/****************************************************************************************** 
 *	Chili DirectX Framework Version 16.07.20											  *	
 *	Game.cpp																			  *
 *	Copyright 2016 PlanetChili.net <http://www.planetchili.net>							  *
 *																						  *
 *	This file is part of The Chili DirectX Framework.									  *
 *																						  *
 *	The Chili DirectX Framework is free software: you can redistribute it and/or modify	  *
 *	it under the terms of the GNU General Public License as published by				  *
 *	the Free Software Foundation, either version 3 of the License, or					  *
 *	(at your option) any later version.													  *
 *																						  *
 *	The Chili DirectX Framework is distributed in the hope that it will be useful,		  *
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of						  *
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						  *
 *	GNU General Public License for more details.										  *
 *																						  *
 *	You should have received a copy of the GNU General Public License					  *
 *	along with The Chili DirectX Framework.  If not, see <http://www.gnu.org/licenses/>.  *
 ******************************************************************************************/
#include "MainWindow.h"
#include "Game.h"
#include <random>

Game::Game( MainWindow& wnd )
	:
	wnd( wnd ),
	gfx( wnd )
{
	std::random_device rd;
	std::mt19937 rng( rd() );
	std::uniform_int_distribution<int> xDist( 0,770 );
	std::uniform_int_distribution<int> yDist( 0,570 );
	poo0X = xDist( rng );
	poo0Y = yDist( rng );
	poo1X = xDist( rng );
	poo1Y = yDist( rng );
	poo2X = xDist( rng );
	poo2Y = yDist( rng );
}

void Game::Go()
{
	gfx.BeginFrame();	
	UpdateModel();
	ComposeFrame();
	gfx.EndFrame();
}

void Game::UpdateModel()
{
	if( isStarted )
	{
		if( wnd.kbd.KeyIsPressed( VK_RIGHT ) )
		{
			dudeX += 1;
		}
		if( wnd.kbd.KeyIsPressed( VK_LEFT ) )
		{
			dudeX -= 1;
		}
		if( wnd.kbd.KeyIsPressed( VK_DOWN ) )
		{
			dudeY += 1;
		}
		if( wnd.kbd.KeyIsPressed( VK_UP ) )
		{
			dudeY -= 1;
		}

		dudeX = ClampScreenX( dudeX,dudeWidth );
		dudeY = ClampScreenY( dudeY,dudeHeight );

		poo0X += poo0vx;
		poo0Y += poo0vy;
		poo1X += poo1vx;
		poo1Y += poo1vy;
		poo2X += poo2vx;
		poo2Y += poo2vy;

		{
			const int poo0Xold = poo0X;
			const int poo0Yold = poo0Y;

			poo0X = ClampScreenX( poo0X,pooWidth );
			if( poo0X != poo0Xold )
			{
				poo0vx = -poo0vx;
			}
			poo0Y = ClampScreenY( poo0Y,pooHeight );
			if( poo0Y != poo0Yold )
			{
				poo0vy = -poo0vy;
			}
		}
		{
			const int poo1Xold = poo1X;
			const int poo1Yold = poo1Y;

			poo1X = ClampScreenX( poo1X,pooWidth );
			if( poo1X != poo1Xold )
			{
				poo1vx = -poo1vx;
			}
			poo1Y = ClampScreenY( poo1Y,pooHeight );
			if( poo1Y != poo1Yold )
			{
				poo1vy = -poo1vy;
			}
		}
		{
			const int poo2Xold = poo2X;
			const int poo2Yold = poo2Y;

			poo2X = ClampScreenX( poo2X,pooWidth );
			if( poo2X != poo2Xold )
			{
				poo2vx = -poo2vx;
			}
			poo2Y = ClampScreenY( poo2Y,pooHeight );
			if( poo2Y != poo2Yold )
			{
				poo2vy = -poo2vy;
			}
		}

		if( IsColliding( dudeX,dudeY,dudeWidth,dudeHeight,poo0X,poo0Y,pooWidth,pooHeight ) )
		{
			poo0IsEaten = true;
		}
		if( IsColliding( dudeX,dudeY,dudeWidth,dudeHeight,poo1X,poo1Y,pooWidth,pooHeight ) )
		{
			poo1IsEaten = true;
		}
		if( IsColliding( dudeX,dudeY,dudeWidth,dudeHeight,poo2X,poo2Y,pooWidth,pooHeight ) )
		{
			poo2IsEaten = true;
		}
	}
	else
	{
		if( wnd.kbd.KeyIsPressed( VK_RETURN ) )
		{
			isStarted = true;
		}
	}
}

void Game::DrawFace( int x,int y )
{
	gfx.PutPixel( 7 + x,0 + y,0,0,0 );
	gfx.PutPixel( 8 + x,0 + y,0,0,0 );
	gfx.PutPixel( 9 + x,0 + y,0,0,0 );
	gfx.PutPixel( 10 + x,0 + y,0,0,0 );
	gfx.PutPixel( 11 + x,0 + y,0,0,0 );
	gfx.PutPixel( 12 + x,0 + y,0,0,0 );
	gfx.PutPixel( 5 + x,1 + y,0,0,0 );
	gfx.PutPixel( 6 + x,1 + y,0,0,0 );
	gfx.PutPixel( 7 + x,1 + y,254,221,88 );
	gfx.PutPixel( 8 + x,1 + y,254,221,88 );
	gfx.PutPixel( 9 + x,1 + y,254,221,88 );
	gfx.PutPixel( 10 + x,1 + y,254,221,88 );
	gfx.PutPixel( 11 + x,1 + y,254,221,88 );
	gfx.PutPixel( 12 + x,1 + y,254,221,88 );
	gfx.PutPixel( 13 + x,1 + y,0,0,0 );
	gfx.PutPixel( 14 + x,1 + y,0,0,0 );
	gfx.PutPixel( 3 + x,2 + y,0,0,0 );
	gfx.PutPixel( 4 + x,2 + y,0,0,0 );
	gfx.PutPixel( 5 + x,2 + y,254,221,88 );
	gfx.PutPixel( 6 + x,2 + y,254,221,88 );
	gfx.PutPixel( 7 + x,2 + y,254,221,88 );
	gfx.PutPixel( 8 + x,2 + y,254,221,88 );
	gfx.PutPixel( 9 + x,2 + y,254,221,88 );
	gfx.PutPixel( 10 + x,2 + y,254,221,88 );
	gfx.PutPixel( 11 + x,2 + y,254,221,88 );
	gfx.PutPixel( 12 + x,2 + y,254,221,88 );
	gfx.PutPixel( 13 + x,2 + y,254,221,88 );
	gfx.PutPixel( 14 + x,2 + y,254,221,88 );
	gfx.PutPixel( 15 + x,2 + y,0,0,0 );
	gfx.PutPixel( 16 + x,2 + y,0,0,0 );
	gfx.PutPixel( 2 + x,3 + y,0,0,0 );
	gfx.PutPixel( 3 + x,3 + y,254,221,88 );
	gfx.PutPixel( 4 + x,3 + y,254,221,88 );
	gfx.PutPixel( 5 + x,3 + y,254,221,88 );
	gfx.PutPixel( 6 + x,3 + y,254,221,88 );
	gfx.PutPixel( 7 + x,3 + y,254,221,88 );
	gfx.PutPixel( 8 + x,3 + y,254,221,88 );
	gfx.PutPixel( 9 + x,3 + y,254,221,88 );
	gfx.PutPixel( 10 + x,3 + y,254,221,88 );
	gfx.PutPixel( 11 + x,3 + y,254,221,88 );
	gfx.PutPixel( 12 + x,3 + y,254,221,88 );
	gfx.PutPixel( 13 + x,3 + y,254,221,88 );
	gfx.PutPixel( 14 + x,3 + y,254,221,88 );
	gfx.PutPixel( 15 + x,3 + y,254,221,88 );
	gfx.PutPixel( 16 + x,3 + y,254,221,88 );
	gfx.PutPixel( 17 + x,3 + y,0,0,0 );
	gfx.PutPixel( 2 + x,4 + y,0,0,0 );
	gfx.PutPixel( 3 + x,4 + y,254,221,88 );
	gfx.PutPixel( 4 + x,4 + y,254,221,88 );
	gfx.PutPixel( 5 + x,4 + y,254,221,88 );
	gfx.PutPixel( 6 + x,4 + y,254,221,88 );
	gfx.PutPixel( 7 + x,4 + y,254,221,88 );
	gfx.PutPixel( 8 + x,4 + y,254,221,88 );
	gfx.PutPixel( 9 + x,4 + y,254,221,88 );
	gfx.PutPixel( 10 + x,4 + y,254,221,88 );
	gfx.PutPixel( 11 + x,4 + y,254,221,88 );
	gfx.PutPixel( 12 + x,4 + y,254,221,88 );
	gfx.PutPixel( 13 + x,4 + y,254,221,88 );
	gfx.PutPixel( 14 + x,4 + y,254,221,88 );
	gfx.PutPixel( 15 + x,4 + y,254,221,88 );
	gfx.PutPixel( 16 + x,4 + y,254,221,88 );
	gfx.PutPixel( 17 + x,4 + y,0,0,0 );
	gfx.PutPixel( 1 + x,5 + y,0,0,0 );
	gfx.PutPixel( 2 + x,5 + y,254,221,88 );
	gfx.PutPixel( 3 + x,5 + y,0,0,0 );
	gfx.PutPixel( 4 + x,5 + y,0,0,0 );
	gfx.PutPixel( 5 + x,5 + y,254,221,88 );
	gfx.PutPixel( 6 + x,5 + y,254,221,88 );
	gfx.PutPixel( 7 + x,5 + y,254,221,88 );
	gfx.PutPixel( 8 + x,5 + y,254,221,88 );
	gfx.PutPixel( 9 + x,5 + y,254,221,88 );
	gfx.PutPixel( 10 + x,5 + y,254,221,88 );
	gfx.PutPixel( 11 + x,5 + y,0,0,0 );
	gfx.PutPixel( 12 + x,5 + y,0,0,0 );
	gfx.PutPixel( 13 + x,5 + y,0,0,0 );
	gfx.PutPixel( 14 + x,5 + y,0,0,0 );
	gfx.PutPixel( 15 + x,5 + y,254,221,88 );
	gfx.PutPixel( 16 + x,5 + y,254,221,88 );
	gfx.PutPixel( 17 + x,5 + y,254,221,88 );
	gfx.PutPixel( 18 + x,5 + y,0,0,0 );
	gfx.PutPixel( 1 + x,6 + y,0,0,0 );
	gfx.PutPixel( 2 + x,6 + y,0,0,0 );
	gfx.PutPixel( 3 + x,6 + y,255,255,255 );
	gfx.PutPixel( 4 + x,6 + y,0,0,0 );
	gfx.PutPixel( 5 + x,6 + y,0,0,0 );
	gfx.PutPixel( 6 + x,6 + y,254,221,88 );
	gfx.PutPixel( 7 + x,6 + y,254,221,88 );
	gfx.PutPixel( 8 + x,6 + y,254,221,88 );
	gfx.PutPixel( 9 + x,6 + y,254,221,88 );
	gfx.PutPixel( 10 + x,6 + y,0,0,0 );
	gfx.PutPixel( 11 + x,6 + y,255,255,255 );
	gfx.PutPixel( 12 + x,6 + y,255,255,255 );
	gfx.PutPixel( 13 + x,6 + y,0,0,0 );
	gfx.PutPixel( 14 + x,6 + y,0,0,0 );
	gfx.PutPixel( 15 + x,6 + y,0,0,0 );
	gfx.PutPixel( 16 + x,6 + y,254,221,88 );
	gfx.PutPixel( 17 + x,6 + y,254,221,88 );
	gfx.PutPixel( 18 + x,6 + y,0,0,0 );
	gfx.PutPixel( 0 + x,7 + y,0,0,0 );
	gfx.PutPixel( 1 + x,7 + y,0,0,0 );
	gfx.PutPixel( 2 + x,7 + y,255,255,255 );
	gfx.PutPixel( 3 + x,7 + y,255,255,255 );
	gfx.PutPixel( 4 + x,7 + y,0,0,0 );
	gfx.PutPixel( 5 + x,7 + y,0,0,0 );
	gfx.PutPixel( 6 + x,7 + y,254,221,88 );
	gfx.PutPixel( 7 + x,7 + y,254,221,88 );
	gfx.PutPixel( 8 + x,7 + y,254,221,88 );
	gfx.PutPixel( 9 + x,7 + y,254,221,88 );
	gfx.PutPixel( 10 + x,7 + y,0,0,0 );
	gfx.PutPixel( 11 + x,7 + y,255,255,255 );
	gfx.PutPixel( 12 + x,7 + y,255,255,255 );
	gfx.PutPixel( 13 + x,7 + y,0,0,0 );
	gfx.PutPixel( 14 + x,7 + y,0,0,0 );
	gfx.PutPixel( 15 + x,7 + y,0,0,0 );
	gfx.PutPixel( 16 + x,7 + y,254,221,88 );
	gfx.PutPixel( 17 + x,7 + y,254,221,88 );
	gfx.PutPixel( 18 + x,7 + y,254,221,88 );
	gfx.PutPixel( 19 + x,7 + y,0,0,0 );
	gfx.PutPixel( 0 + x,8 + y,0,0,0 );
	gfx.PutPixel( 1 + x,8 + y,0,0,0 );
	gfx.PutPixel( 2 + x,8 + y,255,255,255 );
	gfx.PutPixel( 3 + x,8 + y,255,255,255 );
	gfx.PutPixel( 4 + x,8 + y,255,255,255 );
	gfx.PutPixel( 5 + x,8 + y,0,0,0 );
	gfx.PutPixel( 6 + x,8 + y,254,221,88 );
	gfx.PutPixel( 7 + x,8 + y,254,221,88 );
	gfx.PutPixel( 8 + x,8 + y,254,221,88 );
	gfx.PutPixel( 9 + x,8 + y,254,221,88 );
	gfx.PutPixel( 10 + x,8 + y,0,0,0 );
	gfx.PutPixel( 11 + x,8 + y,255,255,255 );
	gfx.PutPixel( 12 + x,8 + y,255,255,255 );
	gfx.PutPixel( 13 + x,8 + y,255,255,255 );
	gfx.PutPixel( 14 + x,8 + y,255,255,255 );
	gfx.PutPixel( 15 + x,8 + y,0,0,0 );
	gfx.PutPixel( 16 + x,8 + y,254,221,88 );
	gfx.PutPixel( 17 + x,8 + y,254,221,88 );
	gfx.PutPixel( 18 + x,8 + y,254,221,88 );
	gfx.PutPixel( 19 + x,8 + y,0,0,0 );
	gfx.PutPixel( 0 + x,9 + y,0,0,0 );
	gfx.PutPixel( 1 + x,9 + y,254,221,88 );
	gfx.PutPixel( 2 + x,9 + y,0,0,0 );
	gfx.PutPixel( 3 + x,9 + y,0,0,0 );
	gfx.PutPixel( 4 + x,9 + y,0,0,0 );
	gfx.PutPixel( 5 + x,9 + y,0,0,0 );
	gfx.PutPixel( 6 + x,9 + y,254,221,88 );
	gfx.PutPixel( 7 + x,9 + y,254,221,88 );
	gfx.PutPixel( 8 + x,9 + y,254,221,88 );
	gfx.PutPixel( 9 + x,9 + y,254,221,88 );
	gfx.PutPixel( 10 + x,9 + y,254,221,88 );
	gfx.PutPixel( 11 + x,9 + y,0,0,0 );
	gfx.PutPixel( 12 + x,9 + y,0,0,0 );
	gfx.PutPixel( 13 + x,9 + y,0,0,0 );
	gfx.PutPixel( 14 + x,9 + y,0,0,0 );
	gfx.PutPixel( 15 + x,9 + y,254,221,88 );
	gfx.PutPixel( 16 + x,9 + y,254,221,88 );
	gfx.PutPixel( 17 + x,9 + y,254,221,88 );
	gfx.PutPixel( 18 + x,9 + y,254,221,88 );
	gfx.PutPixel( 19 + x,9 + y,0,0,0 );
	gfx.PutPixel( 0 + x,10 + y,0,0,0 );
	gfx.PutPixel( 1 + x,10 + y,254,221,88 );
	gfx.PutPixel( 2 + x,10 + y,254,221,88 );
	gfx.PutPixel( 3 + x,10 + y,254,221,88 );
	gfx.PutPixel( 4 + x,10 + y,254,221,88 );
	gfx.PutPixel( 5 + x,10 + y,254,221,88 );
	gfx.PutPixel( 6 + x,10 + y,254,221,88 );
	gfx.PutPixel( 7 + x,10 + y,254,221,88 );
	gfx.PutPixel( 8 + x,10 + y,254,221,88 );
	gfx.PutPixel( 9 + x,10 + y,254,221,88 );
	gfx.PutPixel( 10 + x,10 + y,254,221,88 );
	gfx.PutPixel( 11 + x,10 + y,254,221,88 );
	gfx.PutPixel( 12 + x,10 + y,254,221,88 );
	gfx.PutPixel( 13 + x,10 + y,254,221,88 );
	gfx.PutPixel( 14 + x,10 + y,254,221,88 );
	gfx.PutPixel( 15 + x,10 + y,254,221,88 );
	gfx.PutPixel( 16 + x,10 + y,254,221,88 );
	gfx.PutPixel( 17 + x,10 + y,254,221,88 );
	gfx.PutPixel( 18 + x,10 + y,254,221,88 );
	gfx.PutPixel( 19 + x,10 + y,0,0,0 );
	gfx.PutPixel( 0 + x,11 + y,0,0,0 );
	gfx.PutPixel( 1 + x,11 + y,254,221,88 );
	gfx.PutPixel( 2 + x,11 + y,254,221,88 );
	gfx.PutPixel( 3 + x,11 + y,254,221,88 );
	gfx.PutPixel( 4 + x,11 + y,254,221,88 );
	gfx.PutPixel( 5 + x,11 + y,254,221,88 );
	gfx.PutPixel( 6 + x,11 + y,254,221,88 );
	gfx.PutPixel( 7 + x,11 + y,20,14,18 );
	gfx.PutPixel( 8 + x,11 + y,18,11,14 );
	gfx.PutPixel( 9 + x,11 + y,18,12,14 );
	gfx.PutPixel( 10 + x,11 + y,18,12,14 );
	gfx.PutPixel( 11 + x,11 + y,21,13,16 );
	gfx.PutPixel( 12 + x,11 + y,24,11,15 );
	gfx.PutPixel( 13 + x,11 + y,0,0,0 );
	gfx.PutPixel( 14 + x,11 + y,254,221,88 );
	gfx.PutPixel( 15 + x,11 + y,254,221,88 );
	gfx.PutPixel( 16 + x,11 + y,254,221,88 );
	gfx.PutPixel( 17 + x,11 + y,254,221,88 );
	gfx.PutPixel( 18 + x,11 + y,254,221,88 );
	gfx.PutPixel( 19 + x,11 + y,0,0,0 );
	gfx.PutPixel( 0 + x,12 + y,0,0,0 );
	gfx.PutPixel( 1 + x,12 + y,254,221,88 );
	gfx.PutPixel( 2 + x,12 + y,254,221,88 );
	gfx.PutPixel( 3 + x,12 + y,254,221,88 );
	gfx.PutPixel( 4 + x,12 + y,254,221,88 );
	gfx.PutPixel( 5 + x,12 + y,254,221,88 );
	gfx.PutPixel( 6 + x,12 + y,23,9,23 );
	gfx.PutPixel( 7 + x,12 + y,135,26,68 );
	gfx.PutPixel( 8 + x,12 + y,135,26,68 );
	gfx.PutPixel( 9 + x,12 + y,135,26,68 );
	gfx.PutPixel( 10 + x,12 + y,135,26,68 );
	gfx.PutPixel( 11 + x,12 + y,135,26,68 );
	gfx.PutPixel( 12 + x,12 + y,135,26,68 );
	gfx.PutPixel( 13 + x,12 + y,135,26,68 );
	gfx.PutPixel( 14 + x,12 + y,0,0,0 );
	gfx.PutPixel( 15 + x,12 + y,254,221,88 );
	gfx.PutPixel( 16 + x,12 + y,254,221,88 );
	gfx.PutPixel( 17 + x,12 + y,254,221,88 );
	gfx.PutPixel( 18 + x,12 + y,254,221,88 );
	gfx.PutPixel( 19 + x,12 + y,0,0,0 );
	gfx.PutPixel( 1 + x,13 + y,0,0,0 );
	gfx.PutPixel( 2 + x,13 + y,254,221,88 );
	gfx.PutPixel( 3 + x,13 + y,254,221,88 );
	gfx.PutPixel( 4 + x,13 + y,254,221,88 );
	gfx.PutPixel( 5 + x,13 + y,0,0,0 );
	gfx.PutPixel( 6 + x,13 + y,135,26,68 );
	gfx.PutPixel( 7 + x,13 + y,135,26,68 );
	gfx.PutPixel( 8 + x,13 + y,135,26,68 );
	gfx.PutPixel( 9 + x,13 + y,135,26,68 );
	gfx.PutPixel( 10 + x,13 + y,135,26,68 );
	gfx.PutPixel( 11 + x,13 + y,135,26,68 );
	gfx.PutPixel( 12 + x,13 + y,135,26,68 );
	gfx.PutPixel( 13 + x,13 + y,135,26,68 );
	gfx.PutPixel( 14 + x,13 + y,135,26,68 );
	gfx.PutPixel( 15 + x,13 + y,0,0,0 );
	gfx.PutPixel( 16 + x,13 + y,254,221,88 );
	gfx.PutPixel( 17 + x,13 + y,254,221,88 );
	gfx.PutPixel( 18 + x,13 + y,0,0,0 );
	gfx.PutPixel( 1 + x,14 + y,0,0,0 );
	gfx.PutPixel( 2 + x,14 + y,254,221,88 );
	gfx.PutPixel( 3 + x,14 + y,254,221,88 );
	gfx.PutPixel( 4 + x,14 + y,0,0,0 );
	gfx.PutPixel( 5 + x,14 + y,135,26,68 );
	gfx.PutPixel( 6 + x,14 + y,135,26,68 );
	gfx.PutPixel( 7 + x,14 + y,135,26,68 );
	gfx.PutPixel( 8 + x,14 + y,135,26,68 );
	gfx.PutPixel( 9 + x,14 + y,251,192,224 );
	gfx.PutPixel( 10 + x,14 + y,251,192,224 );
	gfx.PutPixel( 11 + x,14 + y,251,192,224 );
	gfx.PutPixel( 12 + x,14 + y,251,192,224 );
	gfx.PutPixel( 13 + x,14 + y,135,26,68 );
	gfx.PutPixel( 14 + x,14 + y,135,26,68 );
	gfx.PutPixel( 15 + x,14 + y,0,0,0 );
	gfx.PutPixel( 16 + x,14 + y,254,221,88 );
	gfx.PutPixel( 17 + x,14 + y,254,221,88 );
	gfx.PutPixel( 18 + x,14 + y,0,0,0 );
	gfx.PutPixel( 2 + x,15 + y,0,0,0 );
	gfx.PutPixel( 3 + x,15 + y,254,221,88 );
	gfx.PutPixel( 4 + x,15 + y,0,0,0 );
	gfx.PutPixel( 5 + x,15 + y,135,26,68 );
	gfx.PutPixel( 6 + x,15 + y,135,26,68 );
	gfx.PutPixel( 7 + x,15 + y,135,26,68 );
	gfx.PutPixel( 8 + x,15 + y,251,192,224 );
	gfx.PutPixel( 9 + x,15 + y,251,192,224 );
	gfx.PutPixel( 10 + x,15 + y,251,192,224 );
	gfx.PutPixel( 11 + x,15 + y,251,192,224 );
	gfx.PutPixel( 12 + x,15 + y,251,192,224 );
	gfx.PutPixel( 13 + x,15 + y,251,192,224 );
	gfx.PutPixel( 14 + x,15 + y,135,26,68 );
	gfx.PutPixel( 15 + x,15 + y,0,0,0 );
	gfx.PutPixel( 16 + x,15 + y,254,221,88 );
	gfx.PutPixel( 17 + x,15 + y,0,0,0 );
	gfx.PutPixel( 2 + x,16 + y,0,0,0 );
	gfx.PutPixel( 3 + x,16 + y,254,221,88 );
	gfx.PutPixel( 4 + x,16 + y,0,0,0 );
	gfx.PutPixel( 5 + x,16 + y,135,26,68 );
	gfx.PutPixel( 6 + x,16 + y,135,26,68 );
	gfx.PutPixel( 7 + x,16 + y,135,26,68 );
	gfx.PutPixel( 8 + x,16 + y,251,192,224 );
	gfx.PutPixel( 9 + x,16 + y,251,192,224 );
	gfx.PutPixel( 10 + x,16 + y,251,192,224 );
	gfx.PutPixel( 11 + x,16 + y,251,192,224 );
	gfx.PutPixel( 12 + x,16 + y,251,192,224 );
	gfx.PutPixel( 13 + x,16 + y,251,192,224 );
	gfx.PutPixel( 14 + x,16 + y,135,26,68 );
	gfx.PutPixel( 15 + x,16 + y,0,0,0 );
	gfx.PutPixel( 16 + x,16 + y,254,221,88 );
	gfx.PutPixel( 17 + x,16 + y,0,0,0 );
	gfx.PutPixel( 3 + x,17 + y,0,0,0 );
	gfx.PutPixel( 4 + x,17 + y,0,0,0 );
	gfx.PutPixel( 5 + x,17 + y,0,0,0 );
	gfx.PutPixel( 6 + x,17 + y,0,0,0 );
	gfx.PutPixel( 7 + x,17 + y,0,0,0 );
	gfx.PutPixel( 8 + x,17 + y,0,0,0 );
	gfx.PutPixel( 9 + x,17 + y,0,0,0 );
	gfx.PutPixel( 10 + x,17 + y,0,0,0 );
	gfx.PutPixel( 11 + x,17 + y,0,0,0 );
	gfx.PutPixel( 12 + x,17 + y,0,0,0 );
	gfx.PutPixel( 13 + x,17 + y,0,0,0 );
	gfx.PutPixel( 14 + x,17 + y,0,0,0 );
	gfx.PutPixel( 15 + x,17 + y,0,0,0 );
	gfx.PutPixel( 16 + x,17 + y,0,0,0 );
	gfx.PutPixel( 5 + x,18 + y,0,0,0 );
	gfx.PutPixel( 6 + x,18 + y,0,0,0 );
	gfx.PutPixel( 7 + x,18 + y,254,221,88 );
	gfx.PutPixel( 8 + x,18 + y,254,221,88 );
	gfx.PutPixel( 9 + x,18 + y,254,221,88 );
	gfx.PutPixel( 10 + x,18 + y,254,221,88 );
	gfx.PutPixel( 11 + x,18 + y,254,221,88 );
	gfx.PutPixel( 12 + x,18 + y,254,221,88 );
	gfx.PutPixel( 13 + x,18 + y,0,0,0 );
	gfx.PutPixel( 14 + x,18 + y,0,0,0 );
	gfx.PutPixel( 7 + x,19 + y,0,0,0 );
	gfx.PutPixel( 8 + x,19 + y,0,0,0 );
	gfx.PutPixel( 9 + x,19 + y,0,0,0 );
	gfx.PutPixel( 10 + x,19 + y,0,0,0 );
	gfx.PutPixel( 11 + x,19 + y,0,0,0 );
	gfx.PutPixel( 12 + x,19 + y,0,0,0 );
}

void Game::DrawPoo( int x,int y )
{
	gfx.PutPixel( 14 + x,0 + y,138,77,0 );
	gfx.PutPixel( 7 + x,1 + y,138,77,0 );
	gfx.PutPixel( 13 + x,1 + y,138,77,0 );
	gfx.PutPixel( 20 + x,1 + y,138,77,0 );
	gfx.PutPixel( 6 + x,2 + y,138,77,0 );
	gfx.PutPixel( 13 + x,2 + y,138,77,0 );
	gfx.PutPixel( 20 + x,2 + y,138,77,0 );
	gfx.PutPixel( 6 + x,3 + y,138,77,0 );
	gfx.PutPixel( 6 + x,4 + y,138,77,0 );
	gfx.PutPixel( 14 + x,4 + y,138,77,0 );
	gfx.PutPixel( 21 + x,4 + y,138,77,0 );
	gfx.PutPixel( 7 + x,5 + y,138,77,0 );
	gfx.PutPixel( 13 + x,5 + y,138,77,0 );
	gfx.PutPixel( 21 + x,5 + y,138,77,0 );
	gfx.PutPixel( 7 + x,6 + y,138,77,0 );
	gfx.PutPixel( 20 + x,6 + y,138,77,0 );
	gfx.PutPixel( 6 + x,7 + y,138,77,0 );
	gfx.PutPixel( 14 + x,7 + y,51,28,0 );
	gfx.PutPixel( 15 + x,7 + y,51,28,0 );
	gfx.PutPixel( 20 + x,7 + y,138,77,0 );
	gfx.PutPixel( 12 + x,8 + y,51,28,0 );
	gfx.PutPixel( 13 + x,8 + y,51,28,0 );
	gfx.PutPixel( 14 + x,8 + y,51,28,0 );
	gfx.PutPixel( 7 + x,9 + y,138,77,0 );
	gfx.PutPixel( 11 + x,9 + y,51,28,0 );
	gfx.PutPixel( 12 + x,9 + y,102,57,0 );
	gfx.PutPixel( 13 + x,9 + y,138,77,0 );
	gfx.PutPixel( 14 + x,9 + y,138,77,0 );
	gfx.PutPixel( 15 + x,9 + y,51,28,0 );
	gfx.PutPixel( 21 + x,9 + y,138,77,0 );
	gfx.PutPixel( 10 + x,10 + y,51,28,0 );
	gfx.PutPixel( 11 + x,10 + y,51,28,0 );
	gfx.PutPixel( 12 + x,10 + y,102,57,0 );
	gfx.PutPixel( 13 + x,10 + y,138,77,0 );
	gfx.PutPixel( 14 + x,10 + y,138,77,0 );
	gfx.PutPixel( 15 + x,10 + y,51,28,0 );
	gfx.PutPixel( 20 + x,10 + y,138,77,0 );
	gfx.PutPixel( 9 + x,11 + y,51,28,0 );
	gfx.PutPixel( 10 + x,11 + y,138,77,0 );
	gfx.PutPixel( 11 + x,11 + y,138,77,0 );
	gfx.PutPixel( 12 + x,11 + y,51,28,0 );
	gfx.PutPixel( 13 + x,11 + y,51,28,0 );
	gfx.PutPixel( 14 + x,11 + y,51,28,0 );
	gfx.PutPixel( 15 + x,11 + y,51,28,0 );
	gfx.PutPixel( 16 + x,11 + y,51,28,0 );
	gfx.PutPixel( 9 + x,12 + y,51,28,0 );
	gfx.PutPixel( 10 + x,12 + y,138,77,0 );
	gfx.PutPixel( 11 + x,12 + y,138,77,0 );
	gfx.PutPixel( 12 + x,12 + y,111,62,0 );
	gfx.PutPixel( 13 + x,12 + y,102,57,0 );
	gfx.PutPixel( 14 + x,12 + y,102,57,0 );
	gfx.PutPixel( 15 + x,12 + y,102,57,0 );
	gfx.PutPixel( 16 + x,12 + y,51,28,0 );
	gfx.PutPixel( 9 + x,13 + y,51,28,0 );
	gfx.PutPixel( 10 + x,13 + y,109,61,0 );
	gfx.PutPixel( 11 + x,13 + y,138,77,0 );
	gfx.PutPixel( 12 + x,13 + y,138,77,0 );
	gfx.PutPixel( 13 + x,13 + y,138,77,0 );
	gfx.PutPixel( 14 + x,13 + y,138,77,0 );
	gfx.PutPixel( 15 + x,13 + y,138,77,0 );
	gfx.PutPixel( 16 + x,13 + y,51,28,0 );
	gfx.PutPixel( 5 + x,14 + y,51,28,0 );
	gfx.PutPixel( 7 + x,14 + y,51,28,0 );
	gfx.PutPixel( 8 + x,14 + y,51,28,0 );
	gfx.PutPixel( 9 + x,14 + y,51,28,0 );
	gfx.PutPixel( 10 + x,14 + y,51,28,0 );
	gfx.PutPixel( 11 + x,14 + y,138,77,0 );
	gfx.PutPixel( 12 + x,14 + y,138,77,0 );
	gfx.PutPixel( 13 + x,14 + y,138,77,0 );
	gfx.PutPixel( 14 + x,14 + y,138,77,0 );
	gfx.PutPixel( 15 + x,14 + y,138,77,0 );
	gfx.PutPixel( 16 + x,14 + y,51,28,0 );
	gfx.PutPixel( 4 + x,15 + y,51,28,0 );
	gfx.PutPixel( 5 + x,15 + y,138,77,0 );
	gfx.PutPixel( 6 + x,15 + y,51,28,0 );
	gfx.PutPixel( 7 + x,15 + y,116,65,0 );
	gfx.PutPixel( 8 + x,15 + y,138,77,0 );
	gfx.PutPixel( 9 + x,15 + y,138,77,0 );
	gfx.PutPixel( 10 + x,15 + y,138,77,0 );
	gfx.PutPixel( 11 + x,15 + y,51,28,0 );
	gfx.PutPixel( 12 + x,15 + y,51,28,0 );
	gfx.PutPixel( 13 + x,15 + y,51,28,0 );
	gfx.PutPixel( 14 + x,15 + y,51,28,0 );
	gfx.PutPixel( 15 + x,15 + y,51,28,0 );
	gfx.PutPixel( 16 + x,15 + y,51,28,0 );
	gfx.PutPixel( 17 + x,15 + y,51,28,0 );
	gfx.PutPixel( 18 + x,15 + y,51,28,0 );
	gfx.PutPixel( 1 + x,16 + y,51,28,0 );
	gfx.PutPixel( 2 + x,16 + y,51,28,0 );
	gfx.PutPixel( 3 + x,16 + y,51,28,0 );
	gfx.PutPixel( 4 + x,16 + y,51,28,0 );
	gfx.PutPixel( 5 + x,16 + y,138,77,0 );
	gfx.PutPixel( 6 + x,16 + y,51,28,0 );
	gfx.PutPixel( 7 + x,16 + y,116,65,0 );
	gfx.PutPixel( 8 + x,16 + y,138,77,0 );
	gfx.PutPixel( 9 + x,16 + y,138,77,0 );
	gfx.PutPixel( 10 + x,16 + y,138,77,0 );
	gfx.PutPixel( 11 + x,16 + y,138,77,0 );
	gfx.PutPixel( 12 + x,16 + y,138,77,0 );
	gfx.PutPixel( 13 + x,16 + y,109,61,0 );
	gfx.PutPixel( 14 + x,16 + y,51,28,0 );
	gfx.PutPixel( 15 + x,16 + y,138,77,0 );
	gfx.PutPixel( 16 + x,16 + y,138,77,0 );
	gfx.PutPixel( 17 + x,16 + y,138,77,0 );
	gfx.PutPixel( 18 + x,16 + y,123,69,0 );
	gfx.PutPixel( 19 + x,16 + y,51,28,0 );
	gfx.PutPixel( 0 + x,17 + y,51,28,0 );
	gfx.PutPixel( 1 + x,17 + y,87,49,0 );
	gfx.PutPixel( 2 + x,17 + y,87,49,0 );
	gfx.PutPixel( 3 + x,17 + y,87,49,0 );
	gfx.PutPixel( 4 + x,17 + y,87,49,0 );
	gfx.PutPixel( 5 + x,17 + y,51,28,0 );
	gfx.PutPixel( 6 + x,17 + y,51,28,0 );
	gfx.PutPixel( 7 + x,17 + y,43,24,0 );
	gfx.PutPixel( 8 + x,17 + y,51,28,0 );
	gfx.PutPixel( 9 + x,17 + y,51,28,0 );
	gfx.PutPixel( 10 + x,17 + y,51,28,0 );
	gfx.PutPixel( 11 + x,17 + y,51,28,0 );
	gfx.PutPixel( 12 + x,17 + y,51,28,0 );
	gfx.PutPixel( 13 + x,17 + y,40,22,0 );
	gfx.PutPixel( 14 + x,17 + y,51,28,0 );
	gfx.PutPixel( 15 + x,17 + y,138,77,0 );
	gfx.PutPixel( 16 + x,17 + y,138,77,0 );
	gfx.PutPixel( 17 + x,17 + y,138,77,0 );
	gfx.PutPixel( 18 + x,17 + y,123,69,0 );
	gfx.PutPixel( 19 + x,17 + y,51,28,0 );
	gfx.PutPixel( 0 + x,18 + y,51,28,0 );
	gfx.PutPixel( 1 + x,18 + y,138,77,0 );
	gfx.PutPixel( 2 + x,18 + y,138,77,0 );
	gfx.PutPixel( 3 + x,18 + y,138,77,0 );
	gfx.PutPixel( 4 + x,18 + y,138,77,0 );
	gfx.PutPixel( 5 + x,18 + y,51,28,0 );
	gfx.PutPixel( 6 + x,18 + y,51,28,0 );
	gfx.PutPixel( 7 + x,18 + y,51,28,0 );
	gfx.PutPixel( 8 + x,18 + y,51,28,0 );
	gfx.PutPixel( 9 + x,18 + y,51,28,0 );
	gfx.PutPixel( 10 + x,18 + y,51,28,0 );
	gfx.PutPixel( 11 + x,18 + y,51,28,0 );
	gfx.PutPixel( 12 + x,18 + y,51,28,0 );
	gfx.PutPixel( 13 + x,18 + y,51,28,0 );
	gfx.PutPixel( 14 + x,18 + y,51,28,0 );
	gfx.PutPixel( 15 + x,18 + y,138,77,0 );
	gfx.PutPixel( 16 + x,18 + y,138,77,0 );
	gfx.PutPixel( 17 + x,18 + y,138,77,0 );
	gfx.PutPixel( 18 + x,18 + y,123,69,0 );
	gfx.PutPixel( 19 + x,18 + y,51,28,0 );
	gfx.PutPixel( 20 + x,18 + y,51,28,0 );
	gfx.PutPixel( 21 + x,18 + y,51,28,0 );
	gfx.PutPixel( 22 + x,18 + y,51,28,0 );
	gfx.PutPixel( 0 + x,19 + y,51,28,0 );
	gfx.PutPixel( 1 + x,19 + y,138,77,0 );
	gfx.PutPixel( 2 + x,19 + y,138,77,0 );
	gfx.PutPixel( 3 + x,19 + y,138,77,0 );
	gfx.PutPixel( 4 + x,19 + y,138,77,0 );
	gfx.PutPixel( 5 + x,19 + y,51,28,0 );
	gfx.PutPixel( 6 + x,19 + y,138,77,0 );
	gfx.PutPixel( 7 + x,19 + y,138,77,0 );
	gfx.PutPixel( 8 + x,19 + y,138,77,0 );
	gfx.PutPixel( 9 + x,19 + y,138,77,0 );
	gfx.PutPixel( 10 + x,19 + y,138,77,0 );
	gfx.PutPixel( 11 + x,19 + y,138,77,0 );
	gfx.PutPixel( 12 + x,19 + y,138,77,0 );
	gfx.PutPixel( 13 + x,19 + y,138,77,0 );
	gfx.PutPixel( 14 + x,19 + y,138,77,0 );
	gfx.PutPixel( 15 + x,19 + y,138,77,0 );
	gfx.PutPixel( 16 + x,19 + y,138,77,0 );
	gfx.PutPixel( 17 + x,19 + y,138,77,0 );
	gfx.PutPixel( 18 + x,19 + y,123,69,0 );
	gfx.PutPixel( 19 + x,19 + y,51,28,0 );
	gfx.PutPixel( 20 + x,19 + y,138,77,0 );
	gfx.PutPixel( 21 + x,19 + y,138,77,0 );
	gfx.PutPixel( 22 + x,19 + y,65,36,0 );
	gfx.PutPixel( 23 + x,19 + y,51,28,0 );
	gfx.PutPixel( 1 + x,20 + y,51,28,0 );
	gfx.PutPixel( 2 + x,20 + y,51,28,0 );
	gfx.PutPixel( 3 + x,20 + y,51,28,0 );
	gfx.PutPixel( 4 + x,20 + y,51,28,0 );
	gfx.PutPixel( 5 + x,20 + y,51,28,0 );
	gfx.PutPixel( 6 + x,20 + y,138,77,0 );
	gfx.PutPixel( 7 + x,20 + y,138,77,0 );
	gfx.PutPixel( 8 + x,20 + y,138,77,0 );
	gfx.PutPixel( 9 + x,20 + y,138,77,0 );
	gfx.PutPixel( 10 + x,20 + y,138,77,0 );
	gfx.PutPixel( 11 + x,20 + y,138,77,0 );
	gfx.PutPixel( 12 + x,20 + y,138,77,0 );
	gfx.PutPixel( 13 + x,20 + y,138,77,0 );
	gfx.PutPixel( 14 + x,20 + y,138,77,0 );
	gfx.PutPixel( 15 + x,20 + y,138,77,0 );
	gfx.PutPixel( 16 + x,20 + y,138,77,0 );
	gfx.PutPixel( 17 + x,20 + y,138,77,0 );
	gfx.PutPixel( 18 + x,20 + y,123,69,0 );
	gfx.PutPixel( 19 + x,20 + y,51,28,0 );
	gfx.PutPixel( 20 + x,20 + y,138,77,0 );
	gfx.PutPixel( 21 + x,20 + y,138,77,0 );
	gfx.PutPixel( 22 + x,20 + y,65,36,0 );
	gfx.PutPixel( 23 + x,20 + y,51,28,0 );
	gfx.PutPixel( 0 + x,21 + y,51,28,0 );
	gfx.PutPixel( 1 + x,21 + y,138,77,0 );
	gfx.PutPixel( 2 + x,21 + y,138,77,0 );
	gfx.PutPixel( 3 + x,21 + y,138,77,0 );
	gfx.PutPixel( 4 + x,21 + y,138,77,0 );
	gfx.PutPixel( 5 + x,21 + y,138,77,0 );
	gfx.PutPixel( 6 + x,21 + y,51,28,0 );
	gfx.PutPixel( 7 + x,21 + y,51,28,0 );
	gfx.PutPixel( 8 + x,21 + y,51,28,0 );
	gfx.PutPixel( 9 + x,21 + y,51,28,0 );
	gfx.PutPixel( 10 + x,21 + y,51,28,0 );
	gfx.PutPixel( 11 + x,21 + y,51,28,0 );
	gfx.PutPixel( 12 + x,21 + y,51,28,0 );
	gfx.PutPixel( 13 + x,21 + y,51,28,0 );
	gfx.PutPixel( 14 + x,21 + y,51,28,0 );
	gfx.PutPixel( 15 + x,21 + y,51,28,0 );
	gfx.PutPixel( 16 + x,21 + y,51,28,0 );
	gfx.PutPixel( 17 + x,21 + y,51,28,0 );
	gfx.PutPixel( 18 + x,21 + y,51,28,0 );
	gfx.PutPixel( 20 + x,21 + y,51,28,0 );
	gfx.PutPixel( 21 + x,21 + y,51,28,0 );
	gfx.PutPixel( 22 + x,21 + y,51,28,0 );
	gfx.PutPixel( 0 + x,22 + y,51,28,0 );
	gfx.PutPixel( 1 + x,22 + y,65,36,0 );
	gfx.PutPixel( 2 + x,22 + y,65,36,0 );
	gfx.PutPixel( 3 + x,22 + y,65,36,0 );
	gfx.PutPixel( 4 + x,22 + y,65,36,0 );
	gfx.PutPixel( 5 + x,22 + y,65,36,0 );
	gfx.PutPixel( 6 + x,22 + y,51,28,0 );
	gfx.PutPixel( 1 + x,23 + y,51,28,0 );
	gfx.PutPixel( 2 + x,23 + y,51,28,0 );
	gfx.PutPixel( 3 + x,23 + y,51,28,0 );
	gfx.PutPixel( 4 + x,23 + y,51,28,0 );
	gfx.PutPixel( 5 + x,23 + y,51,28,0 );
	gfx.PutPixel( 6 + x,23 + y,51,28,0 );
}

void Game::DrawGameOver( int x,int y )
{
	gfx.PutPixel( 49 + x,0 + y,0,146,14 );
	gfx.PutPixel( 50 + x,0 + y,0,146,14 );
	gfx.PutPixel( 51 + x,0 + y,0,146,14 );
	gfx.PutPixel( 49 + x,1 + y,0,146,14 );
	gfx.PutPixel( 50 + x,1 + y,0,146,14 );
	gfx.PutPixel( 51 + x,1 + y,0,146,14 );
	gfx.PutPixel( 52 + x,1 + y,0,146,14 );
	gfx.PutPixel( 38 + x,2 + y,0,146,14 );
	gfx.PutPixel( 39 + x,2 + y,0,146,14 );
	gfx.PutPixel( 40 + x,2 + y,0,146,14 );
	gfx.PutPixel( 41 + x,2 + y,0,146,14 );
	gfx.PutPixel( 50 + x,2 + y,0,146,14 );
	gfx.PutPixel( 51 + x,2 + y,0,146,14 );
	gfx.PutPixel( 52 + x,2 + y,0,146,14 );
	gfx.PutPixel( 36 + x,3 + y,0,146,14 );
	gfx.PutPixel( 37 + x,3 + y,0,146,14 );
	gfx.PutPixel( 38 + x,3 + y,0,146,14 );
	gfx.PutPixel( 39 + x,3 + y,0,146,14 );
	gfx.PutPixel( 40 + x,3 + y,0,146,14 );
	gfx.PutPixel( 41 + x,3 + y,0,146,14 );
	gfx.PutPixel( 42 + x,3 + y,0,146,14 );
	gfx.PutPixel( 43 + x,3 + y,0,146,14 );
	gfx.PutPixel( 50 + x,3 + y,0,146,14 );
	gfx.PutPixel( 51 + x,3 + y,0,146,14 );
	gfx.PutPixel( 52 + x,3 + y,0,146,14 );
	gfx.PutPixel( 53 + x,3 + y,0,146,14 );
	gfx.PutPixel( 35 + x,4 + y,0,146,14 );
	gfx.PutPixel( 36 + x,4 + y,0,146,14 );
	gfx.PutPixel( 37 + x,4 + y,0,146,14 );
	gfx.PutPixel( 38 + x,4 + y,0,146,14 );
	gfx.PutPixel( 39 + x,4 + y,0,146,14 );
	gfx.PutPixel( 40 + x,4 + y,0,146,14 );
	gfx.PutPixel( 41 + x,4 + y,0,146,14 );
	gfx.PutPixel( 42 + x,4 + y,0,146,14 );
	gfx.PutPixel( 43 + x,4 + y,0,146,14 );
	gfx.PutPixel( 44 + x,4 + y,0,146,14 );
	gfx.PutPixel( 51 + x,4 + y,0,146,14 );
	gfx.PutPixel( 52 + x,4 + y,0,146,14 );
	gfx.PutPixel( 53 + x,4 + y,0,146,14 );
	gfx.PutPixel( 68 + x,4 + y,0,146,14 );
	gfx.PutPixel( 69 + x,4 + y,0,146,14 );
	gfx.PutPixel( 70 + x,4 + y,0,146,14 );
	gfx.PutPixel( 71 + x,4 + y,0,146,14 );
	gfx.PutPixel( 72 + x,4 + y,0,146,14 );
	gfx.PutPixel( 73 + x,4 + y,0,146,14 );
	gfx.PutPixel( 74 + x,4 + y,0,146,14 );
	gfx.PutPixel( 75 + x,4 + y,0,146,14 );
	gfx.PutPixel( 76 + x,4 + y,0,146,14 );
	gfx.PutPixel( 77 + x,4 + y,0,146,14 );
	gfx.PutPixel( 78 + x,4 + y,0,146,14 );
	gfx.PutPixel( 79 + x,4 + y,0,146,14 );
	gfx.PutPixel( 34 + x,5 + y,0,118,11 );
	gfx.PutPixel( 35 + x,5 + y,0,146,14 );
	gfx.PutPixel( 36 + x,5 + y,0,146,14 );
	gfx.PutPixel( 37 + x,5 + y,0,146,14 );
	gfx.PutPixel( 38 + x,5 + y,0,146,14 );
	gfx.PutPixel( 39 + x,5 + y,0,146,14 );
	gfx.PutPixel( 40 + x,5 + y,0,146,14 );
	gfx.PutPixel( 41 + x,5 + y,0,146,14 );
	gfx.PutPixel( 42 + x,5 + y,0,146,14 );
	gfx.PutPixel( 43 + x,5 + y,0,146,14 );
	gfx.PutPixel( 44 + x,5 + y,0,146,14 );
	gfx.PutPixel( 51 + x,5 + y,0,142,13 );
	gfx.PutPixel( 52 + x,5 + y,0,146,14 );
	gfx.PutPixel( 53 + x,5 + y,0,146,14 );
	gfx.PutPixel( 54 + x,5 + y,0,146,14 );
	gfx.PutPixel( 66 + x,5 + y,0,146,14 );
	gfx.PutPixel( 67 + x,5 + y,0,146,14 );
	gfx.PutPixel( 68 + x,5 + y,0,146,14 );
	gfx.PutPixel( 69 + x,5 + y,0,146,14 );
	gfx.PutPixel( 70 + x,5 + y,0,146,14 );
	gfx.PutPixel( 71 + x,5 + y,0,146,14 );
	gfx.PutPixel( 72 + x,5 + y,0,146,14 );
	gfx.PutPixel( 73 + x,5 + y,0,146,14 );
	gfx.PutPixel( 74 + x,5 + y,0,146,14 );
	gfx.PutPixel( 75 + x,5 + y,0,146,14 );
	gfx.PutPixel( 76 + x,5 + y,0,146,14 );
	gfx.PutPixel( 77 + x,5 + y,0,146,14 );
	gfx.PutPixel( 78 + x,5 + y,0,146,14 );
	gfx.PutPixel( 79 + x,5 + y,0,146,14 );
	gfx.PutPixel( 80 + x,5 + y,0,146,14 );
	gfx.PutPixel( 34 + x,6 + y,0,146,14 );
	gfx.PutPixel( 35 + x,6 + y,0,146,14 );
	gfx.PutPixel( 36 + x,6 + y,0,146,14 );
	gfx.PutPixel( 37 + x,6 + y,0,146,14 );
	gfx.PutPixel( 38 + x,6 + y,0,146,14 );
	gfx.PutPixel( 39 + x,6 + y,0,146,14 );
	gfx.PutPixel( 40 + x,6 + y,0,146,14 );
	gfx.PutPixel( 41 + x,6 + y,0,146,14 );
	gfx.PutPixel( 42 + x,6 + y,0,146,14 );
	gfx.PutPixel( 43 + x,6 + y,0,146,14 );
	gfx.PutPixel( 44 + x,6 + y,0,146,14 );
	gfx.PutPixel( 45 + x,6 + y,0,146,14 );
	gfx.PutPixel( 52 + x,6 + y,0,146,14 );
	gfx.PutPixel( 53 + x,6 + y,0,146,14 );
	gfx.PutPixel( 54 + x,6 + y,0,146,14 );
	gfx.PutPixel( 55 + x,6 + y,0,146,14 );
	gfx.PutPixel( 65 + x,6 + y,0,146,14 );
	gfx.PutPixel( 66 + x,6 + y,0,146,14 );
	gfx.PutPixel( 67 + x,6 + y,0,146,14 );
	gfx.PutPixel( 68 + x,6 + y,0,146,14 );
	gfx.PutPixel( 69 + x,6 + y,0,146,14 );
	gfx.PutPixel( 70 + x,6 + y,0,146,14 );
	gfx.PutPixel( 71 + x,6 + y,0,146,14 );
	gfx.PutPixel( 72 + x,6 + y,0,146,14 );
	gfx.PutPixel( 73 + x,6 + y,0,146,14 );
	gfx.PutPixel( 74 + x,6 + y,0,146,14 );
	gfx.PutPixel( 75 + x,6 + y,0,146,14 );
	gfx.PutPixel( 76 + x,6 + y,0,146,14 );
	gfx.PutPixel( 77 + x,6 + y,0,146,14 );
	gfx.PutPixel( 78 + x,6 + y,0,146,14 );
	gfx.PutPixel( 79 + x,6 + y,0,146,14 );
	gfx.PutPixel( 80 + x,6 + y,0,146,14 );
	gfx.PutPixel( 81 + x,6 + y,0,146,14 );
	gfx.PutPixel( 34 + x,7 + y,0,146,14 );
	gfx.PutPixel( 35 + x,7 + y,0,146,14 );
	gfx.PutPixel( 36 + x,7 + y,0,146,14 );
	gfx.PutPixel( 37 + x,7 + y,0,146,14 );
	gfx.PutPixel( 38 + x,7 + y,0,146,14 );
	gfx.PutPixel( 39 + x,7 + y,0,146,14 );
	gfx.PutPixel( 40 + x,7 + y,0,146,14 );
	gfx.PutPixel( 41 + x,7 + y,0,146,14 );
	gfx.PutPixel( 42 + x,7 + y,0,146,14 );
	gfx.PutPixel( 43 + x,7 + y,0,146,14 );
	gfx.PutPixel( 44 + x,7 + y,0,146,14 );
	gfx.PutPixel( 45 + x,7 + y,0,146,14 );
	gfx.PutPixel( 53 + x,7 + y,0,146,14 );
	gfx.PutPixel( 54 + x,7 + y,0,146,14 );
	gfx.PutPixel( 55 + x,7 + y,0,146,14 );
	gfx.PutPixel( 65 + x,7 + y,0,146,14 );
	gfx.PutPixel( 66 + x,7 + y,0,146,14 );
	gfx.PutPixel( 67 + x,7 + y,0,146,14 );
	gfx.PutPixel( 68 + x,7 + y,0,142,13 );
	gfx.PutPixel( 79 + x,7 + y,0,146,14 );
	gfx.PutPixel( 80 + x,7 + y,0,146,14 );
	gfx.PutPixel( 81 + x,7 + y,0,146,14 );
	gfx.PutPixel( 82 + x,7 + y,0,146,14 );
	gfx.PutPixel( 34 + x,8 + y,0,146,14 );
	gfx.PutPixel( 35 + x,8 + y,0,146,14 );
	gfx.PutPixel( 36 + x,8 + y,0,146,14 );
	gfx.PutPixel( 37 + x,8 + y,0,146,14 );
	gfx.PutPixel( 38 + x,8 + y,0,146,14 );
	gfx.PutPixel( 39 + x,8 + y,0,146,14 );
	gfx.PutPixel( 40 + x,8 + y,0,146,14 );
	gfx.PutPixel( 41 + x,8 + y,0,146,14 );
	gfx.PutPixel( 42 + x,8 + y,0,146,14 );
	gfx.PutPixel( 43 + x,8 + y,0,146,14 );
	gfx.PutPixel( 44 + x,8 + y,0,146,14 );
	gfx.PutPixel( 45 + x,8 + y,0,146,14 );
	gfx.PutPixel( 53 + x,8 + y,0,146,14 );
	gfx.PutPixel( 54 + x,8 + y,0,146,14 );
	gfx.PutPixel( 55 + x,8 + y,0,146,14 );
	gfx.PutPixel( 56 + x,8 + y,0,146,14 );
	gfx.PutPixel( 64 + x,8 + y,0,146,14 );
	gfx.PutPixel( 65 + x,8 + y,0,146,14 );
	gfx.PutPixel( 66 + x,8 + y,0,146,14 );
	gfx.PutPixel( 67 + x,8 + y,0,146,14 );
	gfx.PutPixel( 80 + x,8 + y,0,146,14 );
	gfx.PutPixel( 81 + x,8 + y,0,146,14 );
	gfx.PutPixel( 82 + x,8 + y,0,146,14 );
	gfx.PutPixel( 34 + x,9 + y,0,146,14 );
	gfx.PutPixel( 35 + x,9 + y,0,146,14 );
	gfx.PutPixel( 36 + x,9 + y,0,146,14 );
	gfx.PutPixel( 37 + x,9 + y,0,146,14 );
	gfx.PutPixel( 38 + x,9 + y,0,146,14 );
	gfx.PutPixel( 39 + x,9 + y,0,146,14 );
	gfx.PutPixel( 40 + x,9 + y,0,146,14 );
	gfx.PutPixel( 41 + x,9 + y,0,146,14 );
	gfx.PutPixel( 42 + x,9 + y,0,146,14 );
	gfx.PutPixel( 43 + x,9 + y,0,146,14 );
	gfx.PutPixel( 44 + x,9 + y,0,146,14 );
	gfx.PutPixel( 45 + x,9 + y,0,146,14 );
	gfx.PutPixel( 54 + x,9 + y,0,146,14 );
	gfx.PutPixel( 55 + x,9 + y,0,146,14 );
	gfx.PutPixel( 56 + x,9 + y,0,146,14 );
	gfx.PutPixel( 57 + x,9 + y,0,146,14 );
	gfx.PutPixel( 64 + x,9 + y,0,146,14 );
	gfx.PutPixel( 65 + x,9 + y,0,146,14 );
	gfx.PutPixel( 66 + x,9 + y,0,146,14 );
	gfx.PutPixel( 80 + x,9 + y,0,146,14 );
	gfx.PutPixel( 81 + x,9 + y,0,146,14 );
	gfx.PutPixel( 82 + x,9 + y,0,146,14 );
	gfx.PutPixel( 83 + x,9 + y,0,118,11 );
	gfx.PutPixel( 34 + x,10 + y,0,146,14 );
	gfx.PutPixel( 35 + x,10 + y,0,146,14 );
	gfx.PutPixel( 36 + x,10 + y,0,146,14 );
	gfx.PutPixel( 37 + x,10 + y,0,146,14 );
	gfx.PutPixel( 38 + x,10 + y,0,146,14 );
	gfx.PutPixel( 39 + x,10 + y,0,146,14 );
	gfx.PutPixel( 40 + x,10 + y,0,146,14 );
	gfx.PutPixel( 41 + x,10 + y,0,146,14 );
	gfx.PutPixel( 42 + x,10 + y,0,146,14 );
	gfx.PutPixel( 43 + x,10 + y,0,146,14 );
	gfx.PutPixel( 44 + x,10 + y,0,146,14 );
	gfx.PutPixel( 45 + x,10 + y,0,146,14 );
	gfx.PutPixel( 55 + x,10 + y,0,146,14 );
	gfx.PutPixel( 56 + x,10 + y,0,146,14 );
	gfx.PutPixel( 57 + x,10 + y,0,146,14 );
	gfx.PutPixel( 64 + x,10 + y,0,146,14 );
	gfx.PutPixel( 65 + x,10 + y,0,146,14 );
	gfx.PutPixel( 66 + x,10 + y,0,146,14 );
	gfx.PutPixel( 81 + x,10 + y,0,146,14 );
	gfx.PutPixel( 82 + x,10 + y,0,146,14 );
	gfx.PutPixel( 83 + x,10 + y,0,146,14 );
	gfx.PutPixel( 28 + x,11 + y,0,146,14 );
	gfx.PutPixel( 29 + x,11 + y,0,146,14 );
	gfx.PutPixel( 30 + x,11 + y,0,146,14 );
	gfx.PutPixel( 31 + x,11 + y,0,146,14 );
	gfx.PutPixel( 32 + x,11 + y,0,146,14 );
	gfx.PutPixel( 35 + x,11 + y,0,146,14 );
	gfx.PutPixel( 36 + x,11 + y,0,146,14 );
	gfx.PutPixel( 37 + x,11 + y,0,146,14 );
	gfx.PutPixel( 38 + x,11 + y,0,146,14 );
	gfx.PutPixel( 39 + x,11 + y,0,146,14 );
	gfx.PutPixel( 40 + x,11 + y,0,146,14 );
	gfx.PutPixel( 41 + x,11 + y,0,146,14 );
	gfx.PutPixel( 42 + x,11 + y,0,146,14 );
	gfx.PutPixel( 43 + x,11 + y,0,146,14 );
	gfx.PutPixel( 44 + x,11 + y,0,146,14 );
	gfx.PutPixel( 55 + x,11 + y,0,146,14 );
	gfx.PutPixel( 56 + x,11 + y,0,146,14 );
	gfx.PutPixel( 57 + x,11 + y,0,146,14 );
	gfx.PutPixel( 58 + x,11 + y,0,146,14 );
	gfx.PutPixel( 64 + x,11 + y,0,146,14 );
	gfx.PutPixel( 65 + x,11 + y,0,146,14 );
	gfx.PutPixel( 66 + x,11 + y,0,146,14 );
	gfx.PutPixel( 81 + x,11 + y,0,146,14 );
	gfx.PutPixel( 82 + x,11 + y,0,146,14 );
	gfx.PutPixel( 83 + x,11 + y,0,146,14 );
	gfx.PutPixel( 27 + x,12 + y,0,146,14 );
	gfx.PutPixel( 28 + x,12 + y,0,146,14 );
	gfx.PutPixel( 29 + x,12 + y,0,146,14 );
	gfx.PutPixel( 30 + x,12 + y,0,146,14 );
	gfx.PutPixel( 31 + x,12 + y,0,146,14 );
	gfx.PutPixel( 32 + x,12 + y,0,146,14 );
	gfx.PutPixel( 33 + x,12 + y,0,146,14 );
	gfx.PutPixel( 35 + x,12 + y,0,142,13 );
	gfx.PutPixel( 36 + x,12 + y,0,146,14 );
	gfx.PutPixel( 37 + x,12 + y,0,146,14 );
	gfx.PutPixel( 38 + x,12 + y,0,146,14 );
	gfx.PutPixel( 39 + x,12 + y,0,146,14 );
	gfx.PutPixel( 40 + x,12 + y,0,146,14 );
	gfx.PutPixel( 41 + x,12 + y,0,146,14 );
	gfx.PutPixel( 42 + x,12 + y,0,146,14 );
	gfx.PutPixel( 43 + x,12 + y,0,146,14 );
	gfx.PutPixel( 56 + x,12 + y,0,146,14 );
	gfx.PutPixel( 57 + x,12 + y,0,146,14 );
	gfx.PutPixel( 58 + x,12 + y,0,146,14 );
	gfx.PutPixel( 64 + x,12 + y,0,146,14 );
	gfx.PutPixel( 65 + x,12 + y,0,146,14 );
	gfx.PutPixel( 66 + x,12 + y,0,146,14 );
	gfx.PutPixel( 67 + x,12 + y,0,146,14 );
	gfx.PutPixel( 68 + x,12 + y,0,146,14 );
	gfx.PutPixel( 69 + x,12 + y,0,146,14 );
	gfx.PutPixel( 70 + x,12 + y,0,146,14 );
	gfx.PutPixel( 71 + x,12 + y,0,146,14 );
	gfx.PutPixel( 72 + x,12 + y,0,146,14 );
	gfx.PutPixel( 73 + x,12 + y,0,146,14 );
	gfx.PutPixel( 74 + x,12 + y,0,146,14 );
	gfx.PutPixel( 75 + x,12 + y,0,146,14 );
	gfx.PutPixel( 76 + x,12 + y,0,146,14 );
	gfx.PutPixel( 77 + x,12 + y,0,146,14 );
	gfx.PutPixel( 78 + x,12 + y,0,146,14 );
	gfx.PutPixel( 79 + x,12 + y,0,146,14 );
	gfx.PutPixel( 80 + x,12 + y,0,146,14 );
	gfx.PutPixel( 81 + x,12 + y,0,146,14 );
	gfx.PutPixel( 82 + x,12 + y,0,146,14 );
	gfx.PutPixel( 83 + x,12 + y,0,146,14 );
	gfx.PutPixel( 26 + x,13 + y,0,146,14 );
	gfx.PutPixel( 27 + x,13 + y,0,146,14 );
	gfx.PutPixel( 28 + x,13 + y,0,146,14 );
	gfx.PutPixel( 29 + x,13 + y,0,146,14 );
	gfx.PutPixel( 30 + x,13 + y,0,146,14 );
	gfx.PutPixel( 31 + x,13 + y,0,146,14 );
	gfx.PutPixel( 32 + x,13 + y,0,146,14 );
	gfx.PutPixel( 33 + x,13 + y,0,146,14 );
	gfx.PutPixel( 34 + x,13 + y,0,146,14 );
	gfx.PutPixel( 37 + x,13 + y,0,146,14 );
	gfx.PutPixel( 38 + x,13 + y,0,146,14 );
	gfx.PutPixel( 39 + x,13 + y,0,146,14 );
	gfx.PutPixel( 40 + x,13 + y,0,146,14 );
	gfx.PutPixel( 41 + x,13 + y,0,146,14 );
	gfx.PutPixel( 42 + x,13 + y,0,146,14 );
	gfx.PutPixel( 56 + x,13 + y,0,142,13 );
	gfx.PutPixel( 57 + x,13 + y,0,146,14 );
	gfx.PutPixel( 58 + x,13 + y,0,146,14 );
	gfx.PutPixel( 59 + x,13 + y,0,146,14 );
	gfx.PutPixel( 64 + x,13 + y,0,146,14 );
	gfx.PutPixel( 65 + x,13 + y,0,146,14 );
	gfx.PutPixel( 66 + x,13 + y,0,146,14 );
	gfx.PutPixel( 67 + x,13 + y,0,146,14 );
	gfx.PutPixel( 68 + x,13 + y,0,146,14 );
	gfx.PutPixel( 69 + x,13 + y,0,146,14 );
	gfx.PutPixel( 70 + x,13 + y,0,146,14 );
	gfx.PutPixel( 71 + x,13 + y,0,146,14 );
	gfx.PutPixel( 72 + x,13 + y,0,146,14 );
	gfx.PutPixel( 73 + x,13 + y,0,146,14 );
	gfx.PutPixel( 74 + x,13 + y,0,146,14 );
	gfx.PutPixel( 75 + x,13 + y,0,146,14 );
	gfx.PutPixel( 76 + x,13 + y,0,146,14 );
	gfx.PutPixel( 77 + x,13 + y,0,146,14 );
	gfx.PutPixel( 78 + x,13 + y,0,146,14 );
	gfx.PutPixel( 79 + x,13 + y,0,146,14 );
	gfx.PutPixel( 80 + x,13 + y,0,146,14 );
	gfx.PutPixel( 81 + x,13 + y,0,146,14 );
	gfx.PutPixel( 82 + x,13 + y,0,146,14 );
	gfx.PutPixel( 83 + x,13 + y,0,146,14 );
	gfx.PutPixel( 25 + x,14 + y,0,146,14 );
	gfx.PutPixel( 26 + x,14 + y,0,146,14 );
	gfx.PutPixel( 27 + x,14 + y,0,146,14 );
	gfx.PutPixel( 28 + x,14 + y,0,146,14 );
	gfx.PutPixel( 29 + x,14 + y,0,146,14 );
	gfx.PutPixel( 30 + x,14 + y,0,146,14 );
	gfx.PutPixel( 31 + x,14 + y,0,146,14 );
	gfx.PutPixel( 32 + x,14 + y,0,146,14 );
	gfx.PutPixel( 33 + x,14 + y,0,146,14 );
	gfx.PutPixel( 34 + x,14 + y,0,146,14 );
	gfx.PutPixel( 57 + x,14 + y,0,146,14 );
	gfx.PutPixel( 58 + x,14 + y,0,146,14 );
	gfx.PutPixel( 59 + x,14 + y,0,146,14 );
	gfx.PutPixel( 60 + x,14 + y,0,146,14 );
	gfx.PutPixel( 64 + x,14 + y,0,146,14 );
	gfx.PutPixel( 65 + x,14 + y,0,146,14 );
	gfx.PutPixel( 66 + x,14 + y,0,146,14 );
	gfx.PutPixel( 67 + x,14 + y,0,146,14 );
	gfx.PutPixel( 68 + x,14 + y,0,146,14 );
	gfx.PutPixel( 69 + x,14 + y,0,146,14 );
	gfx.PutPixel( 70 + x,14 + y,0,146,14 );
	gfx.PutPixel( 71 + x,14 + y,0,146,14 );
	gfx.PutPixel( 72 + x,14 + y,0,146,14 );
	gfx.PutPixel( 73 + x,14 + y,0,146,14 );
	gfx.PutPixel( 74 + x,14 + y,0,146,14 );
	gfx.PutPixel( 75 + x,14 + y,0,146,14 );
	gfx.PutPixel( 76 + x,14 + y,0,146,14 );
	gfx.PutPixel( 77 + x,14 + y,0,146,14 );
	gfx.PutPixel( 78 + x,14 + y,0,146,14 );
	gfx.PutPixel( 79 + x,14 + y,0,146,14 );
	gfx.PutPixel( 80 + x,14 + y,0,146,14 );
	gfx.PutPixel( 81 + x,14 + y,0,146,14 );
	gfx.PutPixel( 82 + x,14 + y,0,146,14 );
	gfx.PutPixel( 83 + x,14 + y,0,146,14 );
	gfx.PutPixel( 24 + x,15 + y,0,25,2 );
	gfx.PutPixel( 25 + x,15 + y,0,146,14 );
	gfx.PutPixel( 26 + x,15 + y,0,146,14 );
	gfx.PutPixel( 27 + x,15 + y,0,146,14 );
	gfx.PutPixel( 28 + x,15 + y,0,146,14 );
	gfx.PutPixel( 29 + x,15 + y,0,146,14 );
	gfx.PutPixel( 30 + x,15 + y,0,146,14 );
	gfx.PutPixel( 31 + x,15 + y,0,146,14 );
	gfx.PutPixel( 32 + x,15 + y,0,146,14 );
	gfx.PutPixel( 33 + x,15 + y,0,146,14 );
	gfx.PutPixel( 34 + x,15 + y,0,146,14 );
	gfx.PutPixel( 58 + x,15 + y,0,146,14 );
	gfx.PutPixel( 59 + x,15 + y,0,146,14 );
	gfx.PutPixel( 60 + x,15 + y,0,146,14 );
	gfx.PutPixel( 64 + x,15 + y,0,146,14 );
	gfx.PutPixel( 65 + x,15 + y,0,146,14 );
	gfx.PutPixel( 66 + x,15 + y,0,146,14 );
	gfx.PutPixel( 81 + x,15 + y,0,146,14 );
	gfx.PutPixel( 82 + x,15 + y,0,146,14 );
	gfx.PutPixel( 83 + x,15 + y,0,146,14 );
	gfx.PutPixel( 24 + x,16 + y,0,146,14 );
	gfx.PutPixel( 25 + x,16 + y,0,146,14 );
	gfx.PutPixel( 26 + x,16 + y,0,146,14 );
	gfx.PutPixel( 27 + x,16 + y,0,146,14 );
	gfx.PutPixel( 28 + x,16 + y,0,146,14 );
	gfx.PutPixel( 29 + x,16 + y,0,146,14 );
	gfx.PutPixel( 30 + x,16 + y,0,146,14 );
	gfx.PutPixel( 31 + x,16 + y,0,146,14 );
	gfx.PutPixel( 32 + x,16 + y,0,146,14 );
	gfx.PutPixel( 33 + x,16 + y,0,146,14 );
	gfx.PutPixel( 34 + x,16 + y,0,146,14 );
	gfx.PutPixel( 58 + x,16 + y,0,146,14 );
	gfx.PutPixel( 59 + x,16 + y,0,146,14 );
	gfx.PutPixel( 60 + x,16 + y,0,146,14 );
	gfx.PutPixel( 61 + x,16 + y,0,146,14 );
	gfx.PutPixel( 64 + x,16 + y,0,146,14 );
	gfx.PutPixel( 65 + x,16 + y,0,146,14 );
	gfx.PutPixel( 66 + x,16 + y,0,146,14 );
	gfx.PutPixel( 81 + x,16 + y,0,146,14 );
	gfx.PutPixel( 82 + x,16 + y,0,146,14 );
	gfx.PutPixel( 83 + x,16 + y,0,146,14 );
	gfx.PutPixel( 23 + x,17 + y,0,146,14 );
	gfx.PutPixel( 24 + x,17 + y,0,146,14 );
	gfx.PutPixel( 25 + x,17 + y,0,146,14 );
	gfx.PutPixel( 26 + x,17 + y,0,146,14 );
	gfx.PutPixel( 27 + x,17 + y,0,146,14 );
	gfx.PutPixel( 28 + x,17 + y,0,146,14 );
	gfx.PutPixel( 29 + x,17 + y,0,146,14 );
	gfx.PutPixel( 30 + x,17 + y,0,146,14 );
	gfx.PutPixel( 31 + x,17 + y,0,146,14 );
	gfx.PutPixel( 32 + x,17 + y,0,146,14 );
	gfx.PutPixel( 33 + x,17 + y,0,146,14 );
	gfx.PutPixel( 34 + x,17 + y,0,146,14 );
	gfx.PutPixel( 59 + x,17 + y,0,146,14 );
	gfx.PutPixel( 60 + x,17 + y,0,146,14 );
	gfx.PutPixel( 61 + x,17 + y,0,146,14 );
	gfx.PutPixel( 62 + x,17 + y,0,146,14 );
	gfx.PutPixel( 64 + x,17 + y,0,146,14 );
	gfx.PutPixel( 65 + x,17 + y,0,146,14 );
	gfx.PutPixel( 66 + x,17 + y,0,146,14 );
	gfx.PutPixel( 81 + x,17 + y,0,146,14 );
	gfx.PutPixel( 82 + x,17 + y,0,146,14 );
	gfx.PutPixel( 83 + x,17 + y,0,146,14 );
	gfx.PutPixel( 22 + x,18 + y,0,146,14 );
	gfx.PutPixel( 23 + x,18 + y,0,146,14 );
	gfx.PutPixel( 24 + x,18 + y,0,146,14 );
	gfx.PutPixel( 25 + x,18 + y,0,146,14 );
	gfx.PutPixel( 26 + x,18 + y,0,146,14 );
	gfx.PutPixel( 27 + x,18 + y,0,146,14 );
	gfx.PutPixel( 28 + x,18 + y,0,146,14 );
	gfx.PutPixel( 29 + x,18 + y,0,146,14 );
	gfx.PutPixel( 30 + x,18 + y,0,146,14 );
	gfx.PutPixel( 31 + x,18 + y,0,146,14 );
	gfx.PutPixel( 32 + x,18 + y,0,146,14 );
	gfx.PutPixel( 33 + x,18 + y,0,146,14 );
	gfx.PutPixel( 34 + x,18 + y,0,146,14 );
	gfx.PutPixel( 60 + x,18 + y,0,146,14 );
	gfx.PutPixel( 61 + x,18 + y,0,146,14 );
	gfx.PutPixel( 62 + x,18 + y,0,146,14 );
	gfx.PutPixel( 64 + x,18 + y,0,146,14 );
	gfx.PutPixel( 65 + x,18 + y,0,146,14 );
	gfx.PutPixel( 66 + x,18 + y,0,146,14 );
	gfx.PutPixel( 81 + x,18 + y,0,146,14 );
	gfx.PutPixel( 82 + x,18 + y,0,146,14 );
	gfx.PutPixel( 83 + x,18 + y,0,146,14 );
	gfx.PutPixel( 21 + x,19 + y,0,146,14 );
	gfx.PutPixel( 22 + x,19 + y,0,146,14 );
	gfx.PutPixel( 23 + x,19 + y,0,146,14 );
	gfx.PutPixel( 24 + x,19 + y,0,146,14 );
	gfx.PutPixel( 25 + x,19 + y,0,146,14 );
	gfx.PutPixel( 26 + x,19 + y,0,146,14 );
	gfx.PutPixel( 27 + x,19 + y,0,146,14 );
	gfx.PutPixel( 28 + x,19 + y,0,146,14 );
	gfx.PutPixel( 29 + x,19 + y,0,146,14 );
	gfx.PutPixel( 30 + x,19 + y,0,146,14 );
	gfx.PutPixel( 31 + x,19 + y,0,146,14 );
	gfx.PutPixel( 32 + x,19 + y,0,146,14 );
	gfx.PutPixel( 33 + x,19 + y,0,146,14 );
	gfx.PutPixel( 34 + x,19 + y,0,146,14 );
	gfx.PutPixel( 60 + x,19 + y,0,146,14 );
	gfx.PutPixel( 61 + x,19 + y,0,146,14 );
	gfx.PutPixel( 62 + x,19 + y,0,146,14 );
	gfx.PutPixel( 63 + x,19 + y,0,146,14 );
	gfx.PutPixel( 64 + x,19 + y,0,146,14 );
	gfx.PutPixel( 65 + x,19 + y,0,146,14 );
	gfx.PutPixel( 66 + x,19 + y,0,146,14 );
	gfx.PutPixel( 81 + x,19 + y,0,146,14 );
	gfx.PutPixel( 82 + x,19 + y,0,146,14 );
	gfx.PutPixel( 83 + x,19 + y,0,146,14 );
	gfx.PutPixel( 20 + x,20 + y,0,146,14 );
	gfx.PutPixel( 21 + x,20 + y,0,146,14 );
	gfx.PutPixel( 22 + x,20 + y,0,146,14 );
	gfx.PutPixel( 23 + x,20 + y,0,146,14 );
	gfx.PutPixel( 24 + x,20 + y,0,146,14 );
	gfx.PutPixel( 25 + x,20 + y,0,146,14 );
	gfx.PutPixel( 26 + x,20 + y,0,146,14 );
	gfx.PutPixel( 27 + x,20 + y,0,146,14 );
	gfx.PutPixel( 28 + x,20 + y,0,146,14 );
	gfx.PutPixel( 29 + x,20 + y,0,146,14 );
	gfx.PutPixel( 30 + x,20 + y,0,146,14 );
	gfx.PutPixel( 31 + x,20 + y,0,146,14 );
	gfx.PutPixel( 32 + x,20 + y,0,146,14 );
	gfx.PutPixel( 33 + x,20 + y,0,146,14 );
	gfx.PutPixel( 34 + x,20 + y,0,146,14 );
	gfx.PutPixel( 61 + x,20 + y,0,146,14 );
	gfx.PutPixel( 62 + x,20 + y,0,146,14 );
	gfx.PutPixel( 63 + x,20 + y,0,146,14 );
	gfx.PutPixel( 64 + x,20 + y,0,146,14 );
	gfx.PutPixel( 65 + x,20 + y,0,146,14 );
	gfx.PutPixel( 66 + x,20 + y,0,146,14 );
	gfx.PutPixel( 81 + x,20 + y,0,146,14 );
	gfx.PutPixel( 82 + x,20 + y,0,146,14 );
	gfx.PutPixel( 83 + x,20 + y,0,146,14 );
	gfx.PutPixel( 19 + x,21 + y,0,146,14 );
	gfx.PutPixel( 20 + x,21 + y,0,146,14 );
	gfx.PutPixel( 21 + x,21 + y,0,146,14 );
	gfx.PutPixel( 22 + x,21 + y,0,146,14 );
	gfx.PutPixel( 23 + x,21 + y,0,146,14 );
	gfx.PutPixel( 24 + x,21 + y,0,146,14 );
	gfx.PutPixel( 25 + x,21 + y,0,146,14 );
	gfx.PutPixel( 26 + x,21 + y,0,146,14 );
	gfx.PutPixel( 27 + x,21 + y,0,146,14 );
	gfx.PutPixel( 28 + x,21 + y,0,146,14 );
	gfx.PutPixel( 29 + x,21 + y,0,146,14 );
	gfx.PutPixel( 30 + x,21 + y,0,146,14 );
	gfx.PutPixel( 31 + x,21 + y,0,146,14 );
	gfx.PutPixel( 32 + x,21 + y,0,146,14 );
	gfx.PutPixel( 33 + x,21 + y,0,146,14 );
	gfx.PutPixel( 34 + x,21 + y,0,146,14 );
	gfx.PutPixel( 61 + x,21 + y,0,146,14 );
	gfx.PutPixel( 62 + x,21 + y,0,146,14 );
	gfx.PutPixel( 63 + x,21 + y,0,146,14 );
	gfx.PutPixel( 64 + x,21 + y,0,146,14 );
	gfx.PutPixel( 65 + x,21 + y,0,146,14 );
	gfx.PutPixel( 66 + x,21 + y,0,146,14 );
	gfx.PutPixel( 81 + x,21 + y,0,146,14 );
	gfx.PutPixel( 82 + x,21 + y,0,146,14 );
	gfx.PutPixel( 83 + x,21 + y,0,146,14 );
	gfx.PutPixel( 18 + x,22 + y,0,146,14 );
	gfx.PutPixel( 19 + x,22 + y,0,146,14 );
	gfx.PutPixel( 20 + x,22 + y,0,146,14 );
	gfx.PutPixel( 21 + x,22 + y,0,146,14 );
	gfx.PutPixel( 22 + x,22 + y,0,146,14 );
	gfx.PutPixel( 23 + x,22 + y,0,146,14 );
	gfx.PutPixel( 24 + x,22 + y,0,146,14 );
	gfx.PutPixel( 25 + x,22 + y,0,146,14 );
	gfx.PutPixel( 26 + x,22 + y,0,146,14 );
	gfx.PutPixel( 27 + x,22 + y,0,146,14 );
	gfx.PutPixel( 28 + x,22 + y,0,146,14 );
	gfx.PutPixel( 29 + x,22 + y,0,146,14 );
	gfx.PutPixel( 30 + x,22 + y,0,146,14 );
	gfx.PutPixel( 31 + x,22 + y,0,146,14 );
	gfx.PutPixel( 32 + x,22 + y,0,146,14 );
	gfx.PutPixel( 33 + x,22 + y,0,146,14 );
	gfx.PutPixel( 34 + x,22 + y,0,146,14 );
	gfx.PutPixel( 35 + x,22 + y,0,25,2 );
	gfx.PutPixel( 62 + x,22 + y,0,146,14 );
	gfx.PutPixel( 63 + x,22 + y,0,146,14 );
	gfx.PutPixel( 64 + x,22 + y,0,146,14 );
	gfx.PutPixel( 65 + x,22 + y,0,146,14 );
	gfx.PutPixel( 66 + x,22 + y,0,146,14 );
	gfx.PutPixel( 81 + x,22 + y,0,146,14 );
	gfx.PutPixel( 82 + x,22 + y,0,146,14 );
	gfx.PutPixel( 83 + x,22 + y,0,146,14 );
	gfx.PutPixel( 17 + x,23 + y,0,3,0 );
	gfx.PutPixel( 18 + x,23 + y,0,146,14 );
	gfx.PutPixel( 19 + x,23 + y,0,146,14 );
	gfx.PutPixel( 20 + x,23 + y,0,146,14 );
	gfx.PutPixel( 21 + x,23 + y,0,146,14 );
	gfx.PutPixel( 22 + x,23 + y,0,146,14 );
	gfx.PutPixel( 23 + x,23 + y,0,146,14 );
	gfx.PutPixel( 24 + x,23 + y,0,146,14 );
	gfx.PutPixel( 25 + x,23 + y,0,146,14 );
	gfx.PutPixel( 26 + x,23 + y,0,146,14 );
	gfx.PutPixel( 27 + x,23 + y,0,146,14 );
	gfx.PutPixel( 28 + x,23 + y,0,146,14 );
	gfx.PutPixel( 30 + x,23 + y,0,146,14 );
	gfx.PutPixel( 31 + x,23 + y,0,146,14 );
	gfx.PutPixel( 32 + x,23 + y,0,146,14 );
	gfx.PutPixel( 33 + x,23 + y,0,146,14 );
	gfx.PutPixel( 34 + x,23 + y,0,146,14 );
	gfx.PutPixel( 35 + x,23 + y,0,25,2 );
	gfx.PutPixel( 63 + x,23 + y,0,146,14 );
	gfx.PutPixel( 64 + x,23 + y,0,146,14 );
	gfx.PutPixel( 65 + x,23 + y,0,146,14 );
	gfx.PutPixel( 66 + x,23 + y,0,146,14 );
	gfx.PutPixel( 81 + x,23 + y,0,146,14 );
	gfx.PutPixel( 82 + x,23 + y,0,146,14 );
	gfx.PutPixel( 83 + x,23 + y,0,146,14 );
	gfx.PutPixel( 17 + x,24 + y,0,146,14 );
	gfx.PutPixel( 18 + x,24 + y,0,146,14 );
	gfx.PutPixel( 19 + x,24 + y,0,146,14 );
	gfx.PutPixel( 20 + x,24 + y,0,146,14 );
	gfx.PutPixel( 21 + x,24 + y,0,146,14 );
	gfx.PutPixel( 22 + x,24 + y,0,146,14 );
	gfx.PutPixel( 23 + x,24 + y,0,146,14 );
	gfx.PutPixel( 24 + x,24 + y,0,146,14 );
	gfx.PutPixel( 25 + x,24 + y,0,146,14 );
	gfx.PutPixel( 26 + x,24 + y,0,146,14 );
	gfx.PutPixel( 27 + x,24 + y,0,146,14 );
	gfx.PutPixel( 30 + x,24 + y,0,146,14 );
	gfx.PutPixel( 31 + x,24 + y,0,146,14 );
	gfx.PutPixel( 32 + x,24 + y,0,146,14 );
	gfx.PutPixel( 33 + x,24 + y,0,146,14 );
	gfx.PutPixel( 34 + x,24 + y,0,146,14 );
	gfx.PutPixel( 35 + x,24 + y,0,146,14 );
	gfx.PutPixel( 36 + x,24 + y,0,146,14 );
	gfx.PutPixel( 37 + x,24 + y,0,146,14 );
	gfx.PutPixel( 38 + x,24 + y,0,146,14 );
	gfx.PutPixel( 39 + x,24 + y,0,146,14 );
	gfx.PutPixel( 40 + x,24 + y,0,146,14 );
	gfx.PutPixel( 41 + x,24 + y,0,146,14 );
	gfx.PutPixel( 42 + x,24 + y,0,146,14 );
	gfx.PutPixel( 43 + x,24 + y,0,146,14 );
	gfx.PutPixel( 44 + x,24 + y,0,146,14 );
	gfx.PutPixel( 45 + x,24 + y,0,146,14 );
	gfx.PutPixel( 46 + x,24 + y,0,146,14 );
	gfx.PutPixel( 47 + x,24 + y,0,146,14 );
	gfx.PutPixel( 48 + x,24 + y,0,146,14 );
	gfx.PutPixel( 49 + x,24 + y,0,146,14 );
	gfx.PutPixel( 50 + x,24 + y,0,146,14 );
	gfx.PutPixel( 51 + x,24 + y,0,146,14 );
	gfx.PutPixel( 52 + x,24 + y,0,146,14 );
	gfx.PutPixel( 53 + x,24 + y,0,146,14 );
	gfx.PutPixel( 54 + x,24 + y,0,146,14 );
	gfx.PutPixel( 55 + x,24 + y,0,146,14 );
	gfx.PutPixel( 56 + x,24 + y,0,146,14 );
	gfx.PutPixel( 57 + x,24 + y,0,146,14 );
	gfx.PutPixel( 58 + x,24 + y,0,146,14 );
	gfx.PutPixel( 59 + x,24 + y,0,146,14 );
	gfx.PutPixel( 60 + x,24 + y,0,146,14 );
	gfx.PutPixel( 61 + x,24 + y,0,146,14 );
	gfx.PutPixel( 62 + x,24 + y,0,146,14 );
	gfx.PutPixel( 63 + x,24 + y,0,146,14 );
	gfx.PutPixel( 64 + x,24 + y,0,146,14 );
	gfx.PutPixel( 65 + x,24 + y,0,146,14 );
	gfx.PutPixel( 66 + x,24 + y,0,146,14 );
	gfx.PutPixel( 81 + x,24 + y,0,146,14 );
	gfx.PutPixel( 82 + x,24 + y,0,146,14 );
	gfx.PutPixel( 83 + x,24 + y,0,146,14 );
	gfx.PutPixel( 16 + x,25 + y,0,146,14 );
	gfx.PutPixel( 17 + x,25 + y,0,146,14 );
	gfx.PutPixel( 18 + x,25 + y,0,146,14 );
	gfx.PutPixel( 19 + x,25 + y,0,146,14 );
	gfx.PutPixel( 20 + x,25 + y,0,146,14 );
	gfx.PutPixel( 21 + x,25 + y,0,146,14 );
	gfx.PutPixel( 22 + x,25 + y,0,146,14 );
	gfx.PutPixel( 23 + x,25 + y,0,146,14 );
	gfx.PutPixel( 24 + x,25 + y,0,146,14 );
	gfx.PutPixel( 25 + x,25 + y,0,146,14 );
	gfx.PutPixel( 26 + x,25 + y,0,146,14 );
	gfx.PutPixel( 30 + x,25 + y,0,146,14 );
	gfx.PutPixel( 31 + x,25 + y,0,146,14 );
	gfx.PutPixel( 32 + x,25 + y,0,146,14 );
	gfx.PutPixel( 33 + x,25 + y,0,146,14 );
	gfx.PutPixel( 34 + x,25 + y,0,146,14 );
	gfx.PutPixel( 35 + x,25 + y,0,146,14 );
	gfx.PutPixel( 36 + x,25 + y,0,146,14 );
	gfx.PutPixel( 37 + x,25 + y,0,146,14 );
	gfx.PutPixel( 38 + x,25 + y,0,146,14 );
	gfx.PutPixel( 39 + x,25 + y,0,146,14 );
	gfx.PutPixel( 40 + x,25 + y,0,146,14 );
	gfx.PutPixel( 41 + x,25 + y,0,146,14 );
	gfx.PutPixel( 42 + x,25 + y,0,146,14 );
	gfx.PutPixel( 43 + x,25 + y,0,146,14 );
	gfx.PutPixel( 44 + x,25 + y,0,146,14 );
	gfx.PutPixel( 45 + x,25 + y,0,146,14 );
	gfx.PutPixel( 46 + x,25 + y,0,146,14 );
	gfx.PutPixel( 47 + x,25 + y,0,146,14 );
	gfx.PutPixel( 48 + x,25 + y,0,146,14 );
	gfx.PutPixel( 49 + x,25 + y,0,146,14 );
	gfx.PutPixel( 50 + x,25 + y,0,146,14 );
	gfx.PutPixel( 51 + x,25 + y,0,146,14 );
	gfx.PutPixel( 52 + x,25 + y,0,146,14 );
	gfx.PutPixel( 53 + x,25 + y,0,146,14 );
	gfx.PutPixel( 54 + x,25 + y,0,146,14 );
	gfx.PutPixel( 55 + x,25 + y,0,146,14 );
	gfx.PutPixel( 56 + x,25 + y,0,146,14 );
	gfx.PutPixel( 57 + x,25 + y,0,146,14 );
	gfx.PutPixel( 58 + x,25 + y,0,146,14 );
	gfx.PutPixel( 59 + x,25 + y,0,146,14 );
	gfx.PutPixel( 60 + x,25 + y,0,146,14 );
	gfx.PutPixel( 61 + x,25 + y,0,146,14 );
	gfx.PutPixel( 62 + x,25 + y,0,146,14 );
	gfx.PutPixel( 63 + x,25 + y,0,146,14 );
	gfx.PutPixel( 64 + x,25 + y,0,146,14 );
	gfx.PutPixel( 65 + x,25 + y,0,146,14 );
	gfx.PutPixel( 66 + x,25 + y,0,146,14 );
	gfx.PutPixel( 81 + x,25 + y,0,146,14 );
	gfx.PutPixel( 82 + x,25 + y,0,146,14 );
	gfx.PutPixel( 83 + x,25 + y,0,146,14 );
	gfx.PutPixel( 15 + x,26 + y,0,146,14 );
	gfx.PutPixel( 16 + x,26 + y,0,146,14 );
	gfx.PutPixel( 17 + x,26 + y,0,146,14 );
	gfx.PutPixel( 18 + x,26 + y,0,146,14 );
	gfx.PutPixel( 19 + x,26 + y,0,146,14 );
	gfx.PutPixel( 20 + x,26 + y,0,146,14 );
	gfx.PutPixel( 21 + x,26 + y,0,146,14 );
	gfx.PutPixel( 22 + x,26 + y,0,146,14 );
	gfx.PutPixel( 23 + x,26 + y,0,146,14 );
	gfx.PutPixel( 24 + x,26 + y,0,146,14 );
	gfx.PutPixel( 25 + x,26 + y,0,146,14 );
	gfx.PutPixel( 30 + x,26 + y,0,146,14 );
	gfx.PutPixel( 31 + x,26 + y,0,146,14 );
	gfx.PutPixel( 32 + x,26 + y,0,146,14 );
	gfx.PutPixel( 33 + x,26 + y,0,146,14 );
	gfx.PutPixel( 34 + x,26 + y,0,146,14 );
	gfx.PutPixel( 35 + x,26 + y,0,146,14 );
	gfx.PutPixel( 36 + x,26 + y,0,146,14 );
	gfx.PutPixel( 37 + x,26 + y,0,146,14 );
	gfx.PutPixel( 38 + x,26 + y,0,146,14 );
	gfx.PutPixel( 39 + x,26 + y,0,146,14 );
	gfx.PutPixel( 40 + x,26 + y,0,146,14 );
	gfx.PutPixel( 41 + x,26 + y,0,146,14 );
	gfx.PutPixel( 42 + x,26 + y,0,146,14 );
	gfx.PutPixel( 43 + x,26 + y,0,146,14 );
	gfx.PutPixel( 44 + x,26 + y,0,146,14 );
	gfx.PutPixel( 45 + x,26 + y,0,146,14 );
	gfx.PutPixel( 46 + x,26 + y,0,146,14 );
	gfx.PutPixel( 47 + x,26 + y,0,146,14 );
	gfx.PutPixel( 48 + x,26 + y,0,146,14 );
	gfx.PutPixel( 49 + x,26 + y,0,146,14 );
	gfx.PutPixel( 50 + x,26 + y,0,146,14 );
	gfx.PutPixel( 51 + x,26 + y,0,146,14 );
	gfx.PutPixel( 52 + x,26 + y,0,146,14 );
	gfx.PutPixel( 53 + x,26 + y,0,146,14 );
	gfx.PutPixel( 54 + x,26 + y,0,146,14 );
	gfx.PutPixel( 55 + x,26 + y,0,146,14 );
	gfx.PutPixel( 56 + x,26 + y,0,146,14 );
	gfx.PutPixel( 57 + x,26 + y,0,146,14 );
	gfx.PutPixel( 58 + x,26 + y,0,146,14 );
	gfx.PutPixel( 59 + x,26 + y,0,146,14 );
	gfx.PutPixel( 60 + x,26 + y,0,146,14 );
	gfx.PutPixel( 61 + x,26 + y,0,146,14 );
	gfx.PutPixel( 62 + x,26 + y,0,146,14 );
	gfx.PutPixel( 63 + x,26 + y,0,146,14 );
	gfx.PutPixel( 64 + x,26 + y,0,146,14 );
	gfx.PutPixel( 65 + x,26 + y,0,146,14 );
	gfx.PutPixel( 66 + x,26 + y,0,146,14 );
	gfx.PutPixel( 81 + x,26 + y,0,146,14 );
	gfx.PutPixel( 82 + x,26 + y,0,146,14 );
	gfx.PutPixel( 83 + x,26 + y,0,146,14 );
	gfx.PutPixel( 14 + x,27 + y,0,146,14 );
	gfx.PutPixel( 15 + x,27 + y,0,146,14 );
	gfx.PutPixel( 16 + x,27 + y,0,146,14 );
	gfx.PutPixel( 17 + x,27 + y,0,146,14 );
	gfx.PutPixel( 18 + x,27 + y,0,146,14 );
	gfx.PutPixel( 19 + x,27 + y,0,146,14 );
	gfx.PutPixel( 20 + x,27 + y,0,146,14 );
	gfx.PutPixel( 21 + x,27 + y,0,146,14 );
	gfx.PutPixel( 22 + x,27 + y,0,146,14 );
	gfx.PutPixel( 23 + x,27 + y,0,146,14 );
	gfx.PutPixel( 24 + x,27 + y,0,146,14 );
	gfx.PutPixel( 30 + x,27 + y,0,146,14 );
	gfx.PutPixel( 31 + x,27 + y,0,146,14 );
	gfx.PutPixel( 32 + x,27 + y,0,146,14 );
	gfx.PutPixel( 33 + x,27 + y,0,146,14 );
	gfx.PutPixel( 34 + x,27 + y,0,146,14 );
	gfx.PutPixel( 35 + x,27 + y,0,146,14 );
	gfx.PutPixel( 36 + x,27 + y,0,146,14 );
	gfx.PutPixel( 37 + x,27 + y,0,146,14 );
	gfx.PutPixel( 38 + x,27 + y,0,146,14 );
	gfx.PutPixel( 39 + x,27 + y,0,146,14 );
	gfx.PutPixel( 40 + x,27 + y,0,146,14 );
	gfx.PutPixel( 41 + x,27 + y,0,146,14 );
	gfx.PutPixel( 42 + x,27 + y,0,146,14 );
	gfx.PutPixel( 43 + x,27 + y,0,146,14 );
	gfx.PutPixel( 44 + x,27 + y,0,146,14 );
	gfx.PutPixel( 45 + x,27 + y,0,146,14 );
	gfx.PutPixel( 46 + x,27 + y,0,146,14 );
	gfx.PutPixel( 64 + x,27 + y,0,146,14 );
	gfx.PutPixel( 65 + x,27 + y,0,146,14 );
	gfx.PutPixel( 66 + x,27 + y,0,146,14 );
	gfx.PutPixel( 81 + x,27 + y,0,146,14 );
	gfx.PutPixel( 82 + x,27 + y,0,146,14 );
	gfx.PutPixel( 83 + x,27 + y,0,146,14 );
	gfx.PutPixel( 13 + x,28 + y,0,146,14 );
	gfx.PutPixel( 14 + x,28 + y,0,146,14 );
	gfx.PutPixel( 15 + x,28 + y,0,146,14 );
	gfx.PutPixel( 16 + x,28 + y,0,146,14 );
	gfx.PutPixel( 17 + x,28 + y,0,146,14 );
	gfx.PutPixel( 18 + x,28 + y,0,146,14 );
	gfx.PutPixel( 19 + x,28 + y,0,146,14 );
	gfx.PutPixel( 20 + x,28 + y,0,146,14 );
	gfx.PutPixel( 21 + x,28 + y,0,146,14 );
	gfx.PutPixel( 22 + x,28 + y,0,146,14 );
	gfx.PutPixel( 23 + x,28 + y,0,146,14 );
	gfx.PutPixel( 30 + x,28 + y,0,146,14 );
	gfx.PutPixel( 31 + x,28 + y,0,146,14 );
	gfx.PutPixel( 32 + x,28 + y,0,146,14 );
	gfx.PutPixel( 33 + x,28 + y,0,146,14 );
	gfx.PutPixel( 34 + x,28 + y,0,146,14 );
	gfx.PutPixel( 35 + x,28 + y,0,146,14 );
	gfx.PutPixel( 36 + x,28 + y,0,146,14 );
	gfx.PutPixel( 37 + x,28 + y,0,146,14 );
	gfx.PutPixel( 38 + x,28 + y,0,146,14 );
	gfx.PutPixel( 39 + x,28 + y,0,146,14 );
	gfx.PutPixel( 40 + x,28 + y,0,146,14 );
	gfx.PutPixel( 41 + x,28 + y,0,146,14 );
	gfx.PutPixel( 42 + x,28 + y,0,146,14 );
	gfx.PutPixel( 43 + x,28 + y,0,146,14 );
	gfx.PutPixel( 44 + x,28 + y,0,146,14 );
	gfx.PutPixel( 45 + x,28 + y,0,146,14 );
	gfx.PutPixel( 46 + x,28 + y,0,146,14 );
	gfx.PutPixel( 47 + x,28 + y,0,146,14 );
	gfx.PutPixel( 64 + x,28 + y,0,146,14 );
	gfx.PutPixel( 65 + x,28 + y,0,146,14 );
	gfx.PutPixel( 66 + x,28 + y,0,146,14 );
	gfx.PutPixel( 81 + x,28 + y,0,146,14 );
	gfx.PutPixel( 82 + x,28 + y,0,146,14 );
	gfx.PutPixel( 83 + x,28 + y,0,146,14 );
	gfx.PutPixel( 12 + x,29 + y,0,146,14 );
	gfx.PutPixel( 13 + x,29 + y,0,146,14 );
	gfx.PutPixel( 14 + x,29 + y,0,146,14 );
	gfx.PutPixel( 15 + x,29 + y,0,146,14 );
	gfx.PutPixel( 16 + x,29 + y,0,146,14 );
	gfx.PutPixel( 17 + x,29 + y,0,146,14 );
	gfx.PutPixel( 18 + x,29 + y,0,146,14 );
	gfx.PutPixel( 19 + x,29 + y,0,146,14 );
	gfx.PutPixel( 20 + x,29 + y,0,146,14 );
	gfx.PutPixel( 21 + x,29 + y,0,146,14 );
	gfx.PutPixel( 22 + x,29 + y,0,146,14 );
	gfx.PutPixel( 23 + x,29 + y,0,146,14 );
	gfx.PutPixel( 30 + x,29 + y,0,146,14 );
	gfx.PutPixel( 31 + x,29 + y,0,146,14 );
	gfx.PutPixel( 32 + x,29 + y,0,146,14 );
	gfx.PutPixel( 33 + x,29 + y,0,146,14 );
	gfx.PutPixel( 34 + x,29 + y,0,146,14 );
	gfx.PutPixel( 35 + x,29 + y,0,146,14 );
	gfx.PutPixel( 36 + x,29 + y,0,146,14 );
	gfx.PutPixel( 37 + x,29 + y,0,146,14 );
	gfx.PutPixel( 38 + x,29 + y,0,146,14 );
	gfx.PutPixel( 39 + x,29 + y,0,146,14 );
	gfx.PutPixel( 40 + x,29 + y,0,146,14 );
	gfx.PutPixel( 41 + x,29 + y,0,146,14 );
	gfx.PutPixel( 42 + x,29 + y,0,146,14 );
	gfx.PutPixel( 43 + x,29 + y,0,146,14 );
	gfx.PutPixel( 44 + x,29 + y,0,146,14 );
	gfx.PutPixel( 45 + x,29 + y,0,146,14 );
	gfx.PutPixel( 46 + x,29 + y,0,146,14 );
	gfx.PutPixel( 47 + x,29 + y,0,146,14 );
	gfx.PutPixel( 63 + x,29 + y,0,25,2 );
	gfx.PutPixel( 64 + x,29 + y,0,146,14 );
	gfx.PutPixel( 65 + x,29 + y,0,146,14 );
	gfx.PutPixel( 66 + x,29 + y,0,146,14 );
	gfx.PutPixel( 81 + x,29 + y,0,146,14 );
	gfx.PutPixel( 82 + x,29 + y,0,146,14 );
	gfx.PutPixel( 83 + x,29 + y,0,146,14 );
	gfx.PutPixel( 11 + x,30 + y,0,146,14 );
	gfx.PutPixel( 12 + x,30 + y,0,146,14 );
	gfx.PutPixel( 13 + x,30 + y,0,146,14 );
	gfx.PutPixel( 14 + x,30 + y,0,146,14 );
	gfx.PutPixel( 15 + x,30 + y,0,146,14 );
	gfx.PutPixel( 16 + x,30 + y,0,146,14 );
	gfx.PutPixel( 17 + x,30 + y,0,146,14 );
	gfx.PutPixel( 18 + x,30 + y,0,146,14 );
	gfx.PutPixel( 19 + x,30 + y,0,146,14 );
	gfx.PutPixel( 20 + x,30 + y,0,146,14 );
	gfx.PutPixel( 21 + x,30 + y,0,146,14 );
	gfx.PutPixel( 22 + x,30 + y,0,146,14 );
	gfx.PutPixel( 30 + x,30 + y,0,146,14 );
	gfx.PutPixel( 31 + x,30 + y,0,146,14 );
	gfx.PutPixel( 32 + x,30 + y,0,146,14 );
	gfx.PutPixel( 33 + x,30 + y,0,146,14 );
	gfx.PutPixel( 34 + x,30 + y,0,146,14 );
	gfx.PutPixel( 35 + x,30 + y,0,146,14 );
	gfx.PutPixel( 36 + x,30 + y,0,146,14 );
	gfx.PutPixel( 37 + x,30 + y,0,146,14 );
	gfx.PutPixel( 38 + x,30 + y,0,146,14 );
	gfx.PutPixel( 39 + x,30 + y,0,146,14 );
	gfx.PutPixel( 40 + x,30 + y,0,146,14 );
	gfx.PutPixel( 41 + x,30 + y,0,146,14 );
	gfx.PutPixel( 42 + x,30 + y,0,146,14 );
	gfx.PutPixel( 43 + x,30 + y,0,146,14 );
	gfx.PutPixel( 44 + x,30 + y,0,146,14 );
	gfx.PutPixel( 45 + x,30 + y,0,146,14 );
	gfx.PutPixel( 46 + x,30 + y,0,146,14 );
	gfx.PutPixel( 47 + x,30 + y,0,146,14 );
	gfx.PutPixel( 63 + x,30 + y,0,146,14 );
	gfx.PutPixel( 64 + x,30 + y,0,146,14 );
	gfx.PutPixel( 65 + x,30 + y,0,146,14 );
	gfx.PutPixel( 66 + x,30 + y,0,146,14 );
	gfx.PutPixel( 80 + x,30 + y,0,25,2 );
	gfx.PutPixel( 81 + x,30 + y,0,146,14 );
	gfx.PutPixel( 82 + x,30 + y,0,146,14 );
	gfx.PutPixel( 83 + x,30 + y,0,146,14 );
	gfx.PutPixel( 10 + x,31 + y,0,70,6 );
	gfx.PutPixel( 11 + x,31 + y,0,146,14 );
	gfx.PutPixel( 12 + x,31 + y,0,146,14 );
	gfx.PutPixel( 13 + x,31 + y,0,146,14 );
	gfx.PutPixel( 14 + x,31 + y,0,146,14 );
	gfx.PutPixel( 15 + x,31 + y,0,146,14 );
	gfx.PutPixel( 16 + x,31 + y,0,146,14 );
	gfx.PutPixel( 17 + x,31 + y,0,146,14 );
	gfx.PutPixel( 18 + x,31 + y,0,146,14 );
	gfx.PutPixel( 19 + x,31 + y,0,146,14 );
	gfx.PutPixel( 20 + x,31 + y,0,146,14 );
	gfx.PutPixel( 21 + x,31 + y,0,146,14 );
	gfx.PutPixel( 30 + x,31 + y,0,146,14 );
	gfx.PutPixel( 31 + x,31 + y,0,146,14 );
	gfx.PutPixel( 32 + x,31 + y,0,146,14 );
	gfx.PutPixel( 33 + x,31 + y,0,146,14 );
	gfx.PutPixel( 34 + x,31 + y,0,146,14 );
	gfx.PutPixel( 35 + x,31 + y,0,146,14 );
	gfx.PutPixel( 36 + x,31 + y,0,146,14 );
	gfx.PutPixel( 37 + x,31 + y,0,146,14 );
	gfx.PutPixel( 38 + x,31 + y,0,146,14 );
	gfx.PutPixel( 39 + x,31 + y,0,146,14 );
	gfx.PutPixel( 40 + x,31 + y,0,146,14 );
	gfx.PutPixel( 41 + x,31 + y,0,146,14 );
	gfx.PutPixel( 42 + x,31 + y,0,146,14 );
	gfx.PutPixel( 43 + x,31 + y,0,146,14 );
	gfx.PutPixel( 44 + x,31 + y,0,146,14 );
	gfx.PutPixel( 45 + x,31 + y,0,146,14 );
	gfx.PutPixel( 46 + x,31 + y,0,146,14 );
	gfx.PutPixel( 47 + x,31 + y,0,146,14 );
	gfx.PutPixel( 63 + x,31 + y,0,146,14 );
	gfx.PutPixel( 64 + x,31 + y,0,146,14 );
	gfx.PutPixel( 65 + x,31 + y,0,146,14 );
	gfx.PutPixel( 66 + x,31 + y,0,146,14 );
	gfx.PutPixel( 67 + x,31 + y,0,146,14 );
	gfx.PutPixel( 80 + x,31 + y,0,146,14 );
	gfx.PutPixel( 81 + x,31 + y,0,146,14 );
	gfx.PutPixel( 82 + x,31 + y,0,146,14 );
	gfx.PutPixel( 10 + x,32 + y,0,146,14 );
	gfx.PutPixel( 11 + x,32 + y,0,146,14 );
	gfx.PutPixel( 12 + x,32 + y,0,146,14 );
	gfx.PutPixel( 13 + x,32 + y,0,146,14 );
	gfx.PutPixel( 14 + x,32 + y,0,146,14 );
	gfx.PutPixel( 15 + x,32 + y,0,146,14 );
	gfx.PutPixel( 16 + x,32 + y,0,146,14 );
	gfx.PutPixel( 17 + x,32 + y,0,146,14 );
	gfx.PutPixel( 18 + x,32 + y,0,146,14 );
	gfx.PutPixel( 19 + x,32 + y,0,146,14 );
	gfx.PutPixel( 20 + x,32 + y,0,146,14 );
	gfx.PutPixel( 32 + x,32 + y,0,146,14 );
	gfx.PutPixel( 33 + x,32 + y,0,146,14 );
	gfx.PutPixel( 34 + x,32 + y,0,146,14 );
	gfx.PutPixel( 35 + x,32 + y,0,146,14 );
	gfx.PutPixel( 36 + x,32 + y,0,146,14 );
	gfx.PutPixel( 37 + x,32 + y,0,146,14 );
	gfx.PutPixel( 38 + x,32 + y,0,146,14 );
	gfx.PutPixel( 39 + x,32 + y,0,146,14 );
	gfx.PutPixel( 40 + x,32 + y,0,146,14 );
	gfx.PutPixel( 41 + x,32 + y,0,146,14 );
	gfx.PutPixel( 42 + x,32 + y,0,146,14 );
	gfx.PutPixel( 43 + x,32 + y,0,146,14 );
	gfx.PutPixel( 44 + x,32 + y,0,146,14 );
	gfx.PutPixel( 45 + x,32 + y,0,146,14 );
	gfx.PutPixel( 46 + x,32 + y,0,118,11 );
	gfx.PutPixel( 62 + x,32 + y,0,146,14 );
	gfx.PutPixel( 63 + x,32 + y,0,146,14 );
	gfx.PutPixel( 64 + x,32 + y,0,146,14 );
	gfx.PutPixel( 65 + x,32 + y,0,146,14 );
	gfx.PutPixel( 66 + x,32 + y,0,146,14 );
	gfx.PutPixel( 67 + x,32 + y,0,146,14 );
	gfx.PutPixel( 68 + x,32 + y,0,25,2 );
	gfx.PutPixel( 79 + x,32 + y,0,146,14 );
	gfx.PutPixel( 80 + x,32 + y,0,146,14 );
	gfx.PutPixel( 81 + x,32 + y,0,146,14 );
	gfx.PutPixel( 82 + x,32 + y,0,146,14 );
	gfx.PutPixel( 9 + x,33 + y,0,146,14 );
	gfx.PutPixel( 10 + x,33 + y,0,146,14 );
	gfx.PutPixel( 11 + x,33 + y,0,146,14 );
	gfx.PutPixel( 12 + x,33 + y,0,146,14 );
	gfx.PutPixel( 13 + x,33 + y,0,146,14 );
	gfx.PutPixel( 14 + x,33 + y,0,146,14 );
	gfx.PutPixel( 15 + x,33 + y,0,146,14 );
	gfx.PutPixel( 16 + x,33 + y,0,146,14 );
	gfx.PutPixel( 17 + x,33 + y,0,146,14 );
	gfx.PutPixel( 18 + x,33 + y,0,146,14 );
	gfx.PutPixel( 19 + x,33 + y,0,146,14 );
	gfx.PutPixel( 35 + x,33 + y,0,146,14 );
	gfx.PutPixel( 36 + x,33 + y,0,146,14 );
	gfx.PutPixel( 37 + x,33 + y,0,146,14 );
	gfx.PutPixel( 62 + x,33 + y,0,146,14 );
	gfx.PutPixel( 63 + x,33 + y,0,146,14 );
	gfx.PutPixel( 64 + x,33 + y,0,146,14 );
	gfx.PutPixel( 65 + x,33 + y,0,146,14 );
	gfx.PutPixel( 66 + x,33 + y,0,146,14 );
	gfx.PutPixel( 67 + x,33 + y,0,146,14 );
	gfx.PutPixel( 68 + x,33 + y,0,146,14 );
	gfx.PutPixel( 69 + x,33 + y,0,146,14 );
	gfx.PutPixel( 70 + x,33 + y,0,146,14 );
	gfx.PutPixel( 71 + x,33 + y,0,146,14 );
	gfx.PutPixel( 72 + x,33 + y,0,146,14 );
	gfx.PutPixel( 73 + x,33 + y,0,146,14 );
	gfx.PutPixel( 74 + x,33 + y,0,146,14 );
	gfx.PutPixel( 75 + x,33 + y,0,146,14 );
	gfx.PutPixel( 76 + x,33 + y,0,146,14 );
	gfx.PutPixel( 77 + x,33 + y,0,146,14 );
	gfx.PutPixel( 78 + x,33 + y,0,146,14 );
	gfx.PutPixel( 79 + x,33 + y,0,146,14 );
	gfx.PutPixel( 80 + x,33 + y,0,146,14 );
	gfx.PutPixel( 81 + x,33 + y,0,146,14 );
	gfx.PutPixel( 82 + x,33 + y,0,25,2 );
	gfx.PutPixel( 8 + x,34 + y,0,146,14 );
	gfx.PutPixel( 9 + x,34 + y,0,146,14 );
	gfx.PutPixel( 10 + x,34 + y,0,146,14 );
	gfx.PutPixel( 11 + x,34 + y,0,146,14 );
	gfx.PutPixel( 12 + x,34 + y,0,146,14 );
	gfx.PutPixel( 13 + x,34 + y,0,146,14 );
	gfx.PutPixel( 14 + x,34 + y,0,146,14 );
	gfx.PutPixel( 15 + x,34 + y,0,146,14 );
	gfx.PutPixel( 16 + x,34 + y,0,146,14 );
	gfx.PutPixel( 17 + x,34 + y,0,146,14 );
	gfx.PutPixel( 18 + x,34 + y,0,146,14 );
	gfx.PutPixel( 35 + x,34 + y,0,146,14 );
	gfx.PutPixel( 36 + x,34 + y,0,146,14 );
	gfx.PutPixel( 37 + x,34 + y,0,146,14 );
	gfx.PutPixel( 38 + x,34 + y,0,146,14 );
	gfx.PutPixel( 61 + x,34 + y,0,146,14 );
	gfx.PutPixel( 62 + x,34 + y,0,146,14 );
	gfx.PutPixel( 63 + x,34 + y,0,146,14 );
	gfx.PutPixel( 64 + x,34 + y,0,146,14 );
	gfx.PutPixel( 65 + x,34 + y,0,146,14 );
	gfx.PutPixel( 66 + x,34 + y,0,146,14 );
	gfx.PutPixel( 67 + x,34 + y,0,146,14 );
	gfx.PutPixel( 68 + x,34 + y,0,146,14 );
	gfx.PutPixel( 69 + x,34 + y,0,146,14 );
	gfx.PutPixel( 70 + x,34 + y,0,146,14 );
	gfx.PutPixel( 71 + x,34 + y,0,146,14 );
	gfx.PutPixel( 72 + x,34 + y,0,146,14 );
	gfx.PutPixel( 73 + x,34 + y,0,146,14 );
	gfx.PutPixel( 74 + x,34 + y,0,146,14 );
	gfx.PutPixel( 75 + x,34 + y,0,146,14 );
	gfx.PutPixel( 76 + x,34 + y,0,146,14 );
	gfx.PutPixel( 77 + x,34 + y,0,146,14 );
	gfx.PutPixel( 78 + x,34 + y,0,146,14 );
	gfx.PutPixel( 79 + x,34 + y,0,146,14 );
	gfx.PutPixel( 80 + x,34 + y,0,146,14 );
	gfx.PutPixel( 81 + x,34 + y,0,146,14 );
	gfx.PutPixel( 8 + x,35 + y,0,146,14 );
	gfx.PutPixel( 9 + x,35 + y,0,146,14 );
	gfx.PutPixel( 10 + x,35 + y,0,146,14 );
	gfx.PutPixel( 11 + x,35 + y,0,146,14 );
	gfx.PutPixel( 12 + x,35 + y,0,146,14 );
	gfx.PutPixel( 13 + x,35 + y,0,146,14 );
	gfx.PutPixel( 14 + x,35 + y,0,146,14 );
	gfx.PutPixel( 15 + x,35 + y,0,146,14 );
	gfx.PutPixel( 16 + x,35 + y,0,146,14 );
	gfx.PutPixel( 17 + x,35 + y,0,146,14 );
	gfx.PutPixel( 36 + x,35 + y,0,146,14 );
	gfx.PutPixel( 37 + x,35 + y,0,146,14 );
	gfx.PutPixel( 38 + x,35 + y,0,146,14 );
	gfx.PutPixel( 39 + x,35 + y,0,146,14 );
	gfx.PutPixel( 60 + x,35 + y,0,146,14 );
	gfx.PutPixel( 61 + x,35 + y,0,146,14 );
	gfx.PutPixel( 62 + x,35 + y,0,146,14 );
	gfx.PutPixel( 63 + x,35 + y,0,146,14 );
	gfx.PutPixel( 64 + x,35 + y,0,146,14 );
	gfx.PutPixel( 65 + x,35 + y,0,146,14 );
	gfx.PutPixel( 66 + x,35 + y,0,146,14 );
	gfx.PutPixel( 67 + x,35 + y,0,146,14 );
	gfx.PutPixel( 68 + x,35 + y,0,146,14 );
	gfx.PutPixel( 69 + x,35 + y,0,146,14 );
	gfx.PutPixel( 70 + x,35 + y,0,146,14 );
	gfx.PutPixel( 71 + x,35 + y,0,146,14 );
	gfx.PutPixel( 72 + x,35 + y,0,146,14 );
	gfx.PutPixel( 73 + x,35 + y,0,146,14 );
	gfx.PutPixel( 74 + x,35 + y,0,146,14 );
	gfx.PutPixel( 75 + x,35 + y,0,146,14 );
	gfx.PutPixel( 76 + x,35 + y,0,146,14 );
	gfx.PutPixel( 77 + x,35 + y,0,146,14 );
	gfx.PutPixel( 78 + x,35 + y,0,146,14 );
	gfx.PutPixel( 79 + x,35 + y,0,146,14 );
	gfx.PutPixel( 8 + x,36 + y,0,146,14 );
	gfx.PutPixel( 9 + x,36 + y,0,146,14 );
	gfx.PutPixel( 10 + x,36 + y,0,146,14 );
	gfx.PutPixel( 11 + x,36 + y,0,146,14 );
	gfx.PutPixel( 12 + x,36 + y,0,146,14 );
	gfx.PutPixel( 13 + x,36 + y,0,146,14 );
	gfx.PutPixel( 14 + x,36 + y,0,146,14 );
	gfx.PutPixel( 15 + x,36 + y,0,146,14 );
	gfx.PutPixel( 16 + x,36 + y,0,146,14 );
	gfx.PutPixel( 17 + x,36 + y,0,146,14 );
	gfx.PutPixel( 18 + x,36 + y,0,146,14 );
	gfx.PutPixel( 37 + x,36 + y,0,146,14 );
	gfx.PutPixel( 38 + x,36 + y,0,146,14 );
	gfx.PutPixel( 39 + x,36 + y,0,146,14 );
	gfx.PutPixel( 40 + x,36 + y,0,146,14 );
	gfx.PutPixel( 59 + x,36 + y,0,146,14 );
	gfx.PutPixel( 60 + x,36 + y,0,146,14 );
	gfx.PutPixel( 61 + x,36 + y,0,146,14 );
	gfx.PutPixel( 62 + x,36 + y,0,146,14 );
	gfx.PutPixel( 63 + x,36 + y,0,146,14 );
	gfx.PutPixel( 64 + x,36 + y,0,146,14 );
	gfx.PutPixel( 65 + x,36 + y,0,146,14 );
	gfx.PutPixel( 66 + x,36 + y,0,146,14 );
	gfx.PutPixel( 67 + x,36 + y,0,146,14 );
	gfx.PutPixel( 68 + x,36 + y,0,146,14 );
	gfx.PutPixel( 69 + x,36 + y,0,146,14 );
	gfx.PutPixel( 70 + x,36 + y,0,146,14 );
	gfx.PutPixel( 71 + x,36 + y,0,146,14 );
	gfx.PutPixel( 72 + x,36 + y,0,146,14 );
	gfx.PutPixel( 73 + x,36 + y,0,146,14 );
	gfx.PutPixel( 74 + x,36 + y,0,146,14 );
	gfx.PutPixel( 9 + x,37 + y,0,146,14 );
	gfx.PutPixel( 10 + x,37 + y,0,146,14 );
	gfx.PutPixel( 11 + x,37 + y,0,146,14 );
	gfx.PutPixel( 12 + x,37 + y,0,146,14 );
	gfx.PutPixel( 13 + x,37 + y,0,146,14 );
	gfx.PutPixel( 14 + x,37 + y,0,146,14 );
	gfx.PutPixel( 15 + x,37 + y,0,146,14 );
	gfx.PutPixel( 16 + x,37 + y,0,146,14 );
	gfx.PutPixel( 17 + x,37 + y,0,146,14 );
	gfx.PutPixel( 18 + x,37 + y,0,146,14 );
	gfx.PutPixel( 19 + x,37 + y,0,146,14 );
	gfx.PutPixel( 37 + x,37 + y,0,70,6 );
	gfx.PutPixel( 38 + x,37 + y,0,146,14 );
	gfx.PutPixel( 39 + x,37 + y,0,146,14 );
	gfx.PutPixel( 40 + x,37 + y,0,146,14 );
	gfx.PutPixel( 41 + x,37 + y,0,146,14 );
	gfx.PutPixel( 58 + x,37 + y,0,146,14 );
	gfx.PutPixel( 59 + x,37 + y,0,146,14 );
	gfx.PutPixel( 60 + x,37 + y,0,146,14 );
	gfx.PutPixel( 61 + x,37 + y,0,146,14 );
	gfx.PutPixel( 62 + x,37 + y,0,146,14 );
	gfx.PutPixel( 63 + x,37 + y,0,146,14 );
	gfx.PutPixel( 64 + x,37 + y,0,146,14 );
	gfx.PutPixel( 65 + x,37 + y,0,146,14 );
	gfx.PutPixel( 66 + x,37 + y,0,146,14 );
	gfx.PutPixel( 67 + x,37 + y,0,146,14 );
	gfx.PutPixel( 68 + x,37 + y,0,146,14 );
	gfx.PutPixel( 69 + x,37 + y,0,146,14 );
	gfx.PutPixel( 70 + x,37 + y,0,146,14 );
	gfx.PutPixel( 71 + x,37 + y,0,146,14 );
	gfx.PutPixel( 72 + x,37 + y,0,146,14 );
	gfx.PutPixel( 73 + x,37 + y,0,146,14 );
	gfx.PutPixel( 74 + x,37 + y,0,146,14 );
	gfx.PutPixel( 9 + x,38 + y,0,146,14 );
	gfx.PutPixel( 10 + x,38 + y,0,146,14 );
	gfx.PutPixel( 11 + x,38 + y,0,146,14 );
	gfx.PutPixel( 12 + x,38 + y,0,146,14 );
	gfx.PutPixel( 13 + x,38 + y,0,146,14 );
	gfx.PutPixel( 14 + x,38 + y,0,146,14 );
	gfx.PutPixel( 15 + x,38 + y,0,146,14 );
	gfx.PutPixel( 16 + x,38 + y,0,146,14 );
	gfx.PutPixel( 17 + x,38 + y,0,146,14 );
	gfx.PutPixel( 18 + x,38 + y,0,146,14 );
	gfx.PutPixel( 19 + x,38 + y,0,146,14 );
	gfx.PutPixel( 20 + x,38 + y,0,146,14 );
	gfx.PutPixel( 38 + x,38 + y,0,70,6 );
	gfx.PutPixel( 39 + x,38 + y,0,146,14 );
	gfx.PutPixel( 40 + x,38 + y,0,146,14 );
	gfx.PutPixel( 41 + x,38 + y,0,146,14 );
	gfx.PutPixel( 42 + x,38 + y,0,146,14 );
	gfx.PutPixel( 43 + x,38 + y,0,146,14 );
	gfx.PutPixel( 56 + x,38 + y,0,146,14 );
	gfx.PutPixel( 57 + x,38 + y,0,146,14 );
	gfx.PutPixel( 58 + x,38 + y,0,146,14 );
	gfx.PutPixel( 59 + x,38 + y,0,146,14 );
	gfx.PutPixel( 60 + x,38 + y,0,146,14 );
	gfx.PutPixel( 61 + x,38 + y,0,146,14 );
	gfx.PutPixel( 62 + x,38 + y,0,146,14 );
	gfx.PutPixel( 63 + x,38 + y,0,146,14 );
	gfx.PutPixel( 64 + x,38 + y,0,146,14 );
	gfx.PutPixel( 65 + x,38 + y,0,146,14 );
	gfx.PutPixel( 66 + x,38 + y,0,146,14 );
	gfx.PutPixel( 67 + x,38 + y,0,146,14 );
	gfx.PutPixel( 68 + x,38 + y,0,146,14 );
	gfx.PutPixel( 69 + x,38 + y,0,146,14 );
	gfx.PutPixel( 70 + x,38 + y,0,146,14 );
	gfx.PutPixel( 71 + x,38 + y,0,146,14 );
	gfx.PutPixel( 72 + x,38 + y,0,146,14 );
	gfx.PutPixel( 73 + x,38 + y,0,146,14 );
	gfx.PutPixel( 74 + x,38 + y,0,146,14 );
	gfx.PutPixel( 10 + x,39 + y,0,146,14 );
	gfx.PutPixel( 11 + x,39 + y,0,146,14 );
	gfx.PutPixel( 12 + x,39 + y,0,146,14 );
	gfx.PutPixel( 13 + x,39 + y,0,146,14 );
	gfx.PutPixel( 14 + x,39 + y,0,146,14 );
	gfx.PutPixel( 15 + x,39 + y,0,146,14 );
	gfx.PutPixel( 16 + x,39 + y,0,146,14 );
	gfx.PutPixel( 17 + x,39 + y,0,146,14 );
	gfx.PutPixel( 18 + x,39 + y,0,146,14 );
	gfx.PutPixel( 19 + x,39 + y,0,146,14 );
	gfx.PutPixel( 20 + x,39 + y,0,146,14 );
	gfx.PutPixel( 21 + x,39 + y,0,146,14 );
	gfx.PutPixel( 40 + x,39 + y,0,146,14 );
	gfx.PutPixel( 41 + x,39 + y,0,146,14 );
	gfx.PutPixel( 42 + x,39 + y,0,146,14 );
	gfx.PutPixel( 43 + x,39 + y,0,146,14 );
	gfx.PutPixel( 44 + x,39 + y,0,146,14 );
	gfx.PutPixel( 45 + x,39 + y,0,146,14 );
	gfx.PutPixel( 46 + x,39 + y,0,146,14 );
	gfx.PutPixel( 53 + x,39 + y,0,146,14 );
	gfx.PutPixel( 54 + x,39 + y,0,146,14 );
	gfx.PutPixel( 55 + x,39 + y,0,146,14 );
	gfx.PutPixel( 56 + x,39 + y,0,146,14 );
	gfx.PutPixel( 57 + x,39 + y,0,146,14 );
	gfx.PutPixel( 58 + x,39 + y,0,146,14 );
	gfx.PutPixel( 59 + x,39 + y,0,146,14 );
	gfx.PutPixel( 60 + x,39 + y,0,146,14 );
	gfx.PutPixel( 61 + x,39 + y,0,146,14 );
	gfx.PutPixel( 62 + x,39 + y,0,146,14 );
	gfx.PutPixel( 63 + x,39 + y,0,146,14 );
	gfx.PutPixel( 64 + x,39 + y,0,146,14 );
	gfx.PutPixel( 65 + x,39 + y,0,146,14 );
	gfx.PutPixel( 66 + x,39 + y,0,146,14 );
	gfx.PutPixel( 67 + x,39 + y,0,146,14 );
	gfx.PutPixel( 68 + x,39 + y,0,146,14 );
	gfx.PutPixel( 69 + x,39 + y,0,146,14 );
	gfx.PutPixel( 70 + x,39 + y,0,146,14 );
	gfx.PutPixel( 71 + x,39 + y,0,146,14 );
	gfx.PutPixel( 72 + x,39 + y,0,146,14 );
	gfx.PutPixel( 73 + x,39 + y,0,146,14 );
	gfx.PutPixel( 74 + x,39 + y,0,146,14 );
	gfx.PutPixel( 11 + x,40 + y,0,146,14 );
	gfx.PutPixel( 12 + x,40 + y,0,146,14 );
	gfx.PutPixel( 13 + x,40 + y,0,146,14 );
	gfx.PutPixel( 14 + x,40 + y,0,146,14 );
	gfx.PutPixel( 15 + x,40 + y,0,146,14 );
	gfx.PutPixel( 16 + x,40 + y,0,146,14 );
	gfx.PutPixel( 17 + x,40 + y,0,146,14 );
	gfx.PutPixel( 18 + x,40 + y,0,146,14 );
	gfx.PutPixel( 19 + x,40 + y,0,146,14 );
	gfx.PutPixel( 20 + x,40 + y,0,146,14 );
	gfx.PutPixel( 21 + x,40 + y,0,146,14 );
	gfx.PutPixel( 22 + x,40 + y,0,146,14 );
	gfx.PutPixel( 41 + x,40 + y,0,146,14 );
	gfx.PutPixel( 42 + x,40 + y,0,146,14 );
	gfx.PutPixel( 43 + x,40 + y,0,146,14 );
	gfx.PutPixel( 44 + x,40 + y,0,146,14 );
	gfx.PutPixel( 45 + x,40 + y,0,146,14 );
	gfx.PutPixel( 46 + x,40 + y,0,146,14 );
	gfx.PutPixel( 47 + x,40 + y,0,146,14 );
	gfx.PutPixel( 48 + x,40 + y,0,146,14 );
	gfx.PutPixel( 49 + x,40 + y,0,146,14 );
	gfx.PutPixel( 50 + x,40 + y,0,146,14 );
	gfx.PutPixel( 51 + x,40 + y,0,146,14 );
	gfx.PutPixel( 52 + x,40 + y,0,146,14 );
	gfx.PutPixel( 53 + x,40 + y,0,146,14 );
	gfx.PutPixel( 54 + x,40 + y,0,146,14 );
	gfx.PutPixel( 55 + x,40 + y,0,146,14 );
	gfx.PutPixel( 56 + x,40 + y,0,146,14 );
	gfx.PutPixel( 57 + x,40 + y,0,146,14 );
	gfx.PutPixel( 58 + x,40 + y,0,146,14 );
	gfx.PutPixel( 59 + x,40 + y,0,146,14 );
	gfx.PutPixel( 60 + x,40 + y,0,146,14 );
	gfx.PutPixel( 61 + x,40 + y,0,146,14 );
	gfx.PutPixel( 62 + x,40 + y,0,146,14 );
	gfx.PutPixel( 63 + x,40 + y,0,146,14 );
	gfx.PutPixel( 64 + x,40 + y,0,146,14 );
	gfx.PutPixel( 65 + x,40 + y,0,146,14 );
	gfx.PutPixel( 66 + x,40 + y,0,146,14 );
	gfx.PutPixel( 67 + x,40 + y,0,146,14 );
	gfx.PutPixel( 68 + x,40 + y,0,146,14 );
	gfx.PutPixel( 69 + x,40 + y,0,146,14 );
	gfx.PutPixel( 70 + x,40 + y,0,146,14 );
	gfx.PutPixel( 71 + x,40 + y,0,146,14 );
	gfx.PutPixel( 72 + x,40 + y,0,146,14 );
	gfx.PutPixel( 73 + x,40 + y,0,146,14 );
	gfx.PutPixel( 74 + x,40 + y,0,146,14 );
	gfx.PutPixel( 75 + x,40 + y,0,146,14 );
	gfx.PutPixel( 76 + x,40 + y,0,146,14 );
	gfx.PutPixel( 77 + x,40 + y,0,70,6 );
	gfx.PutPixel( 12 + x,41 + y,0,146,14 );
	gfx.PutPixel( 13 + x,41 + y,0,146,14 );
	gfx.PutPixel( 14 + x,41 + y,0,146,14 );
	gfx.PutPixel( 15 + x,41 + y,0,146,14 );
	gfx.PutPixel( 16 + x,41 + y,0,146,14 );
	gfx.PutPixel( 17 + x,41 + y,0,146,14 );
	gfx.PutPixel( 18 + x,41 + y,0,146,14 );
	gfx.PutPixel( 19 + x,41 + y,0,146,14 );
	gfx.PutPixel( 20 + x,41 + y,0,146,14 );
	gfx.PutPixel( 21 + x,41 + y,0,146,14 );
	gfx.PutPixel( 22 + x,41 + y,0,146,14 );
	gfx.PutPixel( 23 + x,41 + y,0,146,14 );
	gfx.PutPixel( 40 + x,41 + y,0,146,14 );
	gfx.PutPixel( 41 + x,41 + y,0,146,14 );
	gfx.PutPixel( 42 + x,41 + y,0,146,14 );
	gfx.PutPixel( 43 + x,41 + y,0,146,14 );
	gfx.PutPixel( 44 + x,41 + y,0,146,14 );
	gfx.PutPixel( 45 + x,41 + y,0,146,14 );
	gfx.PutPixel( 46 + x,41 + y,0,146,14 );
	gfx.PutPixel( 47 + x,41 + y,0,146,14 );
	gfx.PutPixel( 48 + x,41 + y,0,146,14 );
	gfx.PutPixel( 49 + x,41 + y,0,146,14 );
	gfx.PutPixel( 50 + x,41 + y,0,146,14 );
	gfx.PutPixel( 51 + x,41 + y,0,146,14 );
	gfx.PutPixel( 52 + x,41 + y,0,146,14 );
	gfx.PutPixel( 53 + x,41 + y,0,146,14 );
	gfx.PutPixel( 54 + x,41 + y,0,146,14 );
	gfx.PutPixel( 55 + x,41 + y,0,146,14 );
	gfx.PutPixel( 56 + x,41 + y,0,146,14 );
	gfx.PutPixel( 57 + x,41 + y,0,146,14 );
	gfx.PutPixel( 58 + x,41 + y,0,146,14 );
	gfx.PutPixel( 59 + x,41 + y,0,146,14 );
	gfx.PutPixel( 60 + x,41 + y,0,146,14 );
	gfx.PutPixel( 61 + x,41 + y,0,146,14 );
	gfx.PutPixel( 62 + x,41 + y,0,146,14 );
	gfx.PutPixel( 63 + x,41 + y,0,146,14 );
	gfx.PutPixel( 64 + x,41 + y,0,146,14 );
	gfx.PutPixel( 65 + x,41 + y,0,146,14 );
	gfx.PutPixel( 66 + x,41 + y,0,146,14 );
	gfx.PutPixel( 67 + x,41 + y,0,146,14 );
	gfx.PutPixel( 68 + x,41 + y,0,146,14 );
	gfx.PutPixel( 69 + x,41 + y,0,146,14 );
	gfx.PutPixel( 70 + x,41 + y,0,146,14 );
	gfx.PutPixel( 71 + x,41 + y,0,146,14 );
	gfx.PutPixel( 72 + x,41 + y,0,146,14 );
	gfx.PutPixel( 73 + x,41 + y,0,146,14 );
	gfx.PutPixel( 74 + x,41 + y,0,146,14 );
	gfx.PutPixel( 75 + x,41 + y,0,146,14 );
	gfx.PutPixel( 76 + x,41 + y,0,146,14 );
	gfx.PutPixel( 77 + x,41 + y,0,146,14 );
	gfx.PutPixel( 78 + x,41 + y,0,146,14 );
	gfx.PutPixel( 3 + x,42 + y,0,25,2 );
	gfx.PutPixel( 4 + x,42 + y,0,146,14 );
	gfx.PutPixel( 5 + x,42 + y,0,146,14 );
	gfx.PutPixel( 6 + x,42 + y,0,25,2 );
	gfx.PutPixel( 13 + x,42 + y,0,146,14 );
	gfx.PutPixel( 14 + x,42 + y,0,146,14 );
	gfx.PutPixel( 15 + x,42 + y,0,146,14 );
	gfx.PutPixel( 16 + x,42 + y,0,146,14 );
	gfx.PutPixel( 17 + x,42 + y,0,146,14 );
	gfx.PutPixel( 18 + x,42 + y,0,146,14 );
	gfx.PutPixel( 19 + x,42 + y,0,146,14 );
	gfx.PutPixel( 20 + x,42 + y,0,146,14 );
	gfx.PutPixel( 21 + x,42 + y,0,146,14 );
	gfx.PutPixel( 22 + x,42 + y,0,146,14 );
	gfx.PutPixel( 23 + x,42 + y,0,146,14 );
	gfx.PutPixel( 24 + x,42 + y,0,146,14 );
	gfx.PutPixel( 39 + x,42 + y,0,146,14 );
	gfx.PutPixel( 40 + x,42 + y,0,146,14 );
	gfx.PutPixel( 41 + x,42 + y,0,146,14 );
	gfx.PutPixel( 42 + x,42 + y,0,146,14 );
	gfx.PutPixel( 43 + x,42 + y,0,146,14 );
	gfx.PutPixel( 44 + x,42 + y,0,146,14 );
	gfx.PutPixel( 45 + x,42 + y,0,146,14 );
	gfx.PutPixel( 46 + x,42 + y,0,146,14 );
	gfx.PutPixel( 47 + x,42 + y,0,146,14 );
	gfx.PutPixel( 48 + x,42 + y,0,146,14 );
	gfx.PutPixel( 49 + x,42 + y,0,146,14 );
	gfx.PutPixel( 50 + x,42 + y,0,146,14 );
	gfx.PutPixel( 51 + x,42 + y,0,146,14 );
	gfx.PutPixel( 52 + x,42 + y,0,146,14 );
	gfx.PutPixel( 53 + x,42 + y,0,146,14 );
	gfx.PutPixel( 54 + x,42 + y,0,146,14 );
	gfx.PutPixel( 55 + x,42 + y,0,146,14 );
	gfx.PutPixel( 56 + x,42 + y,0,146,14 );
	gfx.PutPixel( 57 + x,42 + y,0,146,14 );
	gfx.PutPixel( 58 + x,42 + y,0,146,14 );
	gfx.PutPixel( 59 + x,42 + y,0,146,14 );
	gfx.PutPixel( 60 + x,42 + y,0,146,14 );
	gfx.PutPixel( 61 + x,42 + y,0,146,14 );
	gfx.PutPixel( 62 + x,42 + y,0,146,14 );
	gfx.PutPixel( 63 + x,42 + y,0,146,14 );
	gfx.PutPixel( 64 + x,42 + y,0,146,14 );
	gfx.PutPixel( 65 + x,42 + y,0,146,14 );
	gfx.PutPixel( 66 + x,42 + y,0,146,14 );
	gfx.PutPixel( 67 + x,42 + y,0,146,14 );
	gfx.PutPixel( 68 + x,42 + y,0,146,14 );
	gfx.PutPixel( 69 + x,42 + y,0,146,14 );
	gfx.PutPixel( 70 + x,42 + y,0,146,14 );
	gfx.PutPixel( 71 + x,42 + y,0,146,14 );
	gfx.PutPixel( 72 + x,42 + y,0,146,14 );
	gfx.PutPixel( 73 + x,42 + y,0,146,14 );
	gfx.PutPixel( 74 + x,42 + y,0,146,14 );
	gfx.PutPixel( 75 + x,42 + y,0,146,14 );
	gfx.PutPixel( 76 + x,42 + y,0,146,14 );
	gfx.PutPixel( 77 + x,42 + y,0,146,14 );
	gfx.PutPixel( 78 + x,42 + y,0,146,14 );
	gfx.PutPixel( 79 + x,42 + y,0,146,14 );
	gfx.PutPixel( 1 + x,43 + y,0,146,14 );
	gfx.PutPixel( 2 + x,43 + y,0,146,14 );
	gfx.PutPixel( 3 + x,43 + y,0,146,14 );
	gfx.PutPixel( 4 + x,43 + y,0,146,14 );
	gfx.PutPixel( 5 + x,43 + y,0,146,14 );
	gfx.PutPixel( 6 + x,43 + y,0,146,14 );
	gfx.PutPixel( 7 + x,43 + y,0,146,14 );
	gfx.PutPixel( 8 + x,43 + y,0,146,14 );
	gfx.PutPixel( 9 + x,43 + y,0,146,14 );
	gfx.PutPixel( 10 + x,43 + y,0,146,14 );
	gfx.PutPixel( 11 + x,43 + y,0,146,14 );
	gfx.PutPixel( 12 + x,43 + y,0,146,14 );
	gfx.PutPixel( 13 + x,43 + y,0,146,14 );
	gfx.PutPixel( 14 + x,43 + y,0,146,14 );
	gfx.PutPixel( 15 + x,43 + y,0,146,14 );
	gfx.PutPixel( 16 + x,43 + y,0,146,14 );
	gfx.PutPixel( 17 + x,43 + y,0,146,14 );
	gfx.PutPixel( 18 + x,43 + y,0,146,14 );
	gfx.PutPixel( 19 + x,43 + y,0,146,14 );
	gfx.PutPixel( 20 + x,43 + y,0,146,14 );
	gfx.PutPixel( 21 + x,43 + y,0,146,14 );
	gfx.PutPixel( 22 + x,43 + y,0,146,14 );
	gfx.PutPixel( 23 + x,43 + y,0,146,14 );
	gfx.PutPixel( 24 + x,43 + y,0,146,14 );
	gfx.PutPixel( 25 + x,43 + y,0,146,14 );
	gfx.PutPixel( 38 + x,43 + y,0,146,14 );
	gfx.PutPixel( 39 + x,43 + y,0,146,14 );
	gfx.PutPixel( 40 + x,43 + y,0,146,14 );
	gfx.PutPixel( 41 + x,43 + y,0,146,14 );
	gfx.PutPixel( 77 + x,43 + y,0,146,14 );
	gfx.PutPixel( 78 + x,43 + y,0,146,14 );
	gfx.PutPixel( 79 + x,43 + y,0,146,14 );
	gfx.PutPixel( 0 + x,44 + y,0,146,14 );
	gfx.PutPixel( 1 + x,44 + y,0,146,14 );
	gfx.PutPixel( 2 + x,44 + y,0,146,14 );
	gfx.PutPixel( 3 + x,44 + y,0,146,14 );
	gfx.PutPixel( 4 + x,44 + y,0,146,14 );
	gfx.PutPixel( 5 + x,44 + y,0,146,14 );
	gfx.PutPixel( 6 + x,44 + y,0,146,14 );
	gfx.PutPixel( 7 + x,44 + y,0,146,14 );
	gfx.PutPixel( 8 + x,44 + y,0,146,14 );
	gfx.PutPixel( 9 + x,44 + y,0,146,14 );
	gfx.PutPixel( 10 + x,44 + y,0,146,14 );
	gfx.PutPixel( 11 + x,44 + y,0,146,14 );
	gfx.PutPixel( 12 + x,44 + y,0,146,14 );
	gfx.PutPixel( 13 + x,44 + y,0,146,14 );
	gfx.PutPixel( 14 + x,44 + y,0,146,14 );
	gfx.PutPixel( 15 + x,44 + y,0,146,14 );
	gfx.PutPixel( 16 + x,44 + y,0,146,14 );
	gfx.PutPixel( 17 + x,44 + y,0,146,14 );
	gfx.PutPixel( 18 + x,44 + y,0,146,14 );
	gfx.PutPixel( 19 + x,44 + y,0,146,14 );
	gfx.PutPixel( 20 + x,44 + y,0,146,14 );
	gfx.PutPixel( 21 + x,44 + y,0,146,14 );
	gfx.PutPixel( 22 + x,44 + y,0,146,14 );
	gfx.PutPixel( 23 + x,44 + y,0,146,14 );
	gfx.PutPixel( 24 + x,44 + y,0,146,14 );
	gfx.PutPixel( 25 + x,44 + y,0,146,14 );
	gfx.PutPixel( 26 + x,44 + y,0,146,14 );
	gfx.PutPixel( 38 + x,44 + y,0,146,14 );
	gfx.PutPixel( 39 + x,44 + y,0,146,14 );
	gfx.PutPixel( 40 + x,44 + y,0,146,14 );
	gfx.PutPixel( 77 + x,44 + y,0,3,0 );
	gfx.PutPixel( 78 + x,44 + y,0,146,14 );
	gfx.PutPixel( 79 + x,44 + y,0,146,14 );
	gfx.PutPixel( 80 + x,44 + y,0,146,14 );
	gfx.PutPixel( 0 + x,45 + y,0,146,14 );
	gfx.PutPixel( 1 + x,45 + y,0,146,14 );
	gfx.PutPixel( 2 + x,45 + y,0,146,14 );
	gfx.PutPixel( 3 + x,45 + y,0,146,14 );
	gfx.PutPixel( 4 + x,45 + y,0,146,14 );
	gfx.PutPixel( 5 + x,45 + y,0,146,14 );
	gfx.PutPixel( 6 + x,45 + y,0,146,14 );
	gfx.PutPixel( 7 + x,45 + y,0,146,14 );
	gfx.PutPixel( 8 + x,45 + y,0,146,14 );
	gfx.PutPixel( 9 + x,45 + y,0,146,14 );
	gfx.PutPixel( 10 + x,45 + y,0,146,14 );
	gfx.PutPixel( 11 + x,45 + y,0,146,14 );
	gfx.PutPixel( 12 + x,45 + y,0,146,14 );
	gfx.PutPixel( 13 + x,45 + y,0,146,14 );
	gfx.PutPixel( 14 + x,45 + y,0,146,14 );
	gfx.PutPixel( 15 + x,45 + y,0,146,14 );
	gfx.PutPixel( 16 + x,45 + y,0,146,14 );
	gfx.PutPixel( 17 + x,45 + y,0,146,14 );
	gfx.PutPixel( 18 + x,45 + y,0,146,14 );
	gfx.PutPixel( 19 + x,45 + y,0,146,14 );
	gfx.PutPixel( 20 + x,45 + y,0,146,14 );
	gfx.PutPixel( 21 + x,45 + y,0,146,14 );
	gfx.PutPixel( 22 + x,45 + y,0,146,14 );
	gfx.PutPixel( 23 + x,45 + y,0,146,14 );
	gfx.PutPixel( 24 + x,45 + y,0,146,14 );
	gfx.PutPixel( 25 + x,45 + y,0,146,14 );
	gfx.PutPixel( 26 + x,45 + y,0,146,14 );
	gfx.PutPixel( 27 + x,45 + y,0,118,11 );
	gfx.PutPixel( 38 + x,45 + y,0,146,14 );
	gfx.PutPixel( 39 + x,45 + y,0,146,14 );
	gfx.PutPixel( 40 + x,45 + y,0,146,14 );
	gfx.PutPixel( 78 + x,45 + y,0,146,14 );
	gfx.PutPixel( 79 + x,45 + y,0,146,14 );
	gfx.PutPixel( 80 + x,45 + y,0,146,14 );
	gfx.PutPixel( 0 + x,46 + y,0,146,14 );
	gfx.PutPixel( 1 + x,46 + y,0,146,14 );
	gfx.PutPixel( 2 + x,46 + y,0,146,14 );
	gfx.PutPixel( 3 + x,46 + y,0,146,14 );
	gfx.PutPixel( 4 + x,46 + y,0,146,14 );
	gfx.PutPixel( 5 + x,46 + y,0,146,14 );
	gfx.PutPixel( 6 + x,46 + y,0,146,14 );
	gfx.PutPixel( 7 + x,46 + y,0,146,14 );
	gfx.PutPixel( 8 + x,46 + y,0,146,14 );
	gfx.PutPixel( 9 + x,46 + y,0,146,14 );
	gfx.PutPixel( 10 + x,46 + y,0,146,14 );
	gfx.PutPixel( 11 + x,46 + y,0,146,14 );
	gfx.PutPixel( 12 + x,46 + y,0,146,14 );
	gfx.PutPixel( 13 + x,46 + y,0,146,14 );
	gfx.PutPixel( 14 + x,46 + y,0,146,14 );
	gfx.PutPixel( 15 + x,46 + y,0,146,14 );
	gfx.PutPixel( 16 + x,46 + y,0,146,14 );
	gfx.PutPixel( 17 + x,46 + y,0,146,14 );
	gfx.PutPixel( 18 + x,46 + y,0,146,14 );
	gfx.PutPixel( 19 + x,46 + y,0,146,14 );
	gfx.PutPixel( 20 + x,46 + y,0,146,14 );
	gfx.PutPixel( 21 + x,46 + y,0,146,14 );
	gfx.PutPixel( 22 + x,46 + y,0,146,14 );
	gfx.PutPixel( 23 + x,46 + y,0,146,14 );
	gfx.PutPixel( 24 + x,46 + y,0,146,14 );
	gfx.PutPixel( 25 + x,46 + y,0,146,14 );
	gfx.PutPixel( 26 + x,46 + y,0,146,14 );
	gfx.PutPixel( 27 + x,46 + y,0,146,14 );
	gfx.PutPixel( 38 + x,46 + y,0,146,14 );
	gfx.PutPixel( 39 + x,46 + y,0,146,14 );
	gfx.PutPixel( 40 + x,46 + y,0,146,14 );
	gfx.PutPixel( 77 + x,46 + y,0,118,11 );
	gfx.PutPixel( 78 + x,46 + y,0,146,14 );
	gfx.PutPixel( 79 + x,46 + y,0,146,14 );
	gfx.PutPixel( 80 + x,46 + y,0,146,14 );
	gfx.PutPixel( 0 + x,47 + y,0,146,14 );
	gfx.PutPixel( 1 + x,47 + y,0,146,14 );
	gfx.PutPixel( 2 + x,47 + y,0,146,14 );
	gfx.PutPixel( 3 + x,47 + y,0,146,14 );
	gfx.PutPixel( 4 + x,47 + y,0,146,14 );
	gfx.PutPixel( 5 + x,47 + y,0,146,14 );
	gfx.PutPixel( 6 + x,47 + y,0,146,14 );
	gfx.PutPixel( 7 + x,47 + y,0,146,14 );
	gfx.PutPixel( 8 + x,47 + y,0,146,14 );
	gfx.PutPixel( 9 + x,47 + y,0,146,14 );
	gfx.PutPixel( 10 + x,47 + y,0,146,14 );
	gfx.PutPixel( 11 + x,47 + y,0,146,14 );
	gfx.PutPixel( 12 + x,47 + y,0,146,14 );
	gfx.PutPixel( 13 + x,47 + y,0,146,14 );
	gfx.PutPixel( 14 + x,47 + y,0,146,14 );
	gfx.PutPixel( 15 + x,47 + y,0,146,14 );
	gfx.PutPixel( 16 + x,47 + y,0,146,14 );
	gfx.PutPixel( 17 + x,47 + y,0,146,14 );
	gfx.PutPixel( 18 + x,47 + y,0,146,14 );
	gfx.PutPixel( 19 + x,47 + y,0,146,14 );
	gfx.PutPixel( 20 + x,47 + y,0,146,14 );
	gfx.PutPixel( 21 + x,47 + y,0,146,14 );
	gfx.PutPixel( 22 + x,47 + y,0,146,14 );
	gfx.PutPixel( 23 + x,47 + y,0,146,14 );
	gfx.PutPixel( 24 + x,47 + y,0,146,14 );
	gfx.PutPixel( 25 + x,47 + y,0,146,14 );
	gfx.PutPixel( 26 + x,47 + y,0,146,14 );
	gfx.PutPixel( 27 + x,47 + y,0,146,14 );
	gfx.PutPixel( 38 + x,47 + y,0,146,14 );
	gfx.PutPixel( 39 + x,47 + y,0,146,14 );
	gfx.PutPixel( 40 + x,47 + y,0,146,14 );
	gfx.PutPixel( 41 + x,47 + y,0,146,14 );
	gfx.PutPixel( 77 + x,47 + y,0,146,14 );
	gfx.PutPixel( 78 + x,47 + y,0,146,14 );
	gfx.PutPixel( 79 + x,47 + y,0,146,14 );
	gfx.PutPixel( 0 + x,48 + y,0,146,14 );
	gfx.PutPixel( 1 + x,48 + y,0,146,14 );
	gfx.PutPixel( 2 + x,48 + y,0,146,14 );
	gfx.PutPixel( 3 + x,48 + y,0,146,14 );
	gfx.PutPixel( 4 + x,48 + y,0,146,14 );
	gfx.PutPixel( 5 + x,48 + y,0,146,14 );
	gfx.PutPixel( 6 + x,48 + y,0,146,14 );
	gfx.PutPixel( 7 + x,48 + y,0,146,14 );
	gfx.PutPixel( 8 + x,48 + y,0,146,14 );
	gfx.PutPixel( 9 + x,48 + y,0,146,14 );
	gfx.PutPixel( 10 + x,48 + y,0,146,14 );
	gfx.PutPixel( 11 + x,48 + y,0,146,14 );
	gfx.PutPixel( 12 + x,48 + y,0,146,14 );
	gfx.PutPixel( 13 + x,48 + y,0,146,14 );
	gfx.PutPixel( 14 + x,48 + y,0,146,14 );
	gfx.PutPixel( 15 + x,48 + y,0,146,14 );
	gfx.PutPixel( 16 + x,48 + y,0,146,14 );
	gfx.PutPixel( 17 + x,48 + y,0,146,14 );
	gfx.PutPixel( 18 + x,48 + y,0,146,14 );
	gfx.PutPixel( 19 + x,48 + y,0,146,14 );
	gfx.PutPixel( 20 + x,48 + y,0,146,14 );
	gfx.PutPixel( 21 + x,48 + y,0,146,14 );
	gfx.PutPixel( 22 + x,48 + y,0,146,14 );
	gfx.PutPixel( 23 + x,48 + y,0,146,14 );
	gfx.PutPixel( 24 + x,48 + y,0,146,14 );
	gfx.PutPixel( 25 + x,48 + y,0,146,14 );
	gfx.PutPixel( 26 + x,48 + y,0,146,14 );
	gfx.PutPixel( 39 + x,48 + y,0,146,14 );
	gfx.PutPixel( 40 + x,48 + y,0,146,14 );
	gfx.PutPixel( 41 + x,48 + y,0,146,14 );
	gfx.PutPixel( 42 + x,48 + y,0,146,14 );
	gfx.PutPixel( 43 + x,48 + y,0,146,14 );
	gfx.PutPixel( 44 + x,48 + y,0,146,14 );
	gfx.PutPixel( 45 + x,48 + y,0,146,14 );
	gfx.PutPixel( 46 + x,48 + y,0,146,14 );
	gfx.PutPixel( 47 + x,48 + y,0,146,14 );
	gfx.PutPixel( 48 + x,48 + y,0,146,14 );
	gfx.PutPixel( 49 + x,48 + y,0,146,14 );
	gfx.PutPixel( 50 + x,48 + y,0,146,14 );
	gfx.PutPixel( 51 + x,48 + y,0,146,14 );
	gfx.PutPixel( 52 + x,48 + y,0,146,14 );
	gfx.PutPixel( 53 + x,48 + y,0,146,14 );
	gfx.PutPixel( 54 + x,48 + y,0,146,14 );
	gfx.PutPixel( 55 + x,48 + y,0,146,14 );
	gfx.PutPixel( 56 + x,48 + y,0,146,14 );
	gfx.PutPixel( 57 + x,48 + y,0,146,14 );
	gfx.PutPixel( 58 + x,48 + y,0,146,14 );
	gfx.PutPixel( 59 + x,48 + y,0,146,14 );
	gfx.PutPixel( 60 + x,48 + y,0,146,14 );
	gfx.PutPixel( 61 + x,48 + y,0,146,14 );
	gfx.PutPixel( 62 + x,48 + y,0,146,14 );
	gfx.PutPixel( 63 + x,48 + y,0,146,14 );
	gfx.PutPixel( 64 + x,48 + y,0,146,14 );
	gfx.PutPixel( 65 + x,48 + y,0,146,14 );
	gfx.PutPixel( 66 + x,48 + y,0,146,14 );
	gfx.PutPixel( 67 + x,48 + y,0,146,14 );
	gfx.PutPixel( 68 + x,48 + y,0,146,14 );
	gfx.PutPixel( 69 + x,48 + y,0,146,14 );
	gfx.PutPixel( 70 + x,48 + y,0,146,14 );
	gfx.PutPixel( 71 + x,48 + y,0,146,14 );
	gfx.PutPixel( 72 + x,48 + y,0,146,14 );
	gfx.PutPixel( 73 + x,48 + y,0,146,14 );
	gfx.PutPixel( 74 + x,48 + y,0,146,14 );
	gfx.PutPixel( 75 + x,48 + y,0,146,14 );
	gfx.PutPixel( 76 + x,48 + y,0,146,14 );
	gfx.PutPixel( 77 + x,48 + y,0,146,14 );
	gfx.PutPixel( 78 + x,48 + y,0,146,14 );
	gfx.PutPixel( 79 + x,48 + y,0,146,14 );
	gfx.PutPixel( 0 + x,49 + y,0,142,13 );
	gfx.PutPixel( 1 + x,49 + y,0,146,14 );
	gfx.PutPixel( 2 + x,49 + y,0,146,14 );
	gfx.PutPixel( 3 + x,49 + y,0,146,14 );
	gfx.PutPixel( 4 + x,49 + y,0,146,14 );
	gfx.PutPixel( 5 + x,49 + y,0,146,14 );
	gfx.PutPixel( 6 + x,49 + y,0,146,14 );
	gfx.PutPixel( 7 + x,49 + y,0,146,14 );
	gfx.PutPixel( 8 + x,49 + y,0,146,14 );
	gfx.PutPixel( 9 + x,49 + y,0,146,14 );
	gfx.PutPixel( 10 + x,49 + y,0,146,14 );
	gfx.PutPixel( 11 + x,49 + y,0,146,14 );
	gfx.PutPixel( 12 + x,49 + y,0,146,14 );
	gfx.PutPixel( 13 + x,49 + y,0,146,14 );
	gfx.PutPixel( 14 + x,49 + y,0,146,14 );
	gfx.PutPixel( 15 + x,49 + y,0,146,14 );
	gfx.PutPixel( 16 + x,49 + y,0,146,14 );
	gfx.PutPixel( 17 + x,49 + y,0,146,14 );
	gfx.PutPixel( 18 + x,49 + y,0,146,14 );
	gfx.PutPixel( 19 + x,49 + y,0,146,14 );
	gfx.PutPixel( 20 + x,49 + y,0,146,14 );
	gfx.PutPixel( 21 + x,49 + y,0,146,14 );
	gfx.PutPixel( 22 + x,49 + y,0,146,14 );
	gfx.PutPixel( 23 + x,49 + y,0,146,14 );
	gfx.PutPixel( 24 + x,49 + y,0,146,14 );
	gfx.PutPixel( 25 + x,49 + y,0,146,14 );
	gfx.PutPixel( 26 + x,49 + y,0,146,14 );
	gfx.PutPixel( 40 + x,49 + y,0,146,14 );
	gfx.PutPixel( 41 + x,49 + y,0,146,14 );
	gfx.PutPixel( 42 + x,49 + y,0,146,14 );
	gfx.PutPixel( 43 + x,49 + y,0,146,14 );
	gfx.PutPixel( 44 + x,49 + y,0,146,14 );
	gfx.PutPixel( 45 + x,49 + y,0,146,14 );
	gfx.PutPixel( 46 + x,49 + y,0,146,14 );
	gfx.PutPixel( 47 + x,49 + y,0,146,14 );
	gfx.PutPixel( 48 + x,49 + y,0,146,14 );
	gfx.PutPixel( 49 + x,49 + y,0,146,14 );
	gfx.PutPixel( 50 + x,49 + y,0,146,14 );
	gfx.PutPixel( 51 + x,49 + y,0,146,14 );
	gfx.PutPixel( 52 + x,49 + y,0,146,14 );
	gfx.PutPixel( 53 + x,49 + y,0,146,14 );
	gfx.PutPixel( 54 + x,49 + y,0,146,14 );
	gfx.PutPixel( 55 + x,49 + y,0,146,14 );
	gfx.PutPixel( 56 + x,49 + y,0,146,14 );
	gfx.PutPixel( 57 + x,49 + y,0,146,14 );
	gfx.PutPixel( 58 + x,49 + y,0,146,14 );
	gfx.PutPixel( 59 + x,49 + y,0,146,14 );
	gfx.PutPixel( 60 + x,49 + y,0,146,14 );
	gfx.PutPixel( 61 + x,49 + y,0,146,14 );
	gfx.PutPixel( 62 + x,49 + y,0,146,14 );
	gfx.PutPixel( 63 + x,49 + y,0,146,14 );
	gfx.PutPixel( 64 + x,49 + y,0,146,14 );
	gfx.PutPixel( 65 + x,49 + y,0,146,14 );
	gfx.PutPixel( 66 + x,49 + y,0,146,14 );
	gfx.PutPixel( 67 + x,49 + y,0,146,14 );
	gfx.PutPixel( 68 + x,49 + y,0,146,14 );
	gfx.PutPixel( 69 + x,49 + y,0,146,14 );
	gfx.PutPixel( 70 + x,49 + y,0,146,14 );
	gfx.PutPixel( 71 + x,49 + y,0,146,14 );
	gfx.PutPixel( 72 + x,49 + y,0,146,14 );
	gfx.PutPixel( 73 + x,49 + y,0,146,14 );
	gfx.PutPixel( 74 + x,49 + y,0,146,14 );
	gfx.PutPixel( 75 + x,49 + y,0,146,14 );
	gfx.PutPixel( 76 + x,49 + y,0,146,14 );
	gfx.PutPixel( 77 + x,49 + y,0,146,14 );
	gfx.PutPixel( 78 + x,49 + y,0,146,14 );
	gfx.PutPixel( 2 + x,50 + y,0,146,14 );
	gfx.PutPixel( 3 + x,50 + y,0,146,14 );
	gfx.PutPixel( 4 + x,50 + y,0,146,14 );
	gfx.PutPixel( 5 + x,50 + y,0,146,14 );
	gfx.PutPixel( 6 + x,50 + y,0,146,14 );
	gfx.PutPixel( 7 + x,50 + y,0,146,14 );
	gfx.PutPixel( 8 + x,50 + y,0,146,14 );
	gfx.PutPixel( 9 + x,50 + y,0,146,14 );
	gfx.PutPixel( 10 + x,50 + y,0,146,14 );
	gfx.PutPixel( 11 + x,50 + y,0,146,14 );
	gfx.PutPixel( 12 + x,50 + y,0,146,14 );
	gfx.PutPixel( 13 + x,50 + y,0,146,14 );
	gfx.PutPixel( 14 + x,50 + y,0,146,14 );
	gfx.PutPixel( 15 + x,50 + y,0,146,14 );
	gfx.PutPixel( 16 + x,50 + y,0,146,14 );
	gfx.PutPixel( 17 + x,50 + y,0,146,14 );
	gfx.PutPixel( 18 + x,50 + y,0,146,14 );
	gfx.PutPixel( 19 + x,50 + y,0,146,14 );
	gfx.PutPixel( 20 + x,50 + y,0,146,14 );
	gfx.PutPixel( 21 + x,50 + y,0,146,14 );
	gfx.PutPixel( 22 + x,50 + y,0,146,14 );
	gfx.PutPixel( 23 + x,50 + y,0,146,14 );
	gfx.PutPixel( 24 + x,50 + y,0,146,14 );
	gfx.PutPixel( 25 + x,50 + y,0,142,13 );
	gfx.PutPixel( 41 + x,50 + y,0,146,14 );
	gfx.PutPixel( 42 + x,50 + y,0,146,14 );
	gfx.PutPixel( 43 + x,50 + y,0,146,14 );
	gfx.PutPixel( 44 + x,50 + y,0,146,14 );
	gfx.PutPixel( 45 + x,50 + y,0,146,14 );
	gfx.PutPixel( 46 + x,50 + y,0,146,14 );
	gfx.PutPixel( 47 + x,50 + y,0,146,14 );
	gfx.PutPixel( 48 + x,50 + y,0,146,14 );
	gfx.PutPixel( 49 + x,50 + y,0,146,14 );
	gfx.PutPixel( 50 + x,50 + y,0,146,14 );
	gfx.PutPixel( 51 + x,50 + y,0,146,14 );
	gfx.PutPixel( 52 + x,50 + y,0,146,14 );
	gfx.PutPixel( 53 + x,50 + y,0,146,14 );
	gfx.PutPixel( 54 + x,50 + y,0,146,14 );
	gfx.PutPixel( 55 + x,50 + y,0,146,14 );
	gfx.PutPixel( 56 + x,50 + y,0,146,14 );
	gfx.PutPixel( 57 + x,50 + y,0,146,14 );
	gfx.PutPixel( 58 + x,50 + y,0,146,14 );
	gfx.PutPixel( 59 + x,50 + y,0,146,14 );
	gfx.PutPixel( 60 + x,50 + y,0,146,14 );
	gfx.PutPixel( 61 + x,50 + y,0,146,14 );
	gfx.PutPixel( 62 + x,50 + y,0,146,14 );
	gfx.PutPixel( 63 + x,50 + y,0,146,14 );
	gfx.PutPixel( 64 + x,50 + y,0,146,14 );
	gfx.PutPixel( 65 + x,50 + y,0,146,14 );
	gfx.PutPixel( 66 + x,50 + y,0,146,14 );
	gfx.PutPixel( 67 + x,50 + y,0,146,14 );
	gfx.PutPixel( 68 + x,50 + y,0,146,14 );
	gfx.PutPixel( 69 + x,50 + y,0,146,14 );
	gfx.PutPixel( 70 + x,50 + y,0,146,14 );
	gfx.PutPixel( 71 + x,50 + y,0,146,14 );
	gfx.PutPixel( 72 + x,50 + y,0,146,14 );
	gfx.PutPixel( 73 + x,50 + y,0,146,14 );
	gfx.PutPixel( 74 + x,50 + y,0,146,14 );
	gfx.PutPixel( 75 + x,50 + y,0,146,14 );
	gfx.PutPixel( 76 + x,50 + y,0,146,14 );
	gfx.PutPixel( 2 + x,55 + y,0,146,14 );
	gfx.PutPixel( 3 + x,55 + y,0,146,14 );
	gfx.PutPixel( 4 + x,55 + y,0,146,14 );
	gfx.PutPixel( 5 + x,55 + y,0,146,14 );
	gfx.PutPixel( 6 + x,55 + y,0,146,14 );
	gfx.PutPixel( 7 + x,55 + y,0,146,14 );
	gfx.PutPixel( 12 + x,55 + y,0,146,14 );
	gfx.PutPixel( 13 + x,55 + y,0,146,14 );
	gfx.PutPixel( 14 + x,55 + y,0,146,14 );
	gfx.PutPixel( 19 + x,55 + y,0,146,14 );
	gfx.PutPixel( 20 + x,55 + y,0,146,14 );
	gfx.PutPixel( 25 + x,55 + y,0,146,14 );
	gfx.PutPixel( 26 + x,55 + y,0,146,14 );
	gfx.PutPixel( 28 + x,55 + y,0,146,14 );
	gfx.PutPixel( 29 + x,55 + y,0,146,14 );
	gfx.PutPixel( 30 + x,55 + y,0,146,14 );
	gfx.PutPixel( 31 + x,55 + y,0,146,14 );
	gfx.PutPixel( 32 + x,55 + y,0,146,14 );
	gfx.PutPixel( 33 + x,55 + y,0,146,14 );
	gfx.PutPixel( 34 + x,55 + y,0,146,14 );
	gfx.PutPixel( 35 + x,55 + y,0,146,14 );
	gfx.PutPixel( 36 + x,55 + y,0,146,14 );
	gfx.PutPixel( 48 + x,55 + y,0,118,11 );
	gfx.PutPixel( 49 + x,55 + y,0,146,14 );
	gfx.PutPixel( 50 + x,55 + y,0,146,14 );
	gfx.PutPixel( 51 + x,55 + y,0,146,14 );
	gfx.PutPixel( 52 + x,55 + y,0,146,14 );
	gfx.PutPixel( 53 + x,55 + y,0,146,14 );
	gfx.PutPixel( 54 + x,55 + y,0,146,14 );
	gfx.PutPixel( 57 + x,55 + y,0,146,14 );
	gfx.PutPixel( 58 + x,55 + y,0,146,14 );
	gfx.PutPixel( 63 + x,55 + y,0,146,14 );
	gfx.PutPixel( 64 + x,55 + y,0,146,14 );
	gfx.PutPixel( 66 + x,55 + y,0,3,0 );
	gfx.PutPixel( 67 + x,55 + y,0,146,14 );
	gfx.PutPixel( 68 + x,55 + y,0,146,14 );
	gfx.PutPixel( 69 + x,55 + y,0,146,14 );
	gfx.PutPixel( 70 + x,55 + y,0,146,14 );
	gfx.PutPixel( 71 + x,55 + y,0,146,14 );
	gfx.PutPixel( 72 + x,55 + y,0,146,14 );
	gfx.PutPixel( 73 + x,55 + y,0,146,14 );
	gfx.PutPixel( 74 + x,55 + y,0,146,14 );
	gfx.PutPixel( 76 + x,55 + y,0,146,14 );
	gfx.PutPixel( 77 + x,55 + y,0,146,14 );
	gfx.PutPixel( 78 + x,55 + y,0,146,14 );
	gfx.PutPixel( 79 + x,55 + y,0,146,14 );
	gfx.PutPixel( 80 + x,55 + y,0,146,14 );
	gfx.PutPixel( 81 + x,55 + y,0,146,14 );
	gfx.PutPixel( 82 + x,55 + y,0,146,14 );
	gfx.PutPixel( 1 + x,56 + y,0,146,14 );
	gfx.PutPixel( 2 + x,56 + y,0,146,14 );
	gfx.PutPixel( 3 + x,56 + y,0,146,14 );
	gfx.PutPixel( 4 + x,56 + y,0,146,14 );
	gfx.PutPixel( 5 + x,56 + y,0,146,14 );
	gfx.PutPixel( 6 + x,56 + y,0,146,14 );
	gfx.PutPixel( 7 + x,56 + y,0,146,14 );
	gfx.PutPixel( 11 + x,56 + y,0,146,14 );
	gfx.PutPixel( 12 + x,56 + y,0,146,14 );
	gfx.PutPixel( 13 + x,56 + y,0,146,14 );
	gfx.PutPixel( 14 + x,56 + y,0,146,14 );
	gfx.PutPixel( 15 + x,56 + y,0,146,14 );
	gfx.PutPixel( 16 + x,56 + y,0,142,13 );
	gfx.PutPixel( 19 + x,56 + y,0,146,14 );
	gfx.PutPixel( 20 + x,56 + y,0,146,14 );
	gfx.PutPixel( 21 + x,56 + y,0,146,14 );
	gfx.PutPixel( 24 + x,56 + y,0,146,14 );
	gfx.PutPixel( 25 + x,56 + y,0,146,14 );
	gfx.PutPixel( 26 + x,56 + y,0,146,14 );
	gfx.PutPixel( 28 + x,56 + y,0,146,14 );
	gfx.PutPixel( 29 + x,56 + y,0,146,14 );
	gfx.PutPixel( 30 + x,56 + y,0,146,14 );
	gfx.PutPixel( 31 + x,56 + y,0,146,14 );
	gfx.PutPixel( 32 + x,56 + y,0,146,14 );
	gfx.PutPixel( 33 + x,56 + y,0,146,14 );
	gfx.PutPixel( 34 + x,56 + y,0,146,14 );
	gfx.PutPixel( 35 + x,56 + y,0,146,14 );
	gfx.PutPixel( 36 + x,56 + y,0,142,13 );
	gfx.PutPixel( 47 + x,56 + y,0,146,14 );
	gfx.PutPixel( 48 + x,56 + y,0,146,14 );
	gfx.PutPixel( 49 + x,56 + y,0,146,14 );
	gfx.PutPixel( 50 + x,56 + y,0,25,2 );
	gfx.PutPixel( 51 + x,56 + y,0,25,2 );
	gfx.PutPixel( 52 + x,56 + y,0,146,14 );
	gfx.PutPixel( 53 + x,56 + y,0,146,14 );
	gfx.PutPixel( 54 + x,56 + y,0,146,14 );
	gfx.PutPixel( 55 + x,56 + y,0,146,14 );
	gfx.PutPixel( 57 + x,56 + y,0,146,14 );
	gfx.PutPixel( 58 + x,56 + y,0,146,14 );
	gfx.PutPixel( 63 + x,56 + y,0,146,14 );
	gfx.PutPixel( 64 + x,56 + y,0,146,14 );
	gfx.PutPixel( 65 + x,56 + y,0,146,14 );
	gfx.PutPixel( 66 + x,56 + y,0,146,14 );
	gfx.PutPixel( 67 + x,56 + y,0,146,14 );
	gfx.PutPixel( 68 + x,56 + y,0,146,14 );
	gfx.PutPixel( 69 + x,56 + y,0,146,14 );
	gfx.PutPixel( 70 + x,56 + y,0,146,14 );
	gfx.PutPixel( 71 + x,56 + y,0,146,14 );
	gfx.PutPixel( 72 + x,56 + y,0,146,14 );
	gfx.PutPixel( 73 + x,56 + y,0,146,14 );
	gfx.PutPixel( 74 + x,56 + y,0,146,14 );
	gfx.PutPixel( 76 + x,56 + y,0,146,14 );
	gfx.PutPixel( 77 + x,56 + y,0,146,14 );
	gfx.PutPixel( 78 + x,56 + y,0,146,14 );
	gfx.PutPixel( 79 + x,56 + y,0,25,2 );
	gfx.PutPixel( 80 + x,56 + y,0,146,14 );
	gfx.PutPixel( 81 + x,56 + y,0,146,14 );
	gfx.PutPixel( 82 + x,56 + y,0,146,14 );
	gfx.PutPixel( 83 + x,56 + y,0,146,14 );
	gfx.PutPixel( 0 + x,57 + y,0,146,14 );
	gfx.PutPixel( 1 + x,57 + y,0,146,14 );
	gfx.PutPixel( 9 + x,57 + y,0,25,2 );
	gfx.PutPixel( 10 + x,57 + y,0,146,14 );
	gfx.PutPixel( 11 + x,57 + y,0,146,14 );
	gfx.PutPixel( 15 + x,57 + y,0,146,14 );
	gfx.PutPixel( 16 + x,57 + y,0,146,14 );
	gfx.PutPixel( 17 + x,57 + y,0,118,11 );
	gfx.PutPixel( 19 + x,57 + y,0,146,14 );
	gfx.PutPixel( 20 + x,57 + y,0,146,14 );
	gfx.PutPixel( 21 + x,57 + y,0,146,14 );
	gfx.PutPixel( 22 + x,57 + y,0,146,14 );
	gfx.PutPixel( 23 + x,57 + y,0,146,14 );
	gfx.PutPixel( 24 + x,57 + y,0,146,14 );
	gfx.PutPixel( 25 + x,57 + y,0,146,14 );
	gfx.PutPixel( 26 + x,57 + y,0,146,14 );
	gfx.PutPixel( 28 + x,57 + y,0,146,14 );
	gfx.PutPixel( 29 + x,57 + y,0,146,14 );
	gfx.PutPixel( 30 + x,57 + y,0,146,14 );
	gfx.PutPixel( 47 + x,57 + y,0,146,14 );
	gfx.PutPixel( 48 + x,57 + y,0,146,14 );
	gfx.PutPixel( 49 + x,57 + y,0,146,14 );
	gfx.PutPixel( 54 + x,57 + y,0,146,14 );
	gfx.PutPixel( 55 + x,57 + y,0,146,14 );
	gfx.PutPixel( 57 + x,57 + y,0,146,14 );
	gfx.PutPixel( 58 + x,57 + y,0,146,14 );
	gfx.PutPixel( 63 + x,57 + y,0,146,14 );
	gfx.PutPixel( 64 + x,57 + y,0,146,14 );
	gfx.PutPixel( 65 + x,57 + y,0,25,2 );
	gfx.PutPixel( 66 + x,57 + y,0,146,14 );
	gfx.PutPixel( 67 + x,57 + y,0,146,14 );
	gfx.PutPixel( 68 + x,57 + y,0,146,14 );
	gfx.PutPixel( 76 + x,57 + y,0,146,14 );
	gfx.PutPixel( 77 + x,57 + y,0,146,14 );
	gfx.PutPixel( 82 + x,57 + y,0,146,14 );
	gfx.PutPixel( 83 + x,57 + y,0,146,14 );
	gfx.PutPixel( 0 + x,58 + y,0,146,14 );
	gfx.PutPixel( 1 + x,58 + y,0,146,14 );
	gfx.PutPixel( 9 + x,58 + y,0,146,14 );
	gfx.PutPixel( 10 + x,58 + y,0,146,14 );
	gfx.PutPixel( 11 + x,58 + y,0,118,11 );
	gfx.PutPixel( 15 + x,58 + y,0,25,2 );
	gfx.PutPixel( 16 + x,58 + y,0,146,14 );
	gfx.PutPixel( 17 + x,58 + y,0,146,14 );
	gfx.PutPixel( 19 + x,58 + y,0,146,14 );
	gfx.PutPixel( 20 + x,58 + y,0,146,14 );
	gfx.PutPixel( 21 + x,58 + y,0,146,14 );
	gfx.PutPixel( 22 + x,58 + y,0,146,14 );
	gfx.PutPixel( 23 + x,58 + y,0,146,14 );
	gfx.PutPixel( 24 + x,58 + y,0,146,14 );
	gfx.PutPixel( 25 + x,58 + y,0,146,14 );
	gfx.PutPixel( 26 + x,58 + y,0,146,14 );
	gfx.PutPixel( 28 + x,58 + y,0,146,14 );
	gfx.PutPixel( 29 + x,58 + y,0,146,14 );
	gfx.PutPixel( 30 + x,58 + y,0,146,14 );
	gfx.PutPixel( 47 + x,58 + y,0,146,14 );
	gfx.PutPixel( 48 + x,58 + y,0,146,14 );
	gfx.PutPixel( 49 + x,58 + y,0,146,14 );
	gfx.PutPixel( 54 + x,58 + y,0,146,14 );
	gfx.PutPixel( 55 + x,58 + y,0,146,14 );
	gfx.PutPixel( 57 + x,58 + y,0,146,14 );
	gfx.PutPixel( 58 + x,58 + y,0,146,14 );
	gfx.PutPixel( 63 + x,58 + y,0,146,14 );
	gfx.PutPixel( 64 + x,58 + y,0,146,14 );
	gfx.PutPixel( 65 + x,58 + y,0,25,2 );
	gfx.PutPixel( 66 + x,58 + y,0,146,14 );
	gfx.PutPixel( 67 + x,58 + y,0,146,14 );
	gfx.PutPixel( 68 + x,58 + y,0,146,14 );
	gfx.PutPixel( 76 + x,58 + y,0,146,14 );
	gfx.PutPixel( 77 + x,58 + y,0,146,14 );
	gfx.PutPixel( 82 + x,58 + y,0,146,14 );
	gfx.PutPixel( 83 + x,58 + y,0,146,14 );
	gfx.PutPixel( 0 + x,59 + y,0,146,14 );
	gfx.PutPixel( 1 + x,59 + y,0,146,14 );
	gfx.PutPixel( 5 + x,59 + y,0,146,14 );
	gfx.PutPixel( 6 + x,59 + y,0,146,14 );
	gfx.PutPixel( 7 + x,59 + y,0,146,14 );
	gfx.PutPixel( 9 + x,59 + y,0,146,14 );
	gfx.PutPixel( 10 + x,59 + y,0,146,14 );
	gfx.PutPixel( 11 + x,59 + y,0,25,2 );
	gfx.PutPixel( 15 + x,59 + y,0,70,6 );
	gfx.PutPixel( 16 + x,59 + y,0,146,14 );
	gfx.PutPixel( 17 + x,59 + y,0,146,14 );
	gfx.PutPixel( 19 + x,59 + y,0,146,14 );
	gfx.PutPixel( 20 + x,59 + y,0,146,14 );
	gfx.PutPixel( 22 + x,59 + y,0,146,14 );
	gfx.PutPixel( 23 + x,59 + y,0,146,14 );
	gfx.PutPixel( 24 + x,59 + y,0,25,2 );
	gfx.PutPixel( 25 + x,59 + y,0,146,14 );
	gfx.PutPixel( 26 + x,59 + y,0,146,14 );
	gfx.PutPixel( 28 + x,59 + y,0,146,14 );
	gfx.PutPixel( 29 + x,59 + y,0,146,14 );
	gfx.PutPixel( 30 + x,59 + y,0,146,14 );
	gfx.PutPixel( 31 + x,59 + y,0,146,14 );
	gfx.PutPixel( 32 + x,59 + y,0,146,14 );
	gfx.PutPixel( 33 + x,59 + y,0,146,14 );
	gfx.PutPixel( 34 + x,59 + y,0,146,14 );
	gfx.PutPixel( 35 + x,59 + y,0,146,14 );
	gfx.PutPixel( 47 + x,59 + y,0,146,14 );
	gfx.PutPixel( 48 + x,59 + y,0,146,14 );
	gfx.PutPixel( 49 + x,59 + y,0,146,14 );
	gfx.PutPixel( 54 + x,59 + y,0,146,14 );
	gfx.PutPixel( 55 + x,59 + y,0,146,14 );
	gfx.PutPixel( 57 + x,59 + y,0,146,14 );
	gfx.PutPixel( 58 + x,59 + y,0,146,14 );
	gfx.PutPixel( 59 + x,59 + y,0,146,14 );
	gfx.PutPixel( 63 + x,59 + y,0,146,14 );
	gfx.PutPixel( 64 + x,59 + y,0,146,14 );
	gfx.PutPixel( 65 + x,59 + y,0,25,2 );
	gfx.PutPixel( 66 + x,59 + y,0,146,14 );
	gfx.PutPixel( 67 + x,59 + y,0,146,14 );
	gfx.PutPixel( 68 + x,59 + y,0,146,14 );
	gfx.PutPixel( 69 + x,59 + y,0,146,14 );
	gfx.PutPixel( 70 + x,59 + y,0,146,14 );
	gfx.PutPixel( 71 + x,59 + y,0,146,14 );
	gfx.PutPixel( 72 + x,59 + y,0,146,14 );
	gfx.PutPixel( 73 + x,59 + y,0,146,14 );
	gfx.PutPixel( 76 + x,59 + y,0,146,14 );
	gfx.PutPixel( 77 + x,59 + y,0,146,14 );
	gfx.PutPixel( 82 + x,59 + y,0,146,14 );
	gfx.PutPixel( 83 + x,59 + y,0,146,14 );
	gfx.PutPixel( 0 + x,60 + y,0,146,14 );
	gfx.PutPixel( 1 + x,60 + y,0,146,14 );
	gfx.PutPixel( 6 + x,60 + y,0,146,14 );
	gfx.PutPixel( 7 + x,60 + y,0,146,14 );
	gfx.PutPixel( 9 + x,60 + y,0,146,14 );
	gfx.PutPixel( 10 + x,60 + y,0,146,14 );
	gfx.PutPixel( 11 + x,60 + y,0,146,14 );
	gfx.PutPixel( 12 + x,60 + y,0,146,14 );
	gfx.PutPixel( 13 + x,60 + y,0,146,14 );
	gfx.PutPixel( 14 + x,60 + y,0,146,14 );
	gfx.PutPixel( 15 + x,60 + y,0,146,14 );
	gfx.PutPixel( 16 + x,60 + y,0,146,14 );
	gfx.PutPixel( 17 + x,60 + y,0,146,14 );
	gfx.PutPixel( 19 + x,60 + y,0,146,14 );
	gfx.PutPixel( 20 + x,60 + y,0,146,14 );
	gfx.PutPixel( 25 + x,60 + y,0,146,14 );
	gfx.PutPixel( 26 + x,60 + y,0,146,14 );
	gfx.PutPixel( 28 + x,60 + y,0,146,14 );
	gfx.PutPixel( 29 + x,60 + y,0,146,14 );
	gfx.PutPixel( 30 + x,60 + y,0,146,14 );
	gfx.PutPixel( 47 + x,60 + y,0,146,14 );
	gfx.PutPixel( 48 + x,60 + y,0,146,14 );
	gfx.PutPixel( 49 + x,60 + y,0,146,14 );
	gfx.PutPixel( 54 + x,60 + y,0,146,14 );
	gfx.PutPixel( 55 + x,60 + y,0,146,14 );
	gfx.PutPixel( 57 + x,60 + y,0,146,14 );
	gfx.PutPixel( 58 + x,60 + y,0,146,14 );
	gfx.PutPixel( 59 + x,60 + y,0,146,14 );
	gfx.PutPixel( 60 + x,60 + y,0,146,14 );
	gfx.PutPixel( 61 + x,60 + y,0,146,14 );
	gfx.PutPixel( 62 + x,60 + y,0,146,14 );
	gfx.PutPixel( 63 + x,60 + y,0,146,14 );
	gfx.PutPixel( 64 + x,60 + y,0,146,14 );
	gfx.PutPixel( 66 + x,60 + y,0,146,14 );
	gfx.PutPixel( 67 + x,60 + y,0,146,14 );
	gfx.PutPixel( 68 + x,60 + y,0,146,14 );
	gfx.PutPixel( 76 + x,60 + y,0,146,14 );
	gfx.PutPixel( 77 + x,60 + y,0,146,14 );
	gfx.PutPixel( 78 + x,60 + y,0,146,14 );
	gfx.PutPixel( 80 + x,60 + y,0,146,14 );
	gfx.PutPixel( 81 + x,60 + y,0,146,14 );
	gfx.PutPixel( 82 + x,60 + y,0,146,14 );
	gfx.PutPixel( 83 + x,60 + y,0,146,14 );
	gfx.PutPixel( 0 + x,61 + y,0,146,14 );
	gfx.PutPixel( 1 + x,61 + y,0,146,14 );
	gfx.PutPixel( 6 + x,61 + y,0,146,14 );
	gfx.PutPixel( 7 + x,61 + y,0,146,14 );
	gfx.PutPixel( 9 + x,61 + y,0,146,14 );
	gfx.PutPixel( 10 + x,61 + y,0,146,14 );
	gfx.PutPixel( 11 + x,61 + y,0,146,14 );
	gfx.PutPixel( 12 + x,61 + y,0,146,14 );
	gfx.PutPixel( 13 + x,61 + y,0,146,14 );
	gfx.PutPixel( 14 + x,61 + y,0,146,14 );
	gfx.PutPixel( 15 + x,61 + y,0,146,14 );
	gfx.PutPixel( 16 + x,61 + y,0,146,14 );
	gfx.PutPixel( 17 + x,61 + y,0,146,14 );
	gfx.PutPixel( 19 + x,61 + y,0,146,14 );
	gfx.PutPixel( 20 + x,61 + y,0,146,14 );
	gfx.PutPixel( 25 + x,61 + y,0,146,14 );
	gfx.PutPixel( 26 + x,61 + y,0,146,14 );
	gfx.PutPixel( 28 + x,61 + y,0,146,14 );
	gfx.PutPixel( 29 + x,61 + y,0,146,14 );
	gfx.PutPixel( 30 + x,61 + y,0,146,14 );
	gfx.PutPixel( 47 + x,61 + y,0,146,14 );
	gfx.PutPixel( 48 + x,61 + y,0,146,14 );
	gfx.PutPixel( 49 + x,61 + y,0,146,14 );
	gfx.PutPixel( 54 + x,61 + y,0,146,14 );
	gfx.PutPixel( 55 + x,61 + y,0,146,14 );
	gfx.PutPixel( 58 + x,61 + y,0,146,14 );
	gfx.PutPixel( 59 + x,61 + y,0,146,14 );
	gfx.PutPixel( 60 + x,61 + y,0,146,14 );
	gfx.PutPixel( 61 + x,61 + y,0,146,14 );
	gfx.PutPixel( 62 + x,61 + y,0,146,14 );
	gfx.PutPixel( 63 + x,61 + y,0,146,14 );
	gfx.PutPixel( 66 + x,61 + y,0,146,14 );
	gfx.PutPixel( 67 + x,61 + y,0,146,14 );
	gfx.PutPixel( 68 + x,61 + y,0,146,14 );
	gfx.PutPixel( 76 + x,61 + y,0,146,14 );
	gfx.PutPixel( 77 + x,61 + y,0,146,14 );
	gfx.PutPixel( 78 + x,61 + y,0,146,14 );
	gfx.PutPixel( 79 + x,61 + y,0,146,14 );
	gfx.PutPixel( 80 + x,61 + y,0,146,14 );
	gfx.PutPixel( 81 + x,61 + y,0,146,14 );
	gfx.PutPixel( 82 + x,61 + y,0,146,14 );
	gfx.PutPixel( 0 + x,62 + y,0,142,13 );
	gfx.PutPixel( 1 + x,62 + y,0,146,14 );
	gfx.PutPixel( 2 + x,62 + y,0,146,14 );
	gfx.PutPixel( 6 + x,62 + y,0,146,14 );
	gfx.PutPixel( 7 + x,62 + y,0,146,14 );
	gfx.PutPixel( 9 + x,62 + y,0,146,14 );
	gfx.PutPixel( 10 + x,62 + y,0,146,14 );
	gfx.PutPixel( 11 + x,62 + y,0,146,14 );
	gfx.PutPixel( 15 + x,62 + y,0,70,6 );
	gfx.PutPixel( 16 + x,62 + y,0,146,14 );
	gfx.PutPixel( 17 + x,62 + y,0,146,14 );
	gfx.PutPixel( 19 + x,62 + y,0,146,14 );
	gfx.PutPixel( 20 + x,62 + y,0,146,14 );
	gfx.PutPixel( 25 + x,62 + y,0,146,14 );
	gfx.PutPixel( 26 + x,62 + y,0,146,14 );
	gfx.PutPixel( 28 + x,62 + y,0,146,14 );
	gfx.PutPixel( 29 + x,62 + y,0,146,14 );
	gfx.PutPixel( 30 + x,62 + y,0,146,14 );
	gfx.PutPixel( 47 + x,62 + y,0,146,14 );
	gfx.PutPixel( 48 + x,62 + y,0,146,14 );
	gfx.PutPixel( 49 + x,62 + y,0,146,14 );
	gfx.PutPixel( 53 + x,62 + y,0,3,0 );
	gfx.PutPixel( 54 + x,62 + y,0,146,14 );
	gfx.PutPixel( 55 + x,62 + y,0,146,14 );
	gfx.PutPixel( 59 + x,62 + y,0,146,14 );
	gfx.PutPixel( 60 + x,62 + y,0,146,14 );
	gfx.PutPixel( 61 + x,62 + y,0,146,14 );
	gfx.PutPixel( 62 + x,62 + y,0,146,14 );
	gfx.PutPixel( 66 + x,62 + y,0,146,14 );
	gfx.PutPixel( 67 + x,62 + y,0,146,14 );
	gfx.PutPixel( 68 + x,62 + y,0,146,14 );
	gfx.PutPixel( 76 + x,62 + y,0,146,14 );
	gfx.PutPixel( 77 + x,62 + y,0,146,14 );
	gfx.PutPixel( 80 + x,62 + y,0,146,14 );
	gfx.PutPixel( 81 + x,62 + y,0,146,14 );
	gfx.PutPixel( 82 + x,62 + y,0,146,14 );
	gfx.PutPixel( 83 + x,62 + y,0,70,6 );
	gfx.PutPixel( 1 + x,63 + y,0,142,13 );
	gfx.PutPixel( 2 + x,63 + y,0,146,14 );
	gfx.PutPixel( 3 + x,63 + y,0,146,14 );
	gfx.PutPixel( 4 + x,63 + y,0,146,14 );
	gfx.PutPixel( 5 + x,63 + y,0,146,14 );
	gfx.PutPixel( 6 + x,63 + y,0,146,14 );
	gfx.PutPixel( 7 + x,63 + y,0,146,14 );
	gfx.PutPixel( 9 + x,63 + y,0,146,14 );
	gfx.PutPixel( 10 + x,63 + y,0,146,14 );
	gfx.PutPixel( 11 + x,63 + y,0,146,14 );
	gfx.PutPixel( 15 + x,63 + y,0,25,2 );
	gfx.PutPixel( 16 + x,63 + y,0,146,14 );
	gfx.PutPixel( 17 + x,63 + y,0,146,14 );
	gfx.PutPixel( 19 + x,63 + y,0,146,14 );
	gfx.PutPixel( 20 + x,63 + y,0,146,14 );
	gfx.PutPixel( 25 + x,63 + y,0,146,14 );
	gfx.PutPixel( 26 + x,63 + y,0,146,14 );
	gfx.PutPixel( 28 + x,63 + y,0,146,14 );
	gfx.PutPixel( 29 + x,63 + y,0,146,14 );
	gfx.PutPixel( 30 + x,63 + y,0,146,14 );
	gfx.PutPixel( 31 + x,63 + y,0,146,14 );
	gfx.PutPixel( 32 + x,63 + y,0,146,14 );
	gfx.PutPixel( 33 + x,63 + y,0,146,14 );
	gfx.PutPixel( 34 + x,63 + y,0,146,14 );
	gfx.PutPixel( 35 + x,63 + y,0,146,14 );
	gfx.PutPixel( 36 + x,63 + y,0,146,14 );
	gfx.PutPixel( 48 + x,63 + y,0,146,14 );
	gfx.PutPixel( 49 + x,63 + y,0,146,14 );
	gfx.PutPixel( 50 + x,63 + y,0,146,14 );
	gfx.PutPixel( 51 + x,63 + y,0,146,14 );
	gfx.PutPixel( 52 + x,63 + y,0,146,14 );
	gfx.PutPixel( 53 + x,63 + y,0,146,14 );
	gfx.PutPixel( 54 + x,63 + y,0,146,14 );
	gfx.PutPixel( 60 + x,63 + y,0,146,14 );
	gfx.PutPixel( 61 + x,63 + y,0,146,14 );
	gfx.PutPixel( 66 + x,63 + y,0,146,14 );
	gfx.PutPixel( 67 + x,63 + y,0,146,14 );
	gfx.PutPixel( 68 + x,63 + y,0,146,14 );
	gfx.PutPixel( 69 + x,63 + y,0,146,14 );
	gfx.PutPixel( 70 + x,63 + y,0,146,14 );
	gfx.PutPixel( 71 + x,63 + y,0,146,14 );
	gfx.PutPixel( 72 + x,63 + y,0,146,14 );
	gfx.PutPixel( 73 + x,63 + y,0,146,14 );
	gfx.PutPixel( 74 + x,63 + y,0,146,14 );
	gfx.PutPixel( 76 + x,63 + y,0,146,14 );
	gfx.PutPixel( 77 + x,63 + y,0,146,14 );
	gfx.PutPixel( 82 + x,63 + y,0,146,14 );
	gfx.PutPixel( 83 + x,63 + y,0,146,14 );
}

void Game::DrawTitleScreen( int x,int y )
{
	gfx.PutPixel( 0 + x,0 + y,208,34,34 );
	gfx.PutPixel( 1 + x,0 + y,208,34,34 );
	gfx.PutPixel( 2 + x,0 + y,208,34,34 );
	gfx.PutPixel( 3 + x,0 + y,208,34,34 );
	gfx.PutPixel( 4 + x,0 + y,208,34,34 );
	gfx.PutPixel( 5 + x,0 + y,208,34,34 );
	gfx.PutPixel( 6 + x,0 + y,208,34,34 );
	gfx.PutPixel( 7 + x,0 + y,208,34,34 );
	gfx.PutPixel( 8 + x,0 + y,208,34,34 );
	gfx.PutPixel( 9 + x,0 + y,208,34,34 );
	gfx.PutPixel( 10 + x,0 + y,208,34,34 );
	gfx.PutPixel( 11 + x,0 + y,208,34,34 );
	gfx.PutPixel( 12 + x,0 + y,208,34,34 );
	gfx.PutPixel( 13 + x,0 + y,208,34,34 );
	gfx.PutPixel( 14 + x,0 + y,208,34,34 );
	gfx.PutPixel( 15 + x,0 + y,208,34,34 );
	gfx.PutPixel( 16 + x,0 + y,208,34,34 );
	gfx.PutPixel( 17 + x,0 + y,208,34,34 );
	gfx.PutPixel( 18 + x,0 + y,208,34,34 );
	gfx.PutPixel( 19 + x,0 + y,208,34,34 );
	gfx.PutPixel( 20 + x,0 + y,208,34,34 );
	gfx.PutPixel( 21 + x,0 + y,208,34,34 );
	gfx.PutPixel( 22 + x,0 + y,208,34,34 );
	gfx.PutPixel( 23 + x,0 + y,208,34,34 );
	gfx.PutPixel( 24 + x,0 + y,208,34,34 );
	gfx.PutPixel( 25 + x,0 + y,208,34,34 );
	gfx.PutPixel( 26 + x,0 + y,208,34,34 );
	gfx.PutPixel( 27 + x,0 + y,208,34,34 );
	gfx.PutPixel( 28 + x,0 + y,208,34,34 );
	gfx.PutPixel( 29 + x,0 + y,208,34,34 );
	gfx.PutPixel( 30 + x,0 + y,208,34,34 );
	gfx.PutPixel( 31 + x,0 + y,208,34,34 );
	gfx.PutPixel( 32 + x,0 + y,208,34,34 );
	gfx.PutPixel( 33 + x,0 + y,208,34,34 );
	gfx.PutPixel( 34 + x,0 + y,208,34,34 );
	gfx.PutPixel( 35 + x,0 + y,208,34,34 );
	gfx.PutPixel( 36 + x,0 + y,208,34,34 );
	gfx.PutPixel( 37 + x,0 + y,208,34,34 );
	gfx.PutPixel( 38 + x,0 + y,208,34,34 );
	gfx.PutPixel( 39 + x,0 + y,208,34,34 );
	gfx.PutPixel( 40 + x,0 + y,208,34,34 );
	gfx.PutPixel( 41 + x,0 + y,208,34,34 );
	gfx.PutPixel( 42 + x,0 + y,208,34,34 );
	gfx.PutPixel( 43 + x,0 + y,208,34,34 );
	gfx.PutPixel( 44 + x,0 + y,208,34,34 );
	gfx.PutPixel( 45 + x,0 + y,208,34,34 );
	gfx.PutPixel( 46 + x,0 + y,208,34,34 );
	gfx.PutPixel( 47 + x,0 + y,208,34,34 );
	gfx.PutPixel( 48 + x,0 + y,208,34,34 );
	gfx.PutPixel( 49 + x,0 + y,208,34,34 );
	gfx.PutPixel( 50 + x,0 + y,208,34,34 );
	gfx.PutPixel( 51 + x,0 + y,208,34,34 );
	gfx.PutPixel( 52 + x,0 + y,208,34,34 );
	gfx.PutPixel( 53 + x,0 + y,208,34,34 );
	gfx.PutPixel( 54 + x,0 + y,208,34,34 );
	gfx.PutPixel( 55 + x,0 + y,208,34,34 );
	gfx.PutPixel( 56 + x,0 + y,208,34,34 );
	gfx.PutPixel( 57 + x,0 + y,208,34,34 );
	gfx.PutPixel( 58 + x,0 + y,208,34,34 );
	gfx.PutPixel( 59 + x,0 + y,208,34,34 );
	gfx.PutPixel( 60 + x,0 + y,208,34,34 );
	gfx.PutPixel( 61 + x,0 + y,208,34,34 );
	gfx.PutPixel( 62 + x,0 + y,208,34,34 );
	gfx.PutPixel( 63 + x,0 + y,208,34,34 );
	gfx.PutPixel( 64 + x,0 + y,208,34,34 );
	gfx.PutPixel( 65 + x,0 + y,208,34,34 );
	gfx.PutPixel( 66 + x,0 + y,208,34,34 );
	gfx.PutPixel( 67 + x,0 + y,208,34,34 );
	gfx.PutPixel( 68 + x,0 + y,208,34,34 );
	gfx.PutPixel( 69 + x,0 + y,208,34,34 );
	gfx.PutPixel( 70 + x,0 + y,208,34,34 );
	gfx.PutPixel( 71 + x,0 + y,208,34,34 );
	gfx.PutPixel( 72 + x,0 + y,208,34,34 );
	gfx.PutPixel( 73 + x,0 + y,208,34,34 );
	gfx.PutPixel( 74 + x,0 + y,208,34,34 );
	gfx.PutPixel( 75 + x,0 + y,208,34,34 );
	gfx.PutPixel( 76 + x,0 + y,208,34,34 );
	gfx.PutPixel( 77 + x,0 + y,208,34,34 );
	gfx.PutPixel( 78 + x,0 + y,208,34,34 );
	gfx.PutPixel( 79 + x,0 + y,208,34,34 );
	gfx.PutPixel( 80 + x,0 + y,208,34,34 );
	gfx.PutPixel( 81 + x,0 + y,208,34,34 );
	gfx.PutPixel( 82 + x,0 + y,208,34,34 );
	gfx.PutPixel( 83 + x,0 + y,208,34,34 );
	gfx.PutPixel( 84 + x,0 + y,208,34,34 );
	gfx.PutPixel( 85 + x,0 + y,208,34,34 );
	gfx.PutPixel( 86 + x,0 + y,208,34,34 );
	gfx.PutPixel( 87 + x,0 + y,208,34,34 );
	gfx.PutPixel( 88 + x,0 + y,208,34,34 );
	gfx.PutPixel( 89 + x,0 + y,208,34,34 );
	gfx.PutPixel( 90 + x,0 + y,208,34,34 );
	gfx.PutPixel( 91 + x,0 + y,208,34,34 );
	gfx.PutPixel( 92 + x,0 + y,208,34,34 );
	gfx.PutPixel( 93 + x,0 + y,208,34,34 );
	gfx.PutPixel( 94 + x,0 + y,208,34,34 );
	gfx.PutPixel( 95 + x,0 + y,208,34,34 );
	gfx.PutPixel( 96 + x,0 + y,208,34,34 );
	gfx.PutPixel( 97 + x,0 + y,208,34,34 );
	gfx.PutPixel( 98 + x,0 + y,208,34,34 );
	gfx.PutPixel( 99 + x,0 + y,208,34,34 );
	gfx.PutPixel( 100 + x,0 + y,208,34,34 );
	gfx.PutPixel( 101 + x,0 + y,208,34,34 );
	gfx.PutPixel( 102 + x,0 + y,208,34,34 );
	gfx.PutPixel( 103 + x,0 + y,208,34,34 );
	gfx.PutPixel( 104 + x,0 + y,208,34,34 );
	gfx.PutPixel( 105 + x,0 + y,208,34,34 );
	gfx.PutPixel( 106 + x,0 + y,208,34,34 );
	gfx.PutPixel( 107 + x,0 + y,208,34,34 );
	gfx.PutPixel( 108 + x,0 + y,208,34,34 );
	gfx.PutPixel( 109 + x,0 + y,208,34,34 );
	gfx.PutPixel( 110 + x,0 + y,208,34,34 );
	gfx.PutPixel( 111 + x,0 + y,208,34,34 );
	gfx.PutPixel( 112 + x,0 + y,208,34,34 );
	gfx.PutPixel( 113 + x,0 + y,208,34,34 );
	gfx.PutPixel( 114 + x,0 + y,208,34,34 );
	gfx.PutPixel( 115 + x,0 + y,208,34,34 );
	gfx.PutPixel( 116 + x,0 + y,208,34,34 );
	gfx.PutPixel( 117 + x,0 + y,208,34,34 );
	gfx.PutPixel( 118 + x,0 + y,208,34,34 );
	gfx.PutPixel( 119 + x,0 + y,208,34,34 );
	gfx.PutPixel( 120 + x,0 + y,208,34,34 );
	gfx.PutPixel( 121 + x,0 + y,208,34,34 );
	gfx.PutPixel( 122 + x,0 + y,208,34,34 );
	gfx.PutPixel( 123 + x,0 + y,208,34,34 );
	gfx.PutPixel( 124 + x,0 + y,208,34,34 );
	gfx.PutPixel( 125 + x,0 + y,208,34,34 );
	gfx.PutPixel( 126 + x,0 + y,208,34,34 );
	gfx.PutPixel( 127 + x,0 + y,208,34,34 );
	gfx.PutPixel( 128 + x,0 + y,208,34,34 );
	gfx.PutPixel( 129 + x,0 + y,208,34,34 );
	gfx.PutPixel( 130 + x,0 + y,208,34,34 );
	gfx.PutPixel( 131 + x,0 + y,208,34,34 );
	gfx.PutPixel( 132 + x,0 + y,208,34,34 );
	gfx.PutPixel( 133 + x,0 + y,208,34,34 );
	gfx.PutPixel( 134 + x,0 + y,208,34,34 );
	gfx.PutPixel( 135 + x,0 + y,208,34,34 );
	gfx.PutPixel( 136 + x,0 + y,208,34,34 );
	gfx.PutPixel( 137 + x,0 + y,208,34,34 );
	gfx.PutPixel( 138 + x,0 + y,208,34,34 );
	gfx.PutPixel( 139 + x,0 + y,208,34,34 );
	gfx.PutPixel( 140 + x,0 + y,208,34,34 );
	gfx.PutPixel( 141 + x,0 + y,208,34,34 );
	gfx.PutPixel( 142 + x,0 + y,208,34,34 );
	gfx.PutPixel( 143 + x,0 + y,208,34,34 );
	gfx.PutPixel( 144 + x,0 + y,208,34,34 );
	gfx.PutPixel( 145 + x,0 + y,208,34,34 );
	gfx.PutPixel( 146 + x,0 + y,208,34,34 );
	gfx.PutPixel( 147 + x,0 + y,208,34,34 );
	gfx.PutPixel( 148 + x,0 + y,208,34,34 );
	gfx.PutPixel( 149 + x,0 + y,208,34,34 );
	gfx.PutPixel( 0 + x,1 + y,208,34,34 );
	gfx.PutPixel( 1 + x,1 + y,208,34,34 );
	gfx.PutPixel( 2 + x,1 + y,208,34,34 );
	gfx.PutPixel( 3 + x,1 + y,208,34,34 );
	gfx.PutPixel( 4 + x,1 + y,208,34,34 );
	gfx.PutPixel( 5 + x,1 + y,208,34,34 );
	gfx.PutPixel( 6 + x,1 + y,208,34,34 );
	gfx.PutPixel( 7 + x,1 + y,208,34,34 );
	gfx.PutPixel( 8 + x,1 + y,208,34,34 );
	gfx.PutPixel( 9 + x,1 + y,208,34,34 );
	gfx.PutPixel( 10 + x,1 + y,208,34,34 );
	gfx.PutPixel( 11 + x,1 + y,208,34,34 );
	gfx.PutPixel( 12 + x,1 + y,208,34,34 );
	gfx.PutPixel( 13 + x,1 + y,208,34,34 );
	gfx.PutPixel( 14 + x,1 + y,208,34,34 );
	gfx.PutPixel( 15 + x,1 + y,208,34,34 );
	gfx.PutPixel( 16 + x,1 + y,208,34,34 );
	gfx.PutPixel( 17 + x,1 + y,208,34,34 );
	gfx.PutPixel( 18 + x,1 + y,208,34,34 );
	gfx.PutPixel( 19 + x,1 + y,208,34,34 );
	gfx.PutPixel( 20 + x,1 + y,208,34,34 );
	gfx.PutPixel( 21 + x,1 + y,208,34,34 );
	gfx.PutPixel( 22 + x,1 + y,208,34,34 );
	gfx.PutPixel( 23 + x,1 + y,208,34,34 );
	gfx.PutPixel( 24 + x,1 + y,208,34,34 );
	gfx.PutPixel( 25 + x,1 + y,208,34,34 );
	gfx.PutPixel( 26 + x,1 + y,208,34,34 );
	gfx.PutPixel( 27 + x,1 + y,208,34,34 );
	gfx.PutPixel( 28 + x,1 + y,208,34,34 );
	gfx.PutPixel( 29 + x,1 + y,208,34,34 );
	gfx.PutPixel( 30 + x,1 + y,208,34,34 );
	gfx.PutPixel( 31 + x,1 + y,208,34,34 );
	gfx.PutPixel( 32 + x,1 + y,208,34,34 );
	gfx.PutPixel( 33 + x,1 + y,208,34,34 );
	gfx.PutPixel( 34 + x,1 + y,208,34,34 );
	gfx.PutPixel( 35 + x,1 + y,208,34,34 );
	gfx.PutPixel( 36 + x,1 + y,208,34,34 );
	gfx.PutPixel( 37 + x,1 + y,208,34,34 );
	gfx.PutPixel( 38 + x,1 + y,208,34,34 );
	gfx.PutPixel( 39 + x,1 + y,208,34,34 );
	gfx.PutPixel( 40 + x,1 + y,208,34,34 );
	gfx.PutPixel( 41 + x,1 + y,208,34,34 );
	gfx.PutPixel( 42 + x,1 + y,208,34,34 );
	gfx.PutPixel( 43 + x,1 + y,208,34,34 );
	gfx.PutPixel( 44 + x,1 + y,208,34,34 );
	gfx.PutPixel( 45 + x,1 + y,208,34,34 );
	gfx.PutPixel( 46 + x,1 + y,208,34,34 );
	gfx.PutPixel( 47 + x,1 + y,208,34,34 );
	gfx.PutPixel( 48 + x,1 + y,208,34,34 );
	gfx.PutPixel( 49 + x,1 + y,208,34,34 );
	gfx.PutPixel( 50 + x,1 + y,208,34,34 );
	gfx.PutPixel( 51 + x,1 + y,208,34,34 );
	gfx.PutPixel( 52 + x,1 + y,208,34,34 );
	gfx.PutPixel( 53 + x,1 + y,208,34,34 );
	gfx.PutPixel( 54 + x,1 + y,208,34,34 );
	gfx.PutPixel( 55 + x,1 + y,208,34,34 );
	gfx.PutPixel( 56 + x,1 + y,208,34,34 );
	gfx.PutPixel( 57 + x,1 + y,208,34,34 );
	gfx.PutPixel( 58 + x,1 + y,208,34,34 );
	gfx.PutPixel( 59 + x,1 + y,208,34,34 );
	gfx.PutPixel( 60 + x,1 + y,208,34,34 );
	gfx.PutPixel( 61 + x,1 + y,208,34,34 );
	gfx.PutPixel( 62 + x,1 + y,208,34,34 );
	gfx.PutPixel( 63 + x,1 + y,208,34,34 );
	gfx.PutPixel( 64 + x,1 + y,208,34,34 );
	gfx.PutPixel( 65 + x,1 + y,208,34,34 );
	gfx.PutPixel( 66 + x,1 + y,208,34,34 );
	gfx.PutPixel( 67 + x,1 + y,208,34,34 );
	gfx.PutPixel( 68 + x,1 + y,208,34,34 );
	gfx.PutPixel( 69 + x,1 + y,208,34,34 );
	gfx.PutPixel( 70 + x,1 + y,208,34,34 );
	gfx.PutPixel( 71 + x,1 + y,208,34,34 );
	gfx.PutPixel( 72 + x,1 + y,208,34,34 );
	gfx.PutPixel( 73 + x,1 + y,208,34,34 );
	gfx.PutPixel( 74 + x,1 + y,208,34,34 );
	gfx.PutPixel( 75 + x,1 + y,208,34,34 );
	gfx.PutPixel( 76 + x,1 + y,208,34,34 );
	gfx.PutPixel( 77 + x,1 + y,208,34,34 );
	gfx.PutPixel( 78 + x,1 + y,208,34,34 );
	gfx.PutPixel( 79 + x,1 + y,208,34,34 );
	gfx.PutPixel( 80 + x,1 + y,208,34,34 );
	gfx.PutPixel( 81 + x,1 + y,208,34,34 );
	gfx.PutPixel( 82 + x,1 + y,208,34,34 );
	gfx.PutPixel( 83 + x,1 + y,208,34,34 );
	gfx.PutPixel( 84 + x,1 + y,208,34,34 );
	gfx.PutPixel( 85 + x,1 + y,208,34,34 );
	gfx.PutPixel( 86 + x,1 + y,208,34,34 );
	gfx.PutPixel( 87 + x,1 + y,208,34,34 );
	gfx.PutPixel( 88 + x,1 + y,208,34,34 );
	gfx.PutPixel( 89 + x,1 + y,208,34,34 );
	gfx.PutPixel( 90 + x,1 + y,208,34,34 );
	gfx.PutPixel( 91 + x,1 + y,208,34,34 );
	gfx.PutPixel( 92 + x,1 + y,208,34,34 );
	gfx.PutPixel( 93 + x,1 + y,208,34,34 );
	gfx.PutPixel( 94 + x,1 + y,208,34,34 );
	gfx.PutPixel( 95 + x,1 + y,208,34,34 );
	gfx.PutPixel( 96 + x,1 + y,208,34,34 );
	gfx.PutPixel( 97 + x,1 + y,208,34,34 );
	gfx.PutPixel( 98 + x,1 + y,208,34,34 );
	gfx.PutPixel( 99 + x,1 + y,208,34,34 );
	gfx.PutPixel( 100 + x,1 + y,208,34,34 );
	gfx.PutPixel( 101 + x,1 + y,208,34,34 );
	gfx.PutPixel( 102 + x,1 + y,208,34,34 );
	gfx.PutPixel( 103 + x,1 + y,208,34,34 );
	gfx.PutPixel( 104 + x,1 + y,208,34,34 );
	gfx.PutPixel( 105 + x,1 + y,208,34,34 );
	gfx.PutPixel( 106 + x,1 + y,208,34,34 );
	gfx.PutPixel( 107 + x,1 + y,208,34,34 );
	gfx.PutPixel( 108 + x,1 + y,208,34,34 );
	gfx.PutPixel( 109 + x,1 + y,208,34,34 );
	gfx.PutPixel( 110 + x,1 + y,208,34,34 );
	gfx.PutPixel( 111 + x,1 + y,208,34,34 );
	gfx.PutPixel( 112 + x,1 + y,208,34,34 );
	gfx.PutPixel( 113 + x,1 + y,208,34,34 );
	gfx.PutPixel( 114 + x,1 + y,208,34,34 );
	gfx.PutPixel( 115 + x,1 + y,208,34,34 );
	gfx.PutPixel( 116 + x,1 + y,208,34,34 );
	gfx.PutPixel( 117 + x,1 + y,208,34,34 );
	gfx.PutPixel( 118 + x,1 + y,208,34,34 );
	gfx.PutPixel( 119 + x,1 + y,208,34,34 );
	gfx.PutPixel( 120 + x,1 + y,208,34,34 );
	gfx.PutPixel( 121 + x,1 + y,208,34,34 );
	gfx.PutPixel( 122 + x,1 + y,208,34,34 );
	gfx.PutPixel( 123 + x,1 + y,208,34,34 );
	gfx.PutPixel( 124 + x,1 + y,208,34,34 );
	gfx.PutPixel( 125 + x,1 + y,208,34,34 );
	gfx.PutPixel( 126 + x,1 + y,208,34,34 );
	gfx.PutPixel( 127 + x,1 + y,208,34,34 );
	gfx.PutPixel( 128 + x,1 + y,208,34,34 );
	gfx.PutPixel( 129 + x,1 + y,208,34,34 );
	gfx.PutPixel( 130 + x,1 + y,208,34,34 );
	gfx.PutPixel( 131 + x,1 + y,208,34,34 );
	gfx.PutPixel( 132 + x,1 + y,208,34,34 );
	gfx.PutPixel( 133 + x,1 + y,208,34,34 );
	gfx.PutPixel( 134 + x,1 + y,208,34,34 );
	gfx.PutPixel( 135 + x,1 + y,208,34,34 );
	gfx.PutPixel( 136 + x,1 + y,208,34,34 );
	gfx.PutPixel( 137 + x,1 + y,208,34,34 );
	gfx.PutPixel( 138 + x,1 + y,208,34,34 );
	gfx.PutPixel( 139 + x,1 + y,208,34,34 );
	gfx.PutPixel( 140 + x,1 + y,208,34,34 );
	gfx.PutPixel( 141 + x,1 + y,208,34,34 );
	gfx.PutPixel( 142 + x,1 + y,208,34,34 );
	gfx.PutPixel( 143 + x,1 + y,208,34,34 );
	gfx.PutPixel( 144 + x,1 + y,208,34,34 );
	gfx.PutPixel( 145 + x,1 + y,208,34,34 );
	gfx.PutPixel( 146 + x,1 + y,208,34,34 );
	gfx.PutPixel( 147 + x,1 + y,208,34,34 );
	gfx.PutPixel( 148 + x,1 + y,208,34,34 );
	gfx.PutPixel( 149 + x,1 + y,208,34,34 );
	gfx.PutPixel( 0 + x,2 + y,208,34,34 );
	gfx.PutPixel( 1 + x,2 + y,208,34,34 );
	gfx.PutPixel( 2 + x,2 + y,208,34,34 );
	gfx.PutPixel( 3 + x,2 + y,208,34,34 );
	gfx.PutPixel( 4 + x,2 + y,208,34,34 );
	gfx.PutPixel( 5 + x,2 + y,208,34,34 );
	gfx.PutPixel( 6 + x,2 + y,208,34,34 );
	gfx.PutPixel( 7 + x,2 + y,208,34,34 );
	gfx.PutPixel( 8 + x,2 + y,208,34,34 );
	gfx.PutPixel( 9 + x,2 + y,208,34,34 );
	gfx.PutPixel( 10 + x,2 + y,208,34,34 );
	gfx.PutPixel( 11 + x,2 + y,208,34,34 );
	gfx.PutPixel( 12 + x,2 + y,208,34,34 );
	gfx.PutPixel( 13 + x,2 + y,208,34,34 );
	gfx.PutPixel( 14 + x,2 + y,208,34,34 );
	gfx.PutPixel( 15 + x,2 + y,208,34,34 );
	gfx.PutPixel( 16 + x,2 + y,208,34,34 );
	gfx.PutPixel( 17 + x,2 + y,208,34,34 );
	gfx.PutPixel( 18 + x,2 + y,208,34,34 );
	gfx.PutPixel( 19 + x,2 + y,208,34,34 );
	gfx.PutPixel( 20 + x,2 + y,208,34,34 );
	gfx.PutPixel( 21 + x,2 + y,208,34,34 );
	gfx.PutPixel( 22 + x,2 + y,208,34,34 );
	gfx.PutPixel( 23 + x,2 + y,208,34,34 );
	gfx.PutPixel( 24 + x,2 + y,208,34,34 );
	gfx.PutPixel( 25 + x,2 + y,208,34,34 );
	gfx.PutPixel( 26 + x,2 + y,208,34,34 );
	gfx.PutPixel( 27 + x,2 + y,208,34,34 );
	gfx.PutPixel( 28 + x,2 + y,208,34,34 );
	gfx.PutPixel( 29 + x,2 + y,208,34,34 );
	gfx.PutPixel( 30 + x,2 + y,208,34,34 );
	gfx.PutPixel( 31 + x,2 + y,208,34,34 );
	gfx.PutPixel( 32 + x,2 + y,208,34,34 );
	gfx.PutPixel( 33 + x,2 + y,208,34,34 );
	gfx.PutPixel( 34 + x,2 + y,208,34,34 );
	gfx.PutPixel( 35 + x,2 + y,208,34,34 );
	gfx.PutPixel( 36 + x,2 + y,208,34,34 );
	gfx.PutPixel( 37 + x,2 + y,208,34,34 );
	gfx.PutPixel( 38 + x,2 + y,208,34,34 );
	gfx.PutPixel( 39 + x,2 + y,208,34,34 );
	gfx.PutPixel( 40 + x,2 + y,208,34,34 );
	gfx.PutPixel( 41 + x,2 + y,208,34,34 );
	gfx.PutPixel( 42 + x,2 + y,208,34,34 );
	gfx.PutPixel( 43 + x,2 + y,208,34,34 );
	gfx.PutPixel( 44 + x,2 + y,208,34,34 );
	gfx.PutPixel( 45 + x,2 + y,208,34,34 );
	gfx.PutPixel( 46 + x,2 + y,208,34,34 );
	gfx.PutPixel( 47 + x,2 + y,208,34,34 );
	gfx.PutPixel( 48 + x,2 + y,208,34,34 );
	gfx.PutPixel( 49 + x,2 + y,208,34,34 );
	gfx.PutPixel( 50 + x,2 + y,208,34,34 );
	gfx.PutPixel( 51 + x,2 + y,208,34,34 );
	gfx.PutPixel( 52 + x,2 + y,208,34,34 );
	gfx.PutPixel( 53 + x,2 + y,208,34,34 );
	gfx.PutPixel( 54 + x,2 + y,208,34,34 );
	gfx.PutPixel( 55 + x,2 + y,208,34,34 );
	gfx.PutPixel( 56 + x,2 + y,208,34,34 );
	gfx.PutPixel( 57 + x,2 + y,208,34,34 );
	gfx.PutPixel( 58 + x,2 + y,208,34,34 );
	gfx.PutPixel( 59 + x,2 + y,208,34,34 );
	gfx.PutPixel( 60 + x,2 + y,208,34,34 );
	gfx.PutPixel( 61 + x,2 + y,208,34,34 );
	gfx.PutPixel( 62 + x,2 + y,208,34,34 );
	gfx.PutPixel( 63 + x,2 + y,208,34,34 );
	gfx.PutPixel( 64 + x,2 + y,208,34,34 );
	gfx.PutPixel( 65 + x,2 + y,208,34,34 );
	gfx.PutPixel( 66 + x,2 + y,208,34,34 );
	gfx.PutPixel( 67 + x,2 + y,208,34,34 );
	gfx.PutPixel( 68 + x,2 + y,208,34,34 );
	gfx.PutPixel( 69 + x,2 + y,208,34,34 );
	gfx.PutPixel( 70 + x,2 + y,208,34,34 );
	gfx.PutPixel( 71 + x,2 + y,208,34,34 );
	gfx.PutPixel( 72 + x,2 + y,208,34,34 );
	gfx.PutPixel( 73 + x,2 + y,208,34,34 );
	gfx.PutPixel( 74 + x,2 + y,208,34,34 );
	gfx.PutPixel( 75 + x,2 + y,208,34,34 );
	gfx.PutPixel( 76 + x,2 + y,208,34,34 );
	gfx.PutPixel( 77 + x,2 + y,208,34,34 );
	gfx.PutPixel( 78 + x,2 + y,208,34,34 );
	gfx.PutPixel( 79 + x,2 + y,208,34,34 );
	gfx.PutPixel( 80 + x,2 + y,208,34,34 );
	gfx.PutPixel( 81 + x,2 + y,208,34,34 );
	gfx.PutPixel( 82 + x,2 + y,208,34,34 );
	gfx.PutPixel( 83 + x,2 + y,208,34,34 );
	gfx.PutPixel( 84 + x,2 + y,208,34,34 );
	gfx.PutPixel( 85 + x,2 + y,208,34,34 );
	gfx.PutPixel( 86 + x,2 + y,208,34,34 );
	gfx.PutPixel( 87 + x,2 + y,208,34,34 );
	gfx.PutPixel( 88 + x,2 + y,208,34,34 );
	gfx.PutPixel( 89 + x,2 + y,208,34,34 );
	gfx.PutPixel( 90 + x,2 + y,208,34,34 );
	gfx.PutPixel( 91 + x,2 + y,208,34,34 );
	gfx.PutPixel( 92 + x,2 + y,208,34,34 );
	gfx.PutPixel( 93 + x,2 + y,208,34,34 );
	gfx.PutPixel( 94 + x,2 + y,208,34,34 );
	gfx.PutPixel( 95 + x,2 + y,208,34,34 );
	gfx.PutPixel( 96 + x,2 + y,208,34,34 );
	gfx.PutPixel( 97 + x,2 + y,208,34,34 );
	gfx.PutPixel( 98 + x,2 + y,208,34,34 );
	gfx.PutPixel( 99 + x,2 + y,208,34,34 );
	gfx.PutPixel( 100 + x,2 + y,208,34,34 );
	gfx.PutPixel( 101 + x,2 + y,208,34,34 );
	gfx.PutPixel( 102 + x,2 + y,208,34,34 );
	gfx.PutPixel( 103 + x,2 + y,208,34,34 );
	gfx.PutPixel( 104 + x,2 + y,208,34,34 );
	gfx.PutPixel( 105 + x,2 + y,208,34,34 );
	gfx.PutPixel( 106 + x,2 + y,208,34,34 );
	gfx.PutPixel( 107 + x,2 + y,208,34,34 );
	gfx.PutPixel( 108 + x,2 + y,208,34,34 );
	gfx.PutPixel( 109 + x,2 + y,208,34,34 );
	gfx.PutPixel( 110 + x,2 + y,208,34,34 );
	gfx.PutPixel( 111 + x,2 + y,208,34,34 );
	gfx.PutPixel( 112 + x,2 + y,208,34,34 );
	gfx.PutPixel( 113 + x,2 + y,208,34,34 );
	gfx.PutPixel( 114 + x,2 + y,208,34,34 );
	gfx.PutPixel( 115 + x,2 + y,208,34,34 );
	gfx.PutPixel( 116 + x,2 + y,208,34,34 );
	gfx.PutPixel( 117 + x,2 + y,208,34,34 );
	gfx.PutPixel( 118 + x,2 + y,208,34,34 );
	gfx.PutPixel( 119 + x,2 + y,208,34,34 );
	gfx.PutPixel( 120 + x,2 + y,208,34,34 );
	gfx.PutPixel( 121 + x,2 + y,208,34,34 );
	gfx.PutPixel( 122 + x,2 + y,208,34,34 );
	gfx.PutPixel( 123 + x,2 + y,208,34,34 );
	gfx.PutPixel( 124 + x,2 + y,208,34,34 );
	gfx.PutPixel( 125 + x,2 + y,208,34,34 );
	gfx.PutPixel( 126 + x,2 + y,208,34,34 );
	gfx.PutPixel( 127 + x,2 + y,208,34,34 );
	gfx.PutPixel( 128 + x,2 + y,208,34,34 );
	gfx.PutPixel( 129 + x,2 + y,208,34,34 );
	gfx.PutPixel( 130 + x,2 + y,208,34,34 );
	gfx.PutPixel( 131 + x,2 + y,208,34,34 );
	gfx.PutPixel( 132 + x,2 + y,208,34,34 );
	gfx.PutPixel( 133 + x,2 + y,208,34,34 );
	gfx.PutPixel( 134 + x,2 + y,208,34,34 );
	gfx.PutPixel( 135 + x,2 + y,208,34,34 );
	gfx.PutPixel( 136 + x,2 + y,208,34,34 );
	gfx.PutPixel( 137 + x,2 + y,208,34,34 );
	gfx.PutPixel( 138 + x,2 + y,208,34,34 );
	gfx.PutPixel( 139 + x,2 + y,208,34,34 );
	gfx.PutPixel( 140 + x,2 + y,208,34,34 );
	gfx.PutPixel( 141 + x,2 + y,208,34,34 );
	gfx.PutPixel( 142 + x,2 + y,208,34,34 );
	gfx.PutPixel( 143 + x,2 + y,208,34,34 );
	gfx.PutPixel( 144 + x,2 + y,208,34,34 );
	gfx.PutPixel( 145 + x,2 + y,208,34,34 );
	gfx.PutPixel( 146 + x,2 + y,208,34,34 );
	gfx.PutPixel( 147 + x,2 + y,208,34,34 );
	gfx.PutPixel( 148 + x,2 + y,208,34,34 );
	gfx.PutPixel( 149 + x,2 + y,208,34,34 );
	gfx.PutPixel( 0 + x,3 + y,208,34,34 );
	gfx.PutPixel( 1 + x,3 + y,208,34,34 );
	gfx.PutPixel( 2 + x,3 + y,208,34,34 );
	gfx.PutPixel( 3 + x,3 + y,208,34,34 );
	gfx.PutPixel( 4 + x,3 + y,208,34,34 );
	gfx.PutPixel( 5 + x,3 + y,208,34,34 );
	gfx.PutPixel( 6 + x,3 + y,208,34,34 );
	gfx.PutPixel( 7 + x,3 + y,208,34,34 );
	gfx.PutPixel( 8 + x,3 + y,208,34,34 );
	gfx.PutPixel( 9 + x,3 + y,208,34,34 );
	gfx.PutPixel( 10 + x,3 + y,208,34,34 );
	gfx.PutPixel( 11 + x,3 + y,208,34,34 );
	gfx.PutPixel( 12 + x,3 + y,208,34,34 );
	gfx.PutPixel( 13 + x,3 + y,208,34,34 );
	gfx.PutPixel( 14 + x,3 + y,208,34,34 );
	gfx.PutPixel( 15 + x,3 + y,208,34,34 );
	gfx.PutPixel( 16 + x,3 + y,208,34,34 );
	gfx.PutPixel( 17 + x,3 + y,208,34,34 );
	gfx.PutPixel( 18 + x,3 + y,208,34,34 );
	gfx.PutPixel( 19 + x,3 + y,208,34,34 );
	gfx.PutPixel( 20 + x,3 + y,208,34,34 );
	gfx.PutPixel( 21 + x,3 + y,208,34,34 );
	gfx.PutPixel( 22 + x,3 + y,208,34,34 );
	gfx.PutPixel( 23 + x,3 + y,208,34,34 );
	gfx.PutPixel( 24 + x,3 + y,208,34,34 );
	gfx.PutPixel( 25 + x,3 + y,208,34,34 );
	gfx.PutPixel( 26 + x,3 + y,208,34,34 );
	gfx.PutPixel( 27 + x,3 + y,208,34,34 );
	gfx.PutPixel( 28 + x,3 + y,208,34,34 );
	gfx.PutPixel( 29 + x,3 + y,208,34,34 );
	gfx.PutPixel( 30 + x,3 + y,208,34,34 );
	gfx.PutPixel( 31 + x,3 + y,208,34,34 );
	gfx.PutPixel( 32 + x,3 + y,208,34,34 );
	gfx.PutPixel( 33 + x,3 + y,208,34,34 );
	gfx.PutPixel( 34 + x,3 + y,208,34,34 );
	gfx.PutPixel( 35 + x,3 + y,208,34,34 );
	gfx.PutPixel( 36 + x,3 + y,208,34,34 );
	gfx.PutPixel( 37 + x,3 + y,208,34,34 );
	gfx.PutPixel( 38 + x,3 + y,208,34,34 );
	gfx.PutPixel( 39 + x,3 + y,208,34,34 );
	gfx.PutPixel( 40 + x,3 + y,208,34,34 );
	gfx.PutPixel( 41 + x,3 + y,208,34,34 );
	gfx.PutPixel( 42 + x,3 + y,208,34,34 );
	gfx.PutPixel( 43 + x,3 + y,208,34,34 );
	gfx.PutPixel( 44 + x,3 + y,208,34,34 );
	gfx.PutPixel( 45 + x,3 + y,208,34,34 );
	gfx.PutPixel( 46 + x,3 + y,208,34,34 );
	gfx.PutPixel( 47 + x,3 + y,208,34,34 );
	gfx.PutPixel( 48 + x,3 + y,208,34,34 );
	gfx.PutPixel( 49 + x,3 + y,208,34,34 );
	gfx.PutPixel( 50 + x,3 + y,208,34,34 );
	gfx.PutPixel( 51 + x,3 + y,208,34,34 );
	gfx.PutPixel( 52 + x,3 + y,208,34,34 );
	gfx.PutPixel( 53 + x,3 + y,208,34,34 );
	gfx.PutPixel( 54 + x,3 + y,208,34,34 );
	gfx.PutPixel( 55 + x,3 + y,208,34,34 );
	gfx.PutPixel( 56 + x,3 + y,208,34,34 );
	gfx.PutPixel( 57 + x,3 + y,208,34,34 );
	gfx.PutPixel( 58 + x,3 + y,208,34,34 );
	gfx.PutPixel( 59 + x,3 + y,208,34,34 );
	gfx.PutPixel( 60 + x,3 + y,208,34,34 );
	gfx.PutPixel( 61 + x,3 + y,208,34,34 );
	gfx.PutPixel( 62 + x,3 + y,208,34,34 );
	gfx.PutPixel( 63 + x,3 + y,208,34,34 );
	gfx.PutPixel( 64 + x,3 + y,208,34,34 );
	gfx.PutPixel( 65 + x,3 + y,208,34,34 );
	gfx.PutPixel( 66 + x,3 + y,208,34,34 );
	gfx.PutPixel( 67 + x,3 + y,208,34,34 );
	gfx.PutPixel( 68 + x,3 + y,208,34,34 );
	gfx.PutPixel( 69 + x,3 + y,208,34,34 );
	gfx.PutPixel( 70 + x,3 + y,208,34,34 );
	gfx.PutPixel( 71 + x,3 + y,208,34,34 );
	gfx.PutPixel( 72 + x,3 + y,208,34,34 );
	gfx.PutPixel( 73 + x,3 + y,208,34,34 );
	gfx.PutPixel( 74 + x,3 + y,208,34,34 );
	gfx.PutPixel( 75 + x,3 + y,208,34,34 );
	gfx.PutPixel( 76 + x,3 + y,208,34,34 );
	gfx.PutPixel( 77 + x,3 + y,208,34,34 );
	gfx.PutPixel( 78 + x,3 + y,208,34,34 );
	gfx.PutPixel( 79 + x,3 + y,208,34,34 );
	gfx.PutPixel( 80 + x,3 + y,208,34,34 );
	gfx.PutPixel( 81 + x,3 + y,208,34,34 );
	gfx.PutPixel( 82 + x,3 + y,208,34,34 );
	gfx.PutPixel( 83 + x,3 + y,208,34,34 );
	gfx.PutPixel( 84 + x,3 + y,208,34,34 );
	gfx.PutPixel( 85 + x,3 + y,208,34,34 );
	gfx.PutPixel( 86 + x,3 + y,208,34,34 );
	gfx.PutPixel( 87 + x,3 + y,208,34,34 );
	gfx.PutPixel( 88 + x,3 + y,208,34,34 );
	gfx.PutPixel( 89 + x,3 + y,208,34,34 );
	gfx.PutPixel( 90 + x,3 + y,208,34,34 );
	gfx.PutPixel( 91 + x,3 + y,208,34,34 );
	gfx.PutPixel( 92 + x,3 + y,208,34,34 );
	gfx.PutPixel( 93 + x,3 + y,208,34,34 );
	gfx.PutPixel( 94 + x,3 + y,208,34,34 );
	gfx.PutPixel( 95 + x,3 + y,208,34,34 );
	gfx.PutPixel( 96 + x,3 + y,208,34,34 );
	gfx.PutPixel( 97 + x,3 + y,208,34,34 );
	gfx.PutPixel( 98 + x,3 + y,208,34,34 );
	gfx.PutPixel( 99 + x,3 + y,208,34,34 );
	gfx.PutPixel( 100 + x,3 + y,208,34,34 );
	gfx.PutPixel( 101 + x,3 + y,208,34,34 );
	gfx.PutPixel( 102 + x,3 + y,208,34,34 );
	gfx.PutPixel( 103 + x,3 + y,208,34,34 );
	gfx.PutPixel( 104 + x,3 + y,208,34,34 );
	gfx.PutPixel( 105 + x,3 + y,208,34,34 );
	gfx.PutPixel( 106 + x,3 + y,208,34,34 );
	gfx.PutPixel( 107 + x,3 + y,208,34,34 );
	gfx.PutPixel( 108 + x,3 + y,208,34,34 );
	gfx.PutPixel( 109 + x,3 + y,208,34,34 );
	gfx.PutPixel( 110 + x,3 + y,208,34,34 );
	gfx.PutPixel( 111 + x,3 + y,208,34,34 );
	gfx.PutPixel( 112 + x,3 + y,208,34,34 );
	gfx.PutPixel( 113 + x,3 + y,208,34,34 );
	gfx.PutPixel( 114 + x,3 + y,208,34,34 );
	gfx.PutPixel( 115 + x,3 + y,208,34,34 );
	gfx.PutPixel( 116 + x,3 + y,208,34,34 );
	gfx.PutPixel( 117 + x,3 + y,208,34,34 );
	gfx.PutPixel( 118 + x,3 + y,208,34,34 );
	gfx.PutPixel( 119 + x,3 + y,208,34,34 );
	gfx.PutPixel( 120 + x,3 + y,208,34,34 );
	gfx.PutPixel( 121 + x,3 + y,208,34,34 );
	gfx.PutPixel( 122 + x,3 + y,208,34,34 );
	gfx.PutPixel( 123 + x,3 + y,208,34,34 );
	gfx.PutPixel( 124 + x,3 + y,208,34,34 );
	gfx.PutPixel( 125 + x,3 + y,208,34,34 );
	gfx.PutPixel( 126 + x,3 + y,208,34,34 );
	gfx.PutPixel( 127 + x,3 + y,208,34,34 );
	gfx.PutPixel( 128 + x,3 + y,208,34,34 );
	gfx.PutPixel( 129 + x,3 + y,208,34,34 );
	gfx.PutPixel( 130 + x,3 + y,208,34,34 );
	gfx.PutPixel( 131 + x,3 + y,208,34,34 );
	gfx.PutPixel( 132 + x,3 + y,208,34,34 );
	gfx.PutPixel( 133 + x,3 + y,208,34,34 );
	gfx.PutPixel( 134 + x,3 + y,208,34,34 );
	gfx.PutPixel( 135 + x,3 + y,208,34,34 );
	gfx.PutPixel( 136 + x,3 + y,208,34,34 );
	gfx.PutPixel( 137 + x,3 + y,208,34,34 );
	gfx.PutPixel( 138 + x,3 + y,208,34,34 );
	gfx.PutPixel( 139 + x,3 + y,208,34,34 );
	gfx.PutPixel( 140 + x,3 + y,208,34,34 );
	gfx.PutPixel( 141 + x,3 + y,208,34,34 );
	gfx.PutPixel( 142 + x,3 + y,208,34,34 );
	gfx.PutPixel( 143 + x,3 + y,208,34,34 );
	gfx.PutPixel( 144 + x,3 + y,208,34,34 );
	gfx.PutPixel( 145 + x,3 + y,208,34,34 );
	gfx.PutPixel( 146 + x,3 + y,208,34,34 );
	gfx.PutPixel( 147 + x,3 + y,208,34,34 );
	gfx.PutPixel( 148 + x,3 + y,208,34,34 );
	gfx.PutPixel( 149 + x,3 + y,208,34,34 );
	gfx.PutPixel( 0 + x,4 + y,208,34,34 );
	gfx.PutPixel( 1 + x,4 + y,208,34,34 );
	gfx.PutPixel( 2 + x,4 + y,208,34,34 );
	gfx.PutPixel( 3 + x,4 + y,208,34,34 );
	gfx.PutPixel( 4 + x,4 + y,208,34,34 );
	gfx.PutPixel( 5 + x,4 + y,208,34,34 );
	gfx.PutPixel( 6 + x,4 + y,208,34,34 );
	gfx.PutPixel( 7 + x,4 + y,208,34,34 );
	gfx.PutPixel( 8 + x,4 + y,208,34,34 );
	gfx.PutPixel( 9 + x,4 + y,208,34,34 );
	gfx.PutPixel( 10 + x,4 + y,208,34,34 );
	gfx.PutPixel( 11 + x,4 + y,208,34,34 );
	gfx.PutPixel( 12 + x,4 + y,208,34,34 );
	gfx.PutPixel( 13 + x,4 + y,208,34,34 );
	gfx.PutPixel( 14 + x,4 + y,208,34,34 );
	gfx.PutPixel( 15 + x,4 + y,208,34,34 );
	gfx.PutPixel( 16 + x,4 + y,208,34,34 );
	gfx.PutPixel( 17 + x,4 + y,208,34,34 );
	gfx.PutPixel( 18 + x,4 + y,208,34,34 );
	gfx.PutPixel( 19 + x,4 + y,208,34,34 );
	gfx.PutPixel( 20 + x,4 + y,208,34,34 );
	gfx.PutPixel( 21 + x,4 + y,208,34,34 );
	gfx.PutPixel( 22 + x,4 + y,208,34,34 );
	gfx.PutPixel( 23 + x,4 + y,208,34,34 );
	gfx.PutPixel( 24 + x,4 + y,208,34,34 );
	gfx.PutPixel( 25 + x,4 + y,208,34,34 );
	gfx.PutPixel( 26 + x,4 + y,208,34,34 );
	gfx.PutPixel( 27 + x,4 + y,208,34,34 );
	gfx.PutPixel( 28 + x,4 + y,208,34,34 );
	gfx.PutPixel( 29 + x,4 + y,208,34,34 );
	gfx.PutPixel( 30 + x,4 + y,208,34,34 );
	gfx.PutPixel( 31 + x,4 + y,208,34,34 );
	gfx.PutPixel( 32 + x,4 + y,208,34,34 );
	gfx.PutPixel( 33 + x,4 + y,208,34,34 );
	gfx.PutPixel( 34 + x,4 + y,208,34,34 );
	gfx.PutPixel( 35 + x,4 + y,208,34,34 );
	gfx.PutPixel( 36 + x,4 + y,208,34,34 );
	gfx.PutPixel( 37 + x,4 + y,208,34,34 );
	gfx.PutPixel( 38 + x,4 + y,208,34,34 );
	gfx.PutPixel( 39 + x,4 + y,208,34,34 );
	gfx.PutPixel( 40 + x,4 + y,208,34,34 );
	gfx.PutPixel( 41 + x,4 + y,208,34,34 );
	gfx.PutPixel( 42 + x,4 + y,208,34,34 );
	gfx.PutPixel( 43 + x,4 + y,208,34,34 );
	gfx.PutPixel( 44 + x,4 + y,208,34,34 );
	gfx.PutPixel( 45 + x,4 + y,208,34,34 );
	gfx.PutPixel( 46 + x,4 + y,208,34,34 );
	gfx.PutPixel( 47 + x,4 + y,208,34,34 );
	gfx.PutPixel( 48 + x,4 + y,208,34,34 );
	gfx.PutPixel( 49 + x,4 + y,208,34,34 );
	gfx.PutPixel( 50 + x,4 + y,208,34,34 );
	gfx.PutPixel( 51 + x,4 + y,208,34,34 );
	gfx.PutPixel( 52 + x,4 + y,208,34,34 );
	gfx.PutPixel( 53 + x,4 + y,208,34,34 );
	gfx.PutPixel( 54 + x,4 + y,208,34,34 );
	gfx.PutPixel( 55 + x,4 + y,208,34,34 );
	gfx.PutPixel( 56 + x,4 + y,208,34,34 );
	gfx.PutPixel( 57 + x,4 + y,208,34,34 );
	gfx.PutPixel( 58 + x,4 + y,208,34,34 );
	gfx.PutPixel( 59 + x,4 + y,208,34,34 );
	gfx.PutPixel( 60 + x,4 + y,208,34,34 );
	gfx.PutPixel( 61 + x,4 + y,208,34,34 );
	gfx.PutPixel( 62 + x,4 + y,208,34,34 );
	gfx.PutPixel( 63 + x,4 + y,208,34,34 );
	gfx.PutPixel( 64 + x,4 + y,208,34,34 );
	gfx.PutPixel( 65 + x,4 + y,208,34,34 );
	gfx.PutPixel( 66 + x,4 + y,208,34,34 );
	gfx.PutPixel( 67 + x,4 + y,208,34,34 );
	gfx.PutPixel( 68 + x,4 + y,208,34,34 );
	gfx.PutPixel( 69 + x,4 + y,208,34,34 );
	gfx.PutPixel( 70 + x,4 + y,208,34,34 );
	gfx.PutPixel( 71 + x,4 + y,208,34,34 );
	gfx.PutPixel( 72 + x,4 + y,208,34,34 );
	gfx.PutPixel( 73 + x,4 + y,208,31,31 );
	gfx.PutPixel( 74 + x,4 + y,207,24,24 );
	gfx.PutPixel( 75 + x,4 + y,207,26,26 );
	gfx.PutPixel( 76 + x,4 + y,208,34,34 );
	gfx.PutPixel( 77 + x,4 + y,208,34,34 );
	gfx.PutPixel( 78 + x,4 + y,208,34,34 );
	gfx.PutPixel( 79 + x,4 + y,208,34,34 );
	gfx.PutPixel( 80 + x,4 + y,208,34,34 );
	gfx.PutPixel( 81 + x,4 + y,208,34,34 );
	gfx.PutPixel( 82 + x,4 + y,208,34,34 );
	gfx.PutPixel( 83 + x,4 + y,208,34,34 );
	gfx.PutPixel( 84 + x,4 + y,208,34,34 );
	gfx.PutPixel( 85 + x,4 + y,208,34,34 );
	gfx.PutPixel( 86 + x,4 + y,208,34,34 );
	gfx.PutPixel( 87 + x,4 + y,208,34,34 );
	gfx.PutPixel( 88 + x,4 + y,208,34,34 );
	gfx.PutPixel( 89 + x,4 + y,208,34,34 );
	gfx.PutPixel( 90 + x,4 + y,208,34,34 );
	gfx.PutPixel( 91 + x,4 + y,208,34,34 );
	gfx.PutPixel( 92 + x,4 + y,208,34,34 );
	gfx.PutPixel( 93 + x,4 + y,208,34,34 );
	gfx.PutPixel( 94 + x,4 + y,208,34,34 );
	gfx.PutPixel( 95 + x,4 + y,208,34,34 );
	gfx.PutPixel( 96 + x,4 + y,208,34,34 );
	gfx.PutPixel( 97 + x,4 + y,208,34,34 );
	gfx.PutPixel( 98 + x,4 + y,208,34,34 );
	gfx.PutPixel( 99 + x,4 + y,208,34,34 );
	gfx.PutPixel( 100 + x,4 + y,208,34,34 );
	gfx.PutPixel( 101 + x,4 + y,208,34,34 );
	gfx.PutPixel( 102 + x,4 + y,208,34,34 );
	gfx.PutPixel( 103 + x,4 + y,208,34,34 );
	gfx.PutPixel( 104 + x,4 + y,208,34,34 );
	gfx.PutPixel( 105 + x,4 + y,208,34,34 );
	gfx.PutPixel( 106 + x,4 + y,208,34,34 );
	gfx.PutPixel( 107 + x,4 + y,208,34,34 );
	gfx.PutPixel( 108 + x,4 + y,208,34,34 );
	gfx.PutPixel( 109 + x,4 + y,208,34,34 );
	gfx.PutPixel( 110 + x,4 + y,208,34,34 );
	gfx.PutPixel( 111 + x,4 + y,208,34,34 );
	gfx.PutPixel( 112 + x,4 + y,208,34,34 );
	gfx.PutPixel( 113 + x,4 + y,208,34,34 );
	gfx.PutPixel( 114 + x,4 + y,208,34,34 );
	gfx.PutPixel( 115 + x,4 + y,208,34,34 );
	gfx.PutPixel( 116 + x,4 + y,208,34,34 );
	gfx.PutPixel( 117 + x,4 + y,208,34,34 );
	gfx.PutPixel( 118 + x,4 + y,208,34,34 );
	gfx.PutPixel( 119 + x,4 + y,208,34,34 );
	gfx.PutPixel( 120 + x,4 + y,208,34,34 );
	gfx.PutPixel( 121 + x,4 + y,208,34,34 );
	gfx.PutPixel( 122 + x,4 + y,208,34,34 );
	gfx.PutPixel( 123 + x,4 + y,208,34,34 );
	gfx.PutPixel( 124 + x,4 + y,208,34,34 );
	gfx.PutPixel( 125 + x,4 + y,208,34,34 );
	gfx.PutPixel( 126 + x,4 + y,208,34,34 );
	gfx.PutPixel( 127 + x,4 + y,208,34,34 );
	gfx.PutPixel( 128 + x,4 + y,208,34,34 );
	gfx.PutPixel( 129 + x,4 + y,208,34,34 );
	gfx.PutPixel( 130 + x,4 + y,208,34,34 );
	gfx.PutPixel( 131 + x,4 + y,208,34,34 );
	gfx.PutPixel( 132 + x,4 + y,208,34,34 );
	gfx.PutPixel( 133 + x,4 + y,208,34,34 );
	gfx.PutPixel( 134 + x,4 + y,208,34,34 );
	gfx.PutPixel( 135 + x,4 + y,208,34,34 );
	gfx.PutPixel( 136 + x,4 + y,208,34,34 );
	gfx.PutPixel( 137 + x,4 + y,208,34,34 );
	gfx.PutPixel( 138 + x,4 + y,208,34,34 );
	gfx.PutPixel( 139 + x,4 + y,208,34,34 );
	gfx.PutPixel( 140 + x,4 + y,208,34,34 );
	gfx.PutPixel( 141 + x,4 + y,208,34,34 );
	gfx.PutPixel( 142 + x,4 + y,208,34,34 );
	gfx.PutPixel( 143 + x,4 + y,208,34,34 );
	gfx.PutPixel( 144 + x,4 + y,208,34,34 );
	gfx.PutPixel( 145 + x,4 + y,208,34,34 );
	gfx.PutPixel( 146 + x,4 + y,208,34,34 );
	gfx.PutPixel( 147 + x,4 + y,208,34,34 );
	gfx.PutPixel( 148 + x,4 + y,208,34,34 );
	gfx.PutPixel( 149 + x,4 + y,208,34,34 );
	gfx.PutPixel( 0 + x,5 + y,208,34,34 );
	gfx.PutPixel( 1 + x,5 + y,208,34,34 );
	gfx.PutPixel( 2 + x,5 + y,208,34,34 );
	gfx.PutPixel( 3 + x,5 + y,208,34,34 );
	gfx.PutPixel( 4 + x,5 + y,208,34,34 );
	gfx.PutPixel( 5 + x,5 + y,208,34,34 );
	gfx.PutPixel( 6 + x,5 + y,208,34,34 );
	gfx.PutPixel( 7 + x,5 + y,208,34,34 );
	gfx.PutPixel( 8 + x,5 + y,208,34,34 );
	gfx.PutPixel( 9 + x,5 + y,208,34,34 );
	gfx.PutPixel( 10 + x,5 + y,208,34,34 );
	gfx.PutPixel( 11 + x,5 + y,208,34,34 );
	gfx.PutPixel( 12 + x,5 + y,208,34,34 );
	gfx.PutPixel( 13 + x,5 + y,208,34,34 );
	gfx.PutPixel( 14 + x,5 + y,208,34,34 );
	gfx.PutPixel( 15 + x,5 + y,208,34,34 );
	gfx.PutPixel( 16 + x,5 + y,208,34,34 );
	gfx.PutPixel( 17 + x,5 + y,208,34,34 );
	gfx.PutPixel( 18 + x,5 + y,208,34,34 );
	gfx.PutPixel( 19 + x,5 + y,208,34,34 );
	gfx.PutPixel( 20 + x,5 + y,208,34,34 );
	gfx.PutPixel( 21 + x,5 + y,208,34,34 );
	gfx.PutPixel( 22 + x,5 + y,208,34,34 );
	gfx.PutPixel( 23 + x,5 + y,208,34,34 );
	gfx.PutPixel( 24 + x,5 + y,208,34,34 );
	gfx.PutPixel( 25 + x,5 + y,208,34,34 );
	gfx.PutPixel( 26 + x,5 + y,208,34,34 );
	gfx.PutPixel( 27 + x,5 + y,208,34,34 );
	gfx.PutPixel( 28 + x,5 + y,208,34,34 );
	gfx.PutPixel( 29 + x,5 + y,208,34,34 );
	gfx.PutPixel( 30 + x,5 + y,208,34,34 );
	gfx.PutPixel( 31 + x,5 + y,208,34,34 );
	gfx.PutPixel( 32 + x,5 + y,208,34,34 );
	gfx.PutPixel( 33 + x,5 + y,208,34,34 );
	gfx.PutPixel( 34 + x,5 + y,208,34,34 );
	gfx.PutPixel( 35 + x,5 + y,208,34,34 );
	gfx.PutPixel( 36 + x,5 + y,208,34,34 );
	gfx.PutPixel( 37 + x,5 + y,208,34,34 );
	gfx.PutPixel( 38 + x,5 + y,208,34,34 );
	gfx.PutPixel( 39 + x,5 + y,208,34,34 );
	gfx.PutPixel( 40 + x,5 + y,208,34,34 );
	gfx.PutPixel( 41 + x,5 + y,208,34,34 );
	gfx.PutPixel( 42 + x,5 + y,208,34,34 );
	gfx.PutPixel( 43 + x,5 + y,208,34,34 );
	gfx.PutPixel( 44 + x,5 + y,208,34,34 );
	gfx.PutPixel( 45 + x,5 + y,208,34,34 );
	gfx.PutPixel( 46 + x,5 + y,208,34,34 );
	gfx.PutPixel( 47 + x,5 + y,208,34,34 );
	gfx.PutPixel( 48 + x,5 + y,208,34,34 );
	gfx.PutPixel( 49 + x,5 + y,208,34,34 );
	gfx.PutPixel( 50 + x,5 + y,208,34,34 );
	gfx.PutPixel( 51 + x,5 + y,208,34,34 );
	gfx.PutPixel( 52 + x,5 + y,208,34,34 );
	gfx.PutPixel( 53 + x,5 + y,208,34,34 );
	gfx.PutPixel( 54 + x,5 + y,208,34,34 );
	gfx.PutPixel( 55 + x,5 + y,208,34,34 );
	gfx.PutPixel( 56 + x,5 + y,208,34,34 );
	gfx.PutPixel( 57 + x,5 + y,208,34,34 );
	gfx.PutPixel( 58 + x,5 + y,208,34,34 );
	gfx.PutPixel( 59 + x,5 + y,208,34,34 );
	gfx.PutPixel( 60 + x,5 + y,208,34,34 );
	gfx.PutPixel( 61 + x,5 + y,208,34,34 );
	gfx.PutPixel( 62 + x,5 + y,208,34,34 );
	gfx.PutPixel( 63 + x,5 + y,208,34,34 );
	gfx.PutPixel( 64 + x,5 + y,208,34,34 );
	gfx.PutPixel( 65 + x,5 + y,208,34,34 );
	gfx.PutPixel( 66 + x,5 + y,208,34,34 );
	gfx.PutPixel( 67 + x,5 + y,208,34,34 );
	gfx.PutPixel( 68 + x,5 + y,208,34,34 );
	gfx.PutPixel( 69 + x,5 + y,208,34,34 );
	gfx.PutPixel( 70 + x,5 + y,208,34,34 );
	gfx.PutPixel( 71 + x,5 + y,208,34,34 );
	gfx.PutPixel( 72 + x,5 + y,208,31,31 );
	gfx.PutPixel( 73 + x,5 + y,210,56,56 );
	gfx.PutPixel( 74 + x,5 + y,213,106,106 );
	gfx.PutPixel( 75 + x,5 + y,212,94,94 );
	gfx.PutPixel( 76 + x,5 + y,208,37,37 );
	gfx.PutPixel( 77 + x,5 + y,208,33,33 );
	gfx.PutPixel( 78 + x,5 + y,208,34,34 );
	gfx.PutPixel( 79 + x,5 + y,208,34,34 );
	gfx.PutPixel( 80 + x,5 + y,208,34,34 );
	gfx.PutPixel( 81 + x,5 + y,208,34,34 );
	gfx.PutPixel( 82 + x,5 + y,208,34,34 );
	gfx.PutPixel( 83 + x,5 + y,208,34,34 );
	gfx.PutPixel( 84 + x,5 + y,208,34,34 );
	gfx.PutPixel( 85 + x,5 + y,208,34,34 );
	gfx.PutPixel( 86 + x,5 + y,208,34,34 );
	gfx.PutPixel( 87 + x,5 + y,208,34,34 );
	gfx.PutPixel( 88 + x,5 + y,208,34,34 );
	gfx.PutPixel( 89 + x,5 + y,208,34,34 );
	gfx.PutPixel( 90 + x,5 + y,208,34,34 );
	gfx.PutPixel( 91 + x,5 + y,208,34,34 );
	gfx.PutPixel( 92 + x,5 + y,208,34,34 );
	gfx.PutPixel( 93 + x,5 + y,208,34,34 );
	gfx.PutPixel( 94 + x,5 + y,208,34,34 );
	gfx.PutPixel( 95 + x,5 + y,208,34,34 );
	gfx.PutPixel( 96 + x,5 + y,208,34,34 );
	gfx.PutPixel( 97 + x,5 + y,208,34,34 );
	gfx.PutPixel( 98 + x,5 + y,208,34,34 );
	gfx.PutPixel( 99 + x,5 + y,208,34,34 );
	gfx.PutPixel( 100 + x,5 + y,208,34,34 );
	gfx.PutPixel( 101 + x,5 + y,208,34,34 );
	gfx.PutPixel( 102 + x,5 + y,208,34,34 );
	gfx.PutPixel( 103 + x,5 + y,208,34,34 );
	gfx.PutPixel( 104 + x,5 + y,208,34,34 );
	gfx.PutPixel( 105 + x,5 + y,208,34,34 );
	gfx.PutPixel( 106 + x,5 + y,208,34,34 );
	gfx.PutPixel( 107 + x,5 + y,208,34,34 );
	gfx.PutPixel( 108 + x,5 + y,208,34,34 );
	gfx.PutPixel( 109 + x,5 + y,208,34,34 );
	gfx.PutPixel( 110 + x,5 + y,208,34,34 );
	gfx.PutPixel( 111 + x,5 + y,208,34,34 );
	gfx.PutPixel( 112 + x,5 + y,208,34,34 );
	gfx.PutPixel( 113 + x,5 + y,208,34,34 );
	gfx.PutPixel( 114 + x,5 + y,208,34,34 );
	gfx.PutPixel( 115 + x,5 + y,208,34,34 );
	gfx.PutPixel( 116 + x,5 + y,208,34,34 );
	gfx.PutPixel( 117 + x,5 + y,208,34,34 );
	gfx.PutPixel( 118 + x,5 + y,208,34,34 );
	gfx.PutPixel( 119 + x,5 + y,208,34,34 );
	gfx.PutPixel( 120 + x,5 + y,208,34,34 );
	gfx.PutPixel( 121 + x,5 + y,208,34,34 );
	gfx.PutPixel( 122 + x,5 + y,208,34,34 );
	gfx.PutPixel( 123 + x,5 + y,208,34,34 );
	gfx.PutPixel( 124 + x,5 + y,208,34,34 );
	gfx.PutPixel( 125 + x,5 + y,208,34,34 );
	gfx.PutPixel( 126 + x,5 + y,208,34,34 );
	gfx.PutPixel( 127 + x,5 + y,208,34,34 );
	gfx.PutPixel( 128 + x,5 + y,208,34,34 );
	gfx.PutPixel( 129 + x,5 + y,208,34,34 );
	gfx.PutPixel( 130 + x,5 + y,208,34,34 );
	gfx.PutPixel( 131 + x,5 + y,208,34,34 );
	gfx.PutPixel( 132 + x,5 + y,208,34,34 );
	gfx.PutPixel( 133 + x,5 + y,208,34,34 );
	gfx.PutPixel( 134 + x,5 + y,208,34,34 );
	gfx.PutPixel( 135 + x,5 + y,208,34,34 );
	gfx.PutPixel( 136 + x,5 + y,208,34,34 );
	gfx.PutPixel( 137 + x,5 + y,208,34,34 );
	gfx.PutPixel( 138 + x,5 + y,208,34,34 );
	gfx.PutPixel( 139 + x,5 + y,208,34,34 );
	gfx.PutPixel( 140 + x,5 + y,208,34,34 );
	gfx.PutPixel( 141 + x,5 + y,208,34,34 );
	gfx.PutPixel( 142 + x,5 + y,208,34,34 );
	gfx.PutPixel( 143 + x,5 + y,208,34,34 );
	gfx.PutPixel( 144 + x,5 + y,208,34,34 );
	gfx.PutPixel( 145 + x,5 + y,208,34,34 );
	gfx.PutPixel( 146 + x,5 + y,208,34,34 );
	gfx.PutPixel( 147 + x,5 + y,208,34,34 );
	gfx.PutPixel( 148 + x,5 + y,208,34,34 );
	gfx.PutPixel( 149 + x,5 + y,208,34,34 );
	gfx.PutPixel( 0 + x,6 + y,208,34,34 );
	gfx.PutPixel( 1 + x,6 + y,208,34,34 );
	gfx.PutPixel( 2 + x,6 + y,208,34,34 );
	gfx.PutPixel( 3 + x,6 + y,208,34,34 );
	gfx.PutPixel( 4 + x,6 + y,208,34,34 );
	gfx.PutPixel( 5 + x,6 + y,208,34,34 );
	gfx.PutPixel( 6 + x,6 + y,208,34,34 );
	gfx.PutPixel( 7 + x,6 + y,208,34,34 );
	gfx.PutPixel( 8 + x,6 + y,208,34,34 );
	gfx.PutPixel( 9 + x,6 + y,208,34,34 );
	gfx.PutPixel( 10 + x,6 + y,208,34,34 );
	gfx.PutPixel( 11 + x,6 + y,208,34,34 );
	gfx.PutPixel( 12 + x,6 + y,208,34,34 );
	gfx.PutPixel( 13 + x,6 + y,208,34,34 );
	gfx.PutPixel( 14 + x,6 + y,208,34,34 );
	gfx.PutPixel( 15 + x,6 + y,208,34,34 );
	gfx.PutPixel( 16 + x,6 + y,208,34,34 );
	gfx.PutPixel( 17 + x,6 + y,208,34,34 );
	gfx.PutPixel( 18 + x,6 + y,208,34,34 );
	gfx.PutPixel( 19 + x,6 + y,208,34,34 );
	gfx.PutPixel( 20 + x,6 + y,208,34,34 );
	gfx.PutPixel( 21 + x,6 + y,208,34,34 );
	gfx.PutPixel( 22 + x,6 + y,208,34,34 );
	gfx.PutPixel( 23 + x,6 + y,208,34,34 );
	gfx.PutPixel( 24 + x,6 + y,208,34,34 );
	gfx.PutPixel( 25 + x,6 + y,208,34,34 );
	gfx.PutPixel( 26 + x,6 + y,208,34,34 );
	gfx.PutPixel( 27 + x,6 + y,208,34,34 );
	gfx.PutPixel( 28 + x,6 + y,208,34,34 );
	gfx.PutPixel( 29 + x,6 + y,208,34,34 );
	gfx.PutPixel( 30 + x,6 + y,208,34,34 );
	gfx.PutPixel( 31 + x,6 + y,208,34,34 );
	gfx.PutPixel( 32 + x,6 + y,208,34,34 );
	gfx.PutPixel( 33 + x,6 + y,208,34,34 );
	gfx.PutPixel( 34 + x,6 + y,208,34,34 );
	gfx.PutPixel( 35 + x,6 + y,208,34,34 );
	gfx.PutPixel( 36 + x,6 + y,208,34,34 );
	gfx.PutPixel( 37 + x,6 + y,208,34,34 );
	gfx.PutPixel( 38 + x,6 + y,208,34,34 );
	gfx.PutPixel( 39 + x,6 + y,208,34,34 );
	gfx.PutPixel( 40 + x,6 + y,208,34,34 );
	gfx.PutPixel( 41 + x,6 + y,208,34,34 );
	gfx.PutPixel( 42 + x,6 + y,208,34,34 );
	gfx.PutPixel( 43 + x,6 + y,208,34,34 );
	gfx.PutPixel( 44 + x,6 + y,208,34,34 );
	gfx.PutPixel( 45 + x,6 + y,208,34,34 );
	gfx.PutPixel( 46 + x,6 + y,208,34,34 );
	gfx.PutPixel( 47 + x,6 + y,208,34,34 );
	gfx.PutPixel( 48 + x,6 + y,208,34,34 );
	gfx.PutPixel( 49 + x,6 + y,208,34,34 );
	gfx.PutPixel( 50 + x,6 + y,208,34,34 );
	gfx.PutPixel( 51 + x,6 + y,208,34,34 );
	gfx.PutPixel( 52 + x,6 + y,208,34,34 );
	gfx.PutPixel( 53 + x,6 + y,208,34,34 );
	gfx.PutPixel( 54 + x,6 + y,208,34,34 );
	gfx.PutPixel( 55 + x,6 + y,208,34,34 );
	gfx.PutPixel( 56 + x,6 + y,208,34,34 );
	gfx.PutPixel( 57 + x,6 + y,208,34,34 );
	gfx.PutPixel( 58 + x,6 + y,208,34,34 );
	gfx.PutPixel( 59 + x,6 + y,208,34,34 );
	gfx.PutPixel( 60 + x,6 + y,208,34,34 );
	gfx.PutPixel( 61 + x,6 + y,208,34,34 );
	gfx.PutPixel( 62 + x,6 + y,208,34,34 );
	gfx.PutPixel( 63 + x,6 + y,208,34,34 );
	gfx.PutPixel( 64 + x,6 + y,208,34,34 );
	gfx.PutPixel( 65 + x,6 + y,208,34,34 );
	gfx.PutPixel( 66 + x,6 + y,208,34,34 );
	gfx.PutPixel( 67 + x,6 + y,208,34,34 );
	gfx.PutPixel( 68 + x,6 + y,208,34,34 );
	gfx.PutPixel( 69 + x,6 + y,208,34,34 );
	gfx.PutPixel( 70 + x,6 + y,208,34,34 );
	gfx.PutPixel( 71 + x,6 + y,208,34,34 );
	gfx.PutPixel( 72 + x,6 + y,208,27,27 );
	gfx.PutPixel( 73 + x,6 + y,209,53,53 );
	gfx.PutPixel( 74 + x,6 + y,222,228,228 );
	gfx.PutPixel( 75 + x,6 + y,218,174,174 );
	gfx.PutPixel( 76 + x,6 + y,207,22,22 );
	gfx.PutPixel( 77 + x,6 + y,208,33,33 );
	gfx.PutPixel( 78 + x,6 + y,208,34,34 );
	gfx.PutPixel( 79 + x,6 + y,208,34,34 );
	gfx.PutPixel( 80 + x,6 + y,208,34,34 );
	gfx.PutPixel( 81 + x,6 + y,208,34,34 );
	gfx.PutPixel( 82 + x,6 + y,208,34,34 );
	gfx.PutPixel( 83 + x,6 + y,208,34,34 );
	gfx.PutPixel( 84 + x,6 + y,208,34,34 );
	gfx.PutPixel( 85 + x,6 + y,208,34,34 );
	gfx.PutPixel( 86 + x,6 + y,208,34,34 );
	gfx.PutPixel( 87 + x,6 + y,208,34,34 );
	gfx.PutPixel( 88 + x,6 + y,208,34,34 );
	gfx.PutPixel( 89 + x,6 + y,208,34,34 );
	gfx.PutPixel( 90 + x,6 + y,208,34,34 );
	gfx.PutPixel( 91 + x,6 + y,208,34,34 );
	gfx.PutPixel( 92 + x,6 + y,208,34,34 );
	gfx.PutPixel( 93 + x,6 + y,208,34,34 );
	gfx.PutPixel( 94 + x,6 + y,208,34,34 );
	gfx.PutPixel( 95 + x,6 + y,208,34,34 );
	gfx.PutPixel( 96 + x,6 + y,208,34,34 );
	gfx.PutPixel( 97 + x,6 + y,208,34,34 );
	gfx.PutPixel( 98 + x,6 + y,208,34,34 );
	gfx.PutPixel( 99 + x,6 + y,208,34,34 );
	gfx.PutPixel( 100 + x,6 + y,208,34,34 );
	gfx.PutPixel( 101 + x,6 + y,208,34,34 );
	gfx.PutPixel( 102 + x,6 + y,208,34,34 );
	gfx.PutPixel( 103 + x,6 + y,208,34,34 );
	gfx.PutPixel( 104 + x,6 + y,208,34,34 );
	gfx.PutPixel( 105 + x,6 + y,208,34,34 );
	gfx.PutPixel( 106 + x,6 + y,208,34,34 );
	gfx.PutPixel( 107 + x,6 + y,208,34,34 );
	gfx.PutPixel( 108 + x,6 + y,208,34,34 );
	gfx.PutPixel( 109 + x,6 + y,208,34,34 );
	gfx.PutPixel( 110 + x,6 + y,208,34,34 );
	gfx.PutPixel( 111 + x,6 + y,208,34,34 );
	gfx.PutPixel( 112 + x,6 + y,208,34,34 );
	gfx.PutPixel( 113 + x,6 + y,208,34,34 );
	gfx.PutPixel( 114 + x,6 + y,208,34,34 );
	gfx.PutPixel( 115 + x,6 + y,208,34,34 );
	gfx.PutPixel( 116 + x,6 + y,208,34,34 );
	gfx.PutPixel( 117 + x,6 + y,208,34,34 );
	gfx.PutPixel( 118 + x,6 + y,208,34,34 );
	gfx.PutPixel( 119 + x,6 + y,208,34,34 );
	gfx.PutPixel( 120 + x,6 + y,208,34,34 );
	gfx.PutPixel( 121 + x,6 + y,208,34,34 );
	gfx.PutPixel( 122 + x,6 + y,208,34,34 );
	gfx.PutPixel( 123 + x,6 + y,208,34,34 );
	gfx.PutPixel( 124 + x,6 + y,208,34,34 );
	gfx.PutPixel( 125 + x,6 + y,208,34,34 );
	gfx.PutPixel( 126 + x,6 + y,208,34,34 );
	gfx.PutPixel( 127 + x,6 + y,208,34,34 );
	gfx.PutPixel( 128 + x,6 + y,208,34,34 );
	gfx.PutPixel( 129 + x,6 + y,208,34,34 );
	gfx.PutPixel( 130 + x,6 + y,208,34,34 );
	gfx.PutPixel( 131 + x,6 + y,208,34,34 );
	gfx.PutPixel( 132 + x,6 + y,208,34,34 );
	gfx.PutPixel( 133 + x,6 + y,208,34,34 );
	gfx.PutPixel( 134 + x,6 + y,208,34,34 );
	gfx.PutPixel( 135 + x,6 + y,208,34,34 );
	gfx.PutPixel( 136 + x,6 + y,208,34,34 );
	gfx.PutPixel( 137 + x,6 + y,208,34,34 );
	gfx.PutPixel( 138 + x,6 + y,208,34,34 );
	gfx.PutPixel( 139 + x,6 + y,208,34,34 );
	gfx.PutPixel( 140 + x,6 + y,208,34,34 );
	gfx.PutPixel( 141 + x,6 + y,208,34,34 );
	gfx.PutPixel( 142 + x,6 + y,208,34,34 );
	gfx.PutPixel( 143 + x,6 + y,208,34,34 );
	gfx.PutPixel( 144 + x,6 + y,208,34,34 );
	gfx.PutPixel( 145 + x,6 + y,208,34,34 );
	gfx.PutPixel( 146 + x,6 + y,208,34,34 );
	gfx.PutPixel( 147 + x,6 + y,208,34,34 );
	gfx.PutPixel( 148 + x,6 + y,208,34,34 );
	gfx.PutPixel( 149 + x,6 + y,208,34,34 );
	gfx.PutPixel( 0 + x,7 + y,208,34,34 );
	gfx.PutPixel( 1 + x,7 + y,208,34,34 );
	gfx.PutPixel( 2 + x,7 + y,208,34,34 );
	gfx.PutPixel( 3 + x,7 + y,208,34,34 );
	gfx.PutPixel( 4 + x,7 + y,208,34,34 );
	gfx.PutPixel( 5 + x,7 + y,208,34,34 );
	gfx.PutPixel( 6 + x,7 + y,208,34,34 );
	gfx.PutPixel( 7 + x,7 + y,208,34,34 );
	gfx.PutPixel( 8 + x,7 + y,208,34,34 );
	gfx.PutPixel( 9 + x,7 + y,208,34,34 );
	gfx.PutPixel( 10 + x,7 + y,208,34,34 );
	gfx.PutPixel( 11 + x,7 + y,208,34,34 );
	gfx.PutPixel( 12 + x,7 + y,208,34,34 );
	gfx.PutPixel( 13 + x,7 + y,208,34,34 );
	gfx.PutPixel( 14 + x,7 + y,208,34,34 );
	gfx.PutPixel( 15 + x,7 + y,208,34,34 );
	gfx.PutPixel( 16 + x,7 + y,208,34,34 );
	gfx.PutPixel( 17 + x,7 + y,208,34,34 );
	gfx.PutPixel( 18 + x,7 + y,208,34,34 );
	gfx.PutPixel( 19 + x,7 + y,208,34,34 );
	gfx.PutPixel( 20 + x,7 + y,208,34,34 );
	gfx.PutPixel( 21 + x,7 + y,208,34,34 );
	gfx.PutPixel( 22 + x,7 + y,208,34,34 );
	gfx.PutPixel( 23 + x,7 + y,208,34,34 );
	gfx.PutPixel( 24 + x,7 + y,208,34,34 );
	gfx.PutPixel( 25 + x,7 + y,208,34,34 );
	gfx.PutPixel( 26 + x,7 + y,208,34,34 );
	gfx.PutPixel( 27 + x,7 + y,208,34,34 );
	gfx.PutPixel( 28 + x,7 + y,208,34,34 );
	gfx.PutPixel( 29 + x,7 + y,208,34,34 );
	gfx.PutPixel( 30 + x,7 + y,208,34,34 );
	gfx.PutPixel( 31 + x,7 + y,208,34,34 );
	gfx.PutPixel( 32 + x,7 + y,208,34,34 );
	gfx.PutPixel( 33 + x,7 + y,208,34,34 );
	gfx.PutPixel( 34 + x,7 + y,208,34,34 );
	gfx.PutPixel( 35 + x,7 + y,208,34,34 );
	gfx.PutPixel( 36 + x,7 + y,208,34,34 );
	gfx.PutPixel( 37 + x,7 + y,208,34,34 );
	gfx.PutPixel( 38 + x,7 + y,208,34,34 );
	gfx.PutPixel( 39 + x,7 + y,208,34,34 );
	gfx.PutPixel( 40 + x,7 + y,208,34,34 );
	gfx.PutPixel( 41 + x,7 + y,208,34,34 );
	gfx.PutPixel( 42 + x,7 + y,208,34,34 );
	gfx.PutPixel( 43 + x,7 + y,208,34,34 );
	gfx.PutPixel( 44 + x,7 + y,208,34,34 );
	gfx.PutPixel( 45 + x,7 + y,208,34,34 );
	gfx.PutPixel( 46 + x,7 + y,208,34,34 );
	gfx.PutPixel( 47 + x,7 + y,208,34,34 );
	gfx.PutPixel( 48 + x,7 + y,208,34,34 );
	gfx.PutPixel( 49 + x,7 + y,208,34,34 );
	gfx.PutPixel( 50 + x,7 + y,208,34,34 );
	gfx.PutPixel( 51 + x,7 + y,208,34,34 );
	gfx.PutPixel( 52 + x,7 + y,208,34,34 );
	gfx.PutPixel( 53 + x,7 + y,208,34,34 );
	gfx.PutPixel( 54 + x,7 + y,208,34,34 );
	gfx.PutPixel( 55 + x,7 + y,208,34,34 );
	gfx.PutPixel( 56 + x,7 + y,208,34,34 );
	gfx.PutPixel( 57 + x,7 + y,208,34,34 );
	gfx.PutPixel( 58 + x,7 + y,208,34,34 );
	gfx.PutPixel( 59 + x,7 + y,208,34,34 );
	gfx.PutPixel( 60 + x,7 + y,208,34,34 );
	gfx.PutPixel( 61 + x,7 + y,208,34,34 );
	gfx.PutPixel( 62 + x,7 + y,208,34,34 );
	gfx.PutPixel( 63 + x,7 + y,208,34,34 );
	gfx.PutPixel( 64 + x,7 + y,208,34,34 );
	gfx.PutPixel( 65 + x,7 + y,208,34,34 );
	gfx.PutPixel( 66 + x,7 + y,208,34,34 );
	gfx.PutPixel( 67 + x,7 + y,208,34,34 );
	gfx.PutPixel( 68 + x,7 + y,208,34,34 );
	gfx.PutPixel( 69 + x,7 + y,208,34,34 );
	gfx.PutPixel( 70 + x,7 + y,208,34,34 );
	gfx.PutPixel( 71 + x,7 + y,207,29,29 );
	gfx.PutPixel( 72 + x,7 + y,210,65,65 );
	gfx.PutPixel( 73 + x,7 + y,216,144,144 );
	gfx.PutPixel( 74 + x,7 + y,220,207,207 );
	gfx.PutPixel( 75 + x,7 + y,218,181,181 );
	gfx.PutPixel( 76 + x,7 + y,215,127,127 );
	gfx.PutPixel( 77 + x,7 + y,208,39,39 );
	gfx.PutPixel( 78 + x,7 + y,208,32,32 );
	gfx.PutPixel( 79 + x,7 + y,208,34,34 );
	gfx.PutPixel( 80 + x,7 + y,208,34,34 );
	gfx.PutPixel( 81 + x,7 + y,208,34,34 );
	gfx.PutPixel( 82 + x,7 + y,208,34,34 );
	gfx.PutPixel( 83 + x,7 + y,208,34,34 );
	gfx.PutPixel( 84 + x,7 + y,208,34,34 );
	gfx.PutPixel( 85 + x,7 + y,208,34,34 );
	gfx.PutPixel( 86 + x,7 + y,208,34,34 );
	gfx.PutPixel( 87 + x,7 + y,208,34,34 );
	gfx.PutPixel( 88 + x,7 + y,208,34,34 );
	gfx.PutPixel( 89 + x,7 + y,208,34,34 );
	gfx.PutPixel( 90 + x,7 + y,208,34,34 );
	gfx.PutPixel( 91 + x,7 + y,208,34,34 );
	gfx.PutPixel( 92 + x,7 + y,208,34,34 );
	gfx.PutPixel( 93 + x,7 + y,208,34,34 );
	gfx.PutPixel( 94 + x,7 + y,208,34,34 );
	gfx.PutPixel( 95 + x,7 + y,208,34,34 );
	gfx.PutPixel( 96 + x,7 + y,208,34,34 );
	gfx.PutPixel( 97 + x,7 + y,208,34,34 );
	gfx.PutPixel( 98 + x,7 + y,208,34,34 );
	gfx.PutPixel( 99 + x,7 + y,208,34,34 );
	gfx.PutPixel( 100 + x,7 + y,208,34,34 );
	gfx.PutPixel( 101 + x,7 + y,208,34,34 );
	gfx.PutPixel( 102 + x,7 + y,208,34,34 );
	gfx.PutPixel( 103 + x,7 + y,208,34,34 );
	gfx.PutPixel( 104 + x,7 + y,208,34,34 );
	gfx.PutPixel( 105 + x,7 + y,208,34,34 );
	gfx.PutPixel( 106 + x,7 + y,208,34,34 );
	gfx.PutPixel( 107 + x,7 + y,208,34,34 );
	gfx.PutPixel( 108 + x,7 + y,208,34,34 );
	gfx.PutPixel( 109 + x,7 + y,208,34,34 );
	gfx.PutPixel( 110 + x,7 + y,208,34,34 );
	gfx.PutPixel( 111 + x,7 + y,208,34,34 );
	gfx.PutPixel( 112 + x,7 + y,208,34,34 );
	gfx.PutPixel( 113 + x,7 + y,208,34,34 );
	gfx.PutPixel( 114 + x,7 + y,208,34,34 );
	gfx.PutPixel( 115 + x,7 + y,208,34,34 );
	gfx.PutPixel( 116 + x,7 + y,208,34,34 );
	gfx.PutPixel( 117 + x,7 + y,208,34,34 );
	gfx.PutPixel( 118 + x,7 + y,208,34,34 );
	gfx.PutPixel( 119 + x,7 + y,208,34,34 );
	gfx.PutPixel( 120 + x,7 + y,208,34,34 );
	gfx.PutPixel( 121 + x,7 + y,208,34,34 );
	gfx.PutPixel( 122 + x,7 + y,208,34,34 );
	gfx.PutPixel( 123 + x,7 + y,208,34,34 );
	gfx.PutPixel( 124 + x,7 + y,208,34,34 );
	gfx.PutPixel( 125 + x,7 + y,208,34,34 );
	gfx.PutPixel( 126 + x,7 + y,208,34,34 );
	gfx.PutPixel( 127 + x,7 + y,208,34,34 );
	gfx.PutPixel( 128 + x,7 + y,208,34,34 );
	gfx.PutPixel( 129 + x,7 + y,208,34,34 );
	gfx.PutPixel( 130 + x,7 + y,208,34,34 );
	gfx.PutPixel( 131 + x,7 + y,208,34,34 );
	gfx.PutPixel( 132 + x,7 + y,208,34,34 );
	gfx.PutPixel( 133 + x,7 + y,208,34,34 );
	gfx.PutPixel( 134 + x,7 + y,208,34,34 );
	gfx.PutPixel( 135 + x,7 + y,208,34,34 );
	gfx.PutPixel( 136 + x,7 + y,208,34,34 );
	gfx.PutPixel( 137 + x,7 + y,208,34,34 );
	gfx.PutPixel( 138 + x,7 + y,208,34,34 );
	gfx.PutPixel( 139 + x,7 + y,208,34,34 );
	gfx.PutPixel( 140 + x,7 + y,208,34,34 );
	gfx.PutPixel( 141 + x,7 + y,208,34,34 );
	gfx.PutPixel( 142 + x,7 + y,208,34,34 );
	gfx.PutPixel( 143 + x,7 + y,208,34,34 );
	gfx.PutPixel( 144 + x,7 + y,208,34,34 );
	gfx.PutPixel( 145 + x,7 + y,208,34,34 );
	gfx.PutPixel( 146 + x,7 + y,208,34,34 );
	gfx.PutPixel( 147 + x,7 + y,208,34,34 );
	gfx.PutPixel( 148 + x,7 + y,208,34,34 );
	gfx.PutPixel( 149 + x,7 + y,208,34,34 );
	gfx.PutPixel( 0 + x,8 + y,208,34,34 );
	gfx.PutPixel( 1 + x,8 + y,208,34,34 );
	gfx.PutPixel( 2 + x,8 + y,208,34,34 );
	gfx.PutPixel( 3 + x,8 + y,208,34,34 );
	gfx.PutPixel( 4 + x,8 + y,208,34,34 );
	gfx.PutPixel( 5 + x,8 + y,208,34,34 );
	gfx.PutPixel( 6 + x,8 + y,208,34,34 );
	gfx.PutPixel( 7 + x,8 + y,208,34,34 );
	gfx.PutPixel( 8 + x,8 + y,208,34,34 );
	gfx.PutPixel( 9 + x,8 + y,208,34,34 );
	gfx.PutPixel( 10 + x,8 + y,208,34,34 );
	gfx.PutPixel( 11 + x,8 + y,208,34,34 );
	gfx.PutPixel( 12 + x,8 + y,208,34,34 );
	gfx.PutPixel( 13 + x,8 + y,208,34,34 );
	gfx.PutPixel( 14 + x,8 + y,208,34,34 );
	gfx.PutPixel( 15 + x,8 + y,208,34,34 );
	gfx.PutPixel( 16 + x,8 + y,208,34,34 );
	gfx.PutPixel( 17 + x,8 + y,208,34,34 );
	gfx.PutPixel( 18 + x,8 + y,208,34,34 );
	gfx.PutPixel( 19 + x,8 + y,208,34,34 );
	gfx.PutPixel( 20 + x,8 + y,208,34,34 );
	gfx.PutPixel( 21 + x,8 + y,208,34,34 );
	gfx.PutPixel( 22 + x,8 + y,208,34,34 );
	gfx.PutPixel( 23 + x,8 + y,208,34,34 );
	gfx.PutPixel( 24 + x,8 + y,208,34,34 );
	gfx.PutPixel( 25 + x,8 + y,208,34,34 );
	gfx.PutPixel( 26 + x,8 + y,208,34,34 );
	gfx.PutPixel( 27 + x,8 + y,208,34,34 );
	gfx.PutPixel( 28 + x,8 + y,208,34,34 );
	gfx.PutPixel( 29 + x,8 + y,208,34,34 );
	gfx.PutPixel( 30 + x,8 + y,208,34,34 );
	gfx.PutPixel( 31 + x,8 + y,208,34,34 );
	gfx.PutPixel( 32 + x,8 + y,208,34,34 );
	gfx.PutPixel( 33 + x,8 + y,208,34,34 );
	gfx.PutPixel( 34 + x,8 + y,208,34,34 );
	gfx.PutPixel( 35 + x,8 + y,208,34,34 );
	gfx.PutPixel( 36 + x,8 + y,208,34,34 );
	gfx.PutPixel( 37 + x,8 + y,208,34,34 );
	gfx.PutPixel( 38 + x,8 + y,208,34,34 );
	gfx.PutPixel( 39 + x,8 + y,208,34,34 );
	gfx.PutPixel( 40 + x,8 + y,208,34,34 );
	gfx.PutPixel( 41 + x,8 + y,208,34,34 );
	gfx.PutPixel( 42 + x,8 + y,208,34,34 );
	gfx.PutPixel( 43 + x,8 + y,208,34,34 );
	gfx.PutPixel( 44 + x,8 + y,208,34,34 );
	gfx.PutPixel( 45 + x,8 + y,208,34,34 );
	gfx.PutPixel( 46 + x,8 + y,208,34,34 );
	gfx.PutPixel( 47 + x,8 + y,208,34,34 );
	gfx.PutPixel( 48 + x,8 + y,208,34,34 );
	gfx.PutPixel( 49 + x,8 + y,208,34,34 );
	gfx.PutPixel( 50 + x,8 + y,208,34,34 );
	gfx.PutPixel( 51 + x,8 + y,208,34,34 );
	gfx.PutPixel( 52 + x,8 + y,208,34,34 );
	gfx.PutPixel( 53 + x,8 + y,208,34,34 );
	gfx.PutPixel( 54 + x,8 + y,208,34,34 );
	gfx.PutPixel( 55 + x,8 + y,208,34,34 );
	gfx.PutPixel( 56 + x,8 + y,208,34,34 );
	gfx.PutPixel( 57 + x,8 + y,208,34,34 );
	gfx.PutPixel( 58 + x,8 + y,208,34,34 );
	gfx.PutPixel( 59 + x,8 + y,208,34,34 );
	gfx.PutPixel( 60 + x,8 + y,208,34,34 );
	gfx.PutPixel( 61 + x,8 + y,208,34,34 );
	gfx.PutPixel( 62 + x,8 + y,208,34,34 );
	gfx.PutPixel( 63 + x,8 + y,208,34,34 );
	gfx.PutPixel( 64 + x,8 + y,208,34,34 );
	gfx.PutPixel( 65 + x,8 + y,208,34,34 );
	gfx.PutPixel( 66 + x,8 + y,208,34,34 );
	gfx.PutPixel( 67 + x,8 + y,208,34,34 );
	gfx.PutPixel( 68 + x,8 + y,208,34,34 );
	gfx.PutPixel( 69 + x,8 + y,208,34,34 );
	gfx.PutPixel( 70 + x,8 + y,208,34,34 );
	gfx.PutPixel( 71 + x,8 + y,208,27,27 );
	gfx.PutPixel( 72 + x,8 + y,211,76,76 );
	gfx.PutPixel( 73 + x,8 + y,219,198,198 );
	gfx.PutPixel( 74 + x,8 + y,218,182,182 );
	gfx.PutPixel( 75 + x,8 + y,218,185,185 );
	gfx.PutPixel( 76 + x,8 + y,218,179,179 );
	gfx.PutPixel( 77 + x,8 + y,208,38,38 );
	gfx.PutPixel( 78 + x,8 + y,208,32,32 );
	gfx.PutPixel( 79 + x,8 + y,208,34,34 );
	gfx.PutPixel( 80 + x,8 + y,208,34,34 );
	gfx.PutPixel( 81 + x,8 + y,208,34,34 );
	gfx.PutPixel( 82 + x,8 + y,208,34,34 );
	gfx.PutPixel( 83 + x,8 + y,208,34,34 );
	gfx.PutPixel( 84 + x,8 + y,208,34,34 );
	gfx.PutPixel( 85 + x,8 + y,208,34,34 );
	gfx.PutPixel( 86 + x,8 + y,208,34,34 );
	gfx.PutPixel( 87 + x,8 + y,208,34,34 );
	gfx.PutPixel( 88 + x,8 + y,208,34,34 );
	gfx.PutPixel( 89 + x,8 + y,208,34,34 );
	gfx.PutPixel( 90 + x,8 + y,208,34,34 );
	gfx.PutPixel( 91 + x,8 + y,208,34,34 );
	gfx.PutPixel( 92 + x,8 + y,208,34,34 );
	gfx.PutPixel( 93 + x,8 + y,208,34,34 );
	gfx.PutPixel( 94 + x,8 + y,208,34,34 );
	gfx.PutPixel( 95 + x,8 + y,208,34,34 );
	gfx.PutPixel( 96 + x,8 + y,208,34,34 );
	gfx.PutPixel( 97 + x,8 + y,208,34,34 );
	gfx.PutPixel( 98 + x,8 + y,208,34,34 );
	gfx.PutPixel( 99 + x,8 + y,208,34,34 );
	gfx.PutPixel( 100 + x,8 + y,208,34,34 );
	gfx.PutPixel( 101 + x,8 + y,208,34,34 );
	gfx.PutPixel( 102 + x,8 + y,208,34,34 );
	gfx.PutPixel( 103 + x,8 + y,208,34,34 );
	gfx.PutPixel( 104 + x,8 + y,208,34,34 );
	gfx.PutPixel( 105 + x,8 + y,208,34,34 );
	gfx.PutPixel( 106 + x,8 + y,208,34,34 );
	gfx.PutPixel( 107 + x,8 + y,208,34,34 );
	gfx.PutPixel( 108 + x,8 + y,208,34,34 );
	gfx.PutPixel( 109 + x,8 + y,208,34,34 );
	gfx.PutPixel( 110 + x,8 + y,208,34,34 );
	gfx.PutPixel( 111 + x,8 + y,208,34,34 );
	gfx.PutPixel( 112 + x,8 + y,208,34,34 );
	gfx.PutPixel( 113 + x,8 + y,208,34,34 );
	gfx.PutPixel( 114 + x,8 + y,208,34,34 );
	gfx.PutPixel( 115 + x,8 + y,208,34,34 );
	gfx.PutPixel( 116 + x,8 + y,208,34,34 );
	gfx.PutPixel( 117 + x,8 + y,208,34,34 );
	gfx.PutPixel( 118 + x,8 + y,208,34,34 );
	gfx.PutPixel( 119 + x,8 + y,208,34,34 );
	gfx.PutPixel( 120 + x,8 + y,208,34,34 );
	gfx.PutPixel( 121 + x,8 + y,208,34,34 );
	gfx.PutPixel( 122 + x,8 + y,208,34,34 );
	gfx.PutPixel( 123 + x,8 + y,208,34,34 );
	gfx.PutPixel( 124 + x,8 + y,208,34,34 );
	gfx.PutPixel( 125 + x,8 + y,208,34,34 );
	gfx.PutPixel( 126 + x,8 + y,208,34,34 );
	gfx.PutPixel( 127 + x,8 + y,208,34,34 );
	gfx.PutPixel( 128 + x,8 + y,208,34,34 );
	gfx.PutPixel( 129 + x,8 + y,208,34,34 );
	gfx.PutPixel( 130 + x,8 + y,208,34,34 );
	gfx.PutPixel( 131 + x,8 + y,208,34,34 );
	gfx.PutPixel( 132 + x,8 + y,208,34,34 );
	gfx.PutPixel( 133 + x,8 + y,208,34,34 );
	gfx.PutPixel( 134 + x,8 + y,208,34,34 );
	gfx.PutPixel( 135 + x,8 + y,208,34,34 );
	gfx.PutPixel( 136 + x,8 + y,208,34,34 );
	gfx.PutPixel( 137 + x,8 + y,208,34,34 );
	gfx.PutPixel( 138 + x,8 + y,208,34,34 );
	gfx.PutPixel( 139 + x,8 + y,208,34,34 );
	gfx.PutPixel( 140 + x,8 + y,208,34,34 );
	gfx.PutPixel( 141 + x,8 + y,208,34,34 );
	gfx.PutPixel( 142 + x,8 + y,208,34,34 );
	gfx.PutPixel( 143 + x,8 + y,208,34,34 );
	gfx.PutPixel( 144 + x,8 + y,208,34,34 );
	gfx.PutPixel( 145 + x,8 + y,208,34,34 );
	gfx.PutPixel( 146 + x,8 + y,208,34,34 );
	gfx.PutPixel( 147 + x,8 + y,208,34,34 );
	gfx.PutPixel( 148 + x,8 + y,208,34,34 );
	gfx.PutPixel( 149 + x,8 + y,208,34,34 );
	gfx.PutPixel( 0 + x,9 + y,208,34,34 );
	gfx.PutPixel( 1 + x,9 + y,208,34,34 );
	gfx.PutPixel( 2 + x,9 + y,208,34,34 );
	gfx.PutPixel( 3 + x,9 + y,208,34,34 );
	gfx.PutPixel( 4 + x,9 + y,208,34,34 );
	gfx.PutPixel( 5 + x,9 + y,208,34,34 );
	gfx.PutPixel( 6 + x,9 + y,208,34,34 );
	gfx.PutPixel( 7 + x,9 + y,208,34,34 );
	gfx.PutPixel( 8 + x,9 + y,208,34,34 );
	gfx.PutPixel( 9 + x,9 + y,208,34,34 );
	gfx.PutPixel( 10 + x,9 + y,208,34,34 );
	gfx.PutPixel( 11 + x,9 + y,208,34,34 );
	gfx.PutPixel( 12 + x,9 + y,208,34,34 );
	gfx.PutPixel( 13 + x,9 + y,208,34,34 );
	gfx.PutPixel( 14 + x,9 + y,208,34,34 );
	gfx.PutPixel( 15 + x,9 + y,208,34,34 );
	gfx.PutPixel( 16 + x,9 + y,208,34,34 );
	gfx.PutPixel( 17 + x,9 + y,208,34,34 );
	gfx.PutPixel( 18 + x,9 + y,208,34,34 );
	gfx.PutPixel( 19 + x,9 + y,208,34,34 );
	gfx.PutPixel( 20 + x,9 + y,208,34,34 );
	gfx.PutPixel( 21 + x,9 + y,208,34,34 );
	gfx.PutPixel( 22 + x,9 + y,208,34,34 );
	gfx.PutPixel( 23 + x,9 + y,208,34,34 );
	gfx.PutPixel( 24 + x,9 + y,208,34,34 );
	gfx.PutPixel( 25 + x,9 + y,208,34,34 );
	gfx.PutPixel( 26 + x,9 + y,208,34,34 );
	gfx.PutPixel( 27 + x,9 + y,208,34,34 );
	gfx.PutPixel( 28 + x,9 + y,208,34,34 );
	gfx.PutPixel( 29 + x,9 + y,208,34,34 );
	gfx.PutPixel( 30 + x,9 + y,208,34,34 );
	gfx.PutPixel( 31 + x,9 + y,208,34,34 );
	gfx.PutPixel( 32 + x,9 + y,208,34,34 );
	gfx.PutPixel( 33 + x,9 + y,208,34,34 );
	gfx.PutPixel( 34 + x,9 + y,208,34,34 );
	gfx.PutPixel( 35 + x,9 + y,208,34,34 );
	gfx.PutPixel( 36 + x,9 + y,208,34,34 );
	gfx.PutPixel( 37 + x,9 + y,208,34,34 );
	gfx.PutPixel( 38 + x,9 + y,208,34,34 );
	gfx.PutPixel( 39 + x,9 + y,208,34,34 );
	gfx.PutPixel( 40 + x,9 + y,208,34,34 );
	gfx.PutPixel( 41 + x,9 + y,208,34,34 );
	gfx.PutPixel( 42 + x,9 + y,208,34,34 );
	gfx.PutPixel( 43 + x,9 + y,208,34,34 );
	gfx.PutPixel( 44 + x,9 + y,208,34,34 );
	gfx.PutPixel( 45 + x,9 + y,208,34,34 );
	gfx.PutPixel( 46 + x,9 + y,208,34,34 );
	gfx.PutPixel( 47 + x,9 + y,208,34,34 );
	gfx.PutPixel( 48 + x,9 + y,208,34,34 );
	gfx.PutPixel( 49 + x,9 + y,208,34,34 );
	gfx.PutPixel( 50 + x,9 + y,208,34,34 );
	gfx.PutPixel( 51 + x,9 + y,208,34,34 );
	gfx.PutPixel( 52 + x,9 + y,208,34,34 );
	gfx.PutPixel( 53 + x,9 + y,208,34,34 );
	gfx.PutPixel( 54 + x,9 + y,208,34,34 );
	gfx.PutPixel( 55 + x,9 + y,208,34,34 );
	gfx.PutPixel( 56 + x,9 + y,208,34,34 );
	gfx.PutPixel( 57 + x,9 + y,208,34,34 );
	gfx.PutPixel( 58 + x,9 + y,208,34,34 );
	gfx.PutPixel( 59 + x,9 + y,208,34,34 );
	gfx.PutPixel( 60 + x,9 + y,208,34,34 );
	gfx.PutPixel( 61 + x,9 + y,208,34,34 );
	gfx.PutPixel( 62 + x,9 + y,208,34,34 );
	gfx.PutPixel( 63 + x,9 + y,208,34,34 );
	gfx.PutPixel( 64 + x,9 + y,208,34,34 );
	gfx.PutPixel( 65 + x,9 + y,208,34,34 );
	gfx.PutPixel( 66 + x,9 + y,208,34,34 );
	gfx.PutPixel( 67 + x,9 + y,208,34,34 );
	gfx.PutPixel( 68 + x,9 + y,208,34,34 );
	gfx.PutPixel( 69 + x,9 + y,208,34,34 );
	gfx.PutPixel( 70 + x,9 + y,208,34,34 );
	gfx.PutPixel( 71 + x,9 + y,208,33,33 );
	gfx.PutPixel( 72 + x,9 + y,208,37,37 );
	gfx.PutPixel( 73 + x,9 + y,209,47,47 );
	gfx.PutPixel( 74 + x,9 + y,216,155,155 );
	gfx.PutPixel( 75 + x,9 + y,214,120,120 );
	gfx.PutPixel( 76 + x,9 + y,208,40,40 );
	gfx.PutPixel( 77 + x,9 + y,208,35,35 );
	gfx.PutPixel( 78 + x,9 + y,208,34,34 );
	gfx.PutPixel( 79 + x,9 + y,208,34,34 );
	gfx.PutPixel( 80 + x,9 + y,208,34,34 );
	gfx.PutPixel( 81 + x,9 + y,208,34,34 );
	gfx.PutPixel( 82 + x,9 + y,208,34,34 );
	gfx.PutPixel( 83 + x,9 + y,208,34,34 );
	gfx.PutPixel( 84 + x,9 + y,208,34,34 );
	gfx.PutPixel( 85 + x,9 + y,208,34,34 );
	gfx.PutPixel( 86 + x,9 + y,208,34,34 );
	gfx.PutPixel( 87 + x,9 + y,208,34,34 );
	gfx.PutPixel( 88 + x,9 + y,208,34,34 );
	gfx.PutPixel( 89 + x,9 + y,208,34,34 );
	gfx.PutPixel( 90 + x,9 + y,208,34,34 );
	gfx.PutPixel( 91 + x,9 + y,208,34,34 );
	gfx.PutPixel( 92 + x,9 + y,208,34,34 );
	gfx.PutPixel( 93 + x,9 + y,208,34,34 );
	gfx.PutPixel( 94 + x,9 + y,208,34,34 );
	gfx.PutPixel( 95 + x,9 + y,208,34,34 );
	gfx.PutPixel( 96 + x,9 + y,208,34,34 );
	gfx.PutPixel( 97 + x,9 + y,208,34,34 );
	gfx.PutPixel( 98 + x,9 + y,208,34,34 );
	gfx.PutPixel( 99 + x,9 + y,208,34,34 );
	gfx.PutPixel( 100 + x,9 + y,208,34,34 );
	gfx.PutPixel( 101 + x,9 + y,208,34,34 );
	gfx.PutPixel( 102 + x,9 + y,208,34,34 );
	gfx.PutPixel( 103 + x,9 + y,208,34,34 );
	gfx.PutPixel( 104 + x,9 + y,208,34,34 );
	gfx.PutPixel( 105 + x,9 + y,208,34,34 );
	gfx.PutPixel( 106 + x,9 + y,208,34,34 );
	gfx.PutPixel( 107 + x,9 + y,208,34,34 );
	gfx.PutPixel( 108 + x,9 + y,208,34,34 );
	gfx.PutPixel( 109 + x,9 + y,208,34,34 );
	gfx.PutPixel( 110 + x,9 + y,208,34,34 );
	gfx.PutPixel( 111 + x,9 + y,208,34,34 );
	gfx.PutPixel( 112 + x,9 + y,208,34,34 );
	gfx.PutPixel( 113 + x,9 + y,208,34,34 );
	gfx.PutPixel( 114 + x,9 + y,208,34,34 );
	gfx.PutPixel( 115 + x,9 + y,208,34,34 );
	gfx.PutPixel( 116 + x,9 + y,208,34,34 );
	gfx.PutPixel( 117 + x,9 + y,208,34,34 );
	gfx.PutPixel( 118 + x,9 + y,208,34,34 );
	gfx.PutPixel( 119 + x,9 + y,208,34,34 );
	gfx.PutPixel( 120 + x,9 + y,208,34,34 );
	gfx.PutPixel( 121 + x,9 + y,208,34,34 );
	gfx.PutPixel( 122 + x,9 + y,208,34,34 );
	gfx.PutPixel( 123 + x,9 + y,208,34,34 );
	gfx.PutPixel( 124 + x,9 + y,208,34,34 );
	gfx.PutPixel( 125 + x,9 + y,208,34,34 );
	gfx.PutPixel( 126 + x,9 + y,208,34,34 );
	gfx.PutPixel( 127 + x,9 + y,208,34,34 );
	gfx.PutPixel( 128 + x,9 + y,208,34,34 );
	gfx.PutPixel( 129 + x,9 + y,208,34,34 );
	gfx.PutPixel( 130 + x,9 + y,208,34,34 );
	gfx.PutPixel( 131 + x,9 + y,208,34,34 );
	gfx.PutPixel( 132 + x,9 + y,208,34,34 );
	gfx.PutPixel( 133 + x,9 + y,208,34,34 );
	gfx.PutPixel( 134 + x,9 + y,208,34,34 );
	gfx.PutPixel( 135 + x,9 + y,208,34,34 );
	gfx.PutPixel( 136 + x,9 + y,208,34,34 );
	gfx.PutPixel( 137 + x,9 + y,208,34,34 );
	gfx.PutPixel( 138 + x,9 + y,208,34,34 );
	gfx.PutPixel( 139 + x,9 + y,208,34,34 );
	gfx.PutPixel( 140 + x,9 + y,208,34,34 );
	gfx.PutPixel( 141 + x,9 + y,208,34,34 );
	gfx.PutPixel( 142 + x,9 + y,208,34,34 );
	gfx.PutPixel( 143 + x,9 + y,208,34,34 );
	gfx.PutPixel( 144 + x,9 + y,208,34,34 );
	gfx.PutPixel( 145 + x,9 + y,208,34,34 );
	gfx.PutPixel( 146 + x,9 + y,208,34,34 );
	gfx.PutPixel( 147 + x,9 + y,208,34,34 );
	gfx.PutPixel( 148 + x,9 + y,208,34,34 );
	gfx.PutPixel( 149 + x,9 + y,208,34,34 );
	gfx.PutPixel( 0 + x,10 + y,208,34,34 );
	gfx.PutPixel( 1 + x,10 + y,208,34,34 );
	gfx.PutPixel( 2 + x,10 + y,208,34,34 );
	gfx.PutPixel( 3 + x,10 + y,208,34,34 );
	gfx.PutPixel( 4 + x,10 + y,208,34,34 );
	gfx.PutPixel( 5 + x,10 + y,208,34,34 );
	gfx.PutPixel( 6 + x,10 + y,208,34,34 );
	gfx.PutPixel( 7 + x,10 + y,208,34,34 );
	gfx.PutPixel( 8 + x,10 + y,208,34,34 );
	gfx.PutPixel( 9 + x,10 + y,208,34,34 );
	gfx.PutPixel( 10 + x,10 + y,208,34,34 );
	gfx.PutPixel( 11 + x,10 + y,208,34,34 );
	gfx.PutPixel( 12 + x,10 + y,208,34,34 );
	gfx.PutPixel( 13 + x,10 + y,208,34,34 );
	gfx.PutPixel( 14 + x,10 + y,208,34,34 );
	gfx.PutPixel( 15 + x,10 + y,208,34,34 );
	gfx.PutPixel( 16 + x,10 + y,208,34,34 );
	gfx.PutPixel( 17 + x,10 + y,208,34,34 );
	gfx.PutPixel( 18 + x,10 + y,208,34,34 );
	gfx.PutPixel( 19 + x,10 + y,208,34,34 );
	gfx.PutPixel( 20 + x,10 + y,208,34,34 );
	gfx.PutPixel( 21 + x,10 + y,208,34,34 );
	gfx.PutPixel( 22 + x,10 + y,208,34,34 );
	gfx.PutPixel( 23 + x,10 + y,208,34,34 );
	gfx.PutPixel( 24 + x,10 + y,208,34,34 );
	gfx.PutPixel( 25 + x,10 + y,208,34,34 );
	gfx.PutPixel( 26 + x,10 + y,208,34,34 );
	gfx.PutPixel( 27 + x,10 + y,208,34,34 );
	gfx.PutPixel( 28 + x,10 + y,208,34,34 );
	gfx.PutPixel( 29 + x,10 + y,208,34,34 );
	gfx.PutPixel( 30 + x,10 + y,208,34,34 );
	gfx.PutPixel( 31 + x,10 + y,208,34,34 );
	gfx.PutPixel( 32 + x,10 + y,208,34,34 );
	gfx.PutPixel( 33 + x,10 + y,208,34,34 );
	gfx.PutPixel( 34 + x,10 + y,208,34,34 );
	gfx.PutPixel( 35 + x,10 + y,208,34,34 );
	gfx.PutPixel( 36 + x,10 + y,208,34,34 );
	gfx.PutPixel( 37 + x,10 + y,208,34,34 );
	gfx.PutPixel( 38 + x,10 + y,208,34,34 );
	gfx.PutPixel( 39 + x,10 + y,208,34,34 );
	gfx.PutPixel( 40 + x,10 + y,208,34,34 );
	gfx.PutPixel( 41 + x,10 + y,208,34,34 );
	gfx.PutPixel( 42 + x,10 + y,208,34,34 );
	gfx.PutPixel( 43 + x,10 + y,208,34,34 );
	gfx.PutPixel( 44 + x,10 + y,208,34,34 );
	gfx.PutPixel( 45 + x,10 + y,208,34,34 );
	gfx.PutPixel( 46 + x,10 + y,208,34,34 );
	gfx.PutPixel( 47 + x,10 + y,208,34,34 );
	gfx.PutPixel( 48 + x,10 + y,208,34,34 );
	gfx.PutPixel( 49 + x,10 + y,208,34,34 );
	gfx.PutPixel( 50 + x,10 + y,208,34,34 );
	gfx.PutPixel( 51 + x,10 + y,208,34,34 );
	gfx.PutPixel( 52 + x,10 + y,208,34,34 );
	gfx.PutPixel( 53 + x,10 + y,208,34,34 );
	gfx.PutPixel( 54 + x,10 + y,208,34,34 );
	gfx.PutPixel( 55 + x,10 + y,208,34,34 );
	gfx.PutPixel( 56 + x,10 + y,208,34,34 );
	gfx.PutPixel( 57 + x,10 + y,208,34,34 );
	gfx.PutPixel( 58 + x,10 + y,208,34,34 );
	gfx.PutPixel( 59 + x,10 + y,208,34,34 );
	gfx.PutPixel( 60 + x,10 + y,208,34,34 );
	gfx.PutPixel( 61 + x,10 + y,208,34,34 );
	gfx.PutPixel( 62 + x,10 + y,208,34,34 );
	gfx.PutPixel( 63 + x,10 + y,208,34,34 );
	gfx.PutPixel( 64 + x,10 + y,208,34,34 );
	gfx.PutPixel( 65 + x,10 + y,208,34,34 );
	gfx.PutPixel( 66 + x,10 + y,208,34,34 );
	gfx.PutPixel( 67 + x,10 + y,208,34,34 );
	gfx.PutPixel( 68 + x,10 + y,208,34,34 );
	gfx.PutPixel( 69 + x,10 + y,208,34,34 );
	gfx.PutPixel( 70 + x,10 + y,208,30,30 );
	gfx.PutPixel( 71 + x,10 + y,207,24,24 );
	gfx.PutPixel( 72 + x,10 + y,208,40,40 );
	gfx.PutPixel( 73 + x,10 + y,215,129,129 );
	gfx.PutPixel( 74 + x,10 + y,217,160,160 );
	gfx.PutPixel( 75 + x,10 + y,216,157,157 );
	gfx.PutPixel( 76 + x,10 + y,213,104,104 );
	gfx.PutPixel( 77 + x,10 + y,208,24,24 );
	gfx.PutPixel( 78 + x,10 + y,208,27,27 );
	gfx.PutPixel( 79 + x,10 + y,208,34,34 );
	gfx.PutPixel( 80 + x,10 + y,208,34,34 );
	gfx.PutPixel( 81 + x,10 + y,208,34,34 );
	gfx.PutPixel( 82 + x,10 + y,208,34,34 );
	gfx.PutPixel( 83 + x,10 + y,208,34,34 );
	gfx.PutPixel( 84 + x,10 + y,208,34,34 );
	gfx.PutPixel( 85 + x,10 + y,208,34,34 );
	gfx.PutPixel( 86 + x,10 + y,208,34,34 );
	gfx.PutPixel( 87 + x,10 + y,208,34,34 );
	gfx.PutPixel( 88 + x,10 + y,208,34,34 );
	gfx.PutPixel( 89 + x,10 + y,208,34,34 );
	gfx.PutPixel( 90 + x,10 + y,208,34,34 );
	gfx.PutPixel( 91 + x,10 + y,208,34,34 );
	gfx.PutPixel( 92 + x,10 + y,208,34,34 );
	gfx.PutPixel( 93 + x,10 + y,208,34,34 );
	gfx.PutPixel( 94 + x,10 + y,208,34,34 );
	gfx.PutPixel( 95 + x,10 + y,208,34,34 );
	gfx.PutPixel( 96 + x,10 + y,208,34,34 );
	gfx.PutPixel( 97 + x,10 + y,208,34,34 );
	gfx.PutPixel( 98 + x,10 + y,208,34,34 );
	gfx.PutPixel( 99 + x,10 + y,208,34,34 );
	gfx.PutPixel( 100 + x,10 + y,208,34,34 );
	gfx.PutPixel( 101 + x,10 + y,208,34,34 );
	gfx.PutPixel( 102 + x,10 + y,208,34,34 );
	gfx.PutPixel( 103 + x,10 + y,208,34,34 );
	gfx.PutPixel( 104 + x,10 + y,208,34,34 );
	gfx.PutPixel( 105 + x,10 + y,208,34,34 );
	gfx.PutPixel( 106 + x,10 + y,208,34,34 );
	gfx.PutPixel( 107 + x,10 + y,208,34,34 );
	gfx.PutPixel( 108 + x,10 + y,208,34,34 );
	gfx.PutPixel( 109 + x,10 + y,208,34,34 );
	gfx.PutPixel( 110 + x,10 + y,208,34,34 );
	gfx.PutPixel( 111 + x,10 + y,208,34,34 );
	gfx.PutPixel( 112 + x,10 + y,208,34,34 );
	gfx.PutPixel( 113 + x,10 + y,208,34,34 );
	gfx.PutPixel( 114 + x,10 + y,208,34,34 );
	gfx.PutPixel( 115 + x,10 + y,208,34,34 );
	gfx.PutPixel( 116 + x,10 + y,208,34,34 );
	gfx.PutPixel( 117 + x,10 + y,208,34,34 );
	gfx.PutPixel( 118 + x,10 + y,208,34,34 );
	gfx.PutPixel( 119 + x,10 + y,208,34,34 );
	gfx.PutPixel( 120 + x,10 + y,208,34,34 );
	gfx.PutPixel( 121 + x,10 + y,208,34,34 );
	gfx.PutPixel( 122 + x,10 + y,208,34,34 );
	gfx.PutPixel( 123 + x,10 + y,208,34,34 );
	gfx.PutPixel( 124 + x,10 + y,208,34,34 );
	gfx.PutPixel( 125 + x,10 + y,208,34,34 );
	gfx.PutPixel( 126 + x,10 + y,208,34,34 );
	gfx.PutPixel( 127 + x,10 + y,208,34,34 );
	gfx.PutPixel( 128 + x,10 + y,208,34,34 );
	gfx.PutPixel( 129 + x,10 + y,208,34,34 );
	gfx.PutPixel( 130 + x,10 + y,208,34,34 );
	gfx.PutPixel( 131 + x,10 + y,208,34,34 );
	gfx.PutPixel( 132 + x,10 + y,208,34,34 );
	gfx.PutPixel( 133 + x,10 + y,208,34,34 );
	gfx.PutPixel( 134 + x,10 + y,208,34,34 );
	gfx.PutPixel( 135 + x,10 + y,208,34,34 );
	gfx.PutPixel( 136 + x,10 + y,208,34,34 );
	gfx.PutPixel( 137 + x,10 + y,208,34,34 );
	gfx.PutPixel( 138 + x,10 + y,208,34,34 );
	gfx.PutPixel( 139 + x,10 + y,208,34,34 );
	gfx.PutPixel( 140 + x,10 + y,208,34,34 );
	gfx.PutPixel( 141 + x,10 + y,208,34,34 );
	gfx.PutPixel( 142 + x,10 + y,208,34,34 );
	gfx.PutPixel( 143 + x,10 + y,208,34,34 );
	gfx.PutPixel( 144 + x,10 + y,208,34,34 );
	gfx.PutPixel( 145 + x,10 + y,208,34,34 );
	gfx.PutPixel( 146 + x,10 + y,208,34,34 );
	gfx.PutPixel( 147 + x,10 + y,208,34,34 );
	gfx.PutPixel( 148 + x,10 + y,208,34,34 );
	gfx.PutPixel( 149 + x,10 + y,208,34,34 );
	gfx.PutPixel( 0 + x,11 + y,208,34,34 );
	gfx.PutPixel( 1 + x,11 + y,208,34,34 );
	gfx.PutPixel( 2 + x,11 + y,208,34,34 );
	gfx.PutPixel( 3 + x,11 + y,208,34,34 );
	gfx.PutPixel( 4 + x,11 + y,208,34,34 );
	gfx.PutPixel( 5 + x,11 + y,208,34,34 );
	gfx.PutPixel( 6 + x,11 + y,208,34,34 );
	gfx.PutPixel( 7 + x,11 + y,208,34,34 );
	gfx.PutPixel( 8 + x,11 + y,208,34,34 );
	gfx.PutPixel( 9 + x,11 + y,208,34,34 );
	gfx.PutPixel( 10 + x,11 + y,208,34,34 );
	gfx.PutPixel( 11 + x,11 + y,208,34,34 );
	gfx.PutPixel( 12 + x,11 + y,208,34,34 );
	gfx.PutPixel( 13 + x,11 + y,208,34,34 );
	gfx.PutPixel( 14 + x,11 + y,208,34,34 );
	gfx.PutPixel( 15 + x,11 + y,208,34,34 );
	gfx.PutPixel( 16 + x,11 + y,208,34,34 );
	gfx.PutPixel( 17 + x,11 + y,208,34,34 );
	gfx.PutPixel( 18 + x,11 + y,208,34,34 );
	gfx.PutPixel( 19 + x,11 + y,208,34,34 );
	gfx.PutPixel( 20 + x,11 + y,208,34,34 );
	gfx.PutPixel( 21 + x,11 + y,208,34,34 );
	gfx.PutPixel( 22 + x,11 + y,208,34,34 );
	gfx.PutPixel( 23 + x,11 + y,208,34,34 );
	gfx.PutPixel( 24 + x,11 + y,208,34,34 );
	gfx.PutPixel( 25 + x,11 + y,208,34,34 );
	gfx.PutPixel( 26 + x,11 + y,208,34,34 );
	gfx.PutPixel( 27 + x,11 + y,208,34,34 );
	gfx.PutPixel( 28 + x,11 + y,208,34,34 );
	gfx.PutPixel( 29 + x,11 + y,208,34,34 );
	gfx.PutPixel( 30 + x,11 + y,208,34,34 );
	gfx.PutPixel( 31 + x,11 + y,208,34,34 );
	gfx.PutPixel( 32 + x,11 + y,208,34,34 );
	gfx.PutPixel( 33 + x,11 + y,208,34,34 );
	gfx.PutPixel( 34 + x,11 + y,208,34,34 );
	gfx.PutPixel( 35 + x,11 + y,208,34,34 );
	gfx.PutPixel( 36 + x,11 + y,208,34,34 );
	gfx.PutPixel( 37 + x,11 + y,208,34,34 );
	gfx.PutPixel( 38 + x,11 + y,208,34,34 );
	gfx.PutPixel( 39 + x,11 + y,208,34,34 );
	gfx.PutPixel( 40 + x,11 + y,208,34,34 );
	gfx.PutPixel( 41 + x,11 + y,208,34,34 );
	gfx.PutPixel( 42 + x,11 + y,208,34,34 );
	gfx.PutPixel( 43 + x,11 + y,208,34,34 );
	gfx.PutPixel( 44 + x,11 + y,208,34,34 );
	gfx.PutPixel( 45 + x,11 + y,208,34,34 );
	gfx.PutPixel( 46 + x,11 + y,208,34,34 );
	gfx.PutPixel( 47 + x,11 + y,208,34,34 );
	gfx.PutPixel( 48 + x,11 + y,208,34,34 );
	gfx.PutPixel( 49 + x,11 + y,208,34,34 );
	gfx.PutPixel( 50 + x,11 + y,208,34,34 );
	gfx.PutPixel( 51 + x,11 + y,208,34,34 );
	gfx.PutPixel( 52 + x,11 + y,208,34,34 );
	gfx.PutPixel( 53 + x,11 + y,208,34,34 );
	gfx.PutPixel( 54 + x,11 + y,208,34,34 );
	gfx.PutPixel( 55 + x,11 + y,208,34,34 );
	gfx.PutPixel( 56 + x,11 + y,208,34,34 );
	gfx.PutPixel( 57 + x,11 + y,208,34,34 );
	gfx.PutPixel( 58 + x,11 + y,208,34,34 );
	gfx.PutPixel( 59 + x,11 + y,208,34,34 );
	gfx.PutPixel( 60 + x,11 + y,208,34,34 );
	gfx.PutPixel( 61 + x,11 + y,208,34,34 );
	gfx.PutPixel( 62 + x,11 + y,208,34,34 );
	gfx.PutPixel( 63 + x,11 + y,208,34,34 );
	gfx.PutPixel( 64 + x,11 + y,208,34,34 );
	gfx.PutPixel( 65 + x,11 + y,208,34,34 );
	gfx.PutPixel( 66 + x,11 + y,208,33,33 );
	gfx.PutPixel( 67 + x,11 + y,208,34,34 );
	gfx.PutPixel( 68 + x,11 + y,208,27,27 );
	gfx.PutPixel( 69 + x,11 + y,207,23,23 );
	gfx.PutPixel( 70 + x,11 + y,209,55,55 );
	gfx.PutPixel( 71 + x,11 + y,212,82,82 );
	gfx.PutPixel( 72 + x,11 + y,211,72,72 );
	gfx.PutPixel( 73 + x,11 + y,218,179,179 );
	gfx.PutPixel( 74 + x,11 + y,215,138,138 );
	gfx.PutPixel( 75 + x,11 + y,216,144,144 );
	gfx.PutPixel( 76 + x,11 + y,217,165,165 );
	gfx.PutPixel( 77 + x,11 + y,209,50,50 );
	gfx.PutPixel( 78 + x,11 + y,211,71,71 );
	gfx.PutPixel( 79 + x,11 + y,208,31,31 );
	gfx.PutPixel( 80 + x,11 + y,207,23,23 );
	gfx.PutPixel( 81 + x,11 + y,208,30,30 );
	gfx.PutPixel( 82 + x,11 + y,208,34,34 );
	gfx.PutPixel( 83 + x,11 + y,208,34,34 );
	gfx.PutPixel( 84 + x,11 + y,208,34,34 );
	gfx.PutPixel( 85 + x,11 + y,208,34,34 );
	gfx.PutPixel( 86 + x,11 + y,208,34,34 );
	gfx.PutPixel( 87 + x,11 + y,208,34,34 );
	gfx.PutPixel( 88 + x,11 + y,208,34,34 );
	gfx.PutPixel( 89 + x,11 + y,208,34,34 );
	gfx.PutPixel( 90 + x,11 + y,208,34,34 );
	gfx.PutPixel( 91 + x,11 + y,208,34,34 );
	gfx.PutPixel( 92 + x,11 + y,208,34,34 );
	gfx.PutPixel( 93 + x,11 + y,208,34,34 );
	gfx.PutPixel( 94 + x,11 + y,208,34,34 );
	gfx.PutPixel( 95 + x,11 + y,208,34,34 );
	gfx.PutPixel( 96 + x,11 + y,208,34,34 );
	gfx.PutPixel( 97 + x,11 + y,208,34,34 );
	gfx.PutPixel( 98 + x,11 + y,208,34,34 );
	gfx.PutPixel( 99 + x,11 + y,208,34,34 );
	gfx.PutPixel( 100 + x,11 + y,208,34,34 );
	gfx.PutPixel( 101 + x,11 + y,208,34,34 );
	gfx.PutPixel( 102 + x,11 + y,208,34,34 );
	gfx.PutPixel( 103 + x,11 + y,208,34,34 );
	gfx.PutPixel( 104 + x,11 + y,208,34,34 );
	gfx.PutPixel( 105 + x,11 + y,208,34,34 );
	gfx.PutPixel( 106 + x,11 + y,208,34,34 );
	gfx.PutPixel( 107 + x,11 + y,208,34,34 );
	gfx.PutPixel( 108 + x,11 + y,208,34,34 );
	gfx.PutPixel( 109 + x,11 + y,208,34,34 );
	gfx.PutPixel( 110 + x,11 + y,208,34,34 );
	gfx.PutPixel( 111 + x,11 + y,208,34,34 );
	gfx.PutPixel( 112 + x,11 + y,208,34,34 );
	gfx.PutPixel( 113 + x,11 + y,208,34,34 );
	gfx.PutPixel( 114 + x,11 + y,208,34,34 );
	gfx.PutPixel( 115 + x,11 + y,208,34,34 );
	gfx.PutPixel( 116 + x,11 + y,208,34,34 );
	gfx.PutPixel( 117 + x,11 + y,208,34,34 );
	gfx.PutPixel( 118 + x,11 + y,208,34,34 );
	gfx.PutPixel( 119 + x,11 + y,208,34,34 );
	gfx.PutPixel( 120 + x,11 + y,208,34,34 );
	gfx.PutPixel( 121 + x,11 + y,208,34,34 );
	gfx.PutPixel( 122 + x,11 + y,208,34,34 );
	gfx.PutPixel( 123 + x,11 + y,208,34,34 );
	gfx.PutPixel( 124 + x,11 + y,208,34,34 );
	gfx.PutPixel( 125 + x,11 + y,208,34,34 );
	gfx.PutPixel( 126 + x,11 + y,208,34,34 );
	gfx.PutPixel( 127 + x,11 + y,208,34,34 );
	gfx.PutPixel( 128 + x,11 + y,208,34,34 );
	gfx.PutPixel( 129 + x,11 + y,208,34,34 );
	gfx.PutPixel( 130 + x,11 + y,208,34,34 );
	gfx.PutPixel( 131 + x,11 + y,208,34,34 );
	gfx.PutPixel( 132 + x,11 + y,208,34,34 );
	gfx.PutPixel( 133 + x,11 + y,208,34,34 );
	gfx.PutPixel( 134 + x,11 + y,208,34,34 );
	gfx.PutPixel( 135 + x,11 + y,208,34,34 );
	gfx.PutPixel( 136 + x,11 + y,208,34,34 );
	gfx.PutPixel( 137 + x,11 + y,208,34,34 );
	gfx.PutPixel( 138 + x,11 + y,208,34,34 );
	gfx.PutPixel( 139 + x,11 + y,208,34,34 );
	gfx.PutPixel( 140 + x,11 + y,208,34,34 );
	gfx.PutPixel( 141 + x,11 + y,208,34,34 );
	gfx.PutPixel( 142 + x,11 + y,208,34,34 );
	gfx.PutPixel( 143 + x,11 + y,208,34,34 );
	gfx.PutPixel( 144 + x,11 + y,208,34,34 );
	gfx.PutPixel( 145 + x,11 + y,208,34,34 );
	gfx.PutPixel( 146 + x,11 + y,208,34,34 );
	gfx.PutPixel( 147 + x,11 + y,208,34,34 );
	gfx.PutPixel( 148 + x,11 + y,208,34,34 );
	gfx.PutPixel( 149 + x,11 + y,208,34,34 );
	gfx.PutPixel( 0 + x,12 + y,208,34,34 );
	gfx.PutPixel( 1 + x,12 + y,208,34,34 );
	gfx.PutPixel( 2 + x,12 + y,208,34,34 );
	gfx.PutPixel( 3 + x,12 + y,208,34,34 );
	gfx.PutPixel( 4 + x,12 + y,208,34,34 );
	gfx.PutPixel( 5 + x,12 + y,208,34,34 );
	gfx.PutPixel( 6 + x,12 + y,208,34,34 );
	gfx.PutPixel( 7 + x,12 + y,208,34,34 );
	gfx.PutPixel( 8 + x,12 + y,208,34,34 );
	gfx.PutPixel( 9 + x,12 + y,208,34,34 );
	gfx.PutPixel( 10 + x,12 + y,208,34,34 );
	gfx.PutPixel( 11 + x,12 + y,208,34,34 );
	gfx.PutPixel( 12 + x,12 + y,208,34,34 );
	gfx.PutPixel( 13 + x,12 + y,208,34,34 );
	gfx.PutPixel( 14 + x,12 + y,208,34,34 );
	gfx.PutPixel( 15 + x,12 + y,208,34,34 );
	gfx.PutPixel( 16 + x,12 + y,208,34,34 );
	gfx.PutPixel( 17 + x,12 + y,208,34,34 );
	gfx.PutPixel( 18 + x,12 + y,208,34,34 );
	gfx.PutPixel( 19 + x,12 + y,208,34,34 );
	gfx.PutPixel( 20 + x,12 + y,208,34,34 );
	gfx.PutPixel( 21 + x,12 + y,208,34,34 );
	gfx.PutPixel( 22 + x,12 + y,208,34,34 );
	gfx.PutPixel( 23 + x,12 + y,208,34,34 );
	gfx.PutPixel( 24 + x,12 + y,208,34,34 );
	gfx.PutPixel( 25 + x,12 + y,208,34,34 );
	gfx.PutPixel( 26 + x,12 + y,208,34,34 );
	gfx.PutPixel( 27 + x,12 + y,208,34,34 );
	gfx.PutPixel( 28 + x,12 + y,208,34,34 );
	gfx.PutPixel( 29 + x,12 + y,208,34,34 );
	gfx.PutPixel( 30 + x,12 + y,208,34,34 );
	gfx.PutPixel( 31 + x,12 + y,208,34,34 );
	gfx.PutPixel( 32 + x,12 + y,208,34,34 );
	gfx.PutPixel( 33 + x,12 + y,208,34,34 );
	gfx.PutPixel( 34 + x,12 + y,208,34,34 );
	gfx.PutPixel( 35 + x,12 + y,208,34,34 );
	gfx.PutPixel( 36 + x,12 + y,208,34,34 );
	gfx.PutPixel( 37 + x,12 + y,208,34,34 );
	gfx.PutPixel( 38 + x,12 + y,208,34,34 );
	gfx.PutPixel( 39 + x,12 + y,208,34,34 );
	gfx.PutPixel( 40 + x,12 + y,208,34,34 );
	gfx.PutPixel( 41 + x,12 + y,208,34,34 );
	gfx.PutPixel( 42 + x,12 + y,208,34,34 );
	gfx.PutPixel( 43 + x,12 + y,208,34,34 );
	gfx.PutPixel( 44 + x,12 + y,208,34,34 );
	gfx.PutPixel( 45 + x,12 + y,208,34,34 );
	gfx.PutPixel( 46 + x,12 + y,208,34,34 );
	gfx.PutPixel( 47 + x,12 + y,208,34,34 );
	gfx.PutPixel( 48 + x,12 + y,208,34,34 );
	gfx.PutPixel( 49 + x,12 + y,208,34,34 );
	gfx.PutPixel( 50 + x,12 + y,208,34,34 );
	gfx.PutPixel( 51 + x,12 + y,208,34,34 );
	gfx.PutPixel( 52 + x,12 + y,208,34,34 );
	gfx.PutPixel( 53 + x,12 + y,208,34,34 );
	gfx.PutPixel( 54 + x,12 + y,208,34,34 );
	gfx.PutPixel( 55 + x,12 + y,208,34,34 );
	gfx.PutPixel( 56 + x,12 + y,208,34,34 );
	gfx.PutPixel( 57 + x,12 + y,208,34,34 );
	gfx.PutPixel( 58 + x,12 + y,208,34,34 );
	gfx.PutPixel( 59 + x,12 + y,208,34,34 );
	gfx.PutPixel( 60 + x,12 + y,208,34,34 );
	gfx.PutPixel( 61 + x,12 + y,208,34,34 );
	gfx.PutPixel( 62 + x,12 + y,208,34,34 );
	gfx.PutPixel( 63 + x,12 + y,208,34,34 );
	gfx.PutPixel( 64 + x,12 + y,208,34,34 );
	gfx.PutPixel( 65 + x,12 + y,208,33,33 );
	gfx.PutPixel( 66 + x,12 + y,208,30,30 );
	gfx.PutPixel( 67 + x,12 + y,208,25,25 );
	gfx.PutPixel( 68 + x,12 + y,214,122,122 );
	gfx.PutPixel( 69 + x,12 + y,214,123,123 );
	gfx.PutPixel( 70 + x,12 + y,214,127,127 );
	gfx.PutPixel( 71 + x,12 + y,221,227,227 );
	gfx.PutPixel( 72 + x,12 + y,210,58,58 );
	gfx.PutPixel( 73 + x,12 + y,217,156,156 );
	gfx.PutPixel( 74 + x,12 + y,214,114,114 );
	gfx.PutPixel( 75 + x,12 + y,215,143,143 );
	gfx.PutPixel( 76 + x,12 + y,213,111,111 );
	gfx.PutPixel( 77 + x,12 + y,215,131,131 );
	gfx.PutPixel( 78 + x,12 + y,221,218,218 );
	gfx.PutPixel( 79 + x,12 + y,210,62,62 );
	gfx.PutPixel( 80 + x,12 + y,215,133,133 );
	gfx.PutPixel( 81 + x,12 + y,210,67,67 );
	gfx.PutPixel( 82 + x,12 + y,207,21,21 );
	gfx.PutPixel( 83 + x,12 + y,208,29,29 );
	gfx.PutPixel( 84 + x,12 + y,208,34,34 );
	gfx.PutPixel( 85 + x,12 + y,208,34,34 );
	gfx.PutPixel( 86 + x,12 + y,208,34,34 );
	gfx.PutPixel( 87 + x,12 + y,208,34,34 );
	gfx.PutPixel( 88 + x,12 + y,208,34,34 );
	gfx.PutPixel( 89 + x,12 + y,208,34,34 );
	gfx.PutPixel( 90 + x,12 + y,208,34,34 );
	gfx.PutPixel( 91 + x,12 + y,208,34,34 );
	gfx.PutPixel( 92 + x,12 + y,208,34,34 );
	gfx.PutPixel( 93 + x,12 + y,208,34,34 );
	gfx.PutPixel( 94 + x,12 + y,208,34,34 );
	gfx.PutPixel( 95 + x,12 + y,208,34,34 );
	gfx.PutPixel( 96 + x,12 + y,208,34,34 );
	gfx.PutPixel( 97 + x,12 + y,208,34,34 );
	gfx.PutPixel( 98 + x,12 + y,208,34,34 );
	gfx.PutPixel( 99 + x,12 + y,208,34,34 );
	gfx.PutPixel( 100 + x,12 + y,208,34,34 );
	gfx.PutPixel( 101 + x,12 + y,208,34,34 );
	gfx.PutPixel( 102 + x,12 + y,208,34,34 );
	gfx.PutPixel( 103 + x,12 + y,208,34,34 );
	gfx.PutPixel( 104 + x,12 + y,208,34,34 );
	gfx.PutPixel( 105 + x,12 + y,208,34,34 );
	gfx.PutPixel( 106 + x,12 + y,208,34,34 );
	gfx.PutPixel( 107 + x,12 + y,208,34,34 );
	gfx.PutPixel( 108 + x,12 + y,208,34,34 );
	gfx.PutPixel( 109 + x,12 + y,208,34,34 );
	gfx.PutPixel( 110 + x,12 + y,208,34,34 );
	gfx.PutPixel( 111 + x,12 + y,208,34,34 );
	gfx.PutPixel( 112 + x,12 + y,208,34,34 );
	gfx.PutPixel( 113 + x,12 + y,208,34,34 );
	gfx.PutPixel( 114 + x,12 + y,208,34,34 );
	gfx.PutPixel( 115 + x,12 + y,208,34,34 );
	gfx.PutPixel( 116 + x,12 + y,208,34,34 );
	gfx.PutPixel( 117 + x,12 + y,208,34,34 );
	gfx.PutPixel( 118 + x,12 + y,208,34,34 );
	gfx.PutPixel( 119 + x,12 + y,208,34,34 );
	gfx.PutPixel( 120 + x,12 + y,208,34,34 );
	gfx.PutPixel( 121 + x,12 + y,208,34,34 );
	gfx.PutPixel( 122 + x,12 + y,208,34,34 );
	gfx.PutPixel( 123 + x,12 + y,208,34,34 );
	gfx.PutPixel( 124 + x,12 + y,208,34,34 );
	gfx.PutPixel( 125 + x,12 + y,208,34,34 );
	gfx.PutPixel( 126 + x,12 + y,208,34,34 );
	gfx.PutPixel( 127 + x,12 + y,208,34,34 );
	gfx.PutPixel( 128 + x,12 + y,208,34,34 );
	gfx.PutPixel( 129 + x,12 + y,208,34,34 );
	gfx.PutPixel( 130 + x,12 + y,208,34,34 );
	gfx.PutPixel( 131 + x,12 + y,208,34,34 );
	gfx.PutPixel( 132 + x,12 + y,208,34,34 );
	gfx.PutPixel( 133 + x,12 + y,208,34,34 );
	gfx.PutPixel( 134 + x,12 + y,208,34,34 );
	gfx.PutPixel( 135 + x,12 + y,208,34,34 );
	gfx.PutPixel( 136 + x,12 + y,208,34,34 );
	gfx.PutPixel( 137 + x,12 + y,208,34,34 );
	gfx.PutPixel( 138 + x,12 + y,208,34,34 );
	gfx.PutPixel( 139 + x,12 + y,208,34,34 );
	gfx.PutPixel( 140 + x,12 + y,208,34,34 );
	gfx.PutPixel( 141 + x,12 + y,208,34,34 );
	gfx.PutPixel( 142 + x,12 + y,208,34,34 );
	gfx.PutPixel( 143 + x,12 + y,208,34,34 );
	gfx.PutPixel( 144 + x,12 + y,208,34,34 );
	gfx.PutPixel( 145 + x,12 + y,208,34,34 );
	gfx.PutPixel( 146 + x,12 + y,208,34,34 );
	gfx.PutPixel( 147 + x,12 + y,208,34,34 );
	gfx.PutPixel( 148 + x,12 + y,208,34,34 );
	gfx.PutPixel( 149 + x,12 + y,208,34,34 );
	gfx.PutPixel( 0 + x,13 + y,208,34,34 );
	gfx.PutPixel( 1 + x,13 + y,208,34,34 );
	gfx.PutPixel( 2 + x,13 + y,208,34,34 );
	gfx.PutPixel( 3 + x,13 + y,208,34,34 );
	gfx.PutPixel( 4 + x,13 + y,208,34,34 );
	gfx.PutPixel( 5 + x,13 + y,208,34,34 );
	gfx.PutPixel( 6 + x,13 + y,208,34,34 );
	gfx.PutPixel( 7 + x,13 + y,208,34,34 );
	gfx.PutPixel( 8 + x,13 + y,208,34,34 );
	gfx.PutPixel( 9 + x,13 + y,208,34,34 );
	gfx.PutPixel( 10 + x,13 + y,208,34,34 );
	gfx.PutPixel( 11 + x,13 + y,208,34,34 );
	gfx.PutPixel( 12 + x,13 + y,208,34,34 );
	gfx.PutPixel( 13 + x,13 + y,208,34,34 );
	gfx.PutPixel( 14 + x,13 + y,208,34,34 );
	gfx.PutPixel( 15 + x,13 + y,208,34,34 );
	gfx.PutPixel( 16 + x,13 + y,208,34,34 );
	gfx.PutPixel( 17 + x,13 + y,208,34,34 );
	gfx.PutPixel( 18 + x,13 + y,208,34,34 );
	gfx.PutPixel( 19 + x,13 + y,208,34,34 );
	gfx.PutPixel( 20 + x,13 + y,208,34,34 );
	gfx.PutPixel( 21 + x,13 + y,208,34,34 );
	gfx.PutPixel( 22 + x,13 + y,208,34,34 );
	gfx.PutPixel( 23 + x,13 + y,208,34,34 );
	gfx.PutPixel( 24 + x,13 + y,208,34,34 );
	gfx.PutPixel( 25 + x,13 + y,208,34,34 );
	gfx.PutPixel( 26 + x,13 + y,208,34,34 );
	gfx.PutPixel( 27 + x,13 + y,208,34,34 );
	gfx.PutPixel( 28 + x,13 + y,208,34,34 );
	gfx.PutPixel( 29 + x,13 + y,208,34,34 );
	gfx.PutPixel( 30 + x,13 + y,208,34,34 );
	gfx.PutPixel( 31 + x,13 + y,208,34,34 );
	gfx.PutPixel( 32 + x,13 + y,208,34,34 );
	gfx.PutPixel( 33 + x,13 + y,208,34,34 );
	gfx.PutPixel( 34 + x,13 + y,208,34,34 );
	gfx.PutPixel( 35 + x,13 + y,208,34,34 );
	gfx.PutPixel( 36 + x,13 + y,208,34,34 );
	gfx.PutPixel( 37 + x,13 + y,208,34,34 );
	gfx.PutPixel( 38 + x,13 + y,208,34,34 );
	gfx.PutPixel( 39 + x,13 + y,208,34,34 );
	gfx.PutPixel( 40 + x,13 + y,208,34,34 );
	gfx.PutPixel( 41 + x,13 + y,208,34,34 );
	gfx.PutPixel( 42 + x,13 + y,208,34,34 );
	gfx.PutPixel( 43 + x,13 + y,208,34,34 );
	gfx.PutPixel( 44 + x,13 + y,208,34,34 );
	gfx.PutPixel( 45 + x,13 + y,208,34,34 );
	gfx.PutPixel( 46 + x,13 + y,208,34,34 );
	gfx.PutPixel( 47 + x,13 + y,208,34,34 );
	gfx.PutPixel( 48 + x,13 + y,208,34,34 );
	gfx.PutPixel( 49 + x,13 + y,208,34,34 );
	gfx.PutPixel( 50 + x,13 + y,208,34,34 );
	gfx.PutPixel( 51 + x,13 + y,208,34,34 );
	gfx.PutPixel( 52 + x,13 + y,208,34,34 );
	gfx.PutPixel( 53 + x,13 + y,208,34,34 );
	gfx.PutPixel( 54 + x,13 + y,208,34,34 );
	gfx.PutPixel( 55 + x,13 + y,208,34,34 );
	gfx.PutPixel( 56 + x,13 + y,208,34,34 );
	gfx.PutPixel( 57 + x,13 + y,208,34,34 );
	gfx.PutPixel( 58 + x,13 + y,208,34,34 );
	gfx.PutPixel( 59 + x,13 + y,208,34,34 );
	gfx.PutPixel( 60 + x,13 + y,208,34,34 );
	gfx.PutPixel( 61 + x,13 + y,208,34,34 );
	gfx.PutPixel( 62 + x,13 + y,208,34,34 );
	gfx.PutPixel( 63 + x,13 + y,208,34,34 );
	gfx.PutPixel( 64 + x,13 + y,208,29,29 );
	gfx.PutPixel( 65 + x,13 + y,208,29,29 );
	gfx.PutPixel( 66 + x,13 + y,217,163,163 );
	gfx.PutPixel( 67 + x,13 + y,214,120,120 );
	gfx.PutPixel( 68 + x,13 + y,215,138,138 );
	gfx.PutPixel( 69 + x,13 + y,217,158,158 );
	gfx.PutPixel( 70 + x,13 + y,209,55,55 );
	gfx.PutPixel( 71 + x,13 + y,214,125,125 );
	gfx.PutPixel( 72 + x,13 + y,211,73,73 );
	gfx.PutPixel( 73 + x,13 + y,208,37,37 );
	gfx.PutPixel( 74 + x,13 + y,215,140,140 );
	gfx.PutPixel( 75 + x,13 + y,213,109,109 );
	gfx.PutPixel( 76 + x,13 + y,208,31,31 );
	gfx.PutPixel( 77 + x,13 + y,214,121,121 );
	gfx.PutPixel( 78 + x,13 + y,214,119,119 );
	gfx.PutPixel( 79 + x,13 + y,210,60,60 );
	gfx.PutPixel( 80 + x,13 + y,220,208,208 );
	gfx.PutPixel( 81 + x,13 + y,213,105,105 );
	gfx.PutPixel( 82 + x,13 + y,216,143,143 );
	gfx.PutPixel( 83 + x,13 + y,212,99,99 );
	gfx.PutPixel( 84 + x,13 + y,207,18,18 );
	gfx.PutPixel( 85 + x,13 + y,208,31,31 );
	gfx.PutPixel( 86 + x,13 + y,208,34,34 );
	gfx.PutPixel( 87 + x,13 + y,208,34,34 );
	gfx.PutPixel( 88 + x,13 + y,208,34,34 );
	gfx.PutPixel( 89 + x,13 + y,208,34,34 );
	gfx.PutPixel( 90 + x,13 + y,208,34,34 );
	gfx.PutPixel( 91 + x,13 + y,208,34,34 );
	gfx.PutPixel( 92 + x,13 + y,208,34,34 );
	gfx.PutPixel( 93 + x,13 + y,208,34,34 );
	gfx.PutPixel( 94 + x,13 + y,208,34,34 );
	gfx.PutPixel( 95 + x,13 + y,208,34,34 );
	gfx.PutPixel( 96 + x,13 + y,208,34,34 );
	gfx.PutPixel( 97 + x,13 + y,208,34,34 );
	gfx.PutPixel( 98 + x,13 + y,208,34,34 );
	gfx.PutPixel( 99 + x,13 + y,208,34,34 );
	gfx.PutPixel( 100 + x,13 + y,208,34,34 );
	gfx.PutPixel( 101 + x,13 + y,208,34,34 );
	gfx.PutPixel( 102 + x,13 + y,208,34,34 );
	gfx.PutPixel( 103 + x,13 + y,208,34,34 );
	gfx.PutPixel( 104 + x,13 + y,208,34,34 );
	gfx.PutPixel( 105 + x,13 + y,208,34,34 );
	gfx.PutPixel( 106 + x,13 + y,208,34,34 );
	gfx.PutPixel( 107 + x,13 + y,208,34,34 );
	gfx.PutPixel( 108 + x,13 + y,208,34,34 );
	gfx.PutPixel( 109 + x,13 + y,208,34,34 );
	gfx.PutPixel( 110 + x,13 + y,208,34,34 );
	gfx.PutPixel( 111 + x,13 + y,208,34,34 );
	gfx.PutPixel( 112 + x,13 + y,208,34,34 );
	gfx.PutPixel( 113 + x,13 + y,208,34,34 );
	gfx.PutPixel( 114 + x,13 + y,208,34,34 );
	gfx.PutPixel( 115 + x,13 + y,208,34,34 );
	gfx.PutPixel( 116 + x,13 + y,208,34,34 );
	gfx.PutPixel( 117 + x,13 + y,208,34,34 );
	gfx.PutPixel( 118 + x,13 + y,208,34,34 );
	gfx.PutPixel( 119 + x,13 + y,208,34,34 );
	gfx.PutPixel( 120 + x,13 + y,208,34,34 );
	gfx.PutPixel( 121 + x,13 + y,208,34,34 );
	gfx.PutPixel( 122 + x,13 + y,208,34,34 );
	gfx.PutPixel( 123 + x,13 + y,208,34,34 );
	gfx.PutPixel( 124 + x,13 + y,208,34,34 );
	gfx.PutPixel( 125 + x,13 + y,208,34,34 );
	gfx.PutPixel( 126 + x,13 + y,208,34,34 );
	gfx.PutPixel( 127 + x,13 + y,208,34,34 );
	gfx.PutPixel( 128 + x,13 + y,208,34,34 );
	gfx.PutPixel( 129 + x,13 + y,208,34,34 );
	gfx.PutPixel( 130 + x,13 + y,208,34,34 );
	gfx.PutPixel( 131 + x,13 + y,208,34,34 );
	gfx.PutPixel( 132 + x,13 + y,208,34,34 );
	gfx.PutPixel( 133 + x,13 + y,208,34,34 );
	gfx.PutPixel( 134 + x,13 + y,208,34,34 );
	gfx.PutPixel( 135 + x,13 + y,208,34,34 );
	gfx.PutPixel( 136 + x,13 + y,208,34,34 );
	gfx.PutPixel( 137 + x,13 + y,208,34,34 );
	gfx.PutPixel( 138 + x,13 + y,208,34,34 );
	gfx.PutPixel( 139 + x,13 + y,208,34,34 );
	gfx.PutPixel( 140 + x,13 + y,208,34,34 );
	gfx.PutPixel( 141 + x,13 + y,208,34,34 );
	gfx.PutPixel( 142 + x,13 + y,208,34,34 );
	gfx.PutPixel( 143 + x,13 + y,208,34,34 );
	gfx.PutPixel( 144 + x,13 + y,208,34,34 );
	gfx.PutPixel( 145 + x,13 + y,208,34,34 );
	gfx.PutPixel( 146 + x,13 + y,208,34,34 );
	gfx.PutPixel( 147 + x,13 + y,208,34,34 );
	gfx.PutPixel( 148 + x,13 + y,208,34,34 );
	gfx.PutPixel( 149 + x,13 + y,208,34,34 );
	gfx.PutPixel( 0 + x,14 + y,208,34,34 );
	gfx.PutPixel( 1 + x,14 + y,208,34,34 );
	gfx.PutPixel( 2 + x,14 + y,208,34,34 );
	gfx.PutPixel( 3 + x,14 + y,208,34,34 );
	gfx.PutPixel( 4 + x,14 + y,208,34,34 );
	gfx.PutPixel( 5 + x,14 + y,208,34,34 );
	gfx.PutPixel( 6 + x,14 + y,208,34,34 );
	gfx.PutPixel( 7 + x,14 + y,208,34,34 );
	gfx.PutPixel( 8 + x,14 + y,208,34,34 );
	gfx.PutPixel( 9 + x,14 + y,208,34,34 );
	gfx.PutPixel( 10 + x,14 + y,208,34,34 );
	gfx.PutPixel( 11 + x,14 + y,208,34,34 );
	gfx.PutPixel( 12 + x,14 + y,208,34,34 );
	gfx.PutPixel( 13 + x,14 + y,208,34,34 );
	gfx.PutPixel( 14 + x,14 + y,208,34,34 );
	gfx.PutPixel( 15 + x,14 + y,208,34,34 );
	gfx.PutPixel( 16 + x,14 + y,208,34,34 );
	gfx.PutPixel( 17 + x,14 + y,208,34,34 );
	gfx.PutPixel( 18 + x,14 + y,208,34,34 );
	gfx.PutPixel( 19 + x,14 + y,208,34,34 );
	gfx.PutPixel( 20 + x,14 + y,208,34,34 );
	gfx.PutPixel( 21 + x,14 + y,208,34,34 );
	gfx.PutPixel( 22 + x,14 + y,208,34,34 );
	gfx.PutPixel( 23 + x,14 + y,208,34,34 );
	gfx.PutPixel( 24 + x,14 + y,208,34,34 );
	gfx.PutPixel( 25 + x,14 + y,208,34,34 );
	gfx.PutPixel( 26 + x,14 + y,208,34,34 );
	gfx.PutPixel( 27 + x,14 + y,208,34,34 );
	gfx.PutPixel( 28 + x,14 + y,208,34,34 );
	gfx.PutPixel( 29 + x,14 + y,208,34,34 );
	gfx.PutPixel( 30 + x,14 + y,208,34,34 );
	gfx.PutPixel( 31 + x,14 + y,208,34,34 );
	gfx.PutPixel( 32 + x,14 + y,208,34,34 );
	gfx.PutPixel( 33 + x,14 + y,208,34,34 );
	gfx.PutPixel( 34 + x,14 + y,208,34,34 );
	gfx.PutPixel( 35 + x,14 + y,208,34,34 );
	gfx.PutPixel( 36 + x,14 + y,208,34,34 );
	gfx.PutPixel( 37 + x,14 + y,208,34,34 );
	gfx.PutPixel( 38 + x,14 + y,208,34,34 );
	gfx.PutPixel( 39 + x,14 + y,208,34,34 );
	gfx.PutPixel( 40 + x,14 + y,208,34,34 );
	gfx.PutPixel( 41 + x,14 + y,208,34,34 );
	gfx.PutPixel( 42 + x,14 + y,208,34,34 );
	gfx.PutPixel( 43 + x,14 + y,208,34,34 );
	gfx.PutPixel( 44 + x,14 + y,208,34,34 );
	gfx.PutPixel( 45 + x,14 + y,208,34,34 );
	gfx.PutPixel( 46 + x,14 + y,208,34,34 );
	gfx.PutPixel( 47 + x,14 + y,208,34,34 );
	gfx.PutPixel( 48 + x,14 + y,208,34,34 );
	gfx.PutPixel( 49 + x,14 + y,208,34,34 );
	gfx.PutPixel( 50 + x,14 + y,208,34,34 );
	gfx.PutPixel( 51 + x,14 + y,208,34,34 );
	gfx.PutPixel( 52 + x,14 + y,208,34,34 );
	gfx.PutPixel( 53 + x,14 + y,208,34,34 );
	gfx.PutPixel( 54 + x,14 + y,208,34,34 );
	gfx.PutPixel( 55 + x,14 + y,208,34,34 );
	gfx.PutPixel( 56 + x,14 + y,208,34,34 );
	gfx.PutPixel( 57 + x,14 + y,208,34,34 );
	gfx.PutPixel( 58 + x,14 + y,208,34,34 );
	gfx.PutPixel( 59 + x,14 + y,208,34,34 );
	gfx.PutPixel( 60 + x,14 + y,208,34,34 );
	gfx.PutPixel( 61 + x,14 + y,208,34,34 );
	gfx.PutPixel( 62 + x,14 + y,208,31,31 );
	gfx.PutPixel( 63 + x,14 + y,207,18,18 );
	gfx.PutPixel( 64 + x,14 + y,214,126,126 );
	gfx.PutPixel( 65 + x,14 + y,215,142,142 );
	gfx.PutPixel( 66 + x,14 + y,215,130,130 );
	gfx.PutPixel( 67 + x,14 + y,213,114,114 );
	gfx.PutPixel( 68 + x,14 + y,210,69,69 );
	gfx.PutPixel( 69 + x,14 + y,214,124,124 );
	gfx.PutPixel( 70 + x,14 + y,215,139,139 );
	gfx.PutPixel( 71 + x,14 + y,215,129,129 );
	gfx.PutPixel( 72 + x,14 + y,218,171,171 );
	gfx.PutPixel( 73 + x,14 + y,209,45,45 );
	gfx.PutPixel( 74 + x,14 + y,219,188,188 );
	gfx.PutPixel( 75 + x,14 + y,215,126,126 );
	gfx.PutPixel( 76 + x,14 + y,211,77,77 );
	gfx.PutPixel( 77 + x,14 + y,217,166,166 );
	gfx.PutPixel( 78 + x,14 + y,214,127,127 );
	gfx.PutPixel( 79 + x,14 + y,216,143,143 );
	gfx.PutPixel( 80 + x,14 + y,214,121,121 );
	gfx.PutPixel( 81 + x,14 + y,210,63,63 );
	gfx.PutPixel( 82 + x,14 + y,217,164,164 );
	gfx.PutPixel( 83 + x,14 + y,214,123,123 );
	gfx.PutPixel( 84 + x,14 + y,216,146,146 );
	gfx.PutPixel( 85 + x,14 + y,210,66,66 );
	gfx.PutPixel( 86 + x,14 + y,207,19,19 );
	gfx.PutPixel( 87 + x,14 + y,208,33,33 );
	gfx.PutPixel( 88 + x,14 + y,208,34,34 );
	gfx.PutPixel( 89 + x,14 + y,208,34,34 );
	gfx.PutPixel( 90 + x,14 + y,208,34,34 );
	gfx.PutPixel( 91 + x,14 + y,208,34,34 );
	gfx.PutPixel( 92 + x,14 + y,208,34,34 );
	gfx.PutPixel( 93 + x,14 + y,208,34,34 );
	gfx.PutPixel( 94 + x,14 + y,208,34,34 );
	gfx.PutPixel( 95 + x,14 + y,208,34,34 );
	gfx.PutPixel( 96 + x,14 + y,208,34,34 );
	gfx.PutPixel( 97 + x,14 + y,208,34,34 );
	gfx.PutPixel( 98 + x,14 + y,208,34,34 );
	gfx.PutPixel( 99 + x,14 + y,208,34,34 );
	gfx.PutPixel( 100 + x,14 + y,208,34,34 );
	gfx.PutPixel( 101 + x,14 + y,208,34,34 );
	gfx.PutPixel( 102 + x,14 + y,208,34,34 );
	gfx.PutPixel( 103 + x,14 + y,208,34,34 );
	gfx.PutPixel( 104 + x,14 + y,208,34,34 );
	gfx.PutPixel( 105 + x,14 + y,208,34,34 );
	gfx.PutPixel( 106 + x,14 + y,208,34,34 );
	gfx.PutPixel( 107 + x,14 + y,208,34,34 );
	gfx.PutPixel( 108 + x,14 + y,208,34,34 );
	gfx.PutPixel( 109 + x,14 + y,208,34,34 );
	gfx.PutPixel( 110 + x,14 + y,208,34,34 );
	gfx.PutPixel( 111 + x,14 + y,208,34,34 );
	gfx.PutPixel( 112 + x,14 + y,208,34,34 );
	gfx.PutPixel( 113 + x,14 + y,208,34,34 );
	gfx.PutPixel( 114 + x,14 + y,208,34,34 );
	gfx.PutPixel( 115 + x,14 + y,208,34,34 );
	gfx.PutPixel( 116 + x,14 + y,208,34,34 );
	gfx.PutPixel( 117 + x,14 + y,208,34,34 );
	gfx.PutPixel( 118 + x,14 + y,208,34,34 );
	gfx.PutPixel( 119 + x,14 + y,208,34,34 );
	gfx.PutPixel( 120 + x,14 + y,208,34,34 );
	gfx.PutPixel( 121 + x,14 + y,208,34,34 );
	gfx.PutPixel( 122 + x,14 + y,208,34,34 );
	gfx.PutPixel( 123 + x,14 + y,208,34,34 );
	gfx.PutPixel( 124 + x,14 + y,208,34,34 );
	gfx.PutPixel( 125 + x,14 + y,208,34,34 );
	gfx.PutPixel( 126 + x,14 + y,208,34,34 );
	gfx.PutPixel( 127 + x,14 + y,208,34,34 );
	gfx.PutPixel( 128 + x,14 + y,208,34,34 );
	gfx.PutPixel( 129 + x,14 + y,208,34,34 );
	gfx.PutPixel( 130 + x,14 + y,208,34,34 );
	gfx.PutPixel( 131 + x,14 + y,208,34,34 );
	gfx.PutPixel( 132 + x,14 + y,208,34,34 );
	gfx.PutPixel( 133 + x,14 + y,208,34,34 );
	gfx.PutPixel( 134 + x,14 + y,208,34,34 );
	gfx.PutPixel( 135 + x,14 + y,208,34,34 );
	gfx.PutPixel( 136 + x,14 + y,208,34,34 );
	gfx.PutPixel( 137 + x,14 + y,208,34,34 );
	gfx.PutPixel( 138 + x,14 + y,208,34,34 );
	gfx.PutPixel( 139 + x,14 + y,208,34,34 );
	gfx.PutPixel( 140 + x,14 + y,208,34,34 );
	gfx.PutPixel( 141 + x,14 + y,208,34,34 );
	gfx.PutPixel( 142 + x,14 + y,208,34,34 );
	gfx.PutPixel( 143 + x,14 + y,208,34,34 );
	gfx.PutPixel( 144 + x,14 + y,208,34,34 );
	gfx.PutPixel( 145 + x,14 + y,208,34,34 );
	gfx.PutPixel( 146 + x,14 + y,208,34,34 );
	gfx.PutPixel( 147 + x,14 + y,208,34,34 );
	gfx.PutPixel( 148 + x,14 + y,208,34,34 );
	gfx.PutPixel( 149 + x,14 + y,208,34,34 );
	gfx.PutPixel( 0 + x,15 + y,208,34,34 );
	gfx.PutPixel( 1 + x,15 + y,208,34,34 );
	gfx.PutPixel( 2 + x,15 + y,208,34,34 );
	gfx.PutPixel( 3 + x,15 + y,208,34,34 );
	gfx.PutPixel( 4 + x,15 + y,208,34,34 );
	gfx.PutPixel( 5 + x,15 + y,208,34,34 );
	gfx.PutPixel( 6 + x,15 + y,208,34,34 );
	gfx.PutPixel( 7 + x,15 + y,208,34,34 );
	gfx.PutPixel( 8 + x,15 + y,208,34,34 );
	gfx.PutPixel( 9 + x,15 + y,208,34,34 );
	gfx.PutPixel( 10 + x,15 + y,208,34,34 );
	gfx.PutPixel( 11 + x,15 + y,208,34,34 );
	gfx.PutPixel( 12 + x,15 + y,208,34,34 );
	gfx.PutPixel( 13 + x,15 + y,208,34,34 );
	gfx.PutPixel( 14 + x,15 + y,208,34,34 );
	gfx.PutPixel( 15 + x,15 + y,208,34,34 );
	gfx.PutPixel( 16 + x,15 + y,208,34,34 );
	gfx.PutPixel( 17 + x,15 + y,208,34,34 );
	gfx.PutPixel( 18 + x,15 + y,208,34,34 );
	gfx.PutPixel( 19 + x,15 + y,208,34,34 );
	gfx.PutPixel( 20 + x,15 + y,208,34,34 );
	gfx.PutPixel( 21 + x,15 + y,208,34,34 );
	gfx.PutPixel( 22 + x,15 + y,208,34,34 );
	gfx.PutPixel( 23 + x,15 + y,208,34,34 );
	gfx.PutPixel( 24 + x,15 + y,208,34,34 );
	gfx.PutPixel( 25 + x,15 + y,208,34,34 );
	gfx.PutPixel( 26 + x,15 + y,208,34,34 );
	gfx.PutPixel( 27 + x,15 + y,208,34,34 );
	gfx.PutPixel( 28 + x,15 + y,208,34,34 );
	gfx.PutPixel( 29 + x,15 + y,208,34,34 );
	gfx.PutPixel( 30 + x,15 + y,208,34,34 );
	gfx.PutPixel( 31 + x,15 + y,208,34,34 );
	gfx.PutPixel( 32 + x,15 + y,208,34,34 );
	gfx.PutPixel( 33 + x,15 + y,208,34,34 );
	gfx.PutPixel( 34 + x,15 + y,208,34,34 );
	gfx.PutPixel( 35 + x,15 + y,208,34,34 );
	gfx.PutPixel( 36 + x,15 + y,208,34,34 );
	gfx.PutPixel( 37 + x,15 + y,208,34,34 );
	gfx.PutPixel( 38 + x,15 + y,208,34,34 );
	gfx.PutPixel( 39 + x,15 + y,208,34,34 );
	gfx.PutPixel( 40 + x,15 + y,208,34,34 );
	gfx.PutPixel( 41 + x,15 + y,208,34,34 );
	gfx.PutPixel( 42 + x,15 + y,208,34,34 );
	gfx.PutPixel( 43 + x,15 + y,208,34,34 );
	gfx.PutPixel( 44 + x,15 + y,208,34,34 );
	gfx.PutPixel( 45 + x,15 + y,208,34,34 );
	gfx.PutPixel( 46 + x,15 + y,208,34,34 );
	gfx.PutPixel( 47 + x,15 + y,208,34,34 );
	gfx.PutPixel( 48 + x,15 + y,208,34,34 );
	gfx.PutPixel( 49 + x,15 + y,208,34,34 );
	gfx.PutPixel( 50 + x,15 + y,208,34,34 );
	gfx.PutPixel( 51 + x,15 + y,208,34,34 );
	gfx.PutPixel( 52 + x,15 + y,208,34,34 );
	gfx.PutPixel( 53 + x,15 + y,208,34,34 );
	gfx.PutPixel( 54 + x,15 + y,208,34,34 );
	gfx.PutPixel( 55 + x,15 + y,208,34,34 );
	gfx.PutPixel( 56 + x,15 + y,208,34,34 );
	gfx.PutPixel( 57 + x,15 + y,208,34,34 );
	gfx.PutPixel( 58 + x,15 + y,208,34,34 );
	gfx.PutPixel( 59 + x,15 + y,208,34,34 );
	gfx.PutPixel( 60 + x,15 + y,208,34,34 );
	gfx.PutPixel( 61 + x,15 + y,207,21,21 );
	gfx.PutPixel( 62 + x,15 + y,210,64,64 );
	gfx.PutPixel( 63 + x,15 + y,215,134,134 );
	gfx.PutPixel( 64 + x,15 + y,213,95,95 );
	gfx.PutPixel( 65 + x,15 + y,214,118,118 );
	gfx.PutPixel( 66 + x,15 + y,212,87,87 );
	gfx.PutPixel( 67 + x,15 + y,216,144,144 );
	gfx.PutPixel( 68 + x,15 + y,215,133,133 );
	gfx.PutPixel( 69 + x,15 + y,212,82,82 );
	gfx.PutPixel( 70 + x,15 + y,209,43,43 );
	gfx.PutPixel( 71 + x,15 + y,207,17,17 );
	gfx.PutPixel( 72 + x,15 + y,214,128,128 );
	gfx.PutPixel( 73 + x,15 + y,212,84,84 );
	gfx.PutPixel( 74 + x,15 + y,214,122,122 );
	gfx.PutPixel( 75 + x,15 + y,211,76,76 );
	gfx.PutPixel( 76 + x,15 + y,215,126,126 );
	gfx.PutPixel( 77 + x,15 + y,211,71,71 );
	gfx.PutPixel( 78 + x,15 + y,207,23,23 );
	gfx.PutPixel( 79 + x,15 + y,209,56,56 );
	gfx.PutPixel( 80 + x,15 + y,213,101,101 );
	gfx.PutPixel( 81 + x,15 + y,216,145,145 );
	gfx.PutPixel( 82 + x,15 + y,214,128,128 );
	gfx.PutPixel( 83 + x,15 + y,211,77,77 );
	gfx.PutPixel( 84 + x,15 + y,216,150,150 );
	gfx.PutPixel( 85 + x,15 + y,212,95,95 );
	gfx.PutPixel( 86 + x,15 + y,214,116,116 );
	gfx.PutPixel( 87 + x,15 + y,208,30,30 );
	gfx.PutPixel( 88 + x,15 + y,208,28,28 );
	gfx.PutPixel( 89 + x,15 + y,208,35,35 );
	gfx.PutPixel( 90 + x,15 + y,208,34,34 );
	gfx.PutPixel( 91 + x,15 + y,208,34,34 );
	gfx.PutPixel( 92 + x,15 + y,208,34,34 );
	gfx.PutPixel( 93 + x,15 + y,208,34,34 );
	gfx.PutPixel( 94 + x,15 + y,208,34,34 );
	gfx.PutPixel( 95 + x,15 + y,208,34,34 );
	gfx.PutPixel( 96 + x,15 + y,208,34,34 );
	gfx.PutPixel( 97 + x,15 + y,208,34,34 );
	gfx.PutPixel( 98 + x,15 + y,208,34,34 );
	gfx.PutPixel( 99 + x,15 + y,208,34,34 );
	gfx.PutPixel( 100 + x,15 + y,208,34,34 );
	gfx.PutPixel( 101 + x,15 + y,208,34,34 );
	gfx.PutPixel( 102 + x,15 + y,208,34,34 );
	gfx.PutPixel( 103 + x,15 + y,208,34,34 );
	gfx.PutPixel( 104 + x,15 + y,208,34,34 );
	gfx.PutPixel( 105 + x,15 + y,208,34,34 );
	gfx.PutPixel( 106 + x,15 + y,208,34,34 );
	gfx.PutPixel( 107 + x,15 + y,208,34,34 );
	gfx.PutPixel( 108 + x,15 + y,208,34,34 );
	gfx.PutPixel( 109 + x,15 + y,208,34,34 );
	gfx.PutPixel( 110 + x,15 + y,208,34,34 );
	gfx.PutPixel( 111 + x,15 + y,208,34,34 );
	gfx.PutPixel( 112 + x,15 + y,208,34,34 );
	gfx.PutPixel( 113 + x,15 + y,208,34,34 );
	gfx.PutPixel( 114 + x,15 + y,208,34,34 );
	gfx.PutPixel( 115 + x,15 + y,208,34,34 );
	gfx.PutPixel( 116 + x,15 + y,208,34,34 );
	gfx.PutPixel( 117 + x,15 + y,208,34,34 );
	gfx.PutPixel( 118 + x,15 + y,208,34,34 );
	gfx.PutPixel( 119 + x,15 + y,208,34,34 );
	gfx.PutPixel( 120 + x,15 + y,208,34,34 );
	gfx.PutPixel( 121 + x,15 + y,208,34,34 );
	gfx.PutPixel( 122 + x,15 + y,208,34,34 );
	gfx.PutPixel( 123 + x,15 + y,208,34,34 );
	gfx.PutPixel( 124 + x,15 + y,208,34,34 );
	gfx.PutPixel( 125 + x,15 + y,208,34,34 );
	gfx.PutPixel( 126 + x,15 + y,208,34,34 );
	gfx.PutPixel( 127 + x,15 + y,208,34,34 );
	gfx.PutPixel( 128 + x,15 + y,208,34,34 );
	gfx.PutPixel( 129 + x,15 + y,208,34,34 );
	gfx.PutPixel( 130 + x,15 + y,208,34,34 );
	gfx.PutPixel( 131 + x,15 + y,208,34,34 );
	gfx.PutPixel( 132 + x,15 + y,208,34,34 );
	gfx.PutPixel( 133 + x,15 + y,208,34,34 );
	gfx.PutPixel( 134 + x,15 + y,208,34,34 );
	gfx.PutPixel( 135 + x,15 + y,208,34,34 );
	gfx.PutPixel( 136 + x,15 + y,208,34,34 );
	gfx.PutPixel( 137 + x,15 + y,208,34,34 );
	gfx.PutPixel( 138 + x,15 + y,208,34,34 );
	gfx.PutPixel( 139 + x,15 + y,208,34,34 );
	gfx.PutPixel( 140 + x,15 + y,208,34,34 );
	gfx.PutPixel( 141 + x,15 + y,208,34,34 );
	gfx.PutPixel( 142 + x,15 + y,208,34,34 );
	gfx.PutPixel( 143 + x,15 + y,208,34,34 );
	gfx.PutPixel( 144 + x,15 + y,208,34,34 );
	gfx.PutPixel( 145 + x,15 + y,208,34,34 );
	gfx.PutPixel( 146 + x,15 + y,208,34,34 );
	gfx.PutPixel( 147 + x,15 + y,208,34,34 );
	gfx.PutPixel( 148 + x,15 + y,208,34,34 );
	gfx.PutPixel( 149 + x,15 + y,208,34,34 );
	gfx.PutPixel( 0 + x,16 + y,208,34,34 );
	gfx.PutPixel( 1 + x,16 + y,208,34,34 );
	gfx.PutPixel( 2 + x,16 + y,208,34,34 );
	gfx.PutPixel( 3 + x,16 + y,208,34,34 );
	gfx.PutPixel( 4 + x,16 + y,208,34,34 );
	gfx.PutPixel( 5 + x,16 + y,208,34,34 );
	gfx.PutPixel( 6 + x,16 + y,208,34,34 );
	gfx.PutPixel( 7 + x,16 + y,208,34,34 );
	gfx.PutPixel( 8 + x,16 + y,208,34,34 );
	gfx.PutPixel( 9 + x,16 + y,208,34,34 );
	gfx.PutPixel( 10 + x,16 + y,208,34,34 );
	gfx.PutPixel( 11 + x,16 + y,208,34,34 );
	gfx.PutPixel( 12 + x,16 + y,208,34,34 );
	gfx.PutPixel( 13 + x,16 + y,208,34,34 );
	gfx.PutPixel( 14 + x,16 + y,208,34,34 );
	gfx.PutPixel( 15 + x,16 + y,208,34,34 );
	gfx.PutPixel( 16 + x,16 + y,208,34,34 );
	gfx.PutPixel( 17 + x,16 + y,208,34,34 );
	gfx.PutPixel( 18 + x,16 + y,208,34,34 );
	gfx.PutPixel( 19 + x,16 + y,208,34,34 );
	gfx.PutPixel( 20 + x,16 + y,208,34,34 );
	gfx.PutPixel( 21 + x,16 + y,208,34,34 );
	gfx.PutPixel( 22 + x,16 + y,208,34,34 );
	gfx.PutPixel( 23 + x,16 + y,208,34,34 );
	gfx.PutPixel( 24 + x,16 + y,208,34,34 );
	gfx.PutPixel( 25 + x,16 + y,208,34,34 );
	gfx.PutPixel( 26 + x,16 + y,208,34,34 );
	gfx.PutPixel( 27 + x,16 + y,208,34,34 );
	gfx.PutPixel( 28 + x,16 + y,208,34,34 );
	gfx.PutPixel( 29 + x,16 + y,208,34,34 );
	gfx.PutPixel( 30 + x,16 + y,208,34,34 );
	gfx.PutPixel( 31 + x,16 + y,208,34,34 );
	gfx.PutPixel( 32 + x,16 + y,208,34,34 );
	gfx.PutPixel( 33 + x,16 + y,208,34,34 );
	gfx.PutPixel( 34 + x,16 + y,208,34,34 );
	gfx.PutPixel( 35 + x,16 + y,208,34,34 );
	gfx.PutPixel( 36 + x,16 + y,208,34,34 );
	gfx.PutPixel( 37 + x,16 + y,208,34,34 );
	gfx.PutPixel( 38 + x,16 + y,208,34,34 );
	gfx.PutPixel( 39 + x,16 + y,208,34,34 );
	gfx.PutPixel( 40 + x,16 + y,208,34,34 );
	gfx.PutPixel( 41 + x,16 + y,208,34,34 );
	gfx.PutPixel( 42 + x,16 + y,208,34,34 );
	gfx.PutPixel( 43 + x,16 + y,208,34,34 );
	gfx.PutPixel( 44 + x,16 + y,208,34,34 );
	gfx.PutPixel( 45 + x,16 + y,208,34,34 );
	gfx.PutPixel( 46 + x,16 + y,208,34,34 );
	gfx.PutPixel( 47 + x,16 + y,208,34,34 );
	gfx.PutPixel( 48 + x,16 + y,208,34,34 );
	gfx.PutPixel( 49 + x,16 + y,208,34,34 );
	gfx.PutPixel( 50 + x,16 + y,208,34,34 );
	gfx.PutPixel( 51 + x,16 + y,208,34,34 );
	gfx.PutPixel( 52 + x,16 + y,208,34,34 );
	gfx.PutPixel( 53 + x,16 + y,208,34,34 );
	gfx.PutPixel( 54 + x,16 + y,208,34,34 );
	gfx.PutPixel( 55 + x,16 + y,208,34,34 );
	gfx.PutPixel( 56 + x,16 + y,208,34,34 );
	gfx.PutPixel( 57 + x,16 + y,208,34,34 );
	gfx.PutPixel( 58 + x,16 + y,208,34,34 );
	gfx.PutPixel( 59 + x,16 + y,208,34,34 );
	gfx.PutPixel( 60 + x,16 + y,207,24,24 );
	gfx.PutPixel( 61 + x,16 + y,213,103,103 );
	gfx.PutPixel( 62 + x,16 + y,213,106,106 );
	gfx.PutPixel( 63 + x,16 + y,214,119,119 );
	gfx.PutPixel( 64 + x,16 + y,212,89,89 );
	gfx.PutPixel( 65 + x,16 + y,216,146,146 );
	gfx.PutPixel( 66 + x,16 + y,214,120,120 );
	gfx.PutPixel( 67 + x,16 + y,209,51,51 );
	gfx.PutPixel( 68 + x,16 + y,207,25,25 );
	gfx.PutPixel( 69 + x,16 + y,207,27,27 );
	gfx.PutPixel( 70 + x,16 + y,208,32,32 );
	gfx.PutPixel( 71 + x,16 + y,207,26,26 );
	gfx.PutPixel( 72 + x,16 + y,211,84,84 );
	gfx.PutPixel( 73 + x,16 + y,214,121,121 );
	gfx.PutPixel( 74 + x,16 + y,216,140,140 );
	gfx.PutPixel( 75 + x,16 + y,213,103,103 );
	gfx.PutPixel( 76 + x,16 + y,215,135,135 );
	gfx.PutPixel( 77 + x,16 + y,208,39,39 );
	gfx.PutPixel( 78 + x,16 + y,208,32,32 );
	gfx.PutPixel( 79 + x,16 + y,208,30,30 );
	gfx.PutPixel( 80 + x,16 + y,207,24,24 );
	gfx.PutPixel( 81 + x,16 + y,208,32,32 );
	gfx.PutPixel( 82 + x,16 + y,211,73,73 );
	gfx.PutPixel( 83 + x,16 + y,215,131,131 );
	gfx.PutPixel( 84 + x,16 + y,214,116,116 );
	gfx.PutPixel( 85 + x,16 + y,211,84,84 );
	gfx.PutPixel( 86 + x,16 + y,215,137,137 );
	gfx.PutPixel( 87 + x,16 + y,212,91,91 );
	gfx.PutPixel( 88 + x,16 + y,211,71,71 );
	gfx.PutPixel( 89 + x,16 + y,208,26,26 );
	gfx.PutPixel( 90 + x,16 + y,208,34,34 );
	gfx.PutPixel( 91 + x,16 + y,208,34,34 );
	gfx.PutPixel( 92 + x,16 + y,208,34,34 );
	gfx.PutPixel( 93 + x,16 + y,208,34,34 );
	gfx.PutPixel( 94 + x,16 + y,208,34,34 );
	gfx.PutPixel( 95 + x,16 + y,208,34,34 );
	gfx.PutPixel( 96 + x,16 + y,208,34,34 );
	gfx.PutPixel( 97 + x,16 + y,208,34,34 );
	gfx.PutPixel( 98 + x,16 + y,208,34,34 );
	gfx.PutPixel( 99 + x,16 + y,208,34,34 );
	gfx.PutPixel( 100 + x,16 + y,208,34,34 );
	gfx.PutPixel( 101 + x,16 + y,208,34,34 );
	gfx.PutPixel( 102 + x,16 + y,208,34,34 );
	gfx.PutPixel( 103 + x,16 + y,208,34,34 );
	gfx.PutPixel( 104 + x,16 + y,208,34,34 );
	gfx.PutPixel( 105 + x,16 + y,208,34,34 );
	gfx.PutPixel( 106 + x,16 + y,208,34,34 );
	gfx.PutPixel( 107 + x,16 + y,208,34,34 );
	gfx.PutPixel( 108 + x,16 + y,208,34,34 );
	gfx.PutPixel( 109 + x,16 + y,208,34,34 );
	gfx.PutPixel( 110 + x,16 + y,208,34,34 );
	gfx.PutPixel( 111 + x,16 + y,208,34,34 );
	gfx.PutPixel( 112 + x,16 + y,208,34,34 );
	gfx.PutPixel( 113 + x,16 + y,208,34,34 );
	gfx.PutPixel( 114 + x,16 + y,208,34,34 );
	gfx.PutPixel( 115 + x,16 + y,208,34,34 );
	gfx.PutPixel( 116 + x,16 + y,208,34,34 );
	gfx.PutPixel( 117 + x,16 + y,208,34,34 );
	gfx.PutPixel( 118 + x,16 + y,208,34,34 );
	gfx.PutPixel( 119 + x,16 + y,208,34,34 );
	gfx.PutPixel( 120 + x,16 + y,208,34,34 );
	gfx.PutPixel( 121 + x,16 + y,208,34,34 );
	gfx.PutPixel( 122 + x,16 + y,208,34,34 );
	gfx.PutPixel( 123 + x,16 + y,208,34,34 );
	gfx.PutPixel( 124 + x,16 + y,208,34,34 );
	gfx.PutPixel( 125 + x,16 + y,208,34,34 );
	gfx.PutPixel( 126 + x,16 + y,208,34,34 );
	gfx.PutPixel( 127 + x,16 + y,208,34,34 );
	gfx.PutPixel( 128 + x,16 + y,208,34,34 );
	gfx.PutPixel( 129 + x,16 + y,208,34,34 );
	gfx.PutPixel( 130 + x,16 + y,208,34,34 );
	gfx.PutPixel( 131 + x,16 + y,208,34,34 );
	gfx.PutPixel( 132 + x,16 + y,208,34,34 );
	gfx.PutPixel( 133 + x,16 + y,208,34,34 );
	gfx.PutPixel( 134 + x,16 + y,208,34,34 );
	gfx.PutPixel( 135 + x,16 + y,208,34,34 );
	gfx.PutPixel( 136 + x,16 + y,208,34,34 );
	gfx.PutPixel( 137 + x,16 + y,208,34,34 );
	gfx.PutPixel( 138 + x,16 + y,208,34,34 );
	gfx.PutPixel( 139 + x,16 + y,208,34,34 );
	gfx.PutPixel( 140 + x,16 + y,208,34,34 );
	gfx.PutPixel( 141 + x,16 + y,208,34,34 );
	gfx.PutPixel( 142 + x,16 + y,208,34,34 );
	gfx.PutPixel( 143 + x,16 + y,208,34,34 );
	gfx.PutPixel( 144 + x,16 + y,208,34,34 );
	gfx.PutPixel( 145 + x,16 + y,208,34,34 );
	gfx.PutPixel( 146 + x,16 + y,208,34,34 );
	gfx.PutPixel( 147 + x,16 + y,208,34,34 );
	gfx.PutPixel( 148 + x,16 + y,208,34,34 );
	gfx.PutPixel( 149 + x,16 + y,208,34,34 );
	gfx.PutPixel( 0 + x,17 + y,208,34,34 );
	gfx.PutPixel( 1 + x,17 + y,208,34,34 );
	gfx.PutPixel( 2 + x,17 + y,208,34,34 );
	gfx.PutPixel( 3 + x,17 + y,208,34,34 );
	gfx.PutPixel( 4 + x,17 + y,208,34,34 );
	gfx.PutPixel( 5 + x,17 + y,208,34,34 );
	gfx.PutPixel( 6 + x,17 + y,208,34,34 );
	gfx.PutPixel( 7 + x,17 + y,208,34,34 );
	gfx.PutPixel( 8 + x,17 + y,208,34,34 );
	gfx.PutPixel( 9 + x,17 + y,208,34,34 );
	gfx.PutPixel( 10 + x,17 + y,208,34,34 );
	gfx.PutPixel( 11 + x,17 + y,208,34,34 );
	gfx.PutPixel( 12 + x,17 + y,208,34,34 );
	gfx.PutPixel( 13 + x,17 + y,208,34,34 );
	gfx.PutPixel( 14 + x,17 + y,208,34,34 );
	gfx.PutPixel( 15 + x,17 + y,208,34,34 );
	gfx.PutPixel( 16 + x,17 + y,208,34,34 );
	gfx.PutPixel( 17 + x,17 + y,208,34,34 );
	gfx.PutPixel( 18 + x,17 + y,208,34,34 );
	gfx.PutPixel( 19 + x,17 + y,208,34,34 );
	gfx.PutPixel( 20 + x,17 + y,208,34,34 );
	gfx.PutPixel( 21 + x,17 + y,208,34,34 );
	gfx.PutPixel( 22 + x,17 + y,208,34,34 );
	gfx.PutPixel( 23 + x,17 + y,208,34,34 );
	gfx.PutPixel( 24 + x,17 + y,208,34,34 );
	gfx.PutPixel( 25 + x,17 + y,208,34,34 );
	gfx.PutPixel( 26 + x,17 + y,208,34,34 );
	gfx.PutPixel( 27 + x,17 + y,208,34,34 );
	gfx.PutPixel( 28 + x,17 + y,208,34,34 );
	gfx.PutPixel( 29 + x,17 + y,208,34,34 );
	gfx.PutPixel( 30 + x,17 + y,208,34,34 );
	gfx.PutPixel( 31 + x,17 + y,208,34,34 );
	gfx.PutPixel( 32 + x,17 + y,208,34,34 );
	gfx.PutPixel( 33 + x,17 + y,208,34,34 );
	gfx.PutPixel( 34 + x,17 + y,208,34,34 );
	gfx.PutPixel( 35 + x,17 + y,208,34,34 );
	gfx.PutPixel( 36 + x,17 + y,208,34,34 );
	gfx.PutPixel( 37 + x,17 + y,208,34,34 );
	gfx.PutPixel( 38 + x,17 + y,208,34,34 );
	gfx.PutPixel( 39 + x,17 + y,208,34,34 );
	gfx.PutPixel( 40 + x,17 + y,208,34,34 );
	gfx.PutPixel( 41 + x,17 + y,208,34,34 );
	gfx.PutPixel( 42 + x,17 + y,208,34,34 );
	gfx.PutPixel( 43 + x,17 + y,208,34,34 );
	gfx.PutPixel( 44 + x,17 + y,208,34,34 );
	gfx.PutPixel( 45 + x,17 + y,208,34,34 );
	gfx.PutPixel( 46 + x,17 + y,208,34,34 );
	gfx.PutPixel( 47 + x,17 + y,208,34,34 );
	gfx.PutPixel( 48 + x,17 + y,208,34,34 );
	gfx.PutPixel( 49 + x,17 + y,208,34,34 );
	gfx.PutPixel( 50 + x,17 + y,208,34,34 );
	gfx.PutPixel( 51 + x,17 + y,208,34,34 );
	gfx.PutPixel( 52 + x,17 + y,208,34,34 );
	gfx.PutPixel( 53 + x,17 + y,208,34,34 );
	gfx.PutPixel( 54 + x,17 + y,208,34,34 );
	gfx.PutPixel( 55 + x,17 + y,208,34,34 );
	gfx.PutPixel( 56 + x,17 + y,208,34,34 );
	gfx.PutPixel( 57 + x,17 + y,208,34,34 );
	gfx.PutPixel( 58 + x,17 + y,208,34,34 );
	gfx.PutPixel( 59 + x,17 + y,208,34,34 );
	gfx.PutPixel( 60 + x,17 + y,210,66,66 );
	gfx.PutPixel( 61 + x,17 + y,214,125,125 );
	gfx.PutPixel( 62 + x,17 + y,213,104,104 );
	gfx.PutPixel( 63 + x,17 + y,215,128,128 );
	gfx.PutPixel( 64 + x,17 + y,215,129,129 );
	gfx.PutPixel( 65 + x,17 + y,211,77,77 );
	gfx.PutPixel( 66 + x,17 + y,217,160,160 );
	gfx.PutPixel( 67 + x,17 + y,209,53,53 );
	gfx.PutPixel( 68 + x,17 + y,208,29,29 );
	gfx.PutPixel( 69 + x,17 + y,208,34,34 );
	gfx.PutPixel( 70 + x,17 + y,208,34,34 );
	gfx.PutPixel( 71 + x,17 + y,208,31,31 );
	gfx.PutPixel( 72 + x,17 + y,209,52,52 );
	gfx.PutPixel( 73 + x,17 + y,213,111,111 );
	gfx.PutPixel( 74 + x,17 + y,213,112,112 );
	gfx.PutPixel( 75 + x,17 + y,213,102,102 );
	gfx.PutPixel( 76 + x,17 + y,213,111,111 );
	gfx.PutPixel( 77 + x,17 + y,208,28,28 );
	gfx.PutPixel( 78 + x,17 + y,208,34,34 );
	gfx.PutPixel( 79 + x,17 + y,208,34,34 );
	gfx.PutPixel( 80 + x,17 + y,208,34,34 );
	gfx.PutPixel( 81 + x,17 + y,208,28,28 );
	gfx.PutPixel( 82 + x,17 + y,209,56,56 );
	gfx.PutPixel( 83 + x,17 + y,215,128,128 );
	gfx.PutPixel( 84 + x,17 + y,212,81,81 );
	gfx.PutPixel( 85 + x,17 + y,215,141,141 );
	gfx.PutPixel( 86 + x,17 + y,212,85,85 );
	gfx.PutPixel( 87 + x,17 + y,214,123,123 );
	gfx.PutPixel( 88 + x,17 + y,214,117,117 );
	gfx.PutPixel( 89 + x,17 + y,209,46,46 );
	gfx.PutPixel( 90 + x,17 + y,208,32,32 );
	gfx.PutPixel( 91 + x,17 + y,208,34,34 );
	gfx.PutPixel( 92 + x,17 + y,208,34,34 );
	gfx.PutPixel( 93 + x,17 + y,208,34,34 );
	gfx.PutPixel( 94 + x,17 + y,208,34,34 );
	gfx.PutPixel( 95 + x,17 + y,208,34,34 );
	gfx.PutPixel( 96 + x,17 + y,208,34,34 );
	gfx.PutPixel( 97 + x,17 + y,208,34,34 );
	gfx.PutPixel( 98 + x,17 + y,208,34,34 );
	gfx.PutPixel( 99 + x,17 + y,208,34,34 );
	gfx.PutPixel( 100 + x,17 + y,208,34,34 );
	gfx.PutPixel( 101 + x,17 + y,208,34,34 );
	gfx.PutPixel( 102 + x,17 + y,208,34,34 );
	gfx.PutPixel( 103 + x,17 + y,208,34,34 );
	gfx.PutPixel( 104 + x,17 + y,208,34,34 );
	gfx.PutPixel( 105 + x,17 + y,208,34,34 );
	gfx.PutPixel( 106 + x,17 + y,208,34,34 );
	gfx.PutPixel( 107 + x,17 + y,208,34,34 );
	gfx.PutPixel( 108 + x,17 + y,208,34,34 );
	gfx.PutPixel( 109 + x,17 + y,208,34,34 );
	gfx.PutPixel( 110 + x,17 + y,208,34,34 );
	gfx.PutPixel( 111 + x,17 + y,208,34,34 );
	gfx.PutPixel( 112 + x,17 + y,208,34,34 );
	gfx.PutPixel( 113 + x,17 + y,208,34,34 );
	gfx.PutPixel( 114 + x,17 + y,208,34,34 );
	gfx.PutPixel( 115 + x,17 + y,208,34,34 );
	gfx.PutPixel( 116 + x,17 + y,208,34,34 );
	gfx.PutPixel( 117 + x,17 + y,208,34,34 );
	gfx.PutPixel( 118 + x,17 + y,208,34,34 );
	gfx.PutPixel( 119 + x,17 + y,208,34,34 );
	gfx.PutPixel( 120 + x,17 + y,208,34,34 );
	gfx.PutPixel( 121 + x,17 + y,208,34,34 );
	gfx.PutPixel( 122 + x,17 + y,208,34,34 );
	gfx.PutPixel( 123 + x,17 + y,208,34,34 );
	gfx.PutPixel( 124 + x,17 + y,208,34,34 );
	gfx.PutPixel( 125 + x,17 + y,208,34,34 );
	gfx.PutPixel( 126 + x,17 + y,208,34,34 );
	gfx.PutPixel( 127 + x,17 + y,208,34,34 );
	gfx.PutPixel( 128 + x,17 + y,208,34,34 );
	gfx.PutPixel( 129 + x,17 + y,208,34,34 );
	gfx.PutPixel( 130 + x,17 + y,208,34,34 );
	gfx.PutPixel( 131 + x,17 + y,208,34,34 );
	gfx.PutPixel( 132 + x,17 + y,208,34,34 );
	gfx.PutPixel( 133 + x,17 + y,208,34,34 );
	gfx.PutPixel( 134 + x,17 + y,208,34,34 );
	gfx.PutPixel( 135 + x,17 + y,208,34,34 );
	gfx.PutPixel( 136 + x,17 + y,208,34,34 );
	gfx.PutPixel( 137 + x,17 + y,208,34,34 );
	gfx.PutPixel( 138 + x,17 + y,208,34,34 );
	gfx.PutPixel( 139 + x,17 + y,208,34,34 );
	gfx.PutPixel( 140 + x,17 + y,208,34,34 );
	gfx.PutPixel( 141 + x,17 + y,208,34,34 );
	gfx.PutPixel( 142 + x,17 + y,208,34,34 );
	gfx.PutPixel( 143 + x,17 + y,208,34,34 );
	gfx.PutPixel( 144 + x,17 + y,208,34,34 );
	gfx.PutPixel( 145 + x,17 + y,208,34,34 );
	gfx.PutPixel( 146 + x,17 + y,208,34,34 );
	gfx.PutPixel( 147 + x,17 + y,208,34,34 );
	gfx.PutPixel( 148 + x,17 + y,208,34,34 );
	gfx.PutPixel( 149 + x,17 + y,208,34,34 );
	gfx.PutPixel( 0 + x,18 + y,208,34,34 );
	gfx.PutPixel( 1 + x,18 + y,208,34,34 );
	gfx.PutPixel( 2 + x,18 + y,208,34,34 );
	gfx.PutPixel( 3 + x,18 + y,208,34,34 );
	gfx.PutPixel( 4 + x,18 + y,208,34,34 );
	gfx.PutPixel( 5 + x,18 + y,208,34,34 );
	gfx.PutPixel( 6 + x,18 + y,208,34,34 );
	gfx.PutPixel( 7 + x,18 + y,208,34,34 );
	gfx.PutPixel( 8 + x,18 + y,208,34,34 );
	gfx.PutPixel( 9 + x,18 + y,208,34,34 );
	gfx.PutPixel( 10 + x,18 + y,208,34,34 );
	gfx.PutPixel( 11 + x,18 + y,208,34,34 );
	gfx.PutPixel( 12 + x,18 + y,208,34,34 );
	gfx.PutPixel( 13 + x,18 + y,208,34,34 );
	gfx.PutPixel( 14 + x,18 + y,208,34,34 );
	gfx.PutPixel( 15 + x,18 + y,208,34,34 );
	gfx.PutPixel( 16 + x,18 + y,208,34,34 );
	gfx.PutPixel( 17 + x,18 + y,208,34,34 );
	gfx.PutPixel( 18 + x,18 + y,208,34,34 );
	gfx.PutPixel( 19 + x,18 + y,208,34,34 );
	gfx.PutPixel( 20 + x,18 + y,208,34,34 );
	gfx.PutPixel( 21 + x,18 + y,208,34,34 );
	gfx.PutPixel( 22 + x,18 + y,208,34,34 );
	gfx.PutPixel( 23 + x,18 + y,208,34,34 );
	gfx.PutPixel( 24 + x,18 + y,208,34,34 );
	gfx.PutPixel( 25 + x,18 + y,208,34,34 );
	gfx.PutPixel( 26 + x,18 + y,208,34,34 );
	gfx.PutPixel( 27 + x,18 + y,208,34,34 );
	gfx.PutPixel( 28 + x,18 + y,208,34,34 );
	gfx.PutPixel( 29 + x,18 + y,208,34,34 );
	gfx.PutPixel( 30 + x,18 + y,208,34,34 );
	gfx.PutPixel( 31 + x,18 + y,208,34,34 );
	gfx.PutPixel( 32 + x,18 + y,208,34,34 );
	gfx.PutPixel( 33 + x,18 + y,208,34,34 );
	gfx.PutPixel( 34 + x,18 + y,208,34,34 );
	gfx.PutPixel( 35 + x,18 + y,208,34,34 );
	gfx.PutPixel( 36 + x,18 + y,208,34,34 );
	gfx.PutPixel( 37 + x,18 + y,208,34,34 );
	gfx.PutPixel( 38 + x,18 + y,208,34,34 );
	gfx.PutPixel( 39 + x,18 + y,208,34,34 );
	gfx.PutPixel( 40 + x,18 + y,208,34,34 );
	gfx.PutPixel( 41 + x,18 + y,208,34,34 );
	gfx.PutPixel( 42 + x,18 + y,208,34,34 );
	gfx.PutPixel( 43 + x,18 + y,208,34,34 );
	gfx.PutPixel( 44 + x,18 + y,208,34,34 );
	gfx.PutPixel( 45 + x,18 + y,208,34,34 );
	gfx.PutPixel( 46 + x,18 + y,208,34,34 );
	gfx.PutPixel( 47 + x,18 + y,208,34,34 );
	gfx.PutPixel( 48 + x,18 + y,208,34,34 );
	gfx.PutPixel( 49 + x,18 + y,208,34,34 );
	gfx.PutPixel( 50 + x,18 + y,208,34,34 );
	gfx.PutPixel( 51 + x,18 + y,208,34,34 );
	gfx.PutPixel( 52 + x,18 + y,208,34,34 );
	gfx.PutPixel( 53 + x,18 + y,208,34,34 );
	gfx.PutPixel( 54 + x,18 + y,208,34,34 );
	gfx.PutPixel( 55 + x,18 + y,208,34,34 );
	gfx.PutPixel( 56 + x,18 + y,208,34,34 );
	gfx.PutPixel( 57 + x,18 + y,208,34,34 );
	gfx.PutPixel( 58 + x,18 + y,208,31,31 );
	gfx.PutPixel( 59 + x,18 + y,208,29,29 );
	gfx.PutPixel( 60 + x,18 + y,215,133,133 );
	gfx.PutPixel( 61 + x,18 + y,213,103,103 );
	gfx.PutPixel( 62 + x,18 + y,216,148,148 );
	gfx.PutPixel( 63 + x,18 + y,211,81,81 );
	gfx.PutPixel( 64 + x,18 + y,207,13,13 );
	gfx.PutPixel( 65 + x,18 + y,214,115,115 );
	gfx.PutPixel( 66 + x,18 + y,223,248,248 );
	gfx.PutPixel( 67 + x,18 + y,216,155,155 );
	gfx.PutPixel( 68 + x,18 + y,207,27,27 );
	gfx.PutPixel( 69 + x,18 + y,208,32,32 );
	gfx.PutPixel( 70 + x,18 + y,208,34,34 );
	gfx.PutPixel( 71 + x,18 + y,208,33,33 );
	gfx.PutPixel( 72 + x,18 + y,208,38,38 );
	gfx.PutPixel( 73 + x,18 + y,213,113,113 );
	gfx.PutPixel( 74 + x,18 + y,215,144,144 );
	gfx.PutPixel( 75 + x,18 + y,215,140,140 );
	gfx.PutPixel( 76 + x,18 + y,211,76,76 );
	gfx.PutPixel( 77 + x,18 + y,207,28,28 );
	gfx.PutPixel( 78 + x,18 + y,208,34,34 );
	gfx.PutPixel( 79 + x,18 + y,208,33,33 );
	gfx.PutPixel( 80 + x,18 + y,208,32,32 );
	gfx.PutPixel( 81 + x,18 + y,208,32,32 );
	gfx.PutPixel( 82 + x,18 + y,218,173,173 );
	gfx.PutPixel( 83 + x,18 + y,222,236,236 );
	gfx.PutPixel( 84 + x,18 + y,210,66,66 );
	gfx.PutPixel( 85 + x,18 + y,207,28,28 );
	gfx.PutPixel( 86 + x,18 + y,213,116,116 );
	gfx.PutPixel( 87 + x,18 + y,214,125,125 );
	gfx.PutPixel( 88 + x,18 + y,213,99,99 );
	gfx.PutPixel( 89 + x,18 + y,215,129,129 );
	gfx.PutPixel( 90 + x,18 + y,208,22,22 );
	gfx.PutPixel( 91 + x,18 + y,208,32,32 );
	gfx.PutPixel( 92 + x,18 + y,208,34,34 );
	gfx.PutPixel( 93 + x,18 + y,208,34,34 );
	gfx.PutPixel( 94 + x,18 + y,208,34,34 );
	gfx.PutPixel( 95 + x,18 + y,208,34,34 );
	gfx.PutPixel( 96 + x,18 + y,208,34,34 );
	gfx.PutPixel( 97 + x,18 + y,208,34,34 );
	gfx.PutPixel( 98 + x,18 + y,208,34,34 );
	gfx.PutPixel( 99 + x,18 + y,208,34,34 );
	gfx.PutPixel( 100 + x,18 + y,208,34,34 );
	gfx.PutPixel( 101 + x,18 + y,208,34,34 );
	gfx.PutPixel( 102 + x,18 + y,208,34,34 );
	gfx.PutPixel( 103 + x,18 + y,208,34,34 );
	gfx.PutPixel( 104 + x,18 + y,208,34,34 );
	gfx.PutPixel( 105 + x,18 + y,208,34,34 );
	gfx.PutPixel( 106 + x,18 + y,208,34,34 );
	gfx.PutPixel( 107 + x,18 + y,208,34,34 );
	gfx.PutPixel( 108 + x,18 + y,208,34,34 );
	gfx.PutPixel( 109 + x,18 + y,208,34,34 );
	gfx.PutPixel( 110 + x,18 + y,208,34,34 );
	gfx.PutPixel( 111 + x,18 + y,208,34,34 );
	gfx.PutPixel( 112 + x,18 + y,208,34,34 );
	gfx.PutPixel( 113 + x,18 + y,208,34,34 );
	gfx.PutPixel( 114 + x,18 + y,208,34,34 );
	gfx.PutPixel( 115 + x,18 + y,208,34,34 );
	gfx.PutPixel( 116 + x,18 + y,208,34,34 );
	gfx.PutPixel( 117 + x,18 + y,208,34,34 );
	gfx.PutPixel( 118 + x,18 + y,208,34,34 );
	gfx.PutPixel( 119 + x,18 + y,208,34,34 );
	gfx.PutPixel( 120 + x,18 + y,208,34,34 );
	gfx.PutPixel( 121 + x,18 + y,208,34,34 );
	gfx.PutPixel( 122 + x,18 + y,208,34,34 );
	gfx.PutPixel( 123 + x,18 + y,208,34,34 );
	gfx.PutPixel( 124 + x,18 + y,208,34,34 );
	gfx.PutPixel( 125 + x,18 + y,208,34,34 );
	gfx.PutPixel( 126 + x,18 + y,208,34,34 );
	gfx.PutPixel( 127 + x,18 + y,208,34,34 );
	gfx.PutPixel( 128 + x,18 + y,208,34,34 );
	gfx.PutPixel( 129 + x,18 + y,208,34,34 );
	gfx.PutPixel( 130 + x,18 + y,208,34,34 );
	gfx.PutPixel( 131 + x,18 + y,208,34,34 );
	gfx.PutPixel( 132 + x,18 + y,208,34,34 );
	gfx.PutPixel( 133 + x,18 + y,208,34,34 );
	gfx.PutPixel( 134 + x,18 + y,208,34,34 );
	gfx.PutPixel( 135 + x,18 + y,208,34,34 );
	gfx.PutPixel( 136 + x,18 + y,208,34,34 );
	gfx.PutPixel( 137 + x,18 + y,208,34,34 );
	gfx.PutPixel( 138 + x,18 + y,208,34,34 );
	gfx.PutPixel( 139 + x,18 + y,208,34,34 );
	gfx.PutPixel( 140 + x,18 + y,208,34,34 );
	gfx.PutPixel( 141 + x,18 + y,208,34,34 );
	gfx.PutPixel( 142 + x,18 + y,208,34,34 );
	gfx.PutPixel( 143 + x,18 + y,208,34,34 );
	gfx.PutPixel( 144 + x,18 + y,208,34,34 );
	gfx.PutPixel( 145 + x,18 + y,208,34,34 );
	gfx.PutPixel( 146 + x,18 + y,208,34,34 );
	gfx.PutPixel( 147 + x,18 + y,208,34,34 );
	gfx.PutPixel( 148 + x,18 + y,208,34,34 );
	gfx.PutPixel( 149 + x,18 + y,208,34,34 );
	gfx.PutPixel( 0 + x,19 + y,208,34,34 );
	gfx.PutPixel( 1 + x,19 + y,208,34,34 );
	gfx.PutPixel( 2 + x,19 + y,208,34,34 );
	gfx.PutPixel( 3 + x,19 + y,208,34,34 );
	gfx.PutPixel( 4 + x,19 + y,208,34,34 );
	gfx.PutPixel( 5 + x,19 + y,208,34,34 );
	gfx.PutPixel( 6 + x,19 + y,208,34,34 );
	gfx.PutPixel( 7 + x,19 + y,208,34,34 );
	gfx.PutPixel( 8 + x,19 + y,208,34,34 );
	gfx.PutPixel( 9 + x,19 + y,208,34,34 );
	gfx.PutPixel( 10 + x,19 + y,208,34,34 );
	gfx.PutPixel( 11 + x,19 + y,208,34,34 );
	gfx.PutPixel( 12 + x,19 + y,208,34,34 );
	gfx.PutPixel( 13 + x,19 + y,208,34,34 );
	gfx.PutPixel( 14 + x,19 + y,208,34,34 );
	gfx.PutPixel( 15 + x,19 + y,208,34,34 );
	gfx.PutPixel( 16 + x,19 + y,208,34,34 );
	gfx.PutPixel( 17 + x,19 + y,208,34,34 );
	gfx.PutPixel( 18 + x,19 + y,208,34,34 );
	gfx.PutPixel( 19 + x,19 + y,208,34,34 );
	gfx.PutPixel( 20 + x,19 + y,208,34,34 );
	gfx.PutPixel( 21 + x,19 + y,208,34,34 );
	gfx.PutPixel( 22 + x,19 + y,208,34,34 );
	gfx.PutPixel( 23 + x,19 + y,208,34,34 );
	gfx.PutPixel( 24 + x,19 + y,208,34,34 );
	gfx.PutPixel( 25 + x,19 + y,208,34,34 );
	gfx.PutPixel( 26 + x,19 + y,208,34,34 );
	gfx.PutPixel( 27 + x,19 + y,208,34,34 );
	gfx.PutPixel( 28 + x,19 + y,208,34,34 );
	gfx.PutPixel( 29 + x,19 + y,208,34,34 );
	gfx.PutPixel( 30 + x,19 + y,208,34,34 );
	gfx.PutPixel( 31 + x,19 + y,208,34,34 );
	gfx.PutPixel( 32 + x,19 + y,208,34,34 );
	gfx.PutPixel( 33 + x,19 + y,208,34,34 );
	gfx.PutPixel( 34 + x,19 + y,208,34,34 );
	gfx.PutPixel( 35 + x,19 + y,208,34,34 );
	gfx.PutPixel( 36 + x,19 + y,208,34,34 );
	gfx.PutPixel( 37 + x,19 + y,208,34,34 );
	gfx.PutPixel( 38 + x,19 + y,208,34,34 );
	gfx.PutPixel( 39 + x,19 + y,208,34,34 );
	gfx.PutPixel( 40 + x,19 + y,208,34,34 );
	gfx.PutPixel( 41 + x,19 + y,208,34,34 );
	gfx.PutPixel( 42 + x,19 + y,208,34,34 );
	gfx.PutPixel( 43 + x,19 + y,208,34,34 );
	gfx.PutPixel( 44 + x,19 + y,208,34,34 );
	gfx.PutPixel( 45 + x,19 + y,208,34,34 );
	gfx.PutPixel( 46 + x,19 + y,208,34,34 );
	gfx.PutPixel( 47 + x,19 + y,208,34,34 );
	gfx.PutPixel( 48 + x,19 + y,208,34,34 );
	gfx.PutPixel( 49 + x,19 + y,208,34,34 );
	gfx.PutPixel( 50 + x,19 + y,208,34,34 );
	gfx.PutPixel( 51 + x,19 + y,208,34,34 );
	gfx.PutPixel( 52 + x,19 + y,208,34,34 );
	gfx.PutPixel( 53 + x,19 + y,208,34,34 );
	gfx.PutPixel( 54 + x,19 + y,208,34,34 );
	gfx.PutPixel( 55 + x,19 + y,208,34,34 );
	gfx.PutPixel( 56 + x,19 + y,208,34,34 );
	gfx.PutPixel( 57 + x,19 + y,208,31,31 );
	gfx.PutPixel( 58 + x,19 + y,208,37,37 );
	gfx.PutPixel( 59 + x,19 + y,210,64,64 );
	gfx.PutPixel( 60 + x,19 + y,208,38,38 );
	gfx.PutPixel( 61 + x,19 + y,213,101,101 );
	gfx.PutPixel( 62 + x,19 + y,209,53,53 );
	gfx.PutPixel( 63 + x,19 + y,207,21,21 );
	gfx.PutPixel( 64 + x,19 + y,206,15,15 );
	gfx.PutPixel( 65 + x,19 + y,215,136,136 );
	gfx.PutPixel( 66 + x,19 + y,222,239,239 );
	gfx.PutPixel( 67 + x,19 + y,219,197,197 );
	gfx.PutPixel( 68 + x,19 + y,208,33,33 );
	gfx.PutPixel( 69 + x,19 + y,208,29,29 );
	gfx.PutPixel( 70 + x,19 + y,207,27,27 );
	gfx.PutPixel( 71 + x,19 + y,208,32,32 );
	gfx.PutPixel( 72 + x,19 + y,207,19,19 );
	gfx.PutPixel( 73 + x,19 + y,216,158,158 );
	gfx.PutPixel( 74 + x,19 + y,222,238,238 );
	gfx.PutPixel( 75 + x,19 + y,221,227,227 );
	gfx.PutPixel( 76 + x,19 + y,211,68,68 );
	gfx.PutPixel( 77 + x,19 + y,207,23,23 );
	gfx.PutPixel( 78 + x,19 + y,208,29,29 );
	gfx.PutPixel( 79 + x,19 + y,208,29,29 );
	gfx.PutPixel( 80 + x,19 + y,208,22,22 );
	gfx.PutPixel( 81 + x,19 + y,210,61,61 );
	gfx.PutPixel( 82 + x,19 + y,221,222,222 );
	gfx.PutPixel( 83 + x,19 + y,222,232,232 );
	gfx.PutPixel( 84 + x,19 + y,212,91,91 );
	gfx.PutPixel( 85 + x,19 + y,207,19,19 );
	gfx.PutPixel( 86 + x,19 + y,207,23,23 );
	gfx.PutPixel( 87 + x,19 + y,211,84,84 );
	gfx.PutPixel( 88 + x,19 + y,213,100,100 );
	gfx.PutPixel( 89 + x,19 + y,209,39,39 );
	gfx.PutPixel( 90 + x,19 + y,210,57,57 );
	gfx.PutPixel( 91 + x,19 + y,208,36,36 );
	gfx.PutPixel( 92 + x,19 + y,208,32,32 );
	gfx.PutPixel( 93 + x,19 + y,208,34,34 );
	gfx.PutPixel( 94 + x,19 + y,208,34,34 );
	gfx.PutPixel( 95 + x,19 + y,208,34,34 );
	gfx.PutPixel( 96 + x,19 + y,208,34,34 );
	gfx.PutPixel( 97 + x,19 + y,208,34,34 );
	gfx.PutPixel( 98 + x,19 + y,208,34,34 );
	gfx.PutPixel( 99 + x,19 + y,208,34,34 );
	gfx.PutPixel( 100 + x,19 + y,208,34,34 );
	gfx.PutPixel( 101 + x,19 + y,208,34,34 );
	gfx.PutPixel( 102 + x,19 + y,208,34,34 );
	gfx.PutPixel( 103 + x,19 + y,208,34,34 );
	gfx.PutPixel( 104 + x,19 + y,208,34,34 );
	gfx.PutPixel( 105 + x,19 + y,208,34,34 );
	gfx.PutPixel( 106 + x,19 + y,208,34,34 );
	gfx.PutPixel( 107 + x,19 + y,208,34,34 );
	gfx.PutPixel( 108 + x,19 + y,208,34,34 );
	gfx.PutPixel( 109 + x,19 + y,208,34,34 );
	gfx.PutPixel( 110 + x,19 + y,208,34,34 );
	gfx.PutPixel( 111 + x,19 + y,208,34,34 );
	gfx.PutPixel( 112 + x,19 + y,208,34,34 );
	gfx.PutPixel( 113 + x,19 + y,208,34,34 );
	gfx.PutPixel( 114 + x,19 + y,208,34,34 );
	gfx.PutPixel( 115 + x,19 + y,208,34,34 );
	gfx.PutPixel( 116 + x,19 + y,208,34,34 );
	gfx.PutPixel( 117 + x,19 + y,208,34,34 );
	gfx.PutPixel( 118 + x,19 + y,208,34,34 );
	gfx.PutPixel( 119 + x,19 + y,208,34,34 );
	gfx.PutPixel( 120 + x,19 + y,208,34,34 );
	gfx.PutPixel( 121 + x,19 + y,208,34,34 );
	gfx.PutPixel( 122 + x,19 + y,208,34,34 );
	gfx.PutPixel( 123 + x,19 + y,208,34,34 );
	gfx.PutPixel( 124 + x,19 + y,208,34,34 );
	gfx.PutPixel( 125 + x,19 + y,208,34,34 );
	gfx.PutPixel( 126 + x,19 + y,208,34,34 );
	gfx.PutPixel( 127 + x,19 + y,208,34,34 );
	gfx.PutPixel( 128 + x,19 + y,208,34,34 );
	gfx.PutPixel( 129 + x,19 + y,208,34,34 );
	gfx.PutPixel( 130 + x,19 + y,208,34,34 );
	gfx.PutPixel( 131 + x,19 + y,208,34,34 );
	gfx.PutPixel( 132 + x,19 + y,208,34,34 );
	gfx.PutPixel( 133 + x,19 + y,208,34,34 );
	gfx.PutPixel( 134 + x,19 + y,208,34,34 );
	gfx.PutPixel( 135 + x,19 + y,208,34,34 );
	gfx.PutPixel( 136 + x,19 + y,208,34,34 );
	gfx.PutPixel( 137 + x,19 + y,208,34,34 );
	gfx.PutPixel( 138 + x,19 + y,208,34,34 );
	gfx.PutPixel( 139 + x,19 + y,208,34,34 );
	gfx.PutPixel( 140 + x,19 + y,208,34,34 );
	gfx.PutPixel( 141 + x,19 + y,208,34,34 );
	gfx.PutPixel( 142 + x,19 + y,208,34,34 );
	gfx.PutPixel( 143 + x,19 + y,208,34,34 );
	gfx.PutPixel( 144 + x,19 + y,208,34,34 );
	gfx.PutPixel( 145 + x,19 + y,208,34,34 );
	gfx.PutPixel( 146 + x,19 + y,208,34,34 );
	gfx.PutPixel( 147 + x,19 + y,208,34,34 );
	gfx.PutPixel( 148 + x,19 + y,208,34,34 );
	gfx.PutPixel( 149 + x,19 + y,208,34,34 );
	gfx.PutPixel( 0 + x,20 + y,208,34,34 );
	gfx.PutPixel( 1 + x,20 + y,208,34,34 );
	gfx.PutPixel( 2 + x,20 + y,208,34,34 );
	gfx.PutPixel( 3 + x,20 + y,208,34,34 );
	gfx.PutPixel( 4 + x,20 + y,208,34,34 );
	gfx.PutPixel( 5 + x,20 + y,208,34,34 );
	gfx.PutPixel( 6 + x,20 + y,208,34,34 );
	gfx.PutPixel( 7 + x,20 + y,208,34,34 );
	gfx.PutPixel( 8 + x,20 + y,208,34,34 );
	gfx.PutPixel( 9 + x,20 + y,208,34,34 );
	gfx.PutPixel( 10 + x,20 + y,208,34,34 );
	gfx.PutPixel( 11 + x,20 + y,208,34,34 );
	gfx.PutPixel( 12 + x,20 + y,208,34,34 );
	gfx.PutPixel( 13 + x,20 + y,208,34,34 );
	gfx.PutPixel( 14 + x,20 + y,208,34,34 );
	gfx.PutPixel( 15 + x,20 + y,208,34,34 );
	gfx.PutPixel( 16 + x,20 + y,208,34,34 );
	gfx.PutPixel( 17 + x,20 + y,208,34,34 );
	gfx.PutPixel( 18 + x,20 + y,208,34,34 );
	gfx.PutPixel( 19 + x,20 + y,208,34,34 );
	gfx.PutPixel( 20 + x,20 + y,208,34,34 );
	gfx.PutPixel( 21 + x,20 + y,208,34,34 );
	gfx.PutPixel( 22 + x,20 + y,208,34,34 );
	gfx.PutPixel( 23 + x,20 + y,208,34,34 );
	gfx.PutPixel( 24 + x,20 + y,208,34,34 );
	gfx.PutPixel( 25 + x,20 + y,208,34,34 );
	gfx.PutPixel( 26 + x,20 + y,208,34,34 );
	gfx.PutPixel( 27 + x,20 + y,208,34,34 );
	gfx.PutPixel( 28 + x,20 + y,208,34,34 );
	gfx.PutPixel( 29 + x,20 + y,208,34,34 );
	gfx.PutPixel( 30 + x,20 + y,208,34,34 );
	gfx.PutPixel( 31 + x,20 + y,208,34,34 );
	gfx.PutPixel( 32 + x,20 + y,208,34,34 );
	gfx.PutPixel( 33 + x,20 + y,208,34,34 );
	gfx.PutPixel( 34 + x,20 + y,208,34,34 );
	gfx.PutPixel( 35 + x,20 + y,208,34,34 );
	gfx.PutPixel( 36 + x,20 + y,208,34,34 );
	gfx.PutPixel( 37 + x,20 + y,208,34,34 );
	gfx.PutPixel( 38 + x,20 + y,208,34,34 );
	gfx.PutPixel( 39 + x,20 + y,208,34,34 );
	gfx.PutPixel( 40 + x,20 + y,208,34,34 );
	gfx.PutPixel( 41 + x,20 + y,208,34,34 );
	gfx.PutPixel( 42 + x,20 + y,208,34,34 );
	gfx.PutPixel( 43 + x,20 + y,208,34,34 );
	gfx.PutPixel( 44 + x,20 + y,208,34,34 );
	gfx.PutPixel( 45 + x,20 + y,208,34,34 );
	gfx.PutPixel( 46 + x,20 + y,208,34,34 );
	gfx.PutPixel( 47 + x,20 + y,208,34,34 );
	gfx.PutPixel( 48 + x,20 + y,208,34,34 );
	gfx.PutPixel( 49 + x,20 + y,208,34,34 );
	gfx.PutPixel( 50 + x,20 + y,208,34,34 );
	gfx.PutPixel( 51 + x,20 + y,208,34,34 );
	gfx.PutPixel( 52 + x,20 + y,208,34,34 );
	gfx.PutPixel( 53 + x,20 + y,208,34,34 );
	gfx.PutPixel( 54 + x,20 + y,208,34,34 );
	gfx.PutPixel( 55 + x,20 + y,208,34,34 );
	gfx.PutPixel( 56 + x,20 + y,207,26,26 );
	gfx.PutPixel( 57 + x,20 + y,212,85,85 );
	gfx.PutPixel( 58 + x,20 + y,220,202,202 );
	gfx.PutPixel( 59 + x,20 + y,219,188,188 );
	gfx.PutPixel( 60 + x,20 + y,208,35,35 );
	gfx.PutPixel( 61 + x,20 + y,207,24,24 );
	gfx.PutPixel( 62 + x,20 + y,207,25,25 );
	gfx.PutPixel( 63 + x,20 + y,209,45,45 );
	gfx.PutPixel( 64 + x,20 + y,210,69,69 );
	gfx.PutPixel( 65 + x,20 + y,214,123,123 );
	gfx.PutPixel( 66 + x,20 + y,222,231,231 );
	gfx.PutPixel( 67 + x,20 + y,219,188,188 );
	gfx.PutPixel( 68 + x,20 + y,214,121,121 );
	gfx.PutPixel( 69 + x,20 + y,218,186,186 );
	gfx.PutPixel( 70 + x,20 + y,214,124,124 );
	gfx.PutPixel( 71 + x,20 + y,209,44,44 );
	gfx.PutPixel( 72 + x,20 + y,213,102,102 );
	gfx.PutPixel( 73 + x,20 + y,212,85,85 );
	gfx.PutPixel( 74 + x,20 + y,222,235,235 );
	gfx.PutPixel( 75 + x,20 + y,218,177,177 );
	gfx.PutPixel( 76 + x,20 + y,211,72,72 );
	gfx.PutPixel( 77 + x,20 + y,212,89,89 );
	gfx.PutPixel( 78 + x,20 + y,210,62,62 );
	gfx.PutPixel( 79 + x,20 + y,218,176,176 );
	gfx.PutPixel( 80 + x,20 + y,217,162,162 );
	gfx.PutPixel( 81 + x,20 + y,213,107,107 );
	gfx.PutPixel( 82 + x,20 + y,221,221,221 );
	gfx.PutPixel( 83 + x,20 + y,220,213,213 );
	gfx.PutPixel( 84 + x,20 + y,210,68,68 );
	gfx.PutPixel( 85 + x,20 + y,209,42,42 );
	gfx.PutPixel( 86 + x,20 + y,208,28,28 );
	gfx.PutPixel( 87 + x,20 + y,208,27,27 );
	gfx.PutPixel( 88 + x,20 + y,207,22,22 );
	gfx.PutPixel( 89 + x,20 + y,209,54,54 );
	gfx.PutPixel( 90 + x,20 + y,220,207,207 );
	gfx.PutPixel( 91 + x,20 + y,219,188,188 );
	gfx.PutPixel( 92 + x,20 + y,210,58,58 );
	gfx.PutPixel( 93 + x,20 + y,208,29,29 );
	gfx.PutPixel( 94 + x,20 + y,208,34,34 );
	gfx.PutPixel( 95 + x,20 + y,208,34,34 );
	gfx.PutPixel( 96 + x,20 + y,208,34,34 );
	gfx.PutPixel( 97 + x,20 + y,208,34,34 );
	gfx.PutPixel( 98 + x,20 + y,208,34,34 );
	gfx.PutPixel( 99 + x,20 + y,208,34,34 );
	gfx.PutPixel( 100 + x,20 + y,208,34,34 );
	gfx.PutPixel( 101 + x,20 + y,208,34,34 );
	gfx.PutPixel( 102 + x,20 + y,208,34,34 );
	gfx.PutPixel( 103 + x,20 + y,208,34,34 );
	gfx.PutPixel( 104 + x,20 + y,208,34,34 );
	gfx.PutPixel( 105 + x,20 + y,208,34,34 );
	gfx.PutPixel( 106 + x,20 + y,208,34,34 );
	gfx.PutPixel( 107 + x,20 + y,208,34,34 );
	gfx.PutPixel( 108 + x,20 + y,208,34,34 );
	gfx.PutPixel( 109 + x,20 + y,208,34,34 );
	gfx.PutPixel( 110 + x,20 + y,208,34,34 );
	gfx.PutPixel( 111 + x,20 + y,208,34,34 );
	gfx.PutPixel( 112 + x,20 + y,208,34,34 );
	gfx.PutPixel( 113 + x,20 + y,208,34,34 );
	gfx.PutPixel( 114 + x,20 + y,208,34,34 );
	gfx.PutPixel( 115 + x,20 + y,208,34,34 );
	gfx.PutPixel( 116 + x,20 + y,208,34,34 );
	gfx.PutPixel( 117 + x,20 + y,208,34,34 );
	gfx.PutPixel( 118 + x,20 + y,208,34,34 );
	gfx.PutPixel( 119 + x,20 + y,208,34,34 );
	gfx.PutPixel( 120 + x,20 + y,208,34,34 );
	gfx.PutPixel( 121 + x,20 + y,208,34,34 );
	gfx.PutPixel( 122 + x,20 + y,208,34,34 );
	gfx.PutPixel( 123 + x,20 + y,208,34,34 );
	gfx.PutPixel( 124 + x,20 + y,208,34,34 );
	gfx.PutPixel( 125 + x,20 + y,208,34,34 );
	gfx.PutPixel( 126 + x,20 + y,208,34,34 );
	gfx.PutPixel( 127 + x,20 + y,208,34,34 );
	gfx.PutPixel( 128 + x,20 + y,208,34,34 );
	gfx.PutPixel( 129 + x,20 + y,208,34,34 );
	gfx.PutPixel( 130 + x,20 + y,208,34,34 );
	gfx.PutPixel( 131 + x,20 + y,208,34,34 );
	gfx.PutPixel( 132 + x,20 + y,208,34,34 );
	gfx.PutPixel( 133 + x,20 + y,208,34,34 );
	gfx.PutPixel( 134 + x,20 + y,208,34,34 );
	gfx.PutPixel( 135 + x,20 + y,208,34,34 );
	gfx.PutPixel( 136 + x,20 + y,208,34,34 );
	gfx.PutPixel( 137 + x,20 + y,208,34,34 );
	gfx.PutPixel( 138 + x,20 + y,208,34,34 );
	gfx.PutPixel( 139 + x,20 + y,208,34,34 );
	gfx.PutPixel( 140 + x,20 + y,208,34,34 );
	gfx.PutPixel( 141 + x,20 + y,208,34,34 );
	gfx.PutPixel( 142 + x,20 + y,208,34,34 );
	gfx.PutPixel( 143 + x,20 + y,208,34,34 );
	gfx.PutPixel( 144 + x,20 + y,208,34,34 );
	gfx.PutPixel( 145 + x,20 + y,208,34,34 );
	gfx.PutPixel( 146 + x,20 + y,208,34,34 );
	gfx.PutPixel( 147 + x,20 + y,208,34,34 );
	gfx.PutPixel( 148 + x,20 + y,208,34,34 );
	gfx.PutPixel( 149 + x,20 + y,208,34,34 );
	gfx.PutPixel( 0 + x,21 + y,208,34,34 );
	gfx.PutPixel( 1 + x,21 + y,208,34,34 );
	gfx.PutPixel( 2 + x,21 + y,208,34,34 );
	gfx.PutPixel( 3 + x,21 + y,208,34,34 );
	gfx.PutPixel( 4 + x,21 + y,208,34,34 );
	gfx.PutPixel( 5 + x,21 + y,208,34,34 );
	gfx.PutPixel( 6 + x,21 + y,208,34,34 );
	gfx.PutPixel( 7 + x,21 + y,208,34,34 );
	gfx.PutPixel( 8 + x,21 + y,208,34,34 );
	gfx.PutPixel( 9 + x,21 + y,208,34,34 );
	gfx.PutPixel( 10 + x,21 + y,208,34,34 );
	gfx.PutPixel( 11 + x,21 + y,208,34,34 );
	gfx.PutPixel( 12 + x,21 + y,208,34,34 );
	gfx.PutPixel( 13 + x,21 + y,208,34,34 );
	gfx.PutPixel( 14 + x,21 + y,208,34,34 );
	gfx.PutPixel( 15 + x,21 + y,208,34,34 );
	gfx.PutPixel( 16 + x,21 + y,208,34,34 );
	gfx.PutPixel( 17 + x,21 + y,208,34,34 );
	gfx.PutPixel( 18 + x,21 + y,208,34,34 );
	gfx.PutPixel( 19 + x,21 + y,208,34,34 );
	gfx.PutPixel( 20 + x,21 + y,208,34,34 );
	gfx.PutPixel( 21 + x,21 + y,208,34,34 );
	gfx.PutPixel( 22 + x,21 + y,208,34,34 );
	gfx.PutPixel( 23 + x,21 + y,208,34,34 );
	gfx.PutPixel( 24 + x,21 + y,208,34,34 );
	gfx.PutPixel( 25 + x,21 + y,208,34,34 );
	gfx.PutPixel( 26 + x,21 + y,208,34,34 );
	gfx.PutPixel( 27 + x,21 + y,208,34,34 );
	gfx.PutPixel( 28 + x,21 + y,208,34,34 );
	gfx.PutPixel( 29 + x,21 + y,208,34,34 );
	gfx.PutPixel( 30 + x,21 + y,208,34,34 );
	gfx.PutPixel( 31 + x,21 + y,208,34,34 );
	gfx.PutPixel( 32 + x,21 + y,208,34,34 );
	gfx.PutPixel( 33 + x,21 + y,208,34,34 );
	gfx.PutPixel( 34 + x,21 + y,208,34,34 );
	gfx.PutPixel( 35 + x,21 + y,208,34,34 );
	gfx.PutPixel( 36 + x,21 + y,208,34,34 );
	gfx.PutPixel( 37 + x,21 + y,208,34,34 );
	gfx.PutPixel( 38 + x,21 + y,208,34,34 );
	gfx.PutPixel( 39 + x,21 + y,208,34,34 );
	gfx.PutPixel( 40 + x,21 + y,208,34,34 );
	gfx.PutPixel( 41 + x,21 + y,208,34,34 );
	gfx.PutPixel( 42 + x,21 + y,208,34,34 );
	gfx.PutPixel( 43 + x,21 + y,208,34,34 );
	gfx.PutPixel( 44 + x,21 + y,208,34,34 );
	gfx.PutPixel( 45 + x,21 + y,208,34,34 );
	gfx.PutPixel( 46 + x,21 + y,208,34,34 );
	gfx.PutPixel( 47 + x,21 + y,208,34,34 );
	gfx.PutPixel( 48 + x,21 + y,208,34,34 );
	gfx.PutPixel( 49 + x,21 + y,208,34,34 );
	gfx.PutPixel( 50 + x,21 + y,208,34,34 );
	gfx.PutPixel( 51 + x,21 + y,208,34,34 );
	gfx.PutPixel( 52 + x,21 + y,208,34,34 );
	gfx.PutPixel( 53 + x,21 + y,208,34,34 );
	gfx.PutPixel( 54 + x,21 + y,208,34,34 );
	gfx.PutPixel( 55 + x,21 + y,208,34,34 );
	gfx.PutPixel( 56 + x,21 + y,208,27,27 );
	gfx.PutPixel( 57 + x,21 + y,211,69,69 );
	gfx.PutPixel( 58 + x,21 + y,222,234,234 );
	gfx.PutPixel( 59 + x,21 + y,214,121,121 );
	gfx.PutPixel( 60 + x,21 + y,212,85,85 );
	gfx.PutPixel( 61 + x,21 + y,210,56,56 );
	gfx.PutPixel( 62 + x,21 + y,210,59,59 );
	gfx.PutPixel( 63 + x,21 + y,219,196,196 );
	gfx.PutPixel( 64 + x,21 + y,221,228,228 );
	gfx.PutPixel( 65 + x,21 + y,220,212,212 );
	gfx.PutPixel( 66 + x,21 + y,221,219,219 );
	gfx.PutPixel( 67 + x,21 + y,221,216,216 );
	gfx.PutPixel( 68 + x,21 + y,222,235,235 );
	gfx.PutPixel( 69 + x,21 + y,222,240,240 );
	gfx.PutPixel( 70 + x,21 + y,222,230,230 );
	gfx.PutPixel( 71 + x,21 + y,213,100,100 );
	gfx.PutPixel( 72 + x,21 + y,219,197,197 );
	gfx.PutPixel( 73 + x,21 + y,219,199,199 );
	gfx.PutPixel( 74 + x,21 + y,217,169,169 );
	gfx.PutPixel( 75 + x,21 + y,217,170,170 );
	gfx.PutPixel( 76 + x,21 + y,221,222,222 );
	gfx.PutPixel( 77 + x,21 + y,214,127,127 );
	gfx.PutPixel( 78 + x,21 + y,216,156,156 );
	gfx.PutPixel( 79 + x,21 + y,223,242,242 );
	gfx.PutPixel( 80 + x,21 + y,222,238,238 );
	gfx.PutPixel( 81 + x,21 + y,221,216,216 );
	gfx.PutPixel( 82 + x,21 + y,221,221,221 );
	gfx.PutPixel( 83 + x,21 + y,219,197,197 );
	gfx.PutPixel( 84 + x,21 + y,218,184,184 );
	gfx.PutPixel( 85 + x,21 + y,220,212,212 );
	gfx.PutPixel( 86 + x,21 + y,214,124,124 );
	gfx.PutPixel( 87 + x,21 + y,207,26,26 );
	gfx.PutPixel( 88 + x,21 + y,214,119,119 );
	gfx.PutPixel( 89 + x,21 + y,210,71,71 );
	gfx.PutPixel( 90 + x,21 + y,220,202,202 );
	gfx.PutPixel( 91 + x,21 + y,219,204,204 );
	gfx.PutPixel( 92 + x,21 + y,209,41,41 );
	gfx.PutPixel( 93 + x,21 + y,208,31,31 );
	gfx.PutPixel( 94 + x,21 + y,208,34,34 );
	gfx.PutPixel( 95 + x,21 + y,208,34,34 );
	gfx.PutPixel( 96 + x,21 + y,208,34,34 );
	gfx.PutPixel( 97 + x,21 + y,208,34,34 );
	gfx.PutPixel( 98 + x,21 + y,208,34,34 );
	gfx.PutPixel( 99 + x,21 + y,208,34,34 );
	gfx.PutPixel( 100 + x,21 + y,208,34,34 );
	gfx.PutPixel( 101 + x,21 + y,208,34,34 );
	gfx.PutPixel( 102 + x,21 + y,208,34,34 );
	gfx.PutPixel( 103 + x,21 + y,208,34,34 );
	gfx.PutPixel( 104 + x,21 + y,208,34,34 );
	gfx.PutPixel( 105 + x,21 + y,208,34,34 );
	gfx.PutPixel( 106 + x,21 + y,208,34,34 );
	gfx.PutPixel( 107 + x,21 + y,208,34,34 );
	gfx.PutPixel( 108 + x,21 + y,208,34,34 );
	gfx.PutPixel( 109 + x,21 + y,208,34,34 );
	gfx.PutPixel( 110 + x,21 + y,208,34,34 );
	gfx.PutPixel( 111 + x,21 + y,208,34,34 );
	gfx.PutPixel( 112 + x,21 + y,208,34,34 );
	gfx.PutPixel( 113 + x,21 + y,208,34,34 );
	gfx.PutPixel( 114 + x,21 + y,208,34,34 );
	gfx.PutPixel( 115 + x,21 + y,208,34,34 );
	gfx.PutPixel( 116 + x,21 + y,208,34,34 );
	gfx.PutPixel( 117 + x,21 + y,208,34,34 );
	gfx.PutPixel( 118 + x,21 + y,208,34,34 );
	gfx.PutPixel( 119 + x,21 + y,208,34,34 );
	gfx.PutPixel( 120 + x,21 + y,208,34,34 );
	gfx.PutPixel( 121 + x,21 + y,208,34,34 );
	gfx.PutPixel( 122 + x,21 + y,208,34,34 );
	gfx.PutPixel( 123 + x,21 + y,208,34,34 );
	gfx.PutPixel( 124 + x,21 + y,208,34,34 );
	gfx.PutPixel( 125 + x,21 + y,208,34,34 );
	gfx.PutPixel( 126 + x,21 + y,208,34,34 );
	gfx.PutPixel( 127 + x,21 + y,208,34,34 );
	gfx.PutPixel( 128 + x,21 + y,208,34,34 );
	gfx.PutPixel( 129 + x,21 + y,208,34,34 );
	gfx.PutPixel( 130 + x,21 + y,208,34,34 );
	gfx.PutPixel( 131 + x,21 + y,208,34,34 );
	gfx.PutPixel( 132 + x,21 + y,208,34,34 );
	gfx.PutPixel( 133 + x,21 + y,208,34,34 );
	gfx.PutPixel( 134 + x,21 + y,208,34,34 );
	gfx.PutPixel( 135 + x,21 + y,208,34,34 );
	gfx.PutPixel( 136 + x,21 + y,208,34,34 );
	gfx.PutPixel( 137 + x,21 + y,208,34,34 );
	gfx.PutPixel( 138 + x,21 + y,208,34,34 );
	gfx.PutPixel( 139 + x,21 + y,208,34,34 );
	gfx.PutPixel( 140 + x,21 + y,208,34,34 );
	gfx.PutPixel( 141 + x,21 + y,208,34,34 );
	gfx.PutPixel( 142 + x,21 + y,208,34,34 );
	gfx.PutPixel( 143 + x,21 + y,208,34,34 );
	gfx.PutPixel( 144 + x,21 + y,208,34,34 );
	gfx.PutPixel( 145 + x,21 + y,208,34,34 );
	gfx.PutPixel( 146 + x,21 + y,208,34,34 );
	gfx.PutPixel( 147 + x,21 + y,208,34,34 );
	gfx.PutPixel( 148 + x,21 + y,208,34,34 );
	gfx.PutPixel( 149 + x,21 + y,208,34,34 );
	gfx.PutPixel( 0 + x,22 + y,208,34,34 );
	gfx.PutPixel( 1 + x,22 + y,208,34,34 );
	gfx.PutPixel( 2 + x,22 + y,208,34,34 );
	gfx.PutPixel( 3 + x,22 + y,208,34,34 );
	gfx.PutPixel( 4 + x,22 + y,208,34,34 );
	gfx.PutPixel( 5 + x,22 + y,208,34,34 );
	gfx.PutPixel( 6 + x,22 + y,208,34,34 );
	gfx.PutPixel( 7 + x,22 + y,208,34,34 );
	gfx.PutPixel( 8 + x,22 + y,208,34,34 );
	gfx.PutPixel( 9 + x,22 + y,208,34,34 );
	gfx.PutPixel( 10 + x,22 + y,208,34,34 );
	gfx.PutPixel( 11 + x,22 + y,208,34,34 );
	gfx.PutPixel( 12 + x,22 + y,208,34,34 );
	gfx.PutPixel( 13 + x,22 + y,208,34,34 );
	gfx.PutPixel( 14 + x,22 + y,208,34,34 );
	gfx.PutPixel( 15 + x,22 + y,208,34,34 );
	gfx.PutPixel( 16 + x,22 + y,208,34,34 );
	gfx.PutPixel( 17 + x,22 + y,208,34,34 );
	gfx.PutPixel( 18 + x,22 + y,208,34,34 );
	gfx.PutPixel( 19 + x,22 + y,208,34,34 );
	gfx.PutPixel( 20 + x,22 + y,208,34,34 );
	gfx.PutPixel( 21 + x,22 + y,208,34,34 );
	gfx.PutPixel( 22 + x,22 + y,208,34,34 );
	gfx.PutPixel( 23 + x,22 + y,208,34,34 );
	gfx.PutPixel( 24 + x,22 + y,208,34,34 );
	gfx.PutPixel( 25 + x,22 + y,208,34,34 );
	gfx.PutPixel( 26 + x,22 + y,208,34,34 );
	gfx.PutPixel( 27 + x,22 + y,208,34,34 );
	gfx.PutPixel( 28 + x,22 + y,208,34,34 );
	gfx.PutPixel( 29 + x,22 + y,208,34,34 );
	gfx.PutPixel( 30 + x,22 + y,208,34,34 );
	gfx.PutPixel( 31 + x,22 + y,208,34,34 );
	gfx.PutPixel( 32 + x,22 + y,208,34,34 );
	gfx.PutPixel( 33 + x,22 + y,208,34,34 );
	gfx.PutPixel( 34 + x,22 + y,208,34,34 );
	gfx.PutPixel( 35 + x,22 + y,208,34,34 );
	gfx.PutPixel( 36 + x,22 + y,208,34,34 );
	gfx.PutPixel( 37 + x,22 + y,208,34,34 );
	gfx.PutPixel( 38 + x,22 + y,208,34,34 );
	gfx.PutPixel( 39 + x,22 + y,208,34,34 );
	gfx.PutPixel( 40 + x,22 + y,208,34,34 );
	gfx.PutPixel( 41 + x,22 + y,208,34,34 );
	gfx.PutPixel( 42 + x,22 + y,208,34,34 );
	gfx.PutPixel( 43 + x,22 + y,208,34,34 );
	gfx.PutPixel( 44 + x,22 + y,208,34,34 );
	gfx.PutPixel( 45 + x,22 + y,208,34,34 );
	gfx.PutPixel( 46 + x,22 + y,208,34,34 );
	gfx.PutPixel( 47 + x,22 + y,208,34,34 );
	gfx.PutPixel( 48 + x,22 + y,208,34,34 );
	gfx.PutPixel( 49 + x,22 + y,208,34,34 );
	gfx.PutPixel( 50 + x,22 + y,208,34,34 );
	gfx.PutPixel( 51 + x,22 + y,208,34,34 );
	gfx.PutPixel( 52 + x,22 + y,208,34,34 );
	gfx.PutPixel( 53 + x,22 + y,208,34,34 );
	gfx.PutPixel( 54 + x,22 + y,208,34,34 );
	gfx.PutPixel( 55 + x,22 + y,208,34,34 );
	gfx.PutPixel( 56 + x,22 + y,208,32,32 );
	gfx.PutPixel( 57 + x,22 + y,209,39,39 );
	gfx.PutPixel( 58 + x,22 + y,218,179,179 );
	gfx.PutPixel( 59 + x,22 + y,218,173,173 );
	gfx.PutPixel( 60 + x,22 + y,221,224,224 );
	gfx.PutPixel( 61 + x,22 + y,211,84,84 );
	gfx.PutPixel( 62 + x,22 + y,216,148,148 );
	gfx.PutPixel( 63 + x,22 + y,222,240,240 );
	gfx.PutPixel( 64 + x,22 + y,221,225,225 );
	gfx.PutPixel( 65 + x,22 + y,221,227,227 );
	gfx.PutPixel( 66 + x,22 + y,221,225,225 );
	gfx.PutPixel( 67 + x,22 + y,221,222,222 );
	gfx.PutPixel( 68 + x,22 + y,216,157,157 );
	gfx.PutPixel( 69 + x,22 + y,217,162,162 );
	gfx.PutPixel( 70 + x,22 + y,222,236,236 );
	gfx.PutPixel( 71 + x,22 + y,214,117,117 );
	gfx.PutPixel( 72 + x,22 + y,219,190,190 );
	gfx.PutPixel( 73 + x,22 + y,223,242,242 );
	gfx.PutPixel( 74 + x,22 + y,215,137,137 );
	gfx.PutPixel( 75 + x,22 + y,218,178,178 );
	gfx.PutPixel( 76 + x,22 + y,223,248,248 );
	gfx.PutPixel( 77 + x,22 + y,214,123,123 );
	gfx.PutPixel( 78 + x,22 + y,218,177,177 );
	gfx.PutPixel( 79 + x,22 + y,220,215,215 );
	gfx.PutPixel( 80 + x,22 + y,218,182,182 );
	gfx.PutPixel( 81 + x,22 + y,221,224,224 );
	gfx.PutPixel( 82 + x,22 + y,221,221,221 );
	gfx.PutPixel( 83 + x,22 + y,222,229,229 );
	gfx.PutPixel( 84 + x,22 + y,222,237,237 );
	gfx.PutPixel( 85 + x,22 + y,222,230,230 );
	gfx.PutPixel( 86 + x,22 + y,221,223,223 );
	gfx.PutPixel( 87 + x,22 + y,211,73,73 );
	gfx.PutPixel( 88 + x,22 + y,219,196,196 );
	gfx.PutPixel( 89 + x,22 + y,219,196,196 );
	gfx.PutPixel( 90 + x,22 + y,220,207,207 );
	gfx.PutPixel( 91 + x,22 + y,215,135,135 );
	gfx.PutPixel( 92 + x,22 + y,207,23,23 );
	gfx.PutPixel( 93 + x,22 + y,208,34,34 );
	gfx.PutPixel( 94 + x,22 + y,208,34,34 );
	gfx.PutPixel( 95 + x,22 + y,208,34,34 );
	gfx.PutPixel( 96 + x,22 + y,208,34,34 );
	gfx.PutPixel( 97 + x,22 + y,208,34,34 );
	gfx.PutPixel( 98 + x,22 + y,208,34,34 );
	gfx.PutPixel( 99 + x,22 + y,208,34,34 );
	gfx.PutPixel( 100 + x,22 + y,208,34,34 );
	gfx.PutPixel( 101 + x,22 + y,208,34,34 );
	gfx.PutPixel( 102 + x,22 + y,208,34,34 );
	gfx.PutPixel( 103 + x,22 + y,208,34,34 );
	gfx.PutPixel( 104 + x,22 + y,208,34,34 );
	gfx.PutPixel( 105 + x,22 + y,208,34,34 );
	gfx.PutPixel( 106 + x,22 + y,208,34,34 );
	gfx.PutPixel( 107 + x,22 + y,208,34,34 );
	gfx.PutPixel( 108 + x,22 + y,208,34,34 );
	gfx.PutPixel( 109 + x,22 + y,208,34,34 );
	gfx.PutPixel( 110 + x,22 + y,208,34,34 );
	gfx.PutPixel( 111 + x,22 + y,208,34,34 );
	gfx.PutPixel( 112 + x,22 + y,208,34,34 );
	gfx.PutPixel( 113 + x,22 + y,208,34,34 );
	gfx.PutPixel( 114 + x,22 + y,208,34,34 );
	gfx.PutPixel( 115 + x,22 + y,208,34,34 );
	gfx.PutPixel( 116 + x,22 + y,208,34,34 );
	gfx.PutPixel( 117 + x,22 + y,208,34,34 );
	gfx.PutPixel( 118 + x,22 + y,208,34,34 );
	gfx.PutPixel( 119 + x,22 + y,208,34,34 );
	gfx.PutPixel( 120 + x,22 + y,208,34,34 );
	gfx.PutPixel( 121 + x,22 + y,208,34,34 );
	gfx.PutPixel( 122 + x,22 + y,208,34,34 );
	gfx.PutPixel( 123 + x,22 + y,208,34,34 );
	gfx.PutPixel( 124 + x,22 + y,208,34,34 );
	gfx.PutPixel( 125 + x,22 + y,208,34,34 );
	gfx.PutPixel( 126 + x,22 + y,208,34,34 );
	gfx.PutPixel( 127 + x,22 + y,208,34,34 );
	gfx.PutPixel( 128 + x,22 + y,208,34,34 );
	gfx.PutPixel( 129 + x,22 + y,208,34,34 );
	gfx.PutPixel( 130 + x,22 + y,208,34,34 );
	gfx.PutPixel( 131 + x,22 + y,208,34,34 );
	gfx.PutPixel( 132 + x,22 + y,208,34,34 );
	gfx.PutPixel( 133 + x,22 + y,208,34,34 );
	gfx.PutPixel( 134 + x,22 + y,208,34,34 );
	gfx.PutPixel( 135 + x,22 + y,208,34,34 );
	gfx.PutPixel( 136 + x,22 + y,208,34,34 );
	gfx.PutPixel( 137 + x,22 + y,208,34,34 );
	gfx.PutPixel( 138 + x,22 + y,208,34,34 );
	gfx.PutPixel( 139 + x,22 + y,208,34,34 );
	gfx.PutPixel( 140 + x,22 + y,208,34,34 );
	gfx.PutPixel( 141 + x,22 + y,208,34,34 );
	gfx.PutPixel( 142 + x,22 + y,208,34,34 );
	gfx.PutPixel( 143 + x,22 + y,208,34,34 );
	gfx.PutPixel( 144 + x,22 + y,208,34,34 );
	gfx.PutPixel( 145 + x,22 + y,208,34,34 );
	gfx.PutPixel( 146 + x,22 + y,208,34,34 );
	gfx.PutPixel( 147 + x,22 + y,208,34,34 );
	gfx.PutPixel( 148 + x,22 + y,208,34,34 );
	gfx.PutPixel( 149 + x,22 + y,208,34,34 );
	gfx.PutPixel( 0 + x,23 + y,208,34,34 );
	gfx.PutPixel( 1 + x,23 + y,208,34,34 );
	gfx.PutPixel( 2 + x,23 + y,208,34,34 );
	gfx.PutPixel( 3 + x,23 + y,208,34,34 );
	gfx.PutPixel( 4 + x,23 + y,208,34,34 );
	gfx.PutPixel( 5 + x,23 + y,208,34,34 );
	gfx.PutPixel( 6 + x,23 + y,208,34,34 );
	gfx.PutPixel( 7 + x,23 + y,208,34,34 );
	gfx.PutPixel( 8 + x,23 + y,208,34,34 );
	gfx.PutPixel( 9 + x,23 + y,208,34,34 );
	gfx.PutPixel( 10 + x,23 + y,208,34,34 );
	gfx.PutPixel( 11 + x,23 + y,208,34,34 );
	gfx.PutPixel( 12 + x,23 + y,208,34,34 );
	gfx.PutPixel( 13 + x,23 + y,208,34,34 );
	gfx.PutPixel( 14 + x,23 + y,208,34,34 );
	gfx.PutPixel( 15 + x,23 + y,208,34,34 );
	gfx.PutPixel( 16 + x,23 + y,208,34,34 );
	gfx.PutPixel( 17 + x,23 + y,208,34,34 );
	gfx.PutPixel( 18 + x,23 + y,208,34,34 );
	gfx.PutPixel( 19 + x,23 + y,208,34,34 );
	gfx.PutPixel( 20 + x,23 + y,208,34,34 );
	gfx.PutPixel( 21 + x,23 + y,208,34,34 );
	gfx.PutPixel( 22 + x,23 + y,208,34,34 );
	gfx.PutPixel( 23 + x,23 + y,208,34,34 );
	gfx.PutPixel( 24 + x,23 + y,208,34,34 );
	gfx.PutPixel( 25 + x,23 + y,208,34,34 );
	gfx.PutPixel( 26 + x,23 + y,208,34,34 );
	gfx.PutPixel( 27 + x,23 + y,208,34,34 );
	gfx.PutPixel( 28 + x,23 + y,208,34,34 );
	gfx.PutPixel( 29 + x,23 + y,208,34,34 );
	gfx.PutPixel( 30 + x,23 + y,208,34,34 );
	gfx.PutPixel( 31 + x,23 + y,208,34,34 );
	gfx.PutPixel( 32 + x,23 + y,208,34,34 );
	gfx.PutPixel( 33 + x,23 + y,208,34,34 );
	gfx.PutPixel( 34 + x,23 + y,208,34,34 );
	gfx.PutPixel( 35 + x,23 + y,208,34,34 );
	gfx.PutPixel( 36 + x,23 + y,208,34,34 );
	gfx.PutPixel( 37 + x,23 + y,208,34,34 );
	gfx.PutPixel( 38 + x,23 + y,208,34,34 );
	gfx.PutPixel( 39 + x,23 + y,208,34,34 );
	gfx.PutPixel( 40 + x,23 + y,208,34,34 );
	gfx.PutPixel( 41 + x,23 + y,208,34,34 );
	gfx.PutPixel( 42 + x,23 + y,208,34,34 );
	gfx.PutPixel( 43 + x,23 + y,208,34,34 );
	gfx.PutPixel( 44 + x,23 + y,208,34,34 );
	gfx.PutPixel( 45 + x,23 + y,208,34,34 );
	gfx.PutPixel( 46 + x,23 + y,208,34,34 );
	gfx.PutPixel( 47 + x,23 + y,208,34,34 );
	gfx.PutPixel( 48 + x,23 + y,208,34,34 );
	gfx.PutPixel( 49 + x,23 + y,208,34,34 );
	gfx.PutPixel( 50 + x,23 + y,208,34,34 );
	gfx.PutPixel( 51 + x,23 + y,208,34,34 );
	gfx.PutPixel( 52 + x,23 + y,208,34,34 );
	gfx.PutPixel( 53 + x,23 + y,208,34,34 );
	gfx.PutPixel( 54 + x,23 + y,208,34,34 );
	gfx.PutPixel( 55 + x,23 + y,208,34,34 );
	gfx.PutPixel( 56 + x,23 + y,208,30,30 );
	gfx.PutPixel( 57 + x,23 + y,210,57,57 );
	gfx.PutPixel( 58 + x,23 + y,214,121,121 );
	gfx.PutPixel( 59 + x,23 + y,217,165,165 );
	gfx.PutPixel( 60 + x,23 + y,223,249,249 );
	gfx.PutPixel( 61 + x,23 + y,214,129,129 );
	gfx.PutPixel( 62 + x,23 + y,218,175,175 );
	gfx.PutPixel( 63 + x,23 + y,220,206,206 );
	gfx.PutPixel( 64 + x,23 + y,211,80,80 );
	gfx.PutPixel( 65 + x,23 + y,212,89,89 );
	gfx.PutPixel( 66 + x,23 + y,220,215,215 );
	gfx.PutPixel( 67 + x,23 + y,218,178,178 );
	gfx.PutPixel( 68 + x,23 + y,207,22,22 );
	gfx.PutPixel( 69 + x,23 + y,208,32,32 );
	gfx.PutPixel( 70 + x,23 + y,216,150,150 );
	gfx.PutPixel( 71 + x,23 + y,210,62,62 );
	gfx.PutPixel( 72 + x,23 + y,215,138,138 );
	gfx.PutPixel( 73 + x,23 + y,212,91,91 );
	gfx.PutPixel( 74 + x,23 + y,219,197,197 );
	gfx.PutPixel( 75 + x,23 + y,216,158,158 );
	gfx.PutPixel( 76 + x,23 + y,214,119,119 );
	gfx.PutPixel( 77 + x,23 + y,212,95,95 );
	gfx.PutPixel( 78 + x,23 + y,213,103,103 );
	gfx.PutPixel( 79 + x,23 + y,212,87,87 );
	gfx.PutPixel( 80 + x,23 + y,207,22,22 );
	gfx.PutPixel( 81 + x,23 + y,217,164,164 );
	gfx.PutPixel( 82 + x,23 + y,222,236,236 );
	gfx.PutPixel( 83 + x,23 + y,218,171,171 );
	gfx.PutPixel( 84 + x,23 + y,213,102,102 );
	gfx.PutPixel( 85 + x,23 + y,219,200,200 );
	gfx.PutPixel( 86 + x,23 + y,221,219,219 );
	gfx.PutPixel( 87 + x,23 + y,213,106,106 );
	gfx.PutPixel( 88 + x,23 + y,221,227,227 );
	gfx.PutPixel( 89 + x,23 + y,221,221,221 );
	gfx.PutPixel( 90 + x,23 + y,214,122,122 );
	gfx.PutPixel( 91 + x,23 + y,213,101,101 );
	gfx.PutPixel( 92 + x,23 + y,207,25,25 );
	gfx.PutPixel( 93 + x,23 + y,208,34,34 );
	gfx.PutPixel( 94 + x,23 + y,208,34,34 );
	gfx.PutPixel( 95 + x,23 + y,208,34,34 );
	gfx.PutPixel( 96 + x,23 + y,208,34,34 );
	gfx.PutPixel( 97 + x,23 + y,208,34,34 );
	gfx.PutPixel( 98 + x,23 + y,208,34,34 );
	gfx.PutPixel( 99 + x,23 + y,208,34,34 );
	gfx.PutPixel( 100 + x,23 + y,208,34,34 );
	gfx.PutPixel( 101 + x,23 + y,208,34,34 );
	gfx.PutPixel( 102 + x,23 + y,208,34,34 );
	gfx.PutPixel( 103 + x,23 + y,208,34,34 );
	gfx.PutPixel( 104 + x,23 + y,208,34,34 );
	gfx.PutPixel( 105 + x,23 + y,208,34,34 );
	gfx.PutPixel( 106 + x,23 + y,208,34,34 );
	gfx.PutPixel( 107 + x,23 + y,208,34,34 );
	gfx.PutPixel( 108 + x,23 + y,208,34,34 );
	gfx.PutPixel( 109 + x,23 + y,208,34,34 );
	gfx.PutPixel( 110 + x,23 + y,208,34,34 );
	gfx.PutPixel( 111 + x,23 + y,208,34,34 );
	gfx.PutPixel( 112 + x,23 + y,208,34,34 );
	gfx.PutPixel( 113 + x,23 + y,208,34,34 );
	gfx.PutPixel( 114 + x,23 + y,208,34,34 );
	gfx.PutPixel( 115 + x,23 + y,208,34,34 );
	gfx.PutPixel( 116 + x,23 + y,208,34,34 );
	gfx.PutPixel( 117 + x,23 + y,208,34,34 );
	gfx.PutPixel( 118 + x,23 + y,208,34,34 );
	gfx.PutPixel( 119 + x,23 + y,208,34,34 );
	gfx.PutPixel( 120 + x,23 + y,208,34,34 );
	gfx.PutPixel( 121 + x,23 + y,208,34,34 );
	gfx.PutPixel( 122 + x,23 + y,208,34,34 );
	gfx.PutPixel( 123 + x,23 + y,208,34,34 );
	gfx.PutPixel( 124 + x,23 + y,208,34,34 );
	gfx.PutPixel( 125 + x,23 + y,208,34,34 );
	gfx.PutPixel( 126 + x,23 + y,208,34,34 );
	gfx.PutPixel( 127 + x,23 + y,208,34,34 );
	gfx.PutPixel( 128 + x,23 + y,208,34,34 );
	gfx.PutPixel( 129 + x,23 + y,208,34,34 );
	gfx.PutPixel( 130 + x,23 + y,208,34,34 );
	gfx.PutPixel( 131 + x,23 + y,208,34,34 );
	gfx.PutPixel( 132 + x,23 + y,208,34,34 );
	gfx.PutPixel( 133 + x,23 + y,208,34,34 );
	gfx.PutPixel( 134 + x,23 + y,208,34,34 );
	gfx.PutPixel( 135 + x,23 + y,208,34,34 );
	gfx.PutPixel( 136 + x,23 + y,208,34,34 );
	gfx.PutPixel( 137 + x,23 + y,208,34,34 );
	gfx.PutPixel( 138 + x,23 + y,208,34,34 );
	gfx.PutPixel( 139 + x,23 + y,208,34,34 );
	gfx.PutPixel( 140 + x,23 + y,208,34,34 );
	gfx.PutPixel( 141 + x,23 + y,208,34,34 );
	gfx.PutPixel( 142 + x,23 + y,208,34,34 );
	gfx.PutPixel( 143 + x,23 + y,208,34,34 );
	gfx.PutPixel( 144 + x,23 + y,208,34,34 );
	gfx.PutPixel( 145 + x,23 + y,208,34,34 );
	gfx.PutPixel( 146 + x,23 + y,208,34,34 );
	gfx.PutPixel( 147 + x,23 + y,208,34,34 );
	gfx.PutPixel( 148 + x,23 + y,208,34,34 );
	gfx.PutPixel( 149 + x,23 + y,208,34,34 );
	gfx.PutPixel( 0 + x,24 + y,208,34,34 );
	gfx.PutPixel( 1 + x,24 + y,208,34,34 );
	gfx.PutPixel( 2 + x,24 + y,208,34,34 );
	gfx.PutPixel( 3 + x,24 + y,208,34,34 );
	gfx.PutPixel( 4 + x,24 + y,208,34,34 );
	gfx.PutPixel( 5 + x,24 + y,208,34,34 );
	gfx.PutPixel( 6 + x,24 + y,208,34,34 );
	gfx.PutPixel( 7 + x,24 + y,208,34,34 );
	gfx.PutPixel( 8 + x,24 + y,208,34,34 );
	gfx.PutPixel( 9 + x,24 + y,208,34,34 );
	gfx.PutPixel( 10 + x,24 + y,208,34,34 );
	gfx.PutPixel( 11 + x,24 + y,208,34,34 );
	gfx.PutPixel( 12 + x,24 + y,208,34,34 );
	gfx.PutPixel( 13 + x,24 + y,208,34,34 );
	gfx.PutPixel( 14 + x,24 + y,208,34,34 );
	gfx.PutPixel( 15 + x,24 + y,208,34,34 );
	gfx.PutPixel( 16 + x,24 + y,208,34,34 );
	gfx.PutPixel( 17 + x,24 + y,208,34,34 );
	gfx.PutPixel( 18 + x,24 + y,208,34,34 );
	gfx.PutPixel( 19 + x,24 + y,208,34,34 );
	gfx.PutPixel( 20 + x,24 + y,208,34,34 );
	gfx.PutPixel( 21 + x,24 + y,208,34,34 );
	gfx.PutPixel( 22 + x,24 + y,208,34,34 );
	gfx.PutPixel( 23 + x,24 + y,208,34,34 );
	gfx.PutPixel( 24 + x,24 + y,208,34,34 );
	gfx.PutPixel( 25 + x,24 + y,208,34,34 );
	gfx.PutPixel( 26 + x,24 + y,208,34,34 );
	gfx.PutPixel( 27 + x,24 + y,208,34,34 );
	gfx.PutPixel( 28 + x,24 + y,208,34,34 );
	gfx.PutPixel( 29 + x,24 + y,208,34,34 );
	gfx.PutPixel( 30 + x,24 + y,208,34,34 );
	gfx.PutPixel( 31 + x,24 + y,208,34,34 );
	gfx.PutPixel( 32 + x,24 + y,208,34,34 );
	gfx.PutPixel( 33 + x,24 + y,208,34,34 );
	gfx.PutPixel( 34 + x,24 + y,208,34,34 );
	gfx.PutPixel( 35 + x,24 + y,208,34,34 );
	gfx.PutPixel( 36 + x,24 + y,208,34,34 );
	gfx.PutPixel( 37 + x,24 + y,208,34,34 );
	gfx.PutPixel( 38 + x,24 + y,208,34,34 );
	gfx.PutPixel( 39 + x,24 + y,208,34,34 );
	gfx.PutPixel( 40 + x,24 + y,208,34,34 );
	gfx.PutPixel( 41 + x,24 + y,208,34,34 );
	gfx.PutPixel( 42 + x,24 + y,208,34,34 );
	gfx.PutPixel( 43 + x,24 + y,208,34,34 );
	gfx.PutPixel( 44 + x,24 + y,208,34,34 );
	gfx.PutPixel( 45 + x,24 + y,208,34,34 );
	gfx.PutPixel( 46 + x,24 + y,208,34,34 );
	gfx.PutPixel( 47 + x,24 + y,208,34,34 );
	gfx.PutPixel( 48 + x,24 + y,208,34,34 );
	gfx.PutPixel( 49 + x,24 + y,208,34,34 );
	gfx.PutPixel( 50 + x,24 + y,208,34,34 );
	gfx.PutPixel( 51 + x,24 + y,208,34,34 );
	gfx.PutPixel( 52 + x,24 + y,208,34,34 );
	gfx.PutPixel( 53 + x,24 + y,208,34,34 );
	gfx.PutPixel( 54 + x,24 + y,208,34,34 );
	gfx.PutPixel( 55 + x,24 + y,208,34,34 );
	gfx.PutPixel( 56 + x,24 + y,208,33,33 );
	gfx.PutPixel( 57 + x,24 + y,208,32,32 );
	gfx.PutPixel( 58 + x,24 + y,214,119,119 );
	gfx.PutPixel( 59 + x,24 + y,217,172,172 );
	gfx.PutPixel( 60 + x,24 + y,214,117,117 );
	gfx.PutPixel( 61 + x,24 + y,213,110,110 );
	gfx.PutPixel( 62 + x,24 + y,216,142,142 );
	gfx.PutPixel( 63 + x,24 + y,216,151,151 );
	gfx.PutPixel( 64 + x,24 + y,206,15,15 );
	gfx.PutPixel( 65 + x,24 + y,206,16,16 );
	gfx.PutPixel( 66 + x,24 + y,216,148,148 );
	gfx.PutPixel( 67 + x,24 + y,218,185,185 );
	gfx.PutPixel( 68 + x,24 + y,208,24,24 );
	gfx.PutPixel( 69 + x,24 + y,208,29,29 );
	gfx.PutPixel( 70 + x,24 + y,208,34,34 );
	gfx.PutPixel( 71 + x,24 + y,208,32,32 );
	gfx.PutPixel( 72 + x,24 + y,207,21,21 );
	gfx.PutPixel( 73 + x,24 + y,208,36,36 );
	gfx.PutPixel( 74 + x,24 + y,220,213,213 );
	gfx.PutPixel( 75 + x,24 + y,217,160,160 );
	gfx.PutPixel( 76 + x,24 + y,206,12,12 );
	gfx.PutPixel( 77 + x,24 + y,208,33,33 );
	gfx.PutPixel( 78 + x,24 + y,208,30,30 );
	gfx.PutPixel( 79 + x,24 + y,208,28,28 );
	gfx.PutPixel( 80 + x,24 + y,207,17,17 );
	gfx.PutPixel( 81 + x,24 + y,216,150,150 );
	gfx.PutPixel( 82 + x,24 + y,222,231,231 );
	gfx.PutPixel( 83 + x,24 + y,211,68,68 );
	gfx.PutPixel( 84 + x,24 + y,206,8,8 );
	gfx.PutPixel( 85 + x,24 + y,217,162,162 );
	gfx.PutPixel( 86 + x,24 + y,216,145,145 );
	gfx.PutPixel( 87 + x,24 + y,212,95,95 );
	gfx.PutPixel( 88 + x,24 + y,215,135,135 );
	gfx.PutPixel( 89 + x,24 + y,216,143,143 );
	gfx.PutPixel( 90 + x,24 + y,217,163,163 );
	gfx.PutPixel( 91 + x,24 + y,211,69,69 );
	gfx.PutPixel( 92 + x,24 + y,208,28,28 );
	gfx.PutPixel( 93 + x,24 + y,208,34,34 );
	gfx.PutPixel( 94 + x,24 + y,208,34,34 );
	gfx.PutPixel( 95 + x,24 + y,208,34,34 );
	gfx.PutPixel( 96 + x,24 + y,208,34,34 );
	gfx.PutPixel( 97 + x,24 + y,208,34,34 );
	gfx.PutPixel( 98 + x,24 + y,208,34,34 );
	gfx.PutPixel( 99 + x,24 + y,208,34,34 );
	gfx.PutPixel( 100 + x,24 + y,208,34,34 );
	gfx.PutPixel( 101 + x,24 + y,208,34,34 );
	gfx.PutPixel( 102 + x,24 + y,208,34,34 );
	gfx.PutPixel( 103 + x,24 + y,208,34,34 );
	gfx.PutPixel( 104 + x,24 + y,208,34,34 );
	gfx.PutPixel( 105 + x,24 + y,208,34,34 );
	gfx.PutPixel( 106 + x,24 + y,208,34,34 );
	gfx.PutPixel( 107 + x,24 + y,208,34,34 );
	gfx.PutPixel( 108 + x,24 + y,208,34,34 );
	gfx.PutPixel( 109 + x,24 + y,208,34,34 );
	gfx.PutPixel( 110 + x,24 + y,208,34,34 );
	gfx.PutPixel( 111 + x,24 + y,208,34,34 );
	gfx.PutPixel( 112 + x,24 + y,208,34,34 );
	gfx.PutPixel( 113 + x,24 + y,208,34,34 );
	gfx.PutPixel( 114 + x,24 + y,208,34,34 );
	gfx.PutPixel( 115 + x,24 + y,208,34,34 );
	gfx.PutPixel( 116 + x,24 + y,208,34,34 );
	gfx.PutPixel( 117 + x,24 + y,208,34,34 );
	gfx.PutPixel( 118 + x,24 + y,208,34,34 );
	gfx.PutPixel( 119 + x,24 + y,208,34,34 );
	gfx.PutPixel( 120 + x,24 + y,208,34,34 );
	gfx.PutPixel( 121 + x,24 + y,208,34,34 );
	gfx.PutPixel( 122 + x,24 + y,208,34,34 );
	gfx.PutPixel( 123 + x,24 + y,208,34,34 );
	gfx.PutPixel( 124 + x,24 + y,208,34,34 );
	gfx.PutPixel( 125 + x,24 + y,208,34,34 );
	gfx.PutPixel( 126 + x,24 + y,208,34,34 );
	gfx.PutPixel( 127 + x,24 + y,208,34,34 );
	gfx.PutPixel( 128 + x,24 + y,208,34,34 );
	gfx.PutPixel( 129 + x,24 + y,208,34,34 );
	gfx.PutPixel( 130 + x,24 + y,208,34,34 );
	gfx.PutPixel( 131 + x,24 + y,208,34,34 );
	gfx.PutPixel( 132 + x,24 + y,208,34,34 );
	gfx.PutPixel( 133 + x,24 + y,208,34,34 );
	gfx.PutPixel( 134 + x,24 + y,208,34,34 );
	gfx.PutPixel( 135 + x,24 + y,208,34,34 );
	gfx.PutPixel( 136 + x,24 + y,208,34,34 );
	gfx.PutPixel( 137 + x,24 + y,208,34,34 );
	gfx.PutPixel( 138 + x,24 + y,208,34,34 );
	gfx.PutPixel( 139 + x,24 + y,208,34,34 );
	gfx.PutPixel( 140 + x,24 + y,208,34,34 );
	gfx.PutPixel( 141 + x,24 + y,208,34,34 );
	gfx.PutPixel( 142 + x,24 + y,208,34,34 );
	gfx.PutPixel( 143 + x,24 + y,208,34,34 );
	gfx.PutPixel( 144 + x,24 + y,208,34,34 );
	gfx.PutPixel( 145 + x,24 + y,208,34,34 );
	gfx.PutPixel( 146 + x,24 + y,208,34,34 );
	gfx.PutPixel( 147 + x,24 + y,208,34,34 );
	gfx.PutPixel( 148 + x,24 + y,208,34,34 );
	gfx.PutPixel( 149 + x,24 + y,208,34,34 );
	gfx.PutPixel( 0 + x,25 + y,208,34,34 );
	gfx.PutPixel( 1 + x,25 + y,208,34,34 );
	gfx.PutPixel( 2 + x,25 + y,208,34,34 );
	gfx.PutPixel( 3 + x,25 + y,208,34,34 );
	gfx.PutPixel( 4 + x,25 + y,208,34,34 );
	gfx.PutPixel( 5 + x,25 + y,208,34,34 );
	gfx.PutPixel( 6 + x,25 + y,208,34,34 );
	gfx.PutPixel( 7 + x,25 + y,208,34,34 );
	gfx.PutPixel( 8 + x,25 + y,208,34,34 );
	gfx.PutPixel( 9 + x,25 + y,208,34,34 );
	gfx.PutPixel( 10 + x,25 + y,208,34,34 );
	gfx.PutPixel( 11 + x,25 + y,208,34,34 );
	gfx.PutPixel( 12 + x,25 + y,208,34,34 );
	gfx.PutPixel( 13 + x,25 + y,208,34,34 );
	gfx.PutPixel( 14 + x,25 + y,208,34,34 );
	gfx.PutPixel( 15 + x,25 + y,208,34,34 );
	gfx.PutPixel( 16 + x,25 + y,208,34,34 );
	gfx.PutPixel( 17 + x,25 + y,208,34,34 );
	gfx.PutPixel( 18 + x,25 + y,208,34,34 );
	gfx.PutPixel( 19 + x,25 + y,208,34,34 );
	gfx.PutPixel( 20 + x,25 + y,208,34,34 );
	gfx.PutPixel( 21 + x,25 + y,208,34,34 );
	gfx.PutPixel( 22 + x,25 + y,208,34,34 );
	gfx.PutPixel( 23 + x,25 + y,208,34,34 );
	gfx.PutPixel( 24 + x,25 + y,208,34,34 );
	gfx.PutPixel( 25 + x,25 + y,208,34,34 );
	gfx.PutPixel( 26 + x,25 + y,208,34,34 );
	gfx.PutPixel( 27 + x,25 + y,208,34,34 );
	gfx.PutPixel( 28 + x,25 + y,208,34,34 );
	gfx.PutPixel( 29 + x,25 + y,208,34,34 );
	gfx.PutPixel( 30 + x,25 + y,208,34,34 );
	gfx.PutPixel( 31 + x,25 + y,208,34,34 );
	gfx.PutPixel( 32 + x,25 + y,208,34,34 );
	gfx.PutPixel( 33 + x,25 + y,208,34,34 );
	gfx.PutPixel( 34 + x,25 + y,208,34,34 );
	gfx.PutPixel( 35 + x,25 + y,208,34,34 );
	gfx.PutPixel( 36 + x,25 + y,208,34,34 );
	gfx.PutPixel( 37 + x,25 + y,208,34,34 );
	gfx.PutPixel( 38 + x,25 + y,208,34,34 );
	gfx.PutPixel( 39 + x,25 + y,208,34,34 );
	gfx.PutPixel( 40 + x,25 + y,208,34,34 );
	gfx.PutPixel( 41 + x,25 + y,208,34,34 );
	gfx.PutPixel( 42 + x,25 + y,208,34,34 );
	gfx.PutPixel( 43 + x,25 + y,208,34,34 );
	gfx.PutPixel( 44 + x,25 + y,208,34,34 );
	gfx.PutPixel( 45 + x,25 + y,208,34,34 );
	gfx.PutPixel( 46 + x,25 + y,208,34,34 );
	gfx.PutPixel( 47 + x,25 + y,208,34,34 );
	gfx.PutPixel( 48 + x,25 + y,208,34,34 );
	gfx.PutPixel( 49 + x,25 + y,208,34,34 );
	gfx.PutPixel( 50 + x,25 + y,208,34,34 );
	gfx.PutPixel( 51 + x,25 + y,208,34,34 );
	gfx.PutPixel( 52 + x,25 + y,208,34,34 );
	gfx.PutPixel( 53 + x,25 + y,208,34,34 );
	gfx.PutPixel( 54 + x,25 + y,208,34,34 );
	gfx.PutPixel( 55 + x,25 + y,208,34,34 );
	gfx.PutPixel( 56 + x,25 + y,208,34,34 );
	gfx.PutPixel( 57 + x,25 + y,208,30,30 );
	gfx.PutPixel( 58 + x,25 + y,209,42,42 );
	gfx.PutPixel( 59 + x,25 + y,220,204,204 );
	gfx.PutPixel( 60 + x,25 + y,212,92,92 );
	gfx.PutPixel( 61 + x,25 + y,206,15,15 );
	gfx.PutPixel( 62 + x,25 + y,209,49,49 );
	gfx.PutPixel( 63 + x,25 + y,211,76,76 );
	gfx.PutPixel( 64 + x,25 + y,208,30,30 );
	gfx.PutPixel( 65 + x,25 + y,207,19,19 );
	gfx.PutPixel( 66 + x,25 + y,216,148,148 );
	gfx.PutPixel( 67 + x,25 + y,222,235,235 );
	gfx.PutPixel( 68 + x,25 + y,215,128,128 );
	gfx.PutPixel( 69 + x,25 + y,208,36,36 );
	gfx.PutPixel( 70 + x,25 + y,207,23,23 );
	gfx.PutPixel( 71 + x,25 + y,207,28,28 );
	gfx.PutPixel( 72 + x,25 + y,209,49,49 );
	gfx.PutPixel( 73 + x,25 + y,217,160,160 );
	gfx.PutPixel( 74 + x,25 + y,222,234,234 );
	gfx.PutPixel( 75 + x,25 + y,221,218,218 );
	gfx.PutPixel( 76 + x,25 + y,212,85,85 );
	gfx.PutPixel( 77 + x,25 + y,208,23,23 );
	gfx.PutPixel( 78 + x,25 + y,207,23,23 );
	gfx.PutPixel( 79 + x,25 + y,208,26,26 );
	gfx.PutPixel( 80 + x,25 + y,212,90,90 );
	gfx.PutPixel( 81 + x,25 + y,221,216,216 );
	gfx.PutPixel( 82 + x,25 + y,221,217,217 );
	gfx.PutPixel( 83 + x,25 + y,209,54,54 );
	gfx.PutPixel( 84 + x,25 + y,208,29,29 );
	gfx.PutPixel( 85 + x,25 + y,212,90,90 );
	gfx.PutPixel( 86 + x,25 + y,208,39,39 );
	gfx.PutPixel( 87 + x,25 + y,208,32,32 );
	gfx.PutPixel( 88 + x,25 + y,207,22,22 );
	gfx.PutPixel( 89 + x,25 + y,219,189,189 );
	gfx.PutPixel( 90 + x,25 + y,214,126,126 );
	gfx.PutPixel( 91 + x,25 + y,207,22,22 );
	gfx.PutPixel( 92 + x,25 + y,208,34,34 );
	gfx.PutPixel( 93 + x,25 + y,208,34,34 );
	gfx.PutPixel( 94 + x,25 + y,208,34,34 );
	gfx.PutPixel( 95 + x,25 + y,208,34,34 );
	gfx.PutPixel( 96 + x,25 + y,208,34,34 );
	gfx.PutPixel( 97 + x,25 + y,208,34,34 );
	gfx.PutPixel( 98 + x,25 + y,208,34,34 );
	gfx.PutPixel( 99 + x,25 + y,208,34,34 );
	gfx.PutPixel( 100 + x,25 + y,208,34,34 );
	gfx.PutPixel( 101 + x,25 + y,208,34,34 );
	gfx.PutPixel( 102 + x,25 + y,208,34,34 );
	gfx.PutPixel( 103 + x,25 + y,208,34,34 );
	gfx.PutPixel( 104 + x,25 + y,208,34,34 );
	gfx.PutPixel( 105 + x,25 + y,208,34,34 );
	gfx.PutPixel( 106 + x,25 + y,208,34,34 );
	gfx.PutPixel( 107 + x,25 + y,208,34,34 );
	gfx.PutPixel( 108 + x,25 + y,208,34,34 );
	gfx.PutPixel( 109 + x,25 + y,208,34,34 );
	gfx.PutPixel( 110 + x,25 + y,208,34,34 );
	gfx.PutPixel( 111 + x,25 + y,208,34,34 );
	gfx.PutPixel( 112 + x,25 + y,208,34,34 );
	gfx.PutPixel( 113 + x,25 + y,208,34,34 );
	gfx.PutPixel( 114 + x,25 + y,208,34,34 );
	gfx.PutPixel( 115 + x,25 + y,208,34,34 );
	gfx.PutPixel( 116 + x,25 + y,208,34,34 );
	gfx.PutPixel( 117 + x,25 + y,208,34,34 );
	gfx.PutPixel( 118 + x,25 + y,208,34,34 );
	gfx.PutPixel( 119 + x,25 + y,208,34,34 );
	gfx.PutPixel( 120 + x,25 + y,208,34,34 );
	gfx.PutPixel( 121 + x,25 + y,208,34,34 );
	gfx.PutPixel( 122 + x,25 + y,208,34,34 );
	gfx.PutPixel( 123 + x,25 + y,208,34,34 );
	gfx.PutPixel( 124 + x,25 + y,208,34,34 );
	gfx.PutPixel( 125 + x,25 + y,208,34,34 );
	gfx.PutPixel( 126 + x,25 + y,208,34,34 );
	gfx.PutPixel( 127 + x,25 + y,208,34,34 );
	gfx.PutPixel( 128 + x,25 + y,208,34,34 );
	gfx.PutPixel( 129 + x,25 + y,208,34,34 );
	gfx.PutPixel( 130 + x,25 + y,208,34,34 );
	gfx.PutPixel( 131 + x,25 + y,208,34,34 );
	gfx.PutPixel( 132 + x,25 + y,208,34,34 );
	gfx.PutPixel( 133 + x,25 + y,208,34,34 );
	gfx.PutPixel( 134 + x,25 + y,208,34,34 );
	gfx.PutPixel( 135 + x,25 + y,208,34,34 );
	gfx.PutPixel( 136 + x,25 + y,208,34,34 );
	gfx.PutPixel( 137 + x,25 + y,208,34,34 );
	gfx.PutPixel( 138 + x,25 + y,208,34,34 );
	gfx.PutPixel( 139 + x,25 + y,208,34,34 );
	gfx.PutPixel( 140 + x,25 + y,208,34,34 );
	gfx.PutPixel( 141 + x,25 + y,208,34,34 );
	gfx.PutPixel( 142 + x,25 + y,208,34,34 );
	gfx.PutPixel( 143 + x,25 + y,208,34,34 );
	gfx.PutPixel( 144 + x,25 + y,208,34,34 );
	gfx.PutPixel( 145 + x,25 + y,208,34,34 );
	gfx.PutPixel( 146 + x,25 + y,208,34,34 );
	gfx.PutPixel( 147 + x,25 + y,208,34,34 );
	gfx.PutPixel( 148 + x,25 + y,208,34,34 );
	gfx.PutPixel( 149 + x,25 + y,208,34,34 );
	gfx.PutPixel( 0 + x,26 + y,208,34,34 );
	gfx.PutPixel( 1 + x,26 + y,208,34,34 );
	gfx.PutPixel( 2 + x,26 + y,208,34,34 );
	gfx.PutPixel( 3 + x,26 + y,208,34,34 );
	gfx.PutPixel( 4 + x,26 + y,208,34,34 );
	gfx.PutPixel( 5 + x,26 + y,208,34,34 );
	gfx.PutPixel( 6 + x,26 + y,208,34,34 );
	gfx.PutPixel( 7 + x,26 + y,208,34,34 );
	gfx.PutPixel( 8 + x,26 + y,208,34,34 );
	gfx.PutPixel( 9 + x,26 + y,208,34,34 );
	gfx.PutPixel( 10 + x,26 + y,208,34,34 );
	gfx.PutPixel( 11 + x,26 + y,208,34,34 );
	gfx.PutPixel( 12 + x,26 + y,208,34,34 );
	gfx.PutPixel( 13 + x,26 + y,208,34,34 );
	gfx.PutPixel( 14 + x,26 + y,208,34,34 );
	gfx.PutPixel( 15 + x,26 + y,208,34,34 );
	gfx.PutPixel( 16 + x,26 + y,208,34,34 );
	gfx.PutPixel( 17 + x,26 + y,208,34,34 );
	gfx.PutPixel( 18 + x,26 + y,208,34,34 );
	gfx.PutPixel( 19 + x,26 + y,208,34,34 );
	gfx.PutPixel( 20 + x,26 + y,208,34,34 );
	gfx.PutPixel( 21 + x,26 + y,208,34,34 );
	gfx.PutPixel( 22 + x,26 + y,208,34,34 );
	gfx.PutPixel( 23 + x,26 + y,208,34,34 );
	gfx.PutPixel( 24 + x,26 + y,208,34,34 );
	gfx.PutPixel( 25 + x,26 + y,208,34,34 );
	gfx.PutPixel( 26 + x,26 + y,208,34,34 );
	gfx.PutPixel( 27 + x,26 + y,208,34,34 );
	gfx.PutPixel( 28 + x,26 + y,208,34,34 );
	gfx.PutPixel( 29 + x,26 + y,208,34,34 );
	gfx.PutPixel( 30 + x,26 + y,208,34,34 );
	gfx.PutPixel( 31 + x,26 + y,208,34,34 );
	gfx.PutPixel( 32 + x,26 + y,208,34,34 );
	gfx.PutPixel( 33 + x,26 + y,208,34,34 );
	gfx.PutPixel( 34 + x,26 + y,208,34,34 );
	gfx.PutPixel( 35 + x,26 + y,208,34,34 );
	gfx.PutPixel( 36 + x,26 + y,208,34,34 );
	gfx.PutPixel( 37 + x,26 + y,208,34,34 );
	gfx.PutPixel( 38 + x,26 + y,208,34,34 );
	gfx.PutPixel( 39 + x,26 + y,208,34,34 );
	gfx.PutPixel( 40 + x,26 + y,208,34,34 );
	gfx.PutPixel( 41 + x,26 + y,208,34,34 );
	gfx.PutPixel( 42 + x,26 + y,208,34,34 );
	gfx.PutPixel( 43 + x,26 + y,208,34,34 );
	gfx.PutPixel( 44 + x,26 + y,208,34,34 );
	gfx.PutPixel( 45 + x,26 + y,208,34,34 );
	gfx.PutPixel( 46 + x,26 + y,208,34,34 );
	gfx.PutPixel( 47 + x,26 + y,208,34,34 );
	gfx.PutPixel( 48 + x,26 + y,208,34,34 );
	gfx.PutPixel( 49 + x,26 + y,208,34,34 );
	gfx.PutPixel( 50 + x,26 + y,208,34,34 );
	gfx.PutPixel( 51 + x,26 + y,208,34,34 );
	gfx.PutPixel( 52 + x,26 + y,208,34,34 );
	gfx.PutPixel( 53 + x,26 + y,208,34,34 );
	gfx.PutPixel( 54 + x,26 + y,208,34,34 );
	gfx.PutPixel( 55 + x,26 + y,208,34,34 );
	gfx.PutPixel( 56 + x,26 + y,208,34,34 );
	gfx.PutPixel( 57 + x,26 + y,208,34,34 );
	gfx.PutPixel( 58 + x,26 + y,207,23,23 );
	gfx.PutPixel( 59 + x,26 + y,216,146,146 );
	gfx.PutPixel( 60 + x,26 + y,221,215,215 );
	gfx.PutPixel( 61 + x,26 + y,210,68,68 );
	gfx.PutPixel( 62 + x,26 + y,207,18,18 );
	gfx.PutPixel( 63 + x,26 + y,207,16,16 );
	gfx.PutPixel( 64 + x,26 + y,208,23,23 );
	gfx.PutPixel( 65 + x,26 + y,212,86,86 );
	gfx.PutPixel( 66 + x,26 + y,221,221,221 );
	gfx.PutPixel( 67 + x,26 + y,222,234,234 );
	gfx.PutPixel( 68 + x,26 + y,222,238,238 );
	gfx.PutPixel( 69 + x,26 + y,220,199,199 );
	gfx.PutPixel( 70 + x,26 + y,217,160,160 );
	gfx.PutPixel( 71 + x,26 + y,218,172,172 );
	gfx.PutPixel( 72 + x,26 + y,220,209,209 );
	gfx.PutPixel( 73 + x,26 + y,222,232,232 );
	gfx.PutPixel( 74 + x,26 + y,220,205,205 );
	gfx.PutPixel( 75 + x,26 + y,221,220,220 );
	gfx.PutPixel( 76 + x,26 + y,221,219,219 );
	gfx.PutPixel( 77 + x,26 + y,217,167,167 );
	gfx.PutPixel( 78 + x,26 + y,216,146,146 );
	gfx.PutPixel( 79 + x,26 + y,218,174,174 );
	gfx.PutPixel( 80 + x,26 + y,222,231,231 );
	gfx.PutPixel( 81 + x,26 + y,222,234,234 );
	gfx.PutPixel( 82 + x,26 + y,222,237,237 );
	gfx.PutPixel( 83 + x,26 + y,214,129,129 );
	gfx.PutPixel( 84 + x,26 + y,207,25,25 );
	gfx.PutPixel( 85 + x,26 + y,207,16,16 );
	gfx.PutPixel( 86 + x,26 + y,207,21,21 );
	gfx.PutPixel( 87 + x,26 + y,207,19,19 );
	gfx.PutPixel( 88 + x,26 + y,213,117,117 );
	gfx.PutPixel( 89 + x,26 + y,220,209,209 );
	gfx.PutPixel( 90 + x,26 + y,209,44,44 );
	gfx.PutPixel( 91 + x,26 + y,208,30,30 );
	gfx.PutPixel( 92 + x,26 + y,208,34,34 );
	gfx.PutPixel( 93 + x,26 + y,208,34,34 );
	gfx.PutPixel( 94 + x,26 + y,208,34,34 );
	gfx.PutPixel( 95 + x,26 + y,208,34,34 );
	gfx.PutPixel( 96 + x,26 + y,208,34,34 );
	gfx.PutPixel( 97 + x,26 + y,208,34,34 );
	gfx.PutPixel( 98 + x,26 + y,208,34,34 );
	gfx.PutPixel( 99 + x,26 + y,208,34,34 );
	gfx.PutPixel( 100 + x,26 + y,208,34,34 );
	gfx.PutPixel( 101 + x,26 + y,208,34,34 );
	gfx.PutPixel( 102 + x,26 + y,208,34,34 );
	gfx.PutPixel( 103 + x,26 + y,208,34,34 );
	gfx.PutPixel( 104 + x,26 + y,208,34,34 );
	gfx.PutPixel( 105 + x,26 + y,208,34,34 );
	gfx.PutPixel( 106 + x,26 + y,208,34,34 );
	gfx.PutPixel( 107 + x,26 + y,208,34,34 );
	gfx.PutPixel( 108 + x,26 + y,208,34,34 );
	gfx.PutPixel( 109 + x,26 + y,208,34,34 );
	gfx.PutPixel( 110 + x,26 + y,208,34,34 );
	gfx.PutPixel( 111 + x,26 + y,208,34,34 );
	gfx.PutPixel( 112 + x,26 + y,208,34,34 );
	gfx.PutPixel( 113 + x,26 + y,208,34,34 );
	gfx.PutPixel( 114 + x,26 + y,208,34,34 );
	gfx.PutPixel( 115 + x,26 + y,208,34,34 );
	gfx.PutPixel( 116 + x,26 + y,208,34,34 );
	gfx.PutPixel( 117 + x,26 + y,208,34,34 );
	gfx.PutPixel( 118 + x,26 + y,208,34,34 );
	gfx.PutPixel( 119 + x,26 + y,208,34,34 );
	gfx.PutPixel( 120 + x,26 + y,208,34,34 );
	gfx.PutPixel( 121 + x,26 + y,208,34,34 );
	gfx.PutPixel( 122 + x,26 + y,208,34,34 );
	gfx.PutPixel( 123 + x,26 + y,208,34,34 );
	gfx.PutPixel( 124 + x,26 + y,208,34,34 );
	gfx.PutPixel( 125 + x,26 + y,208,34,34 );
	gfx.PutPixel( 126 + x,26 + y,208,34,34 );
	gfx.PutPixel( 127 + x,26 + y,208,34,34 );
	gfx.PutPixel( 128 + x,26 + y,208,34,34 );
	gfx.PutPixel( 129 + x,26 + y,208,34,34 );
	gfx.PutPixel( 130 + x,26 + y,208,34,34 );
	gfx.PutPixel( 131 + x,26 + y,208,34,34 );
	gfx.PutPixel( 132 + x,26 + y,208,34,34 );
	gfx.PutPixel( 133 + x,26 + y,208,34,34 );
	gfx.PutPixel( 134 + x,26 + y,208,34,34 );
	gfx.PutPixel( 135 + x,26 + y,208,34,34 );
	gfx.PutPixel( 136 + x,26 + y,208,34,34 );
	gfx.PutPixel( 137 + x,26 + y,208,34,34 );
	gfx.PutPixel( 138 + x,26 + y,208,34,34 );
	gfx.PutPixel( 139 + x,26 + y,208,34,34 );
	gfx.PutPixel( 140 + x,26 + y,208,34,34 );
	gfx.PutPixel( 141 + x,26 + y,208,34,34 );
	gfx.PutPixel( 142 + x,26 + y,208,34,34 );
	gfx.PutPixel( 143 + x,26 + y,208,34,34 );
	gfx.PutPixel( 144 + x,26 + y,208,34,34 );
	gfx.PutPixel( 145 + x,26 + y,208,34,34 );
	gfx.PutPixel( 146 + x,26 + y,208,34,34 );
	gfx.PutPixel( 147 + x,26 + y,208,34,34 );
	gfx.PutPixel( 148 + x,26 + y,208,34,34 );
	gfx.PutPixel( 149 + x,26 + y,208,34,34 );
	gfx.PutPixel( 0 + x,27 + y,208,34,34 );
	gfx.PutPixel( 1 + x,27 + y,208,34,34 );
	gfx.PutPixel( 2 + x,27 + y,208,34,34 );
	gfx.PutPixel( 3 + x,27 + y,208,34,34 );
	gfx.PutPixel( 4 + x,27 + y,208,34,34 );
	gfx.PutPixel( 5 + x,27 + y,208,34,34 );
	gfx.PutPixel( 6 + x,27 + y,208,34,34 );
	gfx.PutPixel( 7 + x,27 + y,208,34,34 );
	gfx.PutPixel( 8 + x,27 + y,208,34,34 );
	gfx.PutPixel( 9 + x,27 + y,208,34,34 );
	gfx.PutPixel( 10 + x,27 + y,208,34,34 );
	gfx.PutPixel( 11 + x,27 + y,208,34,34 );
	gfx.PutPixel( 12 + x,27 + y,208,34,34 );
	gfx.PutPixel( 13 + x,27 + y,208,34,34 );
	gfx.PutPixel( 14 + x,27 + y,208,34,34 );
	gfx.PutPixel( 15 + x,27 + y,208,34,34 );
	gfx.PutPixel( 16 + x,27 + y,208,34,34 );
	gfx.PutPixel( 17 + x,27 + y,208,34,34 );
	gfx.PutPixel( 18 + x,27 + y,208,34,34 );
	gfx.PutPixel( 19 + x,27 + y,208,34,34 );
	gfx.PutPixel( 20 + x,27 + y,208,34,34 );
	gfx.PutPixel( 21 + x,27 + y,208,34,34 );
	gfx.PutPixel( 22 + x,27 + y,208,34,34 );
	gfx.PutPixel( 23 + x,27 + y,208,34,34 );
	gfx.PutPixel( 24 + x,27 + y,208,34,34 );
	gfx.PutPixel( 25 + x,27 + y,208,34,34 );
	gfx.PutPixel( 26 + x,27 + y,208,34,34 );
	gfx.PutPixel( 27 + x,27 + y,208,34,34 );
	gfx.PutPixel( 28 + x,27 + y,208,34,34 );
	gfx.PutPixel( 29 + x,27 + y,208,34,34 );
	gfx.PutPixel( 30 + x,27 + y,208,34,34 );
	gfx.PutPixel( 31 + x,27 + y,208,34,34 );
	gfx.PutPixel( 32 + x,27 + y,208,34,34 );
	gfx.PutPixel( 33 + x,27 + y,208,34,34 );
	gfx.PutPixel( 34 + x,27 + y,208,34,34 );
	gfx.PutPixel( 35 + x,27 + y,208,34,34 );
	gfx.PutPixel( 36 + x,27 + y,208,34,34 );
	gfx.PutPixel( 37 + x,27 + y,208,34,34 );
	gfx.PutPixel( 38 + x,27 + y,208,34,34 );
	gfx.PutPixel( 39 + x,27 + y,208,34,34 );
	gfx.PutPixel( 40 + x,27 + y,208,34,34 );
	gfx.PutPixel( 41 + x,27 + y,208,34,34 );
	gfx.PutPixel( 42 + x,27 + y,208,34,34 );
	gfx.PutPixel( 43 + x,27 + y,208,34,34 );
	gfx.PutPixel( 44 + x,27 + y,208,34,34 );
	gfx.PutPixel( 45 + x,27 + y,208,34,34 );
	gfx.PutPixel( 46 + x,27 + y,208,34,34 );
	gfx.PutPixel( 47 + x,27 + y,208,34,34 );
	gfx.PutPixel( 48 + x,27 + y,208,34,34 );
	gfx.PutPixel( 49 + x,27 + y,208,34,34 );
	gfx.PutPixel( 50 + x,27 + y,208,34,34 );
	gfx.PutPixel( 51 + x,27 + y,208,34,34 );
	gfx.PutPixel( 52 + x,27 + y,208,34,34 );
	gfx.PutPixel( 53 + x,27 + y,208,34,34 );
	gfx.PutPixel( 54 + x,27 + y,208,34,34 );
	gfx.PutPixel( 55 + x,27 + y,208,34,34 );
	gfx.PutPixel( 56 + x,27 + y,208,34,34 );
	gfx.PutPixel( 57 + x,27 + y,208,34,34 );
	gfx.PutPixel( 58 + x,27 + y,207,25,25 );
	gfx.PutPixel( 59 + x,27 + y,211,83,83 );
	gfx.PutPixel( 60 + x,27 + y,222,231,231 );
	gfx.PutPixel( 61 + x,27 + y,220,214,214 );
	gfx.PutPixel( 62 + x,27 + y,216,151,151 );
	gfx.PutPixel( 63 + x,27 + y,215,133,133 );
	gfx.PutPixel( 64 + x,27 + y,217,160,160 );
	gfx.PutPixel( 65 + x,27 + y,221,224,224 );
	gfx.PutPixel( 66 + x,27 + y,218,183,183 );
	gfx.PutPixel( 67 + x,27 + y,213,101,101 );
	gfx.PutPixel( 68 + x,27 + y,213,103,103 );
	gfx.PutPixel( 69 + x,27 + y,219,199,199 );
	gfx.PutPixel( 70 + x,27 + y,222,231,231 );
	gfx.PutPixel( 71 + x,27 + y,213,104,104 );
	gfx.PutPixel( 72 + x,27 + y,219,188,188 );
	gfx.PutPixel( 73 + x,27 + y,221,224,224 );
	gfx.PutPixel( 74 + x,27 + y,210,70,70 );
	gfx.PutPixel( 75 + x,27 + y,215,130,130 );
	gfx.PutPixel( 76 + x,27 + y,222,237,237 );
	gfx.PutPixel( 77 + x,27 + y,214,120,120 );
	gfx.PutPixel( 78 + x,27 + y,217,170,170 );
	gfx.PutPixel( 79 + x,27 + y,222,235,235 );
	gfx.PutPixel( 80 + x,27 + y,216,141,141 );
	gfx.PutPixel( 81 + x,27 + y,212,93,93 );
	gfx.PutPixel( 82 + x,27 + y,215,141,141 );
	gfx.PutPixel( 83 + x,27 + y,221,222,222 );
	gfx.PutPixel( 84 + x,27 + y,218,174,174 );
	gfx.PutPixel( 85 + x,27 + y,214,121,121 );
	gfx.PutPixel( 86 + x,27 + y,213,109,109 );
	gfx.PutPixel( 87 + x,27 + y,216,152,152 );
	gfx.PutPixel( 88 + x,27 + y,222,231,231 );
	gfx.PutPixel( 89 + x,27 + y,215,131,131 );
	gfx.PutPixel( 90 + x,27 + y,207,23,23 );
	gfx.PutPixel( 91 + x,27 + y,208,34,34 );
	gfx.PutPixel( 92 + x,27 + y,208,34,34 );
	gfx.PutPixel( 93 + x,27 + y,208,34,34 );
	gfx.PutPixel( 94 + x,27 + y,208,34,34 );
	gfx.PutPixel( 95 + x,27 + y,208,34,34 );
	gfx.PutPixel( 96 + x,27 + y,208,34,34 );
	gfx.PutPixel( 97 + x,27 + y,208,34,34 );
	gfx.PutPixel( 98 + x,27 + y,208,34,34 );
	gfx.PutPixel( 99 + x,27 + y,208,34,34 );
	gfx.PutPixel( 100 + x,27 + y,208,34,34 );
	gfx.PutPixel( 101 + x,27 + y,208,34,34 );
	gfx.PutPixel( 102 + x,27 + y,208,34,34 );
	gfx.PutPixel( 103 + x,27 + y,208,34,34 );
	gfx.PutPixel( 104 + x,27 + y,208,34,34 );
	gfx.PutPixel( 105 + x,27 + y,208,34,34 );
	gfx.PutPixel( 106 + x,27 + y,208,34,34 );
	gfx.PutPixel( 107 + x,27 + y,208,34,34 );
	gfx.PutPixel( 108 + x,27 + y,208,34,34 );
	gfx.PutPixel( 109 + x,27 + y,208,34,34 );
	gfx.PutPixel( 110 + x,27 + y,208,34,34 );
	gfx.PutPixel( 111 + x,27 + y,208,34,34 );
	gfx.PutPixel( 112 + x,27 + y,208,34,34 );
	gfx.PutPixel( 113 + x,27 + y,208,34,34 );
	gfx.PutPixel( 114 + x,27 + y,208,34,34 );
	gfx.PutPixel( 115 + x,27 + y,208,34,34 );
	gfx.PutPixel( 116 + x,27 + y,208,34,34 );
	gfx.PutPixel( 117 + x,27 + y,208,34,34 );
	gfx.PutPixel( 118 + x,27 + y,208,34,34 );
	gfx.PutPixel( 119 + x,27 + y,208,34,34 );
	gfx.PutPixel( 120 + x,27 + y,208,34,34 );
	gfx.PutPixel( 121 + x,27 + y,208,34,34 );
	gfx.PutPixel( 122 + x,27 + y,208,34,34 );
	gfx.PutPixel( 123 + x,27 + y,208,34,34 );
	gfx.PutPixel( 124 + x,27 + y,208,34,34 );
	gfx.PutPixel( 125 + x,27 + y,208,34,34 );
	gfx.PutPixel( 126 + x,27 + y,208,34,34 );
	gfx.PutPixel( 127 + x,27 + y,208,34,34 );
	gfx.PutPixel( 128 + x,27 + y,208,34,34 );
	gfx.PutPixel( 129 + x,27 + y,208,34,34 );
	gfx.PutPixel( 130 + x,27 + y,208,34,34 );
	gfx.PutPixel( 131 + x,27 + y,208,34,34 );
	gfx.PutPixel( 132 + x,27 + y,208,34,34 );
	gfx.PutPixel( 133 + x,27 + y,208,34,34 );
	gfx.PutPixel( 134 + x,27 + y,208,34,34 );
	gfx.PutPixel( 135 + x,27 + y,208,34,34 );
	gfx.PutPixel( 136 + x,27 + y,208,34,34 );
	gfx.PutPixel( 137 + x,27 + y,208,34,34 );
	gfx.PutPixel( 138 + x,27 + y,208,34,34 );
	gfx.PutPixel( 139 + x,27 + y,208,34,34 );
	gfx.PutPixel( 140 + x,27 + y,208,34,34 );
	gfx.PutPixel( 141 + x,27 + y,208,34,34 );
	gfx.PutPixel( 142 + x,27 + y,208,34,34 );
	gfx.PutPixel( 143 + x,27 + y,208,34,34 );
	gfx.PutPixel( 144 + x,27 + y,208,34,34 );
	gfx.PutPixel( 145 + x,27 + y,208,34,34 );
	gfx.PutPixel( 146 + x,27 + y,208,34,34 );
	gfx.PutPixel( 147 + x,27 + y,208,34,34 );
	gfx.PutPixel( 148 + x,27 + y,208,34,34 );
	gfx.PutPixel( 149 + x,27 + y,208,34,34 );
	gfx.PutPixel( 0 + x,28 + y,208,34,34 );
	gfx.PutPixel( 1 + x,28 + y,208,34,34 );
	gfx.PutPixel( 2 + x,28 + y,208,34,34 );
	gfx.PutPixel( 3 + x,28 + y,208,34,34 );
	gfx.PutPixel( 4 + x,28 + y,208,34,34 );
	gfx.PutPixel( 5 + x,28 + y,208,34,34 );
	gfx.PutPixel( 6 + x,28 + y,208,34,34 );
	gfx.PutPixel( 7 + x,28 + y,208,34,34 );
	gfx.PutPixel( 8 + x,28 + y,208,34,34 );
	gfx.PutPixel( 9 + x,28 + y,208,34,34 );
	gfx.PutPixel( 10 + x,28 + y,208,34,34 );
	gfx.PutPixel( 11 + x,28 + y,208,34,34 );
	gfx.PutPixel( 12 + x,28 + y,208,34,34 );
	gfx.PutPixel( 13 + x,28 + y,208,34,34 );
	gfx.PutPixel( 14 + x,28 + y,208,34,34 );
	gfx.PutPixel( 15 + x,28 + y,208,34,34 );
	gfx.PutPixel( 16 + x,28 + y,208,34,34 );
	gfx.PutPixel( 17 + x,28 + y,208,34,34 );
	gfx.PutPixel( 18 + x,28 + y,208,34,34 );
	gfx.PutPixel( 19 + x,28 + y,208,34,34 );
	gfx.PutPixel( 20 + x,28 + y,208,34,34 );
	gfx.PutPixel( 21 + x,28 + y,208,34,34 );
	gfx.PutPixel( 22 + x,28 + y,208,34,34 );
	gfx.PutPixel( 23 + x,28 + y,208,34,34 );
	gfx.PutPixel( 24 + x,28 + y,208,34,34 );
	gfx.PutPixel( 25 + x,28 + y,208,34,34 );
	gfx.PutPixel( 26 + x,28 + y,208,34,34 );
	gfx.PutPixel( 27 + x,28 + y,208,34,34 );
	gfx.PutPixel( 28 + x,28 + y,208,34,34 );
	gfx.PutPixel( 29 + x,28 + y,208,34,34 );
	gfx.PutPixel( 30 + x,28 + y,208,34,34 );
	gfx.PutPixel( 31 + x,28 + y,208,34,34 );
	gfx.PutPixel( 32 + x,28 + y,208,34,34 );
	gfx.PutPixel( 33 + x,28 + y,208,34,34 );
	gfx.PutPixel( 34 + x,28 + y,208,34,34 );
	gfx.PutPixel( 35 + x,28 + y,208,34,34 );
	gfx.PutPixel( 36 + x,28 + y,208,34,34 );
	gfx.PutPixel( 37 + x,28 + y,208,34,34 );
	gfx.PutPixel( 38 + x,28 + y,208,34,34 );
	gfx.PutPixel( 39 + x,28 + y,208,34,34 );
	gfx.PutPixel( 40 + x,28 + y,208,34,34 );
	gfx.PutPixel( 41 + x,28 + y,208,34,34 );
	gfx.PutPixel( 42 + x,28 + y,208,34,34 );
	gfx.PutPixel( 43 + x,28 + y,208,34,34 );
	gfx.PutPixel( 44 + x,28 + y,208,34,34 );
	gfx.PutPixel( 45 + x,28 + y,208,34,34 );
	gfx.PutPixel( 46 + x,28 + y,208,34,34 );
	gfx.PutPixel( 47 + x,28 + y,208,34,34 );
	gfx.PutPixel( 48 + x,28 + y,208,34,34 );
	gfx.PutPixel( 49 + x,28 + y,208,34,34 );
	gfx.PutPixel( 50 + x,28 + y,208,34,34 );
	gfx.PutPixel( 51 + x,28 + y,208,34,34 );
	gfx.PutPixel( 52 + x,28 + y,208,34,34 );
	gfx.PutPixel( 53 + x,28 + y,208,34,34 );
	gfx.PutPixel( 54 + x,28 + y,208,34,34 );
	gfx.PutPixel( 55 + x,28 + y,208,34,34 );
	gfx.PutPixel( 56 + x,28 + y,208,34,34 );
	gfx.PutPixel( 57 + x,28 + y,208,34,34 );
	gfx.PutPixel( 58 + x,28 + y,208,27,27 );
	gfx.PutPixel( 59 + x,28 + y,210,66,66 );
	gfx.PutPixel( 60 + x,28 + y,221,225,225 );
	gfx.PutPixel( 61 + x,28 + y,222,231,231 );
	gfx.PutPixel( 62 + x,28 + y,221,212,212 );
	gfx.PutPixel( 63 + x,28 + y,217,163,163 );
	gfx.PutPixel( 64 + x,28 + y,222,233,233 );
	gfx.PutPixel( 65 + x,28 + y,220,204,204 );
	gfx.PutPixel( 66 + x,28 + y,208,41,41 );
	gfx.PutPixel( 67 + x,28 + y,207,19,19 );
	gfx.PutPixel( 68 + x,28 + y,206,10,10 );
	gfx.PutPixel( 69 + x,28 + y,212,89,89 );
	gfx.PutPixel( 70 + x,28 + y,222,231,231 );
	gfx.PutPixel( 71 + x,28 + y,216,147,147 );
	gfx.PutPixel( 72 + x,28 + y,219,196,196 );
	gfx.PutPixel( 73 + x,28 + y,221,218,218 );
	gfx.PutPixel( 74 + x,28 + y,209,50,50 );
	gfx.PutPixel( 75 + x,28 + y,213,108,108 );
	gfx.PutPixel( 76 + x,28 + y,222,232,232 );
	gfx.PutPixel( 77 + x,28 + y,216,144,144 );
	gfx.PutPixel( 78 + x,28 + y,219,195,195 );
	gfx.PutPixel( 79 + x,28 + y,218,177,177 );
	gfx.PutPixel( 80 + x,28 + y,207,16,16 );
	gfx.PutPixel( 81 + x,28 + y,207,21,21 );
	gfx.PutPixel( 82 + x,28 + y,207,14,14 );
	gfx.PutPixel( 83 + x,28 + y,215,131,131 );
	gfx.PutPixel( 84 + x,28 + y,222,242,242 );
	gfx.PutPixel( 85 + x,28 + y,216,152,152 );
	gfx.PutPixel( 86 + x,28 + y,219,193,193 );
	gfx.PutPixel( 87 + x,28 + y,222,237,237 );
	gfx.PutPixel( 88 + x,28 + y,222,238,238 );
	gfx.PutPixel( 89 + x,28 + y,212,92,92 );
	gfx.PutPixel( 90 + x,28 + y,207,24,24 );
	gfx.PutPixel( 91 + x,28 + y,208,34,34 );
	gfx.PutPixel( 92 + x,28 + y,208,34,34 );
	gfx.PutPixel( 93 + x,28 + y,208,34,34 );
	gfx.PutPixel( 94 + x,28 + y,208,34,34 );
	gfx.PutPixel( 95 + x,28 + y,208,34,34 );
	gfx.PutPixel( 96 + x,28 + y,208,34,34 );
	gfx.PutPixel( 97 + x,28 + y,208,34,34 );
	gfx.PutPixel( 98 + x,28 + y,208,34,34 );
	gfx.PutPixel( 99 + x,28 + y,208,34,34 );
	gfx.PutPixel( 100 + x,28 + y,208,34,34 );
	gfx.PutPixel( 101 + x,28 + y,208,34,34 );
	gfx.PutPixel( 102 + x,28 + y,208,34,34 );
	gfx.PutPixel( 103 + x,28 + y,208,34,34 );
	gfx.PutPixel( 104 + x,28 + y,208,34,34 );
	gfx.PutPixel( 105 + x,28 + y,208,34,34 );
	gfx.PutPixel( 106 + x,28 + y,208,34,34 );
	gfx.PutPixel( 107 + x,28 + y,208,34,34 );
	gfx.PutPixel( 108 + x,28 + y,208,34,34 );
	gfx.PutPixel( 109 + x,28 + y,208,34,34 );
	gfx.PutPixel( 110 + x,28 + y,208,34,34 );
	gfx.PutPixel( 111 + x,28 + y,208,34,34 );
	gfx.PutPixel( 112 + x,28 + y,208,34,34 );
	gfx.PutPixel( 113 + x,28 + y,208,34,34 );
	gfx.PutPixel( 114 + x,28 + y,208,34,34 );
	gfx.PutPixel( 115 + x,28 + y,208,34,34 );
	gfx.PutPixel( 116 + x,28 + y,208,34,34 );
	gfx.PutPixel( 117 + x,28 + y,208,34,34 );
	gfx.PutPixel( 118 + x,28 + y,208,34,34 );
	gfx.PutPixel( 119 + x,28 + y,208,34,34 );
	gfx.PutPixel( 120 + x,28 + y,208,34,34 );
	gfx.PutPixel( 121 + x,28 + y,208,34,34 );
	gfx.PutPixel( 122 + x,28 + y,208,34,34 );
	gfx.PutPixel( 123 + x,28 + y,208,34,34 );
	gfx.PutPixel( 124 + x,28 + y,208,34,34 );
	gfx.PutPixel( 125 + x,28 + y,208,34,34 );
	gfx.PutPixel( 126 + x,28 + y,208,34,34 );
	gfx.PutPixel( 127 + x,28 + y,208,34,34 );
	gfx.PutPixel( 128 + x,28 + y,208,34,34 );
	gfx.PutPixel( 129 + x,28 + y,208,34,34 );
	gfx.PutPixel( 130 + x,28 + y,208,34,34 );
	gfx.PutPixel( 131 + x,28 + y,208,34,34 );
	gfx.PutPixel( 132 + x,28 + y,208,34,34 );
	gfx.PutPixel( 133 + x,28 + y,208,34,34 );
	gfx.PutPixel( 134 + x,28 + y,208,34,34 );
	gfx.PutPixel( 135 + x,28 + y,208,34,34 );
	gfx.PutPixel( 136 + x,28 + y,208,34,34 );
	gfx.PutPixel( 137 + x,28 + y,208,34,34 );
	gfx.PutPixel( 138 + x,28 + y,208,34,34 );
	gfx.PutPixel( 139 + x,28 + y,208,34,34 );
	gfx.PutPixel( 140 + x,28 + y,208,34,34 );
	gfx.PutPixel( 141 + x,28 + y,208,34,34 );
	gfx.PutPixel( 142 + x,28 + y,208,34,34 );
	gfx.PutPixel( 143 + x,28 + y,208,34,34 );
	gfx.PutPixel( 144 + x,28 + y,208,34,34 );
	gfx.PutPixel( 145 + x,28 + y,208,34,34 );
	gfx.PutPixel( 146 + x,28 + y,208,34,34 );
	gfx.PutPixel( 147 + x,28 + y,208,34,34 );
	gfx.PutPixel( 148 + x,28 + y,208,34,34 );
	gfx.PutPixel( 149 + x,28 + y,208,34,34 );
	gfx.PutPixel( 0 + x,29 + y,208,34,34 );
	gfx.PutPixel( 1 + x,29 + y,208,34,34 );
	gfx.PutPixel( 2 + x,29 + y,208,34,34 );
	gfx.PutPixel( 3 + x,29 + y,208,34,34 );
	gfx.PutPixel( 4 + x,29 + y,208,34,34 );
	gfx.PutPixel( 5 + x,29 + y,208,34,34 );
	gfx.PutPixel( 6 + x,29 + y,208,34,34 );
	gfx.PutPixel( 7 + x,29 + y,208,34,34 );
	gfx.PutPixel( 8 + x,29 + y,208,34,34 );
	gfx.PutPixel( 9 + x,29 + y,208,34,34 );
	gfx.PutPixel( 10 + x,29 + y,208,34,34 );
	gfx.PutPixel( 11 + x,29 + y,208,34,34 );
	gfx.PutPixel( 12 + x,29 + y,208,34,34 );
	gfx.PutPixel( 13 + x,29 + y,208,34,34 );
	gfx.PutPixel( 14 + x,29 + y,208,34,34 );
	gfx.PutPixel( 15 + x,29 + y,208,34,34 );
	gfx.PutPixel( 16 + x,29 + y,208,34,34 );
	gfx.PutPixel( 17 + x,29 + y,208,34,34 );
	gfx.PutPixel( 18 + x,29 + y,208,34,34 );
	gfx.PutPixel( 19 + x,29 + y,208,34,34 );
	gfx.PutPixel( 20 + x,29 + y,208,34,34 );
	gfx.PutPixel( 21 + x,29 + y,208,34,34 );
	gfx.PutPixel( 22 + x,29 + y,208,34,34 );
	gfx.PutPixel( 23 + x,29 + y,208,34,34 );
	gfx.PutPixel( 24 + x,29 + y,208,34,34 );
	gfx.PutPixel( 25 + x,29 + y,208,34,34 );
	gfx.PutPixel( 26 + x,29 + y,208,34,34 );
	gfx.PutPixel( 27 + x,29 + y,208,34,34 );
	gfx.PutPixel( 28 + x,29 + y,208,34,34 );
	gfx.PutPixel( 29 + x,29 + y,208,34,34 );
	gfx.PutPixel( 30 + x,29 + y,208,34,34 );
	gfx.PutPixel( 31 + x,29 + y,208,34,34 );
	gfx.PutPixel( 32 + x,29 + y,208,34,34 );
	gfx.PutPixel( 33 + x,29 + y,208,34,34 );
	gfx.PutPixel( 34 + x,29 + y,208,34,34 );
	gfx.PutPixel( 35 + x,29 + y,208,34,34 );
	gfx.PutPixel( 36 + x,29 + y,208,34,34 );
	gfx.PutPixel( 37 + x,29 + y,208,34,34 );
	gfx.PutPixel( 38 + x,29 + y,208,34,34 );
	gfx.PutPixel( 39 + x,29 + y,208,34,34 );
	gfx.PutPixel( 40 + x,29 + y,208,34,34 );
	gfx.PutPixel( 41 + x,29 + y,208,34,34 );
	gfx.PutPixel( 42 + x,29 + y,208,34,34 );
	gfx.PutPixel( 43 + x,29 + y,208,34,34 );
	gfx.PutPixel( 44 + x,29 + y,208,34,34 );
	gfx.PutPixel( 45 + x,29 + y,208,34,34 );
	gfx.PutPixel( 46 + x,29 + y,208,34,34 );
	gfx.PutPixel( 47 + x,29 + y,208,34,34 );
	gfx.PutPixel( 48 + x,29 + y,208,34,34 );
	gfx.PutPixel( 49 + x,29 + y,208,34,34 );
	gfx.PutPixel( 50 + x,29 + y,208,34,34 );
	gfx.PutPixel( 51 + x,29 + y,208,34,34 );
	gfx.PutPixel( 52 + x,29 + y,208,34,34 );
	gfx.PutPixel( 53 + x,29 + y,208,34,34 );
	gfx.PutPixel( 54 + x,29 + y,208,34,34 );
	gfx.PutPixel( 55 + x,29 + y,208,34,34 );
	gfx.PutPixel( 56 + x,29 + y,208,34,34 );
	gfx.PutPixel( 57 + x,29 + y,208,34,34 );
	gfx.PutPixel( 58 + x,29 + y,207,25,25 );
	gfx.PutPixel( 59 + x,29 + y,212,87,87 );
	gfx.PutPixel( 60 + x,29 + y,218,176,176 );
	gfx.PutPixel( 61 + x,29 + y,221,213,213 );
	gfx.PutPixel( 62 + x,29 + y,219,194,194 );
	gfx.PutPixel( 63 + x,29 + y,213,104,104 );
	gfx.PutPixel( 64 + x,29 + y,221,220,220 );
	gfx.PutPixel( 65 + x,29 + y,220,210,210 );
	gfx.PutPixel( 66 + x,29 + y,210,66,66 );
	gfx.PutPixel( 67 + x,29 + y,208,25,25 );
	gfx.PutPixel( 68 + x,29 + y,208,41,41 );
	gfx.PutPixel( 69 + x,29 + y,217,155,155 );
	gfx.PutPixel( 70 + x,29 + y,222,238,238 );
	gfx.PutPixel( 71 + x,29 + y,213,108,108 );
	gfx.PutPixel( 72 + x,29 + y,216,151,151 );
	gfx.PutPixel( 73 + x,29 + y,223,243,243 );
	gfx.PutPixel( 74 + x,29 + y,219,191,191 );
	gfx.PutPixel( 75 + x,29 + y,220,213,213 );
	gfx.PutPixel( 76 + x,29 + y,221,222,222 );
	gfx.PutPixel( 77 + x,29 + y,211,83,83 );
	gfx.PutPixel( 78 + x,29 + y,219,193,193 );
	gfx.PutPixel( 79 + x,29 + y,221,215,215 );
	gfx.PutPixel( 80 + x,29 + y,211,77,77 );
	gfx.PutPixel( 81 + x,29 + y,208,27,27 );
	gfx.PutPixel( 82 + x,29 + y,207,29,29 );
	gfx.PutPixel( 83 + x,29 + y,216,147,147 );
	gfx.PutPixel( 84 + x,29 + y,222,232,232 );
	gfx.PutPixel( 85 + x,29 + y,214,123,123 );
	gfx.PutPixel( 86 + x,29 + y,218,177,177 );
	gfx.PutPixel( 87 + x,29 + y,221,223,223 );
	gfx.PutPixel( 88 + x,29 + y,217,158,158 );
	gfx.PutPixel( 89 + x,29 + y,214,123,123 );
	gfx.PutPixel( 90 + x,29 + y,208,26,26 );
	gfx.PutPixel( 91 + x,29 + y,208,34,34 );
	gfx.PutPixel( 92 + x,29 + y,208,34,34 );
	gfx.PutPixel( 93 + x,29 + y,208,34,34 );
	gfx.PutPixel( 94 + x,29 + y,208,34,34 );
	gfx.PutPixel( 95 + x,29 + y,208,34,34 );
	gfx.PutPixel( 96 + x,29 + y,208,34,34 );
	gfx.PutPixel( 97 + x,29 + y,208,34,34 );
	gfx.PutPixel( 98 + x,29 + y,208,34,34 );
	gfx.PutPixel( 99 + x,29 + y,208,34,34 );
	gfx.PutPixel( 100 + x,29 + y,208,34,34 );
	gfx.PutPixel( 101 + x,29 + y,208,34,34 );
	gfx.PutPixel( 102 + x,29 + y,208,34,34 );
	gfx.PutPixel( 103 + x,29 + y,208,34,34 );
	gfx.PutPixel( 104 + x,29 + y,208,34,34 );
	gfx.PutPixel( 105 + x,29 + y,208,34,34 );
	gfx.PutPixel( 106 + x,29 + y,208,34,34 );
	gfx.PutPixel( 107 + x,29 + y,208,34,34 );
	gfx.PutPixel( 108 + x,29 + y,208,34,34 );
	gfx.PutPixel( 109 + x,29 + y,208,34,34 );
	gfx.PutPixel( 110 + x,29 + y,208,34,34 );
	gfx.PutPixel( 111 + x,29 + y,208,34,34 );
	gfx.PutPixel( 112 + x,29 + y,208,34,34 );
	gfx.PutPixel( 113 + x,29 + y,208,34,34 );
	gfx.PutPixel( 114 + x,29 + y,208,34,34 );
	gfx.PutPixel( 115 + x,29 + y,208,34,34 );
	gfx.PutPixel( 116 + x,29 + y,208,34,34 );
	gfx.PutPixel( 117 + x,29 + y,208,34,34 );
	gfx.PutPixel( 118 + x,29 + y,208,34,34 );
	gfx.PutPixel( 119 + x,29 + y,208,34,34 );
	gfx.PutPixel( 120 + x,29 + y,208,34,34 );
	gfx.PutPixel( 121 + x,29 + y,208,34,34 );
	gfx.PutPixel( 122 + x,29 + y,208,34,34 );
	gfx.PutPixel( 123 + x,29 + y,208,34,34 );
	gfx.PutPixel( 124 + x,29 + y,208,34,34 );
	gfx.PutPixel( 125 + x,29 + y,208,34,34 );
	gfx.PutPixel( 126 + x,29 + y,208,34,34 );
	gfx.PutPixel( 127 + x,29 + y,208,34,34 );
	gfx.PutPixel( 128 + x,29 + y,208,34,34 );
	gfx.PutPixel( 129 + x,29 + y,208,34,34 );
	gfx.PutPixel( 130 + x,29 + y,208,34,34 );
	gfx.PutPixel( 131 + x,29 + y,208,34,34 );
	gfx.PutPixel( 132 + x,29 + y,208,34,34 );
	gfx.PutPixel( 133 + x,29 + y,208,34,34 );
	gfx.PutPixel( 134 + x,29 + y,208,34,34 );
	gfx.PutPixel( 135 + x,29 + y,208,34,34 );
	gfx.PutPixel( 136 + x,29 + y,208,34,34 );
	gfx.PutPixel( 137 + x,29 + y,208,34,34 );
	gfx.PutPixel( 138 + x,29 + y,208,34,34 );
	gfx.PutPixel( 139 + x,29 + y,208,34,34 );
	gfx.PutPixel( 140 + x,29 + y,208,34,34 );
	gfx.PutPixel( 141 + x,29 + y,208,34,34 );
	gfx.PutPixel( 142 + x,29 + y,208,34,34 );
	gfx.PutPixel( 143 + x,29 + y,208,34,34 );
	gfx.PutPixel( 144 + x,29 + y,208,34,34 );
	gfx.PutPixel( 145 + x,29 + y,208,34,34 );
	gfx.PutPixel( 146 + x,29 + y,208,34,34 );
	gfx.PutPixel( 147 + x,29 + y,208,34,34 );
	gfx.PutPixel( 148 + x,29 + y,208,34,34 );
	gfx.PutPixel( 149 + x,29 + y,208,34,34 );
	gfx.PutPixel( 0 + x,30 + y,208,34,34 );
	gfx.PutPixel( 1 + x,30 + y,208,34,34 );
	gfx.PutPixel( 2 + x,30 + y,208,34,34 );
	gfx.PutPixel( 3 + x,30 + y,208,34,34 );
	gfx.PutPixel( 4 + x,30 + y,208,34,34 );
	gfx.PutPixel( 5 + x,30 + y,208,34,34 );
	gfx.PutPixel( 6 + x,30 + y,208,34,34 );
	gfx.PutPixel( 7 + x,30 + y,208,34,34 );
	gfx.PutPixel( 8 + x,30 + y,208,34,34 );
	gfx.PutPixel( 9 + x,30 + y,208,34,34 );
	gfx.PutPixel( 10 + x,30 + y,208,34,34 );
	gfx.PutPixel( 11 + x,30 + y,208,34,34 );
	gfx.PutPixel( 12 + x,30 + y,208,34,34 );
	gfx.PutPixel( 13 + x,30 + y,208,34,34 );
	gfx.PutPixel( 14 + x,30 + y,208,34,34 );
	gfx.PutPixel( 15 + x,30 + y,208,34,34 );
	gfx.PutPixel( 16 + x,30 + y,208,34,34 );
	gfx.PutPixel( 17 + x,30 + y,208,34,34 );
	gfx.PutPixel( 18 + x,30 + y,208,34,34 );
	gfx.PutPixel( 19 + x,30 + y,208,34,34 );
	gfx.PutPixel( 20 + x,30 + y,208,34,34 );
	gfx.PutPixel( 21 + x,30 + y,208,34,34 );
	gfx.PutPixel( 22 + x,30 + y,208,34,34 );
	gfx.PutPixel( 23 + x,30 + y,208,34,34 );
	gfx.PutPixel( 24 + x,30 + y,208,34,34 );
	gfx.PutPixel( 25 + x,30 + y,208,34,34 );
	gfx.PutPixel( 26 + x,30 + y,208,34,34 );
	gfx.PutPixel( 27 + x,30 + y,208,34,34 );
	gfx.PutPixel( 28 + x,30 + y,208,34,34 );
	gfx.PutPixel( 29 + x,30 + y,208,34,34 );
	gfx.PutPixel( 30 + x,30 + y,208,34,34 );
	gfx.PutPixel( 31 + x,30 + y,208,34,34 );
	gfx.PutPixel( 32 + x,30 + y,208,34,34 );
	gfx.PutPixel( 33 + x,30 + y,208,34,34 );
	gfx.PutPixel( 34 + x,30 + y,208,34,34 );
	gfx.PutPixel( 35 + x,30 + y,208,34,34 );
	gfx.PutPixel( 36 + x,30 + y,208,34,34 );
	gfx.PutPixel( 37 + x,30 + y,208,34,34 );
	gfx.PutPixel( 38 + x,30 + y,208,34,34 );
	gfx.PutPixel( 39 + x,30 + y,208,34,34 );
	gfx.PutPixel( 40 + x,30 + y,208,34,34 );
	gfx.PutPixel( 41 + x,30 + y,208,34,34 );
	gfx.PutPixel( 42 + x,30 + y,208,34,34 );
	gfx.PutPixel( 43 + x,30 + y,208,34,34 );
	gfx.PutPixel( 44 + x,30 + y,208,34,34 );
	gfx.PutPixel( 45 + x,30 + y,208,34,34 );
	gfx.PutPixel( 46 + x,30 + y,208,34,34 );
	gfx.PutPixel( 47 + x,30 + y,208,34,34 );
	gfx.PutPixel( 48 + x,30 + y,208,34,34 );
	gfx.PutPixel( 49 + x,30 + y,208,34,34 );
	gfx.PutPixel( 50 + x,30 + y,208,34,34 );
	gfx.PutPixel( 51 + x,30 + y,208,34,34 );
	gfx.PutPixel( 52 + x,30 + y,208,34,34 );
	gfx.PutPixel( 53 + x,30 + y,208,34,34 );
	gfx.PutPixel( 54 + x,30 + y,208,34,34 );
	gfx.PutPixel( 55 + x,30 + y,208,34,34 );
	gfx.PutPixel( 56 + x,30 + y,208,34,34 );
	gfx.PutPixel( 57 + x,30 + y,208,34,34 );
	gfx.PutPixel( 58 + x,30 + y,207,25,25 );
	gfx.PutPixel( 59 + x,30 + y,213,105,105 );
	gfx.PutPixel( 60 + x,30 + y,213,102,102 );
	gfx.PutPixel( 61 + x,30 + y,215,129,129 );
	gfx.PutPixel( 62 + x,30 + y,222,242,242 );
	gfx.PutPixel( 63 + x,30 + y,215,127,127 );
	gfx.PutPixel( 64 + x,30 + y,215,134,134 );
	gfx.PutPixel( 65 + x,30 + y,223,239,239 );
	gfx.PutPixel( 66 + x,30 + y,221,219,219 );
	gfx.PutPixel( 67 + x,30 + y,219,184,184 );
	gfx.PutPixel( 68 + x,30 + y,220,202,202 );
	gfx.PutPixel( 69 + x,30 + y,221,218,218 );
	gfx.PutPixel( 70 + x,30 + y,219,199,199 );
	gfx.PutPixel( 71 + x,30 + y,217,167,167 );
	gfx.PutPixel( 72 + x,30 + y,217,163,163 );
	gfx.PutPixel( 73 + x,30 + y,217,169,169 );
	gfx.PutPixel( 74 + x,30 + y,218,171,171 );
	gfx.PutPixel( 75 + x,30 + y,217,168,168 );
	gfx.PutPixel( 76 + x,30 + y,217,168,168 );
	gfx.PutPixel( 77 + x,30 + y,217,157,157 );
	gfx.PutPixel( 78 + x,30 + y,218,181,181 );
	gfx.PutPixel( 79 + x,30 + y,220,204,204 );
	gfx.PutPixel( 80 + x,30 + y,220,209,209 );
	gfx.PutPixel( 81 + x,30 + y,218,181,181 );
	gfx.PutPixel( 82 + x,30 + y,219,197,197 );
	gfx.PutPixel( 83 + x,30 + y,222,240,240 );
	gfx.PutPixel( 84 + x,30 + y,218,175,175 );
	gfx.PutPixel( 85 + x,30 + y,212,92,92 );
	gfx.PutPixel( 86 + x,30 + y,221,227,227 );
	gfx.PutPixel( 87 + x,30 + y,219,199,199 );
	gfx.PutPixel( 88 + x,30 + y,211,75,75 );
	gfx.PutPixel( 89 + x,30 + y,215,136,136 );
	gfx.PutPixel( 90 + x,30 + y,208,29,29 );
	gfx.PutPixel( 91 + x,30 + y,208,34,34 );
	gfx.PutPixel( 92 + x,30 + y,208,34,34 );
	gfx.PutPixel( 93 + x,30 + y,208,34,34 );
	gfx.PutPixel( 94 + x,30 + y,208,34,34 );
	gfx.PutPixel( 95 + x,30 + y,208,34,34 );
	gfx.PutPixel( 96 + x,30 + y,208,34,34 );
	gfx.PutPixel( 97 + x,30 + y,208,34,34 );
	gfx.PutPixel( 98 + x,30 + y,208,34,34 );
	gfx.PutPixel( 99 + x,30 + y,208,34,34 );
	gfx.PutPixel( 100 + x,30 + y,208,34,34 );
	gfx.PutPixel( 101 + x,30 + y,208,34,34 );
	gfx.PutPixel( 102 + x,30 + y,208,34,34 );
	gfx.PutPixel( 103 + x,30 + y,208,34,34 );
	gfx.PutPixel( 104 + x,30 + y,208,34,34 );
	gfx.PutPixel( 105 + x,30 + y,208,34,34 );
	gfx.PutPixel( 106 + x,30 + y,208,34,34 );
	gfx.PutPixel( 107 + x,30 + y,208,34,34 );
	gfx.PutPixel( 108 + x,30 + y,208,34,34 );
	gfx.PutPixel( 109 + x,30 + y,208,34,34 );
	gfx.PutPixel( 110 + x,30 + y,208,34,34 );
	gfx.PutPixel( 111 + x,30 + y,208,34,34 );
	gfx.PutPixel( 112 + x,30 + y,208,34,34 );
	gfx.PutPixel( 113 + x,30 + y,208,34,34 );
	gfx.PutPixel( 114 + x,30 + y,208,34,34 );
	gfx.PutPixel( 115 + x,30 + y,208,34,34 );
	gfx.PutPixel( 116 + x,30 + y,208,34,34 );
	gfx.PutPixel( 117 + x,30 + y,208,34,34 );
	gfx.PutPixel( 118 + x,30 + y,208,34,34 );
	gfx.PutPixel( 119 + x,30 + y,208,34,34 );
	gfx.PutPixel( 120 + x,30 + y,208,34,34 );
	gfx.PutPixel( 121 + x,30 + y,208,34,34 );
	gfx.PutPixel( 122 + x,30 + y,208,34,34 );
	gfx.PutPixel( 123 + x,30 + y,208,34,34 );
	gfx.PutPixel( 124 + x,30 + y,208,34,34 );
	gfx.PutPixel( 125 + x,30 + y,208,34,34 );
	gfx.PutPixel( 126 + x,30 + y,208,34,34 );
	gfx.PutPixel( 127 + x,30 + y,208,34,34 );
	gfx.PutPixel( 128 + x,30 + y,208,34,34 );
	gfx.PutPixel( 129 + x,30 + y,208,34,34 );
	gfx.PutPixel( 130 + x,30 + y,208,34,34 );
	gfx.PutPixel( 131 + x,30 + y,208,34,34 );
	gfx.PutPixel( 132 + x,30 + y,208,34,34 );
	gfx.PutPixel( 133 + x,30 + y,208,34,34 );
	gfx.PutPixel( 134 + x,30 + y,208,34,34 );
	gfx.PutPixel( 135 + x,30 + y,208,34,34 );
	gfx.PutPixel( 136 + x,30 + y,208,34,34 );
	gfx.PutPixel( 137 + x,30 + y,208,34,34 );
	gfx.PutPixel( 138 + x,30 + y,208,34,34 );
	gfx.PutPixel( 139 + x,30 + y,208,34,34 );
	gfx.PutPixel( 140 + x,30 + y,208,34,34 );
	gfx.PutPixel( 141 + x,30 + y,208,34,34 );
	gfx.PutPixel( 142 + x,30 + y,208,34,34 );
	gfx.PutPixel( 143 + x,30 + y,208,34,34 );
	gfx.PutPixel( 144 + x,30 + y,208,34,34 );
	gfx.PutPixel( 145 + x,30 + y,208,34,34 );
	gfx.PutPixel( 146 + x,30 + y,208,34,34 );
	gfx.PutPixel( 147 + x,30 + y,208,34,34 );
	gfx.PutPixel( 148 + x,30 + y,208,34,34 );
	gfx.PutPixel( 149 + x,30 + y,208,34,34 );
	gfx.PutPixel( 0 + x,31 + y,208,34,34 );
	gfx.PutPixel( 1 + x,31 + y,208,34,34 );
	gfx.PutPixel( 2 + x,31 + y,208,34,34 );
	gfx.PutPixel( 3 + x,31 + y,208,34,34 );
	gfx.PutPixel( 4 + x,31 + y,208,34,34 );
	gfx.PutPixel( 5 + x,31 + y,208,34,34 );
	gfx.PutPixel( 6 + x,31 + y,208,34,34 );
	gfx.PutPixel( 7 + x,31 + y,208,34,34 );
	gfx.PutPixel( 8 + x,31 + y,208,34,34 );
	gfx.PutPixel( 9 + x,31 + y,208,34,34 );
	gfx.PutPixel( 10 + x,31 + y,208,34,34 );
	gfx.PutPixel( 11 + x,31 + y,208,34,34 );
	gfx.PutPixel( 12 + x,31 + y,208,34,34 );
	gfx.PutPixel( 13 + x,31 + y,208,34,34 );
	gfx.PutPixel( 14 + x,31 + y,208,34,34 );
	gfx.PutPixel( 15 + x,31 + y,208,34,34 );
	gfx.PutPixel( 16 + x,31 + y,208,34,34 );
	gfx.PutPixel( 17 + x,31 + y,208,34,34 );
	gfx.PutPixel( 18 + x,31 + y,208,34,34 );
	gfx.PutPixel( 19 + x,31 + y,208,34,34 );
	gfx.PutPixel( 20 + x,31 + y,208,34,34 );
	gfx.PutPixel( 21 + x,31 + y,208,34,34 );
	gfx.PutPixel( 22 + x,31 + y,208,34,34 );
	gfx.PutPixel( 23 + x,31 + y,208,34,34 );
	gfx.PutPixel( 24 + x,31 + y,208,34,34 );
	gfx.PutPixel( 25 + x,31 + y,208,34,34 );
	gfx.PutPixel( 26 + x,31 + y,208,34,34 );
	gfx.PutPixel( 27 + x,31 + y,208,34,34 );
	gfx.PutPixel( 28 + x,31 + y,208,34,34 );
	gfx.PutPixel( 29 + x,31 + y,208,34,34 );
	gfx.PutPixel( 30 + x,31 + y,208,34,34 );
	gfx.PutPixel( 31 + x,31 + y,208,34,34 );
	gfx.PutPixel( 32 + x,31 + y,208,34,34 );
	gfx.PutPixel( 33 + x,31 + y,208,34,34 );
	gfx.PutPixel( 34 + x,31 + y,208,34,34 );
	gfx.PutPixel( 35 + x,31 + y,208,34,34 );
	gfx.PutPixel( 36 + x,31 + y,208,34,34 );
	gfx.PutPixel( 37 + x,31 + y,208,34,34 );
	gfx.PutPixel( 38 + x,31 + y,208,34,34 );
	gfx.PutPixel( 39 + x,31 + y,208,34,34 );
	gfx.PutPixel( 40 + x,31 + y,208,34,34 );
	gfx.PutPixel( 41 + x,31 + y,208,34,34 );
	gfx.PutPixel( 42 + x,31 + y,208,34,34 );
	gfx.PutPixel( 43 + x,31 + y,208,34,34 );
	gfx.PutPixel( 44 + x,31 + y,208,34,34 );
	gfx.PutPixel( 45 + x,31 + y,208,34,34 );
	gfx.PutPixel( 46 + x,31 + y,208,34,34 );
	gfx.PutPixel( 47 + x,31 + y,208,34,34 );
	gfx.PutPixel( 48 + x,31 + y,208,34,34 );
	gfx.PutPixel( 49 + x,31 + y,208,34,34 );
	gfx.PutPixel( 50 + x,31 + y,208,34,34 );
	gfx.PutPixel( 51 + x,31 + y,208,34,34 );
	gfx.PutPixel( 52 + x,31 + y,208,34,34 );
	gfx.PutPixel( 53 + x,31 + y,208,34,34 );
	gfx.PutPixel( 54 + x,31 + y,208,34,34 );
	gfx.PutPixel( 55 + x,31 + y,208,34,34 );
	gfx.PutPixel( 56 + x,31 + y,208,34,34 );
	gfx.PutPixel( 57 + x,31 + y,208,34,34 );
	gfx.PutPixel( 58 + x,31 + y,208,31,31 );
	gfx.PutPixel( 59 + x,31 + y,209,45,45 );
	gfx.PutPixel( 60 + x,31 + y,215,136,136 );
	gfx.PutPixel( 61 + x,31 + y,219,190,190 );
	gfx.PutPixel( 62 + x,31 + y,222,235,235 );
	gfx.PutPixel( 63 + x,31 + y,219,196,196 );
	gfx.PutPixel( 64 + x,31 + y,218,185,185 );
	gfx.PutPixel( 65 + x,31 + y,219,188,188 );
	gfx.PutPixel( 66 + x,31 + y,216,151,151 );
	gfx.PutPixel( 67 + x,31 + y,215,126,126 );
	gfx.PutPixel( 68 + x,31 + y,213,106,106 );
	gfx.PutPixel( 69 + x,31 + y,212,97,97 );
	gfx.PutPixel( 70 + x,31 + y,212,100,100 );
	gfx.PutPixel( 71 + x,31 + y,213,112,112 );
	gfx.PutPixel( 72 + x,31 + y,214,119,119 );
	gfx.PutPixel( 73 + x,31 + y,214,123,123 );
	gfx.PutPixel( 74 + x,31 + y,214,126,126 );
	gfx.PutPixel( 75 + x,31 + y,214,126,126 );
	gfx.PutPixel( 76 + x,31 + y,214,124,124 );
	gfx.PutPixel( 77 + x,31 + y,214,121,121 );
	gfx.PutPixel( 78 + x,31 + y,213,111,111 );
	gfx.PutPixel( 79 + x,31 + y,213,104,104 );
	gfx.PutPixel( 80 + x,31 + y,213,103,103 );
	gfx.PutPixel( 81 + x,31 + y,214,115,115 );
	gfx.PutPixel( 82 + x,31 + y,215,131,131 );
	gfx.PutPixel( 83 + x,31 + y,216,159,159 );
	gfx.PutPixel( 84 + x,31 + y,218,180,180 );
	gfx.PutPixel( 85 + x,31 + y,218,182,182 );
	gfx.PutPixel( 86 + x,31 + y,222,231,231 );
	gfx.PutPixel( 87 + x,31 + y,222,229,229 );
	gfx.PutPixel( 88 + x,31 + y,219,188,188 );
	gfx.PutPixel( 89 + x,31 + y,210,66,66 );
	gfx.PutPixel( 90 + x,31 + y,208,29,29 );
	gfx.PutPixel( 91 + x,31 + y,208,34,34 );
	gfx.PutPixel( 92 + x,31 + y,208,34,34 );
	gfx.PutPixel( 93 + x,31 + y,208,34,34 );
	gfx.PutPixel( 94 + x,31 + y,208,34,34 );
	gfx.PutPixel( 95 + x,31 + y,208,34,34 );
	gfx.PutPixel( 96 + x,31 + y,208,34,34 );
	gfx.PutPixel( 97 + x,31 + y,208,34,34 );
	gfx.PutPixel( 98 + x,31 + y,208,34,34 );
	gfx.PutPixel( 99 + x,31 + y,208,34,34 );
	gfx.PutPixel( 100 + x,31 + y,208,34,34 );
	gfx.PutPixel( 101 + x,31 + y,208,34,34 );
	gfx.PutPixel( 102 + x,31 + y,208,34,34 );
	gfx.PutPixel( 103 + x,31 + y,208,34,34 );
	gfx.PutPixel( 104 + x,31 + y,208,34,34 );
	gfx.PutPixel( 105 + x,31 + y,208,34,34 );
	gfx.PutPixel( 106 + x,31 + y,208,34,34 );
	gfx.PutPixel( 107 + x,31 + y,208,34,34 );
	gfx.PutPixel( 108 + x,31 + y,208,34,34 );
	gfx.PutPixel( 109 + x,31 + y,208,34,34 );
	gfx.PutPixel( 110 + x,31 + y,208,34,34 );
	gfx.PutPixel( 111 + x,31 + y,208,34,34 );
	gfx.PutPixel( 112 + x,31 + y,208,34,34 );
	gfx.PutPixel( 113 + x,31 + y,208,34,34 );
	gfx.PutPixel( 114 + x,31 + y,208,34,34 );
	gfx.PutPixel( 115 + x,31 + y,208,34,34 );
	gfx.PutPixel( 116 + x,31 + y,208,34,34 );
	gfx.PutPixel( 117 + x,31 + y,208,34,34 );
	gfx.PutPixel( 118 + x,31 + y,208,34,34 );
	gfx.PutPixel( 119 + x,31 + y,208,34,34 );
	gfx.PutPixel( 120 + x,31 + y,208,34,34 );
	gfx.PutPixel( 121 + x,31 + y,208,34,34 );
	gfx.PutPixel( 122 + x,31 + y,208,34,34 );
	gfx.PutPixel( 123 + x,31 + y,208,34,34 );
	gfx.PutPixel( 124 + x,31 + y,208,34,34 );
	gfx.PutPixel( 125 + x,31 + y,208,34,34 );
	gfx.PutPixel( 126 + x,31 + y,208,34,34 );
	gfx.PutPixel( 127 + x,31 + y,208,34,34 );
	gfx.PutPixel( 128 + x,31 + y,208,34,34 );
	gfx.PutPixel( 129 + x,31 + y,208,34,34 );
	gfx.PutPixel( 130 + x,31 + y,208,34,34 );
	gfx.PutPixel( 131 + x,31 + y,208,34,34 );
	gfx.PutPixel( 132 + x,31 + y,208,34,34 );
	gfx.PutPixel( 133 + x,31 + y,208,34,34 );
	gfx.PutPixel( 134 + x,31 + y,208,34,34 );
	gfx.PutPixel( 135 + x,31 + y,208,34,34 );
	gfx.PutPixel( 136 + x,31 + y,208,34,34 );
	gfx.PutPixel( 137 + x,31 + y,208,34,34 );
	gfx.PutPixel( 138 + x,31 + y,208,34,34 );
	gfx.PutPixel( 139 + x,31 + y,208,34,34 );
	gfx.PutPixel( 140 + x,31 + y,208,34,34 );
	gfx.PutPixel( 141 + x,31 + y,208,34,34 );
	gfx.PutPixel( 142 + x,31 + y,208,34,34 );
	gfx.PutPixel( 143 + x,31 + y,208,34,34 );
	gfx.PutPixel( 144 + x,31 + y,208,34,34 );
	gfx.PutPixel( 145 + x,31 + y,208,34,34 );
	gfx.PutPixel( 146 + x,31 + y,208,34,34 );
	gfx.PutPixel( 147 + x,31 + y,208,34,34 );
	gfx.PutPixel( 148 + x,31 + y,208,34,34 );
	gfx.PutPixel( 149 + x,31 + y,208,34,34 );
	gfx.PutPixel( 0 + x,32 + y,208,34,34 );
	gfx.PutPixel( 1 + x,32 + y,208,34,34 );
	gfx.PutPixel( 2 + x,32 + y,208,34,34 );
	gfx.PutPixel( 3 + x,32 + y,208,34,34 );
	gfx.PutPixel( 4 + x,32 + y,208,34,34 );
	gfx.PutPixel( 5 + x,32 + y,208,34,34 );
	gfx.PutPixel( 6 + x,32 + y,208,34,34 );
	gfx.PutPixel( 7 + x,32 + y,208,34,34 );
	gfx.PutPixel( 8 + x,32 + y,208,34,34 );
	gfx.PutPixel( 9 + x,32 + y,208,34,34 );
	gfx.PutPixel( 10 + x,32 + y,208,34,34 );
	gfx.PutPixel( 11 + x,32 + y,208,34,34 );
	gfx.PutPixel( 12 + x,32 + y,208,34,34 );
	gfx.PutPixel( 13 + x,32 + y,208,34,34 );
	gfx.PutPixel( 14 + x,32 + y,208,34,34 );
	gfx.PutPixel( 15 + x,32 + y,208,34,34 );
	gfx.PutPixel( 16 + x,32 + y,208,34,34 );
	gfx.PutPixel( 17 + x,32 + y,208,34,34 );
	gfx.PutPixel( 18 + x,32 + y,208,34,34 );
	gfx.PutPixel( 19 + x,32 + y,208,34,34 );
	gfx.PutPixel( 20 + x,32 + y,208,34,34 );
	gfx.PutPixel( 21 + x,32 + y,208,34,34 );
	gfx.PutPixel( 22 + x,32 + y,208,34,34 );
	gfx.PutPixel( 23 + x,32 + y,208,34,34 );
	gfx.PutPixel( 24 + x,32 + y,208,34,34 );
	gfx.PutPixel( 25 + x,32 + y,208,34,34 );
	gfx.PutPixel( 26 + x,32 + y,208,34,34 );
	gfx.PutPixel( 27 + x,32 + y,208,34,34 );
	gfx.PutPixel( 28 + x,32 + y,208,34,34 );
	gfx.PutPixel( 29 + x,32 + y,208,34,34 );
	gfx.PutPixel( 30 + x,32 + y,208,34,34 );
	gfx.PutPixel( 31 + x,32 + y,208,34,34 );
	gfx.PutPixel( 32 + x,32 + y,208,34,34 );
	gfx.PutPixel( 33 + x,32 + y,208,34,34 );
	gfx.PutPixel( 34 + x,32 + y,208,34,34 );
	gfx.PutPixel( 35 + x,32 + y,208,34,34 );
	gfx.PutPixel( 36 + x,32 + y,208,34,34 );
	gfx.PutPixel( 37 + x,32 + y,208,34,34 );
	gfx.PutPixel( 38 + x,32 + y,208,34,34 );
	gfx.PutPixel( 39 + x,32 + y,208,34,34 );
	gfx.PutPixel( 40 + x,32 + y,208,34,34 );
	gfx.PutPixel( 41 + x,32 + y,208,34,34 );
	gfx.PutPixel( 42 + x,32 + y,208,34,34 );
	gfx.PutPixel( 43 + x,32 + y,208,34,34 );
	gfx.PutPixel( 44 + x,32 + y,208,34,34 );
	gfx.PutPixel( 45 + x,32 + y,208,34,34 );
	gfx.PutPixel( 46 + x,32 + y,208,34,34 );
	gfx.PutPixel( 47 + x,32 + y,208,34,34 );
	gfx.PutPixel( 48 + x,32 + y,208,34,34 );
	gfx.PutPixel( 49 + x,32 + y,208,34,34 );
	gfx.PutPixel( 50 + x,32 + y,208,34,34 );
	gfx.PutPixel( 51 + x,32 + y,208,34,34 );
	gfx.PutPixel( 52 + x,32 + y,208,34,34 );
	gfx.PutPixel( 53 + x,32 + y,208,34,34 );
	gfx.PutPixel( 54 + x,32 + y,208,34,34 );
	gfx.PutPixel( 55 + x,32 + y,208,34,34 );
	gfx.PutPixel( 56 + x,32 + y,208,34,34 );
	gfx.PutPixel( 57 + x,32 + y,208,34,34 );
	gfx.PutPixel( 58 + x,32 + y,208,34,34 );
	gfx.PutPixel( 59 + x,32 + y,208,29,29 );
	gfx.PutPixel( 60 + x,32 + y,208,34,34 );
	gfx.PutPixel( 61 + x,32 + y,215,143,143 );
	gfx.PutPixel( 62 + x,32 + y,220,202,202 );
	gfx.PutPixel( 63 + x,32 + y,215,138,138 );
	gfx.PutPixel( 64 + x,32 + y,213,101,101 );
	gfx.PutPixel( 65 + x,32 + y,213,106,106 );
	gfx.PutPixel( 66 + x,32 + y,215,137,137 );
	gfx.PutPixel( 67 + x,32 + y,218,169,169 );
	gfx.PutPixel( 68 + x,32 + y,219,196,196 );
	gfx.PutPixel( 69 + x,32 + y,220,213,213 );
	gfx.PutPixel( 70 + x,32 + y,221,223,223 );
	gfx.PutPixel( 71 + x,32 + y,221,228,228 );
	gfx.PutPixel( 72 + x,32 + y,222,230,230 );
	gfx.PutPixel( 73 + x,32 + y,222,231,231 );
	gfx.PutPixel( 74 + x,32 + y,222,231,231 );
	gfx.PutPixel( 75 + x,32 + y,222,231,231 );
	gfx.PutPixel( 76 + x,32 + y,222,231,231 );
	gfx.PutPixel( 77 + x,32 + y,222,230,230 );
	gfx.PutPixel( 78 + x,32 + y,221,228,228 );
	gfx.PutPixel( 79 + x,32 + y,221,224,224 );
	gfx.PutPixel( 80 + x,32 + y,220,213,213 );
	gfx.PutPixel( 81 + x,32 + y,219,196,196 );
	gfx.PutPixel( 82 + x,32 + y,217,169,169 );
	gfx.PutPixel( 83 + x,32 + y,215,137,137 );
	gfx.PutPixel( 84 + x,32 + y,213,112,112 );
	gfx.PutPixel( 85 + x,32 + y,213,112,112 );
	gfx.PutPixel( 86 + x,32 + y,216,151,151 );
	gfx.PutPixel( 87 + x,32 + y,221,208,208 );
	gfx.PutPixel( 88 + x,32 + y,212,95,95 );
	gfx.PutPixel( 89 + x,32 + y,207,23,23 );
	gfx.PutPixel( 90 + x,32 + y,208,34,34 );
	gfx.PutPixel( 91 + x,32 + y,208,34,34 );
	gfx.PutPixel( 92 + x,32 + y,208,34,34 );
	gfx.PutPixel( 93 + x,32 + y,208,34,34 );
	gfx.PutPixel( 94 + x,32 + y,208,34,34 );
	gfx.PutPixel( 95 + x,32 + y,208,34,34 );
	gfx.PutPixel( 96 + x,32 + y,208,34,34 );
	gfx.PutPixel( 97 + x,32 + y,208,34,34 );
	gfx.PutPixel( 98 + x,32 + y,208,34,34 );
	gfx.PutPixel( 99 + x,32 + y,208,34,34 );
	gfx.PutPixel( 100 + x,32 + y,208,34,34 );
	gfx.PutPixel( 101 + x,32 + y,208,34,34 );
	gfx.PutPixel( 102 + x,32 + y,208,34,34 );
	gfx.PutPixel( 103 + x,32 + y,208,34,34 );
	gfx.PutPixel( 104 + x,32 + y,208,34,34 );
	gfx.PutPixel( 105 + x,32 + y,208,34,34 );
	gfx.PutPixel( 106 + x,32 + y,208,34,34 );
	gfx.PutPixel( 107 + x,32 + y,208,34,34 );
	gfx.PutPixel( 108 + x,32 + y,208,34,34 );
	gfx.PutPixel( 109 + x,32 + y,208,34,34 );
	gfx.PutPixel( 110 + x,32 + y,208,34,34 );
	gfx.PutPixel( 111 + x,32 + y,208,34,34 );
	gfx.PutPixel( 112 + x,32 + y,208,34,34 );
	gfx.PutPixel( 113 + x,32 + y,208,34,34 );
	gfx.PutPixel( 114 + x,32 + y,208,34,34 );
	gfx.PutPixel( 115 + x,32 + y,208,34,34 );
	gfx.PutPixel( 116 + x,32 + y,208,34,34 );
	gfx.PutPixel( 117 + x,32 + y,208,34,34 );
	gfx.PutPixel( 118 + x,32 + y,208,34,34 );
	gfx.PutPixel( 119 + x,32 + y,208,34,34 );
	gfx.PutPixel( 120 + x,32 + y,208,34,34 );
	gfx.PutPixel( 121 + x,32 + y,208,34,34 );
	gfx.PutPixel( 122 + x,32 + y,208,34,34 );
	gfx.PutPixel( 123 + x,32 + y,208,34,34 );
	gfx.PutPixel( 124 + x,32 + y,208,34,34 );
	gfx.PutPixel( 125 + x,32 + y,208,34,34 );
	gfx.PutPixel( 126 + x,32 + y,208,34,34 );
	gfx.PutPixel( 127 + x,32 + y,208,34,34 );
	gfx.PutPixel( 128 + x,32 + y,208,34,34 );
	gfx.PutPixel( 129 + x,32 + y,208,34,34 );
	gfx.PutPixel( 130 + x,32 + y,208,34,34 );
	gfx.PutPixel( 131 + x,32 + y,208,34,34 );
	gfx.PutPixel( 132 + x,32 + y,208,34,34 );
	gfx.PutPixel( 133 + x,32 + y,208,34,34 );
	gfx.PutPixel( 134 + x,32 + y,208,34,34 );
	gfx.PutPixel( 135 + x,32 + y,208,34,34 );
	gfx.PutPixel( 136 + x,32 + y,208,34,34 );
	gfx.PutPixel( 137 + x,32 + y,208,34,34 );
	gfx.PutPixel( 138 + x,32 + y,208,34,34 );
	gfx.PutPixel( 139 + x,32 + y,208,34,34 );
	gfx.PutPixel( 140 + x,32 + y,208,34,34 );
	gfx.PutPixel( 141 + x,32 + y,208,34,34 );
	gfx.PutPixel( 142 + x,32 + y,208,34,34 );
	gfx.PutPixel( 143 + x,32 + y,208,34,34 );
	gfx.PutPixel( 144 + x,32 + y,208,34,34 );
	gfx.PutPixel( 145 + x,32 + y,208,34,34 );
	gfx.PutPixel( 146 + x,32 + y,208,34,34 );
	gfx.PutPixel( 147 + x,32 + y,208,34,34 );
	gfx.PutPixel( 148 + x,32 + y,208,34,34 );
	gfx.PutPixel( 149 + x,32 + y,208,34,34 );
	gfx.PutPixel( 0 + x,33 + y,208,34,34 );
	gfx.PutPixel( 1 + x,33 + y,208,34,34 );
	gfx.PutPixel( 2 + x,33 + y,208,34,34 );
	gfx.PutPixel( 3 + x,33 + y,208,34,34 );
	gfx.PutPixel( 4 + x,33 + y,208,34,34 );
	gfx.PutPixel( 5 + x,33 + y,208,34,34 );
	gfx.PutPixel( 6 + x,33 + y,208,34,34 );
	gfx.PutPixel( 7 + x,33 + y,208,34,34 );
	gfx.PutPixel( 8 + x,33 + y,208,34,34 );
	gfx.PutPixel( 9 + x,33 + y,208,34,34 );
	gfx.PutPixel( 10 + x,33 + y,208,34,34 );
	gfx.PutPixel( 11 + x,33 + y,208,34,34 );
	gfx.PutPixel( 12 + x,33 + y,208,34,34 );
	gfx.PutPixel( 13 + x,33 + y,208,34,34 );
	gfx.PutPixel( 14 + x,33 + y,208,34,34 );
	gfx.PutPixel( 15 + x,33 + y,208,34,34 );
	gfx.PutPixel( 16 + x,33 + y,208,34,34 );
	gfx.PutPixel( 17 + x,33 + y,208,34,34 );
	gfx.PutPixel( 18 + x,33 + y,208,34,34 );
	gfx.PutPixel( 19 + x,33 + y,208,34,34 );
	gfx.PutPixel( 20 + x,33 + y,208,34,34 );
	gfx.PutPixel( 21 + x,33 + y,208,34,34 );
	gfx.PutPixel( 22 + x,33 + y,208,34,34 );
	gfx.PutPixel( 23 + x,33 + y,208,34,34 );
	gfx.PutPixel( 24 + x,33 + y,208,34,34 );
	gfx.PutPixel( 25 + x,33 + y,208,34,34 );
	gfx.PutPixel( 26 + x,33 + y,208,34,34 );
	gfx.PutPixel( 27 + x,33 + y,208,34,34 );
	gfx.PutPixel( 28 + x,33 + y,208,34,34 );
	gfx.PutPixel( 29 + x,33 + y,208,34,34 );
	gfx.PutPixel( 30 + x,33 + y,208,34,34 );
	gfx.PutPixel( 31 + x,33 + y,208,34,34 );
	gfx.PutPixel( 32 + x,33 + y,208,34,34 );
	gfx.PutPixel( 33 + x,33 + y,208,34,34 );
	gfx.PutPixel( 34 + x,33 + y,208,34,34 );
	gfx.PutPixel( 35 + x,33 + y,208,34,34 );
	gfx.PutPixel( 36 + x,33 + y,208,34,34 );
	gfx.PutPixel( 37 + x,33 + y,208,34,34 );
	gfx.PutPixel( 38 + x,33 + y,208,34,34 );
	gfx.PutPixel( 39 + x,33 + y,208,34,34 );
	gfx.PutPixel( 40 + x,33 + y,208,34,34 );
	gfx.PutPixel( 41 + x,33 + y,208,34,34 );
	gfx.PutPixel( 42 + x,33 + y,208,34,34 );
	gfx.PutPixel( 43 + x,33 + y,208,34,34 );
	gfx.PutPixel( 44 + x,33 + y,208,34,34 );
	gfx.PutPixel( 45 + x,33 + y,208,34,34 );
	gfx.PutPixel( 46 + x,33 + y,208,34,34 );
	gfx.PutPixel( 47 + x,33 + y,208,34,34 );
	gfx.PutPixel( 48 + x,33 + y,208,34,34 );
	gfx.PutPixel( 49 + x,33 + y,208,34,34 );
	gfx.PutPixel( 50 + x,33 + y,208,34,34 );
	gfx.PutPixel( 51 + x,33 + y,208,34,34 );
	gfx.PutPixel( 52 + x,33 + y,208,34,34 );
	gfx.PutPixel( 53 + x,33 + y,208,34,34 );
	gfx.PutPixel( 54 + x,33 + y,208,34,34 );
	gfx.PutPixel( 55 + x,33 + y,208,34,34 );
	gfx.PutPixel( 56 + x,33 + y,208,34,34 );
	gfx.PutPixel( 57 + x,33 + y,208,34,34 );
	gfx.PutPixel( 58 + x,33 + y,208,34,34 );
	gfx.PutPixel( 59 + x,33 + y,208,34,34 );
	gfx.PutPixel( 60 + x,33 + y,208,31,31 );
	gfx.PutPixel( 61 + x,33 + y,208,30,30 );
	gfx.PutPixel( 62 + x,33 + y,209,46,46 );
	gfx.PutPixel( 63 + x,33 + y,215,130,130 );
	gfx.PutPixel( 64 + x,33 + y,220,214,214 );
	gfx.PutPixel( 65 + x,33 + y,222,239,239 );
	gfx.PutPixel( 66 + x,33 + y,222,238,238 );
	gfx.PutPixel( 67 + x,33 + y,222,231,231 );
	gfx.PutPixel( 68 + x,33 + y,221,226,226 );
	gfx.PutPixel( 69 + x,33 + y,221,223,223 );
	gfx.PutPixel( 70 + x,33 + y,221,222,222 );
	gfx.PutPixel( 71 + x,33 + y,221,221,221 );
	gfx.PutPixel( 72 + x,33 + y,221,221,221 );
	gfx.PutPixel( 73 + x,33 + y,221,221,221 );
	gfx.PutPixel( 74 + x,33 + y,221,221,221 );
	gfx.PutPixel( 75 + x,33 + y,221,221,221 );
	gfx.PutPixel( 76 + x,33 + y,221,221,221 );
	gfx.PutPixel( 77 + x,33 + y,221,221,221 );
	gfx.PutPixel( 78 + x,33 + y,221,221,221 );
	gfx.PutPixel( 79 + x,33 + y,221,222,222 );
	gfx.PutPixel( 80 + x,33 + y,221,223,223 );
	gfx.PutPixel( 81 + x,33 + y,221,225,225 );
	gfx.PutPixel( 82 + x,33 + y,222,230,230 );
	gfx.PutPixel( 83 + x,33 + y,222,236,236 );
	gfx.PutPixel( 84 + x,33 + y,222,237,237 );
	gfx.PutPixel( 85 + x,33 + y,221,210,210 );
	gfx.PutPixel( 86 + x,33 + y,213,110,110 );
	gfx.PutPixel( 87 + x,33 + y,209,41,41 );
	gfx.PutPixel( 88 + x,33 + y,208,31,31 );
	gfx.PutPixel( 89 + x,33 + y,208,34,34 );
	gfx.PutPixel( 90 + x,33 + y,208,34,34 );
	gfx.PutPixel( 91 + x,33 + y,208,34,34 );
	gfx.PutPixel( 92 + x,33 + y,208,34,34 );
	gfx.PutPixel( 93 + x,33 + y,208,34,34 );
	gfx.PutPixel( 94 + x,33 + y,208,34,34 );
	gfx.PutPixel( 95 + x,33 + y,208,34,34 );
	gfx.PutPixel( 96 + x,33 + y,208,34,34 );
	gfx.PutPixel( 97 + x,33 + y,208,34,34 );
	gfx.PutPixel( 98 + x,33 + y,208,34,34 );
	gfx.PutPixel( 99 + x,33 + y,208,34,34 );
	gfx.PutPixel( 100 + x,33 + y,208,34,34 );
	gfx.PutPixel( 101 + x,33 + y,208,34,34 );
	gfx.PutPixel( 102 + x,33 + y,208,34,34 );
	gfx.PutPixel( 103 + x,33 + y,208,34,34 );
	gfx.PutPixel( 104 + x,33 + y,208,34,34 );
	gfx.PutPixel( 105 + x,33 + y,208,34,34 );
	gfx.PutPixel( 106 + x,33 + y,208,34,34 );
	gfx.PutPixel( 107 + x,33 + y,208,34,34 );
	gfx.PutPixel( 108 + x,33 + y,208,34,34 );
	gfx.PutPixel( 109 + x,33 + y,208,34,34 );
	gfx.PutPixel( 110 + x,33 + y,208,34,34 );
	gfx.PutPixel( 111 + x,33 + y,208,34,34 );
	gfx.PutPixel( 112 + x,33 + y,208,34,34 );
	gfx.PutPixel( 113 + x,33 + y,208,34,34 );
	gfx.PutPixel( 114 + x,33 + y,208,34,34 );
	gfx.PutPixel( 115 + x,33 + y,208,34,34 );
	gfx.PutPixel( 116 + x,33 + y,208,34,34 );
	gfx.PutPixel( 117 + x,33 + y,208,34,34 );
	gfx.PutPixel( 118 + x,33 + y,208,34,34 );
	gfx.PutPixel( 119 + x,33 + y,208,34,34 );
	gfx.PutPixel( 120 + x,33 + y,208,34,34 );
	gfx.PutPixel( 121 + x,33 + y,208,34,34 );
	gfx.PutPixel( 122 + x,33 + y,208,34,34 );
	gfx.PutPixel( 123 + x,33 + y,208,34,34 );
	gfx.PutPixel( 124 + x,33 + y,208,34,34 );
	gfx.PutPixel( 125 + x,33 + y,208,34,34 );
	gfx.PutPixel( 126 + x,33 + y,208,34,34 );
	gfx.PutPixel( 127 + x,33 + y,208,34,34 );
	gfx.PutPixel( 128 + x,33 + y,208,34,34 );
	gfx.PutPixel( 129 + x,33 + y,208,34,34 );
	gfx.PutPixel( 130 + x,33 + y,208,34,34 );
	gfx.PutPixel( 131 + x,33 + y,208,34,34 );
	gfx.PutPixel( 132 + x,33 + y,208,34,34 );
	gfx.PutPixel( 133 + x,33 + y,208,34,34 );
	gfx.PutPixel( 134 + x,33 + y,208,34,34 );
	gfx.PutPixel( 135 + x,33 + y,208,34,34 );
	gfx.PutPixel( 136 + x,33 + y,208,34,34 );
	gfx.PutPixel( 137 + x,33 + y,208,34,34 );
	gfx.PutPixel( 138 + x,33 + y,208,34,34 );
	gfx.PutPixel( 139 + x,33 + y,208,34,34 );
	gfx.PutPixel( 140 + x,33 + y,208,34,34 );
	gfx.PutPixel( 141 + x,33 + y,208,34,34 );
	gfx.PutPixel( 142 + x,33 + y,208,34,34 );
	gfx.PutPixel( 143 + x,33 + y,208,34,34 );
	gfx.PutPixel( 144 + x,33 + y,208,34,34 );
	gfx.PutPixel( 145 + x,33 + y,208,34,34 );
	gfx.PutPixel( 146 + x,33 + y,208,34,34 );
	gfx.PutPixel( 147 + x,33 + y,208,34,34 );
	gfx.PutPixel( 148 + x,33 + y,208,34,34 );
	gfx.PutPixel( 149 + x,33 + y,208,34,34 );
	gfx.PutPixel( 0 + x,34 + y,208,34,34 );
	gfx.PutPixel( 1 + x,34 + y,208,34,34 );
	gfx.PutPixel( 2 + x,34 + y,208,34,34 );
	gfx.PutPixel( 3 + x,34 + y,208,34,34 );
	gfx.PutPixel( 4 + x,34 + y,208,34,34 );
	gfx.PutPixel( 5 + x,34 + y,208,34,34 );
	gfx.PutPixel( 6 + x,34 + y,208,34,34 );
	gfx.PutPixel( 7 + x,34 + y,208,34,34 );
	gfx.PutPixel( 8 + x,34 + y,208,34,34 );
	gfx.PutPixel( 9 + x,34 + y,208,34,34 );
	gfx.PutPixel( 10 + x,34 + y,208,34,34 );
	gfx.PutPixel( 11 + x,34 + y,208,34,34 );
	gfx.PutPixel( 12 + x,34 + y,208,34,34 );
	gfx.PutPixel( 13 + x,34 + y,208,34,34 );
	gfx.PutPixel( 14 + x,34 + y,208,34,34 );
	gfx.PutPixel( 15 + x,34 + y,208,34,34 );
	gfx.PutPixel( 16 + x,34 + y,208,34,34 );
	gfx.PutPixel( 17 + x,34 + y,208,34,34 );
	gfx.PutPixel( 18 + x,34 + y,208,34,34 );
	gfx.PutPixel( 19 + x,34 + y,208,34,34 );
	gfx.PutPixel( 20 + x,34 + y,208,34,34 );
	gfx.PutPixel( 21 + x,34 + y,208,34,34 );
	gfx.PutPixel( 22 + x,34 + y,208,34,34 );
	gfx.PutPixel( 23 + x,34 + y,208,34,34 );
	gfx.PutPixel( 24 + x,34 + y,208,34,34 );
	gfx.PutPixel( 25 + x,34 + y,208,34,34 );
	gfx.PutPixel( 26 + x,34 + y,208,34,34 );
	gfx.PutPixel( 27 + x,34 + y,208,34,34 );
	gfx.PutPixel( 28 + x,34 + y,208,34,34 );
	gfx.PutPixel( 29 + x,34 + y,208,34,34 );
	gfx.PutPixel( 30 + x,34 + y,208,34,34 );
	gfx.PutPixel( 31 + x,34 + y,208,34,34 );
	gfx.PutPixel( 32 + x,34 + y,208,34,34 );
	gfx.PutPixel( 33 + x,34 + y,208,34,34 );
	gfx.PutPixel( 34 + x,34 + y,208,34,34 );
	gfx.PutPixel( 35 + x,34 + y,208,34,34 );
	gfx.PutPixel( 36 + x,34 + y,208,34,34 );
	gfx.PutPixel( 37 + x,34 + y,208,34,34 );
	gfx.PutPixel( 38 + x,34 + y,208,34,34 );
	gfx.PutPixel( 39 + x,34 + y,208,34,34 );
	gfx.PutPixel( 40 + x,34 + y,208,34,34 );
	gfx.PutPixel( 41 + x,34 + y,208,34,34 );
	gfx.PutPixel( 42 + x,34 + y,208,34,34 );
	gfx.PutPixel( 43 + x,34 + y,208,34,34 );
	gfx.PutPixel( 44 + x,34 + y,208,34,34 );
	gfx.PutPixel( 45 + x,34 + y,208,34,34 );
	gfx.PutPixel( 46 + x,34 + y,208,34,34 );
	gfx.PutPixel( 47 + x,34 + y,208,34,34 );
	gfx.PutPixel( 48 + x,34 + y,208,34,34 );
	gfx.PutPixel( 49 + x,34 + y,208,34,34 );
	gfx.PutPixel( 50 + x,34 + y,208,34,34 );
	gfx.PutPixel( 51 + x,34 + y,208,34,34 );
	gfx.PutPixel( 52 + x,34 + y,208,34,34 );
	gfx.PutPixel( 53 + x,34 + y,208,34,34 );
	gfx.PutPixel( 54 + x,34 + y,208,34,34 );
	gfx.PutPixel( 55 + x,34 + y,208,34,34 );
	gfx.PutPixel( 56 + x,34 + y,208,34,34 );
	gfx.PutPixel( 57 + x,34 + y,208,34,34 );
	gfx.PutPixel( 58 + x,34 + y,208,34,34 );
	gfx.PutPixel( 59 + x,34 + y,208,34,34 );
	gfx.PutPixel( 60 + x,34 + y,208,34,34 );
	gfx.PutPixel( 61 + x,34 + y,208,33,33 );
	gfx.PutPixel( 62 + x,34 + y,208,31,31 );
	gfx.PutPixel( 63 + x,34 + y,210,56,56 );
	gfx.PutPixel( 64 + x,34 + y,212,96,96 );
	gfx.PutPixel( 65 + x,34 + y,216,144,144 );
	gfx.PutPixel( 66 + x,34 + y,218,184,184 );
	gfx.PutPixel( 67 + x,34 + y,220,210,210 );
	gfx.PutPixel( 68 + x,34 + y,221,224,224 );
	gfx.PutPixel( 69 + x,34 + y,222,230,230 );
	gfx.PutPixel( 70 + x,34 + y,222,231,231 );
	gfx.PutPixel( 71 + x,34 + y,222,232,232 );
	gfx.PutPixel( 72 + x,34 + y,222,232,232 );
	gfx.PutPixel( 73 + x,34 + y,222,231,231 );
	gfx.PutPixel( 74 + x,34 + y,222,231,231 );
	gfx.PutPixel( 75 + x,34 + y,222,230,230 );
	gfx.PutPixel( 76 + x,34 + y,222,231,231 );
	gfx.PutPixel( 77 + x,34 + y,222,231,231 );
	gfx.PutPixel( 78 + x,34 + y,222,231,231 );
	gfx.PutPixel( 79 + x,34 + y,222,232,232 );
	gfx.PutPixel( 80 + x,34 + y,222,231,231 );
	gfx.PutPixel( 81 + x,34 + y,222,229,229 );
	gfx.PutPixel( 82 + x,34 + y,221,219,219 );
	gfx.PutPixel( 83 + x,34 + y,219,197,197 );
	gfx.PutPixel( 84 + x,34 + y,216,156,156 );
	gfx.PutPixel( 85 + x,34 + y,213,102,102 );
	gfx.PutPixel( 86 + x,34 + y,209,53,53 );
	gfx.PutPixel( 87 + x,34 + y,208,29,29 );
	gfx.PutPixel( 88 + x,34 + y,208,33,33 );
	gfx.PutPixel( 89 + x,34 + y,208,34,34 );
	gfx.PutPixel( 90 + x,34 + y,208,34,34 );
	gfx.PutPixel( 91 + x,34 + y,208,34,34 );
	gfx.PutPixel( 92 + x,34 + y,208,34,34 );
	gfx.PutPixel( 93 + x,34 + y,208,34,34 );
	gfx.PutPixel( 94 + x,34 + y,208,34,34 );
	gfx.PutPixel( 95 + x,34 + y,208,34,34 );
	gfx.PutPixel( 96 + x,34 + y,208,34,34 );
	gfx.PutPixel( 97 + x,34 + y,208,34,34 );
	gfx.PutPixel( 98 + x,34 + y,208,34,34 );
	gfx.PutPixel( 99 + x,34 + y,208,34,34 );
	gfx.PutPixel( 100 + x,34 + y,208,34,34 );
	gfx.PutPixel( 101 + x,34 + y,208,34,34 );
	gfx.PutPixel( 102 + x,34 + y,208,34,34 );
	gfx.PutPixel( 103 + x,34 + y,208,34,34 );
	gfx.PutPixel( 104 + x,34 + y,208,34,34 );
	gfx.PutPixel( 105 + x,34 + y,208,34,34 );
	gfx.PutPixel( 106 + x,34 + y,208,34,34 );
	gfx.PutPixel( 107 + x,34 + y,208,34,34 );
	gfx.PutPixel( 108 + x,34 + y,208,34,34 );
	gfx.PutPixel( 109 + x,34 + y,208,34,34 );
	gfx.PutPixel( 110 + x,34 + y,208,34,34 );
	gfx.PutPixel( 111 + x,34 + y,208,34,34 );
	gfx.PutPixel( 112 + x,34 + y,208,34,34 );
	gfx.PutPixel( 113 + x,34 + y,208,34,34 );
	gfx.PutPixel( 114 + x,34 + y,208,34,34 );
	gfx.PutPixel( 115 + x,34 + y,208,34,34 );
	gfx.PutPixel( 116 + x,34 + y,208,34,34 );
	gfx.PutPixel( 117 + x,34 + y,208,34,34 );
	gfx.PutPixel( 118 + x,34 + y,208,34,34 );
	gfx.PutPixel( 119 + x,34 + y,208,34,34 );
	gfx.PutPixel( 120 + x,34 + y,208,34,34 );
	gfx.PutPixel( 121 + x,34 + y,208,34,34 );
	gfx.PutPixel( 122 + x,34 + y,208,34,34 );
	gfx.PutPixel( 123 + x,34 + y,208,34,34 );
	gfx.PutPixel( 124 + x,34 + y,208,34,34 );
	gfx.PutPixel( 125 + x,34 + y,208,34,34 );
	gfx.PutPixel( 126 + x,34 + y,208,34,34 );
	gfx.PutPixel( 127 + x,34 + y,208,34,34 );
	gfx.PutPixel( 128 + x,34 + y,208,34,34 );
	gfx.PutPixel( 129 + x,34 + y,208,34,34 );
	gfx.PutPixel( 130 + x,34 + y,208,34,34 );
	gfx.PutPixel( 131 + x,34 + y,208,34,34 );
	gfx.PutPixel( 132 + x,34 + y,208,34,34 );
	gfx.PutPixel( 133 + x,34 + y,208,34,34 );
	gfx.PutPixel( 134 + x,34 + y,208,34,34 );
	gfx.PutPixel( 135 + x,34 + y,208,34,34 );
	gfx.PutPixel( 136 + x,34 + y,208,34,34 );
	gfx.PutPixel( 137 + x,34 + y,208,34,34 );
	gfx.PutPixel( 138 + x,34 + y,208,34,34 );
	gfx.PutPixel( 139 + x,34 + y,208,34,34 );
	gfx.PutPixel( 140 + x,34 + y,208,34,34 );
	gfx.PutPixel( 141 + x,34 + y,208,34,34 );
	gfx.PutPixel( 142 + x,34 + y,208,34,34 );
	gfx.PutPixel( 143 + x,34 + y,208,34,34 );
	gfx.PutPixel( 144 + x,34 + y,208,34,34 );
	gfx.PutPixel( 145 + x,34 + y,208,34,34 );
	gfx.PutPixel( 146 + x,34 + y,208,34,34 );
	gfx.PutPixel( 147 + x,34 + y,208,34,34 );
	gfx.PutPixel( 148 + x,34 + y,208,34,34 );
	gfx.PutPixel( 149 + x,34 + y,208,34,34 );
	gfx.PutPixel( 0 + x,35 + y,208,34,34 );
	gfx.PutPixel( 1 + x,35 + y,208,34,34 );
	gfx.PutPixel( 2 + x,35 + y,208,34,34 );
	gfx.PutPixel( 3 + x,35 + y,208,34,34 );
	gfx.PutPixel( 4 + x,35 + y,208,34,34 );
	gfx.PutPixel( 5 + x,35 + y,208,34,34 );
	gfx.PutPixel( 6 + x,35 + y,208,34,34 );
	gfx.PutPixel( 7 + x,35 + y,208,34,34 );
	gfx.PutPixel( 8 + x,35 + y,208,34,34 );
	gfx.PutPixel( 9 + x,35 + y,208,34,34 );
	gfx.PutPixel( 10 + x,35 + y,208,34,34 );
	gfx.PutPixel( 11 + x,35 + y,208,34,34 );
	gfx.PutPixel( 12 + x,35 + y,208,34,34 );
	gfx.PutPixel( 13 + x,35 + y,208,34,34 );
	gfx.PutPixel( 14 + x,35 + y,208,34,34 );
	gfx.PutPixel( 15 + x,35 + y,208,34,34 );
	gfx.PutPixel( 16 + x,35 + y,208,34,34 );
	gfx.PutPixel( 17 + x,35 + y,208,34,34 );
	gfx.PutPixel( 18 + x,35 + y,208,34,34 );
	gfx.PutPixel( 19 + x,35 + y,208,34,34 );
	gfx.PutPixel( 20 + x,35 + y,208,34,34 );
	gfx.PutPixel( 21 + x,35 + y,208,34,34 );
	gfx.PutPixel( 22 + x,35 + y,208,34,34 );
	gfx.PutPixel( 23 + x,35 + y,208,34,34 );
	gfx.PutPixel( 24 + x,35 + y,208,34,34 );
	gfx.PutPixel( 25 + x,35 + y,208,34,34 );
	gfx.PutPixel( 26 + x,35 + y,208,34,34 );
	gfx.PutPixel( 27 + x,35 + y,208,34,34 );
	gfx.PutPixel( 28 + x,35 + y,208,34,34 );
	gfx.PutPixel( 29 + x,35 + y,208,34,34 );
	gfx.PutPixel( 30 + x,35 + y,208,34,34 );
	gfx.PutPixel( 31 + x,35 + y,208,34,34 );
	gfx.PutPixel( 32 + x,35 + y,208,34,34 );
	gfx.PutPixel( 33 + x,35 + y,208,34,34 );
	gfx.PutPixel( 34 + x,35 + y,208,34,34 );
	gfx.PutPixel( 35 + x,35 + y,208,34,34 );
	gfx.PutPixel( 36 + x,35 + y,208,34,34 );
	gfx.PutPixel( 37 + x,35 + y,208,34,34 );
	gfx.PutPixel( 38 + x,35 + y,208,34,34 );
	gfx.PutPixel( 39 + x,35 + y,208,34,34 );
	gfx.PutPixel( 40 + x,35 + y,208,34,34 );
	gfx.PutPixel( 41 + x,35 + y,208,34,34 );
	gfx.PutPixel( 42 + x,35 + y,208,34,34 );
	gfx.PutPixel( 43 + x,35 + y,208,34,34 );
	gfx.PutPixel( 44 + x,35 + y,208,34,34 );
	gfx.PutPixel( 45 + x,35 + y,208,34,34 );
	gfx.PutPixel( 46 + x,35 + y,208,34,34 );
	gfx.PutPixel( 47 + x,35 + y,208,34,34 );
	gfx.PutPixel( 48 + x,35 + y,208,34,34 );
	gfx.PutPixel( 49 + x,35 + y,208,34,34 );
	gfx.PutPixel( 50 + x,35 + y,208,34,34 );
	gfx.PutPixel( 51 + x,35 + y,208,34,34 );
	gfx.PutPixel( 52 + x,35 + y,208,34,34 );
	gfx.PutPixel( 53 + x,35 + y,208,34,34 );
	gfx.PutPixel( 54 + x,35 + y,208,34,34 );
	gfx.PutPixel( 55 + x,35 + y,208,34,34 );
	gfx.PutPixel( 56 + x,35 + y,208,34,34 );
	gfx.PutPixel( 57 + x,35 + y,208,34,34 );
	gfx.PutPixel( 58 + x,35 + y,208,34,34 );
	gfx.PutPixel( 59 + x,35 + y,208,34,34 );
	gfx.PutPixel( 60 + x,35 + y,208,34,34 );
	gfx.PutPixel( 61 + x,35 + y,208,34,34 );
	gfx.PutPixel( 62 + x,35 + y,208,34,34 );
	gfx.PutPixel( 63 + x,35 + y,208,30,30 );
	gfx.PutPixel( 64 + x,35 + y,207,24,24 );
	gfx.PutPixel( 65 + x,35 + y,207,24,24 );
	gfx.PutPixel( 66 + x,35 + y,208,34,34 );
	gfx.PutPixel( 67 + x,35 + y,209,54,54 );
	gfx.PutPixel( 68 + x,35 + y,211,77,77 );
	gfx.PutPixel( 69 + x,35 + y,213,99,99 );
	gfx.PutPixel( 70 + x,35 + y,214,118,118 );
	gfx.PutPixel( 71 + x,35 + y,215,133,133 );
	gfx.PutPixel( 72 + x,35 + y,216,145,145 );
	gfx.PutPixel( 73 + x,35 + y,216,152,152 );
	gfx.PutPixel( 74 + x,35 + y,217,157,157 );
	gfx.PutPixel( 75 + x,35 + y,217,159,159 );
	gfx.PutPixel( 76 + x,35 + y,217,158,158 );
	gfx.PutPixel( 77 + x,35 + y,216,153,153 );
	gfx.PutPixel( 78 + x,35 + y,216,146,146 );
	gfx.PutPixel( 79 + x,35 + y,215,133,133 );
	gfx.PutPixel( 80 + x,35 + y,214,116,116 );
	gfx.PutPixel( 81 + x,35 + y,212,95,95 );
	gfx.PutPixel( 82 + x,35 + y,210,67,67 );
	gfx.PutPixel( 83 + x,35 + y,208,41,41 );
	gfx.PutPixel( 84 + x,35 + y,207,25,25 );
	gfx.PutPixel( 85 + x,35 + y,207,24,24 );
	gfx.PutPixel( 86 + x,35 + y,208,31,31 );
	gfx.PutPixel( 87 + x,35 + y,208,34,34 );
	gfx.PutPixel( 88 + x,35 + y,208,34,34 );
	gfx.PutPixel( 89 + x,35 + y,208,34,34 );
	gfx.PutPixel( 90 + x,35 + y,208,34,34 );
	gfx.PutPixel( 91 + x,35 + y,208,34,34 );
	gfx.PutPixel( 92 + x,35 + y,208,34,34 );
	gfx.PutPixel( 93 + x,35 + y,208,34,34 );
	gfx.PutPixel( 94 + x,35 + y,208,34,34 );
	gfx.PutPixel( 95 + x,35 + y,208,34,34 );
	gfx.PutPixel( 96 + x,35 + y,208,34,34 );
	gfx.PutPixel( 97 + x,35 + y,208,34,34 );
	gfx.PutPixel( 98 + x,35 + y,208,34,34 );
	gfx.PutPixel( 99 + x,35 + y,208,34,34 );
	gfx.PutPixel( 100 + x,35 + y,208,34,34 );
	gfx.PutPixel( 101 + x,35 + y,208,34,34 );
	gfx.PutPixel( 102 + x,35 + y,208,34,34 );
	gfx.PutPixel( 103 + x,35 + y,208,34,34 );
	gfx.PutPixel( 104 + x,35 + y,208,34,34 );
	gfx.PutPixel( 105 + x,35 + y,208,34,34 );
	gfx.PutPixel( 106 + x,35 + y,208,34,34 );
	gfx.PutPixel( 107 + x,35 + y,208,34,34 );
	gfx.PutPixel( 108 + x,35 + y,208,34,34 );
	gfx.PutPixel( 109 + x,35 + y,208,34,34 );
	gfx.PutPixel( 110 + x,35 + y,208,34,34 );
	gfx.PutPixel( 111 + x,35 + y,208,34,34 );
	gfx.PutPixel( 112 + x,35 + y,208,34,34 );
	gfx.PutPixel( 113 + x,35 + y,208,34,34 );
	gfx.PutPixel( 114 + x,35 + y,208,34,34 );
	gfx.PutPixel( 115 + x,35 + y,208,34,34 );
	gfx.PutPixel( 116 + x,35 + y,208,34,34 );
	gfx.PutPixel( 117 + x,35 + y,208,34,34 );
	gfx.PutPixel( 118 + x,35 + y,208,34,34 );
	gfx.PutPixel( 119 + x,35 + y,208,34,34 );
	gfx.PutPixel( 120 + x,35 + y,208,34,34 );
	gfx.PutPixel( 121 + x,35 + y,208,34,34 );
	gfx.PutPixel( 122 + x,35 + y,208,34,34 );
	gfx.PutPixel( 123 + x,35 + y,208,34,34 );
	gfx.PutPixel( 124 + x,35 + y,208,34,34 );
	gfx.PutPixel( 125 + x,35 + y,208,34,34 );
	gfx.PutPixel( 126 + x,35 + y,208,34,34 );
	gfx.PutPixel( 127 + x,35 + y,208,34,34 );
	gfx.PutPixel( 128 + x,35 + y,208,34,34 );
	gfx.PutPixel( 129 + x,35 + y,208,34,34 );
	gfx.PutPixel( 130 + x,35 + y,208,34,34 );
	gfx.PutPixel( 131 + x,35 + y,208,34,34 );
	gfx.PutPixel( 132 + x,35 + y,208,34,34 );
	gfx.PutPixel( 133 + x,35 + y,208,34,34 );
	gfx.PutPixel( 134 + x,35 + y,208,34,34 );
	gfx.PutPixel( 135 + x,35 + y,208,34,34 );
	gfx.PutPixel( 136 + x,35 + y,208,34,34 );
	gfx.PutPixel( 137 + x,35 + y,208,34,34 );
	gfx.PutPixel( 138 + x,35 + y,208,34,34 );
	gfx.PutPixel( 139 + x,35 + y,208,34,34 );
	gfx.PutPixel( 140 + x,35 + y,208,34,34 );
	gfx.PutPixel( 141 + x,35 + y,208,34,34 );
	gfx.PutPixel( 142 + x,35 + y,208,34,34 );
	gfx.PutPixel( 143 + x,35 + y,208,34,34 );
	gfx.PutPixel( 144 + x,35 + y,208,34,34 );
	gfx.PutPixel( 145 + x,35 + y,208,34,34 );
	gfx.PutPixel( 146 + x,35 + y,208,34,34 );
	gfx.PutPixel( 147 + x,35 + y,208,34,34 );
	gfx.PutPixel( 148 + x,35 + y,208,34,34 );
	gfx.PutPixel( 149 + x,35 + y,208,34,34 );
	gfx.PutPixel( 0 + x,36 + y,208,34,34 );
	gfx.PutPixel( 1 + x,36 + y,208,34,34 );
	gfx.PutPixel( 2 + x,36 + y,208,34,34 );
	gfx.PutPixel( 3 + x,36 + y,208,34,34 );
	gfx.PutPixel( 4 + x,36 + y,208,34,34 );
	gfx.PutPixel( 5 + x,36 + y,208,34,34 );
	gfx.PutPixel( 6 + x,36 + y,208,34,34 );
	gfx.PutPixel( 7 + x,36 + y,208,34,34 );
	gfx.PutPixel( 8 + x,36 + y,208,34,34 );
	gfx.PutPixel( 9 + x,36 + y,208,34,34 );
	gfx.PutPixel( 10 + x,36 + y,208,34,34 );
	gfx.PutPixel( 11 + x,36 + y,208,34,34 );
	gfx.PutPixel( 12 + x,36 + y,208,34,34 );
	gfx.PutPixel( 13 + x,36 + y,208,34,34 );
	gfx.PutPixel( 14 + x,36 + y,208,34,34 );
	gfx.PutPixel( 15 + x,36 + y,208,34,34 );
	gfx.PutPixel( 16 + x,36 + y,208,34,34 );
	gfx.PutPixel( 17 + x,36 + y,208,34,34 );
	gfx.PutPixel( 18 + x,36 + y,208,34,34 );
	gfx.PutPixel( 19 + x,36 + y,208,34,34 );
	gfx.PutPixel( 20 + x,36 + y,208,34,34 );
	gfx.PutPixel( 21 + x,36 + y,208,34,34 );
	gfx.PutPixel( 22 + x,36 + y,208,34,34 );
	gfx.PutPixel( 23 + x,36 + y,208,34,34 );
	gfx.PutPixel( 24 + x,36 + y,208,34,34 );
	gfx.PutPixel( 25 + x,36 + y,208,34,34 );
	gfx.PutPixel( 26 + x,36 + y,208,34,34 );
	gfx.PutPixel( 27 + x,36 + y,208,34,34 );
	gfx.PutPixel( 28 + x,36 + y,208,34,34 );
	gfx.PutPixel( 29 + x,36 + y,208,34,34 );
	gfx.PutPixel( 30 + x,36 + y,208,34,34 );
	gfx.PutPixel( 31 + x,36 + y,208,34,34 );
	gfx.PutPixel( 32 + x,36 + y,208,34,34 );
	gfx.PutPixel( 33 + x,36 + y,208,34,34 );
	gfx.PutPixel( 34 + x,36 + y,208,34,34 );
	gfx.PutPixel( 35 + x,36 + y,208,34,34 );
	gfx.PutPixel( 36 + x,36 + y,208,34,34 );
	gfx.PutPixel( 37 + x,36 + y,208,34,34 );
	gfx.PutPixel( 38 + x,36 + y,208,34,34 );
	gfx.PutPixel( 39 + x,36 + y,208,34,34 );
	gfx.PutPixel( 40 + x,36 + y,208,34,34 );
	gfx.PutPixel( 41 + x,36 + y,208,34,34 );
	gfx.PutPixel( 42 + x,36 + y,208,34,34 );
	gfx.PutPixel( 43 + x,36 + y,208,34,34 );
	gfx.PutPixel( 44 + x,36 + y,208,34,34 );
	gfx.PutPixel( 45 + x,36 + y,208,34,34 );
	gfx.PutPixel( 46 + x,36 + y,208,34,34 );
	gfx.PutPixel( 47 + x,36 + y,208,34,34 );
	gfx.PutPixel( 48 + x,36 + y,208,34,34 );
	gfx.PutPixel( 49 + x,36 + y,208,34,34 );
	gfx.PutPixel( 50 + x,36 + y,208,34,34 );
	gfx.PutPixel( 51 + x,36 + y,208,34,34 );
	gfx.PutPixel( 52 + x,36 + y,208,34,34 );
	gfx.PutPixel( 53 + x,36 + y,208,34,34 );
	gfx.PutPixel( 54 + x,36 + y,208,34,34 );
	gfx.PutPixel( 55 + x,36 + y,208,34,34 );
	gfx.PutPixel( 56 + x,36 + y,208,34,34 );
	gfx.PutPixel( 57 + x,36 + y,208,34,34 );
	gfx.PutPixel( 58 + x,36 + y,208,34,34 );
	gfx.PutPixel( 59 + x,36 + y,208,34,34 );
	gfx.PutPixel( 60 + x,36 + y,208,34,34 );
	gfx.PutPixel( 61 + x,36 + y,208,34,34 );
	gfx.PutPixel( 62 + x,36 + y,208,34,34 );
	gfx.PutPixel( 63 + x,36 + y,208,34,34 );
	gfx.PutPixel( 64 + x,36 + y,208,34,34 );
	gfx.PutPixel( 65 + x,36 + y,208,34,34 );
	gfx.PutPixel( 66 + x,36 + y,208,33,33 );
	gfx.PutPixel( 67 + x,36 + y,208,30,30 );
	gfx.PutPixel( 68 + x,36 + y,207,26,26 );
	gfx.PutPixel( 69 + x,36 + y,207,24,24 );
	gfx.PutPixel( 70 + x,36 + y,207,23,23 );
	gfx.PutPixel( 71 + x,36 + y,207,23,23 );
	gfx.PutPixel( 72 + x,36 + y,207,24,24 );
	gfx.PutPixel( 73 + x,36 + y,207,25,25 );
	gfx.PutPixel( 74 + x,36 + y,208,26,26 );
	gfx.PutPixel( 75 + x,36 + y,208,26,26 );
	gfx.PutPixel( 76 + x,36 + y,208,26,26 );
	gfx.PutPixel( 77 + x,36 + y,207,25,25 );
	gfx.PutPixel( 78 + x,36 + y,207,25,25 );
	gfx.PutPixel( 79 + x,36 + y,207,23,23 );
	gfx.PutPixel( 80 + x,36 + y,207,23,23 );
	gfx.PutPixel( 81 + x,36 + y,207,25,25 );
	gfx.PutPixel( 82 + x,36 + y,208,28,28 );
	gfx.PutPixel( 83 + x,36 + y,208,31,31 );
	gfx.PutPixel( 84 + x,36 + y,208,34,34 );
	gfx.PutPixel( 85 + x,36 + y,208,34,34 );
	gfx.PutPixel( 86 + x,36 + y,208,34,34 );
	gfx.PutPixel( 87 + x,36 + y,208,34,34 );
	gfx.PutPixel( 88 + x,36 + y,208,34,34 );
	gfx.PutPixel( 89 + x,36 + y,208,34,34 );
	gfx.PutPixel( 90 + x,36 + y,208,34,34 );
	gfx.PutPixel( 91 + x,36 + y,208,34,34 );
	gfx.PutPixel( 92 + x,36 + y,208,34,34 );
	gfx.PutPixel( 93 + x,36 + y,208,34,34 );
	gfx.PutPixel( 94 + x,36 + y,208,34,34 );
	gfx.PutPixel( 95 + x,36 + y,208,34,34 );
	gfx.PutPixel( 96 + x,36 + y,208,34,34 );
	gfx.PutPixel( 97 + x,36 + y,208,34,34 );
	gfx.PutPixel( 98 + x,36 + y,208,34,34 );
	gfx.PutPixel( 99 + x,36 + y,208,34,34 );
	gfx.PutPixel( 100 + x,36 + y,208,34,34 );
	gfx.PutPixel( 101 + x,36 + y,208,34,34 );
	gfx.PutPixel( 102 + x,36 + y,208,34,34 );
	gfx.PutPixel( 103 + x,36 + y,208,34,34 );
	gfx.PutPixel( 104 + x,36 + y,208,34,34 );
	gfx.PutPixel( 105 + x,36 + y,208,34,34 );
	gfx.PutPixel( 106 + x,36 + y,208,34,34 );
	gfx.PutPixel( 107 + x,36 + y,208,34,34 );
	gfx.PutPixel( 108 + x,36 + y,208,34,34 );
	gfx.PutPixel( 109 + x,36 + y,208,34,34 );
	gfx.PutPixel( 110 + x,36 + y,208,34,34 );
	gfx.PutPixel( 111 + x,36 + y,208,34,34 );
	gfx.PutPixel( 112 + x,36 + y,208,34,34 );
	gfx.PutPixel( 113 + x,36 + y,208,34,34 );
	gfx.PutPixel( 114 + x,36 + y,208,34,34 );
	gfx.PutPixel( 115 + x,36 + y,208,34,34 );
	gfx.PutPixel( 116 + x,36 + y,208,34,34 );
	gfx.PutPixel( 117 + x,36 + y,208,34,34 );
	gfx.PutPixel( 118 + x,36 + y,208,34,34 );
	gfx.PutPixel( 119 + x,36 + y,208,34,34 );
	gfx.PutPixel( 120 + x,36 + y,208,34,34 );
	gfx.PutPixel( 121 + x,36 + y,208,34,34 );
	gfx.PutPixel( 122 + x,36 + y,208,34,34 );
	gfx.PutPixel( 123 + x,36 + y,208,34,34 );
	gfx.PutPixel( 124 + x,36 + y,208,34,34 );
	gfx.PutPixel( 125 + x,36 + y,208,34,34 );
	gfx.PutPixel( 126 + x,36 + y,208,34,34 );
	gfx.PutPixel( 127 + x,36 + y,208,34,34 );
	gfx.PutPixel( 128 + x,36 + y,208,34,34 );
	gfx.PutPixel( 129 + x,36 + y,208,34,34 );
	gfx.PutPixel( 130 + x,36 + y,208,34,34 );
	gfx.PutPixel( 131 + x,36 + y,208,34,34 );
	gfx.PutPixel( 132 + x,36 + y,208,34,34 );
	gfx.PutPixel( 133 + x,36 + y,208,34,34 );
	gfx.PutPixel( 134 + x,36 + y,208,34,34 );
	gfx.PutPixel( 135 + x,36 + y,208,34,34 );
	gfx.PutPixel( 136 + x,36 + y,208,34,34 );
	gfx.PutPixel( 137 + x,36 + y,208,34,34 );
	gfx.PutPixel( 138 + x,36 + y,208,34,34 );
	gfx.PutPixel( 139 + x,36 + y,208,34,34 );
	gfx.PutPixel( 140 + x,36 + y,208,34,34 );
	gfx.PutPixel( 141 + x,36 + y,208,34,34 );
	gfx.PutPixel( 142 + x,36 + y,208,34,34 );
	gfx.PutPixel( 143 + x,36 + y,208,34,34 );
	gfx.PutPixel( 144 + x,36 + y,208,34,34 );
	gfx.PutPixel( 145 + x,36 + y,208,34,34 );
	gfx.PutPixel( 146 + x,36 + y,208,34,34 );
	gfx.PutPixel( 147 + x,36 + y,208,34,34 );
	gfx.PutPixel( 148 + x,36 + y,208,34,34 );
	gfx.PutPixel( 149 + x,36 + y,208,34,34 );
	gfx.PutPixel( 0 + x,37 + y,208,34,34 );
	gfx.PutPixel( 1 + x,37 + y,208,34,34 );
	gfx.PutPixel( 2 + x,37 + y,208,34,34 );
	gfx.PutPixel( 3 + x,37 + y,208,34,34 );
	gfx.PutPixel( 4 + x,37 + y,208,34,34 );
	gfx.PutPixel( 5 + x,37 + y,208,34,34 );
	gfx.PutPixel( 6 + x,37 + y,208,34,34 );
	gfx.PutPixel( 7 + x,37 + y,208,34,34 );
	gfx.PutPixel( 8 + x,37 + y,208,34,34 );
	gfx.PutPixel( 9 + x,37 + y,208,34,34 );
	gfx.PutPixel( 10 + x,37 + y,208,34,34 );
	gfx.PutPixel( 11 + x,37 + y,208,34,34 );
	gfx.PutPixel( 12 + x,37 + y,208,34,34 );
	gfx.PutPixel( 13 + x,37 + y,208,34,34 );
	gfx.PutPixel( 14 + x,37 + y,208,34,34 );
	gfx.PutPixel( 15 + x,37 + y,208,34,34 );
	gfx.PutPixel( 16 + x,37 + y,208,34,34 );
	gfx.PutPixel( 17 + x,37 + y,208,34,34 );
	gfx.PutPixel( 18 + x,37 + y,208,34,34 );
	gfx.PutPixel( 19 + x,37 + y,208,34,34 );
	gfx.PutPixel( 20 + x,37 + y,208,34,34 );
	gfx.PutPixel( 21 + x,37 + y,208,34,34 );
	gfx.PutPixel( 22 + x,37 + y,208,34,34 );
	gfx.PutPixel( 23 + x,37 + y,208,34,34 );
	gfx.PutPixel( 24 + x,37 + y,208,34,34 );
	gfx.PutPixel( 25 + x,37 + y,208,34,34 );
	gfx.PutPixel( 26 + x,37 + y,208,34,34 );
	gfx.PutPixel( 27 + x,37 + y,208,34,34 );
	gfx.PutPixel( 28 + x,37 + y,208,34,34 );
	gfx.PutPixel( 29 + x,37 + y,208,34,34 );
	gfx.PutPixel( 30 + x,37 + y,208,34,34 );
	gfx.PutPixel( 31 + x,37 + y,208,34,34 );
	gfx.PutPixel( 32 + x,37 + y,208,34,34 );
	gfx.PutPixel( 33 + x,37 + y,208,34,34 );
	gfx.PutPixel( 34 + x,37 + y,208,34,34 );
	gfx.PutPixel( 35 + x,37 + y,208,34,34 );
	gfx.PutPixel( 36 + x,37 + y,208,34,34 );
	gfx.PutPixel( 37 + x,37 + y,208,34,34 );
	gfx.PutPixel( 38 + x,37 + y,208,34,34 );
	gfx.PutPixel( 39 + x,37 + y,208,34,34 );
	gfx.PutPixel( 40 + x,37 + y,208,34,34 );
	gfx.PutPixel( 41 + x,37 + y,208,34,34 );
	gfx.PutPixel( 42 + x,37 + y,208,34,34 );
	gfx.PutPixel( 43 + x,37 + y,208,34,34 );
	gfx.PutPixel( 44 + x,37 + y,208,34,34 );
	gfx.PutPixel( 45 + x,37 + y,208,34,34 );
	gfx.PutPixel( 46 + x,37 + y,208,34,34 );
	gfx.PutPixel( 47 + x,37 + y,208,34,34 );
	gfx.PutPixel( 48 + x,37 + y,208,34,34 );
	gfx.PutPixel( 49 + x,37 + y,208,34,34 );
	gfx.PutPixel( 50 + x,37 + y,208,34,34 );
	gfx.PutPixel( 51 + x,37 + y,208,34,34 );
	gfx.PutPixel( 52 + x,37 + y,208,34,34 );
	gfx.PutPixel( 53 + x,37 + y,208,34,34 );
	gfx.PutPixel( 54 + x,37 + y,208,34,34 );
	gfx.PutPixel( 55 + x,37 + y,208,34,34 );
	gfx.PutPixel( 56 + x,37 + y,208,34,34 );
	gfx.PutPixel( 57 + x,37 + y,208,34,34 );
	gfx.PutPixel( 58 + x,37 + y,208,34,34 );
	gfx.PutPixel( 59 + x,37 + y,208,34,34 );
	gfx.PutPixel( 60 + x,37 + y,208,34,34 );
	gfx.PutPixel( 61 + x,37 + y,208,34,34 );
	gfx.PutPixel( 62 + x,37 + y,208,34,34 );
	gfx.PutPixel( 63 + x,37 + y,208,34,34 );
	gfx.PutPixel( 64 + x,37 + y,208,34,34 );
	gfx.PutPixel( 65 + x,37 + y,208,34,34 );
	gfx.PutPixel( 66 + x,37 + y,208,34,34 );
	gfx.PutPixel( 67 + x,37 + y,208,34,34 );
	gfx.PutPixel( 68 + x,37 + y,208,34,34 );
	gfx.PutPixel( 69 + x,37 + y,208,34,34 );
	gfx.PutPixel( 70 + x,37 + y,208,34,34 );
	gfx.PutPixel( 71 + x,37 + y,208,34,34 );
	gfx.PutPixel( 72 + x,37 + y,208,34,34 );
	gfx.PutPixel( 73 + x,37 + y,208,34,34 );
	gfx.PutPixel( 74 + x,37 + y,208,34,34 );
	gfx.PutPixel( 75 + x,37 + y,208,34,34 );
	gfx.PutPixel( 76 + x,37 + y,208,34,34 );
	gfx.PutPixel( 77 + x,37 + y,208,34,34 );
	gfx.PutPixel( 78 + x,37 + y,208,34,34 );
	gfx.PutPixel( 79 + x,37 + y,208,34,34 );
	gfx.PutPixel( 80 + x,37 + y,208,34,34 );
	gfx.PutPixel( 81 + x,37 + y,208,34,34 );
	gfx.PutPixel( 82 + x,37 + y,208,34,34 );
	gfx.PutPixel( 83 + x,37 + y,208,34,34 );
	gfx.PutPixel( 84 + x,37 + y,208,34,34 );
	gfx.PutPixel( 85 + x,37 + y,208,34,34 );
	gfx.PutPixel( 86 + x,37 + y,208,34,34 );
	gfx.PutPixel( 87 + x,37 + y,208,34,34 );
	gfx.PutPixel( 88 + x,37 + y,208,34,34 );
	gfx.PutPixel( 89 + x,37 + y,208,34,34 );
	gfx.PutPixel( 90 + x,37 + y,208,34,34 );
	gfx.PutPixel( 91 + x,37 + y,208,34,34 );
	gfx.PutPixel( 92 + x,37 + y,208,34,34 );
	gfx.PutPixel( 93 + x,37 + y,208,34,34 );
	gfx.PutPixel( 94 + x,37 + y,208,34,34 );
	gfx.PutPixel( 95 + x,37 + y,208,34,34 );
	gfx.PutPixel( 96 + x,37 + y,208,34,34 );
	gfx.PutPixel( 97 + x,37 + y,208,34,34 );
	gfx.PutPixel( 98 + x,37 + y,208,34,34 );
	gfx.PutPixel( 99 + x,37 + y,208,34,34 );
	gfx.PutPixel( 100 + x,37 + y,208,34,34 );
	gfx.PutPixel( 101 + x,37 + y,208,34,34 );
	gfx.PutPixel( 102 + x,37 + y,208,34,34 );
	gfx.PutPixel( 103 + x,37 + y,208,34,34 );
	gfx.PutPixel( 104 + x,37 + y,208,34,34 );
	gfx.PutPixel( 105 + x,37 + y,208,34,34 );
	gfx.PutPixel( 106 + x,37 + y,208,34,34 );
	gfx.PutPixel( 107 + x,37 + y,208,34,34 );
	gfx.PutPixel( 108 + x,37 + y,208,34,34 );
	gfx.PutPixel( 109 + x,37 + y,208,34,34 );
	gfx.PutPixel( 110 + x,37 + y,208,34,34 );
	gfx.PutPixel( 111 + x,37 + y,208,34,34 );
	gfx.PutPixel( 112 + x,37 + y,208,34,34 );
	gfx.PutPixel( 113 + x,37 + y,208,34,34 );
	gfx.PutPixel( 114 + x,37 + y,208,34,34 );
	gfx.PutPixel( 115 + x,37 + y,208,34,34 );
	gfx.PutPixel( 116 + x,37 + y,208,34,34 );
	gfx.PutPixel( 117 + x,37 + y,208,34,34 );
	gfx.PutPixel( 118 + x,37 + y,208,34,34 );
	gfx.PutPixel( 119 + x,37 + y,208,34,34 );
	gfx.PutPixel( 120 + x,37 + y,208,34,34 );
	gfx.PutPixel( 121 + x,37 + y,208,34,34 );
	gfx.PutPixel( 122 + x,37 + y,208,34,34 );
	gfx.PutPixel( 123 + x,37 + y,208,34,34 );
	gfx.PutPixel( 124 + x,37 + y,208,34,34 );
	gfx.PutPixel( 125 + x,37 + y,208,34,34 );
	gfx.PutPixel( 126 + x,37 + y,208,34,34 );
	gfx.PutPixel( 127 + x,37 + y,208,34,34 );
	gfx.PutPixel( 128 + x,37 + y,208,34,34 );
	gfx.PutPixel( 129 + x,37 + y,208,34,34 );
	gfx.PutPixel( 130 + x,37 + y,208,34,34 );
	gfx.PutPixel( 131 + x,37 + y,208,34,34 );
	gfx.PutPixel( 132 + x,37 + y,208,34,34 );
	gfx.PutPixel( 133 + x,37 + y,208,34,34 );
	gfx.PutPixel( 134 + x,37 + y,208,34,34 );
	gfx.PutPixel( 135 + x,37 + y,208,34,34 );
	gfx.PutPixel( 136 + x,37 + y,208,34,34 );
	gfx.PutPixel( 137 + x,37 + y,208,34,34 );
	gfx.PutPixel( 138 + x,37 + y,208,34,34 );
	gfx.PutPixel( 139 + x,37 + y,208,34,34 );
	gfx.PutPixel( 140 + x,37 + y,208,34,34 );
	gfx.PutPixel( 141 + x,37 + y,208,34,34 );
	gfx.PutPixel( 142 + x,37 + y,208,34,34 );
	gfx.PutPixel( 143 + x,37 + y,208,34,34 );
	gfx.PutPixel( 144 + x,37 + y,208,34,34 );
	gfx.PutPixel( 145 + x,37 + y,208,34,34 );
	gfx.PutPixel( 146 + x,37 + y,208,34,34 );
	gfx.PutPixel( 147 + x,37 + y,208,34,34 );
	gfx.PutPixel( 148 + x,37 + y,208,34,34 );
	gfx.PutPixel( 149 + x,37 + y,208,34,34 );
	gfx.PutPixel( 0 + x,38 + y,208,34,34 );
	gfx.PutPixel( 1 + x,38 + y,208,34,34 );
	gfx.PutPixel( 2 + x,38 + y,208,34,34 );
	gfx.PutPixel( 3 + x,38 + y,208,34,34 );
	gfx.PutPixel( 4 + x,38 + y,208,34,34 );
	gfx.PutPixel( 5 + x,38 + y,208,34,34 );
	gfx.PutPixel( 6 + x,38 + y,208,34,34 );
	gfx.PutPixel( 7 + x,38 + y,208,34,34 );
	gfx.PutPixel( 8 + x,38 + y,208,34,34 );
	gfx.PutPixel( 9 + x,38 + y,208,34,34 );
	gfx.PutPixel( 10 + x,38 + y,208,34,34 );
	gfx.PutPixel( 11 + x,38 + y,208,34,34 );
	gfx.PutPixel( 12 + x,38 + y,208,34,34 );
	gfx.PutPixel( 13 + x,38 + y,208,34,34 );
	gfx.PutPixel( 14 + x,38 + y,208,34,34 );
	gfx.PutPixel( 15 + x,38 + y,208,34,34 );
	gfx.PutPixel( 16 + x,38 + y,208,34,34 );
	gfx.PutPixel( 17 + x,38 + y,208,34,34 );
	gfx.PutPixel( 18 + x,38 + y,208,34,34 );
	gfx.PutPixel( 19 + x,38 + y,208,34,34 );
	gfx.PutPixel( 20 + x,38 + y,208,34,34 );
	gfx.PutPixel( 21 + x,38 + y,208,34,34 );
	gfx.PutPixel( 22 + x,38 + y,208,34,34 );
	gfx.PutPixel( 23 + x,38 + y,208,34,34 );
	gfx.PutPixel( 24 + x,38 + y,208,34,34 );
	gfx.PutPixel( 25 + x,38 + y,208,34,34 );
	gfx.PutPixel( 26 + x,38 + y,208,34,34 );
	gfx.PutPixel( 27 + x,38 + y,208,34,34 );
	gfx.PutPixel( 28 + x,38 + y,208,34,34 );
	gfx.PutPixel( 29 + x,38 + y,208,34,34 );
	gfx.PutPixel( 30 + x,38 + y,208,34,34 );
	gfx.PutPixel( 31 + x,38 + y,208,34,34 );
	gfx.PutPixel( 32 + x,38 + y,208,34,34 );
	gfx.PutPixel( 33 + x,38 + y,208,34,34 );
	gfx.PutPixel( 34 + x,38 + y,208,34,34 );
	gfx.PutPixel( 35 + x,38 + y,208,34,34 );
	gfx.PutPixel( 36 + x,38 + y,208,34,34 );
	gfx.PutPixel( 37 + x,38 + y,208,34,34 );
	gfx.PutPixel( 38 + x,38 + y,208,34,34 );
	gfx.PutPixel( 39 + x,38 + y,208,34,34 );
	gfx.PutPixel( 40 + x,38 + y,208,34,34 );
	gfx.PutPixel( 41 + x,38 + y,208,34,34 );
	gfx.PutPixel( 42 + x,38 + y,208,34,34 );
	gfx.PutPixel( 43 + x,38 + y,208,34,34 );
	gfx.PutPixel( 44 + x,38 + y,208,34,34 );
	gfx.PutPixel( 45 + x,38 + y,208,34,34 );
	gfx.PutPixel( 46 + x,38 + y,208,34,34 );
	gfx.PutPixel( 47 + x,38 + y,208,34,34 );
	gfx.PutPixel( 48 + x,38 + y,208,34,34 );
	gfx.PutPixel( 49 + x,38 + y,208,34,34 );
	gfx.PutPixel( 50 + x,38 + y,208,34,34 );
	gfx.PutPixel( 51 + x,38 + y,208,34,34 );
	gfx.PutPixel( 52 + x,38 + y,208,34,34 );
	gfx.PutPixel( 53 + x,38 + y,208,34,34 );
	gfx.PutPixel( 54 + x,38 + y,208,34,34 );
	gfx.PutPixel( 55 + x,38 + y,208,34,34 );
	gfx.PutPixel( 56 + x,38 + y,208,34,34 );
	gfx.PutPixel( 57 + x,38 + y,208,34,34 );
	gfx.PutPixel( 58 + x,38 + y,208,34,34 );
	gfx.PutPixel( 59 + x,38 + y,208,34,34 );
	gfx.PutPixel( 60 + x,38 + y,208,34,34 );
	gfx.PutPixel( 61 + x,38 + y,208,34,34 );
	gfx.PutPixel( 62 + x,38 + y,208,34,34 );
	gfx.PutPixel( 63 + x,38 + y,208,34,34 );
	gfx.PutPixel( 64 + x,38 + y,208,34,34 );
	gfx.PutPixel( 65 + x,38 + y,208,34,34 );
	gfx.PutPixel( 66 + x,38 + y,208,34,34 );
	gfx.PutPixel( 67 + x,38 + y,208,34,34 );
	gfx.PutPixel( 68 + x,38 + y,208,34,34 );
	gfx.PutPixel( 69 + x,38 + y,208,34,34 );
	gfx.PutPixel( 70 + x,38 + y,208,34,34 );
	gfx.PutPixel( 71 + x,38 + y,208,34,34 );
	gfx.PutPixel( 72 + x,38 + y,208,34,34 );
	gfx.PutPixel( 73 + x,38 + y,208,34,34 );
	gfx.PutPixel( 74 + x,38 + y,208,34,34 );
	gfx.PutPixel( 75 + x,38 + y,208,34,34 );
	gfx.PutPixel( 76 + x,38 + y,208,34,34 );
	gfx.PutPixel( 77 + x,38 + y,208,34,34 );
	gfx.PutPixel( 78 + x,38 + y,208,34,34 );
	gfx.PutPixel( 79 + x,38 + y,208,34,34 );
	gfx.PutPixel( 80 + x,38 + y,208,34,34 );
	gfx.PutPixel( 81 + x,38 + y,208,34,34 );
	gfx.PutPixel( 82 + x,38 + y,208,34,34 );
	gfx.PutPixel( 83 + x,38 + y,208,34,34 );
	gfx.PutPixel( 84 + x,38 + y,208,34,34 );
	gfx.PutPixel( 85 + x,38 + y,208,34,34 );
	gfx.PutPixel( 86 + x,38 + y,208,34,34 );
	gfx.PutPixel( 87 + x,38 + y,208,34,34 );
	gfx.PutPixel( 88 + x,38 + y,208,34,34 );
	gfx.PutPixel( 89 + x,38 + y,208,34,34 );
	gfx.PutPixel( 90 + x,38 + y,208,34,34 );
	gfx.PutPixel( 91 + x,38 + y,208,34,34 );
	gfx.PutPixel( 92 + x,38 + y,208,34,34 );
	gfx.PutPixel( 93 + x,38 + y,208,34,34 );
	gfx.PutPixel( 94 + x,38 + y,208,34,34 );
	gfx.PutPixel( 95 + x,38 + y,208,34,34 );
	gfx.PutPixel( 96 + x,38 + y,208,34,34 );
	gfx.PutPixel( 97 + x,38 + y,208,34,34 );
	gfx.PutPixel( 98 + x,38 + y,208,34,34 );
	gfx.PutPixel( 99 + x,38 + y,208,34,34 );
	gfx.PutPixel( 100 + x,38 + y,208,34,34 );
	gfx.PutPixel( 101 + x,38 + y,208,34,34 );
	gfx.PutPixel( 102 + x,38 + y,208,34,34 );
	gfx.PutPixel( 103 + x,38 + y,208,34,34 );
	gfx.PutPixel( 104 + x,38 + y,208,34,34 );
	gfx.PutPixel( 105 + x,38 + y,208,34,34 );
	gfx.PutPixel( 106 + x,38 + y,208,34,34 );
	gfx.PutPixel( 107 + x,38 + y,208,34,34 );
	gfx.PutPixel( 108 + x,38 + y,208,34,34 );
	gfx.PutPixel( 109 + x,38 + y,208,34,34 );
	gfx.PutPixel( 110 + x,38 + y,208,34,34 );
	gfx.PutPixel( 111 + x,38 + y,208,34,34 );
	gfx.PutPixel( 112 + x,38 + y,208,34,34 );
	gfx.PutPixel( 113 + x,38 + y,208,34,34 );
	gfx.PutPixel( 114 + x,38 + y,208,34,34 );
	gfx.PutPixel( 115 + x,38 + y,208,34,34 );
	gfx.PutPixel( 116 + x,38 + y,208,34,34 );
	gfx.PutPixel( 117 + x,38 + y,208,34,34 );
	gfx.PutPixel( 118 + x,38 + y,208,34,34 );
	gfx.PutPixel( 119 + x,38 + y,208,34,34 );
	gfx.PutPixel( 120 + x,38 + y,208,34,34 );
	gfx.PutPixel( 121 + x,38 + y,208,34,34 );
	gfx.PutPixel( 122 + x,38 + y,208,34,34 );
	gfx.PutPixel( 123 + x,38 + y,208,34,34 );
	gfx.PutPixel( 124 + x,38 + y,208,34,34 );
	gfx.PutPixel( 125 + x,38 + y,208,34,34 );
	gfx.PutPixel( 126 + x,38 + y,208,34,34 );
	gfx.PutPixel( 127 + x,38 + y,208,34,34 );
	gfx.PutPixel( 128 + x,38 + y,208,34,34 );
	gfx.PutPixel( 129 + x,38 + y,208,34,34 );
	gfx.PutPixel( 130 + x,38 + y,208,34,34 );
	gfx.PutPixel( 131 + x,38 + y,208,34,34 );
	gfx.PutPixel( 132 + x,38 + y,208,34,34 );
	gfx.PutPixel( 133 + x,38 + y,208,34,34 );
	gfx.PutPixel( 134 + x,38 + y,208,34,34 );
	gfx.PutPixel( 135 + x,38 + y,208,34,34 );
	gfx.PutPixel( 136 + x,38 + y,208,34,34 );
	gfx.PutPixel( 137 + x,38 + y,208,34,34 );
	gfx.PutPixel( 138 + x,38 + y,208,34,34 );
	gfx.PutPixel( 139 + x,38 + y,208,34,34 );
	gfx.PutPixel( 140 + x,38 + y,208,34,34 );
	gfx.PutPixel( 141 + x,38 + y,208,34,34 );
	gfx.PutPixel( 142 + x,38 + y,208,34,34 );
	gfx.PutPixel( 143 + x,38 + y,208,34,34 );
	gfx.PutPixel( 144 + x,38 + y,208,34,34 );
	gfx.PutPixel( 145 + x,38 + y,208,34,34 );
	gfx.PutPixel( 146 + x,38 + y,208,34,34 );
	gfx.PutPixel( 147 + x,38 + y,208,34,34 );
	gfx.PutPixel( 148 + x,38 + y,208,34,34 );
	gfx.PutPixel( 149 + x,38 + y,208,34,34 );
	gfx.PutPixel( 0 + x,39 + y,208,34,34 );
	gfx.PutPixel( 1 + x,39 + y,208,34,34 );
	gfx.PutPixel( 2 + x,39 + y,208,34,34 );
	gfx.PutPixel( 3 + x,39 + y,208,34,34 );
	gfx.PutPixel( 4 + x,39 + y,208,34,34 );
	gfx.PutPixel( 5 + x,39 + y,208,34,34 );
	gfx.PutPixel( 6 + x,39 + y,208,34,34 );
	gfx.PutPixel( 7 + x,39 + y,208,34,34 );
	gfx.PutPixel( 8 + x,39 + y,208,34,34 );
	gfx.PutPixel( 9 + x,39 + y,208,34,34 );
	gfx.PutPixel( 10 + x,39 + y,208,34,34 );
	gfx.PutPixel( 11 + x,39 + y,208,34,34 );
	gfx.PutPixel( 12 + x,39 + y,208,34,34 );
	gfx.PutPixel( 13 + x,39 + y,208,34,34 );
	gfx.PutPixel( 14 + x,39 + y,208,34,34 );
	gfx.PutPixel( 15 + x,39 + y,208,34,34 );
	gfx.PutPixel( 16 + x,39 + y,208,34,34 );
	gfx.PutPixel( 17 + x,39 + y,208,34,34 );
	gfx.PutPixel( 18 + x,39 + y,208,34,34 );
	gfx.PutPixel( 19 + x,39 + y,208,34,34 );
	gfx.PutPixel( 20 + x,39 + y,208,34,34 );
	gfx.PutPixel( 21 + x,39 + y,208,34,34 );
	gfx.PutPixel( 22 + x,39 + y,208,34,34 );
	gfx.PutPixel( 23 + x,39 + y,208,34,34 );
	gfx.PutPixel( 24 + x,39 + y,208,34,34 );
	gfx.PutPixel( 25 + x,39 + y,208,34,34 );
	gfx.PutPixel( 26 + x,39 + y,208,34,34 );
	gfx.PutPixel( 27 + x,39 + y,208,34,34 );
	gfx.PutPixel( 28 + x,39 + y,208,34,34 );
	gfx.PutPixel( 29 + x,39 + y,208,34,34 );
	gfx.PutPixel( 30 + x,39 + y,208,34,34 );
	gfx.PutPixel( 31 + x,39 + y,208,34,34 );
	gfx.PutPixel( 32 + x,39 + y,208,34,34 );
	gfx.PutPixel( 33 + x,39 + y,208,34,34 );
	gfx.PutPixel( 34 + x,39 + y,208,34,34 );
	gfx.PutPixel( 35 + x,39 + y,208,34,34 );
	gfx.PutPixel( 36 + x,39 + y,208,34,34 );
	gfx.PutPixel( 37 + x,39 + y,208,34,34 );
	gfx.PutPixel( 38 + x,39 + y,208,34,34 );
	gfx.PutPixel( 39 + x,39 + y,208,34,34 );
	gfx.PutPixel( 40 + x,39 + y,208,34,34 );
	gfx.PutPixel( 41 + x,39 + y,208,34,34 );
	gfx.PutPixel( 42 + x,39 + y,208,34,34 );
	gfx.PutPixel( 43 + x,39 + y,208,34,34 );
	gfx.PutPixel( 44 + x,39 + y,208,34,34 );
	gfx.PutPixel( 45 + x,39 + y,208,34,34 );
	gfx.PutPixel( 46 + x,39 + y,208,34,34 );
	gfx.PutPixel( 47 + x,39 + y,208,34,34 );
	gfx.PutPixel( 48 + x,39 + y,208,34,34 );
	gfx.PutPixel( 49 + x,39 + y,208,34,34 );
	gfx.PutPixel( 50 + x,39 + y,208,34,34 );
	gfx.PutPixel( 51 + x,39 + y,208,34,34 );
	gfx.PutPixel( 52 + x,39 + y,208,34,34 );
	gfx.PutPixel( 53 + x,39 + y,208,34,34 );
	gfx.PutPixel( 54 + x,39 + y,208,34,34 );
	gfx.PutPixel( 55 + x,39 + y,208,34,34 );
	gfx.PutPixel( 56 + x,39 + y,208,34,34 );
	gfx.PutPixel( 57 + x,39 + y,208,34,34 );
	gfx.PutPixel( 58 + x,39 + y,208,34,34 );
	gfx.PutPixel( 59 + x,39 + y,208,34,34 );
	gfx.PutPixel( 60 + x,39 + y,208,34,34 );
	gfx.PutPixel( 61 + x,39 + y,208,34,34 );
	gfx.PutPixel( 62 + x,39 + y,208,34,34 );
	gfx.PutPixel( 63 + x,39 + y,208,34,34 );
	gfx.PutPixel( 64 + x,39 + y,208,34,34 );
	gfx.PutPixel( 65 + x,39 + y,208,34,34 );
	gfx.PutPixel( 66 + x,39 + y,208,34,34 );
	gfx.PutPixel( 67 + x,39 + y,208,34,34 );
	gfx.PutPixel( 68 + x,39 + y,208,34,34 );
	gfx.PutPixel( 69 + x,39 + y,208,34,34 );
	gfx.PutPixel( 70 + x,39 + y,208,34,34 );
	gfx.PutPixel( 71 + x,39 + y,208,34,34 );
	gfx.PutPixel( 72 + x,39 + y,208,34,34 );
	gfx.PutPixel( 73 + x,39 + y,208,34,34 );
	gfx.PutPixel( 74 + x,39 + y,208,34,34 );
	gfx.PutPixel( 75 + x,39 + y,208,34,34 );
	gfx.PutPixel( 76 + x,39 + y,208,34,34 );
	gfx.PutPixel( 77 + x,39 + y,208,34,34 );
	gfx.PutPixel( 78 + x,39 + y,208,34,34 );
	gfx.PutPixel( 79 + x,39 + y,208,34,34 );
	gfx.PutPixel( 80 + x,39 + y,208,34,34 );
	gfx.PutPixel( 81 + x,39 + y,208,34,34 );
	gfx.PutPixel( 82 + x,39 + y,208,34,34 );
	gfx.PutPixel( 83 + x,39 + y,208,34,34 );
	gfx.PutPixel( 84 + x,39 + y,208,34,34 );
	gfx.PutPixel( 85 + x,39 + y,208,34,34 );
	gfx.PutPixel( 86 + x,39 + y,208,34,34 );
	gfx.PutPixel( 87 + x,39 + y,208,34,34 );
	gfx.PutPixel( 88 + x,39 + y,208,34,34 );
	gfx.PutPixel( 89 + x,39 + y,208,34,34 );
	gfx.PutPixel( 90 + x,39 + y,208,34,34 );
	gfx.PutPixel( 91 + x,39 + y,208,34,34 );
	gfx.PutPixel( 92 + x,39 + y,208,34,34 );
	gfx.PutPixel( 93 + x,39 + y,208,34,34 );
	gfx.PutPixel( 94 + x,39 + y,208,34,34 );
	gfx.PutPixel( 95 + x,39 + y,208,34,34 );
	gfx.PutPixel( 96 + x,39 + y,208,34,34 );
	gfx.PutPixel( 97 + x,39 + y,208,34,34 );
	gfx.PutPixel( 98 + x,39 + y,208,34,34 );
	gfx.PutPixel( 99 + x,39 + y,208,34,34 );
	gfx.PutPixel( 100 + x,39 + y,208,34,34 );
	gfx.PutPixel( 101 + x,39 + y,208,34,34 );
	gfx.PutPixel( 102 + x,39 + y,208,34,34 );
	gfx.PutPixel( 103 + x,39 + y,208,34,34 );
	gfx.PutPixel( 104 + x,39 + y,208,34,34 );
	gfx.PutPixel( 105 + x,39 + y,208,34,34 );
	gfx.PutPixel( 106 + x,39 + y,208,34,34 );
	gfx.PutPixel( 107 + x,39 + y,208,34,34 );
	gfx.PutPixel( 108 + x,39 + y,208,34,34 );
	gfx.PutPixel( 109 + x,39 + y,208,34,34 );
	gfx.PutPixel( 110 + x,39 + y,208,34,34 );
	gfx.PutPixel( 111 + x,39 + y,208,34,34 );
	gfx.PutPixel( 112 + x,39 + y,208,34,34 );
	gfx.PutPixel( 113 + x,39 + y,208,34,34 );
	gfx.PutPixel( 114 + x,39 + y,208,34,34 );
	gfx.PutPixel( 115 + x,39 + y,208,34,34 );
	gfx.PutPixel( 116 + x,39 + y,208,34,34 );
	gfx.PutPixel( 117 + x,39 + y,208,34,34 );
	gfx.PutPixel( 118 + x,39 + y,208,34,34 );
	gfx.PutPixel( 119 + x,39 + y,208,34,34 );
	gfx.PutPixel( 120 + x,39 + y,208,34,34 );
	gfx.PutPixel( 121 + x,39 + y,208,34,34 );
	gfx.PutPixel( 122 + x,39 + y,208,34,34 );
	gfx.PutPixel( 123 + x,39 + y,208,34,34 );
	gfx.PutPixel( 124 + x,39 + y,208,34,34 );
	gfx.PutPixel( 125 + x,39 + y,208,34,34 );
	gfx.PutPixel( 126 + x,39 + y,208,34,34 );
	gfx.PutPixel( 127 + x,39 + y,208,34,34 );
	gfx.PutPixel( 128 + x,39 + y,208,34,34 );
	gfx.PutPixel( 129 + x,39 + y,208,34,34 );
	gfx.PutPixel( 130 + x,39 + y,208,34,34 );
	gfx.PutPixel( 131 + x,39 + y,208,34,34 );
	gfx.PutPixel( 132 + x,39 + y,208,34,34 );
	gfx.PutPixel( 133 + x,39 + y,208,34,34 );
	gfx.PutPixel( 134 + x,39 + y,208,34,34 );
	gfx.PutPixel( 135 + x,39 + y,208,34,34 );
	gfx.PutPixel( 136 + x,39 + y,208,34,34 );
	gfx.PutPixel( 137 + x,39 + y,208,34,34 );
	gfx.PutPixel( 138 + x,39 + y,208,34,34 );
	gfx.PutPixel( 139 + x,39 + y,208,34,34 );
	gfx.PutPixel( 140 + x,39 + y,208,34,34 );
	gfx.PutPixel( 141 + x,39 + y,208,34,34 );
	gfx.PutPixel( 142 + x,39 + y,208,34,34 );
	gfx.PutPixel( 143 + x,39 + y,208,34,34 );
	gfx.PutPixel( 144 + x,39 + y,208,34,34 );
	gfx.PutPixel( 145 + x,39 + y,208,34,34 );
	gfx.PutPixel( 146 + x,39 + y,208,34,34 );
	gfx.PutPixel( 147 + x,39 + y,208,34,34 );
	gfx.PutPixel( 148 + x,39 + y,208,34,34 );
	gfx.PutPixel( 149 + x,39 + y,208,34,34 );
	gfx.PutPixel( 0 + x,40 + y,208,34,34 );
	gfx.PutPixel( 1 + x,40 + y,208,34,34 );
	gfx.PutPixel( 2 + x,40 + y,208,34,34 );
	gfx.PutPixel( 3 + x,40 + y,208,34,34 );
	gfx.PutPixel( 4 + x,40 + y,208,34,34 );
	gfx.PutPixel( 5 + x,40 + y,208,34,34 );
	gfx.PutPixel( 6 + x,40 + y,208,34,34 );
	gfx.PutPixel( 7 + x,40 + y,208,34,34 );
	gfx.PutPixel( 8 + x,40 + y,208,34,34 );
	gfx.PutPixel( 9 + x,40 + y,208,34,34 );
	gfx.PutPixel( 10 + x,40 + y,208,34,34 );
	gfx.PutPixel( 11 + x,40 + y,208,34,34 );
	gfx.PutPixel( 12 + x,40 + y,208,34,34 );
	gfx.PutPixel( 13 + x,40 + y,208,34,34 );
	gfx.PutPixel( 14 + x,40 + y,208,34,34 );
	gfx.PutPixel( 15 + x,40 + y,208,34,34 );
	gfx.PutPixel( 16 + x,40 + y,208,34,34 );
	gfx.PutPixel( 17 + x,40 + y,208,34,34 );
	gfx.PutPixel( 18 + x,40 + y,208,34,34 );
	gfx.PutPixel( 19 + x,40 + y,208,34,34 );
	gfx.PutPixel( 20 + x,40 + y,208,34,34 );
	gfx.PutPixel( 21 + x,40 + y,208,34,34 );
	gfx.PutPixel( 22 + x,40 + y,208,34,34 );
	gfx.PutPixel( 23 + x,40 + y,208,34,34 );
	gfx.PutPixel( 24 + x,40 + y,208,34,34 );
	gfx.PutPixel( 25 + x,40 + y,208,34,34 );
	gfx.PutPixel( 26 + x,40 + y,208,34,34 );
	gfx.PutPixel( 27 + x,40 + y,208,34,34 );
	gfx.PutPixel( 28 + x,40 + y,208,34,34 );
	gfx.PutPixel( 29 + x,40 + y,208,34,34 );
	gfx.PutPixel( 30 + x,40 + y,208,34,34 );
	gfx.PutPixel( 31 + x,40 + y,208,34,34 );
	gfx.PutPixel( 32 + x,40 + y,208,34,34 );
	gfx.PutPixel( 33 + x,40 + y,208,34,34 );
	gfx.PutPixel( 34 + x,40 + y,208,34,34 );
	gfx.PutPixel( 35 + x,40 + y,208,34,34 );
	gfx.PutPixel( 36 + x,40 + y,208,34,34 );
	gfx.PutPixel( 37 + x,40 + y,208,34,34 );
	gfx.PutPixel( 38 + x,40 + y,208,34,34 );
	gfx.PutPixel( 39 + x,40 + y,208,34,34 );
	gfx.PutPixel( 40 + x,40 + y,208,34,34 );
	gfx.PutPixel( 41 + x,40 + y,208,34,34 );
	gfx.PutPixel( 42 + x,40 + y,208,34,34 );
	gfx.PutPixel( 43 + x,40 + y,208,34,34 );
	gfx.PutPixel( 44 + x,40 + y,208,34,34 );
	gfx.PutPixel( 45 + x,40 + y,208,34,34 );
	gfx.PutPixel( 46 + x,40 + y,208,34,34 );
	gfx.PutPixel( 47 + x,40 + y,208,34,34 );
	gfx.PutPixel( 48 + x,40 + y,208,34,34 );
	gfx.PutPixel( 49 + x,40 + y,208,34,34 );
	gfx.PutPixel( 50 + x,40 + y,208,34,34 );
	gfx.PutPixel( 51 + x,40 + y,208,34,34 );
	gfx.PutPixel( 52 + x,40 + y,208,34,34 );
	gfx.PutPixel( 53 + x,40 + y,208,34,34 );
	gfx.PutPixel( 54 + x,40 + y,208,34,34 );
	gfx.PutPixel( 55 + x,40 + y,208,34,34 );
	gfx.PutPixel( 56 + x,40 + y,208,34,34 );
	gfx.PutPixel( 57 + x,40 + y,208,34,34 );
	gfx.PutPixel( 58 + x,40 + y,208,34,34 );
	gfx.PutPixel( 59 + x,40 + y,208,34,34 );
	gfx.PutPixel( 60 + x,40 + y,208,34,34 );
	gfx.PutPixel( 61 + x,40 + y,208,34,34 );
	gfx.PutPixel( 62 + x,40 + y,208,34,34 );
	gfx.PutPixel( 63 + x,40 + y,208,34,34 );
	gfx.PutPixel( 64 + x,40 + y,208,34,34 );
	gfx.PutPixel( 65 + x,40 + y,208,34,34 );
	gfx.PutPixel( 66 + x,40 + y,208,34,34 );
	gfx.PutPixel( 67 + x,40 + y,208,34,34 );
	gfx.PutPixel( 68 + x,40 + y,208,34,34 );
	gfx.PutPixel( 69 + x,40 + y,208,34,34 );
	gfx.PutPixel( 70 + x,40 + y,208,34,34 );
	gfx.PutPixel( 71 + x,40 + y,208,34,34 );
	gfx.PutPixel( 72 + x,40 + y,208,34,34 );
	gfx.PutPixel( 73 + x,40 + y,208,34,34 );
	gfx.PutPixel( 74 + x,40 + y,208,34,34 );
	gfx.PutPixel( 75 + x,40 + y,208,34,34 );
	gfx.PutPixel( 76 + x,40 + y,208,34,34 );
	gfx.PutPixel( 77 + x,40 + y,208,34,34 );
	gfx.PutPixel( 78 + x,40 + y,208,34,34 );
	gfx.PutPixel( 79 + x,40 + y,208,34,34 );
	gfx.PutPixel( 80 + x,40 + y,208,34,34 );
	gfx.PutPixel( 81 + x,40 + y,208,34,34 );
	gfx.PutPixel( 82 + x,40 + y,208,34,34 );
	gfx.PutPixel( 83 + x,40 + y,208,34,34 );
	gfx.PutPixel( 84 + x,40 + y,208,34,34 );
	gfx.PutPixel( 85 + x,40 + y,208,34,34 );
	gfx.PutPixel( 86 + x,40 + y,208,34,34 );
	gfx.PutPixel( 87 + x,40 + y,208,34,34 );
	gfx.PutPixel( 88 + x,40 + y,208,34,34 );
	gfx.PutPixel( 89 + x,40 + y,208,34,34 );
	gfx.PutPixel( 90 + x,40 + y,208,34,34 );
	gfx.PutPixel( 91 + x,40 + y,208,34,34 );
	gfx.PutPixel( 92 + x,40 + y,208,34,34 );
	gfx.PutPixel( 93 + x,40 + y,208,34,34 );
	gfx.PutPixel( 94 + x,40 + y,208,34,34 );
	gfx.PutPixel( 95 + x,40 + y,208,34,34 );
	gfx.PutPixel( 96 + x,40 + y,208,34,34 );
	gfx.PutPixel( 97 + x,40 + y,208,34,34 );
	gfx.PutPixel( 98 + x,40 + y,208,34,34 );
	gfx.PutPixel( 99 + x,40 + y,208,34,34 );
	gfx.PutPixel( 100 + x,40 + y,208,34,34 );
	gfx.PutPixel( 101 + x,40 + y,208,34,34 );
	gfx.PutPixel( 102 + x,40 + y,208,34,34 );
	gfx.PutPixel( 103 + x,40 + y,208,34,34 );
	gfx.PutPixel( 104 + x,40 + y,208,34,34 );
	gfx.PutPixel( 105 + x,40 + y,208,34,34 );
	gfx.PutPixel( 106 + x,40 + y,208,34,34 );
	gfx.PutPixel( 107 + x,40 + y,208,34,34 );
	gfx.PutPixel( 108 + x,40 + y,208,34,34 );
	gfx.PutPixel( 109 + x,40 + y,208,34,34 );
	gfx.PutPixel( 110 + x,40 + y,208,34,34 );
	gfx.PutPixel( 111 + x,40 + y,208,34,34 );
	gfx.PutPixel( 112 + x,40 + y,208,34,34 );
	gfx.PutPixel( 113 + x,40 + y,208,34,34 );
	gfx.PutPixel( 114 + x,40 + y,208,34,34 );
	gfx.PutPixel( 115 + x,40 + y,208,34,34 );
	gfx.PutPixel( 116 + x,40 + y,208,34,34 );
	gfx.PutPixel( 117 + x,40 + y,208,34,34 );
	gfx.PutPixel( 118 + x,40 + y,208,34,34 );
	gfx.PutPixel( 119 + x,40 + y,208,34,34 );
	gfx.PutPixel( 120 + x,40 + y,208,34,34 );
	gfx.PutPixel( 121 + x,40 + y,208,34,34 );
	gfx.PutPixel( 122 + x,40 + y,208,34,34 );
	gfx.PutPixel( 123 + x,40 + y,208,34,34 );
	gfx.PutPixel( 124 + x,40 + y,208,34,34 );
	gfx.PutPixel( 125 + x,40 + y,208,34,34 );
	gfx.PutPixel( 126 + x,40 + y,208,34,34 );
	gfx.PutPixel( 127 + x,40 + y,208,34,34 );
	gfx.PutPixel( 128 + x,40 + y,208,34,34 );
	gfx.PutPixel( 129 + x,40 + y,208,34,34 );
	gfx.PutPixel( 130 + x,40 + y,208,34,34 );
	gfx.PutPixel( 131 + x,40 + y,208,34,34 );
	gfx.PutPixel( 132 + x,40 + y,208,34,34 );
	gfx.PutPixel( 133 + x,40 + y,208,34,34 );
	gfx.PutPixel( 134 + x,40 + y,208,34,34 );
	gfx.PutPixel( 135 + x,40 + y,208,34,34 );
	gfx.PutPixel( 136 + x,40 + y,208,34,34 );
	gfx.PutPixel( 137 + x,40 + y,208,34,34 );
	gfx.PutPixel( 138 + x,40 + y,208,34,34 );
	gfx.PutPixel( 139 + x,40 + y,208,34,34 );
	gfx.PutPixel( 140 + x,40 + y,208,34,34 );
	gfx.PutPixel( 141 + x,40 + y,208,34,34 );
	gfx.PutPixel( 142 + x,40 + y,208,34,34 );
	gfx.PutPixel( 143 + x,40 + y,208,34,34 );
	gfx.PutPixel( 144 + x,40 + y,208,34,34 );
	gfx.PutPixel( 145 + x,40 + y,208,34,34 );
	gfx.PutPixel( 146 + x,40 + y,208,34,34 );
	gfx.PutPixel( 147 + x,40 + y,208,34,34 );
	gfx.PutPixel( 148 + x,40 + y,208,34,34 );
	gfx.PutPixel( 149 + x,40 + y,208,34,34 );
	gfx.PutPixel( 0 + x,41 + y,208,34,34 );
	gfx.PutPixel( 1 + x,41 + y,208,34,34 );
	gfx.PutPixel( 2 + x,41 + y,208,34,34 );
	gfx.PutPixel( 3 + x,41 + y,208,34,34 );
	gfx.PutPixel( 4 + x,41 + y,208,34,34 );
	gfx.PutPixel( 5 + x,41 + y,208,34,34 );
	gfx.PutPixel( 6 + x,41 + y,208,34,34 );
	gfx.PutPixel( 7 + x,41 + y,208,34,34 );
	gfx.PutPixel( 8 + x,41 + y,208,34,34 );
	gfx.PutPixel( 9 + x,41 + y,208,34,34 );
	gfx.PutPixel( 10 + x,41 + y,208,34,34 );
	gfx.PutPixel( 11 + x,41 + y,208,34,34 );
	gfx.PutPixel( 12 + x,41 + y,208,34,34 );
	gfx.PutPixel( 13 + x,41 + y,208,34,34 );
	gfx.PutPixel( 14 + x,41 + y,208,34,34 );
	gfx.PutPixel( 15 + x,41 + y,208,34,34 );
	gfx.PutPixel( 16 + x,41 + y,208,34,34 );
	gfx.PutPixel( 17 + x,41 + y,208,34,34 );
	gfx.PutPixel( 18 + x,41 + y,208,34,34 );
	gfx.PutPixel( 19 + x,41 + y,208,34,34 );
	gfx.PutPixel( 20 + x,41 + y,208,34,34 );
	gfx.PutPixel( 21 + x,41 + y,208,34,34 );
	gfx.PutPixel( 22 + x,41 + y,208,34,34 );
	gfx.PutPixel( 23 + x,41 + y,208,34,34 );
	gfx.PutPixel( 24 + x,41 + y,208,34,34 );
	gfx.PutPixel( 25 + x,41 + y,208,34,34 );
	gfx.PutPixel( 26 + x,41 + y,208,34,34 );
	gfx.PutPixel( 27 + x,41 + y,208,34,34 );
	gfx.PutPixel( 28 + x,41 + y,208,34,34 );
	gfx.PutPixel( 29 + x,41 + y,208,34,34 );
	gfx.PutPixel( 30 + x,41 + y,208,34,34 );
	gfx.PutPixel( 31 + x,41 + y,208,34,34 );
	gfx.PutPixel( 32 + x,41 + y,208,34,34 );
	gfx.PutPixel( 33 + x,41 + y,208,34,34 );
	gfx.PutPixel( 34 + x,41 + y,208,34,34 );
	gfx.PutPixel( 35 + x,41 + y,208,34,34 );
	gfx.PutPixel( 36 + x,41 + y,208,34,34 );
	gfx.PutPixel( 37 + x,41 + y,208,34,34 );
	gfx.PutPixel( 38 + x,41 + y,208,34,34 );
	gfx.PutPixel( 39 + x,41 + y,208,34,34 );
	gfx.PutPixel( 40 + x,41 + y,208,34,34 );
	gfx.PutPixel( 41 + x,41 + y,208,34,34 );
	gfx.PutPixel( 42 + x,41 + y,208,34,34 );
	gfx.PutPixel( 43 + x,41 + y,208,34,34 );
	gfx.PutPixel( 44 + x,41 + y,208,34,34 );
	gfx.PutPixel( 45 + x,41 + y,208,34,34 );
	gfx.PutPixel( 46 + x,41 + y,208,34,34 );
	gfx.PutPixel( 47 + x,41 + y,208,34,34 );
	gfx.PutPixel( 48 + x,41 + y,208,34,34 );
	gfx.PutPixel( 49 + x,41 + y,208,34,34 );
	gfx.PutPixel( 50 + x,41 + y,208,34,34 );
	gfx.PutPixel( 51 + x,41 + y,208,34,34 );
	gfx.PutPixel( 52 + x,41 + y,208,34,34 );
	gfx.PutPixel( 53 + x,41 + y,208,34,34 );
	gfx.PutPixel( 54 + x,41 + y,208,34,34 );
	gfx.PutPixel( 55 + x,41 + y,208,34,34 );
	gfx.PutPixel( 56 + x,41 + y,208,34,34 );
	gfx.PutPixel( 57 + x,41 + y,208,34,34 );
	gfx.PutPixel( 58 + x,41 + y,208,34,34 );
	gfx.PutPixel( 59 + x,41 + y,208,34,34 );
	gfx.PutPixel( 60 + x,41 + y,208,34,34 );
	gfx.PutPixel( 61 + x,41 + y,208,34,34 );
	gfx.PutPixel( 62 + x,41 + y,208,34,34 );
	gfx.PutPixel( 63 + x,41 + y,208,34,34 );
	gfx.PutPixel( 64 + x,41 + y,208,34,34 );
	gfx.PutPixel( 65 + x,41 + y,208,34,34 );
	gfx.PutPixel( 66 + x,41 + y,208,34,34 );
	gfx.PutPixel( 67 + x,41 + y,208,34,34 );
	gfx.PutPixel( 68 + x,41 + y,208,34,34 );
	gfx.PutPixel( 69 + x,41 + y,208,34,34 );
	gfx.PutPixel( 70 + x,41 + y,208,34,34 );
	gfx.PutPixel( 71 + x,41 + y,208,34,34 );
	gfx.PutPixel( 72 + x,41 + y,208,34,34 );
	gfx.PutPixel( 73 + x,41 + y,208,34,34 );
	gfx.PutPixel( 74 + x,41 + y,208,34,34 );
	gfx.PutPixel( 75 + x,41 + y,208,34,34 );
	gfx.PutPixel( 76 + x,41 + y,208,34,34 );
	gfx.PutPixel( 77 + x,41 + y,208,34,34 );
	gfx.PutPixel( 78 + x,41 + y,208,34,34 );
	gfx.PutPixel( 79 + x,41 + y,208,34,34 );
	gfx.PutPixel( 80 + x,41 + y,208,34,34 );
	gfx.PutPixel( 81 + x,41 + y,208,34,34 );
	gfx.PutPixel( 82 + x,41 + y,208,34,34 );
	gfx.PutPixel( 83 + x,41 + y,208,34,34 );
	gfx.PutPixel( 84 + x,41 + y,208,34,34 );
	gfx.PutPixel( 85 + x,41 + y,208,34,34 );
	gfx.PutPixel( 86 + x,41 + y,208,34,34 );
	gfx.PutPixel( 87 + x,41 + y,208,34,34 );
	gfx.PutPixel( 88 + x,41 + y,208,34,34 );
	gfx.PutPixel( 89 + x,41 + y,208,34,34 );
	gfx.PutPixel( 90 + x,41 + y,208,34,34 );
	gfx.PutPixel( 91 + x,41 + y,208,34,34 );
	gfx.PutPixel( 92 + x,41 + y,208,34,34 );
	gfx.PutPixel( 93 + x,41 + y,208,34,34 );
	gfx.PutPixel( 94 + x,41 + y,208,34,34 );
	gfx.PutPixel( 95 + x,41 + y,208,34,34 );
	gfx.PutPixel( 96 + x,41 + y,208,34,34 );
	gfx.PutPixel( 97 + x,41 + y,208,34,34 );
	gfx.PutPixel( 98 + x,41 + y,208,34,34 );
	gfx.PutPixel( 99 + x,41 + y,208,34,34 );
	gfx.PutPixel( 100 + x,41 + y,208,34,34 );
	gfx.PutPixel( 101 + x,41 + y,208,34,34 );
	gfx.PutPixel( 102 + x,41 + y,208,34,34 );
	gfx.PutPixel( 103 + x,41 + y,208,34,34 );
	gfx.PutPixel( 104 + x,41 + y,208,34,34 );
	gfx.PutPixel( 105 + x,41 + y,208,34,34 );
	gfx.PutPixel( 106 + x,41 + y,208,34,34 );
	gfx.PutPixel( 107 + x,41 + y,208,34,34 );
	gfx.PutPixel( 108 + x,41 + y,208,34,34 );
	gfx.PutPixel( 109 + x,41 + y,208,34,34 );
	gfx.PutPixel( 110 + x,41 + y,208,34,34 );
	gfx.PutPixel( 111 + x,41 + y,208,34,34 );
	gfx.PutPixel( 112 + x,41 + y,208,34,34 );
	gfx.PutPixel( 113 + x,41 + y,208,34,34 );
	gfx.PutPixel( 114 + x,41 + y,208,34,34 );
	gfx.PutPixel( 115 + x,41 + y,208,34,34 );
	gfx.PutPixel( 116 + x,41 + y,208,34,34 );
	gfx.PutPixel( 117 + x,41 + y,208,34,34 );
	gfx.PutPixel( 118 + x,41 + y,208,34,34 );
	gfx.PutPixel( 119 + x,41 + y,208,34,34 );
	gfx.PutPixel( 120 + x,41 + y,208,34,34 );
	gfx.PutPixel( 121 + x,41 + y,208,34,34 );
	gfx.PutPixel( 122 + x,41 + y,208,34,34 );
	gfx.PutPixel( 123 + x,41 + y,208,34,34 );
	gfx.PutPixel( 124 + x,41 + y,208,34,34 );
	gfx.PutPixel( 125 + x,41 + y,208,34,34 );
	gfx.PutPixel( 126 + x,41 + y,208,34,34 );
	gfx.PutPixel( 127 + x,41 + y,208,34,34 );
	gfx.PutPixel( 128 + x,41 + y,208,34,34 );
	gfx.PutPixel( 129 + x,41 + y,208,34,34 );
	gfx.PutPixel( 130 + x,41 + y,208,34,34 );
	gfx.PutPixel( 131 + x,41 + y,208,34,34 );
	gfx.PutPixel( 132 + x,41 + y,208,34,34 );
	gfx.PutPixel( 133 + x,41 + y,208,34,34 );
	gfx.PutPixel( 134 + x,41 + y,208,34,34 );
	gfx.PutPixel( 135 + x,41 + y,208,34,34 );
	gfx.PutPixel( 136 + x,41 + y,208,34,34 );
	gfx.PutPixel( 137 + x,41 + y,208,34,34 );
	gfx.PutPixel( 138 + x,41 + y,208,34,34 );
	gfx.PutPixel( 139 + x,41 + y,208,34,34 );
	gfx.PutPixel( 140 + x,41 + y,208,34,34 );
	gfx.PutPixel( 141 + x,41 + y,208,34,34 );
	gfx.PutPixel( 142 + x,41 + y,208,34,34 );
	gfx.PutPixel( 143 + x,41 + y,208,34,34 );
	gfx.PutPixel( 144 + x,41 + y,208,34,34 );
	gfx.PutPixel( 145 + x,41 + y,208,34,34 );
	gfx.PutPixel( 146 + x,41 + y,208,34,34 );
	gfx.PutPixel( 147 + x,41 + y,208,34,34 );
	gfx.PutPixel( 148 + x,41 + y,208,34,34 );
	gfx.PutPixel( 149 + x,41 + y,208,34,34 );
	gfx.PutPixel( 0 + x,42 + y,208,34,34 );
	gfx.PutPixel( 1 + x,42 + y,208,34,34 );
	gfx.PutPixel( 2 + x,42 + y,208,34,34 );
	gfx.PutPixel( 3 + x,42 + y,208,34,34 );
	gfx.PutPixel( 4 + x,42 + y,208,34,34 );
	gfx.PutPixel( 5 + x,42 + y,208,34,34 );
	gfx.PutPixel( 6 + x,42 + y,208,34,34 );
	gfx.PutPixel( 7 + x,42 + y,208,34,34 );
	gfx.PutPixel( 8 + x,42 + y,208,34,34 );
	gfx.PutPixel( 9 + x,42 + y,208,34,34 );
	gfx.PutPixel( 10 + x,42 + y,208,34,34 );
	gfx.PutPixel( 11 + x,42 + y,208,34,34 );
	gfx.PutPixel( 12 + x,42 + y,208,34,34 );
	gfx.PutPixel( 13 + x,42 + y,208,34,34 );
	gfx.PutPixel( 14 + x,42 + y,208,34,34 );
	gfx.PutPixel( 15 + x,42 + y,208,34,34 );
	gfx.PutPixel( 16 + x,42 + y,208,34,34 );
	gfx.PutPixel( 17 + x,42 + y,208,34,34 );
	gfx.PutPixel( 18 + x,42 + y,208,34,34 );
	gfx.PutPixel( 19 + x,42 + y,208,34,34 );
	gfx.PutPixel( 20 + x,42 + y,208,34,34 );
	gfx.PutPixel( 21 + x,42 + y,208,34,34 );
	gfx.PutPixel( 22 + x,42 + y,208,34,34 );
	gfx.PutPixel( 23 + x,42 + y,208,34,34 );
	gfx.PutPixel( 24 + x,42 + y,208,34,34 );
	gfx.PutPixel( 25 + x,42 + y,208,34,34 );
	gfx.PutPixel( 26 + x,42 + y,208,34,34 );
	gfx.PutPixel( 27 + x,42 + y,208,34,34 );
	gfx.PutPixel( 28 + x,42 + y,208,34,34 );
	gfx.PutPixel( 29 + x,42 + y,208,34,34 );
	gfx.PutPixel( 30 + x,42 + y,208,34,34 );
	gfx.PutPixel( 31 + x,42 + y,208,34,34 );
	gfx.PutPixel( 32 + x,42 + y,208,34,34 );
	gfx.PutPixel( 33 + x,42 + y,208,34,34 );
	gfx.PutPixel( 34 + x,42 + y,208,34,34 );
	gfx.PutPixel( 35 + x,42 + y,208,34,34 );
	gfx.PutPixel( 36 + x,42 + y,208,34,34 );
	gfx.PutPixel( 37 + x,42 + y,208,34,34 );
	gfx.PutPixel( 38 + x,42 + y,208,34,34 );
	gfx.PutPixel( 39 + x,42 + y,208,34,34 );
	gfx.PutPixel( 40 + x,42 + y,208,34,34 );
	gfx.PutPixel( 41 + x,42 + y,208,34,34 );
	gfx.PutPixel( 42 + x,42 + y,208,34,34 );
	gfx.PutPixel( 43 + x,42 + y,208,34,34 );
	gfx.PutPixel( 44 + x,42 + y,208,34,34 );
	gfx.PutPixel( 45 + x,42 + y,208,34,34 );
	gfx.PutPixel( 46 + x,42 + y,208,34,34 );
	gfx.PutPixel( 47 + x,42 + y,208,34,34 );
	gfx.PutPixel( 48 + x,42 + y,208,34,34 );
	gfx.PutPixel( 49 + x,42 + y,208,34,34 );
	gfx.PutPixel( 50 + x,42 + y,208,34,34 );
	gfx.PutPixel( 51 + x,42 + y,208,34,34 );
	gfx.PutPixel( 52 + x,42 + y,208,34,34 );
	gfx.PutPixel( 53 + x,42 + y,208,34,34 );
	gfx.PutPixel( 54 + x,42 + y,208,34,34 );
	gfx.PutPixel( 55 + x,42 + y,208,34,34 );
	gfx.PutPixel( 56 + x,42 + y,208,34,34 );
	gfx.PutPixel( 57 + x,42 + y,208,34,34 );
	gfx.PutPixel( 58 + x,42 + y,208,34,34 );
	gfx.PutPixel( 59 + x,42 + y,208,34,34 );
	gfx.PutPixel( 60 + x,42 + y,208,34,34 );
	gfx.PutPixel( 61 + x,42 + y,208,34,34 );
	gfx.PutPixel( 62 + x,42 + y,208,34,34 );
	gfx.PutPixel( 63 + x,42 + y,208,34,34 );
	gfx.PutPixel( 64 + x,42 + y,208,34,34 );
	gfx.PutPixel( 65 + x,42 + y,208,34,34 );
	gfx.PutPixel( 66 + x,42 + y,208,34,34 );
	gfx.PutPixel( 67 + x,42 + y,208,34,34 );
	gfx.PutPixel( 68 + x,42 + y,208,34,34 );
	gfx.PutPixel( 69 + x,42 + y,208,34,34 );
	gfx.PutPixel( 70 + x,42 + y,208,34,34 );
	gfx.PutPixel( 71 + x,42 + y,208,34,34 );
	gfx.PutPixel( 72 + x,42 + y,208,34,34 );
	gfx.PutPixel( 73 + x,42 + y,208,34,34 );
	gfx.PutPixel( 74 + x,42 + y,208,34,34 );
	gfx.PutPixel( 75 + x,42 + y,208,34,34 );
	gfx.PutPixel( 76 + x,42 + y,208,34,34 );
	gfx.PutPixel( 77 + x,42 + y,208,34,34 );
	gfx.PutPixel( 78 + x,42 + y,208,34,34 );
	gfx.PutPixel( 79 + x,42 + y,208,34,34 );
	gfx.PutPixel( 80 + x,42 + y,208,34,34 );
	gfx.PutPixel( 81 + x,42 + y,208,34,34 );
	gfx.PutPixel( 82 + x,42 + y,208,34,34 );
	gfx.PutPixel( 83 + x,42 + y,208,34,34 );
	gfx.PutPixel( 84 + x,42 + y,208,34,34 );
	gfx.PutPixel( 85 + x,42 + y,208,34,34 );
	gfx.PutPixel( 86 + x,42 + y,208,34,34 );
	gfx.PutPixel( 87 + x,42 + y,208,34,34 );
	gfx.PutPixel( 88 + x,42 + y,208,34,34 );
	gfx.PutPixel( 89 + x,42 + y,208,34,34 );
	gfx.PutPixel( 90 + x,42 + y,208,34,34 );
	gfx.PutPixel( 91 + x,42 + y,208,34,34 );
	gfx.PutPixel( 92 + x,42 + y,208,34,34 );
	gfx.PutPixel( 93 + x,42 + y,208,34,34 );
	gfx.PutPixel( 94 + x,42 + y,208,34,34 );
	gfx.PutPixel( 95 + x,42 + y,208,34,34 );
	gfx.PutPixel( 96 + x,42 + y,208,34,34 );
	gfx.PutPixel( 97 + x,42 + y,208,34,34 );
	gfx.PutPixel( 98 + x,42 + y,208,34,34 );
	gfx.PutPixel( 99 + x,42 + y,208,34,34 );
	gfx.PutPixel( 100 + x,42 + y,208,34,34 );
	gfx.PutPixel( 101 + x,42 + y,208,34,34 );
	gfx.PutPixel( 102 + x,42 + y,208,34,34 );
	gfx.PutPixel( 103 + x,42 + y,208,34,34 );
	gfx.PutPixel( 104 + x,42 + y,208,34,34 );
	gfx.PutPixel( 105 + x,42 + y,208,34,34 );
	gfx.PutPixel( 106 + x,42 + y,208,34,34 );
	gfx.PutPixel( 107 + x,42 + y,208,34,34 );
	gfx.PutPixel( 108 + x,42 + y,208,34,34 );
	gfx.PutPixel( 109 + x,42 + y,208,34,34 );
	gfx.PutPixel( 110 + x,42 + y,208,34,34 );
	gfx.PutPixel( 111 + x,42 + y,208,34,34 );
	gfx.PutPixel( 112 + x,42 + y,208,34,34 );
	gfx.PutPixel( 113 + x,42 + y,208,34,34 );
	gfx.PutPixel( 114 + x,42 + y,208,34,34 );
	gfx.PutPixel( 115 + x,42 + y,208,34,34 );
	gfx.PutPixel( 116 + x,42 + y,208,34,34 );
	gfx.PutPixel( 117 + x,42 + y,208,34,34 );
	gfx.PutPixel( 118 + x,42 + y,208,34,34 );
	gfx.PutPixel( 119 + x,42 + y,208,34,34 );
	gfx.PutPixel( 120 + x,42 + y,208,34,34 );
	gfx.PutPixel( 121 + x,42 + y,208,34,34 );
	gfx.PutPixel( 122 + x,42 + y,208,34,34 );
	gfx.PutPixel( 123 + x,42 + y,208,34,34 );
	gfx.PutPixel( 124 + x,42 + y,208,34,34 );
	gfx.PutPixel( 125 + x,42 + y,208,34,34 );
	gfx.PutPixel( 126 + x,42 + y,208,34,34 );
	gfx.PutPixel( 127 + x,42 + y,208,34,34 );
	gfx.PutPixel( 128 + x,42 + y,208,34,34 );
	gfx.PutPixel( 129 + x,42 + y,208,34,34 );
	gfx.PutPixel( 130 + x,42 + y,208,34,34 );
	gfx.PutPixel( 131 + x,42 + y,208,34,34 );
	gfx.PutPixel( 132 + x,42 + y,208,34,34 );
	gfx.PutPixel( 133 + x,42 + y,208,34,34 );
	gfx.PutPixel( 134 + x,42 + y,208,34,34 );
	gfx.PutPixel( 135 + x,42 + y,208,34,34 );
	gfx.PutPixel( 136 + x,42 + y,208,34,34 );
	gfx.PutPixel( 137 + x,42 + y,208,34,34 );
	gfx.PutPixel( 138 + x,42 + y,208,34,34 );
	gfx.PutPixel( 139 + x,42 + y,208,34,34 );
	gfx.PutPixel( 140 + x,42 + y,208,34,34 );
	gfx.PutPixel( 141 + x,42 + y,208,34,34 );
	gfx.PutPixel( 142 + x,42 + y,208,34,34 );
	gfx.PutPixel( 143 + x,42 + y,208,34,34 );
	gfx.PutPixel( 144 + x,42 + y,208,34,34 );
	gfx.PutPixel( 145 + x,42 + y,208,34,34 );
	gfx.PutPixel( 146 + x,42 + y,208,34,34 );
	gfx.PutPixel( 147 + x,42 + y,208,34,34 );
	gfx.PutPixel( 148 + x,42 + y,208,34,34 );
	gfx.PutPixel( 149 + x,42 + y,208,34,34 );
	gfx.PutPixel( 0 + x,43 + y,208,34,34 );
	gfx.PutPixel( 1 + x,43 + y,208,34,34 );
	gfx.PutPixel( 2 + x,43 + y,208,34,34 );
	gfx.PutPixel( 3 + x,43 + y,208,34,34 );
	gfx.PutPixel( 4 + x,43 + y,208,34,34 );
	gfx.PutPixel( 5 + x,43 + y,208,34,34 );
	gfx.PutPixel( 6 + x,43 + y,208,34,34 );
	gfx.PutPixel( 7 + x,43 + y,208,34,34 );
	gfx.PutPixel( 8 + x,43 + y,208,34,34 );
	gfx.PutPixel( 9 + x,43 + y,208,34,34 );
	gfx.PutPixel( 10 + x,43 + y,208,34,34 );
	gfx.PutPixel( 11 + x,43 + y,208,34,34 );
	gfx.PutPixel( 12 + x,43 + y,208,34,34 );
	gfx.PutPixel( 13 + x,43 + y,208,34,34 );
	gfx.PutPixel( 14 + x,43 + y,208,34,34 );
	gfx.PutPixel( 15 + x,43 + y,208,34,34 );
	gfx.PutPixel( 16 + x,43 + y,208,34,34 );
	gfx.PutPixel( 17 + x,43 + y,208,34,34 );
	gfx.PutPixel( 18 + x,43 + y,208,34,34 );
	gfx.PutPixel( 19 + x,43 + y,208,34,34 );
	gfx.PutPixel( 20 + x,43 + y,208,34,34 );
	gfx.PutPixel( 21 + x,43 + y,208,34,34 );
	gfx.PutPixel( 22 + x,43 + y,208,34,34 );
	gfx.PutPixel( 23 + x,43 + y,208,34,34 );
	gfx.PutPixel( 24 + x,43 + y,208,34,34 );
	gfx.PutPixel( 25 + x,43 + y,208,34,34 );
	gfx.PutPixel( 26 + x,43 + y,208,34,34 );
	gfx.PutPixel( 27 + x,43 + y,208,34,34 );
	gfx.PutPixel( 28 + x,43 + y,208,34,34 );
	gfx.PutPixel( 29 + x,43 + y,208,34,34 );
	gfx.PutPixel( 30 + x,43 + y,208,34,34 );
	gfx.PutPixel( 31 + x,43 + y,208,34,34 );
	gfx.PutPixel( 32 + x,43 + y,208,34,34 );
	gfx.PutPixel( 33 + x,43 + y,208,34,34 );
	gfx.PutPixel( 34 + x,43 + y,208,34,34 );
	gfx.PutPixel( 35 + x,43 + y,208,34,34 );
	gfx.PutPixel( 36 + x,43 + y,208,34,34 );
	gfx.PutPixel( 37 + x,43 + y,208,34,34 );
	gfx.PutPixel( 38 + x,43 + y,208,34,34 );
	gfx.PutPixel( 39 + x,43 + y,208,34,34 );
	gfx.PutPixel( 40 + x,43 + y,208,34,34 );
	gfx.PutPixel( 41 + x,43 + y,208,34,34 );
	gfx.PutPixel( 42 + x,43 + y,208,34,34 );
	gfx.PutPixel( 43 + x,43 + y,208,34,34 );
	gfx.PutPixel( 44 + x,43 + y,208,34,34 );
	gfx.PutPixel( 45 + x,43 + y,208,34,34 );
	gfx.PutPixel( 46 + x,43 + y,208,34,34 );
	gfx.PutPixel( 47 + x,43 + y,208,34,34 );
	gfx.PutPixel( 48 + x,43 + y,208,34,34 );
	gfx.PutPixel( 49 + x,43 + y,208,34,34 );
	gfx.PutPixel( 50 + x,43 + y,208,34,34 );
	gfx.PutPixel( 51 + x,43 + y,208,34,34 );
	gfx.PutPixel( 52 + x,43 + y,208,34,34 );
	gfx.PutPixel( 53 + x,43 + y,208,34,34 );
	gfx.PutPixel( 54 + x,43 + y,208,34,34 );
	gfx.PutPixel( 55 + x,43 + y,208,34,34 );
	gfx.PutPixel( 56 + x,43 + y,208,34,34 );
	gfx.PutPixel( 57 + x,43 + y,208,34,34 );
	gfx.PutPixel( 58 + x,43 + y,208,34,34 );
	gfx.PutPixel( 59 + x,43 + y,208,34,34 );
	gfx.PutPixel( 60 + x,43 + y,208,34,34 );
	gfx.PutPixel( 61 + x,43 + y,208,34,34 );
	gfx.PutPixel( 62 + x,43 + y,208,34,34 );
	gfx.PutPixel( 63 + x,43 + y,208,34,34 );
	gfx.PutPixel( 64 + x,43 + y,208,34,34 );
	gfx.PutPixel( 65 + x,43 + y,208,34,34 );
	gfx.PutPixel( 66 + x,43 + y,208,34,34 );
	gfx.PutPixel( 67 + x,43 + y,208,34,34 );
	gfx.PutPixel( 68 + x,43 + y,208,34,34 );
	gfx.PutPixel( 69 + x,43 + y,208,34,34 );
	gfx.PutPixel( 70 + x,43 + y,208,34,34 );
	gfx.PutPixel( 71 + x,43 + y,208,34,34 );
	gfx.PutPixel( 72 + x,43 + y,208,34,34 );
	gfx.PutPixel( 73 + x,43 + y,208,34,34 );
	gfx.PutPixel( 74 + x,43 + y,208,34,34 );
	gfx.PutPixel( 75 + x,43 + y,208,34,34 );
	gfx.PutPixel( 76 + x,43 + y,208,34,34 );
	gfx.PutPixel( 77 + x,43 + y,208,34,34 );
	gfx.PutPixel( 78 + x,43 + y,208,34,34 );
	gfx.PutPixel( 79 + x,43 + y,208,34,34 );
	gfx.PutPixel( 80 + x,43 + y,208,34,34 );
	gfx.PutPixel( 81 + x,43 + y,208,34,34 );
	gfx.PutPixel( 82 + x,43 + y,208,34,34 );
	gfx.PutPixel( 83 + x,43 + y,208,34,34 );
	gfx.PutPixel( 84 + x,43 + y,208,34,34 );
	gfx.PutPixel( 85 + x,43 + y,208,34,34 );
	gfx.PutPixel( 86 + x,43 + y,208,34,34 );
	gfx.PutPixel( 87 + x,43 + y,208,34,34 );
	gfx.PutPixel( 88 + x,43 + y,208,34,34 );
	gfx.PutPixel( 89 + x,43 + y,208,34,34 );
	gfx.PutPixel( 90 + x,43 + y,208,34,34 );
	gfx.PutPixel( 91 + x,43 + y,208,34,34 );
	gfx.PutPixel( 92 + x,43 + y,208,34,34 );
	gfx.PutPixel( 93 + x,43 + y,208,34,34 );
	gfx.PutPixel( 94 + x,43 + y,208,34,34 );
	gfx.PutPixel( 95 + x,43 + y,208,34,34 );
	gfx.PutPixel( 96 + x,43 + y,208,34,34 );
	gfx.PutPixel( 97 + x,43 + y,208,34,34 );
	gfx.PutPixel( 98 + x,43 + y,208,34,34 );
	gfx.PutPixel( 99 + x,43 + y,208,34,34 );
	gfx.PutPixel( 100 + x,43 + y,208,34,34 );
	gfx.PutPixel( 101 + x,43 + y,208,34,34 );
	gfx.PutPixel( 102 + x,43 + y,208,34,34 );
	gfx.PutPixel( 103 + x,43 + y,208,34,34 );
	gfx.PutPixel( 104 + x,43 + y,208,34,34 );
	gfx.PutPixel( 105 + x,43 + y,208,34,34 );
	gfx.PutPixel( 106 + x,43 + y,208,34,34 );
	gfx.PutPixel( 107 + x,43 + y,208,34,34 );
	gfx.PutPixel( 108 + x,43 + y,208,34,34 );
	gfx.PutPixel( 109 + x,43 + y,208,34,34 );
	gfx.PutPixel( 110 + x,43 + y,208,34,34 );
	gfx.PutPixel( 111 + x,43 + y,208,34,34 );
	gfx.PutPixel( 112 + x,43 + y,208,34,34 );
	gfx.PutPixel( 113 + x,43 + y,208,34,34 );
	gfx.PutPixel( 114 + x,43 + y,208,34,34 );
	gfx.PutPixel( 115 + x,43 + y,208,34,34 );
	gfx.PutPixel( 116 + x,43 + y,208,34,34 );
	gfx.PutPixel( 117 + x,43 + y,208,34,34 );
	gfx.PutPixel( 118 + x,43 + y,208,34,34 );
	gfx.PutPixel( 119 + x,43 + y,208,34,34 );
	gfx.PutPixel( 120 + x,43 + y,208,34,34 );
	gfx.PutPixel( 121 + x,43 + y,208,34,34 );
	gfx.PutPixel( 122 + x,43 + y,208,34,34 );
	gfx.PutPixel( 123 + x,43 + y,208,34,34 );
	gfx.PutPixel( 124 + x,43 + y,208,34,34 );
	gfx.PutPixel( 125 + x,43 + y,208,34,34 );
	gfx.PutPixel( 126 + x,43 + y,208,34,34 );
	gfx.PutPixel( 127 + x,43 + y,208,34,34 );
	gfx.PutPixel( 128 + x,43 + y,208,34,34 );
	gfx.PutPixel( 129 + x,43 + y,208,34,34 );
	gfx.PutPixel( 130 + x,43 + y,208,34,34 );
	gfx.PutPixel( 131 + x,43 + y,208,34,34 );
	gfx.PutPixel( 132 + x,43 + y,208,34,34 );
	gfx.PutPixel( 133 + x,43 + y,208,34,34 );
	gfx.PutPixel( 134 + x,43 + y,208,34,34 );
	gfx.PutPixel( 135 + x,43 + y,208,34,34 );
	gfx.PutPixel( 136 + x,43 + y,208,34,34 );
	gfx.PutPixel( 137 + x,43 + y,208,34,34 );
	gfx.PutPixel( 138 + x,43 + y,208,34,34 );
	gfx.PutPixel( 139 + x,43 + y,208,34,34 );
	gfx.PutPixel( 140 + x,43 + y,208,34,34 );
	gfx.PutPixel( 141 + x,43 + y,208,34,34 );
	gfx.PutPixel( 142 + x,43 + y,208,34,34 );
	gfx.PutPixel( 143 + x,43 + y,208,34,34 );
	gfx.PutPixel( 144 + x,43 + y,208,34,34 );
	gfx.PutPixel( 145 + x,43 + y,208,34,34 );
	gfx.PutPixel( 146 + x,43 + y,208,34,34 );
	gfx.PutPixel( 147 + x,43 + y,208,34,34 );
	gfx.PutPixel( 148 + x,43 + y,208,34,34 );
	gfx.PutPixel( 149 + x,43 + y,208,34,34 );
	gfx.PutPixel( 0 + x,44 + y,208,34,34 );
	gfx.PutPixel( 1 + x,44 + y,208,34,34 );
	gfx.PutPixel( 2 + x,44 + y,208,34,34 );
	gfx.PutPixel( 3 + x,44 + y,208,34,34 );
	gfx.PutPixel( 4 + x,44 + y,208,34,34 );
	gfx.PutPixel( 5 + x,44 + y,208,34,34 );
	gfx.PutPixel( 6 + x,44 + y,208,34,34 );
	gfx.PutPixel( 7 + x,44 + y,208,34,34 );
	gfx.PutPixel( 8 + x,44 + y,208,34,34 );
	gfx.PutPixel( 9 + x,44 + y,208,34,34 );
	gfx.PutPixel( 10 + x,44 + y,208,34,34 );
	gfx.PutPixel( 11 + x,44 + y,208,34,34 );
	gfx.PutPixel( 12 + x,44 + y,208,34,34 );
	gfx.PutPixel( 13 + x,44 + y,208,34,34 );
	gfx.PutPixel( 14 + x,44 + y,208,34,34 );
	gfx.PutPixel( 15 + x,44 + y,208,34,34 );
	gfx.PutPixel( 16 + x,44 + y,208,34,34 );
	gfx.PutPixel( 17 + x,44 + y,208,34,34 );
	gfx.PutPixel( 18 + x,44 + y,208,34,34 );
	gfx.PutPixel( 19 + x,44 + y,208,34,34 );
	gfx.PutPixel( 20 + x,44 + y,208,34,34 );
	gfx.PutPixel( 21 + x,44 + y,208,34,34 );
	gfx.PutPixel( 22 + x,44 + y,208,34,34 );
	gfx.PutPixel( 23 + x,44 + y,208,34,34 );
	gfx.PutPixel( 24 + x,44 + y,208,34,34 );
	gfx.PutPixel( 25 + x,44 + y,208,34,34 );
	gfx.PutPixel( 26 + x,44 + y,208,34,34 );
	gfx.PutPixel( 27 + x,44 + y,208,34,34 );
	gfx.PutPixel( 28 + x,44 + y,208,34,34 );
	gfx.PutPixel( 29 + x,44 + y,208,34,34 );
	gfx.PutPixel( 30 + x,44 + y,208,34,34 );
	gfx.PutPixel( 31 + x,44 + y,208,34,34 );
	gfx.PutPixel( 32 + x,44 + y,208,34,34 );
	gfx.PutPixel( 33 + x,44 + y,208,34,34 );
	gfx.PutPixel( 34 + x,44 + y,208,34,34 );
	gfx.PutPixel( 35 + x,44 + y,208,34,34 );
	gfx.PutPixel( 36 + x,44 + y,208,34,34 );
	gfx.PutPixel( 37 + x,44 + y,208,34,34 );
	gfx.PutPixel( 38 + x,44 + y,208,34,34 );
	gfx.PutPixel( 39 + x,44 + y,208,34,34 );
	gfx.PutPixel( 40 + x,44 + y,208,34,34 );
	gfx.PutPixel( 41 + x,44 + y,208,34,34 );
	gfx.PutPixel( 42 + x,44 + y,208,34,34 );
	gfx.PutPixel( 43 + x,44 + y,208,34,34 );
	gfx.PutPixel( 44 + x,44 + y,208,34,34 );
	gfx.PutPixel( 45 + x,44 + y,208,34,34 );
	gfx.PutPixel( 46 + x,44 + y,208,34,34 );
	gfx.PutPixel( 47 + x,44 + y,208,34,34 );
	gfx.PutPixel( 48 + x,44 + y,208,34,34 );
	gfx.PutPixel( 49 + x,44 + y,208,34,34 );
	gfx.PutPixel( 50 + x,44 + y,208,34,34 );
	gfx.PutPixel( 51 + x,44 + y,208,34,34 );
	gfx.PutPixel( 52 + x,44 + y,208,34,34 );
	gfx.PutPixel( 53 + x,44 + y,208,34,34 );
	gfx.PutPixel( 54 + x,44 + y,208,34,34 );
	gfx.PutPixel( 55 + x,44 + y,208,34,34 );
	gfx.PutPixel( 56 + x,44 + y,208,34,34 );
	gfx.PutPixel( 57 + x,44 + y,208,34,34 );
	gfx.PutPixel( 58 + x,44 + y,208,34,34 );
	gfx.PutPixel( 59 + x,44 + y,208,34,34 );
	gfx.PutPixel( 60 + x,44 + y,208,34,34 );
	gfx.PutPixel( 61 + x,44 + y,208,34,34 );
	gfx.PutPixel( 62 + x,44 + y,208,34,34 );
	gfx.PutPixel( 63 + x,44 + y,208,34,34 );
	gfx.PutPixel( 64 + x,44 + y,208,34,34 );
	gfx.PutPixel( 65 + x,44 + y,208,34,34 );
	gfx.PutPixel( 66 + x,44 + y,208,34,34 );
	gfx.PutPixel( 67 + x,44 + y,208,34,34 );
	gfx.PutPixel( 68 + x,44 + y,208,34,34 );
	gfx.PutPixel( 69 + x,44 + y,208,34,34 );
	gfx.PutPixel( 70 + x,44 + y,208,34,34 );
	gfx.PutPixel( 71 + x,44 + y,208,34,34 );
	gfx.PutPixel( 72 + x,44 + y,208,34,34 );
	gfx.PutPixel( 73 + x,44 + y,208,34,34 );
	gfx.PutPixel( 74 + x,44 + y,208,34,34 );
	gfx.PutPixel( 75 + x,44 + y,208,34,34 );
	gfx.PutPixel( 76 + x,44 + y,208,34,34 );
	gfx.PutPixel( 77 + x,44 + y,208,34,34 );
	gfx.PutPixel( 78 + x,44 + y,208,34,34 );
	gfx.PutPixel( 79 + x,44 + y,208,34,34 );
	gfx.PutPixel( 80 + x,44 + y,208,34,34 );
	gfx.PutPixel( 81 + x,44 + y,208,34,34 );
	gfx.PutPixel( 82 + x,44 + y,208,34,34 );
	gfx.PutPixel( 83 + x,44 + y,208,34,34 );
	gfx.PutPixel( 84 + x,44 + y,208,34,34 );
	gfx.PutPixel( 85 + x,44 + y,208,34,34 );
	gfx.PutPixel( 86 + x,44 + y,208,34,34 );
	gfx.PutPixel( 87 + x,44 + y,208,34,34 );
	gfx.PutPixel( 88 + x,44 + y,208,34,34 );
	gfx.PutPixel( 89 + x,44 + y,208,34,34 );
	gfx.PutPixel( 90 + x,44 + y,208,34,34 );
	gfx.PutPixel( 91 + x,44 + y,208,34,34 );
	gfx.PutPixel( 92 + x,44 + y,208,34,34 );
	gfx.PutPixel( 93 + x,44 + y,208,34,34 );
	gfx.PutPixel( 94 + x,44 + y,208,34,34 );
	gfx.PutPixel( 95 + x,44 + y,208,34,34 );
	gfx.PutPixel( 96 + x,44 + y,208,34,34 );
	gfx.PutPixel( 97 + x,44 + y,208,34,34 );
	gfx.PutPixel( 98 + x,44 + y,208,34,34 );
	gfx.PutPixel( 99 + x,44 + y,208,34,34 );
	gfx.PutPixel( 100 + x,44 + y,208,34,34 );
	gfx.PutPixel( 101 + x,44 + y,208,34,34 );
	gfx.PutPixel( 102 + x,44 + y,208,34,34 );
	gfx.PutPixel( 103 + x,44 + y,208,34,34 );
	gfx.PutPixel( 104 + x,44 + y,208,34,34 );
	gfx.PutPixel( 105 + x,44 + y,208,34,34 );
	gfx.PutPixel( 106 + x,44 + y,208,34,34 );
	gfx.PutPixel( 107 + x,44 + y,208,34,34 );
	gfx.PutPixel( 108 + x,44 + y,208,34,34 );
	gfx.PutPixel( 109 + x,44 + y,208,34,34 );
	gfx.PutPixel( 110 + x,44 + y,208,34,34 );
	gfx.PutPixel( 111 + x,44 + y,208,34,34 );
	gfx.PutPixel( 112 + x,44 + y,208,34,34 );
	gfx.PutPixel( 113 + x,44 + y,208,34,34 );
	gfx.PutPixel( 114 + x,44 + y,208,34,34 );
	gfx.PutPixel( 115 + x,44 + y,208,34,34 );
	gfx.PutPixel( 116 + x,44 + y,208,34,34 );
	gfx.PutPixel( 117 + x,44 + y,208,34,34 );
	gfx.PutPixel( 118 + x,44 + y,208,34,34 );
	gfx.PutPixel( 119 + x,44 + y,208,34,34 );
	gfx.PutPixel( 120 + x,44 + y,208,34,34 );
	gfx.PutPixel( 121 + x,44 + y,208,34,34 );
	gfx.PutPixel( 122 + x,44 + y,208,34,34 );
	gfx.PutPixel( 123 + x,44 + y,208,34,34 );
	gfx.PutPixel( 124 + x,44 + y,208,34,34 );
	gfx.PutPixel( 125 + x,44 + y,208,34,34 );
	gfx.PutPixel( 126 + x,44 + y,208,34,34 );
	gfx.PutPixel( 127 + x,44 + y,208,34,34 );
	gfx.PutPixel( 128 + x,44 + y,208,34,34 );
	gfx.PutPixel( 129 + x,44 + y,208,34,34 );
	gfx.PutPixel( 130 + x,44 + y,208,34,34 );
	gfx.PutPixel( 131 + x,44 + y,208,34,34 );
	gfx.PutPixel( 132 + x,44 + y,208,34,34 );
	gfx.PutPixel( 133 + x,44 + y,208,34,34 );
	gfx.PutPixel( 134 + x,44 + y,208,34,34 );
	gfx.PutPixel( 135 + x,44 + y,208,34,34 );
	gfx.PutPixel( 136 + x,44 + y,208,34,34 );
	gfx.PutPixel( 137 + x,44 + y,208,34,34 );
	gfx.PutPixel( 138 + x,44 + y,208,34,34 );
	gfx.PutPixel( 139 + x,44 + y,208,34,34 );
	gfx.PutPixel( 140 + x,44 + y,208,34,34 );
	gfx.PutPixel( 141 + x,44 + y,208,34,34 );
	gfx.PutPixel( 142 + x,44 + y,208,34,34 );
	gfx.PutPixel( 143 + x,44 + y,208,34,34 );
	gfx.PutPixel( 144 + x,44 + y,208,34,34 );
	gfx.PutPixel( 145 + x,44 + y,208,34,34 );
	gfx.PutPixel( 146 + x,44 + y,208,34,34 );
	gfx.PutPixel( 147 + x,44 + y,208,34,34 );
	gfx.PutPixel( 148 + x,44 + y,208,34,34 );
	gfx.PutPixel( 149 + x,44 + y,208,34,34 );
	gfx.PutPixel( 0 + x,45 + y,208,34,34 );
	gfx.PutPixel( 1 + x,45 + y,208,34,34 );
	gfx.PutPixel( 2 + x,45 + y,208,34,34 );
	gfx.PutPixel( 3 + x,45 + y,208,34,34 );
	gfx.PutPixel( 4 + x,45 + y,208,34,34 );
	gfx.PutPixel( 5 + x,45 + y,208,34,34 );
	gfx.PutPixel( 6 + x,45 + y,208,34,34 );
	gfx.PutPixel( 7 + x,45 + y,208,34,34 );
	gfx.PutPixel( 8 + x,45 + y,208,34,34 );
	gfx.PutPixel( 9 + x,45 + y,208,34,34 );
	gfx.PutPixel( 10 + x,45 + y,208,34,34 );
	gfx.PutPixel( 11 + x,45 + y,208,34,34 );
	gfx.PutPixel( 12 + x,45 + y,208,34,34 );
	gfx.PutPixel( 13 + x,45 + y,208,34,34 );
	gfx.PutPixel( 14 + x,45 + y,208,34,34 );
	gfx.PutPixel( 15 + x,45 + y,208,34,34 );
	gfx.PutPixel( 16 + x,45 + y,208,34,34 );
	gfx.PutPixel( 17 + x,45 + y,208,34,34 );
	gfx.PutPixel( 18 + x,45 + y,208,34,34 );
	gfx.PutPixel( 19 + x,45 + y,208,34,34 );
	gfx.PutPixel( 20 + x,45 + y,208,34,34 );
	gfx.PutPixel( 21 + x,45 + y,208,34,34 );
	gfx.PutPixel( 22 + x,45 + y,208,34,34 );
	gfx.PutPixel( 23 + x,45 + y,208,34,34 );
	gfx.PutPixel( 24 + x,45 + y,208,34,34 );
	gfx.PutPixel( 25 + x,45 + y,208,34,34 );
	gfx.PutPixel( 26 + x,45 + y,208,34,34 );
	gfx.PutPixel( 27 + x,45 + y,208,34,34 );
	gfx.PutPixel( 28 + x,45 + y,208,34,34 );
	gfx.PutPixel( 29 + x,45 + y,208,34,34 );
	gfx.PutPixel( 30 + x,45 + y,208,34,34 );
	gfx.PutPixel( 31 + x,45 + y,208,34,34 );
	gfx.PutPixel( 32 + x,45 + y,208,34,34 );
	gfx.PutPixel( 33 + x,45 + y,208,34,34 );
	gfx.PutPixel( 34 + x,45 + y,208,34,34 );
	gfx.PutPixel( 35 + x,45 + y,208,34,34 );
	gfx.PutPixel( 36 + x,45 + y,208,34,34 );
	gfx.PutPixel( 37 + x,45 + y,208,34,34 );
	gfx.PutPixel( 38 + x,45 + y,208,34,34 );
	gfx.PutPixel( 39 + x,45 + y,208,34,34 );
	gfx.PutPixel( 40 + x,45 + y,208,34,34 );
	gfx.PutPixel( 41 + x,45 + y,208,34,34 );
	gfx.PutPixel( 42 + x,45 + y,208,34,34 );
	gfx.PutPixel( 43 + x,45 + y,208,34,34 );
	gfx.PutPixel( 44 + x,45 + y,208,34,34 );
	gfx.PutPixel( 45 + x,45 + y,208,34,34 );
	gfx.PutPixel( 46 + x,45 + y,208,34,34 );
	gfx.PutPixel( 47 + x,45 + y,208,34,34 );
	gfx.PutPixel( 48 + x,45 + y,208,34,34 );
	gfx.PutPixel( 49 + x,45 + y,208,34,34 );
	gfx.PutPixel( 50 + x,45 + y,208,34,34 );
	gfx.PutPixel( 51 + x,45 + y,208,34,34 );
	gfx.PutPixel( 52 + x,45 + y,208,34,34 );
	gfx.PutPixel( 53 + x,45 + y,208,34,34 );
	gfx.PutPixel( 54 + x,45 + y,208,34,34 );
	gfx.PutPixel( 55 + x,45 + y,208,34,34 );
	gfx.PutPixel( 56 + x,45 + y,208,34,34 );
	gfx.PutPixel( 57 + x,45 + y,208,34,34 );
	gfx.PutPixel( 58 + x,45 + y,208,34,34 );
	gfx.PutPixel( 59 + x,45 + y,208,34,34 );
	gfx.PutPixel( 60 + x,45 + y,208,34,34 );
	gfx.PutPixel( 61 + x,45 + y,208,34,34 );
	gfx.PutPixel( 62 + x,45 + y,208,34,34 );
	gfx.PutPixel( 63 + x,45 + y,208,34,34 );
	gfx.PutPixel( 64 + x,45 + y,208,34,34 );
	gfx.PutPixel( 65 + x,45 + y,208,34,34 );
	gfx.PutPixel( 66 + x,45 + y,208,34,34 );
	gfx.PutPixel( 67 + x,45 + y,208,34,34 );
	gfx.PutPixel( 68 + x,45 + y,208,34,34 );
	gfx.PutPixel( 69 + x,45 + y,208,34,34 );
	gfx.PutPixel( 70 + x,45 + y,208,34,34 );
	gfx.PutPixel( 71 + x,45 + y,208,34,34 );
	gfx.PutPixel( 72 + x,45 + y,208,34,34 );
	gfx.PutPixel( 73 + x,45 + y,208,34,34 );
	gfx.PutPixel( 74 + x,45 + y,208,34,34 );
	gfx.PutPixel( 75 + x,45 + y,208,34,34 );
	gfx.PutPixel( 76 + x,45 + y,208,34,34 );
	gfx.PutPixel( 77 + x,45 + y,208,34,34 );
	gfx.PutPixel( 78 + x,45 + y,208,34,34 );
	gfx.PutPixel( 79 + x,45 + y,208,34,34 );
	gfx.PutPixel( 80 + x,45 + y,208,34,34 );
	gfx.PutPixel( 81 + x,45 + y,208,34,34 );
	gfx.PutPixel( 82 + x,45 + y,208,34,34 );
	gfx.PutPixel( 83 + x,45 + y,208,34,34 );
	gfx.PutPixel( 84 + x,45 + y,208,34,34 );
	gfx.PutPixel( 85 + x,45 + y,208,34,34 );
	gfx.PutPixel( 86 + x,45 + y,208,34,34 );
	gfx.PutPixel( 87 + x,45 + y,208,34,34 );
	gfx.PutPixel( 88 + x,45 + y,208,34,34 );
	gfx.PutPixel( 89 + x,45 + y,208,34,34 );
	gfx.PutPixel( 90 + x,45 + y,208,34,34 );
	gfx.PutPixel( 91 + x,45 + y,208,34,34 );
	gfx.PutPixel( 92 + x,45 + y,208,34,34 );
	gfx.PutPixel( 93 + x,45 + y,208,34,34 );
	gfx.PutPixel( 94 + x,45 + y,208,34,34 );
	gfx.PutPixel( 95 + x,45 + y,208,34,34 );
	gfx.PutPixel( 96 + x,45 + y,208,34,34 );
	gfx.PutPixel( 97 + x,45 + y,208,34,34 );
	gfx.PutPixel( 98 + x,45 + y,208,34,34 );
	gfx.PutPixel( 99 + x,45 + y,208,34,34 );
	gfx.PutPixel( 100 + x,45 + y,208,34,34 );
	gfx.PutPixel( 101 + x,45 + y,208,34,34 );
	gfx.PutPixel( 102 + x,45 + y,208,34,34 );
	gfx.PutPixel( 103 + x,45 + y,208,34,34 );
	gfx.PutPixel( 104 + x,45 + y,208,34,34 );
	gfx.PutPixel( 105 + x,45 + y,208,34,34 );
	gfx.PutPixel( 106 + x,45 + y,208,34,34 );
	gfx.PutPixel( 107 + x,45 + y,208,34,34 );
	gfx.PutPixel( 108 + x,45 + y,208,34,34 );
	gfx.PutPixel( 109 + x,45 + y,208,34,34 );
	gfx.PutPixel( 110 + x,45 + y,208,34,34 );
	gfx.PutPixel( 111 + x,45 + y,208,34,34 );
	gfx.PutPixel( 112 + x,45 + y,208,34,34 );
	gfx.PutPixel( 113 + x,45 + y,208,34,34 );
	gfx.PutPixel( 114 + x,45 + y,208,34,34 );
	gfx.PutPixel( 115 + x,45 + y,208,34,34 );
	gfx.PutPixel( 116 + x,45 + y,208,34,34 );
	gfx.PutPixel( 117 + x,45 + y,208,34,34 );
	gfx.PutPixel( 118 + x,45 + y,208,34,34 );
	gfx.PutPixel( 119 + x,45 + y,208,34,34 );
	gfx.PutPixel( 120 + x,45 + y,208,34,34 );
	gfx.PutPixel( 121 + x,45 + y,208,34,34 );
	gfx.PutPixel( 122 + x,45 + y,208,34,34 );
	gfx.PutPixel( 123 + x,45 + y,208,34,34 );
	gfx.PutPixel( 124 + x,45 + y,208,34,34 );
	gfx.PutPixel( 125 + x,45 + y,208,34,34 );
	gfx.PutPixel( 126 + x,45 + y,208,34,34 );
	gfx.PutPixel( 127 + x,45 + y,208,34,34 );
	gfx.PutPixel( 128 + x,45 + y,208,34,34 );
	gfx.PutPixel( 129 + x,45 + y,208,34,34 );
	gfx.PutPixel( 130 + x,45 + y,208,34,34 );
	gfx.PutPixel( 131 + x,45 + y,208,34,34 );
	gfx.PutPixel( 132 + x,45 + y,208,34,34 );
	gfx.PutPixel( 133 + x,45 + y,208,34,34 );
	gfx.PutPixel( 134 + x,45 + y,208,34,34 );
	gfx.PutPixel( 135 + x,45 + y,208,34,34 );
	gfx.PutPixel( 136 + x,45 + y,208,34,34 );
	gfx.PutPixel( 137 + x,45 + y,208,34,34 );
	gfx.PutPixel( 138 + x,45 + y,208,34,34 );
	gfx.PutPixel( 139 + x,45 + y,208,34,34 );
	gfx.PutPixel( 140 + x,45 + y,208,34,34 );
	gfx.PutPixel( 141 + x,45 + y,208,34,34 );
	gfx.PutPixel( 142 + x,45 + y,208,34,34 );
	gfx.PutPixel( 143 + x,45 + y,208,34,34 );
	gfx.PutPixel( 144 + x,45 + y,208,34,34 );
	gfx.PutPixel( 145 + x,45 + y,208,34,34 );
	gfx.PutPixel( 146 + x,45 + y,208,34,34 );
	gfx.PutPixel( 147 + x,45 + y,208,34,34 );
	gfx.PutPixel( 148 + x,45 + y,208,34,34 );
	gfx.PutPixel( 149 + x,45 + y,208,34,34 );
	gfx.PutPixel( 0 + x,46 + y,208,34,34 );
	gfx.PutPixel( 1 + x,46 + y,208,34,34 );
	gfx.PutPixel( 2 + x,46 + y,208,34,34 );
	gfx.PutPixel( 3 + x,46 + y,208,34,34 );
	gfx.PutPixel( 4 + x,46 + y,208,34,34 );
	gfx.PutPixel( 5 + x,46 + y,208,34,34 );
	gfx.PutPixel( 6 + x,46 + y,208,34,34 );
	gfx.PutPixel( 7 + x,46 + y,208,34,34 );
	gfx.PutPixel( 8 + x,46 + y,208,34,34 );
	gfx.PutPixel( 9 + x,46 + y,208,34,34 );
	gfx.PutPixel( 10 + x,46 + y,208,34,34 );
	gfx.PutPixel( 11 + x,46 + y,208,34,34 );
	gfx.PutPixel( 12 + x,46 + y,208,34,34 );
	gfx.PutPixel( 13 + x,46 + y,208,34,34 );
	gfx.PutPixel( 14 + x,46 + y,208,34,34 );
	gfx.PutPixel( 15 + x,46 + y,208,34,34 );
	gfx.PutPixel( 16 + x,46 + y,208,34,34 );
	gfx.PutPixel( 17 + x,46 + y,208,34,34 );
	gfx.PutPixel( 18 + x,46 + y,208,34,34 );
	gfx.PutPixel( 19 + x,46 + y,208,34,34 );
	gfx.PutPixel( 20 + x,46 + y,208,34,34 );
	gfx.PutPixel( 21 + x,46 + y,208,34,34 );
	gfx.PutPixel( 22 + x,46 + y,208,34,34 );
	gfx.PutPixel( 23 + x,46 + y,208,34,34 );
	gfx.PutPixel( 24 + x,46 + y,208,34,34 );
	gfx.PutPixel( 25 + x,46 + y,208,34,34 );
	gfx.PutPixel( 26 + x,46 + y,208,34,34 );
	gfx.PutPixel( 27 + x,46 + y,208,34,34 );
	gfx.PutPixel( 28 + x,46 + y,208,34,34 );
	gfx.PutPixel( 29 + x,46 + y,208,34,34 );
	gfx.PutPixel( 30 + x,46 + y,208,34,34 );
	gfx.PutPixel( 31 + x,46 + y,208,34,34 );
	gfx.PutPixel( 32 + x,46 + y,208,34,34 );
	gfx.PutPixel( 33 + x,46 + y,208,34,34 );
	gfx.PutPixel( 34 + x,46 + y,208,34,34 );
	gfx.PutPixel( 35 + x,46 + y,208,34,34 );
	gfx.PutPixel( 36 + x,46 + y,208,34,34 );
	gfx.PutPixel( 37 + x,46 + y,208,34,34 );
	gfx.PutPixel( 38 + x,46 + y,208,34,34 );
	gfx.PutPixel( 39 + x,46 + y,208,34,34 );
	gfx.PutPixel( 40 + x,46 + y,208,34,34 );
	gfx.PutPixel( 41 + x,46 + y,208,34,34 );
	gfx.PutPixel( 42 + x,46 + y,208,34,34 );
	gfx.PutPixel( 43 + x,46 + y,208,34,34 );
	gfx.PutPixel( 44 + x,46 + y,208,34,34 );
	gfx.PutPixel( 45 + x,46 + y,208,34,34 );
	gfx.PutPixel( 46 + x,46 + y,208,34,34 );
	gfx.PutPixel( 47 + x,46 + y,208,34,34 );
	gfx.PutPixel( 48 + x,46 + y,208,34,34 );
	gfx.PutPixel( 49 + x,46 + y,208,34,34 );
	gfx.PutPixel( 50 + x,46 + y,208,34,34 );
	gfx.PutPixel( 51 + x,46 + y,208,34,34 );
	gfx.PutPixel( 52 + x,46 + y,208,34,34 );
	gfx.PutPixel( 53 + x,46 + y,208,34,34 );
	gfx.PutPixel( 54 + x,46 + y,208,34,34 );
	gfx.PutPixel( 55 + x,46 + y,208,34,34 );
	gfx.PutPixel( 56 + x,46 + y,208,34,34 );
	gfx.PutPixel( 57 + x,46 + y,208,34,34 );
	gfx.PutPixel( 58 + x,46 + y,208,34,34 );
	gfx.PutPixel( 59 + x,46 + y,208,34,34 );
	gfx.PutPixel( 60 + x,46 + y,208,34,34 );
	gfx.PutPixel( 61 + x,46 + y,208,34,34 );
	gfx.PutPixel( 62 + x,46 + y,208,34,34 );
	gfx.PutPixel( 63 + x,46 + y,208,34,34 );
	gfx.PutPixel( 64 + x,46 + y,208,34,34 );
	gfx.PutPixel( 65 + x,46 + y,208,34,34 );
	gfx.PutPixel( 66 + x,46 + y,208,34,34 );
	gfx.PutPixel( 67 + x,46 + y,208,34,34 );
	gfx.PutPixel( 68 + x,46 + y,208,34,34 );
	gfx.PutPixel( 69 + x,46 + y,208,34,34 );
	gfx.PutPixel( 70 + x,46 + y,208,34,34 );
	gfx.PutPixel( 71 + x,46 + y,208,34,34 );
	gfx.PutPixel( 72 + x,46 + y,208,34,34 );
	gfx.PutPixel( 73 + x,46 + y,208,34,34 );
	gfx.PutPixel( 74 + x,46 + y,208,34,34 );
	gfx.PutPixel( 75 + x,46 + y,208,34,34 );
	gfx.PutPixel( 76 + x,46 + y,208,34,34 );
	gfx.PutPixel( 77 + x,46 + y,208,34,34 );
	gfx.PutPixel( 78 + x,46 + y,208,34,34 );
	gfx.PutPixel( 79 + x,46 + y,208,34,34 );
	gfx.PutPixel( 80 + x,46 + y,208,34,34 );
	gfx.PutPixel( 81 + x,46 + y,208,34,34 );
	gfx.PutPixel( 82 + x,46 + y,208,34,34 );
	gfx.PutPixel( 83 + x,46 + y,208,34,34 );
	gfx.PutPixel( 84 + x,46 + y,208,34,34 );
	gfx.PutPixel( 85 + x,46 + y,208,34,34 );
	gfx.PutPixel( 86 + x,46 + y,208,34,34 );
	gfx.PutPixel( 87 + x,46 + y,208,34,34 );
	gfx.PutPixel( 88 + x,46 + y,208,34,34 );
	gfx.PutPixel( 89 + x,46 + y,208,34,34 );
	gfx.PutPixel( 90 + x,46 + y,208,34,34 );
	gfx.PutPixel( 91 + x,46 + y,208,34,34 );
	gfx.PutPixel( 92 + x,46 + y,208,34,34 );
	gfx.PutPixel( 93 + x,46 + y,208,34,34 );
	gfx.PutPixel( 94 + x,46 + y,208,34,34 );
	gfx.PutPixel( 95 + x,46 + y,208,34,34 );
	gfx.PutPixel( 96 + x,46 + y,208,34,34 );
	gfx.PutPixel( 97 + x,46 + y,208,34,34 );
	gfx.PutPixel( 98 + x,46 + y,208,34,34 );
	gfx.PutPixel( 99 + x,46 + y,208,34,34 );
	gfx.PutPixel( 100 + x,46 + y,208,34,34 );
	gfx.PutPixel( 101 + x,46 + y,208,34,34 );
	gfx.PutPixel( 102 + x,46 + y,208,34,34 );
	gfx.PutPixel( 103 + x,46 + y,208,34,34 );
	gfx.PutPixel( 104 + x,46 + y,208,34,34 );
	gfx.PutPixel( 105 + x,46 + y,208,34,34 );
	gfx.PutPixel( 106 + x,46 + y,208,34,34 );
	gfx.PutPixel( 107 + x,46 + y,208,34,34 );
	gfx.PutPixel( 108 + x,46 + y,208,34,34 );
	gfx.PutPixel( 109 + x,46 + y,208,34,34 );
	gfx.PutPixel( 110 + x,46 + y,208,34,34 );
	gfx.PutPixel( 111 + x,46 + y,208,34,34 );
	gfx.PutPixel( 112 + x,46 + y,208,34,34 );
	gfx.PutPixel( 113 + x,46 + y,208,34,34 );
	gfx.PutPixel( 114 + x,46 + y,208,34,34 );
	gfx.PutPixel( 115 + x,46 + y,208,34,34 );
	gfx.PutPixel( 116 + x,46 + y,208,34,34 );
	gfx.PutPixel( 117 + x,46 + y,208,34,34 );
	gfx.PutPixel( 118 + x,46 + y,208,34,34 );
	gfx.PutPixel( 119 + x,46 + y,208,34,34 );
	gfx.PutPixel( 120 + x,46 + y,208,34,34 );
	gfx.PutPixel( 121 + x,46 + y,208,34,34 );
	gfx.PutPixel( 122 + x,46 + y,208,34,34 );
	gfx.PutPixel( 123 + x,46 + y,208,34,34 );
	gfx.PutPixel( 124 + x,46 + y,208,34,34 );
	gfx.PutPixel( 125 + x,46 + y,208,34,34 );
	gfx.PutPixel( 126 + x,46 + y,208,34,34 );
	gfx.PutPixel( 127 + x,46 + y,208,34,34 );
	gfx.PutPixel( 128 + x,46 + y,208,34,34 );
	gfx.PutPixel( 129 + x,46 + y,208,34,34 );
	gfx.PutPixel( 130 + x,46 + y,208,34,34 );
	gfx.PutPixel( 131 + x,46 + y,208,34,34 );
	gfx.PutPixel( 132 + x,46 + y,208,34,34 );
	gfx.PutPixel( 133 + x,46 + y,208,34,34 );
	gfx.PutPixel( 134 + x,46 + y,208,34,34 );
	gfx.PutPixel( 135 + x,46 + y,208,34,34 );
	gfx.PutPixel( 136 + x,46 + y,208,34,34 );
	gfx.PutPixel( 137 + x,46 + y,208,34,34 );
	gfx.PutPixel( 138 + x,46 + y,208,34,34 );
	gfx.PutPixel( 139 + x,46 + y,208,34,34 );
	gfx.PutPixel( 140 + x,46 + y,208,34,34 );
	gfx.PutPixel( 141 + x,46 + y,208,34,34 );
	gfx.PutPixel( 142 + x,46 + y,208,34,34 );
	gfx.PutPixel( 143 + x,46 + y,208,34,34 );
	gfx.PutPixel( 144 + x,46 + y,208,34,34 );
	gfx.PutPixel( 145 + x,46 + y,208,34,34 );
	gfx.PutPixel( 146 + x,46 + y,208,34,34 );
	gfx.PutPixel( 147 + x,46 + y,208,34,34 );
	gfx.PutPixel( 148 + x,46 + y,208,34,34 );
	gfx.PutPixel( 149 + x,46 + y,208,34,34 );
	gfx.PutPixel( 0 + x,47 + y,208,34,34 );
	gfx.PutPixel( 1 + x,47 + y,208,34,34 );
	gfx.PutPixel( 2 + x,47 + y,208,34,34 );
	gfx.PutPixel( 3 + x,47 + y,208,34,34 );
	gfx.PutPixel( 4 + x,47 + y,208,34,34 );
	gfx.PutPixel( 5 + x,47 + y,208,34,34 );
	gfx.PutPixel( 6 + x,47 + y,208,34,34 );
	gfx.PutPixel( 7 + x,47 + y,208,34,34 );
	gfx.PutPixel( 8 + x,47 + y,208,34,34 );
	gfx.PutPixel( 9 + x,47 + y,208,34,34 );
	gfx.PutPixel( 10 + x,47 + y,208,34,34 );
	gfx.PutPixel( 11 + x,47 + y,208,34,34 );
	gfx.PutPixel( 12 + x,47 + y,208,34,34 );
	gfx.PutPixel( 13 + x,47 + y,208,34,34 );
	gfx.PutPixel( 14 + x,47 + y,208,34,34 );
	gfx.PutPixel( 15 + x,47 + y,208,34,34 );
	gfx.PutPixel( 16 + x,47 + y,208,34,34 );
	gfx.PutPixel( 17 + x,47 + y,208,34,34 );
	gfx.PutPixel( 18 + x,47 + y,208,34,34 );
	gfx.PutPixel( 19 + x,47 + y,208,34,34 );
	gfx.PutPixel( 20 + x,47 + y,208,34,34 );
	gfx.PutPixel( 21 + x,47 + y,208,34,34 );
	gfx.PutPixel( 22 + x,47 + y,208,34,34 );
	gfx.PutPixel( 23 + x,47 + y,208,34,34 );
	gfx.PutPixel( 24 + x,47 + y,208,34,34 );
	gfx.PutPixel( 25 + x,47 + y,208,34,34 );
	gfx.PutPixel( 26 + x,47 + y,208,34,34 );
	gfx.PutPixel( 27 + x,47 + y,208,34,34 );
	gfx.PutPixel( 28 + x,47 + y,208,34,34 );
	gfx.PutPixel( 29 + x,47 + y,208,34,34 );
	gfx.PutPixel( 30 + x,47 + y,208,34,34 );
	gfx.PutPixel( 31 + x,47 + y,208,34,34 );
	gfx.PutPixel( 32 + x,47 + y,208,34,34 );
	gfx.PutPixel( 33 + x,47 + y,208,34,34 );
	gfx.PutPixel( 34 + x,47 + y,208,34,34 );
	gfx.PutPixel( 35 + x,47 + y,208,34,34 );
	gfx.PutPixel( 36 + x,47 + y,208,34,34 );
	gfx.PutPixel( 37 + x,47 + y,208,34,34 );
	gfx.PutPixel( 38 + x,47 + y,208,34,34 );
	gfx.PutPixel( 39 + x,47 + y,208,34,34 );
	gfx.PutPixel( 40 + x,47 + y,208,34,34 );
	gfx.PutPixel( 41 + x,47 + y,208,34,34 );
	gfx.PutPixel( 42 + x,47 + y,208,34,34 );
	gfx.PutPixel( 43 + x,47 + y,208,34,34 );
	gfx.PutPixel( 44 + x,47 + y,208,34,34 );
	gfx.PutPixel( 45 + x,47 + y,208,34,34 );
	gfx.PutPixel( 46 + x,47 + y,208,34,34 );
	gfx.PutPixel( 47 + x,47 + y,208,34,34 );
	gfx.PutPixel( 48 + x,47 + y,208,34,34 );
	gfx.PutPixel( 49 + x,47 + y,208,34,34 );
	gfx.PutPixel( 50 + x,47 + y,208,34,34 );
	gfx.PutPixel( 51 + x,47 + y,208,34,34 );
	gfx.PutPixel( 52 + x,47 + y,208,34,34 );
	gfx.PutPixel( 53 + x,47 + y,208,34,34 );
	gfx.PutPixel( 54 + x,47 + y,208,34,34 );
	gfx.PutPixel( 55 + x,47 + y,208,34,34 );
	gfx.PutPixel( 56 + x,47 + y,208,34,34 );
	gfx.PutPixel( 57 + x,47 + y,208,34,34 );
	gfx.PutPixel( 58 + x,47 + y,208,34,34 );
	gfx.PutPixel( 59 + x,47 + y,208,34,34 );
	gfx.PutPixel( 60 + x,47 + y,208,34,34 );
	gfx.PutPixel( 61 + x,47 + y,208,34,34 );
	gfx.PutPixel( 62 + x,47 + y,208,34,34 );
	gfx.PutPixel( 63 + x,47 + y,208,34,34 );
	gfx.PutPixel( 64 + x,47 + y,208,34,34 );
	gfx.PutPixel( 65 + x,47 + y,208,34,34 );
	gfx.PutPixel( 66 + x,47 + y,208,34,34 );
	gfx.PutPixel( 67 + x,47 + y,208,34,34 );
	gfx.PutPixel( 68 + x,47 + y,208,34,34 );
	gfx.PutPixel( 69 + x,47 + y,208,34,34 );
	gfx.PutPixel( 70 + x,47 + y,208,34,34 );
	gfx.PutPixel( 71 + x,47 + y,208,34,34 );
	gfx.PutPixel( 72 + x,47 + y,208,34,34 );
	gfx.PutPixel( 73 + x,47 + y,208,34,34 );
	gfx.PutPixel( 74 + x,47 + y,208,34,34 );
	gfx.PutPixel( 75 + x,47 + y,208,34,34 );
	gfx.PutPixel( 76 + x,47 + y,208,34,34 );
	gfx.PutPixel( 77 + x,47 + y,208,34,34 );
	gfx.PutPixel( 78 + x,47 + y,208,34,34 );
	gfx.PutPixel( 79 + x,47 + y,208,34,34 );
	gfx.PutPixel( 80 + x,47 + y,208,34,34 );
	gfx.PutPixel( 81 + x,47 + y,208,34,34 );
	gfx.PutPixel( 82 + x,47 + y,208,34,34 );
	gfx.PutPixel( 83 + x,47 + y,208,34,34 );
	gfx.PutPixel( 84 + x,47 + y,208,34,34 );
	gfx.PutPixel( 85 + x,47 + y,208,34,34 );
	gfx.PutPixel( 86 + x,47 + y,208,34,34 );
	gfx.PutPixel( 87 + x,47 + y,208,34,34 );
	gfx.PutPixel( 88 + x,47 + y,208,34,34 );
	gfx.PutPixel( 89 + x,47 + y,208,34,34 );
	gfx.PutPixel( 90 + x,47 + y,208,34,34 );
	gfx.PutPixel( 91 + x,47 + y,208,34,34 );
	gfx.PutPixel( 92 + x,47 + y,208,34,34 );
	gfx.PutPixel( 93 + x,47 + y,208,34,34 );
	gfx.PutPixel( 94 + x,47 + y,208,34,34 );
	gfx.PutPixel( 95 + x,47 + y,208,34,34 );
	gfx.PutPixel( 96 + x,47 + y,208,34,34 );
	gfx.PutPixel( 97 + x,47 + y,208,34,34 );
	gfx.PutPixel( 98 + x,47 + y,208,34,34 );
	gfx.PutPixel( 99 + x,47 + y,208,34,34 );
	gfx.PutPixel( 100 + x,47 + y,208,34,34 );
	gfx.PutPixel( 101 + x,47 + y,208,34,34 );
	gfx.PutPixel( 102 + x,47 + y,208,34,34 );
	gfx.PutPixel( 103 + x,47 + y,208,34,34 );
	gfx.PutPixel( 104 + x,47 + y,208,34,34 );
	gfx.PutPixel( 105 + x,47 + y,208,34,34 );
	gfx.PutPixel( 106 + x,47 + y,208,34,34 );
	gfx.PutPixel( 107 + x,47 + y,208,34,34 );
	gfx.PutPixel( 108 + x,47 + y,208,34,34 );
	gfx.PutPixel( 109 + x,47 + y,208,34,34 );
	gfx.PutPixel( 110 + x,47 + y,208,34,34 );
	gfx.PutPixel( 111 + x,47 + y,208,34,34 );
	gfx.PutPixel( 112 + x,47 + y,208,34,34 );
	gfx.PutPixel( 113 + x,47 + y,208,34,34 );
	gfx.PutPixel( 114 + x,47 + y,208,34,34 );
	gfx.PutPixel( 115 + x,47 + y,208,34,34 );
	gfx.PutPixel( 116 + x,47 + y,208,34,34 );
	gfx.PutPixel( 117 + x,47 + y,208,34,34 );
	gfx.PutPixel( 118 + x,47 + y,208,34,34 );
	gfx.PutPixel( 119 + x,47 + y,208,34,34 );
	gfx.PutPixel( 120 + x,47 + y,208,34,34 );
	gfx.PutPixel( 121 + x,47 + y,208,34,34 );
	gfx.PutPixel( 122 + x,47 + y,208,34,34 );
	gfx.PutPixel( 123 + x,47 + y,208,34,34 );
	gfx.PutPixel( 124 + x,47 + y,208,34,34 );
	gfx.PutPixel( 125 + x,47 + y,208,34,34 );
	gfx.PutPixel( 126 + x,47 + y,208,34,34 );
	gfx.PutPixel( 127 + x,47 + y,208,34,34 );
	gfx.PutPixel( 128 + x,47 + y,208,34,34 );
	gfx.PutPixel( 129 + x,47 + y,208,34,34 );
	gfx.PutPixel( 130 + x,47 + y,208,34,34 );
	gfx.PutPixel( 131 + x,47 + y,208,34,34 );
	gfx.PutPixel( 132 + x,47 + y,208,34,34 );
	gfx.PutPixel( 133 + x,47 + y,208,34,34 );
	gfx.PutPixel( 134 + x,47 + y,208,34,34 );
	gfx.PutPixel( 135 + x,47 + y,208,34,34 );
	gfx.PutPixel( 136 + x,47 + y,208,34,34 );
	gfx.PutPixel( 137 + x,47 + y,208,34,34 );
	gfx.PutPixel( 138 + x,47 + y,208,34,34 );
	gfx.PutPixel( 139 + x,47 + y,208,34,34 );
	gfx.PutPixel( 140 + x,47 + y,208,34,34 );
	gfx.PutPixel( 141 + x,47 + y,208,34,34 );
	gfx.PutPixel( 142 + x,47 + y,208,34,34 );
	gfx.PutPixel( 143 + x,47 + y,208,34,34 );
	gfx.PutPixel( 144 + x,47 + y,208,34,34 );
	gfx.PutPixel( 145 + x,47 + y,208,34,34 );
	gfx.PutPixel( 146 + x,47 + y,208,34,34 );
	gfx.PutPixel( 147 + x,47 + y,208,34,34 );
	gfx.PutPixel( 148 + x,47 + y,208,34,34 );
	gfx.PutPixel( 149 + x,47 + y,208,34,34 );
	gfx.PutPixel( 0 + x,48 + y,208,34,34 );
	gfx.PutPixel( 1 + x,48 + y,208,34,34 );
	gfx.PutPixel( 2 + x,48 + y,208,34,34 );
	gfx.PutPixel( 3 + x,48 + y,208,34,34 );
	gfx.PutPixel( 4 + x,48 + y,208,34,34 );
	gfx.PutPixel( 5 + x,48 + y,208,34,34 );
	gfx.PutPixel( 6 + x,48 + y,208,34,34 );
	gfx.PutPixel( 7 + x,48 + y,208,34,34 );
	gfx.PutPixel( 8 + x,48 + y,208,34,34 );
	gfx.PutPixel( 9 + x,48 + y,208,34,34 );
	gfx.PutPixel( 10 + x,48 + y,208,34,34 );
	gfx.PutPixel( 11 + x,48 + y,208,34,34 );
	gfx.PutPixel( 12 + x,48 + y,208,34,34 );
	gfx.PutPixel( 13 + x,48 + y,208,34,34 );
	gfx.PutPixel( 14 + x,48 + y,208,34,34 );
	gfx.PutPixel( 15 + x,48 + y,208,34,34 );
	gfx.PutPixel( 16 + x,48 + y,208,34,34 );
	gfx.PutPixel( 17 + x,48 + y,208,34,34 );
	gfx.PutPixel( 18 + x,48 + y,208,34,34 );
	gfx.PutPixel( 19 + x,48 + y,208,34,34 );
	gfx.PutPixel( 20 + x,48 + y,208,34,34 );
	gfx.PutPixel( 21 + x,48 + y,208,34,34 );
	gfx.PutPixel( 22 + x,48 + y,208,34,34 );
	gfx.PutPixel( 23 + x,48 + y,208,34,34 );
	gfx.PutPixel( 24 + x,48 + y,208,34,34 );
	gfx.PutPixel( 25 + x,48 + y,208,34,34 );
	gfx.PutPixel( 26 + x,48 + y,208,34,34 );
	gfx.PutPixel( 27 + x,48 + y,208,34,34 );
	gfx.PutPixel( 28 + x,48 + y,208,34,34 );
	gfx.PutPixel( 29 + x,48 + y,208,34,34 );
	gfx.PutPixel( 30 + x,48 + y,208,34,34 );
	gfx.PutPixel( 31 + x,48 + y,208,34,34 );
	gfx.PutPixel( 32 + x,48 + y,208,34,34 );
	gfx.PutPixel( 33 + x,48 + y,208,34,34 );
	gfx.PutPixel( 34 + x,48 + y,208,34,34 );
	gfx.PutPixel( 35 + x,48 + y,208,34,34 );
	gfx.PutPixel( 36 + x,48 + y,208,34,34 );
	gfx.PutPixel( 37 + x,48 + y,208,34,34 );
	gfx.PutPixel( 38 + x,48 + y,208,34,34 );
	gfx.PutPixel( 39 + x,48 + y,208,34,34 );
	gfx.PutPixel( 40 + x,48 + y,208,34,34 );
	gfx.PutPixel( 41 + x,48 + y,208,34,34 );
	gfx.PutPixel( 42 + x,48 + y,208,34,34 );
	gfx.PutPixel( 43 + x,48 + y,208,34,34 );
	gfx.PutPixel( 44 + x,48 + y,208,34,34 );
	gfx.PutPixel( 45 + x,48 + y,208,34,34 );
	gfx.PutPixel( 46 + x,48 + y,208,34,34 );
	gfx.PutPixel( 47 + x,48 + y,208,34,34 );
	gfx.PutPixel( 48 + x,48 + y,208,34,34 );
	gfx.PutPixel( 49 + x,48 + y,208,34,34 );
	gfx.PutPixel( 50 + x,48 + y,208,34,34 );
	gfx.PutPixel( 51 + x,48 + y,208,34,34 );
	gfx.PutPixel( 52 + x,48 + y,208,34,34 );
	gfx.PutPixel( 53 + x,48 + y,208,34,34 );
	gfx.PutPixel( 54 + x,48 + y,208,34,34 );
	gfx.PutPixel( 55 + x,48 + y,208,34,34 );
	gfx.PutPixel( 56 + x,48 + y,208,34,34 );
	gfx.PutPixel( 57 + x,48 + y,208,34,34 );
	gfx.PutPixel( 58 + x,48 + y,208,34,34 );
	gfx.PutPixel( 59 + x,48 + y,208,34,34 );
	gfx.PutPixel( 60 + x,48 + y,208,34,34 );
	gfx.PutPixel( 61 + x,48 + y,208,34,34 );
	gfx.PutPixel( 62 + x,48 + y,208,34,34 );
	gfx.PutPixel( 63 + x,48 + y,208,34,34 );
	gfx.PutPixel( 64 + x,48 + y,208,34,34 );
	gfx.PutPixel( 65 + x,48 + y,208,34,34 );
	gfx.PutPixel( 66 + x,48 + y,208,34,34 );
	gfx.PutPixel( 67 + x,48 + y,208,34,34 );
	gfx.PutPixel( 68 + x,48 + y,208,34,34 );
	gfx.PutPixel( 69 + x,48 + y,208,34,34 );
	gfx.PutPixel( 70 + x,48 + y,208,34,34 );
	gfx.PutPixel( 71 + x,48 + y,208,34,34 );
	gfx.PutPixel( 72 + x,48 + y,208,34,34 );
	gfx.PutPixel( 73 + x,48 + y,208,34,34 );
	gfx.PutPixel( 74 + x,48 + y,208,34,34 );
	gfx.PutPixel( 75 + x,48 + y,208,34,34 );
	gfx.PutPixel( 76 + x,48 + y,208,34,34 );
	gfx.PutPixel( 77 + x,48 + y,208,34,34 );
	gfx.PutPixel( 78 + x,48 + y,208,34,34 );
	gfx.PutPixel( 79 + x,48 + y,208,34,34 );
	gfx.PutPixel( 80 + x,48 + y,208,34,34 );
	gfx.PutPixel( 81 + x,48 + y,208,34,34 );
	gfx.PutPixel( 82 + x,48 + y,208,34,34 );
	gfx.PutPixel( 83 + x,48 + y,208,34,34 );
	gfx.PutPixel( 84 + x,48 + y,208,34,34 );
	gfx.PutPixel( 85 + x,48 + y,208,34,34 );
	gfx.PutPixel( 86 + x,48 + y,208,34,34 );
	gfx.PutPixel( 87 + x,48 + y,208,34,34 );
	gfx.PutPixel( 88 + x,48 + y,208,34,34 );
	gfx.PutPixel( 89 + x,48 + y,208,34,34 );
	gfx.PutPixel( 90 + x,48 + y,208,34,34 );
	gfx.PutPixel( 91 + x,48 + y,208,34,34 );
	gfx.PutPixel( 92 + x,48 + y,208,34,34 );
	gfx.PutPixel( 93 + x,48 + y,208,34,34 );
	gfx.PutPixel( 94 + x,48 + y,208,34,34 );
	gfx.PutPixel( 95 + x,48 + y,208,34,34 );
	gfx.PutPixel( 96 + x,48 + y,208,34,34 );
	gfx.PutPixel( 97 + x,48 + y,208,34,34 );
	gfx.PutPixel( 98 + x,48 + y,208,34,34 );
	gfx.PutPixel( 99 + x,48 + y,208,34,34 );
	gfx.PutPixel( 100 + x,48 + y,208,34,34 );
	gfx.PutPixel( 101 + x,48 + y,208,34,34 );
	gfx.PutPixel( 102 + x,48 + y,208,34,34 );
	gfx.PutPixel( 103 + x,48 + y,208,34,34 );
	gfx.PutPixel( 104 + x,48 + y,208,34,34 );
	gfx.PutPixel( 105 + x,48 + y,208,34,34 );
	gfx.PutPixel( 106 + x,48 + y,208,34,34 );
	gfx.PutPixel( 107 + x,48 + y,208,34,34 );
	gfx.PutPixel( 108 + x,48 + y,208,34,34 );
	gfx.PutPixel( 109 + x,48 + y,208,34,34 );
	gfx.PutPixel( 110 + x,48 + y,208,34,34 );
	gfx.PutPixel( 111 + x,48 + y,208,34,34 );
	gfx.PutPixel( 112 + x,48 + y,208,34,34 );
	gfx.PutPixel( 113 + x,48 + y,208,34,34 );
	gfx.PutPixel( 114 + x,48 + y,208,34,34 );
	gfx.PutPixel( 115 + x,48 + y,208,34,34 );
	gfx.PutPixel( 116 + x,48 + y,208,34,34 );
	gfx.PutPixel( 117 + x,48 + y,208,34,34 );
	gfx.PutPixel( 118 + x,48 + y,208,34,34 );
	gfx.PutPixel( 119 + x,48 + y,208,34,34 );
	gfx.PutPixel( 120 + x,48 + y,208,34,34 );
	gfx.PutPixel( 121 + x,48 + y,208,34,34 );
	gfx.PutPixel( 122 + x,48 + y,208,34,34 );
	gfx.PutPixel( 123 + x,48 + y,208,34,34 );
	gfx.PutPixel( 124 + x,48 + y,208,34,34 );
	gfx.PutPixel( 125 + x,48 + y,208,34,34 );
	gfx.PutPixel( 126 + x,48 + y,208,34,34 );
	gfx.PutPixel( 127 + x,48 + y,208,34,34 );
	gfx.PutPixel( 128 + x,48 + y,208,34,34 );
	gfx.PutPixel( 129 + x,48 + y,208,34,34 );
	gfx.PutPixel( 130 + x,48 + y,208,34,34 );
	gfx.PutPixel( 131 + x,48 + y,208,34,34 );
	gfx.PutPixel( 132 + x,48 + y,208,34,34 );
	gfx.PutPixel( 133 + x,48 + y,208,34,34 );
	gfx.PutPixel( 134 + x,48 + y,208,34,34 );
	gfx.PutPixel( 135 + x,48 + y,208,34,34 );
	gfx.PutPixel( 136 + x,48 + y,208,34,34 );
	gfx.PutPixel( 137 + x,48 + y,208,34,34 );
	gfx.PutPixel( 138 + x,48 + y,208,34,34 );
	gfx.PutPixel( 139 + x,48 + y,208,34,34 );
	gfx.PutPixel( 140 + x,48 + y,208,34,34 );
	gfx.PutPixel( 141 + x,48 + y,208,34,34 );
	gfx.PutPixel( 142 + x,48 + y,208,34,34 );
	gfx.PutPixel( 143 + x,48 + y,208,34,34 );
	gfx.PutPixel( 144 + x,48 + y,208,34,34 );
	gfx.PutPixel( 145 + x,48 + y,208,34,34 );
	gfx.PutPixel( 146 + x,48 + y,208,34,34 );
	gfx.PutPixel( 147 + x,48 + y,208,34,34 );
	gfx.PutPixel( 148 + x,48 + y,208,34,34 );
	gfx.PutPixel( 149 + x,48 + y,208,34,34 );
	gfx.PutPixel( 0 + x,49 + y,208,34,34 );
	gfx.PutPixel( 1 + x,49 + y,208,34,34 );
	gfx.PutPixel( 2 + x,49 + y,208,34,34 );
	gfx.PutPixel( 3 + x,49 + y,208,34,34 );
	gfx.PutPixel( 4 + x,49 + y,208,34,34 );
	gfx.PutPixel( 5 + x,49 + y,208,34,34 );
	gfx.PutPixel( 6 + x,49 + y,208,34,34 );
	gfx.PutPixel( 7 + x,49 + y,208,34,34 );
	gfx.PutPixel( 8 + x,49 + y,208,34,34 );
	gfx.PutPixel( 9 + x,49 + y,208,34,34 );
	gfx.PutPixel( 10 + x,49 + y,208,34,34 );
	gfx.PutPixel( 11 + x,49 + y,208,34,34 );
	gfx.PutPixel( 12 + x,49 + y,208,34,34 );
	gfx.PutPixel( 13 + x,49 + y,208,34,34 );
	gfx.PutPixel( 14 + x,49 + y,208,34,34 );
	gfx.PutPixel( 15 + x,49 + y,208,34,34 );
	gfx.PutPixel( 16 + x,49 + y,208,34,34 );
	gfx.PutPixel( 17 + x,49 + y,208,34,34 );
	gfx.PutPixel( 18 + x,49 + y,208,34,34 );
	gfx.PutPixel( 19 + x,49 + y,208,34,34 );
	gfx.PutPixel( 20 + x,49 + y,208,34,34 );
	gfx.PutPixel( 21 + x,49 + y,208,34,34 );
	gfx.PutPixel( 22 + x,49 + y,208,34,34 );
	gfx.PutPixel( 23 + x,49 + y,208,34,34 );
	gfx.PutPixel( 24 + x,49 + y,208,34,34 );
	gfx.PutPixel( 25 + x,49 + y,208,34,34 );
	gfx.PutPixel( 26 + x,49 + y,208,34,34 );
	gfx.PutPixel( 27 + x,49 + y,208,34,34 );
	gfx.PutPixel( 28 + x,49 + y,208,34,34 );
	gfx.PutPixel( 29 + x,49 + y,208,34,34 );
	gfx.PutPixel( 30 + x,49 + y,208,34,34 );
	gfx.PutPixel( 31 + x,49 + y,208,34,34 );
	gfx.PutPixel( 32 + x,49 + y,208,34,34 );
	gfx.PutPixel( 33 + x,49 + y,208,34,34 );
	gfx.PutPixel( 34 + x,49 + y,208,34,34 );
	gfx.PutPixel( 35 + x,49 + y,208,34,34 );
	gfx.PutPixel( 36 + x,49 + y,208,34,34 );
	gfx.PutPixel( 37 + x,49 + y,208,34,34 );
	gfx.PutPixel( 38 + x,49 + y,208,34,34 );
	gfx.PutPixel( 39 + x,49 + y,208,34,34 );
	gfx.PutPixel( 40 + x,49 + y,208,34,34 );
	gfx.PutPixel( 41 + x,49 + y,208,34,34 );
	gfx.PutPixel( 42 + x,49 + y,208,34,34 );
	gfx.PutPixel( 43 + x,49 + y,208,34,34 );
	gfx.PutPixel( 44 + x,49 + y,208,34,34 );
	gfx.PutPixel( 45 + x,49 + y,208,33,33 );
	gfx.PutPixel( 46 + x,49 + y,207,26,26 );
	gfx.PutPixel( 47 + x,49 + y,207,25,25 );
	gfx.PutPixel( 48 + x,49 + y,207,25,25 );
	gfx.PutPixel( 49 + x,49 + y,208,30,30 );
	gfx.PutPixel( 50 + x,49 + y,208,35,35 );
	gfx.PutPixel( 51 + x,49 + y,208,34,34 );
	gfx.PutPixel( 52 + x,49 + y,208,34,34 );
	gfx.PutPixel( 53 + x,49 + y,208,34,34 );
	gfx.PutPixel( 54 + x,49 + y,208,34,34 );
	gfx.PutPixel( 55 + x,49 + y,208,32,32 );
	gfx.PutPixel( 56 + x,49 + y,207,26,26 );
	gfx.PutPixel( 57 + x,49 + y,207,25,25 );
	gfx.PutPixel( 58 + x,49 + y,207,25,25 );
	gfx.PutPixel( 59 + x,49 + y,207,25,25 );
	gfx.PutPixel( 60 + x,49 + y,208,28,28 );
	gfx.PutPixel( 61 + x,49 + y,208,34,34 );
	gfx.PutPixel( 62 + x,49 + y,208,34,34 );
	gfx.PutPixel( 63 + x,49 + y,208,28,28 );
	gfx.PutPixel( 64 + x,49 + y,207,25,25 );
	gfx.PutPixel( 65 + x,49 + y,207,25,25 );
	gfx.PutPixel( 66 + x,49 + y,207,25,25 );
	gfx.PutPixel( 67 + x,49 + y,207,25,25 );
	gfx.PutPixel( 68 + x,49 + y,207,25,25 );
	gfx.PutPixel( 69 + x,49 + y,207,25,25 );
	gfx.PutPixel( 70 + x,49 + y,207,25,25 );
	gfx.PutPixel( 71 + x,49 + y,207,25,25 );
	gfx.PutPixel( 72 + x,49 + y,207,25,25 );
	gfx.PutPixel( 73 + x,49 + y,207,25,25 );
	gfx.PutPixel( 74 + x,49 + y,208,29,29 );
	gfx.PutPixel( 75 + x,49 + y,208,35,35 );
	gfx.PutPixel( 76 + x,49 + y,208,34,34 );
	gfx.PutPixel( 77 + x,49 + y,208,34,34 );
	gfx.PutPixel( 78 + x,49 + y,208,28,28 );
	gfx.PutPixel( 79 + x,49 + y,207,25,25 );
	gfx.PutPixel( 80 + x,49 + y,207,25,25 );
	gfx.PutPixel( 81 + x,49 + y,207,25,25 );
	gfx.PutPixel( 82 + x,49 + y,207,25,25 );
	gfx.PutPixel( 83 + x,49 + y,207,25,25 );
	gfx.PutPixel( 84 + x,49 + y,207,25,25 );
	gfx.PutPixel( 85 + x,49 + y,207,25,25 );
	gfx.PutPixel( 86 + x,49 + y,207,25,25 );
	gfx.PutPixel( 87 + x,49 + y,207,25,25 );
	gfx.PutPixel( 88 + x,49 + y,207,25,25 );
	gfx.PutPixel( 89 + x,49 + y,208,29,29 );
	gfx.PutPixel( 90 + x,49 + y,208,35,35 );
	gfx.PutPixel( 91 + x,49 + y,208,34,34 );
	gfx.PutPixel( 92 + x,49 + y,208,33,33 );
	gfx.PutPixel( 93 + x,49 + y,207,26,26 );
	gfx.PutPixel( 94 + x,49 + y,207,25,25 );
	gfx.PutPixel( 95 + x,49 + y,207,25,25 );
	gfx.PutPixel( 96 + x,49 + y,207,25,25 );
	gfx.PutPixel( 97 + x,49 + y,207,25,25 );
	gfx.PutPixel( 98 + x,49 + y,207,25,25 );
	gfx.PutPixel( 99 + x,49 + y,207,26,26 );
	gfx.PutPixel( 100 + x,49 + y,208,27,27 );
	gfx.PutPixel( 101 + x,49 + y,208,30,30 );
	gfx.PutPixel( 102 + x,49 + y,208,33,33 );
	gfx.PutPixel( 103 + x,49 + y,208,34,34 );
	gfx.PutPixel( 104 + x,49 + y,208,34,34 );
	gfx.PutPixel( 105 + x,49 + y,208,34,34 );
	gfx.PutPixel( 106 + x,49 + y,208,34,34 );
	gfx.PutPixel( 107 + x,49 + y,208,34,34 );
	gfx.PutPixel( 108 + x,49 + y,208,34,34 );
	gfx.PutPixel( 109 + x,49 + y,208,34,34 );
	gfx.PutPixel( 110 + x,49 + y,208,34,34 );
	gfx.PutPixel( 111 + x,49 + y,208,34,34 );
	gfx.PutPixel( 112 + x,49 + y,208,34,34 );
	gfx.PutPixel( 113 + x,49 + y,208,34,34 );
	gfx.PutPixel( 114 + x,49 + y,208,34,34 );
	gfx.PutPixel( 115 + x,49 + y,208,34,34 );
	gfx.PutPixel( 116 + x,49 + y,208,34,34 );
	gfx.PutPixel( 117 + x,49 + y,208,34,34 );
	gfx.PutPixel( 118 + x,49 + y,208,34,34 );
	gfx.PutPixel( 119 + x,49 + y,208,34,34 );
	gfx.PutPixel( 120 + x,49 + y,208,34,34 );
	gfx.PutPixel( 121 + x,49 + y,208,34,34 );
	gfx.PutPixel( 122 + x,49 + y,208,34,34 );
	gfx.PutPixel( 123 + x,49 + y,208,34,34 );
	gfx.PutPixel( 124 + x,49 + y,208,34,34 );
	gfx.PutPixel( 125 + x,49 + y,208,34,34 );
	gfx.PutPixel( 126 + x,49 + y,208,34,34 );
	gfx.PutPixel( 127 + x,49 + y,208,34,34 );
	gfx.PutPixel( 128 + x,49 + y,208,34,34 );
	gfx.PutPixel( 129 + x,49 + y,208,34,34 );
	gfx.PutPixel( 130 + x,49 + y,208,34,34 );
	gfx.PutPixel( 131 + x,49 + y,208,34,34 );
	gfx.PutPixel( 132 + x,49 + y,208,34,34 );
	gfx.PutPixel( 133 + x,49 + y,208,34,34 );
	gfx.PutPixel( 134 + x,49 + y,208,34,34 );
	gfx.PutPixel( 135 + x,49 + y,208,34,34 );
	gfx.PutPixel( 136 + x,49 + y,208,34,34 );
	gfx.PutPixel( 137 + x,49 + y,208,34,34 );
	gfx.PutPixel( 138 + x,49 + y,208,34,34 );
	gfx.PutPixel( 139 + x,49 + y,208,34,34 );
	gfx.PutPixel( 140 + x,49 + y,208,34,34 );
	gfx.PutPixel( 141 + x,49 + y,208,34,34 );
	gfx.PutPixel( 142 + x,49 + y,208,34,34 );
	gfx.PutPixel( 143 + x,49 + y,208,34,34 );
	gfx.PutPixel( 144 + x,49 + y,208,34,34 );
	gfx.PutPixel( 145 + x,49 + y,208,34,34 );
	gfx.PutPixel( 146 + x,49 + y,208,34,34 );
	gfx.PutPixel( 147 + x,49 + y,208,34,34 );
	gfx.PutPixel( 148 + x,49 + y,208,34,34 );
	gfx.PutPixel( 149 + x,49 + y,208,34,34 );
	gfx.PutPixel( 0 + x,50 + y,208,34,34 );
	gfx.PutPixel( 1 + x,50 + y,208,34,34 );
	gfx.PutPixel( 2 + x,50 + y,208,34,34 );
	gfx.PutPixel( 3 + x,50 + y,208,34,34 );
	gfx.PutPixel( 4 + x,50 + y,208,34,34 );
	gfx.PutPixel( 5 + x,50 + y,208,34,34 );
	gfx.PutPixel( 6 + x,50 + y,208,34,34 );
	gfx.PutPixel( 7 + x,50 + y,208,34,34 );
	gfx.PutPixel( 8 + x,50 + y,208,34,34 );
	gfx.PutPixel( 9 + x,50 + y,208,34,34 );
	gfx.PutPixel( 10 + x,50 + y,208,34,34 );
	gfx.PutPixel( 11 + x,50 + y,208,34,34 );
	gfx.PutPixel( 12 + x,50 + y,208,34,34 );
	gfx.PutPixel( 13 + x,50 + y,208,34,34 );
	gfx.PutPixel( 14 + x,50 + y,208,34,34 );
	gfx.PutPixel( 15 + x,50 + y,208,34,34 );
	gfx.PutPixel( 16 + x,50 + y,208,34,34 );
	gfx.PutPixel( 17 + x,50 + y,208,34,34 );
	gfx.PutPixel( 18 + x,50 + y,208,34,34 );
	gfx.PutPixel( 19 + x,50 + y,208,34,34 );
	gfx.PutPixel( 20 + x,50 + y,208,34,34 );
	gfx.PutPixel( 21 + x,50 + y,208,34,34 );
	gfx.PutPixel( 22 + x,50 + y,208,34,34 );
	gfx.PutPixel( 23 + x,50 + y,208,34,34 );
	gfx.PutPixel( 24 + x,50 + y,208,34,34 );
	gfx.PutPixel( 25 + x,50 + y,208,34,34 );
	gfx.PutPixel( 26 + x,50 + y,208,34,34 );
	gfx.PutPixel( 27 + x,50 + y,208,34,34 );
	gfx.PutPixel( 28 + x,50 + y,208,34,34 );
	gfx.PutPixel( 29 + x,50 + y,208,34,34 );
	gfx.PutPixel( 30 + x,50 + y,208,34,34 );
	gfx.PutPixel( 31 + x,50 + y,208,34,34 );
	gfx.PutPixel( 32 + x,50 + y,208,34,34 );
	gfx.PutPixel( 33 + x,50 + y,208,34,34 );
	gfx.PutPixel( 34 + x,50 + y,208,34,34 );
	gfx.PutPixel( 35 + x,50 + y,208,34,34 );
	gfx.PutPixel( 36 + x,50 + y,208,34,34 );
	gfx.PutPixel( 37 + x,50 + y,208,34,34 );
	gfx.PutPixel( 38 + x,50 + y,208,34,34 );
	gfx.PutPixel( 39 + x,50 + y,208,34,34 );
	gfx.PutPixel( 40 + x,50 + y,208,34,34 );
	gfx.PutPixel( 41 + x,50 + y,208,34,34 );
	gfx.PutPixel( 42 + x,50 + y,208,34,34 );
	gfx.PutPixel( 43 + x,50 + y,208,34,34 );
	gfx.PutPixel( 44 + x,50 + y,208,33,33 );
	gfx.PutPixel( 45 + x,50 + y,208,37,37 );
	gfx.PutPixel( 46 + x,50 + y,211,79,79 );
	gfx.PutPixel( 47 + x,50 + y,211,83,83 );
	gfx.PutPixel( 48 + x,50 + y,212,85,85 );
	gfx.PutPixel( 49 + x,50 + y,210,58,58 );
	gfx.PutPixel( 50 + x,50 + y,208,31,31 );
	gfx.PutPixel( 51 + x,50 + y,208,34,34 );
	gfx.PutPixel( 52 + x,50 + y,208,34,34 );
	gfx.PutPixel( 53 + x,50 + y,208,34,34 );
	gfx.PutPixel( 54 + x,50 + y,208,31,31 );
	gfx.PutPixel( 55 + x,50 + y,208,35,35 );
	gfx.PutPixel( 56 + x,50 + y,211,80,80 );
	gfx.PutPixel( 57 + x,50 + y,211,83,83 );
	gfx.PutPixel( 58 + x,50 + y,211,82,82 );
	gfx.PutPixel( 59 + x,50 + y,212,87,87 );
	gfx.PutPixel( 60 + x,50 + y,211,77,77 );
	gfx.PutPixel( 61 + x,50 + y,208,33,33 );
	gfx.PutPixel( 62 + x,50 + y,208,32,32 );
	gfx.PutPixel( 63 + x,50 + y,211,70,70 );
	gfx.PutPixel( 64 + x,50 + y,212,85,85 );
	gfx.PutPixel( 65 + x,50 + y,211,82,82 );
	gfx.PutPixel( 66 + x,50 + y,211,82,82 );
	gfx.PutPixel( 67 + x,50 + y,211,82,82 );
	gfx.PutPixel( 68 + x,50 + y,211,82,82 );
	gfx.PutPixel( 69 + x,50 + y,211,82,82 );
	gfx.PutPixel( 70 + x,50 + y,211,82,82 );
	gfx.PutPixel( 71 + x,50 + y,211,82,82 );
	gfx.PutPixel( 72 + x,50 + y,211,82,82 );
	gfx.PutPixel( 73 + x,50 + y,212,85,85 );
	gfx.PutPixel( 74 + x,50 + y,210,60,60 );
	gfx.PutPixel( 75 + x,50 + y,208,31,31 );
	gfx.PutPixel( 76 + x,50 + y,208,34,34 );
	gfx.PutPixel( 77 + x,50 + y,208,32,32 );
	gfx.PutPixel( 78 + x,50 + y,211,70,70 );
	gfx.PutPixel( 79 + x,50 + y,212,85,85 );
	gfx.PutPixel( 80 + x,50 + y,211,82,82 );
	gfx.PutPixel( 81 + x,50 + y,211,82,82 );
	gfx.PutPixel( 82 + x,50 + y,211,82,82 );
	gfx.PutPixel( 83 + x,50 + y,211,82,82 );
	gfx.PutPixel( 84 + x,50 + y,211,82,82 );
	gfx.PutPixel( 85 + x,50 + y,211,82,82 );
	gfx.PutPixel( 86 + x,50 + y,211,82,82 );
	gfx.PutPixel( 87 + x,50 + y,211,82,82 );
	gfx.PutPixel( 88 + x,50 + y,212,85,85 );
	gfx.PutPixel( 89 + x,50 + y,210,60,60 );
	gfx.PutPixel( 90 + x,50 + y,208,31,31 );
	gfx.PutPixel( 91 + x,50 + y,208,33,33 );
	gfx.PutPixel( 92 + x,50 + y,208,37,37 );
	gfx.PutPixel( 93 + x,50 + y,211,79,79 );
	gfx.PutPixel( 94 + x,50 + y,211,83,83 );
	gfx.PutPixel( 95 + x,50 + y,211,82,82 );
	gfx.PutPixel( 96 + x,50 + y,211,82,82 );
	gfx.PutPixel( 97 + x,50 + y,211,82,82 );
	gfx.PutPixel( 98 + x,50 + y,211,82,82 );
	gfx.PutPixel( 99 + x,50 + y,211,81,81 );
	gfx.PutPixel( 100 + x,50 + y,211,71,71 );
	gfx.PutPixel( 101 + x,50 + y,209,51,51 );
	gfx.PutPixel( 102 + x,50 + y,208,28,28 );
	gfx.PutPixel( 103 + x,50 + y,207,26,26 );
	gfx.PutPixel( 104 + x,50 + y,208,34,34 );
	gfx.PutPixel( 105 + x,50 + y,208,34,34 );
	gfx.PutPixel( 106 + x,50 + y,208,34,34 );
	gfx.PutPixel( 107 + x,50 + y,208,34,34 );
	gfx.PutPixel( 108 + x,50 + y,208,34,34 );
	gfx.PutPixel( 109 + x,50 + y,208,34,34 );
	gfx.PutPixel( 110 + x,50 + y,208,34,34 );
	gfx.PutPixel( 111 + x,50 + y,208,34,34 );
	gfx.PutPixel( 112 + x,50 + y,208,34,34 );
	gfx.PutPixel( 113 + x,50 + y,208,34,34 );
	gfx.PutPixel( 114 + x,50 + y,208,34,34 );
	gfx.PutPixel( 115 + x,50 + y,208,34,34 );
	gfx.PutPixel( 116 + x,50 + y,208,34,34 );
	gfx.PutPixel( 117 + x,50 + y,208,34,34 );
	gfx.PutPixel( 118 + x,50 + y,208,34,34 );
	gfx.PutPixel( 119 + x,50 + y,208,34,34 );
	gfx.PutPixel( 120 + x,50 + y,208,34,34 );
	gfx.PutPixel( 121 + x,50 + y,208,34,34 );
	gfx.PutPixel( 122 + x,50 + y,208,34,34 );
	gfx.PutPixel( 123 + x,50 + y,208,34,34 );
	gfx.PutPixel( 124 + x,50 + y,208,34,34 );
	gfx.PutPixel( 125 + x,50 + y,208,34,34 );
	gfx.PutPixel( 126 + x,50 + y,208,34,34 );
	gfx.PutPixel( 127 + x,50 + y,208,34,34 );
	gfx.PutPixel( 128 + x,50 + y,208,34,34 );
	gfx.PutPixel( 129 + x,50 + y,208,34,34 );
	gfx.PutPixel( 130 + x,50 + y,208,34,34 );
	gfx.PutPixel( 131 + x,50 + y,208,34,34 );
	gfx.PutPixel( 132 + x,50 + y,208,34,34 );
	gfx.PutPixel( 133 + x,50 + y,208,34,34 );
	gfx.PutPixel( 134 + x,50 + y,208,34,34 );
	gfx.PutPixel( 135 + x,50 + y,208,34,34 );
	gfx.PutPixel( 136 + x,50 + y,208,34,34 );
	gfx.PutPixel( 137 + x,50 + y,208,34,34 );
	gfx.PutPixel( 138 + x,50 + y,208,34,34 );
	gfx.PutPixel( 139 + x,50 + y,208,34,34 );
	gfx.PutPixel( 140 + x,50 + y,208,34,34 );
	gfx.PutPixel( 141 + x,50 + y,208,34,34 );
	gfx.PutPixel( 142 + x,50 + y,208,34,34 );
	gfx.PutPixel( 143 + x,50 + y,208,34,34 );
	gfx.PutPixel( 144 + x,50 + y,208,34,34 );
	gfx.PutPixel( 145 + x,50 + y,208,34,34 );
	gfx.PutPixel( 146 + x,50 + y,208,34,34 );
	gfx.PutPixel( 147 + x,50 + y,208,34,34 );
	gfx.PutPixel( 148 + x,50 + y,208,34,34 );
	gfx.PutPixel( 149 + x,50 + y,208,34,34 );
	gfx.PutPixel( 0 + x,51 + y,208,34,34 );
	gfx.PutPixel( 1 + x,51 + y,208,34,34 );
	gfx.PutPixel( 2 + x,51 + y,208,34,34 );
	gfx.PutPixel( 3 + x,51 + y,208,34,34 );
	gfx.PutPixel( 4 + x,51 + y,208,34,34 );
	gfx.PutPixel( 5 + x,51 + y,208,34,34 );
	gfx.PutPixel( 6 + x,51 + y,208,34,34 );
	gfx.PutPixel( 7 + x,51 + y,208,34,34 );
	gfx.PutPixel( 8 + x,51 + y,208,34,34 );
	gfx.PutPixel( 9 + x,51 + y,208,34,34 );
	gfx.PutPixel( 10 + x,51 + y,208,34,34 );
	gfx.PutPixel( 11 + x,51 + y,208,34,34 );
	gfx.PutPixel( 12 + x,51 + y,208,34,34 );
	gfx.PutPixel( 13 + x,51 + y,208,34,34 );
	gfx.PutPixel( 14 + x,51 + y,208,34,34 );
	gfx.PutPixel( 15 + x,51 + y,208,34,34 );
	gfx.PutPixel( 16 + x,51 + y,208,34,34 );
	gfx.PutPixel( 17 + x,51 + y,208,34,34 );
	gfx.PutPixel( 18 + x,51 + y,208,34,34 );
	gfx.PutPixel( 19 + x,51 + y,208,34,34 );
	gfx.PutPixel( 20 + x,51 + y,208,34,34 );
	gfx.PutPixel( 21 + x,51 + y,208,34,34 );
	gfx.PutPixel( 22 + x,51 + y,208,34,34 );
	gfx.PutPixel( 23 + x,51 + y,208,34,34 );
	gfx.PutPixel( 24 + x,51 + y,208,34,34 );
	gfx.PutPixel( 25 + x,51 + y,208,34,34 );
	gfx.PutPixel( 26 + x,51 + y,208,34,34 );
	gfx.PutPixel( 27 + x,51 + y,208,34,34 );
	gfx.PutPixel( 28 + x,51 + y,208,34,34 );
	gfx.PutPixel( 29 + x,51 + y,208,34,34 );
	gfx.PutPixel( 30 + x,51 + y,208,34,34 );
	gfx.PutPixel( 31 + x,51 + y,208,34,34 );
	gfx.PutPixel( 32 + x,51 + y,208,34,34 );
	gfx.PutPixel( 33 + x,51 + y,208,34,34 );
	gfx.PutPixel( 34 + x,51 + y,208,34,34 );
	gfx.PutPixel( 35 + x,51 + y,208,34,34 );
	gfx.PutPixel( 36 + x,51 + y,208,34,34 );
	gfx.PutPixel( 37 + x,51 + y,208,34,34 );
	gfx.PutPixel( 38 + x,51 + y,208,34,34 );
	gfx.PutPixel( 39 + x,51 + y,208,34,34 );
	gfx.PutPixel( 40 + x,51 + y,208,34,34 );
	gfx.PutPixel( 41 + x,51 + y,208,34,34 );
	gfx.PutPixel( 42 + x,51 + y,208,34,34 );
	gfx.PutPixel( 43 + x,51 + y,208,34,34 );
	gfx.PutPixel( 44 + x,51 + y,208,30,30 );
	gfx.PutPixel( 45 + x,51 + y,209,47,47 );
	gfx.PutPixel( 46 + x,51 + y,220,214,214 );
	gfx.PutPixel( 47 + x,51 + y,221,232,232 );
	gfx.PutPixel( 48 + x,51 + y,223,240,240 );
	gfx.PutPixel( 49 + x,51 + y,215,131,131 );
	gfx.PutPixel( 50 + x,51 + y,207,22,22 );
	gfx.PutPixel( 51 + x,51 + y,208,34,34 );
	gfx.PutPixel( 52 + x,51 + y,208,34,34 );
	gfx.PutPixel( 53 + x,51 + y,208,32,32 );
	gfx.PutPixel( 54 + x,51 + y,208,26,26 );
	gfx.PutPixel( 55 + x,51 + y,216,144,144 );
	gfx.PutPixel( 56 + x,51 + y,222,233,233 );
	gfx.PutPixel( 57 + x,51 + y,221,228,228 );
	gfx.PutPixel( 58 + x,51 + y,222,232,232 );
	gfx.PutPixel( 59 + x,51 + y,222,229,229 );
	gfx.PutPixel( 60 + x,51 + y,212,100,100 );
	gfx.PutPixel( 61 + x,51 + y,207,27,27 );
	gfx.PutPixel( 62 + x,51 + y,208,27,27 );
	gfx.PutPixel( 63 + x,51 + y,218,178,178 );
	gfx.PutPixel( 64 + x,51 + y,223,237,237 );
	gfx.PutPixel( 65 + x,51 + y,221,228,228 );
	gfx.PutPixel( 66 + x,51 + y,221,228,228 );
	gfx.PutPixel( 67 + x,51 + y,221,228,228 );
	gfx.PutPixel( 68 + x,51 + y,221,228,228 );
	gfx.PutPixel( 69 + x,51 + y,221,228,228 );
	gfx.PutPixel( 70 + x,51 + y,221,228,228 );
	gfx.PutPixel( 71 + x,51 + y,221,228,228 );
	gfx.PutPixel( 72 + x,51 + y,221,228,228 );
	gfx.PutPixel( 73 + x,51 + y,223,239,239 );
	gfx.PutPixel( 74 + x,51 + y,215,140,140 );
	gfx.PutPixel( 75 + x,51 + y,207,23,23 );
	gfx.PutPixel( 76 + x,51 + y,208,33,33 );
	gfx.PutPixel( 77 + x,51 + y,208,27,27 );
	gfx.PutPixel( 78 + x,51 + y,218,178,178 );
	gfx.PutPixel( 79 + x,51 + y,223,237,237 );
	gfx.PutPixel( 80 + x,51 + y,221,228,228 );
	gfx.PutPixel( 81 + x,51 + y,221,228,228 );
	gfx.PutPixel( 82 + x,51 + y,221,228,228 );
	gfx.PutPixel( 83 + x,51 + y,221,228,228 );
	gfx.PutPixel( 84 + x,51 + y,221,228,228 );
	gfx.PutPixel( 85 + x,51 + y,221,228,228 );
	gfx.PutPixel( 86 + x,51 + y,221,228,228 );
	gfx.PutPixel( 87 + x,51 + y,221,228,228 );
	gfx.PutPixel( 88 + x,51 + y,223,239,239 );
	gfx.PutPixel( 89 + x,51 + y,215,140,140 );
	gfx.PutPixel( 90 + x,51 + y,207,23,23 );
	gfx.PutPixel( 91 + x,51 + y,208,30,30 );
	gfx.PutPixel( 92 + x,51 + y,209,47,47 );
	gfx.PutPixel( 93 + x,51 + y,220,214,214 );
	gfx.PutPixel( 94 + x,51 + y,221,232,232 );
	gfx.PutPixel( 95 + x,51 + y,221,228,228 );
	gfx.PutPixel( 96 + x,51 + y,221,228,228 );
	gfx.PutPixel( 97 + x,51 + y,221,228,228 );
	gfx.PutPixel( 98 + x,51 + y,221,228,228 );
	gfx.PutPixel( 99 + x,51 + y,221,227,227 );
	gfx.PutPixel( 100 + x,51 + y,221,222,222 );
	gfx.PutPixel( 101 + x,51 + y,220,210,210 );
	gfx.PutPixel( 102 + x,51 + y,217,172,172 );
	gfx.PutPixel( 103 + x,51 + y,211,81,81 );
	gfx.PutPixel( 104 + x,51 + y,207,25,25 );
	gfx.PutPixel( 105 + x,51 + y,208,34,34 );
	gfx.PutPixel( 106 + x,51 + y,208,34,34 );
	gfx.PutPixel( 107 + x,51 + y,208,34,34 );
	gfx.PutPixel( 108 + x,51 + y,208,34,34 );
	gfx.PutPixel( 109 + x,51 + y,208,34,34 );
	gfx.PutPixel( 110 + x,51 + y,208,34,34 );
	gfx.PutPixel( 111 + x,51 + y,208,34,34 );
	gfx.PutPixel( 112 + x,51 + y,208,34,34 );
	gfx.PutPixel( 113 + x,51 + y,208,34,34 );
	gfx.PutPixel( 114 + x,51 + y,208,34,34 );
	gfx.PutPixel( 115 + x,51 + y,208,34,34 );
	gfx.PutPixel( 116 + x,51 + y,208,34,34 );
	gfx.PutPixel( 117 + x,51 + y,208,34,34 );
	gfx.PutPixel( 118 + x,51 + y,208,34,34 );
	gfx.PutPixel( 119 + x,51 + y,208,34,34 );
	gfx.PutPixel( 120 + x,51 + y,208,34,34 );
	gfx.PutPixel( 121 + x,51 + y,208,34,34 );
	gfx.PutPixel( 122 + x,51 + y,208,34,34 );
	gfx.PutPixel( 123 + x,51 + y,208,34,34 );
	gfx.PutPixel( 124 + x,51 + y,208,34,34 );
	gfx.PutPixel( 125 + x,51 + y,208,34,34 );
	gfx.PutPixel( 126 + x,51 + y,208,34,34 );
	gfx.PutPixel( 127 + x,51 + y,208,34,34 );
	gfx.PutPixel( 128 + x,51 + y,208,34,34 );
	gfx.PutPixel( 129 + x,51 + y,208,34,34 );
	gfx.PutPixel( 130 + x,51 + y,208,34,34 );
	gfx.PutPixel( 131 + x,51 + y,208,34,34 );
	gfx.PutPixel( 132 + x,51 + y,208,34,34 );
	gfx.PutPixel( 133 + x,51 + y,208,34,34 );
	gfx.PutPixel( 134 + x,51 + y,208,34,34 );
	gfx.PutPixel( 135 + x,51 + y,208,34,34 );
	gfx.PutPixel( 136 + x,51 + y,208,34,34 );
	gfx.PutPixel( 137 + x,51 + y,208,34,34 );
	gfx.PutPixel( 138 + x,51 + y,208,34,34 );
	gfx.PutPixel( 139 + x,51 + y,208,34,34 );
	gfx.PutPixel( 140 + x,51 + y,208,34,34 );
	gfx.PutPixel( 141 + x,51 + y,208,34,34 );
	gfx.PutPixel( 142 + x,51 + y,208,34,34 );
	gfx.PutPixel( 143 + x,51 + y,208,34,34 );
	gfx.PutPixel( 144 + x,51 + y,208,34,34 );
	gfx.PutPixel( 145 + x,51 + y,208,34,34 );
	gfx.PutPixel( 146 + x,51 + y,208,34,34 );
	gfx.PutPixel( 147 + x,51 + y,208,34,34 );
	gfx.PutPixel( 148 + x,51 + y,208,34,34 );
	gfx.PutPixel( 149 + x,51 + y,208,34,34 );
	gfx.PutPixel( 0 + x,52 + y,208,34,34 );
	gfx.PutPixel( 1 + x,52 + y,208,34,34 );
	gfx.PutPixel( 2 + x,52 + y,208,34,34 );
	gfx.PutPixel( 3 + x,52 + y,208,34,34 );
	gfx.PutPixel( 4 + x,52 + y,208,34,34 );
	gfx.PutPixel( 5 + x,52 + y,208,34,34 );
	gfx.PutPixel( 6 + x,52 + y,208,34,34 );
	gfx.PutPixel( 7 + x,52 + y,208,34,34 );
	gfx.PutPixel( 8 + x,52 + y,208,34,34 );
	gfx.PutPixel( 9 + x,52 + y,208,34,34 );
	gfx.PutPixel( 10 + x,52 + y,208,34,34 );
	gfx.PutPixel( 11 + x,52 + y,208,34,34 );
	gfx.PutPixel( 12 + x,52 + y,208,34,34 );
	gfx.PutPixel( 13 + x,52 + y,208,34,34 );
	gfx.PutPixel( 14 + x,52 + y,208,34,34 );
	gfx.PutPixel( 15 + x,52 + y,208,34,34 );
	gfx.PutPixel( 16 + x,52 + y,208,34,34 );
	gfx.PutPixel( 17 + x,52 + y,208,34,34 );
	gfx.PutPixel( 18 + x,52 + y,208,34,34 );
	gfx.PutPixel( 19 + x,52 + y,208,34,34 );
	gfx.PutPixel( 20 + x,52 + y,208,34,34 );
	gfx.PutPixel( 21 + x,52 + y,208,34,34 );
	gfx.PutPixel( 22 + x,52 + y,208,34,34 );
	gfx.PutPixel( 23 + x,52 + y,208,34,34 );
	gfx.PutPixel( 24 + x,52 + y,208,34,34 );
	gfx.PutPixel( 25 + x,52 + y,208,34,34 );
	gfx.PutPixel( 26 + x,52 + y,208,34,34 );
	gfx.PutPixel( 27 + x,52 + y,208,34,34 );
	gfx.PutPixel( 28 + x,52 + y,208,34,34 );
	gfx.PutPixel( 29 + x,52 + y,208,34,34 );
	gfx.PutPixel( 30 + x,52 + y,208,34,34 );
	gfx.PutPixel( 31 + x,52 + y,208,34,34 );
	gfx.PutPixel( 32 + x,52 + y,208,34,34 );
	gfx.PutPixel( 33 + x,52 + y,208,34,34 );
	gfx.PutPixel( 34 + x,52 + y,208,34,34 );
	gfx.PutPixel( 35 + x,52 + y,208,34,34 );
	gfx.PutPixel( 36 + x,52 + y,208,34,34 );
	gfx.PutPixel( 37 + x,52 + y,208,34,34 );
	gfx.PutPixel( 38 + x,52 + y,208,34,34 );
	gfx.PutPixel( 39 + x,52 + y,208,34,34 );
	gfx.PutPixel( 40 + x,52 + y,208,34,34 );
	gfx.PutPixel( 41 + x,52 + y,208,34,34 );
	gfx.PutPixel( 42 + x,52 + y,208,34,34 );
	gfx.PutPixel( 43 + x,52 + y,208,34,34 );
	gfx.PutPixel( 44 + x,52 + y,208,30,30 );
	gfx.PutPixel( 45 + x,52 + y,209,47,47 );
	gfx.PutPixel( 46 + x,52 + y,220,208,208 );
	gfx.PutPixel( 47 + x,52 + y,221,225,225 );
	gfx.PutPixel( 48 + x,52 + y,222,234,234 );
	gfx.PutPixel( 49 + x,52 + y,215,128,128 );
	gfx.PutPixel( 50 + x,52 + y,207,22,22 );
	gfx.PutPixel( 51 + x,52 + y,208,34,34 );
	gfx.PutPixel( 52 + x,52 + y,208,32,32 );
	gfx.PutPixel( 53 + x,52 + y,207,24,24 );
	gfx.PutPixel( 54 + x,52 + y,215,134,134 );
	gfx.PutPixel( 55 + x,52 + y,222,232,232 );
	gfx.PutPixel( 56 + x,52 + y,221,222,222 );
	gfx.PutPixel( 57 + x,52 + y,221,225,225 );
	gfx.PutPixel( 58 + x,52 + y,221,226,226 );
	gfx.PutPixel( 59 + x,52 + y,213,99,99 );
	gfx.PutPixel( 60 + x,52 + y,207,22,22 );
	gfx.PutPixel( 61 + x,52 + y,208,34,34 );
	gfx.PutPixel( 62 + x,52 + y,208,27,27 );
	gfx.PutPixel( 63 + x,52 + y,218,173,173 );
	gfx.PutPixel( 64 + x,52 + y,222,231,231 );
	gfx.PutPixel( 65 + x,52 + y,221,221,221 );
	gfx.PutPixel( 66 + x,52 + y,221,222,222 );
	gfx.PutPixel( 67 + x,52 + y,221,222,222 );
	gfx.PutPixel( 68 + x,52 + y,221,222,222 );
	gfx.PutPixel( 69 + x,52 + y,221,222,222 );
	gfx.PutPixel( 70 + x,52 + y,221,222,222 );
	gfx.PutPixel( 71 + x,52 + y,221,222,222 );
	gfx.PutPixel( 72 + x,52 + y,221,222,222 );
	gfx.PutPixel( 73 + x,52 + y,222,233,233 );
	gfx.PutPixel( 74 + x,52 + y,215,137,137 );
	gfx.PutPixel( 75 + x,52 + y,207,23,23 );
	gfx.PutPixel( 76 + x,52 + y,208,33,33 );
	gfx.PutPixel( 77 + x,52 + y,208,27,27 );
	gfx.PutPixel( 78 + x,52 + y,218,173,173 );
	gfx.PutPixel( 79 + x,52 + y,222,231,231 );
	gfx.PutPixel( 80 + x,52 + y,221,221,221 );
	gfx.PutPixel( 81 + x,52 + y,221,222,222 );
	gfx.PutPixel( 82 + x,52 + y,221,222,222 );
	gfx.PutPixel( 83 + x,52 + y,221,222,222 );
	gfx.PutPixel( 84 + x,52 + y,221,222,222 );
	gfx.PutPixel( 85 + x,52 + y,221,222,222 );
	gfx.PutPixel( 86 + x,52 + y,221,222,222 );
	gfx.PutPixel( 87 + x,52 + y,221,222,222 );
	gfx.PutPixel( 88 + x,52 + y,222,233,233 );
	gfx.PutPixel( 89 + x,52 + y,215,137,137 );
	gfx.PutPixel( 90 + x,52 + y,207,23,23 );
	gfx.PutPixel( 91 + x,52 + y,208,30,30 );
	gfx.PutPixel( 92 + x,52 + y,209,47,47 );
	gfx.PutPixel( 93 + x,52 + y,220,208,208 );
	gfx.PutPixel( 94 + x,52 + y,221,225,225 );
	gfx.PutPixel( 95 + x,52 + y,221,221,221 );
	gfx.PutPixel( 96 + x,52 + y,221,223,223 );
	gfx.PutPixel( 97 + x,52 + y,221,225,225 );
	gfx.PutPixel( 98 + x,52 + y,221,225,225 );
	gfx.PutPixel( 99 + x,52 + y,221,224,224 );
	gfx.PutPixel( 100 + x,52 + y,221,223,223 );
	gfx.PutPixel( 101 + x,52 + y,221,224,224 );
	gfx.PutPixel( 102 + x,52 + y,222,232,232 );
	gfx.PutPixel( 103 + x,52 + y,222,226,226 );
	gfx.PutPixel( 104 + x,52 + y,212,100,100 );
	gfx.PutPixel( 105 + x,52 + y,207,25,25 );
	gfx.PutPixel( 106 + x,52 + y,208,34,34 );
	gfx.PutPixel( 107 + x,52 + y,208,34,34 );
	gfx.PutPixel( 108 + x,52 + y,208,34,34 );
	gfx.PutPixel( 109 + x,52 + y,208,34,34 );
	gfx.PutPixel( 110 + x,52 + y,208,34,34 );
	gfx.PutPixel( 111 + x,52 + y,208,34,34 );
	gfx.PutPixel( 112 + x,52 + y,208,34,34 );
	gfx.PutPixel( 113 + x,52 + y,208,34,34 );
	gfx.PutPixel( 114 + x,52 + y,208,34,34 );
	gfx.PutPixel( 115 + x,52 + y,208,34,34 );
	gfx.PutPixel( 116 + x,52 + y,208,34,34 );
	gfx.PutPixel( 117 + x,52 + y,208,34,34 );
	gfx.PutPixel( 118 + x,52 + y,208,34,34 );
	gfx.PutPixel( 119 + x,52 + y,208,34,34 );
	gfx.PutPixel( 120 + x,52 + y,208,34,34 );
	gfx.PutPixel( 121 + x,52 + y,208,34,34 );
	gfx.PutPixel( 122 + x,52 + y,208,34,34 );
	gfx.PutPixel( 123 + x,52 + y,208,34,34 );
	gfx.PutPixel( 124 + x,52 + y,208,34,34 );
	gfx.PutPixel( 125 + x,52 + y,208,34,34 );
	gfx.PutPixel( 126 + x,52 + y,208,34,34 );
	gfx.PutPixel( 127 + x,52 + y,208,34,34 );
	gfx.PutPixel( 128 + x,52 + y,208,34,34 );
	gfx.PutPixel( 129 + x,52 + y,208,34,34 );
	gfx.PutPixel( 130 + x,52 + y,208,34,34 );
	gfx.PutPixel( 131 + x,52 + y,208,34,34 );
	gfx.PutPixel( 132 + x,52 + y,208,34,34 );
	gfx.PutPixel( 133 + x,52 + y,208,34,34 );
	gfx.PutPixel( 134 + x,52 + y,208,34,34 );
	gfx.PutPixel( 135 + x,52 + y,208,34,34 );
	gfx.PutPixel( 136 + x,52 + y,208,34,34 );
	gfx.PutPixel( 137 + x,52 + y,208,34,34 );
	gfx.PutPixel( 138 + x,52 + y,208,34,34 );
	gfx.PutPixel( 139 + x,52 + y,208,34,34 );
	gfx.PutPixel( 140 + x,52 + y,208,34,34 );
	gfx.PutPixel( 141 + x,52 + y,208,34,34 );
	gfx.PutPixel( 142 + x,52 + y,208,34,34 );
	gfx.PutPixel( 143 + x,52 + y,208,34,34 );
	gfx.PutPixel( 144 + x,52 + y,208,34,34 );
	gfx.PutPixel( 145 + x,52 + y,208,34,34 );
	gfx.PutPixel( 146 + x,52 + y,208,34,34 );
	gfx.PutPixel( 147 + x,52 + y,208,34,34 );
	gfx.PutPixel( 148 + x,52 + y,208,34,34 );
	gfx.PutPixel( 149 + x,52 + y,208,34,34 );
	gfx.PutPixel( 0 + x,53 + y,208,34,34 );
	gfx.PutPixel( 1 + x,53 + y,208,34,34 );
	gfx.PutPixel( 2 + x,53 + y,208,34,34 );
	gfx.PutPixel( 3 + x,53 + y,208,34,34 );
	gfx.PutPixel( 4 + x,53 + y,208,34,34 );
	gfx.PutPixel( 5 + x,53 + y,208,34,34 );
	gfx.PutPixel( 6 + x,53 + y,208,34,34 );
	gfx.PutPixel( 7 + x,53 + y,208,34,34 );
	gfx.PutPixel( 8 + x,53 + y,208,34,34 );
	gfx.PutPixel( 9 + x,53 + y,208,34,34 );
	gfx.PutPixel( 10 + x,53 + y,208,34,34 );
	gfx.PutPixel( 11 + x,53 + y,208,34,34 );
	gfx.PutPixel( 12 + x,53 + y,208,34,34 );
	gfx.PutPixel( 13 + x,53 + y,208,34,34 );
	gfx.PutPixel( 14 + x,53 + y,208,34,34 );
	gfx.PutPixel( 15 + x,53 + y,208,34,34 );
	gfx.PutPixel( 16 + x,53 + y,208,34,34 );
	gfx.PutPixel( 17 + x,53 + y,208,34,34 );
	gfx.PutPixel( 18 + x,53 + y,208,34,34 );
	gfx.PutPixel( 19 + x,53 + y,208,34,34 );
	gfx.PutPixel( 20 + x,53 + y,208,34,34 );
	gfx.PutPixel( 21 + x,53 + y,208,34,34 );
	gfx.PutPixel( 22 + x,53 + y,208,34,34 );
	gfx.PutPixel( 23 + x,53 + y,208,34,34 );
	gfx.PutPixel( 24 + x,53 + y,208,34,34 );
	gfx.PutPixel( 25 + x,53 + y,208,34,34 );
	gfx.PutPixel( 26 + x,53 + y,208,34,34 );
	gfx.PutPixel( 27 + x,53 + y,208,34,34 );
	gfx.PutPixel( 28 + x,53 + y,208,34,34 );
	gfx.PutPixel( 29 + x,53 + y,208,34,34 );
	gfx.PutPixel( 30 + x,53 + y,208,34,34 );
	gfx.PutPixel( 31 + x,53 + y,208,34,34 );
	gfx.PutPixel( 32 + x,53 + y,208,34,34 );
	gfx.PutPixel( 33 + x,53 + y,208,34,34 );
	gfx.PutPixel( 34 + x,53 + y,208,34,34 );
	gfx.PutPixel( 35 + x,53 + y,208,34,34 );
	gfx.PutPixel( 36 + x,53 + y,208,34,34 );
	gfx.PutPixel( 37 + x,53 + y,208,34,34 );
	gfx.PutPixel( 38 + x,53 + y,208,34,34 );
	gfx.PutPixel( 39 + x,53 + y,208,34,34 );
	gfx.PutPixel( 40 + x,53 + y,208,34,34 );
	gfx.PutPixel( 41 + x,53 + y,208,34,34 );
	gfx.PutPixel( 42 + x,53 + y,208,34,34 );
	gfx.PutPixel( 43 + x,53 + y,208,34,34 );
	gfx.PutPixel( 44 + x,53 + y,208,30,30 );
	gfx.PutPixel( 45 + x,53 + y,209,47,47 );
	gfx.PutPixel( 46 + x,53 + y,220,208,208 );
	gfx.PutPixel( 47 + x,53 + y,221,225,225 );
	gfx.PutPixel( 48 + x,53 + y,222,233,233 );
	gfx.PutPixel( 49 + x,53 + y,215,128,128 );
	gfx.PutPixel( 50 + x,53 + y,207,22,22 );
	gfx.PutPixel( 51 + x,53 + y,208,33,33 );
	gfx.PutPixel( 52 + x,53 + y,207,23,23 );
	gfx.PutPixel( 53 + x,53 + y,214,123,123 );
	gfx.PutPixel( 54 + x,53 + y,222,231,231 );
	gfx.PutPixel( 55 + x,53 + y,221,222,222 );
	gfx.PutPixel( 56 + x,53 + y,221,224,224 );
	gfx.PutPixel( 57 + x,53 + y,221,227,227 );
	gfx.PutPixel( 58 + x,53 + y,213,106,106 );
	gfx.PutPixel( 59 + x,53 + y,207,22,22 );
	gfx.PutPixel( 60 + x,53 + y,208,33,33 );
	gfx.PutPixel( 61 + x,53 + y,208,34,34 );
	gfx.PutPixel( 62 + x,53 + y,208,27,27 );
	gfx.PutPixel( 63 + x,53 + y,218,173,173 );
	gfx.PutPixel( 64 + x,53 + y,222,230,230 );
	gfx.PutPixel( 65 + x,53 + y,221,221,221 );
	gfx.PutPixel( 66 + x,53 + y,221,223,223 );
	gfx.PutPixel( 67 + x,53 + y,221,228,228 );
	gfx.PutPixel( 68 + x,53 + y,221,228,228 );
	gfx.PutPixel( 69 + x,53 + y,221,228,228 );
	gfx.PutPixel( 70 + x,53 + y,221,228,228 );
	gfx.PutPixel( 71 + x,53 + y,221,228,228 );
	gfx.PutPixel( 72 + x,53 + y,221,228,228 );
	gfx.PutPixel( 73 + x,53 + y,223,239,239 );
	gfx.PutPixel( 74 + x,53 + y,215,140,140 );
	gfx.PutPixel( 75 + x,53 + y,207,23,23 );
	gfx.PutPixel( 76 + x,53 + y,208,33,33 );
	gfx.PutPixel( 77 + x,53 + y,208,27,27 );
	gfx.PutPixel( 78 + x,53 + y,218,173,173 );
	gfx.PutPixel( 79 + x,53 + y,222,230,230 );
	gfx.PutPixel( 80 + x,53 + y,221,221,221 );
	gfx.PutPixel( 81 + x,53 + y,221,223,223 );
	gfx.PutPixel( 82 + x,53 + y,221,228,228 );
	gfx.PutPixel( 83 + x,53 + y,221,228,228 );
	gfx.PutPixel( 84 + x,53 + y,221,228,228 );
	gfx.PutPixel( 85 + x,53 + y,221,228,228 );
	gfx.PutPixel( 86 + x,53 + y,221,228,228 );
	gfx.PutPixel( 87 + x,53 + y,221,228,228 );
	gfx.PutPixel( 88 + x,53 + y,223,239,239 );
	gfx.PutPixel( 89 + x,53 + y,215,140,140 );
	gfx.PutPixel( 90 + x,53 + y,207,23,23 );
	gfx.PutPixel( 91 + x,53 + y,208,30,30 );
	gfx.PutPixel( 92 + x,53 + y,209,47,47 );
	gfx.PutPixel( 93 + x,53 + y,220,208,208 );
	gfx.PutPixel( 94 + x,53 + y,221,225,225 );
	gfx.PutPixel( 95 + x,53 + y,221,222,222 );
	gfx.PutPixel( 96 + x,53 + y,221,214,214 );
	gfx.PutPixel( 97 + x,53 + y,220,207,207 );
	gfx.PutPixel( 98 + x,53 + y,220,208,208 );
	gfx.PutPixel( 99 + x,53 + y,220,214,214 );
	gfx.PutPixel( 100 + x,53 + y,222,229,229 );
	gfx.PutPixel( 101 + x,53 + y,221,224,224 );
	gfx.PutPixel( 102 + x,53 + y,221,220,220 );
	gfx.PutPixel( 103 + x,53 + y,221,228,228 );
	gfx.PutPixel( 104 + x,53 + y,220,208,208 );
	gfx.PutPixel( 105 + x,53 + y,209,50,50 );
	gfx.PutPixel( 106 + x,53 + y,208,30,30 );
	gfx.PutPixel( 107 + x,53 + y,208,34,34 );
	gfx.PutPixel( 108 + x,53 + y,208,34,34 );
	gfx.PutPixel( 109 + x,53 + y,208,34,34 );
	gfx.PutPixel( 110 + x,53 + y,208,34,34 );
	gfx.PutPixel( 111 + x,53 + y,208,34,34 );
	gfx.PutPixel( 112 + x,53 + y,208,34,34 );
	gfx.PutPixel( 113 + x,53 + y,208,34,34 );
	gfx.PutPixel( 114 + x,53 + y,208,34,34 );
	gfx.PutPixel( 115 + x,53 + y,208,34,34 );
	gfx.PutPixel( 116 + x,53 + y,208,34,34 );
	gfx.PutPixel( 117 + x,53 + y,208,34,34 );
	gfx.PutPixel( 118 + x,53 + y,208,34,34 );
	gfx.PutPixel( 119 + x,53 + y,208,34,34 );
	gfx.PutPixel( 120 + x,53 + y,208,34,34 );
	gfx.PutPixel( 121 + x,53 + y,208,34,34 );
	gfx.PutPixel( 122 + x,53 + y,208,34,34 );
	gfx.PutPixel( 123 + x,53 + y,208,34,34 );
	gfx.PutPixel( 124 + x,53 + y,208,34,34 );
	gfx.PutPixel( 125 + x,53 + y,208,34,34 );
	gfx.PutPixel( 126 + x,53 + y,208,34,34 );
	gfx.PutPixel( 127 + x,53 + y,208,34,34 );
	gfx.PutPixel( 128 + x,53 + y,208,34,34 );
	gfx.PutPixel( 129 + x,53 + y,208,34,34 );
	gfx.PutPixel( 130 + x,53 + y,208,34,34 );
	gfx.PutPixel( 131 + x,53 + y,208,34,34 );
	gfx.PutPixel( 132 + x,53 + y,208,34,34 );
	gfx.PutPixel( 133 + x,53 + y,208,34,34 );
	gfx.PutPixel( 134 + x,53 + y,208,34,34 );
	gfx.PutPixel( 135 + x,53 + y,208,34,34 );
	gfx.PutPixel( 136 + x,53 + y,208,34,34 );
	gfx.PutPixel( 137 + x,53 + y,208,34,34 );
	gfx.PutPixel( 138 + x,53 + y,208,34,34 );
	gfx.PutPixel( 139 + x,53 + y,208,34,34 );
	gfx.PutPixel( 140 + x,53 + y,208,34,34 );
	gfx.PutPixel( 141 + x,53 + y,208,34,34 );
	gfx.PutPixel( 142 + x,53 + y,208,34,34 );
	gfx.PutPixel( 143 + x,53 + y,208,34,34 );
	gfx.PutPixel( 144 + x,53 + y,208,34,34 );
	gfx.PutPixel( 145 + x,53 + y,208,34,34 );
	gfx.PutPixel( 146 + x,53 + y,208,34,34 );
	gfx.PutPixel( 147 + x,53 + y,208,34,34 );
	gfx.PutPixel( 148 + x,53 + y,208,34,34 );
	gfx.PutPixel( 149 + x,53 + y,208,34,34 );
	gfx.PutPixel( 0 + x,54 + y,208,34,34 );
	gfx.PutPixel( 1 + x,54 + y,208,34,34 );
	gfx.PutPixel( 2 + x,54 + y,208,34,34 );
	gfx.PutPixel( 3 + x,54 + y,208,34,34 );
	gfx.PutPixel( 4 + x,54 + y,208,34,34 );
	gfx.PutPixel( 5 + x,54 + y,208,34,34 );
	gfx.PutPixel( 6 + x,54 + y,208,34,34 );
	gfx.PutPixel( 7 + x,54 + y,208,34,34 );
	gfx.PutPixel( 8 + x,54 + y,208,34,34 );
	gfx.PutPixel( 9 + x,54 + y,208,34,34 );
	gfx.PutPixel( 10 + x,54 + y,208,34,34 );
	gfx.PutPixel( 11 + x,54 + y,208,34,34 );
	gfx.PutPixel( 12 + x,54 + y,208,34,34 );
	gfx.PutPixel( 13 + x,54 + y,208,34,34 );
	gfx.PutPixel( 14 + x,54 + y,208,34,34 );
	gfx.PutPixel( 15 + x,54 + y,208,34,34 );
	gfx.PutPixel( 16 + x,54 + y,208,34,34 );
	gfx.PutPixel( 17 + x,54 + y,208,34,34 );
	gfx.PutPixel( 18 + x,54 + y,208,34,34 );
	gfx.PutPixel( 19 + x,54 + y,208,34,34 );
	gfx.PutPixel( 20 + x,54 + y,208,34,34 );
	gfx.PutPixel( 21 + x,54 + y,208,34,34 );
	gfx.PutPixel( 22 + x,54 + y,208,34,34 );
	gfx.PutPixel( 23 + x,54 + y,208,34,34 );
	gfx.PutPixel( 24 + x,54 + y,208,34,34 );
	gfx.PutPixel( 25 + x,54 + y,208,34,34 );
	gfx.PutPixel( 26 + x,54 + y,208,34,34 );
	gfx.PutPixel( 27 + x,54 + y,208,34,34 );
	gfx.PutPixel( 28 + x,54 + y,208,34,34 );
	gfx.PutPixel( 29 + x,54 + y,208,34,34 );
	gfx.PutPixel( 30 + x,54 + y,208,34,34 );
	gfx.PutPixel( 31 + x,54 + y,208,34,34 );
	gfx.PutPixel( 32 + x,54 + y,208,34,34 );
	gfx.PutPixel( 33 + x,54 + y,208,34,34 );
	gfx.PutPixel( 34 + x,54 + y,208,34,34 );
	gfx.PutPixel( 35 + x,54 + y,208,34,34 );
	gfx.PutPixel( 36 + x,54 + y,208,34,34 );
	gfx.PutPixel( 37 + x,54 + y,208,34,34 );
	gfx.PutPixel( 38 + x,54 + y,208,34,34 );
	gfx.PutPixel( 39 + x,54 + y,208,34,34 );
	gfx.PutPixel( 40 + x,54 + y,208,34,34 );
	gfx.PutPixel( 41 + x,54 + y,208,34,34 );
	gfx.PutPixel( 42 + x,54 + y,208,34,34 );
	gfx.PutPixel( 43 + x,54 + y,208,34,34 );
	gfx.PutPixel( 44 + x,54 + y,208,30,30 );
	gfx.PutPixel( 45 + x,54 + y,209,47,47 );
	gfx.PutPixel( 46 + x,54 + y,220,208,208 );
	gfx.PutPixel( 47 + x,54 + y,221,225,225 );
	gfx.PutPixel( 48 + x,54 + y,222,233,233 );
	gfx.PutPixel( 49 + x,54 + y,215,128,128 );
	gfx.PutPixel( 50 + x,54 + y,207,21,21 );
	gfx.PutPixel( 51 + x,54 + y,207,22,22 );
	gfx.PutPixel( 52 + x,54 + y,213,113,113 );
	gfx.PutPixel( 53 + x,54 + y,222,229,229 );
	gfx.PutPixel( 54 + x,54 + y,221,223,223 );
	gfx.PutPixel( 55 + x,54 + y,221,223,223 );
	gfx.PutPixel( 56 + x,54 + y,221,229,229 );
	gfx.PutPixel( 57 + x,54 + y,213,112,112 );
	gfx.PutPixel( 58 + x,54 + y,207,22,22 );
	gfx.PutPixel( 59 + x,54 + y,208,33,33 );
	gfx.PutPixel( 60 + x,54 + y,208,34,34 );
	gfx.PutPixel( 61 + x,54 + y,208,34,34 );
	gfx.PutPixel( 62 + x,54 + y,208,27,27 );
	gfx.PutPixel( 63 + x,54 + y,218,173,173 );
	gfx.PutPixel( 64 + x,54 + y,222,230,230 );
	gfx.PutPixel( 65 + x,54 + y,222,228,228 );
	gfx.PutPixel( 66 + x,54 + y,219,185,185 );
	gfx.PutPixel( 67 + x,54 + y,211,77,77 );
	gfx.PutPixel( 68 + x,54 + y,211,82,82 );
	gfx.PutPixel( 69 + x,54 + y,211,82,82 );
	gfx.PutPixel( 70 + x,54 + y,211,82,82 );
	gfx.PutPixel( 71 + x,54 + y,211,82,82 );
	gfx.PutPixel( 72 + x,54 + y,211,82,82 );
	gfx.PutPixel( 73 + x,54 + y,212,85,85 );
	gfx.PutPixel( 74 + x,54 + y,210,60,60 );
	gfx.PutPixel( 75 + x,54 + y,208,31,31 );
	gfx.PutPixel( 76 + x,54 + y,208,34,34 );
	gfx.PutPixel( 77 + x,54 + y,208,27,27 );
	gfx.PutPixel( 78 + x,54 + y,218,173,173 );
	gfx.PutPixel( 79 + x,54 + y,222,230,230 );
	gfx.PutPixel( 80 + x,54 + y,222,228,228 );
	gfx.PutPixel( 81 + x,54 + y,219,185,185 );
	gfx.PutPixel( 82 + x,54 + y,211,77,77 );
	gfx.PutPixel( 83 + x,54 + y,211,82,82 );
	gfx.PutPixel( 84 + x,54 + y,211,82,82 );
	gfx.PutPixel( 85 + x,54 + y,211,82,82 );
	gfx.PutPixel( 86 + x,54 + y,211,82,82 );
	gfx.PutPixel( 87 + x,54 + y,211,82,82 );
	gfx.PutPixel( 88 + x,54 + y,212,85,85 );
	gfx.PutPixel( 89 + x,54 + y,210,60,60 );
	gfx.PutPixel( 90 + x,54 + y,208,31,31 );
	gfx.PutPixel( 91 + x,54 + y,208,30,30 );
	gfx.PutPixel( 92 + x,54 + y,209,47,47 );
	gfx.PutPixel( 93 + x,54 + y,220,208,208 );
	gfx.PutPixel( 94 + x,54 + y,221,225,225 );
	gfx.PutPixel( 95 + x,54 + y,222,232,232 );
	gfx.PutPixel( 96 + x,54 + y,215,134,134 );
	gfx.PutPixel( 97 + x,54 + y,208,36,36 );
	gfx.PutPixel( 98 + x,54 + y,209,48,48 );
	gfx.PutPixel( 99 + x,54 + y,209,55,55 );
	gfx.PutPixel( 100 + x,54 + y,213,110,110 );
	gfx.PutPixel( 101 + x,54 + y,221,214,214 );
	gfx.PutPixel( 102 + x,54 + y,221,223,223 );
	gfx.PutPixel( 103 + x,54 + y,221,221,221 );
	gfx.PutPixel( 104 + x,54 + y,222,232,232 );
	gfx.PutPixel( 105 + x,54 + y,213,100,100 );
	gfx.PutPixel( 106 + x,54 + y,207,24,24 );
	gfx.PutPixel( 107 + x,54 + y,208,34,34 );
	gfx.PutPixel( 108 + x,54 + y,208,34,34 );
	gfx.PutPixel( 109 + x,54 + y,208,34,34 );
	gfx.PutPixel( 110 + x,54 + y,208,34,34 );
	gfx.PutPixel( 111 + x,54 + y,208,34,34 );
	gfx.PutPixel( 112 + x,54 + y,208,34,34 );
	gfx.PutPixel( 113 + x,54 + y,208,34,34 );
	gfx.PutPixel( 114 + x,54 + y,208,34,34 );
	gfx.PutPixel( 115 + x,54 + y,208,34,34 );
	gfx.PutPixel( 116 + x,54 + y,208,34,34 );
	gfx.PutPixel( 117 + x,54 + y,208,34,34 );
	gfx.PutPixel( 118 + x,54 + y,208,34,34 );
	gfx.PutPixel( 119 + x,54 + y,208,34,34 );
	gfx.PutPixel( 120 + x,54 + y,208,34,34 );
	gfx.PutPixel( 121 + x,54 + y,208,34,34 );
	gfx.PutPixel( 122 + x,54 + y,208,34,34 );
	gfx.PutPixel( 123 + x,54 + y,208,34,34 );
	gfx.PutPixel( 124 + x,54 + y,208,34,34 );
	gfx.PutPixel( 125 + x,54 + y,208,34,34 );
	gfx.PutPixel( 126 + x,54 + y,208,34,34 );
	gfx.PutPixel( 127 + x,54 + y,208,34,34 );
	gfx.PutPixel( 128 + x,54 + y,208,34,34 );
	gfx.PutPixel( 129 + x,54 + y,208,34,34 );
	gfx.PutPixel( 130 + x,54 + y,208,34,34 );
	gfx.PutPixel( 131 + x,54 + y,208,34,34 );
	gfx.PutPixel( 132 + x,54 + y,208,34,34 );
	gfx.PutPixel( 133 + x,54 + y,208,34,34 );
	gfx.PutPixel( 134 + x,54 + y,208,34,34 );
	gfx.PutPixel( 135 + x,54 + y,208,34,34 );
	gfx.PutPixel( 136 + x,54 + y,208,34,34 );
	gfx.PutPixel( 137 + x,54 + y,208,34,34 );
	gfx.PutPixel( 138 + x,54 + y,208,34,34 );
	gfx.PutPixel( 139 + x,54 + y,208,34,34 );
	gfx.PutPixel( 140 + x,54 + y,208,34,34 );
	gfx.PutPixel( 141 + x,54 + y,208,34,34 );
	gfx.PutPixel( 142 + x,54 + y,208,34,34 );
	gfx.PutPixel( 143 + x,54 + y,208,34,34 );
	gfx.PutPixel( 144 + x,54 + y,208,34,34 );
	gfx.PutPixel( 145 + x,54 + y,208,34,34 );
	gfx.PutPixel( 146 + x,54 + y,208,34,34 );
	gfx.PutPixel( 147 + x,54 + y,208,34,34 );
	gfx.PutPixel( 148 + x,54 + y,208,34,34 );
	gfx.PutPixel( 149 + x,54 + y,208,34,34 );
	gfx.PutPixel( 0 + x,55 + y,208,34,34 );
	gfx.PutPixel( 1 + x,55 + y,208,34,34 );
	gfx.PutPixel( 2 + x,55 + y,208,34,34 );
	gfx.PutPixel( 3 + x,55 + y,208,34,34 );
	gfx.PutPixel( 4 + x,55 + y,208,34,34 );
	gfx.PutPixel( 5 + x,55 + y,208,34,34 );
	gfx.PutPixel( 6 + x,55 + y,208,34,34 );
	gfx.PutPixel( 7 + x,55 + y,208,34,34 );
	gfx.PutPixel( 8 + x,55 + y,208,34,34 );
	gfx.PutPixel( 9 + x,55 + y,208,34,34 );
	gfx.PutPixel( 10 + x,55 + y,208,34,34 );
	gfx.PutPixel( 11 + x,55 + y,208,34,34 );
	gfx.PutPixel( 12 + x,55 + y,208,34,34 );
	gfx.PutPixel( 13 + x,55 + y,208,34,34 );
	gfx.PutPixel( 14 + x,55 + y,208,34,34 );
	gfx.PutPixel( 15 + x,55 + y,208,34,34 );
	gfx.PutPixel( 16 + x,55 + y,208,34,34 );
	gfx.PutPixel( 17 + x,55 + y,208,34,34 );
	gfx.PutPixel( 18 + x,55 + y,208,34,34 );
	gfx.PutPixel( 19 + x,55 + y,208,34,34 );
	gfx.PutPixel( 20 + x,55 + y,208,34,34 );
	gfx.PutPixel( 21 + x,55 + y,208,34,34 );
	gfx.PutPixel( 22 + x,55 + y,208,34,34 );
	gfx.PutPixel( 23 + x,55 + y,208,34,34 );
	gfx.PutPixel( 24 + x,55 + y,208,34,34 );
	gfx.PutPixel( 25 + x,55 + y,208,34,34 );
	gfx.PutPixel( 26 + x,55 + y,208,34,34 );
	gfx.PutPixel( 27 + x,55 + y,208,34,34 );
	gfx.PutPixel( 28 + x,55 + y,208,34,34 );
	gfx.PutPixel( 29 + x,55 + y,208,34,34 );
	gfx.PutPixel( 30 + x,55 + y,208,34,34 );
	gfx.PutPixel( 31 + x,55 + y,208,34,34 );
	gfx.PutPixel( 32 + x,55 + y,208,34,34 );
	gfx.PutPixel( 33 + x,55 + y,208,34,34 );
	gfx.PutPixel( 34 + x,55 + y,208,34,34 );
	gfx.PutPixel( 35 + x,55 + y,208,34,34 );
	gfx.PutPixel( 36 + x,55 + y,208,34,34 );
	gfx.PutPixel( 37 + x,55 + y,208,34,34 );
	gfx.PutPixel( 38 + x,55 + y,208,34,34 );
	gfx.PutPixel( 39 + x,55 + y,208,34,34 );
	gfx.PutPixel( 40 + x,55 + y,208,34,34 );
	gfx.PutPixel( 41 + x,55 + y,208,34,34 );
	gfx.PutPixel( 42 + x,55 + y,208,34,34 );
	gfx.PutPixel( 43 + x,55 + y,208,34,34 );
	gfx.PutPixel( 44 + x,55 + y,208,30,30 );
	gfx.PutPixel( 45 + x,55 + y,209,47,47 );
	gfx.PutPixel( 46 + x,55 + y,220,208,208 );
	gfx.PutPixel( 47 + x,55 + y,221,225,225 );
	gfx.PutPixel( 48 + x,55 + y,222,233,233 );
	gfx.PutPixel( 49 + x,55 + y,215,127,127 );
	gfx.PutPixel( 50 + x,55 + y,206,9,9 );
	gfx.PutPixel( 51 + x,55 + y,213,102,102 );
	gfx.PutPixel( 52 + x,55 + y,221,227,227 );
	gfx.PutPixel( 53 + x,55 + y,221,224,224 );
	gfx.PutPixel( 54 + x,55 + y,221,223,223 );
	gfx.PutPixel( 55 + x,55 + y,222,230,230 );
	gfx.PutPixel( 56 + x,55 + y,214,119,119 );
	gfx.PutPixel( 57 + x,55 + y,207,22,22 );
	gfx.PutPixel( 58 + x,55 + y,208,33,33 );
	gfx.PutPixel( 59 + x,55 + y,208,34,34 );
	gfx.PutPixel( 60 + x,55 + y,208,34,34 );
	gfx.PutPixel( 61 + x,55 + y,208,34,34 );
	gfx.PutPixel( 62 + x,55 + y,208,27,27 );
	gfx.PutPixel( 63 + x,55 + y,218,173,173 );
	gfx.PutPixel( 64 + x,55 + y,222,230,230 );
	gfx.PutPixel( 65 + x,55 + y,222,230,230 );
	gfx.PutPixel( 66 + x,55 + y,218,171,171 );
	gfx.PutPixel( 67 + x,55 + y,207,17,17 );
	gfx.PutPixel( 68 + x,55 + y,207,25,25 );
	gfx.PutPixel( 69 + x,55 + y,207,25,25 );
	gfx.PutPixel( 70 + x,55 + y,207,25,25 );
	gfx.PutPixel( 71 + x,55 + y,207,25,25 );
	gfx.PutPixel( 72 + x,55 + y,207,25,25 );
	gfx.PutPixel( 73 + x,55 + y,207,24,24 );
	gfx.PutPixel( 74 + x,55 + y,208,29,29 );
	gfx.PutPixel( 75 + x,55 + y,208,35,35 );
	gfx.PutPixel( 76 + x,55 + y,208,34,34 );
	gfx.PutPixel( 77 + x,55 + y,208,27,27 );
	gfx.PutPixel( 78 + x,55 + y,218,173,173 );
	gfx.PutPixel( 79 + x,55 + y,222,230,230 );
	gfx.PutPixel( 80 + x,55 + y,222,230,230 );
	gfx.PutPixel( 81 + x,55 + y,218,171,171 );
	gfx.PutPixel( 82 + x,55 + y,207,17,17 );
	gfx.PutPixel( 83 + x,55 + y,207,25,25 );
	gfx.PutPixel( 84 + x,55 + y,207,25,25 );
	gfx.PutPixel( 85 + x,55 + y,207,25,25 );
	gfx.PutPixel( 86 + x,55 + y,207,25,25 );
	gfx.PutPixel( 87 + x,55 + y,207,25,25 );
	gfx.PutPixel( 88 + x,55 + y,207,24,24 );
	gfx.PutPixel( 89 + x,55 + y,208,29,29 );
	gfx.PutPixel( 90 + x,55 + y,208,35,35 );
	gfx.PutPixel( 91 + x,55 + y,208,30,30 );
	gfx.PutPixel( 92 + x,55 + y,209,47,47 );
	gfx.PutPixel( 93 + x,55 + y,220,208,208 );
	gfx.PutPixel( 94 + x,55 + y,221,225,225 );
	gfx.PutPixel( 95 + x,55 + y,222,233,233 );
	gfx.PutPixel( 96 + x,55 + y,215,126,126 );
	gfx.PutPixel( 97 + x,55 + y,207,18,18 );
	gfx.PutPixel( 98 + x,55 + y,208,30,30 );
	gfx.PutPixel( 99 + x,55 + y,208,29,29 );
	gfx.PutPixel( 100 + x,55 + y,206,15,15 );
	gfx.PutPixel( 101 + x,55 + y,215,140,140 );
	gfx.PutPixel( 102 + x,55 + y,222,232,232 );
	gfx.PutPixel( 103 + x,55 + y,221,221,221 );
	gfx.PutPixel( 104 + x,55 + y,222,233,233 );
	gfx.PutPixel( 105 + x,55 + y,214,125,125 );
	gfx.PutPixel( 106 + x,55 + y,207,22,22 );
	gfx.PutPixel( 107 + x,55 + y,208,34,34 );
	gfx.PutPixel( 108 + x,55 + y,208,34,34 );
	gfx.PutPixel( 109 + x,55 + y,208,34,34 );
	gfx.PutPixel( 110 + x,55 + y,208,34,34 );
	gfx.PutPixel( 111 + x,55 + y,208,34,34 );
	gfx.PutPixel( 112 + x,55 + y,208,34,34 );
	gfx.PutPixel( 113 + x,55 + y,208,34,34 );
	gfx.PutPixel( 114 + x,55 + y,208,34,34 );
	gfx.PutPixel( 115 + x,55 + y,208,34,34 );
	gfx.PutPixel( 116 + x,55 + y,208,34,34 );
	gfx.PutPixel( 117 + x,55 + y,208,34,34 );
	gfx.PutPixel( 118 + x,55 + y,208,34,34 );
	gfx.PutPixel( 119 + x,55 + y,208,34,34 );
	gfx.PutPixel( 120 + x,55 + y,208,34,34 );
	gfx.PutPixel( 121 + x,55 + y,208,34,34 );
	gfx.PutPixel( 122 + x,55 + y,208,34,34 );
	gfx.PutPixel( 123 + x,55 + y,208,34,34 );
	gfx.PutPixel( 124 + x,55 + y,208,34,34 );
	gfx.PutPixel( 125 + x,55 + y,208,34,34 );
	gfx.PutPixel( 126 + x,55 + y,208,34,34 );
	gfx.PutPixel( 127 + x,55 + y,208,34,34 );
	gfx.PutPixel( 128 + x,55 + y,208,34,34 );
	gfx.PutPixel( 129 + x,55 + y,208,34,34 );
	gfx.PutPixel( 130 + x,55 + y,208,34,34 );
	gfx.PutPixel( 131 + x,55 + y,208,34,34 );
	gfx.PutPixel( 132 + x,55 + y,208,34,34 );
	gfx.PutPixel( 133 + x,55 + y,208,34,34 );
	gfx.PutPixel( 134 + x,55 + y,208,34,34 );
	gfx.PutPixel( 135 + x,55 + y,208,34,34 );
	gfx.PutPixel( 136 + x,55 + y,208,34,34 );
	gfx.PutPixel( 137 + x,55 + y,208,34,34 );
	gfx.PutPixel( 138 + x,55 + y,208,34,34 );
	gfx.PutPixel( 139 + x,55 + y,208,34,34 );
	gfx.PutPixel( 140 + x,55 + y,208,34,34 );
	gfx.PutPixel( 141 + x,55 + y,208,34,34 );
	gfx.PutPixel( 142 + x,55 + y,208,34,34 );
	gfx.PutPixel( 143 + x,55 + y,208,34,34 );
	gfx.PutPixel( 144 + x,55 + y,208,34,34 );
	gfx.PutPixel( 145 + x,55 + y,208,34,34 );
	gfx.PutPixel( 146 + x,55 + y,208,34,34 );
	gfx.PutPixel( 147 + x,55 + y,208,34,34 );
	gfx.PutPixel( 148 + x,55 + y,208,34,34 );
	gfx.PutPixel( 149 + x,55 + y,208,34,34 );
	gfx.PutPixel( 0 + x,56 + y,208,34,34 );
	gfx.PutPixel( 1 + x,56 + y,208,34,34 );
	gfx.PutPixel( 2 + x,56 + y,208,34,34 );
	gfx.PutPixel( 3 + x,56 + y,208,34,34 );
	gfx.PutPixel( 4 + x,56 + y,208,34,34 );
	gfx.PutPixel( 5 + x,56 + y,208,34,34 );
	gfx.PutPixel( 6 + x,56 + y,208,34,34 );
	gfx.PutPixel( 7 + x,56 + y,208,34,34 );
	gfx.PutPixel( 8 + x,56 + y,208,34,34 );
	gfx.PutPixel( 9 + x,56 + y,208,34,34 );
	gfx.PutPixel( 10 + x,56 + y,208,34,34 );
	gfx.PutPixel( 11 + x,56 + y,208,34,34 );
	gfx.PutPixel( 12 + x,56 + y,208,34,34 );
	gfx.PutPixel( 13 + x,56 + y,208,34,34 );
	gfx.PutPixel( 14 + x,56 + y,208,34,34 );
	gfx.PutPixel( 15 + x,56 + y,208,34,34 );
	gfx.PutPixel( 16 + x,56 + y,208,34,34 );
	gfx.PutPixel( 17 + x,56 + y,208,34,34 );
	gfx.PutPixel( 18 + x,56 + y,208,34,34 );
	gfx.PutPixel( 19 + x,56 + y,208,34,34 );
	gfx.PutPixel( 20 + x,56 + y,208,34,34 );
	gfx.PutPixel( 21 + x,56 + y,208,34,34 );
	gfx.PutPixel( 22 + x,56 + y,208,34,34 );
	gfx.PutPixel( 23 + x,56 + y,208,34,34 );
	gfx.PutPixel( 24 + x,56 + y,208,34,34 );
	gfx.PutPixel( 25 + x,56 + y,208,34,34 );
	gfx.PutPixel( 26 + x,56 + y,208,34,34 );
	gfx.PutPixel( 27 + x,56 + y,208,34,34 );
	gfx.PutPixel( 28 + x,56 + y,208,34,34 );
	gfx.PutPixel( 29 + x,56 + y,208,34,34 );
	gfx.PutPixel( 30 + x,56 + y,208,34,34 );
	gfx.PutPixel( 31 + x,56 + y,208,34,34 );
	gfx.PutPixel( 32 + x,56 + y,208,34,34 );
	gfx.PutPixel( 33 + x,56 + y,208,34,34 );
	gfx.PutPixel( 34 + x,56 + y,208,34,34 );
	gfx.PutPixel( 35 + x,56 + y,208,34,34 );
	gfx.PutPixel( 36 + x,56 + y,208,34,34 );
	gfx.PutPixel( 37 + x,56 + y,208,34,34 );
	gfx.PutPixel( 38 + x,56 + y,208,34,34 );
	gfx.PutPixel( 39 + x,56 + y,208,34,34 );
	gfx.PutPixel( 40 + x,56 + y,208,34,34 );
	gfx.PutPixel( 41 + x,56 + y,208,34,34 );
	gfx.PutPixel( 42 + x,56 + y,208,34,34 );
	gfx.PutPixel( 43 + x,56 + y,208,34,34 );
	gfx.PutPixel( 44 + x,56 + y,208,30,30 );
	gfx.PutPixel( 45 + x,56 + y,209,47,47 );
	gfx.PutPixel( 46 + x,56 + y,220,208,208 );
	gfx.PutPixel( 47 + x,56 + y,221,225,225 );
	gfx.PutPixel( 48 + x,56 + y,222,233,233 );
	gfx.PutPixel( 49 + x,56 + y,214,117,117 );
	gfx.PutPixel( 50 + x,56 + y,211,80,80 );
	gfx.PutPixel( 51 + x,56 + y,221,223,223 );
	gfx.PutPixel( 52 + x,56 + y,221,225,225 );
	gfx.PutPixel( 53 + x,56 + y,221,222,222 );
	gfx.PutPixel( 54 + x,56 + y,222,231,231 );
	gfx.PutPixel( 55 + x,56 + y,214,126,126 );
	gfx.PutPixel( 56 + x,56 + y,207,23,23 );
	gfx.PutPixel( 57 + x,56 + y,208,33,33 );
	gfx.PutPixel( 58 + x,56 + y,208,34,34 );
	gfx.PutPixel( 59 + x,56 + y,208,34,34 );
	gfx.PutPixel( 60 + x,56 + y,208,34,34 );
	gfx.PutPixel( 61 + x,56 + y,208,34,34 );
	gfx.PutPixel( 62 + x,56 + y,208,27,27 );
	gfx.PutPixel( 63 + x,56 + y,218,173,173 );
	gfx.PutPixel( 64 + x,56 + y,222,230,230 );
	gfx.PutPixel( 65 + x,56 + y,222,230,230 );
	gfx.PutPixel( 66 + x,56 + y,218,171,171 );
	gfx.PutPixel( 67 + x,56 + y,208,20,20 );
	gfx.PutPixel( 68 + x,56 + y,208,27,27 );
	gfx.PutPixel( 69 + x,56 + y,208,27,27 );
	gfx.PutPixel( 70 + x,56 + y,208,27,27 );
	gfx.PutPixel( 71 + x,56 + y,208,27,27 );
	gfx.PutPixel( 72 + x,56 + y,208,27,27 );
	gfx.PutPixel( 73 + x,56 + y,208,27,27 );
	gfx.PutPixel( 74 + x,56 + y,208,33,33 );
	gfx.PutPixel( 75 + x,56 + y,208,34,34 );
	gfx.PutPixel( 76 + x,56 + y,208,34,34 );
	gfx.PutPixel( 77 + x,56 + y,208,27,27 );
	gfx.PutPixel( 78 + x,56 + y,218,173,173 );
	gfx.PutPixel( 79 + x,56 + y,222,230,230 );
	gfx.PutPixel( 80 + x,56 + y,222,230,230 );
	gfx.PutPixel( 81 + x,56 + y,218,171,171 );
	gfx.PutPixel( 82 + x,56 + y,208,20,20 );
	gfx.PutPixel( 83 + x,56 + y,208,27,27 );
	gfx.PutPixel( 84 + x,56 + y,208,27,27 );
	gfx.PutPixel( 85 + x,56 + y,208,27,27 );
	gfx.PutPixel( 86 + x,56 + y,208,27,27 );
	gfx.PutPixel( 87 + x,56 + y,208,27,27 );
	gfx.PutPixel( 88 + x,56 + y,208,27,27 );
	gfx.PutPixel( 89 + x,56 + y,208,33,33 );
	gfx.PutPixel( 90 + x,56 + y,208,34,34 );
	gfx.PutPixel( 91 + x,56 + y,208,30,30 );
	gfx.PutPixel( 92 + x,56 + y,209,47,47 );
	gfx.PutPixel( 93 + x,56 + y,220,208,208 );
	gfx.PutPixel( 94 + x,56 + y,221,225,225 );
	gfx.PutPixel( 95 + x,56 + y,222,233,233 );
	gfx.PutPixel( 96 + x,56 + y,215,126,126 );
	gfx.PutPixel( 97 + x,56 + y,207,18,18 );
	gfx.PutPixel( 98 + x,56 + y,208,31,31 );
	gfx.PutPixel( 99 + x,56 + y,208,29,29 );
	gfx.PutPixel( 100 + x,56 + y,206,15,15 );
	gfx.PutPixel( 101 + x,56 + y,216,141,141 );
	gfx.PutPixel( 102 + x,56 + y,222,233,233 );
	gfx.PutPixel( 103 + x,56 + y,221,221,221 );
	gfx.PutPixel( 104 + x,56 + y,222,233,233 );
	gfx.PutPixel( 105 + x,56 + y,214,125,125 );
	gfx.PutPixel( 106 + x,56 + y,207,22,22 );
	gfx.PutPixel( 107 + x,56 + y,208,34,34 );
	gfx.PutPixel( 108 + x,56 + y,208,34,34 );
	gfx.PutPixel( 109 + x,56 + y,208,34,34 );
	gfx.PutPixel( 110 + x,56 + y,208,34,34 );
	gfx.PutPixel( 111 + x,56 + y,208,34,34 );
	gfx.PutPixel( 112 + x,56 + y,208,34,34 );
	gfx.PutPixel( 113 + x,56 + y,208,34,34 );
	gfx.PutPixel( 114 + x,56 + y,208,34,34 );
	gfx.PutPixel( 115 + x,56 + y,208,34,34 );
	gfx.PutPixel( 116 + x,56 + y,208,34,34 );
	gfx.PutPixel( 117 + x,56 + y,208,34,34 );
	gfx.PutPixel( 118 + x,56 + y,208,34,34 );
	gfx.PutPixel( 119 + x,56 + y,208,34,34 );
	gfx.PutPixel( 120 + x,56 + y,208,34,34 );
	gfx.PutPixel( 121 + x,56 + y,208,34,34 );
	gfx.PutPixel( 122 + x,56 + y,208,34,34 );
	gfx.PutPixel( 123 + x,56 + y,208,34,34 );
	gfx.PutPixel( 124 + x,56 + y,208,34,34 );
	gfx.PutPixel( 125 + x,56 + y,208,34,34 );
	gfx.PutPixel( 126 + x,56 + y,208,34,34 );
	gfx.PutPixel( 127 + x,56 + y,208,34,34 );
	gfx.PutPixel( 128 + x,56 + y,208,34,34 );
	gfx.PutPixel( 129 + x,56 + y,208,34,34 );
	gfx.PutPixel( 130 + x,56 + y,208,34,34 );
	gfx.PutPixel( 131 + x,56 + y,208,34,34 );
	gfx.PutPixel( 132 + x,56 + y,208,34,34 );
	gfx.PutPixel( 133 + x,56 + y,208,34,34 );
	gfx.PutPixel( 134 + x,56 + y,208,34,34 );
	gfx.PutPixel( 135 + x,56 + y,208,34,34 );
	gfx.PutPixel( 136 + x,56 + y,208,34,34 );
	gfx.PutPixel( 137 + x,56 + y,208,34,34 );
	gfx.PutPixel( 138 + x,56 + y,208,34,34 );
	gfx.PutPixel( 139 + x,56 + y,208,34,34 );
	gfx.PutPixel( 140 + x,56 + y,208,34,34 );
	gfx.PutPixel( 141 + x,56 + y,208,34,34 );
	gfx.PutPixel( 142 + x,56 + y,208,34,34 );
	gfx.PutPixel( 143 + x,56 + y,208,34,34 );
	gfx.PutPixel( 144 + x,56 + y,208,34,34 );
	gfx.PutPixel( 145 + x,56 + y,208,34,34 );
	gfx.PutPixel( 146 + x,56 + y,208,34,34 );
	gfx.PutPixel( 147 + x,56 + y,208,34,34 );
	gfx.PutPixel( 148 + x,56 + y,208,34,34 );
	gfx.PutPixel( 149 + x,56 + y,208,34,34 );
	gfx.PutPixel( 0 + x,57 + y,208,34,34 );
	gfx.PutPixel( 1 + x,57 + y,208,34,34 );
	gfx.PutPixel( 2 + x,57 + y,208,34,34 );
	gfx.PutPixel( 3 + x,57 + y,208,34,34 );
	gfx.PutPixel( 4 + x,57 + y,208,34,34 );
	gfx.PutPixel( 5 + x,57 + y,208,34,34 );
	gfx.PutPixel( 6 + x,57 + y,208,34,34 );
	gfx.PutPixel( 7 + x,57 + y,208,34,34 );
	gfx.PutPixel( 8 + x,57 + y,208,34,34 );
	gfx.PutPixel( 9 + x,57 + y,208,34,34 );
	gfx.PutPixel( 10 + x,57 + y,208,34,34 );
	gfx.PutPixel( 11 + x,57 + y,208,34,34 );
	gfx.PutPixel( 12 + x,57 + y,208,34,34 );
	gfx.PutPixel( 13 + x,57 + y,208,34,34 );
	gfx.PutPixel( 14 + x,57 + y,208,34,34 );
	gfx.PutPixel( 15 + x,57 + y,208,34,34 );
	gfx.PutPixel( 16 + x,57 + y,208,34,34 );
	gfx.PutPixel( 17 + x,57 + y,208,34,34 );
	gfx.PutPixel( 18 + x,57 + y,208,34,34 );
	gfx.PutPixel( 19 + x,57 + y,208,34,34 );
	gfx.PutPixel( 20 + x,57 + y,208,34,34 );
	gfx.PutPixel( 21 + x,57 + y,208,34,34 );
	gfx.PutPixel( 22 + x,57 + y,208,34,34 );
	gfx.PutPixel( 23 + x,57 + y,208,34,34 );
	gfx.PutPixel( 24 + x,57 + y,208,34,34 );
	gfx.PutPixel( 25 + x,57 + y,208,34,34 );
	gfx.PutPixel( 26 + x,57 + y,208,34,34 );
	gfx.PutPixel( 27 + x,57 + y,208,34,34 );
	gfx.PutPixel( 28 + x,57 + y,208,34,34 );
	gfx.PutPixel( 29 + x,57 + y,208,34,34 );
	gfx.PutPixel( 30 + x,57 + y,208,34,34 );
	gfx.PutPixel( 31 + x,57 + y,208,34,34 );
	gfx.PutPixel( 32 + x,57 + y,208,34,34 );
	gfx.PutPixel( 33 + x,57 + y,208,34,34 );
	gfx.PutPixel( 34 + x,57 + y,208,34,34 );
	gfx.PutPixel( 35 + x,57 + y,208,34,34 );
	gfx.PutPixel( 36 + x,57 + y,208,34,34 );
	gfx.PutPixel( 37 + x,57 + y,208,34,34 );
	gfx.PutPixel( 38 + x,57 + y,208,34,34 );
	gfx.PutPixel( 39 + x,57 + y,208,34,34 );
	gfx.PutPixel( 40 + x,57 + y,208,34,34 );
	gfx.PutPixel( 41 + x,57 + y,208,34,34 );
	gfx.PutPixel( 42 + x,57 + y,208,34,34 );
	gfx.PutPixel( 43 + x,57 + y,208,34,34 );
	gfx.PutPixel( 44 + x,57 + y,208,30,30 );
	gfx.PutPixel( 45 + x,57 + y,209,47,47 );
	gfx.PutPixel( 46 + x,57 + y,220,208,208 );
	gfx.PutPixel( 47 + x,57 + y,221,225,225 );
	gfx.PutPixel( 48 + x,57 + y,221,226,226 );
	gfx.PutPixel( 49 + x,57 + y,218,172,172 );
	gfx.PutPixel( 50 + x,57 + y,220,207,207 );
	gfx.PutPixel( 51 + x,57 + y,221,226,226 );
	gfx.PutPixel( 52 + x,57 + y,221,221,221 );
	gfx.PutPixel( 53 + x,57 + y,222,227,227 );
	gfx.PutPixel( 54 + x,57 + y,215,133,133 );
	gfx.PutPixel( 55 + x,57 + y,207,24,24 );
	gfx.PutPixel( 56 + x,57 + y,208,32,32 );
	gfx.PutPixel( 57 + x,57 + y,208,34,34 );
	gfx.PutPixel( 58 + x,57 + y,208,34,34 );
	gfx.PutPixel( 59 + x,57 + y,208,34,34 );
	gfx.PutPixel( 60 + x,57 + y,208,34,34 );
	gfx.PutPixel( 61 + x,57 + y,208,34,34 );
	gfx.PutPixel( 62 + x,57 + y,208,27,27 );
	gfx.PutPixel( 63 + x,57 + y,218,173,173 );
	gfx.PutPixel( 64 + x,57 + y,222,230,230 );
	gfx.PutPixel( 65 + x,57 + y,221,223,223 );
	gfx.PutPixel( 66 + x,57 + y,220,209,209 );
	gfx.PutPixel( 67 + x,57 + y,218,171,171 );
	gfx.PutPixel( 68 + x,57 + y,218,173,173 );
	gfx.PutPixel( 69 + x,57 + y,218,173,173 );
	gfx.PutPixel( 70 + x,57 + y,218,173,173 );
	gfx.PutPixel( 71 + x,57 + y,218,173,173 );
	gfx.PutPixel( 72 + x,57 + y,218,174,174 );
	gfx.PutPixel( 73 + x,57 + y,218,170,170 );
	gfx.PutPixel( 74 + x,57 + y,209,56,56 );
	gfx.PutPixel( 75 + x,57 + y,208,30,30 );
	gfx.PutPixel( 76 + x,57 + y,208,34,34 );
	gfx.PutPixel( 77 + x,57 + y,208,27,27 );
	gfx.PutPixel( 78 + x,57 + y,218,173,173 );
	gfx.PutPixel( 79 + x,57 + y,222,230,230 );
	gfx.PutPixel( 80 + x,57 + y,221,223,223 );
	gfx.PutPixel( 81 + x,57 + y,220,209,209 );
	gfx.PutPixel( 82 + x,57 + y,218,171,171 );
	gfx.PutPixel( 83 + x,57 + y,218,173,173 );
	gfx.PutPixel( 84 + x,57 + y,218,173,173 );
	gfx.PutPixel( 85 + x,57 + y,218,173,173 );
	gfx.PutPixel( 86 + x,57 + y,218,173,173 );
	gfx.PutPixel( 87 + x,57 + y,218,174,174 );
	gfx.PutPixel( 88 + x,57 + y,218,170,170 );
	gfx.PutPixel( 89 + x,57 + y,209,56,56 );
	gfx.PutPixel( 90 + x,57 + y,208,30,30 );
	gfx.PutPixel( 91 + x,57 + y,208,30,30 );
	gfx.PutPixel( 92 + x,57 + y,209,47,47 );
	gfx.PutPixel( 93 + x,57 + y,220,208,208 );
	gfx.PutPixel( 94 + x,57 + y,221,225,225 );
	gfx.PutPixel( 95 + x,57 + y,222,232,232 );
	gfx.PutPixel( 96 + x,57 + y,215,135,135 );
	gfx.PutPixel( 97 + x,57 + y,208,36,36 );
	gfx.PutPixel( 98 + x,57 + y,209,46,46 );
	gfx.PutPixel( 99 + x,57 + y,209,50,50 );
	gfx.PutPixel( 100 + x,57 + y,213,102,102 );
	gfx.PutPixel( 101 + x,57 + y,221,213,213 );
	gfx.PutPixel( 102 + x,57 + y,221,224,224 );
	gfx.PutPixel( 103 + x,57 + y,221,221,221 );
	gfx.PutPixel( 104 + x,57 + y,222,231,231 );
	gfx.PutPixel( 105 + x,57 + y,212,100,100 );
	gfx.PutPixel( 106 + x,57 + y,207,24,24 );
	gfx.PutPixel( 107 + x,57 + y,208,34,34 );
	gfx.PutPixel( 108 + x,57 + y,208,34,34 );
	gfx.PutPixel( 109 + x,57 + y,208,34,34 );
	gfx.PutPixel( 110 + x,57 + y,208,34,34 );
	gfx.PutPixel( 111 + x,57 + y,208,34,34 );
	gfx.PutPixel( 112 + x,57 + y,208,34,34 );
	gfx.PutPixel( 113 + x,57 + y,208,34,34 );
	gfx.PutPixel( 114 + x,57 + y,208,34,34 );
	gfx.PutPixel( 115 + x,57 + y,208,34,34 );
	gfx.PutPixel( 116 + x,57 + y,208,34,34 );
	gfx.PutPixel( 117 + x,57 + y,208,34,34 );
	gfx.PutPixel( 118 + x,57 + y,208,34,34 );
	gfx.PutPixel( 119 + x,57 + y,208,34,34 );
	gfx.PutPixel( 120 + x,57 + y,208,34,34 );
	gfx.PutPixel( 121 + x,57 + y,208,34,34 );
	gfx.PutPixel( 122 + x,57 + y,208,34,34 );
	gfx.PutPixel( 123 + x,57 + y,208,34,34 );
	gfx.PutPixel( 124 + x,57 + y,208,34,34 );
	gfx.PutPixel( 125 + x,57 + y,208,34,34 );
	gfx.PutPixel( 126 + x,57 + y,208,34,34 );
	gfx.PutPixel( 127 + x,57 + y,208,34,34 );
	gfx.PutPixel( 128 + x,57 + y,208,34,34 );
	gfx.PutPixel( 129 + x,57 + y,208,34,34 );
	gfx.PutPixel( 130 + x,57 + y,208,34,34 );
	gfx.PutPixel( 131 + x,57 + y,208,34,34 );
	gfx.PutPixel( 132 + x,57 + y,208,34,34 );
	gfx.PutPixel( 133 + x,57 + y,208,34,34 );
	gfx.PutPixel( 134 + x,57 + y,208,34,34 );
	gfx.PutPixel( 135 + x,57 + y,208,34,34 );
	gfx.PutPixel( 136 + x,57 + y,208,34,34 );
	gfx.PutPixel( 137 + x,57 + y,208,34,34 );
	gfx.PutPixel( 138 + x,57 + y,208,34,34 );
	gfx.PutPixel( 139 + x,57 + y,208,34,34 );
	gfx.PutPixel( 140 + x,57 + y,208,34,34 );
	gfx.PutPixel( 141 + x,57 + y,208,34,34 );
	gfx.PutPixel( 142 + x,57 + y,208,34,34 );
	gfx.PutPixel( 143 + x,57 + y,208,34,34 );
	gfx.PutPixel( 144 + x,57 + y,208,34,34 );
	gfx.PutPixel( 145 + x,57 + y,208,34,34 );
	gfx.PutPixel( 146 + x,57 + y,208,34,34 );
	gfx.PutPixel( 147 + x,57 + y,208,34,34 );
	gfx.PutPixel( 148 + x,57 + y,208,34,34 );
	gfx.PutPixel( 149 + x,57 + y,208,34,34 );
	gfx.PutPixel( 0 + x,58 + y,208,34,34 );
	gfx.PutPixel( 1 + x,58 + y,208,34,34 );
	gfx.PutPixel( 2 + x,58 + y,208,34,34 );
	gfx.PutPixel( 3 + x,58 + y,208,34,34 );
	gfx.PutPixel( 4 + x,58 + y,208,34,34 );
	gfx.PutPixel( 5 + x,58 + y,208,34,34 );
	gfx.PutPixel( 6 + x,58 + y,208,34,34 );
	gfx.PutPixel( 7 + x,58 + y,208,34,34 );
	gfx.PutPixel( 8 + x,58 + y,208,34,34 );
	gfx.PutPixel( 9 + x,58 + y,208,34,34 );
	gfx.PutPixel( 10 + x,58 + y,208,34,34 );
	gfx.PutPixel( 11 + x,58 + y,208,34,34 );
	gfx.PutPixel( 12 + x,58 + y,208,34,34 );
	gfx.PutPixel( 13 + x,58 + y,208,34,34 );
	gfx.PutPixel( 14 + x,58 + y,208,34,34 );
	gfx.PutPixel( 15 + x,58 + y,208,34,34 );
	gfx.PutPixel( 16 + x,58 + y,208,34,34 );
	gfx.PutPixel( 17 + x,58 + y,208,34,34 );
	gfx.PutPixel( 18 + x,58 + y,208,34,34 );
	gfx.PutPixel( 19 + x,58 + y,208,34,34 );
	gfx.PutPixel( 20 + x,58 + y,208,34,34 );
	gfx.PutPixel( 21 + x,58 + y,208,34,34 );
	gfx.PutPixel( 22 + x,58 + y,208,34,34 );
	gfx.PutPixel( 23 + x,58 + y,208,34,34 );
	gfx.PutPixel( 24 + x,58 + y,208,34,34 );
	gfx.PutPixel( 25 + x,58 + y,208,34,34 );
	gfx.PutPixel( 26 + x,58 + y,208,34,34 );
	gfx.PutPixel( 27 + x,58 + y,208,34,34 );
	gfx.PutPixel( 28 + x,58 + y,208,34,34 );
	gfx.PutPixel( 29 + x,58 + y,208,34,34 );
	gfx.PutPixel( 30 + x,58 + y,208,34,34 );
	gfx.PutPixel( 31 + x,58 + y,208,34,34 );
	gfx.PutPixel( 32 + x,58 + y,208,34,34 );
	gfx.PutPixel( 33 + x,58 + y,208,34,34 );
	gfx.PutPixel( 34 + x,58 + y,208,34,34 );
	gfx.PutPixel( 35 + x,58 + y,208,34,34 );
	gfx.PutPixel( 36 + x,58 + y,208,34,34 );
	gfx.PutPixel( 37 + x,58 + y,208,34,34 );
	gfx.PutPixel( 38 + x,58 + y,208,34,34 );
	gfx.PutPixel( 39 + x,58 + y,208,34,34 );
	gfx.PutPixel( 40 + x,58 + y,208,34,34 );
	gfx.PutPixel( 41 + x,58 + y,208,34,34 );
	gfx.PutPixel( 42 + x,58 + y,208,34,34 );
	gfx.PutPixel( 43 + x,58 + y,208,34,34 );
	gfx.PutPixel( 44 + x,58 + y,208,30,30 );
	gfx.PutPixel( 45 + x,58 + y,209,47,47 );
	gfx.PutPixel( 46 + x,58 + y,220,208,208 );
	gfx.PutPixel( 47 + x,58 + y,221,225,225 );
	gfx.PutPixel( 48 + x,58 + y,221,220,220 );
	gfx.PutPixel( 49 + x,58 + y,221,228,228 );
	gfx.PutPixel( 50 + x,58 + y,221,225,225 );
	gfx.PutPixel( 51 + x,58 + y,221,221,221 );
	gfx.PutPixel( 52 + x,58 + y,222,230,230 );
	gfx.PutPixel( 53 + x,58 + y,217,163,163 );
	gfx.PutPixel( 54 + x,58 + y,207,20,20 );
	gfx.PutPixel( 55 + x,58 + y,208,32,32 );
	gfx.PutPixel( 56 + x,58 + y,208,34,34 );
	gfx.PutPixel( 57 + x,58 + y,208,34,34 );
	gfx.PutPixel( 58 + x,58 + y,208,34,34 );
	gfx.PutPixel( 59 + x,58 + y,208,34,34 );
	gfx.PutPixel( 60 + x,58 + y,208,34,34 );
	gfx.PutPixel( 61 + x,58 + y,208,34,34 );
	gfx.PutPixel( 62 + x,58 + y,208,27,27 );
	gfx.PutPixel( 63 + x,58 + y,218,173,173 );
	gfx.PutPixel( 64 + x,58 + y,222,230,230 );
	gfx.PutPixel( 65 + x,58 + y,221,221,221 );
	gfx.PutPixel( 66 + x,58 + y,221,223,223 );
	gfx.PutPixel( 67 + x,58 + y,222,230,230 );
	gfx.PutPixel( 68 + x,58 + y,222,230,230 );
	gfx.PutPixel( 69 + x,58 + y,222,230,230 );
	gfx.PutPixel( 70 + x,58 + y,222,230,230 );
	gfx.PutPixel( 71 + x,58 + y,222,230,230 );
	gfx.PutPixel( 72 + x,58 + y,222,232,232 );
	gfx.PutPixel( 73 + x,58 + y,222,226,226 );
	gfx.PutPixel( 74 + x,58 + y,210,65,65 );
	gfx.PutPixel( 75 + x,58 + y,208,28,28 );
	gfx.PutPixel( 76 + x,58 + y,208,34,34 );
	gfx.PutPixel( 77 + x,58 + y,208,27,27 );
	gfx.PutPixel( 78 + x,58 + y,218,173,173 );
	gfx.PutPixel( 79 + x,58 + y,222,230,230 );
	gfx.PutPixel( 80 + x,58 + y,221,221,221 );
	gfx.PutPixel( 81 + x,58 + y,221,223,223 );
	gfx.PutPixel( 82 + x,58 + y,222,230,230 );
	gfx.PutPixel( 83 + x,58 + y,222,230,230 );
	gfx.PutPixel( 84 + x,58 + y,222,230,230 );
	gfx.PutPixel( 85 + x,58 + y,222,230,230 );
	gfx.PutPixel( 86 + x,58 + y,222,230,230 );
	gfx.PutPixel( 87 + x,58 + y,222,232,232 );
	gfx.PutPixel( 88 + x,58 + y,222,226,226 );
	gfx.PutPixel( 89 + x,58 + y,210,65,65 );
	gfx.PutPixel( 90 + x,58 + y,208,28,28 );
	gfx.PutPixel( 91 + x,58 + y,208,30,30 );
	gfx.PutPixel( 92 + x,58 + y,209,47,47 );
	gfx.PutPixel( 93 + x,58 + y,220,208,208 );
	gfx.PutPixel( 94 + x,58 + y,221,225,225 );
	gfx.PutPixel( 95 + x,58 + y,221,222,222 );
	gfx.PutPixel( 96 + x,58 + y,221,214,214 );
	gfx.PutPixel( 97 + x,58 + y,220,207,207 );
	gfx.PutPixel( 98 + x,58 + y,220,207,207 );
	gfx.PutPixel( 99 + x,58 + y,220,211,211 );
	gfx.PutPixel( 100 + x,58 + y,221,228,228 );
	gfx.PutPixel( 101 + x,58 + y,221,224,224 );
	gfx.PutPixel( 102 + x,58 + y,221,220,220 );
	gfx.PutPixel( 103 + x,58 + y,221,228,228 );
	gfx.PutPixel( 104 + x,58 + y,220,208,208 );
	gfx.PutPixel( 105 + x,58 + y,209,49,49 );
	gfx.PutPixel( 106 + x,58 + y,208,30,30 );
	gfx.PutPixel( 107 + x,58 + y,208,34,34 );
	gfx.PutPixel( 108 + x,58 + y,208,34,34 );
	gfx.PutPixel( 109 + x,58 + y,208,34,34 );
	gfx.PutPixel( 110 + x,58 + y,208,34,34 );
	gfx.PutPixel( 111 + x,58 + y,208,34,34 );
	gfx.PutPixel( 112 + x,58 + y,208,34,34 );
	gfx.PutPixel( 113 + x,58 + y,208,34,34 );
	gfx.PutPixel( 114 + x,58 + y,208,34,34 );
	gfx.PutPixel( 115 + x,58 + y,208,34,34 );
	gfx.PutPixel( 116 + x,58 + y,208,34,34 );
	gfx.PutPixel( 117 + x,58 + y,208,34,34 );
	gfx.PutPixel( 118 + x,58 + y,208,34,34 );
	gfx.PutPixel( 119 + x,58 + y,208,34,34 );
	gfx.PutPixel( 120 + x,58 + y,208,34,34 );
	gfx.PutPixel( 121 + x,58 + y,208,34,34 );
	gfx.PutPixel( 122 + x,58 + y,208,34,34 );
	gfx.PutPixel( 123 + x,58 + y,208,34,34 );
	gfx.PutPixel( 124 + x,58 + y,208,34,34 );
	gfx.PutPixel( 125 + x,58 + y,208,34,34 );
	gfx.PutPixel( 126 + x,58 + y,208,34,34 );
	gfx.PutPixel( 127 + x,58 + y,208,34,34 );
	gfx.PutPixel( 128 + x,58 + y,208,34,34 );
	gfx.PutPixel( 129 + x,58 + y,208,34,34 );
	gfx.PutPixel( 130 + x,58 + y,208,34,34 );
	gfx.PutPixel( 131 + x,58 + y,208,34,34 );
	gfx.PutPixel( 132 + x,58 + y,208,34,34 );
	gfx.PutPixel( 133 + x,58 + y,208,34,34 );
	gfx.PutPixel( 134 + x,58 + y,208,34,34 );
	gfx.PutPixel( 135 + x,58 + y,208,34,34 );
	gfx.PutPixel( 136 + x,58 + y,208,34,34 );
	gfx.PutPixel( 137 + x,58 + y,208,34,34 );
	gfx.PutPixel( 138 + x,58 + y,208,34,34 );
	gfx.PutPixel( 139 + x,58 + y,208,34,34 );
	gfx.PutPixel( 140 + x,58 + y,208,34,34 );
	gfx.PutPixel( 141 + x,58 + y,208,34,34 );
	gfx.PutPixel( 142 + x,58 + y,208,34,34 );
	gfx.PutPixel( 143 + x,58 + y,208,34,34 );
	gfx.PutPixel( 144 + x,58 + y,208,34,34 );
	gfx.PutPixel( 145 + x,58 + y,208,34,34 );
	gfx.PutPixel( 146 + x,58 + y,208,34,34 );
	gfx.PutPixel( 147 + x,58 + y,208,34,34 );
	gfx.PutPixel( 148 + x,58 + y,208,34,34 );
	gfx.PutPixel( 149 + x,58 + y,208,34,34 );
	gfx.PutPixel( 0 + x,59 + y,208,34,34 );
	gfx.PutPixel( 1 + x,59 + y,208,34,34 );
	gfx.PutPixel( 2 + x,59 + y,208,34,34 );
	gfx.PutPixel( 3 + x,59 + y,208,34,34 );
	gfx.PutPixel( 4 + x,59 + y,208,34,34 );
	gfx.PutPixel( 5 + x,59 + y,208,34,34 );
	gfx.PutPixel( 6 + x,59 + y,208,34,34 );
	gfx.PutPixel( 7 + x,59 + y,208,34,34 );
	gfx.PutPixel( 8 + x,59 + y,208,34,34 );
	gfx.PutPixel( 9 + x,59 + y,208,34,34 );
	gfx.PutPixel( 10 + x,59 + y,208,34,34 );
	gfx.PutPixel( 11 + x,59 + y,208,34,34 );
	gfx.PutPixel( 12 + x,59 + y,208,34,34 );
	gfx.PutPixel( 13 + x,59 + y,208,34,34 );
	gfx.PutPixel( 14 + x,59 + y,208,34,34 );
	gfx.PutPixel( 15 + x,59 + y,208,34,34 );
	gfx.PutPixel( 16 + x,59 + y,208,34,34 );
	gfx.PutPixel( 17 + x,59 + y,208,34,34 );
	gfx.PutPixel( 18 + x,59 + y,208,34,34 );
	gfx.PutPixel( 19 + x,59 + y,208,34,34 );
	gfx.PutPixel( 20 + x,59 + y,208,34,34 );
	gfx.PutPixel( 21 + x,59 + y,208,34,34 );
	gfx.PutPixel( 22 + x,59 + y,208,34,34 );
	gfx.PutPixel( 23 + x,59 + y,208,34,34 );
	gfx.PutPixel( 24 + x,59 + y,208,34,34 );
	gfx.PutPixel( 25 + x,59 + y,208,34,34 );
	gfx.PutPixel( 26 + x,59 + y,208,34,34 );
	gfx.PutPixel( 27 + x,59 + y,208,34,34 );
	gfx.PutPixel( 28 + x,59 + y,208,34,34 );
	gfx.PutPixel( 29 + x,59 + y,208,34,34 );
	gfx.PutPixel( 30 + x,59 + y,208,34,34 );
	gfx.PutPixel( 31 + x,59 + y,208,34,34 );
	gfx.PutPixel( 32 + x,59 + y,208,34,34 );
	gfx.PutPixel( 33 + x,59 + y,208,34,34 );
	gfx.PutPixel( 34 + x,59 + y,208,34,34 );
	gfx.PutPixel( 35 + x,59 + y,208,34,34 );
	gfx.PutPixel( 36 + x,59 + y,208,34,34 );
	gfx.PutPixel( 37 + x,59 + y,208,34,34 );
	gfx.PutPixel( 38 + x,59 + y,208,34,34 );
	gfx.PutPixel( 39 + x,59 + y,208,34,34 );
	gfx.PutPixel( 40 + x,59 + y,208,34,34 );
	gfx.PutPixel( 41 + x,59 + y,208,34,34 );
	gfx.PutPixel( 42 + x,59 + y,208,34,34 );
	gfx.PutPixel( 43 + x,59 + y,208,34,34 );
	gfx.PutPixel( 44 + x,59 + y,208,30,30 );
	gfx.PutPixel( 45 + x,59 + y,209,47,47 );
	gfx.PutPixel( 46 + x,59 + y,220,208,208 );
	gfx.PutPixel( 47 + x,59 + y,221,225,225 );
	gfx.PutPixel( 48 + x,59 + y,221,222,222 );
	gfx.PutPixel( 49 + x,59 + y,220,213,213 );
	gfx.PutPixel( 50 + x,59 + y,221,225,225 );
	gfx.PutPixel( 51 + x,59 + y,221,221,221 );
	gfx.PutPixel( 52 + x,59 + y,221,224,224 );
	gfx.PutPixel( 53 + x,59 + y,221,210,210 );
	gfx.PutPixel( 54 + x,59 + y,211,79,79 );
	gfx.PutPixel( 55 + x,59 + y,207,23,23 );
	gfx.PutPixel( 56 + x,59 + y,208,34,34 );
	gfx.PutPixel( 57 + x,59 + y,208,34,34 );
	gfx.PutPixel( 58 + x,59 + y,208,34,34 );
	gfx.PutPixel( 59 + x,59 + y,208,34,34 );
	gfx.PutPixel( 60 + x,59 + y,208,34,34 );
	gfx.PutPixel( 61 + x,59 + y,208,34,34 );
	gfx.PutPixel( 62 + x,59 + y,208,27,27 );
	gfx.PutPixel( 63 + x,59 + y,218,173,173 );
	gfx.PutPixel( 64 + x,59 + y,222,230,230 );
	gfx.PutPixel( 65 + x,59 + y,221,221,221 );
	gfx.PutPixel( 66 + x,59 + y,221,223,223 );
	gfx.PutPixel( 67 + x,59 + y,222,230,230 );
	gfx.PutPixel( 68 + x,59 + y,222,230,230 );
	gfx.PutPixel( 69 + x,59 + y,222,230,230 );
	gfx.PutPixel( 70 + x,59 + y,222,230,230 );
	gfx.PutPixel( 71 + x,59 + y,222,230,230 );
	gfx.PutPixel( 72 + x,59 + y,222,232,232 );
	gfx.PutPixel( 73 + x,59 + y,222,226,226 );
	gfx.PutPixel( 74 + x,59 + y,210,65,65 );
	gfx.PutPixel( 75 + x,59 + y,208,28,28 );
	gfx.PutPixel( 76 + x,59 + y,208,34,34 );
	gfx.PutPixel( 77 + x,59 + y,208,27,27 );
	gfx.PutPixel( 78 + x,59 + y,218,173,173 );
	gfx.PutPixel( 79 + x,59 + y,222,230,230 );
	gfx.PutPixel( 80 + x,59 + y,221,221,221 );
	gfx.PutPixel( 81 + x,59 + y,221,223,223 );
	gfx.PutPixel( 82 + x,59 + y,222,230,230 );
	gfx.PutPixel( 83 + x,59 + y,222,230,230 );
	gfx.PutPixel( 84 + x,59 + y,222,230,230 );
	gfx.PutPixel( 85 + x,59 + y,222,230,230 );
	gfx.PutPixel( 86 + x,59 + y,222,230,230 );
	gfx.PutPixel( 87 + x,59 + y,222,232,232 );
	gfx.PutPixel( 88 + x,59 + y,222,226,226 );
	gfx.PutPixel( 89 + x,59 + y,210,65,65 );
	gfx.PutPixel( 90 + x,59 + y,208,28,28 );
	gfx.PutPixel( 91 + x,59 + y,208,30,30 );
	gfx.PutPixel( 92 + x,59 + y,209,47,47 );
	gfx.PutPixel( 93 + x,59 + y,220,208,208 );
	gfx.PutPixel( 94 + x,59 + y,221,225,225 );
	gfx.PutPixel( 95 + x,59 + y,221,221,221 );
	gfx.PutPixel( 96 + x,59 + y,221,223,223 );
	gfx.PutPixel( 97 + x,59 + y,221,225,225 );
	gfx.PutPixel( 98 + x,59 + y,221,225,225 );
	gfx.PutPixel( 99 + x,59 + y,221,225,225 );
	gfx.PutPixel( 100 + x,59 + y,221,223,223 );
	gfx.PutPixel( 101 + x,59 + y,221,224,224 );
	gfx.PutPixel( 102 + x,59 + y,222,232,232 );
	gfx.PutPixel( 103 + x,59 + y,221,228,228 );
	gfx.PutPixel( 104 + x,59 + y,213,102,102 );
	gfx.PutPixel( 105 + x,59 + y,207,24,24 );
	gfx.PutPixel( 106 + x,59 + y,208,34,34 );
	gfx.PutPixel( 107 + x,59 + y,208,34,34 );
	gfx.PutPixel( 108 + x,59 + y,208,34,34 );
	gfx.PutPixel( 109 + x,59 + y,208,34,34 );
	gfx.PutPixel( 110 + x,59 + y,208,34,34 );
	gfx.PutPixel( 111 + x,59 + y,208,34,34 );
	gfx.PutPixel( 112 + x,59 + y,208,34,34 );
	gfx.PutPixel( 113 + x,59 + y,208,34,34 );
	gfx.PutPixel( 114 + x,59 + y,208,34,34 );
	gfx.PutPixel( 115 + x,59 + y,208,34,34 );
	gfx.PutPixel( 116 + x,59 + y,208,34,34 );
	gfx.PutPixel( 117 + x,59 + y,208,34,34 );
	gfx.PutPixel( 118 + x,59 + y,208,34,34 );
	gfx.PutPixel( 119 + x,59 + y,208,34,34 );
	gfx.PutPixel( 120 + x,59 + y,208,34,34 );
	gfx.PutPixel( 121 + x,59 + y,208,34,34 );
	gfx.PutPixel( 122 + x,59 + y,208,34,34 );
	gfx.PutPixel( 123 + x,59 + y,208,34,34 );
	gfx.PutPixel( 124 + x,59 + y,208,34,34 );
	gfx.PutPixel( 125 + x,59 + y,208,34,34 );
	gfx.PutPixel( 126 + x,59 + y,208,34,34 );
	gfx.PutPixel( 127 + x,59 + y,208,34,34 );
	gfx.PutPixel( 128 + x,59 + y,208,34,34 );
	gfx.PutPixel( 129 + x,59 + y,208,34,34 );
	gfx.PutPixel( 130 + x,59 + y,208,34,34 );
	gfx.PutPixel( 131 + x,59 + y,208,34,34 );
	gfx.PutPixel( 132 + x,59 + y,208,34,34 );
	gfx.PutPixel( 133 + x,59 + y,208,34,34 );
	gfx.PutPixel( 134 + x,59 + y,208,34,34 );
	gfx.PutPixel( 135 + x,59 + y,208,34,34 );
	gfx.PutPixel( 136 + x,59 + y,208,34,34 );
	gfx.PutPixel( 137 + x,59 + y,208,34,34 );
	gfx.PutPixel( 138 + x,59 + y,208,34,34 );
	gfx.PutPixel( 139 + x,59 + y,208,34,34 );
	gfx.PutPixel( 140 + x,59 + y,208,34,34 );
	gfx.PutPixel( 141 + x,59 + y,208,34,34 );
	gfx.PutPixel( 142 + x,59 + y,208,34,34 );
	gfx.PutPixel( 143 + x,59 + y,208,34,34 );
	gfx.PutPixel( 144 + x,59 + y,208,34,34 );
	gfx.PutPixel( 145 + x,59 + y,208,34,34 );
	gfx.PutPixel( 146 + x,59 + y,208,34,34 );
	gfx.PutPixel( 147 + x,59 + y,208,34,34 );
	gfx.PutPixel( 148 + x,59 + y,208,34,34 );
	gfx.PutPixel( 149 + x,59 + y,208,34,34 );
	gfx.PutPixel( 0 + x,60 + y,208,34,34 );
	gfx.PutPixel( 1 + x,60 + y,208,34,34 );
	gfx.PutPixel( 2 + x,60 + y,208,34,34 );
	gfx.PutPixel( 3 + x,60 + y,208,34,34 );
	gfx.PutPixel( 4 + x,60 + y,208,34,34 );
	gfx.PutPixel( 5 + x,60 + y,208,34,34 );
	gfx.PutPixel( 6 + x,60 + y,208,34,34 );
	gfx.PutPixel( 7 + x,60 + y,208,34,34 );
	gfx.PutPixel( 8 + x,60 + y,208,34,34 );
	gfx.PutPixel( 9 + x,60 + y,208,34,34 );
	gfx.PutPixel( 10 + x,60 + y,208,34,34 );
	gfx.PutPixel( 11 + x,60 + y,208,34,34 );
	gfx.PutPixel( 12 + x,60 + y,208,34,34 );
	gfx.PutPixel( 13 + x,60 + y,208,34,34 );
	gfx.PutPixel( 14 + x,60 + y,208,34,34 );
	gfx.PutPixel( 15 + x,60 + y,208,34,34 );
	gfx.PutPixel( 16 + x,60 + y,208,34,34 );
	gfx.PutPixel( 17 + x,60 + y,208,34,34 );
	gfx.PutPixel( 18 + x,60 + y,208,34,34 );
	gfx.PutPixel( 19 + x,60 + y,208,34,34 );
	gfx.PutPixel( 20 + x,60 + y,208,34,34 );
	gfx.PutPixel( 21 + x,60 + y,208,34,34 );
	gfx.PutPixel( 22 + x,60 + y,208,34,34 );
	gfx.PutPixel( 23 + x,60 + y,208,34,34 );
	gfx.PutPixel( 24 + x,60 + y,208,34,34 );
	gfx.PutPixel( 25 + x,60 + y,208,34,34 );
	gfx.PutPixel( 26 + x,60 + y,208,34,34 );
	gfx.PutPixel( 27 + x,60 + y,208,34,34 );
	gfx.PutPixel( 28 + x,60 + y,208,34,34 );
	gfx.PutPixel( 29 + x,60 + y,208,34,34 );
	gfx.PutPixel( 30 + x,60 + y,208,34,34 );
	gfx.PutPixel( 31 + x,60 + y,208,34,34 );
	gfx.PutPixel( 32 + x,60 + y,208,34,34 );
	gfx.PutPixel( 33 + x,60 + y,208,34,34 );
	gfx.PutPixel( 34 + x,60 + y,208,34,34 );
	gfx.PutPixel( 35 + x,60 + y,208,34,34 );
	gfx.PutPixel( 36 + x,60 + y,208,34,34 );
	gfx.PutPixel( 37 + x,60 + y,208,34,34 );
	gfx.PutPixel( 38 + x,60 + y,208,34,34 );
	gfx.PutPixel( 39 + x,60 + y,208,34,34 );
	gfx.PutPixel( 40 + x,60 + y,208,34,34 );
	gfx.PutPixel( 41 + x,60 + y,208,34,34 );
	gfx.PutPixel( 42 + x,60 + y,208,34,34 );
	gfx.PutPixel( 43 + x,60 + y,208,34,34 );
	gfx.PutPixel( 44 + x,60 + y,208,30,30 );
	gfx.PutPixel( 45 + x,60 + y,209,47,47 );
	gfx.PutPixel( 46 + x,60 + y,220,208,208 );
	gfx.PutPixel( 47 + x,60 + y,221,225,225 );
	gfx.PutPixel( 48 + x,60 + y,222,231,231 );
	gfx.PutPixel( 49 + x,60 + y,215,133,133 );
	gfx.PutPixel( 50 + x,60 + y,217,163,163 );
	gfx.PutPixel( 51 + x,60 + y,222,232,232 );
	gfx.PutPixel( 52 + x,60 + y,221,220,220 );
	gfx.PutPixel( 53 + x,60 + y,221,227,227 );
	gfx.PutPixel( 54 + x,60 + y,220,211,211 );
	gfx.PutPixel( 55 + x,60 + y,210,67,67 );
	gfx.PutPixel( 56 + x,60 + y,207,24,24 );
	gfx.PutPixel( 57 + x,60 + y,208,34,34 );
	gfx.PutPixel( 58 + x,60 + y,208,34,34 );
	gfx.PutPixel( 59 + x,60 + y,208,34,34 );
	gfx.PutPixel( 60 + x,60 + y,208,34,34 );
	gfx.PutPixel( 61 + x,60 + y,208,34,34 );
	gfx.PutPixel( 62 + x,60 + y,208,27,27 );
	gfx.PutPixel( 63 + x,60 + y,218,173,173 );
	gfx.PutPixel( 64 + x,60 + y,222,230,230 );
	gfx.PutPixel( 65 + x,60 + y,221,223,223 );
	gfx.PutPixel( 66 + x,60 + y,220,209,209 );
	gfx.PutPixel( 67 + x,60 + y,218,171,171 );
	gfx.PutPixel( 68 + x,60 + y,218,173,173 );
	gfx.PutPixel( 69 + x,60 + y,218,173,173 );
	gfx.PutPixel( 70 + x,60 + y,218,173,173 );
	gfx.PutPixel( 71 + x,60 + y,218,173,173 );
	gfx.PutPixel( 72 + x,60 + y,218,174,174 );
	gfx.PutPixel( 73 + x,60 + y,218,170,170 );
	gfx.PutPixel( 74 + x,60 + y,209,56,56 );
	gfx.PutPixel( 75 + x,60 + y,208,30,30 );
	gfx.PutPixel( 76 + x,60 + y,208,34,34 );
	gfx.PutPixel( 77 + x,60 + y,208,27,27 );
	gfx.PutPixel( 78 + x,60 + y,218,173,173 );
	gfx.PutPixel( 79 + x,60 + y,222,230,230 );
	gfx.PutPixel( 80 + x,60 + y,221,223,223 );
	gfx.PutPixel( 81 + x,60 + y,220,209,209 );
	gfx.PutPixel( 82 + x,60 + y,218,171,171 );
	gfx.PutPixel( 83 + x,60 + y,218,173,173 );
	gfx.PutPixel( 84 + x,60 + y,218,173,173 );
	gfx.PutPixel( 85 + x,60 + y,218,173,173 );
	gfx.PutPixel( 86 + x,60 + y,218,173,173 );
	gfx.PutPixel( 87 + x,60 + y,218,174,174 );
	gfx.PutPixel( 88 + x,60 + y,218,170,170 );
	gfx.PutPixel( 89 + x,60 + y,209,56,56 );
	gfx.PutPixel( 90 + x,60 + y,208,30,30 );
	gfx.PutPixel( 91 + x,60 + y,208,30,30 );
	gfx.PutPixel( 92 + x,60 + y,209,47,47 );
	gfx.PutPixel( 93 + x,60 + y,220,208,208 );
	gfx.PutPixel( 94 + x,60 + y,221,225,225 );
	gfx.PutPixel( 95 + x,60 + y,221,221,221 );
	gfx.PutPixel( 96 + x,60 + y,221,224,224 );
	gfx.PutPixel( 97 + x,60 + y,222,228,228 );
	gfx.PutPixel( 98 + x,60 + y,221,228,228 );
	gfx.PutPixel( 99 + x,60 + y,221,227,227 );
	gfx.PutPixel( 100 + x,60 + y,221,223,223 );
	gfx.PutPixel( 101 + x,60 + y,221,212,212 );
	gfx.PutPixel( 102 + x,60 + y,218,174,174 );
	gfx.PutPixel( 103 + x,60 + y,211,84,84 );
	gfx.PutPixel( 104 + x,60 + y,207,25,25 );
	gfx.PutPixel( 105 + x,60 + y,208,34,34 );
	gfx.PutPixel( 106 + x,60 + y,208,34,34 );
	gfx.PutPixel( 107 + x,60 + y,208,34,34 );
	gfx.PutPixel( 108 + x,60 + y,208,34,34 );
	gfx.PutPixel( 109 + x,60 + y,208,34,34 );
	gfx.PutPixel( 110 + x,60 + y,208,34,34 );
	gfx.PutPixel( 111 + x,60 + y,208,34,34 );
	gfx.PutPixel( 112 + x,60 + y,208,34,34 );
	gfx.PutPixel( 113 + x,60 + y,208,34,34 );
	gfx.PutPixel( 114 + x,60 + y,208,34,34 );
	gfx.PutPixel( 115 + x,60 + y,208,34,34 );
	gfx.PutPixel( 116 + x,60 + y,208,34,34 );
	gfx.PutPixel( 117 + x,60 + y,208,34,34 );
	gfx.PutPixel( 118 + x,60 + y,208,34,34 );
	gfx.PutPixel( 119 + x,60 + y,208,34,34 );
	gfx.PutPixel( 120 + x,60 + y,208,34,34 );
	gfx.PutPixel( 121 + x,60 + y,208,34,34 );
	gfx.PutPixel( 122 + x,60 + y,208,34,34 );
	gfx.PutPixel( 123 + x,60 + y,208,34,34 );
	gfx.PutPixel( 124 + x,60 + y,208,34,34 );
	gfx.PutPixel( 125 + x,60 + y,208,34,34 );
	gfx.PutPixel( 126 + x,60 + y,208,34,34 );
	gfx.PutPixel( 127 + x,60 + y,208,34,34 );
	gfx.PutPixel( 128 + x,60 + y,208,34,34 );
	gfx.PutPixel( 129 + x,60 + y,208,34,34 );
	gfx.PutPixel( 130 + x,60 + y,208,34,34 );
	gfx.PutPixel( 131 + x,60 + y,208,34,34 );
	gfx.PutPixel( 132 + x,60 + y,208,34,34 );
	gfx.PutPixel( 133 + x,60 + y,208,34,34 );
	gfx.PutPixel( 134 + x,60 + y,208,34,34 );
	gfx.PutPixel( 135 + x,60 + y,208,34,34 );
	gfx.PutPixel( 136 + x,60 + y,208,34,34 );
	gfx.PutPixel( 137 + x,60 + y,208,34,34 );
	gfx.PutPixel( 138 + x,60 + y,208,34,34 );
	gfx.PutPixel( 139 + x,60 + y,208,34,34 );
	gfx.PutPixel( 140 + x,60 + y,208,34,34 );
	gfx.PutPixel( 141 + x,60 + y,208,34,34 );
	gfx.PutPixel( 142 + x,60 + y,208,34,34 );
	gfx.PutPixel( 143 + x,60 + y,208,34,34 );
	gfx.PutPixel( 144 + x,60 + y,208,34,34 );
	gfx.PutPixel( 145 + x,60 + y,208,34,34 );
	gfx.PutPixel( 146 + x,60 + y,208,34,34 );
	gfx.PutPixel( 147 + x,60 + y,208,34,34 );
	gfx.PutPixel( 148 + x,60 + y,208,34,34 );
	gfx.PutPixel( 149 + x,60 + y,208,34,34 );
	gfx.PutPixel( 0 + x,61 + y,208,34,34 );
	gfx.PutPixel( 1 + x,61 + y,208,34,34 );
	gfx.PutPixel( 2 + x,61 + y,208,34,34 );
	gfx.PutPixel( 3 + x,61 + y,208,34,34 );
	gfx.PutPixel( 4 + x,61 + y,208,34,34 );
	gfx.PutPixel( 5 + x,61 + y,208,34,34 );
	gfx.PutPixel( 6 + x,61 + y,208,34,34 );
	gfx.PutPixel( 7 + x,61 + y,208,34,34 );
	gfx.PutPixel( 8 + x,61 + y,208,34,34 );
	gfx.PutPixel( 9 + x,61 + y,208,34,34 );
	gfx.PutPixel( 10 + x,61 + y,208,34,34 );
	gfx.PutPixel( 11 + x,61 + y,208,34,34 );
	gfx.PutPixel( 12 + x,61 + y,208,34,34 );
	gfx.PutPixel( 13 + x,61 + y,208,34,34 );
	gfx.PutPixel( 14 + x,61 + y,208,34,34 );
	gfx.PutPixel( 15 + x,61 + y,208,34,34 );
	gfx.PutPixel( 16 + x,61 + y,208,34,34 );
	gfx.PutPixel( 17 + x,61 + y,208,34,34 );
	gfx.PutPixel( 18 + x,61 + y,208,34,34 );
	gfx.PutPixel( 19 + x,61 + y,208,34,34 );
	gfx.PutPixel( 20 + x,61 + y,208,34,34 );
	gfx.PutPixel( 21 + x,61 + y,208,34,34 );
	gfx.PutPixel( 22 + x,61 + y,208,34,34 );
	gfx.PutPixel( 23 + x,61 + y,208,34,34 );
	gfx.PutPixel( 24 + x,61 + y,208,34,34 );
	gfx.PutPixel( 25 + x,61 + y,208,34,34 );
	gfx.PutPixel( 26 + x,61 + y,208,34,34 );
	gfx.PutPixel( 27 + x,61 + y,208,34,34 );
	gfx.PutPixel( 28 + x,61 + y,208,34,34 );
	gfx.PutPixel( 29 + x,61 + y,208,34,34 );
	gfx.PutPixel( 30 + x,61 + y,208,34,34 );
	gfx.PutPixel( 31 + x,61 + y,208,34,34 );
	gfx.PutPixel( 32 + x,61 + y,208,34,34 );
	gfx.PutPixel( 33 + x,61 + y,208,34,34 );
	gfx.PutPixel( 34 + x,61 + y,208,34,34 );
	gfx.PutPixel( 35 + x,61 + y,208,34,34 );
	gfx.PutPixel( 36 + x,61 + y,208,34,34 );
	gfx.PutPixel( 37 + x,61 + y,208,34,34 );
	gfx.PutPixel( 38 + x,61 + y,208,34,34 );
	gfx.PutPixel( 39 + x,61 + y,208,34,34 );
	gfx.PutPixel( 40 + x,61 + y,208,34,34 );
	gfx.PutPixel( 41 + x,61 + y,208,34,34 );
	gfx.PutPixel( 42 + x,61 + y,208,34,34 );
	gfx.PutPixel( 43 + x,61 + y,208,34,34 );
	gfx.PutPixel( 44 + x,61 + y,208,30,30 );
	gfx.PutPixel( 45 + x,61 + y,209,47,47 );
	gfx.PutPixel( 46 + x,61 + y,220,208,208 );
	gfx.PutPixel( 47 + x,61 + y,221,225,225 );
	gfx.PutPixel( 48 + x,61 + y,222,233,233 );
	gfx.PutPixel( 49 + x,61 + y,214,121,121 );
	gfx.PutPixel( 50 + x,61 + y,208,35,35 );
	gfx.PutPixel( 51 + x,61 + y,219,195,195 );
	gfx.PutPixel( 52 + x,61 + y,222,230,230 );
	gfx.PutPixel( 53 + x,61 + y,221,220,220 );
	gfx.PutPixel( 54 + x,61 + y,222,229,229 );
	gfx.PutPixel( 55 + x,61 + y,220,201,201 );
	gfx.PutPixel( 56 + x,61 + y,209,55,55 );
	gfx.PutPixel( 57 + x,61 + y,207,26,26 );
	gfx.PutPixel( 58 + x,61 + y,208,34,34 );
	gfx.PutPixel( 59 + x,61 + y,208,34,34 );
	gfx.PutPixel( 60 + x,61 + y,208,34,34 );
	gfx.PutPixel( 61 + x,61 + y,208,34,34 );
	gfx.PutPixel( 62 + x,61 + y,208,27,27 );
	gfx.PutPixel( 63 + x,61 + y,218,173,173 );
	gfx.PutPixel( 64 + x,61 + y,222,230,230 );
	gfx.PutPixel( 65 + x,61 + y,222,230,230 );
	gfx.PutPixel( 66 + x,61 + y,218,171,171 );
	gfx.PutPixel( 67 + x,61 + y,208,20,20 );
	gfx.PutPixel( 68 + x,61 + y,208,27,27 );
	gfx.PutPixel( 69 + x,61 + y,208,27,27 );
	gfx.PutPixel( 70 + x,61 + y,208,27,27 );
	gfx.PutPixel( 71 + x,61 + y,208,27,27 );
	gfx.PutPixel( 72 + x,61 + y,208,27,27 );
	gfx.PutPixel( 73 + x,61 + y,208,27,27 );
	gfx.PutPixel( 74 + x,61 + y,208,33,33 );
	gfx.PutPixel( 75 + x,61 + y,208,34,34 );
	gfx.PutPixel( 76 + x,61 + y,208,34,34 );
	gfx.PutPixel( 77 + x,61 + y,208,27,27 );
	gfx.PutPixel( 78 + x,61 + y,218,173,173 );
	gfx.PutPixel( 79 + x,61 + y,222,230,230 );
	gfx.PutPixel( 80 + x,61 + y,222,230,230 );
	gfx.PutPixel( 81 + x,61 + y,218,171,171 );
	gfx.PutPixel( 82 + x,61 + y,208,20,20 );
	gfx.PutPixel( 83 + x,61 + y,208,27,27 );
	gfx.PutPixel( 84 + x,61 + y,208,27,27 );
	gfx.PutPixel( 85 + x,61 + y,208,27,27 );
	gfx.PutPixel( 86 + x,61 + y,208,27,27 );
	gfx.PutPixel( 87 + x,61 + y,208,27,27 );
	gfx.PutPixel( 88 + x,61 + y,208,27,27 );
	gfx.PutPixel( 89 + x,61 + y,208,33,33 );
	gfx.PutPixel( 90 + x,61 + y,208,34,34 );
	gfx.PutPixel( 91 + x,61 + y,208,30,30 );
	gfx.PutPixel( 92 + x,61 + y,209,47,47 );
	gfx.PutPixel( 93 + x,61 + y,220,208,208 );
	gfx.PutPixel( 94 + x,61 + y,221,225,225 );
	gfx.PutPixel( 95 + x,61 + y,222,230,230 );
	gfx.PutPixel( 96 + x,61 + y,217,152,152 );
	gfx.PutPixel( 97 + x,61 + y,211,73,73 );
	gfx.PutPixel( 98 + x,61 + y,211,82,82 );
	gfx.PutPixel( 99 + x,61 + y,211,82,82 );
	gfx.PutPixel( 100 + x,61 + y,211,74,74 );
	gfx.PutPixel( 101 + x,61 + y,210,53,53 );
	gfx.PutPixel( 102 + x,61 + y,208,29,29 );
	gfx.PutPixel( 103 + x,61 + y,207,25,25 );
	gfx.PutPixel( 104 + x,61 + y,208,34,34 );
	gfx.PutPixel( 105 + x,61 + y,208,34,34 );
	gfx.PutPixel( 106 + x,61 + y,208,34,34 );
	gfx.PutPixel( 107 + x,61 + y,208,34,34 );
	gfx.PutPixel( 108 + x,61 + y,208,34,34 );
	gfx.PutPixel( 109 + x,61 + y,208,34,34 );
	gfx.PutPixel( 110 + x,61 + y,208,34,34 );
	gfx.PutPixel( 111 + x,61 + y,208,34,34 );
	gfx.PutPixel( 112 + x,61 + y,208,34,34 );
	gfx.PutPixel( 113 + x,61 + y,208,34,34 );
	gfx.PutPixel( 114 + x,61 + y,208,34,34 );
	gfx.PutPixel( 115 + x,61 + y,208,34,34 );
	gfx.PutPixel( 116 + x,61 + y,208,34,34 );
	gfx.PutPixel( 117 + x,61 + y,208,34,34 );
	gfx.PutPixel( 118 + x,61 + y,208,34,34 );
	gfx.PutPixel( 119 + x,61 + y,208,34,34 );
	gfx.PutPixel( 120 + x,61 + y,208,34,34 );
	gfx.PutPixel( 121 + x,61 + y,208,34,34 );
	gfx.PutPixel( 122 + x,61 + y,208,34,34 );
	gfx.PutPixel( 123 + x,61 + y,208,34,34 );
	gfx.PutPixel( 124 + x,61 + y,208,34,34 );
	gfx.PutPixel( 125 + x,61 + y,208,34,34 );
	gfx.PutPixel( 126 + x,61 + y,208,34,34 );
	gfx.PutPixel( 127 + x,61 + y,208,34,34 );
	gfx.PutPixel( 128 + x,61 + y,208,34,34 );
	gfx.PutPixel( 129 + x,61 + y,208,34,34 );
	gfx.PutPixel( 130 + x,61 + y,208,34,34 );
	gfx.PutPixel( 131 + x,61 + y,208,34,34 );
	gfx.PutPixel( 132 + x,61 + y,208,34,34 );
	gfx.PutPixel( 133 + x,61 + y,208,34,34 );
	gfx.PutPixel( 134 + x,61 + y,208,34,34 );
	gfx.PutPixel( 135 + x,61 + y,208,34,34 );
	gfx.PutPixel( 136 + x,61 + y,208,34,34 );
	gfx.PutPixel( 137 + x,61 + y,208,34,34 );
	gfx.PutPixel( 138 + x,61 + y,208,34,34 );
	gfx.PutPixel( 139 + x,61 + y,208,34,34 );
	gfx.PutPixel( 140 + x,61 + y,208,34,34 );
	gfx.PutPixel( 141 + x,61 + y,208,34,34 );
	gfx.PutPixel( 142 + x,61 + y,208,34,34 );
	gfx.PutPixel( 143 + x,61 + y,208,34,34 );
	gfx.PutPixel( 144 + x,61 + y,208,34,34 );
	gfx.PutPixel( 145 + x,61 + y,208,34,34 );
	gfx.PutPixel( 146 + x,61 + y,208,34,34 );
	gfx.PutPixel( 147 + x,61 + y,208,34,34 );
	gfx.PutPixel( 148 + x,61 + y,208,34,34 );
	gfx.PutPixel( 149 + x,61 + y,208,34,34 );
	gfx.PutPixel( 0 + x,62 + y,208,34,34 );
	gfx.PutPixel( 1 + x,62 + y,208,34,34 );
	gfx.PutPixel( 2 + x,62 + y,208,34,34 );
	gfx.PutPixel( 3 + x,62 + y,208,34,34 );
	gfx.PutPixel( 4 + x,62 + y,208,34,34 );
	gfx.PutPixel( 5 + x,62 + y,208,34,34 );
	gfx.PutPixel( 6 + x,62 + y,208,34,34 );
	gfx.PutPixel( 7 + x,62 + y,208,34,34 );
	gfx.PutPixel( 8 + x,62 + y,208,34,34 );
	gfx.PutPixel( 9 + x,62 + y,208,34,34 );
	gfx.PutPixel( 10 + x,62 + y,208,34,34 );
	gfx.PutPixel( 11 + x,62 + y,208,34,34 );
	gfx.PutPixel( 12 + x,62 + y,208,34,34 );
	gfx.PutPixel( 13 + x,62 + y,208,34,34 );
	gfx.PutPixel( 14 + x,62 + y,208,34,34 );
	gfx.PutPixel( 15 + x,62 + y,208,34,34 );
	gfx.PutPixel( 16 + x,62 + y,208,34,34 );
	gfx.PutPixel( 17 + x,62 + y,208,34,34 );
	gfx.PutPixel( 18 + x,62 + y,208,34,34 );
	gfx.PutPixel( 19 + x,62 + y,208,34,34 );
	gfx.PutPixel( 20 + x,62 + y,208,34,34 );
	gfx.PutPixel( 21 + x,62 + y,208,34,34 );
	gfx.PutPixel( 22 + x,62 + y,208,34,34 );
	gfx.PutPixel( 23 + x,62 + y,208,34,34 );
	gfx.PutPixel( 24 + x,62 + y,208,34,34 );
	gfx.PutPixel( 25 + x,62 + y,208,34,34 );
	gfx.PutPixel( 26 + x,62 + y,208,34,34 );
	gfx.PutPixel( 27 + x,62 + y,208,34,34 );
	gfx.PutPixel( 28 + x,62 + y,208,34,34 );
	gfx.PutPixel( 29 + x,62 + y,208,34,34 );
	gfx.PutPixel( 30 + x,62 + y,208,34,34 );
	gfx.PutPixel( 31 + x,62 + y,208,34,34 );
	gfx.PutPixel( 32 + x,62 + y,208,34,34 );
	gfx.PutPixel( 33 + x,62 + y,208,34,34 );
	gfx.PutPixel( 34 + x,62 + y,208,34,34 );
	gfx.PutPixel( 35 + x,62 + y,208,34,34 );
	gfx.PutPixel( 36 + x,62 + y,208,34,34 );
	gfx.PutPixel( 37 + x,62 + y,208,34,34 );
	gfx.PutPixel( 38 + x,62 + y,208,34,34 );
	gfx.PutPixel( 39 + x,62 + y,208,34,34 );
	gfx.PutPixel( 40 + x,62 + y,208,34,34 );
	gfx.PutPixel( 41 + x,62 + y,208,34,34 );
	gfx.PutPixel( 42 + x,62 + y,208,34,34 );
	gfx.PutPixel( 43 + x,62 + y,208,34,34 );
	gfx.PutPixel( 44 + x,62 + y,208,30,30 );
	gfx.PutPixel( 45 + x,62 + y,209,47,47 );
	gfx.PutPixel( 46 + x,62 + y,220,208,208 );
	gfx.PutPixel( 47 + x,62 + y,221,225,225 );
	gfx.PutPixel( 48 + x,62 + y,222,233,233 );
	gfx.PutPixel( 49 + x,62 + y,215,128,128 );
	gfx.PutPixel( 50 + x,62 + y,206,12,12 );
	gfx.PutPixel( 51 + x,62 + y,210,64,64 );
	gfx.PutPixel( 52 + x,62 + y,220,211,211 );
	gfx.PutPixel( 53 + x,62 + y,221,227,227 );
	gfx.PutPixel( 54 + x,62 + y,221,220,220 );
	gfx.PutPixel( 55 + x,62 + y,222,231,231 );
	gfx.PutPixel( 56 + x,62 + y,219,190,190 );
	gfx.PutPixel( 57 + x,62 + y,209,45,45 );
	gfx.PutPixel( 58 + x,62 + y,208,27,27 );
	gfx.PutPixel( 59 + x,62 + y,208,34,34 );
	gfx.PutPixel( 60 + x,62 + y,208,34,34 );
	gfx.PutPixel( 61 + x,62 + y,208,34,34 );
	gfx.PutPixel( 62 + x,62 + y,208,27,27 );
	gfx.PutPixel( 63 + x,62 + y,218,173,173 );
	gfx.PutPixel( 64 + x,62 + y,222,230,230 );
	gfx.PutPixel( 65 + x,62 + y,222,230,230 );
	gfx.PutPixel( 66 + x,62 + y,218,173,173 );
	gfx.PutPixel( 67 + x,62 + y,208,26,26 );
	gfx.PutPixel( 68 + x,62 + y,208,33,33 );
	gfx.PutPixel( 69 + x,62 + y,208,33,33 );
	gfx.PutPixel( 70 + x,62 + y,208,33,33 );
	gfx.PutPixel( 71 + x,62 + y,208,33,33 );
	gfx.PutPixel( 72 + x,62 + y,208,33,33 );
	gfx.PutPixel( 73 + x,62 + y,208,33,33 );
	gfx.PutPixel( 74 + x,62 + y,208,33,33 );
	gfx.PutPixel( 75 + x,62 + y,208,34,34 );
	gfx.PutPixel( 76 + x,62 + y,208,34,34 );
	gfx.PutPixel( 77 + x,62 + y,208,27,27 );
	gfx.PutPixel( 78 + x,62 + y,218,173,173 );
	gfx.PutPixel( 79 + x,62 + y,222,230,230 );
	gfx.PutPixel( 80 + x,62 + y,222,230,230 );
	gfx.PutPixel( 81 + x,62 + y,218,173,173 );
	gfx.PutPixel( 82 + x,62 + y,208,26,26 );
	gfx.PutPixel( 83 + x,62 + y,208,33,33 );
	gfx.PutPixel( 84 + x,62 + y,208,33,33 );
	gfx.PutPixel( 85 + x,62 + y,208,33,33 );
	gfx.PutPixel( 86 + x,62 + y,208,33,33 );
	gfx.PutPixel( 87 + x,62 + y,208,33,33 );
	gfx.PutPixel( 88 + x,62 + y,208,33,33 );
	gfx.PutPixel( 89 + x,62 + y,208,33,33 );
	gfx.PutPixel( 90 + x,62 + y,208,34,34 );
	gfx.PutPixel( 91 + x,62 + y,208,30,30 );
	gfx.PutPixel( 92 + x,62 + y,209,47,47 );
	gfx.PutPixel( 93 + x,62 + y,220,208,208 );
	gfx.PutPixel( 94 + x,62 + y,221,225,225 );
	gfx.PutPixel( 95 + x,62 + y,222,234,234 );
	gfx.PutPixel( 96 + x,62 + y,215,124,124 );
	gfx.PutPixel( 97 + x,62 + y,206,13,13 );
	gfx.PutPixel( 98 + x,62 + y,207,25,25 );
	gfx.PutPixel( 99 + x,62 + y,207,25,25 );
	gfx.PutPixel( 100 + x,62 + y,207,27,27 );
	gfx.PutPixel( 101 + x,62 + y,208,30,30 );
	gfx.PutPixel( 102 + x,62 + y,208,33,33 );
	gfx.PutPixel( 103 + x,62 + y,208,34,34 );
	gfx.PutPixel( 104 + x,62 + y,208,34,34 );
	gfx.PutPixel( 105 + x,62 + y,208,34,34 );
	gfx.PutPixel( 106 + x,62 + y,208,34,34 );
	gfx.PutPixel( 107 + x,62 + y,208,34,34 );
	gfx.PutPixel( 108 + x,62 + y,208,34,34 );
	gfx.PutPixel( 109 + x,62 + y,208,34,34 );
	gfx.PutPixel( 110 + x,62 + y,208,34,34 );
	gfx.PutPixel( 111 + x,62 + y,208,34,34 );
	gfx.PutPixel( 112 + x,62 + y,208,34,34 );
	gfx.PutPixel( 113 + x,62 + y,208,34,34 );
	gfx.PutPixel( 114 + x,62 + y,208,34,34 );
	gfx.PutPixel( 115 + x,62 + y,208,34,34 );
	gfx.PutPixel( 116 + x,62 + y,208,34,34 );
	gfx.PutPixel( 117 + x,62 + y,208,34,34 );
	gfx.PutPixel( 118 + x,62 + y,208,34,34 );
	gfx.PutPixel( 119 + x,62 + y,208,34,34 );
	gfx.PutPixel( 120 + x,62 + y,208,34,34 );
	gfx.PutPixel( 121 + x,62 + y,208,34,34 );
	gfx.PutPixel( 122 + x,62 + y,208,34,34 );
	gfx.PutPixel( 123 + x,62 + y,208,34,34 );
	gfx.PutPixel( 124 + x,62 + y,208,34,34 );
	gfx.PutPixel( 125 + x,62 + y,208,34,34 );
	gfx.PutPixel( 126 + x,62 + y,208,34,34 );
	gfx.PutPixel( 127 + x,62 + y,208,34,34 );
	gfx.PutPixel( 128 + x,62 + y,208,34,34 );
	gfx.PutPixel( 129 + x,62 + y,208,34,34 );
	gfx.PutPixel( 130 + x,62 + y,208,34,34 );
	gfx.PutPixel( 131 + x,62 + y,208,34,34 );
	gfx.PutPixel( 132 + x,62 + y,208,34,34 );
	gfx.PutPixel( 133 + x,62 + y,208,34,34 );
	gfx.PutPixel( 134 + x,62 + y,208,34,34 );
	gfx.PutPixel( 135 + x,62 + y,208,34,34 );
	gfx.PutPixel( 136 + x,62 + y,208,34,34 );
	gfx.PutPixel( 137 + x,62 + y,208,34,34 );
	gfx.PutPixel( 138 + x,62 + y,208,34,34 );
	gfx.PutPixel( 139 + x,62 + y,208,34,34 );
	gfx.PutPixel( 140 + x,62 + y,208,34,34 );
	gfx.PutPixel( 141 + x,62 + y,208,34,34 );
	gfx.PutPixel( 142 + x,62 + y,208,34,34 );
	gfx.PutPixel( 143 + x,62 + y,208,34,34 );
	gfx.PutPixel( 144 + x,62 + y,208,34,34 );
	gfx.PutPixel( 145 + x,62 + y,208,34,34 );
	gfx.PutPixel( 146 + x,62 + y,208,34,34 );
	gfx.PutPixel( 147 + x,62 + y,208,34,34 );
	gfx.PutPixel( 148 + x,62 + y,208,34,34 );
	gfx.PutPixel( 149 + x,62 + y,208,34,34 );
	gfx.PutPixel( 0 + x,63 + y,208,34,34 );
	gfx.PutPixel( 1 + x,63 + y,208,34,34 );
	gfx.PutPixel( 2 + x,63 + y,208,34,34 );
	gfx.PutPixel( 3 + x,63 + y,208,34,34 );
	gfx.PutPixel( 4 + x,63 + y,208,34,34 );
	gfx.PutPixel( 5 + x,63 + y,208,34,34 );
	gfx.PutPixel( 6 + x,63 + y,208,34,34 );
	gfx.PutPixel( 7 + x,63 + y,208,34,34 );
	gfx.PutPixel( 8 + x,63 + y,208,34,34 );
	gfx.PutPixel( 9 + x,63 + y,208,34,34 );
	gfx.PutPixel( 10 + x,63 + y,208,34,34 );
	gfx.PutPixel( 11 + x,63 + y,208,34,34 );
	gfx.PutPixel( 12 + x,63 + y,208,34,34 );
	gfx.PutPixel( 13 + x,63 + y,208,34,34 );
	gfx.PutPixel( 14 + x,63 + y,208,34,34 );
	gfx.PutPixel( 15 + x,63 + y,208,34,34 );
	gfx.PutPixel( 16 + x,63 + y,208,34,34 );
	gfx.PutPixel( 17 + x,63 + y,208,34,34 );
	gfx.PutPixel( 18 + x,63 + y,208,34,34 );
	gfx.PutPixel( 19 + x,63 + y,208,34,34 );
	gfx.PutPixel( 20 + x,63 + y,208,34,34 );
	gfx.PutPixel( 21 + x,63 + y,208,34,34 );
	gfx.PutPixel( 22 + x,63 + y,208,34,34 );
	gfx.PutPixel( 23 + x,63 + y,208,34,34 );
	gfx.PutPixel( 24 + x,63 + y,208,34,34 );
	gfx.PutPixel( 25 + x,63 + y,208,34,34 );
	gfx.PutPixel( 26 + x,63 + y,208,34,34 );
	gfx.PutPixel( 27 + x,63 + y,208,34,34 );
	gfx.PutPixel( 28 + x,63 + y,208,34,34 );
	gfx.PutPixel( 29 + x,63 + y,208,34,34 );
	gfx.PutPixel( 30 + x,63 + y,208,34,34 );
	gfx.PutPixel( 31 + x,63 + y,208,34,34 );
	gfx.PutPixel( 32 + x,63 + y,208,34,34 );
	gfx.PutPixel( 33 + x,63 + y,208,34,34 );
	gfx.PutPixel( 34 + x,63 + y,208,34,34 );
	gfx.PutPixel( 35 + x,63 + y,208,34,34 );
	gfx.PutPixel( 36 + x,63 + y,208,34,34 );
	gfx.PutPixel( 37 + x,63 + y,208,34,34 );
	gfx.PutPixel( 38 + x,63 + y,208,34,34 );
	gfx.PutPixel( 39 + x,63 + y,208,34,34 );
	gfx.PutPixel( 40 + x,63 + y,208,34,34 );
	gfx.PutPixel( 41 + x,63 + y,208,34,34 );
	gfx.PutPixel( 42 + x,63 + y,208,34,34 );
	gfx.PutPixel( 43 + x,63 + y,208,34,34 );
	gfx.PutPixel( 44 + x,63 + y,208,30,30 );
	gfx.PutPixel( 45 + x,63 + y,209,47,47 );
	gfx.PutPixel( 46 + x,63 + y,220,208,208 );
	gfx.PutPixel( 47 + x,63 + y,221,225,225 );
	gfx.PutPixel( 48 + x,63 + y,222,233,233 );
	gfx.PutPixel( 49 + x,63 + y,215,128,128 );
	gfx.PutPixel( 50 + x,63 + y,207,22,22 );
	gfx.PutPixel( 51 + x,63 + y,207,22,22 );
	gfx.PutPixel( 52 + x,63 + y,211,84,84 );
	gfx.PutPixel( 53 + x,63 + y,221,222,222 );
	gfx.PutPixel( 54 + x,63 + y,221,225,225 );
	gfx.PutPixel( 55 + x,63 + y,221,220,220 );
	gfx.PutPixel( 56 + x,63 + y,222,232,232 );
	gfx.PutPixel( 57 + x,63 + y,218,176,176 );
	gfx.PutPixel( 58 + x,63 + y,208,37,37 );
	gfx.PutPixel( 59 + x,63 + y,208,29,29 );
	gfx.PutPixel( 60 + x,63 + y,208,34,34 );
	gfx.PutPixel( 61 + x,63 + y,208,34,34 );
	gfx.PutPixel( 62 + x,63 + y,208,27,27 );
	gfx.PutPixel( 63 + x,63 + y,218,173,173 );
	gfx.PutPixel( 64 + x,63 + y,222,230,230 );
	gfx.PutPixel( 65 + x,63 + y,222,230,230 );
	gfx.PutPixel( 66 + x,63 + y,218,171,171 );
	gfx.PutPixel( 67 + x,63 + y,208,20,20 );
	gfx.PutPixel( 68 + x,63 + y,208,27,27 );
	gfx.PutPixel( 69 + x,63 + y,208,27,27 );
	gfx.PutPixel( 70 + x,63 + y,208,27,27 );
	gfx.PutPixel( 71 + x,63 + y,208,27,27 );
	gfx.PutPixel( 72 + x,63 + y,208,27,27 );
	gfx.PutPixel( 73 + x,63 + y,208,27,27 );
	gfx.PutPixel( 74 + x,63 + y,208,28,28 );
	gfx.PutPixel( 75 + x,63 + y,208,34,34 );
	gfx.PutPixel( 76 + x,63 + y,208,34,34 );
	gfx.PutPixel( 77 + x,63 + y,208,27,27 );
	gfx.PutPixel( 78 + x,63 + y,218,173,173 );
	gfx.PutPixel( 79 + x,63 + y,222,230,230 );
	gfx.PutPixel( 80 + x,63 + y,222,230,230 );
	gfx.PutPixel( 81 + x,63 + y,218,171,171 );
	gfx.PutPixel( 82 + x,63 + y,208,20,20 );
	gfx.PutPixel( 83 + x,63 + y,208,27,27 );
	gfx.PutPixel( 84 + x,63 + y,208,27,27 );
	gfx.PutPixel( 85 + x,63 + y,208,27,27 );
	gfx.PutPixel( 86 + x,63 + y,208,27,27 );
	gfx.PutPixel( 87 + x,63 + y,208,27,27 );
	gfx.PutPixel( 88 + x,63 + y,208,27,27 );
	gfx.PutPixel( 89 + x,63 + y,208,28,28 );
	gfx.PutPixel( 90 + x,63 + y,208,34,34 );
	gfx.PutPixel( 91 + x,63 + y,208,30,30 );
	gfx.PutPixel( 92 + x,63 + y,209,47,47 );
	gfx.PutPixel( 93 + x,63 + y,220,208,208 );
	gfx.PutPixel( 94 + x,63 + y,221,225,225 );
	gfx.PutPixel( 95 + x,63 + y,222,233,233 );
	gfx.PutPixel( 96 + x,63 + y,215,128,128 );
	gfx.PutPixel( 97 + x,63 + y,207,22,22 );
	gfx.PutPixel( 98 + x,63 + y,208,34,34 );
	gfx.PutPixel( 99 + x,63 + y,208,34,34 );
	gfx.PutPixel( 100 + x,63 + y,208,34,34 );
	gfx.PutPixel( 101 + x,63 + y,208,34,34 );
	gfx.PutPixel( 102 + x,63 + y,208,34,34 );
	gfx.PutPixel( 103 + x,63 + y,208,34,34 );
	gfx.PutPixel( 104 + x,63 + y,208,34,34 );
	gfx.PutPixel( 105 + x,63 + y,208,34,34 );
	gfx.PutPixel( 106 + x,63 + y,208,34,34 );
	gfx.PutPixel( 107 + x,63 + y,208,34,34 );
	gfx.PutPixel( 108 + x,63 + y,208,34,34 );
	gfx.PutPixel( 109 + x,63 + y,208,34,34 );
	gfx.PutPixel( 110 + x,63 + y,208,34,34 );
	gfx.PutPixel( 111 + x,63 + y,208,34,34 );
	gfx.PutPixel( 112 + x,63 + y,208,34,34 );
	gfx.PutPixel( 113 + x,63 + y,208,34,34 );
	gfx.PutPixel( 114 + x,63 + y,208,34,34 );
	gfx.PutPixel( 115 + x,63 + y,208,34,34 );
	gfx.PutPixel( 116 + x,63 + y,208,34,34 );
	gfx.PutPixel( 117 + x,63 + y,208,34,34 );
	gfx.PutPixel( 118 + x,63 + y,208,34,34 );
	gfx.PutPixel( 119 + x,63 + y,208,34,34 );
	gfx.PutPixel( 120 + x,63 + y,208,34,34 );
	gfx.PutPixel( 121 + x,63 + y,208,34,34 );
	gfx.PutPixel( 122 + x,63 + y,208,34,34 );
	gfx.PutPixel( 123 + x,63 + y,208,34,34 );
	gfx.PutPixel( 124 + x,63 + y,208,34,34 );
	gfx.PutPixel( 125 + x,63 + y,208,34,34 );
	gfx.PutPixel( 126 + x,63 + y,208,34,34 );
	gfx.PutPixel( 127 + x,63 + y,208,34,34 );
	gfx.PutPixel( 128 + x,63 + y,208,34,34 );
	gfx.PutPixel( 129 + x,63 + y,208,34,34 );
	gfx.PutPixel( 130 + x,63 + y,208,34,34 );
	gfx.PutPixel( 131 + x,63 + y,208,34,34 );
	gfx.PutPixel( 132 + x,63 + y,208,34,34 );
	gfx.PutPixel( 133 + x,63 + y,208,34,34 );
	gfx.PutPixel( 134 + x,63 + y,208,34,34 );
	gfx.PutPixel( 135 + x,63 + y,208,34,34 );
	gfx.PutPixel( 136 + x,63 + y,208,34,34 );
	gfx.PutPixel( 137 + x,63 + y,208,34,34 );
	gfx.PutPixel( 138 + x,63 + y,208,34,34 );
	gfx.PutPixel( 139 + x,63 + y,208,34,34 );
	gfx.PutPixel( 140 + x,63 + y,208,34,34 );
	gfx.PutPixel( 141 + x,63 + y,208,34,34 );
	gfx.PutPixel( 142 + x,63 + y,208,34,34 );
	gfx.PutPixel( 143 + x,63 + y,208,34,34 );
	gfx.PutPixel( 144 + x,63 + y,208,34,34 );
	gfx.PutPixel( 145 + x,63 + y,208,34,34 );
	gfx.PutPixel( 146 + x,63 + y,208,34,34 );
	gfx.PutPixel( 147 + x,63 + y,208,34,34 );
	gfx.PutPixel( 148 + x,63 + y,208,34,34 );
	gfx.PutPixel( 149 + x,63 + y,208,34,34 );
	gfx.PutPixel( 0 + x,64 + y,208,34,34 );
	gfx.PutPixel( 1 + x,64 + y,208,34,34 );
	gfx.PutPixel( 2 + x,64 + y,208,34,34 );
	gfx.PutPixel( 3 + x,64 + y,208,34,34 );
	gfx.PutPixel( 4 + x,64 + y,208,34,34 );
	gfx.PutPixel( 5 + x,64 + y,208,34,34 );
	gfx.PutPixel( 6 + x,64 + y,208,34,34 );
	gfx.PutPixel( 7 + x,64 + y,208,34,34 );
	gfx.PutPixel( 8 + x,64 + y,208,34,34 );
	gfx.PutPixel( 9 + x,64 + y,208,34,34 );
	gfx.PutPixel( 10 + x,64 + y,208,34,34 );
	gfx.PutPixel( 11 + x,64 + y,208,34,34 );
	gfx.PutPixel( 12 + x,64 + y,208,34,34 );
	gfx.PutPixel( 13 + x,64 + y,208,34,34 );
	gfx.PutPixel( 14 + x,64 + y,208,34,34 );
	gfx.PutPixel( 15 + x,64 + y,208,34,34 );
	gfx.PutPixel( 16 + x,64 + y,208,34,34 );
	gfx.PutPixel( 17 + x,64 + y,208,34,34 );
	gfx.PutPixel( 18 + x,64 + y,208,34,34 );
	gfx.PutPixel( 19 + x,64 + y,208,34,34 );
	gfx.PutPixel( 20 + x,64 + y,208,34,34 );
	gfx.PutPixel( 21 + x,64 + y,208,34,34 );
	gfx.PutPixel( 22 + x,64 + y,208,34,34 );
	gfx.PutPixel( 23 + x,64 + y,208,34,34 );
	gfx.PutPixel( 24 + x,64 + y,208,34,34 );
	gfx.PutPixel( 25 + x,64 + y,208,34,34 );
	gfx.PutPixel( 26 + x,64 + y,208,34,34 );
	gfx.PutPixel( 27 + x,64 + y,208,34,34 );
	gfx.PutPixel( 28 + x,64 + y,208,34,34 );
	gfx.PutPixel( 29 + x,64 + y,208,34,34 );
	gfx.PutPixel( 30 + x,64 + y,208,34,34 );
	gfx.PutPixel( 31 + x,64 + y,208,34,34 );
	gfx.PutPixel( 32 + x,64 + y,208,34,34 );
	gfx.PutPixel( 33 + x,64 + y,208,34,34 );
	gfx.PutPixel( 34 + x,64 + y,208,34,34 );
	gfx.PutPixel( 35 + x,64 + y,208,34,34 );
	gfx.PutPixel( 36 + x,64 + y,208,34,34 );
	gfx.PutPixel( 37 + x,64 + y,208,34,34 );
	gfx.PutPixel( 38 + x,64 + y,208,34,34 );
	gfx.PutPixel( 39 + x,64 + y,208,34,34 );
	gfx.PutPixel( 40 + x,64 + y,208,34,34 );
	gfx.PutPixel( 41 + x,64 + y,208,34,34 );
	gfx.PutPixel( 42 + x,64 + y,208,34,34 );
	gfx.PutPixel( 43 + x,64 + y,208,34,34 );
	gfx.PutPixel( 44 + x,64 + y,208,30,30 );
	gfx.PutPixel( 45 + x,64 + y,209,47,47 );
	gfx.PutPixel( 46 + x,64 + y,220,208,208 );
	gfx.PutPixel( 47 + x,64 + y,221,225,225 );
	gfx.PutPixel( 48 + x,64 + y,222,233,233 );
	gfx.PutPixel( 49 + x,64 + y,215,128,128 );
	gfx.PutPixel( 50 + x,64 + y,207,22,22 );
	gfx.PutPixel( 51 + x,64 + y,208,34,34 );
	gfx.PutPixel( 52 + x,64 + y,207,21,21 );
	gfx.PutPixel( 53 + x,64 + y,213,107,107 );
	gfx.PutPixel( 54 + x,64 + y,222,229,229 );
	gfx.PutPixel( 55 + x,64 + y,221,223,223 );
	gfx.PutPixel( 56 + x,64 + y,221,221,221 );
	gfx.PutPixel( 57 + x,64 + y,222,233,233 );
	gfx.PutPixel( 58 + x,64 + y,217,162,162 );
	gfx.PutPixel( 59 + x,64 + y,208,30,30 );
	gfx.PutPixel( 60 + x,64 + y,208,31,31 );
	gfx.PutPixel( 61 + x,64 + y,208,34,34 );
	gfx.PutPixel( 62 + x,64 + y,208,27,27 );
	gfx.PutPixel( 63 + x,64 + y,218,173,173 );
	gfx.PutPixel( 64 + x,64 + y,222,230,230 );
	gfx.PutPixel( 65 + x,64 + y,221,223,223 );
	gfx.PutPixel( 66 + x,64 + y,220,209,209 );
	gfx.PutPixel( 67 + x,64 + y,218,171,171 );
	gfx.PutPixel( 68 + x,64 + y,218,173,173 );
	gfx.PutPixel( 69 + x,64 + y,218,173,173 );
	gfx.PutPixel( 70 + x,64 + y,218,173,173 );
	gfx.PutPixel( 71 + x,64 + y,218,173,173 );
	gfx.PutPixel( 72 + x,64 + y,218,173,173 );
	gfx.PutPixel( 73 + x,64 + y,218,176,176 );
	gfx.PutPixel( 74 + x,64 + y,217,161,161 );
	gfx.PutPixel( 75 + x,64 + y,209,43,43 );
	gfx.PutPixel( 76 + x,64 + y,208,31,31 );
	gfx.PutPixel( 77 + x,64 + y,208,27,27 );
	gfx.PutPixel( 78 + x,64 + y,218,173,173 );
	gfx.PutPixel( 79 + x,64 + y,222,230,230 );
	gfx.PutPixel( 80 + x,64 + y,221,223,223 );
	gfx.PutPixel( 81 + x,64 + y,220,209,209 );
	gfx.PutPixel( 82 + x,64 + y,218,171,171 );
	gfx.PutPixel( 83 + x,64 + y,218,173,173 );
	gfx.PutPixel( 84 + x,64 + y,218,173,173 );
	gfx.PutPixel( 85 + x,64 + y,218,173,173 );
	gfx.PutPixel( 86 + x,64 + y,218,173,173 );
	gfx.PutPixel( 87 + x,64 + y,218,173,173 );
	gfx.PutPixel( 88 + x,64 + y,218,176,176 );
	gfx.PutPixel( 89 + x,64 + y,217,161,161 );
	gfx.PutPixel( 90 + x,64 + y,209,43,43 );
	gfx.PutPixel( 91 + x,64 + y,208,28,28 );
	gfx.PutPixel( 92 + x,64 + y,209,47,47 );
	gfx.PutPixel( 93 + x,64 + y,220,208,208 );
	gfx.PutPixel( 94 + x,64 + y,221,225,225 );
	gfx.PutPixel( 95 + x,64 + y,222,233,233 );
	gfx.PutPixel( 96 + x,64 + y,215,128,128 );
	gfx.PutPixel( 97 + x,64 + y,207,22,22 );
	gfx.PutPixel( 98 + x,64 + y,208,34,34 );
	gfx.PutPixel( 99 + x,64 + y,208,34,34 );
	gfx.PutPixel( 100 + x,64 + y,208,34,34 );
	gfx.PutPixel( 101 + x,64 + y,208,34,34 );
	gfx.PutPixel( 102 + x,64 + y,208,34,34 );
	gfx.PutPixel( 103 + x,64 + y,208,34,34 );
	gfx.PutPixel( 104 + x,64 + y,208,34,34 );
	gfx.PutPixel( 105 + x,64 + y,208,34,34 );
	gfx.PutPixel( 106 + x,64 + y,208,34,34 );
	gfx.PutPixel( 107 + x,64 + y,208,34,34 );
	gfx.PutPixel( 108 + x,64 + y,208,34,34 );
	gfx.PutPixel( 109 + x,64 + y,208,34,34 );
	gfx.PutPixel( 110 + x,64 + y,208,34,34 );
	gfx.PutPixel( 111 + x,64 + y,208,34,34 );
	gfx.PutPixel( 112 + x,64 + y,208,34,34 );
	gfx.PutPixel( 113 + x,64 + y,208,34,34 );
	gfx.PutPixel( 114 + x,64 + y,208,34,34 );
	gfx.PutPixel( 115 + x,64 + y,208,34,34 );
	gfx.PutPixel( 116 + x,64 + y,208,34,34 );
	gfx.PutPixel( 117 + x,64 + y,208,34,34 );
	gfx.PutPixel( 118 + x,64 + y,208,34,34 );
	gfx.PutPixel( 119 + x,64 + y,208,34,34 );
	gfx.PutPixel( 120 + x,64 + y,208,34,34 );
	gfx.PutPixel( 121 + x,64 + y,208,34,34 );
	gfx.PutPixel( 122 + x,64 + y,208,34,34 );
	gfx.PutPixel( 123 + x,64 + y,208,34,34 );
	gfx.PutPixel( 124 + x,64 + y,208,34,34 );
	gfx.PutPixel( 125 + x,64 + y,208,34,34 );
	gfx.PutPixel( 126 + x,64 + y,208,34,34 );
	gfx.PutPixel( 127 + x,64 + y,208,34,34 );
	gfx.PutPixel( 128 + x,64 + y,208,34,34 );
	gfx.PutPixel( 129 + x,64 + y,208,34,34 );
	gfx.PutPixel( 130 + x,64 + y,208,34,34 );
	gfx.PutPixel( 131 + x,64 + y,208,34,34 );
	gfx.PutPixel( 132 + x,64 + y,208,34,34 );
	gfx.PutPixel( 133 + x,64 + y,208,34,34 );
	gfx.PutPixel( 134 + x,64 + y,208,34,34 );
	gfx.PutPixel( 135 + x,64 + y,208,34,34 );
	gfx.PutPixel( 136 + x,64 + y,208,34,34 );
	gfx.PutPixel( 137 + x,64 + y,208,34,34 );
	gfx.PutPixel( 138 + x,64 + y,208,34,34 );
	gfx.PutPixel( 139 + x,64 + y,208,34,34 );
	gfx.PutPixel( 140 + x,64 + y,208,34,34 );
	gfx.PutPixel( 141 + x,64 + y,208,34,34 );
	gfx.PutPixel( 142 + x,64 + y,208,34,34 );
	gfx.PutPixel( 143 + x,64 + y,208,34,34 );
	gfx.PutPixel( 144 + x,64 + y,208,34,34 );
	gfx.PutPixel( 145 + x,64 + y,208,34,34 );
	gfx.PutPixel( 146 + x,64 + y,208,34,34 );
	gfx.PutPixel( 147 + x,64 + y,208,34,34 );
	gfx.PutPixel( 148 + x,64 + y,208,34,34 );
	gfx.PutPixel( 149 + x,64 + y,208,34,34 );
	gfx.PutPixel( 0 + x,65 + y,208,34,34 );
	gfx.PutPixel( 1 + x,65 + y,208,34,34 );
	gfx.PutPixel( 2 + x,65 + y,208,34,34 );
	gfx.PutPixel( 3 + x,65 + y,208,34,34 );
	gfx.PutPixel( 4 + x,65 + y,208,34,34 );
	gfx.PutPixel( 5 + x,65 + y,208,34,34 );
	gfx.PutPixel( 6 + x,65 + y,208,34,34 );
	gfx.PutPixel( 7 + x,65 + y,208,34,34 );
	gfx.PutPixel( 8 + x,65 + y,208,34,34 );
	gfx.PutPixel( 9 + x,65 + y,208,34,34 );
	gfx.PutPixel( 10 + x,65 + y,208,34,34 );
	gfx.PutPixel( 11 + x,65 + y,208,34,34 );
	gfx.PutPixel( 12 + x,65 + y,208,34,34 );
	gfx.PutPixel( 13 + x,65 + y,208,34,34 );
	gfx.PutPixel( 14 + x,65 + y,208,34,34 );
	gfx.PutPixel( 15 + x,65 + y,208,34,34 );
	gfx.PutPixel( 16 + x,65 + y,208,34,34 );
	gfx.PutPixel( 17 + x,65 + y,208,34,34 );
	gfx.PutPixel( 18 + x,65 + y,208,34,34 );
	gfx.PutPixel( 19 + x,65 + y,208,34,34 );
	gfx.PutPixel( 20 + x,65 + y,208,34,34 );
	gfx.PutPixel( 21 + x,65 + y,208,34,34 );
	gfx.PutPixel( 22 + x,65 + y,208,34,34 );
	gfx.PutPixel( 23 + x,65 + y,208,34,34 );
	gfx.PutPixel( 24 + x,65 + y,208,34,34 );
	gfx.PutPixel( 25 + x,65 + y,208,34,34 );
	gfx.PutPixel( 26 + x,65 + y,208,34,34 );
	gfx.PutPixel( 27 + x,65 + y,208,34,34 );
	gfx.PutPixel( 28 + x,65 + y,208,34,34 );
	gfx.PutPixel( 29 + x,65 + y,208,34,34 );
	gfx.PutPixel( 30 + x,65 + y,208,34,34 );
	gfx.PutPixel( 31 + x,65 + y,208,34,34 );
	gfx.PutPixel( 32 + x,65 + y,208,34,34 );
	gfx.PutPixel( 33 + x,65 + y,208,34,34 );
	gfx.PutPixel( 34 + x,65 + y,208,34,34 );
	gfx.PutPixel( 35 + x,65 + y,208,34,34 );
	gfx.PutPixel( 36 + x,65 + y,208,34,34 );
	gfx.PutPixel( 37 + x,65 + y,208,34,34 );
	gfx.PutPixel( 38 + x,65 + y,208,34,34 );
	gfx.PutPixel( 39 + x,65 + y,208,34,34 );
	gfx.PutPixel( 40 + x,65 + y,208,34,34 );
	gfx.PutPixel( 41 + x,65 + y,208,34,34 );
	gfx.PutPixel( 42 + x,65 + y,208,34,34 );
	gfx.PutPixel( 43 + x,65 + y,208,34,34 );
	gfx.PutPixel( 44 + x,65 + y,208,30,30 );
	gfx.PutPixel( 45 + x,65 + y,209,47,47 );
	gfx.PutPixel( 46 + x,65 + y,220,208,208 );
	gfx.PutPixel( 47 + x,65 + y,221,225,225 );
	gfx.PutPixel( 48 + x,65 + y,222,233,233 );
	gfx.PutPixel( 49 + x,65 + y,215,128,128 );
	gfx.PutPixel( 50 + x,65 + y,207,22,22 );
	gfx.PutPixel( 51 + x,65 + y,208,34,34 );
	gfx.PutPixel( 52 + x,65 + y,208,33,33 );
	gfx.PutPixel( 53 + x,65 + y,207,23,23 );
	gfx.PutPixel( 54 + x,65 + y,215,130,130 );
	gfx.PutPixel( 55 + x,65 + y,222,233,233 );
	gfx.PutPixel( 56 + x,65 + y,221,221,221 );
	gfx.PutPixel( 57 + x,65 + y,221,221,221 );
	gfx.PutPixel( 58 + x,65 + y,222,233,233 );
	gfx.PutPixel( 59 + x,65 + y,216,146,146 );
	gfx.PutPixel( 60 + x,65 + y,208,26,26 );
	gfx.PutPixel( 61 + x,65 + y,208,31,31 );
	gfx.PutPixel( 62 + x,65 + y,208,27,27 );
	gfx.PutPixel( 63 + x,65 + y,218,173,173 );
	gfx.PutPixel( 64 + x,65 + y,222,230,230 );
	gfx.PutPixel( 65 + x,65 + y,221,221,221 );
	gfx.PutPixel( 66 + x,65 + y,221,223,223 );
	gfx.PutPixel( 67 + x,65 + y,222,230,230 );
	gfx.PutPixel( 68 + x,65 + y,222,230,230 );
	gfx.PutPixel( 69 + x,65 + y,222,230,230 );
	gfx.PutPixel( 70 + x,65 + y,222,230,230 );
	gfx.PutPixel( 71 + x,65 + y,222,230,230 );
	gfx.PutPixel( 72 + x,65 + y,222,230,230 );
	gfx.PutPixel( 73 + x,65 + y,222,234,234 );
	gfx.PutPixel( 74 + x,65 + y,221,213,213 );
	gfx.PutPixel( 75 + x,65 + y,209,47,47 );
	gfx.PutPixel( 76 + x,65 + y,208,30,30 );
	gfx.PutPixel( 77 + x,65 + y,208,27,27 );
	gfx.PutPixel( 78 + x,65 + y,218,173,173 );
	gfx.PutPixel( 79 + x,65 + y,222,230,230 );
	gfx.PutPixel( 80 + x,65 + y,221,221,221 );
	gfx.PutPixel( 81 + x,65 + y,221,223,223 );
	gfx.PutPixel( 82 + x,65 + y,222,230,230 );
	gfx.PutPixel( 83 + x,65 + y,222,230,230 );
	gfx.PutPixel( 84 + x,65 + y,222,230,230 );
	gfx.PutPixel( 85 + x,65 + y,222,230,230 );
	gfx.PutPixel( 86 + x,65 + y,222,230,230 );
	gfx.PutPixel( 87 + x,65 + y,222,230,230 );
	gfx.PutPixel( 88 + x,65 + y,222,234,234 );
	gfx.PutPixel( 89 + x,65 + y,221,213,213 );
	gfx.PutPixel( 90 + x,65 + y,209,47,47 );
	gfx.PutPixel( 91 + x,65 + y,208,27,27 );
	gfx.PutPixel( 92 + x,65 + y,209,47,47 );
	gfx.PutPixel( 93 + x,65 + y,220,208,208 );
	gfx.PutPixel( 94 + x,65 + y,221,225,225 );
	gfx.PutPixel( 95 + x,65 + y,222,233,233 );
	gfx.PutPixel( 96 + x,65 + y,215,128,128 );
	gfx.PutPixel( 97 + x,65 + y,207,22,22 );
	gfx.PutPixel( 98 + x,65 + y,208,34,34 );
	gfx.PutPixel( 99 + x,65 + y,208,34,34 );
	gfx.PutPixel( 100 + x,65 + y,208,34,34 );
	gfx.PutPixel( 101 + x,65 + y,208,34,34 );
	gfx.PutPixel( 102 + x,65 + y,208,34,34 );
	gfx.PutPixel( 103 + x,65 + y,208,34,34 );
	gfx.PutPixel( 104 + x,65 + y,208,34,34 );
	gfx.PutPixel( 105 + x,65 + y,208,34,34 );
	gfx.PutPixel( 106 + x,65 + y,208,34,34 );
	gfx.PutPixel( 107 + x,65 + y,208,34,34 );
	gfx.PutPixel( 108 + x,65 + y,208,34,34 );
	gfx.PutPixel( 109 + x,65 + y,208,34,34 );
	gfx.PutPixel( 110 + x,65 + y,208,34,34 );
	gfx.PutPixel( 111 + x,65 + y,208,34,34 );
	gfx.PutPixel( 112 + x,65 + y,208,34,34 );
	gfx.PutPixel( 113 + x,65 + y,208,34,34 );
	gfx.PutPixel( 114 + x,65 + y,208,34,34 );
	gfx.PutPixel( 115 + x,65 + y,208,34,34 );
	gfx.PutPixel( 116 + x,65 + y,208,34,34 );
	gfx.PutPixel( 117 + x,65 + y,208,34,34 );
	gfx.PutPixel( 118 + x,65 + y,208,34,34 );
	gfx.PutPixel( 119 + x,65 + y,208,34,34 );
	gfx.PutPixel( 120 + x,65 + y,208,34,34 );
	gfx.PutPixel( 121 + x,65 + y,208,34,34 );
	gfx.PutPixel( 122 + x,65 + y,208,34,34 );
	gfx.PutPixel( 123 + x,65 + y,208,34,34 );
	gfx.PutPixel( 124 + x,65 + y,208,34,34 );
	gfx.PutPixel( 125 + x,65 + y,208,34,34 );
	gfx.PutPixel( 126 + x,65 + y,208,34,34 );
	gfx.PutPixel( 127 + x,65 + y,208,34,34 );
	gfx.PutPixel( 128 + x,65 + y,208,34,34 );
	gfx.PutPixel( 129 + x,65 + y,208,34,34 );
	gfx.PutPixel( 130 + x,65 + y,208,34,34 );
	gfx.PutPixel( 131 + x,65 + y,208,34,34 );
	gfx.PutPixel( 132 + x,65 + y,208,34,34 );
	gfx.PutPixel( 133 + x,65 + y,208,34,34 );
	gfx.PutPixel( 134 + x,65 + y,208,34,34 );
	gfx.PutPixel( 135 + x,65 + y,208,34,34 );
	gfx.PutPixel( 136 + x,65 + y,208,34,34 );
	gfx.PutPixel( 137 + x,65 + y,208,34,34 );
	gfx.PutPixel( 138 + x,65 + y,208,34,34 );
	gfx.PutPixel( 139 + x,65 + y,208,34,34 );
	gfx.PutPixel( 140 + x,65 + y,208,34,34 );
	gfx.PutPixel( 141 + x,65 + y,208,34,34 );
	gfx.PutPixel( 142 + x,65 + y,208,34,34 );
	gfx.PutPixel( 143 + x,65 + y,208,34,34 );
	gfx.PutPixel( 144 + x,65 + y,208,34,34 );
	gfx.PutPixel( 145 + x,65 + y,208,34,34 );
	gfx.PutPixel( 146 + x,65 + y,208,34,34 );
	gfx.PutPixel( 147 + x,65 + y,208,34,34 );
	gfx.PutPixel( 148 + x,65 + y,208,34,34 );
	gfx.PutPixel( 149 + x,65 + y,208,34,34 );
	gfx.PutPixel( 0 + x,66 + y,208,34,34 );
	gfx.PutPixel( 1 + x,66 + y,208,34,34 );
	gfx.PutPixel( 2 + x,66 + y,208,34,34 );
	gfx.PutPixel( 3 + x,66 + y,208,34,34 );
	gfx.PutPixel( 4 + x,66 + y,208,34,34 );
	gfx.PutPixel( 5 + x,66 + y,208,34,34 );
	gfx.PutPixel( 6 + x,66 + y,208,34,34 );
	gfx.PutPixel( 7 + x,66 + y,208,34,34 );
	gfx.PutPixel( 8 + x,66 + y,208,34,34 );
	gfx.PutPixel( 9 + x,66 + y,208,34,34 );
	gfx.PutPixel( 10 + x,66 + y,208,34,34 );
	gfx.PutPixel( 11 + x,66 + y,208,34,34 );
	gfx.PutPixel( 12 + x,66 + y,208,34,34 );
	gfx.PutPixel( 13 + x,66 + y,208,34,34 );
	gfx.PutPixel( 14 + x,66 + y,208,34,34 );
	gfx.PutPixel( 15 + x,66 + y,208,34,34 );
	gfx.PutPixel( 16 + x,66 + y,208,34,34 );
	gfx.PutPixel( 17 + x,66 + y,208,34,34 );
	gfx.PutPixel( 18 + x,66 + y,208,34,34 );
	gfx.PutPixel( 19 + x,66 + y,208,34,34 );
	gfx.PutPixel( 20 + x,66 + y,208,34,34 );
	gfx.PutPixel( 21 + x,66 + y,208,34,34 );
	gfx.PutPixel( 22 + x,66 + y,208,34,34 );
	gfx.PutPixel( 23 + x,66 + y,208,34,34 );
	gfx.PutPixel( 24 + x,66 + y,208,34,34 );
	gfx.PutPixel( 25 + x,66 + y,208,34,34 );
	gfx.PutPixel( 26 + x,66 + y,208,34,34 );
	gfx.PutPixel( 27 + x,66 + y,208,34,34 );
	gfx.PutPixel( 28 + x,66 + y,208,34,34 );
	gfx.PutPixel( 29 + x,66 + y,208,34,34 );
	gfx.PutPixel( 30 + x,66 + y,208,34,34 );
	gfx.PutPixel( 31 + x,66 + y,208,34,34 );
	gfx.PutPixel( 32 + x,66 + y,208,34,34 );
	gfx.PutPixel( 33 + x,66 + y,208,34,34 );
	gfx.PutPixel( 34 + x,66 + y,208,34,34 );
	gfx.PutPixel( 35 + x,66 + y,208,34,34 );
	gfx.PutPixel( 36 + x,66 + y,208,34,34 );
	gfx.PutPixel( 37 + x,66 + y,208,34,34 );
	gfx.PutPixel( 38 + x,66 + y,208,34,34 );
	gfx.PutPixel( 39 + x,66 + y,208,34,34 );
	gfx.PutPixel( 40 + x,66 + y,208,34,34 );
	gfx.PutPixel( 41 + x,66 + y,208,34,34 );
	gfx.PutPixel( 42 + x,66 + y,208,34,34 );
	gfx.PutPixel( 43 + x,66 + y,208,34,34 );
	gfx.PutPixel( 44 + x,66 + y,208,30,30 );
	gfx.PutPixel( 45 + x,66 + y,209,48,48 );
	gfx.PutPixel( 46 + x,66 + y,221,216,216 );
	gfx.PutPixel( 47 + x,66 + y,222,234,234 );
	gfx.PutPixel( 48 + x,66 + y,223,242,242 );
	gfx.PutPixel( 49 + x,66 + y,215,132,132 );
	gfx.PutPixel( 50 + x,66 + y,207,21,21 );
	gfx.PutPixel( 51 + x,66 + y,208,34,34 );
	gfx.PutPixel( 52 + x,66 + y,208,34,34 );
	gfx.PutPixel( 53 + x,66 + y,208,32,32 );
	gfx.PutPixel( 54 + x,66 + y,208,27,27 );
	gfx.PutPixel( 55 + x,66 + y,216,154,154 );
	gfx.PutPixel( 56 + x,66 + y,222,237,237 );
	gfx.PutPixel( 57 + x,66 + y,222,230,230 );
	gfx.PutPixel( 58 + x,66 + y,222,231,231 );
	gfx.PutPixel( 59 + x,66 + y,222,241,241 );
	gfx.PutPixel( 60 + x,66 + y,215,139,139 );
	gfx.PutPixel( 61 + x,66 + y,208,30,30 );
	gfx.PutPixel( 62 + x,66 + y,208,26,26 );
	gfx.PutPixel( 63 + x,66 + y,218,179,179 );
	gfx.PutPixel( 64 + x,66 + y,223,239,239 );
	gfx.PutPixel( 65 + x,66 + y,222,230,230 );
	gfx.PutPixel( 66 + x,66 + y,222,230,230 );
	gfx.PutPixel( 67 + x,66 + y,222,230,230 );
	gfx.PutPixel( 68 + x,66 + y,222,230,230 );
	gfx.PutPixel( 69 + x,66 + y,222,230,230 );
	gfx.PutPixel( 70 + x,66 + y,222,230,230 );
	gfx.PutPixel( 71 + x,66 + y,222,230,230 );
	gfx.PutPixel( 72 + x,66 + y,222,230,230 );
	gfx.PutPixel( 73 + x,66 + y,222,234,234 );
	gfx.PutPixel( 74 + x,66 + y,221,213,213 );
	gfx.PutPixel( 75 + x,66 + y,209,47,47 );
	gfx.PutPixel( 76 + x,66 + y,208,30,30 );
	gfx.PutPixel( 77 + x,66 + y,208,27,27 );
	gfx.PutPixel( 78 + x,66 + y,218,179,179 );
	gfx.PutPixel( 79 + x,66 + y,223,239,239 );
	gfx.PutPixel( 80 + x,66 + y,222,230,230 );
	gfx.PutPixel( 81 + x,66 + y,222,230,230 );
	gfx.PutPixel( 82 + x,66 + y,222,230,230 );
	gfx.PutPixel( 83 + x,66 + y,222,230,230 );
	gfx.PutPixel( 84 + x,66 + y,222,230,230 );
	gfx.PutPixel( 85 + x,66 + y,222,230,230 );
	gfx.PutPixel( 86 + x,66 + y,222,230,230 );
	gfx.PutPixel( 87 + x,66 + y,222,230,230 );
	gfx.PutPixel( 88 + x,66 + y,222,234,234 );
	gfx.PutPixel( 89 + x,66 + y,221,213,213 );
	gfx.PutPixel( 90 + x,66 + y,209,47,47 );
	gfx.PutPixel( 91 + x,66 + y,208,27,27 );
	gfx.PutPixel( 92 + x,66 + y,209,48,48 );
	gfx.PutPixel( 93 + x,66 + y,221,216,216 );
	gfx.PutPixel( 94 + x,66 + y,222,234,234 );
	gfx.PutPixel( 95 + x,66 + y,223,242,242 );
	gfx.PutPixel( 96 + x,66 + y,215,132,132 );
	gfx.PutPixel( 97 + x,66 + y,207,21,21 );
	gfx.PutPixel( 98 + x,66 + y,208,34,34 );
	gfx.PutPixel( 99 + x,66 + y,208,34,34 );
	gfx.PutPixel( 100 + x,66 + y,208,34,34 );
	gfx.PutPixel( 101 + x,66 + y,208,34,34 );
	gfx.PutPixel( 102 + x,66 + y,208,34,34 );
	gfx.PutPixel( 103 + x,66 + y,208,34,34 );
	gfx.PutPixel( 104 + x,66 + y,208,34,34 );
	gfx.PutPixel( 105 + x,66 + y,208,34,34 );
	gfx.PutPixel( 106 + x,66 + y,208,34,34 );
	gfx.PutPixel( 107 + x,66 + y,208,34,34 );
	gfx.PutPixel( 108 + x,66 + y,208,34,34 );
	gfx.PutPixel( 109 + x,66 + y,208,34,34 );
	gfx.PutPixel( 110 + x,66 + y,208,34,34 );
	gfx.PutPixel( 111 + x,66 + y,208,34,34 );
	gfx.PutPixel( 112 + x,66 + y,208,34,34 );
	gfx.PutPixel( 113 + x,66 + y,208,34,34 );
	gfx.PutPixel( 114 + x,66 + y,208,34,34 );
	gfx.PutPixel( 115 + x,66 + y,208,34,34 );
	gfx.PutPixel( 116 + x,66 + y,208,34,34 );
	gfx.PutPixel( 117 + x,66 + y,208,34,34 );
	gfx.PutPixel( 118 + x,66 + y,208,34,34 );
	gfx.PutPixel( 119 + x,66 + y,208,34,34 );
	gfx.PutPixel( 120 + x,66 + y,208,34,34 );
	gfx.PutPixel( 121 + x,66 + y,208,34,34 );
	gfx.PutPixel( 122 + x,66 + y,208,34,34 );
	gfx.PutPixel( 123 + x,66 + y,208,34,34 );
	gfx.PutPixel( 124 + x,66 + y,208,34,34 );
	gfx.PutPixel( 125 + x,66 + y,208,34,34 );
	gfx.PutPixel( 126 + x,66 + y,208,34,34 );
	gfx.PutPixel( 127 + x,66 + y,208,34,34 );
	gfx.PutPixel( 128 + x,66 + y,208,34,34 );
	gfx.PutPixel( 129 + x,66 + y,208,34,34 );
	gfx.PutPixel( 130 + x,66 + y,208,34,34 );
	gfx.PutPixel( 131 + x,66 + y,208,34,34 );
	gfx.PutPixel( 132 + x,66 + y,208,34,34 );
	gfx.PutPixel( 133 + x,66 + y,208,34,34 );
	gfx.PutPixel( 134 + x,66 + y,208,34,34 );
	gfx.PutPixel( 135 + x,66 + y,208,34,34 );
	gfx.PutPixel( 136 + x,66 + y,208,34,34 );
	gfx.PutPixel( 137 + x,66 + y,208,34,34 );
	gfx.PutPixel( 138 + x,66 + y,208,34,34 );
	gfx.PutPixel( 139 + x,66 + y,208,34,34 );
	gfx.PutPixel( 140 + x,66 + y,208,34,34 );
	gfx.PutPixel( 141 + x,66 + y,208,34,34 );
	gfx.PutPixel( 142 + x,66 + y,208,34,34 );
	gfx.PutPixel( 143 + x,66 + y,208,34,34 );
	gfx.PutPixel( 144 + x,66 + y,208,34,34 );
	gfx.PutPixel( 145 + x,66 + y,208,34,34 );
	gfx.PutPixel( 146 + x,66 + y,208,34,34 );
	gfx.PutPixel( 147 + x,66 + y,208,34,34 );
	gfx.PutPixel( 148 + x,66 + y,208,34,34 );
	gfx.PutPixel( 149 + x,66 + y,208,34,34 );
	gfx.PutPixel( 0 + x,67 + y,208,34,34 );
	gfx.PutPixel( 1 + x,67 + y,208,34,34 );
	gfx.PutPixel( 2 + x,67 + y,208,34,34 );
	gfx.PutPixel( 3 + x,67 + y,208,34,34 );
	gfx.PutPixel( 4 + x,67 + y,208,34,34 );
	gfx.PutPixel( 5 + x,67 + y,208,34,34 );
	gfx.PutPixel( 6 + x,67 + y,208,34,34 );
	gfx.PutPixel( 7 + x,67 + y,208,34,34 );
	gfx.PutPixel( 8 + x,67 + y,208,34,34 );
	gfx.PutPixel( 9 + x,67 + y,208,34,34 );
	gfx.PutPixel( 10 + x,67 + y,208,34,34 );
	gfx.PutPixel( 11 + x,67 + y,208,34,34 );
	gfx.PutPixel( 12 + x,67 + y,208,34,34 );
	gfx.PutPixel( 13 + x,67 + y,208,34,34 );
	gfx.PutPixel( 14 + x,67 + y,208,34,34 );
	gfx.PutPixel( 15 + x,67 + y,208,34,34 );
	gfx.PutPixel( 16 + x,67 + y,208,34,34 );
	gfx.PutPixel( 17 + x,67 + y,208,34,34 );
	gfx.PutPixel( 18 + x,67 + y,208,34,34 );
	gfx.PutPixel( 19 + x,67 + y,208,34,34 );
	gfx.PutPixel( 20 + x,67 + y,208,34,34 );
	gfx.PutPixel( 21 + x,67 + y,208,34,34 );
	gfx.PutPixel( 22 + x,67 + y,208,34,34 );
	gfx.PutPixel( 23 + x,67 + y,208,34,34 );
	gfx.PutPixel( 24 + x,67 + y,208,34,34 );
	gfx.PutPixel( 25 + x,67 + y,208,34,34 );
	gfx.PutPixel( 26 + x,67 + y,208,34,34 );
	gfx.PutPixel( 27 + x,67 + y,208,34,34 );
	gfx.PutPixel( 28 + x,67 + y,208,34,34 );
	gfx.PutPixel( 29 + x,67 + y,208,34,34 );
	gfx.PutPixel( 30 + x,67 + y,208,34,34 );
	gfx.PutPixel( 31 + x,67 + y,208,34,34 );
	gfx.PutPixel( 32 + x,67 + y,208,34,34 );
	gfx.PutPixel( 33 + x,67 + y,208,34,34 );
	gfx.PutPixel( 34 + x,67 + y,208,34,34 );
	gfx.PutPixel( 35 + x,67 + y,208,34,34 );
	gfx.PutPixel( 36 + x,67 + y,208,34,34 );
	gfx.PutPixel( 37 + x,67 + y,208,34,34 );
	gfx.PutPixel( 38 + x,67 + y,208,34,34 );
	gfx.PutPixel( 39 + x,67 + y,208,34,34 );
	gfx.PutPixel( 40 + x,67 + y,208,34,34 );
	gfx.PutPixel( 41 + x,67 + y,208,34,34 );
	gfx.PutPixel( 42 + x,67 + y,208,34,34 );
	gfx.PutPixel( 43 + x,67 + y,208,34,34 );
	gfx.PutPixel( 44 + x,67 + y,208,31,31 );
	gfx.PutPixel( 45 + x,67 + y,209,44,44 );
	gfx.PutPixel( 46 + x,67 + y,217,163,163 );
	gfx.PutPixel( 47 + x,67 + y,218,176,176 );
	gfx.PutPixel( 48 + x,67 + y,218,182,182 );
	gfx.PutPixel( 49 + x,67 + y,213,104,104 );
	gfx.PutPixel( 50 + x,67 + y,207,25,25 );
	gfx.PutPixel( 51 + x,67 + y,208,34,34 );
	gfx.PutPixel( 52 + x,67 + y,208,34,34 );
	gfx.PutPixel( 53 + x,67 + y,208,34,34 );
	gfx.PutPixel( 54 + x,67 + y,208,30,30 );
	gfx.PutPixel( 55 + x,67 + y,208,39,39 );
	gfx.PutPixel( 56 + x,67 + y,216,153,153 );
	gfx.PutPixel( 57 + x,67 + y,218,176,176 );
	gfx.PutPixel( 58 + x,67 + y,218,173,173 );
	gfx.PutPixel( 59 + x,67 + y,218,175,175 );
	gfx.PutPixel( 60 + x,67 + y,218,180,180 );
	gfx.PutPixel( 61 + x,67 + y,211,77,77 );
	gfx.PutPixel( 62 + x,67 + y,207,23,23 );
	gfx.PutPixel( 63 + x,67 + y,215,137,137 );
	gfx.PutPixel( 64 + x,67 + y,218,179,179 );
	gfx.PutPixel( 65 + x,67 + y,218,173,173 );
	gfx.PutPixel( 66 + x,67 + y,218,173,173 );
	gfx.PutPixel( 67 + x,67 + y,218,173,173 );
	gfx.PutPixel( 68 + x,67 + y,218,173,173 );
	gfx.PutPixel( 69 + x,67 + y,218,173,173 );
	gfx.PutPixel( 70 + x,67 + y,218,173,173 );
	gfx.PutPixel( 71 + x,67 + y,218,173,173 );
	gfx.PutPixel( 72 + x,67 + y,218,173,173 );
	gfx.PutPixel( 73 + x,67 + y,218,176,176 );
	gfx.PutPixel( 74 + x,67 + y,217,161,161 );
	gfx.PutPixel( 75 + x,67 + y,209,43,43 );
	gfx.PutPixel( 76 + x,67 + y,208,31,31 );
	gfx.PutPixel( 77 + x,67 + y,208,29,29 );
	gfx.PutPixel( 78 + x,67 + y,215,137,137 );
	gfx.PutPixel( 79 + x,67 + y,218,179,179 );
	gfx.PutPixel( 80 + x,67 + y,218,173,173 );
	gfx.PutPixel( 81 + x,67 + y,218,173,173 );
	gfx.PutPixel( 82 + x,67 + y,218,173,173 );
	gfx.PutPixel( 83 + x,67 + y,218,173,173 );
	gfx.PutPixel( 84 + x,67 + y,218,173,173 );
	gfx.PutPixel( 85 + x,67 + y,218,173,173 );
	gfx.PutPixel( 86 + x,67 + y,218,173,173 );
	gfx.PutPixel( 87 + x,67 + y,218,173,173 );
	gfx.PutPixel( 88 + x,67 + y,218,176,176 );
	gfx.PutPixel( 89 + x,67 + y,217,161,161 );
	gfx.PutPixel( 90 + x,67 + y,209,43,43 );
	gfx.PutPixel( 91 + x,67 + y,208,29,29 );
	gfx.PutPixel( 92 + x,67 + y,209,44,44 );
	gfx.PutPixel( 93 + x,67 + y,217,163,163 );
	gfx.PutPixel( 94 + x,67 + y,218,176,176 );
	gfx.PutPixel( 95 + x,67 + y,218,182,182 );
	gfx.PutPixel( 96 + x,67 + y,213,104,104 );
	gfx.PutPixel( 97 + x,67 + y,207,25,25 );
	gfx.PutPixel( 98 + x,67 + y,208,34,34 );
	gfx.PutPixel( 99 + x,67 + y,208,34,34 );
	gfx.PutPixel( 100 + x,67 + y,208,34,34 );
	gfx.PutPixel( 101 + x,67 + y,208,34,34 );
	gfx.PutPixel( 102 + x,67 + y,208,34,34 );
	gfx.PutPixel( 103 + x,67 + y,208,34,34 );
	gfx.PutPixel( 104 + x,67 + y,208,34,34 );
	gfx.PutPixel( 105 + x,67 + y,208,34,34 );
	gfx.PutPixel( 106 + x,67 + y,208,34,34 );
	gfx.PutPixel( 107 + x,67 + y,208,34,34 );
	gfx.PutPixel( 108 + x,67 + y,208,34,34 );
	gfx.PutPixel( 109 + x,67 + y,208,34,34 );
	gfx.PutPixel( 110 + x,67 + y,208,34,34 );
	gfx.PutPixel( 111 + x,67 + y,208,34,34 );
	gfx.PutPixel( 112 + x,67 + y,208,34,34 );
	gfx.PutPixel( 113 + x,67 + y,208,34,34 );
	gfx.PutPixel( 114 + x,67 + y,208,34,34 );
	gfx.PutPixel( 115 + x,67 + y,208,34,34 );
	gfx.PutPixel( 116 + x,67 + y,208,34,34 );
	gfx.PutPixel( 117 + x,67 + y,208,34,34 );
	gfx.PutPixel( 118 + x,67 + y,208,34,34 );
	gfx.PutPixel( 119 + x,67 + y,208,34,34 );
	gfx.PutPixel( 120 + x,67 + y,208,34,34 );
	gfx.PutPixel( 121 + x,67 + y,208,34,34 );
	gfx.PutPixel( 122 + x,67 + y,208,34,34 );
	gfx.PutPixel( 123 + x,67 + y,208,34,34 );
	gfx.PutPixel( 124 + x,67 + y,208,34,34 );
	gfx.PutPixel( 125 + x,67 + y,208,34,34 );
	gfx.PutPixel( 126 + x,67 + y,208,34,34 );
	gfx.PutPixel( 127 + x,67 + y,208,34,34 );
	gfx.PutPixel( 128 + x,67 + y,208,34,34 );
	gfx.PutPixel( 129 + x,67 + y,208,34,34 );
	gfx.PutPixel( 130 + x,67 + y,208,34,34 );
	gfx.PutPixel( 131 + x,67 + y,208,34,34 );
	gfx.PutPixel( 132 + x,67 + y,208,34,34 );
	gfx.PutPixel( 133 + x,67 + y,208,34,34 );
	gfx.PutPixel( 134 + x,67 + y,208,34,34 );
	gfx.PutPixel( 135 + x,67 + y,208,34,34 );
	gfx.PutPixel( 136 + x,67 + y,208,34,34 );
	gfx.PutPixel( 137 + x,67 + y,208,34,34 );
	gfx.PutPixel( 138 + x,67 + y,208,34,34 );
	gfx.PutPixel( 139 + x,67 + y,208,34,34 );
	gfx.PutPixel( 140 + x,67 + y,208,34,34 );
	gfx.PutPixel( 141 + x,67 + y,208,34,34 );
	gfx.PutPixel( 142 + x,67 + y,208,34,34 );
	gfx.PutPixel( 143 + x,67 + y,208,34,34 );
	gfx.PutPixel( 144 + x,67 + y,208,34,34 );
	gfx.PutPixel( 145 + x,67 + y,208,34,34 );
	gfx.PutPixel( 146 + x,67 + y,208,34,34 );
	gfx.PutPixel( 147 + x,67 + y,208,34,34 );
	gfx.PutPixel( 148 + x,67 + y,208,34,34 );
	gfx.PutPixel( 149 + x,67 + y,208,34,34 );
	gfx.PutPixel( 0 + x,68 + y,208,34,34 );
	gfx.PutPixel( 1 + x,68 + y,208,34,34 );
	gfx.PutPixel( 2 + x,68 + y,208,34,34 );
	gfx.PutPixel( 3 + x,68 + y,208,34,34 );
	gfx.PutPixel( 4 + x,68 + y,208,34,34 );
	gfx.PutPixel( 5 + x,68 + y,208,34,34 );
	gfx.PutPixel( 6 + x,68 + y,208,34,34 );
	gfx.PutPixel( 7 + x,68 + y,208,34,34 );
	gfx.PutPixel( 8 + x,68 + y,208,34,34 );
	gfx.PutPixel( 9 + x,68 + y,208,34,34 );
	gfx.PutPixel( 10 + x,68 + y,208,34,34 );
	gfx.PutPixel( 11 + x,68 + y,208,34,34 );
	gfx.PutPixel( 12 + x,68 + y,208,34,34 );
	gfx.PutPixel( 13 + x,68 + y,208,34,34 );
	gfx.PutPixel( 14 + x,68 + y,208,34,34 );
	gfx.PutPixel( 15 + x,68 + y,208,34,34 );
	gfx.PutPixel( 16 + x,68 + y,208,34,34 );
	gfx.PutPixel( 17 + x,68 + y,208,34,34 );
	gfx.PutPixel( 18 + x,68 + y,208,34,34 );
	gfx.PutPixel( 19 + x,68 + y,208,34,34 );
	gfx.PutPixel( 20 + x,68 + y,208,34,34 );
	gfx.PutPixel( 21 + x,68 + y,208,34,34 );
	gfx.PutPixel( 22 + x,68 + y,208,34,34 );
	gfx.PutPixel( 23 + x,68 + y,208,34,34 );
	gfx.PutPixel( 24 + x,68 + y,208,34,34 );
	gfx.PutPixel( 25 + x,68 + y,208,34,34 );
	gfx.PutPixel( 26 + x,68 + y,208,34,34 );
	gfx.PutPixel( 27 + x,68 + y,208,34,34 );
	gfx.PutPixel( 28 + x,68 + y,208,34,34 );
	gfx.PutPixel( 29 + x,68 + y,208,34,34 );
	gfx.PutPixel( 30 + x,68 + y,208,34,34 );
	gfx.PutPixel( 31 + x,68 + y,208,34,34 );
	gfx.PutPixel( 32 + x,68 + y,208,34,34 );
	gfx.PutPixel( 33 + x,68 + y,208,34,34 );
	gfx.PutPixel( 34 + x,68 + y,208,34,34 );
	gfx.PutPixel( 35 + x,68 + y,208,34,34 );
	gfx.PutPixel( 36 + x,68 + y,208,34,34 );
	gfx.PutPixel( 37 + x,68 + y,208,34,34 );
	gfx.PutPixel( 38 + x,68 + y,208,34,34 );
	gfx.PutPixel( 39 + x,68 + y,208,34,34 );
	gfx.PutPixel( 40 + x,68 + y,208,34,34 );
	gfx.PutPixel( 41 + x,68 + y,208,34,34 );
	gfx.PutPixel( 42 + x,68 + y,208,34,34 );
	gfx.PutPixel( 43 + x,68 + y,208,34,34 );
	gfx.PutPixel( 44 + x,68 + y,208,34,34 );
	gfx.PutPixel( 45 + x,68 + y,208,34,34 );
	gfx.PutPixel( 46 + x,68 + y,208,28,28 );
	gfx.PutPixel( 47 + x,68 + y,208,27,27 );
	gfx.PutPixel( 48 + x,68 + y,207,27,27 );
	gfx.PutPixel( 49 + x,68 + y,208,31,31 );
	gfx.PutPixel( 50 + x,68 + y,208,34,34 );
	gfx.PutPixel( 51 + x,68 + y,208,34,34 );
	gfx.PutPixel( 52 + x,68 + y,208,34,34 );
	gfx.PutPixel( 53 + x,68 + y,208,34,34 );
	gfx.PutPixel( 54 + x,68 + y,208,34,34 );
	gfx.PutPixel( 55 + x,68 + y,208,32,32 );
	gfx.PutPixel( 56 + x,68 + y,207,26,26 );
	gfx.PutPixel( 57 + x,68 + y,208,27,27 );
	gfx.PutPixel( 58 + x,68 + y,208,27,27 );
	gfx.PutPixel( 59 + x,68 + y,208,27,27 );
	gfx.PutPixel( 60 + x,68 + y,208,28,28 );
	gfx.PutPixel( 61 + x,68 + y,208,35,35 );
	gfx.PutPixel( 62 + x,68 + y,208,34,34 );
	gfx.PutPixel( 63 + x,68 + y,208,29,29 );
	gfx.PutPixel( 64 + x,68 + y,207,27,27 );
	gfx.PutPixel( 65 + x,68 + y,208,27,27 );
	gfx.PutPixel( 66 + x,68 + y,208,27,27 );
	gfx.PutPixel( 67 + x,68 + y,208,27,27 );
	gfx.PutPixel( 68 + x,68 + y,208,27,27 );
	gfx.PutPixel( 69 + x,68 + y,208,27,27 );
	gfx.PutPixel( 70 + x,68 + y,208,27,27 );
	gfx.PutPixel( 71 + x,68 + y,208,27,27 );
	gfx.PutPixel( 72 + x,68 + y,208,27,27 );
	gfx.PutPixel( 73 + x,68 + y,208,27,27 );
	gfx.PutPixel( 74 + x,68 + y,208,28,28 );
	gfx.PutPixel( 75 + x,68 + y,208,34,34 );
	gfx.PutPixel( 76 + x,68 + y,208,34,34 );
	gfx.PutPixel( 77 + x,68 + y,208,34,34 );
	gfx.PutPixel( 78 + x,68 + y,208,29,29 );
	gfx.PutPixel( 79 + x,68 + y,207,27,27 );
	gfx.PutPixel( 80 + x,68 + y,208,27,27 );
	gfx.PutPixel( 81 + x,68 + y,208,27,27 );
	gfx.PutPixel( 82 + x,68 + y,208,27,27 );
	gfx.PutPixel( 83 + x,68 + y,208,27,27 );
	gfx.PutPixel( 84 + x,68 + y,208,27,27 );
	gfx.PutPixel( 85 + x,68 + y,208,27,27 );
	gfx.PutPixel( 86 + x,68 + y,208,27,27 );
	gfx.PutPixel( 87 + x,68 + y,208,27,27 );
	gfx.PutPixel( 88 + x,68 + y,208,27,27 );
	gfx.PutPixel( 89 + x,68 + y,208,28,28 );
	gfx.PutPixel( 90 + x,68 + y,208,34,34 );
	gfx.PutPixel( 91 + x,68 + y,208,34,34 );
	gfx.PutPixel( 92 + x,68 + y,208,34,34 );
	gfx.PutPixel( 93 + x,68 + y,208,28,28 );
	gfx.PutPixel( 94 + x,68 + y,208,27,27 );
	gfx.PutPixel( 95 + x,68 + y,207,27,27 );
	gfx.PutPixel( 96 + x,68 + y,208,31,31 );
	gfx.PutPixel( 97 + x,68 + y,208,34,34 );
	gfx.PutPixel( 98 + x,68 + y,208,34,34 );
	gfx.PutPixel( 99 + x,68 + y,208,34,34 );
	gfx.PutPixel( 100 + x,68 + y,208,34,34 );
	gfx.PutPixel( 101 + x,68 + y,208,34,34 );
	gfx.PutPixel( 102 + x,68 + y,208,34,34 );
	gfx.PutPixel( 103 + x,68 + y,208,34,34 );
	gfx.PutPixel( 104 + x,68 + y,208,34,34 );
	gfx.PutPixel( 105 + x,68 + y,208,34,34 );
	gfx.PutPixel( 106 + x,68 + y,208,34,34 );
	gfx.PutPixel( 107 + x,68 + y,208,34,34 );
	gfx.PutPixel( 108 + x,68 + y,208,34,34 );
	gfx.PutPixel( 109 + x,68 + y,208,34,34 );
	gfx.PutPixel( 110 + x,68 + y,208,34,34 );
	gfx.PutPixel( 111 + x,68 + y,208,34,34 );
	gfx.PutPixel( 112 + x,68 + y,208,34,34 );
	gfx.PutPixel( 113 + x,68 + y,208,34,34 );
	gfx.PutPixel( 114 + x,68 + y,208,34,34 );
	gfx.PutPixel( 115 + x,68 + y,208,34,34 );
	gfx.PutPixel( 116 + x,68 + y,208,34,34 );
	gfx.PutPixel( 117 + x,68 + y,208,34,34 );
	gfx.PutPixel( 118 + x,68 + y,208,34,34 );
	gfx.PutPixel( 119 + x,68 + y,208,34,34 );
	gfx.PutPixel( 120 + x,68 + y,208,34,34 );
	gfx.PutPixel( 121 + x,68 + y,208,34,34 );
	gfx.PutPixel( 122 + x,68 + y,208,34,34 );
	gfx.PutPixel( 123 + x,68 + y,208,34,34 );
	gfx.PutPixel( 124 + x,68 + y,208,34,34 );
	gfx.PutPixel( 125 + x,68 + y,208,34,34 );
	gfx.PutPixel( 126 + x,68 + y,208,34,34 );
	gfx.PutPixel( 127 + x,68 + y,208,34,34 );
	gfx.PutPixel( 128 + x,68 + y,208,34,34 );
	gfx.PutPixel( 129 + x,68 + y,208,34,34 );
	gfx.PutPixel( 130 + x,68 + y,208,34,34 );
	gfx.PutPixel( 131 + x,68 + y,208,34,34 );
	gfx.PutPixel( 132 + x,68 + y,208,34,34 );
	gfx.PutPixel( 133 + x,68 + y,208,34,34 );
	gfx.PutPixel( 134 + x,68 + y,208,34,34 );
	gfx.PutPixel( 135 + x,68 + y,208,34,34 );
	gfx.PutPixel( 136 + x,68 + y,208,34,34 );
	gfx.PutPixel( 137 + x,68 + y,208,34,34 );
	gfx.PutPixel( 138 + x,68 + y,208,34,34 );
	gfx.PutPixel( 139 + x,68 + y,208,34,34 );
	gfx.PutPixel( 140 + x,68 + y,208,34,34 );
	gfx.PutPixel( 141 + x,68 + y,208,34,34 );
	gfx.PutPixel( 142 + x,68 + y,208,34,34 );
	gfx.PutPixel( 143 + x,68 + y,208,34,34 );
	gfx.PutPixel( 144 + x,68 + y,208,34,34 );
	gfx.PutPixel( 145 + x,68 + y,208,34,34 );
	gfx.PutPixel( 146 + x,68 + y,208,34,34 );
	gfx.PutPixel( 147 + x,68 + y,208,34,34 );
	gfx.PutPixel( 148 + x,68 + y,208,34,34 );
	gfx.PutPixel( 149 + x,68 + y,208,34,34 );
	gfx.PutPixel( 0 + x,69 + y,208,34,34 );
	gfx.PutPixel( 1 + x,69 + y,208,34,34 );
	gfx.PutPixel( 2 + x,69 + y,208,34,34 );
	gfx.PutPixel( 3 + x,69 + y,208,34,34 );
	gfx.PutPixel( 4 + x,69 + y,208,34,34 );
	gfx.PutPixel( 5 + x,69 + y,208,34,34 );
	gfx.PutPixel( 6 + x,69 + y,208,34,34 );
	gfx.PutPixel( 7 + x,69 + y,208,34,34 );
	gfx.PutPixel( 8 + x,69 + y,208,34,34 );
	gfx.PutPixel( 9 + x,69 + y,208,34,34 );
	gfx.PutPixel( 10 + x,69 + y,208,34,34 );
	gfx.PutPixel( 11 + x,69 + y,208,34,34 );
	gfx.PutPixel( 12 + x,69 + y,208,34,34 );
	gfx.PutPixel( 13 + x,69 + y,208,34,34 );
	gfx.PutPixel( 14 + x,69 + y,208,34,34 );
	gfx.PutPixel( 15 + x,69 + y,208,34,34 );
	gfx.PutPixel( 16 + x,69 + y,208,34,34 );
	gfx.PutPixel( 17 + x,69 + y,208,34,34 );
	gfx.PutPixel( 18 + x,69 + y,208,34,34 );
	gfx.PutPixel( 19 + x,69 + y,208,34,34 );
	gfx.PutPixel( 20 + x,69 + y,208,34,34 );
	gfx.PutPixel( 21 + x,69 + y,208,34,34 );
	gfx.PutPixel( 22 + x,69 + y,208,34,34 );
	gfx.PutPixel( 23 + x,69 + y,208,34,34 );
	gfx.PutPixel( 24 + x,69 + y,208,34,34 );
	gfx.PutPixel( 25 + x,69 + y,208,34,34 );
	gfx.PutPixel( 26 + x,69 + y,208,34,34 );
	gfx.PutPixel( 27 + x,69 + y,208,34,34 );
	gfx.PutPixel( 28 + x,69 + y,208,34,34 );
	gfx.PutPixel( 29 + x,69 + y,208,34,34 );
	gfx.PutPixel( 30 + x,69 + y,208,34,34 );
	gfx.PutPixel( 31 + x,69 + y,208,34,34 );
	gfx.PutPixel( 32 + x,69 + y,208,34,34 );
	gfx.PutPixel( 33 + x,69 + y,208,34,34 );
	gfx.PutPixel( 34 + x,69 + y,208,34,34 );
	gfx.PutPixel( 35 + x,69 + y,208,34,34 );
	gfx.PutPixel( 36 + x,69 + y,208,34,34 );
	gfx.PutPixel( 37 + x,69 + y,208,34,34 );
	gfx.PutPixel( 38 + x,69 + y,208,34,34 );
	gfx.PutPixel( 39 + x,69 + y,208,34,34 );
	gfx.PutPixel( 40 + x,69 + y,208,34,34 );
	gfx.PutPixel( 41 + x,69 + y,208,34,34 );
	gfx.PutPixel( 42 + x,69 + y,208,34,34 );
	gfx.PutPixel( 43 + x,69 + y,208,34,34 );
	gfx.PutPixel( 44 + x,69 + y,208,34,34 );
	gfx.PutPixel( 45 + x,69 + y,208,34,34 );
	gfx.PutPixel( 46 + x,69 + y,208,34,34 );
	gfx.PutPixel( 47 + x,69 + y,208,34,34 );
	gfx.PutPixel( 48 + x,69 + y,208,33,33 );
	gfx.PutPixel( 49 + x,69 + y,208,34,34 );
	gfx.PutPixel( 50 + x,69 + y,208,34,34 );
	gfx.PutPixel( 51 + x,69 + y,208,34,34 );
	gfx.PutPixel( 52 + x,69 + y,208,34,34 );
	gfx.PutPixel( 53 + x,69 + y,208,34,34 );
	gfx.PutPixel( 54 + x,69 + y,208,34,34 );
	gfx.PutPixel( 55 + x,69 + y,208,34,34 );
	gfx.PutPixel( 56 + x,69 + y,208,34,34 );
	gfx.PutPixel( 57 + x,69 + y,208,33,33 );
	gfx.PutPixel( 58 + x,69 + y,208,34,34 );
	gfx.PutPixel( 59 + x,69 + y,208,34,34 );
	gfx.PutPixel( 60 + x,69 + y,208,33,33 );
	gfx.PutPixel( 61 + x,69 + y,208,34,34 );
	gfx.PutPixel( 62 + x,69 + y,208,34,34 );
	gfx.PutPixel( 63 + x,69 + y,208,34,34 );
	gfx.PutPixel( 64 + x,69 + y,208,33,33 );
	gfx.PutPixel( 65 + x,69 + y,208,34,34 );
	gfx.PutPixel( 66 + x,69 + y,208,34,34 );
	gfx.PutPixel( 67 + x,69 + y,208,34,34 );
	gfx.PutPixel( 68 + x,69 + y,208,34,34 );
	gfx.PutPixel( 69 + x,69 + y,208,34,34 );
	gfx.PutPixel( 70 + x,69 + y,208,34,34 );
	gfx.PutPixel( 71 + x,69 + y,208,34,34 );
	gfx.PutPixel( 72 + x,69 + y,208,34,34 );
	gfx.PutPixel( 73 + x,69 + y,208,34,34 );
	gfx.PutPixel( 74 + x,69 + y,208,34,34 );
	gfx.PutPixel( 75 + x,69 + y,208,34,34 );
	gfx.PutPixel( 76 + x,69 + y,208,34,34 );
	gfx.PutPixel( 77 + x,69 + y,208,34,34 );
	gfx.PutPixel( 78 + x,69 + y,208,34,34 );
	gfx.PutPixel( 79 + x,69 + y,208,33,33 );
	gfx.PutPixel( 80 + x,69 + y,208,34,34 );
	gfx.PutPixel( 81 + x,69 + y,208,34,34 );
	gfx.PutPixel( 82 + x,69 + y,208,34,34 );
	gfx.PutPixel( 83 + x,69 + y,208,34,34 );
	gfx.PutPixel( 84 + x,69 + y,208,34,34 );
	gfx.PutPixel( 85 + x,69 + y,208,34,34 );
	gfx.PutPixel( 86 + x,69 + y,208,34,34 );
	gfx.PutPixel( 87 + x,69 + y,208,34,34 );
	gfx.PutPixel( 88 + x,69 + y,208,34,34 );
	gfx.PutPixel( 89 + x,69 + y,208,34,34 );
	gfx.PutPixel( 90 + x,69 + y,208,34,34 );
	gfx.PutPixel( 91 + x,69 + y,208,34,34 );
	gfx.PutPixel( 92 + x,69 + y,208,34,34 );
	gfx.PutPixel( 93 + x,69 + y,208,34,34 );
	gfx.PutPixel( 94 + x,69 + y,208,34,34 );
	gfx.PutPixel( 95 + x,69 + y,208,33,33 );
	gfx.PutPixel( 96 + x,69 + y,208,34,34 );
	gfx.PutPixel( 97 + x,69 + y,208,34,34 );
	gfx.PutPixel( 98 + x,69 + y,208,34,34 );
	gfx.PutPixel( 99 + x,69 + y,208,34,34 );
	gfx.PutPixel( 100 + x,69 + y,208,34,34 );
	gfx.PutPixel( 101 + x,69 + y,208,34,34 );
	gfx.PutPixel( 102 + x,69 + y,208,34,34 );
	gfx.PutPixel( 103 + x,69 + y,208,34,34 );
	gfx.PutPixel( 104 + x,69 + y,208,34,34 );
	gfx.PutPixel( 105 + x,69 + y,208,34,34 );
	gfx.PutPixel( 106 + x,69 + y,208,34,34 );
	gfx.PutPixel( 107 + x,69 + y,208,34,34 );
	gfx.PutPixel( 108 + x,69 + y,208,34,34 );
	gfx.PutPixel( 109 + x,69 + y,208,34,34 );
	gfx.PutPixel( 110 + x,69 + y,208,34,34 );
	gfx.PutPixel( 111 + x,69 + y,208,34,34 );
	gfx.PutPixel( 112 + x,69 + y,208,34,34 );
	gfx.PutPixel( 113 + x,69 + y,208,34,34 );
	gfx.PutPixel( 114 + x,69 + y,208,34,34 );
	gfx.PutPixel( 115 + x,69 + y,208,34,34 );
	gfx.PutPixel( 116 + x,69 + y,208,34,34 );
	gfx.PutPixel( 117 + x,69 + y,208,34,34 );
	gfx.PutPixel( 118 + x,69 + y,208,34,34 );
	gfx.PutPixel( 119 + x,69 + y,208,34,34 );
	gfx.PutPixel( 120 + x,69 + y,208,34,34 );
	gfx.PutPixel( 121 + x,69 + y,208,34,34 );
	gfx.PutPixel( 122 + x,69 + y,208,34,34 );
	gfx.PutPixel( 123 + x,69 + y,208,34,34 );
	gfx.PutPixel( 124 + x,69 + y,208,34,34 );
	gfx.PutPixel( 125 + x,69 + y,208,34,34 );
	gfx.PutPixel( 126 + x,69 + y,208,34,34 );
	gfx.PutPixel( 127 + x,69 + y,208,34,34 );
	gfx.PutPixel( 128 + x,69 + y,208,34,34 );
	gfx.PutPixel( 129 + x,69 + y,208,34,34 );
	gfx.PutPixel( 130 + x,69 + y,208,34,34 );
	gfx.PutPixel( 131 + x,69 + y,208,34,34 );
	gfx.PutPixel( 132 + x,69 + y,208,34,34 );
	gfx.PutPixel( 133 + x,69 + y,208,34,34 );
	gfx.PutPixel( 134 + x,69 + y,208,34,34 );
	gfx.PutPixel( 135 + x,69 + y,208,34,34 );
	gfx.PutPixel( 136 + x,69 + y,208,34,34 );
	gfx.PutPixel( 137 + x,69 + y,208,34,34 );
	gfx.PutPixel( 138 + x,69 + y,208,34,34 );
	gfx.PutPixel( 139 + x,69 + y,208,34,34 );
	gfx.PutPixel( 140 + x,69 + y,208,34,34 );
	gfx.PutPixel( 141 + x,69 + y,208,34,34 );
	gfx.PutPixel( 142 + x,69 + y,208,34,34 );
	gfx.PutPixel( 143 + x,69 + y,208,34,34 );
	gfx.PutPixel( 144 + x,69 + y,208,34,34 );
	gfx.PutPixel( 145 + x,69 + y,208,34,34 );
	gfx.PutPixel( 146 + x,69 + y,208,34,34 );
	gfx.PutPixel( 147 + x,69 + y,208,34,34 );
	gfx.PutPixel( 148 + x,69 + y,208,34,34 );
	gfx.PutPixel( 149 + x,69 + y,208,34,34 );
	gfx.PutPixel( 0 + x,70 + y,208,34,34 );
	gfx.PutPixel( 1 + x,70 + y,208,34,34 );
	gfx.PutPixel( 2 + x,70 + y,208,34,34 );
	gfx.PutPixel( 3 + x,70 + y,208,34,34 );
	gfx.PutPixel( 4 + x,70 + y,208,34,34 );
	gfx.PutPixel( 5 + x,70 + y,208,34,34 );
	gfx.PutPixel( 6 + x,70 + y,208,34,34 );
	gfx.PutPixel( 7 + x,70 + y,208,34,34 );
	gfx.PutPixel( 8 + x,70 + y,208,34,34 );
	gfx.PutPixel( 9 + x,70 + y,208,34,34 );
	gfx.PutPixel( 10 + x,70 + y,208,34,34 );
	gfx.PutPixel( 11 + x,70 + y,208,34,34 );
	gfx.PutPixel( 12 + x,70 + y,208,34,34 );
	gfx.PutPixel( 13 + x,70 + y,208,34,34 );
	gfx.PutPixel( 14 + x,70 + y,208,34,34 );
	gfx.PutPixel( 15 + x,70 + y,208,34,34 );
	gfx.PutPixel( 16 + x,70 + y,208,34,34 );
	gfx.PutPixel( 17 + x,70 + y,208,34,34 );
	gfx.PutPixel( 18 + x,70 + y,208,34,34 );
	gfx.PutPixel( 19 + x,70 + y,208,34,34 );
	gfx.PutPixel( 20 + x,70 + y,208,34,34 );
	gfx.PutPixel( 21 + x,70 + y,208,34,34 );
	gfx.PutPixel( 22 + x,70 + y,208,34,34 );
	gfx.PutPixel( 23 + x,70 + y,208,34,34 );
	gfx.PutPixel( 24 + x,70 + y,208,34,34 );
	gfx.PutPixel( 25 + x,70 + y,208,34,34 );
	gfx.PutPixel( 26 + x,70 + y,208,34,34 );
	gfx.PutPixel( 27 + x,70 + y,208,34,34 );
	gfx.PutPixel( 28 + x,70 + y,208,34,34 );
	gfx.PutPixel( 29 + x,70 + y,208,34,34 );
	gfx.PutPixel( 30 + x,70 + y,208,34,34 );
	gfx.PutPixel( 31 + x,70 + y,208,34,34 );
	gfx.PutPixel( 32 + x,70 + y,208,34,34 );
	gfx.PutPixel( 33 + x,70 + y,208,34,34 );
	gfx.PutPixel( 34 + x,70 + y,208,34,34 );
	gfx.PutPixel( 35 + x,70 + y,208,34,34 );
	gfx.PutPixel( 36 + x,70 + y,208,34,34 );
	gfx.PutPixel( 37 + x,70 + y,208,34,34 );
	gfx.PutPixel( 38 + x,70 + y,208,34,34 );
	gfx.PutPixel( 39 + x,70 + y,208,34,34 );
	gfx.PutPixel( 40 + x,70 + y,208,34,34 );
	gfx.PutPixel( 41 + x,70 + y,208,34,34 );
	gfx.PutPixel( 42 + x,70 + y,208,34,34 );
	gfx.PutPixel( 43 + x,70 + y,208,34,34 );
	gfx.PutPixel( 44 + x,70 + y,208,34,34 );
	gfx.PutPixel( 45 + x,70 + y,208,34,34 );
	gfx.PutPixel( 46 + x,70 + y,208,34,34 );
	gfx.PutPixel( 47 + x,70 + y,208,34,34 );
	gfx.PutPixel( 48 + x,70 + y,208,34,34 );
	gfx.PutPixel( 49 + x,70 + y,208,34,34 );
	gfx.PutPixel( 50 + x,70 + y,208,34,34 );
	gfx.PutPixel( 51 + x,70 + y,208,34,34 );
	gfx.PutPixel( 52 + x,70 + y,208,34,34 );
	gfx.PutPixel( 53 + x,70 + y,208,34,34 );
	gfx.PutPixel( 54 + x,70 + y,208,34,34 );
	gfx.PutPixel( 55 + x,70 + y,208,34,34 );
	gfx.PutPixel( 56 + x,70 + y,208,34,34 );
	gfx.PutPixel( 57 + x,70 + y,208,34,34 );
	gfx.PutPixel( 58 + x,70 + y,208,34,34 );
	gfx.PutPixel( 59 + x,70 + y,208,34,34 );
	gfx.PutPixel( 60 + x,70 + y,208,34,34 );
	gfx.PutPixel( 61 + x,70 + y,208,34,34 );
	gfx.PutPixel( 62 + x,70 + y,208,34,34 );
	gfx.PutPixel( 63 + x,70 + y,208,34,34 );
	gfx.PutPixel( 64 + x,70 + y,208,34,34 );
	gfx.PutPixel( 65 + x,70 + y,208,34,34 );
	gfx.PutPixel( 66 + x,70 + y,208,34,34 );
	gfx.PutPixel( 67 + x,70 + y,208,34,34 );
	gfx.PutPixel( 68 + x,70 + y,208,34,34 );
	gfx.PutPixel( 69 + x,70 + y,208,34,34 );
	gfx.PutPixel( 70 + x,70 + y,208,34,34 );
	gfx.PutPixel( 71 + x,70 + y,208,34,34 );
	gfx.PutPixel( 72 + x,70 + y,208,34,34 );
	gfx.PutPixel( 73 + x,70 + y,208,34,34 );
	gfx.PutPixel( 74 + x,70 + y,208,34,34 );
	gfx.PutPixel( 75 + x,70 + y,208,34,34 );
	gfx.PutPixel( 76 + x,70 + y,208,34,34 );
	gfx.PutPixel( 77 + x,70 + y,208,34,34 );
	gfx.PutPixel( 78 + x,70 + y,208,34,34 );
	gfx.PutPixel( 79 + x,70 + y,208,34,34 );
	gfx.PutPixel( 80 + x,70 + y,208,34,34 );
	gfx.PutPixel( 81 + x,70 + y,208,34,34 );
	gfx.PutPixel( 82 + x,70 + y,208,34,34 );
	gfx.PutPixel( 83 + x,70 + y,208,34,34 );
	gfx.PutPixel( 84 + x,70 + y,208,34,34 );
	gfx.PutPixel( 85 + x,70 + y,208,34,34 );
	gfx.PutPixel( 86 + x,70 + y,208,34,34 );
	gfx.PutPixel( 87 + x,70 + y,208,34,34 );
	gfx.PutPixel( 88 + x,70 + y,208,34,34 );
	gfx.PutPixel( 89 + x,70 + y,208,34,34 );
	gfx.PutPixel( 90 + x,70 + y,208,34,34 );
	gfx.PutPixel( 91 + x,70 + y,208,34,34 );
	gfx.PutPixel( 92 + x,70 + y,208,34,34 );
	gfx.PutPixel( 93 + x,70 + y,208,34,34 );
	gfx.PutPixel( 94 + x,70 + y,208,34,34 );
	gfx.PutPixel( 95 + x,70 + y,208,34,34 );
	gfx.PutPixel( 96 + x,70 + y,208,34,34 );
	gfx.PutPixel( 97 + x,70 + y,208,34,34 );
	gfx.PutPixel( 98 + x,70 + y,208,34,34 );
	gfx.PutPixel( 99 + x,70 + y,208,34,34 );
	gfx.PutPixel( 100 + x,70 + y,208,34,34 );
	gfx.PutPixel( 101 + x,70 + y,208,34,34 );
	gfx.PutPixel( 102 + x,70 + y,208,34,34 );
	gfx.PutPixel( 103 + x,70 + y,208,34,34 );
	gfx.PutPixel( 104 + x,70 + y,208,34,34 );
	gfx.PutPixel( 105 + x,70 + y,208,34,34 );
	gfx.PutPixel( 106 + x,70 + y,208,34,34 );
	gfx.PutPixel( 107 + x,70 + y,208,34,34 );
	gfx.PutPixel( 108 + x,70 + y,208,34,34 );
	gfx.PutPixel( 109 + x,70 + y,208,34,34 );
	gfx.PutPixel( 110 + x,70 + y,208,34,34 );
	gfx.PutPixel( 111 + x,70 + y,208,34,34 );
	gfx.PutPixel( 112 + x,70 + y,208,34,34 );
	gfx.PutPixel( 113 + x,70 + y,208,34,34 );
	gfx.PutPixel( 114 + x,70 + y,208,34,34 );
	gfx.PutPixel( 115 + x,70 + y,208,34,34 );
	gfx.PutPixel( 116 + x,70 + y,208,34,34 );
	gfx.PutPixel( 117 + x,70 + y,208,34,34 );
	gfx.PutPixel( 118 + x,70 + y,208,34,34 );
	gfx.PutPixel( 119 + x,70 + y,208,34,34 );
	gfx.PutPixel( 120 + x,70 + y,208,34,34 );
	gfx.PutPixel( 121 + x,70 + y,208,34,34 );
	gfx.PutPixel( 122 + x,70 + y,208,34,34 );
	gfx.PutPixel( 123 + x,70 + y,208,34,34 );
	gfx.PutPixel( 124 + x,70 + y,208,34,34 );
	gfx.PutPixel( 125 + x,70 + y,208,34,34 );
	gfx.PutPixel( 126 + x,70 + y,208,34,34 );
	gfx.PutPixel( 127 + x,70 + y,208,34,34 );
	gfx.PutPixel( 128 + x,70 + y,208,34,34 );
	gfx.PutPixel( 129 + x,70 + y,208,34,34 );
	gfx.PutPixel( 130 + x,70 + y,208,34,34 );
	gfx.PutPixel( 131 + x,70 + y,208,34,34 );
	gfx.PutPixel( 132 + x,70 + y,208,34,34 );
	gfx.PutPixel( 133 + x,70 + y,208,34,34 );
	gfx.PutPixel( 134 + x,70 + y,208,34,34 );
	gfx.PutPixel( 135 + x,70 + y,208,34,34 );
	gfx.PutPixel( 136 + x,70 + y,208,34,34 );
	gfx.PutPixel( 137 + x,70 + y,208,34,34 );
	gfx.PutPixel( 138 + x,70 + y,208,34,34 );
	gfx.PutPixel( 139 + x,70 + y,208,34,34 );
	gfx.PutPixel( 140 + x,70 + y,208,34,34 );
	gfx.PutPixel( 141 + x,70 + y,208,34,34 );
	gfx.PutPixel( 142 + x,70 + y,208,34,34 );
	gfx.PutPixel( 143 + x,70 + y,208,34,34 );
	gfx.PutPixel( 144 + x,70 + y,208,34,34 );
	gfx.PutPixel( 145 + x,70 + y,208,34,34 );
	gfx.PutPixel( 146 + x,70 + y,208,34,34 );
	gfx.PutPixel( 147 + x,70 + y,208,34,34 );
	gfx.PutPixel( 148 + x,70 + y,208,34,34 );
	gfx.PutPixel( 149 + x,70 + y,208,34,34 );
	gfx.PutPixel( 0 + x,71 + y,208,34,34 );
	gfx.PutPixel( 1 + x,71 + y,208,34,34 );
	gfx.PutPixel( 2 + x,71 + y,208,34,34 );
	gfx.PutPixel( 3 + x,71 + y,208,34,34 );
	gfx.PutPixel( 4 + x,71 + y,208,34,34 );
	gfx.PutPixel( 5 + x,71 + y,208,34,34 );
	gfx.PutPixel( 6 + x,71 + y,208,34,34 );
	gfx.PutPixel( 7 + x,71 + y,208,34,34 );
	gfx.PutPixel( 8 + x,71 + y,208,34,34 );
	gfx.PutPixel( 9 + x,71 + y,208,34,34 );
	gfx.PutPixel( 10 + x,71 + y,208,34,34 );
	gfx.PutPixel( 11 + x,71 + y,208,34,34 );
	gfx.PutPixel( 12 + x,71 + y,208,34,34 );
	gfx.PutPixel( 13 + x,71 + y,208,34,34 );
	gfx.PutPixel( 14 + x,71 + y,208,34,34 );
	gfx.PutPixel( 15 + x,71 + y,208,34,34 );
	gfx.PutPixel( 16 + x,71 + y,208,34,34 );
	gfx.PutPixel( 17 + x,71 + y,208,34,34 );
	gfx.PutPixel( 18 + x,71 + y,208,34,34 );
	gfx.PutPixel( 19 + x,71 + y,208,34,34 );
	gfx.PutPixel( 20 + x,71 + y,208,34,34 );
	gfx.PutPixel( 21 + x,71 + y,208,34,34 );
	gfx.PutPixel( 22 + x,71 + y,208,34,34 );
	gfx.PutPixel( 23 + x,71 + y,208,34,34 );
	gfx.PutPixel( 24 + x,71 + y,208,34,34 );
	gfx.PutPixel( 25 + x,71 + y,208,34,34 );
	gfx.PutPixel( 26 + x,71 + y,208,34,34 );
	gfx.PutPixel( 27 + x,71 + y,208,34,34 );
	gfx.PutPixel( 28 + x,71 + y,208,34,34 );
	gfx.PutPixel( 29 + x,71 + y,208,34,34 );
	gfx.PutPixel( 30 + x,71 + y,208,34,34 );
	gfx.PutPixel( 31 + x,71 + y,208,34,34 );
	gfx.PutPixel( 32 + x,71 + y,208,34,34 );
	gfx.PutPixel( 33 + x,71 + y,208,34,34 );
	gfx.PutPixel( 34 + x,71 + y,208,34,34 );
	gfx.PutPixel( 35 + x,71 + y,208,34,34 );
	gfx.PutPixel( 36 + x,71 + y,208,34,34 );
	gfx.PutPixel( 37 + x,71 + y,208,34,34 );
	gfx.PutPixel( 38 + x,71 + y,208,34,34 );
	gfx.PutPixel( 39 + x,71 + y,208,34,34 );
	gfx.PutPixel( 40 + x,71 + y,208,34,34 );
	gfx.PutPixel( 41 + x,71 + y,208,34,34 );
	gfx.PutPixel( 42 + x,71 + y,208,34,34 );
	gfx.PutPixel( 43 + x,71 + y,208,34,34 );
	gfx.PutPixel( 44 + x,71 + y,208,34,34 );
	gfx.PutPixel( 45 + x,71 + y,208,34,34 );
	gfx.PutPixel( 46 + x,71 + y,208,34,34 );
	gfx.PutPixel( 47 + x,71 + y,208,34,34 );
	gfx.PutPixel( 48 + x,71 + y,208,34,34 );
	gfx.PutPixel( 49 + x,71 + y,208,34,34 );
	gfx.PutPixel( 50 + x,71 + y,208,34,34 );
	gfx.PutPixel( 51 + x,71 + y,208,34,34 );
	gfx.PutPixel( 52 + x,71 + y,208,34,34 );
	gfx.PutPixel( 53 + x,71 + y,208,34,34 );
	gfx.PutPixel( 54 + x,71 + y,208,34,34 );
	gfx.PutPixel( 55 + x,71 + y,208,34,34 );
	gfx.PutPixel( 56 + x,71 + y,208,34,34 );
	gfx.PutPixel( 57 + x,71 + y,208,34,34 );
	gfx.PutPixel( 58 + x,71 + y,208,34,34 );
	gfx.PutPixel( 59 + x,71 + y,208,34,34 );
	gfx.PutPixel( 60 + x,71 + y,208,34,34 );
	gfx.PutPixel( 61 + x,71 + y,208,34,34 );
	gfx.PutPixel( 62 + x,71 + y,208,34,34 );
	gfx.PutPixel( 63 + x,71 + y,208,34,34 );
	gfx.PutPixel( 64 + x,71 + y,208,34,34 );
	gfx.PutPixel( 65 + x,71 + y,208,34,34 );
	gfx.PutPixel( 66 + x,71 + y,208,34,34 );
	gfx.PutPixel( 67 + x,71 + y,208,34,34 );
	gfx.PutPixel( 68 + x,71 + y,208,34,34 );
	gfx.PutPixel( 69 + x,71 + y,208,34,34 );
	gfx.PutPixel( 70 + x,71 + y,208,34,34 );
	gfx.PutPixel( 71 + x,71 + y,208,34,34 );
	gfx.PutPixel( 72 + x,71 + y,208,34,34 );
	gfx.PutPixel( 73 + x,71 + y,208,34,34 );
	gfx.PutPixel( 74 + x,71 + y,208,34,34 );
	gfx.PutPixel( 75 + x,71 + y,208,34,34 );
	gfx.PutPixel( 76 + x,71 + y,208,34,34 );
	gfx.PutPixel( 77 + x,71 + y,208,34,34 );
	gfx.PutPixel( 78 + x,71 + y,208,34,34 );
	gfx.PutPixel( 79 + x,71 + y,208,34,34 );
	gfx.PutPixel( 80 + x,71 + y,208,34,34 );
	gfx.PutPixel( 81 + x,71 + y,208,34,34 );
	gfx.PutPixel( 82 + x,71 + y,208,34,34 );
	gfx.PutPixel( 83 + x,71 + y,208,34,34 );
	gfx.PutPixel( 84 + x,71 + y,208,34,34 );
	gfx.PutPixel( 85 + x,71 + y,208,34,34 );
	gfx.PutPixel( 86 + x,71 + y,208,34,34 );
	gfx.PutPixel( 87 + x,71 + y,208,34,34 );
	gfx.PutPixel( 88 + x,71 + y,208,34,34 );
	gfx.PutPixel( 89 + x,71 + y,208,34,34 );
	gfx.PutPixel( 90 + x,71 + y,208,34,34 );
	gfx.PutPixel( 91 + x,71 + y,208,34,34 );
	gfx.PutPixel( 92 + x,71 + y,208,34,34 );
	gfx.PutPixel( 93 + x,71 + y,208,34,34 );
	gfx.PutPixel( 94 + x,71 + y,208,34,34 );
	gfx.PutPixel( 95 + x,71 + y,208,34,34 );
	gfx.PutPixel( 96 + x,71 + y,208,34,34 );
	gfx.PutPixel( 97 + x,71 + y,208,34,34 );
	gfx.PutPixel( 98 + x,71 + y,208,34,34 );
	gfx.PutPixel( 99 + x,71 + y,208,34,34 );
	gfx.PutPixel( 100 + x,71 + y,208,34,34 );
	gfx.PutPixel( 101 + x,71 + y,208,34,34 );
	gfx.PutPixel( 102 + x,71 + y,208,34,34 );
	gfx.PutPixel( 103 + x,71 + y,208,34,34 );
	gfx.PutPixel( 104 + x,71 + y,208,34,34 );
	gfx.PutPixel( 105 + x,71 + y,208,34,34 );
	gfx.PutPixel( 106 + x,71 + y,208,34,34 );
	gfx.PutPixel( 107 + x,71 + y,208,34,34 );
	gfx.PutPixel( 108 + x,71 + y,208,34,34 );
	gfx.PutPixel( 109 + x,71 + y,208,34,34 );
	gfx.PutPixel( 110 + x,71 + y,208,34,34 );
	gfx.PutPixel( 111 + x,71 + y,208,34,34 );
	gfx.PutPixel( 112 + x,71 + y,208,34,34 );
	gfx.PutPixel( 113 + x,71 + y,208,34,34 );
	gfx.PutPixel( 114 + x,71 + y,208,34,34 );
	gfx.PutPixel( 115 + x,71 + y,208,34,34 );
	gfx.PutPixel( 116 + x,71 + y,208,34,34 );
	gfx.PutPixel( 117 + x,71 + y,208,34,34 );
	gfx.PutPixel( 118 + x,71 + y,208,34,34 );
	gfx.PutPixel( 119 + x,71 + y,208,34,34 );
	gfx.PutPixel( 120 + x,71 + y,208,34,34 );
	gfx.PutPixel( 121 + x,71 + y,208,34,34 );
	gfx.PutPixel( 122 + x,71 + y,208,34,34 );
	gfx.PutPixel( 123 + x,71 + y,208,34,34 );
	gfx.PutPixel( 124 + x,71 + y,208,34,34 );
	gfx.PutPixel( 125 + x,71 + y,208,34,34 );
	gfx.PutPixel( 126 + x,71 + y,208,34,34 );
	gfx.PutPixel( 127 + x,71 + y,208,34,34 );
	gfx.PutPixel( 128 + x,71 + y,208,34,34 );
	gfx.PutPixel( 129 + x,71 + y,208,34,34 );
	gfx.PutPixel( 130 + x,71 + y,208,34,34 );
	gfx.PutPixel( 131 + x,71 + y,208,34,34 );
	gfx.PutPixel( 132 + x,71 + y,208,34,34 );
	gfx.PutPixel( 133 + x,71 + y,208,34,34 );
	gfx.PutPixel( 134 + x,71 + y,208,34,34 );
	gfx.PutPixel( 135 + x,71 + y,208,34,34 );
	gfx.PutPixel( 136 + x,71 + y,208,34,34 );
	gfx.PutPixel( 137 + x,71 + y,208,34,34 );
	gfx.PutPixel( 138 + x,71 + y,208,34,34 );
	gfx.PutPixel( 139 + x,71 + y,208,34,34 );
	gfx.PutPixel( 140 + x,71 + y,208,34,34 );
	gfx.PutPixel( 141 + x,71 + y,208,34,34 );
	gfx.PutPixel( 142 + x,71 + y,208,34,34 );
	gfx.PutPixel( 143 + x,71 + y,208,34,34 );
	gfx.PutPixel( 144 + x,71 + y,208,34,34 );
	gfx.PutPixel( 145 + x,71 + y,208,34,34 );
	gfx.PutPixel( 146 + x,71 + y,208,34,34 );
	gfx.PutPixel( 147 + x,71 + y,208,34,34 );
	gfx.PutPixel( 148 + x,71 + y,208,34,34 );
	gfx.PutPixel( 149 + x,71 + y,208,34,34 );
	gfx.PutPixel( 0 + x,72 + y,208,34,34 );
	gfx.PutPixel( 1 + x,72 + y,208,34,34 );
	gfx.PutPixel( 2 + x,72 + y,208,34,34 );
	gfx.PutPixel( 3 + x,72 + y,208,34,34 );
	gfx.PutPixel( 4 + x,72 + y,208,34,34 );
	gfx.PutPixel( 5 + x,72 + y,208,34,34 );
	gfx.PutPixel( 6 + x,72 + y,208,34,34 );
	gfx.PutPixel( 7 + x,72 + y,208,34,34 );
	gfx.PutPixel( 8 + x,72 + y,208,34,34 );
	gfx.PutPixel( 9 + x,72 + y,208,34,34 );
	gfx.PutPixel( 10 + x,72 + y,208,34,34 );
	gfx.PutPixel( 11 + x,72 + y,208,34,34 );
	gfx.PutPixel( 12 + x,72 + y,208,34,34 );
	gfx.PutPixel( 13 + x,72 + y,208,34,34 );
	gfx.PutPixel( 14 + x,72 + y,208,34,34 );
	gfx.PutPixel( 15 + x,72 + y,208,34,34 );
	gfx.PutPixel( 16 + x,72 + y,208,34,34 );
	gfx.PutPixel( 17 + x,72 + y,208,34,34 );
	gfx.PutPixel( 18 + x,72 + y,208,34,34 );
	gfx.PutPixel( 19 + x,72 + y,208,34,34 );
	gfx.PutPixel( 20 + x,72 + y,208,34,34 );
	gfx.PutPixel( 21 + x,72 + y,208,34,34 );
	gfx.PutPixel( 22 + x,72 + y,208,34,34 );
	gfx.PutPixel( 23 + x,72 + y,208,34,34 );
	gfx.PutPixel( 24 + x,72 + y,208,34,34 );
	gfx.PutPixel( 25 + x,72 + y,208,34,34 );
	gfx.PutPixel( 26 + x,72 + y,208,34,34 );
	gfx.PutPixel( 27 + x,72 + y,208,34,34 );
	gfx.PutPixel( 28 + x,72 + y,208,34,34 );
	gfx.PutPixel( 29 + x,72 + y,208,34,34 );
	gfx.PutPixel( 30 + x,72 + y,208,34,34 );
	gfx.PutPixel( 31 + x,72 + y,208,34,34 );
	gfx.PutPixel( 32 + x,72 + y,208,34,34 );
	gfx.PutPixel( 33 + x,72 + y,208,34,34 );
	gfx.PutPixel( 34 + x,72 + y,208,34,34 );
	gfx.PutPixel( 35 + x,72 + y,208,34,34 );
	gfx.PutPixel( 36 + x,72 + y,208,34,34 );
	gfx.PutPixel( 37 + x,72 + y,208,34,34 );
	gfx.PutPixel( 38 + x,72 + y,208,34,34 );
	gfx.PutPixel( 39 + x,72 + y,208,34,34 );
	gfx.PutPixel( 40 + x,72 + y,208,34,34 );
	gfx.PutPixel( 41 + x,72 + y,208,34,34 );
	gfx.PutPixel( 42 + x,72 + y,208,34,34 );
	gfx.PutPixel( 43 + x,72 + y,208,34,34 );
	gfx.PutPixel( 44 + x,72 + y,208,34,34 );
	gfx.PutPixel( 45 + x,72 + y,208,34,34 );
	gfx.PutPixel( 46 + x,72 + y,208,34,34 );
	gfx.PutPixel( 47 + x,72 + y,208,34,34 );
	gfx.PutPixel( 48 + x,72 + y,208,34,34 );
	gfx.PutPixel( 49 + x,72 + y,208,34,34 );
	gfx.PutPixel( 50 + x,72 + y,208,34,34 );
	gfx.PutPixel( 51 + x,72 + y,208,34,34 );
	gfx.PutPixel( 52 + x,72 + y,208,34,34 );
	gfx.PutPixel( 53 + x,72 + y,208,34,34 );
	gfx.PutPixel( 54 + x,72 + y,208,34,34 );
	gfx.PutPixel( 55 + x,72 + y,208,34,34 );
	gfx.PutPixel( 56 + x,72 + y,208,34,34 );
	gfx.PutPixel( 57 + x,72 + y,208,34,34 );
	gfx.PutPixel( 58 + x,72 + y,208,34,34 );
	gfx.PutPixel( 59 + x,72 + y,208,34,34 );
	gfx.PutPixel( 60 + x,72 + y,208,34,34 );
	gfx.PutPixel( 61 + x,72 + y,208,34,34 );
	gfx.PutPixel( 62 + x,72 + y,208,34,34 );
	gfx.PutPixel( 63 + x,72 + y,208,34,34 );
	gfx.PutPixel( 64 + x,72 + y,208,34,34 );
	gfx.PutPixel( 65 + x,72 + y,208,34,34 );
	gfx.PutPixel( 66 + x,72 + y,208,34,34 );
	gfx.PutPixel( 67 + x,72 + y,208,34,34 );
	gfx.PutPixel( 68 + x,72 + y,208,34,34 );
	gfx.PutPixel( 69 + x,72 + y,208,34,34 );
	gfx.PutPixel( 70 + x,72 + y,208,34,34 );
	gfx.PutPixel( 71 + x,72 + y,208,34,34 );
	gfx.PutPixel( 72 + x,72 + y,208,34,34 );
	gfx.PutPixel( 73 + x,72 + y,208,34,34 );
	gfx.PutPixel( 74 + x,72 + y,208,34,34 );
	gfx.PutPixel( 75 + x,72 + y,208,34,34 );
	gfx.PutPixel( 76 + x,72 + y,208,34,34 );
	gfx.PutPixel( 77 + x,72 + y,208,34,34 );
	gfx.PutPixel( 78 + x,72 + y,208,34,34 );
	gfx.PutPixel( 79 + x,72 + y,208,34,34 );
	gfx.PutPixel( 80 + x,72 + y,208,34,34 );
	gfx.PutPixel( 81 + x,72 + y,208,34,34 );
	gfx.PutPixel( 82 + x,72 + y,208,34,34 );
	gfx.PutPixel( 83 + x,72 + y,208,34,34 );
	gfx.PutPixel( 84 + x,72 + y,208,34,34 );
	gfx.PutPixel( 85 + x,72 + y,208,34,34 );
	gfx.PutPixel( 86 + x,72 + y,208,34,34 );
	gfx.PutPixel( 87 + x,72 + y,208,34,34 );
	gfx.PutPixel( 88 + x,72 + y,208,34,34 );
	gfx.PutPixel( 89 + x,72 + y,208,34,34 );
	gfx.PutPixel( 90 + x,72 + y,208,34,34 );
	gfx.PutPixel( 91 + x,72 + y,208,34,34 );
	gfx.PutPixel( 92 + x,72 + y,208,34,34 );
	gfx.PutPixel( 93 + x,72 + y,208,34,34 );
	gfx.PutPixel( 94 + x,72 + y,208,34,34 );
	gfx.PutPixel( 95 + x,72 + y,208,34,34 );
	gfx.PutPixel( 96 + x,72 + y,208,34,34 );
	gfx.PutPixel( 97 + x,72 + y,208,34,34 );
	gfx.PutPixel( 98 + x,72 + y,208,34,34 );
	gfx.PutPixel( 99 + x,72 + y,208,34,34 );
	gfx.PutPixel( 100 + x,72 + y,208,34,34 );
	gfx.PutPixel( 101 + x,72 + y,208,34,34 );
	gfx.PutPixel( 102 + x,72 + y,208,34,34 );
	gfx.PutPixel( 103 + x,72 + y,208,34,34 );
	gfx.PutPixel( 104 + x,72 + y,208,34,34 );
	gfx.PutPixel( 105 + x,72 + y,208,34,34 );
	gfx.PutPixel( 106 + x,72 + y,208,34,34 );
	gfx.PutPixel( 107 + x,72 + y,208,34,34 );
	gfx.PutPixel( 108 + x,72 + y,208,34,34 );
	gfx.PutPixel( 109 + x,72 + y,208,34,34 );
	gfx.PutPixel( 110 + x,72 + y,208,34,34 );
	gfx.PutPixel( 111 + x,72 + y,208,34,34 );
	gfx.PutPixel( 112 + x,72 + y,208,34,34 );
	gfx.PutPixel( 113 + x,72 + y,208,34,34 );
	gfx.PutPixel( 114 + x,72 + y,208,34,34 );
	gfx.PutPixel( 115 + x,72 + y,208,34,34 );
	gfx.PutPixel( 116 + x,72 + y,208,34,34 );
	gfx.PutPixel( 117 + x,72 + y,208,34,34 );
	gfx.PutPixel( 118 + x,72 + y,208,34,34 );
	gfx.PutPixel( 119 + x,72 + y,208,34,34 );
	gfx.PutPixel( 120 + x,72 + y,208,34,34 );
	gfx.PutPixel( 121 + x,72 + y,208,34,34 );
	gfx.PutPixel( 122 + x,72 + y,208,34,34 );
	gfx.PutPixel( 123 + x,72 + y,208,34,34 );
	gfx.PutPixel( 124 + x,72 + y,208,34,34 );
	gfx.PutPixel( 125 + x,72 + y,208,34,34 );
	gfx.PutPixel( 126 + x,72 + y,208,34,34 );
	gfx.PutPixel( 127 + x,72 + y,208,34,34 );
	gfx.PutPixel( 128 + x,72 + y,208,34,34 );
	gfx.PutPixel( 129 + x,72 + y,208,34,34 );
	gfx.PutPixel( 130 + x,72 + y,208,34,34 );
	gfx.PutPixel( 131 + x,72 + y,208,34,34 );
	gfx.PutPixel( 132 + x,72 + y,208,34,34 );
	gfx.PutPixel( 133 + x,72 + y,208,34,34 );
	gfx.PutPixel( 134 + x,72 + y,208,34,34 );
	gfx.PutPixel( 135 + x,72 + y,208,34,34 );
	gfx.PutPixel( 136 + x,72 + y,208,34,34 );
	gfx.PutPixel( 137 + x,72 + y,208,34,34 );
	gfx.PutPixel( 138 + x,72 + y,208,34,34 );
	gfx.PutPixel( 139 + x,72 + y,208,34,34 );
	gfx.PutPixel( 140 + x,72 + y,208,34,34 );
	gfx.PutPixel( 141 + x,72 + y,208,34,34 );
	gfx.PutPixel( 142 + x,72 + y,208,34,34 );
	gfx.PutPixel( 143 + x,72 + y,208,34,34 );
	gfx.PutPixel( 144 + x,72 + y,208,34,34 );
	gfx.PutPixel( 145 + x,72 + y,208,34,34 );
	gfx.PutPixel( 146 + x,72 + y,208,34,34 );
	gfx.PutPixel( 147 + x,72 + y,208,34,34 );
	gfx.PutPixel( 148 + x,72 + y,208,34,34 );
	gfx.PutPixel( 149 + x,72 + y,208,34,34 );
	gfx.PutPixel( 0 + x,73 + y,208,34,34 );
	gfx.PutPixel( 1 + x,73 + y,208,34,34 );
	gfx.PutPixel( 2 + x,73 + y,208,34,34 );
	gfx.PutPixel( 3 + x,73 + y,208,34,34 );
	gfx.PutPixel( 4 + x,73 + y,208,34,34 );
	gfx.PutPixel( 5 + x,73 + y,208,34,34 );
	gfx.PutPixel( 6 + x,73 + y,208,34,34 );
	gfx.PutPixel( 7 + x,73 + y,208,34,34 );
	gfx.PutPixel( 8 + x,73 + y,208,34,34 );
	gfx.PutPixel( 9 + x,73 + y,208,34,34 );
	gfx.PutPixel( 10 + x,73 + y,208,34,34 );
	gfx.PutPixel( 11 + x,73 + y,208,34,34 );
	gfx.PutPixel( 12 + x,73 + y,208,34,34 );
	gfx.PutPixel( 13 + x,73 + y,208,34,34 );
	gfx.PutPixel( 14 + x,73 + y,208,34,34 );
	gfx.PutPixel( 15 + x,73 + y,208,34,34 );
	gfx.PutPixel( 16 + x,73 + y,208,34,34 );
	gfx.PutPixel( 17 + x,73 + y,208,34,34 );
	gfx.PutPixel( 18 + x,73 + y,208,34,34 );
	gfx.PutPixel( 19 + x,73 + y,208,34,34 );
	gfx.PutPixel( 20 + x,73 + y,208,34,34 );
	gfx.PutPixel( 21 + x,73 + y,208,34,34 );
	gfx.PutPixel( 22 + x,73 + y,208,34,34 );
	gfx.PutPixel( 23 + x,73 + y,208,34,34 );
	gfx.PutPixel( 24 + x,73 + y,208,34,34 );
	gfx.PutPixel( 25 + x,73 + y,208,34,34 );
	gfx.PutPixel( 26 + x,73 + y,208,34,34 );
	gfx.PutPixel( 27 + x,73 + y,208,34,34 );
	gfx.PutPixel( 28 + x,73 + y,208,34,34 );
	gfx.PutPixel( 29 + x,73 + y,208,34,34 );
	gfx.PutPixel( 30 + x,73 + y,208,34,34 );
	gfx.PutPixel( 31 + x,73 + y,208,34,34 );
	gfx.PutPixel( 32 + x,73 + y,208,34,34 );
	gfx.PutPixel( 33 + x,73 + y,208,34,34 );
	gfx.PutPixel( 34 + x,73 + y,208,34,34 );
	gfx.PutPixel( 35 + x,73 + y,208,34,34 );
	gfx.PutPixel( 36 + x,73 + y,208,34,34 );
	gfx.PutPixel( 37 + x,73 + y,208,34,34 );
	gfx.PutPixel( 38 + x,73 + y,208,34,34 );
	gfx.PutPixel( 39 + x,73 + y,208,34,34 );
	gfx.PutPixel( 40 + x,73 + y,208,34,34 );
	gfx.PutPixel( 41 + x,73 + y,208,34,34 );
	gfx.PutPixel( 42 + x,73 + y,208,34,34 );
	gfx.PutPixel( 43 + x,73 + y,208,34,34 );
	gfx.PutPixel( 44 + x,73 + y,208,34,34 );
	gfx.PutPixel( 45 + x,73 + y,208,34,34 );
	gfx.PutPixel( 46 + x,73 + y,208,34,34 );
	gfx.PutPixel( 47 + x,73 + y,208,34,34 );
	gfx.PutPixel( 48 + x,73 + y,208,34,34 );
	gfx.PutPixel( 49 + x,73 + y,208,34,34 );
	gfx.PutPixel( 50 + x,73 + y,208,34,34 );
	gfx.PutPixel( 51 + x,73 + y,208,34,34 );
	gfx.PutPixel( 52 + x,73 + y,208,34,34 );
	gfx.PutPixel( 53 + x,73 + y,208,34,34 );
	gfx.PutPixel( 54 + x,73 + y,208,34,34 );
	gfx.PutPixel( 55 + x,73 + y,208,34,34 );
	gfx.PutPixel( 56 + x,73 + y,208,34,34 );
	gfx.PutPixel( 57 + x,73 + y,208,34,34 );
	gfx.PutPixel( 58 + x,73 + y,208,34,34 );
	gfx.PutPixel( 59 + x,73 + y,208,34,34 );
	gfx.PutPixel( 60 + x,73 + y,208,34,34 );
	gfx.PutPixel( 61 + x,73 + y,208,34,34 );
	gfx.PutPixel( 62 + x,73 + y,208,34,34 );
	gfx.PutPixel( 63 + x,73 + y,208,34,34 );
	gfx.PutPixel( 64 + x,73 + y,208,34,34 );
	gfx.PutPixel( 65 + x,73 + y,208,34,34 );
	gfx.PutPixel( 66 + x,73 + y,208,34,34 );
	gfx.PutPixel( 67 + x,73 + y,208,34,34 );
	gfx.PutPixel( 68 + x,73 + y,208,34,34 );
	gfx.PutPixel( 69 + x,73 + y,208,34,34 );
	gfx.PutPixel( 70 + x,73 + y,208,34,34 );
	gfx.PutPixel( 71 + x,73 + y,208,34,34 );
	gfx.PutPixel( 72 + x,73 + y,208,34,34 );
	gfx.PutPixel( 73 + x,73 + y,208,34,34 );
	gfx.PutPixel( 74 + x,73 + y,208,34,34 );
	gfx.PutPixel( 75 + x,73 + y,208,34,34 );
	gfx.PutPixel( 76 + x,73 + y,208,34,34 );
	gfx.PutPixel( 77 + x,73 + y,208,34,34 );
	gfx.PutPixel( 78 + x,73 + y,208,34,34 );
	gfx.PutPixel( 79 + x,73 + y,208,34,34 );
	gfx.PutPixel( 80 + x,73 + y,208,34,34 );
	gfx.PutPixel( 81 + x,73 + y,208,34,34 );
	gfx.PutPixel( 82 + x,73 + y,208,34,34 );
	gfx.PutPixel( 83 + x,73 + y,208,34,34 );
	gfx.PutPixel( 84 + x,73 + y,208,34,34 );
	gfx.PutPixel( 85 + x,73 + y,208,34,34 );
	gfx.PutPixel( 86 + x,73 + y,208,34,34 );
	gfx.PutPixel( 87 + x,73 + y,208,34,34 );
	gfx.PutPixel( 88 + x,73 + y,208,34,34 );
	gfx.PutPixel( 89 + x,73 + y,208,34,34 );
	gfx.PutPixel( 90 + x,73 + y,208,34,34 );
	gfx.PutPixel( 91 + x,73 + y,208,34,34 );
	gfx.PutPixel( 92 + x,73 + y,208,34,34 );
	gfx.PutPixel( 93 + x,73 + y,208,34,34 );
	gfx.PutPixel( 94 + x,73 + y,208,34,34 );
	gfx.PutPixel( 95 + x,73 + y,208,34,34 );
	gfx.PutPixel( 96 + x,73 + y,208,34,34 );
	gfx.PutPixel( 97 + x,73 + y,208,34,34 );
	gfx.PutPixel( 98 + x,73 + y,208,34,34 );
	gfx.PutPixel( 99 + x,73 + y,208,34,34 );
	gfx.PutPixel( 100 + x,73 + y,208,34,34 );
	gfx.PutPixel( 101 + x,73 + y,208,34,34 );
	gfx.PutPixel( 102 + x,73 + y,208,34,34 );
	gfx.PutPixel( 103 + x,73 + y,208,34,34 );
	gfx.PutPixel( 104 + x,73 + y,208,34,34 );
	gfx.PutPixel( 105 + x,73 + y,208,34,34 );
	gfx.PutPixel( 106 + x,73 + y,208,34,34 );
	gfx.PutPixel( 107 + x,73 + y,208,34,34 );
	gfx.PutPixel( 108 + x,73 + y,208,34,34 );
	gfx.PutPixel( 109 + x,73 + y,208,34,34 );
	gfx.PutPixel( 110 + x,73 + y,208,34,34 );
	gfx.PutPixel( 111 + x,73 + y,208,34,34 );
	gfx.PutPixel( 112 + x,73 + y,208,34,34 );
	gfx.PutPixel( 113 + x,73 + y,208,34,34 );
	gfx.PutPixel( 114 + x,73 + y,208,34,34 );
	gfx.PutPixel( 115 + x,73 + y,208,34,34 );
	gfx.PutPixel( 116 + x,73 + y,208,34,34 );
	gfx.PutPixel( 117 + x,73 + y,208,34,34 );
	gfx.PutPixel( 118 + x,73 + y,208,34,34 );
	gfx.PutPixel( 119 + x,73 + y,208,34,34 );
	gfx.PutPixel( 120 + x,73 + y,208,34,34 );
	gfx.PutPixel( 121 + x,73 + y,208,34,34 );
	gfx.PutPixel( 122 + x,73 + y,208,34,34 );
	gfx.PutPixel( 123 + x,73 + y,208,34,34 );
	gfx.PutPixel( 124 + x,73 + y,208,34,34 );
	gfx.PutPixel( 125 + x,73 + y,208,34,34 );
	gfx.PutPixel( 126 + x,73 + y,208,34,34 );
	gfx.PutPixel( 127 + x,73 + y,208,34,34 );
	gfx.PutPixel( 128 + x,73 + y,208,34,34 );
	gfx.PutPixel( 129 + x,73 + y,208,34,34 );
	gfx.PutPixel( 130 + x,73 + y,208,34,34 );
	gfx.PutPixel( 131 + x,73 + y,208,34,34 );
	gfx.PutPixel( 132 + x,73 + y,208,34,34 );
	gfx.PutPixel( 133 + x,73 + y,208,34,34 );
	gfx.PutPixel( 134 + x,73 + y,208,34,34 );
	gfx.PutPixel( 135 + x,73 + y,208,34,34 );
	gfx.PutPixel( 136 + x,73 + y,208,34,34 );
	gfx.PutPixel( 137 + x,73 + y,208,34,34 );
	gfx.PutPixel( 138 + x,73 + y,208,34,34 );
	gfx.PutPixel( 139 + x,73 + y,208,34,34 );
	gfx.PutPixel( 140 + x,73 + y,208,34,34 );
	gfx.PutPixel( 141 + x,73 + y,208,34,34 );
	gfx.PutPixel( 142 + x,73 + y,208,34,34 );
	gfx.PutPixel( 143 + x,73 + y,208,34,34 );
	gfx.PutPixel( 144 + x,73 + y,208,34,34 );
	gfx.PutPixel( 145 + x,73 + y,208,34,34 );
	gfx.PutPixel( 146 + x,73 + y,208,34,34 );
	gfx.PutPixel( 147 + x,73 + y,208,34,34 );
	gfx.PutPixel( 148 + x,73 + y,208,34,34 );
	gfx.PutPixel( 149 + x,73 + y,208,34,34 );
	gfx.PutPixel( 0 + x,74 + y,208,34,34 );
	gfx.PutPixel( 1 + x,74 + y,208,34,34 );
	gfx.PutPixel( 2 + x,74 + y,208,34,34 );
	gfx.PutPixel( 3 + x,74 + y,208,34,34 );
	gfx.PutPixel( 4 + x,74 + y,208,34,34 );
	gfx.PutPixel( 5 + x,74 + y,208,34,34 );
	gfx.PutPixel( 6 + x,74 + y,208,34,34 );
	gfx.PutPixel( 7 + x,74 + y,208,34,34 );
	gfx.PutPixel( 8 + x,74 + y,208,34,34 );
	gfx.PutPixel( 9 + x,74 + y,208,34,34 );
	gfx.PutPixel( 10 + x,74 + y,208,34,34 );
	gfx.PutPixel( 11 + x,74 + y,208,34,34 );
	gfx.PutPixel( 12 + x,74 + y,208,34,34 );
	gfx.PutPixel( 13 + x,74 + y,208,34,34 );
	gfx.PutPixel( 14 + x,74 + y,208,34,34 );
	gfx.PutPixel( 15 + x,74 + y,208,34,34 );
	gfx.PutPixel( 16 + x,74 + y,208,34,34 );
	gfx.PutPixel( 17 + x,74 + y,208,34,34 );
	gfx.PutPixel( 18 + x,74 + y,208,34,34 );
	gfx.PutPixel( 19 + x,74 + y,208,34,34 );
	gfx.PutPixel( 20 + x,74 + y,208,34,34 );
	gfx.PutPixel( 21 + x,74 + y,208,34,34 );
	gfx.PutPixel( 22 + x,74 + y,208,34,34 );
	gfx.PutPixel( 23 + x,74 + y,208,34,34 );
	gfx.PutPixel( 24 + x,74 + y,208,34,34 );
	gfx.PutPixel( 25 + x,74 + y,208,34,34 );
	gfx.PutPixel( 26 + x,74 + y,208,34,34 );
	gfx.PutPixel( 27 + x,74 + y,208,34,34 );
	gfx.PutPixel( 28 + x,74 + y,208,34,34 );
	gfx.PutPixel( 29 + x,74 + y,208,34,34 );
	gfx.PutPixel( 30 + x,74 + y,208,34,34 );
	gfx.PutPixel( 31 + x,74 + y,208,34,34 );
	gfx.PutPixel( 32 + x,74 + y,208,34,34 );
	gfx.PutPixel( 33 + x,74 + y,208,34,34 );
	gfx.PutPixel( 34 + x,74 + y,208,34,34 );
	gfx.PutPixel( 35 + x,74 + y,208,34,34 );
	gfx.PutPixel( 36 + x,74 + y,208,34,34 );
	gfx.PutPixel( 37 + x,74 + y,208,34,34 );
	gfx.PutPixel( 38 + x,74 + y,208,34,34 );
	gfx.PutPixel( 39 + x,74 + y,208,34,34 );
	gfx.PutPixel( 40 + x,74 + y,208,34,34 );
	gfx.PutPixel( 41 + x,74 + y,208,34,34 );
	gfx.PutPixel( 42 + x,74 + y,208,34,34 );
	gfx.PutPixel( 43 + x,74 + y,208,34,34 );
	gfx.PutPixel( 44 + x,74 + y,208,34,34 );
	gfx.PutPixel( 45 + x,74 + y,208,34,34 );
	gfx.PutPixel( 46 + x,74 + y,208,34,34 );
	gfx.PutPixel( 47 + x,74 + y,208,31,31 );
	gfx.PutPixel( 48 + x,74 + y,208,27,27 );
	gfx.PutPixel( 49 + x,74 + y,207,26,26 );
	gfx.PutPixel( 50 + x,74 + y,207,26,26 );
	gfx.PutPixel( 51 + x,74 + y,208,28,28 );
	gfx.PutPixel( 52 + x,74 + y,208,32,32 );
	gfx.PutPixel( 53 + x,74 + y,208,34,34 );
	gfx.PutPixel( 54 + x,74 + y,208,34,34 );
	gfx.PutPixel( 55 + x,74 + y,208,34,34 );
	gfx.PutPixel( 56 + x,74 + y,208,34,34 );
	gfx.PutPixel( 57 + x,74 + y,208,34,34 );
	gfx.PutPixel( 58 + x,74 + y,208,34,34 );
	gfx.PutPixel( 59 + x,74 + y,208,34,34 );
	gfx.PutPixel( 60 + x,74 + y,208,34,34 );
	gfx.PutPixel( 61 + x,74 + y,208,34,34 );
	gfx.PutPixel( 62 + x,74 + y,208,34,34 );
	gfx.PutPixel( 63 + x,74 + y,208,34,34 );
	gfx.PutPixel( 64 + x,74 + y,208,34,34 );
	gfx.PutPixel( 65 + x,74 + y,208,34,34 );
	gfx.PutPixel( 66 + x,74 + y,208,34,34 );
	gfx.PutPixel( 67 + x,74 + y,208,34,34 );
	gfx.PutPixel( 68 + x,74 + y,208,34,34 );
	gfx.PutPixel( 69 + x,74 + y,208,34,34 );
	gfx.PutPixel( 70 + x,74 + y,208,34,34 );
	gfx.PutPixel( 71 + x,74 + y,208,34,34 );
	gfx.PutPixel( 72 + x,74 + y,208,34,34 );
	gfx.PutPixel( 73 + x,74 + y,208,34,34 );
	gfx.PutPixel( 74 + x,74 + y,208,34,34 );
	gfx.PutPixel( 75 + x,74 + y,208,34,34 );
	gfx.PutPixel( 76 + x,74 + y,208,34,34 );
	gfx.PutPixel( 77 + x,74 + y,208,33,33 );
	gfx.PutPixel( 78 + x,74 + y,208,33,33 );
	gfx.PutPixel( 79 + x,74 + y,208,34,34 );
	gfx.PutPixel( 80 + x,74 + y,208,34,34 );
	gfx.PutPixel( 81 + x,74 + y,208,34,34 );
	gfx.PutPixel( 82 + x,74 + y,208,34,34 );
	gfx.PutPixel( 83 + x,74 + y,208,34,34 );
	gfx.PutPixel( 84 + x,74 + y,208,34,34 );
	gfx.PutPixel( 85 + x,74 + y,208,34,34 );
	gfx.PutPixel( 86 + x,74 + y,208,34,34 );
	gfx.PutPixel( 87 + x,74 + y,208,34,34 );
	gfx.PutPixel( 88 + x,74 + y,208,34,34 );
	gfx.PutPixel( 89 + x,74 + y,208,34,34 );
	gfx.PutPixel( 90 + x,74 + y,208,34,34 );
	gfx.PutPixel( 91 + x,74 + y,208,34,34 );
	gfx.PutPixel( 92 + x,74 + y,208,34,34 );
	gfx.PutPixel( 93 + x,74 + y,208,33,33 );
	gfx.PutPixel( 94 + x,74 + y,208,34,34 );
	gfx.PutPixel( 95 + x,74 + y,208,34,34 );
	gfx.PutPixel( 96 + x,74 + y,208,34,34 );
	gfx.PutPixel( 97 + x,74 + y,208,34,34 );
	gfx.PutPixel( 98 + x,74 + y,208,34,34 );
	gfx.PutPixel( 99 + x,74 + y,208,34,34 );
	gfx.PutPixel( 100 + x,74 + y,208,34,34 );
	gfx.PutPixel( 101 + x,74 + y,208,34,34 );
	gfx.PutPixel( 102 + x,74 + y,208,34,34 );
	gfx.PutPixel( 103 + x,74 + y,208,33,33 );
	gfx.PutPixel( 104 + x,74 + y,208,34,34 );
	gfx.PutPixel( 105 + x,74 + y,208,34,34 );
	gfx.PutPixel( 106 + x,74 + y,208,34,34 );
	gfx.PutPixel( 107 + x,74 + y,208,34,34 );
	gfx.PutPixel( 108 + x,74 + y,208,34,34 );
	gfx.PutPixel( 109 + x,74 + y,208,34,34 );
	gfx.PutPixel( 110 + x,74 + y,208,34,34 );
	gfx.PutPixel( 111 + x,74 + y,208,34,34 );
	gfx.PutPixel( 112 + x,74 + y,208,34,34 );
	gfx.PutPixel( 113 + x,74 + y,208,34,34 );
	gfx.PutPixel( 114 + x,74 + y,208,34,34 );
	gfx.PutPixel( 115 + x,74 + y,208,34,34 );
	gfx.PutPixel( 116 + x,74 + y,208,34,34 );
	gfx.PutPixel( 117 + x,74 + y,208,34,34 );
	gfx.PutPixel( 118 + x,74 + y,208,34,34 );
	gfx.PutPixel( 119 + x,74 + y,208,34,34 );
	gfx.PutPixel( 120 + x,74 + y,208,34,34 );
	gfx.PutPixel( 121 + x,74 + y,208,34,34 );
	gfx.PutPixel( 122 + x,74 + y,208,34,34 );
	gfx.PutPixel( 123 + x,74 + y,208,34,34 );
	gfx.PutPixel( 124 + x,74 + y,208,34,34 );
	gfx.PutPixel( 125 + x,74 + y,208,34,34 );
	gfx.PutPixel( 126 + x,74 + y,208,34,34 );
	gfx.PutPixel( 127 + x,74 + y,208,34,34 );
	gfx.PutPixel( 128 + x,74 + y,208,34,34 );
	gfx.PutPixel( 129 + x,74 + y,208,34,34 );
	gfx.PutPixel( 130 + x,74 + y,208,34,34 );
	gfx.PutPixel( 131 + x,74 + y,208,34,34 );
	gfx.PutPixel( 132 + x,74 + y,208,34,34 );
	gfx.PutPixel( 133 + x,74 + y,208,34,34 );
	gfx.PutPixel( 134 + x,74 + y,208,34,34 );
	gfx.PutPixel( 135 + x,74 + y,208,34,34 );
	gfx.PutPixel( 136 + x,74 + y,208,34,34 );
	gfx.PutPixel( 137 + x,74 + y,208,34,34 );
	gfx.PutPixel( 138 + x,74 + y,208,34,34 );
	gfx.PutPixel( 139 + x,74 + y,208,34,34 );
	gfx.PutPixel( 140 + x,74 + y,208,34,34 );
	gfx.PutPixel( 141 + x,74 + y,208,34,34 );
	gfx.PutPixel( 142 + x,74 + y,208,34,34 );
	gfx.PutPixel( 143 + x,74 + y,208,34,34 );
	gfx.PutPixel( 144 + x,74 + y,208,34,34 );
	gfx.PutPixel( 145 + x,74 + y,208,34,34 );
	gfx.PutPixel( 146 + x,74 + y,208,34,34 );
	gfx.PutPixel( 147 + x,74 + y,208,34,34 );
	gfx.PutPixel( 148 + x,74 + y,208,34,34 );
	gfx.PutPixel( 149 + x,74 + y,208,34,34 );
	gfx.PutPixel( 0 + x,75 + y,208,34,34 );
	gfx.PutPixel( 1 + x,75 + y,208,34,34 );
	gfx.PutPixel( 2 + x,75 + y,208,34,34 );
	gfx.PutPixel( 3 + x,75 + y,208,34,34 );
	gfx.PutPixel( 4 + x,75 + y,208,34,34 );
	gfx.PutPixel( 5 + x,75 + y,208,34,34 );
	gfx.PutPixel( 6 + x,75 + y,208,34,34 );
	gfx.PutPixel( 7 + x,75 + y,208,34,34 );
	gfx.PutPixel( 8 + x,75 + y,208,34,34 );
	gfx.PutPixel( 9 + x,75 + y,208,34,34 );
	gfx.PutPixel( 10 + x,75 + y,208,34,34 );
	gfx.PutPixel( 11 + x,75 + y,208,34,34 );
	gfx.PutPixel( 12 + x,75 + y,208,34,34 );
	gfx.PutPixel( 13 + x,75 + y,208,34,34 );
	gfx.PutPixel( 14 + x,75 + y,208,34,34 );
	gfx.PutPixel( 15 + x,75 + y,208,34,34 );
	gfx.PutPixel( 16 + x,75 + y,208,34,34 );
	gfx.PutPixel( 17 + x,75 + y,208,34,34 );
	gfx.PutPixel( 18 + x,75 + y,208,34,34 );
	gfx.PutPixel( 19 + x,75 + y,208,34,34 );
	gfx.PutPixel( 20 + x,75 + y,208,34,34 );
	gfx.PutPixel( 21 + x,75 + y,208,34,34 );
	gfx.PutPixel( 22 + x,75 + y,208,34,34 );
	gfx.PutPixel( 23 + x,75 + y,208,34,34 );
	gfx.PutPixel( 24 + x,75 + y,208,34,34 );
	gfx.PutPixel( 25 + x,75 + y,208,34,34 );
	gfx.PutPixel( 26 + x,75 + y,208,34,34 );
	gfx.PutPixel( 27 + x,75 + y,208,34,34 );
	gfx.PutPixel( 28 + x,75 + y,208,34,34 );
	gfx.PutPixel( 29 + x,75 + y,208,34,34 );
	gfx.PutPixel( 30 + x,75 + y,208,34,34 );
	gfx.PutPixel( 31 + x,75 + y,208,34,34 );
	gfx.PutPixel( 32 + x,75 + y,208,34,34 );
	gfx.PutPixel( 33 + x,75 + y,208,34,34 );
	gfx.PutPixel( 34 + x,75 + y,208,34,34 );
	gfx.PutPixel( 35 + x,75 + y,208,34,34 );
	gfx.PutPixel( 36 + x,75 + y,208,34,34 );
	gfx.PutPixel( 37 + x,75 + y,208,34,34 );
	gfx.PutPixel( 38 + x,75 + y,208,34,34 );
	gfx.PutPixel( 39 + x,75 + y,208,34,34 );
	gfx.PutPixel( 40 + x,75 + y,208,34,34 );
	gfx.PutPixel( 41 + x,75 + y,208,34,34 );
	gfx.PutPixel( 42 + x,75 + y,208,34,34 );
	gfx.PutPixel( 43 + x,75 + y,208,34,34 );
	gfx.PutPixel( 44 + x,75 + y,208,33,33 );
	gfx.PutPixel( 45 + x,75 + y,207,25,25 );
	gfx.PutPixel( 46 + x,75 + y,207,25,25 );
	gfx.PutPixel( 47 + x,75 + y,209,44,44 );
	gfx.PutPixel( 48 + x,75 + y,210,67,67 );
	gfx.PutPixel( 49 + x,75 + y,211,80,80 );
	gfx.PutPixel( 50 + x,75 + y,211,80,80 );
	gfx.PutPixel( 51 + x,75 + y,210,63,63 );
	gfx.PutPixel( 52 + x,75 + y,208,37,37 );
	gfx.PutPixel( 53 + x,75 + y,207,23,23 );
	gfx.PutPixel( 54 + x,75 + y,208,31,31 );
	gfx.PutPixel( 55 + x,75 + y,208,34,34 );
	gfx.PutPixel( 56 + x,75 + y,208,34,34 );
	gfx.PutPixel( 57 + x,75 + y,208,34,34 );
	gfx.PutPixel( 58 + x,75 + y,208,34,34 );
	gfx.PutPixel( 59 + x,75 + y,208,34,34 );
	gfx.PutPixel( 60 + x,75 + y,208,34,34 );
	gfx.PutPixel( 61 + x,75 + y,208,34,34 );
	gfx.PutPixel( 62 + x,75 + y,208,34,34 );
	gfx.PutPixel( 63 + x,75 + y,208,30,30 );
	gfx.PutPixel( 64 + x,75 + y,207,27,27 );
	gfx.PutPixel( 65 + x,75 + y,208,27,27 );
	gfx.PutPixel( 66 + x,75 + y,207,27,27 );
	gfx.PutPixel( 67 + x,75 + y,208,32,32 );
	gfx.PutPixel( 68 + x,75 + y,208,34,34 );
	gfx.PutPixel( 69 + x,75 + y,208,34,34 );
	gfx.PutPixel( 70 + x,75 + y,208,34,34 );
	gfx.PutPixel( 71 + x,75 + y,208,34,34 );
	gfx.PutPixel( 72 + x,75 + y,208,34,34 );
	gfx.PutPixel( 73 + x,75 + y,208,34,34 );
	gfx.PutPixel( 74 + x,75 + y,208,34,34 );
	gfx.PutPixel( 75 + x,75 + y,208,34,34 );
	gfx.PutPixel( 76 + x,75 + y,208,29,29 );
	gfx.PutPixel( 77 + x,75 + y,207,27,27 );
	gfx.PutPixel( 78 + x,75 + y,207,27,27 );
	gfx.PutPixel( 79 + x,75 + y,208,29,29 );
	gfx.PutPixel( 80 + x,75 + y,208,34,34 );
	gfx.PutPixel( 81 + x,75 + y,208,34,34 );
	gfx.PutPixel( 82 + x,75 + y,208,34,34 );
	gfx.PutPixel( 83 + x,75 + y,208,34,34 );
	gfx.PutPixel( 84 + x,75 + y,208,34,34 );
	gfx.PutPixel( 85 + x,75 + y,208,34,34 );
	gfx.PutPixel( 86 + x,75 + y,208,34,34 );
	gfx.PutPixel( 87 + x,75 + y,208,34,34 );
	gfx.PutPixel( 88 + x,75 + y,208,34,34 );
	gfx.PutPixel( 89 + x,75 + y,208,28,28 );
	gfx.PutPixel( 90 + x,75 + y,208,27,27 );
	gfx.PutPixel( 91 + x,75 + y,208,27,27 );
	gfx.PutPixel( 92 + x,75 + y,208,27,27 );
	gfx.PutPixel( 93 + x,75 + y,208,27,27 );
	gfx.PutPixel( 94 + x,75 + y,208,28,28 );
	gfx.PutPixel( 95 + x,75 + y,208,34,34 );
	gfx.PutPixel( 96 + x,75 + y,208,34,34 );
	gfx.PutPixel( 97 + x,75 + y,208,34,34 );
	gfx.PutPixel( 98 + x,75 + y,208,34,34 );
	gfx.PutPixel( 99 + x,75 + y,208,34,34 );
	gfx.PutPixel( 100 + x,75 + y,208,34,34 );
	gfx.PutPixel( 101 + x,75 + y,208,34,34 );
	gfx.PutPixel( 102 + x,75 + y,208,28,28 );
	gfx.PutPixel( 103 + x,75 + y,208,27,27 );
	gfx.PutPixel( 104 + x,75 + y,208,27,27 );
	gfx.PutPixel( 105 + x,75 + y,208,27,27 );
	gfx.PutPixel( 106 + x,75 + y,208,27,27 );
	gfx.PutPixel( 107 + x,75 + y,208,28,28 );
	gfx.PutPixel( 108 + x,75 + y,208,34,34 );
	gfx.PutPixel( 109 + x,75 + y,208,34,34 );
	gfx.PutPixel( 110 + x,75 + y,208,34,34 );
	gfx.PutPixel( 111 + x,75 + y,208,34,34 );
	gfx.PutPixel( 112 + x,75 + y,208,34,34 );
	gfx.PutPixel( 113 + x,75 + y,208,34,34 );
	gfx.PutPixel( 114 + x,75 + y,208,34,34 );
	gfx.PutPixel( 115 + x,75 + y,208,34,34 );
	gfx.PutPixel( 116 + x,75 + y,208,34,34 );
	gfx.PutPixel( 117 + x,75 + y,208,34,34 );
	gfx.PutPixel( 118 + x,75 + y,208,34,34 );
	gfx.PutPixel( 119 + x,75 + y,208,34,34 );
	gfx.PutPixel( 120 + x,75 + y,208,34,34 );
	gfx.PutPixel( 121 + x,75 + y,208,34,34 );
	gfx.PutPixel( 122 + x,75 + y,208,34,34 );
	gfx.PutPixel( 123 + x,75 + y,208,34,34 );
	gfx.PutPixel( 124 + x,75 + y,208,34,34 );
	gfx.PutPixel( 125 + x,75 + y,208,34,34 );
	gfx.PutPixel( 126 + x,75 + y,208,34,34 );
	gfx.PutPixel( 127 + x,75 + y,208,34,34 );
	gfx.PutPixel( 128 + x,75 + y,208,34,34 );
	gfx.PutPixel( 129 + x,75 + y,208,34,34 );
	gfx.PutPixel( 130 + x,75 + y,208,34,34 );
	gfx.PutPixel( 131 + x,75 + y,208,34,34 );
	gfx.PutPixel( 132 + x,75 + y,208,34,34 );
	gfx.PutPixel( 133 + x,75 + y,208,34,34 );
	gfx.PutPixel( 134 + x,75 + y,208,34,34 );
	gfx.PutPixel( 135 + x,75 + y,208,34,34 );
	gfx.PutPixel( 136 + x,75 + y,208,34,34 );
	gfx.PutPixel( 137 + x,75 + y,208,34,34 );
	gfx.PutPixel( 138 + x,75 + y,208,34,34 );
	gfx.PutPixel( 139 + x,75 + y,208,34,34 );
	gfx.PutPixel( 140 + x,75 + y,208,34,34 );
	gfx.PutPixel( 141 + x,75 + y,208,34,34 );
	gfx.PutPixel( 142 + x,75 + y,208,34,34 );
	gfx.PutPixel( 143 + x,75 + y,208,34,34 );
	gfx.PutPixel( 144 + x,75 + y,208,34,34 );
	gfx.PutPixel( 145 + x,75 + y,208,34,34 );
	gfx.PutPixel( 146 + x,75 + y,208,34,34 );
	gfx.PutPixel( 147 + x,75 + y,208,34,34 );
	gfx.PutPixel( 148 + x,75 + y,208,34,34 );
	gfx.PutPixel( 149 + x,75 + y,208,34,34 );
	gfx.PutPixel( 0 + x,76 + y,208,34,34 );
	gfx.PutPixel( 1 + x,76 + y,208,34,34 );
	gfx.PutPixel( 2 + x,76 + y,208,34,34 );
	gfx.PutPixel( 3 + x,76 + y,208,34,34 );
	gfx.PutPixel( 4 + x,76 + y,208,34,34 );
	gfx.PutPixel( 5 + x,76 + y,208,34,34 );
	gfx.PutPixel( 6 + x,76 + y,208,34,34 );
	gfx.PutPixel( 7 + x,76 + y,208,34,34 );
	gfx.PutPixel( 8 + x,76 + y,208,34,34 );
	gfx.PutPixel( 9 + x,76 + y,208,34,34 );
	gfx.PutPixel( 10 + x,76 + y,208,34,34 );
	gfx.PutPixel( 11 + x,76 + y,208,34,34 );
	gfx.PutPixel( 12 + x,76 + y,208,34,34 );
	gfx.PutPixel( 13 + x,76 + y,208,34,34 );
	gfx.PutPixel( 14 + x,76 + y,208,34,34 );
	gfx.PutPixel( 15 + x,76 + y,208,34,34 );
	gfx.PutPixel( 16 + x,76 + y,208,34,34 );
	gfx.PutPixel( 17 + x,76 + y,208,34,34 );
	gfx.PutPixel( 18 + x,76 + y,208,34,34 );
	gfx.PutPixel( 19 + x,76 + y,208,34,34 );
	gfx.PutPixel( 20 + x,76 + y,208,34,34 );
	gfx.PutPixel( 21 + x,76 + y,208,34,34 );
	gfx.PutPixel( 22 + x,76 + y,208,34,34 );
	gfx.PutPixel( 23 + x,76 + y,208,34,34 );
	gfx.PutPixel( 24 + x,76 + y,208,34,34 );
	gfx.PutPixel( 25 + x,76 + y,208,34,34 );
	gfx.PutPixel( 26 + x,76 + y,208,34,34 );
	gfx.PutPixel( 27 + x,76 + y,208,34,34 );
	gfx.PutPixel( 28 + x,76 + y,208,34,34 );
	gfx.PutPixel( 29 + x,76 + y,208,34,34 );
	gfx.PutPixel( 30 + x,76 + y,208,34,34 );
	gfx.PutPixel( 31 + x,76 + y,208,34,34 );
	gfx.PutPixel( 32 + x,76 + y,208,34,34 );
	gfx.PutPixel( 33 + x,76 + y,208,34,34 );
	gfx.PutPixel( 34 + x,76 + y,208,34,34 );
	gfx.PutPixel( 35 + x,76 + y,208,34,34 );
	gfx.PutPixel( 36 + x,76 + y,208,34,34 );
	gfx.PutPixel( 37 + x,76 + y,208,34,34 );
	gfx.PutPixel( 38 + x,76 + y,208,34,34 );
	gfx.PutPixel( 39 + x,76 + y,208,34,34 );
	gfx.PutPixel( 40 + x,76 + y,208,34,34 );
	gfx.PutPixel( 41 + x,76 + y,208,34,34 );
	gfx.PutPixel( 42 + x,76 + y,208,34,34 );
	gfx.PutPixel( 43 + x,76 + y,208,29,29 );
	gfx.PutPixel( 44 + x,76 + y,207,26,26 );
	gfx.PutPixel( 45 + x,76 + y,211,81,81 );
	gfx.PutPixel( 46 + x,76 + y,217,158,158 );
	gfx.PutPixel( 47 + x,76 + y,220,202,202 );
	gfx.PutPixel( 48 + x,76 + y,221,220,220 );
	gfx.PutPixel( 49 + x,76 + y,221,227,227 );
	gfx.PutPixel( 50 + x,76 + y,221,226,226 );
	gfx.PutPixel( 51 + x,76 + y,221,218,218 );
	gfx.PutPixel( 52 + x,76 + y,219,192,192 );
	gfx.PutPixel( 53 + x,76 + y,214,125,125 );
	gfx.PutPixel( 54 + x,76 + y,208,41,41 );
	gfx.PutPixel( 55 + x,76 + y,208,26,26 );
	gfx.PutPixel( 56 + x,76 + y,208,35,35 );
	gfx.PutPixel( 57 + x,76 + y,208,34,34 );
	gfx.PutPixel( 58 + x,76 + y,208,34,34 );
	gfx.PutPixel( 59 + x,76 + y,208,34,34 );
	gfx.PutPixel( 60 + x,76 + y,208,34,34 );
	gfx.PutPixel( 61 + x,76 + y,208,34,34 );
	gfx.PutPixel( 62 + x,76 + y,207,26,26 );
	gfx.PutPixel( 63 + x,76 + y,211,81,81 );
	gfx.PutPixel( 64 + x,76 + y,218,179,179 );
	gfx.PutPixel( 65 + x,76 + y,218,175,175 );
	gfx.PutPixel( 66 + x,76 + y,217,168,168 );
	gfx.PutPixel( 67 + x,76 + y,209,50,50 );
	gfx.PutPixel( 68 + x,76 + y,208,30,30 );
	gfx.PutPixel( 69 + x,76 + y,208,34,34 );
	gfx.PutPixel( 70 + x,76 + y,208,34,34 );
	gfx.PutPixel( 71 + x,76 + y,208,34,34 );
	gfx.PutPixel( 72 + x,76 + y,208,34,34 );
	gfx.PutPixel( 73 + x,76 + y,208,34,34 );
	gfx.PutPixel( 74 + x,76 + y,208,34,34 );
	gfx.PutPixel( 75 + x,76 + y,208,29,29 );
	gfx.PutPixel( 76 + x,76 + y,215,137,137 );
	gfx.PutPixel( 77 + x,76 + y,218,179,179 );
	gfx.PutPixel( 78 + x,76 + y,218,179,179 );
	gfx.PutPixel( 79 + x,76 + y,215,137,137 );
	gfx.PutPixel( 80 + x,76 + y,208,29,29 );
	gfx.PutPixel( 81 + x,76 + y,208,34,34 );
	gfx.PutPixel( 82 + x,76 + y,208,34,34 );
	gfx.PutPixel( 83 + x,76 + y,208,34,34 );
	gfx.PutPixel( 84 + x,76 + y,208,34,34 );
	gfx.PutPixel( 85 + x,76 + y,208,34,34 );
	gfx.PutPixel( 86 + x,76 + y,208,34,34 );
	gfx.PutPixel( 87 + x,76 + y,208,31,31 );
	gfx.PutPixel( 88 + x,76 + y,209,44,44 );
	gfx.PutPixel( 89 + x,76 + y,217,163,163 );
	gfx.PutPixel( 90 + x,76 + y,218,176,176 );
	gfx.PutPixel( 91 + x,76 + y,218,173,173 );
	gfx.PutPixel( 92 + x,76 + y,218,173,173 );
	gfx.PutPixel( 93 + x,76 + y,218,179,179 );
	gfx.PutPixel( 94 + x,76 + y,215,134,134 );
	gfx.PutPixel( 95 + x,76 + y,208,28,28 );
	gfx.PutPixel( 96 + x,76 + y,208,34,34 );
	gfx.PutPixel( 97 + x,76 + y,208,34,34 );
	gfx.PutPixel( 98 + x,76 + y,208,34,34 );
	gfx.PutPixel( 99 + x,76 + y,208,34,34 );
	gfx.PutPixel( 100 + x,76 + y,208,34,34 );
	gfx.PutPixel( 101 + x,76 + y,207,28,28 );
	gfx.PutPixel( 102 + x,76 + y,215,131,131 );
	gfx.PutPixel( 103 + x,76 + y,218,179,179 );
	gfx.PutPixel( 104 + x,76 + y,218,173,173 );
	gfx.PutPixel( 105 + x,76 + y,218,173,173 );
	gfx.PutPixel( 106 + x,76 + y,218,176,176 );
	gfx.PutPixel( 107 + x,76 + y,217,163,163 );
	gfx.PutPixel( 108 + x,76 + y,209,44,44 );
	gfx.PutPixel( 109 + x,76 + y,208,31,31 );
	gfx.PutPixel( 110 + x,76 + y,208,34,34 );
	gfx.PutPixel( 111 + x,76 + y,208,34,34 );
	gfx.PutPixel( 112 + x,76 + y,208,34,34 );
	gfx.PutPixel( 113 + x,76 + y,208,34,34 );
	gfx.PutPixel( 114 + x,76 + y,208,34,34 );
	gfx.PutPixel( 115 + x,76 + y,208,34,34 );
	gfx.PutPixel( 116 + x,76 + y,208,34,34 );
	gfx.PutPixel( 117 + x,76 + y,208,34,34 );
	gfx.PutPixel( 118 + x,76 + y,208,34,34 );
	gfx.PutPixel( 119 + x,76 + y,208,34,34 );
	gfx.PutPixel( 120 + x,76 + y,208,34,34 );
	gfx.PutPixel( 121 + x,76 + y,208,34,34 );
	gfx.PutPixel( 122 + x,76 + y,208,34,34 );
	gfx.PutPixel( 123 + x,76 + y,208,34,34 );
	gfx.PutPixel( 124 + x,76 + y,208,34,34 );
	gfx.PutPixel( 125 + x,76 + y,208,34,34 );
	gfx.PutPixel( 126 + x,76 + y,208,34,34 );
	gfx.PutPixel( 127 + x,76 + y,208,34,34 );
	gfx.PutPixel( 128 + x,76 + y,208,34,34 );
	gfx.PutPixel( 129 + x,76 + y,208,34,34 );
	gfx.PutPixel( 130 + x,76 + y,208,34,34 );
	gfx.PutPixel( 131 + x,76 + y,208,34,34 );
	gfx.PutPixel( 132 + x,76 + y,208,34,34 );
	gfx.PutPixel( 133 + x,76 + y,208,34,34 );
	gfx.PutPixel( 134 + x,76 + y,208,34,34 );
	gfx.PutPixel( 135 + x,76 + y,208,34,34 );
	gfx.PutPixel( 136 + x,76 + y,208,34,34 );
	gfx.PutPixel( 137 + x,76 + y,208,34,34 );
	gfx.PutPixel( 138 + x,76 + y,208,34,34 );
	gfx.PutPixel( 139 + x,76 + y,208,34,34 );
	gfx.PutPixel( 140 + x,76 + y,208,34,34 );
	gfx.PutPixel( 141 + x,76 + y,208,34,34 );
	gfx.PutPixel( 142 + x,76 + y,208,34,34 );
	gfx.PutPixel( 143 + x,76 + y,208,34,34 );
	gfx.PutPixel( 144 + x,76 + y,208,34,34 );
	gfx.PutPixel( 145 + x,76 + y,208,34,34 );
	gfx.PutPixel( 146 + x,76 + y,208,34,34 );
	gfx.PutPixel( 147 + x,76 + y,208,34,34 );
	gfx.PutPixel( 148 + x,76 + y,208,34,34 );
	gfx.PutPixel( 149 + x,76 + y,208,34,34 );
	gfx.PutPixel( 0 + x,77 + y,208,34,34 );
	gfx.PutPixel( 1 + x,77 + y,208,34,34 );
	gfx.PutPixel( 2 + x,77 + y,208,34,34 );
	gfx.PutPixel( 3 + x,77 + y,208,34,34 );
	gfx.PutPixel( 4 + x,77 + y,208,34,34 );
	gfx.PutPixel( 5 + x,77 + y,208,34,34 );
	gfx.PutPixel( 6 + x,77 + y,208,34,34 );
	gfx.PutPixel( 7 + x,77 + y,208,34,34 );
	gfx.PutPixel( 8 + x,77 + y,208,34,34 );
	gfx.PutPixel( 9 + x,77 + y,208,34,34 );
	gfx.PutPixel( 10 + x,77 + y,208,34,34 );
	gfx.PutPixel( 11 + x,77 + y,208,34,34 );
	gfx.PutPixel( 12 + x,77 + y,208,34,34 );
	gfx.PutPixel( 13 + x,77 + y,208,34,34 );
	gfx.PutPixel( 14 + x,77 + y,208,34,34 );
	gfx.PutPixel( 15 + x,77 + y,208,34,34 );
	gfx.PutPixel( 16 + x,77 + y,208,34,34 );
	gfx.PutPixel( 17 + x,77 + y,208,34,34 );
	gfx.PutPixel( 18 + x,77 + y,208,34,34 );
	gfx.PutPixel( 19 + x,77 + y,208,34,34 );
	gfx.PutPixel( 20 + x,77 + y,208,34,34 );
	gfx.PutPixel( 21 + x,77 + y,208,34,34 );
	gfx.PutPixel( 22 + x,77 + y,208,34,34 );
	gfx.PutPixel( 23 + x,77 + y,208,34,34 );
	gfx.PutPixel( 24 + x,77 + y,208,34,34 );
	gfx.PutPixel( 25 + x,77 + y,208,34,34 );
	gfx.PutPixel( 26 + x,77 + y,208,34,34 );
	gfx.PutPixel( 27 + x,77 + y,208,34,34 );
	gfx.PutPixel( 28 + x,77 + y,208,34,34 );
	gfx.PutPixel( 29 + x,77 + y,208,34,34 );
	gfx.PutPixel( 30 + x,77 + y,208,34,34 );
	gfx.PutPixel( 31 + x,77 + y,208,34,34 );
	gfx.PutPixel( 32 + x,77 + y,208,34,34 );
	gfx.PutPixel( 33 + x,77 + y,208,34,34 );
	gfx.PutPixel( 34 + x,77 + y,208,34,34 );
	gfx.PutPixel( 35 + x,77 + y,208,34,34 );
	gfx.PutPixel( 36 + x,77 + y,208,34,34 );
	gfx.PutPixel( 37 + x,77 + y,208,34,34 );
	gfx.PutPixel( 38 + x,77 + y,208,34,34 );
	gfx.PutPixel( 39 + x,77 + y,208,34,34 );
	gfx.PutPixel( 40 + x,77 + y,208,34,34 );
	gfx.PutPixel( 41 + x,77 + y,208,34,34 );
	gfx.PutPixel( 42 + x,77 + y,207,27,27 );
	gfx.PutPixel( 43 + x,77 + y,209,42,42 );
	gfx.PutPixel( 44 + x,77 + y,216,155,155 );
	gfx.PutPixel( 45 + x,77 + y,221,227,227 );
	gfx.PutPixel( 46 + x,77 + y,222,232,232 );
	gfx.PutPixel( 47 + x,77 + y,221,226,226 );
	gfx.PutPixel( 48 + x,77 + y,221,223,223 );
	gfx.PutPixel( 49 + x,77 + y,221,222,222 );
	gfx.PutPixel( 50 + x,77 + y,221,222,222 );
	gfx.PutPixel( 51 + x,77 + y,221,223,223 );
	gfx.PutPixel( 52 + x,77 + y,221,228,228 );
	gfx.PutPixel( 53 + x,77 + y,222,235,235 );
	gfx.PutPixel( 54 + x,77 + y,219,193,193 );
	gfx.PutPixel( 55 + x,77 + y,210,70,70 );
	gfx.PutPixel( 56 + x,77 + y,208,29,29 );
	gfx.PutPixel( 57 + x,77 + y,208,34,34 );
	gfx.PutPixel( 58 + x,77 + y,208,34,34 );
	gfx.PutPixel( 59 + x,77 + y,208,34,34 );
	gfx.PutPixel( 60 + x,77 + y,208,34,34 );
	gfx.PutPixel( 61 + x,77 + y,208,33,33 );
	gfx.PutPixel( 62 + x,77 + y,207,26,26 );
	gfx.PutPixel( 63 + x,77 + y,217,168,168 );
	gfx.PutPixel( 64 + x,77 + y,222,239,239 );
	gfx.PutPixel( 65 + x,77 + y,222,230,230 );
	gfx.PutPixel( 66 + x,77 + y,223,240,240 );
	gfx.PutPixel( 67 + x,77 + y,214,119,119 );
	gfx.PutPixel( 68 + x,77 + y,207,22,22 );
	gfx.PutPixel( 69 + x,77 + y,208,34,34 );
	gfx.PutPixel( 70 + x,77 + y,208,34,34 );
	gfx.PutPixel( 71 + x,77 + y,208,34,34 );
	gfx.PutPixel( 72 + x,77 + y,208,34,34 );
	gfx.PutPixel( 73 + x,77 + y,208,34,34 );
	gfx.PutPixel( 74 + x,77 + y,208,34,34 );
	gfx.PutPixel( 75 + x,77 + y,208,27,27 );
	gfx.PutPixel( 76 + x,77 + y,218,179,179 );
	gfx.PutPixel( 77 + x,77 + y,223,239,239 );
	gfx.PutPixel( 78 + x,77 + y,223,239,239 );
	gfx.PutPixel( 79 + x,77 + y,218,179,179 );
	gfx.PutPixel( 80 + x,77 + y,208,27,27 );
	gfx.PutPixel( 81 + x,77 + y,208,34,34 );
	gfx.PutPixel( 82 + x,77 + y,208,34,34 );
	gfx.PutPixel( 83 + x,77 + y,208,34,34 );
	gfx.PutPixel( 84 + x,77 + y,208,34,34 );
	gfx.PutPixel( 85 + x,77 + y,208,34,34 );
	gfx.PutPixel( 86 + x,77 + y,208,34,34 );
	gfx.PutPixel( 87 + x,77 + y,208,30,30 );
	gfx.PutPixel( 88 + x,77 + y,209,48,48 );
	gfx.PutPixel( 89 + x,77 + y,221,216,216 );
	gfx.PutPixel( 90 + x,77 + y,222,234,234 );
	gfx.PutPixel( 91 + x,77 + y,222,230,230 );
	gfx.PutPixel( 92 + x,77 + y,222,230,230 );
	gfx.PutPixel( 93 + x,77 + y,222,233,233 );
	gfx.PutPixel( 94 + x,77 + y,221,216,216 );
	gfx.PutPixel( 95 + x,77 + y,209,53,53 );
	gfx.PutPixel( 96 + x,77 + y,208,29,29 );
	gfx.PutPixel( 97 + x,77 + y,208,34,34 );
	gfx.PutPixel( 98 + x,77 + y,208,34,34 );
	gfx.PutPixel( 99 + x,77 + y,208,34,34 );
	gfx.PutPixel( 100 + x,77 + y,208,30,30 );
	gfx.PutPixel( 101 + x,77 + y,209,50,50 );
	gfx.PutPixel( 102 + x,77 + y,220,214,214 );
	gfx.PutPixel( 103 + x,77 + y,222,234,234 );
	gfx.PutPixel( 104 + x,77 + y,222,230,230 );
	gfx.PutPixel( 105 + x,77 + y,222,230,230 );
	gfx.PutPixel( 106 + x,77 + y,222,234,234 );
	gfx.PutPixel( 107 + x,77 + y,221,216,216 );
	gfx.PutPixel( 108 + x,77 + y,209,48,48 );
	gfx.PutPixel( 109 + x,77 + y,208,30,30 );
	gfx.PutPixel( 110 + x,77 + y,208,34,34 );
	gfx.PutPixel( 111 + x,77 + y,208,34,34 );
	gfx.PutPixel( 112 + x,77 + y,208,34,34 );
	gfx.PutPixel( 113 + x,77 + y,208,34,34 );
	gfx.PutPixel( 114 + x,77 + y,208,34,34 );
	gfx.PutPixel( 115 + x,77 + y,208,34,34 );
	gfx.PutPixel( 116 + x,77 + y,208,34,34 );
	gfx.PutPixel( 117 + x,77 + y,208,34,34 );
	gfx.PutPixel( 118 + x,77 + y,208,34,34 );
	gfx.PutPixel( 119 + x,77 + y,208,34,34 );
	gfx.PutPixel( 120 + x,77 + y,208,34,34 );
	gfx.PutPixel( 121 + x,77 + y,208,34,34 );
	gfx.PutPixel( 122 + x,77 + y,208,34,34 );
	gfx.PutPixel( 123 + x,77 + y,208,34,34 );
	gfx.PutPixel( 124 + x,77 + y,208,34,34 );
	gfx.PutPixel( 125 + x,77 + y,208,34,34 );
	gfx.PutPixel( 126 + x,77 + y,208,34,34 );
	gfx.PutPixel( 127 + x,77 + y,208,34,34 );
	gfx.PutPixel( 128 + x,77 + y,208,34,34 );
	gfx.PutPixel( 129 + x,77 + y,208,34,34 );
	gfx.PutPixel( 130 + x,77 + y,208,34,34 );
	gfx.PutPixel( 131 + x,77 + y,208,34,34 );
	gfx.PutPixel( 132 + x,77 + y,208,34,34 );
	gfx.PutPixel( 133 + x,77 + y,208,34,34 );
	gfx.PutPixel( 134 + x,77 + y,208,34,34 );
	gfx.PutPixel( 135 + x,77 + y,208,34,34 );
	gfx.PutPixel( 136 + x,77 + y,208,34,34 );
	gfx.PutPixel( 137 + x,77 + y,208,34,34 );
	gfx.PutPixel( 138 + x,77 + y,208,34,34 );
	gfx.PutPixel( 139 + x,77 + y,208,34,34 );
	gfx.PutPixel( 140 + x,77 + y,208,34,34 );
	gfx.PutPixel( 141 + x,77 + y,208,34,34 );
	gfx.PutPixel( 142 + x,77 + y,208,34,34 );
	gfx.PutPixel( 143 + x,77 + y,208,34,34 );
	gfx.PutPixel( 144 + x,77 + y,208,34,34 );
	gfx.PutPixel( 145 + x,77 + y,208,34,34 );
	gfx.PutPixel( 146 + x,77 + y,208,34,34 );
	gfx.PutPixel( 147 + x,77 + y,208,34,34 );
	gfx.PutPixel( 148 + x,77 + y,208,34,34 );
	gfx.PutPixel( 149 + x,77 + y,208,34,34 );
	gfx.PutPixel( 0 + x,78 + y,208,34,34 );
	gfx.PutPixel( 1 + x,78 + y,208,34,34 );
	gfx.PutPixel( 2 + x,78 + y,208,34,34 );
	gfx.PutPixel( 3 + x,78 + y,208,34,34 );
	gfx.PutPixel( 4 + x,78 + y,208,34,34 );
	gfx.PutPixel( 5 + x,78 + y,208,34,34 );
	gfx.PutPixel( 6 + x,78 + y,208,34,34 );
	gfx.PutPixel( 7 + x,78 + y,208,34,34 );
	gfx.PutPixel( 8 + x,78 + y,208,34,34 );
	gfx.PutPixel( 9 + x,78 + y,208,34,34 );
	gfx.PutPixel( 10 + x,78 + y,208,34,34 );
	gfx.PutPixel( 11 + x,78 + y,208,34,34 );
	gfx.PutPixel( 12 + x,78 + y,208,34,34 );
	gfx.PutPixel( 13 + x,78 + y,208,34,34 );
	gfx.PutPixel( 14 + x,78 + y,208,34,34 );
	gfx.PutPixel( 15 + x,78 + y,208,34,34 );
	gfx.PutPixel( 16 + x,78 + y,208,34,34 );
	gfx.PutPixel( 17 + x,78 + y,208,34,34 );
	gfx.PutPixel( 18 + x,78 + y,208,34,34 );
	gfx.PutPixel( 19 + x,78 + y,208,34,34 );
	gfx.PutPixel( 20 + x,78 + y,208,34,34 );
	gfx.PutPixel( 21 + x,78 + y,208,34,34 );
	gfx.PutPixel( 22 + x,78 + y,208,34,34 );
	gfx.PutPixel( 23 + x,78 + y,208,34,34 );
	gfx.PutPixel( 24 + x,78 + y,208,34,34 );
	gfx.PutPixel( 25 + x,78 + y,208,34,34 );
	gfx.PutPixel( 26 + x,78 + y,208,34,34 );
	gfx.PutPixel( 27 + x,78 + y,208,34,34 );
	gfx.PutPixel( 28 + x,78 + y,208,34,34 );
	gfx.PutPixel( 29 + x,78 + y,208,34,34 );
	gfx.PutPixel( 30 + x,78 + y,208,34,34 );
	gfx.PutPixel( 31 + x,78 + y,208,34,34 );
	gfx.PutPixel( 32 + x,78 + y,208,34,34 );
	gfx.PutPixel( 33 + x,78 + y,208,34,34 );
	gfx.PutPixel( 34 + x,78 + y,208,34,34 );
	gfx.PutPixel( 35 + x,78 + y,208,34,34 );
	gfx.PutPixel( 36 + x,78 + y,208,34,34 );
	gfx.PutPixel( 37 + x,78 + y,208,34,34 );
	gfx.PutPixel( 38 + x,78 + y,208,34,34 );
	gfx.PutPixel( 39 + x,78 + y,208,34,34 );
	gfx.PutPixel( 40 + x,78 + y,208,34,34 );
	gfx.PutPixel( 41 + x,78 + y,208,29,29 );
	gfx.PutPixel( 42 + x,78 + y,209,44,44 );
	gfx.PutPixel( 43 + x,78 + y,218,184,184 );
	gfx.PutPixel( 44 + x,78 + y,222,235,235 );
	gfx.PutPixel( 45 + x,78 + y,221,222,222 );
	gfx.PutPixel( 46 + x,78 + y,221,221,221 );
	gfx.PutPixel( 47 + x,78 + y,222,229,229 );
	gfx.PutPixel( 48 + x,78 + y,222,231,231 );
	gfx.PutPixel( 49 + x,78 + y,221,228,228 );
	gfx.PutPixel( 50 + x,78 + y,222,230,230 );
	gfx.PutPixel( 51 + x,78 + y,222,231,231 );
	gfx.PutPixel( 52 + x,78 + y,221,222,222 );
	gfx.PutPixel( 53 + x,78 + y,221,225,225 );
	gfx.PutPixel( 54 + x,78 + y,222,235,235 );
	gfx.PutPixel( 55 + x,78 + y,213,113,113 );
	gfx.PutPixel( 56 + x,78 + y,207,25,25 );
	gfx.PutPixel( 57 + x,78 + y,208,34,34 );
	gfx.PutPixel( 58 + x,78 + y,208,34,34 );
	gfx.PutPixel( 59 + x,78 + y,208,34,34 );
	gfx.PutPixel( 60 + x,78 + y,208,34,34 );
	gfx.PutPixel( 61 + x,78 + y,207,27,27 );
	gfx.PutPixel( 62 + x,78 + y,210,68,68 );
	gfx.PutPixel( 63 + x,78 + y,221,221,221 );
	gfx.PutPixel( 64 + x,78 + y,221,223,223 );
	gfx.PutPixel( 65 + x,78 + y,221,221,221 );
	gfx.PutPixel( 66 + x,78 + y,221,227,227 );
	gfx.PutPixel( 67 + x,78 + y,219,193,193 );
	gfx.PutPixel( 68 + x,78 + y,208,37,37 );
	gfx.PutPixel( 69 + x,78 + y,208,32,32 );
	gfx.PutPixel( 70 + x,78 + y,208,34,34 );
	gfx.PutPixel( 71 + x,78 + y,208,34,34 );
	gfx.PutPixel( 72 + x,78 + y,208,34,34 );
	gfx.PutPixel( 73 + x,78 + y,208,34,34 );
	gfx.PutPixel( 74 + x,78 + y,208,34,34 );
	gfx.PutPixel( 75 + x,78 + y,208,27,27 );
	gfx.PutPixel( 76 + x,78 + y,218,173,173 );
	gfx.PutPixel( 77 + x,78 + y,222,230,230 );
	gfx.PutPixel( 78 + x,78 + y,222,230,230 );
	gfx.PutPixel( 79 + x,78 + y,218,173,173 );
	gfx.PutPixel( 80 + x,78 + y,208,27,27 );
	gfx.PutPixel( 81 + x,78 + y,208,34,34 );
	gfx.PutPixel( 82 + x,78 + y,208,34,34 );
	gfx.PutPixel( 83 + x,78 + y,208,34,34 );
	gfx.PutPixel( 84 + x,78 + y,208,34,34 );
	gfx.PutPixel( 85 + x,78 + y,208,34,34 );
	gfx.PutPixel( 86 + x,78 + y,208,34,34 );
	gfx.PutPixel( 87 + x,78 + y,208,30,30 );
	gfx.PutPixel( 88 + x,78 + y,209,47,47 );
	gfx.PutPixel( 89 + x,78 + y,220,208,208 );
	gfx.PutPixel( 90 + x,78 + y,221,225,225 );
	gfx.PutPixel( 91 + x,78 + y,221,221,221 );
	gfx.PutPixel( 92 + x,78 + y,221,221,221 );
	gfx.PutPixel( 93 + x,78 + y,221,221,221 );
	gfx.PutPixel( 94 + x,78 + y,222,232,232 );
	gfx.PutPixel( 95 + x,78 + y,213,109,109 );
	gfx.PutPixel( 96 + x,78 + y,207,23,23 );
	gfx.PutPixel( 97 + x,78 + y,208,34,34 );
	gfx.PutPixel( 98 + x,78 + y,208,34,34 );
	gfx.PutPixel( 99 + x,78 + y,208,34,34 );
	gfx.PutPixel( 100 + x,78 + y,207,23,23 );
	gfx.PutPixel( 101 + x,78 + y,212,104,104 );
	gfx.PutPixel( 102 + x,78 + y,222,231,231 );
	gfx.PutPixel( 103 + x,78 + y,221,221,221 );
	gfx.PutPixel( 104 + x,78 + y,221,221,221 );
	gfx.PutPixel( 105 + x,78 + y,221,221,221 );
	gfx.PutPixel( 106 + x,78 + y,221,225,225 );
	gfx.PutPixel( 107 + x,78 + y,220,208,208 );
	gfx.PutPixel( 108 + x,78 + y,209,47,47 );
	gfx.PutPixel( 109 + x,78 + y,208,30,30 );
	gfx.PutPixel( 110 + x,78 + y,208,34,34 );
	gfx.PutPixel( 111 + x,78 + y,208,34,34 );
	gfx.PutPixel( 112 + x,78 + y,208,34,34 );
	gfx.PutPixel( 113 + x,78 + y,208,34,34 );
	gfx.PutPixel( 114 + x,78 + y,208,34,34 );
	gfx.PutPixel( 115 + x,78 + y,208,34,34 );
	gfx.PutPixel( 116 + x,78 + y,208,34,34 );
	gfx.PutPixel( 117 + x,78 + y,208,34,34 );
	gfx.PutPixel( 118 + x,78 + y,208,34,34 );
	gfx.PutPixel( 119 + x,78 + y,208,34,34 );
	gfx.PutPixel( 120 + x,78 + y,208,34,34 );
	gfx.PutPixel( 121 + x,78 + y,208,34,34 );
	gfx.PutPixel( 122 + x,78 + y,208,34,34 );
	gfx.PutPixel( 123 + x,78 + y,208,34,34 );
	gfx.PutPixel( 124 + x,78 + y,208,34,34 );
	gfx.PutPixel( 125 + x,78 + y,208,34,34 );
	gfx.PutPixel( 126 + x,78 + y,208,34,34 );
	gfx.PutPixel( 127 + x,78 + y,208,34,34 );
	gfx.PutPixel( 128 + x,78 + y,208,34,34 );
	gfx.PutPixel( 129 + x,78 + y,208,34,34 );
	gfx.PutPixel( 130 + x,78 + y,208,34,34 );
	gfx.PutPixel( 131 + x,78 + y,208,34,34 );
	gfx.PutPixel( 132 + x,78 + y,208,34,34 );
	gfx.PutPixel( 133 + x,78 + y,208,34,34 );
	gfx.PutPixel( 134 + x,78 + y,208,34,34 );
	gfx.PutPixel( 135 + x,78 + y,208,34,34 );
	gfx.PutPixel( 136 + x,78 + y,208,34,34 );
	gfx.PutPixel( 137 + x,78 + y,208,34,34 );
	gfx.PutPixel( 138 + x,78 + y,208,34,34 );
	gfx.PutPixel( 139 + x,78 + y,208,34,34 );
	gfx.PutPixel( 140 + x,78 + y,208,34,34 );
	gfx.PutPixel( 141 + x,78 + y,208,34,34 );
	gfx.PutPixel( 142 + x,78 + y,208,34,34 );
	gfx.PutPixel( 143 + x,78 + y,208,34,34 );
	gfx.PutPixel( 144 + x,78 + y,208,34,34 );
	gfx.PutPixel( 145 + x,78 + y,208,34,34 );
	gfx.PutPixel( 146 + x,78 + y,208,34,34 );
	gfx.PutPixel( 147 + x,78 + y,208,34,34 );
	gfx.PutPixel( 148 + x,78 + y,208,34,34 );
	gfx.PutPixel( 149 + x,78 + y,208,34,34 );
	gfx.PutPixel( 0 + x,79 + y,208,34,34 );
	gfx.PutPixel( 1 + x,79 + y,208,34,34 );
	gfx.PutPixel( 2 + x,79 + y,208,34,34 );
	gfx.PutPixel( 3 + x,79 + y,208,34,34 );
	gfx.PutPixel( 4 + x,79 + y,208,34,34 );
	gfx.PutPixel( 5 + x,79 + y,208,34,34 );
	gfx.PutPixel( 6 + x,79 + y,208,34,34 );
	gfx.PutPixel( 7 + x,79 + y,208,34,34 );
	gfx.PutPixel( 8 + x,79 + y,208,34,34 );
	gfx.PutPixel( 9 + x,79 + y,208,34,34 );
	gfx.PutPixel( 10 + x,79 + y,208,34,34 );
	gfx.PutPixel( 11 + x,79 + y,208,34,34 );
	gfx.PutPixel( 12 + x,79 + y,208,34,34 );
	gfx.PutPixel( 13 + x,79 + y,208,34,34 );
	gfx.PutPixel( 14 + x,79 + y,208,34,34 );
	gfx.PutPixel( 15 + x,79 + y,208,34,34 );
	gfx.PutPixel( 16 + x,79 + y,208,34,34 );
	gfx.PutPixel( 17 + x,79 + y,208,34,34 );
	gfx.PutPixel( 18 + x,79 + y,208,34,34 );
	gfx.PutPixel( 19 + x,79 + y,208,34,34 );
	gfx.PutPixel( 20 + x,79 + y,208,34,34 );
	gfx.PutPixel( 21 + x,79 + y,208,34,34 );
	gfx.PutPixel( 22 + x,79 + y,208,34,34 );
	gfx.PutPixel( 23 + x,79 + y,208,34,34 );
	gfx.PutPixel( 24 + x,79 + y,208,34,34 );
	gfx.PutPixel( 25 + x,79 + y,208,34,34 );
	gfx.PutPixel( 26 + x,79 + y,208,34,34 );
	gfx.PutPixel( 27 + x,79 + y,208,34,34 );
	gfx.PutPixel( 28 + x,79 + y,208,34,34 );
	gfx.PutPixel( 29 + x,79 + y,208,34,34 );
	gfx.PutPixel( 30 + x,79 + y,208,34,34 );
	gfx.PutPixel( 31 + x,79 + y,208,34,34 );
	gfx.PutPixel( 32 + x,79 + y,208,34,34 );
	gfx.PutPixel( 33 + x,79 + y,208,34,34 );
	gfx.PutPixel( 34 + x,79 + y,208,34,34 );
	gfx.PutPixel( 35 + x,79 + y,208,34,34 );
	gfx.PutPixel( 36 + x,79 + y,208,34,34 );
	gfx.PutPixel( 37 + x,79 + y,208,34,34 );
	gfx.PutPixel( 38 + x,79 + y,208,34,34 );
	gfx.PutPixel( 39 + x,79 + y,208,34,34 );
	gfx.PutPixel( 40 + x,79 + y,208,33,33 );
	gfx.PutPixel( 41 + x,79 + y,208,28,28 );
	gfx.PutPixel( 42 + x,79 + y,217,162,162 );
	gfx.PutPixel( 43 + x,79 + y,222,235,235 );
	gfx.PutPixel( 44 + x,79 + y,221,221,221 );
	gfx.PutPixel( 45 + x,79 + y,221,223,223 );
	gfx.PutPixel( 46 + x,79 + y,222,229,229 );
	gfx.PutPixel( 47 + x,79 + y,218,176,176 );
	gfx.PutPixel( 48 + x,79 + y,213,108,108 );
	gfx.PutPixel( 49 + x,79 + y,212,82,82 );
	gfx.PutPixel( 50 + x,79 + y,212,93,93 );
	gfx.PutPixel( 51 + x,79 + y,216,149,149 );
	gfx.PutPixel( 52 + x,79 + y,221,225,225 );
	gfx.PutPixel( 53 + x,79 + y,221,218,218 );
	gfx.PutPixel( 54 + x,79 + y,212,97,97 );
	gfx.PutPixel( 55 + x,79 + y,208,26,26 );
	gfx.PutPixel( 56 + x,79 + y,208,34,34 );
	gfx.PutPixel( 57 + x,79 + y,208,34,34 );
	gfx.PutPixel( 58 + x,79 + y,208,34,34 );
	gfx.PutPixel( 59 + x,79 + y,208,34,34 );
	gfx.PutPixel( 60 + x,79 + y,208,34,34 );
	gfx.PutPixel( 61 + x,79 + y,207,23,23 );
	gfx.PutPixel( 62 + x,79 + y,216,143,143 );
	gfx.PutPixel( 63 + x,79 + y,222,233,233 );
	gfx.PutPixel( 64 + x,79 + y,221,221,221 );
	gfx.PutPixel( 65 + x,79 + y,221,221,221 );
	gfx.PutPixel( 66 + x,79 + y,221,221,221 );
	gfx.PutPixel( 67 + x,79 + y,222,230,230 );
	gfx.PutPixel( 68 + x,79 + y,213,96,96 );
	gfx.PutPixel( 69 + x,79 + y,207,23,23 );
	gfx.PutPixel( 70 + x,79 + y,208,34,34 );
	gfx.PutPixel( 71 + x,79 + y,208,34,34 );
	gfx.PutPixel( 72 + x,79 + y,208,34,34 );
	gfx.PutPixel( 73 + x,79 + y,208,34,34 );
	gfx.PutPixel( 74 + x,79 + y,208,34,34 );
	gfx.PutPixel( 75 + x,79 + y,208,27,27 );
	gfx.PutPixel( 76 + x,79 + y,218,173,173 );
	gfx.PutPixel( 77 + x,79 + y,222,230,230 );
	gfx.PutPixel( 78 + x,79 + y,222,230,230 );
	gfx.PutPixel( 79 + x,79 + y,218,173,173 );
	gfx.PutPixel( 80 + x,79 + y,208,27,27 );
	gfx.PutPixel( 81 + x,79 + y,208,34,34 );
	gfx.PutPixel( 82 + x,79 + y,208,34,34 );
	gfx.PutPixel( 83 + x,79 + y,208,34,34 );
	gfx.PutPixel( 84 + x,79 + y,208,34,34 );
	gfx.PutPixel( 85 + x,79 + y,208,34,34 );
	gfx.PutPixel( 86 + x,79 + y,208,34,34 );
	gfx.PutPixel( 87 + x,79 + y,208,30,30 );
	gfx.PutPixel( 88 + x,79 + y,209,47,47 );
	gfx.PutPixel( 89 + x,79 + y,220,208,208 );
	gfx.PutPixel( 90 + x,79 + y,221,225,225 );
	gfx.PutPixel( 91 + x,79 + y,221,221,221 );
	gfx.PutPixel( 92 + x,79 + y,221,223,223 );
	gfx.PutPixel( 93 + x,79 + y,221,221,221 );
	gfx.PutPixel( 94 + x,79 + y,222,230,230 );
	gfx.PutPixel( 95 + x,79 + y,218,172,172 );
	gfx.PutPixel( 96 + x,79 + y,207,28,28 );
	gfx.PutPixel( 97 + x,79 + y,208,33,33 );
	gfx.PutPixel( 98 + x,79 + y,208,34,34 );
	gfx.PutPixel( 99 + x,79 + y,208,33,33 );
	gfx.PutPixel( 100 + x,79 + y,207,27,27 );
	gfx.PutPixel( 101 + x,79 + y,217,168,168 );
	gfx.PutPixel( 102 + x,79 + y,222,230,230 );
	gfx.PutPixel( 103 + x,79 + y,221,221,221 );
	gfx.PutPixel( 104 + x,79 + y,221,223,223 );
	gfx.PutPixel( 105 + x,79 + y,221,221,221 );
	gfx.PutPixel( 106 + x,79 + y,221,225,225 );
	gfx.PutPixel( 107 + x,79 + y,220,208,208 );
	gfx.PutPixel( 108 + x,79 + y,209,47,47 );
	gfx.PutPixel( 109 + x,79 + y,208,30,30 );
	gfx.PutPixel( 110 + x,79 + y,208,34,34 );
	gfx.PutPixel( 111 + x,79 + y,208,34,34 );
	gfx.PutPixel( 112 + x,79 + y,208,34,34 );
	gfx.PutPixel( 113 + x,79 + y,208,34,34 );
	gfx.PutPixel( 114 + x,79 + y,208,34,34 );
	gfx.PutPixel( 115 + x,79 + y,208,34,34 );
	gfx.PutPixel( 116 + x,79 + y,208,34,34 );
	gfx.PutPixel( 117 + x,79 + y,208,34,34 );
	gfx.PutPixel( 118 + x,79 + y,208,34,34 );
	gfx.PutPixel( 119 + x,79 + y,208,34,34 );
	gfx.PutPixel( 120 + x,79 + y,208,34,34 );
	gfx.PutPixel( 121 + x,79 + y,208,34,34 );
	gfx.PutPixel( 122 + x,79 + y,208,34,34 );
	gfx.PutPixel( 123 + x,79 + y,208,34,34 );
	gfx.PutPixel( 124 + x,79 + y,208,34,34 );
	gfx.PutPixel( 125 + x,79 + y,208,34,34 );
	gfx.PutPixel( 126 + x,79 + y,208,34,34 );
	gfx.PutPixel( 127 + x,79 + y,208,34,34 );
	gfx.PutPixel( 128 + x,79 + y,208,34,34 );
	gfx.PutPixel( 129 + x,79 + y,208,34,34 );
	gfx.PutPixel( 130 + x,79 + y,208,34,34 );
	gfx.PutPixel( 131 + x,79 + y,208,34,34 );
	gfx.PutPixel( 132 + x,79 + y,208,34,34 );
	gfx.PutPixel( 133 + x,79 + y,208,34,34 );
	gfx.PutPixel( 134 + x,79 + y,208,34,34 );
	gfx.PutPixel( 135 + x,79 + y,208,34,34 );
	gfx.PutPixel( 136 + x,79 + y,208,34,34 );
	gfx.PutPixel( 137 + x,79 + y,208,34,34 );
	gfx.PutPixel( 138 + x,79 + y,208,34,34 );
	gfx.PutPixel( 139 + x,79 + y,208,34,34 );
	gfx.PutPixel( 140 + x,79 + y,208,34,34 );
	gfx.PutPixel( 141 + x,79 + y,208,34,34 );
	gfx.PutPixel( 142 + x,79 + y,208,34,34 );
	gfx.PutPixel( 143 + x,79 + y,208,34,34 );
	gfx.PutPixel( 144 + x,79 + y,208,34,34 );
	gfx.PutPixel( 145 + x,79 + y,208,34,34 );
	gfx.PutPixel( 146 + x,79 + y,208,34,34 );
	gfx.PutPixel( 147 + x,79 + y,208,34,34 );
	gfx.PutPixel( 148 + x,79 + y,208,34,34 );
	gfx.PutPixel( 149 + x,79 + y,208,34,34 );
	gfx.PutPixel( 0 + x,80 + y,208,34,34 );
	gfx.PutPixel( 1 + x,80 + y,208,34,34 );
	gfx.PutPixel( 2 + x,80 + y,208,34,34 );
	gfx.PutPixel( 3 + x,80 + y,208,34,34 );
	gfx.PutPixel( 4 + x,80 + y,208,34,34 );
	gfx.PutPixel( 5 + x,80 + y,208,34,34 );
	gfx.PutPixel( 6 + x,80 + y,208,34,34 );
	gfx.PutPixel( 7 + x,80 + y,208,34,34 );
	gfx.PutPixel( 8 + x,80 + y,208,34,34 );
	gfx.PutPixel( 9 + x,80 + y,208,34,34 );
	gfx.PutPixel( 10 + x,80 + y,208,34,34 );
	gfx.PutPixel( 11 + x,80 + y,208,34,34 );
	gfx.PutPixel( 12 + x,80 + y,208,34,34 );
	gfx.PutPixel( 13 + x,80 + y,208,34,34 );
	gfx.PutPixel( 14 + x,80 + y,208,34,34 );
	gfx.PutPixel( 15 + x,80 + y,208,34,34 );
	gfx.PutPixel( 16 + x,80 + y,208,34,34 );
	gfx.PutPixel( 17 + x,80 + y,208,34,34 );
	gfx.PutPixel( 18 + x,80 + y,208,34,34 );
	gfx.PutPixel( 19 + x,80 + y,208,34,34 );
	gfx.PutPixel( 20 + x,80 + y,208,34,34 );
	gfx.PutPixel( 21 + x,80 + y,208,34,34 );
	gfx.PutPixel( 22 + x,80 + y,208,34,34 );
	gfx.PutPixel( 23 + x,80 + y,208,34,34 );
	gfx.PutPixel( 24 + x,80 + y,208,34,34 );
	gfx.PutPixel( 25 + x,80 + y,208,34,34 );
	gfx.PutPixel( 26 + x,80 + y,208,34,34 );
	gfx.PutPixel( 27 + x,80 + y,208,34,34 );
	gfx.PutPixel( 28 + x,80 + y,208,34,34 );
	gfx.PutPixel( 29 + x,80 + y,208,34,34 );
	gfx.PutPixel( 30 + x,80 + y,208,34,34 );
	gfx.PutPixel( 31 + x,80 + y,208,34,34 );
	gfx.PutPixel( 32 + x,80 + y,208,34,34 );
	gfx.PutPixel( 33 + x,80 + y,208,34,34 );
	gfx.PutPixel( 34 + x,80 + y,208,34,34 );
	gfx.PutPixel( 35 + x,80 + y,208,34,34 );
	gfx.PutPixel( 36 + x,80 + y,208,34,34 );
	gfx.PutPixel( 37 + x,80 + y,208,34,34 );
	gfx.PutPixel( 38 + x,80 + y,208,34,34 );
	gfx.PutPixel( 39 + x,80 + y,208,34,34 );
	gfx.PutPixel( 40 + x,80 + y,207,25,25 );
	gfx.PutPixel( 41 + x,80 + y,212,90,90 );
	gfx.PutPixel( 42 + x,80 + y,222,230,230 );
	gfx.PutPixel( 43 + x,80 + y,221,222,222 );
	gfx.PutPixel( 44 + x,80 + y,221,222,222 );
	gfx.PutPixel( 45 + x,80 + y,222,228,228 );
	gfx.PutPixel( 46 + x,80 + y,214,127,127 );
	gfx.PutPixel( 47 + x,80 + y,208,28,28 );
	gfx.PutPixel( 48 + x,80 + y,207,22,22 );
	gfx.PutPixel( 49 + x,80 + y,207,25,25 );
	gfx.PutPixel( 50 + x,80 + y,207,24,24 );
	gfx.PutPixel( 51 + x,80 + y,207,22,22 );
	gfx.PutPixel( 52 + x,80 + y,212,91,91 );
	gfx.PutPixel( 53 + x,80 + y,211,78,78 );
	gfx.PutPixel( 54 + x,80 + y,207,22,22 );
	gfx.PutPixel( 55 + x,80 + y,208,34,34 );
	gfx.PutPixel( 56 + x,80 + y,208,34,34 );
	gfx.PutPixel( 57 + x,80 + y,208,34,34 );
	gfx.PutPixel( 58 + x,80 + y,208,34,34 );
	gfx.PutPixel( 59 + x,80 + y,208,34,34 );
	gfx.PutPixel( 60 + x,80 + y,208,30,30 );
	gfx.PutPixel( 61 + x,80 + y,209,50,50 );
	gfx.PutPixel( 62 + x,80 + y,220,208,208 );
	gfx.PutPixel( 63 + x,80 + y,221,225,225 );
	gfx.PutPixel( 64 + x,80 + y,221,223,223 );
	gfx.PutPixel( 65 + x,80 + y,221,226,226 );
	gfx.PutPixel( 66 + x,80 + y,221,221,221 );
	gfx.PutPixel( 67 + x,80 + y,222,230,230 );
	gfx.PutPixel( 68 + x,80 + y,218,174,174 );
	gfx.PutPixel( 69 + x,80 + y,207,29,29 );
	gfx.PutPixel( 70 + x,80 + y,208,33,33 );
	gfx.PutPixel( 71 + x,80 + y,208,34,34 );
	gfx.PutPixel( 72 + x,80 + y,208,34,34 );
	gfx.PutPixel( 73 + x,80 + y,208,34,34 );
	gfx.PutPixel( 74 + x,80 + y,208,34,34 );
	gfx.PutPixel( 75 + x,80 + y,208,27,27 );
	gfx.PutPixel( 76 + x,80 + y,218,173,173 );
	gfx.PutPixel( 77 + x,80 + y,222,230,230 );
	gfx.PutPixel( 78 + x,80 + y,222,230,230 );
	gfx.PutPixel( 79 + x,80 + y,218,173,173 );
	gfx.PutPixel( 80 + x,80 + y,208,27,27 );
	gfx.PutPixel( 81 + x,80 + y,208,34,34 );
	gfx.PutPixel( 82 + x,80 + y,208,34,34 );
	gfx.PutPixel( 83 + x,80 + y,208,34,34 );
	gfx.PutPixel( 84 + x,80 + y,208,34,34 );
	gfx.PutPixel( 85 + x,80 + y,208,34,34 );
	gfx.PutPixel( 86 + x,80 + y,208,34,34 );
	gfx.PutPixel( 87 + x,80 + y,208,30,30 );
	gfx.PutPixel( 88 + x,80 + y,209,47,47 );
	gfx.PutPixel( 89 + x,80 + y,220,208,208 );
	gfx.PutPixel( 90 + x,80 + y,221,225,225 );
	gfx.PutPixel( 91 + x,80 + y,221,223,223 );
	gfx.PutPixel( 92 + x,80 + y,220,196,196 );
	gfx.PutPixel( 93 + x,80 + y,221,219,219 );
	gfx.PutPixel( 94 + x,80 + y,221,223,223 );
	gfx.PutPixel( 95 + x,80 + y,221,217,217 );
	gfx.PutPixel( 96 + x,80 + y,210,60,60 );
	gfx.PutPixel( 97 + x,80 + y,208,28,28 );
	gfx.PutPixel( 98 + x,80 + y,208,34,34 );
	gfx.PutPixel( 99 + x,80 + y,208,29,29 );
	gfx.PutPixel( 100 + x,80 + y,210,57,57 );
	gfx.PutPixel( 101 + x,80 + y,221,215,215 );
	gfx.PutPixel( 102 + x,80 + y,221,223,223 );
	gfx.PutPixel( 103 + x,80 + y,221,220,220 );
	gfx.PutPixel( 104 + x,80 + y,220,202,202 );
	gfx.PutPixel( 105 + x,80 + y,221,222,222 );
	gfx.PutPixel( 106 + x,80 + y,221,225,225 );
	gfx.PutPixel( 107 + x,80 + y,220,208,208 );
	gfx.PutPixel( 108 + x,80 + y,209,47,47 );
	gfx.PutPixel( 109 + x,80 + y,208,30,30 );
	gfx.PutPixel( 110 + x,80 + y,208,34,34 );
	gfx.PutPixel( 111 + x,80 + y,208,34,34 );
	gfx.PutPixel( 112 + x,80 + y,208,34,34 );
	gfx.PutPixel( 113 + x,80 + y,208,34,34 );
	gfx.PutPixel( 114 + x,80 + y,208,34,34 );
	gfx.PutPixel( 115 + x,80 + y,208,34,34 );
	gfx.PutPixel( 116 + x,80 + y,208,34,34 );
	gfx.PutPixel( 117 + x,80 + y,208,34,34 );
	gfx.PutPixel( 118 + x,80 + y,208,34,34 );
	gfx.PutPixel( 119 + x,80 + y,208,34,34 );
	gfx.PutPixel( 120 + x,80 + y,208,34,34 );
	gfx.PutPixel( 121 + x,80 + y,208,34,34 );
	gfx.PutPixel( 122 + x,80 + y,208,34,34 );
	gfx.PutPixel( 123 + x,80 + y,208,34,34 );
	gfx.PutPixel( 124 + x,80 + y,208,34,34 );
	gfx.PutPixel( 125 + x,80 + y,208,34,34 );
	gfx.PutPixel( 126 + x,80 + y,208,34,34 );
	gfx.PutPixel( 127 + x,80 + y,208,34,34 );
	gfx.PutPixel( 128 + x,80 + y,208,34,34 );
	gfx.PutPixel( 129 + x,80 + y,208,34,34 );
	gfx.PutPixel( 130 + x,80 + y,208,34,34 );
	gfx.PutPixel( 131 + x,80 + y,208,34,34 );
	gfx.PutPixel( 132 + x,80 + y,208,34,34 );
	gfx.PutPixel( 133 + x,80 + y,208,34,34 );
	gfx.PutPixel( 134 + x,80 + y,208,34,34 );
	gfx.PutPixel( 135 + x,80 + y,208,34,34 );
	gfx.PutPixel( 136 + x,80 + y,208,34,34 );
	gfx.PutPixel( 137 + x,80 + y,208,34,34 );
	gfx.PutPixel( 138 + x,80 + y,208,34,34 );
	gfx.PutPixel( 139 + x,80 + y,208,34,34 );
	gfx.PutPixel( 140 + x,80 + y,208,34,34 );
	gfx.PutPixel( 141 + x,80 + y,208,34,34 );
	gfx.PutPixel( 142 + x,80 + y,208,34,34 );
	gfx.PutPixel( 143 + x,80 + y,208,34,34 );
	gfx.PutPixel( 144 + x,80 + y,208,34,34 );
	gfx.PutPixel( 145 + x,80 + y,208,34,34 );
	gfx.PutPixel( 146 + x,80 + y,208,34,34 );
	gfx.PutPixel( 147 + x,80 + y,208,34,34 );
	gfx.PutPixel( 148 + x,80 + y,208,34,34 );
	gfx.PutPixel( 149 + x,80 + y,208,34,34 );
	gfx.PutPixel( 0 + x,81 + y,208,34,34 );
	gfx.PutPixel( 1 + x,81 + y,208,34,34 );
	gfx.PutPixel( 2 + x,81 + y,208,34,34 );
	gfx.PutPixel( 3 + x,81 + y,208,34,34 );
	gfx.PutPixel( 4 + x,81 + y,208,34,34 );
	gfx.PutPixel( 5 + x,81 + y,208,34,34 );
	gfx.PutPixel( 6 + x,81 + y,208,34,34 );
	gfx.PutPixel( 7 + x,81 + y,208,34,34 );
	gfx.PutPixel( 8 + x,81 + y,208,34,34 );
	gfx.PutPixel( 9 + x,81 + y,208,34,34 );
	gfx.PutPixel( 10 + x,81 + y,208,34,34 );
	gfx.PutPixel( 11 + x,81 + y,208,34,34 );
	gfx.PutPixel( 12 + x,81 + y,208,34,34 );
	gfx.PutPixel( 13 + x,81 + y,208,34,34 );
	gfx.PutPixel( 14 + x,81 + y,208,34,34 );
	gfx.PutPixel( 15 + x,81 + y,208,34,34 );
	gfx.PutPixel( 16 + x,81 + y,208,34,34 );
	gfx.PutPixel( 17 + x,81 + y,208,34,34 );
	gfx.PutPixel( 18 + x,81 + y,208,34,34 );
	gfx.PutPixel( 19 + x,81 + y,208,34,34 );
	gfx.PutPixel( 20 + x,81 + y,208,34,34 );
	gfx.PutPixel( 21 + x,81 + y,208,34,34 );
	gfx.PutPixel( 22 + x,81 + y,208,34,34 );
	gfx.PutPixel( 23 + x,81 + y,208,34,34 );
	gfx.PutPixel( 24 + x,81 + y,208,34,34 );
	gfx.PutPixel( 25 + x,81 + y,208,34,34 );
	gfx.PutPixel( 26 + x,81 + y,208,34,34 );
	gfx.PutPixel( 27 + x,81 + y,208,34,34 );
	gfx.PutPixel( 28 + x,81 + y,208,34,34 );
	gfx.PutPixel( 29 + x,81 + y,208,34,34 );
	gfx.PutPixel( 30 + x,81 + y,208,34,34 );
	gfx.PutPixel( 31 + x,81 + y,208,34,34 );
	gfx.PutPixel( 32 + x,81 + y,208,34,34 );
	gfx.PutPixel( 33 + x,81 + y,208,34,34 );
	gfx.PutPixel( 34 + x,81 + y,208,34,34 );
	gfx.PutPixel( 35 + x,81 + y,208,34,34 );
	gfx.PutPixel( 36 + x,81 + y,208,34,34 );
	gfx.PutPixel( 37 + x,81 + y,208,34,34 );
	gfx.PutPixel( 38 + x,81 + y,208,34,34 );
	gfx.PutPixel( 39 + x,81 + y,208,33,33 );
	gfx.PutPixel( 40 + x,81 + y,207,27,27 );
	gfx.PutPixel( 41 + x,81 + y,217,167,167 );
	gfx.PutPixel( 42 + x,81 + y,222,231,231 );
	gfx.PutPixel( 43 + x,81 + y,221,221,221 );
	gfx.PutPixel( 44 + x,81 + y,222,231,231 );
	gfx.PutPixel( 45 + x,81 + y,216,156,156 );
	gfx.PutPixel( 46 + x,81 + y,207,22,22 );
	gfx.PutPixel( 47 + x,81 + y,208,31,31 );
	gfx.PutPixel( 48 + x,81 + y,208,34,34 );
	gfx.PutPixel( 49 + x,81 + y,208,34,34 );
	gfx.PutPixel( 50 + x,81 + y,208,34,34 );
	gfx.PutPixel( 51 + x,81 + y,208,34,34 );
	gfx.PutPixel( 52 + x,81 + y,207,26,26 );
	gfx.PutPixel( 53 + x,81 + y,208,27,27 );
	gfx.PutPixel( 54 + x,81 + y,208,34,34 );
	gfx.PutPixel( 55 + x,81 + y,208,34,34 );
	gfx.PutPixel( 56 + x,81 + y,208,34,34 );
	gfx.PutPixel( 57 + x,81 + y,208,34,34 );
	gfx.PutPixel( 58 + x,81 + y,208,34,34 );
	gfx.PutPixel( 59 + x,81 + y,208,34,34 );
	gfx.PutPixel( 60 + x,81 + y,207,22,22 );
	gfx.PutPixel( 61 + x,81 + y,214,118,118 );
	gfx.PutPixel( 62 + x,81 + y,222,233,233 );
	gfx.PutPixel( 63 + x,81 + y,221,222,222 );
	gfx.PutPixel( 64 + x,81 + y,220,211,211 );
	gfx.PutPixel( 65 + x,81 + y,219,184,184 );
	gfx.PutPixel( 66 + x,81 + y,221,226,226 );
	gfx.PutPixel( 67 + x,81 + y,221,222,222 );
	gfx.PutPixel( 68 + x,81 + y,221,224,224 );
	gfx.PutPixel( 69 + x,81 + y,211,74,74 );
	gfx.PutPixel( 70 + x,81 + y,207,26,26 );
	gfx.PutPixel( 71 + x,81 + y,208,34,34 );
	gfx.PutPixel( 72 + x,81 + y,208,34,34 );
	gfx.PutPixel( 73 + x,81 + y,208,34,34 );
	gfx.PutPixel( 74 + x,81 + y,208,34,34 );
	gfx.PutPixel( 75 + x,81 + y,208,27,27 );
	gfx.PutPixel( 76 + x,81 + y,218,173,173 );
	gfx.PutPixel( 77 + x,81 + y,222,230,230 );
	gfx.PutPixel( 78 + x,81 + y,222,230,230 );
	gfx.PutPixel( 79 + x,81 + y,218,173,173 );
	gfx.PutPixel( 80 + x,81 + y,208,27,27 );
	gfx.PutPixel( 81 + x,81 + y,208,34,34 );
	gfx.PutPixel( 82 + x,81 + y,208,34,34 );
	gfx.PutPixel( 83 + x,81 + y,208,34,34 );
	gfx.PutPixel( 84 + x,81 + y,208,34,34 );
	gfx.PutPixel( 85 + x,81 + y,208,34,34 );
	gfx.PutPixel( 86 + x,81 + y,208,34,34 );
	gfx.PutPixel( 87 + x,81 + y,208,30,30 );
	gfx.PutPixel( 88 + x,81 + y,209,47,47 );
	gfx.PutPixel( 89 + x,81 + y,220,208,208 );
	gfx.PutPixel( 90 + x,81 + y,221,225,225 );
	gfx.PutPixel( 91 + x,81 + y,222,229,229 );
	gfx.PutPixel( 92 + x,81 + y,216,143,143 );
	gfx.PutPixel( 93 + x,81 + y,219,197,197 );
	gfx.PutPixel( 94 + x,81 + y,221,225,225 );
	gfx.PutPixel( 95 + x,81 + y,222,233,233 );
	gfx.PutPixel( 96 + x,81 + y,214,119,119 );
	gfx.PutPixel( 97 + x,81 + y,207,22,22 );
	gfx.PutPixel( 98 + x,81 + y,208,34,34 );
	gfx.PutPixel( 99 + x,81 + y,207,22,22 );
	gfx.PutPixel( 100 + x,81 + y,213,114,114 );
	gfx.PutPixel( 101 + x,81 + y,222,232,232 );
	gfx.PutPixel( 102 + x,81 + y,221,224,224 );
	gfx.PutPixel( 103 + x,81 + y,220,200,200 );
	gfx.PutPixel( 104 + x,81 + y,216,148,148 );
	gfx.PutPixel( 105 + x,81 + y,222,229,229 );
	gfx.PutPixel( 106 + x,81 + y,221,225,225 );
	gfx.PutPixel( 107 + x,81 + y,220,208,208 );
	gfx.PutPixel( 108 + x,81 + y,209,47,47 );
	gfx.PutPixel( 109 + x,81 + y,208,30,30 );
	gfx.PutPixel( 110 + x,81 + y,208,34,34 );
	gfx.PutPixel( 111 + x,81 + y,208,34,34 );
	gfx.PutPixel( 112 + x,81 + y,208,34,34 );
	gfx.PutPixel( 113 + x,81 + y,208,34,34 );
	gfx.PutPixel( 114 + x,81 + y,208,34,34 );
	gfx.PutPixel( 115 + x,81 + y,208,34,34 );
	gfx.PutPixel( 116 + x,81 + y,208,34,34 );
	gfx.PutPixel( 117 + x,81 + y,208,34,34 );
	gfx.PutPixel( 118 + x,81 + y,208,34,34 );
	gfx.PutPixel( 119 + x,81 + y,208,34,34 );
	gfx.PutPixel( 120 + x,81 + y,208,34,34 );
	gfx.PutPixel( 121 + x,81 + y,208,34,34 );
	gfx.PutPixel( 122 + x,81 + y,208,34,34 );
	gfx.PutPixel( 123 + x,81 + y,208,34,34 );
	gfx.PutPixel( 124 + x,81 + y,208,34,34 );
	gfx.PutPixel( 125 + x,81 + y,208,34,34 );
	gfx.PutPixel( 126 + x,81 + y,208,34,34 );
	gfx.PutPixel( 127 + x,81 + y,208,34,34 );
	gfx.PutPixel( 128 + x,81 + y,208,34,34 );
	gfx.PutPixel( 129 + x,81 + y,208,34,34 );
	gfx.PutPixel( 130 + x,81 + y,208,34,34 );
	gfx.PutPixel( 131 + x,81 + y,208,34,34 );
	gfx.PutPixel( 132 + x,81 + y,208,34,34 );
	gfx.PutPixel( 133 + x,81 + y,208,34,34 );
	gfx.PutPixel( 134 + x,81 + y,208,34,34 );
	gfx.PutPixel( 135 + x,81 + y,208,34,34 );
	gfx.PutPixel( 136 + x,81 + y,208,34,34 );
	gfx.PutPixel( 137 + x,81 + y,208,34,34 );
	gfx.PutPixel( 138 + x,81 + y,208,34,34 );
	gfx.PutPixel( 139 + x,81 + y,208,34,34 );
	gfx.PutPixel( 140 + x,81 + y,208,34,34 );
	gfx.PutPixel( 141 + x,81 + y,208,34,34 );
	gfx.PutPixel( 142 + x,81 + y,208,34,34 );
	gfx.PutPixel( 143 + x,81 + y,208,34,34 );
	gfx.PutPixel( 144 + x,81 + y,208,34,34 );
	gfx.PutPixel( 145 + x,81 + y,208,34,34 );
	gfx.PutPixel( 146 + x,81 + y,208,34,34 );
	gfx.PutPixel( 147 + x,81 + y,208,34,34 );
	gfx.PutPixel( 148 + x,81 + y,208,34,34 );
	gfx.PutPixel( 149 + x,81 + y,208,34,34 );
	gfx.PutPixel( 0 + x,82 + y,208,34,34 );
	gfx.PutPixel( 1 + x,82 + y,208,34,34 );
	gfx.PutPixel( 2 + x,82 + y,208,34,34 );
	gfx.PutPixel( 3 + x,82 + y,208,34,34 );
	gfx.PutPixel( 4 + x,82 + y,208,34,34 );
	gfx.PutPixel( 5 + x,82 + y,208,34,34 );
	gfx.PutPixel( 6 + x,82 + y,208,34,34 );
	gfx.PutPixel( 7 + x,82 + y,208,34,34 );
	gfx.PutPixel( 8 + x,82 + y,208,34,34 );
	gfx.PutPixel( 9 + x,82 + y,208,34,34 );
	gfx.PutPixel( 10 + x,82 + y,208,34,34 );
	gfx.PutPixel( 11 + x,82 + y,208,34,34 );
	gfx.PutPixel( 12 + x,82 + y,208,34,34 );
	gfx.PutPixel( 13 + x,82 + y,208,34,34 );
	gfx.PutPixel( 14 + x,82 + y,208,34,34 );
	gfx.PutPixel( 15 + x,82 + y,208,34,34 );
	gfx.PutPixel( 16 + x,82 + y,208,34,34 );
	gfx.PutPixel( 17 + x,82 + y,208,34,34 );
	gfx.PutPixel( 18 + x,82 + y,208,34,34 );
	gfx.PutPixel( 19 + x,82 + y,208,34,34 );
	gfx.PutPixel( 20 + x,82 + y,208,34,34 );
	gfx.PutPixel( 21 + x,82 + y,208,34,34 );
	gfx.PutPixel( 22 + x,82 + y,208,34,34 );
	gfx.PutPixel( 23 + x,82 + y,208,34,34 );
	gfx.PutPixel( 24 + x,82 + y,208,34,34 );
	gfx.PutPixel( 25 + x,82 + y,208,34,34 );
	gfx.PutPixel( 26 + x,82 + y,208,34,34 );
	gfx.PutPixel( 27 + x,82 + y,208,34,34 );
	gfx.PutPixel( 28 + x,82 + y,208,34,34 );
	gfx.PutPixel( 29 + x,82 + y,208,34,34 );
	gfx.PutPixel( 30 + x,82 + y,208,34,34 );
	gfx.PutPixel( 31 + x,82 + y,208,34,34 );
	gfx.PutPixel( 32 + x,82 + y,208,34,34 );
	gfx.PutPixel( 33 + x,82 + y,208,34,34 );
	gfx.PutPixel( 34 + x,82 + y,208,34,34 );
	gfx.PutPixel( 35 + x,82 + y,208,34,34 );
	gfx.PutPixel( 36 + x,82 + y,208,34,34 );
	gfx.PutPixel( 37 + x,82 + y,208,34,34 );
	gfx.PutPixel( 38 + x,82 + y,208,34,34 );
	gfx.PutPixel( 39 + x,82 + y,208,30,30 );
	gfx.PutPixel( 40 + x,82 + y,209,49,49 );
	gfx.PutPixel( 41 + x,82 + y,220,208,208 );
	gfx.PutPixel( 42 + x,82 + y,221,225,225 );
	gfx.PutPixel( 43 + x,82 + y,221,223,223 );
	gfx.PutPixel( 44 + x,82 + y,221,220,220 );
	gfx.PutPixel( 45 + x,82 + y,210,67,67 );
	gfx.PutPixel( 46 + x,82 + y,207,26,26 );
	gfx.PutPixel( 47 + x,82 + y,208,34,34 );
	gfx.PutPixel( 48 + x,82 + y,208,34,34 );
	gfx.PutPixel( 49 + x,82 + y,208,34,34 );
	gfx.PutPixel( 50 + x,82 + y,208,34,34 );
	gfx.PutPixel( 51 + x,82 + y,208,34,34 );
	gfx.PutPixel( 52 + x,82 + y,208,34,34 );
	gfx.PutPixel( 53 + x,82 + y,208,34,34 );
	gfx.PutPixel( 54 + x,82 + y,208,34,34 );
	gfx.PutPixel( 55 + x,82 + y,208,34,34 );
	gfx.PutPixel( 56 + x,82 + y,208,34,34 );
	gfx.PutPixel( 57 + x,82 + y,208,34,34 );
	gfx.PutPixel( 58 + x,82 + y,208,34,34 );
	gfx.PutPixel( 59 + x,82 + y,208,32,32 );
	gfx.PutPixel( 60 + x,82 + y,208,36,36 );
	gfx.PutPixel( 61 + x,82 + y,219,192,192 );
	gfx.PutPixel( 62 + x,82 + y,221,227,227 );
	gfx.PutPixel( 63 + x,82 + y,222,230,230 );
	gfx.PutPixel( 64 + x,82 + y,217,165,165 );
	gfx.PutPixel( 65 + x,82 + y,211,76,76 );
	gfx.PutPixel( 66 + x,82 + y,221,225,225 );
	gfx.PutPixel( 67 + x,82 + y,221,222,222 );
	gfx.PutPixel( 68 + x,82 + y,222,232,232 );
	gfx.PutPixel( 69 + x,82 + y,216,152,152 );
	gfx.PutPixel( 70 + x,82 + y,207,24,24 );
	gfx.PutPixel( 71 + x,82 + y,208,34,34 );
	gfx.PutPixel( 72 + x,82 + y,208,34,34 );
	gfx.PutPixel( 73 + x,82 + y,208,34,34 );
	gfx.PutPixel( 74 + x,82 + y,208,34,34 );
	gfx.PutPixel( 75 + x,82 + y,208,27,27 );
	gfx.PutPixel( 76 + x,82 + y,218,173,173 );
	gfx.PutPixel( 77 + x,82 + y,222,230,230 );
	gfx.PutPixel( 78 + x,82 + y,222,230,230 );
	gfx.PutPixel( 79 + x,82 + y,218,173,173 );
	gfx.PutPixel( 80 + x,82 + y,208,27,27 );
	gfx.PutPixel( 81 + x,82 + y,208,34,34 );
	gfx.PutPixel( 82 + x,82 + y,208,34,34 );
	gfx.PutPixel( 83 + x,82 + y,208,34,34 );
	gfx.PutPixel( 84 + x,82 + y,208,34,34 );
	gfx.PutPixel( 85 + x,82 + y,208,34,34 );
	gfx.PutPixel( 86 + x,82 + y,208,34,34 );
	gfx.PutPixel( 87 + x,82 + y,208,30,30 );
	gfx.PutPixel( 88 + x,82 + y,209,47,47 );
	gfx.PutPixel( 89 + x,82 + y,220,208,208 );
	gfx.PutPixel( 90 + x,82 + y,221,225,225 );
	gfx.PutPixel( 91 + x,82 + y,222,233,233 );
	gfx.PutPixel( 92 + x,82 + y,214,118,118 );
	gfx.PutPixel( 93 + x,82 + y,216,147,147 );
	gfx.PutPixel( 94 + x,82 + y,222,231,231 );
	gfx.PutPixel( 95 + x,82 + y,222,229,229 );
	gfx.PutPixel( 96 + x,82 + y,218,181,181 );
	gfx.PutPixel( 97 + x,82 + y,208,31,31 );
	gfx.PutPixel( 98 + x,82 + y,208,32,32 );
	gfx.PutPixel( 99 + x,82 + y,208,29,29 );
	gfx.PutPixel( 100 + x,82 + y,218,176,176 );
	gfx.PutPixel( 101 + x,82 + y,222,229,229 );
	gfx.PutPixel( 102 + x,82 + y,222,231,231 );
	gfx.PutPixel( 103 + x,82 + y,216,151,151 );
	gfx.PutPixel( 104 + x,82 + y,214,119,119 );
	gfx.PutPixel( 105 + x,82 + y,222,233,233 );
	gfx.PutPixel( 106 + x,82 + y,221,225,225 );
	gfx.PutPixel( 107 + x,82 + y,220,208,208 );
	gfx.PutPixel( 108 + x,82 + y,209,47,47 );
	gfx.PutPixel( 109 + x,82 + y,208,30,30 );
	gfx.PutPixel( 110 + x,82 + y,208,34,34 );
	gfx.PutPixel( 111 + x,82 + y,208,34,34 );
	gfx.PutPixel( 112 + x,82 + y,208,34,34 );
	gfx.PutPixel( 113 + x,82 + y,208,34,34 );
	gfx.PutPixel( 114 + x,82 + y,208,34,34 );
	gfx.PutPixel( 115 + x,82 + y,208,34,34 );
	gfx.PutPixel( 116 + x,82 + y,208,34,34 );
	gfx.PutPixel( 117 + x,82 + y,208,34,34 );
	gfx.PutPixel( 118 + x,82 + y,208,34,34 );
	gfx.PutPixel( 119 + x,82 + y,208,34,34 );
	gfx.PutPixel( 120 + x,82 + y,208,34,34 );
	gfx.PutPixel( 121 + x,82 + y,208,34,34 );
	gfx.PutPixel( 122 + x,82 + y,208,34,34 );
	gfx.PutPixel( 123 + x,82 + y,208,34,34 );
	gfx.PutPixel( 124 + x,82 + y,208,34,34 );
	gfx.PutPixel( 125 + x,82 + y,208,34,34 );
	gfx.PutPixel( 126 + x,82 + y,208,34,34 );
	gfx.PutPixel( 127 + x,82 + y,208,34,34 );
	gfx.PutPixel( 128 + x,82 + y,208,34,34 );
	gfx.PutPixel( 129 + x,82 + y,208,34,34 );
	gfx.PutPixel( 130 + x,82 + y,208,34,34 );
	gfx.PutPixel( 131 + x,82 + y,208,34,34 );
	gfx.PutPixel( 132 + x,82 + y,208,34,34 );
	gfx.PutPixel( 133 + x,82 + y,208,34,34 );
	gfx.PutPixel( 134 + x,82 + y,208,34,34 );
	gfx.PutPixel( 135 + x,82 + y,208,34,34 );
	gfx.PutPixel( 136 + x,82 + y,208,34,34 );
	gfx.PutPixel( 137 + x,82 + y,208,34,34 );
	gfx.PutPixel( 138 + x,82 + y,208,34,34 );
	gfx.PutPixel( 139 + x,82 + y,208,34,34 );
	gfx.PutPixel( 140 + x,82 + y,208,34,34 );
	gfx.PutPixel( 141 + x,82 + y,208,34,34 );
	gfx.PutPixel( 142 + x,82 + y,208,34,34 );
	gfx.PutPixel( 143 + x,82 + y,208,34,34 );
	gfx.PutPixel( 144 + x,82 + y,208,34,34 );
	gfx.PutPixel( 145 + x,82 + y,208,34,34 );
	gfx.PutPixel( 146 + x,82 + y,208,34,34 );
	gfx.PutPixel( 147 + x,82 + y,208,34,34 );
	gfx.PutPixel( 148 + x,82 + y,208,34,34 );
	gfx.PutPixel( 149 + x,82 + y,208,34,34 );
	gfx.PutPixel( 0 + x,83 + y,208,34,34 );
	gfx.PutPixel( 1 + x,83 + y,208,34,34 );
	gfx.PutPixel( 2 + x,83 + y,208,34,34 );
	gfx.PutPixel( 3 + x,83 + y,208,34,34 );
	gfx.PutPixel( 4 + x,83 + y,208,34,34 );
	gfx.PutPixel( 5 + x,83 + y,208,34,34 );
	gfx.PutPixel( 6 + x,83 + y,208,34,34 );
	gfx.PutPixel( 7 + x,83 + y,208,34,34 );
	gfx.PutPixel( 8 + x,83 + y,208,34,34 );
	gfx.PutPixel( 9 + x,83 + y,208,34,34 );
	gfx.PutPixel( 10 + x,83 + y,208,34,34 );
	gfx.PutPixel( 11 + x,83 + y,208,34,34 );
	gfx.PutPixel( 12 + x,83 + y,208,34,34 );
	gfx.PutPixel( 13 + x,83 + y,208,34,34 );
	gfx.PutPixel( 14 + x,83 + y,208,34,34 );
	gfx.PutPixel( 15 + x,83 + y,208,34,34 );
	gfx.PutPixel( 16 + x,83 + y,208,34,34 );
	gfx.PutPixel( 17 + x,83 + y,208,34,34 );
	gfx.PutPixel( 18 + x,83 + y,208,34,34 );
	gfx.PutPixel( 19 + x,83 + y,208,34,34 );
	gfx.PutPixel( 20 + x,83 + y,208,34,34 );
	gfx.PutPixel( 21 + x,83 + y,208,34,34 );
	gfx.PutPixel( 22 + x,83 + y,208,34,34 );
	gfx.PutPixel( 23 + x,83 + y,208,34,34 );
	gfx.PutPixel( 24 + x,83 + y,208,34,34 );
	gfx.PutPixel( 25 + x,83 + y,208,34,34 );
	gfx.PutPixel( 26 + x,83 + y,208,34,34 );
	gfx.PutPixel( 27 + x,83 + y,208,34,34 );
	gfx.PutPixel( 28 + x,83 + y,208,34,34 );
	gfx.PutPixel( 29 + x,83 + y,208,34,34 );
	gfx.PutPixel( 30 + x,83 + y,208,34,34 );
	gfx.PutPixel( 31 + x,83 + y,208,34,34 );
	gfx.PutPixel( 32 + x,83 + y,208,34,34 );
	gfx.PutPixel( 33 + x,83 + y,208,34,34 );
	gfx.PutPixel( 34 + x,83 + y,208,34,34 );
	gfx.PutPixel( 35 + x,83 + y,208,34,34 );
	gfx.PutPixel( 36 + x,83 + y,208,34,34 );
	gfx.PutPixel( 37 + x,83 + y,208,34,34 );
	gfx.PutPixel( 38 + x,83 + y,208,34,34 );
	gfx.PutPixel( 39 + x,83 + y,208,27,27 );
	gfx.PutPixel( 40 + x,83 + y,211,72,72 );
	gfx.PutPixel( 41 + x,83 + y,221,222,222 );
	gfx.PutPixel( 42 + x,83 + y,221,222,222 );
	gfx.PutPixel( 43 + x,83 + y,221,227,227 );
	gfx.PutPixel( 44 + x,83 + y,219,189,189 );
	gfx.PutPixel( 45 + x,83 + y,208,35,35 );
	gfx.PutPixel( 46 + x,83 + y,208,32,32 );
	gfx.PutPixel( 47 + x,83 + y,208,34,34 );
	gfx.PutPixel( 48 + x,83 + y,208,34,34 );
	gfx.PutPixel( 49 + x,83 + y,208,34,34 );
	gfx.PutPixel( 50 + x,83 + y,208,34,34 );
	gfx.PutPixel( 51 + x,83 + y,208,34,34 );
	gfx.PutPixel( 52 + x,83 + y,208,34,34 );
	gfx.PutPixel( 53 + x,83 + y,208,34,34 );
	gfx.PutPixel( 54 + x,83 + y,208,34,34 );
	gfx.PutPixel( 55 + x,83 + y,208,34,34 );
	gfx.PutPixel( 56 + x,83 + y,208,34,34 );
	gfx.PutPixel( 57 + x,83 + y,208,34,34 );
	gfx.PutPixel( 58 + x,83 + y,208,34,34 );
	gfx.PutPixel( 59 + x,83 + y,207,24,24 );
	gfx.PutPixel( 60 + x,83 + y,212,93,93 );
	gfx.PutPixel( 61 + x,83 + y,222,230,230 );
	gfx.PutPixel( 62 + x,83 + y,221,222,222 );
	gfx.PutPixel( 63 + x,83 + y,222,231,231 );
	gfx.PutPixel( 64 + x,83 + y,213,102,102 );
	gfx.PutPixel( 65 + x,83 + y,207,22,22 );
	gfx.PutPixel( 66 + x,83 + y,219,186,186 );
	gfx.PutPixel( 67 + x,83 + y,222,228,228 );
	gfx.PutPixel( 68 + x,83 + y,221,224,224 );
	gfx.PutPixel( 69 + x,83 + y,220,214,214 );
	gfx.PutPixel( 70 + x,83 + y,209,56,56 );
	gfx.PutPixel( 71 + x,83 + y,208,29,29 );
	gfx.PutPixel( 72 + x,83 + y,208,34,34 );
	gfx.PutPixel( 73 + x,83 + y,208,34,34 );
	gfx.PutPixel( 74 + x,83 + y,208,34,34 );
	gfx.PutPixel( 75 + x,83 + y,208,27,27 );
	gfx.PutPixel( 76 + x,83 + y,218,173,173 );
	gfx.PutPixel( 77 + x,83 + y,222,230,230 );
	gfx.PutPixel( 78 + x,83 + y,222,230,230 );
	gfx.PutPixel( 79 + x,83 + y,218,173,173 );
	gfx.PutPixel( 80 + x,83 + y,208,27,27 );
	gfx.PutPixel( 81 + x,83 + y,208,34,34 );
	gfx.PutPixel( 82 + x,83 + y,208,34,34 );
	gfx.PutPixel( 83 + x,83 + y,208,34,34 );
	gfx.PutPixel( 84 + x,83 + y,208,34,34 );
	gfx.PutPixel( 85 + x,83 + y,208,34,34 );
	gfx.PutPixel( 86 + x,83 + y,208,34,34 );
	gfx.PutPixel( 87 + x,83 + y,208,30,30 );
	gfx.PutPixel( 88 + x,83 + y,209,47,47 );
	gfx.PutPixel( 89 + x,83 + y,220,208,208 );
	gfx.PutPixel( 90 + x,83 + y,221,225,225 );
	gfx.PutPixel( 91 + x,83 + y,222,233,233 );
	gfx.PutPixel( 92 + x,83 + y,214,117,117 );
	gfx.PutPixel( 93 + x,83 + y,211,85,85 );
	gfx.PutPixel( 94 + x,83 + y,222,230,230 );
	gfx.PutPixel( 95 + x,83 + y,221,222,222 );
	gfx.PutPixel( 96 + x,83 + y,221,221,221 );
	gfx.PutPixel( 97 + x,83 + y,210,68,68 );
	gfx.PutPixel( 98 + x,83 + y,207,21,21 );
	gfx.PutPixel( 99 + x,83 + y,210,64,64 );
	gfx.PutPixel( 100 + x,83 + y,221,220,220 );
	gfx.PutPixel( 101 + x,83 + y,221,223,223 );
	gfx.PutPixel( 102 + x,83 + y,222,230,230 );
	gfx.PutPixel( 103 + x,83 + y,211,87,87 );
	gfx.PutPixel( 104 + x,83 + y,214,117,117 );
	gfx.PutPixel( 105 + x,83 + y,222,233,233 );
	gfx.PutPixel( 106 + x,83 + y,221,225,225 );
	gfx.PutPixel( 107 + x,83 + y,220,208,208 );
	gfx.PutPixel( 108 + x,83 + y,209,47,47 );
	gfx.PutPixel( 109 + x,83 + y,208,30,30 );
	gfx.PutPixel( 110 + x,83 + y,208,34,34 );
	gfx.PutPixel( 111 + x,83 + y,208,34,34 );
	gfx.PutPixel( 112 + x,83 + y,208,34,34 );
	gfx.PutPixel( 113 + x,83 + y,208,34,34 );
	gfx.PutPixel( 114 + x,83 + y,208,34,34 );
	gfx.PutPixel( 115 + x,83 + y,208,34,34 );
	gfx.PutPixel( 116 + x,83 + y,208,34,34 );
	gfx.PutPixel( 117 + x,83 + y,208,34,34 );
	gfx.PutPixel( 118 + x,83 + y,208,34,34 );
	gfx.PutPixel( 119 + x,83 + y,208,34,34 );
	gfx.PutPixel( 120 + x,83 + y,208,34,34 );
	gfx.PutPixel( 121 + x,83 + y,208,34,34 );
	gfx.PutPixel( 122 + x,83 + y,208,34,34 );
	gfx.PutPixel( 123 + x,83 + y,208,34,34 );
	gfx.PutPixel( 124 + x,83 + y,208,34,34 );
	gfx.PutPixel( 125 + x,83 + y,208,34,34 );
	gfx.PutPixel( 126 + x,83 + y,208,34,34 );
	gfx.PutPixel( 127 + x,83 + y,208,34,34 );
	gfx.PutPixel( 128 + x,83 + y,208,34,34 );
	gfx.PutPixel( 129 + x,83 + y,208,34,34 );
	gfx.PutPixel( 130 + x,83 + y,208,34,34 );
	gfx.PutPixel( 131 + x,83 + y,208,34,34 );
	gfx.PutPixel( 132 + x,83 + y,208,34,34 );
	gfx.PutPixel( 133 + x,83 + y,208,34,34 );
	gfx.PutPixel( 134 + x,83 + y,208,34,34 );
	gfx.PutPixel( 135 + x,83 + y,208,34,34 );
	gfx.PutPixel( 136 + x,83 + y,208,34,34 );
	gfx.PutPixel( 137 + x,83 + y,208,34,34 );
	gfx.PutPixel( 138 + x,83 + y,208,34,34 );
	gfx.PutPixel( 139 + x,83 + y,208,34,34 );
	gfx.PutPixel( 140 + x,83 + y,208,34,34 );
	gfx.PutPixel( 141 + x,83 + y,208,34,34 );
	gfx.PutPixel( 142 + x,83 + y,208,34,34 );
	gfx.PutPixel( 143 + x,83 + y,208,34,34 );
	gfx.PutPixel( 144 + x,83 + y,208,34,34 );
	gfx.PutPixel( 145 + x,83 + y,208,34,34 );
	gfx.PutPixel( 146 + x,83 + y,208,34,34 );
	gfx.PutPixel( 147 + x,83 + y,208,34,34 );
	gfx.PutPixel( 148 + x,83 + y,208,34,34 );
	gfx.PutPixel( 149 + x,83 + y,208,34,34 );
	gfx.PutPixel( 0 + x,84 + y,208,34,34 );
	gfx.PutPixel( 1 + x,84 + y,208,34,34 );
	gfx.PutPixel( 2 + x,84 + y,208,34,34 );
	gfx.PutPixel( 3 + x,84 + y,208,34,34 );
	gfx.PutPixel( 4 + x,84 + y,208,34,34 );
	gfx.PutPixel( 5 + x,84 + y,208,34,34 );
	gfx.PutPixel( 6 + x,84 + y,208,34,34 );
	gfx.PutPixel( 7 + x,84 + y,208,34,34 );
	gfx.PutPixel( 8 + x,84 + y,208,34,34 );
	gfx.PutPixel( 9 + x,84 + y,208,34,34 );
	gfx.PutPixel( 10 + x,84 + y,208,34,34 );
	gfx.PutPixel( 11 + x,84 + y,208,34,34 );
	gfx.PutPixel( 12 + x,84 + y,208,34,34 );
	gfx.PutPixel( 13 + x,84 + y,208,34,34 );
	gfx.PutPixel( 14 + x,84 + y,208,34,34 );
	gfx.PutPixel( 15 + x,84 + y,208,34,34 );
	gfx.PutPixel( 16 + x,84 + y,208,34,34 );
	gfx.PutPixel( 17 + x,84 + y,208,34,34 );
	gfx.PutPixel( 18 + x,84 + y,208,34,34 );
	gfx.PutPixel( 19 + x,84 + y,208,34,34 );
	gfx.PutPixel( 20 + x,84 + y,208,34,34 );
	gfx.PutPixel( 21 + x,84 + y,208,34,34 );
	gfx.PutPixel( 22 + x,84 + y,208,34,34 );
	gfx.PutPixel( 23 + x,84 + y,208,34,34 );
	gfx.PutPixel( 24 + x,84 + y,208,34,34 );
	gfx.PutPixel( 25 + x,84 + y,208,34,34 );
	gfx.PutPixel( 26 + x,84 + y,208,34,34 );
	gfx.PutPixel( 27 + x,84 + y,208,34,34 );
	gfx.PutPixel( 28 + x,84 + y,208,34,34 );
	gfx.PutPixel( 29 + x,84 + y,208,34,34 );
	gfx.PutPixel( 30 + x,84 + y,208,34,34 );
	gfx.PutPixel( 31 + x,84 + y,208,34,34 );
	gfx.PutPixel( 32 + x,84 + y,208,34,34 );
	gfx.PutPixel( 33 + x,84 + y,208,34,34 );
	gfx.PutPixel( 34 + x,84 + y,208,34,34 );
	gfx.PutPixel( 35 + x,84 + y,208,34,34 );
	gfx.PutPixel( 36 + x,84 + y,208,34,34 );
	gfx.PutPixel( 37 + x,84 + y,208,34,34 );
	gfx.PutPixel( 38 + x,84 + y,208,34,34 );
	gfx.PutPixel( 39 + x,84 + y,207,25,25 );
	gfx.PutPixel( 40 + x,84 + y,211,82,82 );
	gfx.PutPixel( 41 + x,84 + y,221,227,227 );
	gfx.PutPixel( 42 + x,84 + y,221,222,222 );
	gfx.PutPixel( 43 + x,84 + y,222,230,230 );
	gfx.PutPixel( 44 + x,84 + y,218,173,173 );
	gfx.PutPixel( 45 + x,84 + y,208,28,28 );
	gfx.PutPixel( 46 + x,84 + y,208,33,33 );
	gfx.PutPixel( 47 + x,84 + y,208,34,34 );
	gfx.PutPixel( 48 + x,84 + y,208,34,34 );
	gfx.PutPixel( 49 + x,84 + y,208,34,34 );
	gfx.PutPixel( 50 + x,84 + y,208,34,34 );
	gfx.PutPixel( 51 + x,84 + y,208,34,34 );
	gfx.PutPixel( 52 + x,84 + y,208,34,34 );
	gfx.PutPixel( 53 + x,84 + y,208,34,34 );
	gfx.PutPixel( 54 + x,84 + y,208,34,34 );
	gfx.PutPixel( 55 + x,84 + y,208,34,34 );
	gfx.PutPixel( 56 + x,84 + y,208,34,34 );
	gfx.PutPixel( 57 + x,84 + y,208,34,34 );
	gfx.PutPixel( 58 + x,84 + y,208,33,33 );
	gfx.PutPixel( 59 + x,84 + y,207,28,28 );
	gfx.PutPixel( 60 + x,84 + y,217,171,171 );
	gfx.PutPixel( 61 + x,84 + y,222,230,230 );
	gfx.PutPixel( 62 + x,84 + y,221,225,225 );
	gfx.PutPixel( 63 + x,84 + y,220,204,204 );
	gfx.PutPixel( 64 + x,84 + y,209,46,46 );
	gfx.PutPixel( 65 + x,84 + y,207,19,19 );
	gfx.PutPixel( 66 + x,84 + y,214,117,117 );
	gfx.PutPixel( 67 + x,84 + y,222,233,233 );
	gfx.PutPixel( 68 + x,84 + y,221,221,221 );
	gfx.PutPixel( 69 + x,84 + y,222,233,233 );
	gfx.PutPixel( 70 + x,84 + y,215,128,128 );
	gfx.PutPixel( 71 + x,84 + y,207,22,22 );
	gfx.PutPixel( 72 + x,84 + y,208,34,34 );
	gfx.PutPixel( 73 + x,84 + y,208,34,34 );
	gfx.PutPixel( 74 + x,84 + y,208,34,34 );
	gfx.PutPixel( 75 + x,84 + y,208,27,27 );
	gfx.PutPixel( 76 + x,84 + y,218,173,173 );
	gfx.PutPixel( 77 + x,84 + y,222,230,230 );
	gfx.PutPixel( 78 + x,84 + y,222,230,230 );
	gfx.PutPixel( 79 + x,84 + y,218,173,173 );
	gfx.PutPixel( 80 + x,84 + y,208,27,27 );
	gfx.PutPixel( 81 + x,84 + y,208,34,34 );
	gfx.PutPixel( 82 + x,84 + y,208,34,34 );
	gfx.PutPixel( 83 + x,84 + y,208,34,34 );
	gfx.PutPixel( 84 + x,84 + y,208,34,34 );
	gfx.PutPixel( 85 + x,84 + y,208,34,34 );
	gfx.PutPixel( 86 + x,84 + y,208,34,34 );
	gfx.PutPixel( 87 + x,84 + y,208,30,30 );
	gfx.PutPixel( 88 + x,84 + y,209,47,47 );
	gfx.PutPixel( 89 + x,84 + y,220,208,208 );
	gfx.PutPixel( 90 + x,84 + y,221,225,225 );
	gfx.PutPixel( 91 + x,84 + y,222,233,233 );
	gfx.PutPixel( 92 + x,84 + y,214,124,124 );
	gfx.PutPixel( 93 + x,84 + y,208,36,36 );
	gfx.PutPixel( 94 + x,84 + y,220,207,207 );
	gfx.PutPixel( 95 + x,84 + y,221,224,224 );
	gfx.PutPixel( 96 + x,84 + y,222,233,233 );
	gfx.PutPixel( 97 + x,84 + y,215,129,129 );
	gfx.PutPixel( 98 + x,84 + y,206,11,11 );
	gfx.PutPixel( 99 + x,84 + y,215,124,124 );
	gfx.PutPixel( 100 + x,84 + y,222,233,233 );
	gfx.PutPixel( 101 + x,84 + y,221,225,225 );
	gfx.PutPixel( 102 + x,84 + y,220,206,206 );
	gfx.PutPixel( 103 + x,84 + y,208,35,35 );
	gfx.PutPixel( 104 + x,84 + y,214,124,124 );
	gfx.PutPixel( 105 + x,84 + y,222,233,233 );
	gfx.PutPixel( 106 + x,84 + y,221,225,225 );
	gfx.PutPixel( 107 + x,84 + y,220,208,208 );
	gfx.PutPixel( 108 + x,84 + y,209,47,47 );
	gfx.PutPixel( 109 + x,84 + y,208,30,30 );
	gfx.PutPixel( 110 + x,84 + y,208,34,34 );
	gfx.PutPixel( 111 + x,84 + y,208,34,34 );
	gfx.PutPixel( 112 + x,84 + y,208,34,34 );
	gfx.PutPixel( 113 + x,84 + y,208,34,34 );
	gfx.PutPixel( 114 + x,84 + y,208,34,34 );
	gfx.PutPixel( 115 + x,84 + y,208,34,34 );
	gfx.PutPixel( 116 + x,84 + y,208,34,34 );
	gfx.PutPixel( 117 + x,84 + y,208,34,34 );
	gfx.PutPixel( 118 + x,84 + y,208,34,34 );
	gfx.PutPixel( 119 + x,84 + y,208,34,34 );
	gfx.PutPixel( 120 + x,84 + y,208,34,34 );
	gfx.PutPixel( 121 + x,84 + y,208,34,34 );
	gfx.PutPixel( 122 + x,84 + y,208,34,34 );
	gfx.PutPixel( 123 + x,84 + y,208,34,34 );
	gfx.PutPixel( 124 + x,84 + y,208,34,34 );
	gfx.PutPixel( 125 + x,84 + y,208,34,34 );
	gfx.PutPixel( 126 + x,84 + y,208,34,34 );
	gfx.PutPixel( 127 + x,84 + y,208,34,34 );
	gfx.PutPixel( 128 + x,84 + y,208,34,34 );
	gfx.PutPixel( 129 + x,84 + y,208,34,34 );
	gfx.PutPixel( 130 + x,84 + y,208,34,34 );
	gfx.PutPixel( 131 + x,84 + y,208,34,34 );
	gfx.PutPixel( 132 + x,84 + y,208,34,34 );
	gfx.PutPixel( 133 + x,84 + y,208,34,34 );
	gfx.PutPixel( 134 + x,84 + y,208,34,34 );
	gfx.PutPixel( 135 + x,84 + y,208,34,34 );
	gfx.PutPixel( 136 + x,84 + y,208,34,34 );
	gfx.PutPixel( 137 + x,84 + y,208,34,34 );
	gfx.PutPixel( 138 + x,84 + y,208,34,34 );
	gfx.PutPixel( 139 + x,84 + y,208,34,34 );
	gfx.PutPixel( 140 + x,84 + y,208,34,34 );
	gfx.PutPixel( 141 + x,84 + y,208,34,34 );
	gfx.PutPixel( 142 + x,84 + y,208,34,34 );
	gfx.PutPixel( 143 + x,84 + y,208,34,34 );
	gfx.PutPixel( 144 + x,84 + y,208,34,34 );
	gfx.PutPixel( 145 + x,84 + y,208,34,34 );
	gfx.PutPixel( 146 + x,84 + y,208,34,34 );
	gfx.PutPixel( 147 + x,84 + y,208,34,34 );
	gfx.PutPixel( 148 + x,84 + y,208,34,34 );
	gfx.PutPixel( 149 + x,84 + y,208,34,34 );
	gfx.PutPixel( 0 + x,85 + y,208,34,34 );
	gfx.PutPixel( 1 + x,85 + y,208,34,34 );
	gfx.PutPixel( 2 + x,85 + y,208,34,34 );
	gfx.PutPixel( 3 + x,85 + y,208,34,34 );
	gfx.PutPixel( 4 + x,85 + y,208,34,34 );
	gfx.PutPixel( 5 + x,85 + y,208,34,34 );
	gfx.PutPixel( 6 + x,85 + y,208,34,34 );
	gfx.PutPixel( 7 + x,85 + y,208,34,34 );
	gfx.PutPixel( 8 + x,85 + y,208,34,34 );
	gfx.PutPixel( 9 + x,85 + y,208,34,34 );
	gfx.PutPixel( 10 + x,85 + y,208,34,34 );
	gfx.PutPixel( 11 + x,85 + y,208,34,34 );
	gfx.PutPixel( 12 + x,85 + y,208,34,34 );
	gfx.PutPixel( 13 + x,85 + y,208,34,34 );
	gfx.PutPixel( 14 + x,85 + y,208,34,34 );
	gfx.PutPixel( 15 + x,85 + y,208,34,34 );
	gfx.PutPixel( 16 + x,85 + y,208,34,34 );
	gfx.PutPixel( 17 + x,85 + y,208,34,34 );
	gfx.PutPixel( 18 + x,85 + y,208,34,34 );
	gfx.PutPixel( 19 + x,85 + y,208,34,34 );
	gfx.PutPixel( 20 + x,85 + y,208,34,34 );
	gfx.PutPixel( 21 + x,85 + y,208,34,34 );
	gfx.PutPixel( 22 + x,85 + y,208,34,34 );
	gfx.PutPixel( 23 + x,85 + y,208,34,34 );
	gfx.PutPixel( 24 + x,85 + y,208,34,34 );
	gfx.PutPixel( 25 + x,85 + y,208,34,34 );
	gfx.PutPixel( 26 + x,85 + y,208,34,34 );
	gfx.PutPixel( 27 + x,85 + y,208,34,34 );
	gfx.PutPixel( 28 + x,85 + y,208,34,34 );
	gfx.PutPixel( 29 + x,85 + y,208,34,34 );
	gfx.PutPixel( 30 + x,85 + y,208,34,34 );
	gfx.PutPixel( 31 + x,85 + y,208,34,34 );
	gfx.PutPixel( 32 + x,85 + y,208,34,34 );
	gfx.PutPixel( 33 + x,85 + y,208,34,34 );
	gfx.PutPixel( 34 + x,85 + y,208,34,34 );
	gfx.PutPixel( 35 + x,85 + y,208,34,34 );
	gfx.PutPixel( 36 + x,85 + y,208,34,34 );
	gfx.PutPixel( 37 + x,85 + y,208,34,34 );
	gfx.PutPixel( 38 + x,85 + y,208,34,34 );
	gfx.PutPixel( 39 + x,85 + y,207,26,26 );
	gfx.PutPixel( 40 + x,85 + y,211,78,78 );
	gfx.PutPixel( 41 + x,85 + y,221,226,226 );
	gfx.PutPixel( 42 + x,85 + y,221,222,222 );
	gfx.PutPixel( 43 + x,85 + y,222,229,229 );
	gfx.PutPixel( 44 + x,85 + y,218,178,178 );
	gfx.PutPixel( 45 + x,85 + y,208,30,30 );
	gfx.PutPixel( 46 + x,85 + y,208,33,33 );
	gfx.PutPixel( 47 + x,85 + y,208,34,34 );
	gfx.PutPixel( 48 + x,85 + y,208,34,34 );
	gfx.PutPixel( 49 + x,85 + y,208,34,34 );
	gfx.PutPixel( 50 + x,85 + y,208,34,34 );
	gfx.PutPixel( 51 + x,85 + y,208,34,34 );
	gfx.PutPixel( 52 + x,85 + y,208,34,34 );
	gfx.PutPixel( 53 + x,85 + y,208,34,34 );
	gfx.PutPixel( 54 + x,85 + y,208,34,34 );
	gfx.PutPixel( 55 + x,85 + y,208,34,34 );
	gfx.PutPixel( 56 + x,85 + y,208,34,34 );
	gfx.PutPixel( 57 + x,85 + y,208,34,34 );
	gfx.PutPixel( 58 + x,85 + y,207,26,26 );
	gfx.PutPixel( 59 + x,85 + y,211,71,71 );
	gfx.PutPixel( 60 + x,85 + y,221,223,223 );
	gfx.PutPixel( 61 + x,85 + y,221,222,222 );
	gfx.PutPixel( 62 + x,85 + y,222,232,232 );
	gfx.PutPixel( 63 + x,85 + y,215,133,133 );
	gfx.PutPixel( 64 + x,85 + y,206,11,11 );
	gfx.PutPixel( 65 + x,85 + y,207,17,17 );
	gfx.PutPixel( 66 + x,85 + y,208,41,41 );
	gfx.PutPixel( 67 + x,85 + y,220,206,206 );
	gfx.PutPixel( 68 + x,85 + y,221,225,225 );
	gfx.PutPixel( 69 + x,85 + y,221,226,226 );
	gfx.PutPixel( 70 + x,85 + y,220,199,199 );
	gfx.PutPixel( 71 + x,85 + y,209,41,41 );
	gfx.PutPixel( 72 + x,85 + y,208,31,31 );
	gfx.PutPixel( 73 + x,85 + y,208,34,34 );
	gfx.PutPixel( 74 + x,85 + y,208,34,34 );
	gfx.PutPixel( 75 + x,85 + y,208,27,27 );
	gfx.PutPixel( 76 + x,85 + y,218,173,173 );
	gfx.PutPixel( 77 + x,85 + y,222,230,230 );
	gfx.PutPixel( 78 + x,85 + y,222,230,230 );
	gfx.PutPixel( 79 + x,85 + y,218,173,173 );
	gfx.PutPixel( 80 + x,85 + y,208,27,27 );
	gfx.PutPixel( 81 + x,85 + y,208,34,34 );
	gfx.PutPixel( 82 + x,85 + y,208,34,34 );
	gfx.PutPixel( 83 + x,85 + y,208,34,34 );
	gfx.PutPixel( 84 + x,85 + y,208,34,34 );
	gfx.PutPixel( 85 + x,85 + y,208,34,34 );
	gfx.PutPixel( 86 + x,85 + y,208,34,34 );
	gfx.PutPixel( 87 + x,85 + y,208,30,30 );
	gfx.PutPixel( 88 + x,85 + y,209,47,47 );
	gfx.PutPixel( 89 + x,85 + y,220,208,208 );
	gfx.PutPixel( 90 + x,85 + y,221,225,225 );
	gfx.PutPixel( 91 + x,85 + y,222,233,233 );
	gfx.PutPixel( 92 + x,85 + y,214,127,127 );
	gfx.PutPixel( 93 + x,85 + y,206,12,12 );
	gfx.PutPixel( 94 + x,85 + y,217,156,156 );
	gfx.PutPixel( 95 + x,85 + y,222,232,232 );
	gfx.PutPixel( 96 + x,85 + y,221,228,228 );
	gfx.PutPixel( 97 + x,85 + y,219,188,188 );
	gfx.PutPixel( 98 + x,85 + y,208,34,34 );
	gfx.PutPixel( 99 + x,85 + y,218,183,183 );
	gfx.PutPixel( 100 + x,85 + y,222,228,228 );
	gfx.PutPixel( 101 + x,85 + y,222,232,232 );
	gfx.PutPixel( 102 + x,85 + y,216,152,152 );
	gfx.PutPixel( 103 + x,85 + y,206,12,12 );
	gfx.PutPixel( 104 + x,85 + y,214,127,127 );
	gfx.PutPixel( 105 + x,85 + y,222,233,233 );
	gfx.PutPixel( 106 + x,85 + y,221,225,225 );
	gfx.PutPixel( 107 + x,85 + y,220,208,208 );
	gfx.PutPixel( 108 + x,85 + y,209,47,47 );
	gfx.PutPixel( 109 + x,85 + y,208,30,30 );
	gfx.PutPixel( 110 + x,85 + y,208,34,34 );
	gfx.PutPixel( 111 + x,85 + y,208,34,34 );
	gfx.PutPixel( 112 + x,85 + y,208,34,34 );
	gfx.PutPixel( 113 + x,85 + y,208,34,34 );
	gfx.PutPixel( 114 + x,85 + y,208,34,34 );
	gfx.PutPixel( 115 + x,85 + y,208,34,34 );
	gfx.PutPixel( 116 + x,85 + y,208,34,34 );
	gfx.PutPixel( 117 + x,85 + y,208,34,34 );
	gfx.PutPixel( 118 + x,85 + y,208,34,34 );
	gfx.PutPixel( 119 + x,85 + y,208,34,34 );
	gfx.PutPixel( 120 + x,85 + y,208,34,34 );
	gfx.PutPixel( 121 + x,85 + y,208,34,34 );
	gfx.PutPixel( 122 + x,85 + y,208,34,34 );
	gfx.PutPixel( 123 + x,85 + y,208,34,34 );
	gfx.PutPixel( 124 + x,85 + y,208,34,34 );
	gfx.PutPixel( 125 + x,85 + y,208,34,34 );
	gfx.PutPixel( 126 + x,85 + y,208,34,34 );
	gfx.PutPixel( 127 + x,85 + y,208,34,34 );
	gfx.PutPixel( 128 + x,85 + y,208,34,34 );
	gfx.PutPixel( 129 + x,85 + y,208,34,34 );
	gfx.PutPixel( 130 + x,85 + y,208,34,34 );
	gfx.PutPixel( 131 + x,85 + y,208,34,34 );
	gfx.PutPixel( 132 + x,85 + y,208,34,34 );
	gfx.PutPixel( 133 + x,85 + y,208,34,34 );
	gfx.PutPixel( 134 + x,85 + y,208,34,34 );
	gfx.PutPixel( 135 + x,85 + y,208,34,34 );
	gfx.PutPixel( 136 + x,85 + y,208,34,34 );
	gfx.PutPixel( 137 + x,85 + y,208,34,34 );
	gfx.PutPixel( 138 + x,85 + y,208,34,34 );
	gfx.PutPixel( 139 + x,85 + y,208,34,34 );
	gfx.PutPixel( 140 + x,85 + y,208,34,34 );
	gfx.PutPixel( 141 + x,85 + y,208,34,34 );
	gfx.PutPixel( 142 + x,85 + y,208,34,34 );
	gfx.PutPixel( 143 + x,85 + y,208,34,34 );
	gfx.PutPixel( 144 + x,85 + y,208,34,34 );
	gfx.PutPixel( 145 + x,85 + y,208,34,34 );
	gfx.PutPixel( 146 + x,85 + y,208,34,34 );
	gfx.PutPixel( 147 + x,85 + y,208,34,34 );
	gfx.PutPixel( 148 + x,85 + y,208,34,34 );
	gfx.PutPixel( 149 + x,85 + y,208,34,34 );
	gfx.PutPixel( 0 + x,86 + y,208,34,34 );
	gfx.PutPixel( 1 + x,86 + y,208,34,34 );
	gfx.PutPixel( 2 + x,86 + y,208,34,34 );
	gfx.PutPixel( 3 + x,86 + y,208,34,34 );
	gfx.PutPixel( 4 + x,86 + y,208,34,34 );
	gfx.PutPixel( 5 + x,86 + y,208,34,34 );
	gfx.PutPixel( 6 + x,86 + y,208,34,34 );
	gfx.PutPixel( 7 + x,86 + y,208,34,34 );
	gfx.PutPixel( 8 + x,86 + y,208,34,34 );
	gfx.PutPixel( 9 + x,86 + y,208,34,34 );
	gfx.PutPixel( 10 + x,86 + y,208,34,34 );
	gfx.PutPixel( 11 + x,86 + y,208,34,34 );
	gfx.PutPixel( 12 + x,86 + y,208,34,34 );
	gfx.PutPixel( 13 + x,86 + y,208,34,34 );
	gfx.PutPixel( 14 + x,86 + y,208,34,34 );
	gfx.PutPixel( 15 + x,86 + y,208,34,34 );
	gfx.PutPixel( 16 + x,86 + y,208,34,34 );
	gfx.PutPixel( 17 + x,86 + y,208,34,34 );
	gfx.PutPixel( 18 + x,86 + y,208,34,34 );
	gfx.PutPixel( 19 + x,86 + y,208,34,34 );
	gfx.PutPixel( 20 + x,86 + y,208,34,34 );
	gfx.PutPixel( 21 + x,86 + y,208,34,34 );
	gfx.PutPixel( 22 + x,86 + y,208,34,34 );
	gfx.PutPixel( 23 + x,86 + y,208,34,34 );
	gfx.PutPixel( 24 + x,86 + y,208,34,34 );
	gfx.PutPixel( 25 + x,86 + y,208,34,34 );
	gfx.PutPixel( 26 + x,86 + y,208,34,34 );
	gfx.PutPixel( 27 + x,86 + y,208,34,34 );
	gfx.PutPixel( 28 + x,86 + y,208,34,34 );
	gfx.PutPixel( 29 + x,86 + y,208,34,34 );
	gfx.PutPixel( 30 + x,86 + y,208,34,34 );
	gfx.PutPixel( 31 + x,86 + y,208,34,34 );
	gfx.PutPixel( 32 + x,86 + y,208,34,34 );
	gfx.PutPixel( 33 + x,86 + y,208,34,34 );
	gfx.PutPixel( 34 + x,86 + y,208,34,34 );
	gfx.PutPixel( 35 + x,86 + y,208,34,34 );
	gfx.PutPixel( 36 + x,86 + y,208,34,34 );
	gfx.PutPixel( 37 + x,86 + y,208,34,34 );
	gfx.PutPixel( 38 + x,86 + y,208,34,34 );
	gfx.PutPixel( 39 + x,86 + y,208,28,28 );
	gfx.PutPixel( 40 + x,86 + y,210,61,61 );
	gfx.PutPixel( 41 + x,86 + y,221,217,217 );
	gfx.PutPixel( 42 + x,86 + y,221,223,223 );
	gfx.PutPixel( 43 + x,86 + y,221,225,225 );
	gfx.PutPixel( 44 + x,86 + y,220,204,204 );
	gfx.PutPixel( 45 + x,86 + y,209,45,45 );
	gfx.PutPixel( 46 + x,86 + y,208,30,30 );
	gfx.PutPixel( 47 + x,86 + y,208,34,34 );
	gfx.PutPixel( 48 + x,86 + y,208,34,34 );
	gfx.PutPixel( 49 + x,86 + y,208,34,34 );
	gfx.PutPixel( 50 + x,86 + y,208,34,34 );
	gfx.PutPixel( 51 + x,86 + y,208,34,34 );
	gfx.PutPixel( 52 + x,86 + y,208,34,34 );
	gfx.PutPixel( 53 + x,86 + y,208,34,34 );
	gfx.PutPixel( 54 + x,86 + y,208,34,34 );
	gfx.PutPixel( 55 + x,86 + y,208,34,34 );
	gfx.PutPixel( 56 + x,86 + y,208,34,34 );
	gfx.PutPixel( 57 + x,86 + y,208,34,34 );
	gfx.PutPixel( 58 + x,86 + y,207,23,23 );
	gfx.PutPixel( 59 + x,86 + y,216,147,147 );
	gfx.PutPixel( 60 + x,86 + y,222,232,232 );
	gfx.PutPixel( 61 + x,86 + y,221,221,221 );
	gfx.PutPixel( 62 + x,86 + y,221,225,225 );
	gfx.PutPixel( 63 + x,86 + y,216,154,154 );
	gfx.PutPixel( 64 + x,86 + y,214,122,122 );
	gfx.PutPixel( 65 + x,86 + y,215,128,128 );
	gfx.PutPixel( 66 + x,86 + y,214,123,123 );
	gfx.PutPixel( 67 + x,86 + y,219,196,196 );
	gfx.PutPixel( 68 + x,86 + y,221,225,225 );
	gfx.PutPixel( 69 + x,86 + y,221,221,221 );
	gfx.PutPixel( 70 + x,86 + y,222,231,231 );
	gfx.PutPixel( 71 + x,86 + y,213,104,104 );
	gfx.PutPixel( 72 + x,86 + y,207,23,23 );
	gfx.PutPixel( 73 + x,86 + y,208,34,34 );
	gfx.PutPixel( 74 + x,86 + y,208,34,34 );
	gfx.PutPixel( 75 + x,86 + y,208,27,27 );
	gfx.PutPixel( 76 + x,86 + y,218,173,173 );
	gfx.PutPixel( 77 + x,86 + y,222,230,230 );
	gfx.PutPixel( 78 + x,86 + y,222,230,230 );
	gfx.PutPixel( 79 + x,86 + y,218,173,173 );
	gfx.PutPixel( 80 + x,86 + y,208,27,27 );
	gfx.PutPixel( 81 + x,86 + y,208,34,34 );
	gfx.PutPixel( 82 + x,86 + y,208,34,34 );
	gfx.PutPixel( 83 + x,86 + y,208,34,34 );
	gfx.PutPixel( 84 + x,86 + y,208,34,34 );
	gfx.PutPixel( 85 + x,86 + y,208,34,34 );
	gfx.PutPixel( 86 + x,86 + y,208,34,34 );
	gfx.PutPixel( 87 + x,86 + y,208,30,30 );
	gfx.PutPixel( 88 + x,86 + y,209,47,47 );
	gfx.PutPixel( 89 + x,86 + y,220,208,208 );
	gfx.PutPixel( 90 + x,86 + y,221,225,225 );
	gfx.PutPixel( 91 + x,86 + y,222,233,233 );
	gfx.PutPixel( 92 + x,86 + y,215,128,128 );
	gfx.PutPixel( 93 + x,86 + y,206,12,12 );
	gfx.PutPixel( 94 + x,86 + y,212,94,94 );
	gfx.PutPixel( 95 + x,86 + y,222,230,230 );
	gfx.PutPixel( 96 + x,86 + y,221,222,222 );
	gfx.PutPixel( 97 + x,86 + y,221,218,218 );
	gfx.PutPixel( 98 + x,86 + y,214,119,119 );
	gfx.PutPixel( 99 + x,86 + y,221,215,215 );
	gfx.PutPixel( 100 + x,86 + y,221,223,223 );
	gfx.PutPixel( 101 + x,86 + y,222,228,228 );
	gfx.PutPixel( 102 + x,86 + y,211,88,88 );
	gfx.PutPixel( 103 + x,86 + y,206,12,12 );
	gfx.PutPixel( 104 + x,86 + y,215,128,128 );
	gfx.PutPixel( 105 + x,86 + y,222,233,233 );
	gfx.PutPixel( 106 + x,86 + y,221,225,225 );
	gfx.PutPixel( 107 + x,86 + y,220,208,208 );
	gfx.PutPixel( 108 + x,86 + y,209,47,47 );
	gfx.PutPixel( 109 + x,86 + y,208,30,30 );
	gfx.PutPixel( 110 + x,86 + y,208,34,34 );
	gfx.PutPixel( 111 + x,86 + y,208,34,34 );
	gfx.PutPixel( 112 + x,86 + y,208,34,34 );
	gfx.PutPixel( 113 + x,86 + y,208,34,34 );
	gfx.PutPixel( 114 + x,86 + y,208,34,34 );
	gfx.PutPixel( 115 + x,86 + y,208,34,34 );
	gfx.PutPixel( 116 + x,86 + y,208,34,34 );
	gfx.PutPixel( 117 + x,86 + y,208,34,34 );
	gfx.PutPixel( 118 + x,86 + y,208,34,34 );
	gfx.PutPixel( 119 + x,86 + y,208,34,34 );
	gfx.PutPixel( 120 + x,86 + y,208,34,34 );
	gfx.PutPixel( 121 + x,86 + y,208,34,34 );
	gfx.PutPixel( 122 + x,86 + y,208,34,34 );
	gfx.PutPixel( 123 + x,86 + y,208,34,34 );
	gfx.PutPixel( 124 + x,86 + y,208,34,34 );
	gfx.PutPixel( 125 + x,86 + y,208,34,34 );
	gfx.PutPixel( 126 + x,86 + y,208,34,34 );
	gfx.PutPixel( 127 + x,86 + y,208,34,34 );
	gfx.PutPixel( 128 + x,86 + y,208,34,34 );
	gfx.PutPixel( 129 + x,86 + y,208,34,34 );
	gfx.PutPixel( 130 + x,86 + y,208,34,34 );
	gfx.PutPixel( 131 + x,86 + y,208,34,34 );
	gfx.PutPixel( 132 + x,86 + y,208,34,34 );
	gfx.PutPixel( 133 + x,86 + y,208,34,34 );
	gfx.PutPixel( 134 + x,86 + y,208,34,34 );
	gfx.PutPixel( 135 + x,86 + y,208,34,34 );
	gfx.PutPixel( 136 + x,86 + y,208,34,34 );
	gfx.PutPixel( 137 + x,86 + y,208,34,34 );
	gfx.PutPixel( 138 + x,86 + y,208,34,34 );
	gfx.PutPixel( 139 + x,86 + y,208,34,34 );
	gfx.PutPixel( 140 + x,86 + y,208,34,34 );
	gfx.PutPixel( 141 + x,86 + y,208,34,34 );
	gfx.PutPixel( 142 + x,86 + y,208,34,34 );
	gfx.PutPixel( 143 + x,86 + y,208,34,34 );
	gfx.PutPixel( 144 + x,86 + y,208,34,34 );
	gfx.PutPixel( 145 + x,86 + y,208,34,34 );
	gfx.PutPixel( 146 + x,86 + y,208,34,34 );
	gfx.PutPixel( 147 + x,86 + y,208,34,34 );
	gfx.PutPixel( 148 + x,86 + y,208,34,34 );
	gfx.PutPixel( 149 + x,86 + y,208,34,34 );
	gfx.PutPixel( 0 + x,87 + y,208,34,34 );
	gfx.PutPixel( 1 + x,87 + y,208,34,34 );
	gfx.PutPixel( 2 + x,87 + y,208,34,34 );
	gfx.PutPixel( 3 + x,87 + y,208,34,34 );
	gfx.PutPixel( 4 + x,87 + y,208,34,34 );
	gfx.PutPixel( 5 + x,87 + y,208,34,34 );
	gfx.PutPixel( 6 + x,87 + y,208,34,34 );
	gfx.PutPixel( 7 + x,87 + y,208,34,34 );
	gfx.PutPixel( 8 + x,87 + y,208,34,34 );
	gfx.PutPixel( 9 + x,87 + y,208,34,34 );
	gfx.PutPixel( 10 + x,87 + y,208,34,34 );
	gfx.PutPixel( 11 + x,87 + y,208,34,34 );
	gfx.PutPixel( 12 + x,87 + y,208,34,34 );
	gfx.PutPixel( 13 + x,87 + y,208,34,34 );
	gfx.PutPixel( 14 + x,87 + y,208,34,34 );
	gfx.PutPixel( 15 + x,87 + y,208,34,34 );
	gfx.PutPixel( 16 + x,87 + y,208,34,34 );
	gfx.PutPixel( 17 + x,87 + y,208,34,34 );
	gfx.PutPixel( 18 + x,87 + y,208,34,34 );
	gfx.PutPixel( 19 + x,87 + y,208,34,34 );
	gfx.PutPixel( 20 + x,87 + y,208,34,34 );
	gfx.PutPixel( 21 + x,87 + y,208,34,34 );
	gfx.PutPixel( 22 + x,87 + y,208,34,34 );
	gfx.PutPixel( 23 + x,87 + y,208,34,34 );
	gfx.PutPixel( 24 + x,87 + y,208,34,34 );
	gfx.PutPixel( 25 + x,87 + y,208,34,34 );
	gfx.PutPixel( 26 + x,87 + y,208,34,34 );
	gfx.PutPixel( 27 + x,87 + y,208,34,34 );
	gfx.PutPixel( 28 + x,87 + y,208,34,34 );
	gfx.PutPixel( 29 + x,87 + y,208,34,34 );
	gfx.PutPixel( 30 + x,87 + y,208,34,34 );
	gfx.PutPixel( 31 + x,87 + y,208,34,34 );
	gfx.PutPixel( 32 + x,87 + y,208,34,34 );
	gfx.PutPixel( 33 + x,87 + y,208,34,34 );
	gfx.PutPixel( 34 + x,87 + y,208,34,34 );
	gfx.PutPixel( 35 + x,87 + y,208,34,34 );
	gfx.PutPixel( 36 + x,87 + y,208,34,34 );
	gfx.PutPixel( 37 + x,87 + y,208,34,34 );
	gfx.PutPixel( 38 + x,87 + y,208,34,34 );
	gfx.PutPixel( 39 + x,87 + y,208,32,32 );
	gfx.PutPixel( 40 + x,87 + y,208,37,37 );
	gfx.PutPixel( 41 + x,87 + y,219,192,192 );
	gfx.PutPixel( 42 + x,87 + y,221,227,227 );
	gfx.PutPixel( 43 + x,87 + y,221,221,221 );
	gfx.PutPixel( 44 + x,87 + y,222,230,230 );
	gfx.PutPixel( 45 + x,87 + y,213,103,103 );
	gfx.PutPixel( 46 + x,87 + y,207,20,20 );
	gfx.PutPixel( 47 + x,87 + y,208,34,34 );
	gfx.PutPixel( 48 + x,87 + y,208,34,34 );
	gfx.PutPixel( 49 + x,87 + y,208,34,34 );
	gfx.PutPixel( 50 + x,87 + y,208,34,34 );
	gfx.PutPixel( 51 + x,87 + y,208,35,35 );
	gfx.PutPixel( 52 + x,87 + y,208,30,30 );
	gfx.PutPixel( 53 + x,87 + y,207,26,26 );
	gfx.PutPixel( 54 + x,87 + y,208,34,34 );
	gfx.PutPixel( 55 + x,87 + y,208,34,34 );
	gfx.PutPixel( 56 + x,87 + y,208,34,34 );
	gfx.PutPixel( 57 + x,87 + y,208,29,29 );
	gfx.PutPixel( 58 + x,87 + y,209,53,53 );
	gfx.PutPixel( 59 + x,87 + y,220,211,211 );
	gfx.PutPixel( 60 + x,87 + y,221,224,224 );
	gfx.PutPixel( 61 + x,87 + y,221,221,221 );
	gfx.PutPixel( 62 + x,87 + y,221,220,220 );
	gfx.PutPixel( 63 + x,87 + y,222,229,229 );
	gfx.PutPixel( 64 + x,87 + y,222,234,234 );
	gfx.PutPixel( 65 + x,87 + y,222,233,233 );
	gfx.PutPixel( 66 + x,87 + y,222,233,233 );
	gfx.PutPixel( 67 + x,87 + y,221,224,224 );
	gfx.PutPixel( 68 + x,87 + y,221,221,221 );
	gfx.PutPixel( 69 + x,87 + y,221,221,221 );
	gfx.PutPixel( 70 + x,87 + y,222,229,229 );
	gfx.PutPixel( 71 + x,87 + y,218,181,181 );
	gfx.PutPixel( 72 + x,87 + y,208,31,31 );
	gfx.PutPixel( 73 + x,87 + y,208,33,33 );
	gfx.PutPixel( 74 + x,87 + y,208,34,34 );
	gfx.PutPixel( 75 + x,87 + y,208,27,27 );
	gfx.PutPixel( 76 + x,87 + y,218,173,173 );
	gfx.PutPixel( 77 + x,87 + y,222,230,230 );
	gfx.PutPixel( 78 + x,87 + y,222,230,230 );
	gfx.PutPixel( 79 + x,87 + y,218,173,173 );
	gfx.PutPixel( 80 + x,87 + y,208,27,27 );
	gfx.PutPixel( 81 + x,87 + y,208,34,34 );
	gfx.PutPixel( 82 + x,87 + y,208,34,34 );
	gfx.PutPixel( 83 + x,87 + y,208,34,34 );
	gfx.PutPixel( 84 + x,87 + y,208,34,34 );
	gfx.PutPixel( 85 + x,87 + y,208,34,34 );
	gfx.PutPixel( 86 + x,87 + y,208,34,34 );
	gfx.PutPixel( 87 + x,87 + y,208,30,30 );
	gfx.PutPixel( 88 + x,87 + y,209,47,47 );
	gfx.PutPixel( 89 + x,87 + y,220,208,208 );
	gfx.PutPixel( 90 + x,87 + y,221,225,225 );
	gfx.PutPixel( 91 + x,87 + y,222,233,233 );
	gfx.PutPixel( 92 + x,87 + y,215,128,128 );
	gfx.PutPixel( 93 + x,87 + y,207,18,18 );
	gfx.PutPixel( 94 + x,87 + y,209,46,46 );
	gfx.PutPixel( 95 + x,87 + y,220,204,204 );
	gfx.PutPixel( 96 + x,87 + y,221,225,225 );
	gfx.PutPixel( 97 + x,87 + y,221,222,222 );
	gfx.PutPixel( 98 + x,87 + y,221,215,215 );
	gfx.PutPixel( 99 + x,87 + y,221,222,222 );
	gfx.PutPixel( 100 + x,87 + y,221,226,226 );
	gfx.PutPixel( 101 + x,87 + y,219,199,199 );
	gfx.PutPixel( 102 + x,87 + y,208,41,41 );
	gfx.PutPixel( 103 + x,87 + y,207,19,19 );
	gfx.PutPixel( 104 + x,87 + y,215,128,128 );
	gfx.PutPixel( 105 + x,87 + y,222,233,233 );
	gfx.PutPixel( 106 + x,87 + y,221,225,225 );
	gfx.PutPixel( 107 + x,87 + y,220,208,208 );
	gfx.PutPixel( 108 + x,87 + y,209,47,47 );
	gfx.PutPixel( 109 + x,87 + y,208,30,30 );
	gfx.PutPixel( 110 + x,87 + y,208,34,34 );
	gfx.PutPixel( 111 + x,87 + y,208,34,34 );
	gfx.PutPixel( 112 + x,87 + y,208,34,34 );
	gfx.PutPixel( 113 + x,87 + y,208,34,34 );
	gfx.PutPixel( 114 + x,87 + y,208,34,34 );
	gfx.PutPixel( 115 + x,87 + y,208,34,34 );
	gfx.PutPixel( 116 + x,87 + y,208,34,34 );
	gfx.PutPixel( 117 + x,87 + y,208,34,34 );
	gfx.PutPixel( 118 + x,87 + y,208,34,34 );
	gfx.PutPixel( 119 + x,87 + y,208,34,34 );
	gfx.PutPixel( 120 + x,87 + y,208,34,34 );
	gfx.PutPixel( 121 + x,87 + y,208,34,34 );
	gfx.PutPixel( 122 + x,87 + y,208,34,34 );
	gfx.PutPixel( 123 + x,87 + y,208,34,34 );
	gfx.PutPixel( 124 + x,87 + y,208,34,34 );
	gfx.PutPixel( 125 + x,87 + y,208,34,34 );
	gfx.PutPixel( 126 + x,87 + y,208,34,34 );
	gfx.PutPixel( 127 + x,87 + y,208,34,34 );
	gfx.PutPixel( 128 + x,87 + y,208,34,34 );
	gfx.PutPixel( 129 + x,87 + y,208,34,34 );
	gfx.PutPixel( 130 + x,87 + y,208,34,34 );
	gfx.PutPixel( 131 + x,87 + y,208,34,34 );
	gfx.PutPixel( 132 + x,87 + y,208,34,34 );
	gfx.PutPixel( 133 + x,87 + y,208,34,34 );
	gfx.PutPixel( 134 + x,87 + y,208,34,34 );
	gfx.PutPixel( 135 + x,87 + y,208,34,34 );
	gfx.PutPixel( 136 + x,87 + y,208,34,34 );
	gfx.PutPixel( 137 + x,87 + y,208,34,34 );
	gfx.PutPixel( 138 + x,87 + y,208,34,34 );
	gfx.PutPixel( 139 + x,87 + y,208,34,34 );
	gfx.PutPixel( 140 + x,87 + y,208,34,34 );
	gfx.PutPixel( 141 + x,87 + y,208,34,34 );
	gfx.PutPixel( 142 + x,87 + y,208,34,34 );
	gfx.PutPixel( 143 + x,87 + y,208,34,34 );
	gfx.PutPixel( 144 + x,87 + y,208,34,34 );
	gfx.PutPixel( 145 + x,87 + y,208,34,34 );
	gfx.PutPixel( 146 + x,87 + y,208,34,34 );
	gfx.PutPixel( 147 + x,87 + y,208,34,34 );
	gfx.PutPixel( 148 + x,87 + y,208,34,34 );
	gfx.PutPixel( 149 + x,87 + y,208,34,34 );
	gfx.PutPixel( 0 + x,88 + y,208,34,34 );
	gfx.PutPixel( 1 + x,88 + y,208,34,34 );
	gfx.PutPixel( 2 + x,88 + y,208,34,34 );
	gfx.PutPixel( 3 + x,88 + y,208,34,34 );
	gfx.PutPixel( 4 + x,88 + y,208,34,34 );
	gfx.PutPixel( 5 + x,88 + y,208,34,34 );
	gfx.PutPixel( 6 + x,88 + y,208,34,34 );
	gfx.PutPixel( 7 + x,88 + y,208,34,34 );
	gfx.PutPixel( 8 + x,88 + y,208,34,34 );
	gfx.PutPixel( 9 + x,88 + y,208,34,34 );
	gfx.PutPixel( 10 + x,88 + y,208,34,34 );
	gfx.PutPixel( 11 + x,88 + y,208,34,34 );
	gfx.PutPixel( 12 + x,88 + y,208,34,34 );
	gfx.PutPixel( 13 + x,88 + y,208,34,34 );
	gfx.PutPixel( 14 + x,88 + y,208,34,34 );
	gfx.PutPixel( 15 + x,88 + y,208,34,34 );
	gfx.PutPixel( 16 + x,88 + y,208,34,34 );
	gfx.PutPixel( 17 + x,88 + y,208,34,34 );
	gfx.PutPixel( 18 + x,88 + y,208,34,34 );
	gfx.PutPixel( 19 + x,88 + y,208,34,34 );
	gfx.PutPixel( 20 + x,88 + y,208,34,34 );
	gfx.PutPixel( 21 + x,88 + y,208,34,34 );
	gfx.PutPixel( 22 + x,88 + y,208,34,34 );
	gfx.PutPixel( 23 + x,88 + y,208,34,34 );
	gfx.PutPixel( 24 + x,88 + y,208,34,34 );
	gfx.PutPixel( 25 + x,88 + y,208,34,34 );
	gfx.PutPixel( 26 + x,88 + y,208,34,34 );
	gfx.PutPixel( 27 + x,88 + y,208,34,34 );
	gfx.PutPixel( 28 + x,88 + y,208,34,34 );
	gfx.PutPixel( 29 + x,88 + y,208,34,34 );
	gfx.PutPixel( 30 + x,88 + y,208,34,34 );
	gfx.PutPixel( 31 + x,88 + y,208,34,34 );
	gfx.PutPixel( 32 + x,88 + y,208,34,34 );
	gfx.PutPixel( 33 + x,88 + y,208,34,34 );
	gfx.PutPixel( 34 + x,88 + y,208,34,34 );
	gfx.PutPixel( 35 + x,88 + y,208,34,34 );
	gfx.PutPixel( 36 + x,88 + y,208,34,34 );
	gfx.PutPixel( 37 + x,88 + y,208,34,34 );
	gfx.PutPixel( 38 + x,88 + y,208,34,34 );
	gfx.PutPixel( 39 + x,88 + y,208,34,34 );
	gfx.PutPixel( 40 + x,88 + y,207,23,23 );
	gfx.PutPixel( 41 + x,88 + y,215,132,132 );
	gfx.PutPixel( 42 + x,88 + y,222,234,234 );
	gfx.PutPixel( 43 + x,88 + y,221,221,221 );
	gfx.PutPixel( 44 + x,88 + y,221,226,226 );
	gfx.PutPixel( 45 + x,88 + y,220,203,203 );
	gfx.PutPixel( 46 + x,88 + y,209,54,54 );
	gfx.PutPixel( 47 + x,88 + y,207,21,21 );
	gfx.PutPixel( 48 + x,88 + y,208,32,32 );
	gfx.PutPixel( 49 + x,88 + y,208,34,34 );
	gfx.PutPixel( 50 + x,88 + y,208,32,32 );
	gfx.PutPixel( 51 + x,88 + y,207,22,22 );
	gfx.PutPixel( 52 + x,88 + y,210,58,58 );
	gfx.PutPixel( 53 + x,88 + y,212,85,85 );
	gfx.PutPixel( 54 + x,88 + y,207,24,24 );
	gfx.PutPixel( 55 + x,88 + y,208,32,32 );
	gfx.PutPixel( 56 + x,88 + y,208,34,34 );
	gfx.PutPixel( 57 + x,88 + y,207,22,22 );
	gfx.PutPixel( 58 + x,88 + y,214,122,122 );
	gfx.PutPixel( 59 + x,88 + y,222,233,233 );
	gfx.PutPixel( 60 + x,88 + y,221,221,221 );
	gfx.PutPixel( 61 + x,88 + y,221,222,222 );
	gfx.PutPixel( 62 + x,88 + y,222,229,229 );
	gfx.PutPixel( 63 + x,88 + y,222,230,230 );
	gfx.PutPixel( 64 + x,88 + y,222,230,230 );
	gfx.PutPixel( 65 + x,88 + y,222,230,230 );
	gfx.PutPixel( 66 + x,88 + y,222,230,230 );
	gfx.PutPixel( 67 + x,88 + y,222,230,230 );
	gfx.PutPixel( 68 + x,88 + y,221,227,227 );
	gfx.PutPixel( 69 + x,88 + y,221,221,221 );
	gfx.PutPixel( 70 + x,88 + y,221,222,222 );
	gfx.PutPixel( 71 + x,88 + y,222,227,227 );
	gfx.PutPixel( 72 + x,88 + y,211,82,82 );
	gfx.PutPixel( 73 + x,88 + y,207,25,25 );
	gfx.PutPixel( 74 + x,88 + y,208,34,34 );
	gfx.PutPixel( 75 + x,88 + y,208,27,27 );
	gfx.PutPixel( 76 + x,88 + y,218,173,173 );
	gfx.PutPixel( 77 + x,88 + y,222,230,230 );
	gfx.PutPixel( 78 + x,88 + y,222,230,230 );
	gfx.PutPixel( 79 + x,88 + y,218,171,171 );
	gfx.PutPixel( 80 + x,88 + y,207,18,18 );
	gfx.PutPixel( 81 + x,88 + y,207,25,25 );
	gfx.PutPixel( 82 + x,88 + y,207,25,25 );
	gfx.PutPixel( 83 + x,88 + y,207,25,25 );
	gfx.PutPixel( 84 + x,88 + y,207,25,25 );
	gfx.PutPixel( 85 + x,88 + y,207,25,25 );
	gfx.PutPixel( 86 + x,88 + y,208,28,28 );
	gfx.PutPixel( 87 + x,88 + y,208,30,30 );
	gfx.PutPixel( 88 + x,88 + y,209,47,47 );
	gfx.PutPixel( 89 + x,88 + y,220,208,208 );
	gfx.PutPixel( 90 + x,88 + y,221,225,225 );
	gfx.PutPixel( 91 + x,88 + y,222,233,233 );
	gfx.PutPixel( 92 + x,88 + y,215,128,128 );
	gfx.PutPixel( 93 + x,88 + y,207,22,22 );
	gfx.PutPixel( 94 + x,88 + y,207,24,24 );
	gfx.PutPixel( 95 + x,88 + y,217,154,154 );
	gfx.PutPixel( 96 + x,88 + y,222,232,232 );
	gfx.PutPixel( 97 + x,88 + y,221,221,221 );
	gfx.PutPixel( 98 + x,88 + y,221,223,223 );
	gfx.PutPixel( 99 + x,88 + y,221,221,221 );
	gfx.PutPixel( 100 + x,88 + y,222,232,232 );
	gfx.PutPixel( 101 + x,88 + y,216,142,142 );
	gfx.PutPixel( 102 + x,88 + y,207,23,23 );
	gfx.PutPixel( 103 + x,88 + y,207,22,22 );
	gfx.PutPixel( 104 + x,88 + y,215,128,128 );
	gfx.PutPixel( 105 + x,88 + y,222,233,233 );
	gfx.PutPixel( 106 + x,88 + y,221,225,225 );
	gfx.PutPixel( 107 + x,88 + y,220,208,208 );
	gfx.PutPixel( 108 + x,88 + y,209,47,47 );
	gfx.PutPixel( 109 + x,88 + y,208,30,30 );
	gfx.PutPixel( 110 + x,88 + y,208,34,34 );
	gfx.PutPixel( 111 + x,88 + y,208,34,34 );
	gfx.PutPixel( 112 + x,88 + y,208,34,34 );
	gfx.PutPixel( 113 + x,88 + y,208,34,34 );
	gfx.PutPixel( 114 + x,88 + y,208,34,34 );
	gfx.PutPixel( 115 + x,88 + y,208,34,34 );
	gfx.PutPixel( 116 + x,88 + y,208,34,34 );
	gfx.PutPixel( 117 + x,88 + y,208,34,34 );
	gfx.PutPixel( 118 + x,88 + y,208,34,34 );
	gfx.PutPixel( 119 + x,88 + y,208,34,34 );
	gfx.PutPixel( 120 + x,88 + y,208,34,34 );
	gfx.PutPixel( 121 + x,88 + y,208,34,34 );
	gfx.PutPixel( 122 + x,88 + y,208,34,34 );
	gfx.PutPixel( 123 + x,88 + y,208,34,34 );
	gfx.PutPixel( 124 + x,88 + y,208,34,34 );
	gfx.PutPixel( 125 + x,88 + y,208,34,34 );
	gfx.PutPixel( 126 + x,88 + y,208,34,34 );
	gfx.PutPixel( 127 + x,88 + y,208,34,34 );
	gfx.PutPixel( 128 + x,88 + y,208,34,34 );
	gfx.PutPixel( 129 + x,88 + y,208,34,34 );
	gfx.PutPixel( 130 + x,88 + y,208,34,34 );
	gfx.PutPixel( 131 + x,88 + y,208,34,34 );
	gfx.PutPixel( 132 + x,88 + y,208,34,34 );
	gfx.PutPixel( 133 + x,88 + y,208,34,34 );
	gfx.PutPixel( 134 + x,88 + y,208,34,34 );
	gfx.PutPixel( 135 + x,88 + y,208,34,34 );
	gfx.PutPixel( 136 + x,88 + y,208,34,34 );
	gfx.PutPixel( 137 + x,88 + y,208,34,34 );
	gfx.PutPixel( 138 + x,88 + y,208,34,34 );
	gfx.PutPixel( 139 + x,88 + y,208,34,34 );
	gfx.PutPixel( 140 + x,88 + y,208,34,34 );
	gfx.PutPixel( 141 + x,88 + y,208,34,34 );
	gfx.PutPixel( 142 + x,88 + y,208,34,34 );
	gfx.PutPixel( 143 + x,88 + y,208,34,34 );
	gfx.PutPixel( 144 + x,88 + y,208,34,34 );
	gfx.PutPixel( 145 + x,88 + y,208,34,34 );
	gfx.PutPixel( 146 + x,88 + y,208,34,34 );
	gfx.PutPixel( 147 + x,88 + y,208,34,34 );
	gfx.PutPixel( 148 + x,88 + y,208,34,34 );
	gfx.PutPixel( 149 + x,88 + y,208,34,34 );
	gfx.PutPixel( 0 + x,89 + y,208,34,34 );
	gfx.PutPixel( 1 + x,89 + y,208,34,34 );
	gfx.PutPixel( 2 + x,89 + y,208,34,34 );
	gfx.PutPixel( 3 + x,89 + y,208,34,34 );
	gfx.PutPixel( 4 + x,89 + y,208,34,34 );
	gfx.PutPixel( 5 + x,89 + y,208,34,34 );
	gfx.PutPixel( 6 + x,89 + y,208,34,34 );
	gfx.PutPixel( 7 + x,89 + y,208,34,34 );
	gfx.PutPixel( 8 + x,89 + y,208,34,34 );
	gfx.PutPixel( 9 + x,89 + y,208,34,34 );
	gfx.PutPixel( 10 + x,89 + y,208,34,34 );
	gfx.PutPixel( 11 + x,89 + y,208,34,34 );
	gfx.PutPixel( 12 + x,89 + y,208,34,34 );
	gfx.PutPixel( 13 + x,89 + y,208,34,34 );
	gfx.PutPixel( 14 + x,89 + y,208,34,34 );
	gfx.PutPixel( 15 + x,89 + y,208,34,34 );
	gfx.PutPixel( 16 + x,89 + y,208,34,34 );
	gfx.PutPixel( 17 + x,89 + y,208,34,34 );
	gfx.PutPixel( 18 + x,89 + y,208,34,34 );
	gfx.PutPixel( 19 + x,89 + y,208,34,34 );
	gfx.PutPixel( 20 + x,89 + y,208,34,34 );
	gfx.PutPixel( 21 + x,89 + y,208,34,34 );
	gfx.PutPixel( 22 + x,89 + y,208,34,34 );
	gfx.PutPixel( 23 + x,89 + y,208,34,34 );
	gfx.PutPixel( 24 + x,89 + y,208,34,34 );
	gfx.PutPixel( 25 + x,89 + y,208,34,34 );
	gfx.PutPixel( 26 + x,89 + y,208,34,34 );
	gfx.PutPixel( 27 + x,89 + y,208,34,34 );
	gfx.PutPixel( 28 + x,89 + y,208,34,34 );
	gfx.PutPixel( 29 + x,89 + y,208,34,34 );
	gfx.PutPixel( 30 + x,89 + y,208,34,34 );
	gfx.PutPixel( 31 + x,89 + y,208,34,34 );
	gfx.PutPixel( 32 + x,89 + y,208,34,34 );
	gfx.PutPixel( 33 + x,89 + y,208,34,34 );
	gfx.PutPixel( 34 + x,89 + y,208,34,34 );
	gfx.PutPixel( 35 + x,89 + y,208,34,34 );
	gfx.PutPixel( 36 + x,89 + y,208,34,34 );
	gfx.PutPixel( 37 + x,89 + y,208,34,34 );
	gfx.PutPixel( 38 + x,89 + y,208,34,34 );
	gfx.PutPixel( 39 + x,89 + y,208,34,34 );
	gfx.PutPixel( 40 + x,89 + y,208,29,29 );
	gfx.PutPixel( 41 + x,89 + y,209,52,52 );
	gfx.PutPixel( 42 + x,89 + y,220,209,209 );
	gfx.PutPixel( 43 + x,89 + y,221,227,227 );
	gfx.PutPixel( 44 + x,89 + y,221,220,220 );
	gfx.PutPixel( 45 + x,89 + y,222,229,229 );
	gfx.PutPixel( 46 + x,89 + y,219,196,196 );
	gfx.PutPixel( 47 + x,89 + y,211,84,84 );
	gfx.PutPixel( 48 + x,89 + y,208,35,35 );
	gfx.PutPixel( 49 + x,89 + y,208,27,27 );
	gfx.PutPixel( 50 + x,89 + y,208,33,33 );
	gfx.PutPixel( 51 + x,89 + y,211,76,76 );
	gfx.PutPixel( 52 + x,89 + y,219,193,193 );
	gfx.PutPixel( 53 + x,89 + y,222,229,229 );
	gfx.PutPixel( 54 + x,89 + y,214,126,126 );
	gfx.PutPixel( 55 + x,89 + y,208,31,31 );
	gfx.PutPixel( 56 + x,89 + y,208,28,28 );
	gfx.PutPixel( 57 + x,89 + y,208,39,39 );
	gfx.PutPixel( 58 + x,89 + y,219,195,195 );
	gfx.PutPixel( 59 + x,89 + y,221,227,227 );
	gfx.PutPixel( 60 + x,89 + y,221,222,222 );
	gfx.PutPixel( 61 + x,89 + y,221,218,218 );
	gfx.PutPixel( 62 + x,89 + y,218,176,176 );
	gfx.PutPixel( 63 + x,89 + y,218,172,172 );
	gfx.PutPixel( 64 + x,89 + y,218,173,173 );
	gfx.PutPixel( 65 + x,89 + y,218,173,173 );
	gfx.PutPixel( 66 + x,89 + y,218,173,173 );
	gfx.PutPixel( 67 + x,89 + y,217,170,170 );
	gfx.PutPixel( 68 + x,89 + y,219,189,189 );
	gfx.PutPixel( 69 + x,89 + y,221,225,225 );
	gfx.PutPixel( 70 + x,89 + y,221,221,221 );
	gfx.PutPixel( 71 + x,89 + y,222,232,232 );
	gfx.PutPixel( 72 + x,89 + y,217,160,160 );
	gfx.PutPixel( 73 + x,89 + y,207,25,25 );
	gfx.PutPixel( 74 + x,89 + y,208,33,33 );
	gfx.PutPixel( 75 + x,89 + y,208,27,27 );
	gfx.PutPixel( 76 + x,89 + y,218,173,173 );
	gfx.PutPixel( 77 + x,89 + y,222,230,230 );
	gfx.PutPixel( 78 + x,89 + y,222,228,228 );
	gfx.PutPixel( 79 + x,89 + y,219,185,185 );
	gfx.PutPixel( 80 + x,89 + y,211,77,77 );
	gfx.PutPixel( 81 + x,89 + y,211,82,82 );
	gfx.PutPixel( 82 + x,89 + y,211,82,82 );
	gfx.PutPixel( 83 + x,89 + y,211,82,82 );
	gfx.PutPixel( 84 + x,89 + y,211,82,82 );
	gfx.PutPixel( 85 + x,89 + y,212,85,85 );
	gfx.PutPixel( 86 + x,89 + y,210,67,67 );
	gfx.PutPixel( 87 + x,89 + y,208,28,28 );
	gfx.PutPixel( 88 + x,89 + y,209,47,47 );
	gfx.PutPixel( 89 + x,89 + y,220,208,208 );
	gfx.PutPixel( 90 + x,89 + y,221,225,225 );
	gfx.PutPixel( 91 + x,89 + y,222,233,233 );
	gfx.PutPixel( 92 + x,89 + y,215,128,128 );
	gfx.PutPixel( 93 + x,89 + y,207,22,22 );
	gfx.PutPixel( 94 + x,89 + y,207,24,24 );
	gfx.PutPixel( 95 + x,89 + y,212,92,92 );
	gfx.PutPixel( 96 + x,89 + y,222,230,230 );
	gfx.PutPixel( 97 + x,89 + y,221,221,221 );
	gfx.PutPixel( 98 + x,89 + y,221,221,221 );
	gfx.PutPixel( 99 + x,89 + y,221,222,222 );
	gfx.PutPixel( 100 + x,89 + y,221,226,226 );
	gfx.PutPixel( 101 + x,89 + y,211,79,79 );
	gfx.PutPixel( 102 + x,89 + y,207,26,26 );
	gfx.PutPixel( 103 + x,89 + y,207,22,22 );
	gfx.PutPixel( 104 + x,89 + y,215,128,128 );
	gfx.PutPixel( 105 + x,89 + y,222,233,233 );
	gfx.PutPixel( 106 + x,89 + y,221,225,225 );
	gfx.PutPixel( 107 + x,89 + y,220,208,208 );
	gfx.PutPixel( 108 + x,89 + y,209,47,47 );
	gfx.PutPixel( 109 + x,89 + y,208,30,30 );
	gfx.PutPixel( 110 + x,89 + y,208,34,34 );
	gfx.PutPixel( 111 + x,89 + y,208,34,34 );
	gfx.PutPixel( 112 + x,89 + y,208,34,34 );
	gfx.PutPixel( 113 + x,89 + y,208,34,34 );
	gfx.PutPixel( 114 + x,89 + y,208,34,34 );
	gfx.PutPixel( 115 + x,89 + y,208,34,34 );
	gfx.PutPixel( 116 + x,89 + y,208,34,34 );
	gfx.PutPixel( 117 + x,89 + y,208,34,34 );
	gfx.PutPixel( 118 + x,89 + y,208,34,34 );
	gfx.PutPixel( 119 + x,89 + y,208,34,34 );
	gfx.PutPixel( 120 + x,89 + y,208,34,34 );
	gfx.PutPixel( 121 + x,89 + y,208,34,34 );
	gfx.PutPixel( 122 + x,89 + y,208,34,34 );
	gfx.PutPixel( 123 + x,89 + y,208,34,34 );
	gfx.PutPixel( 124 + x,89 + y,208,34,34 );
	gfx.PutPixel( 125 + x,89 + y,208,34,34 );
	gfx.PutPixel( 126 + x,89 + y,208,34,34 );
	gfx.PutPixel( 127 + x,89 + y,208,34,34 );
	gfx.PutPixel( 128 + x,89 + y,208,34,34 );
	gfx.PutPixel( 129 + x,89 + y,208,34,34 );
	gfx.PutPixel( 130 + x,89 + y,208,34,34 );
	gfx.PutPixel( 131 + x,89 + y,208,34,34 );
	gfx.PutPixel( 132 + x,89 + y,208,34,34 );
	gfx.PutPixel( 133 + x,89 + y,208,34,34 );
	gfx.PutPixel( 134 + x,89 + y,208,34,34 );
	gfx.PutPixel( 135 + x,89 + y,208,34,34 );
	gfx.PutPixel( 136 + x,89 + y,208,34,34 );
	gfx.PutPixel( 137 + x,89 + y,208,34,34 );
	gfx.PutPixel( 138 + x,89 + y,208,34,34 );
	gfx.PutPixel( 139 + x,89 + y,208,34,34 );
	gfx.PutPixel( 140 + x,89 + y,208,34,34 );
	gfx.PutPixel( 141 + x,89 + y,208,34,34 );
	gfx.PutPixel( 142 + x,89 + y,208,34,34 );
	gfx.PutPixel( 143 + x,89 + y,208,34,34 );
	gfx.PutPixel( 144 + x,89 + y,208,34,34 );
	gfx.PutPixel( 145 + x,89 + y,208,34,34 );
	gfx.PutPixel( 146 + x,89 + y,208,34,34 );
	gfx.PutPixel( 147 + x,89 + y,208,34,34 );
	gfx.PutPixel( 148 + x,89 + y,208,34,34 );
	gfx.PutPixel( 149 + x,89 + y,208,34,34 );
	gfx.PutPixel( 0 + x,90 + y,208,34,34 );
	gfx.PutPixel( 1 + x,90 + y,208,34,34 );
	gfx.PutPixel( 2 + x,90 + y,208,34,34 );
	gfx.PutPixel( 3 + x,90 + y,208,34,34 );
	gfx.PutPixel( 4 + x,90 + y,208,34,34 );
	gfx.PutPixel( 5 + x,90 + y,208,34,34 );
	gfx.PutPixel( 6 + x,90 + y,208,34,34 );
	gfx.PutPixel( 7 + x,90 + y,208,34,34 );
	gfx.PutPixel( 8 + x,90 + y,208,34,34 );
	gfx.PutPixel( 9 + x,90 + y,208,34,34 );
	gfx.PutPixel( 10 + x,90 + y,208,34,34 );
	gfx.PutPixel( 11 + x,90 + y,208,34,34 );
	gfx.PutPixel( 12 + x,90 + y,208,34,34 );
	gfx.PutPixel( 13 + x,90 + y,208,34,34 );
	gfx.PutPixel( 14 + x,90 + y,208,34,34 );
	gfx.PutPixel( 15 + x,90 + y,208,34,34 );
	gfx.PutPixel( 16 + x,90 + y,208,34,34 );
	gfx.PutPixel( 17 + x,90 + y,208,34,34 );
	gfx.PutPixel( 18 + x,90 + y,208,34,34 );
	gfx.PutPixel( 19 + x,90 + y,208,34,34 );
	gfx.PutPixel( 20 + x,90 + y,208,34,34 );
	gfx.PutPixel( 21 + x,90 + y,208,34,34 );
	gfx.PutPixel( 22 + x,90 + y,208,34,34 );
	gfx.PutPixel( 23 + x,90 + y,208,34,34 );
	gfx.PutPixel( 24 + x,90 + y,208,34,34 );
	gfx.PutPixel( 25 + x,90 + y,208,34,34 );
	gfx.PutPixel( 26 + x,90 + y,208,34,34 );
	gfx.PutPixel( 27 + x,90 + y,208,34,34 );
	gfx.PutPixel( 28 + x,90 + y,208,34,34 );
	gfx.PutPixel( 29 + x,90 + y,208,34,34 );
	gfx.PutPixel( 30 + x,90 + y,208,34,34 );
	gfx.PutPixel( 31 + x,90 + y,208,34,34 );
	gfx.PutPixel( 32 + x,90 + y,208,34,34 );
	gfx.PutPixel( 33 + x,90 + y,208,34,34 );
	gfx.PutPixel( 34 + x,90 + y,208,34,34 );
	gfx.PutPixel( 35 + x,90 + y,208,34,34 );
	gfx.PutPixel( 36 + x,90 + y,208,34,34 );
	gfx.PutPixel( 37 + x,90 + y,208,34,34 );
	gfx.PutPixel( 38 + x,90 + y,208,34,34 );
	gfx.PutPixel( 39 + x,90 + y,208,34,34 );
	gfx.PutPixel( 40 + x,90 + y,208,34,34 );
	gfx.PutPixel( 41 + x,90 + y,207,24,24 );
	gfx.PutPixel( 42 + x,90 + y,212,98,98 );
	gfx.PutPixel( 43 + x,90 + y,222,229,229 );
	gfx.PutPixel( 44 + x,90 + y,221,226,226 );
	gfx.PutPixel( 45 + x,90 + y,221,220,220 );
	gfx.PutPixel( 46 + x,90 + y,221,227,227 );
	gfx.PutPixel( 47 + x,90 + y,221,225,225 );
	gfx.PutPixel( 48 + x,90 + y,219,191,191 );
	gfx.PutPixel( 49 + x,90 + y,218,172,172 );
	gfx.PutPixel( 50 + x,90 + y,219,187,187 );
	gfx.PutPixel( 51 + x,90 + y,221,222,222 );
	gfx.PutPixel( 52 + x,90 + y,221,227,227 );
	gfx.PutPixel( 53 + x,90 + y,221,223,223 );
	gfx.PutPixel( 54 + x,90 + y,222,235,235 );
	gfx.PutPixel( 55 + x,90 + y,217,170,170 );
	gfx.PutPixel( 56 + x,90 + y,208,28,28 );
	gfx.PutPixel( 57 + x,90 + y,212,95,95 );
	gfx.PutPixel( 58 + x,90 + y,222,231,231 );
	gfx.PutPixel( 59 + x,90 + y,221,221,221 );
	gfx.PutPixel( 60 + x,90 + y,222,230,230 );
	gfx.PutPixel( 61 + x,90 + y,217,167,167 );
	gfx.PutPixel( 62 + x,90 + y,207,22,22 );
	gfx.PutPixel( 63 + x,90 + y,208,26,26 );
	gfx.PutPixel( 64 + x,90 + y,208,27,27 );
	gfx.PutPixel( 65 + x,90 + y,208,27,27 );
	gfx.PutPixel( 66 + x,90 + y,208,27,27 );
	gfx.PutPixel( 67 + x,90 + y,207,22,22 );
	gfx.PutPixel( 68 + x,90 + y,209,55,55 );
	gfx.PutPixel( 69 + x,90 + y,220,214,214 );
	gfx.PutPixel( 70 + x,90 + y,221,224,224 );
	gfx.PutPixel( 71 + x,90 + y,221,223,223 );
	gfx.PutPixel( 72 + x,90 + y,221,218,218 );
	gfx.PutPixel( 73 + x,90 + y,210,62,62 );
	gfx.PutPixel( 74 + x,90 + y,207,28,28 );
	gfx.PutPixel( 75 + x,90 + y,208,27,27 );
	gfx.PutPixel( 76 + x,90 + y,218,173,173 );
	gfx.PutPixel( 77 + x,90 + y,222,230,230 );
	gfx.PutPixel( 78 + x,90 + y,221,221,221 );
	gfx.PutPixel( 79 + x,90 + y,221,223,223 );
	gfx.PutPixel( 80 + x,90 + y,221,228,228 );
	gfx.PutPixel( 81 + x,90 + y,221,228,228 );
	gfx.PutPixel( 82 + x,90 + y,221,228,228 );
	gfx.PutPixel( 83 + x,90 + y,221,228,228 );
	gfx.PutPixel( 84 + x,90 + y,221,228,228 );
	gfx.PutPixel( 85 + x,90 + y,223,238,238 );
	gfx.PutPixel( 86 + x,90 + y,217,166,166 );
	gfx.PutPixel( 87 + x,90 + y,207,22,22 );
	gfx.PutPixel( 88 + x,90 + y,209,47,47 );
	gfx.PutPixel( 89 + x,90 + y,220,208,208 );
	gfx.PutPixel( 90 + x,90 + y,221,225,225 );
	gfx.PutPixel( 91 + x,90 + y,222,233,233 );
	gfx.PutPixel( 92 + x,90 + y,215,128,128 );
	gfx.PutPixel( 93 + x,90 + y,207,22,22 );
	gfx.PutPixel( 94 + x,90 + y,208,31,31 );
	gfx.PutPixel( 95 + x,90 + y,209,44,44 );
	gfx.PutPixel( 96 + x,90 + y,220,203,203 );
	gfx.PutPixel( 97 + x,90 + y,221,226,226 );
	gfx.PutPixel( 98 + x,90 + y,221,221,221 );
	gfx.PutPixel( 99 + x,90 + y,221,227,227 );
	gfx.PutPixel( 100 + x,90 + y,219,191,191 );
	gfx.PutPixel( 101 + x,90 + y,208,36,36 );
	gfx.PutPixel( 102 + x,90 + y,208,32,32 );
	gfx.PutPixel( 103 + x,90 + y,207,22,22 );
	gfx.PutPixel( 104 + x,90 + y,215,128,128 );
	gfx.PutPixel( 105 + x,90 + y,222,233,233 );
	gfx.PutPixel( 106 + x,90 + y,221,225,225 );
	gfx.PutPixel( 107 + x,90 + y,220,208,208 );
	gfx.PutPixel( 108 + x,90 + y,209,47,47 );
	gfx.PutPixel( 109 + x,90 + y,208,30,30 );
	gfx.PutPixel( 110 + x,90 + y,208,34,34 );
	gfx.PutPixel( 111 + x,90 + y,208,34,34 );
	gfx.PutPixel( 112 + x,90 + y,208,34,34 );
	gfx.PutPixel( 113 + x,90 + y,208,34,34 );
	gfx.PutPixel( 114 + x,90 + y,208,34,34 );
	gfx.PutPixel( 115 + x,90 + y,208,34,34 );
	gfx.PutPixel( 116 + x,90 + y,208,34,34 );
	gfx.PutPixel( 117 + x,90 + y,208,34,34 );
	gfx.PutPixel( 118 + x,90 + y,208,34,34 );
	gfx.PutPixel( 119 + x,90 + y,208,34,34 );
	gfx.PutPixel( 120 + x,90 + y,208,34,34 );
	gfx.PutPixel( 121 + x,90 + y,208,34,34 );
	gfx.PutPixel( 122 + x,90 + y,208,34,34 );
	gfx.PutPixel( 123 + x,90 + y,208,34,34 );
	gfx.PutPixel( 124 + x,90 + y,208,34,34 );
	gfx.PutPixel( 125 + x,90 + y,208,34,34 );
	gfx.PutPixel( 126 + x,90 + y,208,34,34 );
	gfx.PutPixel( 127 + x,90 + y,208,34,34 );
	gfx.PutPixel( 128 + x,90 + y,208,34,34 );
	gfx.PutPixel( 129 + x,90 + y,208,34,34 );
	gfx.PutPixel( 130 + x,90 + y,208,34,34 );
	gfx.PutPixel( 131 + x,90 + y,208,34,34 );
	gfx.PutPixel( 132 + x,90 + y,208,34,34 );
	gfx.PutPixel( 133 + x,90 + y,208,34,34 );
	gfx.PutPixel( 134 + x,90 + y,208,34,34 );
	gfx.PutPixel( 135 + x,90 + y,208,34,34 );
	gfx.PutPixel( 136 + x,90 + y,208,34,34 );
	gfx.PutPixel( 137 + x,90 + y,208,34,34 );
	gfx.PutPixel( 138 + x,90 + y,208,34,34 );
	gfx.PutPixel( 139 + x,90 + y,208,34,34 );
	gfx.PutPixel( 140 + x,90 + y,208,34,34 );
	gfx.PutPixel( 141 + x,90 + y,208,34,34 );
	gfx.PutPixel( 142 + x,90 + y,208,34,34 );
	gfx.PutPixel( 143 + x,90 + y,208,34,34 );
	gfx.PutPixel( 144 + x,90 + y,208,34,34 );
	gfx.PutPixel( 145 + x,90 + y,208,34,34 );
	gfx.PutPixel( 146 + x,90 + y,208,34,34 );
	gfx.PutPixel( 147 + x,90 + y,208,34,34 );
	gfx.PutPixel( 148 + x,90 + y,208,34,34 );
	gfx.PutPixel( 149 + x,90 + y,208,34,34 );
	gfx.PutPixel( 0 + x,91 + y,208,34,34 );
	gfx.PutPixel( 1 + x,91 + y,208,34,34 );
	gfx.PutPixel( 2 + x,91 + y,208,34,34 );
	gfx.PutPixel( 3 + x,91 + y,208,34,34 );
	gfx.PutPixel( 4 + x,91 + y,208,34,34 );
	gfx.PutPixel( 5 + x,91 + y,208,34,34 );
	gfx.PutPixel( 6 + x,91 + y,208,34,34 );
	gfx.PutPixel( 7 + x,91 + y,208,34,34 );
	gfx.PutPixel( 8 + x,91 + y,208,34,34 );
	gfx.PutPixel( 9 + x,91 + y,208,34,34 );
	gfx.PutPixel( 10 + x,91 + y,208,34,34 );
	gfx.PutPixel( 11 + x,91 + y,208,34,34 );
	gfx.PutPixel( 12 + x,91 + y,208,34,34 );
	gfx.PutPixel( 13 + x,91 + y,208,34,34 );
	gfx.PutPixel( 14 + x,91 + y,208,34,34 );
	gfx.PutPixel( 15 + x,91 + y,208,34,34 );
	gfx.PutPixel( 16 + x,91 + y,208,34,34 );
	gfx.PutPixel( 17 + x,91 + y,208,34,34 );
	gfx.PutPixel( 18 + x,91 + y,208,34,34 );
	gfx.PutPixel( 19 + x,91 + y,208,34,34 );
	gfx.PutPixel( 20 + x,91 + y,208,34,34 );
	gfx.PutPixel( 21 + x,91 + y,208,34,34 );
	gfx.PutPixel( 22 + x,91 + y,208,34,34 );
	gfx.PutPixel( 23 + x,91 + y,208,34,34 );
	gfx.PutPixel( 24 + x,91 + y,208,34,34 );
	gfx.PutPixel( 25 + x,91 + y,208,34,34 );
	gfx.PutPixel( 26 + x,91 + y,208,34,34 );
	gfx.PutPixel( 27 + x,91 + y,208,34,34 );
	gfx.PutPixel( 28 + x,91 + y,208,34,34 );
	gfx.PutPixel( 29 + x,91 + y,208,34,34 );
	gfx.PutPixel( 30 + x,91 + y,208,34,34 );
	gfx.PutPixel( 31 + x,91 + y,208,34,34 );
	gfx.PutPixel( 32 + x,91 + y,208,34,34 );
	gfx.PutPixel( 33 + x,91 + y,208,34,34 );
	gfx.PutPixel( 34 + x,91 + y,208,34,34 );
	gfx.PutPixel( 35 + x,91 + y,208,34,34 );
	gfx.PutPixel( 36 + x,91 + y,208,34,34 );
	gfx.PutPixel( 37 + x,91 + y,208,34,34 );
	gfx.PutPixel( 38 + x,91 + y,208,34,34 );
	gfx.PutPixel( 39 + x,91 + y,208,34,34 );
	gfx.PutPixel( 40 + x,91 + y,208,34,34 );
	gfx.PutPixel( 41 + x,91 + y,208,34,34 );
	gfx.PutPixel( 42 + x,91 + y,207,24,24 );
	gfx.PutPixel( 43 + x,91 + y,213,107,107 );
	gfx.PutPixel( 44 + x,91 + y,221,221,221 );
	gfx.PutPixel( 45 + x,91 + y,222,232,232 );
	gfx.PutPixel( 46 + x,91 + y,221,222,222 );
	gfx.PutPixel( 47 + x,91 + y,221,222,222 );
	gfx.PutPixel( 48 + x,91 + y,221,227,227 );
	gfx.PutPixel( 49 + x,91 + y,222,230,230 );
	gfx.PutPixel( 50 + x,91 + y,221,228,228 );
	gfx.PutPixel( 51 + x,91 + y,221,222,222 );
	gfx.PutPixel( 52 + x,91 + y,221,221,221 );
	gfx.PutPixel( 53 + x,91 + y,221,226,226 );
	gfx.PutPixel( 54 + x,91 + y,222,234,234 );
	gfx.PutPixel( 55 + x,91 + y,216,141,141 );
	gfx.PutPixel( 56 + x,91 + y,208,27,27 );
	gfx.PutPixel( 57 + x,91 + y,218,175,175 );
	gfx.PutPixel( 58 + x,91 + y,222,230,230 );
	gfx.PutPixel( 59 + x,91 + y,221,222,222 );
	gfx.PutPixel( 60 + x,91 + y,222,230,230 );
	gfx.PutPixel( 61 + x,91 + y,212,93,93 );
	gfx.PutPixel( 62 + x,91 + y,207,23,23 );
	gfx.PutPixel( 63 + x,91 + y,208,34,34 );
	gfx.PutPixel( 64 + x,91 + y,208,34,34 );
	gfx.PutPixel( 65 + x,91 + y,208,34,34 );
	gfx.PutPixel( 66 + x,91 + y,208,34,34 );
	gfx.PutPixel( 67 + x,91 + y,208,33,33 );
	gfx.PutPixel( 68 + x,91 + y,207,24,24 );
	gfx.PutPixel( 69 + x,91 + y,216,154,154 );
	gfx.PutPixel( 70 + x,91 + y,222,232,232 );
	gfx.PutPixel( 71 + x,91 + y,221,221,221 );
	gfx.PutPixel( 72 + x,91 + y,222,234,234 );
	gfx.PutPixel( 73 + x,91 + y,215,137,137 );
	gfx.PutPixel( 74 + x,91 + y,207,22,22 );
	gfx.PutPixel( 75 + x,91 + y,208,27,27 );
	gfx.PutPixel( 76 + x,91 + y,218,173,173 );
	gfx.PutPixel( 77 + x,91 + y,222,231,231 );
	gfx.PutPixel( 78 + x,91 + y,221,221,221 );
	gfx.PutPixel( 79 + x,91 + y,221,222,222 );
	gfx.PutPixel( 80 + x,91 + y,221,222,222 );
	gfx.PutPixel( 81 + x,91 + y,221,222,222 );
	gfx.PutPixel( 82 + x,91 + y,221,222,222 );
	gfx.PutPixel( 83 + x,91 + y,221,222,222 );
	gfx.PutPixel( 84 + x,91 + y,221,222,222 );
	gfx.PutPixel( 85 + x,91 + y,222,232,232 );
	gfx.PutPixel( 86 + x,91 + y,217,162,162 );
	gfx.PutPixel( 87 + x,91 + y,207,22,22 );
	gfx.PutPixel( 88 + x,91 + y,209,47,47 );
	gfx.PutPixel( 89 + x,91 + y,220,208,208 );
	gfx.PutPixel( 90 + x,91 + y,221,225,225 );
	gfx.PutPixel( 91 + x,91 + y,222,234,234 );
	gfx.PutPixel( 92 + x,91 + y,215,128,128 );
	gfx.PutPixel( 93 + x,91 + y,207,22,22 );
	gfx.PutPixel( 94 + x,91 + y,208,34,34 );
	gfx.PutPixel( 95 + x,91 + y,207,24,24 );
	gfx.PutPixel( 96 + x,91 + y,216,150,150 );
	gfx.PutPixel( 97 + x,91 + y,222,233,233 );
	gfx.PutPixel( 98 + x,91 + y,221,221,221 );
	gfx.PutPixel( 99 + x,91 + y,222,233,233 );
	gfx.PutPixel( 100 + x,91 + y,214,132,132 );
	gfx.PutPixel( 101 + x,91 + y,207,22,22 );
	gfx.PutPixel( 102 + x,91 + y,208,34,34 );
	gfx.PutPixel( 103 + x,91 + y,207,22,22 );
	gfx.PutPixel( 104 + x,91 + y,215,128,128 );
	gfx.PutPixel( 105 + x,91 + y,222,234,234 );
	gfx.PutPixel( 106 + x,91 + y,221,225,225 );
	gfx.PutPixel( 107 + x,91 + y,220,208,208 );
	gfx.PutPixel( 108 + x,91 + y,209,47,47 );
	gfx.PutPixel( 109 + x,91 + y,208,30,30 );
	gfx.PutPixel( 110 + x,91 + y,208,34,34 );
	gfx.PutPixel( 111 + x,91 + y,208,34,34 );
	gfx.PutPixel( 112 + x,91 + y,208,34,34 );
	gfx.PutPixel( 113 + x,91 + y,208,34,34 );
	gfx.PutPixel( 114 + x,91 + y,208,34,34 );
	gfx.PutPixel( 115 + x,91 + y,208,34,34 );
	gfx.PutPixel( 116 + x,91 + y,208,34,34 );
	gfx.PutPixel( 117 + x,91 + y,208,34,34 );
	gfx.PutPixel( 118 + x,91 + y,208,34,34 );
	gfx.PutPixel( 119 + x,91 + y,208,34,34 );
	gfx.PutPixel( 120 + x,91 + y,208,34,34 );
	gfx.PutPixel( 121 + x,91 + y,208,34,34 );
	gfx.PutPixel( 122 + x,91 + y,208,34,34 );
	gfx.PutPixel( 123 + x,91 + y,208,34,34 );
	gfx.PutPixel( 124 + x,91 + y,208,34,34 );
	gfx.PutPixel( 125 + x,91 + y,208,34,34 );
	gfx.PutPixel( 126 + x,91 + y,208,34,34 );
	gfx.PutPixel( 127 + x,91 + y,208,34,34 );
	gfx.PutPixel( 128 + x,91 + y,208,34,34 );
	gfx.PutPixel( 129 + x,91 + y,208,34,34 );
	gfx.PutPixel( 130 + x,91 + y,208,34,34 );
	gfx.PutPixel( 131 + x,91 + y,208,34,34 );
	gfx.PutPixel( 132 + x,91 + y,208,34,34 );
	gfx.PutPixel( 133 + x,91 + y,208,34,34 );
	gfx.PutPixel( 134 + x,91 + y,208,34,34 );
	gfx.PutPixel( 135 + x,91 + y,208,34,34 );
	gfx.PutPixel( 136 + x,91 + y,208,34,34 );
	gfx.PutPixel( 137 + x,91 + y,208,34,34 );
	gfx.PutPixel( 138 + x,91 + y,208,34,34 );
	gfx.PutPixel( 139 + x,91 + y,208,34,34 );
	gfx.PutPixel( 140 + x,91 + y,208,34,34 );
	gfx.PutPixel( 141 + x,91 + y,208,34,34 );
	gfx.PutPixel( 142 + x,91 + y,208,34,34 );
	gfx.PutPixel( 143 + x,91 + y,208,34,34 );
	gfx.PutPixel( 144 + x,91 + y,208,34,34 );
	gfx.PutPixel( 145 + x,91 + y,208,34,34 );
	gfx.PutPixel( 146 + x,91 + y,208,34,34 );
	gfx.PutPixel( 147 + x,91 + y,208,34,34 );
	gfx.PutPixel( 148 + x,91 + y,208,34,34 );
	gfx.PutPixel( 149 + x,91 + y,208,34,34 );
	gfx.PutPixel( 0 + x,92 + y,208,34,34 );
	gfx.PutPixel( 1 + x,92 + y,208,34,34 );
	gfx.PutPixel( 2 + x,92 + y,208,34,34 );
	gfx.PutPixel( 3 + x,92 + y,208,34,34 );
	gfx.PutPixel( 4 + x,92 + y,208,34,34 );
	gfx.PutPixel( 5 + x,92 + y,208,34,34 );
	gfx.PutPixel( 6 + x,92 + y,208,34,34 );
	gfx.PutPixel( 7 + x,92 + y,208,34,34 );
	gfx.PutPixel( 8 + x,92 + y,208,34,34 );
	gfx.PutPixel( 9 + x,92 + y,208,34,34 );
	gfx.PutPixel( 10 + x,92 + y,208,34,34 );
	gfx.PutPixel( 11 + x,92 + y,208,34,34 );
	gfx.PutPixel( 12 + x,92 + y,208,34,34 );
	gfx.PutPixel( 13 + x,92 + y,208,34,34 );
	gfx.PutPixel( 14 + x,92 + y,208,34,34 );
	gfx.PutPixel( 15 + x,92 + y,208,34,34 );
	gfx.PutPixel( 16 + x,92 + y,208,34,34 );
	gfx.PutPixel( 17 + x,92 + y,208,34,34 );
	gfx.PutPixel( 18 + x,92 + y,208,34,34 );
	gfx.PutPixel( 19 + x,92 + y,208,34,34 );
	gfx.PutPixel( 20 + x,92 + y,208,34,34 );
	gfx.PutPixel( 21 + x,92 + y,208,34,34 );
	gfx.PutPixel( 22 + x,92 + y,208,34,34 );
	gfx.PutPixel( 23 + x,92 + y,208,34,34 );
	gfx.PutPixel( 24 + x,92 + y,208,34,34 );
	gfx.PutPixel( 25 + x,92 + y,208,34,34 );
	gfx.PutPixel( 26 + x,92 + y,208,34,34 );
	gfx.PutPixel( 27 + x,92 + y,208,34,34 );
	gfx.PutPixel( 28 + x,92 + y,208,34,34 );
	gfx.PutPixel( 29 + x,92 + y,208,34,34 );
	gfx.PutPixel( 30 + x,92 + y,208,34,34 );
	gfx.PutPixel( 31 + x,92 + y,208,34,34 );
	gfx.PutPixel( 32 + x,92 + y,208,34,34 );
	gfx.PutPixel( 33 + x,92 + y,208,34,34 );
	gfx.PutPixel( 34 + x,92 + y,208,34,34 );
	gfx.PutPixel( 35 + x,92 + y,208,34,34 );
	gfx.PutPixel( 36 + x,92 + y,208,34,34 );
	gfx.PutPixel( 37 + x,92 + y,208,34,34 );
	gfx.PutPixel( 38 + x,92 + y,208,34,34 );
	gfx.PutPixel( 39 + x,92 + y,208,34,34 );
	gfx.PutPixel( 40 + x,92 + y,208,34,34 );
	gfx.PutPixel( 41 + x,92 + y,208,34,34 );
	gfx.PutPixel( 42 + x,92 + y,208,33,33 );
	gfx.PutPixel( 43 + x,92 + y,207,23,23 );
	gfx.PutPixel( 44 + x,92 + y,211,71,71 );
	gfx.PutPixel( 45 + x,92 + y,217,170,170 );
	gfx.PutPixel( 46 + x,92 + y,221,223,223 );
	gfx.PutPixel( 47 + x,92 + y,222,233,233 );
	gfx.PutPixel( 48 + x,92 + y,222,231,231 );
	gfx.PutPixel( 49 + x,92 + y,222,230,230 );
	gfx.PutPixel( 50 + x,92 + y,222,230,230 );
	gfx.PutPixel( 51 + x,92 + y,222,232,232 );
	gfx.PutPixel( 52 + x,92 + y,222,232,232 );
	gfx.PutPixel( 53 + x,92 + y,220,206,206 );
	gfx.PutPixel( 54 + x,92 + y,213,110,110 );
	gfx.PutPixel( 55 + x,92 + y,207,19,19 );
	gfx.PutPixel( 56 + x,92 + y,211,79,79 );
	gfx.PutPixel( 57 + x,92 + y,222,231,231 );
	gfx.PutPixel( 58 + x,92 + y,221,229,229 );
	gfx.PutPixel( 59 + x,92 + y,222,233,233 );
	gfx.PutPixel( 60 + x,92 + y,219,197,197 );
	gfx.PutPixel( 61 + x,92 + y,208,39,39 );
	gfx.PutPixel( 62 + x,92 + y,208,31,31 );
	gfx.PutPixel( 63 + x,92 + y,208,34,34 );
	gfx.PutPixel( 64 + x,92 + y,208,34,34 );
	gfx.PutPixel( 65 + x,92 + y,208,34,34 );
	gfx.PutPixel( 66 + x,92 + y,208,34,34 );
	gfx.PutPixel( 67 + x,92 + y,208,34,34 );
	gfx.PutPixel( 68 + x,92 + y,207,25,25 );
	gfx.PutPixel( 69 + x,92 + y,211,79,79 );
	gfx.PutPixel( 70 + x,92 + y,222,229,229 );
	gfx.PutPixel( 71 + x,92 + y,221,229,229 );
	gfx.PutPixel( 72 + x,92 + y,222,232,232 );
	gfx.PutPixel( 73 + x,92 + y,220,212,212 );
	gfx.PutPixel( 74 + x,92 + y,209,51,51 );
	gfx.PutPixel( 75 + x,92 + y,207,23,23 );
	gfx.PutPixel( 76 + x,92 + y,218,178,178 );
	gfx.PutPixel( 77 + x,92 + y,223,237,237 );
	gfx.PutPixel( 78 + x,92 + y,221,228,228 );
	gfx.PutPixel( 79 + x,92 + y,221,228,228 );
	gfx.PutPixel( 80 + x,92 + y,221,228,228 );
	gfx.PutPixel( 81 + x,92 + y,221,228,228 );
	gfx.PutPixel( 82 + x,92 + y,221,228,228 );
	gfx.PutPixel( 83 + x,92 + y,221,228,228 );
	gfx.PutPixel( 84 + x,92 + y,221,228,228 );
	gfx.PutPixel( 85 + x,92 + y,223,238,238 );
	gfx.PutPixel( 86 + x,92 + y,217,166,166 );
	gfx.PutPixel( 87 + x,92 + y,207,22,22 );
	gfx.PutPixel( 88 + x,92 + y,209,47,47 );
	gfx.PutPixel( 89 + x,92 + y,220,214,214 );
	gfx.PutPixel( 90 + x,92 + y,221,232,232 );
	gfx.PutPixel( 91 + x,92 + y,223,240,240 );
	gfx.PutPixel( 92 + x,92 + y,215,131,131 );
	gfx.PutPixel( 93 + x,92 + y,207,22,22 );
	gfx.PutPixel( 94 + x,92 + y,208,34,34 );
	gfx.PutPixel( 95 + x,92 + y,207,24,24 );
	gfx.PutPixel( 96 + x,92 + y,212,88,88 );
	gfx.PutPixel( 97 + x,92 + y,222,233,233 );
	gfx.PutPixel( 98 + x,92 + y,221,231,231 );
	gfx.PutPixel( 99 + x,92 + y,221,226,226 );
	gfx.PutPixel( 100 + x,92 + y,210,70,70 );
	gfx.PutPixel( 101 + x,92 + y,207,27,27 );
	gfx.PutPixel( 102 + x,92 + y,208,34,34 );
	gfx.PutPixel( 103 + x,92 + y,207,22,22 );
	gfx.PutPixel( 104 + x,92 + y,215,131,131 );
	gfx.PutPixel( 105 + x,92 + y,223,240,240 );
	gfx.PutPixel( 106 + x,92 + y,221,232,232 );
	gfx.PutPixel( 107 + x,92 + y,220,214,214 );
	gfx.PutPixel( 108 + x,92 + y,209,47,47 );
	gfx.PutPixel( 109 + x,92 + y,208,30,30 );
	gfx.PutPixel( 110 + x,92 + y,208,34,34 );
	gfx.PutPixel( 111 + x,92 + y,208,34,34 );
	gfx.PutPixel( 112 + x,92 + y,208,34,34 );
	gfx.PutPixel( 113 + x,92 + y,208,34,34 );
	gfx.PutPixel( 114 + x,92 + y,208,34,34 );
	gfx.PutPixel( 115 + x,92 + y,208,34,34 );
	gfx.PutPixel( 116 + x,92 + y,208,34,34 );
	gfx.PutPixel( 117 + x,92 + y,208,34,34 );
	gfx.PutPixel( 118 + x,92 + y,208,34,34 );
	gfx.PutPixel( 119 + x,92 + y,208,34,34 );
	gfx.PutPixel( 120 + x,92 + y,208,34,34 );
	gfx.PutPixel( 121 + x,92 + y,208,34,34 );
	gfx.PutPixel( 122 + x,92 + y,208,34,34 );
	gfx.PutPixel( 123 + x,92 + y,208,34,34 );
	gfx.PutPixel( 124 + x,92 + y,208,34,34 );
	gfx.PutPixel( 125 + x,92 + y,208,34,34 );
	gfx.PutPixel( 126 + x,92 + y,208,34,34 );
	gfx.PutPixel( 127 + x,92 + y,208,34,34 );
	gfx.PutPixel( 128 + x,92 + y,208,34,34 );
	gfx.PutPixel( 129 + x,92 + y,208,34,34 );
	gfx.PutPixel( 130 + x,92 + y,208,34,34 );
	gfx.PutPixel( 131 + x,92 + y,208,34,34 );
	gfx.PutPixel( 132 + x,92 + y,208,34,34 );
	gfx.PutPixel( 133 + x,92 + y,208,34,34 );
	gfx.PutPixel( 134 + x,92 + y,208,34,34 );
	gfx.PutPixel( 135 + x,92 + y,208,34,34 );
	gfx.PutPixel( 136 + x,92 + y,208,34,34 );
	gfx.PutPixel( 137 + x,92 + y,208,34,34 );
	gfx.PutPixel( 138 + x,92 + y,208,34,34 );
	gfx.PutPixel( 139 + x,92 + y,208,34,34 );
	gfx.PutPixel( 140 + x,92 + y,208,34,34 );
	gfx.PutPixel( 141 + x,92 + y,208,34,34 );
	gfx.PutPixel( 142 + x,92 + y,208,34,34 );
	gfx.PutPixel( 143 + x,92 + y,208,34,34 );
	gfx.PutPixel( 144 + x,92 + y,208,34,34 );
	gfx.PutPixel( 145 + x,92 + y,208,34,34 );
	gfx.PutPixel( 146 + x,92 + y,208,34,34 );
	gfx.PutPixel( 147 + x,92 + y,208,34,34 );
	gfx.PutPixel( 148 + x,92 + y,208,34,34 );
	gfx.PutPixel( 149 + x,92 + y,208,34,34 );
	gfx.PutPixel( 0 + x,93 + y,208,34,34 );
	gfx.PutPixel( 1 + x,93 + y,208,34,34 );
	gfx.PutPixel( 2 + x,93 + y,208,34,34 );
	gfx.PutPixel( 3 + x,93 + y,208,34,34 );
	gfx.PutPixel( 4 + x,93 + y,208,34,34 );
	gfx.PutPixel( 5 + x,93 + y,208,34,34 );
	gfx.PutPixel( 6 + x,93 + y,208,34,34 );
	gfx.PutPixel( 7 + x,93 + y,208,34,34 );
	gfx.PutPixel( 8 + x,93 + y,208,34,34 );
	gfx.PutPixel( 9 + x,93 + y,208,34,34 );
	gfx.PutPixel( 10 + x,93 + y,208,34,34 );
	gfx.PutPixel( 11 + x,93 + y,208,34,34 );
	gfx.PutPixel( 12 + x,93 + y,208,34,34 );
	gfx.PutPixel( 13 + x,93 + y,208,34,34 );
	gfx.PutPixel( 14 + x,93 + y,208,34,34 );
	gfx.PutPixel( 15 + x,93 + y,208,34,34 );
	gfx.PutPixel( 16 + x,93 + y,208,34,34 );
	gfx.PutPixel( 17 + x,93 + y,208,34,34 );
	gfx.PutPixel( 18 + x,93 + y,208,34,34 );
	gfx.PutPixel( 19 + x,93 + y,208,34,34 );
	gfx.PutPixel( 20 + x,93 + y,208,34,34 );
	gfx.PutPixel( 21 + x,93 + y,208,34,34 );
	gfx.PutPixel( 22 + x,93 + y,208,34,34 );
	gfx.PutPixel( 23 + x,93 + y,208,34,34 );
	gfx.PutPixel( 24 + x,93 + y,208,34,34 );
	gfx.PutPixel( 25 + x,93 + y,208,34,34 );
	gfx.PutPixel( 26 + x,93 + y,208,34,34 );
	gfx.PutPixel( 27 + x,93 + y,208,34,34 );
	gfx.PutPixel( 28 + x,93 + y,208,34,34 );
	gfx.PutPixel( 29 + x,93 + y,208,34,34 );
	gfx.PutPixel( 30 + x,93 + y,208,34,34 );
	gfx.PutPixel( 31 + x,93 + y,208,34,34 );
	gfx.PutPixel( 32 + x,93 + y,208,34,34 );
	gfx.PutPixel( 33 + x,93 + y,208,34,34 );
	gfx.PutPixel( 34 + x,93 + y,208,34,34 );
	gfx.PutPixel( 35 + x,93 + y,208,34,34 );
	gfx.PutPixel( 36 + x,93 + y,208,34,34 );
	gfx.PutPixel( 37 + x,93 + y,208,34,34 );
	gfx.PutPixel( 38 + x,93 + y,208,34,34 );
	gfx.PutPixel( 39 + x,93 + y,208,34,34 );
	gfx.PutPixel( 40 + x,93 + y,208,34,34 );
	gfx.PutPixel( 41 + x,93 + y,208,34,34 );
	gfx.PutPixel( 42 + x,93 + y,208,34,34 );
	gfx.PutPixel( 43 + x,93 + y,208,34,34 );
	gfx.PutPixel( 44 + x,93 + y,207,26,26 );
	gfx.PutPixel( 45 + x,93 + y,208,28,28 );
	gfx.PutPixel( 46 + x,93 + y,210,70,70 );
	gfx.PutPixel( 47 + x,93 + y,214,120,120 );
	gfx.PutPixel( 48 + x,93 + y,216,154,154 );
	gfx.PutPixel( 49 + x,93 + y,217,170,170 );
	gfx.PutPixel( 50 + x,93 + y,217,170,170 );
	gfx.PutPixel( 51 + x,93 + y,216,148,148 );
	gfx.PutPixel( 52 + x,93 + y,213,103,103 );
	gfx.PutPixel( 53 + x,93 + y,209,47,47 );
	gfx.PutPixel( 54 + x,93 + y,207,23,23 );
	gfx.PutPixel( 55 + x,93 + y,208,30,30 );
	gfx.PutPixel( 56 + x,93 + y,210,58,58 );
	gfx.PutPixel( 57 + x,93 + y,212,86,86 );
	gfx.PutPixel( 58 + x,93 + y,211,82,82 );
	gfx.PutPixel( 59 + x,93 + y,212,85,85 );
	gfx.PutPixel( 60 + x,93 + y,210,65,65 );
	gfx.PutPixel( 61 + x,93 + y,208,30,30 );
	gfx.PutPixel( 62 + x,93 + y,208,34,34 );
	gfx.PutPixel( 63 + x,93 + y,208,34,34 );
	gfx.PutPixel( 64 + x,93 + y,208,34,34 );
	gfx.PutPixel( 65 + x,93 + y,208,34,34 );
	gfx.PutPixel( 66 + x,93 + y,208,34,34 );
	gfx.PutPixel( 67 + x,93 + y,208,34,34 );
	gfx.PutPixel( 68 + x,93 + y,208,33,33 );
	gfx.PutPixel( 69 + x,93 + y,208,35,35 );
	gfx.PutPixel( 70 + x,93 + y,211,77,77 );
	gfx.PutPixel( 71 + x,93 + y,211,83,83 );
	gfx.PutPixel( 72 + x,93 + y,211,82,82 );
	gfx.PutPixel( 73 + x,93 + y,212,86,86 );
	gfx.PutPixel( 74 + x,93 + y,209,47,47 );
	gfx.PutPixel( 75 + x,93 + y,208,30,30 );
	gfx.PutPixel( 76 + x,93 + y,211,70,70 );
	gfx.PutPixel( 77 + x,93 + y,212,85,85 );
	gfx.PutPixel( 78 + x,93 + y,211,82,82 );
	gfx.PutPixel( 79 + x,93 + y,211,82,82 );
	gfx.PutPixel( 80 + x,93 + y,211,82,82 );
	gfx.PutPixel( 81 + x,93 + y,211,82,82 );
	gfx.PutPixel( 82 + x,93 + y,211,82,82 );
	gfx.PutPixel( 83 + x,93 + y,211,82,82 );
	gfx.PutPixel( 84 + x,93 + y,211,82,82 );
	gfx.PutPixel( 85 + x,93 + y,212,85,85 );
	gfx.PutPixel( 86 + x,93 + y,210,67,67 );
	gfx.PutPixel( 87 + x,93 + y,208,31,31 );
	gfx.PutPixel( 88 + x,93 + y,208,37,37 );
	gfx.PutPixel( 89 + x,93 + y,211,79,79 );
	gfx.PutPixel( 90 + x,93 + y,211,83,83 );
	gfx.PutPixel( 91 + x,93 + y,212,85,85 );
	gfx.PutPixel( 92 + x,93 + y,210,58,58 );
	gfx.PutPixel( 93 + x,93 + y,208,31,31 );
	gfx.PutPixel( 94 + x,93 + y,208,34,34 );
	gfx.PutPixel( 95 + x,93 + y,208,33,33 );
	gfx.PutPixel( 96 + x,93 + y,208,39,39 );
	gfx.PutPixel( 97 + x,93 + y,211,80,80 );
	gfx.PutPixel( 98 + x,93 + y,211,84,84 );
	gfx.PutPixel( 99 + x,93 + y,211,77,77 );
	gfx.PutPixel( 100 + x,93 + y,208,35,35 );
	gfx.PutPixel( 101 + x,93 + y,208,33,33 );
	gfx.PutPixel( 102 + x,93 + y,208,34,34 );
	gfx.PutPixel( 103 + x,93 + y,208,31,31 );
	gfx.PutPixel( 104 + x,93 + y,210,58,58 );
	gfx.PutPixel( 105 + x,93 + y,212,85,85 );
	gfx.PutPixel( 106 + x,93 + y,211,83,83 );
	gfx.PutPixel( 107 + x,93 + y,211,79,79 );
	gfx.PutPixel( 108 + x,93 + y,208,37,37 );
	gfx.PutPixel( 109 + x,93 + y,208,33,33 );
	gfx.PutPixel( 110 + x,93 + y,208,34,34 );
	gfx.PutPixel( 111 + x,93 + y,208,34,34 );
	gfx.PutPixel( 112 + x,93 + y,208,34,34 );
	gfx.PutPixel( 113 + x,93 + y,208,34,34 );
	gfx.PutPixel( 114 + x,93 + y,208,34,34 );
	gfx.PutPixel( 115 + x,93 + y,208,34,34 );
	gfx.PutPixel( 116 + x,93 + y,208,34,34 );
	gfx.PutPixel( 117 + x,93 + y,208,34,34 );
	gfx.PutPixel( 118 + x,93 + y,208,34,34 );
	gfx.PutPixel( 119 + x,93 + y,208,34,34 );
	gfx.PutPixel( 120 + x,93 + y,208,34,34 );
	gfx.PutPixel( 121 + x,93 + y,208,34,34 );
	gfx.PutPixel( 122 + x,93 + y,208,34,34 );
	gfx.PutPixel( 123 + x,93 + y,208,34,34 );
	gfx.PutPixel( 124 + x,93 + y,208,34,34 );
	gfx.PutPixel( 125 + x,93 + y,208,34,34 );
	gfx.PutPixel( 126 + x,93 + y,208,34,34 );
	gfx.PutPixel( 127 + x,93 + y,208,34,34 );
	gfx.PutPixel( 128 + x,93 + y,208,34,34 );
	gfx.PutPixel( 129 + x,93 + y,208,34,34 );
	gfx.PutPixel( 130 + x,93 + y,208,34,34 );
	gfx.PutPixel( 131 + x,93 + y,208,34,34 );
	gfx.PutPixel( 132 + x,93 + y,208,34,34 );
	gfx.PutPixel( 133 + x,93 + y,208,34,34 );
	gfx.PutPixel( 134 + x,93 + y,208,34,34 );
	gfx.PutPixel( 135 + x,93 + y,208,34,34 );
	gfx.PutPixel( 136 + x,93 + y,208,34,34 );
	gfx.PutPixel( 137 + x,93 + y,208,34,34 );
	gfx.PutPixel( 138 + x,93 + y,208,34,34 );
	gfx.PutPixel( 139 + x,93 + y,208,34,34 );
	gfx.PutPixel( 140 + x,93 + y,208,34,34 );
	gfx.PutPixel( 141 + x,93 + y,208,34,34 );
	gfx.PutPixel( 142 + x,93 + y,208,34,34 );
	gfx.PutPixel( 143 + x,93 + y,208,34,34 );
	gfx.PutPixel( 144 + x,93 + y,208,34,34 );
	gfx.PutPixel( 145 + x,93 + y,208,34,34 );
	gfx.PutPixel( 146 + x,93 + y,208,34,34 );
	gfx.PutPixel( 147 + x,93 + y,208,34,34 );
	gfx.PutPixel( 148 + x,93 + y,208,34,34 );
	gfx.PutPixel( 149 + x,93 + y,208,34,34 );
	gfx.PutPixel( 0 + x,94 + y,208,34,34 );
	gfx.PutPixel( 1 + x,94 + y,208,34,34 );
	gfx.PutPixel( 2 + x,94 + y,208,34,34 );
	gfx.PutPixel( 3 + x,94 + y,208,34,34 );
	gfx.PutPixel( 4 + x,94 + y,208,34,34 );
	gfx.PutPixel( 5 + x,94 + y,208,34,34 );
	gfx.PutPixel( 6 + x,94 + y,208,34,34 );
	gfx.PutPixel( 7 + x,94 + y,208,34,34 );
	gfx.PutPixel( 8 + x,94 + y,208,34,34 );
	gfx.PutPixel( 9 + x,94 + y,208,34,34 );
	gfx.PutPixel( 10 + x,94 + y,208,34,34 );
	gfx.PutPixel( 11 + x,94 + y,208,34,34 );
	gfx.PutPixel( 12 + x,94 + y,208,34,34 );
	gfx.PutPixel( 13 + x,94 + y,208,34,34 );
	gfx.PutPixel( 14 + x,94 + y,208,34,34 );
	gfx.PutPixel( 15 + x,94 + y,208,34,34 );
	gfx.PutPixel( 16 + x,94 + y,208,34,34 );
	gfx.PutPixel( 17 + x,94 + y,208,34,34 );
	gfx.PutPixel( 18 + x,94 + y,208,34,34 );
	gfx.PutPixel( 19 + x,94 + y,208,34,34 );
	gfx.PutPixel( 20 + x,94 + y,208,34,34 );
	gfx.PutPixel( 21 + x,94 + y,208,34,34 );
	gfx.PutPixel( 22 + x,94 + y,208,34,34 );
	gfx.PutPixel( 23 + x,94 + y,208,34,34 );
	gfx.PutPixel( 24 + x,94 + y,208,34,34 );
	gfx.PutPixel( 25 + x,94 + y,208,34,34 );
	gfx.PutPixel( 26 + x,94 + y,208,34,34 );
	gfx.PutPixel( 27 + x,94 + y,208,34,34 );
	gfx.PutPixel( 28 + x,94 + y,208,34,34 );
	gfx.PutPixel( 29 + x,94 + y,208,34,34 );
	gfx.PutPixel( 30 + x,94 + y,208,34,34 );
	gfx.PutPixel( 31 + x,94 + y,208,34,34 );
	gfx.PutPixel( 32 + x,94 + y,208,34,34 );
	gfx.PutPixel( 33 + x,94 + y,208,34,34 );
	gfx.PutPixel( 34 + x,94 + y,208,34,34 );
	gfx.PutPixel( 35 + x,94 + y,208,34,34 );
	gfx.PutPixel( 36 + x,94 + y,208,34,34 );
	gfx.PutPixel( 37 + x,94 + y,208,34,34 );
	gfx.PutPixel( 38 + x,94 + y,208,34,34 );
	gfx.PutPixel( 39 + x,94 + y,208,34,34 );
	gfx.PutPixel( 40 + x,94 + y,208,34,34 );
	gfx.PutPixel( 41 + x,94 + y,208,34,34 );
	gfx.PutPixel( 42 + x,94 + y,208,34,34 );
	gfx.PutPixel( 43 + x,94 + y,208,34,34 );
	gfx.PutPixel( 44 + x,94 + y,208,34,34 );
	gfx.PutPixel( 45 + x,94 + y,208,33,33 );
	gfx.PutPixel( 46 + x,94 + y,208,27,27 );
	gfx.PutPixel( 47 + x,94 + y,207,23,23 );
	gfx.PutPixel( 48 + x,94 + y,207,25,25 );
	gfx.PutPixel( 49 + x,94 + y,208,27,27 );
	gfx.PutPixel( 50 + x,94 + y,208,27,27 );
	gfx.PutPixel( 51 + x,94 + y,207,24,24 );
	gfx.PutPixel( 52 + x,94 + y,207,24,24 );
	gfx.PutPixel( 53 + x,94 + y,208,30,30 );
	gfx.PutPixel( 54 + x,94 + y,208,34,34 );
	gfx.PutPixel( 55 + x,94 + y,208,35,35 );
	gfx.PutPixel( 56 + x,94 + y,208,30,30 );
	gfx.PutPixel( 57 + x,94 + y,207,25,25 );
	gfx.PutPixel( 58 + x,94 + y,207,25,25 );
	gfx.PutPixel( 59 + x,94 + y,207,25,25 );
	gfx.PutPixel( 60 + x,94 + y,208,28,28 );
	gfx.PutPixel( 61 + x,94 + y,208,34,34 );
	gfx.PutPixel( 62 + x,94 + y,208,34,34 );
	gfx.PutPixel( 63 + x,94 + y,208,34,34 );
	gfx.PutPixel( 64 + x,94 + y,208,34,34 );
	gfx.PutPixel( 65 + x,94 + y,208,34,34 );
	gfx.PutPixel( 66 + x,94 + y,208,34,34 );
	gfx.PutPixel( 67 + x,94 + y,208,34,34 );
	gfx.PutPixel( 68 + x,94 + y,208,34,34 );
	gfx.PutPixel( 69 + x,94 + y,208,33,33 );
	gfx.PutPixel( 70 + x,94 + y,207,26,26 );
	gfx.PutPixel( 71 + x,94 + y,207,25,25 );
	gfx.PutPixel( 72 + x,94 + y,207,25,25 );
	gfx.PutPixel( 73 + x,94 + y,207,25,25 );
	gfx.PutPixel( 74 + x,94 + y,208,32,32 );
	gfx.PutPixel( 75 + x,94 + y,208,35,35 );
	gfx.PutPixel( 76 + x,94 + y,208,28,28 );
	gfx.PutPixel( 77 + x,94 + y,207,25,25 );
	gfx.PutPixel( 78 + x,94 + y,207,25,25 );
	gfx.PutPixel( 79 + x,94 + y,207,25,25 );
	gfx.PutPixel( 80 + x,94 + y,207,25,25 );
	gfx.PutPixel( 81 + x,94 + y,207,25,25 );
	gfx.PutPixel( 82 + x,94 + y,207,25,25 );
	gfx.PutPixel( 83 + x,94 + y,207,25,25 );
	gfx.PutPixel( 84 + x,94 + y,207,25,25 );
	gfx.PutPixel( 85 + x,94 + y,207,25,25 );
	gfx.PutPixel( 86 + x,94 + y,208,28,28 );
	gfx.PutPixel( 87 + x,94 + y,208,35,35 );
	gfx.PutPixel( 88 + x,94 + y,208,33,33 );
	gfx.PutPixel( 89 + x,94 + y,207,26,26 );
	gfx.PutPixel( 90 + x,94 + y,207,25,25 );
	gfx.PutPixel( 91 + x,94 + y,207,25,25 );
	gfx.PutPixel( 92 + x,94 + y,208,30,30 );
	gfx.PutPixel( 93 + x,94 + y,208,35,35 );
	gfx.PutPixel( 94 + x,94 + y,208,34,34 );
	gfx.PutPixel( 95 + x,94 + y,208,34,34 );
	gfx.PutPixel( 96 + x,94 + y,208,33,33 );
	gfx.PutPixel( 97 + x,94 + y,207,25,25 );
	gfx.PutPixel( 98 + x,94 + y,207,25,25 );
	gfx.PutPixel( 99 + x,94 + y,207,26,26 );
	gfx.PutPixel( 100 + x,94 + y,208,33,33 );
	gfx.PutPixel( 101 + x,94 + y,208,34,34 );
	gfx.PutPixel( 102 + x,94 + y,208,34,34 );
	gfx.PutPixel( 103 + x,94 + y,208,35,35 );
	gfx.PutPixel( 104 + x,94 + y,208,30,30 );
	gfx.PutPixel( 105 + x,94 + y,207,25,25 );
	gfx.PutPixel( 106 + x,94 + y,207,25,25 );
	gfx.PutPixel( 107 + x,94 + y,207,26,26 );
	gfx.PutPixel( 108 + x,94 + y,208,33,33 );
	gfx.PutPixel( 109 + x,94 + y,208,34,34 );
	gfx.PutPixel( 110 + x,94 + y,208,34,34 );
	gfx.PutPixel( 111 + x,94 + y,208,34,34 );
	gfx.PutPixel( 112 + x,94 + y,208,34,34 );
	gfx.PutPixel( 113 + x,94 + y,208,34,34 );
	gfx.PutPixel( 114 + x,94 + y,208,34,34 );
	gfx.PutPixel( 115 + x,94 + y,208,34,34 );
	gfx.PutPixel( 116 + x,94 + y,208,34,34 );
	gfx.PutPixel( 117 + x,94 + y,208,34,34 );
	gfx.PutPixel( 118 + x,94 + y,208,34,34 );
	gfx.PutPixel( 119 + x,94 + y,208,34,34 );
	gfx.PutPixel( 120 + x,94 + y,208,34,34 );
	gfx.PutPixel( 121 + x,94 + y,208,34,34 );
	gfx.PutPixel( 122 + x,94 + y,208,34,34 );
	gfx.PutPixel( 123 + x,94 + y,208,34,34 );
	gfx.PutPixel( 124 + x,94 + y,208,34,34 );
	gfx.PutPixel( 125 + x,94 + y,208,34,34 );
	gfx.PutPixel( 126 + x,94 + y,208,34,34 );
	gfx.PutPixel( 127 + x,94 + y,208,34,34 );
	gfx.PutPixel( 128 + x,94 + y,208,34,34 );
	gfx.PutPixel( 129 + x,94 + y,208,34,34 );
	gfx.PutPixel( 130 + x,94 + y,208,34,34 );
	gfx.PutPixel( 131 + x,94 + y,208,34,34 );
	gfx.PutPixel( 132 + x,94 + y,208,34,34 );
	gfx.PutPixel( 133 + x,94 + y,208,34,34 );
	gfx.PutPixel( 134 + x,94 + y,208,34,34 );
	gfx.PutPixel( 135 + x,94 + y,208,34,34 );
	gfx.PutPixel( 136 + x,94 + y,208,34,34 );
	gfx.PutPixel( 137 + x,94 + y,208,34,34 );
	gfx.PutPixel( 138 + x,94 + y,208,34,34 );
	gfx.PutPixel( 139 + x,94 + y,208,34,34 );
	gfx.PutPixel( 140 + x,94 + y,208,34,34 );
	gfx.PutPixel( 141 + x,94 + y,208,34,34 );
	gfx.PutPixel( 142 + x,94 + y,208,34,34 );
	gfx.PutPixel( 143 + x,94 + y,208,34,34 );
	gfx.PutPixel( 144 + x,94 + y,208,34,34 );
	gfx.PutPixel( 145 + x,94 + y,208,34,34 );
	gfx.PutPixel( 146 + x,94 + y,208,34,34 );
	gfx.PutPixel( 147 + x,94 + y,208,34,34 );
	gfx.PutPixel( 148 + x,94 + y,208,34,34 );
	gfx.PutPixel( 149 + x,94 + y,208,34,34 );
	gfx.PutPixel( 0 + x,95 + y,208,34,34 );
	gfx.PutPixel( 1 + x,95 + y,208,34,34 );
	gfx.PutPixel( 2 + x,95 + y,208,34,34 );
	gfx.PutPixel( 3 + x,95 + y,208,34,34 );
	gfx.PutPixel( 4 + x,95 + y,208,34,34 );
	gfx.PutPixel( 5 + x,95 + y,208,34,34 );
	gfx.PutPixel( 6 + x,95 + y,208,34,34 );
	gfx.PutPixel( 7 + x,95 + y,208,34,34 );
	gfx.PutPixel( 8 + x,95 + y,208,34,34 );
	gfx.PutPixel( 9 + x,95 + y,208,34,34 );
	gfx.PutPixel( 10 + x,95 + y,208,34,34 );
	gfx.PutPixel( 11 + x,95 + y,208,34,34 );
	gfx.PutPixel( 12 + x,95 + y,208,34,34 );
	gfx.PutPixel( 13 + x,95 + y,208,34,34 );
	gfx.PutPixel( 14 + x,95 + y,208,34,34 );
	gfx.PutPixel( 15 + x,95 + y,208,34,34 );
	gfx.PutPixel( 16 + x,95 + y,208,34,34 );
	gfx.PutPixel( 17 + x,95 + y,208,34,34 );
	gfx.PutPixel( 18 + x,95 + y,208,34,34 );
	gfx.PutPixel( 19 + x,95 + y,208,34,34 );
	gfx.PutPixel( 20 + x,95 + y,208,34,34 );
	gfx.PutPixel( 21 + x,95 + y,208,34,34 );
	gfx.PutPixel( 22 + x,95 + y,208,34,34 );
	gfx.PutPixel( 23 + x,95 + y,208,34,34 );
	gfx.PutPixel( 24 + x,95 + y,208,34,34 );
	gfx.PutPixel( 25 + x,95 + y,208,34,34 );
	gfx.PutPixel( 26 + x,95 + y,208,34,34 );
	gfx.PutPixel( 27 + x,95 + y,208,34,34 );
	gfx.PutPixel( 28 + x,95 + y,208,34,34 );
	gfx.PutPixel( 29 + x,95 + y,208,34,34 );
	gfx.PutPixel( 30 + x,95 + y,208,34,34 );
	gfx.PutPixel( 31 + x,95 + y,208,34,34 );
	gfx.PutPixel( 32 + x,95 + y,208,34,34 );
	gfx.PutPixel( 33 + x,95 + y,208,34,34 );
	gfx.PutPixel( 34 + x,95 + y,208,34,34 );
	gfx.PutPixel( 35 + x,95 + y,208,34,34 );
	gfx.PutPixel( 36 + x,95 + y,208,34,34 );
	gfx.PutPixel( 37 + x,95 + y,208,34,34 );
	gfx.PutPixel( 38 + x,95 + y,208,34,34 );
	gfx.PutPixel( 39 + x,95 + y,208,34,34 );
	gfx.PutPixel( 40 + x,95 + y,208,34,34 );
	gfx.PutPixel( 41 + x,95 + y,208,34,34 );
	gfx.PutPixel( 42 + x,95 + y,208,34,34 );
	gfx.PutPixel( 43 + x,95 + y,208,34,34 );
	gfx.PutPixel( 44 + x,95 + y,208,34,34 );
	gfx.PutPixel( 45 + x,95 + y,208,34,34 );
	gfx.PutPixel( 46 + x,95 + y,208,34,34 );
	gfx.PutPixel( 47 + x,95 + y,208,34,34 );
	gfx.PutPixel( 48 + x,95 + y,208,34,34 );
	gfx.PutPixel( 49 + x,95 + y,208,34,34 );
	gfx.PutPixel( 50 + x,95 + y,208,34,34 );
	gfx.PutPixel( 51 + x,95 + y,208,34,34 );
	gfx.PutPixel( 52 + x,95 + y,208,34,34 );
	gfx.PutPixel( 53 + x,95 + y,208,34,34 );
	gfx.PutPixel( 54 + x,95 + y,208,34,34 );
	gfx.PutPixel( 55 + x,95 + y,208,34,34 );
	gfx.PutPixel( 56 + x,95 + y,208,34,34 );
	gfx.PutPixel( 57 + x,95 + y,208,34,34 );
	gfx.PutPixel( 58 + x,95 + y,208,34,34 );
	gfx.PutPixel( 59 + x,95 + y,208,34,34 );
	gfx.PutPixel( 60 + x,95 + y,208,34,34 );
	gfx.PutPixel( 61 + x,95 + y,208,34,34 );
	gfx.PutPixel( 62 + x,95 + y,208,34,34 );
	gfx.PutPixel( 63 + x,95 + y,208,34,34 );
	gfx.PutPixel( 64 + x,95 + y,208,34,34 );
	gfx.PutPixel( 65 + x,95 + y,208,34,34 );
	gfx.PutPixel( 66 + x,95 + y,208,34,34 );
	gfx.PutPixel( 67 + x,95 + y,208,34,34 );
	gfx.PutPixel( 68 + x,95 + y,208,34,34 );
	gfx.PutPixel( 69 + x,95 + y,208,34,34 );
	gfx.PutPixel( 70 + x,95 + y,208,34,34 );
	gfx.PutPixel( 71 + x,95 + y,208,34,34 );
	gfx.PutPixel( 72 + x,95 + y,208,34,34 );
	gfx.PutPixel( 73 + x,95 + y,208,34,34 );
	gfx.PutPixel( 74 + x,95 + y,208,34,34 );
	gfx.PutPixel( 75 + x,95 + y,208,34,34 );
	gfx.PutPixel( 76 + x,95 + y,208,34,34 );
	gfx.PutPixel( 77 + x,95 + y,208,34,34 );
	gfx.PutPixel( 78 + x,95 + y,208,34,34 );
	gfx.PutPixel( 79 + x,95 + y,208,34,34 );
	gfx.PutPixel( 80 + x,95 + y,208,34,34 );
	gfx.PutPixel( 81 + x,95 + y,208,34,34 );
	gfx.PutPixel( 82 + x,95 + y,208,34,34 );
	gfx.PutPixel( 83 + x,95 + y,208,34,34 );
	gfx.PutPixel( 84 + x,95 + y,208,34,34 );
	gfx.PutPixel( 85 + x,95 + y,208,34,34 );
	gfx.PutPixel( 86 + x,95 + y,208,34,34 );
	gfx.PutPixel( 87 + x,95 + y,208,34,34 );
	gfx.PutPixel( 88 + x,95 + y,208,34,34 );
	gfx.PutPixel( 89 + x,95 + y,208,34,34 );
	gfx.PutPixel( 90 + x,95 + y,208,34,34 );
	gfx.PutPixel( 91 + x,95 + y,208,34,34 );
	gfx.PutPixel( 92 + x,95 + y,208,34,34 );
	gfx.PutPixel( 93 + x,95 + y,208,34,34 );
	gfx.PutPixel( 94 + x,95 + y,208,34,34 );
	gfx.PutPixel( 95 + x,95 + y,208,34,34 );
	gfx.PutPixel( 96 + x,95 + y,208,34,34 );
	gfx.PutPixel( 97 + x,95 + y,208,34,34 );
	gfx.PutPixel( 98 + x,95 + y,208,34,34 );
	gfx.PutPixel( 99 + x,95 + y,208,34,34 );
	gfx.PutPixel( 100 + x,95 + y,208,34,34 );
	gfx.PutPixel( 101 + x,95 + y,208,34,34 );
	gfx.PutPixel( 102 + x,95 + y,208,34,34 );
	gfx.PutPixel( 103 + x,95 + y,208,34,34 );
	gfx.PutPixel( 104 + x,95 + y,208,34,34 );
	gfx.PutPixel( 105 + x,95 + y,208,34,34 );
	gfx.PutPixel( 106 + x,95 + y,208,34,34 );
	gfx.PutPixel( 107 + x,95 + y,208,34,34 );
	gfx.PutPixel( 108 + x,95 + y,208,34,34 );
	gfx.PutPixel( 109 + x,95 + y,208,34,34 );
	gfx.PutPixel( 110 + x,95 + y,208,34,34 );
	gfx.PutPixel( 111 + x,95 + y,208,34,34 );
	gfx.PutPixel( 112 + x,95 + y,208,34,34 );
	gfx.PutPixel( 113 + x,95 + y,208,34,34 );
	gfx.PutPixel( 114 + x,95 + y,208,34,34 );
	gfx.PutPixel( 115 + x,95 + y,208,34,34 );
	gfx.PutPixel( 116 + x,95 + y,208,34,34 );
	gfx.PutPixel( 117 + x,95 + y,208,34,34 );
	gfx.PutPixel( 118 + x,95 + y,208,34,34 );
	gfx.PutPixel( 119 + x,95 + y,208,34,34 );
	gfx.PutPixel( 120 + x,95 + y,208,34,34 );
	gfx.PutPixel( 121 + x,95 + y,208,34,34 );
	gfx.PutPixel( 122 + x,95 + y,208,34,34 );
	gfx.PutPixel( 123 + x,95 + y,208,34,34 );
	gfx.PutPixel( 124 + x,95 + y,208,34,34 );
	gfx.PutPixel( 125 + x,95 + y,208,34,34 );
	gfx.PutPixel( 126 + x,95 + y,208,34,34 );
	gfx.PutPixel( 127 + x,95 + y,208,34,34 );
	gfx.PutPixel( 128 + x,95 + y,208,34,34 );
	gfx.PutPixel( 129 + x,95 + y,208,34,34 );
	gfx.PutPixel( 130 + x,95 + y,208,34,34 );
	gfx.PutPixel( 131 + x,95 + y,208,34,34 );
	gfx.PutPixel( 132 + x,95 + y,208,34,34 );
	gfx.PutPixel( 133 + x,95 + y,208,34,34 );
	gfx.PutPixel( 134 + x,95 + y,208,34,34 );
	gfx.PutPixel( 135 + x,95 + y,208,34,34 );
	gfx.PutPixel( 136 + x,95 + y,208,34,34 );
	gfx.PutPixel( 137 + x,95 + y,208,34,34 );
	gfx.PutPixel( 138 + x,95 + y,208,34,34 );
	gfx.PutPixel( 139 + x,95 + y,208,34,34 );
	gfx.PutPixel( 140 + x,95 + y,208,34,34 );
	gfx.PutPixel( 141 + x,95 + y,208,34,34 );
	gfx.PutPixel( 142 + x,95 + y,208,34,34 );
	gfx.PutPixel( 143 + x,95 + y,208,34,34 );
	gfx.PutPixel( 144 + x,95 + y,208,34,34 );
	gfx.PutPixel( 145 + x,95 + y,208,34,34 );
	gfx.PutPixel( 146 + x,95 + y,208,34,34 );
	gfx.PutPixel( 147 + x,95 + y,208,34,34 );
	gfx.PutPixel( 148 + x,95 + y,208,34,34 );
	gfx.PutPixel( 149 + x,95 + y,208,34,34 );
	gfx.PutPixel( 0 + x,96 + y,208,34,34 );
	gfx.PutPixel( 1 + x,96 + y,208,34,34 );
	gfx.PutPixel( 2 + x,96 + y,208,34,34 );
	gfx.PutPixel( 3 + x,96 + y,208,34,34 );
	gfx.PutPixel( 4 + x,96 + y,208,34,34 );
	gfx.PutPixel( 5 + x,96 + y,208,34,34 );
	gfx.PutPixel( 6 + x,96 + y,208,34,34 );
	gfx.PutPixel( 7 + x,96 + y,208,34,34 );
	gfx.PutPixel( 8 + x,96 + y,208,34,34 );
	gfx.PutPixel( 9 + x,96 + y,208,34,34 );
	gfx.PutPixel( 10 + x,96 + y,208,34,34 );
	gfx.PutPixel( 11 + x,96 + y,208,34,34 );
	gfx.PutPixel( 12 + x,96 + y,208,34,34 );
	gfx.PutPixel( 13 + x,96 + y,208,34,34 );
	gfx.PutPixel( 14 + x,96 + y,208,34,34 );
	gfx.PutPixel( 15 + x,96 + y,208,34,34 );
	gfx.PutPixel( 16 + x,96 + y,208,34,34 );
	gfx.PutPixel( 17 + x,96 + y,208,34,34 );
	gfx.PutPixel( 18 + x,96 + y,208,34,34 );
	gfx.PutPixel( 19 + x,96 + y,208,34,34 );
	gfx.PutPixel( 20 + x,96 + y,208,34,34 );
	gfx.PutPixel( 21 + x,96 + y,208,34,34 );
	gfx.PutPixel( 22 + x,96 + y,208,34,34 );
	gfx.PutPixel( 23 + x,96 + y,208,34,34 );
	gfx.PutPixel( 24 + x,96 + y,208,34,34 );
	gfx.PutPixel( 25 + x,96 + y,208,34,34 );
	gfx.PutPixel( 26 + x,96 + y,208,34,34 );
	gfx.PutPixel( 27 + x,96 + y,208,34,34 );
	gfx.PutPixel( 28 + x,96 + y,208,34,34 );
	gfx.PutPixel( 29 + x,96 + y,208,34,34 );
	gfx.PutPixel( 30 + x,96 + y,208,34,34 );
	gfx.PutPixel( 31 + x,96 + y,208,34,34 );
	gfx.PutPixel( 32 + x,96 + y,208,34,34 );
	gfx.PutPixel( 33 + x,96 + y,208,34,34 );
	gfx.PutPixel( 34 + x,96 + y,208,34,34 );
	gfx.PutPixel( 35 + x,96 + y,208,34,34 );
	gfx.PutPixel( 36 + x,96 + y,208,34,34 );
	gfx.PutPixel( 37 + x,96 + y,208,34,34 );
	gfx.PutPixel( 38 + x,96 + y,208,34,34 );
	gfx.PutPixel( 39 + x,96 + y,208,34,34 );
	gfx.PutPixel( 40 + x,96 + y,208,34,34 );
	gfx.PutPixel( 41 + x,96 + y,208,34,34 );
	gfx.PutPixel( 42 + x,96 + y,208,34,34 );
	gfx.PutPixel( 43 + x,96 + y,208,34,34 );
	gfx.PutPixel( 44 + x,96 + y,208,34,34 );
	gfx.PutPixel( 45 + x,96 + y,208,34,34 );
	gfx.PutPixel( 46 + x,96 + y,208,34,34 );
	gfx.PutPixel( 47 + x,96 + y,208,34,34 );
	gfx.PutPixel( 48 + x,96 + y,208,34,34 );
	gfx.PutPixel( 49 + x,96 + y,208,34,34 );
	gfx.PutPixel( 50 + x,96 + y,208,34,34 );
	gfx.PutPixel( 51 + x,96 + y,208,34,34 );
	gfx.PutPixel( 52 + x,96 + y,208,34,34 );
	gfx.PutPixel( 53 + x,96 + y,208,34,34 );
	gfx.PutPixel( 54 + x,96 + y,208,34,34 );
	gfx.PutPixel( 55 + x,96 + y,208,34,34 );
	gfx.PutPixel( 56 + x,96 + y,208,34,34 );
	gfx.PutPixel( 57 + x,96 + y,208,34,34 );
	gfx.PutPixel( 58 + x,96 + y,208,34,34 );
	gfx.PutPixel( 59 + x,96 + y,208,34,34 );
	gfx.PutPixel( 60 + x,96 + y,208,34,34 );
	gfx.PutPixel( 61 + x,96 + y,208,34,34 );
	gfx.PutPixel( 62 + x,96 + y,208,34,34 );
	gfx.PutPixel( 63 + x,96 + y,208,34,34 );
	gfx.PutPixel( 64 + x,96 + y,208,34,34 );
	gfx.PutPixel( 65 + x,96 + y,208,34,34 );
	gfx.PutPixel( 66 + x,96 + y,208,34,34 );
	gfx.PutPixel( 67 + x,96 + y,208,34,34 );
	gfx.PutPixel( 68 + x,96 + y,208,34,34 );
	gfx.PutPixel( 69 + x,96 + y,208,34,34 );
	gfx.PutPixel( 70 + x,96 + y,208,34,34 );
	gfx.PutPixel( 71 + x,96 + y,208,34,34 );
	gfx.PutPixel( 72 + x,96 + y,208,34,34 );
	gfx.PutPixel( 73 + x,96 + y,208,34,34 );
	gfx.PutPixel( 74 + x,96 + y,208,34,34 );
	gfx.PutPixel( 75 + x,96 + y,208,34,34 );
	gfx.PutPixel( 76 + x,96 + y,208,34,34 );
	gfx.PutPixel( 77 + x,96 + y,208,34,34 );
	gfx.PutPixel( 78 + x,96 + y,208,34,34 );
	gfx.PutPixel( 79 + x,96 + y,208,34,34 );
	gfx.PutPixel( 80 + x,96 + y,208,34,34 );
	gfx.PutPixel( 81 + x,96 + y,208,34,34 );
	gfx.PutPixel( 82 + x,96 + y,208,34,34 );
	gfx.PutPixel( 83 + x,96 + y,208,34,34 );
	gfx.PutPixel( 84 + x,96 + y,208,34,34 );
	gfx.PutPixel( 85 + x,96 + y,208,34,34 );
	gfx.PutPixel( 86 + x,96 + y,208,34,34 );
	gfx.PutPixel( 87 + x,96 + y,208,34,34 );
	gfx.PutPixel( 88 + x,96 + y,208,34,34 );
	gfx.PutPixel( 89 + x,96 + y,208,34,34 );
	gfx.PutPixel( 90 + x,96 + y,208,34,34 );
	gfx.PutPixel( 91 + x,96 + y,208,34,34 );
	gfx.PutPixel( 92 + x,96 + y,208,34,34 );
	gfx.PutPixel( 93 + x,96 + y,208,34,34 );
	gfx.PutPixel( 94 + x,96 + y,208,34,34 );
	gfx.PutPixel( 95 + x,96 + y,208,34,34 );
	gfx.PutPixel( 96 + x,96 + y,208,34,34 );
	gfx.PutPixel( 97 + x,96 + y,208,34,34 );
	gfx.PutPixel( 98 + x,96 + y,208,34,34 );
	gfx.PutPixel( 99 + x,96 + y,208,34,34 );
	gfx.PutPixel( 100 + x,96 + y,208,34,34 );
	gfx.PutPixel( 101 + x,96 + y,208,34,34 );
	gfx.PutPixel( 102 + x,96 + y,208,34,34 );
	gfx.PutPixel( 103 + x,96 + y,208,34,34 );
	gfx.PutPixel( 104 + x,96 + y,208,34,34 );
	gfx.PutPixel( 105 + x,96 + y,208,34,34 );
	gfx.PutPixel( 106 + x,96 + y,208,34,34 );
	gfx.PutPixel( 107 + x,96 + y,208,34,34 );
	gfx.PutPixel( 108 + x,96 + y,208,34,34 );
	gfx.PutPixel( 109 + x,96 + y,208,34,34 );
	gfx.PutPixel( 110 + x,96 + y,208,34,34 );
	gfx.PutPixel( 111 + x,96 + y,208,34,34 );
	gfx.PutPixel( 112 + x,96 + y,208,34,34 );
	gfx.PutPixel( 113 + x,96 + y,208,34,34 );
	gfx.PutPixel( 114 + x,96 + y,208,34,34 );
	gfx.PutPixel( 115 + x,96 + y,208,34,34 );
	gfx.PutPixel( 116 + x,96 + y,208,34,34 );
	gfx.PutPixel( 117 + x,96 + y,208,34,34 );
	gfx.PutPixel( 118 + x,96 + y,208,34,34 );
	gfx.PutPixel( 119 + x,96 + y,208,34,34 );
	gfx.PutPixel( 120 + x,96 + y,208,34,34 );
	gfx.PutPixel( 121 + x,96 + y,208,34,34 );
	gfx.PutPixel( 122 + x,96 + y,208,34,34 );
	gfx.PutPixel( 123 + x,96 + y,208,34,34 );
	gfx.PutPixel( 124 + x,96 + y,208,34,34 );
	gfx.PutPixel( 125 + x,96 + y,208,34,34 );
	gfx.PutPixel( 126 + x,96 + y,208,34,34 );
	gfx.PutPixel( 127 + x,96 + y,208,34,34 );
	gfx.PutPixel( 128 + x,96 + y,208,34,34 );
	gfx.PutPixel( 129 + x,96 + y,208,34,34 );
	gfx.PutPixel( 130 + x,96 + y,208,34,34 );
	gfx.PutPixel( 131 + x,96 + y,208,34,34 );
	gfx.PutPixel( 132 + x,96 + y,208,34,34 );
	gfx.PutPixel( 133 + x,96 + y,208,34,34 );
	gfx.PutPixel( 134 + x,96 + y,208,34,34 );
	gfx.PutPixel( 135 + x,96 + y,208,34,34 );
	gfx.PutPixel( 136 + x,96 + y,208,34,34 );
	gfx.PutPixel( 137 + x,96 + y,208,34,34 );
	gfx.PutPixel( 138 + x,96 + y,208,34,34 );
	gfx.PutPixel( 139 + x,96 + y,208,34,34 );
	gfx.PutPixel( 140 + x,96 + y,208,34,34 );
	gfx.PutPixel( 141 + x,96 + y,208,34,34 );
	gfx.PutPixel( 142 + x,96 + y,208,34,34 );
	gfx.PutPixel( 143 + x,96 + y,208,34,34 );
	gfx.PutPixel( 144 + x,96 + y,208,34,34 );
	gfx.PutPixel( 145 + x,96 + y,208,34,34 );
	gfx.PutPixel( 146 + x,96 + y,208,34,34 );
	gfx.PutPixel( 147 + x,96 + y,208,34,34 );
	gfx.PutPixel( 148 + x,96 + y,208,34,34 );
	gfx.PutPixel( 149 + x,96 + y,208,34,34 );
	gfx.PutPixel( 0 + x,97 + y,208,34,34 );
	gfx.PutPixel( 1 + x,97 + y,208,34,34 );
	gfx.PutPixel( 2 + x,97 + y,208,34,34 );
	gfx.PutPixel( 3 + x,97 + y,208,34,34 );
	gfx.PutPixel( 4 + x,97 + y,208,34,34 );
	gfx.PutPixel( 5 + x,97 + y,208,34,34 );
	gfx.PutPixel( 6 + x,97 + y,208,34,34 );
	gfx.PutPixel( 7 + x,97 + y,208,34,34 );
	gfx.PutPixel( 8 + x,97 + y,208,34,34 );
	gfx.PutPixel( 9 + x,97 + y,208,34,34 );
	gfx.PutPixel( 10 + x,97 + y,208,34,34 );
	gfx.PutPixel( 11 + x,97 + y,208,34,34 );
	gfx.PutPixel( 12 + x,97 + y,208,34,34 );
	gfx.PutPixel( 13 + x,97 + y,208,34,34 );
	gfx.PutPixel( 14 + x,97 + y,208,34,34 );
	gfx.PutPixel( 15 + x,97 + y,208,34,34 );
	gfx.PutPixel( 16 + x,97 + y,208,34,34 );
	gfx.PutPixel( 17 + x,97 + y,208,34,34 );
	gfx.PutPixel( 18 + x,97 + y,208,34,34 );
	gfx.PutPixel( 19 + x,97 + y,208,34,34 );
	gfx.PutPixel( 20 + x,97 + y,208,34,34 );
	gfx.PutPixel( 21 + x,97 + y,208,34,34 );
	gfx.PutPixel( 22 + x,97 + y,208,34,34 );
	gfx.PutPixel( 23 + x,97 + y,208,34,34 );
	gfx.PutPixel( 24 + x,97 + y,208,34,34 );
	gfx.PutPixel( 25 + x,97 + y,208,34,34 );
	gfx.PutPixel( 26 + x,97 + y,208,34,34 );
	gfx.PutPixel( 27 + x,97 + y,208,34,34 );
	gfx.PutPixel( 28 + x,97 + y,208,34,34 );
	gfx.PutPixel( 29 + x,97 + y,208,34,34 );
	gfx.PutPixel( 30 + x,97 + y,208,34,34 );
	gfx.PutPixel( 31 + x,97 + y,208,34,34 );
	gfx.PutPixel( 32 + x,97 + y,208,34,34 );
	gfx.PutPixel( 33 + x,97 + y,208,34,34 );
	gfx.PutPixel( 34 + x,97 + y,208,34,34 );
	gfx.PutPixel( 35 + x,97 + y,208,34,34 );
	gfx.PutPixel( 36 + x,97 + y,208,34,34 );
	gfx.PutPixel( 37 + x,97 + y,208,34,34 );
	gfx.PutPixel( 38 + x,97 + y,208,34,34 );
	gfx.PutPixel( 39 + x,97 + y,208,34,34 );
	gfx.PutPixel( 40 + x,97 + y,208,34,34 );
	gfx.PutPixel( 41 + x,97 + y,208,34,34 );
	gfx.PutPixel( 42 + x,97 + y,208,34,34 );
	gfx.PutPixel( 43 + x,97 + y,208,34,34 );
	gfx.PutPixel( 44 + x,97 + y,208,34,34 );
	gfx.PutPixel( 45 + x,97 + y,208,34,34 );
	gfx.PutPixel( 46 + x,97 + y,208,34,34 );
	gfx.PutPixel( 47 + x,97 + y,208,34,34 );
	gfx.PutPixel( 48 + x,97 + y,208,34,34 );
	gfx.PutPixel( 49 + x,97 + y,208,34,34 );
	gfx.PutPixel( 50 + x,97 + y,208,34,34 );
	gfx.PutPixel( 51 + x,97 + y,208,34,34 );
	gfx.PutPixel( 52 + x,97 + y,208,34,34 );
	gfx.PutPixel( 53 + x,97 + y,208,34,34 );
	gfx.PutPixel( 54 + x,97 + y,208,34,34 );
	gfx.PutPixel( 55 + x,97 + y,208,34,34 );
	gfx.PutPixel( 56 + x,97 + y,208,34,34 );
	gfx.PutPixel( 57 + x,97 + y,208,34,34 );
	gfx.PutPixel( 58 + x,97 + y,208,34,34 );
	gfx.PutPixel( 59 + x,97 + y,208,34,34 );
	gfx.PutPixel( 60 + x,97 + y,208,34,34 );
	gfx.PutPixel( 61 + x,97 + y,208,34,34 );
	gfx.PutPixel( 62 + x,97 + y,208,34,34 );
	gfx.PutPixel( 63 + x,97 + y,208,34,34 );
	gfx.PutPixel( 64 + x,97 + y,208,34,34 );
	gfx.PutPixel( 65 + x,97 + y,208,34,34 );
	gfx.PutPixel( 66 + x,97 + y,208,34,34 );
	gfx.PutPixel( 67 + x,97 + y,208,34,34 );
	gfx.PutPixel( 68 + x,97 + y,208,34,34 );
	gfx.PutPixel( 69 + x,97 + y,208,34,34 );
	gfx.PutPixel( 70 + x,97 + y,208,34,34 );
	gfx.PutPixel( 71 + x,97 + y,208,34,34 );
	gfx.PutPixel( 72 + x,97 + y,208,34,34 );
	gfx.PutPixel( 73 + x,97 + y,208,34,34 );
	gfx.PutPixel( 74 + x,97 + y,208,34,34 );
	gfx.PutPixel( 75 + x,97 + y,208,34,34 );
	gfx.PutPixel( 76 + x,97 + y,208,34,34 );
	gfx.PutPixel( 77 + x,97 + y,208,34,34 );
	gfx.PutPixel( 78 + x,97 + y,208,34,34 );
	gfx.PutPixel( 79 + x,97 + y,208,34,34 );
	gfx.PutPixel( 80 + x,97 + y,208,34,34 );
	gfx.PutPixel( 81 + x,97 + y,208,34,34 );
	gfx.PutPixel( 82 + x,97 + y,208,34,34 );
	gfx.PutPixel( 83 + x,97 + y,208,34,34 );
	gfx.PutPixel( 84 + x,97 + y,208,34,34 );
	gfx.PutPixel( 85 + x,97 + y,208,34,34 );
	gfx.PutPixel( 86 + x,97 + y,208,34,34 );
	gfx.PutPixel( 87 + x,97 + y,208,34,34 );
	gfx.PutPixel( 88 + x,97 + y,208,34,34 );
	gfx.PutPixel( 89 + x,97 + y,208,34,34 );
	gfx.PutPixel( 90 + x,97 + y,208,34,34 );
	gfx.PutPixel( 91 + x,97 + y,208,34,34 );
	gfx.PutPixel( 92 + x,97 + y,208,34,34 );
	gfx.PutPixel( 93 + x,97 + y,208,34,34 );
	gfx.PutPixel( 94 + x,97 + y,208,34,34 );
	gfx.PutPixel( 95 + x,97 + y,208,34,34 );
	gfx.PutPixel( 96 + x,97 + y,208,34,34 );
	gfx.PutPixel( 97 + x,97 + y,208,34,34 );
	gfx.PutPixel( 98 + x,97 + y,208,34,34 );
	gfx.PutPixel( 99 + x,97 + y,208,34,34 );
	gfx.PutPixel( 100 + x,97 + y,208,34,34 );
	gfx.PutPixel( 101 + x,97 + y,208,34,34 );
	gfx.PutPixel( 102 + x,97 + y,208,34,34 );
	gfx.PutPixel( 103 + x,97 + y,208,34,34 );
	gfx.PutPixel( 104 + x,97 + y,208,34,34 );
	gfx.PutPixel( 105 + x,97 + y,208,34,34 );
	gfx.PutPixel( 106 + x,97 + y,208,34,34 );
	gfx.PutPixel( 107 + x,97 + y,208,34,34 );
	gfx.PutPixel( 108 + x,97 + y,208,34,34 );
	gfx.PutPixel( 109 + x,97 + y,208,34,34 );
	gfx.PutPixel( 110 + x,97 + y,208,34,34 );
	gfx.PutPixel( 111 + x,97 + y,208,34,34 );
	gfx.PutPixel( 112 + x,97 + y,208,34,34 );
	gfx.PutPixel( 113 + x,97 + y,208,34,34 );
	gfx.PutPixel( 114 + x,97 + y,208,34,34 );
	gfx.PutPixel( 115 + x,97 + y,208,34,34 );
	gfx.PutPixel( 116 + x,97 + y,208,34,34 );
	gfx.PutPixel( 117 + x,97 + y,208,34,34 );
	gfx.PutPixel( 118 + x,97 + y,208,34,34 );
	gfx.PutPixel( 119 + x,97 + y,208,34,34 );
	gfx.PutPixel( 120 + x,97 + y,208,34,34 );
	gfx.PutPixel( 121 + x,97 + y,208,34,34 );
	gfx.PutPixel( 122 + x,97 + y,208,34,34 );
	gfx.PutPixel( 123 + x,97 + y,208,34,34 );
	gfx.PutPixel( 124 + x,97 + y,208,34,34 );
	gfx.PutPixel( 125 + x,97 + y,208,34,34 );
	gfx.PutPixel( 126 + x,97 + y,208,34,34 );
	gfx.PutPixel( 127 + x,97 + y,208,34,34 );
	gfx.PutPixel( 128 + x,97 + y,208,34,34 );
	gfx.PutPixel( 129 + x,97 + y,208,34,34 );
	gfx.PutPixel( 130 + x,97 + y,208,34,34 );
	gfx.PutPixel( 131 + x,97 + y,208,34,34 );
	gfx.PutPixel( 132 + x,97 + y,208,34,34 );
	gfx.PutPixel( 133 + x,97 + y,208,34,34 );
	gfx.PutPixel( 134 + x,97 + y,208,34,34 );
	gfx.PutPixel( 135 + x,97 + y,208,34,34 );
	gfx.PutPixel( 136 + x,97 + y,208,34,34 );
	gfx.PutPixel( 137 + x,97 + y,208,34,34 );
	gfx.PutPixel( 138 + x,97 + y,208,34,34 );
	gfx.PutPixel( 139 + x,97 + y,208,34,34 );
	gfx.PutPixel( 140 + x,97 + y,208,34,34 );
	gfx.PutPixel( 141 + x,97 + y,208,34,34 );
	gfx.PutPixel( 142 + x,97 + y,208,34,34 );
	gfx.PutPixel( 143 + x,97 + y,208,34,34 );
	gfx.PutPixel( 144 + x,97 + y,208,34,34 );
	gfx.PutPixel( 145 + x,97 + y,208,34,34 );
	gfx.PutPixel( 146 + x,97 + y,208,34,34 );
	gfx.PutPixel( 147 + x,97 + y,208,34,34 );
	gfx.PutPixel( 148 + x,97 + y,208,34,34 );
	gfx.PutPixel( 149 + x,97 + y,208,34,34 );
	gfx.PutPixel( 0 + x,98 + y,208,34,34 );
	gfx.PutPixel( 1 + x,98 + y,208,34,34 );
	gfx.PutPixel( 2 + x,98 + y,208,34,34 );
	gfx.PutPixel( 3 + x,98 + y,208,34,34 );
	gfx.PutPixel( 4 + x,98 + y,208,34,34 );
	gfx.PutPixel( 5 + x,98 + y,208,34,34 );
	gfx.PutPixel( 6 + x,98 + y,208,34,34 );
	gfx.PutPixel( 7 + x,98 + y,208,34,34 );
	gfx.PutPixel( 8 + x,98 + y,208,34,34 );
	gfx.PutPixel( 9 + x,98 + y,208,34,34 );
	gfx.PutPixel( 10 + x,98 + y,208,34,34 );
	gfx.PutPixel( 11 + x,98 + y,208,34,34 );
	gfx.PutPixel( 12 + x,98 + y,208,34,34 );
	gfx.PutPixel( 13 + x,98 + y,208,34,34 );
	gfx.PutPixel( 14 + x,98 + y,208,34,34 );
	gfx.PutPixel( 15 + x,98 + y,208,34,34 );
	gfx.PutPixel( 16 + x,98 + y,208,34,34 );
	gfx.PutPixel( 17 + x,98 + y,208,34,34 );
	gfx.PutPixel( 18 + x,98 + y,208,34,34 );
	gfx.PutPixel( 19 + x,98 + y,208,34,34 );
	gfx.PutPixel( 20 + x,98 + y,208,34,34 );
	gfx.PutPixel( 21 + x,98 + y,208,34,34 );
	gfx.PutPixel( 22 + x,98 + y,208,34,34 );
	gfx.PutPixel( 23 + x,98 + y,208,34,34 );
	gfx.PutPixel( 24 + x,98 + y,208,34,34 );
	gfx.PutPixel( 25 + x,98 + y,208,34,34 );
	gfx.PutPixel( 26 + x,98 + y,208,34,34 );
	gfx.PutPixel( 27 + x,98 + y,208,34,34 );
	gfx.PutPixel( 28 + x,98 + y,208,34,34 );
	gfx.PutPixel( 29 + x,98 + y,208,34,34 );
	gfx.PutPixel( 30 + x,98 + y,208,34,34 );
	gfx.PutPixel( 31 + x,98 + y,208,34,34 );
	gfx.PutPixel( 32 + x,98 + y,208,34,34 );
	gfx.PutPixel( 33 + x,98 + y,208,34,34 );
	gfx.PutPixel( 34 + x,98 + y,208,34,34 );
	gfx.PutPixel( 35 + x,98 + y,208,34,34 );
	gfx.PutPixel( 36 + x,98 + y,208,34,34 );
	gfx.PutPixel( 37 + x,98 + y,208,34,34 );
	gfx.PutPixel( 38 + x,98 + y,208,34,34 );
	gfx.PutPixel( 39 + x,98 + y,208,34,34 );
	gfx.PutPixel( 40 + x,98 + y,208,34,34 );
	gfx.PutPixel( 41 + x,98 + y,208,34,34 );
	gfx.PutPixel( 42 + x,98 + y,208,34,34 );
	gfx.PutPixel( 43 + x,98 + y,208,34,34 );
	gfx.PutPixel( 44 + x,98 + y,208,34,34 );
	gfx.PutPixel( 45 + x,98 + y,208,34,34 );
	gfx.PutPixel( 46 + x,98 + y,208,34,34 );
	gfx.PutPixel( 47 + x,98 + y,208,34,34 );
	gfx.PutPixel( 48 + x,98 + y,208,34,34 );
	gfx.PutPixel( 49 + x,98 + y,208,34,34 );
	gfx.PutPixel( 50 + x,98 + y,208,34,34 );
	gfx.PutPixel( 51 + x,98 + y,208,34,34 );
	gfx.PutPixel( 52 + x,98 + y,208,34,34 );
	gfx.PutPixel( 53 + x,98 + y,208,34,34 );
	gfx.PutPixel( 54 + x,98 + y,208,34,34 );
	gfx.PutPixel( 55 + x,98 + y,208,34,34 );
	gfx.PutPixel( 56 + x,98 + y,208,34,34 );
	gfx.PutPixel( 57 + x,98 + y,208,34,34 );
	gfx.PutPixel( 58 + x,98 + y,208,34,34 );
	gfx.PutPixel( 59 + x,98 + y,208,34,34 );
	gfx.PutPixel( 60 + x,98 + y,208,34,34 );
	gfx.PutPixel( 61 + x,98 + y,208,34,34 );
	gfx.PutPixel( 62 + x,98 + y,208,34,34 );
	gfx.PutPixel( 63 + x,98 + y,208,34,34 );
	gfx.PutPixel( 64 + x,98 + y,208,34,34 );
	gfx.PutPixel( 65 + x,98 + y,208,27,27 );
	gfx.PutPixel( 66 + x,98 + y,207,26,26 );
	gfx.PutPixel( 67 + x,98 + y,208,34,34 );
	gfx.PutPixel( 68 + x,98 + y,208,34,34 );
	gfx.PutPixel( 69 + x,98 + y,208,34,34 );
	gfx.PutPixel( 70 + x,98 + y,208,33,33 );
	gfx.PutPixel( 71 + x,98 + y,207,26,26 );
	gfx.PutPixel( 72 + x,98 + y,207,25,25 );
	gfx.PutPixel( 73 + x,98 + y,208,29,29 );
	gfx.PutPixel( 74 + x,98 + y,208,34,34 );
	gfx.PutPixel( 75 + x,98 + y,208,34,34 );
	gfx.PutPixel( 76 + x,98 + y,208,32,32 );
	gfx.PutPixel( 77 + x,98 + y,207,24,24 );
	gfx.PutPixel( 78 + x,98 + y,208,30,30 );
	gfx.PutPixel( 79 + x,98 + y,208,34,34 );
	gfx.PutPixel( 80 + x,98 + y,207,26,26 );
	gfx.PutPixel( 81 + x,98 + y,207,25,25 );
	gfx.PutPixel( 82 + x,98 + y,207,25,25 );
	gfx.PutPixel( 83 + x,98 + y,207,27,27 );
	gfx.PutPixel( 84 + x,98 + y,208,31,31 );
	gfx.PutPixel( 85 + x,98 + y,208,34,34 );
	gfx.PutPixel( 86 + x,98 + y,208,34,34 );
	gfx.PutPixel( 87 + x,98 + y,208,34,34 );
	gfx.PutPixel( 88 + x,98 + y,208,34,34 );
	gfx.PutPixel( 89 + x,98 + y,208,34,34 );
	gfx.PutPixel( 90 + x,98 + y,208,34,34 );
	gfx.PutPixel( 91 + x,98 + y,208,34,34 );
	gfx.PutPixel( 92 + x,98 + y,208,34,34 );
	gfx.PutPixel( 93 + x,98 + y,208,34,34 );
	gfx.PutPixel( 94 + x,98 + y,208,34,34 );
	gfx.PutPixel( 95 + x,98 + y,208,34,34 );
	gfx.PutPixel( 96 + x,98 + y,208,34,34 );
	gfx.PutPixel( 97 + x,98 + y,208,34,34 );
	gfx.PutPixel( 98 + x,98 + y,208,34,34 );
	gfx.PutPixel( 99 + x,98 + y,208,34,34 );
	gfx.PutPixel( 100 + x,98 + y,208,34,34 );
	gfx.PutPixel( 101 + x,98 + y,208,34,34 );
	gfx.PutPixel( 102 + x,98 + y,208,34,34 );
	gfx.PutPixel( 103 + x,98 + y,208,34,34 );
	gfx.PutPixel( 104 + x,98 + y,208,34,34 );
	gfx.PutPixel( 105 + x,98 + y,208,34,34 );
	gfx.PutPixel( 106 + x,98 + y,208,34,34 );
	gfx.PutPixel( 107 + x,98 + y,208,34,34 );
	gfx.PutPixel( 108 + x,98 + y,208,34,34 );
	gfx.PutPixel( 109 + x,98 + y,208,34,34 );
	gfx.PutPixel( 110 + x,98 + y,208,34,34 );
	gfx.PutPixel( 111 + x,98 + y,208,34,34 );
	gfx.PutPixel( 112 + x,98 + y,208,34,34 );
	gfx.PutPixel( 113 + x,98 + y,208,34,34 );
	gfx.PutPixel( 114 + x,98 + y,208,34,34 );
	gfx.PutPixel( 115 + x,98 + y,208,34,34 );
	gfx.PutPixel( 116 + x,98 + y,208,34,34 );
	gfx.PutPixel( 117 + x,98 + y,208,34,34 );
	gfx.PutPixel( 118 + x,98 + y,208,34,34 );
	gfx.PutPixel( 119 + x,98 + y,208,34,34 );
	gfx.PutPixel( 120 + x,98 + y,208,34,34 );
	gfx.PutPixel( 121 + x,98 + y,208,34,34 );
	gfx.PutPixel( 122 + x,98 + y,208,34,34 );
	gfx.PutPixel( 123 + x,98 + y,208,34,34 );
	gfx.PutPixel( 124 + x,98 + y,208,34,34 );
	gfx.PutPixel( 125 + x,98 + y,208,34,34 );
	gfx.PutPixel( 126 + x,98 + y,208,34,34 );
	gfx.PutPixel( 127 + x,98 + y,208,34,34 );
	gfx.PutPixel( 128 + x,98 + y,208,34,34 );
	gfx.PutPixel( 129 + x,98 + y,208,34,34 );
	gfx.PutPixel( 130 + x,98 + y,208,34,34 );
	gfx.PutPixel( 131 + x,98 + y,208,34,34 );
	gfx.PutPixel( 132 + x,98 + y,208,34,34 );
	gfx.PutPixel( 133 + x,98 + y,208,34,34 );
	gfx.PutPixel( 134 + x,98 + y,208,34,34 );
	gfx.PutPixel( 135 + x,98 + y,208,34,34 );
	gfx.PutPixel( 136 + x,98 + y,208,34,34 );
	gfx.PutPixel( 137 + x,98 + y,208,34,34 );
	gfx.PutPixel( 138 + x,98 + y,208,34,34 );
	gfx.PutPixel( 139 + x,98 + y,208,34,34 );
	gfx.PutPixel( 140 + x,98 + y,208,34,34 );
	gfx.PutPixel( 141 + x,98 + y,208,34,34 );
	gfx.PutPixel( 142 + x,98 + y,208,34,34 );
	gfx.PutPixel( 143 + x,98 + y,208,34,34 );
	gfx.PutPixel( 144 + x,98 + y,208,34,34 );
	gfx.PutPixel( 145 + x,98 + y,208,34,34 );
	gfx.PutPixel( 146 + x,98 + y,208,34,34 );
	gfx.PutPixel( 147 + x,98 + y,208,34,34 );
	gfx.PutPixel( 148 + x,98 + y,208,34,34 );
	gfx.PutPixel( 149 + x,98 + y,208,34,34 );
	gfx.PutPixel( 0 + x,99 + y,208,34,34 );
	gfx.PutPixel( 1 + x,99 + y,208,34,34 );
	gfx.PutPixel( 2 + x,99 + y,208,34,34 );
	gfx.PutPixel( 3 + x,99 + y,208,34,34 );
	gfx.PutPixel( 4 + x,99 + y,208,34,34 );
	gfx.PutPixel( 5 + x,99 + y,208,34,34 );
	gfx.PutPixel( 6 + x,99 + y,208,34,34 );
	gfx.PutPixel( 7 + x,99 + y,208,34,34 );
	gfx.PutPixel( 8 + x,99 + y,208,34,34 );
	gfx.PutPixel( 9 + x,99 + y,208,34,34 );
	gfx.PutPixel( 10 + x,99 + y,208,34,34 );
	gfx.PutPixel( 11 + x,99 + y,208,34,34 );
	gfx.PutPixel( 12 + x,99 + y,208,34,34 );
	gfx.PutPixel( 13 + x,99 + y,208,34,34 );
	gfx.PutPixel( 14 + x,99 + y,208,34,34 );
	gfx.PutPixel( 15 + x,99 + y,208,34,34 );
	gfx.PutPixel( 16 + x,99 + y,208,34,34 );
	gfx.PutPixel( 17 + x,99 + y,208,34,34 );
	gfx.PutPixel( 18 + x,99 + y,208,34,34 );
	gfx.PutPixel( 19 + x,99 + y,208,34,34 );
	gfx.PutPixel( 20 + x,99 + y,208,34,34 );
	gfx.PutPixel( 21 + x,99 + y,208,34,34 );
	gfx.PutPixel( 22 + x,99 + y,208,34,34 );
	gfx.PutPixel( 23 + x,99 + y,208,34,34 );
	gfx.PutPixel( 24 + x,99 + y,208,34,34 );
	gfx.PutPixel( 25 + x,99 + y,208,34,34 );
	gfx.PutPixel( 26 + x,99 + y,208,34,34 );
	gfx.PutPixel( 27 + x,99 + y,208,34,34 );
	gfx.PutPixel( 28 + x,99 + y,208,34,34 );
	gfx.PutPixel( 29 + x,99 + y,208,34,34 );
	gfx.PutPixel( 30 + x,99 + y,208,34,34 );
	gfx.PutPixel( 31 + x,99 + y,208,34,34 );
	gfx.PutPixel( 32 + x,99 + y,208,34,34 );
	gfx.PutPixel( 33 + x,99 + y,208,34,34 );
	gfx.PutPixel( 34 + x,99 + y,208,34,34 );
	gfx.PutPixel( 35 + x,99 + y,208,34,34 );
	gfx.PutPixel( 36 + x,99 + y,208,34,34 );
	gfx.PutPixel( 37 + x,99 + y,208,34,34 );
	gfx.PutPixel( 38 + x,99 + y,208,34,34 );
	gfx.PutPixel( 39 + x,99 + y,208,34,34 );
	gfx.PutPixel( 40 + x,99 + y,208,34,34 );
	gfx.PutPixel( 41 + x,99 + y,208,34,34 );
	gfx.PutPixel( 42 + x,99 + y,208,34,34 );
	gfx.PutPixel( 43 + x,99 + y,208,34,34 );
	gfx.PutPixel( 44 + x,99 + y,208,34,34 );
	gfx.PutPixel( 45 + x,99 + y,208,34,34 );
	gfx.PutPixel( 46 + x,99 + y,208,34,34 );
	gfx.PutPixel( 47 + x,99 + y,208,34,34 );
	gfx.PutPixel( 48 + x,99 + y,208,34,34 );
	gfx.PutPixel( 49 + x,99 + y,208,34,34 );
	gfx.PutPixel( 50 + x,99 + y,208,34,34 );
	gfx.PutPixel( 51 + x,99 + y,208,34,34 );
	gfx.PutPixel( 52 + x,99 + y,208,34,34 );
	gfx.PutPixel( 53 + x,99 + y,208,34,34 );
	gfx.PutPixel( 54 + x,99 + y,208,34,34 );
	gfx.PutPixel( 55 + x,99 + y,208,34,34 );
	gfx.PutPixel( 56 + x,99 + y,208,34,34 );
	gfx.PutPixel( 57 + x,99 + y,208,34,34 );
	gfx.PutPixel( 58 + x,99 + y,208,34,34 );
	gfx.PutPixel( 59 + x,99 + y,208,34,34 );
	gfx.PutPixel( 60 + x,99 + y,208,34,34 );
	gfx.PutPixel( 61 + x,99 + y,208,34,34 );
	gfx.PutPixel( 62 + x,99 + y,208,34,34 );
	gfx.PutPixel( 63 + x,99 + y,208,34,34 );
	gfx.PutPixel( 64 + x,99 + y,208,30,30 );
	gfx.PutPixel( 65 + x,99 + y,210,69,69 );
	gfx.PutPixel( 66 + x,99 + y,211,75,75 );
	gfx.PutPixel( 67 + x,99 + y,208,32,32 );
	gfx.PutPixel( 68 + x,99 + y,208,34,34 );
	gfx.PutPixel( 69 + x,99 + y,208,33,33 );
	gfx.PutPixel( 70 + x,99 + y,208,37,37 );
	gfx.PutPixel( 71 + x,99 + y,211,79,79 );
	gfx.PutPixel( 72 + x,99 + y,212,86,86 );
	gfx.PutPixel( 73 + x,99 + y,209,54,54 );
	gfx.PutPixel( 74 + x,99 + y,208,29,29 );
	gfx.PutPixel( 75 + x,99 + y,208,32,32 );
	gfx.PutPixel( 76 + x,99 + y,209,46,46 );
	gfx.PutPixel( 77 + x,99 + y,212,87,87 );
	gfx.PutPixel( 78 + x,99 + y,210,57,57 );
	gfx.PutPixel( 79 + x,99 + y,208,34,34 );
	gfx.PutPixel( 80 + x,99 + y,211,79,79 );
	gfx.PutPixel( 81 + x,99 + y,211,84,84 );
	gfx.PutPixel( 82 + x,99 + y,211,83,83 );
	gfx.PutPixel( 83 + x,99 + y,211,72,72 );
	gfx.PutPixel( 84 + x,99 + y,209,44,44 );
	gfx.PutPixel( 85 + x,99 + y,207,24,24 );
	gfx.PutPixel( 86 + x,99 + y,208,33,33 );
	gfx.PutPixel( 87 + x,99 + y,208,34,34 );
	gfx.PutPixel( 88 + x,99 + y,208,34,34 );
	gfx.PutPixel( 89 + x,99 + y,208,34,34 );
	gfx.PutPixel( 90 + x,99 + y,208,34,34 );
	gfx.PutPixel( 91 + x,99 + y,208,34,34 );
	gfx.PutPixel( 92 + x,99 + y,208,34,34 );
	gfx.PutPixel( 93 + x,99 + y,208,34,34 );
	gfx.PutPixel( 94 + x,99 + y,208,34,34 );
	gfx.PutPixel( 95 + x,99 + y,208,34,34 );
	gfx.PutPixel( 96 + x,99 + y,208,34,34 );
	gfx.PutPixel( 97 + x,99 + y,208,34,34 );
	gfx.PutPixel( 98 + x,99 + y,208,34,34 );
	gfx.PutPixel( 99 + x,99 + y,208,34,34 );
	gfx.PutPixel( 100 + x,99 + y,208,34,34 );
	gfx.PutPixel( 101 + x,99 + y,208,34,34 );
	gfx.PutPixel( 102 + x,99 + y,208,34,34 );
	gfx.PutPixel( 103 + x,99 + y,208,34,34 );
	gfx.PutPixel( 104 + x,99 + y,208,34,34 );
	gfx.PutPixel( 105 + x,99 + y,208,34,34 );
	gfx.PutPixel( 106 + x,99 + y,208,34,34 );
	gfx.PutPixel( 107 + x,99 + y,208,34,34 );
	gfx.PutPixel( 108 + x,99 + y,208,34,34 );
	gfx.PutPixel( 109 + x,99 + y,208,34,34 );
	gfx.PutPixel( 110 + x,99 + y,208,34,34 );
	gfx.PutPixel( 111 + x,99 + y,208,34,34 );
	gfx.PutPixel( 112 + x,99 + y,208,34,34 );
	gfx.PutPixel( 113 + x,99 + y,208,34,34 );
	gfx.PutPixel( 114 + x,99 + y,208,34,34 );
	gfx.PutPixel( 115 + x,99 + y,208,34,34 );
	gfx.PutPixel( 116 + x,99 + y,208,34,34 );
	gfx.PutPixel( 117 + x,99 + y,208,34,34 );
	gfx.PutPixel( 118 + x,99 + y,208,34,34 );
	gfx.PutPixel( 119 + x,99 + y,208,34,34 );
	gfx.PutPixel( 120 + x,99 + y,208,34,34 );
	gfx.PutPixel( 121 + x,99 + y,208,34,34 );
	gfx.PutPixel( 122 + x,99 + y,208,34,34 );
	gfx.PutPixel( 123 + x,99 + y,208,34,34 );
	gfx.PutPixel( 124 + x,99 + y,208,34,34 );
	gfx.PutPixel( 125 + x,99 + y,208,34,34 );
	gfx.PutPixel( 126 + x,99 + y,208,34,34 );
	gfx.PutPixel( 127 + x,99 + y,208,34,34 );
	gfx.PutPixel( 128 + x,99 + y,208,34,34 );
	gfx.PutPixel( 129 + x,99 + y,208,34,34 );
	gfx.PutPixel( 130 + x,99 + y,208,34,34 );
	gfx.PutPixel( 131 + x,99 + y,208,34,34 );
	gfx.PutPixel( 132 + x,99 + y,208,34,34 );
	gfx.PutPixel( 133 + x,99 + y,208,34,34 );
	gfx.PutPixel( 134 + x,99 + y,208,34,34 );
	gfx.PutPixel( 135 + x,99 + y,208,34,34 );
	gfx.PutPixel( 136 + x,99 + y,208,34,34 );
	gfx.PutPixel( 137 + x,99 + y,208,34,34 );
	gfx.PutPixel( 138 + x,99 + y,208,34,34 );
	gfx.PutPixel( 139 + x,99 + y,208,34,34 );
	gfx.PutPixel( 140 + x,99 + y,208,34,34 );
	gfx.PutPixel( 141 + x,99 + y,208,34,34 );
	gfx.PutPixel( 142 + x,99 + y,208,34,34 );
	gfx.PutPixel( 143 + x,99 + y,208,34,34 );
	gfx.PutPixel( 144 + x,99 + y,208,34,34 );
	gfx.PutPixel( 145 + x,99 + y,208,34,34 );
	gfx.PutPixel( 146 + x,99 + y,208,34,34 );
	gfx.PutPixel( 147 + x,99 + y,208,34,34 );
	gfx.PutPixel( 148 + x,99 + y,208,34,34 );
	gfx.PutPixel( 149 + x,99 + y,208,34,34 );
	gfx.PutPixel( 0 + x,100 + y,208,34,34 );
	gfx.PutPixel( 1 + x,100 + y,208,34,34 );
	gfx.PutPixel( 2 + x,100 + y,208,34,34 );
	gfx.PutPixel( 3 + x,100 + y,208,34,34 );
	gfx.PutPixel( 4 + x,100 + y,208,34,34 );
	gfx.PutPixel( 5 + x,100 + y,208,34,34 );
	gfx.PutPixel( 6 + x,100 + y,208,34,34 );
	gfx.PutPixel( 7 + x,100 + y,208,34,34 );
	gfx.PutPixel( 8 + x,100 + y,208,34,34 );
	gfx.PutPixel( 9 + x,100 + y,208,34,34 );
	gfx.PutPixel( 10 + x,100 + y,208,34,34 );
	gfx.PutPixel( 11 + x,100 + y,208,34,34 );
	gfx.PutPixel( 12 + x,100 + y,208,34,34 );
	gfx.PutPixel( 13 + x,100 + y,208,34,34 );
	gfx.PutPixel( 14 + x,100 + y,208,34,34 );
	gfx.PutPixel( 15 + x,100 + y,208,34,34 );
	gfx.PutPixel( 16 + x,100 + y,208,34,34 );
	gfx.PutPixel( 17 + x,100 + y,208,34,34 );
	gfx.PutPixel( 18 + x,100 + y,208,34,34 );
	gfx.PutPixel( 19 + x,100 + y,208,34,34 );
	gfx.PutPixel( 20 + x,100 + y,208,34,34 );
	gfx.PutPixel( 21 + x,100 + y,208,34,34 );
	gfx.PutPixel( 22 + x,100 + y,208,34,34 );
	gfx.PutPixel( 23 + x,100 + y,208,34,34 );
	gfx.PutPixel( 24 + x,100 + y,208,34,34 );
	gfx.PutPixel( 25 + x,100 + y,208,34,34 );
	gfx.PutPixel( 26 + x,100 + y,208,34,34 );
	gfx.PutPixel( 27 + x,100 + y,208,34,34 );
	gfx.PutPixel( 28 + x,100 + y,208,34,34 );
	gfx.PutPixel( 29 + x,100 + y,208,34,34 );
	gfx.PutPixel( 30 + x,100 + y,208,34,34 );
	gfx.PutPixel( 31 + x,100 + y,208,34,34 );
	gfx.PutPixel( 32 + x,100 + y,208,34,34 );
	gfx.PutPixel( 33 + x,100 + y,208,34,34 );
	gfx.PutPixel( 34 + x,100 + y,208,34,34 );
	gfx.PutPixel( 35 + x,100 + y,208,34,34 );
	gfx.PutPixel( 36 + x,100 + y,208,34,34 );
	gfx.PutPixel( 37 + x,100 + y,208,34,34 );
	gfx.PutPixel( 38 + x,100 + y,208,34,34 );
	gfx.PutPixel( 39 + x,100 + y,208,34,34 );
	gfx.PutPixel( 40 + x,100 + y,208,34,34 );
	gfx.PutPixel( 41 + x,100 + y,208,34,34 );
	gfx.PutPixel( 42 + x,100 + y,208,34,34 );
	gfx.PutPixel( 43 + x,100 + y,208,34,34 );
	gfx.PutPixel( 44 + x,100 + y,208,34,34 );
	gfx.PutPixel( 45 + x,100 + y,208,34,34 );
	gfx.PutPixel( 46 + x,100 + y,208,34,34 );
	gfx.PutPixel( 47 + x,100 + y,208,34,34 );
	gfx.PutPixel( 48 + x,100 + y,208,34,34 );
	gfx.PutPixel( 49 + x,100 + y,208,34,34 );
	gfx.PutPixel( 50 + x,100 + y,208,34,34 );
	gfx.PutPixel( 51 + x,100 + y,208,34,34 );
	gfx.PutPixel( 52 + x,100 + y,208,34,34 );
	gfx.PutPixel( 53 + x,100 + y,208,34,34 );
	gfx.PutPixel( 54 + x,100 + y,208,34,34 );
	gfx.PutPixel( 55 + x,100 + y,208,34,34 );
	gfx.PutPixel( 56 + x,100 + y,208,34,34 );
	gfx.PutPixel( 57 + x,100 + y,208,34,34 );
	gfx.PutPixel( 58 + x,100 + y,208,34,34 );
	gfx.PutPixel( 59 + x,100 + y,208,34,34 );
	gfx.PutPixel( 60 + x,100 + y,208,34,34 );
	gfx.PutPixel( 61 + x,100 + y,208,34,34 );
	gfx.PutPixel( 62 + x,100 + y,208,34,34 );
	gfx.PutPixel( 63 + x,100 + y,208,31,31 );
	gfx.PutPixel( 64 + x,100 + y,208,45,45 );
	gfx.PutPixel( 65 + x,100 + y,220,209,209 );
	gfx.PutPixel( 66 + x,100 + y,221,225,225 );
	gfx.PutPixel( 67 + x,100 + y,210,60,60 );
	gfx.PutPixel( 68 + x,100 + y,208,28,28 );
	gfx.PutPixel( 69 + x,100 + y,208,30,30 );
	gfx.PutPixel( 70 + x,100 + y,209,47,47 );
	gfx.PutPixel( 71 + x,100 + y,220,214,214 );
	gfx.PutPixel( 72 + x,100 + y,222,239,239 );
	gfx.PutPixel( 73 + x,100 + y,219,185,185 );
	gfx.PutPixel( 74 + x,100 + y,208,35,35 );
	gfx.PutPixel( 75 + x,100 + y,207,22,22 );
	gfx.PutPixel( 76 + x,100 + y,211,84,84 );
	gfx.PutPixel( 77 + x,100 + y,223,247,247 );
	gfx.PutPixel( 78 + x,100 + y,214,127,127 );
	gfx.PutPixel( 79 + x,100 + y,208,35,35 );
	gfx.PutPixel( 80 + x,100 + y,220,214,214 );
	gfx.PutPixel( 81 + x,100 + y,222,234,234 );
	gfx.PutPixel( 82 + x,100 + y,222,234,234 );
	gfx.PutPixel( 83 + x,100 + y,222,232,232 );
	gfx.PutPixel( 84 + x,100 + y,220,210,210 );
	gfx.PutPixel( 85 + x,100 + y,214,119,119 );
	gfx.PutPixel( 86 + x,100 + y,208,29,29 );
	gfx.PutPixel( 87 + x,100 + y,208,33,33 );
	gfx.PutPixel( 88 + x,100 + y,208,34,34 );
	gfx.PutPixel( 89 + x,100 + y,208,34,34 );
	gfx.PutPixel( 90 + x,100 + y,208,34,34 );
	gfx.PutPixel( 91 + x,100 + y,208,34,34 );
	gfx.PutPixel( 92 + x,100 + y,208,34,34 );
	gfx.PutPixel( 93 + x,100 + y,208,34,34 );
	gfx.PutPixel( 94 + x,100 + y,208,34,34 );
	gfx.PutPixel( 95 + x,100 + y,208,34,34 );
	gfx.PutPixel( 96 + x,100 + y,208,34,34 );
	gfx.PutPixel( 97 + x,100 + y,208,34,34 );
	gfx.PutPixel( 98 + x,100 + y,208,34,34 );
	gfx.PutPixel( 99 + x,100 + y,208,34,34 );
	gfx.PutPixel( 100 + x,100 + y,208,34,34 );
	gfx.PutPixel( 101 + x,100 + y,208,34,34 );
	gfx.PutPixel( 102 + x,100 + y,208,34,34 );
	gfx.PutPixel( 103 + x,100 + y,208,34,34 );
	gfx.PutPixel( 104 + x,100 + y,208,34,34 );
	gfx.PutPixel( 105 + x,100 + y,208,34,34 );
	gfx.PutPixel( 106 + x,100 + y,208,34,34 );
	gfx.PutPixel( 107 + x,100 + y,208,34,34 );
	gfx.PutPixel( 108 + x,100 + y,208,34,34 );
	gfx.PutPixel( 109 + x,100 + y,208,34,34 );
	gfx.PutPixel( 110 + x,100 + y,208,34,34 );
	gfx.PutPixel( 111 + x,100 + y,208,34,34 );
	gfx.PutPixel( 112 + x,100 + y,208,34,34 );
	gfx.PutPixel( 113 + x,100 + y,208,34,34 );
	gfx.PutPixel( 114 + x,100 + y,208,34,34 );
	gfx.PutPixel( 115 + x,100 + y,208,34,34 );
	gfx.PutPixel( 116 + x,100 + y,208,34,34 );
	gfx.PutPixel( 117 + x,100 + y,208,34,34 );
	gfx.PutPixel( 118 + x,100 + y,208,34,34 );
	gfx.PutPixel( 119 + x,100 + y,208,34,34 );
	gfx.PutPixel( 120 + x,100 + y,208,34,34 );
	gfx.PutPixel( 121 + x,100 + y,208,34,34 );
	gfx.PutPixel( 122 + x,100 + y,208,34,34 );
	gfx.PutPixel( 123 + x,100 + y,208,34,34 );
	gfx.PutPixel( 124 + x,100 + y,208,34,34 );
	gfx.PutPixel( 125 + x,100 + y,208,34,34 );
	gfx.PutPixel( 126 + x,100 + y,208,34,34 );
	gfx.PutPixel( 127 + x,100 + y,208,34,34 );
	gfx.PutPixel( 128 + x,100 + y,208,34,34 );
	gfx.PutPixel( 129 + x,100 + y,208,34,34 );
	gfx.PutPixel( 130 + x,100 + y,208,34,34 );
	gfx.PutPixel( 131 + x,100 + y,208,34,34 );
	gfx.PutPixel( 132 + x,100 + y,208,34,34 );
	gfx.PutPixel( 133 + x,100 + y,208,34,34 );
	gfx.PutPixel( 134 + x,100 + y,208,34,34 );
	gfx.PutPixel( 135 + x,100 + y,208,34,34 );
	gfx.PutPixel( 136 + x,100 + y,208,34,34 );
	gfx.PutPixel( 137 + x,100 + y,208,34,34 );
	gfx.PutPixel( 138 + x,100 + y,208,34,34 );
	gfx.PutPixel( 139 + x,100 + y,208,34,34 );
	gfx.PutPixel( 140 + x,100 + y,208,34,34 );
	gfx.PutPixel( 141 + x,100 + y,208,34,34 );
	gfx.PutPixel( 142 + x,100 + y,208,34,34 );
	gfx.PutPixel( 143 + x,100 + y,208,34,34 );
	gfx.PutPixel( 144 + x,100 + y,208,34,34 );
	gfx.PutPixel( 145 + x,100 + y,208,34,34 );
	gfx.PutPixel( 146 + x,100 + y,208,34,34 );
	gfx.PutPixel( 147 + x,100 + y,208,34,34 );
	gfx.PutPixel( 148 + x,100 + y,208,34,34 );
	gfx.PutPixel( 149 + x,100 + y,208,34,34 );
	gfx.PutPixel( 0 + x,101 + y,208,34,34 );
	gfx.PutPixel( 1 + x,101 + y,208,34,34 );
	gfx.PutPixel( 2 + x,101 + y,208,34,34 );
	gfx.PutPixel( 3 + x,101 + y,208,34,34 );
	gfx.PutPixel( 4 + x,101 + y,208,34,34 );
	gfx.PutPixel( 5 + x,101 + y,208,34,34 );
	gfx.PutPixel( 6 + x,101 + y,208,34,34 );
	gfx.PutPixel( 7 + x,101 + y,208,34,34 );
	gfx.PutPixel( 8 + x,101 + y,208,34,34 );
	gfx.PutPixel( 9 + x,101 + y,208,34,34 );
	gfx.PutPixel( 10 + x,101 + y,208,34,34 );
	gfx.PutPixel( 11 + x,101 + y,208,34,34 );
	gfx.PutPixel( 12 + x,101 + y,208,34,34 );
	gfx.PutPixel( 13 + x,101 + y,208,34,34 );
	gfx.PutPixel( 14 + x,101 + y,208,34,34 );
	gfx.PutPixel( 15 + x,101 + y,208,34,34 );
	gfx.PutPixel( 16 + x,101 + y,208,34,34 );
	gfx.PutPixel( 17 + x,101 + y,208,34,34 );
	gfx.PutPixel( 18 + x,101 + y,208,34,34 );
	gfx.PutPixel( 19 + x,101 + y,208,34,34 );
	gfx.PutPixel( 20 + x,101 + y,208,34,34 );
	gfx.PutPixel( 21 + x,101 + y,208,34,34 );
	gfx.PutPixel( 22 + x,101 + y,208,34,34 );
	gfx.PutPixel( 23 + x,101 + y,208,34,34 );
	gfx.PutPixel( 24 + x,101 + y,208,34,34 );
	gfx.PutPixel( 25 + x,101 + y,208,34,34 );
	gfx.PutPixel( 26 + x,101 + y,208,34,34 );
	gfx.PutPixel( 27 + x,101 + y,208,34,34 );
	gfx.PutPixel( 28 + x,101 + y,208,34,34 );
	gfx.PutPixel( 29 + x,101 + y,208,34,34 );
	gfx.PutPixel( 30 + x,101 + y,208,34,34 );
	gfx.PutPixel( 31 + x,101 + y,208,34,34 );
	gfx.PutPixel( 32 + x,101 + y,208,34,34 );
	gfx.PutPixel( 33 + x,101 + y,208,34,34 );
	gfx.PutPixel( 34 + x,101 + y,208,34,34 );
	gfx.PutPixel( 35 + x,101 + y,208,34,34 );
	gfx.PutPixel( 36 + x,101 + y,208,34,34 );
	gfx.PutPixel( 37 + x,101 + y,208,34,34 );
	gfx.PutPixel( 38 + x,101 + y,208,34,34 );
	gfx.PutPixel( 39 + x,101 + y,208,34,34 );
	gfx.PutPixel( 40 + x,101 + y,208,34,34 );
	gfx.PutPixel( 41 + x,101 + y,208,34,34 );
	gfx.PutPixel( 42 + x,101 + y,208,34,34 );
	gfx.PutPixel( 43 + x,101 + y,208,34,34 );
	gfx.PutPixel( 44 + x,101 + y,208,34,34 );
	gfx.PutPixel( 45 + x,101 + y,208,34,34 );
	gfx.PutPixel( 46 + x,101 + y,208,34,34 );
	gfx.PutPixel( 47 + x,101 + y,208,34,34 );
	gfx.PutPixel( 48 + x,101 + y,208,34,34 );
	gfx.PutPixel( 49 + x,101 + y,208,34,34 );
	gfx.PutPixel( 50 + x,101 + y,208,34,34 );
	gfx.PutPixel( 51 + x,101 + y,208,34,34 );
	gfx.PutPixel( 52 + x,101 + y,208,34,34 );
	gfx.PutPixel( 53 + x,101 + y,208,34,34 );
	gfx.PutPixel( 54 + x,101 + y,208,34,34 );
	gfx.PutPixel( 55 + x,101 + y,208,34,34 );
	gfx.PutPixel( 56 + x,101 + y,208,34,34 );
	gfx.PutPixel( 57 + x,101 + y,208,34,34 );
	gfx.PutPixel( 58 + x,101 + y,208,34,34 );
	gfx.PutPixel( 59 + x,101 + y,208,34,34 );
	gfx.PutPixel( 60 + x,101 + y,208,34,34 );
	gfx.PutPixel( 61 + x,101 + y,208,34,34 );
	gfx.PutPixel( 62 + x,101 + y,208,34,34 );
	gfx.PutPixel( 63 + x,101 + y,207,22,22 );
	gfx.PutPixel( 64 + x,101 + y,213,110,110 );
	gfx.PutPixel( 65 + x,101 + y,222,233,233 );
	gfx.PutPixel( 66 + x,101 + y,222,234,234 );
	gfx.PutPixel( 67 + x,101 + y,215,134,134 );
	gfx.PutPixel( 68 + x,101 + y,207,22,22 );
	gfx.PutPixel( 69 + x,101 + y,208,30,30 );
	gfx.PutPixel( 70 + x,101 + y,209,47,47 );
	gfx.PutPixel( 71 + x,101 + y,220,208,208 );
	gfx.PutPixel( 72 + x,101 + y,221,226,226 );
	gfx.PutPixel( 73 + x,101 + y,222,236,236 );
	gfx.PutPixel( 74 + x,101 + y,214,125,125 );
	gfx.PutPixel( 75 + x,101 + y,207,13,13 );
	gfx.PutPixel( 76 + x,101 + y,211,82,82 );
	gfx.PutPixel( 77 + x,101 + y,222,241,241 );
	gfx.PutPixel( 78 + x,101 + y,214,124,124 );
	gfx.PutPixel( 79 + x,101 + y,208,35,35 );
	gfx.PutPixel( 80 + x,101 + y,221,214,214 );
	gfx.PutPixel( 81 + x,101 + y,219,189,189 );
	gfx.PutPixel( 82 + x,101 + y,211,76,76 );
	gfx.PutPixel( 83 + x,101 + y,213,101,101 );
	gfx.PutPixel( 84 + x,101 + y,219,191,191 );
	gfx.PutPixel( 85 + x,101 + y,222,242,242 );
	gfx.PutPixel( 86 + x,101 + y,214,113,113 );
	gfx.PutPixel( 87 + x,101 + y,207,24,24 );
	gfx.PutPixel( 88 + x,101 + y,208,34,34 );
	gfx.PutPixel( 89 + x,101 + y,208,34,34 );
	gfx.PutPixel( 90 + x,101 + y,208,34,34 );
	gfx.PutPixel( 91 + x,101 + y,208,34,34 );
	gfx.PutPixel( 92 + x,101 + y,208,34,34 );
	gfx.PutPixel( 93 + x,101 + y,208,34,34 );
	gfx.PutPixel( 94 + x,101 + y,208,34,34 );
	gfx.PutPixel( 95 + x,101 + y,208,34,34 );
	gfx.PutPixel( 96 + x,101 + y,208,34,34 );
	gfx.PutPixel( 97 + x,101 + y,208,34,34 );
	gfx.PutPixel( 98 + x,101 + y,208,34,34 );
	gfx.PutPixel( 99 + x,101 + y,208,34,34 );
	gfx.PutPixel( 100 + x,101 + y,208,34,34 );
	gfx.PutPixel( 101 + x,101 + y,208,34,34 );
	gfx.PutPixel( 102 + x,101 + y,208,34,34 );
	gfx.PutPixel( 103 + x,101 + y,208,34,34 );
	gfx.PutPixel( 104 + x,101 + y,208,34,34 );
	gfx.PutPixel( 105 + x,101 + y,208,34,34 );
	gfx.PutPixel( 106 + x,101 + y,208,34,34 );
	gfx.PutPixel( 107 + x,101 + y,208,34,34 );
	gfx.PutPixel( 108 + x,101 + y,208,34,34 );
	gfx.PutPixel( 109 + x,101 + y,208,34,34 );
	gfx.PutPixel( 110 + x,101 + y,208,34,34 );
	gfx.PutPixel( 111 + x,101 + y,208,34,34 );
	gfx.PutPixel( 112 + x,101 + y,208,34,34 );
	gfx.PutPixel( 113 + x,101 + y,208,34,34 );
	gfx.PutPixel( 114 + x,101 + y,208,34,34 );
	gfx.PutPixel( 115 + x,101 + y,208,34,34 );
	gfx.PutPixel( 116 + x,101 + y,208,34,34 );
	gfx.PutPixel( 117 + x,101 + y,208,34,34 );
	gfx.PutPixel( 118 + x,101 + y,208,34,34 );
	gfx.PutPixel( 119 + x,101 + y,208,34,34 );
	gfx.PutPixel( 120 + x,101 + y,208,34,34 );
	gfx.PutPixel( 121 + x,101 + y,208,34,34 );
	gfx.PutPixel( 122 + x,101 + y,208,34,34 );
	gfx.PutPixel( 123 + x,101 + y,208,34,34 );
	gfx.PutPixel( 124 + x,101 + y,208,34,34 );
	gfx.PutPixel( 125 + x,101 + y,208,34,34 );
	gfx.PutPixel( 126 + x,101 + y,208,34,34 );
	gfx.PutPixel( 127 + x,101 + y,208,34,34 );
	gfx.PutPixel( 128 + x,101 + y,208,34,34 );
	gfx.PutPixel( 129 + x,101 + y,208,34,34 );
	gfx.PutPixel( 130 + x,101 + y,208,34,34 );
	gfx.PutPixel( 131 + x,101 + y,208,34,34 );
	gfx.PutPixel( 132 + x,101 + y,208,34,34 );
	gfx.PutPixel( 133 + x,101 + y,208,34,34 );
	gfx.PutPixel( 134 + x,101 + y,208,34,34 );
	gfx.PutPixel( 135 + x,101 + y,208,34,34 );
	gfx.PutPixel( 136 + x,101 + y,208,34,34 );
	gfx.PutPixel( 137 + x,101 + y,208,34,34 );
	gfx.PutPixel( 138 + x,101 + y,208,34,34 );
	gfx.PutPixel( 139 + x,101 + y,208,34,34 );
	gfx.PutPixel( 140 + x,101 + y,208,34,34 );
	gfx.PutPixel( 141 + x,101 + y,208,34,34 );
	gfx.PutPixel( 142 + x,101 + y,208,34,34 );
	gfx.PutPixel( 143 + x,101 + y,208,34,34 );
	gfx.PutPixel( 144 + x,101 + y,208,34,34 );
	gfx.PutPixel( 145 + x,101 + y,208,34,34 );
	gfx.PutPixel( 146 + x,101 + y,208,34,34 );
	gfx.PutPixel( 147 + x,101 + y,208,34,34 );
	gfx.PutPixel( 148 + x,101 + y,208,34,34 );
	gfx.PutPixel( 149 + x,101 + y,208,34,34 );
	gfx.PutPixel( 0 + x,102 + y,208,34,34 );
	gfx.PutPixel( 1 + x,102 + y,208,34,34 );
	gfx.PutPixel( 2 + x,102 + y,208,34,34 );
	gfx.PutPixel( 3 + x,102 + y,208,34,34 );
	gfx.PutPixel( 4 + x,102 + y,208,34,34 );
	gfx.PutPixel( 5 + x,102 + y,208,34,34 );
	gfx.PutPixel( 6 + x,102 + y,208,34,34 );
	gfx.PutPixel( 7 + x,102 + y,208,34,34 );
	gfx.PutPixel( 8 + x,102 + y,208,34,34 );
	gfx.PutPixel( 9 + x,102 + y,208,34,34 );
	gfx.PutPixel( 10 + x,102 + y,208,34,34 );
	gfx.PutPixel( 11 + x,102 + y,208,34,34 );
	gfx.PutPixel( 12 + x,102 + y,208,34,34 );
	gfx.PutPixel( 13 + x,102 + y,208,34,34 );
	gfx.PutPixel( 14 + x,102 + y,208,34,34 );
	gfx.PutPixel( 15 + x,102 + y,208,34,34 );
	gfx.PutPixel( 16 + x,102 + y,208,34,34 );
	gfx.PutPixel( 17 + x,102 + y,208,34,34 );
	gfx.PutPixel( 18 + x,102 + y,208,34,34 );
	gfx.PutPixel( 19 + x,102 + y,208,34,34 );
	gfx.PutPixel( 20 + x,102 + y,208,34,34 );
	gfx.PutPixel( 21 + x,102 + y,208,34,34 );
	gfx.PutPixel( 22 + x,102 + y,208,34,34 );
	gfx.PutPixel( 23 + x,102 + y,208,34,34 );
	gfx.PutPixel( 24 + x,102 + y,208,34,34 );
	gfx.PutPixel( 25 + x,102 + y,208,34,34 );
	gfx.PutPixel( 26 + x,102 + y,208,34,34 );
	gfx.PutPixel( 27 + x,102 + y,208,34,34 );
	gfx.PutPixel( 28 + x,102 + y,208,34,34 );
	gfx.PutPixel( 29 + x,102 + y,208,34,34 );
	gfx.PutPixel( 30 + x,102 + y,208,34,34 );
	gfx.PutPixel( 31 + x,102 + y,208,34,34 );
	gfx.PutPixel( 32 + x,102 + y,208,34,34 );
	gfx.PutPixel( 33 + x,102 + y,208,34,34 );
	gfx.PutPixel( 34 + x,102 + y,208,34,34 );
	gfx.PutPixel( 35 + x,102 + y,208,34,34 );
	gfx.PutPixel( 36 + x,102 + y,208,34,34 );
	gfx.PutPixel( 37 + x,102 + y,208,34,34 );
	gfx.PutPixel( 38 + x,102 + y,208,34,34 );
	gfx.PutPixel( 39 + x,102 + y,208,34,34 );
	gfx.PutPixel( 40 + x,102 + y,208,34,34 );
	gfx.PutPixel( 41 + x,102 + y,208,34,34 );
	gfx.PutPixel( 42 + x,102 + y,208,34,34 );
	gfx.PutPixel( 43 + x,102 + y,208,34,34 );
	gfx.PutPixel( 44 + x,102 + y,208,34,34 );
	gfx.PutPixel( 45 + x,102 + y,208,34,34 );
	gfx.PutPixel( 46 + x,102 + y,208,34,34 );
	gfx.PutPixel( 47 + x,102 + y,208,34,34 );
	gfx.PutPixel( 48 + x,102 + y,208,34,34 );
	gfx.PutPixel( 49 + x,102 + y,208,34,34 );
	gfx.PutPixel( 50 + x,102 + y,208,34,34 );
	gfx.PutPixel( 51 + x,102 + y,208,34,34 );
	gfx.PutPixel( 52 + x,102 + y,208,34,34 );
	gfx.PutPixel( 53 + x,102 + y,208,34,34 );
	gfx.PutPixel( 54 + x,102 + y,208,34,34 );
	gfx.PutPixel( 55 + x,102 + y,208,34,34 );
	gfx.PutPixel( 56 + x,102 + y,208,34,34 );
	gfx.PutPixel( 57 + x,102 + y,208,34,34 );
	gfx.PutPixel( 58 + x,102 + y,208,34,34 );
	gfx.PutPixel( 59 + x,102 + y,208,34,34 );
	gfx.PutPixel( 60 + x,102 + y,208,34,34 );
	gfx.PutPixel( 61 + x,102 + y,208,34,34 );
	gfx.PutPixel( 62 + x,102 + y,208,32,32 );
	gfx.PutPixel( 63 + x,102 + y,208,33,33 );
	gfx.PutPixel( 64 + x,102 + y,219,194,194 );
	gfx.PutPixel( 65 + x,102 + y,218,175,175 );
	gfx.PutPixel( 66 + x,102 + y,217,169,169 );
	gfx.PutPixel( 67 + x,102 + y,220,212,212 );
	gfx.PutPixel( 68 + x,102 + y,209,45,45 );
	gfx.PutPixel( 69 + x,102 + y,207,27,27 );
	gfx.PutPixel( 70 + x,102 + y,209,47,47 );
	gfx.PutPixel( 71 + x,102 + y,221,213,213 );
	gfx.PutPixel( 72 + x,102 + y,219,186,186 );
	gfx.PutPixel( 73 + x,102 + y,219,190,190 );
	gfx.PutPixel( 74 + x,102 + y,221,225,225 );
	gfx.PutPixel( 75 + x,102 + y,210,56,56 );
	gfx.PutPixel( 76 + x,102 + y,211,74,74 );
	gfx.PutPixel( 77 + x,102 + y,222,240,240 );
	gfx.PutPixel( 78 + x,102 + y,214,124,124 );
	gfx.PutPixel( 79 + x,102 + y,208,35,35 );
	gfx.PutPixel( 80 + x,102 + y,221,216,216 );
	gfx.PutPixel( 81 + x,102 + y,218,174,174 );
	gfx.PutPixel( 82 + x,102 + y,207,18,18 );
	gfx.PutPixel( 83 + x,102 + y,207,19,19 );
	gfx.PutPixel( 84 + x,102 + y,209,50,50 );
	gfx.PutPixel( 85 + x,102 + y,221,213,213 );
	gfx.PutPixel( 86 + x,102 + y,219,195,195 );
	gfx.PutPixel( 87 + x,102 + y,208,35,35 );
	gfx.PutPixel( 88 + x,102 + y,208,32,32 );
	gfx.PutPixel( 89 + x,102 + y,208,34,34 );
	gfx.PutPixel( 90 + x,102 + y,208,34,34 );
	gfx.PutPixel( 91 + x,102 + y,208,34,34 );
	gfx.PutPixel( 92 + x,102 + y,208,34,34 );
	gfx.PutPixel( 93 + x,102 + y,208,34,34 );
	gfx.PutPixel( 94 + x,102 + y,208,34,34 );
	gfx.PutPixel( 95 + x,102 + y,208,34,34 );
	gfx.PutPixel( 96 + x,102 + y,208,34,34 );
	gfx.PutPixel( 97 + x,102 + y,208,34,34 );
	gfx.PutPixel( 98 + x,102 + y,208,34,34 );
	gfx.PutPixel( 99 + x,102 + y,208,34,34 );
	gfx.PutPixel( 100 + x,102 + y,208,34,34 );
	gfx.PutPixel( 101 + x,102 + y,208,34,34 );
	gfx.PutPixel( 102 + x,102 + y,208,34,34 );
	gfx.PutPixel( 103 + x,102 + y,208,34,34 );
	gfx.PutPixel( 104 + x,102 + y,208,34,34 );
	gfx.PutPixel( 105 + x,102 + y,208,34,34 );
	gfx.PutPixel( 106 + x,102 + y,208,34,34 );
	gfx.PutPixel( 107 + x,102 + y,208,34,34 );
	gfx.PutPixel( 108 + x,102 + y,208,34,34 );
	gfx.PutPixel( 109 + x,102 + y,208,34,34 );
	gfx.PutPixel( 110 + x,102 + y,208,34,34 );
	gfx.PutPixel( 111 + x,102 + y,208,34,34 );
	gfx.PutPixel( 112 + x,102 + y,208,34,34 );
	gfx.PutPixel( 113 + x,102 + y,208,34,34 );
	gfx.PutPixel( 114 + x,102 + y,208,34,34 );
	gfx.PutPixel( 115 + x,102 + y,208,34,34 );
	gfx.PutPixel( 116 + x,102 + y,208,34,34 );
	gfx.PutPixel( 117 + x,102 + y,208,34,34 );
	gfx.PutPixel( 118 + x,102 + y,208,34,34 );
	gfx.PutPixel( 119 + x,102 + y,208,34,34 );
	gfx.PutPixel( 120 + x,102 + y,208,34,34 );
	gfx.PutPixel( 121 + x,102 + y,208,34,34 );
	gfx.PutPixel( 122 + x,102 + y,208,34,34 );
	gfx.PutPixel( 123 + x,102 + y,208,34,34 );
	gfx.PutPixel( 124 + x,102 + y,208,34,34 );
	gfx.PutPixel( 125 + x,102 + y,208,34,34 );
	gfx.PutPixel( 126 + x,102 + y,208,34,34 );
	gfx.PutPixel( 127 + x,102 + y,208,34,34 );
	gfx.PutPixel( 128 + x,102 + y,208,34,34 );
	gfx.PutPixel( 129 + x,102 + y,208,34,34 );
	gfx.PutPixel( 130 + x,102 + y,208,34,34 );
	gfx.PutPixel( 131 + x,102 + y,208,34,34 );
	gfx.PutPixel( 132 + x,102 + y,208,34,34 );
	gfx.PutPixel( 133 + x,102 + y,208,34,34 );
	gfx.PutPixel( 134 + x,102 + y,208,34,34 );
	gfx.PutPixel( 135 + x,102 + y,208,34,34 );
	gfx.PutPixel( 136 + x,102 + y,208,34,34 );
	gfx.PutPixel( 137 + x,102 + y,208,34,34 );
	gfx.PutPixel( 138 + x,102 + y,208,34,34 );
	gfx.PutPixel( 139 + x,102 + y,208,34,34 );
	gfx.PutPixel( 140 + x,102 + y,208,34,34 );
	gfx.PutPixel( 141 + x,102 + y,208,34,34 );
	gfx.PutPixel( 142 + x,102 + y,208,34,34 );
	gfx.PutPixel( 143 + x,102 + y,208,34,34 );
	gfx.PutPixel( 144 + x,102 + y,208,34,34 );
	gfx.PutPixel( 145 + x,102 + y,208,34,34 );
	gfx.PutPixel( 146 + x,102 + y,208,34,34 );
	gfx.PutPixel( 147 + x,102 + y,208,34,34 );
	gfx.PutPixel( 148 + x,102 + y,208,34,34 );
	gfx.PutPixel( 149 + x,102 + y,208,34,34 );
	gfx.PutPixel( 0 + x,103 + y,208,34,34 );
	gfx.PutPixel( 1 + x,103 + y,208,34,34 );
	gfx.PutPixel( 2 + x,103 + y,208,34,34 );
	gfx.PutPixel( 3 + x,103 + y,208,34,34 );
	gfx.PutPixel( 4 + x,103 + y,208,34,34 );
	gfx.PutPixel( 5 + x,103 + y,208,34,34 );
	gfx.PutPixel( 6 + x,103 + y,208,34,34 );
	gfx.PutPixel( 7 + x,103 + y,208,34,34 );
	gfx.PutPixel( 8 + x,103 + y,208,34,34 );
	gfx.PutPixel( 9 + x,103 + y,208,34,34 );
	gfx.PutPixel( 10 + x,103 + y,208,34,34 );
	gfx.PutPixel( 11 + x,103 + y,208,34,34 );
	gfx.PutPixel( 12 + x,103 + y,208,34,34 );
	gfx.PutPixel( 13 + x,103 + y,208,34,34 );
	gfx.PutPixel( 14 + x,103 + y,208,34,34 );
	gfx.PutPixel( 15 + x,103 + y,208,34,34 );
	gfx.PutPixel( 16 + x,103 + y,208,34,34 );
	gfx.PutPixel( 17 + x,103 + y,208,34,34 );
	gfx.PutPixel( 18 + x,103 + y,208,34,34 );
	gfx.PutPixel( 19 + x,103 + y,208,34,34 );
	gfx.PutPixel( 20 + x,103 + y,208,34,34 );
	gfx.PutPixel( 21 + x,103 + y,208,34,34 );
	gfx.PutPixel( 22 + x,103 + y,208,34,34 );
	gfx.PutPixel( 23 + x,103 + y,208,34,34 );
	gfx.PutPixel( 24 + x,103 + y,208,34,34 );
	gfx.PutPixel( 25 + x,103 + y,208,34,34 );
	gfx.PutPixel( 26 + x,103 + y,208,34,34 );
	gfx.PutPixel( 27 + x,103 + y,208,34,34 );
	gfx.PutPixel( 28 + x,103 + y,208,34,34 );
	gfx.PutPixel( 29 + x,103 + y,208,34,34 );
	gfx.PutPixel( 30 + x,103 + y,208,34,34 );
	gfx.PutPixel( 31 + x,103 + y,208,34,34 );
	gfx.PutPixel( 32 + x,103 + y,208,34,34 );
	gfx.PutPixel( 33 + x,103 + y,208,34,34 );
	gfx.PutPixel( 34 + x,103 + y,208,34,34 );
	gfx.PutPixel( 35 + x,103 + y,208,34,34 );
	gfx.PutPixel( 36 + x,103 + y,208,34,34 );
	gfx.PutPixel( 37 + x,103 + y,208,34,34 );
	gfx.PutPixel( 38 + x,103 + y,208,34,34 );
	gfx.PutPixel( 39 + x,103 + y,208,34,34 );
	gfx.PutPixel( 40 + x,103 + y,208,34,34 );
	gfx.PutPixel( 41 + x,103 + y,208,34,34 );
	gfx.PutPixel( 42 + x,103 + y,208,34,34 );
	gfx.PutPixel( 43 + x,103 + y,208,34,34 );
	gfx.PutPixel( 44 + x,103 + y,208,34,34 );
	gfx.PutPixel( 45 + x,103 + y,208,34,34 );
	gfx.PutPixel( 46 + x,103 + y,208,34,34 );
	gfx.PutPixel( 47 + x,103 + y,208,34,34 );
	gfx.PutPixel( 48 + x,103 + y,208,34,34 );
	gfx.PutPixel( 49 + x,103 + y,208,34,34 );
	gfx.PutPixel( 50 + x,103 + y,208,34,34 );
	gfx.PutPixel( 51 + x,103 + y,208,34,34 );
	gfx.PutPixel( 52 + x,103 + y,208,34,34 );
	gfx.PutPixel( 53 + x,103 + y,208,34,34 );
	gfx.PutPixel( 54 + x,103 + y,208,34,34 );
	gfx.PutPixel( 55 + x,103 + y,208,34,34 );
	gfx.PutPixel( 56 + x,103 + y,208,34,34 );
	gfx.PutPixel( 57 + x,103 + y,208,34,34 );
	gfx.PutPixel( 58 + x,103 + y,208,34,34 );
	gfx.PutPixel( 59 + x,103 + y,208,34,34 );
	gfx.PutPixel( 60 + x,103 + y,208,34,34 );
	gfx.PutPixel( 61 + x,103 + y,208,34,34 );
	gfx.PutPixel( 62 + x,103 + y,207,24,24 );
	gfx.PutPixel( 63 + x,103 + y,212,88,88 );
	gfx.PutPixel( 64 + x,103 + y,222,236,236 );
	gfx.PutPixel( 65 + x,103 + y,212,86,86 );
	gfx.PutPixel( 66 + x,103 + y,211,77,77 );
	gfx.PutPixel( 67 + x,103 + y,222,239,239 );
	gfx.PutPixel( 68 + x,103 + y,213,112,112 );
	gfx.PutPixel( 69 + x,103 + y,207,19,19 );
	gfx.PutPixel( 70 + x,103 + y,209,47,47 );
	gfx.PutPixel( 71 + x,103 + y,221,216,216 );
	gfx.PutPixel( 72 + x,103 + y,217,166,166 );
	gfx.PutPixel( 73 + x,103 + y,211,82,82 );
	gfx.PutPixel( 74 + x,103 + y,222,237,237 );
	gfx.PutPixel( 75 + x,103 + y,217,166,166 );
	gfx.PutPixel( 76 + x,103 + y,211,78,78 );
	gfx.PutPixel( 77 + x,103 + y,222,238,238 );
	gfx.PutPixel( 78 + x,103 + y,214,124,124 );
	gfx.PutPixel( 79 + x,103 + y,208,35,35 );
	gfx.PutPixel( 80 + x,103 + y,221,216,216 );
	gfx.PutPixel( 81 + x,103 + y,218,176,176 );
	gfx.PutPixel( 82 + x,103 + y,208,27,27 );
	gfx.PutPixel( 83 + x,103 + y,208,33,33 );
	gfx.PutPixel( 84 + x,103 + y,208,25,25 );
	gfx.PutPixel( 85 + x,103 + y,218,176,176 );
	gfx.PutPixel( 86 + x,103 + y,220,217,217 );
	gfx.PutPixel( 87 + x,103 + y,209,47,47 );
	gfx.PutPixel( 88 + x,103 + y,208,31,31 );
	gfx.PutPixel( 89 + x,103 + y,208,34,34 );
	gfx.PutPixel( 90 + x,103 + y,208,34,34 );
	gfx.PutPixel( 91 + x,103 + y,208,34,34 );
	gfx.PutPixel( 92 + x,103 + y,208,34,34 );
	gfx.PutPixel( 93 + x,103 + y,208,34,34 );
	gfx.PutPixel( 94 + x,103 + y,208,34,34 );
	gfx.PutPixel( 95 + x,103 + y,208,34,34 );
	gfx.PutPixel( 96 + x,103 + y,208,34,34 );
	gfx.PutPixel( 97 + x,103 + y,208,34,34 );
	gfx.PutPixel( 98 + x,103 + y,208,34,34 );
	gfx.PutPixel( 99 + x,103 + y,208,34,34 );
	gfx.PutPixel( 100 + x,103 + y,208,34,34 );
	gfx.PutPixel( 101 + x,103 + y,208,34,34 );
	gfx.PutPixel( 102 + x,103 + y,208,34,34 );
	gfx.PutPixel( 103 + x,103 + y,208,34,34 );
	gfx.PutPixel( 104 + x,103 + y,208,34,34 );
	gfx.PutPixel( 105 + x,103 + y,208,34,34 );
	gfx.PutPixel( 106 + x,103 + y,208,34,34 );
	gfx.PutPixel( 107 + x,103 + y,208,34,34 );
	gfx.PutPixel( 108 + x,103 + y,208,34,34 );
	gfx.PutPixel( 109 + x,103 + y,208,34,34 );
	gfx.PutPixel( 110 + x,103 + y,208,34,34 );
	gfx.PutPixel( 111 + x,103 + y,208,34,34 );
	gfx.PutPixel( 112 + x,103 + y,208,34,34 );
	gfx.PutPixel( 113 + x,103 + y,208,34,34 );
	gfx.PutPixel( 114 + x,103 + y,208,34,34 );
	gfx.PutPixel( 115 + x,103 + y,208,34,34 );
	gfx.PutPixel( 116 + x,103 + y,208,34,34 );
	gfx.PutPixel( 117 + x,103 + y,208,34,34 );
	gfx.PutPixel( 118 + x,103 + y,208,34,34 );
	gfx.PutPixel( 119 + x,103 + y,208,34,34 );
	gfx.PutPixel( 120 + x,103 + y,208,34,34 );
	gfx.PutPixel( 121 + x,103 + y,208,34,34 );
	gfx.PutPixel( 122 + x,103 + y,208,34,34 );
	gfx.PutPixel( 123 + x,103 + y,208,34,34 );
	gfx.PutPixel( 124 + x,103 + y,208,34,34 );
	gfx.PutPixel( 125 + x,103 + y,208,34,34 );
	gfx.PutPixel( 126 + x,103 + y,208,34,34 );
	gfx.PutPixel( 127 + x,103 + y,208,34,34 );
	gfx.PutPixel( 128 + x,103 + y,208,34,34 );
	gfx.PutPixel( 129 + x,103 + y,208,34,34 );
	gfx.PutPixel( 130 + x,103 + y,208,34,34 );
	gfx.PutPixel( 131 + x,103 + y,208,34,34 );
	gfx.PutPixel( 132 + x,103 + y,208,34,34 );
	gfx.PutPixel( 133 + x,103 + y,208,34,34 );
	gfx.PutPixel( 134 + x,103 + y,208,34,34 );
	gfx.PutPixel( 135 + x,103 + y,208,34,34 );
	gfx.PutPixel( 136 + x,103 + y,208,34,34 );
	gfx.PutPixel( 137 + x,103 + y,208,34,34 );
	gfx.PutPixel( 138 + x,103 + y,208,34,34 );
	gfx.PutPixel( 139 + x,103 + y,208,34,34 );
	gfx.PutPixel( 140 + x,103 + y,208,34,34 );
	gfx.PutPixel( 141 + x,103 + y,208,34,34 );
	gfx.PutPixel( 142 + x,103 + y,208,34,34 );
	gfx.PutPixel( 143 + x,103 + y,208,34,34 );
	gfx.PutPixel( 144 + x,103 + y,208,34,34 );
	gfx.PutPixel( 145 + x,103 + y,208,34,34 );
	gfx.PutPixel( 146 + x,103 + y,208,34,34 );
	gfx.PutPixel( 147 + x,103 + y,208,34,34 );
	gfx.PutPixel( 148 + x,103 + y,208,34,34 );
	gfx.PutPixel( 149 + x,103 + y,208,34,34 );
	gfx.PutPixel( 0 + x,104 + y,208,34,34 );
	gfx.PutPixel( 1 + x,104 + y,208,34,34 );
	gfx.PutPixel( 2 + x,104 + y,208,34,34 );
	gfx.PutPixel( 3 + x,104 + y,208,34,34 );
	gfx.PutPixel( 4 + x,104 + y,208,34,34 );
	gfx.PutPixel( 5 + x,104 + y,208,34,34 );
	gfx.PutPixel( 6 + x,104 + y,208,34,34 );
	gfx.PutPixel( 7 + x,104 + y,208,34,34 );
	gfx.PutPixel( 8 + x,104 + y,208,34,34 );
	gfx.PutPixel( 9 + x,104 + y,208,34,34 );
	gfx.PutPixel( 10 + x,104 + y,208,34,34 );
	gfx.PutPixel( 11 + x,104 + y,208,34,34 );
	gfx.PutPixel( 12 + x,104 + y,208,34,34 );
	gfx.PutPixel( 13 + x,104 + y,208,34,34 );
	gfx.PutPixel( 14 + x,104 + y,208,34,34 );
	gfx.PutPixel( 15 + x,104 + y,208,34,34 );
	gfx.PutPixel( 16 + x,104 + y,208,34,34 );
	gfx.PutPixel( 17 + x,104 + y,208,34,34 );
	gfx.PutPixel( 18 + x,104 + y,208,34,34 );
	gfx.PutPixel( 19 + x,104 + y,208,34,34 );
	gfx.PutPixel( 20 + x,104 + y,208,34,34 );
	gfx.PutPixel( 21 + x,104 + y,208,34,34 );
	gfx.PutPixel( 22 + x,104 + y,208,34,34 );
	gfx.PutPixel( 23 + x,104 + y,208,34,34 );
	gfx.PutPixel( 24 + x,104 + y,208,34,34 );
	gfx.PutPixel( 25 + x,104 + y,208,34,34 );
	gfx.PutPixel( 26 + x,104 + y,208,34,34 );
	gfx.PutPixel( 27 + x,104 + y,208,34,34 );
	gfx.PutPixel( 28 + x,104 + y,208,34,34 );
	gfx.PutPixel( 29 + x,104 + y,208,34,34 );
	gfx.PutPixel( 30 + x,104 + y,208,34,34 );
	gfx.PutPixel( 31 + x,104 + y,208,34,34 );
	gfx.PutPixel( 32 + x,104 + y,208,34,34 );
	gfx.PutPixel( 33 + x,104 + y,208,34,34 );
	gfx.PutPixel( 34 + x,104 + y,208,34,34 );
	gfx.PutPixel( 35 + x,104 + y,208,34,34 );
	gfx.PutPixel( 36 + x,104 + y,208,34,34 );
	gfx.PutPixel( 37 + x,104 + y,208,34,34 );
	gfx.PutPixel( 38 + x,104 + y,208,34,34 );
	gfx.PutPixel( 39 + x,104 + y,208,34,34 );
	gfx.PutPixel( 40 + x,104 + y,208,34,34 );
	gfx.PutPixel( 41 + x,104 + y,208,34,34 );
	gfx.PutPixel( 42 + x,104 + y,208,34,34 );
	gfx.PutPixel( 43 + x,104 + y,208,34,34 );
	gfx.PutPixel( 44 + x,104 + y,208,34,34 );
	gfx.PutPixel( 45 + x,104 + y,208,34,34 );
	gfx.PutPixel( 46 + x,104 + y,208,34,34 );
	gfx.PutPixel( 47 + x,104 + y,208,34,34 );
	gfx.PutPixel( 48 + x,104 + y,208,34,34 );
	gfx.PutPixel( 49 + x,104 + y,208,34,34 );
	gfx.PutPixel( 50 + x,104 + y,208,34,34 );
	gfx.PutPixel( 51 + x,104 + y,208,34,34 );
	gfx.PutPixel( 52 + x,104 + y,208,34,34 );
	gfx.PutPixel( 53 + x,104 + y,208,34,34 );
	gfx.PutPixel( 54 + x,104 + y,208,34,34 );
	gfx.PutPixel( 55 + x,104 + y,208,34,34 );
	gfx.PutPixel( 56 + x,104 + y,208,34,34 );
	gfx.PutPixel( 57 + x,104 + y,208,34,34 );
	gfx.PutPixel( 58 + x,104 + y,208,34,34 );
	gfx.PutPixel( 59 + x,104 + y,208,34,34 );
	gfx.PutPixel( 60 + x,104 + y,208,34,34 );
	gfx.PutPixel( 61 + x,104 + y,208,34,34 );
	gfx.PutPixel( 62 + x,104 + y,207,26,26 );
	gfx.PutPixel( 63 + x,104 + y,217,165,165 );
	gfx.PutPixel( 64 + x,104 + y,222,235,235 );
	gfx.PutPixel( 65 + x,104 + y,219,186,186 );
	gfx.PutPixel( 66 + x,104 + y,218,185,185 );
	gfx.PutPixel( 67 + x,104 + y,222,232,232 );
	gfx.PutPixel( 68 + x,104 + y,219,188,188 );
	gfx.PutPixel( 69 + x,104 + y,208,30,30 );
	gfx.PutPixel( 70 + x,104 + y,209,45,45 );
	gfx.PutPixel( 71 + x,104 + y,221,216,216 );
	gfx.PutPixel( 72 + x,104 + y,218,176,176 );
	gfx.PutPixel( 73 + x,104 + y,207,18,18 );
	gfx.PutPixel( 74 + x,104 + y,216,155,155 );
	gfx.PutPixel( 75 + x,104 + y,222,235,235 );
	gfx.PutPixel( 76 + x,104 + y,217,160,160 );
	gfx.PutPixel( 77 + x,104 + y,222,231,231 );
	gfx.PutPixel( 78 + x,104 + y,214,124,124 );
	gfx.PutPixel( 79 + x,104 + y,208,35,35 );
	gfx.PutPixel( 80 + x,104 + y,221,216,216 );
	gfx.PutPixel( 81 + x,104 + y,218,175,175 );
	gfx.PutPixel( 82 + x,104 + y,208,23,23 );
	gfx.PutPixel( 83 + x,104 + y,207,24,24 );
	gfx.PutPixel( 84 + x,104 + y,208,34,34 );
	gfx.PutPixel( 85 + x,104 + y,220,200,200 );
	gfx.PutPixel( 86 + x,104 + y,220,204,204 );
	gfx.PutPixel( 87 + x,104 + y,209,39,39 );
	gfx.PutPixel( 88 + x,104 + y,208,32,32 );
	gfx.PutPixel( 89 + x,104 + y,208,34,34 );
	gfx.PutPixel( 90 + x,104 + y,208,34,34 );
	gfx.PutPixel( 91 + x,104 + y,208,34,34 );
	gfx.PutPixel( 92 + x,104 + y,208,34,34 );
	gfx.PutPixel( 93 + x,104 + y,208,34,34 );
	gfx.PutPixel( 94 + x,104 + y,208,34,34 );
	gfx.PutPixel( 95 + x,104 + y,208,34,34 );
	gfx.PutPixel( 96 + x,104 + y,208,34,34 );
	gfx.PutPixel( 97 + x,104 + y,208,34,34 );
	gfx.PutPixel( 98 + x,104 + y,208,34,34 );
	gfx.PutPixel( 99 + x,104 + y,208,34,34 );
	gfx.PutPixel( 100 + x,104 + y,208,34,34 );
	gfx.PutPixel( 101 + x,104 + y,208,34,34 );
	gfx.PutPixel( 102 + x,104 + y,208,34,34 );
	gfx.PutPixel( 103 + x,104 + y,208,34,34 );
	gfx.PutPixel( 104 + x,104 + y,208,34,34 );
	gfx.PutPixel( 105 + x,104 + y,208,34,34 );
	gfx.PutPixel( 106 + x,104 + y,208,34,34 );
	gfx.PutPixel( 107 + x,104 + y,208,34,34 );
	gfx.PutPixel( 108 + x,104 + y,208,34,34 );
	gfx.PutPixel( 109 + x,104 + y,208,34,34 );
	gfx.PutPixel( 110 + x,104 + y,208,34,34 );
	gfx.PutPixel( 111 + x,104 + y,208,34,34 );
	gfx.PutPixel( 112 + x,104 + y,208,34,34 );
	gfx.PutPixel( 113 + x,104 + y,208,34,34 );
	gfx.PutPixel( 114 + x,104 + y,208,34,34 );
	gfx.PutPixel( 115 + x,104 + y,208,34,34 );
	gfx.PutPixel( 116 + x,104 + y,208,34,34 );
	gfx.PutPixel( 117 + x,104 + y,208,34,34 );
	gfx.PutPixel( 118 + x,104 + y,208,34,34 );
	gfx.PutPixel( 119 + x,104 + y,208,34,34 );
	gfx.PutPixel( 120 + x,104 + y,208,34,34 );
	gfx.PutPixel( 121 + x,104 + y,208,34,34 );
	gfx.PutPixel( 122 + x,104 + y,208,34,34 );
	gfx.PutPixel( 123 + x,104 + y,208,34,34 );
	gfx.PutPixel( 124 + x,104 + y,208,34,34 );
	gfx.PutPixel( 125 + x,104 + y,208,34,34 );
	gfx.PutPixel( 126 + x,104 + y,208,34,34 );
	gfx.PutPixel( 127 + x,104 + y,208,34,34 );
	gfx.PutPixel( 128 + x,104 + y,208,34,34 );
	gfx.PutPixel( 129 + x,104 + y,208,34,34 );
	gfx.PutPixel( 130 + x,104 + y,208,34,34 );
	gfx.PutPixel( 131 + x,104 + y,208,34,34 );
	gfx.PutPixel( 132 + x,104 + y,208,34,34 );
	gfx.PutPixel( 133 + x,104 + y,208,34,34 );
	gfx.PutPixel( 134 + x,104 + y,208,34,34 );
	gfx.PutPixel( 135 + x,104 + y,208,34,34 );
	gfx.PutPixel( 136 + x,104 + y,208,34,34 );
	gfx.PutPixel( 137 + x,104 + y,208,34,34 );
	gfx.PutPixel( 138 + x,104 + y,208,34,34 );
	gfx.PutPixel( 139 + x,104 + y,208,34,34 );
	gfx.PutPixel( 140 + x,104 + y,208,34,34 );
	gfx.PutPixel( 141 + x,104 + y,208,34,34 );
	gfx.PutPixel( 142 + x,104 + y,208,34,34 );
	gfx.PutPixel( 143 + x,104 + y,208,34,34 );
	gfx.PutPixel( 144 + x,104 + y,208,34,34 );
	gfx.PutPixel( 145 + x,104 + y,208,34,34 );
	gfx.PutPixel( 146 + x,104 + y,208,34,34 );
	gfx.PutPixel( 147 + x,104 + y,208,34,34 );
	gfx.PutPixel( 148 + x,104 + y,208,34,34 );
	gfx.PutPixel( 149 + x,104 + y,208,34,34 );
	gfx.PutPixel( 0 + x,105 + y,208,34,34 );
	gfx.PutPixel( 1 + x,105 + y,208,34,34 );
	gfx.PutPixel( 2 + x,105 + y,208,34,34 );
	gfx.PutPixel( 3 + x,105 + y,208,34,34 );
	gfx.PutPixel( 4 + x,105 + y,208,34,34 );
	gfx.PutPixel( 5 + x,105 + y,208,34,34 );
	gfx.PutPixel( 6 + x,105 + y,208,34,34 );
	gfx.PutPixel( 7 + x,105 + y,208,34,34 );
	gfx.PutPixel( 8 + x,105 + y,208,34,34 );
	gfx.PutPixel( 9 + x,105 + y,208,34,34 );
	gfx.PutPixel( 10 + x,105 + y,208,34,34 );
	gfx.PutPixel( 11 + x,105 + y,208,34,34 );
	gfx.PutPixel( 12 + x,105 + y,208,34,34 );
	gfx.PutPixel( 13 + x,105 + y,208,34,34 );
	gfx.PutPixel( 14 + x,105 + y,208,34,34 );
	gfx.PutPixel( 15 + x,105 + y,208,34,34 );
	gfx.PutPixel( 16 + x,105 + y,208,34,34 );
	gfx.PutPixel( 17 + x,105 + y,208,34,34 );
	gfx.PutPixel( 18 + x,105 + y,208,34,34 );
	gfx.PutPixel( 19 + x,105 + y,208,34,34 );
	gfx.PutPixel( 20 + x,105 + y,208,34,34 );
	gfx.PutPixel( 21 + x,105 + y,208,34,34 );
	gfx.PutPixel( 22 + x,105 + y,208,34,34 );
	gfx.PutPixel( 23 + x,105 + y,208,34,34 );
	gfx.PutPixel( 24 + x,105 + y,208,34,34 );
	gfx.PutPixel( 25 + x,105 + y,208,34,34 );
	gfx.PutPixel( 26 + x,105 + y,208,34,34 );
	gfx.PutPixel( 27 + x,105 + y,208,34,34 );
	gfx.PutPixel( 28 + x,105 + y,208,34,34 );
	gfx.PutPixel( 29 + x,105 + y,208,34,34 );
	gfx.PutPixel( 30 + x,105 + y,208,34,34 );
	gfx.PutPixel( 31 + x,105 + y,208,34,34 );
	gfx.PutPixel( 32 + x,105 + y,208,34,34 );
	gfx.PutPixel( 33 + x,105 + y,208,34,34 );
	gfx.PutPixel( 34 + x,105 + y,208,34,34 );
	gfx.PutPixel( 35 + x,105 + y,208,34,34 );
	gfx.PutPixel( 36 + x,105 + y,208,34,34 );
	gfx.PutPixel( 37 + x,105 + y,208,34,34 );
	gfx.PutPixel( 38 + x,105 + y,208,34,34 );
	gfx.PutPixel( 39 + x,105 + y,208,34,34 );
	gfx.PutPixel( 40 + x,105 + y,208,34,34 );
	gfx.PutPixel( 41 + x,105 + y,208,34,34 );
	gfx.PutPixel( 42 + x,105 + y,208,34,34 );
	gfx.PutPixel( 43 + x,105 + y,208,34,34 );
	gfx.PutPixel( 44 + x,105 + y,208,34,34 );
	gfx.PutPixel( 45 + x,105 + y,208,34,34 );
	gfx.PutPixel( 46 + x,105 + y,208,34,34 );
	gfx.PutPixel( 47 + x,105 + y,208,34,34 );
	gfx.PutPixel( 48 + x,105 + y,208,34,34 );
	gfx.PutPixel( 49 + x,105 + y,208,34,34 );
	gfx.PutPixel( 50 + x,105 + y,208,34,34 );
	gfx.PutPixel( 51 + x,105 + y,208,34,34 );
	gfx.PutPixel( 52 + x,105 + y,208,34,34 );
	gfx.PutPixel( 53 + x,105 + y,208,34,34 );
	gfx.PutPixel( 54 + x,105 + y,208,34,34 );
	gfx.PutPixel( 55 + x,105 + y,208,34,34 );
	gfx.PutPixel( 56 + x,105 + y,208,34,34 );
	gfx.PutPixel( 57 + x,105 + y,208,34,34 );
	gfx.PutPixel( 58 + x,105 + y,208,34,34 );
	gfx.PutPixel( 59 + x,105 + y,208,34,34 );
	gfx.PutPixel( 60 + x,105 + y,208,34,34 );
	gfx.PutPixel( 61 + x,105 + y,207,27,27 );
	gfx.PutPixel( 62 + x,105 + y,210,66,66 );
	gfx.PutPixel( 63 + x,105 + y,221,224,224 );
	gfx.PutPixel( 64 + x,105 + y,219,199,199 );
	gfx.PutPixel( 65 + x,105 + y,218,177,177 );
	gfx.PutPixel( 66 + x,105 + y,218,177,177 );
	gfx.PutPixel( 67 + x,105 + y,219,194,194 );
	gfx.PutPixel( 68 + x,105 + y,222,232,232 );
	gfx.PutPixel( 69 + x,105 + y,212,85,85 );
	gfx.PutPixel( 70 + x,105 + y,208,37,37 );
	gfx.PutPixel( 71 + x,105 + y,221,216,216 );
	gfx.PutPixel( 72 + x,105 + y,218,176,176 );
	gfx.PutPixel( 73 + x,105 + y,207,21,21 );
	gfx.PutPixel( 74 + x,105 + y,209,52,52 );
	gfx.PutPixel( 75 + x,105 + y,220,210,210 );
	gfx.PutPixel( 76 + x,105 + y,222,229,229 );
	gfx.PutPixel( 77 + x,105 + y,222,232,232 );
	gfx.PutPixel( 78 + x,105 + y,214,124,124 );
	gfx.PutPixel( 79 + x,105 + y,208,35,35 );
	gfx.PutPixel( 80 + x,105 + y,221,215,215 );
	gfx.PutPixel( 81 + x,105 + y,218,179,179 );
	gfx.PutPixel( 82 + x,105 + y,208,40,40 );
	gfx.PutPixel( 83 + x,105 + y,210,58,58 );
	gfx.PutPixel( 84 + x,105 + y,216,149,149 );
	gfx.PutPixel( 85 + x,105 + y,222,244,244 );
	gfx.PutPixel( 86 + x,105 + y,215,131,131 );
	gfx.PutPixel( 87 + x,105 + y,207,25,25 );
	gfx.PutPixel( 88 + x,105 + y,208,34,34 );
	gfx.PutPixel( 89 + x,105 + y,208,34,34 );
	gfx.PutPixel( 90 + x,105 + y,208,34,34 );
	gfx.PutPixel( 91 + x,105 + y,208,34,34 );
	gfx.PutPixel( 92 + x,105 + y,208,34,34 );
	gfx.PutPixel( 93 + x,105 + y,208,34,34 );
	gfx.PutPixel( 94 + x,105 + y,208,34,34 );
	gfx.PutPixel( 95 + x,105 + y,208,34,34 );
	gfx.PutPixel( 96 + x,105 + y,208,34,34 );
	gfx.PutPixel( 97 + x,105 + y,208,34,34 );
	gfx.PutPixel( 98 + x,105 + y,208,34,34 );
	gfx.PutPixel( 99 + x,105 + y,208,34,34 );
	gfx.PutPixel( 100 + x,105 + y,208,34,34 );
	gfx.PutPixel( 101 + x,105 + y,208,34,34 );
	gfx.PutPixel( 102 + x,105 + y,208,34,34 );
	gfx.PutPixel( 103 + x,105 + y,208,34,34 );
	gfx.PutPixel( 104 + x,105 + y,208,34,34 );
	gfx.PutPixel( 105 + x,105 + y,208,34,34 );
	gfx.PutPixel( 106 + x,105 + y,208,34,34 );
	gfx.PutPixel( 107 + x,105 + y,208,34,34 );
	gfx.PutPixel( 108 + x,105 + y,208,34,34 );
	gfx.PutPixel( 109 + x,105 + y,208,34,34 );
	gfx.PutPixel( 110 + x,105 + y,208,34,34 );
	gfx.PutPixel( 111 + x,105 + y,208,34,34 );
	gfx.PutPixel( 112 + x,105 + y,208,34,34 );
	gfx.PutPixel( 113 + x,105 + y,208,34,34 );
	gfx.PutPixel( 114 + x,105 + y,208,34,34 );
	gfx.PutPixel( 115 + x,105 + y,208,34,34 );
	gfx.PutPixel( 116 + x,105 + y,208,34,34 );
	gfx.PutPixel( 117 + x,105 + y,208,34,34 );
	gfx.PutPixel( 118 + x,105 + y,208,34,34 );
	gfx.PutPixel( 119 + x,105 + y,208,34,34 );
	gfx.PutPixel( 120 + x,105 + y,208,34,34 );
	gfx.PutPixel( 121 + x,105 + y,208,34,34 );
	gfx.PutPixel( 122 + x,105 + y,208,34,34 );
	gfx.PutPixel( 123 + x,105 + y,208,34,34 );
	gfx.PutPixel( 124 + x,105 + y,208,34,34 );
	gfx.PutPixel( 125 + x,105 + y,208,34,34 );
	gfx.PutPixel( 126 + x,105 + y,208,34,34 );
	gfx.PutPixel( 127 + x,105 + y,208,34,34 );
	gfx.PutPixel( 128 + x,105 + y,208,34,34 );
	gfx.PutPixel( 129 + x,105 + y,208,34,34 );
	gfx.PutPixel( 130 + x,105 + y,208,34,34 );
	gfx.PutPixel( 131 + x,105 + y,208,34,34 );
	gfx.PutPixel( 132 + x,105 + y,208,34,34 );
	gfx.PutPixel( 133 + x,105 + y,208,34,34 );
	gfx.PutPixel( 134 + x,105 + y,208,34,34 );
	gfx.PutPixel( 135 + x,105 + y,208,34,34 );
	gfx.PutPixel( 136 + x,105 + y,208,34,34 );
	gfx.PutPixel( 137 + x,105 + y,208,34,34 );
	gfx.PutPixel( 138 + x,105 + y,208,34,34 );
	gfx.PutPixel( 139 + x,105 + y,208,34,34 );
	gfx.PutPixel( 140 + x,105 + y,208,34,34 );
	gfx.PutPixel( 141 + x,105 + y,208,34,34 );
	gfx.PutPixel( 142 + x,105 + y,208,34,34 );
	gfx.PutPixel( 143 + x,105 + y,208,34,34 );
	gfx.PutPixel( 144 + x,105 + y,208,34,34 );
	gfx.PutPixel( 145 + x,105 + y,208,34,34 );
	gfx.PutPixel( 146 + x,105 + y,208,34,34 );
	gfx.PutPixel( 147 + x,105 + y,208,34,34 );
	gfx.PutPixel( 148 + x,105 + y,208,34,34 );
	gfx.PutPixel( 149 + x,105 + y,208,34,34 );
	gfx.PutPixel( 0 + x,106 + y,208,34,34 );
	gfx.PutPixel( 1 + x,106 + y,208,34,34 );
	gfx.PutPixel( 2 + x,106 + y,208,34,34 );
	gfx.PutPixel( 3 + x,106 + y,208,34,34 );
	gfx.PutPixel( 4 + x,106 + y,208,34,34 );
	gfx.PutPixel( 5 + x,106 + y,208,34,34 );
	gfx.PutPixel( 6 + x,106 + y,208,34,34 );
	gfx.PutPixel( 7 + x,106 + y,208,34,34 );
	gfx.PutPixel( 8 + x,106 + y,208,34,34 );
	gfx.PutPixel( 9 + x,106 + y,208,34,34 );
	gfx.PutPixel( 10 + x,106 + y,208,34,34 );
	gfx.PutPixel( 11 + x,106 + y,208,34,34 );
	gfx.PutPixel( 12 + x,106 + y,208,34,34 );
	gfx.PutPixel( 13 + x,106 + y,208,34,34 );
	gfx.PutPixel( 14 + x,106 + y,208,34,34 );
	gfx.PutPixel( 15 + x,106 + y,208,34,34 );
	gfx.PutPixel( 16 + x,106 + y,208,34,34 );
	gfx.PutPixel( 17 + x,106 + y,208,34,34 );
	gfx.PutPixel( 18 + x,106 + y,208,34,34 );
	gfx.PutPixel( 19 + x,106 + y,208,34,34 );
	gfx.PutPixel( 20 + x,106 + y,208,34,34 );
	gfx.PutPixel( 21 + x,106 + y,208,34,34 );
	gfx.PutPixel( 22 + x,106 + y,208,34,34 );
	gfx.PutPixel( 23 + x,106 + y,208,34,34 );
	gfx.PutPixel( 24 + x,106 + y,208,34,34 );
	gfx.PutPixel( 25 + x,106 + y,208,34,34 );
	gfx.PutPixel( 26 + x,106 + y,208,34,34 );
	gfx.PutPixel( 27 + x,106 + y,208,34,34 );
	gfx.PutPixel( 28 + x,106 + y,208,34,34 );
	gfx.PutPixel( 29 + x,106 + y,208,34,34 );
	gfx.PutPixel( 30 + x,106 + y,208,34,34 );
	gfx.PutPixel( 31 + x,106 + y,208,34,34 );
	gfx.PutPixel( 32 + x,106 + y,208,34,34 );
	gfx.PutPixel( 33 + x,106 + y,208,34,34 );
	gfx.PutPixel( 34 + x,106 + y,208,34,34 );
	gfx.PutPixel( 35 + x,106 + y,208,34,34 );
	gfx.PutPixel( 36 + x,106 + y,208,34,34 );
	gfx.PutPixel( 37 + x,106 + y,208,34,34 );
	gfx.PutPixel( 38 + x,106 + y,208,34,34 );
	gfx.PutPixel( 39 + x,106 + y,208,34,34 );
	gfx.PutPixel( 40 + x,106 + y,208,34,34 );
	gfx.PutPixel( 41 + x,106 + y,208,34,34 );
	gfx.PutPixel( 42 + x,106 + y,208,34,34 );
	gfx.PutPixel( 43 + x,106 + y,208,34,34 );
	gfx.PutPixel( 44 + x,106 + y,208,34,34 );
	gfx.PutPixel( 45 + x,106 + y,208,34,34 );
	gfx.PutPixel( 46 + x,106 + y,208,34,34 );
	gfx.PutPixel( 47 + x,106 + y,208,34,34 );
	gfx.PutPixel( 48 + x,106 + y,208,34,34 );
	gfx.PutPixel( 49 + x,106 + y,208,34,34 );
	gfx.PutPixel( 50 + x,106 + y,208,34,34 );
	gfx.PutPixel( 51 + x,106 + y,208,34,34 );
	gfx.PutPixel( 52 + x,106 + y,208,34,34 );
	gfx.PutPixel( 53 + x,106 + y,208,34,34 );
	gfx.PutPixel( 54 + x,106 + y,208,34,34 );
	gfx.PutPixel( 55 + x,106 + y,208,34,34 );
	gfx.PutPixel( 56 + x,106 + y,208,34,34 );
	gfx.PutPixel( 57 + x,106 + y,208,34,34 );
	gfx.PutPixel( 58 + x,106 + y,208,34,34 );
	gfx.PutPixel( 59 + x,106 + y,208,34,34 );
	gfx.PutPixel( 60 + x,106 + y,208,34,34 );
	gfx.PutPixel( 61 + x,106 + y,207,25,25 );
	gfx.PutPixel( 62 + x,106 + y,217,155,155 );
	gfx.PutPixel( 63 + x,106 + y,223,248,248 );
	gfx.PutPixel( 64 + x,106 + y,211,82,82 );
	gfx.PutPixel( 65 + x,106 + y,207,18,18 );
	gfx.PutPixel( 66 + x,106 + y,207,20,20 );
	gfx.PutPixel( 67 + x,106 + y,210,67,67 );
	gfx.PutPixel( 68 + x,106 + y,222,239,239 );
	gfx.PutPixel( 69 + x,106 + y,218,178,178 );
	gfx.PutPixel( 70 + x,106 + y,209,45,45 );
	gfx.PutPixel( 71 + x,106 + y,222,227,227 );
	gfx.PutPixel( 72 + x,106 + y,219,185,185 );
	gfx.PutPixel( 73 + x,106 + y,208,27,27 );
	gfx.PutPixel( 74 + x,106 + y,207,21,21 );
	gfx.PutPixel( 75 + x,106 + y,213,109,109 );
	gfx.PutPixel( 76 + x,106 + y,222,239,239 );
	gfx.PutPixel( 77 + x,106 + y,223,247,247 );
	gfx.PutPixel( 78 + x,106 + y,214,130,130 );
	gfx.PutPixel( 79 + x,106 + y,208,35,35 );
	gfx.PutPixel( 80 + x,106 + y,221,220,220 );
	gfx.PutPixel( 81 + x,106 + y,222,234,234 );
	gfx.PutPixel( 82 + x,106 + y,221,219,219 );
	gfx.PutPixel( 83 + x,106 + y,222,229,229 );
	gfx.PutPixel( 84 + x,106 + y,222,234,234 );
	gfx.PutPixel( 85 + x,106 + y,216,150,150 );
	gfx.PutPixel( 86 + x,106 + y,208,35,35 );
	gfx.PutPixel( 87 + x,106 + y,208,32,32 );
	gfx.PutPixel( 88 + x,106 + y,208,34,34 );
	gfx.PutPixel( 89 + x,106 + y,208,34,34 );
	gfx.PutPixel( 90 + x,106 + y,208,34,34 );
	gfx.PutPixel( 91 + x,106 + y,208,34,34 );
	gfx.PutPixel( 92 + x,106 + y,208,34,34 );
	gfx.PutPixel( 93 + x,106 + y,208,34,34 );
	gfx.PutPixel( 94 + x,106 + y,208,34,34 );
	gfx.PutPixel( 95 + x,106 + y,208,34,34 );
	gfx.PutPixel( 96 + x,106 + y,208,34,34 );
	gfx.PutPixel( 97 + x,106 + y,208,34,34 );
	gfx.PutPixel( 98 + x,106 + y,208,34,34 );
	gfx.PutPixel( 99 + x,106 + y,208,34,34 );
	gfx.PutPixel( 100 + x,106 + y,208,34,34 );
	gfx.PutPixel( 101 + x,106 + y,208,34,34 );
	gfx.PutPixel( 102 + x,106 + y,208,34,34 );
	gfx.PutPixel( 103 + x,106 + y,208,34,34 );
	gfx.PutPixel( 104 + x,106 + y,208,34,34 );
	gfx.PutPixel( 105 + x,106 + y,208,34,34 );
	gfx.PutPixel( 106 + x,106 + y,208,34,34 );
	gfx.PutPixel( 107 + x,106 + y,208,34,34 );
	gfx.PutPixel( 108 + x,106 + y,208,34,34 );
	gfx.PutPixel( 109 + x,106 + y,208,34,34 );
	gfx.PutPixel( 110 + x,106 + y,208,34,34 );
	gfx.PutPixel( 111 + x,106 + y,208,34,34 );
	gfx.PutPixel( 112 + x,106 + y,208,34,34 );
	gfx.PutPixel( 113 + x,106 + y,208,34,34 );
	gfx.PutPixel( 114 + x,106 + y,208,34,34 );
	gfx.PutPixel( 115 + x,106 + y,208,34,34 );
	gfx.PutPixel( 116 + x,106 + y,208,34,34 );
	gfx.PutPixel( 117 + x,106 + y,208,34,34 );
	gfx.PutPixel( 118 + x,106 + y,208,34,34 );
	gfx.PutPixel( 119 + x,106 + y,208,34,34 );
	gfx.PutPixel( 120 + x,106 + y,208,34,34 );
	gfx.PutPixel( 121 + x,106 + y,208,34,34 );
	gfx.PutPixel( 122 + x,106 + y,208,34,34 );
	gfx.PutPixel( 123 + x,106 + y,208,34,34 );
	gfx.PutPixel( 124 + x,106 + y,208,34,34 );
	gfx.PutPixel( 125 + x,106 + y,208,34,34 );
	gfx.PutPixel( 126 + x,106 + y,208,34,34 );
	gfx.PutPixel( 127 + x,106 + y,208,34,34 );
	gfx.PutPixel( 128 + x,106 + y,208,34,34 );
	gfx.PutPixel( 129 + x,106 + y,208,34,34 );
	gfx.PutPixel( 130 + x,106 + y,208,34,34 );
	gfx.PutPixel( 131 + x,106 + y,208,34,34 );
	gfx.PutPixel( 132 + x,106 + y,208,34,34 );
	gfx.PutPixel( 133 + x,106 + y,208,34,34 );
	gfx.PutPixel( 134 + x,106 + y,208,34,34 );
	gfx.PutPixel( 135 + x,106 + y,208,34,34 );
	gfx.PutPixel( 136 + x,106 + y,208,34,34 );
	gfx.PutPixel( 137 + x,106 + y,208,34,34 );
	gfx.PutPixel( 138 + x,106 + y,208,34,34 );
	gfx.PutPixel( 139 + x,106 + y,208,34,34 );
	gfx.PutPixel( 140 + x,106 + y,208,34,34 );
	gfx.PutPixel( 141 + x,106 + y,208,34,34 );
	gfx.PutPixel( 142 + x,106 + y,208,34,34 );
	gfx.PutPixel( 143 + x,106 + y,208,34,34 );
	gfx.PutPixel( 144 + x,106 + y,208,34,34 );
	gfx.PutPixel( 145 + x,106 + y,208,34,34 );
	gfx.PutPixel( 146 + x,106 + y,208,34,34 );
	gfx.PutPixel( 147 + x,106 + y,208,34,34 );
	gfx.PutPixel( 148 + x,106 + y,208,34,34 );
	gfx.PutPixel( 149 + x,106 + y,208,34,34 );
	gfx.PutPixel( 0 + x,107 + y,208,34,34 );
	gfx.PutPixel( 1 + x,107 + y,208,34,34 );
	gfx.PutPixel( 2 + x,107 + y,208,34,34 );
	gfx.PutPixel( 3 + x,107 + y,208,34,34 );
	gfx.PutPixel( 4 + x,107 + y,208,34,34 );
	gfx.PutPixel( 5 + x,107 + y,208,34,34 );
	gfx.PutPixel( 6 + x,107 + y,208,34,34 );
	gfx.PutPixel( 7 + x,107 + y,208,34,34 );
	gfx.PutPixel( 8 + x,107 + y,208,34,34 );
	gfx.PutPixel( 9 + x,107 + y,208,34,34 );
	gfx.PutPixel( 10 + x,107 + y,208,34,34 );
	gfx.PutPixel( 11 + x,107 + y,208,34,34 );
	gfx.PutPixel( 12 + x,107 + y,208,34,34 );
	gfx.PutPixel( 13 + x,107 + y,208,34,34 );
	gfx.PutPixel( 14 + x,107 + y,208,34,34 );
	gfx.PutPixel( 15 + x,107 + y,208,34,34 );
	gfx.PutPixel( 16 + x,107 + y,208,34,34 );
	gfx.PutPixel( 17 + x,107 + y,208,34,34 );
	gfx.PutPixel( 18 + x,107 + y,208,34,34 );
	gfx.PutPixel( 19 + x,107 + y,208,34,34 );
	gfx.PutPixel( 20 + x,107 + y,208,34,34 );
	gfx.PutPixel( 21 + x,107 + y,208,34,34 );
	gfx.PutPixel( 22 + x,107 + y,208,34,34 );
	gfx.PutPixel( 23 + x,107 + y,208,34,34 );
	gfx.PutPixel( 24 + x,107 + y,208,34,34 );
	gfx.PutPixel( 25 + x,107 + y,208,34,34 );
	gfx.PutPixel( 26 + x,107 + y,208,34,34 );
	gfx.PutPixel( 27 + x,107 + y,208,34,34 );
	gfx.PutPixel( 28 + x,107 + y,208,34,34 );
	gfx.PutPixel( 29 + x,107 + y,208,34,34 );
	gfx.PutPixel( 30 + x,107 + y,208,34,34 );
	gfx.PutPixel( 31 + x,107 + y,208,34,34 );
	gfx.PutPixel( 32 + x,107 + y,208,34,34 );
	gfx.PutPixel( 33 + x,107 + y,208,34,34 );
	gfx.PutPixel( 34 + x,107 + y,208,34,34 );
	gfx.PutPixel( 35 + x,107 + y,208,34,34 );
	gfx.PutPixel( 36 + x,107 + y,208,34,34 );
	gfx.PutPixel( 37 + x,107 + y,208,34,34 );
	gfx.PutPixel( 38 + x,107 + y,208,34,34 );
	gfx.PutPixel( 39 + x,107 + y,208,34,34 );
	gfx.PutPixel( 40 + x,107 + y,208,34,34 );
	gfx.PutPixel( 41 + x,107 + y,208,34,34 );
	gfx.PutPixel( 42 + x,107 + y,208,34,34 );
	gfx.PutPixel( 43 + x,107 + y,208,34,34 );
	gfx.PutPixel( 44 + x,107 + y,208,34,34 );
	gfx.PutPixel( 45 + x,107 + y,208,34,34 );
	gfx.PutPixel( 46 + x,107 + y,208,34,34 );
	gfx.PutPixel( 47 + x,107 + y,208,34,34 );
	gfx.PutPixel( 48 + x,107 + y,208,34,34 );
	gfx.PutPixel( 49 + x,107 + y,208,34,34 );
	gfx.PutPixel( 50 + x,107 + y,208,34,34 );
	gfx.PutPixel( 51 + x,107 + y,208,34,34 );
	gfx.PutPixel( 52 + x,107 + y,208,34,34 );
	gfx.PutPixel( 53 + x,107 + y,208,34,34 );
	gfx.PutPixel( 54 + x,107 + y,208,34,34 );
	gfx.PutPixel( 55 + x,107 + y,208,34,34 );
	gfx.PutPixel( 56 + x,107 + y,208,34,34 );
	gfx.PutPixel( 57 + x,107 + y,208,34,34 );
	gfx.PutPixel( 58 + x,107 + y,208,34,34 );
	gfx.PutPixel( 59 + x,107 + y,208,34,34 );
	gfx.PutPixel( 60 + x,107 + y,208,33,33 );
	gfx.PutPixel( 61 + x,107 + y,208,36,36 );
	gfx.PutPixel( 62 + x,107 + y,214,118,118 );
	gfx.PutPixel( 63 + x,107 + y,214,122,122 );
	gfx.PutPixel( 64 + x,107 + y,208,38,38 );
	gfx.PutPixel( 65 + x,107 + y,208,32,32 );
	gfx.PutPixel( 66 + x,107 + y,208,33,33 );
	gfx.PutPixel( 67 + x,107 + y,208,33,33 );
	gfx.PutPixel( 68 + x,107 + y,214,113,113 );
	gfx.PutPixel( 69 + x,107 + y,214,126,126 );
	gfx.PutPixel( 70 + x,107 + y,209,51,51 );
	gfx.PutPixel( 71 + x,107 + y,214,123,123 );
	gfx.PutPixel( 72 + x,107 + y,213,105,105 );
	gfx.PutPixel( 73 + x,107 + y,208,31,31 );
	gfx.PutPixel( 74 + x,107 + y,208,32,32 );
	gfx.PutPixel( 75 + x,107 + y,208,36,36 );
	gfx.PutPixel( 76 + x,107 + y,214,117,117 );
	gfx.PutPixel( 77 + x,107 + y,215,136,136 );
	gfx.PutPixel( 78 + x,107 + y,211,79,79 );
	gfx.PutPixel( 79 + x,107 + y,208,35,35 );
	gfx.PutPixel( 80 + x,107 + y,214,121,121 );
	gfx.PutPixel( 81 + x,107 + y,215,130,130 );
	gfx.PutPixel( 82 + x,107 + y,215,132,132 );
	gfx.PutPixel( 83 + x,107 + y,214,118,118 );
	gfx.PutPixel( 84 + x,107 + y,211,72,72 );
	gfx.PutPixel( 85 + x,107 + y,208,27,27 );
	gfx.PutPixel( 86 + x,107 + y,208,31,31 );
	gfx.PutPixel( 87 + x,107 + y,208,34,34 );
	gfx.PutPixel( 88 + x,107 + y,208,34,34 );
	gfx.PutPixel( 89 + x,107 + y,208,34,34 );
	gfx.PutPixel( 90 + x,107 + y,208,34,34 );
	gfx.PutPixel( 91 + x,107 + y,208,34,34 );
	gfx.PutPixel( 92 + x,107 + y,208,34,34 );
	gfx.PutPixel( 93 + x,107 + y,208,34,34 );
	gfx.PutPixel( 94 + x,107 + y,208,34,34 );
	gfx.PutPixel( 95 + x,107 + y,208,34,34 );
	gfx.PutPixel( 96 + x,107 + y,208,34,34 );
	gfx.PutPixel( 97 + x,107 + y,208,34,34 );
	gfx.PutPixel( 98 + x,107 + y,208,34,34 );
	gfx.PutPixel( 99 + x,107 + y,208,34,34 );
	gfx.PutPixel( 100 + x,107 + y,208,34,34 );
	gfx.PutPixel( 101 + x,107 + y,208,34,34 );
	gfx.PutPixel( 102 + x,107 + y,208,34,34 );
	gfx.PutPixel( 103 + x,107 + y,208,34,34 );
	gfx.PutPixel( 104 + x,107 + y,208,34,34 );
	gfx.PutPixel( 105 + x,107 + y,208,34,34 );
	gfx.PutPixel( 106 + x,107 + y,208,34,34 );
	gfx.PutPixel( 107 + x,107 + y,208,34,34 );
	gfx.PutPixel( 108 + x,107 + y,208,34,34 );
	gfx.PutPixel( 109 + x,107 + y,208,34,34 );
	gfx.PutPixel( 110 + x,107 + y,208,34,34 );
	gfx.PutPixel( 111 + x,107 + y,208,34,34 );
	gfx.PutPixel( 112 + x,107 + y,208,34,34 );
	gfx.PutPixel( 113 + x,107 + y,208,34,34 );
	gfx.PutPixel( 114 + x,107 + y,208,34,34 );
	gfx.PutPixel( 115 + x,107 + y,208,34,34 );
	gfx.PutPixel( 116 + x,107 + y,208,34,34 );
	gfx.PutPixel( 117 + x,107 + y,208,34,34 );
	gfx.PutPixel( 118 + x,107 + y,208,34,34 );
	gfx.PutPixel( 119 + x,107 + y,208,34,34 );
	gfx.PutPixel( 120 + x,107 + y,208,34,34 );
	gfx.PutPixel( 121 + x,107 + y,208,34,34 );
	gfx.PutPixel( 122 + x,107 + y,208,34,34 );
	gfx.PutPixel( 123 + x,107 + y,208,34,34 );
	gfx.PutPixel( 124 + x,107 + y,208,34,34 );
	gfx.PutPixel( 125 + x,107 + y,208,34,34 );
	gfx.PutPixel( 126 + x,107 + y,208,34,34 );
	gfx.PutPixel( 127 + x,107 + y,208,34,34 );
	gfx.PutPixel( 128 + x,107 + y,208,34,34 );
	gfx.PutPixel( 129 + x,107 + y,208,34,34 );
	gfx.PutPixel( 130 + x,107 + y,208,34,34 );
	gfx.PutPixel( 131 + x,107 + y,208,34,34 );
	gfx.PutPixel( 132 + x,107 + y,208,34,34 );
	gfx.PutPixel( 133 + x,107 + y,208,34,34 );
	gfx.PutPixel( 134 + x,107 + y,208,34,34 );
	gfx.PutPixel( 135 + x,107 + y,208,34,34 );
	gfx.PutPixel( 136 + x,107 + y,208,34,34 );
	gfx.PutPixel( 137 + x,107 + y,208,34,34 );
	gfx.PutPixel( 138 + x,107 + y,208,34,34 );
	gfx.PutPixel( 139 + x,107 + y,208,34,34 );
	gfx.PutPixel( 140 + x,107 + y,208,34,34 );
	gfx.PutPixel( 141 + x,107 + y,208,34,34 );
	gfx.PutPixel( 142 + x,107 + y,208,34,34 );
	gfx.PutPixel( 143 + x,107 + y,208,34,34 );
	gfx.PutPixel( 144 + x,107 + y,208,34,34 );
	gfx.PutPixel( 145 + x,107 + y,208,34,34 );
	gfx.PutPixel( 146 + x,107 + y,208,34,34 );
	gfx.PutPixel( 147 + x,107 + y,208,34,34 );
	gfx.PutPixel( 148 + x,107 + y,208,34,34 );
	gfx.PutPixel( 149 + x,107 + y,208,34,34 );
	gfx.PutPixel( 0 + x,108 + y,208,34,34 );
	gfx.PutPixel( 1 + x,108 + y,208,34,34 );
	gfx.PutPixel( 2 + x,108 + y,208,34,34 );
	gfx.PutPixel( 3 + x,108 + y,208,34,34 );
	gfx.PutPixel( 4 + x,108 + y,208,34,34 );
	gfx.PutPixel( 5 + x,108 + y,208,34,34 );
	gfx.PutPixel( 6 + x,108 + y,208,34,34 );
	gfx.PutPixel( 7 + x,108 + y,208,34,34 );
	gfx.PutPixel( 8 + x,108 + y,208,34,34 );
	gfx.PutPixel( 9 + x,108 + y,208,34,34 );
	gfx.PutPixel( 10 + x,108 + y,208,34,34 );
	gfx.PutPixel( 11 + x,108 + y,208,34,34 );
	gfx.PutPixel( 12 + x,108 + y,208,34,34 );
	gfx.PutPixel( 13 + x,108 + y,208,34,34 );
	gfx.PutPixel( 14 + x,108 + y,208,34,34 );
	gfx.PutPixel( 15 + x,108 + y,208,34,34 );
	gfx.PutPixel( 16 + x,108 + y,208,34,34 );
	gfx.PutPixel( 17 + x,108 + y,208,34,34 );
	gfx.PutPixel( 18 + x,108 + y,208,34,34 );
	gfx.PutPixel( 19 + x,108 + y,208,34,34 );
	gfx.PutPixel( 20 + x,108 + y,208,34,34 );
	gfx.PutPixel( 21 + x,108 + y,208,34,34 );
	gfx.PutPixel( 22 + x,108 + y,208,34,34 );
	gfx.PutPixel( 23 + x,108 + y,208,34,34 );
	gfx.PutPixel( 24 + x,108 + y,208,34,34 );
	gfx.PutPixel( 25 + x,108 + y,208,34,34 );
	gfx.PutPixel( 26 + x,108 + y,208,34,34 );
	gfx.PutPixel( 27 + x,108 + y,208,34,34 );
	gfx.PutPixel( 28 + x,108 + y,208,34,34 );
	gfx.PutPixel( 29 + x,108 + y,208,34,34 );
	gfx.PutPixel( 30 + x,108 + y,208,34,34 );
	gfx.PutPixel( 31 + x,108 + y,208,34,34 );
	gfx.PutPixel( 32 + x,108 + y,208,34,34 );
	gfx.PutPixel( 33 + x,108 + y,208,34,34 );
	gfx.PutPixel( 34 + x,108 + y,208,34,34 );
	gfx.PutPixel( 35 + x,108 + y,208,34,34 );
	gfx.PutPixel( 36 + x,108 + y,208,34,34 );
	gfx.PutPixel( 37 + x,108 + y,208,34,34 );
	gfx.PutPixel( 38 + x,108 + y,208,34,34 );
	gfx.PutPixel( 39 + x,108 + y,208,34,34 );
	gfx.PutPixel( 40 + x,108 + y,208,34,34 );
	gfx.PutPixel( 41 + x,108 + y,208,34,34 );
	gfx.PutPixel( 42 + x,108 + y,208,34,34 );
	gfx.PutPixel( 43 + x,108 + y,208,34,34 );
	gfx.PutPixel( 44 + x,108 + y,208,34,34 );
	gfx.PutPixel( 45 + x,108 + y,208,34,34 );
	gfx.PutPixel( 46 + x,108 + y,208,34,34 );
	gfx.PutPixel( 47 + x,108 + y,208,34,34 );
	gfx.PutPixel( 48 + x,108 + y,208,34,34 );
	gfx.PutPixel( 49 + x,108 + y,208,34,34 );
	gfx.PutPixel( 50 + x,108 + y,208,34,34 );
	gfx.PutPixel( 51 + x,108 + y,208,34,34 );
	gfx.PutPixel( 52 + x,108 + y,208,34,34 );
	gfx.PutPixel( 53 + x,108 + y,208,34,34 );
	gfx.PutPixel( 54 + x,108 + y,208,34,34 );
	gfx.PutPixel( 55 + x,108 + y,208,34,34 );
	gfx.PutPixel( 56 + x,108 + y,208,34,34 );
	gfx.PutPixel( 57 + x,108 + y,208,34,34 );
	gfx.PutPixel( 58 + x,108 + y,208,34,34 );
	gfx.PutPixel( 59 + x,108 + y,208,34,34 );
	gfx.PutPixel( 60 + x,108 + y,208,34,34 );
	gfx.PutPixel( 61 + x,108 + y,208,34,34 );
	gfx.PutPixel( 62 + x,108 + y,207,24,24 );
	gfx.PutPixel( 63 + x,108 + y,207,22,22 );
	gfx.PutPixel( 64 + x,108 + y,208,33,33 );
	gfx.PutPixel( 65 + x,108 + y,208,34,34 );
	gfx.PutPixel( 66 + x,108 + y,208,34,34 );
	gfx.PutPixel( 67 + x,108 + y,208,34,34 );
	gfx.PutPixel( 68 + x,108 + y,207,23,23 );
	gfx.PutPixel( 69 + x,108 + y,207,23,23 );
	gfx.PutPixel( 70 + x,108 + y,208,32,32 );
	gfx.PutPixel( 71 + x,108 + y,207,22,22 );
	gfx.PutPixel( 72 + x,108 + y,207,25,25 );
	gfx.PutPixel( 73 + x,108 + y,208,34,34 );
	gfx.PutPixel( 74 + x,108 + y,208,34,34 );
	gfx.PutPixel( 75 + x,108 + y,208,33,33 );
	gfx.PutPixel( 76 + x,108 + y,207,23,23 );
	gfx.PutPixel( 77 + x,108 + y,207,21,21 );
	gfx.PutPixel( 78 + x,108 + y,208,28,28 );
	gfx.PutPixel( 79 + x,108 + y,208,34,34 );
	gfx.PutPixel( 80 + x,108 + y,207,23,23 );
	gfx.PutPixel( 81 + x,108 + y,207,22,22 );
	gfx.PutPixel( 82 + x,108 + y,207,22,22 );
	gfx.PutPixel( 83 + x,108 + y,207,23,23 );
	gfx.PutPixel( 84 + x,108 + y,208,27,27 );
	gfx.PutPixel( 85 + x,108 + y,208,33,33 );
	gfx.PutPixel( 86 + x,108 + y,208,34,34 );
	gfx.PutPixel( 87 + x,108 + y,208,34,34 );
	gfx.PutPixel( 88 + x,108 + y,208,34,34 );
	gfx.PutPixel( 89 + x,108 + y,208,34,34 );
	gfx.PutPixel( 90 + x,108 + y,208,34,34 );
	gfx.PutPixel( 91 + x,108 + y,208,34,34 );
	gfx.PutPixel( 92 + x,108 + y,208,34,34 );
	gfx.PutPixel( 93 + x,108 + y,208,34,34 );
	gfx.PutPixel( 94 + x,108 + y,208,34,34 );
	gfx.PutPixel( 95 + x,108 + y,208,34,34 );
	gfx.PutPixel( 96 + x,108 + y,208,34,34 );
	gfx.PutPixel( 97 + x,108 + y,208,34,34 );
	gfx.PutPixel( 98 + x,108 + y,208,34,34 );
	gfx.PutPixel( 99 + x,108 + y,208,34,34 );
	gfx.PutPixel( 100 + x,108 + y,208,34,34 );
	gfx.PutPixel( 101 + x,108 + y,208,34,34 );
	gfx.PutPixel( 102 + x,108 + y,208,34,34 );
	gfx.PutPixel( 103 + x,108 + y,208,34,34 );
	gfx.PutPixel( 104 + x,108 + y,208,34,34 );
	gfx.PutPixel( 105 + x,108 + y,208,34,34 );
	gfx.PutPixel( 106 + x,108 + y,208,34,34 );
	gfx.PutPixel( 107 + x,108 + y,208,34,34 );
	gfx.PutPixel( 108 + x,108 + y,208,34,34 );
	gfx.PutPixel( 109 + x,108 + y,208,34,34 );
	gfx.PutPixel( 110 + x,108 + y,208,34,34 );
	gfx.PutPixel( 111 + x,108 + y,208,34,34 );
	gfx.PutPixel( 112 + x,108 + y,208,34,34 );
	gfx.PutPixel( 113 + x,108 + y,208,34,34 );
	gfx.PutPixel( 114 + x,108 + y,208,34,34 );
	gfx.PutPixel( 115 + x,108 + y,208,34,34 );
	gfx.PutPixel( 116 + x,108 + y,208,34,34 );
	gfx.PutPixel( 117 + x,108 + y,208,34,34 );
	gfx.PutPixel( 118 + x,108 + y,208,34,34 );
	gfx.PutPixel( 119 + x,108 + y,208,34,34 );
	gfx.PutPixel( 120 + x,108 + y,208,34,34 );
	gfx.PutPixel( 121 + x,108 + y,208,34,34 );
	gfx.PutPixel( 122 + x,108 + y,208,34,34 );
	gfx.PutPixel( 123 + x,108 + y,208,34,34 );
	gfx.PutPixel( 124 + x,108 + y,208,34,34 );
	gfx.PutPixel( 125 + x,108 + y,208,34,34 );
	gfx.PutPixel( 126 + x,108 + y,208,34,34 );
	gfx.PutPixel( 127 + x,108 + y,208,34,34 );
	gfx.PutPixel( 128 + x,108 + y,208,34,34 );
	gfx.PutPixel( 129 + x,108 + y,208,34,34 );
	gfx.PutPixel( 130 + x,108 + y,208,34,34 );
	gfx.PutPixel( 131 + x,108 + y,208,34,34 );
	gfx.PutPixel( 132 + x,108 + y,208,34,34 );
	gfx.PutPixel( 133 + x,108 + y,208,34,34 );
	gfx.PutPixel( 134 + x,108 + y,208,34,34 );
	gfx.PutPixel( 135 + x,108 + y,208,34,34 );
	gfx.PutPixel( 136 + x,108 + y,208,34,34 );
	gfx.PutPixel( 137 + x,108 + y,208,34,34 );
	gfx.PutPixel( 138 + x,108 + y,208,34,34 );
	gfx.PutPixel( 139 + x,108 + y,208,34,34 );
	gfx.PutPixel( 140 + x,108 + y,208,34,34 );
	gfx.PutPixel( 141 + x,108 + y,208,34,34 );
	gfx.PutPixel( 142 + x,108 + y,208,34,34 );
	gfx.PutPixel( 143 + x,108 + y,208,34,34 );
	gfx.PutPixel( 144 + x,108 + y,208,34,34 );
	gfx.PutPixel( 145 + x,108 + y,208,34,34 );
	gfx.PutPixel( 146 + x,108 + y,208,34,34 );
	gfx.PutPixel( 147 + x,108 + y,208,34,34 );
	gfx.PutPixel( 148 + x,108 + y,208,34,34 );
	gfx.PutPixel( 149 + x,108 + y,208,34,34 );
	gfx.PutPixel( 0 + x,109 + y,208,34,34 );
	gfx.PutPixel( 1 + x,109 + y,208,34,34 );
	gfx.PutPixel( 2 + x,109 + y,208,34,34 );
	gfx.PutPixel( 3 + x,109 + y,208,34,34 );
	gfx.PutPixel( 4 + x,109 + y,208,34,34 );
	gfx.PutPixel( 5 + x,109 + y,208,34,34 );
	gfx.PutPixel( 6 + x,109 + y,208,34,34 );
	gfx.PutPixel( 7 + x,109 + y,208,34,34 );
	gfx.PutPixel( 8 + x,109 + y,208,34,34 );
	gfx.PutPixel( 9 + x,109 + y,208,34,34 );
	gfx.PutPixel( 10 + x,109 + y,208,34,34 );
	gfx.PutPixel( 11 + x,109 + y,208,34,34 );
	gfx.PutPixel( 12 + x,109 + y,208,34,34 );
	gfx.PutPixel( 13 + x,109 + y,208,34,34 );
	gfx.PutPixel( 14 + x,109 + y,208,34,34 );
	gfx.PutPixel( 15 + x,109 + y,208,34,34 );
	gfx.PutPixel( 16 + x,109 + y,208,34,34 );
	gfx.PutPixel( 17 + x,109 + y,208,34,34 );
	gfx.PutPixel( 18 + x,109 + y,208,34,34 );
	gfx.PutPixel( 19 + x,109 + y,208,34,34 );
	gfx.PutPixel( 20 + x,109 + y,208,34,34 );
	gfx.PutPixel( 21 + x,109 + y,208,34,34 );
	gfx.PutPixel( 22 + x,109 + y,208,34,34 );
	gfx.PutPixel( 23 + x,109 + y,208,34,34 );
	gfx.PutPixel( 24 + x,109 + y,208,34,34 );
	gfx.PutPixel( 25 + x,109 + y,208,34,34 );
	gfx.PutPixel( 26 + x,109 + y,208,34,34 );
	gfx.PutPixel( 27 + x,109 + y,208,34,34 );
	gfx.PutPixel( 28 + x,109 + y,208,34,34 );
	gfx.PutPixel( 29 + x,109 + y,208,34,34 );
	gfx.PutPixel( 30 + x,109 + y,208,34,34 );
	gfx.PutPixel( 31 + x,109 + y,208,34,34 );
	gfx.PutPixel( 32 + x,109 + y,208,34,34 );
	gfx.PutPixel( 33 + x,109 + y,208,34,34 );
	gfx.PutPixel( 34 + x,109 + y,208,34,34 );
	gfx.PutPixel( 35 + x,109 + y,208,34,34 );
	gfx.PutPixel( 36 + x,109 + y,208,34,34 );
	gfx.PutPixel( 37 + x,109 + y,208,34,34 );
	gfx.PutPixel( 38 + x,109 + y,208,34,34 );
	gfx.PutPixel( 39 + x,109 + y,208,34,34 );
	gfx.PutPixel( 40 + x,109 + y,208,34,34 );
	gfx.PutPixel( 41 + x,109 + y,208,34,34 );
	gfx.PutPixel( 42 + x,109 + y,208,34,34 );
	gfx.PutPixel( 43 + x,109 + y,208,34,34 );
	gfx.PutPixel( 44 + x,109 + y,208,34,34 );
	gfx.PutPixel( 45 + x,109 + y,208,34,34 );
	gfx.PutPixel( 46 + x,109 + y,208,34,34 );
	gfx.PutPixel( 47 + x,109 + y,208,34,34 );
	gfx.PutPixel( 48 + x,109 + y,208,34,34 );
	gfx.PutPixel( 49 + x,109 + y,208,34,34 );
	gfx.PutPixel( 50 + x,109 + y,208,34,34 );
	gfx.PutPixel( 51 + x,109 + y,208,34,34 );
	gfx.PutPixel( 52 + x,109 + y,208,34,34 );
	gfx.PutPixel( 53 + x,109 + y,208,34,34 );
	gfx.PutPixel( 54 + x,109 + y,208,34,34 );
	gfx.PutPixel( 55 + x,109 + y,208,34,34 );
	gfx.PutPixel( 56 + x,109 + y,208,34,34 );
	gfx.PutPixel( 57 + x,109 + y,208,34,34 );
	gfx.PutPixel( 58 + x,109 + y,208,34,34 );
	gfx.PutPixel( 59 + x,109 + y,208,34,34 );
	gfx.PutPixel( 60 + x,109 + y,208,34,34 );
	gfx.PutPixel( 61 + x,109 + y,208,34,34 );
	gfx.PutPixel( 62 + x,109 + y,208,34,34 );
	gfx.PutPixel( 63 + x,109 + y,208,34,34 );
	gfx.PutPixel( 64 + x,109 + y,208,34,34 );
	gfx.PutPixel( 65 + x,109 + y,208,34,34 );
	gfx.PutPixel( 66 + x,109 + y,208,34,34 );
	gfx.PutPixel( 67 + x,109 + y,208,34,34 );
	gfx.PutPixel( 68 + x,109 + y,208,34,34 );
	gfx.PutPixel( 69 + x,109 + y,208,34,34 );
	gfx.PutPixel( 70 + x,109 + y,208,34,34 );
	gfx.PutPixel( 71 + x,109 + y,208,34,34 );
	gfx.PutPixel( 72 + x,109 + y,208,34,34 );
	gfx.PutPixel( 73 + x,109 + y,208,34,34 );
	gfx.PutPixel( 74 + x,109 + y,208,34,34 );
	gfx.PutPixel( 75 + x,109 + y,208,34,34 );
	gfx.PutPixel( 76 + x,109 + y,208,34,34 );
	gfx.PutPixel( 77 + x,109 + y,208,34,34 );
	gfx.PutPixel( 78 + x,109 + y,208,34,34 );
	gfx.PutPixel( 79 + x,109 + y,208,34,34 );
	gfx.PutPixel( 80 + x,109 + y,208,34,34 );
	gfx.PutPixel( 81 + x,109 + y,208,34,34 );
	gfx.PutPixel( 82 + x,109 + y,208,34,34 );
	gfx.PutPixel( 83 + x,109 + y,208,34,34 );
	gfx.PutPixel( 84 + x,109 + y,208,34,34 );
	gfx.PutPixel( 85 + x,109 + y,208,34,34 );
	gfx.PutPixel( 86 + x,109 + y,208,34,34 );
	gfx.PutPixel( 87 + x,109 + y,208,34,34 );
	gfx.PutPixel( 88 + x,109 + y,208,34,34 );
	gfx.PutPixel( 89 + x,109 + y,208,34,34 );
	gfx.PutPixel( 90 + x,109 + y,208,34,34 );
	gfx.PutPixel( 91 + x,109 + y,208,34,34 );
	gfx.PutPixel( 92 + x,109 + y,208,34,34 );
	gfx.PutPixel( 93 + x,109 + y,208,34,34 );
	gfx.PutPixel( 94 + x,109 + y,208,34,34 );
	gfx.PutPixel( 95 + x,109 + y,208,34,34 );
	gfx.PutPixel( 96 + x,109 + y,208,34,34 );
	gfx.PutPixel( 97 + x,109 + y,208,34,34 );
	gfx.PutPixel( 98 + x,109 + y,208,34,34 );
	gfx.PutPixel( 99 + x,109 + y,208,34,34 );
	gfx.PutPixel( 100 + x,109 + y,208,34,34 );
	gfx.PutPixel( 101 + x,109 + y,208,34,34 );
	gfx.PutPixel( 102 + x,109 + y,208,34,34 );
	gfx.PutPixel( 103 + x,109 + y,208,34,34 );
	gfx.PutPixel( 104 + x,109 + y,208,34,34 );
	gfx.PutPixel( 105 + x,109 + y,208,34,34 );
	gfx.PutPixel( 106 + x,109 + y,208,34,34 );
	gfx.PutPixel( 107 + x,109 + y,208,34,34 );
	gfx.PutPixel( 108 + x,109 + y,208,34,34 );
	gfx.PutPixel( 109 + x,109 + y,208,34,34 );
	gfx.PutPixel( 110 + x,109 + y,208,34,34 );
	gfx.PutPixel( 111 + x,109 + y,208,34,34 );
	gfx.PutPixel( 112 + x,109 + y,208,34,34 );
	gfx.PutPixel( 113 + x,109 + y,208,34,34 );
	gfx.PutPixel( 114 + x,109 + y,208,34,34 );
	gfx.PutPixel( 115 + x,109 + y,208,34,34 );
	gfx.PutPixel( 116 + x,109 + y,208,34,34 );
	gfx.PutPixel( 117 + x,109 + y,208,34,34 );
	gfx.PutPixel( 118 + x,109 + y,208,34,34 );
	gfx.PutPixel( 119 + x,109 + y,208,34,34 );
	gfx.PutPixel( 120 + x,109 + y,208,34,34 );
	gfx.PutPixel( 121 + x,109 + y,208,34,34 );
	gfx.PutPixel( 122 + x,109 + y,208,34,34 );
	gfx.PutPixel( 123 + x,109 + y,208,34,34 );
	gfx.PutPixel( 124 + x,109 + y,208,34,34 );
	gfx.PutPixel( 125 + x,109 + y,208,34,34 );
	gfx.PutPixel( 126 + x,109 + y,208,34,34 );
	gfx.PutPixel( 127 + x,109 + y,208,34,34 );
	gfx.PutPixel( 128 + x,109 + y,208,34,34 );
	gfx.PutPixel( 129 + x,109 + y,208,34,34 );
	gfx.PutPixel( 130 + x,109 + y,208,34,34 );
	gfx.PutPixel( 131 + x,109 + y,208,34,34 );
	gfx.PutPixel( 132 + x,109 + y,208,34,34 );
	gfx.PutPixel( 133 + x,109 + y,208,34,34 );
	gfx.PutPixel( 134 + x,109 + y,208,34,34 );
	gfx.PutPixel( 135 + x,109 + y,208,34,34 );
	gfx.PutPixel( 136 + x,109 + y,208,34,34 );
	gfx.PutPixel( 137 + x,109 + y,208,34,34 );
	gfx.PutPixel( 138 + x,109 + y,208,34,34 );
	gfx.PutPixel( 139 + x,109 + y,208,34,34 );
	gfx.PutPixel( 140 + x,109 + y,208,34,34 );
	gfx.PutPixel( 141 + x,109 + y,208,34,34 );
	gfx.PutPixel( 142 + x,109 + y,208,34,34 );
	gfx.PutPixel( 143 + x,109 + y,208,34,34 );
	gfx.PutPixel( 144 + x,109 + y,208,34,34 );
	gfx.PutPixel( 145 + x,109 + y,208,34,34 );
	gfx.PutPixel( 146 + x,109 + y,208,34,34 );
	gfx.PutPixel( 147 + x,109 + y,208,34,34 );
	gfx.PutPixel( 148 + x,109 + y,208,34,34 );
	gfx.PutPixel( 149 + x,109 + y,208,34,34 );
	gfx.PutPixel( 0 + x,110 + y,208,34,34 );
	gfx.PutPixel( 1 + x,110 + y,208,34,34 );
	gfx.PutPixel( 2 + x,110 + y,208,34,34 );
	gfx.PutPixel( 3 + x,110 + y,208,34,34 );
	gfx.PutPixel( 4 + x,110 + y,208,34,34 );
	gfx.PutPixel( 5 + x,110 + y,208,34,34 );
	gfx.PutPixel( 6 + x,110 + y,208,34,34 );
	gfx.PutPixel( 7 + x,110 + y,208,34,34 );
	gfx.PutPixel( 8 + x,110 + y,208,34,34 );
	gfx.PutPixel( 9 + x,110 + y,208,34,34 );
	gfx.PutPixel( 10 + x,110 + y,208,34,34 );
	gfx.PutPixel( 11 + x,110 + y,208,34,34 );
	gfx.PutPixel( 12 + x,110 + y,208,34,34 );
	gfx.PutPixel( 13 + x,110 + y,208,34,34 );
	gfx.PutPixel( 14 + x,110 + y,208,34,34 );
	gfx.PutPixel( 15 + x,110 + y,208,34,34 );
	gfx.PutPixel( 16 + x,110 + y,208,34,34 );
	gfx.PutPixel( 17 + x,110 + y,208,34,34 );
	gfx.PutPixel( 18 + x,110 + y,208,34,34 );
	gfx.PutPixel( 19 + x,110 + y,208,34,34 );
	gfx.PutPixel( 20 + x,110 + y,208,34,34 );
	gfx.PutPixel( 21 + x,110 + y,208,34,34 );
	gfx.PutPixel( 22 + x,110 + y,208,34,34 );
	gfx.PutPixel( 23 + x,110 + y,208,34,34 );
	gfx.PutPixel( 24 + x,110 + y,208,34,34 );
	gfx.PutPixel( 25 + x,110 + y,208,34,34 );
	gfx.PutPixel( 26 + x,110 + y,208,34,34 );
	gfx.PutPixel( 27 + x,110 + y,208,34,34 );
	gfx.PutPixel( 28 + x,110 + y,208,34,34 );
	gfx.PutPixel( 29 + x,110 + y,208,34,34 );
	gfx.PutPixel( 30 + x,110 + y,208,34,34 );
	gfx.PutPixel( 31 + x,110 + y,208,34,34 );
	gfx.PutPixel( 32 + x,110 + y,208,34,34 );
	gfx.PutPixel( 33 + x,110 + y,208,34,34 );
	gfx.PutPixel( 34 + x,110 + y,208,34,34 );
	gfx.PutPixel( 35 + x,110 + y,208,34,34 );
	gfx.PutPixel( 36 + x,110 + y,208,34,34 );
	gfx.PutPixel( 37 + x,110 + y,208,34,34 );
	gfx.PutPixel( 38 + x,110 + y,208,34,34 );
	gfx.PutPixel( 39 + x,110 + y,208,34,34 );
	gfx.PutPixel( 40 + x,110 + y,208,34,34 );
	gfx.PutPixel( 41 + x,110 + y,208,34,34 );
	gfx.PutPixel( 42 + x,110 + y,208,34,34 );
	gfx.PutPixel( 43 + x,110 + y,208,34,34 );
	gfx.PutPixel( 44 + x,110 + y,208,34,34 );
	gfx.PutPixel( 45 + x,110 + y,208,34,34 );
	gfx.PutPixel( 46 + x,110 + y,208,34,34 );
	gfx.PutPixel( 47 + x,110 + y,208,34,34 );
	gfx.PutPixel( 48 + x,110 + y,208,34,34 );
	gfx.PutPixel( 49 + x,110 + y,208,34,34 );
	gfx.PutPixel( 50 + x,110 + y,208,34,34 );
	gfx.PutPixel( 51 + x,110 + y,208,34,34 );
	gfx.PutPixel( 52 + x,110 + y,208,34,34 );
	gfx.PutPixel( 53 + x,110 + y,208,34,34 );
	gfx.PutPixel( 54 + x,110 + y,208,34,34 );
	gfx.PutPixel( 55 + x,110 + y,208,34,34 );
	gfx.PutPixel( 56 + x,110 + y,208,34,34 );
	gfx.PutPixel( 57 + x,110 + y,208,34,34 );
	gfx.PutPixel( 58 + x,110 + y,208,34,34 );
	gfx.PutPixel( 59 + x,110 + y,208,34,34 );
	gfx.PutPixel( 60 + x,110 + y,208,34,34 );
	gfx.PutPixel( 61 + x,110 + y,208,34,34 );
	gfx.PutPixel( 62 + x,110 + y,208,34,34 );
	gfx.PutPixel( 63 + x,110 + y,208,34,34 );
	gfx.PutPixel( 64 + x,110 + y,208,34,34 );
	gfx.PutPixel( 65 + x,110 + y,208,34,34 );
	gfx.PutPixel( 66 + x,110 + y,208,34,34 );
	gfx.PutPixel( 67 + x,110 + y,208,34,34 );
	gfx.PutPixel( 68 + x,110 + y,208,34,34 );
	gfx.PutPixel( 69 + x,110 + y,208,34,34 );
	gfx.PutPixel( 70 + x,110 + y,208,34,34 );
	gfx.PutPixel( 71 + x,110 + y,208,34,34 );
	gfx.PutPixel( 72 + x,110 + y,208,34,34 );
	gfx.PutPixel( 73 + x,110 + y,208,34,34 );
	gfx.PutPixel( 74 + x,110 + y,208,34,34 );
	gfx.PutPixel( 75 + x,110 + y,208,34,34 );
	gfx.PutPixel( 76 + x,110 + y,208,34,34 );
	gfx.PutPixel( 77 + x,110 + y,208,34,34 );
	gfx.PutPixel( 78 + x,110 + y,208,34,34 );
	gfx.PutPixel( 79 + x,110 + y,208,34,34 );
	gfx.PutPixel( 80 + x,110 + y,208,34,34 );
	gfx.PutPixel( 81 + x,110 + y,208,34,34 );
	gfx.PutPixel( 82 + x,110 + y,208,34,34 );
	gfx.PutPixel( 83 + x,110 + y,208,34,34 );
	gfx.PutPixel( 84 + x,110 + y,208,34,34 );
	gfx.PutPixel( 85 + x,110 + y,208,34,34 );
	gfx.PutPixel( 86 + x,110 + y,208,34,34 );
	gfx.PutPixel( 87 + x,110 + y,208,34,34 );
	gfx.PutPixel( 88 + x,110 + y,208,34,34 );
	gfx.PutPixel( 89 + x,110 + y,208,34,34 );
	gfx.PutPixel( 90 + x,110 + y,208,34,34 );
	gfx.PutPixel( 91 + x,110 + y,208,34,34 );
	gfx.PutPixel( 92 + x,110 + y,208,34,34 );
	gfx.PutPixel( 93 + x,110 + y,208,34,34 );
	gfx.PutPixel( 94 + x,110 + y,208,34,34 );
	gfx.PutPixel( 95 + x,110 + y,208,34,34 );
	gfx.PutPixel( 96 + x,110 + y,208,34,34 );
	gfx.PutPixel( 97 + x,110 + y,208,34,34 );
	gfx.PutPixel( 98 + x,110 + y,208,34,34 );
	gfx.PutPixel( 99 + x,110 + y,208,34,34 );
	gfx.PutPixel( 100 + x,110 + y,208,34,34 );
	gfx.PutPixel( 101 + x,110 + y,208,34,34 );
	gfx.PutPixel( 102 + x,110 + y,208,34,34 );
	gfx.PutPixel( 103 + x,110 + y,208,34,34 );
	gfx.PutPixel( 104 + x,110 + y,208,34,34 );
	gfx.PutPixel( 105 + x,110 + y,208,34,34 );
	gfx.PutPixel( 106 + x,110 + y,208,34,34 );
	gfx.PutPixel( 107 + x,110 + y,208,34,34 );
	gfx.PutPixel( 108 + x,110 + y,208,34,34 );
	gfx.PutPixel( 109 + x,110 + y,208,34,34 );
	gfx.PutPixel( 110 + x,110 + y,208,34,34 );
	gfx.PutPixel( 111 + x,110 + y,208,34,34 );
	gfx.PutPixel( 112 + x,110 + y,208,34,34 );
	gfx.PutPixel( 113 + x,110 + y,208,34,34 );
	gfx.PutPixel( 114 + x,110 + y,208,34,34 );
	gfx.PutPixel( 115 + x,110 + y,208,34,34 );
	gfx.PutPixel( 116 + x,110 + y,208,34,34 );
	gfx.PutPixel( 117 + x,110 + y,208,34,34 );
	gfx.PutPixel( 118 + x,110 + y,208,34,34 );
	gfx.PutPixel( 119 + x,110 + y,208,34,34 );
	gfx.PutPixel( 120 + x,110 + y,208,34,34 );
	gfx.PutPixel( 121 + x,110 + y,208,34,34 );
	gfx.PutPixel( 122 + x,110 + y,208,34,34 );
	gfx.PutPixel( 123 + x,110 + y,208,34,34 );
	gfx.PutPixel( 124 + x,110 + y,208,34,34 );
	gfx.PutPixel( 125 + x,110 + y,208,34,34 );
	gfx.PutPixel( 126 + x,110 + y,208,34,34 );
	gfx.PutPixel( 127 + x,110 + y,208,34,34 );
	gfx.PutPixel( 128 + x,110 + y,208,34,34 );
	gfx.PutPixel( 129 + x,110 + y,208,34,34 );
	gfx.PutPixel( 130 + x,110 + y,208,34,34 );
	gfx.PutPixel( 131 + x,110 + y,208,34,34 );
	gfx.PutPixel( 132 + x,110 + y,208,34,34 );
	gfx.PutPixel( 133 + x,110 + y,208,34,34 );
	gfx.PutPixel( 134 + x,110 + y,208,34,34 );
	gfx.PutPixel( 135 + x,110 + y,208,34,34 );
	gfx.PutPixel( 136 + x,110 + y,208,34,34 );
	gfx.PutPixel( 137 + x,110 + y,208,34,34 );
	gfx.PutPixel( 138 + x,110 + y,208,34,34 );
	gfx.PutPixel( 139 + x,110 + y,208,34,34 );
	gfx.PutPixel( 140 + x,110 + y,208,34,34 );
	gfx.PutPixel( 141 + x,110 + y,208,34,34 );
	gfx.PutPixel( 142 + x,110 + y,208,34,34 );
	gfx.PutPixel( 143 + x,110 + y,208,34,34 );
	gfx.PutPixel( 144 + x,110 + y,208,34,34 );
	gfx.PutPixel( 145 + x,110 + y,208,34,34 );
	gfx.PutPixel( 146 + x,110 + y,208,34,34 );
	gfx.PutPixel( 147 + x,110 + y,208,34,34 );
	gfx.PutPixel( 148 + x,110 + y,208,34,34 );
	gfx.PutPixel( 149 + x,110 + y,208,34,34 );
	gfx.PutPixel( 0 + x,111 + y,208,34,34 );
	gfx.PutPixel( 1 + x,111 + y,208,34,34 );
	gfx.PutPixel( 2 + x,111 + y,208,34,34 );
	gfx.PutPixel( 3 + x,111 + y,208,34,34 );
	gfx.PutPixel( 4 + x,111 + y,208,34,34 );
	gfx.PutPixel( 5 + x,111 + y,208,34,34 );
	gfx.PutPixel( 6 + x,111 + y,208,34,34 );
	gfx.PutPixel( 7 + x,111 + y,208,34,34 );
	gfx.PutPixel( 8 + x,111 + y,208,34,34 );
	gfx.PutPixel( 9 + x,111 + y,208,34,34 );
	gfx.PutPixel( 10 + x,111 + y,208,34,34 );
	gfx.PutPixel( 11 + x,111 + y,208,34,34 );
	gfx.PutPixel( 12 + x,111 + y,208,34,34 );
	gfx.PutPixel( 13 + x,111 + y,208,34,34 );
	gfx.PutPixel( 14 + x,111 + y,208,34,34 );
	gfx.PutPixel( 15 + x,111 + y,208,34,34 );
	gfx.PutPixel( 16 + x,111 + y,208,34,34 );
	gfx.PutPixel( 17 + x,111 + y,208,34,34 );
	gfx.PutPixel( 18 + x,111 + y,208,34,34 );
	gfx.PutPixel( 19 + x,111 + y,208,34,34 );
	gfx.PutPixel( 20 + x,111 + y,208,34,34 );
	gfx.PutPixel( 21 + x,111 + y,208,34,34 );
	gfx.PutPixel( 22 + x,111 + y,208,34,34 );
	gfx.PutPixel( 23 + x,111 + y,208,34,34 );
	gfx.PutPixel( 24 + x,111 + y,208,34,34 );
	gfx.PutPixel( 25 + x,111 + y,208,34,34 );
	gfx.PutPixel( 26 + x,111 + y,208,34,34 );
	gfx.PutPixel( 27 + x,111 + y,208,34,34 );
	gfx.PutPixel( 28 + x,111 + y,208,34,34 );
	gfx.PutPixel( 29 + x,111 + y,208,34,34 );
	gfx.PutPixel( 30 + x,111 + y,208,34,34 );
	gfx.PutPixel( 31 + x,111 + y,208,34,34 );
	gfx.PutPixel( 32 + x,111 + y,208,34,34 );
	gfx.PutPixel( 33 + x,111 + y,208,34,34 );
	gfx.PutPixel( 34 + x,111 + y,208,34,34 );
	gfx.PutPixel( 35 + x,111 + y,208,34,34 );
	gfx.PutPixel( 36 + x,111 + y,208,34,34 );
	gfx.PutPixel( 37 + x,111 + y,208,34,34 );
	gfx.PutPixel( 38 + x,111 + y,208,34,34 );
	gfx.PutPixel( 39 + x,111 + y,208,34,34 );
	gfx.PutPixel( 40 + x,111 + y,208,34,34 );
	gfx.PutPixel( 41 + x,111 + y,208,34,34 );
	gfx.PutPixel( 42 + x,111 + y,208,34,34 );
	gfx.PutPixel( 43 + x,111 + y,208,34,34 );
	gfx.PutPixel( 44 + x,111 + y,208,34,34 );
	gfx.PutPixel( 45 + x,111 + y,208,34,34 );
	gfx.PutPixel( 46 + x,111 + y,208,34,34 );
	gfx.PutPixel( 47 + x,111 + y,208,34,34 );
	gfx.PutPixel( 48 + x,111 + y,208,34,34 );
	gfx.PutPixel( 49 + x,111 + y,208,34,34 );
	gfx.PutPixel( 50 + x,111 + y,208,34,34 );
	gfx.PutPixel( 51 + x,111 + y,208,34,34 );
	gfx.PutPixel( 52 + x,111 + y,208,34,34 );
	gfx.PutPixel( 53 + x,111 + y,208,34,34 );
	gfx.PutPixel( 54 + x,111 + y,208,34,34 );
	gfx.PutPixel( 55 + x,111 + y,208,34,34 );
	gfx.PutPixel( 56 + x,111 + y,208,34,34 );
	gfx.PutPixel( 57 + x,111 + y,208,34,34 );
	gfx.PutPixel( 58 + x,111 + y,208,34,34 );
	gfx.PutPixel( 59 + x,111 + y,208,34,34 );
	gfx.PutPixel( 60 + x,111 + y,208,34,34 );
	gfx.PutPixel( 61 + x,111 + y,208,34,34 );
	gfx.PutPixel( 62 + x,111 + y,208,34,34 );
	gfx.PutPixel( 63 + x,111 + y,208,34,34 );
	gfx.PutPixel( 64 + x,111 + y,208,34,34 );
	gfx.PutPixel( 65 + x,111 + y,208,34,34 );
	gfx.PutPixel( 66 + x,111 + y,208,34,34 );
	gfx.PutPixel( 67 + x,111 + y,208,34,34 );
	gfx.PutPixel( 68 + x,111 + y,208,34,34 );
	gfx.PutPixel( 69 + x,111 + y,208,34,34 );
	gfx.PutPixel( 70 + x,111 + y,208,34,34 );
	gfx.PutPixel( 71 + x,111 + y,208,34,34 );
	gfx.PutPixel( 72 + x,111 + y,208,34,34 );
	gfx.PutPixel( 73 + x,111 + y,208,34,34 );
	gfx.PutPixel( 74 + x,111 + y,208,34,34 );
	gfx.PutPixel( 75 + x,111 + y,208,34,34 );
	gfx.PutPixel( 76 + x,111 + y,208,34,34 );
	gfx.PutPixel( 77 + x,111 + y,208,34,34 );
	gfx.PutPixel( 78 + x,111 + y,208,34,34 );
	gfx.PutPixel( 79 + x,111 + y,208,34,34 );
	gfx.PutPixel( 80 + x,111 + y,208,34,34 );
	gfx.PutPixel( 81 + x,111 + y,208,34,34 );
	gfx.PutPixel( 82 + x,111 + y,208,34,34 );
	gfx.PutPixel( 83 + x,111 + y,208,34,34 );
	gfx.PutPixel( 84 + x,111 + y,208,34,34 );
	gfx.PutPixel( 85 + x,111 + y,208,34,34 );
	gfx.PutPixel( 86 + x,111 + y,208,34,34 );
	gfx.PutPixel( 87 + x,111 + y,208,34,34 );
	gfx.PutPixel( 88 + x,111 + y,208,34,34 );
	gfx.PutPixel( 89 + x,111 + y,208,34,34 );
	gfx.PutPixel( 90 + x,111 + y,208,34,34 );
	gfx.PutPixel( 91 + x,111 + y,208,34,34 );
	gfx.PutPixel( 92 + x,111 + y,208,34,34 );
	gfx.PutPixel( 93 + x,111 + y,208,34,34 );
	gfx.PutPixel( 94 + x,111 + y,208,34,34 );
	gfx.PutPixel( 95 + x,111 + y,208,34,34 );
	gfx.PutPixel( 96 + x,111 + y,208,34,34 );
	gfx.PutPixel( 97 + x,111 + y,208,34,34 );
	gfx.PutPixel( 98 + x,111 + y,208,34,34 );
	gfx.PutPixel( 99 + x,111 + y,208,34,34 );
	gfx.PutPixel( 100 + x,111 + y,208,34,34 );
	gfx.PutPixel( 101 + x,111 + y,208,34,34 );
	gfx.PutPixel( 102 + x,111 + y,208,34,34 );
	gfx.PutPixel( 103 + x,111 + y,208,34,34 );
	gfx.PutPixel( 104 + x,111 + y,208,34,34 );
	gfx.PutPixel( 105 + x,111 + y,208,34,34 );
	gfx.PutPixel( 106 + x,111 + y,208,34,34 );
	gfx.PutPixel( 107 + x,111 + y,208,34,34 );
	gfx.PutPixel( 108 + x,111 + y,208,34,34 );
	gfx.PutPixel( 109 + x,111 + y,208,34,34 );
	gfx.PutPixel( 110 + x,111 + y,208,34,34 );
	gfx.PutPixel( 111 + x,111 + y,208,34,34 );
	gfx.PutPixel( 112 + x,111 + y,208,34,34 );
	gfx.PutPixel( 113 + x,111 + y,208,34,34 );
	gfx.PutPixel( 114 + x,111 + y,208,34,34 );
	gfx.PutPixel( 115 + x,111 + y,208,34,34 );
	gfx.PutPixel( 116 + x,111 + y,208,34,34 );
	gfx.PutPixel( 117 + x,111 + y,208,34,34 );
	gfx.PutPixel( 118 + x,111 + y,208,34,34 );
	gfx.PutPixel( 119 + x,111 + y,208,34,34 );
	gfx.PutPixel( 120 + x,111 + y,208,34,34 );
	gfx.PutPixel( 121 + x,111 + y,208,34,34 );
	gfx.PutPixel( 122 + x,111 + y,208,34,34 );
	gfx.PutPixel( 123 + x,111 + y,208,34,34 );
	gfx.PutPixel( 124 + x,111 + y,208,34,34 );
	gfx.PutPixel( 125 + x,111 + y,208,34,34 );
	gfx.PutPixel( 126 + x,111 + y,208,34,34 );
	gfx.PutPixel( 127 + x,111 + y,208,34,34 );
	gfx.PutPixel( 128 + x,111 + y,208,34,34 );
	gfx.PutPixel( 129 + x,111 + y,208,34,34 );
	gfx.PutPixel( 130 + x,111 + y,208,34,34 );
	gfx.PutPixel( 131 + x,111 + y,208,34,34 );
	gfx.PutPixel( 132 + x,111 + y,208,34,34 );
	gfx.PutPixel( 133 + x,111 + y,208,34,34 );
	gfx.PutPixel( 134 + x,111 + y,208,34,34 );
	gfx.PutPixel( 135 + x,111 + y,208,34,34 );
	gfx.PutPixel( 136 + x,111 + y,208,34,34 );
	gfx.PutPixel( 137 + x,111 + y,208,34,34 );
	gfx.PutPixel( 138 + x,111 + y,208,34,34 );
	gfx.PutPixel( 139 + x,111 + y,208,34,34 );
	gfx.PutPixel( 140 + x,111 + y,208,34,34 );
	gfx.PutPixel( 141 + x,111 + y,208,34,34 );
	gfx.PutPixel( 142 + x,111 + y,208,34,34 );
	gfx.PutPixel( 143 + x,111 + y,208,34,34 );
	gfx.PutPixel( 144 + x,111 + y,208,34,34 );
	gfx.PutPixel( 145 + x,111 + y,208,34,34 );
	gfx.PutPixel( 146 + x,111 + y,208,34,34 );
	gfx.PutPixel( 147 + x,111 + y,208,34,34 );
	gfx.PutPixel( 148 + x,111 + y,208,34,34 );
	gfx.PutPixel( 149 + x,111 + y,208,34,34 );
	gfx.PutPixel( 0 + x,112 + y,208,34,34 );
	gfx.PutPixel( 1 + x,112 + y,208,34,34 );
	gfx.PutPixel( 2 + x,112 + y,208,34,34 );
	gfx.PutPixel( 3 + x,112 + y,208,34,34 );
	gfx.PutPixel( 4 + x,112 + y,208,34,34 );
	gfx.PutPixel( 5 + x,112 + y,208,34,34 );
	gfx.PutPixel( 6 + x,112 + y,208,34,34 );
	gfx.PutPixel( 7 + x,112 + y,208,34,34 );
	gfx.PutPixel( 8 + x,112 + y,208,34,34 );
	gfx.PutPixel( 9 + x,112 + y,208,34,34 );
	gfx.PutPixel( 10 + x,112 + y,208,34,34 );
	gfx.PutPixel( 11 + x,112 + y,208,34,34 );
	gfx.PutPixel( 12 + x,112 + y,208,34,34 );
	gfx.PutPixel( 13 + x,112 + y,208,34,34 );
	gfx.PutPixel( 14 + x,112 + y,208,34,34 );
	gfx.PutPixel( 15 + x,112 + y,208,34,34 );
	gfx.PutPixel( 16 + x,112 + y,208,34,34 );
	gfx.PutPixel( 17 + x,112 + y,208,34,34 );
	gfx.PutPixel( 18 + x,112 + y,208,34,34 );
	gfx.PutPixel( 19 + x,112 + y,208,34,34 );
	gfx.PutPixel( 20 + x,112 + y,208,34,34 );
	gfx.PutPixel( 21 + x,112 + y,208,34,34 );
	gfx.PutPixel( 22 + x,112 + y,208,34,34 );
	gfx.PutPixel( 23 + x,112 + y,208,34,34 );
	gfx.PutPixel( 24 + x,112 + y,208,34,34 );
	gfx.PutPixel( 25 + x,112 + y,208,34,34 );
	gfx.PutPixel( 26 + x,112 + y,208,34,34 );
	gfx.PutPixel( 27 + x,112 + y,208,34,34 );
	gfx.PutPixel( 28 + x,112 + y,208,34,34 );
	gfx.PutPixel( 29 + x,112 + y,208,34,34 );
	gfx.PutPixel( 30 + x,112 + y,208,34,34 );
	gfx.PutPixel( 31 + x,112 + y,208,34,34 );
	gfx.PutPixel( 32 + x,112 + y,208,34,34 );
	gfx.PutPixel( 33 + x,112 + y,208,32,32 );
	gfx.PutPixel( 34 + x,112 + y,208,30,30 );
	gfx.PutPixel( 35 + x,112 + y,208,30,30 );
	gfx.PutPixel( 36 + x,112 + y,208,30,30 );
	gfx.PutPixel( 37 + x,112 + y,208,30,30 );
	gfx.PutPixel( 38 + x,112 + y,208,30,30 );
	gfx.PutPixel( 39 + x,112 + y,208,30,30 );
	gfx.PutPixel( 40 + x,112 + y,208,30,30 );
	gfx.PutPixel( 41 + x,112 + y,208,30,30 );
	gfx.PutPixel( 42 + x,112 + y,208,30,30 );
	gfx.PutPixel( 43 + x,112 + y,208,30,30 );
	gfx.PutPixel( 44 + x,112 + y,208,31,31 );
	gfx.PutPixel( 45 + x,112 + y,208,34,34 );
	gfx.PutPixel( 46 + x,112 + y,208,34,34 );
	gfx.PutPixel( 47 + x,112 + y,208,34,34 );
	gfx.PutPixel( 48 + x,112 + y,208,34,34 );
	gfx.PutPixel( 49 + x,112 + y,208,34,34 );
	gfx.PutPixel( 50 + x,112 + y,208,34,34 );
	gfx.PutPixel( 51 + x,112 + y,208,34,34 );
	gfx.PutPixel( 52 + x,112 + y,208,34,34 );
	gfx.PutPixel( 53 + x,112 + y,208,33,33 );
	gfx.PutPixel( 54 + x,112 + y,208,30,30 );
	gfx.PutPixel( 55 + x,112 + y,208,30,30 );
	gfx.PutPixel( 56 + x,112 + y,208,31,31 );
	gfx.PutPixel( 57 + x,112 + y,208,34,34 );
	gfx.PutPixel( 58 + x,112 + y,208,34,34 );
	gfx.PutPixel( 59 + x,112 + y,208,34,34 );
	gfx.PutPixel( 60 + x,112 + y,208,34,34 );
	gfx.PutPixel( 61 + x,112 + y,208,34,34 );
	gfx.PutPixel( 62 + x,112 + y,208,32,32 );
	gfx.PutPixel( 63 + x,112 + y,208,30,30 );
	gfx.PutPixel( 64 + x,112 + y,208,30,30 );
	gfx.PutPixel( 65 + x,112 + y,208,30,30 );
	gfx.PutPixel( 66 + x,112 + y,208,30,30 );
	gfx.PutPixel( 67 + x,112 + y,208,30,30 );
	gfx.PutPixel( 68 + x,112 + y,208,30,30 );
	gfx.PutPixel( 69 + x,112 + y,208,30,30 );
	gfx.PutPixel( 70 + x,112 + y,208,30,30 );
	gfx.PutPixel( 71 + x,112 + y,208,30,30 );
	gfx.PutPixel( 72 + x,112 + y,208,30,30 );
	gfx.PutPixel( 73 + x,112 + y,208,30,30 );
	gfx.PutPixel( 74 + x,112 + y,208,30,30 );
	gfx.PutPixel( 75 + x,112 + y,208,32,32 );
	gfx.PutPixel( 76 + x,112 + y,208,34,34 );
	gfx.PutPixel( 77 + x,112 + y,208,34,34 );
	gfx.PutPixel( 78 + x,112 + y,208,34,34 );
	gfx.PutPixel( 79 + x,112 + y,208,34,34 );
	gfx.PutPixel( 80 + x,112 + y,208,34,34 );
	gfx.PutPixel( 81 + x,112 + y,208,34,34 );
	gfx.PutPixel( 82 + x,112 + y,208,34,34 );
	gfx.PutPixel( 83 + x,112 + y,208,34,34 );
	gfx.PutPixel( 84 + x,112 + y,208,32,32 );
	gfx.PutPixel( 85 + x,112 + y,208,30,30 );
	gfx.PutPixel( 86 + x,112 + y,208,30,30 );
	gfx.PutPixel( 87 + x,112 + y,208,30,30 );
	gfx.PutPixel( 88 + x,112 + y,208,30,30 );
	gfx.PutPixel( 89 + x,112 + y,208,30,30 );
	gfx.PutPixel( 90 + x,112 + y,208,31,31 );
	gfx.PutPixel( 91 + x,112 + y,208,31,31 );
	gfx.PutPixel( 92 + x,112 + y,208,33,33 );
	gfx.PutPixel( 93 + x,112 + y,208,34,34 );
	gfx.PutPixel( 94 + x,112 + y,208,34,34 );
	gfx.PutPixel( 95 + x,112 + y,208,34,34 );
	gfx.PutPixel( 96 + x,112 + y,208,34,34 );
	gfx.PutPixel( 97 + x,112 + y,208,34,34 );
	gfx.PutPixel( 98 + x,112 + y,208,34,34 );
	gfx.PutPixel( 99 + x,112 + y,208,34,34 );
	gfx.PutPixel( 100 + x,112 + y,208,34,34 );
	gfx.PutPixel( 101 + x,112 + y,208,34,34 );
	gfx.PutPixel( 102 + x,112 + y,208,34,34 );
	gfx.PutPixel( 103 + x,112 + y,208,34,34 );
	gfx.PutPixel( 104 + x,112 + y,208,34,34 );
	gfx.PutPixel( 105 + x,112 + y,208,34,34 );
	gfx.PutPixel( 106 + x,112 + y,208,34,34 );
	gfx.PutPixel( 107 + x,112 + y,208,34,34 );
	gfx.PutPixel( 108 + x,112 + y,208,31,31 );
	gfx.PutPixel( 109 + x,112 + y,208,30,30 );
	gfx.PutPixel( 110 + x,112 + y,208,30,30 );
	gfx.PutPixel( 111 + x,112 + y,208,32,32 );
	gfx.PutPixel( 112 + x,112 + y,208,34,34 );
	gfx.PutPixel( 113 + x,112 + y,208,34,34 );
	gfx.PutPixel( 114 + x,112 + y,208,34,34 );
	gfx.PutPixel( 115 + x,112 + y,208,34,34 );
	gfx.PutPixel( 116 + x,112 + y,208,34,34 );
	gfx.PutPixel( 117 + x,112 + y,208,34,34 );
	gfx.PutPixel( 118 + x,112 + y,208,34,34 );
	gfx.PutPixel( 119 + x,112 + y,208,34,34 );
	gfx.PutPixel( 120 + x,112 + y,208,34,34 );
	gfx.PutPixel( 121 + x,112 + y,208,34,34 );
	gfx.PutPixel( 122 + x,112 + y,208,34,34 );
	gfx.PutPixel( 123 + x,112 + y,208,34,34 );
	gfx.PutPixel( 124 + x,112 + y,208,34,34 );
	gfx.PutPixel( 125 + x,112 + y,208,34,34 );
	gfx.PutPixel( 126 + x,112 + y,208,34,34 );
	gfx.PutPixel( 127 + x,112 + y,208,34,34 );
	gfx.PutPixel( 128 + x,112 + y,208,34,34 );
	gfx.PutPixel( 129 + x,112 + y,208,34,34 );
	gfx.PutPixel( 130 + x,112 + y,208,34,34 );
	gfx.PutPixel( 131 + x,112 + y,208,34,34 );
	gfx.PutPixel( 132 + x,112 + y,208,34,34 );
	gfx.PutPixel( 133 + x,112 + y,208,34,34 );
	gfx.PutPixel( 134 + x,112 + y,208,34,34 );
	gfx.PutPixel( 135 + x,112 + y,208,34,34 );
	gfx.PutPixel( 136 + x,112 + y,208,34,34 );
	gfx.PutPixel( 137 + x,112 + y,208,34,34 );
	gfx.PutPixel( 138 + x,112 + y,208,34,34 );
	gfx.PutPixel( 139 + x,112 + y,208,34,34 );
	gfx.PutPixel( 140 + x,112 + y,208,34,34 );
	gfx.PutPixel( 141 + x,112 + y,208,34,34 );
	gfx.PutPixel( 142 + x,112 + y,208,34,34 );
	gfx.PutPixel( 143 + x,112 + y,208,34,34 );
	gfx.PutPixel( 144 + x,112 + y,208,34,34 );
	gfx.PutPixel( 145 + x,112 + y,208,34,34 );
	gfx.PutPixel( 146 + x,112 + y,208,34,34 );
	gfx.PutPixel( 147 + x,112 + y,208,34,34 );
	gfx.PutPixel( 148 + x,112 + y,208,34,34 );
	gfx.PutPixel( 149 + x,112 + y,208,34,34 );
	gfx.PutPixel( 0 + x,113 + y,208,34,34 );
	gfx.PutPixel( 1 + x,113 + y,208,34,34 );
	gfx.PutPixel( 2 + x,113 + y,208,34,34 );
	gfx.PutPixel( 3 + x,113 + y,208,34,34 );
	gfx.PutPixel( 4 + x,113 + y,208,34,34 );
	gfx.PutPixel( 5 + x,113 + y,208,34,34 );
	gfx.PutPixel( 6 + x,113 + y,208,34,34 );
	gfx.PutPixel( 7 + x,113 + y,208,34,34 );
	gfx.PutPixel( 8 + x,113 + y,208,34,34 );
	gfx.PutPixel( 9 + x,113 + y,208,34,34 );
	gfx.PutPixel( 10 + x,113 + y,208,34,34 );
	gfx.PutPixel( 11 + x,113 + y,208,34,34 );
	gfx.PutPixel( 12 + x,113 + y,208,34,34 );
	gfx.PutPixel( 13 + x,113 + y,208,34,34 );
	gfx.PutPixel( 14 + x,113 + y,208,34,34 );
	gfx.PutPixel( 15 + x,113 + y,208,34,34 );
	gfx.PutPixel( 16 + x,113 + y,208,34,34 );
	gfx.PutPixel( 17 + x,113 + y,208,34,34 );
	gfx.PutPixel( 18 + x,113 + y,208,34,34 );
	gfx.PutPixel( 19 + x,113 + y,208,34,34 );
	gfx.PutPixel( 20 + x,113 + y,208,34,34 );
	gfx.PutPixel( 21 + x,113 + y,208,34,34 );
	gfx.PutPixel( 22 + x,113 + y,208,34,34 );
	gfx.PutPixel( 23 + x,113 + y,208,34,34 );
	gfx.PutPixel( 24 + x,113 + y,208,34,34 );
	gfx.PutPixel( 25 + x,113 + y,208,34,34 );
	gfx.PutPixel( 26 + x,113 + y,208,34,34 );
	gfx.PutPixel( 27 + x,113 + y,208,34,34 );
	gfx.PutPixel( 28 + x,113 + y,208,34,34 );
	gfx.PutPixel( 29 + x,113 + y,208,34,34 );
	gfx.PutPixel( 30 + x,113 + y,208,34,34 );
	gfx.PutPixel( 31 + x,113 + y,208,34,34 );
	gfx.PutPixel( 32 + x,113 + y,208,33,33 );
	gfx.PutPixel( 33 + x,113 + y,208,41,41 );
	gfx.PutPixel( 34 + x,113 + y,209,48,48 );
	gfx.PutPixel( 35 + x,113 + y,209,47,47 );
	gfx.PutPixel( 36 + x,113 + y,209,47,47 );
	gfx.PutPixel( 37 + x,113 + y,209,47,47 );
	gfx.PutPixel( 38 + x,113 + y,209,47,47 );
	gfx.PutPixel( 39 + x,113 + y,209,47,47 );
	gfx.PutPixel( 40 + x,113 + y,209,47,47 );
	gfx.PutPixel( 41 + x,113 + y,209,47,47 );
	gfx.PutPixel( 42 + x,113 + y,209,47,47 );
	gfx.PutPixel( 43 + x,113 + y,209,48,48 );
	gfx.PutPixel( 44 + x,113 + y,209,44,44 );
	gfx.PutPixel( 45 + x,113 + y,208,34,34 );
	gfx.PutPixel( 46 + x,113 + y,208,34,34 );
	gfx.PutPixel( 47 + x,113 + y,208,34,34 );
	gfx.PutPixel( 48 + x,113 + y,208,34,34 );
	gfx.PutPixel( 49 + x,113 + y,208,34,34 );
	gfx.PutPixel( 50 + x,113 + y,208,34,34 );
	gfx.PutPixel( 51 + x,113 + y,208,34,34 );
	gfx.PutPixel( 52 + x,113 + y,208,34,34 );
	gfx.PutPixel( 53 + x,113 + y,208,34,34 );
	gfx.PutPixel( 54 + x,113 + y,209,47,47 );
	gfx.PutPixel( 55 + x,113 + y,209,48,48 );
	gfx.PutPixel( 56 + x,113 + y,209,45,45 );
	gfx.PutPixel( 57 + x,113 + y,208,32,32 );
	gfx.PutPixel( 58 + x,113 + y,208,34,34 );
	gfx.PutPixel( 59 + x,113 + y,208,34,34 );
	gfx.PutPixel( 60 + x,113 + y,208,34,34 );
	gfx.PutPixel( 61 + x,113 + y,208,33,33 );
	gfx.PutPixel( 62 + x,113 + y,209,42,42 );
	gfx.PutPixel( 63 + x,113 + y,209,48,48 );
	gfx.PutPixel( 64 + x,113 + y,209,47,47 );
	gfx.PutPixel( 65 + x,113 + y,209,47,47 );
	gfx.PutPixel( 66 + x,113 + y,209,47,47 );
	gfx.PutPixel( 67 + x,113 + y,209,47,47 );
	gfx.PutPixel( 68 + x,113 + y,209,47,47 );
	gfx.PutPixel( 69 + x,113 + y,209,47,47 );
	gfx.PutPixel( 70 + x,113 + y,209,47,47 );
	gfx.PutPixel( 71 + x,113 + y,209,47,47 );
	gfx.PutPixel( 72 + x,113 + y,209,47,47 );
	gfx.PutPixel( 73 + x,113 + y,209,47,47 );
	gfx.PutPixel( 74 + x,113 + y,209,48,48 );
	gfx.PutPixel( 75 + x,113 + y,209,42,42 );
	gfx.PutPixel( 76 + x,113 + y,208,33,33 );
	gfx.PutPixel( 77 + x,113 + y,208,34,34 );
	gfx.PutPixel( 78 + x,113 + y,208,34,34 );
	gfx.PutPixel( 79 + x,113 + y,208,34,34 );
	gfx.PutPixel( 80 + x,113 + y,208,34,34 );
	gfx.PutPixel( 81 + x,113 + y,208,34,34 );
	gfx.PutPixel( 82 + x,113 + y,208,34,34 );
	gfx.PutPixel( 83 + x,113 + y,208,33,33 );
	gfx.PutPixel( 84 + x,113 + y,208,41,41 );
	gfx.PutPixel( 85 + x,113 + y,209,48,48 );
	gfx.PutPixel( 86 + x,113 + y,209,47,47 );
	gfx.PutPixel( 87 + x,113 + y,209,47,47 );
	gfx.PutPixel( 88 + x,113 + y,209,47,47 );
	gfx.PutPixel( 89 + x,113 + y,209,47,47 );
	gfx.PutPixel( 90 + x,113 + y,209,47,47 );
	gfx.PutPixel( 91 + x,113 + y,209,43,43 );
	gfx.PutPixel( 92 + x,113 + y,208,34,34 );
	gfx.PutPixel( 93 + x,113 + y,207,25,25 );
	gfx.PutPixel( 94 + x,113 + y,207,23,23 );
	gfx.PutPixel( 95 + x,113 + y,208,29,29 );
	gfx.PutPixel( 96 + x,113 + y,208,34,34 );
	gfx.PutPixel( 97 + x,113 + y,208,34,34 );
	gfx.PutPixel( 98 + x,113 + y,208,34,34 );
	gfx.PutPixel( 99 + x,113 + y,208,34,34 );
	gfx.PutPixel( 100 + x,113 + y,208,34,34 );
	gfx.PutPixel( 101 + x,113 + y,208,34,34 );
	gfx.PutPixel( 102 + x,113 + y,208,34,34 );
	gfx.PutPixel( 103 + x,113 + y,208,34,34 );
	gfx.PutPixel( 104 + x,113 + y,208,34,34 );
	gfx.PutPixel( 105 + x,113 + y,208,34,34 );
	gfx.PutPixel( 106 + x,113 + y,208,34,34 );
	gfx.PutPixel( 107 + x,113 + y,208,32,32 );
	gfx.PutPixel( 108 + x,113 + y,208,41,41 );
	gfx.PutPixel( 109 + x,113 + y,209,48,48 );
	gfx.PutPixel( 110 + x,113 + y,209,48,48 );
	gfx.PutPixel( 111 + x,113 + y,208,37,37 );
	gfx.PutPixel( 112 + x,113 + y,208,33,33 );
	gfx.PutPixel( 113 + x,113 + y,208,34,34 );
	gfx.PutPixel( 114 + x,113 + y,208,34,34 );
	gfx.PutPixel( 115 + x,113 + y,208,34,34 );
	gfx.PutPixel( 116 + x,113 + y,208,34,34 );
	gfx.PutPixel( 117 + x,113 + y,208,34,34 );
	gfx.PutPixel( 118 + x,113 + y,208,34,34 );
	gfx.PutPixel( 119 + x,113 + y,208,34,34 );
	gfx.PutPixel( 120 + x,113 + y,208,34,34 );
	gfx.PutPixel( 121 + x,113 + y,208,34,34 );
	gfx.PutPixel( 122 + x,113 + y,208,34,34 );
	gfx.PutPixel( 123 + x,113 + y,208,34,34 );
	gfx.PutPixel( 124 + x,113 + y,208,34,34 );
	gfx.PutPixel( 125 + x,113 + y,208,34,34 );
	gfx.PutPixel( 126 + x,113 + y,208,34,34 );
	gfx.PutPixel( 127 + x,113 + y,208,34,34 );
	gfx.PutPixel( 128 + x,113 + y,208,34,34 );
	gfx.PutPixel( 129 + x,113 + y,208,34,34 );
	gfx.PutPixel( 130 + x,113 + y,208,34,34 );
	gfx.PutPixel( 131 + x,113 + y,208,34,34 );
	gfx.PutPixel( 132 + x,113 + y,208,34,34 );
	gfx.PutPixel( 133 + x,113 + y,208,34,34 );
	gfx.PutPixel( 134 + x,113 + y,208,34,34 );
	gfx.PutPixel( 135 + x,113 + y,208,34,34 );
	gfx.PutPixel( 136 + x,113 + y,208,34,34 );
	gfx.PutPixel( 137 + x,113 + y,208,34,34 );
	gfx.PutPixel( 138 + x,113 + y,208,34,34 );
	gfx.PutPixel( 139 + x,113 + y,208,34,34 );
	gfx.PutPixel( 140 + x,113 + y,208,34,34 );
	gfx.PutPixel( 141 + x,113 + y,208,34,34 );
	gfx.PutPixel( 142 + x,113 + y,208,34,34 );
	gfx.PutPixel( 143 + x,113 + y,208,34,34 );
	gfx.PutPixel( 144 + x,113 + y,208,34,34 );
	gfx.PutPixel( 145 + x,113 + y,208,34,34 );
	gfx.PutPixel( 146 + x,113 + y,208,34,34 );
	gfx.PutPixel( 147 + x,113 + y,208,34,34 );
	gfx.PutPixel( 148 + x,113 + y,208,34,34 );
	gfx.PutPixel( 149 + x,113 + y,208,34,34 );
	gfx.PutPixel( 0 + x,114 + y,208,34,34 );
	gfx.PutPixel( 1 + x,114 + y,208,34,34 );
	gfx.PutPixel( 2 + x,114 + y,208,34,34 );
	gfx.PutPixel( 3 + x,114 + y,208,34,34 );
	gfx.PutPixel( 4 + x,114 + y,208,34,34 );
	gfx.PutPixel( 5 + x,114 + y,208,34,34 );
	gfx.PutPixel( 6 + x,114 + y,208,34,34 );
	gfx.PutPixel( 7 + x,114 + y,208,34,34 );
	gfx.PutPixel( 8 + x,114 + y,208,34,34 );
	gfx.PutPixel( 9 + x,114 + y,208,34,34 );
	gfx.PutPixel( 10 + x,114 + y,208,34,34 );
	gfx.PutPixel( 11 + x,114 + y,208,34,34 );
	gfx.PutPixel( 12 + x,114 + y,208,34,34 );
	gfx.PutPixel( 13 + x,114 + y,208,34,34 );
	gfx.PutPixel( 14 + x,114 + y,208,34,34 );
	gfx.PutPixel( 15 + x,114 + y,208,34,34 );
	gfx.PutPixel( 16 + x,114 + y,208,34,34 );
	gfx.PutPixel( 17 + x,114 + y,208,34,34 );
	gfx.PutPixel( 18 + x,114 + y,208,34,34 );
	gfx.PutPixel( 19 + x,114 + y,208,34,34 );
	gfx.PutPixel( 20 + x,114 + y,208,34,34 );
	gfx.PutPixel( 21 + x,114 + y,208,34,34 );
	gfx.PutPixel( 22 + x,114 + y,208,34,34 );
	gfx.PutPixel( 23 + x,114 + y,208,34,34 );
	gfx.PutPixel( 24 + x,114 + y,208,34,34 );
	gfx.PutPixel( 25 + x,114 + y,208,34,34 );
	gfx.PutPixel( 26 + x,114 + y,208,34,34 );
	gfx.PutPixel( 27 + x,114 + y,208,34,34 );
	gfx.PutPixel( 28 + x,114 + y,208,34,34 );
	gfx.PutPixel( 29 + x,114 + y,208,34,34 );
	gfx.PutPixel( 30 + x,114 + y,208,34,34 );
	gfx.PutPixel( 31 + x,114 + y,208,34,34 );
	gfx.PutPixel( 32 + x,114 + y,207,23,23 );
	gfx.PutPixel( 33 + x,114 + y,215,121,121 );
	gfx.PutPixel( 34 + x,114 + y,221,219,219 );
	gfx.PutPixel( 35 + x,114 + y,220,208,208 );
	gfx.PutPixel( 36 + x,114 + y,220,208,208 );
	gfx.PutPixel( 37 + x,114 + y,220,208,208 );
	gfx.PutPixel( 38 + x,114 + y,220,208,208 );
	gfx.PutPixel( 39 + x,114 + y,220,208,208 );
	gfx.PutPixel( 40 + x,114 + y,220,208,208 );
	gfx.PutPixel( 41 + x,114 + y,220,208,208 );
	gfx.PutPixel( 42 + x,114 + y,220,208,208 );
	gfx.PutPixel( 43 + x,114 + y,221,215,215 );
	gfx.PutPixel( 44 + x,114 + y,217,169,169 );
	gfx.PutPixel( 45 + x,114 + y,208,31,31 );
	gfx.PutPixel( 46 + x,114 + y,208,33,33 );
	gfx.PutPixel( 47 + x,114 + y,208,34,34 );
	gfx.PutPixel( 48 + x,114 + y,208,34,34 );
	gfx.PutPixel( 49 + x,114 + y,208,34,34 );
	gfx.PutPixel( 50 + x,114 + y,208,34,34 );
	gfx.PutPixel( 51 + x,114 + y,208,34,34 );
	gfx.PutPixel( 52 + x,114 + y,207,23,23 );
	gfx.PutPixel( 53 + x,114 + y,213,105,105 );
	gfx.PutPixel( 54 + x,114 + y,221,217,217 );
	gfx.PutPixel( 55 + x,114 + y,220,210,210 );
	gfx.PutPixel( 56 + x,114 + y,220,206,206 );
	gfx.PutPixel( 57 + x,114 + y,210,64,64 );
	gfx.PutPixel( 58 + x,114 + y,207,28,28 );
	gfx.PutPixel( 59 + x,114 + y,208,34,34 );
	gfx.PutPixel( 60 + x,114 + y,208,34,34 );
	gfx.PutPixel( 61 + x,114 + y,207,25,25 );
	gfx.PutPixel( 62 + x,114 + y,215,137,137 );
	gfx.PutPixel( 63 + x,114 + y,221,218,218 );
	gfx.PutPixel( 64 + x,114 + y,220,208,208 );
	gfx.PutPixel( 65 + x,114 + y,220,208,208 );
	gfx.PutPixel( 66 + x,114 + y,220,208,208 );
	gfx.PutPixel( 67 + x,114 + y,220,208,208 );
	gfx.PutPixel( 68 + x,114 + y,220,208,208 );
	gfx.PutPixel( 69 + x,114 + y,220,208,208 );
	gfx.PutPixel( 70 + x,114 + y,220,208,208 );
	gfx.PutPixel( 71 + x,114 + y,220,208,208 );
	gfx.PutPixel( 72 + x,114 + y,220,208,208 );
	gfx.PutPixel( 73 + x,114 + y,220,208,208 );
	gfx.PutPixel( 74 + x,114 + y,221,218,218 );
	gfx.PutPixel( 75 + x,114 + y,215,137,137 );
	gfx.PutPixel( 76 + x,114 + y,207,25,25 );
	gfx.PutPixel( 77 + x,114 + y,208,34,34 );
	gfx.PutPixel( 78 + x,114 + y,208,34,34 );
	gfx.PutPixel( 79 + x,114 + y,208,34,34 );
	gfx.PutPixel( 80 + x,114 + y,208,34,34 );
	gfx.PutPixel( 81 + x,114 + y,208,34,34 );
	gfx.PutPixel( 82 + x,114 + y,208,34,34 );
	gfx.PutPixel( 83 + x,114 + y,207,23,23 );
	gfx.PutPixel( 84 + x,114 + y,215,121,121 );
	gfx.PutPixel( 85 + x,114 + y,221,219,219 );
	gfx.PutPixel( 86 + x,114 + y,220,208,208 );
	gfx.PutPixel( 87 + x,114 + y,220,208,208 );
	gfx.PutPixel( 88 + x,114 + y,220,208,208 );
	gfx.PutPixel( 89 + x,114 + y,220,208,208 );
	gfx.PutPixel( 90 + x,114 + y,220,207,207 );
	gfx.PutPixel( 91 + x,114 + y,220,200,200 );
	gfx.PutPixel( 92 + x,114 + y,218,185,185 );
	gfx.PutPixel( 93 + x,114 + y,217,157,157 );
	gfx.PutPixel( 94 + x,114 + y,213,111,111 );
	gfx.PutPixel( 95 + x,114 + y,209,54,54 );
	gfx.PutPixel( 96 + x,114 + y,207,23,23 );
	gfx.PutPixel( 97 + x,114 + y,208,31,31 );
	gfx.PutPixel( 98 + x,114 + y,208,34,34 );
	gfx.PutPixel( 99 + x,114 + y,208,34,34 );
	gfx.PutPixel( 100 + x,114 + y,208,34,34 );
	gfx.PutPixel( 101 + x,114 + y,208,34,34 );
	gfx.PutPixel( 102 + x,114 + y,208,34,34 );
	gfx.PutPixel( 103 + x,114 + y,208,34,34 );
	gfx.PutPixel( 104 + x,114 + y,208,34,34 );
	gfx.PutPixel( 105 + x,114 + y,208,34,34 );
	gfx.PutPixel( 106 + x,114 + y,208,31,31 );
	gfx.PutPixel( 107 + x,114 + y,208,38,38 );
	gfx.PutPixel( 108 + x,114 + y,218,182,182 );
	gfx.PutPixel( 109 + x,114 + y,220,213,213 );
	gfx.PutPixel( 110 + x,114 + y,221,217,217 );
	gfx.PutPixel( 111 + x,114 + y,216,144,144 );
	gfx.PutPixel( 112 + x,114 + y,207,25,25 );
	gfx.PutPixel( 113 + x,114 + y,208,34,34 );
	gfx.PutPixel( 114 + x,114 + y,208,34,34 );
	gfx.PutPixel( 115 + x,114 + y,208,34,34 );
	gfx.PutPixel( 116 + x,114 + y,208,34,34 );
	gfx.PutPixel( 117 + x,114 + y,208,34,34 );
	gfx.PutPixel( 118 + x,114 + y,208,34,34 );
	gfx.PutPixel( 119 + x,114 + y,208,34,34 );
	gfx.PutPixel( 120 + x,114 + y,208,34,34 );
	gfx.PutPixel( 121 + x,114 + y,208,34,34 );
	gfx.PutPixel( 122 + x,114 + y,208,34,34 );
	gfx.PutPixel( 123 + x,114 + y,208,34,34 );
	gfx.PutPixel( 124 + x,114 + y,208,34,34 );
	gfx.PutPixel( 125 + x,114 + y,208,34,34 );
	gfx.PutPixel( 126 + x,114 + y,208,34,34 );
	gfx.PutPixel( 127 + x,114 + y,208,34,34 );
	gfx.PutPixel( 128 + x,114 + y,208,34,34 );
	gfx.PutPixel( 129 + x,114 + y,208,34,34 );
	gfx.PutPixel( 130 + x,114 + y,208,34,34 );
	gfx.PutPixel( 131 + x,114 + y,208,34,34 );
	gfx.PutPixel( 132 + x,114 + y,208,34,34 );
	gfx.PutPixel( 133 + x,114 + y,208,34,34 );
	gfx.PutPixel( 134 + x,114 + y,208,34,34 );
	gfx.PutPixel( 135 + x,114 + y,208,34,34 );
	gfx.PutPixel( 136 + x,114 + y,208,34,34 );
	gfx.PutPixel( 137 + x,114 + y,208,34,34 );
	gfx.PutPixel( 138 + x,114 + y,208,34,34 );
	gfx.PutPixel( 139 + x,114 + y,208,34,34 );
	gfx.PutPixel( 140 + x,114 + y,208,34,34 );
	gfx.PutPixel( 141 + x,114 + y,208,34,34 );
	gfx.PutPixel( 142 + x,114 + y,208,34,34 );
	gfx.PutPixel( 143 + x,114 + y,208,34,34 );
	gfx.PutPixel( 144 + x,114 + y,208,34,34 );
	gfx.PutPixel( 145 + x,114 + y,208,34,34 );
	gfx.PutPixel( 146 + x,114 + y,208,34,34 );
	gfx.PutPixel( 147 + x,114 + y,208,34,34 );
	gfx.PutPixel( 148 + x,114 + y,208,34,34 );
	gfx.PutPixel( 149 + x,114 + y,208,34,34 );
	gfx.PutPixel( 0 + x,115 + y,208,34,34 );
	gfx.PutPixel( 1 + x,115 + y,208,34,34 );
	gfx.PutPixel( 2 + x,115 + y,208,34,34 );
	gfx.PutPixel( 3 + x,115 + y,208,34,34 );
	gfx.PutPixel( 4 + x,115 + y,208,34,34 );
	gfx.PutPixel( 5 + x,115 + y,208,34,34 );
	gfx.PutPixel( 6 + x,115 + y,208,34,34 );
	gfx.PutPixel( 7 + x,115 + y,208,34,34 );
	gfx.PutPixel( 8 + x,115 + y,208,34,34 );
	gfx.PutPixel( 9 + x,115 + y,208,34,34 );
	gfx.PutPixel( 10 + x,115 + y,208,34,34 );
	gfx.PutPixel( 11 + x,115 + y,208,34,34 );
	gfx.PutPixel( 12 + x,115 + y,208,34,34 );
	gfx.PutPixel( 13 + x,115 + y,208,34,34 );
	gfx.PutPixel( 14 + x,115 + y,208,34,34 );
	gfx.PutPixel( 15 + x,115 + y,208,34,34 );
	gfx.PutPixel( 16 + x,115 + y,208,34,34 );
	gfx.PutPixel( 17 + x,115 + y,208,34,34 );
	gfx.PutPixel( 18 + x,115 + y,208,34,34 );
	gfx.PutPixel( 19 + x,115 + y,208,34,34 );
	gfx.PutPixel( 20 + x,115 + y,208,34,34 );
	gfx.PutPixel( 21 + x,115 + y,208,34,34 );
	gfx.PutPixel( 22 + x,115 + y,208,34,34 );
	gfx.PutPixel( 23 + x,115 + y,208,34,34 );
	gfx.PutPixel( 24 + x,115 + y,208,34,34 );
	gfx.PutPixel( 25 + x,115 + y,208,34,34 );
	gfx.PutPixel( 26 + x,115 + y,208,34,34 );
	gfx.PutPixel( 27 + x,115 + y,208,34,34 );
	gfx.PutPixel( 28 + x,115 + y,208,34,34 );
	gfx.PutPixel( 29 + x,115 + y,208,34,34 );
	gfx.PutPixel( 30 + x,115 + y,208,34,34 );
	gfx.PutPixel( 31 + x,115 + y,208,34,34 );
	gfx.PutPixel( 32 + x,115 + y,207,22,22 );
	gfx.PutPixel( 33 + x,115 + y,215,130,130 );
	gfx.PutPixel( 34 + x,115 + y,222,237,237 );
	gfx.PutPixel( 35 + x,115 + y,221,225,225 );
	gfx.PutPixel( 36 + x,115 + y,221,225,225 );
	gfx.PutPixel( 37 + x,115 + y,221,225,225 );
	gfx.PutPixel( 38 + x,115 + y,221,225,225 );
	gfx.PutPixel( 39 + x,115 + y,221,225,225 );
	gfx.PutPixel( 40 + x,115 + y,221,225,225 );
	gfx.PutPixel( 41 + x,115 + y,221,225,225 );
	gfx.PutPixel( 42 + x,115 + y,221,225,225 );
	gfx.PutPixel( 43 + x,115 + y,222,233,233 );
	gfx.PutPixel( 44 + x,115 + y,218,182,182 );
	gfx.PutPixel( 45 + x,115 + y,208,31,31 );
	gfx.PutPixel( 46 + x,115 + y,208,33,33 );
	gfx.PutPixel( 47 + x,115 + y,208,34,34 );
	gfx.PutPixel( 48 + x,115 + y,208,34,34 );
	gfx.PutPixel( 49 + x,115 + y,208,34,34 );
	gfx.PutPixel( 50 + x,115 + y,208,34,34 );
	gfx.PutPixel( 51 + x,115 + y,208,32,32 );
	gfx.PutPixel( 52 + x,115 + y,208,32,32 );
	gfx.PutPixel( 53 + x,115 + y,218,185,185 );
	gfx.PutPixel( 54 + x,115 + y,222,232,232 );
	gfx.PutPixel( 55 + x,115 + y,221,224,224 );
	gfx.PutPixel( 56 + x,115 + y,222,236,236 );
	gfx.PutPixel( 57 + x,115 + y,215,140,140 );
	gfx.PutPixel( 58 + x,115 + y,207,22,22 );
	gfx.PutPixel( 59 + x,115 + y,208,34,34 );
	gfx.PutPixel( 60 + x,115 + y,208,34,34 );
	gfx.PutPixel( 61 + x,115 + y,207,24,24 );
	gfx.PutPixel( 62 + x,115 + y,216,147,147 );
	gfx.PutPixel( 63 + x,115 + y,222,236,236 );
	gfx.PutPixel( 64 + x,115 + y,221,225,225 );
	gfx.PutPixel( 65 + x,115 + y,221,225,225 );
	gfx.PutPixel( 66 + x,115 + y,221,225,225 );
	gfx.PutPixel( 67 + x,115 + y,221,225,225 );
	gfx.PutPixel( 68 + x,115 + y,221,225,225 );
	gfx.PutPixel( 69 + x,115 + y,221,225,225 );
	gfx.PutPixel( 70 + x,115 + y,221,225,225 );
	gfx.PutPixel( 71 + x,115 + y,221,225,225 );
	gfx.PutPixel( 72 + x,115 + y,221,225,225 );
	gfx.PutPixel( 73 + x,115 + y,221,225,225 );
	gfx.PutPixel( 74 + x,115 + y,222,236,236 );
	gfx.PutPixel( 75 + x,115 + y,216,147,147 );
	gfx.PutPixel( 76 + x,115 + y,207,24,24 );
	gfx.PutPixel( 77 + x,115 + y,208,34,34 );
	gfx.PutPixel( 78 + x,115 + y,208,34,34 );
	gfx.PutPixel( 79 + x,115 + y,208,34,34 );
	gfx.PutPixel( 80 + x,115 + y,208,34,34 );
	gfx.PutPixel( 81 + x,115 + y,208,34,34 );
	gfx.PutPixel( 82 + x,115 + y,208,34,34 );
	gfx.PutPixel( 83 + x,115 + y,207,22,22 );
	gfx.PutPixel( 84 + x,115 + y,215,130,130 );
	gfx.PutPixel( 85 + x,115 + y,222,237,237 );
	gfx.PutPixel( 86 + x,115 + y,221,225,225 );
	gfx.PutPixel( 87 + x,115 + y,221,225,225 );
	gfx.PutPixel( 88 + x,115 + y,221,225,225 );
	gfx.PutPixel( 89 + x,115 + y,221,225,225 );
	gfx.PutPixel( 90 + x,115 + y,221,225,225 );
	gfx.PutPixel( 91 + x,115 + y,221,226,226 );
	gfx.PutPixel( 92 + x,115 + y,221,228,228 );
	gfx.PutPixel( 93 + x,115 + y,222,231,231 );
	gfx.PutPixel( 94 + x,115 + y,222,233,233 );
	gfx.PutPixel( 95 + x,115 + y,221,213,213 );
	gfx.PutPixel( 96 + x,115 + y,215,136,136 );
	gfx.PutPixel( 97 + x,115 + y,208,39,39 );
	gfx.PutPixel( 98 + x,115 + y,208,27,27 );
	gfx.PutPixel( 99 + x,115 + y,208,35,35 );
	gfx.PutPixel( 100 + x,115 + y,208,34,34 );
	gfx.PutPixel( 101 + x,115 + y,208,34,34 );
	gfx.PutPixel( 102 + x,115 + y,208,34,34 );
	gfx.PutPixel( 103 + x,115 + y,208,34,34 );
	gfx.PutPixel( 104 + x,115 + y,208,34,34 );
	gfx.PutPixel( 105 + x,115 + y,208,34,34 );
	gfx.PutPixel( 106 + x,115 + y,207,23,23 );
	gfx.PutPixel( 107 + x,115 + y,212,96,96 );
	gfx.PutPixel( 108 + x,115 + y,222,233,233 );
	gfx.PutPixel( 109 + x,115 + y,221,225,225 );
	gfx.PutPixel( 110 + x,115 + y,221,228,228 );
	gfx.PutPixel( 111 + x,115 + y,221,215,215 );
	gfx.PutPixel( 112 + x,115 + y,209,55,55 );
	gfx.PutPixel( 113 + x,115 + y,208,29,29 );
	gfx.PutPixel( 114 + x,115 + y,208,34,34 );
	gfx.PutPixel( 115 + x,115 + y,208,34,34 );
	gfx.PutPixel( 116 + x,115 + y,208,34,34 );
	gfx.PutPixel( 117 + x,115 + y,208,34,34 );
	gfx.PutPixel( 118 + x,115 + y,208,34,34 );
	gfx.PutPixel( 119 + x,115 + y,208,34,34 );
	gfx.PutPixel( 120 + x,115 + y,208,34,34 );
	gfx.PutPixel( 121 + x,115 + y,208,34,34 );
	gfx.PutPixel( 122 + x,115 + y,208,34,34 );
	gfx.PutPixel( 123 + x,115 + y,208,34,34 );
	gfx.PutPixel( 124 + x,115 + y,208,34,34 );
	gfx.PutPixel( 125 + x,115 + y,208,34,34 );
	gfx.PutPixel( 126 + x,115 + y,208,34,34 );
	gfx.PutPixel( 127 + x,115 + y,208,34,34 );
	gfx.PutPixel( 128 + x,115 + y,208,34,34 );
	gfx.PutPixel( 129 + x,115 + y,208,34,34 );
	gfx.PutPixel( 130 + x,115 + y,208,34,34 );
	gfx.PutPixel( 131 + x,115 + y,208,34,34 );
	gfx.PutPixel( 132 + x,115 + y,208,34,34 );
	gfx.PutPixel( 133 + x,115 + y,208,34,34 );
	gfx.PutPixel( 134 + x,115 + y,208,34,34 );
	gfx.PutPixel( 135 + x,115 + y,208,34,34 );
	gfx.PutPixel( 136 + x,115 + y,208,34,34 );
	gfx.PutPixel( 137 + x,115 + y,208,34,34 );
	gfx.PutPixel( 138 + x,115 + y,208,34,34 );
	gfx.PutPixel( 139 + x,115 + y,208,34,34 );
	gfx.PutPixel( 140 + x,115 + y,208,34,34 );
	gfx.PutPixel( 141 + x,115 + y,208,34,34 );
	gfx.PutPixel( 142 + x,115 + y,208,34,34 );
	gfx.PutPixel( 143 + x,115 + y,208,34,34 );
	gfx.PutPixel( 144 + x,115 + y,208,34,34 );
	gfx.PutPixel( 145 + x,115 + y,208,34,34 );
	gfx.PutPixel( 146 + x,115 + y,208,34,34 );
	gfx.PutPixel( 147 + x,115 + y,208,34,34 );
	gfx.PutPixel( 148 + x,115 + y,208,34,34 );
	gfx.PutPixel( 149 + x,115 + y,208,34,34 );
	gfx.PutPixel( 0 + x,116 + y,208,34,34 );
	gfx.PutPixel( 1 + x,116 + y,208,34,34 );
	gfx.PutPixel( 2 + x,116 + y,208,34,34 );
	gfx.PutPixel( 3 + x,116 + y,208,34,34 );
	gfx.PutPixel( 4 + x,116 + y,208,34,34 );
	gfx.PutPixel( 5 + x,116 + y,208,34,34 );
	gfx.PutPixel( 6 + x,116 + y,208,34,34 );
	gfx.PutPixel( 7 + x,116 + y,208,34,34 );
	gfx.PutPixel( 8 + x,116 + y,208,34,34 );
	gfx.PutPixel( 9 + x,116 + y,208,34,34 );
	gfx.PutPixel( 10 + x,116 + y,208,34,34 );
	gfx.PutPixel( 11 + x,116 + y,208,34,34 );
	gfx.PutPixel( 12 + x,116 + y,208,34,34 );
	gfx.PutPixel( 13 + x,116 + y,208,34,34 );
	gfx.PutPixel( 14 + x,116 + y,208,34,34 );
	gfx.PutPixel( 15 + x,116 + y,208,34,34 );
	gfx.PutPixel( 16 + x,116 + y,208,34,34 );
	gfx.PutPixel( 17 + x,116 + y,208,34,34 );
	gfx.PutPixel( 18 + x,116 + y,208,34,34 );
	gfx.PutPixel( 19 + x,116 + y,208,34,34 );
	gfx.PutPixel( 20 + x,116 + y,208,34,34 );
	gfx.PutPixel( 21 + x,116 + y,208,34,34 );
	gfx.PutPixel( 22 + x,116 + y,208,34,34 );
	gfx.PutPixel( 23 + x,116 + y,208,34,34 );
	gfx.PutPixel( 24 + x,116 + y,208,34,34 );
	gfx.PutPixel( 25 + x,116 + y,208,34,34 );
	gfx.PutPixel( 26 + x,116 + y,208,34,34 );
	gfx.PutPixel( 27 + x,116 + y,208,34,34 );
	gfx.PutPixel( 28 + x,116 + y,208,34,34 );
	gfx.PutPixel( 29 + x,116 + y,208,34,34 );
	gfx.PutPixel( 30 + x,116 + y,208,34,34 );
	gfx.PutPixel( 31 + x,116 + y,208,34,34 );
	gfx.PutPixel( 32 + x,116 + y,207,22,22 );
	gfx.PutPixel( 33 + x,116 + y,215,128,128 );
	gfx.PutPixel( 34 + x,116 + y,222,233,233 );
	gfx.PutPixel( 35 + x,116 + y,221,221,221 );
	gfx.PutPixel( 36 + x,116 + y,221,222,222 );
	gfx.PutPixel( 37 + x,116 + y,222,232,232 );
	gfx.PutPixel( 38 + x,116 + y,222,233,233 );
	gfx.PutPixel( 39 + x,116 + y,222,233,233 );
	gfx.PutPixel( 40 + x,116 + y,222,233,233 );
	gfx.PutPixel( 41 + x,116 + y,222,233,233 );
	gfx.PutPixel( 42 + x,116 + y,222,233,233 );
	gfx.PutPixel( 43 + x,116 + y,223,242,242 );
	gfx.PutPixel( 44 + x,116 + y,219,188,188 );
	gfx.PutPixel( 45 + x,116 + y,208,31,31 );
	gfx.PutPixel( 46 + x,116 + y,208,33,33 );
	gfx.PutPixel( 47 + x,116 + y,208,34,34 );
	gfx.PutPixel( 48 + x,116 + y,208,34,34 );
	gfx.PutPixel( 49 + x,116 + y,208,34,34 );
	gfx.PutPixel( 50 + x,116 + y,208,34,34 );
	gfx.PutPixel( 51 + x,116 + y,207,24,24 );
	gfx.PutPixel( 52 + x,116 + y,212,85,85 );
	gfx.PutPixel( 53 + x,116 + y,222,227,227 );
	gfx.PutPixel( 54 + x,116 + y,221,222,222 );
	gfx.PutPixel( 55 + x,116 + y,221,221,221 );
	gfx.PutPixel( 56 + x,116 + y,221,225,225 );
	gfx.PutPixel( 57 + x,116 + y,220,207,207 );
	gfx.PutPixel( 58 + x,116 + y,209,48,48 );
	gfx.PutPixel( 59 + x,116 + y,208,30,30 );
	gfx.PutPixel( 60 + x,116 + y,208,34,34 );
	gfx.PutPixel( 61 + x,116 + y,207,23,23 );
	gfx.PutPixel( 62 + x,116 + y,217,152,152 );
	gfx.PutPixel( 63 + x,116 + y,223,245,245 );
	gfx.PutPixel( 64 + x,116 + y,222,233,233 );
	gfx.PutPixel( 65 + x,116 + y,222,233,233 );
	gfx.PutPixel( 66 + x,116 + y,222,234,234 );
	gfx.PutPixel( 67 + x,116 + y,221,224,224 );
	gfx.PutPixel( 68 + x,116 + y,221,220,220 );
	gfx.PutPixel( 69 + x,116 + y,221,220,220 );
	gfx.PutPixel( 70 + x,116 + y,221,224,224 );
	gfx.PutPixel( 71 + x,116 + y,222,234,234 );
	gfx.PutPixel( 72 + x,116 + y,222,233,233 );
	gfx.PutPixel( 73 + x,116 + y,222,233,233 );
	gfx.PutPixel( 74 + x,116 + y,223,245,245 );
	gfx.PutPixel( 75 + x,116 + y,217,152,152 );
	gfx.PutPixel( 76 + x,116 + y,207,23,23 );
	gfx.PutPixel( 77 + x,116 + y,208,34,34 );
	gfx.PutPixel( 78 + x,116 + y,208,34,34 );
	gfx.PutPixel( 79 + x,116 + y,208,34,34 );
	gfx.PutPixel( 80 + x,116 + y,208,34,34 );
	gfx.PutPixel( 81 + x,116 + y,208,34,34 );
	gfx.PutPixel( 82 + x,116 + y,208,34,34 );
	gfx.PutPixel( 83 + x,116 + y,207,22,22 );
	gfx.PutPixel( 84 + x,116 + y,215,128,128 );
	gfx.PutPixel( 85 + x,116 + y,222,233,233 );
	gfx.PutPixel( 86 + x,116 + y,221,221,221 );
	gfx.PutPixel( 87 + x,116 + y,221,222,222 );
	gfx.PutPixel( 88 + x,116 + y,222,232,232 );
	gfx.PutPixel( 89 + x,116 + y,222,233,233 );
	gfx.PutPixel( 90 + x,116 + y,222,233,233 );
	gfx.PutPixel( 91 + x,116 + y,222,232,232 );
	gfx.PutPixel( 92 + x,116 + y,222,229,229 );
	gfx.PutPixel( 93 + x,116 + y,221,223,223 );
	gfx.PutPixel( 94 + x,116 + y,221,221,221 );
	gfx.PutPixel( 95 + x,116 + y,221,225,225 );
	gfx.PutPixel( 96 + x,116 + y,222,235,235 );
	gfx.PutPixel( 97 + x,116 + y,218,183,183 );
	gfx.PutPixel( 98 + x,116 + y,209,48,48 );
	gfx.PutPixel( 99 + x,116 + y,208,28,28 );
	gfx.PutPixel( 100 + x,116 + y,208,34,34 );
	gfx.PutPixel( 101 + x,116 + y,208,34,34 );
	gfx.PutPixel( 102 + x,116 + y,208,34,34 );
	gfx.PutPixel( 103 + x,116 + y,208,34,34 );
	gfx.PutPixel( 104 + x,116 + y,208,34,34 );
	gfx.PutPixel( 105 + x,116 + y,208,33,33 );
	gfx.PutPixel( 106 + x,116 + y,207,28,28 );
	gfx.PutPixel( 107 + x,116 + y,218,174,174 );
	gfx.PutPixel( 108 + x,116 + y,222,230,230 );
	gfx.PutPixel( 109 + x,116 + y,221,221,221 );
	gfx.PutPixel( 110 + x,116 + y,221,221,221 );
	gfx.PutPixel( 111 + x,116 + y,222,233,233 );
	gfx.PutPixel( 112 + x,116 + y,215,128,128 );
	gfx.PutPixel( 113 + x,116 + y,207,22,22 );
	gfx.PutPixel( 114 + x,116 + y,208,34,34 );
	gfx.PutPixel( 115 + x,116 + y,208,34,34 );
	gfx.PutPixel( 116 + x,116 + y,208,34,34 );
	gfx.PutPixel( 117 + x,116 + y,208,34,34 );
	gfx.PutPixel( 118 + x,116 + y,208,34,34 );
	gfx.PutPixel( 119 + x,116 + y,208,34,34 );
	gfx.PutPixel( 120 + x,116 + y,208,34,34 );
	gfx.PutPixel( 121 + x,116 + y,208,34,34 );
	gfx.PutPixel( 122 + x,116 + y,208,34,34 );
	gfx.PutPixel( 123 + x,116 + y,208,34,34 );
	gfx.PutPixel( 124 + x,116 + y,208,34,34 );
	gfx.PutPixel( 125 + x,116 + y,208,34,34 );
	gfx.PutPixel( 126 + x,116 + y,208,34,34 );
	gfx.PutPixel( 127 + x,116 + y,208,34,34 );
	gfx.PutPixel( 128 + x,116 + y,208,34,34 );
	gfx.PutPixel( 129 + x,116 + y,208,34,34 );
	gfx.PutPixel( 130 + x,116 + y,208,34,34 );
	gfx.PutPixel( 131 + x,116 + y,208,34,34 );
	gfx.PutPixel( 132 + x,116 + y,208,34,34 );
	gfx.PutPixel( 133 + x,116 + y,208,34,34 );
	gfx.PutPixel( 134 + x,116 + y,208,34,34 );
	gfx.PutPixel( 135 + x,116 + y,208,34,34 );
	gfx.PutPixel( 136 + x,116 + y,208,34,34 );
	gfx.PutPixel( 137 + x,116 + y,208,34,34 );
	gfx.PutPixel( 138 + x,116 + y,208,34,34 );
	gfx.PutPixel( 139 + x,116 + y,208,34,34 );
	gfx.PutPixel( 140 + x,116 + y,208,34,34 );
	gfx.PutPixel( 141 + x,116 + y,208,34,34 );
	gfx.PutPixel( 142 + x,116 + y,208,34,34 );
	gfx.PutPixel( 143 + x,116 + y,208,34,34 );
	gfx.PutPixel( 144 + x,116 + y,208,34,34 );
	gfx.PutPixel( 145 + x,116 + y,208,34,34 );
	gfx.PutPixel( 146 + x,116 + y,208,34,34 );
	gfx.PutPixel( 147 + x,116 + y,208,34,34 );
	gfx.PutPixel( 148 + x,116 + y,208,34,34 );
	gfx.PutPixel( 149 + x,116 + y,208,34,34 );
	gfx.PutPixel( 0 + x,117 + y,208,34,34 );
	gfx.PutPixel( 1 + x,117 + y,208,34,34 );
	gfx.PutPixel( 2 + x,117 + y,208,34,34 );
	gfx.PutPixel( 3 + x,117 + y,208,34,34 );
	gfx.PutPixel( 4 + x,117 + y,208,34,34 );
	gfx.PutPixel( 5 + x,117 + y,208,34,34 );
	gfx.PutPixel( 6 + x,117 + y,208,34,34 );
	gfx.PutPixel( 7 + x,117 + y,208,34,34 );
	gfx.PutPixel( 8 + x,117 + y,208,34,34 );
	gfx.PutPixel( 9 + x,117 + y,208,34,34 );
	gfx.PutPixel( 10 + x,117 + y,208,34,34 );
	gfx.PutPixel( 11 + x,117 + y,208,34,34 );
	gfx.PutPixel( 12 + x,117 + y,208,34,34 );
	gfx.PutPixel( 13 + x,117 + y,208,34,34 );
	gfx.PutPixel( 14 + x,117 + y,208,34,34 );
	gfx.PutPixel( 15 + x,117 + y,208,34,34 );
	gfx.PutPixel( 16 + x,117 + y,208,34,34 );
	gfx.PutPixel( 17 + x,117 + y,208,34,34 );
	gfx.PutPixel( 18 + x,117 + y,208,34,34 );
	gfx.PutPixel( 19 + x,117 + y,208,34,34 );
	gfx.PutPixel( 20 + x,117 + y,208,34,34 );
	gfx.PutPixel( 21 + x,117 + y,208,34,34 );
	gfx.PutPixel( 22 + x,117 + y,208,34,34 );
	gfx.PutPixel( 23 + x,117 + y,208,34,34 );
	gfx.PutPixel( 24 + x,117 + y,208,34,34 );
	gfx.PutPixel( 25 + x,117 + y,208,34,34 );
	gfx.PutPixel( 26 + x,117 + y,208,34,34 );
	gfx.PutPixel( 27 + x,117 + y,208,34,34 );
	gfx.PutPixel( 28 + x,117 + y,208,34,34 );
	gfx.PutPixel( 29 + x,117 + y,208,34,34 );
	gfx.PutPixel( 30 + x,117 + y,208,34,34 );
	gfx.PutPixel( 31 + x,117 + y,208,34,34 );
	gfx.PutPixel( 32 + x,117 + y,207,22,22 );
	gfx.PutPixel( 33 + x,117 + y,215,128,128 );
	gfx.PutPixel( 34 + x,117 + y,222,233,233 );
	gfx.PutPixel( 35 + x,117 + y,221,223,223 );
	gfx.PutPixel( 36 + x,117 + y,221,215,215 );
	gfx.PutPixel( 37 + x,117 + y,215,134,134 );
	gfx.PutPixel( 38 + x,117 + y,215,126,126 );
	gfx.PutPixel( 39 + x,117 + y,215,128,128 );
	gfx.PutPixel( 40 + x,117 + y,215,128,128 );
	gfx.PutPixel( 41 + x,117 + y,215,128,128 );
	gfx.PutPixel( 42 + x,117 + y,215,128,128 );
	gfx.PutPixel( 43 + x,117 + y,215,132,132 );
	gfx.PutPixel( 44 + x,117 + y,213,107,107 );
	gfx.PutPixel( 45 + x,117 + y,208,33,33 );
	gfx.PutPixel( 46 + x,117 + y,208,34,34 );
	gfx.PutPixel( 47 + x,117 + y,208,34,34 );
	gfx.PutPixel( 48 + x,117 + y,208,34,34 );
	gfx.PutPixel( 49 + x,117 + y,208,34,34 );
	gfx.PutPixel( 50 + x,117 + y,208,34,34 );
	gfx.PutPixel( 51 + x,117 + y,207,26,26 );
	gfx.PutPixel( 52 + x,117 + y,217,162,162 );
	gfx.PutPixel( 53 + x,117 + y,222,231,231 );
	gfx.PutPixel( 54 + x,117 + y,221,221,221 );
	gfx.PutPixel( 55 + x,117 + y,221,221,221 );
	gfx.PutPixel( 56 + x,117 + y,221,221,221 );
	gfx.PutPixel( 57 + x,117 + y,222,233,233 );
	gfx.PutPixel( 58 + x,117 + y,214,116,116 );
	gfx.PutPixel( 59 + x,117 + y,207,22,22 );
	gfx.PutPixel( 60 + x,117 + y,208,34,34 );
	gfx.PutPixel( 61 + x,117 + y,208,29,29 );
	gfx.PutPixel( 62 + x,117 + y,212,90,90 );
	gfx.PutPixel( 63 + x,117 + y,215,133,133 );
	gfx.PutPixel( 64 + x,117 + y,215,128,128 );
	gfx.PutPixel( 65 + x,117 + y,215,128,128 );
	gfx.PutPixel( 66 + x,117 + y,215,124,124 );
	gfx.PutPixel( 67 + x,117 + y,220,197,197 );
	gfx.PutPixel( 68 + x,117 + y,222,226,226 );
	gfx.PutPixel( 69 + x,117 + y,222,226,226 );
	gfx.PutPixel( 70 + x,117 + y,220,197,197 );
	gfx.PutPixel( 71 + x,117 + y,215,124,124 );
	gfx.PutPixel( 72 + x,117 + y,215,128,128 );
	gfx.PutPixel( 73 + x,117 + y,215,128,128 );
	gfx.PutPixel( 74 + x,117 + y,215,133,133 );
	gfx.PutPixel( 75 + x,117 + y,212,90,90 );
	gfx.PutPixel( 76 + x,117 + y,208,29,29 );
	gfx.PutPixel( 77 + x,117 + y,208,34,34 );
	gfx.PutPixel( 78 + x,117 + y,208,34,34 );
	gfx.PutPixel( 79 + x,117 + y,208,34,34 );
	gfx.PutPixel( 80 + x,117 + y,208,34,34 );
	gfx.PutPixel( 81 + x,117 + y,208,34,34 );
	gfx.PutPixel( 82 + x,117 + y,208,34,34 );
	gfx.PutPixel( 83 + x,117 + y,207,22,22 );
	gfx.PutPixel( 84 + x,117 + y,215,128,128 );
	gfx.PutPixel( 85 + x,117 + y,222,233,233 );
	gfx.PutPixel( 86 + x,117 + y,221,223,223 );
	gfx.PutPixel( 87 + x,117 + y,221,215,215 );
	gfx.PutPixel( 88 + x,117 + y,215,134,134 );
	gfx.PutPixel( 89 + x,117 + y,215,125,125 );
	gfx.PutPixel( 90 + x,117 + y,215,128,128 );
	gfx.PutPixel( 91 + x,117 + y,216,143,143 );
	gfx.PutPixel( 92 + x,117 + y,218,178,178 );
	gfx.PutPixel( 93 + x,117 + y,221,219,219 );
	gfx.PutPixel( 94 + x,117 + y,222,230,230 );
	gfx.PutPixel( 95 + x,117 + y,221,221,221 );
	gfx.PutPixel( 96 + x,117 + y,221,221,221 );
	gfx.PutPixel( 97 + x,117 + y,222,234,234 );
	gfx.PutPixel( 98 + x,117 + y,218,173,173 );
	gfx.PutPixel( 99 + x,117 + y,208,32,32 );
	gfx.PutPixel( 100 + x,117 + y,208,32,32 );
	gfx.PutPixel( 101 + x,117 + y,208,34,34 );
	gfx.PutPixel( 102 + x,117 + y,208,34,34 );
	gfx.PutPixel( 103 + x,117 + y,208,34,34 );
	gfx.PutPixel( 104 + x,117 + y,208,34,34 );
	gfx.PutPixel( 105 + x,117 + y,207,26,26 );
	gfx.PutPixel( 106 + x,117 + y,211,74,74 );
	gfx.PutPixel( 107 + x,117 + y,221,224,224 );
	gfx.PutPixel( 108 + x,117 + y,221,222,222 );
	gfx.PutPixel( 109 + x,117 + y,221,221,221 );
	gfx.PutPixel( 110 + x,117 + y,221,221,221 );
	gfx.PutPixel( 111 + x,117 + y,221,226,226 );
	gfx.PutPixel( 112 + x,117 + y,220,199,199 );
	gfx.PutPixel( 113 + x,117 + y,209,41,41 );
	gfx.PutPixel( 114 + x,117 + y,208,31,31 );
	gfx.PutPixel( 115 + x,117 + y,208,34,34 );
	gfx.PutPixel( 116 + x,117 + y,208,34,34 );
	gfx.PutPixel( 117 + x,117 + y,208,34,34 );
	gfx.PutPixel( 118 + x,117 + y,208,34,34 );
	gfx.PutPixel( 119 + x,117 + y,208,34,34 );
	gfx.PutPixel( 120 + x,117 + y,208,34,34 );
	gfx.PutPixel( 121 + x,117 + y,208,34,34 );
	gfx.PutPixel( 122 + x,117 + y,208,34,34 );
	gfx.PutPixel( 123 + x,117 + y,208,34,34 );
	gfx.PutPixel( 124 + x,117 + y,208,34,34 );
	gfx.PutPixel( 125 + x,117 + y,208,34,34 );
	gfx.PutPixel( 126 + x,117 + y,208,34,34 );
	gfx.PutPixel( 127 + x,117 + y,208,34,34 );
	gfx.PutPixel( 128 + x,117 + y,208,34,34 );
	gfx.PutPixel( 129 + x,117 + y,208,34,34 );
	gfx.PutPixel( 130 + x,117 + y,208,34,34 );
	gfx.PutPixel( 131 + x,117 + y,208,34,34 );
	gfx.PutPixel( 132 + x,117 + y,208,34,34 );
	gfx.PutPixel( 133 + x,117 + y,208,34,34 );
	gfx.PutPixel( 134 + x,117 + y,208,34,34 );
	gfx.PutPixel( 135 + x,117 + y,208,34,34 );
	gfx.PutPixel( 136 + x,117 + y,208,34,34 );
	gfx.PutPixel( 137 + x,117 + y,208,34,34 );
	gfx.PutPixel( 138 + x,117 + y,208,34,34 );
	gfx.PutPixel( 139 + x,117 + y,208,34,34 );
	gfx.PutPixel( 140 + x,117 + y,208,34,34 );
	gfx.PutPixel( 141 + x,117 + y,208,34,34 );
	gfx.PutPixel( 142 + x,117 + y,208,34,34 );
	gfx.PutPixel( 143 + x,117 + y,208,34,34 );
	gfx.PutPixel( 144 + x,117 + y,208,34,34 );
	gfx.PutPixel( 145 + x,117 + y,208,34,34 );
	gfx.PutPixel( 146 + x,117 + y,208,34,34 );
	gfx.PutPixel( 147 + x,117 + y,208,34,34 );
	gfx.PutPixel( 148 + x,117 + y,208,34,34 );
	gfx.PutPixel( 149 + x,117 + y,208,34,34 );
	gfx.PutPixel( 0 + x,118 + y,208,34,34 );
	gfx.PutPixel( 1 + x,118 + y,208,34,34 );
	gfx.PutPixel( 2 + x,118 + y,208,34,34 );
	gfx.PutPixel( 3 + x,118 + y,208,34,34 );
	gfx.PutPixel( 4 + x,118 + y,208,34,34 );
	gfx.PutPixel( 5 + x,118 + y,208,34,34 );
	gfx.PutPixel( 6 + x,118 + y,208,34,34 );
	gfx.PutPixel( 7 + x,118 + y,208,34,34 );
	gfx.PutPixel( 8 + x,118 + y,208,34,34 );
	gfx.PutPixel( 9 + x,118 + y,208,34,34 );
	gfx.PutPixel( 10 + x,118 + y,208,34,34 );
	gfx.PutPixel( 11 + x,118 + y,208,34,34 );
	gfx.PutPixel( 12 + x,118 + y,208,34,34 );
	gfx.PutPixel( 13 + x,118 + y,208,34,34 );
	gfx.PutPixel( 14 + x,118 + y,208,34,34 );
	gfx.PutPixel( 15 + x,118 + y,208,34,34 );
	gfx.PutPixel( 16 + x,118 + y,208,34,34 );
	gfx.PutPixel( 17 + x,118 + y,208,34,34 );
	gfx.PutPixel( 18 + x,118 + y,208,34,34 );
	gfx.PutPixel( 19 + x,118 + y,208,34,34 );
	gfx.PutPixel( 20 + x,118 + y,208,34,34 );
	gfx.PutPixel( 21 + x,118 + y,208,34,34 );
	gfx.PutPixel( 22 + x,118 + y,208,34,34 );
	gfx.PutPixel( 23 + x,118 + y,208,34,34 );
	gfx.PutPixel( 24 + x,118 + y,208,34,34 );
	gfx.PutPixel( 25 + x,118 + y,208,34,34 );
	gfx.PutPixel( 26 + x,118 + y,208,34,34 );
	gfx.PutPixel( 27 + x,118 + y,208,34,34 );
	gfx.PutPixel( 28 + x,118 + y,208,34,34 );
	gfx.PutPixel( 29 + x,118 + y,208,34,34 );
	gfx.PutPixel( 30 + x,118 + y,208,34,34 );
	gfx.PutPixel( 31 + x,118 + y,208,34,34 );
	gfx.PutPixel( 32 + x,118 + y,207,22,22 );
	gfx.PutPixel( 33 + x,118 + y,215,128,128 );
	gfx.PutPixel( 34 + x,118 + y,222,233,233 );
	gfx.PutPixel( 35 + x,118 + y,221,225,225 );
	gfx.PutPixel( 36 + x,118 + y,220,207,207 );
	gfx.PutPixel( 37 + x,118 + y,208,36,36 );
	gfx.PutPixel( 38 + x,118 + y,207,18,18 );
	gfx.PutPixel( 39 + x,118 + y,207,22,22 );
	gfx.PutPixel( 40 + x,118 + y,207,22,22 );
	gfx.PutPixel( 41 + x,118 + y,207,22,22 );
	gfx.PutPixel( 42 + x,118 + y,207,22,22 );
	gfx.PutPixel( 43 + x,118 + y,207,21,21 );
	gfx.PutPixel( 44 + x,118 + y,207,25,25 );
	gfx.PutPixel( 45 + x,118 + y,208,34,34 );
	gfx.PutPixel( 46 + x,118 + y,208,34,34 );
	gfx.PutPixel( 47 + x,118 + y,208,34,34 );
	gfx.PutPixel( 48 + x,118 + y,208,34,34 );
	gfx.PutPixel( 49 + x,118 + y,208,34,34 );
	gfx.PutPixel( 50 + x,118 + y,207,27,27 );
	gfx.PutPixel( 51 + x,118 + y,210,64,64 );
	gfx.PutPixel( 52 + x,118 + y,221,219,219 );
	gfx.PutPixel( 53 + x,118 + y,221,223,223 );
	gfx.PutPixel( 54 + x,118 + y,221,222,222 );
	gfx.PutPixel( 55 + x,118 + y,221,225,225 );
	gfx.PutPixel( 56 + x,118 + y,221,221,221 );
	gfx.PutPixel( 57 + x,118 + y,221,228,228 );
	gfx.PutPixel( 58 + x,118 + y,219,190,190 );
	gfx.PutPixel( 59 + x,118 + y,208,36,36 );
	gfx.PutPixel( 60 + x,118 + y,208,32,32 );
	gfx.PutPixel( 61 + x,118 + y,208,35,35 );
	gfx.PutPixel( 62 + x,118 + y,207,27,27 );
	gfx.PutPixel( 63 + x,118 + y,207,21,21 );
	gfx.PutPixel( 64 + x,118 + y,207,22,22 );
	gfx.PutPixel( 65 + x,118 + y,207,22,22 );
	gfx.PutPixel( 66 + x,118 + y,207,14,14 );
	gfx.PutPixel( 67 + x,118 + y,218,170,170 );
	gfx.PutPixel( 68 + x,118 + y,222,231,231 );
	gfx.PutPixel( 69 + x,118 + y,222,231,231 );
	gfx.PutPixel( 70 + x,118 + y,218,170,170 );
	gfx.PutPixel( 71 + x,118 + y,207,14,14 );
	gfx.PutPixel( 72 + x,118 + y,207,22,22 );
	gfx.PutPixel( 73 + x,118 + y,207,22,22 );
	gfx.PutPixel( 74 + x,118 + y,207,21,21 );
	gfx.PutPixel( 75 + x,118 + y,207,27,27 );
	gfx.PutPixel( 76 + x,118 + y,208,35,35 );
	gfx.PutPixel( 77 + x,118 + y,208,34,34 );
	gfx.PutPixel( 78 + x,118 + y,208,34,34 );
	gfx.PutPixel( 79 + x,118 + y,208,34,34 );
	gfx.PutPixel( 80 + x,118 + y,208,34,34 );
	gfx.PutPixel( 81 + x,118 + y,208,34,34 );
	gfx.PutPixel( 82 + x,118 + y,208,34,34 );
	gfx.PutPixel( 83 + x,118 + y,207,22,22 );
	gfx.PutPixel( 84 + x,118 + y,215,128,128 );
	gfx.PutPixel( 85 + x,118 + y,222,233,233 );
	gfx.PutPixel( 86 + x,118 + y,221,225,225 );
	gfx.PutPixel( 87 + x,118 + y,220,207,207 );
	gfx.PutPixel( 88 + x,118 + y,208,36,36 );
	gfx.PutPixel( 89 + x,118 + y,207,18,18 );
	gfx.PutPixel( 90 + x,118 + y,207,22,22 );
	gfx.PutPixel( 91 + x,118 + y,207,23,23 );
	gfx.PutPixel( 92 + x,118 + y,208,29,29 );
	gfx.PutPixel( 93 + x,118 + y,210,65,65 );
	gfx.PutPixel( 94 + x,118 + y,217,168,168 );
	gfx.PutPixel( 95 + x,118 + y,222,230,230 );
	gfx.PutPixel( 96 + x,118 + y,221,221,221 );
	gfx.PutPixel( 97 + x,118 + y,221,221,221 );
	gfx.PutPixel( 98 + x,118 + y,222,233,233 );
	gfx.PutPixel( 99 + x,118 + y,213,105,105 );
	gfx.PutPixel( 100 + x,118 + y,207,24,24 );
	gfx.PutPixel( 101 + x,118 + y,208,34,34 );
	gfx.PutPixel( 102 + x,118 + y,208,34,34 );
	gfx.PutPixel( 103 + x,118 + y,208,34,34 );
	gfx.PutPixel( 104 + x,118 + y,208,34,34 );
	gfx.PutPixel( 105 + x,118 + y,207,24,24 );
	gfx.PutPixel( 106 + x,118 + y,216,150,150 );
	gfx.PutPixel( 107 + x,118 + y,222,232,232 );
	gfx.PutPixel( 108 + x,118 + y,221,221,221 );
	gfx.PutPixel( 109 + x,118 + y,221,225,225 );
	gfx.PutPixel( 110 + x,118 + y,221,222,222 );
	gfx.PutPixel( 111 + x,118 + y,221,221,221 );
	gfx.PutPixel( 112 + x,118 + y,222,231,231 );
	gfx.PutPixel( 113 + x,118 + y,213,104,104 );
	gfx.PutPixel( 114 + x,118 + y,207,23,23 );
	gfx.PutPixel( 115 + x,118 + y,208,34,34 );
	gfx.PutPixel( 116 + x,118 + y,208,34,34 );
	gfx.PutPixel( 117 + x,118 + y,208,34,34 );
	gfx.PutPixel( 118 + x,118 + y,208,34,34 );
	gfx.PutPixel( 119 + x,118 + y,208,34,34 );
	gfx.PutPixel( 120 + x,118 + y,208,34,34 );
	gfx.PutPixel( 121 + x,118 + y,208,34,34 );
	gfx.PutPixel( 122 + x,118 + y,208,34,34 );
	gfx.PutPixel( 123 + x,118 + y,208,34,34 );
	gfx.PutPixel( 124 + x,118 + y,208,34,34 );
	gfx.PutPixel( 125 + x,118 + y,208,34,34 );
	gfx.PutPixel( 126 + x,118 + y,208,34,34 );
	gfx.PutPixel( 127 + x,118 + y,208,34,34 );
	gfx.PutPixel( 128 + x,118 + y,208,34,34 );
	gfx.PutPixel( 129 + x,118 + y,208,34,34 );
	gfx.PutPixel( 130 + x,118 + y,208,34,34 );
	gfx.PutPixel( 131 + x,118 + y,208,34,34 );
	gfx.PutPixel( 132 + x,118 + y,208,34,34 );
	gfx.PutPixel( 133 + x,118 + y,208,34,34 );
	gfx.PutPixel( 134 + x,118 + y,208,34,34 );
	gfx.PutPixel( 135 + x,118 + y,208,34,34 );
	gfx.PutPixel( 136 + x,118 + y,208,34,34 );
	gfx.PutPixel( 137 + x,118 + y,208,34,34 );
	gfx.PutPixel( 138 + x,118 + y,208,34,34 );
	gfx.PutPixel( 139 + x,118 + y,208,34,34 );
	gfx.PutPixel( 140 + x,118 + y,208,34,34 );
	gfx.PutPixel( 141 + x,118 + y,208,34,34 );
	gfx.PutPixel( 142 + x,118 + y,208,34,34 );
	gfx.PutPixel( 143 + x,118 + y,208,34,34 );
	gfx.PutPixel( 144 + x,118 + y,208,34,34 );
	gfx.PutPixel( 145 + x,118 + y,208,34,34 );
	gfx.PutPixel( 146 + x,118 + y,208,34,34 );
	gfx.PutPixel( 147 + x,118 + y,208,34,34 );
	gfx.PutPixel( 148 + x,118 + y,208,34,34 );
	gfx.PutPixel( 149 + x,118 + y,208,34,34 );
	gfx.PutPixel( 0 + x,119 + y,208,34,34 );
	gfx.PutPixel( 1 + x,119 + y,208,34,34 );
	gfx.PutPixel( 2 + x,119 + y,208,34,34 );
	gfx.PutPixel( 3 + x,119 + y,208,34,34 );
	gfx.PutPixel( 4 + x,119 + y,208,34,34 );
	gfx.PutPixel( 5 + x,119 + y,208,34,34 );
	gfx.PutPixel( 6 + x,119 + y,208,34,34 );
	gfx.PutPixel( 7 + x,119 + y,208,34,34 );
	gfx.PutPixel( 8 + x,119 + y,208,34,34 );
	gfx.PutPixel( 9 + x,119 + y,208,34,34 );
	gfx.PutPixel( 10 + x,119 + y,208,34,34 );
	gfx.PutPixel( 11 + x,119 + y,208,34,34 );
	gfx.PutPixel( 12 + x,119 + y,208,34,34 );
	gfx.PutPixel( 13 + x,119 + y,208,34,34 );
	gfx.PutPixel( 14 + x,119 + y,208,34,34 );
	gfx.PutPixel( 15 + x,119 + y,208,34,34 );
	gfx.PutPixel( 16 + x,119 + y,208,34,34 );
	gfx.PutPixel( 17 + x,119 + y,208,34,34 );
	gfx.PutPixel( 18 + x,119 + y,208,34,34 );
	gfx.PutPixel( 19 + x,119 + y,208,34,34 );
	gfx.PutPixel( 20 + x,119 + y,208,34,34 );
	gfx.PutPixel( 21 + x,119 + y,208,34,34 );
	gfx.PutPixel( 22 + x,119 + y,208,34,34 );
	gfx.PutPixel( 23 + x,119 + y,208,34,34 );
	gfx.PutPixel( 24 + x,119 + y,208,34,34 );
	gfx.PutPixel( 25 + x,119 + y,208,34,34 );
	gfx.PutPixel( 26 + x,119 + y,208,34,34 );
	gfx.PutPixel( 27 + x,119 + y,208,34,34 );
	gfx.PutPixel( 28 + x,119 + y,208,34,34 );
	gfx.PutPixel( 29 + x,119 + y,208,34,34 );
	gfx.PutPixel( 30 + x,119 + y,208,34,34 );
	gfx.PutPixel( 31 + x,119 + y,208,34,34 );
	gfx.PutPixel( 32 + x,119 + y,207,22,22 );
	gfx.PutPixel( 33 + x,119 + y,215,128,128 );
	gfx.PutPixel( 34 + x,119 + y,222,233,233 );
	gfx.PutPixel( 35 + x,119 + y,221,225,225 );
	gfx.PutPixel( 36 + x,119 + y,220,207,207 );
	gfx.PutPixel( 37 + x,119 + y,208,36,36 );
	gfx.PutPixel( 38 + x,119 + y,207,18,18 );
	gfx.PutPixel( 39 + x,119 + y,207,22,22 );
	gfx.PutPixel( 40 + x,119 + y,207,22,22 );
	gfx.PutPixel( 41 + x,119 + y,207,22,22 );
	gfx.PutPixel( 42 + x,119 + y,207,22,22 );
	gfx.PutPixel( 43 + x,119 + y,207,21,21 );
	gfx.PutPixel( 44 + x,119 + y,208,29,29 );
	gfx.PutPixel( 45 + x,119 + y,208,35,35 );
	gfx.PutPixel( 46 + x,119 + y,208,34,34 );
	gfx.PutPixel( 47 + x,119 + y,208,34,34 );
	gfx.PutPixel( 48 + x,119 + y,208,34,34 );
	gfx.PutPixel( 49 + x,119 + y,208,34,34 );
	gfx.PutPixel( 50 + x,119 + y,207,22,22 );
	gfx.PutPixel( 51 + x,119 + y,215,138,138 );
	gfx.PutPixel( 52 + x,119 + y,222,233,233 );
	gfx.PutPixel( 53 + x,119 + y,221,224,224 );
	gfx.PutPixel( 54 + x,119 + y,220,203,203 );
	gfx.PutPixel( 55 + x,119 + y,217,158,158 );
	gfx.PutPixel( 56 + x,119 + y,222,228,228 );
	gfx.PutPixel( 57 + x,119 + y,221,221,221 );
	gfx.PutPixel( 58 + x,119 + y,222,229,229 );
	gfx.PutPixel( 59 + x,119 + y,212,92,92 );
	gfx.PutPixel( 60 + x,119 + y,207,24,24 );
	gfx.PutPixel( 61 + x,119 + y,208,34,34 );
	gfx.PutPixel( 62 + x,119 + y,208,34,34 );
	gfx.PutPixel( 63 + x,119 + y,208,34,34 );
	gfx.PutPixel( 64 + x,119 + y,208,34,34 );
	gfx.PutPixel( 65 + x,119 + y,208,34,34 );
	gfx.PutPixel( 66 + x,119 + y,208,27,27 );
	gfx.PutPixel( 67 + x,119 + y,218,173,173 );
	gfx.PutPixel( 68 + x,119 + y,222,230,230 );
	gfx.PutPixel( 69 + x,119 + y,222,230,230 );
	gfx.PutPixel( 70 + x,119 + y,218,173,173 );
	gfx.PutPixel( 71 + x,119 + y,208,27,27 );
	gfx.PutPixel( 72 + x,119 + y,208,34,34 );
	gfx.PutPixel( 73 + x,119 + y,208,34,34 );
	gfx.PutPixel( 74 + x,119 + y,208,34,34 );
	gfx.PutPixel( 75 + x,119 + y,208,34,34 );
	gfx.PutPixel( 76 + x,119 + y,208,34,34 );
	gfx.PutPixel( 77 + x,119 + y,208,34,34 );
	gfx.PutPixel( 78 + x,119 + y,208,34,34 );
	gfx.PutPixel( 79 + x,119 + y,208,34,34 );
	gfx.PutPixel( 80 + x,119 + y,208,34,34 );
	gfx.PutPixel( 81 + x,119 + y,208,34,34 );
	gfx.PutPixel( 82 + x,119 + y,208,34,34 );
	gfx.PutPixel( 83 + x,119 + y,207,22,22 );
	gfx.PutPixel( 84 + x,119 + y,215,128,128 );
	gfx.PutPixel( 85 + x,119 + y,222,233,233 );
	gfx.PutPixel( 86 + x,119 + y,221,225,225 );
	gfx.PutPixel( 87 + x,119 + y,220,208,208 );
	gfx.PutPixel( 88 + x,119 + y,209,47,47 );
	gfx.PutPixel( 89 + x,119 + y,208,30,30 );
	gfx.PutPixel( 90 + x,119 + y,208,34,34 );
	gfx.PutPixel( 91 + x,119 + y,208,34,34 );
	gfx.PutPixel( 92 + x,119 + y,208,33,33 );
	gfx.PutPixel( 93 + x,119 + y,207,25,25 );
	gfx.PutPixel( 94 + x,119 + y,207,29,29 );
	gfx.PutPixel( 95 + x,119 + y,217,164,164 );
	gfx.PutPixel( 96 + x,119 + y,222,230,230 );
	gfx.PutPixel( 97 + x,119 + y,221,221,221 );
	gfx.PutPixel( 98 + x,119 + y,222,229,229 );
	gfx.PutPixel( 99 + x,119 + y,218,180,180 );
	gfx.PutPixel( 100 + x,119 + y,208,31,31 );
	gfx.PutPixel( 101 + x,119 + y,208,33,33 );
	gfx.PutPixel( 102 + x,119 + y,208,34,34 );
	gfx.PutPixel( 103 + x,119 + y,208,34,34 );
	gfx.PutPixel( 104 + x,119 + y,208,29,29 );
	gfx.PutPixel( 105 + x,119 + y,209,55,55 );
	gfx.PutPixel( 106 + x,119 + y,220,213,213 );
	gfx.PutPixel( 107 + x,119 + y,221,224,224 );
	gfx.PutPixel( 108 + x,119 + y,222,228,228 );
	gfx.PutPixel( 109 + x,119 + y,217,159,159 );
	gfx.PutPixel( 110 + x,119 + y,220,200,200 );
	gfx.PutPixel( 111 + x,119 + y,221,224,224 );
	gfx.PutPixel( 112 + x,119 + y,222,229,229 );
	gfx.PutPixel( 113 + x,119 + y,218,181,181 );
	gfx.PutPixel( 114 + x,119 + y,208,31,31 );
	gfx.PutPixel( 115 + x,119 + y,208,33,33 );
	gfx.PutPixel( 116 + x,119 + y,208,34,34 );
	gfx.PutPixel( 117 + x,119 + y,208,34,34 );
	gfx.PutPixel( 118 + x,119 + y,208,34,34 );
	gfx.PutPixel( 119 + x,119 + y,208,34,34 );
	gfx.PutPixel( 120 + x,119 + y,208,34,34 );
	gfx.PutPixel( 121 + x,119 + y,208,34,34 );
	gfx.PutPixel( 122 + x,119 + y,208,34,34 );
	gfx.PutPixel( 123 + x,119 + y,208,34,34 );
	gfx.PutPixel( 124 + x,119 + y,208,34,34 );
	gfx.PutPixel( 125 + x,119 + y,208,34,34 );
	gfx.PutPixel( 126 + x,119 + y,208,34,34 );
	gfx.PutPixel( 127 + x,119 + y,208,34,34 );
	gfx.PutPixel( 128 + x,119 + y,208,34,34 );
	gfx.PutPixel( 129 + x,119 + y,208,34,34 );
	gfx.PutPixel( 130 + x,119 + y,208,34,34 );
	gfx.PutPixel( 131 + x,119 + y,208,34,34 );
	gfx.PutPixel( 132 + x,119 + y,208,34,34 );
	gfx.PutPixel( 133 + x,119 + y,208,34,34 );
	gfx.PutPixel( 134 + x,119 + y,208,34,34 );
	gfx.PutPixel( 135 + x,119 + y,208,34,34 );
	gfx.PutPixel( 136 + x,119 + y,208,34,34 );
	gfx.PutPixel( 137 + x,119 + y,208,34,34 );
	gfx.PutPixel( 138 + x,119 + y,208,34,34 );
	gfx.PutPixel( 139 + x,119 + y,208,34,34 );
	gfx.PutPixel( 140 + x,119 + y,208,34,34 );
	gfx.PutPixel( 141 + x,119 + y,208,34,34 );
	gfx.PutPixel( 142 + x,119 + y,208,34,34 );
	gfx.PutPixel( 143 + x,119 + y,208,34,34 );
	gfx.PutPixel( 144 + x,119 + y,208,34,34 );
	gfx.PutPixel( 145 + x,119 + y,208,34,34 );
	gfx.PutPixel( 146 + x,119 + y,208,34,34 );
	gfx.PutPixel( 147 + x,119 + y,208,34,34 );
	gfx.PutPixel( 148 + x,119 + y,208,34,34 );
	gfx.PutPixel( 149 + x,119 + y,208,34,34 );
	gfx.PutPixel( 0 + x,120 + y,208,34,34 );
	gfx.PutPixel( 1 + x,120 + y,208,34,34 );
	gfx.PutPixel( 2 + x,120 + y,208,34,34 );
	gfx.PutPixel( 3 + x,120 + y,208,34,34 );
	gfx.PutPixel( 4 + x,120 + y,208,34,34 );
	gfx.PutPixel( 5 + x,120 + y,208,34,34 );
	gfx.PutPixel( 6 + x,120 + y,208,34,34 );
	gfx.PutPixel( 7 + x,120 + y,208,34,34 );
	gfx.PutPixel( 8 + x,120 + y,208,34,34 );
	gfx.PutPixel( 9 + x,120 + y,208,34,34 );
	gfx.PutPixel( 10 + x,120 + y,208,34,34 );
	gfx.PutPixel( 11 + x,120 + y,208,34,34 );
	gfx.PutPixel( 12 + x,120 + y,208,34,34 );
	gfx.PutPixel( 13 + x,120 + y,208,34,34 );
	gfx.PutPixel( 14 + x,120 + y,208,34,34 );
	gfx.PutPixel( 15 + x,120 + y,208,34,34 );
	gfx.PutPixel( 16 + x,120 + y,208,34,34 );
	gfx.PutPixel( 17 + x,120 + y,208,34,34 );
	gfx.PutPixel( 18 + x,120 + y,208,34,34 );
	gfx.PutPixel( 19 + x,120 + y,208,34,34 );
	gfx.PutPixel( 20 + x,120 + y,208,34,34 );
	gfx.PutPixel( 21 + x,120 + y,208,34,34 );
	gfx.PutPixel( 22 + x,120 + y,208,34,34 );
	gfx.PutPixel( 23 + x,120 + y,208,34,34 );
	gfx.PutPixel( 24 + x,120 + y,208,34,34 );
	gfx.PutPixel( 25 + x,120 + y,208,34,34 );
	gfx.PutPixel( 26 + x,120 + y,208,34,34 );
	gfx.PutPixel( 27 + x,120 + y,208,34,34 );
	gfx.PutPixel( 28 + x,120 + y,208,34,34 );
	gfx.PutPixel( 29 + x,120 + y,208,34,34 );
	gfx.PutPixel( 30 + x,120 + y,208,34,34 );
	gfx.PutPixel( 31 + x,120 + y,208,34,34 );
	gfx.PutPixel( 32 + x,120 + y,207,22,22 );
	gfx.PutPixel( 33 + x,120 + y,215,128,128 );
	gfx.PutPixel( 34 + x,120 + y,222,233,233 );
	gfx.PutPixel( 35 + x,120 + y,221,223,223 );
	gfx.PutPixel( 36 + x,120 + y,221,215,215 );
	gfx.PutPixel( 37 + x,120 + y,215,134,134 );
	gfx.PutPixel( 38 + x,120 + y,215,126,126 );
	gfx.PutPixel( 39 + x,120 + y,215,128,128 );
	gfx.PutPixel( 40 + x,120 + y,215,128,128 );
	gfx.PutPixel( 41 + x,120 + y,215,128,128 );
	gfx.PutPixel( 42 + x,120 + y,215,128,128 );
	gfx.PutPixel( 43 + x,120 + y,215,132,132 );
	gfx.PutPixel( 44 + x,120 + y,211,69,69 );
	gfx.PutPixel( 45 + x,120 + y,208,29,29 );
	gfx.PutPixel( 46 + x,120 + y,208,34,34 );
	gfx.PutPixel( 47 + x,120 + y,208,34,34 );
	gfx.PutPixel( 48 + x,120 + y,208,34,34 );
	gfx.PutPixel( 49 + x,120 + y,208,30,30 );
	gfx.PutPixel( 50 + x,120 + y,209,47,47 );
	gfx.PutPixel( 51 + x,120 + y,220,206,206 );
	gfx.PutPixel( 52 + x,120 + y,221,225,225 );
	gfx.PutPixel( 53 + x,120 + y,222,232,232 );
	gfx.PutPixel( 54 + x,120 + y,216,151,151 );
	gfx.PutPixel( 55 + x,120 + y,209,56,56 );
	gfx.PutPixel( 56 + x,120 + y,221,219,219 );
	gfx.PutPixel( 57 + x,120 + y,221,223,223 );
	gfx.PutPixel( 58 + x,120 + y,222,231,231 );
	gfx.PutPixel( 59 + x,120 + y,217,170,170 );
	gfx.PutPixel( 60 + x,120 + y,207,28,28 );
	gfx.PutPixel( 61 + x,120 + y,208,33,33 );
	gfx.PutPixel( 62 + x,120 + y,208,34,34 );
	gfx.PutPixel( 63 + x,120 + y,208,34,34 );
	gfx.PutPixel( 64 + x,120 + y,208,34,34 );
	gfx.PutPixel( 65 + x,120 + y,208,34,34 );
	gfx.PutPixel( 66 + x,120 + y,208,27,27 );
	gfx.PutPixel( 67 + x,120 + y,218,173,173 );
	gfx.PutPixel( 68 + x,120 + y,222,230,230 );
	gfx.PutPixel( 69 + x,120 + y,222,230,230 );
	gfx.PutPixel( 70 + x,120 + y,218,173,173 );
	gfx.PutPixel( 71 + x,120 + y,208,27,27 );
	gfx.PutPixel( 72 + x,120 + y,208,34,34 );
	gfx.PutPixel( 73 + x,120 + y,208,34,34 );
	gfx.PutPixel( 74 + x,120 + y,208,34,34 );
	gfx.PutPixel( 75 + x,120 + y,208,34,34 );
	gfx.PutPixel( 76 + x,120 + y,208,34,34 );
	gfx.PutPixel( 77 + x,120 + y,208,34,34 );
	gfx.PutPixel( 78 + x,120 + y,208,34,34 );
	gfx.PutPixel( 79 + x,120 + y,208,34,34 );
	gfx.PutPixel( 80 + x,120 + y,208,34,34 );
	gfx.PutPixel( 81 + x,120 + y,208,34,34 );
	gfx.PutPixel( 82 + x,120 + y,208,34,34 );
	gfx.PutPixel( 83 + x,120 + y,207,22,22 );
	gfx.PutPixel( 84 + x,120 + y,215,128,128 );
	gfx.PutPixel( 85 + x,120 + y,222,233,233 );
	gfx.PutPixel( 86 + x,120 + y,221,225,225 );
	gfx.PutPixel( 87 + x,120 + y,220,208,208 );
	gfx.PutPixel( 88 + x,120 + y,209,47,47 );
	gfx.PutPixel( 89 + x,120 + y,208,30,30 );
	gfx.PutPixel( 90 + x,120 + y,208,34,34 );
	gfx.PutPixel( 91 + x,120 + y,208,34,34 );
	gfx.PutPixel( 92 + x,120 + y,208,34,34 );
	gfx.PutPixel( 93 + x,120 + y,208,34,34 );
	gfx.PutPixel( 94 + x,120 + y,208,25,25 );
	gfx.PutPixel( 95 + x,120 + y,210,61,61 );
	gfx.PutPixel( 96 + x,120 + y,221,216,216 );
	gfx.PutPixel( 97 + x,120 + y,221,223,223 );
	gfx.PutPixel( 98 + x,120 + y,221,224,224 );
	gfx.PutPixel( 99 + x,120 + y,221,213,213 );
	gfx.PutPixel( 100 + x,120 + y,209,56,56 );
	gfx.PutPixel( 101 + x,120 + y,208,29,29 );
	gfx.PutPixel( 102 + x,120 + y,208,34,34 );
	gfx.PutPixel( 103 + x,120 + y,208,34,34 );
	gfx.PutPixel( 104 + x,120 + y,207,22,22 );
	gfx.PutPixel( 105 + x,120 + y,214,125,125 );
	gfx.PutPixel( 106 + x,120 + y,222,233,233 );
	gfx.PutPixel( 107 + x,120 + y,221,222,222 );
	gfx.PutPixel( 108 + x,120 + y,221,222,222 );
	gfx.PutPixel( 109 + x,120 + y,210,59,59 );
	gfx.PutPixel( 110 + x,120 + y,216,145,145 );
	gfx.PutPixel( 111 + x,120 + y,222,232,232 );
	gfx.PutPixel( 112 + x,120 + y,221,222,222 );
	gfx.PutPixel( 113 + x,120 + y,222,227,227 );
	gfx.PutPixel( 114 + x,120 + y,211,82,82 );
	gfx.PutPixel( 115 + x,120 + y,207,25,25 );
	gfx.PutPixel( 116 + x,120 + y,208,34,34 );
	gfx.PutPixel( 117 + x,120 + y,208,34,34 );
	gfx.PutPixel( 118 + x,120 + y,208,34,34 );
	gfx.PutPixel( 119 + x,120 + y,208,34,34 );
	gfx.PutPixel( 120 + x,120 + y,208,34,34 );
	gfx.PutPixel( 121 + x,120 + y,208,34,34 );
	gfx.PutPixel( 122 + x,120 + y,208,34,34 );
	gfx.PutPixel( 123 + x,120 + y,208,34,34 );
	gfx.PutPixel( 124 + x,120 + y,208,34,34 );
	gfx.PutPixel( 125 + x,120 + y,208,34,34 );
	gfx.PutPixel( 126 + x,120 + y,208,34,34 );
	gfx.PutPixel( 127 + x,120 + y,208,34,34 );
	gfx.PutPixel( 128 + x,120 + y,208,34,34 );
	gfx.PutPixel( 129 + x,120 + y,208,34,34 );
	gfx.PutPixel( 130 + x,120 + y,208,34,34 );
	gfx.PutPixel( 131 + x,120 + y,208,34,34 );
	gfx.PutPixel( 132 + x,120 + y,208,34,34 );
	gfx.PutPixel( 133 + x,120 + y,208,34,34 );
	gfx.PutPixel( 134 + x,120 + y,208,34,34 );
	gfx.PutPixel( 135 + x,120 + y,208,34,34 );
	gfx.PutPixel( 136 + x,120 + y,208,34,34 );
	gfx.PutPixel( 137 + x,120 + y,208,34,34 );
	gfx.PutPixel( 138 + x,120 + y,208,34,34 );
	gfx.PutPixel( 139 + x,120 + y,208,34,34 );
	gfx.PutPixel( 140 + x,120 + y,208,34,34 );
	gfx.PutPixel( 141 + x,120 + y,208,34,34 );
	gfx.PutPixel( 142 + x,120 + y,208,34,34 );
	gfx.PutPixel( 143 + x,120 + y,208,34,34 );
	gfx.PutPixel( 144 + x,120 + y,208,34,34 );
	gfx.PutPixel( 145 + x,120 + y,208,34,34 );
	gfx.PutPixel( 146 + x,120 + y,208,34,34 );
	gfx.PutPixel( 147 + x,120 + y,208,34,34 );
	gfx.PutPixel( 148 + x,120 + y,208,34,34 );
	gfx.PutPixel( 149 + x,120 + y,208,34,34 );
	gfx.PutPixel( 0 + x,121 + y,208,34,34 );
	gfx.PutPixel( 1 + x,121 + y,208,34,34 );
	gfx.PutPixel( 2 + x,121 + y,208,34,34 );
	gfx.PutPixel( 3 + x,121 + y,208,34,34 );
	gfx.PutPixel( 4 + x,121 + y,208,34,34 );
	gfx.PutPixel( 5 + x,121 + y,208,34,34 );
	gfx.PutPixel( 6 + x,121 + y,208,34,34 );
	gfx.PutPixel( 7 + x,121 + y,208,34,34 );
	gfx.PutPixel( 8 + x,121 + y,208,34,34 );
	gfx.PutPixel( 9 + x,121 + y,208,34,34 );
	gfx.PutPixel( 10 + x,121 + y,208,34,34 );
	gfx.PutPixel( 11 + x,121 + y,208,34,34 );
	gfx.PutPixel( 12 + x,121 + y,208,34,34 );
	gfx.PutPixel( 13 + x,121 + y,208,34,34 );
	gfx.PutPixel( 14 + x,121 + y,208,34,34 );
	gfx.PutPixel( 15 + x,121 + y,208,34,34 );
	gfx.PutPixel( 16 + x,121 + y,208,34,34 );
	gfx.PutPixel( 17 + x,121 + y,208,34,34 );
	gfx.PutPixel( 18 + x,121 + y,208,34,34 );
	gfx.PutPixel( 19 + x,121 + y,208,34,34 );
	gfx.PutPixel( 20 + x,121 + y,208,34,34 );
	gfx.PutPixel( 21 + x,121 + y,208,34,34 );
	gfx.PutPixel( 22 + x,121 + y,208,34,34 );
	gfx.PutPixel( 23 + x,121 + y,208,34,34 );
	gfx.PutPixel( 24 + x,121 + y,208,34,34 );
	gfx.PutPixel( 25 + x,121 + y,208,34,34 );
	gfx.PutPixel( 26 + x,121 + y,208,34,34 );
	gfx.PutPixel( 27 + x,121 + y,208,34,34 );
	gfx.PutPixel( 28 + x,121 + y,208,34,34 );
	gfx.PutPixel( 29 + x,121 + y,208,34,34 );
	gfx.PutPixel( 30 + x,121 + y,208,34,34 );
	gfx.PutPixel( 31 + x,121 + y,208,34,34 );
	gfx.PutPixel( 32 + x,121 + y,207,22,22 );
	gfx.PutPixel( 33 + x,121 + y,215,128,128 );
	gfx.PutPixel( 34 + x,121 + y,222,233,233 );
	gfx.PutPixel( 35 + x,121 + y,221,221,221 );
	gfx.PutPixel( 36 + x,121 + y,221,222,222 );
	gfx.PutPixel( 37 + x,121 + y,222,232,232 );
	gfx.PutPixel( 38 + x,121 + y,222,233,233 );
	gfx.PutPixel( 39 + x,121 + y,222,233,233 );
	gfx.PutPixel( 40 + x,121 + y,222,233,233 );
	gfx.PutPixel( 41 + x,121 + y,222,233,233 );
	gfx.PutPixel( 42 + x,121 + y,222,233,233 );
	gfx.PutPixel( 43 + x,121 + y,223,243,243 );
	gfx.PutPixel( 44 + x,121 + y,213,109,109 );
	gfx.PutPixel( 45 + x,121 + y,207,23,23 );
	gfx.PutPixel( 46 + x,121 + y,208,34,34 );
	gfx.PutPixel( 47 + x,121 + y,208,34,34 );
	gfx.PutPixel( 48 + x,121 + y,208,34,34 );
	gfx.PutPixel( 49 + x,121 + y,207,22,22 );
	gfx.PutPixel( 50 + x,121 + y,213,113,113 );
	gfx.PutPixel( 51 + x,121 + y,222,232,232 );
	gfx.PutPixel( 52 + x,121 + y,221,222,222 );
	gfx.PutPixel( 53 + x,121 + y,222,228,228 );
	gfx.PutPixel( 54 + x,121 + y,212,86,86 );
	gfx.PutPixel( 55 + x,121 + y,207,18,18 );
	gfx.PutPixel( 56 + x,121 + y,218,171,171 );
	gfx.PutPixel( 57 + x,121 + y,222,230,230 );
	gfx.PutPixel( 58 + x,121 + y,221,222,222 );
	gfx.PutPixel( 59 + x,121 + y,221,223,223 );
	gfx.PutPixel( 60 + x,121 + y,211,71,71 );
	gfx.PutPixel( 61 + x,121 + y,207,26,26 );
	gfx.PutPixel( 62 + x,121 + y,208,34,34 );
	gfx.PutPixel( 63 + x,121 + y,208,34,34 );
	gfx.PutPixel( 64 + x,121 + y,208,34,34 );
	gfx.PutPixel( 65 + x,121 + y,208,34,34 );
	gfx.PutPixel( 66 + x,121 + y,208,27,27 );
	gfx.PutPixel( 67 + x,121 + y,218,173,173 );
	gfx.PutPixel( 68 + x,121 + y,222,230,230 );
	gfx.PutPixel( 69 + x,121 + y,222,230,230 );
	gfx.PutPixel( 70 + x,121 + y,218,173,173 );
	gfx.PutPixel( 71 + x,121 + y,208,27,27 );
	gfx.PutPixel( 72 + x,121 + y,208,34,34 );
	gfx.PutPixel( 73 + x,121 + y,208,34,34 );
	gfx.PutPixel( 74 + x,121 + y,208,34,34 );
	gfx.PutPixel( 75 + x,121 + y,208,34,34 );
	gfx.PutPixel( 76 + x,121 + y,208,34,34 );
	gfx.PutPixel( 77 + x,121 + y,208,34,34 );
	gfx.PutPixel( 78 + x,121 + y,208,34,34 );
	gfx.PutPixel( 79 + x,121 + y,208,34,34 );
	gfx.PutPixel( 80 + x,121 + y,208,34,34 );
	gfx.PutPixel( 81 + x,121 + y,208,34,34 );
	gfx.PutPixel( 82 + x,121 + y,208,34,34 );
	gfx.PutPixel( 83 + x,121 + y,207,22,22 );
	gfx.PutPixel( 84 + x,121 + y,215,128,128 );
	gfx.PutPixel( 85 + x,121 + y,222,233,233 );
	gfx.PutPixel( 86 + x,121 + y,221,225,225 );
	gfx.PutPixel( 87 + x,121 + y,220,208,208 );
	gfx.PutPixel( 88 + x,121 + y,209,47,47 );
	gfx.PutPixel( 89 + x,121 + y,208,30,30 );
	gfx.PutPixel( 90 + x,121 + y,208,34,34 );
	gfx.PutPixel( 91 + x,121 + y,208,34,34 );
	gfx.PutPixel( 92 + x,121 + y,208,34,34 );
	gfx.PutPixel( 93 + x,121 + y,208,34,34 );
	gfx.PutPixel( 94 + x,121 + y,208,33,33 );
	gfx.PutPixel( 95 + x,121 + y,208,31,31 );
	gfx.PutPixel( 96 + x,121 + y,218,183,183 );
	gfx.PutPixel( 97 + x,121 + y,222,228,228 );
	gfx.PutPixel( 98 + x,121 + y,221,222,222 );
	gfx.PutPixel( 99 + x,121 + y,221,224,224 );
	gfx.PutPixel( 100 + x,121 + y,211,75,75 );
	gfx.PutPixel( 101 + x,121 + y,207,26,26 );
	gfx.PutPixel( 102 + x,121 + y,208,34,34 );
	gfx.PutPixel( 103 + x,121 + y,208,31,31 );
	gfx.PutPixel( 104 + x,121 + y,209,40,40 );
	gfx.PutPixel( 105 + x,121 + y,220,197,197 );
	gfx.PutPixel( 106 + x,121 + y,221,226,226 );
	gfx.PutPixel( 107 + x,121 + y,222,229,229 );
	gfx.PutPixel( 108 + x,121 + y,218,176,176 );
	gfx.PutPixel( 109 + x,121 + y,207,20,20 );
	gfx.PutPixel( 110 + x,121 + y,211,81,81 );
	gfx.PutPixel( 111 + x,121 + y,222,227,227 );
	gfx.PutPixel( 112 + x,121 + y,221,221,221 );
	gfx.PutPixel( 113 + x,121 + y,222,232,232 );
	gfx.PutPixel( 114 + x,121 + y,217,159,159 );
	gfx.PutPixel( 115 + x,121 + y,207,25,25 );
	gfx.PutPixel( 116 + x,121 + y,208,34,34 );
	gfx.PutPixel( 117 + x,121 + y,208,34,34 );
	gfx.PutPixel( 118 + x,121 + y,208,34,34 );
	gfx.PutPixel( 119 + x,121 + y,208,34,34 );
	gfx.PutPixel( 120 + x,121 + y,208,34,34 );
	gfx.PutPixel( 121 + x,121 + y,208,34,34 );
	gfx.PutPixel( 122 + x,121 + y,208,34,34 );
	gfx.PutPixel( 123 + x,121 + y,208,34,34 );
	gfx.PutPixel( 124 + x,121 + y,208,34,34 );
	gfx.PutPixel( 125 + x,121 + y,208,34,34 );
	gfx.PutPixel( 126 + x,121 + y,208,34,34 );
	gfx.PutPixel( 127 + x,121 + y,208,34,34 );
	gfx.PutPixel( 128 + x,121 + y,208,34,34 );
	gfx.PutPixel( 129 + x,121 + y,208,34,34 );
	gfx.PutPixel( 130 + x,121 + y,208,34,34 );
	gfx.PutPixel( 131 + x,121 + y,208,34,34 );
	gfx.PutPixel( 132 + x,121 + y,208,34,34 );
	gfx.PutPixel( 133 + x,121 + y,208,34,34 );
	gfx.PutPixel( 134 + x,121 + y,208,34,34 );
	gfx.PutPixel( 135 + x,121 + y,208,34,34 );
	gfx.PutPixel( 136 + x,121 + y,208,34,34 );
	gfx.PutPixel( 137 + x,121 + y,208,34,34 );
	gfx.PutPixel( 138 + x,121 + y,208,34,34 );
	gfx.PutPixel( 139 + x,121 + y,208,34,34 );
	gfx.PutPixel( 140 + x,121 + y,208,34,34 );
	gfx.PutPixel( 141 + x,121 + y,208,34,34 );
	gfx.PutPixel( 142 + x,121 + y,208,34,34 );
	gfx.PutPixel( 143 + x,121 + y,208,34,34 );
	gfx.PutPixel( 144 + x,121 + y,208,34,34 );
	gfx.PutPixel( 145 + x,121 + y,208,34,34 );
	gfx.PutPixel( 146 + x,121 + y,208,34,34 );
	gfx.PutPixel( 147 + x,121 + y,208,34,34 );
	gfx.PutPixel( 148 + x,121 + y,208,34,34 );
	gfx.PutPixel( 149 + x,121 + y,208,34,34 );
	gfx.PutPixel( 0 + x,122 + y,208,34,34 );
	gfx.PutPixel( 1 + x,122 + y,208,34,34 );
	gfx.PutPixel( 2 + x,122 + y,208,34,34 );
	gfx.PutPixel( 3 + x,122 + y,208,34,34 );
	gfx.PutPixel( 4 + x,122 + y,208,34,34 );
	gfx.PutPixel( 5 + x,122 + y,208,34,34 );
	gfx.PutPixel( 6 + x,122 + y,208,34,34 );
	gfx.PutPixel( 7 + x,122 + y,208,34,34 );
	gfx.PutPixel( 8 + x,122 + y,208,34,34 );
	gfx.PutPixel( 9 + x,122 + y,208,34,34 );
	gfx.PutPixel( 10 + x,122 + y,208,34,34 );
	gfx.PutPixel( 11 + x,122 + y,208,34,34 );
	gfx.PutPixel( 12 + x,122 + y,208,34,34 );
	gfx.PutPixel( 13 + x,122 + y,208,34,34 );
	gfx.PutPixel( 14 + x,122 + y,208,34,34 );
	gfx.PutPixel( 15 + x,122 + y,208,34,34 );
	gfx.PutPixel( 16 + x,122 + y,208,34,34 );
	gfx.PutPixel( 17 + x,122 + y,208,34,34 );
	gfx.PutPixel( 18 + x,122 + y,208,34,34 );
	gfx.PutPixel( 19 + x,122 + y,208,34,34 );
	gfx.PutPixel( 20 + x,122 + y,208,34,34 );
	gfx.PutPixel( 21 + x,122 + y,208,34,34 );
	gfx.PutPixel( 22 + x,122 + y,208,34,34 );
	gfx.PutPixel( 23 + x,122 + y,208,34,34 );
	gfx.PutPixel( 24 + x,122 + y,208,34,34 );
	gfx.PutPixel( 25 + x,122 + y,208,34,34 );
	gfx.PutPixel( 26 + x,122 + y,208,34,34 );
	gfx.PutPixel( 27 + x,122 + y,208,34,34 );
	gfx.PutPixel( 28 + x,122 + y,208,34,34 );
	gfx.PutPixel( 29 + x,122 + y,208,34,34 );
	gfx.PutPixel( 30 + x,122 + y,208,34,34 );
	gfx.PutPixel( 31 + x,122 + y,208,34,34 );
	gfx.PutPixel( 32 + x,122 + y,207,22,22 );
	gfx.PutPixel( 33 + x,122 + y,215,128,128 );
	gfx.PutPixel( 34 + x,122 + y,222,233,233 );
	gfx.PutPixel( 35 + x,122 + y,221,221,221 );
	gfx.PutPixel( 36 + x,122 + y,221,221,221 );
	gfx.PutPixel( 37 + x,122 + y,221,224,224 );
	gfx.PutPixel( 38 + x,122 + y,221,225,225 );
	gfx.PutPixel( 39 + x,122 + y,221,225,225 );
	gfx.PutPixel( 40 + x,122 + y,221,225,225 );
	gfx.PutPixel( 41 + x,122 + y,221,225,225 );
	gfx.PutPixel( 42 + x,122 + y,221,225,225 );
	gfx.PutPixel( 43 + x,122 + y,222,234,234 );
	gfx.PutPixel( 44 + x,122 + y,213,105,105 );
	gfx.PutPixel( 45 + x,122 + y,207,24,24 );
	gfx.PutPixel( 46 + x,122 + y,208,34,34 );
	gfx.PutPixel( 47 + x,122 + y,208,34,34 );
	gfx.PutPixel( 48 + x,122 + y,208,32,32 );
	gfx.PutPixel( 49 + x,122 + y,208,34,34 );
	gfx.PutPixel( 50 + x,122 + y,219,188,188 );
	gfx.PutPixel( 51 + x,122 + y,222,228,228 );
	gfx.PutPixel( 52 + x,122 + y,221,227,227 );
	gfx.PutPixel( 53 + x,122 + y,219,191,191 );
	gfx.PutPixel( 54 + x,122 + y,208,36,36 );
	gfx.PutPixel( 55 + x,122 + y,207,21,21 );
	gfx.PutPixel( 56 + x,122 + y,213,99,99 );
	gfx.PutPixel( 57 + x,122 + y,222,231,231 );
	gfx.PutPixel( 58 + x,122 + y,221,221,221 );
	gfx.PutPixel( 59 + x,122 + y,222,232,232 );
	gfx.PutPixel( 60 + x,122 + y,216,148,148 );
	gfx.PutPixel( 61 + x,122 + y,207,23,23 );
	gfx.PutPixel( 62 + x,122 + y,208,34,34 );
	gfx.PutPixel( 63 + x,122 + y,208,34,34 );
	gfx.PutPixel( 64 + x,122 + y,208,34,34 );
	gfx.PutPixel( 65 + x,122 + y,208,34,34 );
	gfx.PutPixel( 66 + x,122 + y,208,27,27 );
	gfx.PutPixel( 67 + x,122 + y,218,173,173 );
	gfx.PutPixel( 68 + x,122 + y,222,230,230 );
	gfx.PutPixel( 69 + x,122 + y,222,230,230 );
	gfx.PutPixel( 70 + x,122 + y,218,173,173 );
	gfx.PutPixel( 71 + x,122 + y,208,27,27 );
	gfx.PutPixel( 72 + x,122 + y,208,34,34 );
	gfx.PutPixel( 73 + x,122 + y,208,34,34 );
	gfx.PutPixel( 74 + x,122 + y,208,34,34 );
	gfx.PutPixel( 75 + x,122 + y,208,34,34 );
	gfx.PutPixel( 76 + x,122 + y,208,34,34 );
	gfx.PutPixel( 77 + x,122 + y,208,34,34 );
	gfx.PutPixel( 78 + x,122 + y,208,34,34 );
	gfx.PutPixel( 79 + x,122 + y,208,34,34 );
	gfx.PutPixel( 80 + x,122 + y,208,34,34 );
	gfx.PutPixel( 81 + x,122 + y,208,34,34 );
	gfx.PutPixel( 82 + x,122 + y,208,34,34 );
	gfx.PutPixel( 83 + x,122 + y,207,22,22 );
	gfx.PutPixel( 84 + x,122 + y,215,128,128 );
	gfx.PutPixel( 85 + x,122 + y,222,233,233 );
	gfx.PutPixel( 86 + x,122 + y,221,225,225 );
	gfx.PutPixel( 87 + x,122 + y,220,208,208 );
	gfx.PutPixel( 88 + x,122 + y,209,47,47 );
	gfx.PutPixel( 89 + x,122 + y,208,30,30 );
	gfx.PutPixel( 90 + x,122 + y,208,34,34 );
	gfx.PutPixel( 91 + x,122 + y,208,34,34 );
	gfx.PutPixel( 92 + x,122 + y,208,34,34 );
	gfx.PutPixel( 93 + x,122 + y,208,34,34 );
	gfx.PutPixel( 94 + x,122 + y,208,33,33 );
	gfx.PutPixel( 95 + x,122 + y,208,27,27 );
	gfx.PutPixel( 96 + x,122 + y,218,173,173 );
	gfx.PutPixel( 97 + x,122 + y,222,230,230 );
	gfx.PutPixel( 98 + x,122 + y,221,222,222 );
	gfx.PutPixel( 99 + x,122 + y,221,227,227 );
	gfx.PutPixel( 100 + x,122 + y,211,82,82 );
	gfx.PutPixel( 101 + x,122 + y,207,25,25 );
	gfx.PutPixel( 102 + x,122 + y,208,34,34 );
	gfx.PutPixel( 103 + x,122 + y,207,23,23 );
	gfx.PutPixel( 104 + x,122 + y,213,101,101 );
	gfx.PutPixel( 105 + x,122 + y,222,231,231 );
	gfx.PutPixel( 106 + x,122 + y,221,222,222 );
	gfx.PutPixel( 107 + x,122 + y,222,231,231 );
	gfx.PutPixel( 108 + x,122 + y,213,105,105 );
	gfx.PutPixel( 109 + x,122 + y,207,21,21 );
	gfx.PutPixel( 110 + x,122 + y,208,33,33 );
	gfx.PutPixel( 111 + x,122 + y,219,186,186 );
	gfx.PutPixel( 112 + x,122 + y,222,228,228 );
	gfx.PutPixel( 113 + x,122 + y,221,223,223 );
	gfx.PutPixel( 114 + x,122 + y,221,218,218 );
	gfx.PutPixel( 115 + x,122 + y,210,62,62 );
	gfx.PutPixel( 116 + x,122 + y,208,28,28 );
	gfx.PutPixel( 117 + x,122 + y,208,34,34 );
	gfx.PutPixel( 118 + x,122 + y,208,34,34 );
	gfx.PutPixel( 119 + x,122 + y,208,34,34 );
	gfx.PutPixel( 120 + x,122 + y,208,34,34 );
	gfx.PutPixel( 121 + x,122 + y,208,34,34 );
	gfx.PutPixel( 122 + x,122 + y,208,34,34 );
	gfx.PutPixel( 123 + x,122 + y,208,34,34 );
	gfx.PutPixel( 124 + x,122 + y,208,34,34 );
	gfx.PutPixel( 125 + x,122 + y,208,34,34 );
	gfx.PutPixel( 126 + x,122 + y,208,34,34 );
	gfx.PutPixel( 127 + x,122 + y,208,34,34 );
	gfx.PutPixel( 128 + x,122 + y,208,34,34 );
	gfx.PutPixel( 129 + x,122 + y,208,34,34 );
	gfx.PutPixel( 130 + x,122 + y,208,34,34 );
	gfx.PutPixel( 131 + x,122 + y,208,34,34 );
	gfx.PutPixel( 132 + x,122 + y,208,34,34 );
	gfx.PutPixel( 133 + x,122 + y,208,34,34 );
	gfx.PutPixel( 134 + x,122 + y,208,34,34 );
	gfx.PutPixel( 135 + x,122 + y,208,34,34 );
	gfx.PutPixel( 136 + x,122 + y,208,34,34 );
	gfx.PutPixel( 137 + x,122 + y,208,34,34 );
	gfx.PutPixel( 138 + x,122 + y,208,34,34 );
	gfx.PutPixel( 139 + x,122 + y,208,34,34 );
	gfx.PutPixel( 140 + x,122 + y,208,34,34 );
	gfx.PutPixel( 141 + x,122 + y,208,34,34 );
	gfx.PutPixel( 142 + x,122 + y,208,34,34 );
	gfx.PutPixel( 143 + x,122 + y,208,34,34 );
	gfx.PutPixel( 144 + x,122 + y,208,34,34 );
	gfx.PutPixel( 145 + x,122 + y,208,34,34 );
	gfx.PutPixel( 146 + x,122 + y,208,34,34 );
	gfx.PutPixel( 147 + x,122 + y,208,34,34 );
	gfx.PutPixel( 148 + x,122 + y,208,34,34 );
	gfx.PutPixel( 149 + x,122 + y,208,34,34 );
	gfx.PutPixel( 0 + x,123 + y,208,34,34 );
	gfx.PutPixel( 1 + x,123 + y,208,34,34 );
	gfx.PutPixel( 2 + x,123 + y,208,34,34 );
	gfx.PutPixel( 3 + x,123 + y,208,34,34 );
	gfx.PutPixel( 4 + x,123 + y,208,34,34 );
	gfx.PutPixel( 5 + x,123 + y,208,34,34 );
	gfx.PutPixel( 6 + x,123 + y,208,34,34 );
	gfx.PutPixel( 7 + x,123 + y,208,34,34 );
	gfx.PutPixel( 8 + x,123 + y,208,34,34 );
	gfx.PutPixel( 9 + x,123 + y,208,34,34 );
	gfx.PutPixel( 10 + x,123 + y,208,34,34 );
	gfx.PutPixel( 11 + x,123 + y,208,34,34 );
	gfx.PutPixel( 12 + x,123 + y,208,34,34 );
	gfx.PutPixel( 13 + x,123 + y,208,34,34 );
	gfx.PutPixel( 14 + x,123 + y,208,34,34 );
	gfx.PutPixel( 15 + x,123 + y,208,34,34 );
	gfx.PutPixel( 16 + x,123 + y,208,34,34 );
	gfx.PutPixel( 17 + x,123 + y,208,34,34 );
	gfx.PutPixel( 18 + x,123 + y,208,34,34 );
	gfx.PutPixel( 19 + x,123 + y,208,34,34 );
	gfx.PutPixel( 20 + x,123 + y,208,34,34 );
	gfx.PutPixel( 21 + x,123 + y,208,34,34 );
	gfx.PutPixel( 22 + x,123 + y,208,34,34 );
	gfx.PutPixel( 23 + x,123 + y,208,34,34 );
	gfx.PutPixel( 24 + x,123 + y,208,34,34 );
	gfx.PutPixel( 25 + x,123 + y,208,34,34 );
	gfx.PutPixel( 26 + x,123 + y,208,34,34 );
	gfx.PutPixel( 27 + x,123 + y,208,34,34 );
	gfx.PutPixel( 28 + x,123 + y,208,34,34 );
	gfx.PutPixel( 29 + x,123 + y,208,34,34 );
	gfx.PutPixel( 30 + x,123 + y,208,34,34 );
	gfx.PutPixel( 31 + x,123 + y,208,34,34 );
	gfx.PutPixel( 32 + x,123 + y,207,22,22 );
	gfx.PutPixel( 33 + x,123 + y,215,128,128 );
	gfx.PutPixel( 34 + x,123 + y,222,233,233 );
	gfx.PutPixel( 35 + x,123 + y,221,221,221 );
	gfx.PutPixel( 36 + x,123 + y,221,220,220 );
	gfx.PutPixel( 37 + x,123 + y,220,209,209 );
	gfx.PutPixel( 38 + x,123 + y,220,207,207 );
	gfx.PutPixel( 39 + x,123 + y,220,208,208 );
	gfx.PutPixel( 40 + x,123 + y,220,208,208 );
	gfx.PutPixel( 41 + x,123 + y,220,208,208 );
	gfx.PutPixel( 42 + x,123 + y,220,208,208 );
	gfx.PutPixel( 43 + x,123 + y,221,216,216 );
	gfx.PutPixel( 44 + x,123 + y,213,99,99 );
	gfx.PutPixel( 45 + x,123 + y,207,25,25 );
	gfx.PutPixel( 46 + x,123 + y,208,34,34 );
	gfx.PutPixel( 47 + x,123 + y,208,34,34 );
	gfx.PutPixel( 48 + x,123 + y,207,24,24 );
	gfx.PutPixel( 49 + x,123 + y,212,88,88 );
	gfx.PutPixel( 50 + x,123 + y,222,229,229 );
	gfx.PutPixel( 51 + x,123 + y,221,222,222 );
	gfx.PutPixel( 52 + x,123 + y,222,232,232 );
	gfx.PutPixel( 53 + x,123 + y,214,118,118 );
	gfx.PutPixel( 54 + x,123 + y,206,15,15 );
	gfx.PutPixel( 55 + x,123 + y,207,24,24 );
	gfx.PutPixel( 56 + x,123 + y,208,36,36 );
	gfx.PutPixel( 57 + x,123 + y,219,196,196 );
	gfx.PutPixel( 58 + x,123 + y,221,226,226 );
	gfx.PutPixel( 59 + x,123 + y,221,224,224 );
	gfx.PutPixel( 60 + x,123 + y,220,212,212 );
	gfx.PutPixel( 61 + x,123 + y,209,53,53 );
	gfx.PutPixel( 62 + x,123 + y,208,29,29 );
	gfx.PutPixel( 63 + x,123 + y,208,34,34 );
	gfx.PutPixel( 64 + x,123 + y,208,34,34 );
	gfx.PutPixel( 65 + x,123 + y,208,34,34 );
	gfx.PutPixel( 66 + x,123 + y,208,27,27 );
	gfx.PutPixel( 67 + x,123 + y,218,173,173 );
	gfx.PutPixel( 68 + x,123 + y,222,230,230 );
	gfx.PutPixel( 69 + x,123 + y,222,230,230 );
	gfx.PutPixel( 70 + x,123 + y,218,173,173 );
	gfx.PutPixel( 71 + x,123 + y,208,27,27 );
	gfx.PutPixel( 72 + x,123 + y,208,34,34 );
	gfx.PutPixel( 73 + x,123 + y,208,34,34 );
	gfx.PutPixel( 74 + x,123 + y,208,34,34 );
	gfx.PutPixel( 75 + x,123 + y,208,34,34 );
	gfx.PutPixel( 76 + x,123 + y,208,34,34 );
	gfx.PutPixel( 77 + x,123 + y,208,34,34 );
	gfx.PutPixel( 78 + x,123 + y,208,34,34 );
	gfx.PutPixel( 79 + x,123 + y,208,34,34 );
	gfx.PutPixel( 80 + x,123 + y,208,34,34 );
	gfx.PutPixel( 81 + x,123 + y,208,34,34 );
	gfx.PutPixel( 82 + x,123 + y,208,34,34 );
	gfx.PutPixel( 83 + x,123 + y,207,22,22 );
	gfx.PutPixel( 84 + x,123 + y,215,128,128 );
	gfx.PutPixel( 85 + x,123 + y,222,233,233 );
	gfx.PutPixel( 86 + x,123 + y,221,225,225 );
	gfx.PutPixel( 87 + x,123 + y,220,208,208 );
	gfx.PutPixel( 88 + x,123 + y,209,47,47 );
	gfx.PutPixel( 89 + x,123 + y,208,30,30 );
	gfx.PutPixel( 90 + x,123 + y,208,34,34 );
	gfx.PutPixel( 91 + x,123 + y,208,34,34 );
	gfx.PutPixel( 92 + x,123 + y,208,34,34 );
	gfx.PutPixel( 93 + x,123 + y,208,34,34 );
	gfx.PutPixel( 94 + x,123 + y,208,33,33 );
	gfx.PutPixel( 95 + x,123 + y,208,33,33 );
	gfx.PutPixel( 96 + x,123 + y,218,187,187 );
	gfx.PutPixel( 97 + x,123 + y,221,228,228 );
	gfx.PutPixel( 98 + x,123 + y,221,222,222 );
	gfx.PutPixel( 99 + x,123 + y,221,224,224 );
	gfx.PutPixel( 100 + x,123 + y,211,75,75 );
	gfx.PutPixel( 101 + x,123 + y,208,26,26 );
	gfx.PutPixel( 102 + x,123 + y,208,33,33 );
	gfx.PutPixel( 103 + x,123 + y,208,30,30 );
	gfx.PutPixel( 104 + x,123 + y,218,177,177 );
	gfx.PutPixel( 105 + x,123 + y,222,230,230 );
	gfx.PutPixel( 106 + x,123 + y,221,226,226 );
	gfx.PutPixel( 107 + x,123 + y,220,201,201 );
	gfx.PutPixel( 108 + x,123 + y,208,39,39 );
	gfx.PutPixel( 109 + x,123 + y,207,23,23 );
	gfx.PutPixel( 110 + x,123 + y,206,15,15 );
	gfx.PutPixel( 111 + x,123 + y,213,111,111 );
	gfx.PutPixel( 112 + x,123 + y,222,231,231 );
	gfx.PutPixel( 113 + x,123 + y,221,221,221 );
	gfx.PutPixel( 114 + x,123 + y,222,233,233 );
	gfx.PutPixel( 115 + x,123 + y,215,136,136 );
	gfx.PutPixel( 116 + x,123 + y,207,22,22 );
	gfx.PutPixel( 117 + x,123 + y,208,34,34 );
	gfx.PutPixel( 118 + x,123 + y,208,34,34 );
	gfx.PutPixel( 119 + x,123 + y,208,34,34 );
	gfx.PutPixel( 120 + x,123 + y,208,34,34 );
	gfx.PutPixel( 121 + x,123 + y,208,34,34 );
	gfx.PutPixel( 122 + x,123 + y,208,34,34 );
	gfx.PutPixel( 123 + x,123 + y,208,34,34 );
	gfx.PutPixel( 124 + x,123 + y,208,34,34 );
	gfx.PutPixel( 125 + x,123 + y,208,34,34 );
	gfx.PutPixel( 126 + x,123 + y,208,34,34 );
	gfx.PutPixel( 127 + x,123 + y,208,34,34 );
	gfx.PutPixel( 128 + x,123 + y,208,34,34 );
	gfx.PutPixel( 129 + x,123 + y,208,34,34 );
	gfx.PutPixel( 130 + x,123 + y,208,34,34 );
	gfx.PutPixel( 131 + x,123 + y,208,34,34 );
	gfx.PutPixel( 132 + x,123 + y,208,34,34 );
	gfx.PutPixel( 133 + x,123 + y,208,34,34 );
	gfx.PutPixel( 134 + x,123 + y,208,34,34 );
	gfx.PutPixel( 135 + x,123 + y,208,34,34 );
	gfx.PutPixel( 136 + x,123 + y,208,34,34 );
	gfx.PutPixel( 137 + x,123 + y,208,34,34 );
	gfx.PutPixel( 138 + x,123 + y,208,34,34 );
	gfx.PutPixel( 139 + x,123 + y,208,34,34 );
	gfx.PutPixel( 140 + x,123 + y,208,34,34 );
	gfx.PutPixel( 141 + x,123 + y,208,34,34 );
	gfx.PutPixel( 142 + x,123 + y,208,34,34 );
	gfx.PutPixel( 143 + x,123 + y,208,34,34 );
	gfx.PutPixel( 144 + x,123 + y,208,34,34 );
	gfx.PutPixel( 145 + x,123 + y,208,34,34 );
	gfx.PutPixel( 146 + x,123 + y,208,34,34 );
	gfx.PutPixel( 147 + x,123 + y,208,34,34 );
	gfx.PutPixel( 148 + x,123 + y,208,34,34 );
	gfx.PutPixel( 149 + x,123 + y,208,34,34 );
	gfx.PutPixel( 0 + x,124 + y,208,34,34 );
	gfx.PutPixel( 1 + x,124 + y,208,34,34 );
	gfx.PutPixel( 2 + x,124 + y,208,34,34 );
	gfx.PutPixel( 3 + x,124 + y,208,34,34 );
	gfx.PutPixel( 4 + x,124 + y,208,34,34 );
	gfx.PutPixel( 5 + x,124 + y,208,34,34 );
	gfx.PutPixel( 6 + x,124 + y,208,34,34 );
	gfx.PutPixel( 7 + x,124 + y,208,34,34 );
	gfx.PutPixel( 8 + x,124 + y,208,34,34 );
	gfx.PutPixel( 9 + x,124 + y,208,34,34 );
	gfx.PutPixel( 10 + x,124 + y,208,34,34 );
	gfx.PutPixel( 11 + x,124 + y,208,34,34 );
	gfx.PutPixel( 12 + x,124 + y,208,34,34 );
	gfx.PutPixel( 13 + x,124 + y,208,34,34 );
	gfx.PutPixel( 14 + x,124 + y,208,34,34 );
	gfx.PutPixel( 15 + x,124 + y,208,34,34 );
	gfx.PutPixel( 16 + x,124 + y,208,34,34 );
	gfx.PutPixel( 17 + x,124 + y,208,34,34 );
	gfx.PutPixel( 18 + x,124 + y,208,34,34 );
	gfx.PutPixel( 19 + x,124 + y,208,34,34 );
	gfx.PutPixel( 20 + x,124 + y,208,34,34 );
	gfx.PutPixel( 21 + x,124 + y,208,34,34 );
	gfx.PutPixel( 22 + x,124 + y,208,34,34 );
	gfx.PutPixel( 23 + x,124 + y,208,34,34 );
	gfx.PutPixel( 24 + x,124 + y,208,34,34 );
	gfx.PutPixel( 25 + x,124 + y,208,34,34 );
	gfx.PutPixel( 26 + x,124 + y,208,34,34 );
	gfx.PutPixel( 27 + x,124 + y,208,34,34 );
	gfx.PutPixel( 28 + x,124 + y,208,34,34 );
	gfx.PutPixel( 29 + x,124 + y,208,34,34 );
	gfx.PutPixel( 30 + x,124 + y,208,34,34 );
	gfx.PutPixel( 31 + x,124 + y,208,34,34 );
	gfx.PutPixel( 32 + x,124 + y,207,22,22 );
	gfx.PutPixel( 33 + x,124 + y,215,128,128 );
	gfx.PutPixel( 34 + x,124 + y,222,233,233 );
	gfx.PutPixel( 35 + x,124 + y,221,225,225 );
	gfx.PutPixel( 36 + x,124 + y,220,209,209 );
	gfx.PutPixel( 37 + x,124 + y,210,59,59 );
	gfx.PutPixel( 38 + x,124 + y,209,44,44 );
	gfx.PutPixel( 39 + x,124 + y,209,47,47 );
	gfx.PutPixel( 40 + x,124 + y,209,47,47 );
	gfx.PutPixel( 41 + x,124 + y,209,47,47 );
	gfx.PutPixel( 42 + x,124 + y,209,47,47 );
	gfx.PutPixel( 43 + x,124 + y,209,48,48 );
	gfx.PutPixel( 44 + x,124 + y,208,39,39 );
	gfx.PutPixel( 45 + x,124 + y,208,33,33 );
	gfx.PutPixel( 46 + x,124 + y,208,34,34 );
	gfx.PutPixel( 47 + x,124 + y,208,34,34 );
	gfx.PutPixel( 48 + x,124 + y,207,26,26 );
	gfx.PutPixel( 49 + x,124 + y,217,167,167 );
	gfx.PutPixel( 50 + x,124 + y,222,231,231 );
	gfx.PutPixel( 51 + x,124 + y,221,221,221 );
	gfx.PutPixel( 52 + x,124 + y,221,223,223 );
	gfx.PutPixel( 53 + x,124 + y,218,183,183 );
	gfx.PutPixel( 54 + x,124 + y,217,170,170 );
	gfx.PutPixel( 55 + x,124 + y,218,173,173 );
	gfx.PutPixel( 56 + x,124 + y,217,169,169 );
	gfx.PutPixel( 57 + x,124 + y,220,206,206 );
	gfx.PutPixel( 58 + x,124 + y,221,224,224 );
	gfx.PutPixel( 59 + x,124 + y,221,221,221 );
	gfx.PutPixel( 60 + x,124 + y,222,233,233 );
	gfx.PutPixel( 61 + x,124 + y,214,124,124 );
	gfx.PutPixel( 62 + x,124 + y,207,22,22 );
	gfx.PutPixel( 63 + x,124 + y,208,34,34 );
	gfx.PutPixel( 64 + x,124 + y,208,34,34 );
	gfx.PutPixel( 65 + x,124 + y,208,34,34 );
	gfx.PutPixel( 66 + x,124 + y,208,27,27 );
	gfx.PutPixel( 67 + x,124 + y,218,173,173 );
	gfx.PutPixel( 68 + x,124 + y,222,230,230 );
	gfx.PutPixel( 69 + x,124 + y,222,230,230 );
	gfx.PutPixel( 70 + x,124 + y,218,173,173 );
	gfx.PutPixel( 71 + x,124 + y,208,27,27 );
	gfx.PutPixel( 72 + x,124 + y,208,34,34 );
	gfx.PutPixel( 73 + x,124 + y,208,34,34 );
	gfx.PutPixel( 74 + x,124 + y,208,34,34 );
	gfx.PutPixel( 75 + x,124 + y,208,34,34 );
	gfx.PutPixel( 76 + x,124 + y,208,34,34 );
	gfx.PutPixel( 77 + x,124 + y,208,34,34 );
	gfx.PutPixel( 78 + x,124 + y,208,34,34 );
	gfx.PutPixel( 79 + x,124 + y,208,34,34 );
	gfx.PutPixel( 80 + x,124 + y,208,34,34 );
	gfx.PutPixel( 81 + x,124 + y,208,34,34 );
	gfx.PutPixel( 82 + x,124 + y,208,34,34 );
	gfx.PutPixel( 83 + x,124 + y,207,22,22 );
	gfx.PutPixel( 84 + x,124 + y,215,128,128 );
	gfx.PutPixel( 85 + x,124 + y,222,233,233 );
	gfx.PutPixel( 86 + x,124 + y,221,225,225 );
	gfx.PutPixel( 87 + x,124 + y,220,208,208 );
	gfx.PutPixel( 88 + x,124 + y,209,47,47 );
	gfx.PutPixel( 89 + x,124 + y,208,30,30 );
	gfx.PutPixel( 90 + x,124 + y,208,34,34 );
	gfx.PutPixel( 91 + x,124 + y,208,34,34 );
	gfx.PutPixel( 92 + x,124 + y,208,34,34 );
	gfx.PutPixel( 93 + x,124 + y,208,34,34 );
	gfx.PutPixel( 94 + x,124 + y,208,26,26 );
	gfx.PutPixel( 95 + x,124 + y,210,63,63 );
	gfx.PutPixel( 96 + x,124 + y,221,218,218 );
	gfx.PutPixel( 97 + x,124 + y,221,223,223 );
	gfx.PutPixel( 98 + x,124 + y,221,224,224 );
	gfx.PutPixel( 99 + x,124 + y,220,212,212 );
	gfx.PutPixel( 100 + x,124 + y,209,53,53 );
	gfx.PutPixel( 101 + x,124 + y,208,30,30 );
	gfx.PutPixel( 102 + x,124 + y,207,25,25 );
	gfx.PutPixel( 103 + x,124 + y,211,78,78 );
	gfx.PutPixel( 104 + x,124 + y,221,225,225 );
	gfx.PutPixel( 105 + x,124 + y,221,222,222 );
	gfx.PutPixel( 106 + x,124 + y,221,223,223 );
	gfx.PutPixel( 107 + x,124 + y,220,207,207 );
	gfx.PutPixel( 108 + x,124 + y,218,170,170 );
	gfx.PutPixel( 109 + x,124 + y,218,173,173 );
	gfx.PutPixel( 110 + x,124 + y,217,171,171 );
	gfx.PutPixel( 111 + x,124 + y,218,182,182 );
	gfx.PutPixel( 112 + x,124 + y,221,222,222 );
	gfx.PutPixel( 113 + x,124 + y,221,221,221 );
	gfx.PutPixel( 114 + x,124 + y,221,225,225 );
	gfx.PutPixel( 115 + x,124 + y,220,204,204 );
	gfx.PutPixel( 116 + x,124 + y,209,46,46 );
	gfx.PutPixel( 117 + x,124 + y,208,30,30 );
	gfx.PutPixel( 118 + x,124 + y,208,34,34 );
	gfx.PutPixel( 119 + x,124 + y,208,34,34 );
	gfx.PutPixel( 120 + x,124 + y,208,34,34 );
	gfx.PutPixel( 121 + x,124 + y,208,34,34 );
	gfx.PutPixel( 122 + x,124 + y,208,34,34 );
	gfx.PutPixel( 123 + x,124 + y,208,34,34 );
	gfx.PutPixel( 124 + x,124 + y,208,34,34 );
	gfx.PutPixel( 125 + x,124 + y,208,34,34 );
	gfx.PutPixel( 126 + x,124 + y,208,34,34 );
	gfx.PutPixel( 127 + x,124 + y,208,34,34 );
	gfx.PutPixel( 128 + x,124 + y,208,34,34 );
	gfx.PutPixel( 129 + x,124 + y,208,34,34 );
	gfx.PutPixel( 130 + x,124 + y,208,34,34 );
	gfx.PutPixel( 131 + x,124 + y,208,34,34 );
	gfx.PutPixel( 132 + x,124 + y,208,34,34 );
	gfx.PutPixel( 133 + x,124 + y,208,34,34 );
	gfx.PutPixel( 134 + x,124 + y,208,34,34 );
	gfx.PutPixel( 135 + x,124 + y,208,34,34 );
	gfx.PutPixel( 136 + x,124 + y,208,34,34 );
	gfx.PutPixel( 137 + x,124 + y,208,34,34 );
	gfx.PutPixel( 138 + x,124 + y,208,34,34 );
	gfx.PutPixel( 139 + x,124 + y,208,34,34 );
	gfx.PutPixel( 140 + x,124 + y,208,34,34 );
	gfx.PutPixel( 141 + x,124 + y,208,34,34 );
	gfx.PutPixel( 142 + x,124 + y,208,34,34 );
	gfx.PutPixel( 143 + x,124 + y,208,34,34 );
	gfx.PutPixel( 144 + x,124 + y,208,34,34 );
	gfx.PutPixel( 145 + x,124 + y,208,34,34 );
	gfx.PutPixel( 146 + x,124 + y,208,34,34 );
	gfx.PutPixel( 147 + x,124 + y,208,34,34 );
	gfx.PutPixel( 148 + x,124 + y,208,34,34 );
	gfx.PutPixel( 149 + x,124 + y,208,34,34 );
	gfx.PutPixel( 0 + x,125 + y,208,34,34 );
	gfx.PutPixel( 1 + x,125 + y,208,34,34 );
	gfx.PutPixel( 2 + x,125 + y,208,34,34 );
	gfx.PutPixel( 3 + x,125 + y,208,34,34 );
	gfx.PutPixel( 4 + x,125 + y,208,34,34 );
	gfx.PutPixel( 5 + x,125 + y,208,34,34 );
	gfx.PutPixel( 6 + x,125 + y,208,34,34 );
	gfx.PutPixel( 7 + x,125 + y,208,34,34 );
	gfx.PutPixel( 8 + x,125 + y,208,34,34 );
	gfx.PutPixel( 9 + x,125 + y,208,34,34 );
	gfx.PutPixel( 10 + x,125 + y,208,34,34 );
	gfx.PutPixel( 11 + x,125 + y,208,34,34 );
	gfx.PutPixel( 12 + x,125 + y,208,34,34 );
	gfx.PutPixel( 13 + x,125 + y,208,34,34 );
	gfx.PutPixel( 14 + x,125 + y,208,34,34 );
	gfx.PutPixel( 15 + x,125 + y,208,34,34 );
	gfx.PutPixel( 16 + x,125 + y,208,34,34 );
	gfx.PutPixel( 17 + x,125 + y,208,34,34 );
	gfx.PutPixel( 18 + x,125 + y,208,34,34 );
	gfx.PutPixel( 19 + x,125 + y,208,34,34 );
	gfx.PutPixel( 20 + x,125 + y,208,34,34 );
	gfx.PutPixel( 21 + x,125 + y,208,34,34 );
	gfx.PutPixel( 22 + x,125 + y,208,34,34 );
	gfx.PutPixel( 23 + x,125 + y,208,34,34 );
	gfx.PutPixel( 24 + x,125 + y,208,34,34 );
	gfx.PutPixel( 25 + x,125 + y,208,34,34 );
	gfx.PutPixel( 26 + x,125 + y,208,34,34 );
	gfx.PutPixel( 27 + x,125 + y,208,34,34 );
	gfx.PutPixel( 28 + x,125 + y,208,34,34 );
	gfx.PutPixel( 29 + x,125 + y,208,34,34 );
	gfx.PutPixel( 30 + x,125 + y,208,34,34 );
	gfx.PutPixel( 31 + x,125 + y,208,34,34 );
	gfx.PutPixel( 32 + x,125 + y,207,22,22 );
	gfx.PutPixel( 33 + x,125 + y,215,128,128 );
	gfx.PutPixel( 34 + x,125 + y,222,233,233 );
	gfx.PutPixel( 35 + x,125 + y,221,225,225 );
	gfx.PutPixel( 36 + x,125 + y,220,208,208 );
	gfx.PutPixel( 37 + x,125 + y,209,44,44 );
	gfx.PutPixel( 38 + x,125 + y,208,26,26 );
	gfx.PutPixel( 39 + x,125 + y,208,30,30 );
	gfx.PutPixel( 40 + x,125 + y,208,30,30 );
	gfx.PutPixel( 41 + x,125 + y,208,30,30 );
	gfx.PutPixel( 42 + x,125 + y,208,30,30 );
	gfx.PutPixel( 43 + x,125 + y,208,30,30 );
	gfx.PutPixel( 44 + x,125 + y,208,33,33 );
	gfx.PutPixel( 45 + x,125 + y,208,34,34 );
	gfx.PutPixel( 46 + x,125 + y,208,34,34 );
	gfx.PutPixel( 47 + x,125 + y,207,27,27 );
	gfx.PutPixel( 48 + x,125 + y,210,67,67 );
	gfx.PutPixel( 49 + x,125 + y,221,221,221 );
	gfx.PutPixel( 50 + x,125 + y,221,223,223 );
	gfx.PutPixel( 51 + x,125 + y,221,221,221 );
	gfx.PutPixel( 52 + x,125 + y,221,221,221 );
	gfx.PutPixel( 53 + x,125 + y,221,227,227 );
	gfx.PutPixel( 54 + x,125 + y,222,230,230 );
	gfx.PutPixel( 55 + x,125 + y,222,230,230 );
	gfx.PutPixel( 56 + x,125 + y,222,230,230 );
	gfx.PutPixel( 57 + x,125 + y,221,223,223 );
	gfx.PutPixel( 58 + x,125 + y,221,221,221 );
	gfx.PutPixel( 59 + x,125 + y,221,221,221 );
	gfx.PutPixel( 60 + x,125 + y,221,227,227 );
	gfx.PutPixel( 61 + x,125 + y,220,197,197 );
	gfx.PutPixel( 62 + x,125 + y,209,39,39 );
	gfx.PutPixel( 63 + x,125 + y,208,31,31 );
	gfx.PutPixel( 64 + x,125 + y,208,34,34 );
	gfx.PutPixel( 65 + x,125 + y,208,34,34 );
	gfx.PutPixel( 66 + x,125 + y,208,27,27 );
	gfx.PutPixel( 67 + x,125 + y,218,173,173 );
	gfx.PutPixel( 68 + x,125 + y,222,230,230 );
	gfx.PutPixel( 69 + x,125 + y,222,230,230 );
	gfx.PutPixel( 70 + x,125 + y,218,173,173 );
	gfx.PutPixel( 71 + x,125 + y,208,27,27 );
	gfx.PutPixel( 72 + x,125 + y,208,34,34 );
	gfx.PutPixel( 73 + x,125 + y,208,34,34 );
	gfx.PutPixel( 74 + x,125 + y,208,34,34 );
	gfx.PutPixel( 75 + x,125 + y,208,34,34 );
	gfx.PutPixel( 76 + x,125 + y,208,34,34 );
	gfx.PutPixel( 77 + x,125 + y,208,34,34 );
	gfx.PutPixel( 78 + x,125 + y,208,34,34 );
	gfx.PutPixel( 79 + x,125 + y,208,34,34 );
	gfx.PutPixel( 80 + x,125 + y,208,34,34 );
	gfx.PutPixel( 81 + x,125 + y,208,34,34 );
	gfx.PutPixel( 82 + x,125 + y,208,34,34 );
	gfx.PutPixel( 83 + x,125 + y,207,22,22 );
	gfx.PutPixel( 84 + x,125 + y,215,128,128 );
	gfx.PutPixel( 85 + x,125 + y,222,233,233 );
	gfx.PutPixel( 86 + x,125 + y,221,225,225 );
	gfx.PutPixel( 87 + x,125 + y,220,208,208 );
	gfx.PutPixel( 88 + x,125 + y,209,47,47 );
	gfx.PutPixel( 89 + x,125 + y,208,30,30 );
	gfx.PutPixel( 90 + x,125 + y,208,34,34 );
	gfx.PutPixel( 91 + x,125 + y,208,34,34 );
	gfx.PutPixel( 92 + x,125 + y,208,33,33 );
	gfx.PutPixel( 93 + x,125 + y,207,26,26 );
	gfx.PutPixel( 94 + x,125 + y,207,27,27 );
	gfx.PutPixel( 95 + x,125 + y,217,162,162 );
	gfx.PutPixel( 96 + x,125 + y,222,230,230 );
	gfx.PutPixel( 97 + x,125 + y,221,221,221 );
	gfx.PutPixel( 98 + x,125 + y,222,231,231 );
	gfx.PutPixel( 99 + x,125 + y,218,172,172 );
	gfx.PutPixel( 100 + x,125 + y,207,28,28 );
	gfx.PutPixel( 101 + x,125 + y,208,33,33 );
	gfx.PutPixel( 102 + x,125 + y,207,24,24 );
	gfx.PutPixel( 103 + x,125 + y,216,154,154 );
	gfx.PutPixel( 104 + x,125 + y,222,232,232 );
	gfx.PutPixel( 105 + x,125 + y,221,221,221 );
	gfx.PutPixel( 106 + x,125 + y,221,221,221 );
	gfx.PutPixel( 107 + x,125 + y,221,223,223 );
	gfx.PutPixel( 108 + x,125 + y,222,230,230 );
	gfx.PutPixel( 109 + x,125 + y,222,230,230 );
	gfx.PutPixel( 110 + x,125 + y,222,230,230 );
	gfx.PutPixel( 111 + x,125 + y,221,227,227 );
	gfx.PutPixel( 112 + x,125 + y,221,221,221 );
	gfx.PutPixel( 113 + x,125 + y,221,221,221 );
	gfx.PutPixel( 114 + x,125 + y,221,221,221 );
	gfx.PutPixel( 115 + x,125 + y,222,232,232 );
	gfx.PutPixel( 116 + x,125 + y,213,112,112 );
	gfx.PutPixel( 117 + x,125 + y,207,22,22 );
	gfx.PutPixel( 118 + x,125 + y,208,34,34 );
	gfx.PutPixel( 119 + x,125 + y,208,34,34 );
	gfx.PutPixel( 120 + x,125 + y,208,34,34 );
	gfx.PutPixel( 121 + x,125 + y,208,34,34 );
	gfx.PutPixel( 122 + x,125 + y,208,34,34 );
	gfx.PutPixel( 123 + x,125 + y,208,34,34 );
	gfx.PutPixel( 124 + x,125 + y,208,34,34 );
	gfx.PutPixel( 125 + x,125 + y,208,34,34 );
	gfx.PutPixel( 126 + x,125 + y,208,34,34 );
	gfx.PutPixel( 127 + x,125 + y,208,34,34 );
	gfx.PutPixel( 128 + x,125 + y,208,34,34 );
	gfx.PutPixel( 129 + x,125 + y,208,34,34 );
	gfx.PutPixel( 130 + x,125 + y,208,34,34 );
	gfx.PutPixel( 131 + x,125 + y,208,34,34 );
	gfx.PutPixel( 132 + x,125 + y,208,34,34 );
	gfx.PutPixel( 133 + x,125 + y,208,34,34 );
	gfx.PutPixel( 134 + x,125 + y,208,34,34 );
	gfx.PutPixel( 135 + x,125 + y,208,34,34 );
	gfx.PutPixel( 136 + x,125 + y,208,34,34 );
	gfx.PutPixel( 137 + x,125 + y,208,34,34 );
	gfx.PutPixel( 138 + x,125 + y,208,34,34 );
	gfx.PutPixel( 139 + x,125 + y,208,34,34 );
	gfx.PutPixel( 140 + x,125 + y,208,34,34 );
	gfx.PutPixel( 141 + x,125 + y,208,34,34 );
	gfx.PutPixel( 142 + x,125 + y,208,34,34 );
	gfx.PutPixel( 143 + x,125 + y,208,34,34 );
	gfx.PutPixel( 144 + x,125 + y,208,34,34 );
	gfx.PutPixel( 145 + x,125 + y,208,34,34 );
	gfx.PutPixel( 146 + x,125 + y,208,34,34 );
	gfx.PutPixel( 147 + x,125 + y,208,34,34 );
	gfx.PutPixel( 148 + x,125 + y,208,34,34 );
	gfx.PutPixel( 149 + x,125 + y,208,34,34 );
	gfx.PutPixel( 0 + x,126 + y,208,34,34 );
	gfx.PutPixel( 1 + x,126 + y,208,34,34 );
	gfx.PutPixel( 2 + x,126 + y,208,34,34 );
	gfx.PutPixel( 3 + x,126 + y,208,34,34 );
	gfx.PutPixel( 4 + x,126 + y,208,34,34 );
	gfx.PutPixel( 5 + x,126 + y,208,34,34 );
	gfx.PutPixel( 6 + x,126 + y,208,34,34 );
	gfx.PutPixel( 7 + x,126 + y,208,34,34 );
	gfx.PutPixel( 8 + x,126 + y,208,34,34 );
	gfx.PutPixel( 9 + x,126 + y,208,34,34 );
	gfx.PutPixel( 10 + x,126 + y,208,34,34 );
	gfx.PutPixel( 11 + x,126 + y,208,34,34 );
	gfx.PutPixel( 12 + x,126 + y,208,34,34 );
	gfx.PutPixel( 13 + x,126 + y,208,34,34 );
	gfx.PutPixel( 14 + x,126 + y,208,34,34 );
	gfx.PutPixel( 15 + x,126 + y,208,34,34 );
	gfx.PutPixel( 16 + x,126 + y,208,34,34 );
	gfx.PutPixel( 17 + x,126 + y,208,34,34 );
	gfx.PutPixel( 18 + x,126 + y,208,34,34 );
	gfx.PutPixel( 19 + x,126 + y,208,34,34 );
	gfx.PutPixel( 20 + x,126 + y,208,34,34 );
	gfx.PutPixel( 21 + x,126 + y,208,34,34 );
	gfx.PutPixel( 22 + x,126 + y,208,34,34 );
	gfx.PutPixel( 23 + x,126 + y,208,34,34 );
	gfx.PutPixel( 24 + x,126 + y,208,34,34 );
	gfx.PutPixel( 25 + x,126 + y,208,34,34 );
	gfx.PutPixel( 26 + x,126 + y,208,34,34 );
	gfx.PutPixel( 27 + x,126 + y,208,34,34 );
	gfx.PutPixel( 28 + x,126 + y,208,34,34 );
	gfx.PutPixel( 29 + x,126 + y,208,34,34 );
	gfx.PutPixel( 30 + x,126 + y,208,34,34 );
	gfx.PutPixel( 31 + x,126 + y,208,34,34 );
	gfx.PutPixel( 32 + x,126 + y,207,22,22 );
	gfx.PutPixel( 33 + x,126 + y,215,128,128 );
	gfx.PutPixel( 34 + x,126 + y,222,233,233 );
	gfx.PutPixel( 35 + x,126 + y,221,225,225 );
	gfx.PutPixel( 36 + x,126 + y,220,207,207 );
	gfx.PutPixel( 37 + x,126 + y,208,36,36 );
	gfx.PutPixel( 38 + x,126 + y,207,18,18 );
	gfx.PutPixel( 39 + x,126 + y,207,22,22 );
	gfx.PutPixel( 40 + x,126 + y,207,22,22 );
	gfx.PutPixel( 41 + x,126 + y,207,22,22 );
	gfx.PutPixel( 42 + x,126 + y,207,22,22 );
	gfx.PutPixel( 43 + x,126 + y,207,22,22 );
	gfx.PutPixel( 44 + x,126 + y,207,22,22 );
	gfx.PutPixel( 45 + x,126 + y,208,31,31 );
	gfx.PutPixel( 46 + x,126 + y,208,34,34 );
	gfx.PutPixel( 47 + x,126 + y,207,23,23 );
	gfx.PutPixel( 48 + x,126 + y,216,142,142 );
	gfx.PutPixel( 49 + x,126 + y,222,233,233 );
	gfx.PutPixel( 50 + x,126 + y,221,220,220 );
	gfx.PutPixel( 51 + x,126 + y,221,223,223 );
	gfx.PutPixel( 52 + x,126 + y,222,233,233 );
	gfx.PutPixel( 53 + x,126 + y,222,233,233 );
	gfx.PutPixel( 54 + x,126 + y,222,233,233 );
	gfx.PutPixel( 55 + x,126 + y,222,233,233 );
	gfx.PutPixel( 56 + x,126 + y,222,233,233 );
	gfx.PutPixel( 57 + x,126 + y,222,234,234 );
	gfx.PutPixel( 58 + x,126 + y,222,230,230 );
	gfx.PutPixel( 59 + x,126 + y,221,221,221 );
	gfx.PutPixel( 60 + x,126 + y,221,221,221 );
	gfx.PutPixel( 61 + x,126 + y,222,231,231 );
	gfx.PutPixel( 62 + x,126 + y,213,100,100 );
	gfx.PutPixel( 63 + x,126 + y,207,23,23 );
	gfx.PutPixel( 64 + x,126 + y,208,34,34 );
	gfx.PutPixel( 65 + x,126 + y,208,34,34 );
	gfx.PutPixel( 66 + x,126 + y,208,27,27 );
	gfx.PutPixel( 67 + x,126 + y,218,173,173 );
	gfx.PutPixel( 68 + x,126 + y,222,230,230 );
	gfx.PutPixel( 69 + x,126 + y,222,230,230 );
	gfx.PutPixel( 70 + x,126 + y,218,173,173 );
	gfx.PutPixel( 71 + x,126 + y,208,27,27 );
	gfx.PutPixel( 72 + x,126 + y,208,34,34 );
	gfx.PutPixel( 73 + x,126 + y,208,34,34 );
	gfx.PutPixel( 74 + x,126 + y,208,34,34 );
	gfx.PutPixel( 75 + x,126 + y,208,34,34 );
	gfx.PutPixel( 76 + x,126 + y,208,34,34 );
	gfx.PutPixel( 77 + x,126 + y,208,34,34 );
	gfx.PutPixel( 78 + x,126 + y,208,34,34 );
	gfx.PutPixel( 79 + x,126 + y,208,34,34 );
	gfx.PutPixel( 80 + x,126 + y,208,34,34 );
	gfx.PutPixel( 81 + x,126 + y,208,34,34 );
	gfx.PutPixel( 82 + x,126 + y,208,34,34 );
	gfx.PutPixel( 83 + x,126 + y,207,22,22 );
	gfx.PutPixel( 84 + x,126 + y,215,128,128 );
	gfx.PutPixel( 85 + x,126 + y,222,233,233 );
	gfx.PutPixel( 86 + x,126 + y,221,225,225 );
	gfx.PutPixel( 87 + x,126 + y,220,207,207 );
	gfx.PutPixel( 88 + x,126 + y,208,36,36 );
	gfx.PutPixel( 89 + x,126 + y,207,18,18 );
	gfx.PutPixel( 90 + x,126 + y,207,22,22 );
	gfx.PutPixel( 91 + x,126 + y,207,23,23 );
	gfx.PutPixel( 92 + x,126 + y,208,28,28 );
	gfx.PutPixel( 93 + x,126 + y,210,60,60 );
	gfx.PutPixel( 94 + x,126 + y,217,161,161 );
	gfx.PutPixel( 95 + x,126 + y,222,230,230 );
	gfx.PutPixel( 96 + x,126 + y,221,221,221 );
	gfx.PutPixel( 97 + x,126 + y,221,222,222 );
	gfx.PutPixel( 98 + x,126 + y,222,230,230 );
	gfx.PutPixel( 99 + x,126 + y,212,89,89 );
	gfx.PutPixel( 100 + x,126 + y,207,25,25 );
	gfx.PutPixel( 101 + x,126 + y,208,29,29 );
	gfx.PutPixel( 102 + x,126 + y,209,58,58 );
	gfx.PutPixel( 103 + x,126 + y,220,215,215 );
	gfx.PutPixel( 104 + x,126 + y,221,224,224 );
	gfx.PutPixel( 105 + x,126 + y,221,220,220 );
	gfx.PutPixel( 106 + x,126 + y,222,229,229 );
	gfx.PutPixel( 107 + x,126 + y,222,234,234 );
	gfx.PutPixel( 108 + x,126 + y,222,233,233 );
	gfx.PutPixel( 109 + x,126 + y,222,233,233 );
	gfx.PutPixel( 110 + x,126 + y,222,233,233 );
	gfx.PutPixel( 111 + x,126 + y,222,233,233 );
	gfx.PutPixel( 112 + x,126 + y,222,233,233 );
	gfx.PutPixel( 113 + x,126 + y,221,225,225 );
	gfx.PutPixel( 114 + x,126 + y,221,220,220 );
	gfx.PutPixel( 115 + x,126 + y,222,228,228 );
	gfx.PutPixel( 116 + x,126 + y,219,188,188 );
	gfx.PutPixel( 117 + x,126 + y,208,34,34 );
	gfx.PutPixel( 118 + x,126 + y,208,32,32 );
	gfx.PutPixel( 119 + x,126 + y,208,34,34 );
	gfx.PutPixel( 120 + x,126 + y,208,34,34 );
	gfx.PutPixel( 121 + x,126 + y,208,34,34 );
	gfx.PutPixel( 122 + x,126 + y,208,34,34 );
	gfx.PutPixel( 123 + x,126 + y,208,34,34 );
	gfx.PutPixel( 124 + x,126 + y,208,34,34 );
	gfx.PutPixel( 125 + x,126 + y,208,34,34 );
	gfx.PutPixel( 126 + x,126 + y,208,34,34 );
	gfx.PutPixel( 127 + x,126 + y,208,34,34 );
	gfx.PutPixel( 128 + x,126 + y,208,34,34 );
	gfx.PutPixel( 129 + x,126 + y,208,34,34 );
	gfx.PutPixel( 130 + x,126 + y,208,34,34 );
	gfx.PutPixel( 131 + x,126 + y,208,34,34 );
	gfx.PutPixel( 132 + x,126 + y,208,34,34 );
	gfx.PutPixel( 133 + x,126 + y,208,34,34 );
	gfx.PutPixel( 134 + x,126 + y,208,34,34 );
	gfx.PutPixel( 135 + x,126 + y,208,34,34 );
	gfx.PutPixel( 136 + x,126 + y,208,34,34 );
	gfx.PutPixel( 137 + x,126 + y,208,34,34 );
	gfx.PutPixel( 138 + x,126 + y,208,34,34 );
	gfx.PutPixel( 139 + x,126 + y,208,34,34 );
	gfx.PutPixel( 140 + x,126 + y,208,34,34 );
	gfx.PutPixel( 141 + x,126 + y,208,34,34 );
	gfx.PutPixel( 142 + x,126 + y,208,34,34 );
	gfx.PutPixel( 143 + x,126 + y,208,34,34 );
	gfx.PutPixel( 144 + x,126 + y,208,34,34 );
	gfx.PutPixel( 145 + x,126 + y,208,34,34 );
	gfx.PutPixel( 146 + x,126 + y,208,34,34 );
	gfx.PutPixel( 147 + x,126 + y,208,34,34 );
	gfx.PutPixel( 148 + x,126 + y,208,34,34 );
	gfx.PutPixel( 149 + x,126 + y,208,34,34 );
	gfx.PutPixel( 0 + x,127 + y,208,34,34 );
	gfx.PutPixel( 1 + x,127 + y,208,34,34 );
	gfx.PutPixel( 2 + x,127 + y,208,34,34 );
	gfx.PutPixel( 3 + x,127 + y,208,34,34 );
	gfx.PutPixel( 4 + x,127 + y,208,34,34 );
	gfx.PutPixel( 5 + x,127 + y,208,34,34 );
	gfx.PutPixel( 6 + x,127 + y,208,34,34 );
	gfx.PutPixel( 7 + x,127 + y,208,34,34 );
	gfx.PutPixel( 8 + x,127 + y,208,34,34 );
	gfx.PutPixel( 9 + x,127 + y,208,34,34 );
	gfx.PutPixel( 10 + x,127 + y,208,34,34 );
	gfx.PutPixel( 11 + x,127 + y,208,34,34 );
	gfx.PutPixel( 12 + x,127 + y,208,34,34 );
	gfx.PutPixel( 13 + x,127 + y,208,34,34 );
	gfx.PutPixel( 14 + x,127 + y,208,34,34 );
	gfx.PutPixel( 15 + x,127 + y,208,34,34 );
	gfx.PutPixel( 16 + x,127 + y,208,34,34 );
	gfx.PutPixel( 17 + x,127 + y,208,34,34 );
	gfx.PutPixel( 18 + x,127 + y,208,34,34 );
	gfx.PutPixel( 19 + x,127 + y,208,34,34 );
	gfx.PutPixel( 20 + x,127 + y,208,34,34 );
	gfx.PutPixel( 21 + x,127 + y,208,34,34 );
	gfx.PutPixel( 22 + x,127 + y,208,34,34 );
	gfx.PutPixel( 23 + x,127 + y,208,34,34 );
	gfx.PutPixel( 24 + x,127 + y,208,34,34 );
	gfx.PutPixel( 25 + x,127 + y,208,34,34 );
	gfx.PutPixel( 26 + x,127 + y,208,34,34 );
	gfx.PutPixel( 27 + x,127 + y,208,34,34 );
	gfx.PutPixel( 28 + x,127 + y,208,34,34 );
	gfx.PutPixel( 29 + x,127 + y,208,34,34 );
	gfx.PutPixel( 30 + x,127 + y,208,34,34 );
	gfx.PutPixel( 31 + x,127 + y,208,34,34 );
	gfx.PutPixel( 32 + x,127 + y,207,22,22 );
	gfx.PutPixel( 33 + x,127 + y,215,128,128 );
	gfx.PutPixel( 34 + x,127 + y,222,233,233 );
	gfx.PutPixel( 35 + x,127 + y,221,223,223 );
	gfx.PutPixel( 36 + x,127 + y,221,215,215 );
	gfx.PutPixel( 37 + x,127 + y,215,134,134 );
	gfx.PutPixel( 38 + x,127 + y,215,126,126 );
	gfx.PutPixel( 39 + x,127 + y,215,128,128 );
	gfx.PutPixel( 40 + x,127 + y,215,128,128 );
	gfx.PutPixel( 41 + x,127 + y,215,128,128 );
	gfx.PutPixel( 42 + x,127 + y,215,128,128 );
	gfx.PutPixel( 43 + x,127 + y,215,128,128 );
	gfx.PutPixel( 44 + x,127 + y,215,130,130 );
	gfx.PutPixel( 45 + x,127 + y,210,57,57 );
	gfx.PutPixel( 46 + x,127 + y,208,26,26 );
	gfx.PutPixel( 47 + x,127 + y,209,49,49 );
	gfx.PutPixel( 48 + x,127 + y,220,208,208 );
	gfx.PutPixel( 49 + x,127 + y,221,225,225 );
	gfx.PutPixel( 50 + x,127 + y,221,224,224 );
	gfx.PutPixel( 51 + x,127 + y,220,210,210 );
	gfx.PutPixel( 52 + x,127 + y,215,131,131 );
	gfx.PutPixel( 53 + x,127 + y,215,126,126 );
	gfx.PutPixel( 54 + x,127 + y,215,128,128 );
	gfx.PutPixel( 55 + x,127 + y,215,128,128 );
	gfx.PutPixel( 56 + x,127 + y,215,128,128 );
	gfx.PutPixel( 57 + x,127 + y,214,123,123 );
	gfx.PutPixel( 58 + x,127 + y,216,154,154 );
	gfx.PutPixel( 59 + x,127 + y,221,226,226 );
	gfx.PutPixel( 60 + x,127 + y,221,221,221 );
	gfx.PutPixel( 61 + x,127 + y,222,230,230 );
	gfx.PutPixel( 62 + x,127 + y,218,178,178 );
	gfx.PutPixel( 63 + x,127 + y,207,30,30 );
	gfx.PutPixel( 64 + x,127 + y,208,33,33 );
	gfx.PutPixel( 65 + x,127 + y,208,34,34 );
	gfx.PutPixel( 66 + x,127 + y,208,27,27 );
	gfx.PutPixel( 67 + x,127 + y,218,173,173 );
	gfx.PutPixel( 68 + x,127 + y,222,230,230 );
	gfx.PutPixel( 69 + x,127 + y,222,230,230 );
	gfx.PutPixel( 70 + x,127 + y,218,173,173 );
	gfx.PutPixel( 71 + x,127 + y,208,27,27 );
	gfx.PutPixel( 72 + x,127 + y,208,34,34 );
	gfx.PutPixel( 73 + x,127 + y,208,34,34 );
	gfx.PutPixel( 74 + x,127 + y,208,34,34 );
	gfx.PutPixel( 75 + x,127 + y,208,34,34 );
	gfx.PutPixel( 76 + x,127 + y,208,34,34 );
	gfx.PutPixel( 77 + x,127 + y,208,34,34 );
	gfx.PutPixel( 78 + x,127 + y,208,34,34 );
	gfx.PutPixel( 79 + x,127 + y,208,34,34 );
	gfx.PutPixel( 80 + x,127 + y,208,34,34 );
	gfx.PutPixel( 81 + x,127 + y,208,34,34 );
	gfx.PutPixel( 82 + x,127 + y,208,34,34 );
	gfx.PutPixel( 83 + x,127 + y,207,22,22 );
	gfx.PutPixel( 84 + x,127 + y,215,128,128 );
	gfx.PutPixel( 85 + x,127 + y,222,233,233 );
	gfx.PutPixel( 86 + x,127 + y,221,223,223 );
	gfx.PutPixel( 87 + x,127 + y,221,215,215 );
	gfx.PutPixel( 88 + x,127 + y,215,134,134 );
	gfx.PutPixel( 89 + x,127 + y,215,125,125 );
	gfx.PutPixel( 90 + x,127 + y,215,129,129 );
	gfx.PutPixel( 91 + x,127 + y,216,144,144 );
	gfx.PutPixel( 92 + x,127 + y,218,176,176 );
	gfx.PutPixel( 93 + x,127 + y,221,217,217 );
	gfx.PutPixel( 94 + x,127 + y,222,230,230 );
	gfx.PutPixel( 95 + x,127 + y,221,221,221 );
	gfx.PutPixel( 96 + x,127 + y,221,221,221 );
	gfx.PutPixel( 97 + x,127 + y,222,236,236 );
	gfx.PutPixel( 98 + x,127 + y,216,148,148 );
	gfx.PutPixel( 99 + x,127 + y,207,26,26 );
	gfx.PutPixel( 100 + x,127 + y,208,34,34 );
	gfx.PutPixel( 101 + x,127 + y,207,22,22 );
	gfx.PutPixel( 102 + x,127 + y,215,129,129 );
	gfx.PutPixel( 103 + x,127 + y,222,233,233 );
	gfx.PutPixel( 104 + x,127 + y,221,221,221 );
	gfx.PutPixel( 105 + x,127 + y,222,227,227 );
	gfx.PutPixel( 106 + x,127 + y,217,168,168 );
	gfx.PutPixel( 107 + x,127 + y,214,122,122 );
	gfx.PutPixel( 108 + x,127 + y,215,128,128 );
	gfx.PutPixel( 109 + x,127 + y,215,128,128 );
	gfx.PutPixel( 110 + x,127 + y,215,128,128 );
	gfx.PutPixel( 111 + x,127 + y,215,127,127 );
	gfx.PutPixel( 112 + x,127 + y,214,125,125 );
	gfx.PutPixel( 113 + x,127 + y,219,200,200 );
	gfx.PutPixel( 114 + x,127 + y,221,225,225 );
	gfx.PutPixel( 115 + x,127 + y,221,221,221 );
	gfx.PutPixel( 116 + x,127 + y,222,229,229 );
	gfx.PutPixel( 117 + x,127 + y,212,89,89 );
	gfx.PutPixel( 118 + x,127 + y,207,24,24 );
	gfx.PutPixel( 119 + x,127 + y,208,34,34 );
	gfx.PutPixel( 120 + x,127 + y,208,34,34 );
	gfx.PutPixel( 121 + x,127 + y,208,34,34 );
	gfx.PutPixel( 122 + x,127 + y,208,34,34 );
	gfx.PutPixel( 123 + x,127 + y,208,34,34 );
	gfx.PutPixel( 124 + x,127 + y,208,34,34 );
	gfx.PutPixel( 125 + x,127 + y,208,34,34 );
	gfx.PutPixel( 126 + x,127 + y,208,34,34 );
	gfx.PutPixel( 127 + x,127 + y,208,34,34 );
	gfx.PutPixel( 128 + x,127 + y,208,34,34 );
	gfx.PutPixel( 129 + x,127 + y,208,34,34 );
	gfx.PutPixel( 130 + x,127 + y,208,34,34 );
	gfx.PutPixel( 131 + x,127 + y,208,34,34 );
	gfx.PutPixel( 132 + x,127 + y,208,34,34 );
	gfx.PutPixel( 133 + x,127 + y,208,34,34 );
	gfx.PutPixel( 134 + x,127 + y,208,34,34 );
	gfx.PutPixel( 135 + x,127 + y,208,34,34 );
	gfx.PutPixel( 136 + x,127 + y,208,34,34 );
	gfx.PutPixel( 137 + x,127 + y,208,34,34 );
	gfx.PutPixel( 138 + x,127 + y,208,34,34 );
	gfx.PutPixel( 139 + x,127 + y,208,34,34 );
	gfx.PutPixel( 140 + x,127 + y,208,34,34 );
	gfx.PutPixel( 141 + x,127 + y,208,34,34 );
	gfx.PutPixel( 142 + x,127 + y,208,34,34 );
	gfx.PutPixel( 143 + x,127 + y,208,34,34 );
	gfx.PutPixel( 144 + x,127 + y,208,34,34 );
	gfx.PutPixel( 145 + x,127 + y,208,34,34 );
	gfx.PutPixel( 146 + x,127 + y,208,34,34 );
	gfx.PutPixel( 147 + x,127 + y,208,34,34 );
	gfx.PutPixel( 148 + x,127 + y,208,34,34 );
	gfx.PutPixel( 149 + x,127 + y,208,34,34 );
	gfx.PutPixel( 0 + x,128 + y,208,34,34 );
	gfx.PutPixel( 1 + x,128 + y,208,34,34 );
	gfx.PutPixel( 2 + x,128 + y,208,34,34 );
	gfx.PutPixel( 3 + x,128 + y,208,34,34 );
	gfx.PutPixel( 4 + x,128 + y,208,34,34 );
	gfx.PutPixel( 5 + x,128 + y,208,34,34 );
	gfx.PutPixel( 6 + x,128 + y,208,34,34 );
	gfx.PutPixel( 7 + x,128 + y,208,34,34 );
	gfx.PutPixel( 8 + x,128 + y,208,34,34 );
	gfx.PutPixel( 9 + x,128 + y,208,34,34 );
	gfx.PutPixel( 10 + x,128 + y,208,34,34 );
	gfx.PutPixel( 11 + x,128 + y,208,34,34 );
	gfx.PutPixel( 12 + x,128 + y,208,34,34 );
	gfx.PutPixel( 13 + x,128 + y,208,34,34 );
	gfx.PutPixel( 14 + x,128 + y,208,34,34 );
	gfx.PutPixel( 15 + x,128 + y,208,34,34 );
	gfx.PutPixel( 16 + x,128 + y,208,34,34 );
	gfx.PutPixel( 17 + x,128 + y,208,34,34 );
	gfx.PutPixel( 18 + x,128 + y,208,34,34 );
	gfx.PutPixel( 19 + x,128 + y,208,34,34 );
	gfx.PutPixel( 20 + x,128 + y,208,34,34 );
	gfx.PutPixel( 21 + x,128 + y,208,34,34 );
	gfx.PutPixel( 22 + x,128 + y,208,34,34 );
	gfx.PutPixel( 23 + x,128 + y,208,34,34 );
	gfx.PutPixel( 24 + x,128 + y,208,34,34 );
	gfx.PutPixel( 25 + x,128 + y,208,34,34 );
	gfx.PutPixel( 26 + x,128 + y,208,34,34 );
	gfx.PutPixel( 27 + x,128 + y,208,34,34 );
	gfx.PutPixel( 28 + x,128 + y,208,34,34 );
	gfx.PutPixel( 29 + x,128 + y,208,34,34 );
	gfx.PutPixel( 30 + x,128 + y,208,34,34 );
	gfx.PutPixel( 31 + x,128 + y,208,34,34 );
	gfx.PutPixel( 32 + x,128 + y,207,22,22 );
	gfx.PutPixel( 33 + x,128 + y,215,128,128 );
	gfx.PutPixel( 34 + x,128 + y,222,233,233 );
	gfx.PutPixel( 35 + x,128 + y,221,221,221 );
	gfx.PutPixel( 36 + x,128 + y,221,222,222 );
	gfx.PutPixel( 37 + x,128 + y,222,232,232 );
	gfx.PutPixel( 38 + x,128 + y,222,233,233 );
	gfx.PutPixel( 39 + x,128 + y,222,233,233 );
	gfx.PutPixel( 40 + x,128 + y,222,233,233 );
	gfx.PutPixel( 41 + x,128 + y,222,233,233 );
	gfx.PutPixel( 42 + x,128 + y,222,233,233 );
	gfx.PutPixel( 43 + x,128 + y,222,234,234 );
	gfx.PutPixel( 44 + x,128 + y,222,238,238 );
	gfx.PutPixel( 45 + x,128 + y,211,83,83 );
	gfx.PutPixel( 46 + x,128 + y,207,13,13 );
	gfx.PutPixel( 47 + x,128 + y,214,117,117 );
	gfx.PutPixel( 48 + x,128 + y,222,233,233 );
	gfx.PutPixel( 49 + x,128 + y,221,221,221 );
	gfx.PutPixel( 50 + x,128 + y,222,232,232 );
	gfx.PutPixel( 51 + x,128 + y,216,149,149 );
	gfx.PutPixel( 52 + x,128 + y,206,14,14 );
	gfx.PutPixel( 53 + x,128 + y,207,21,21 );
	gfx.PutPixel( 54 + x,128 + y,207,22,22 );
	gfx.PutPixel( 55 + x,128 + y,207,22,22 );
	gfx.PutPixel( 56 + x,128 + y,207,22,22 );
	gfx.PutPixel( 57 + x,128 + y,207,18,18 );
	gfx.PutPixel( 58 + x,128 + y,208,39,39 );
	gfx.PutPixel( 59 + x,128 + y,220,203,203 );
	gfx.PutPixel( 60 + x,128 + y,221,226,226 );
	gfx.PutPixel( 61 + x,128 + y,221,222,222 );
	gfx.PutPixel( 62 + x,128 + y,221,226,226 );
	gfx.PutPixel( 63 + x,128 + y,211,78,78 );
	gfx.PutPixel( 64 + x,128 + y,207,25,25 );
	gfx.PutPixel( 65 + x,128 + y,208,34,34 );
	gfx.PutPixel( 66 + x,128 + y,208,27,27 );
	gfx.PutPixel( 67 + x,128 + y,218,173,173 );
	gfx.PutPixel( 68 + x,128 + y,222,230,230 );
	gfx.PutPixel( 69 + x,128 + y,222,230,230 );
	gfx.PutPixel( 70 + x,128 + y,218,173,173 );
	gfx.PutPixel( 71 + x,128 + y,208,27,27 );
	gfx.PutPixel( 72 + x,128 + y,208,34,34 );
	gfx.PutPixel( 73 + x,128 + y,208,34,34 );
	gfx.PutPixel( 74 + x,128 + y,208,34,34 );
	gfx.PutPixel( 75 + x,128 + y,208,34,34 );
	gfx.PutPixel( 76 + x,128 + y,208,34,34 );
	gfx.PutPixel( 77 + x,128 + y,208,34,34 );
	gfx.PutPixel( 78 + x,128 + y,208,34,34 );
	gfx.PutPixel( 79 + x,128 + y,208,34,34 );
	gfx.PutPixel( 80 + x,128 + y,208,34,34 );
	gfx.PutPixel( 81 + x,128 + y,208,34,34 );
	gfx.PutPixel( 82 + x,128 + y,208,34,34 );
	gfx.PutPixel( 83 + x,128 + y,207,22,22 );
	gfx.PutPixel( 84 + x,128 + y,215,128,128 );
	gfx.PutPixel( 85 + x,128 + y,222,233,233 );
	gfx.PutPixel( 86 + x,128 + y,221,221,221 );
	gfx.PutPixel( 87 + x,128 + y,221,222,222 );
	gfx.PutPixel( 88 + x,128 + y,222,232,232 );
	gfx.PutPixel( 89 + x,128 + y,222,233,233 );
	gfx.PutPixel( 90 + x,128 + y,222,233,233 );
	gfx.PutPixel( 91 + x,128 + y,222,232,232 );
	gfx.PutPixel( 92 + x,128 + y,222,229,229 );
	gfx.PutPixel( 93 + x,128 + y,221,223,223 );
	gfx.PutPixel( 94 + x,128 + y,221,221,221 );
	gfx.PutPixel( 95 + x,128 + y,221,227,227 );
	gfx.PutPixel( 96 + x,128 + y,222,234,234 );
	gfx.PutPixel( 97 + x,128 + y,217,157,157 );
	gfx.PutPixel( 98 + x,128 + y,208,35,35 );
	gfx.PutPixel( 99 + x,128 + y,208,30,30 );
	gfx.PutPixel( 100 + x,128 + y,208,31,31 );
	gfx.PutPixel( 101 + x,128 + y,209,42,42 );
	gfx.PutPixel( 102 + x,128 + y,220,200,200 );
	gfx.PutPixel( 103 + x,128 + y,221,226,226 );
	gfx.PutPixel( 104 + x,128 + y,221,223,223 );
	gfx.PutPixel( 105 + x,128 + y,221,219,219 );
	gfx.PutPixel( 106 + x,128 + y,210,58,58 );
	gfx.PutPixel( 107 + x,128 + y,207,15,15 );
	gfx.PutPixel( 108 + x,128 + y,207,22,22 );
	gfx.PutPixel( 109 + x,128 + y,207,22,22 );
	gfx.PutPixel( 110 + x,128 + y,207,22,22 );
	gfx.PutPixel( 111 + x,128 + y,207,22,22 );
	gfx.PutPixel( 112 + x,128 + y,206,11,11 );
	gfx.PutPixel( 113 + x,128 + y,214,120,120 );
	gfx.PutPixel( 114 + x,128 + y,222,233,233 );
	gfx.PutPixel( 115 + x,128 + y,221,221,221 );
	gfx.PutPixel( 116 + x,128 + y,222,231,231 );
	gfx.PutPixel( 117 + x,128 + y,217,167,167 );
	gfx.PutPixel( 118 + x,128 + y,207,27,27 );
	gfx.PutPixel( 119 + x,128 + y,208,33,33 );
	gfx.PutPixel( 120 + x,128 + y,208,34,34 );
	gfx.PutPixel( 121 + x,128 + y,208,34,34 );
	gfx.PutPixel( 122 + x,128 + y,208,34,34 );
	gfx.PutPixel( 123 + x,128 + y,208,34,34 );
	gfx.PutPixel( 124 + x,128 + y,208,34,34 );
	gfx.PutPixel( 125 + x,128 + y,208,34,34 );
	gfx.PutPixel( 126 + x,128 + y,208,34,34 );
	gfx.PutPixel( 127 + x,128 + y,208,34,34 );
	gfx.PutPixel( 128 + x,128 + y,208,34,34 );
	gfx.PutPixel( 129 + x,128 + y,208,34,34 );
	gfx.PutPixel( 130 + x,128 + y,208,34,34 );
	gfx.PutPixel( 131 + x,128 + y,208,34,34 );
	gfx.PutPixel( 132 + x,128 + y,208,34,34 );
	gfx.PutPixel( 133 + x,128 + y,208,34,34 );
	gfx.PutPixel( 134 + x,128 + y,208,34,34 );
	gfx.PutPixel( 135 + x,128 + y,208,34,34 );
	gfx.PutPixel( 136 + x,128 + y,208,34,34 );
	gfx.PutPixel( 137 + x,128 + y,208,34,34 );
	gfx.PutPixel( 138 + x,128 + y,208,34,34 );
	gfx.PutPixel( 139 + x,128 + y,208,34,34 );
	gfx.PutPixel( 140 + x,128 + y,208,34,34 );
	gfx.PutPixel( 141 + x,128 + y,208,34,34 );
	gfx.PutPixel( 142 + x,128 + y,208,34,34 );
	gfx.PutPixel( 143 + x,128 + y,208,34,34 );
	gfx.PutPixel( 144 + x,128 + y,208,34,34 );
	gfx.PutPixel( 145 + x,128 + y,208,34,34 );
	gfx.PutPixel( 146 + x,128 + y,208,34,34 );
	gfx.PutPixel( 147 + x,128 + y,208,34,34 );
	gfx.PutPixel( 148 + x,128 + y,208,34,34 );
	gfx.PutPixel( 149 + x,128 + y,208,34,34 );
	gfx.PutPixel( 0 + x,129 + y,208,34,34 );
	gfx.PutPixel( 1 + x,129 + y,208,34,34 );
	gfx.PutPixel( 2 + x,129 + y,208,34,34 );
	gfx.PutPixel( 3 + x,129 + y,208,34,34 );
	gfx.PutPixel( 4 + x,129 + y,208,34,34 );
	gfx.PutPixel( 5 + x,129 + y,208,34,34 );
	gfx.PutPixel( 6 + x,129 + y,208,34,34 );
	gfx.PutPixel( 7 + x,129 + y,208,34,34 );
	gfx.PutPixel( 8 + x,129 + y,208,34,34 );
	gfx.PutPixel( 9 + x,129 + y,208,34,34 );
	gfx.PutPixel( 10 + x,129 + y,208,34,34 );
	gfx.PutPixel( 11 + x,129 + y,208,34,34 );
	gfx.PutPixel( 12 + x,129 + y,208,34,34 );
	gfx.PutPixel( 13 + x,129 + y,208,34,34 );
	gfx.PutPixel( 14 + x,129 + y,208,34,34 );
	gfx.PutPixel( 15 + x,129 + y,208,34,34 );
	gfx.PutPixel( 16 + x,129 + y,208,34,34 );
	gfx.PutPixel( 17 + x,129 + y,208,34,34 );
	gfx.PutPixel( 18 + x,129 + y,208,34,34 );
	gfx.PutPixel( 19 + x,129 + y,208,34,34 );
	gfx.PutPixel( 20 + x,129 + y,208,34,34 );
	gfx.PutPixel( 21 + x,129 + y,208,34,34 );
	gfx.PutPixel( 22 + x,129 + y,208,34,34 );
	gfx.PutPixel( 23 + x,129 + y,208,34,34 );
	gfx.PutPixel( 24 + x,129 + y,208,34,34 );
	gfx.PutPixel( 25 + x,129 + y,208,34,34 );
	gfx.PutPixel( 26 + x,129 + y,208,34,34 );
	gfx.PutPixel( 27 + x,129 + y,208,34,34 );
	gfx.PutPixel( 28 + x,129 + y,208,34,34 );
	gfx.PutPixel( 29 + x,129 + y,208,34,34 );
	gfx.PutPixel( 30 + x,129 + y,208,34,34 );
	gfx.PutPixel( 31 + x,129 + y,208,34,34 );
	gfx.PutPixel( 32 + x,129 + y,207,22,22 );
	gfx.PutPixel( 33 + x,129 + y,215,130,130 );
	gfx.PutPixel( 34 + x,129 + y,222,237,237 );
	gfx.PutPixel( 35 + x,129 + y,221,225,225 );
	gfx.PutPixel( 36 + x,129 + y,221,225,225 );
	gfx.PutPixel( 37 + x,129 + y,221,225,225 );
	gfx.PutPixel( 38 + x,129 + y,221,225,225 );
	gfx.PutPixel( 39 + x,129 + y,221,225,225 );
	gfx.PutPixel( 40 + x,129 + y,221,225,225 );
	gfx.PutPixel( 41 + x,129 + y,221,225,225 );
	gfx.PutPixel( 42 + x,129 + y,221,225,225 );
	gfx.PutPixel( 43 + x,129 + y,221,226,226 );
	gfx.PutPixel( 44 + x,129 + y,221,230,230 );
	gfx.PutPixel( 45 + x,129 + y,211,78,78 );
	gfx.PutPixel( 46 + x,129 + y,208,30,30 );
	gfx.PutPixel( 47 + x,129 + y,219,195,195 );
	gfx.PutPixel( 48 + x,129 + y,222,231,231 );
	gfx.PutPixel( 49 + x,129 + y,221,226,226 );
	gfx.PutPixel( 50 + x,129 + y,221,227,227 );
	gfx.PutPixel( 51 + x,129 + y,211,77,77 );
	gfx.PutPixel( 52 + x,129 + y,207,26,26 );
	gfx.PutPixel( 53 + x,129 + y,208,34,34 );
	gfx.PutPixel( 54 + x,129 + y,208,34,34 );
	gfx.PutPixel( 55 + x,129 + y,208,34,34 );
	gfx.PutPixel( 56 + x,129 + y,208,34,34 );
	gfx.PutPixel( 57 + x,129 + y,208,34,34 );
	gfx.PutPixel( 58 + x,129 + y,207,22,22 );
	gfx.PutPixel( 59 + x,129 + y,215,135,135 );
	gfx.PutPixel( 60 + x,129 + y,222,236,236 );
	gfx.PutPixel( 61 + x,129 + y,221,224,224 );
	gfx.PutPixel( 62 + x,129 + y,222,235,235 );
	gfx.PutPixel( 63 + x,129 + y,217,160,160 );
	gfx.PutPixel( 64 + x,129 + y,207,25,25 );
	gfx.PutPixel( 65 + x,129 + y,208,33,33 );
	gfx.PutPixel( 66 + x,129 + y,208,27,27 );
	gfx.PutPixel( 67 + x,129 + y,218,176,176 );
	gfx.PutPixel( 68 + x,129 + y,222,234,234 );
	gfx.PutPixel( 69 + x,129 + y,222,234,234 );
	gfx.PutPixel( 70 + x,129 + y,218,176,176 );
	gfx.PutPixel( 71 + x,129 + y,208,27,27 );
	gfx.PutPixel( 72 + x,129 + y,208,34,34 );
	gfx.PutPixel( 73 + x,129 + y,208,34,34 );
	gfx.PutPixel( 74 + x,129 + y,208,34,34 );
	gfx.PutPixel( 75 + x,129 + y,208,34,34 );
	gfx.PutPixel( 76 + x,129 + y,208,34,34 );
	gfx.PutPixel( 77 + x,129 + y,208,34,34 );
	gfx.PutPixel( 78 + x,129 + y,208,34,34 );
	gfx.PutPixel( 79 + x,129 + y,208,34,34 );
	gfx.PutPixel( 80 + x,129 + y,208,34,34 );
	gfx.PutPixel( 81 + x,129 + y,208,34,34 );
	gfx.PutPixel( 82 + x,129 + y,208,34,34 );
	gfx.PutPixel( 83 + x,129 + y,207,22,22 );
	gfx.PutPixel( 84 + x,129 + y,215,130,130 );
	gfx.PutPixel( 85 + x,129 + y,222,237,237 );
	gfx.PutPixel( 86 + x,129 + y,221,225,225 );
	gfx.PutPixel( 87 + x,129 + y,221,225,225 );
	gfx.PutPixel( 88 + x,129 + y,221,225,225 );
	gfx.PutPixel( 89 + x,129 + y,221,225,225 );
	gfx.PutPixel( 90 + x,129 + y,221,225,225 );
	gfx.PutPixel( 91 + x,129 + y,221,225,225 );
	gfx.PutPixel( 92 + x,129 + y,221,227,227 );
	gfx.PutPixel( 93 + x,129 + y,222,231,231 );
	gfx.PutPixel( 94 + x,129 + y,222,232,232 );
	gfx.PutPixel( 95 + x,129 + y,220,203,203 );
	gfx.PutPixel( 96 + x,129 + y,213,112,112 );
	gfx.PutPixel( 97 + x,129 + y,208,29,29 );
	gfx.PutPixel( 98 + x,129 + y,208,30,30 );
	gfx.PutPixel( 99 + x,129 + y,208,34,34 );
	gfx.PutPixel( 100 + x,129 + y,207,23,23 );
	gfx.PutPixel( 101 + x,129 + y,213,108,108 );
	gfx.PutPixel( 102 + x,129 + y,222,235,235 );
	gfx.PutPixel( 103 + x,129 + y,221,224,224 );
	gfx.PutPixel( 104 + x,129 + y,222,234,234 );
	gfx.PutPixel( 105 + x,129 + y,217,166,166 );
	gfx.PutPixel( 106 + x,129 + y,207,26,26 );
	gfx.PutPixel( 107 + x,129 + y,208,33,33 );
	gfx.PutPixel( 108 + x,129 + y,208,34,34 );
	gfx.PutPixel( 109 + x,129 + y,208,34,34 );
	gfx.PutPixel( 110 + x,129 + y,208,34,34 );
	gfx.PutPixel( 111 + x,129 + y,208,34,34 );
	gfx.PutPixel( 112 + x,129 + y,208,29,29 );
	gfx.PutPixel( 113 + x,129 + y,209,53,53 );
	gfx.PutPixel( 114 + x,129 + y,221,213,213 );
	gfx.PutPixel( 115 + x,129 + y,221,228,228 );
	gfx.PutPixel( 116 + x,129 + y,221,226,226 );
	gfx.PutPixel( 117 + x,129 + y,221,225,225 );
	gfx.PutPixel( 118 + x,129 + y,211,71,71 );
	gfx.PutPixel( 119 + x,129 + y,207,27,27 );
	gfx.PutPixel( 120 + x,129 + y,208,34,34 );
	gfx.PutPixel( 121 + x,129 + y,208,34,34 );
	gfx.PutPixel( 122 + x,129 + y,208,34,34 );
	gfx.PutPixel( 123 + x,129 + y,208,34,34 );
	gfx.PutPixel( 124 + x,129 + y,208,34,34 );
	gfx.PutPixel( 125 + x,129 + y,208,34,34 );
	gfx.PutPixel( 126 + x,129 + y,208,34,34 );
	gfx.PutPixel( 127 + x,129 + y,208,34,34 );
	gfx.PutPixel( 128 + x,129 + y,208,34,34 );
	gfx.PutPixel( 129 + x,129 + y,208,34,34 );
	gfx.PutPixel( 130 + x,129 + y,208,34,34 );
	gfx.PutPixel( 131 + x,129 + y,208,34,34 );
	gfx.PutPixel( 132 + x,129 + y,208,34,34 );
	gfx.PutPixel( 133 + x,129 + y,208,34,34 );
	gfx.PutPixel( 134 + x,129 + y,208,34,34 );
	gfx.PutPixel( 135 + x,129 + y,208,34,34 );
	gfx.PutPixel( 136 + x,129 + y,208,34,34 );
	gfx.PutPixel( 137 + x,129 + y,208,34,34 );
	gfx.PutPixel( 138 + x,129 + y,208,34,34 );
	gfx.PutPixel( 139 + x,129 + y,208,34,34 );
	gfx.PutPixel( 140 + x,129 + y,208,34,34 );
	gfx.PutPixel( 141 + x,129 + y,208,34,34 );
	gfx.PutPixel( 142 + x,129 + y,208,34,34 );
	gfx.PutPixel( 143 + x,129 + y,208,34,34 );
	gfx.PutPixel( 144 + x,129 + y,208,34,34 );
	gfx.PutPixel( 145 + x,129 + y,208,34,34 );
	gfx.PutPixel( 146 + x,129 + y,208,34,34 );
	gfx.PutPixel( 147 + x,129 + y,208,34,34 );
	gfx.PutPixel( 148 + x,129 + y,208,34,34 );
	gfx.PutPixel( 149 + x,129 + y,208,34,34 );
	gfx.PutPixel( 0 + x,130 + y,208,34,34 );
	gfx.PutPixel( 1 + x,130 + y,208,34,34 );
	gfx.PutPixel( 2 + x,130 + y,208,34,34 );
	gfx.PutPixel( 3 + x,130 + y,208,34,34 );
	gfx.PutPixel( 4 + x,130 + y,208,34,34 );
	gfx.PutPixel( 5 + x,130 + y,208,34,34 );
	gfx.PutPixel( 6 + x,130 + y,208,34,34 );
	gfx.PutPixel( 7 + x,130 + y,208,34,34 );
	gfx.PutPixel( 8 + x,130 + y,208,34,34 );
	gfx.PutPixel( 9 + x,130 + y,208,34,34 );
	gfx.PutPixel( 10 + x,130 + y,208,34,34 );
	gfx.PutPixel( 11 + x,130 + y,208,34,34 );
	gfx.PutPixel( 12 + x,130 + y,208,34,34 );
	gfx.PutPixel( 13 + x,130 + y,208,34,34 );
	gfx.PutPixel( 14 + x,130 + y,208,34,34 );
	gfx.PutPixel( 15 + x,130 + y,208,34,34 );
	gfx.PutPixel( 16 + x,130 + y,208,34,34 );
	gfx.PutPixel( 17 + x,130 + y,208,34,34 );
	gfx.PutPixel( 18 + x,130 + y,208,34,34 );
	gfx.PutPixel( 19 + x,130 + y,208,34,34 );
	gfx.PutPixel( 20 + x,130 + y,208,34,34 );
	gfx.PutPixel( 21 + x,130 + y,208,34,34 );
	gfx.PutPixel( 22 + x,130 + y,208,34,34 );
	gfx.PutPixel( 23 + x,130 + y,208,34,34 );
	gfx.PutPixel( 24 + x,130 + y,208,34,34 );
	gfx.PutPixel( 25 + x,130 + y,208,34,34 );
	gfx.PutPixel( 26 + x,130 + y,208,34,34 );
	gfx.PutPixel( 27 + x,130 + y,208,34,34 );
	gfx.PutPixel( 28 + x,130 + y,208,34,34 );
	gfx.PutPixel( 29 + x,130 + y,208,34,34 );
	gfx.PutPixel( 30 + x,130 + y,208,34,34 );
	gfx.PutPixel( 31 + x,130 + y,208,34,34 );
	gfx.PutPixel( 32 + x,130 + y,207,23,23 );
	gfx.PutPixel( 33 + x,130 + y,215,121,121 );
	gfx.PutPixel( 34 + x,130 + y,221,219,219 );
	gfx.PutPixel( 35 + x,130 + y,220,208,208 );
	gfx.PutPixel( 36 + x,130 + y,220,208,208 );
	gfx.PutPixel( 37 + x,130 + y,220,208,208 );
	gfx.PutPixel( 38 + x,130 + y,220,208,208 );
	gfx.PutPixel( 39 + x,130 + y,220,208,208 );
	gfx.PutPixel( 40 + x,130 + y,220,208,208 );
	gfx.PutPixel( 41 + x,130 + y,220,208,208 );
	gfx.PutPixel( 42 + x,130 + y,220,208,208 );
	gfx.PutPixel( 43 + x,130 + y,220,209,209 );
	gfx.PutPixel( 44 + x,130 + y,220,212,212 );
	gfx.PutPixel( 45 + x,130 + y,210,68,68 );
	gfx.PutPixel( 46 + x,130 + y,211,80,80 );
	gfx.PutPixel( 47 + x,130 + y,221,215,215 );
	gfx.PutPixel( 48 + x,130 + y,220,208,208 );
	gfx.PutPixel( 49 + x,130 + y,221,214,214 );
	gfx.PutPixel( 50 + x,130 + y,218,171,171 );
	gfx.PutPixel( 51 + x,130 + y,208,32,32 );
	gfx.PutPixel( 52 + x,130 + y,208,33,33 );
	gfx.PutPixel( 53 + x,130 + y,208,34,34 );
	gfx.PutPixel( 54 + x,130 + y,208,34,34 );
	gfx.PutPixel( 55 + x,130 + y,208,34,34 );
	gfx.PutPixel( 56 + x,130 + y,208,34,34 );
	gfx.PutPixel( 57 + x,130 + y,208,34,34 );
	gfx.PutPixel( 58 + x,130 + y,208,28,28 );
	gfx.PutPixel( 59 + x,130 + y,210,63,63 );
	gfx.PutPixel( 60 + x,130 + y,220,205,205 );
	gfx.PutPixel( 61 + x,130 + y,220,209,209 );
	gfx.PutPixel( 62 + x,130 + y,220,210,210 );
	gfx.PutPixel( 63 + x,130 + y,219,202,202 );
	gfx.PutPixel( 64 + x,130 + y,210,57,57 );
	gfx.PutPixel( 65 + x,130 + y,208,29,29 );
	gfx.PutPixel( 66 + x,130 + y,208,27,27 );
	gfx.PutPixel( 67 + x,130 + y,217,163,163 );
	gfx.PutPixel( 68 + x,130 + y,221,216,216 );
	gfx.PutPixel( 69 + x,130 + y,221,216,216 );
	gfx.PutPixel( 70 + x,130 + y,217,163,163 );
	gfx.PutPixel( 71 + x,130 + y,208,27,27 );
	gfx.PutPixel( 72 + x,130 + y,208,34,34 );
	gfx.PutPixel( 73 + x,130 + y,208,34,34 );
	gfx.PutPixel( 74 + x,130 + y,208,34,34 );
	gfx.PutPixel( 75 + x,130 + y,208,34,34 );
	gfx.PutPixel( 76 + x,130 + y,208,34,34 );
	gfx.PutPixel( 77 + x,130 + y,208,34,34 );
	gfx.PutPixel( 78 + x,130 + y,208,34,34 );
	gfx.PutPixel( 79 + x,130 + y,208,34,34 );
	gfx.PutPixel( 80 + x,130 + y,208,34,34 );
	gfx.PutPixel( 81 + x,130 + y,208,34,34 );
	gfx.PutPixel( 82 + x,130 + y,208,34,34 );
	gfx.PutPixel( 83 + x,130 + y,207,23,23 );
	gfx.PutPixel( 84 + x,130 + y,215,121,121 );
	gfx.PutPixel( 85 + x,130 + y,221,219,219 );
	gfx.PutPixel( 86 + x,130 + y,220,208,208 );
	gfx.PutPixel( 87 + x,130 + y,220,208,208 );
	gfx.PutPixel( 88 + x,130 + y,220,208,208 );
	gfx.PutPixel( 89 + x,130 + y,220,208,208 );
	gfx.PutPixel( 90 + x,130 + y,220,208,208 );
	gfx.PutPixel( 91 + x,130 + y,220,203,203 );
	gfx.PutPixel( 92 + x,130 + y,219,189,189 );
	gfx.PutPixel( 93 + x,130 + y,217,157,157 );
	gfx.PutPixel( 94 + x,130 + y,213,104,104 );
	gfx.PutPixel( 95 + x,130 + y,209,45,45 );
	gfx.PutPixel( 96 + x,130 + y,207,23,23 );
	gfx.PutPixel( 97 + x,130 + y,208,32,32 );
	gfx.PutPixel( 98 + x,130 + y,208,34,34 );
	gfx.PutPixel( 99 + x,130 + y,208,33,33 );
	gfx.PutPixel( 100 + x,130 + y,208,32,32 );
	gfx.PutPixel( 101 + x,130 + y,218,169,169 );
	gfx.PutPixel( 102 + x,130 + y,221,215,215 );
	gfx.PutPixel( 103 + x,130 + y,220,208,208 );
	gfx.PutPixel( 104 + x,130 + y,221,214,214 );
	gfx.PutPixel( 105 + x,130 + y,212,90,90 );
	gfx.PutPixel( 106 + x,130 + y,207,24,24 );
	gfx.PutPixel( 107 + x,130 + y,208,34,34 );
	gfx.PutPixel( 108 + x,130 + y,208,34,34 );
	gfx.PutPixel( 109 + x,130 + y,208,34,34 );
	gfx.PutPixel( 110 + x,130 + y,208,34,34 );
	gfx.PutPixel( 111 + x,130 + y,208,34,34 );
	gfx.PutPixel( 112 + x,130 + y,208,34,34 );
	gfx.PutPixel( 113 + x,130 + y,207,24,24 );
	gfx.PutPixel( 114 + x,130 + y,216,143,143 );
	gfx.PutPixel( 115 + x,130 + y,221,217,217 );
	gfx.PutPixel( 116 + x,130 + y,220,208,208 );
	gfx.PutPixel( 117 + x,130 + y,221,219,219 );
	gfx.PutPixel( 118 + x,130 + y,215,135,135 );
	gfx.PutPixel( 119 + x,130 + y,207,25,25 );
	gfx.PutPixel( 120 + x,130 + y,208,34,34 );
	gfx.PutPixel( 121 + x,130 + y,208,34,34 );
	gfx.PutPixel( 122 + x,130 + y,208,34,34 );
	gfx.PutPixel( 123 + x,130 + y,208,34,34 );
	gfx.PutPixel( 124 + x,130 + y,208,34,34 );
	gfx.PutPixel( 125 + x,130 + y,208,34,34 );
	gfx.PutPixel( 126 + x,130 + y,208,34,34 );
	gfx.PutPixel( 127 + x,130 + y,208,34,34 );
	gfx.PutPixel( 128 + x,130 + y,208,34,34 );
	gfx.PutPixel( 129 + x,130 + y,208,34,34 );
	gfx.PutPixel( 130 + x,130 + y,208,34,34 );
	gfx.PutPixel( 131 + x,130 + y,208,34,34 );
	gfx.PutPixel( 132 + x,130 + y,208,34,34 );
	gfx.PutPixel( 133 + x,130 + y,208,34,34 );
	gfx.PutPixel( 134 + x,130 + y,208,34,34 );
	gfx.PutPixel( 135 + x,130 + y,208,34,34 );
	gfx.PutPixel( 136 + x,130 + y,208,34,34 );
	gfx.PutPixel( 137 + x,130 + y,208,34,34 );
	gfx.PutPixel( 138 + x,130 + y,208,34,34 );
	gfx.PutPixel( 139 + x,130 + y,208,34,34 );
	gfx.PutPixel( 140 + x,130 + y,208,34,34 );
	gfx.PutPixel( 141 + x,130 + y,208,34,34 );
	gfx.PutPixel( 142 + x,130 + y,208,34,34 );
	gfx.PutPixel( 143 + x,130 + y,208,34,34 );
	gfx.PutPixel( 144 + x,130 + y,208,34,34 );
	gfx.PutPixel( 145 + x,130 + y,208,34,34 );
	gfx.PutPixel( 146 + x,130 + y,208,34,34 );
	gfx.PutPixel( 147 + x,130 + y,208,34,34 );
	gfx.PutPixel( 148 + x,130 + y,208,34,34 );
	gfx.PutPixel( 149 + x,130 + y,208,34,34 );
	gfx.PutPixel( 0 + x,131 + y,208,34,34 );
	gfx.PutPixel( 1 + x,131 + y,208,34,34 );
	gfx.PutPixel( 2 + x,131 + y,208,34,34 );
	gfx.PutPixel( 3 + x,131 + y,208,34,34 );
	gfx.PutPixel( 4 + x,131 + y,208,34,34 );
	gfx.PutPixel( 5 + x,131 + y,208,34,34 );
	gfx.PutPixel( 6 + x,131 + y,208,34,34 );
	gfx.PutPixel( 7 + x,131 + y,208,34,34 );
	gfx.PutPixel( 8 + x,131 + y,208,34,34 );
	gfx.PutPixel( 9 + x,131 + y,208,34,34 );
	gfx.PutPixel( 10 + x,131 + y,208,34,34 );
	gfx.PutPixel( 11 + x,131 + y,208,34,34 );
	gfx.PutPixel( 12 + x,131 + y,208,34,34 );
	gfx.PutPixel( 13 + x,131 + y,208,34,34 );
	gfx.PutPixel( 14 + x,131 + y,208,34,34 );
	gfx.PutPixel( 15 + x,131 + y,208,34,34 );
	gfx.PutPixel( 16 + x,131 + y,208,34,34 );
	gfx.PutPixel( 17 + x,131 + y,208,34,34 );
	gfx.PutPixel( 18 + x,131 + y,208,34,34 );
	gfx.PutPixel( 19 + x,131 + y,208,34,34 );
	gfx.PutPixel( 20 + x,131 + y,208,34,34 );
	gfx.PutPixel( 21 + x,131 + y,208,34,34 );
	gfx.PutPixel( 22 + x,131 + y,208,34,34 );
	gfx.PutPixel( 23 + x,131 + y,208,34,34 );
	gfx.PutPixel( 24 + x,131 + y,208,34,34 );
	gfx.PutPixel( 25 + x,131 + y,208,34,34 );
	gfx.PutPixel( 26 + x,131 + y,208,34,34 );
	gfx.PutPixel( 27 + x,131 + y,208,34,34 );
	gfx.PutPixel( 28 + x,131 + y,208,34,34 );
	gfx.PutPixel( 29 + x,131 + y,208,34,34 );
	gfx.PutPixel( 30 + x,131 + y,208,34,34 );
	gfx.PutPixel( 31 + x,131 + y,208,34,34 );
	gfx.PutPixel( 32 + x,131 + y,208,33,33 );
	gfx.PutPixel( 33 + x,131 + y,208,41,41 );
	gfx.PutPixel( 34 + x,131 + y,209,48,48 );
	gfx.PutPixel( 35 + x,131 + y,209,47,47 );
	gfx.PutPixel( 36 + x,131 + y,209,47,47 );
	gfx.PutPixel( 37 + x,131 + y,209,47,47 );
	gfx.PutPixel( 38 + x,131 + y,209,47,47 );
	gfx.PutPixel( 39 + x,131 + y,209,47,47 );
	gfx.PutPixel( 40 + x,131 + y,209,47,47 );
	gfx.PutPixel( 41 + x,131 + y,209,47,47 );
	gfx.PutPixel( 42 + x,131 + y,209,47,47 );
	gfx.PutPixel( 43 + x,131 + y,209,47,47 );
	gfx.PutPixel( 44 + x,131 + y,209,48,48 );
	gfx.PutPixel( 45 + x,131 + y,208,36,36 );
	gfx.PutPixel( 46 + x,131 + y,209,43,43 );
	gfx.PutPixel( 47 + x,131 + y,209,49,49 );
	gfx.PutPixel( 48 + x,131 + y,209,47,47 );
	gfx.PutPixel( 49 + x,131 + y,209,48,48 );
	gfx.PutPixel( 50 + x,131 + y,208,40,40 );
	gfx.PutPixel( 51 + x,131 + y,208,32,32 );
	gfx.PutPixel( 52 + x,131 + y,208,34,34 );
	gfx.PutPixel( 53 + x,131 + y,208,34,34 );
	gfx.PutPixel( 54 + x,131 + y,208,34,34 );
	gfx.PutPixel( 55 + x,131 + y,208,34,34 );
	gfx.PutPixel( 56 + x,131 + y,208,34,34 );
	gfx.PutPixel( 57 + x,131 + y,208,34,34 );
	gfx.PutPixel( 58 + x,131 + y,208,34,34 );
	gfx.PutPixel( 59 + x,131 + y,208,32,32 );
	gfx.PutPixel( 60 + x,131 + y,209,45,45 );
	gfx.PutPixel( 61 + x,131 + y,209,48,48 );
	gfx.PutPixel( 62 + x,131 + y,209,47,47 );
	gfx.PutPixel( 63 + x,131 + y,209,49,49 );
	gfx.PutPixel( 64 + x,131 + y,208,40,40 );
	gfx.PutPixel( 65 + x,131 + y,208,33,33 );
	gfx.PutPixel( 66 + x,131 + y,208,34,34 );
	gfx.PutPixel( 67 + x,131 + y,209,44,44 );
	gfx.PutPixel( 68 + x,131 + y,209,48,48 );
	gfx.PutPixel( 69 + x,131 + y,209,48,48 );
	gfx.PutPixel( 70 + x,131 + y,209,44,44 );
	gfx.PutPixel( 71 + x,131 + y,208,34,34 );
	gfx.PutPixel( 72 + x,131 + y,208,34,34 );
	gfx.PutPixel( 73 + x,131 + y,208,34,34 );
	gfx.PutPixel( 74 + x,131 + y,208,34,34 );
	gfx.PutPixel( 75 + x,131 + y,208,34,34 );
	gfx.PutPixel( 76 + x,131 + y,208,34,34 );
	gfx.PutPixel( 77 + x,131 + y,208,34,34 );
	gfx.PutPixel( 78 + x,131 + y,208,34,34 );
	gfx.PutPixel( 79 + x,131 + y,208,34,34 );
	gfx.PutPixel( 80 + x,131 + y,208,34,34 );
	gfx.PutPixel( 81 + x,131 + y,208,34,34 );
	gfx.PutPixel( 82 + x,131 + y,208,34,34 );
	gfx.PutPixel( 83 + x,131 + y,208,33,33 );
	gfx.PutPixel( 84 + x,131 + y,208,41,41 );
	gfx.PutPixel( 85 + x,131 + y,209,48,48 );
	gfx.PutPixel( 86 + x,131 + y,209,47,47 );
	gfx.PutPixel( 87 + x,131 + y,209,47,47 );
	gfx.PutPixel( 88 + x,131 + y,209,47,47 );
	gfx.PutPixel( 89 + x,131 + y,209,47,47 );
	gfx.PutPixel( 90 + x,131 + y,209,47,47 );
	gfx.PutPixel( 91 + x,131 + y,209,45,45 );
	gfx.PutPixel( 92 + x,131 + y,208,36,36 );
	gfx.PutPixel( 93 + x,131 + y,207,25,25 );
	gfx.PutPixel( 94 + x,131 + y,207,23,23 );
	gfx.PutPixel( 95 + x,131 + y,208,31,31 );
	gfx.PutPixel( 96 + x,131 + y,208,34,34 );
	gfx.PutPixel( 97 + x,131 + y,208,34,34 );
	gfx.PutPixel( 98 + x,131 + y,208,34,34 );
	gfx.PutPixel( 99 + x,131 + y,208,34,34 );
	gfx.PutPixel( 100 + x,131 + y,208,36,36 );
	gfx.PutPixel( 101 + x,131 + y,209,49,49 );
	gfx.PutPixel( 102 + x,131 + y,209,47,47 );
	gfx.PutPixel( 103 + x,131 + y,209,47,47 );
	gfx.PutPixel( 104 + x,131 + y,209,47,47 );
	gfx.PutPixel( 105 + x,131 + y,208,34,34 );
	gfx.PutPixel( 106 + x,131 + y,208,34,34 );
	gfx.PutPixel( 107 + x,131 + y,208,34,34 );
	gfx.PutPixel( 108 + x,131 + y,208,34,34 );
	gfx.PutPixel( 109 + x,131 + y,208,34,34 );
	gfx.PutPixel( 110 + x,131 + y,208,34,34 );
	gfx.PutPixel( 111 + x,131 + y,208,34,34 );
	gfx.PutPixel( 112 + x,131 + y,208,34,34 );
	gfx.PutPixel( 113 + x,131 + y,208,33,33 );
	gfx.PutPixel( 114 + x,131 + y,208,37,37 );
	gfx.PutPixel( 115 + x,131 + y,209,48,48 );
	gfx.PutPixel( 116 + x,131 + y,209,47,47 );
	gfx.PutPixel( 117 + x,131 + y,209,48,48 );
	gfx.PutPixel( 118 + x,131 + y,209,47,47 );
	gfx.PutPixel( 119 + x,131 + y,208,34,34 );
	gfx.PutPixel( 120 + x,131 + y,208,34,34 );
	gfx.PutPixel( 121 + x,131 + y,208,34,34 );
	gfx.PutPixel( 122 + x,131 + y,208,34,34 );
	gfx.PutPixel( 123 + x,131 + y,208,34,34 );
	gfx.PutPixel( 124 + x,131 + y,208,34,34 );
	gfx.PutPixel( 125 + x,131 + y,208,34,34 );
	gfx.PutPixel( 126 + x,131 + y,208,34,34 );
	gfx.PutPixel( 127 + x,131 + y,208,34,34 );
	gfx.PutPixel( 128 + x,131 + y,208,34,34 );
	gfx.PutPixel( 129 + x,131 + y,208,34,34 );
	gfx.PutPixel( 130 + x,131 + y,208,34,34 );
	gfx.PutPixel( 131 + x,131 + y,208,34,34 );
	gfx.PutPixel( 132 + x,131 + y,208,34,34 );
	gfx.PutPixel( 133 + x,131 + y,208,34,34 );
	gfx.PutPixel( 134 + x,131 + y,208,34,34 );
	gfx.PutPixel( 135 + x,131 + y,208,34,34 );
	gfx.PutPixel( 136 + x,131 + y,208,34,34 );
	gfx.PutPixel( 137 + x,131 + y,208,34,34 );
	gfx.PutPixel( 138 + x,131 + y,208,34,34 );
	gfx.PutPixel( 139 + x,131 + y,208,34,34 );
	gfx.PutPixel( 140 + x,131 + y,208,34,34 );
	gfx.PutPixel( 141 + x,131 + y,208,34,34 );
	gfx.PutPixel( 142 + x,131 + y,208,34,34 );
	gfx.PutPixel( 143 + x,131 + y,208,34,34 );
	gfx.PutPixel( 144 + x,131 + y,208,34,34 );
	gfx.PutPixel( 145 + x,131 + y,208,34,34 );
	gfx.PutPixel( 146 + x,131 + y,208,34,34 );
	gfx.PutPixel( 147 + x,131 + y,208,34,34 );
	gfx.PutPixel( 148 + x,131 + y,208,34,34 );
	gfx.PutPixel( 149 + x,131 + y,208,34,34 );
	gfx.PutPixel( 0 + x,132 + y,208,34,34 );
	gfx.PutPixel( 1 + x,132 + y,208,34,34 );
	gfx.PutPixel( 2 + x,132 + y,208,34,34 );
	gfx.PutPixel( 3 + x,132 + y,208,34,34 );
	gfx.PutPixel( 4 + x,132 + y,208,34,34 );
	gfx.PutPixel( 5 + x,132 + y,208,34,34 );
	gfx.PutPixel( 6 + x,132 + y,208,34,34 );
	gfx.PutPixel( 7 + x,132 + y,208,34,34 );
	gfx.PutPixel( 8 + x,132 + y,208,34,34 );
	gfx.PutPixel( 9 + x,132 + y,208,34,34 );
	gfx.PutPixel( 10 + x,132 + y,208,34,34 );
	gfx.PutPixel( 11 + x,132 + y,208,34,34 );
	gfx.PutPixel( 12 + x,132 + y,208,34,34 );
	gfx.PutPixel( 13 + x,132 + y,208,34,34 );
	gfx.PutPixel( 14 + x,132 + y,208,34,34 );
	gfx.PutPixel( 15 + x,132 + y,208,34,34 );
	gfx.PutPixel( 16 + x,132 + y,208,34,34 );
	gfx.PutPixel( 17 + x,132 + y,208,34,34 );
	gfx.PutPixel( 18 + x,132 + y,208,34,34 );
	gfx.PutPixel( 19 + x,132 + y,208,34,34 );
	gfx.PutPixel( 20 + x,132 + y,208,34,34 );
	gfx.PutPixel( 21 + x,132 + y,208,34,34 );
	gfx.PutPixel( 22 + x,132 + y,208,34,34 );
	gfx.PutPixel( 23 + x,132 + y,208,34,34 );
	gfx.PutPixel( 24 + x,132 + y,208,34,34 );
	gfx.PutPixel( 25 + x,132 + y,208,34,34 );
	gfx.PutPixel( 26 + x,132 + y,208,34,34 );
	gfx.PutPixel( 27 + x,132 + y,208,34,34 );
	gfx.PutPixel( 28 + x,132 + y,208,34,34 );
	gfx.PutPixel( 29 + x,132 + y,208,34,34 );
	gfx.PutPixel( 30 + x,132 + y,208,34,34 );
	gfx.PutPixel( 31 + x,132 + y,208,34,34 );
	gfx.PutPixel( 32 + x,132 + y,208,34,34 );
	gfx.PutPixel( 33 + x,132 + y,208,32,32 );
	gfx.PutPixel( 34 + x,132 + y,208,30,30 );
	gfx.PutPixel( 35 + x,132 + y,208,30,30 );
	gfx.PutPixel( 36 + x,132 + y,208,30,30 );
	gfx.PutPixel( 37 + x,132 + y,208,30,30 );
	gfx.PutPixel( 38 + x,132 + y,208,30,30 );
	gfx.PutPixel( 39 + x,132 + y,208,30,30 );
	gfx.PutPixel( 40 + x,132 + y,208,30,30 );
	gfx.PutPixel( 41 + x,132 + y,208,30,30 );
	gfx.PutPixel( 42 + x,132 + y,208,30,30 );
	gfx.PutPixel( 43 + x,132 + y,208,30,30 );
	gfx.PutPixel( 44 + x,132 + y,208,30,30 );
	gfx.PutPixel( 45 + x,132 + y,208,33,33 );
	gfx.PutPixel( 46 + x,132 + y,208,33,33 );
	gfx.PutPixel( 47 + x,132 + y,208,30,30 );
	gfx.PutPixel( 48 + x,132 + y,208,30,30 );
	gfx.PutPixel( 49 + x,132 + y,208,30,30 );
	gfx.PutPixel( 50 + x,132 + y,208,32,32 );
	gfx.PutPixel( 51 + x,132 + y,208,34,34 );
	gfx.PutPixel( 52 + x,132 + y,208,34,34 );
	gfx.PutPixel( 53 + x,132 + y,208,34,34 );
	gfx.PutPixel( 54 + x,132 + y,208,34,34 );
	gfx.PutPixel( 55 + x,132 + y,208,34,34 );
	gfx.PutPixel( 56 + x,132 + y,208,34,34 );
	gfx.PutPixel( 57 + x,132 + y,208,34,34 );
	gfx.PutPixel( 58 + x,132 + y,208,34,34 );
	gfx.PutPixel( 59 + x,132 + y,208,34,34 );
	gfx.PutPixel( 60 + x,132 + y,208,31,31 );
	gfx.PutPixel( 61 + x,132 + y,208,30,30 );
	gfx.PutPixel( 62 + x,132 + y,208,30,30 );
	gfx.PutPixel( 63 + x,132 + y,208,30,30 );
	gfx.PutPixel( 64 + x,132 + y,208,33,33 );
	gfx.PutPixel( 65 + x,132 + y,208,34,34 );
	gfx.PutPixel( 66 + x,132 + y,208,34,34 );
	gfx.PutPixel( 67 + x,132 + y,208,31,31 );
	gfx.PutPixel( 68 + x,132 + y,208,30,30 );
	gfx.PutPixel( 69 + x,132 + y,208,30,30 );
	gfx.PutPixel( 70 + x,132 + y,208,31,31 );
	gfx.PutPixel( 71 + x,132 + y,208,34,34 );
	gfx.PutPixel( 72 + x,132 + y,208,34,34 );
	gfx.PutPixel( 73 + x,132 + y,208,34,34 );
	gfx.PutPixel( 74 + x,132 + y,208,34,34 );
	gfx.PutPixel( 75 + x,132 + y,208,34,34 );
	gfx.PutPixel( 76 + x,132 + y,208,34,34 );
	gfx.PutPixel( 77 + x,132 + y,208,34,34 );
	gfx.PutPixel( 78 + x,132 + y,208,34,34 );
	gfx.PutPixel( 79 + x,132 + y,208,34,34 );
	gfx.PutPixel( 80 + x,132 + y,208,34,34 );
	gfx.PutPixel( 81 + x,132 + y,208,34,34 );
	gfx.PutPixel( 82 + x,132 + y,208,34,34 );
	gfx.PutPixel( 83 + x,132 + y,208,34,34 );
	gfx.PutPixel( 84 + x,132 + y,208,32,32 );
	gfx.PutPixel( 85 + x,132 + y,208,30,30 );
	gfx.PutPixel( 86 + x,132 + y,208,30,30 );
	gfx.PutPixel( 87 + x,132 + y,208,30,30 );
	gfx.PutPixel( 88 + x,132 + y,208,30,30 );
	gfx.PutPixel( 89 + x,132 + y,208,30,30 );
	gfx.PutPixel( 90 + x,132 + y,208,30,30 );
	gfx.PutPixel( 91 + x,132 + y,208,31,31 );
	gfx.PutPixel( 92 + x,132 + y,208,32,32 );
	gfx.PutPixel( 93 + x,132 + y,208,34,34 );
	gfx.PutPixel( 94 + x,132 + y,208,34,34 );
	gfx.PutPixel( 95 + x,132 + y,208,34,34 );
	gfx.PutPixel( 96 + x,132 + y,208,34,34 );
	gfx.PutPixel( 97 + x,132 + y,208,34,34 );
	gfx.PutPixel( 98 + x,132 + y,208,34,34 );
	gfx.PutPixel( 99 + x,132 + y,208,34,34 );
	gfx.PutPixel( 100 + x,132 + y,208,34,34 );
	gfx.PutPixel( 101 + x,132 + y,208,31,31 );
	gfx.PutPixel( 102 + x,132 + y,208,30,30 );
	gfx.PutPixel( 103 + x,132 + y,208,30,30 );
	gfx.PutPixel( 104 + x,132 + y,208,30,30 );
	gfx.PutPixel( 105 + x,132 + y,208,33,33 );
	gfx.PutPixel( 106 + x,132 + y,208,34,34 );
	gfx.PutPixel( 107 + x,132 + y,208,34,34 );
	gfx.PutPixel( 108 + x,132 + y,208,34,34 );
	gfx.PutPixel( 109 + x,132 + y,208,34,34 );
	gfx.PutPixel( 110 + x,132 + y,208,34,34 );
	gfx.PutPixel( 111 + x,132 + y,208,34,34 );
	gfx.PutPixel( 112 + x,132 + y,208,34,34 );
	gfx.PutPixel( 113 + x,132 + y,208,34,34 );
	gfx.PutPixel( 114 + x,132 + y,208,32,32 );
	gfx.PutPixel( 115 + x,132 + y,208,30,30 );
	gfx.PutPixel( 116 + x,132 + y,208,30,30 );
	gfx.PutPixel( 117 + x,132 + y,208,30,30 );
	gfx.PutPixel( 118 + x,132 + y,208,31,31 );
	gfx.PutPixel( 119 + x,132 + y,208,34,34 );
	gfx.PutPixel( 120 + x,132 + y,208,34,34 );
	gfx.PutPixel( 121 + x,132 + y,208,34,34 );
	gfx.PutPixel( 122 + x,132 + y,208,34,34 );
	gfx.PutPixel( 123 + x,132 + y,208,34,34 );
	gfx.PutPixel( 124 + x,132 + y,208,34,34 );
	gfx.PutPixel( 125 + x,132 + y,208,34,34 );
	gfx.PutPixel( 126 + x,132 + y,208,34,34 );
	gfx.PutPixel( 127 + x,132 + y,208,34,34 );
	gfx.PutPixel( 128 + x,132 + y,208,34,34 );
	gfx.PutPixel( 129 + x,132 + y,208,34,34 );
	gfx.PutPixel( 130 + x,132 + y,208,34,34 );
	gfx.PutPixel( 131 + x,132 + y,208,34,34 );
	gfx.PutPixel( 132 + x,132 + y,208,34,34 );
	gfx.PutPixel( 133 + x,132 + y,208,34,34 );
	gfx.PutPixel( 134 + x,132 + y,208,34,34 );
	gfx.PutPixel( 135 + x,132 + y,208,34,34 );
	gfx.PutPixel( 136 + x,132 + y,208,34,34 );
	gfx.PutPixel( 137 + x,132 + y,208,34,34 );
	gfx.PutPixel( 138 + x,132 + y,208,34,34 );
	gfx.PutPixel( 139 + x,132 + y,208,34,34 );
	gfx.PutPixel( 140 + x,132 + y,208,34,34 );
	gfx.PutPixel( 141 + x,132 + y,208,34,34 );
	gfx.PutPixel( 142 + x,132 + y,208,34,34 );
	gfx.PutPixel( 143 + x,132 + y,208,34,34 );
	gfx.PutPixel( 144 + x,132 + y,208,34,34 );
	gfx.PutPixel( 145 + x,132 + y,208,34,34 );
	gfx.PutPixel( 146 + x,132 + y,208,34,34 );
	gfx.PutPixel( 147 + x,132 + y,208,34,34 );
	gfx.PutPixel( 148 + x,132 + y,208,34,34 );
	gfx.PutPixel( 149 + x,132 + y,208,34,34 );
	gfx.PutPixel( 0 + x,133 + y,208,34,34 );
	gfx.PutPixel( 1 + x,133 + y,208,34,34 );
	gfx.PutPixel( 2 + x,133 + y,208,34,34 );
	gfx.PutPixel( 3 + x,133 + y,208,34,34 );
	gfx.PutPixel( 4 + x,133 + y,208,34,34 );
	gfx.PutPixel( 5 + x,133 + y,208,34,34 );
	gfx.PutPixel( 6 + x,133 + y,208,34,34 );
	gfx.PutPixel( 7 + x,133 + y,208,34,34 );
	gfx.PutPixel( 8 + x,133 + y,208,34,34 );
	gfx.PutPixel( 9 + x,133 + y,208,34,34 );
	gfx.PutPixel( 10 + x,133 + y,208,34,34 );
	gfx.PutPixel( 11 + x,133 + y,208,34,34 );
	gfx.PutPixel( 12 + x,133 + y,208,34,34 );
	gfx.PutPixel( 13 + x,133 + y,208,34,34 );
	gfx.PutPixel( 14 + x,133 + y,208,34,34 );
	gfx.PutPixel( 15 + x,133 + y,208,34,34 );
	gfx.PutPixel( 16 + x,133 + y,208,34,34 );
	gfx.PutPixel( 17 + x,133 + y,208,34,34 );
	gfx.PutPixel( 18 + x,133 + y,208,34,34 );
	gfx.PutPixel( 19 + x,133 + y,208,34,34 );
	gfx.PutPixel( 20 + x,133 + y,208,34,34 );
	gfx.PutPixel( 21 + x,133 + y,208,34,34 );
	gfx.PutPixel( 22 + x,133 + y,208,34,34 );
	gfx.PutPixel( 23 + x,133 + y,208,34,34 );
	gfx.PutPixel( 24 + x,133 + y,208,34,34 );
	gfx.PutPixel( 25 + x,133 + y,208,34,34 );
	gfx.PutPixel( 26 + x,133 + y,208,34,34 );
	gfx.PutPixel( 27 + x,133 + y,208,34,34 );
	gfx.PutPixel( 28 + x,133 + y,208,34,34 );
	gfx.PutPixel( 29 + x,133 + y,208,34,34 );
	gfx.PutPixel( 30 + x,133 + y,208,34,34 );
	gfx.PutPixel( 31 + x,133 + y,208,34,34 );
	gfx.PutPixel( 32 + x,133 + y,208,34,34 );
	gfx.PutPixel( 33 + x,133 + y,208,34,34 );
	gfx.PutPixel( 34 + x,133 + y,208,34,34 );
	gfx.PutPixel( 35 + x,133 + y,208,34,34 );
	gfx.PutPixel( 36 + x,133 + y,208,34,34 );
	gfx.PutPixel( 37 + x,133 + y,208,34,34 );
	gfx.PutPixel( 38 + x,133 + y,208,34,34 );
	gfx.PutPixel( 39 + x,133 + y,208,34,34 );
	gfx.PutPixel( 40 + x,133 + y,208,34,34 );
	gfx.PutPixel( 41 + x,133 + y,208,34,34 );
	gfx.PutPixel( 42 + x,133 + y,208,34,34 );
	gfx.PutPixel( 43 + x,133 + y,208,34,34 );
	gfx.PutPixel( 44 + x,133 + y,208,34,34 );
	gfx.PutPixel( 45 + x,133 + y,208,34,34 );
	gfx.PutPixel( 46 + x,133 + y,208,34,34 );
	gfx.PutPixel( 47 + x,133 + y,208,34,34 );
	gfx.PutPixel( 48 + x,133 + y,208,34,34 );
	gfx.PutPixel( 49 + x,133 + y,208,34,34 );
	gfx.PutPixel( 50 + x,133 + y,208,34,34 );
	gfx.PutPixel( 51 + x,133 + y,208,34,34 );
	gfx.PutPixel( 52 + x,133 + y,208,34,34 );
	gfx.PutPixel( 53 + x,133 + y,208,34,34 );
	gfx.PutPixel( 54 + x,133 + y,208,34,34 );
	gfx.PutPixel( 55 + x,133 + y,208,34,34 );
	gfx.PutPixel( 56 + x,133 + y,208,34,34 );
	gfx.PutPixel( 57 + x,133 + y,208,34,34 );
	gfx.PutPixel( 58 + x,133 + y,208,34,34 );
	gfx.PutPixel( 59 + x,133 + y,208,34,34 );
	gfx.PutPixel( 60 + x,133 + y,208,34,34 );
	gfx.PutPixel( 61 + x,133 + y,208,34,34 );
	gfx.PutPixel( 62 + x,133 + y,208,34,34 );
	gfx.PutPixel( 63 + x,133 + y,208,34,34 );
	gfx.PutPixel( 64 + x,133 + y,208,34,34 );
	gfx.PutPixel( 65 + x,133 + y,208,34,34 );
	gfx.PutPixel( 66 + x,133 + y,208,34,34 );
	gfx.PutPixel( 67 + x,133 + y,208,34,34 );
	gfx.PutPixel( 68 + x,133 + y,208,34,34 );
	gfx.PutPixel( 69 + x,133 + y,208,34,34 );
	gfx.PutPixel( 70 + x,133 + y,208,34,34 );
	gfx.PutPixel( 71 + x,133 + y,208,34,34 );
	gfx.PutPixel( 72 + x,133 + y,208,34,34 );
	gfx.PutPixel( 73 + x,133 + y,208,34,34 );
	gfx.PutPixel( 74 + x,133 + y,208,34,34 );
	gfx.PutPixel( 75 + x,133 + y,208,34,34 );
	gfx.PutPixel( 76 + x,133 + y,208,34,34 );
	gfx.PutPixel( 77 + x,133 + y,208,34,34 );
	gfx.PutPixel( 78 + x,133 + y,208,34,34 );
	gfx.PutPixel( 79 + x,133 + y,208,34,34 );
	gfx.PutPixel( 80 + x,133 + y,208,34,34 );
	gfx.PutPixel( 81 + x,133 + y,208,34,34 );
	gfx.PutPixel( 82 + x,133 + y,208,34,34 );
	gfx.PutPixel( 83 + x,133 + y,208,34,34 );
	gfx.PutPixel( 84 + x,133 + y,208,34,34 );
	gfx.PutPixel( 85 + x,133 + y,208,34,34 );
	gfx.PutPixel( 86 + x,133 + y,208,34,34 );
	gfx.PutPixel( 87 + x,133 + y,208,34,34 );
	gfx.PutPixel( 88 + x,133 + y,208,34,34 );
	gfx.PutPixel( 89 + x,133 + y,208,34,34 );
	gfx.PutPixel( 90 + x,133 + y,208,34,34 );
	gfx.PutPixel( 91 + x,133 + y,208,34,34 );
	gfx.PutPixel( 92 + x,133 + y,208,34,34 );
	gfx.PutPixel( 93 + x,133 + y,208,34,34 );
	gfx.PutPixel( 94 + x,133 + y,208,34,34 );
	gfx.PutPixel( 95 + x,133 + y,208,34,34 );
	gfx.PutPixel( 96 + x,133 + y,208,34,34 );
	gfx.PutPixel( 97 + x,133 + y,208,34,34 );
	gfx.PutPixel( 98 + x,133 + y,208,34,34 );
	gfx.PutPixel( 99 + x,133 + y,208,34,34 );
	gfx.PutPixel( 100 + x,133 + y,208,34,34 );
	gfx.PutPixel( 101 + x,133 + y,208,34,34 );
	gfx.PutPixel( 102 + x,133 + y,208,34,34 );
	gfx.PutPixel( 103 + x,133 + y,208,34,34 );
	gfx.PutPixel( 104 + x,133 + y,208,34,34 );
	gfx.PutPixel( 105 + x,133 + y,208,34,34 );
	gfx.PutPixel( 106 + x,133 + y,208,34,34 );
	gfx.PutPixel( 107 + x,133 + y,208,34,34 );
	gfx.PutPixel( 108 + x,133 + y,208,34,34 );
	gfx.PutPixel( 109 + x,133 + y,208,34,34 );
	gfx.PutPixel( 110 + x,133 + y,208,34,34 );
	gfx.PutPixel( 111 + x,133 + y,208,34,34 );
	gfx.PutPixel( 112 + x,133 + y,208,34,34 );
	gfx.PutPixel( 113 + x,133 + y,208,34,34 );
	gfx.PutPixel( 114 + x,133 + y,208,34,34 );
	gfx.PutPixel( 115 + x,133 + y,208,34,34 );
	gfx.PutPixel( 116 + x,133 + y,208,34,34 );
	gfx.PutPixel( 117 + x,133 + y,208,34,34 );
	gfx.PutPixel( 118 + x,133 + y,208,34,34 );
	gfx.PutPixel( 119 + x,133 + y,208,34,34 );
	gfx.PutPixel( 120 + x,133 + y,208,34,34 );
	gfx.PutPixel( 121 + x,133 + y,208,34,34 );
	gfx.PutPixel( 122 + x,133 + y,208,34,34 );
	gfx.PutPixel( 123 + x,133 + y,208,34,34 );
	gfx.PutPixel( 124 + x,133 + y,208,34,34 );
	gfx.PutPixel( 125 + x,133 + y,208,34,34 );
	gfx.PutPixel( 126 + x,133 + y,208,34,34 );
	gfx.PutPixel( 127 + x,133 + y,208,34,34 );
	gfx.PutPixel( 128 + x,133 + y,208,34,34 );
	gfx.PutPixel( 129 + x,133 + y,208,34,34 );
	gfx.PutPixel( 130 + x,133 + y,208,34,34 );
	gfx.PutPixel( 131 + x,133 + y,208,34,34 );
	gfx.PutPixel( 132 + x,133 + y,208,34,34 );
	gfx.PutPixel( 133 + x,133 + y,208,34,34 );
	gfx.PutPixel( 134 + x,133 + y,208,34,34 );
	gfx.PutPixel( 135 + x,133 + y,208,34,34 );
	gfx.PutPixel( 136 + x,133 + y,208,34,34 );
	gfx.PutPixel( 137 + x,133 + y,208,34,34 );
	gfx.PutPixel( 138 + x,133 + y,208,34,34 );
	gfx.PutPixel( 139 + x,133 + y,208,34,34 );
	gfx.PutPixel( 140 + x,133 + y,208,34,34 );
	gfx.PutPixel( 141 + x,133 + y,208,34,34 );
	gfx.PutPixel( 142 + x,133 + y,208,34,34 );
	gfx.PutPixel( 143 + x,133 + y,208,34,34 );
	gfx.PutPixel( 144 + x,133 + y,208,34,34 );
	gfx.PutPixel( 145 + x,133 + y,208,34,34 );
	gfx.PutPixel( 146 + x,133 + y,208,34,34 );
	gfx.PutPixel( 147 + x,133 + y,208,34,34 );
	gfx.PutPixel( 148 + x,133 + y,208,34,34 );
	gfx.PutPixel( 149 + x,133 + y,208,34,34 );
	gfx.PutPixel( 0 + x,134 + y,208,34,34 );
	gfx.PutPixel( 1 + x,134 + y,208,34,34 );
	gfx.PutPixel( 2 + x,134 + y,208,34,34 );
	gfx.PutPixel( 3 + x,134 + y,208,34,34 );
	gfx.PutPixel( 4 + x,134 + y,208,34,34 );
	gfx.PutPixel( 5 + x,134 + y,208,34,34 );
	gfx.PutPixel( 6 + x,134 + y,208,34,34 );
	gfx.PutPixel( 7 + x,134 + y,208,34,34 );
	gfx.PutPixel( 8 + x,134 + y,208,34,34 );
	gfx.PutPixel( 9 + x,134 + y,208,34,34 );
	gfx.PutPixel( 10 + x,134 + y,208,34,34 );
	gfx.PutPixel( 11 + x,134 + y,208,34,34 );
	gfx.PutPixel( 12 + x,134 + y,208,34,34 );
	gfx.PutPixel( 13 + x,134 + y,208,34,34 );
	gfx.PutPixel( 14 + x,134 + y,208,34,34 );
	gfx.PutPixel( 15 + x,134 + y,208,34,34 );
	gfx.PutPixel( 16 + x,134 + y,208,34,34 );
	gfx.PutPixel( 17 + x,134 + y,208,34,34 );
	gfx.PutPixel( 18 + x,134 + y,208,34,34 );
	gfx.PutPixel( 19 + x,134 + y,208,34,34 );
	gfx.PutPixel( 20 + x,134 + y,208,34,34 );
	gfx.PutPixel( 21 + x,134 + y,208,34,34 );
	gfx.PutPixel( 22 + x,134 + y,208,34,34 );
	gfx.PutPixel( 23 + x,134 + y,208,34,34 );
	gfx.PutPixel( 24 + x,134 + y,208,34,34 );
	gfx.PutPixel( 25 + x,134 + y,208,34,34 );
	gfx.PutPixel( 26 + x,134 + y,208,34,34 );
	gfx.PutPixel( 27 + x,134 + y,208,34,34 );
	gfx.PutPixel( 28 + x,134 + y,208,34,34 );
	gfx.PutPixel( 29 + x,134 + y,208,34,34 );
	gfx.PutPixel( 30 + x,134 + y,208,34,34 );
	gfx.PutPixel( 31 + x,134 + y,208,34,34 );
	gfx.PutPixel( 32 + x,134 + y,208,34,34 );
	gfx.PutPixel( 33 + x,134 + y,208,34,34 );
	gfx.PutPixel( 34 + x,134 + y,208,34,34 );
	gfx.PutPixel( 35 + x,134 + y,208,34,34 );
	gfx.PutPixel( 36 + x,134 + y,208,34,34 );
	gfx.PutPixel( 37 + x,134 + y,208,34,34 );
	gfx.PutPixel( 38 + x,134 + y,208,34,34 );
	gfx.PutPixel( 39 + x,134 + y,208,34,34 );
	gfx.PutPixel( 40 + x,134 + y,208,34,34 );
	gfx.PutPixel( 41 + x,134 + y,208,34,34 );
	gfx.PutPixel( 42 + x,134 + y,208,34,34 );
	gfx.PutPixel( 43 + x,134 + y,208,34,34 );
	gfx.PutPixel( 44 + x,134 + y,208,34,34 );
	gfx.PutPixel( 45 + x,134 + y,208,34,34 );
	gfx.PutPixel( 46 + x,134 + y,208,34,34 );
	gfx.PutPixel( 47 + x,134 + y,208,34,34 );
	gfx.PutPixel( 48 + x,134 + y,208,34,34 );
	gfx.PutPixel( 49 + x,134 + y,208,34,34 );
	gfx.PutPixel( 50 + x,134 + y,208,34,34 );
	gfx.PutPixel( 51 + x,134 + y,208,34,34 );
	gfx.PutPixel( 52 + x,134 + y,208,34,34 );
	gfx.PutPixel( 53 + x,134 + y,208,34,34 );
	gfx.PutPixel( 54 + x,134 + y,208,34,34 );
	gfx.PutPixel( 55 + x,134 + y,208,34,34 );
	gfx.PutPixel( 56 + x,134 + y,208,34,34 );
	gfx.PutPixel( 57 + x,134 + y,208,34,34 );
	gfx.PutPixel( 58 + x,134 + y,208,34,34 );
	gfx.PutPixel( 59 + x,134 + y,208,34,34 );
	gfx.PutPixel( 60 + x,134 + y,208,34,34 );
	gfx.PutPixel( 61 + x,134 + y,208,34,34 );
	gfx.PutPixel( 62 + x,134 + y,208,34,34 );
	gfx.PutPixel( 63 + x,134 + y,208,34,34 );
	gfx.PutPixel( 64 + x,134 + y,208,34,34 );
	gfx.PutPixel( 65 + x,134 + y,208,34,34 );
	gfx.PutPixel( 66 + x,134 + y,208,34,34 );
	gfx.PutPixel( 67 + x,134 + y,208,34,34 );
	gfx.PutPixel( 68 + x,134 + y,208,34,34 );
	gfx.PutPixel( 69 + x,134 + y,208,34,34 );
	gfx.PutPixel( 70 + x,134 + y,208,34,34 );
	gfx.PutPixel( 71 + x,134 + y,208,34,34 );
	gfx.PutPixel( 72 + x,134 + y,208,34,34 );
	gfx.PutPixel( 73 + x,134 + y,208,34,34 );
	gfx.PutPixel( 74 + x,134 + y,208,34,34 );
	gfx.PutPixel( 75 + x,134 + y,208,34,34 );
	gfx.PutPixel( 76 + x,134 + y,208,34,34 );
	gfx.PutPixel( 77 + x,134 + y,208,34,34 );
	gfx.PutPixel( 78 + x,134 + y,208,34,34 );
	gfx.PutPixel( 79 + x,134 + y,208,34,34 );
	gfx.PutPixel( 80 + x,134 + y,208,34,34 );
	gfx.PutPixel( 81 + x,134 + y,208,34,34 );
	gfx.PutPixel( 82 + x,134 + y,208,34,34 );
	gfx.PutPixel( 83 + x,134 + y,208,34,34 );
	gfx.PutPixel( 84 + x,134 + y,208,34,34 );
	gfx.PutPixel( 85 + x,134 + y,208,34,34 );
	gfx.PutPixel( 86 + x,134 + y,208,34,34 );
	gfx.PutPixel( 87 + x,134 + y,208,34,34 );
	gfx.PutPixel( 88 + x,134 + y,208,34,34 );
	gfx.PutPixel( 89 + x,134 + y,208,34,34 );
	gfx.PutPixel( 90 + x,134 + y,208,34,34 );
	gfx.PutPixel( 91 + x,134 + y,208,34,34 );
	gfx.PutPixel( 92 + x,134 + y,208,34,34 );
	gfx.PutPixel( 93 + x,134 + y,208,34,34 );
	gfx.PutPixel( 94 + x,134 + y,208,34,34 );
	gfx.PutPixel( 95 + x,134 + y,208,34,34 );
	gfx.PutPixel( 96 + x,134 + y,208,34,34 );
	gfx.PutPixel( 97 + x,134 + y,208,34,34 );
	gfx.PutPixel( 98 + x,134 + y,208,34,34 );
	gfx.PutPixel( 99 + x,134 + y,208,34,34 );
	gfx.PutPixel( 100 + x,134 + y,208,34,34 );
	gfx.PutPixel( 101 + x,134 + y,208,34,34 );
	gfx.PutPixel( 102 + x,134 + y,208,34,34 );
	gfx.PutPixel( 103 + x,134 + y,208,34,34 );
	gfx.PutPixel( 104 + x,134 + y,208,34,34 );
	gfx.PutPixel( 105 + x,134 + y,208,34,34 );
	gfx.PutPixel( 106 + x,134 + y,208,34,34 );
	gfx.PutPixel( 107 + x,134 + y,208,34,34 );
	gfx.PutPixel( 108 + x,134 + y,208,34,34 );
	gfx.PutPixel( 109 + x,134 + y,208,34,34 );
	gfx.PutPixel( 110 + x,134 + y,208,34,34 );
	gfx.PutPixel( 111 + x,134 + y,208,34,34 );
	gfx.PutPixel( 112 + x,134 + y,208,34,34 );
	gfx.PutPixel( 113 + x,134 + y,208,34,34 );
	gfx.PutPixel( 114 + x,134 + y,208,34,34 );
	gfx.PutPixel( 115 + x,134 + y,208,34,34 );
	gfx.PutPixel( 116 + x,134 + y,208,34,34 );
	gfx.PutPixel( 117 + x,134 + y,208,34,34 );
	gfx.PutPixel( 118 + x,134 + y,208,34,34 );
	gfx.PutPixel( 119 + x,134 + y,208,34,34 );
	gfx.PutPixel( 120 + x,134 + y,208,34,34 );
	gfx.PutPixel( 121 + x,134 + y,208,34,34 );
	gfx.PutPixel( 122 + x,134 + y,208,34,34 );
	gfx.PutPixel( 123 + x,134 + y,208,34,34 );
	gfx.PutPixel( 124 + x,134 + y,208,34,34 );
	gfx.PutPixel( 125 + x,134 + y,208,34,34 );
	gfx.PutPixel( 126 + x,134 + y,208,34,34 );
	gfx.PutPixel( 127 + x,134 + y,208,34,34 );
	gfx.PutPixel( 128 + x,134 + y,208,34,34 );
	gfx.PutPixel( 129 + x,134 + y,208,34,34 );
	gfx.PutPixel( 130 + x,134 + y,208,34,34 );
	gfx.PutPixel( 131 + x,134 + y,208,34,34 );
	gfx.PutPixel( 132 + x,134 + y,208,34,34 );
	gfx.PutPixel( 133 + x,134 + y,208,34,34 );
	gfx.PutPixel( 134 + x,134 + y,208,34,34 );
	gfx.PutPixel( 135 + x,134 + y,208,34,34 );
	gfx.PutPixel( 136 + x,134 + y,208,34,34 );
	gfx.PutPixel( 137 + x,134 + y,208,34,34 );
	gfx.PutPixel( 138 + x,134 + y,208,34,34 );
	gfx.PutPixel( 139 + x,134 + y,208,34,34 );
	gfx.PutPixel( 140 + x,134 + y,208,34,34 );
	gfx.PutPixel( 141 + x,134 + y,208,34,34 );
	gfx.PutPixel( 142 + x,134 + y,208,34,34 );
	gfx.PutPixel( 143 + x,134 + y,208,34,34 );
	gfx.PutPixel( 144 + x,134 + y,208,34,34 );
	gfx.PutPixel( 145 + x,134 + y,208,34,34 );
	gfx.PutPixel( 146 + x,134 + y,208,34,34 );
	gfx.PutPixel( 147 + x,134 + y,208,34,34 );
	gfx.PutPixel( 148 + x,134 + y,208,34,34 );
	gfx.PutPixel( 149 + x,134 + y,208,34,34 );
	gfx.PutPixel( 0 + x,135 + y,208,34,34 );
	gfx.PutPixel( 1 + x,135 + y,208,34,34 );
	gfx.PutPixel( 2 + x,135 + y,208,34,34 );
	gfx.PutPixel( 3 + x,135 + y,208,34,34 );
	gfx.PutPixel( 4 + x,135 + y,208,34,34 );
	gfx.PutPixel( 5 + x,135 + y,208,34,34 );
	gfx.PutPixel( 6 + x,135 + y,208,34,34 );
	gfx.PutPixel( 7 + x,135 + y,208,34,34 );
	gfx.PutPixel( 8 + x,135 + y,208,34,34 );
	gfx.PutPixel( 9 + x,135 + y,208,34,34 );
	gfx.PutPixel( 10 + x,135 + y,208,34,34 );
	gfx.PutPixel( 11 + x,135 + y,208,34,34 );
	gfx.PutPixel( 12 + x,135 + y,208,34,34 );
	gfx.PutPixel( 13 + x,135 + y,208,34,34 );
	gfx.PutPixel( 14 + x,135 + y,208,34,34 );
	gfx.PutPixel( 15 + x,135 + y,208,34,34 );
	gfx.PutPixel( 16 + x,135 + y,208,34,34 );
	gfx.PutPixel( 17 + x,135 + y,208,34,34 );
	gfx.PutPixel( 18 + x,135 + y,208,34,34 );
	gfx.PutPixel( 19 + x,135 + y,208,34,34 );
	gfx.PutPixel( 20 + x,135 + y,208,34,34 );
	gfx.PutPixel( 21 + x,135 + y,208,34,34 );
	gfx.PutPixel( 22 + x,135 + y,208,34,34 );
	gfx.PutPixel( 23 + x,135 + y,208,34,34 );
	gfx.PutPixel( 24 + x,135 + y,208,34,34 );
	gfx.PutPixel( 25 + x,135 + y,208,34,34 );
	gfx.PutPixel( 26 + x,135 + y,208,34,34 );
	gfx.PutPixel( 27 + x,135 + y,208,34,34 );
	gfx.PutPixel( 28 + x,135 + y,208,34,34 );
	gfx.PutPixel( 29 + x,135 + y,208,34,34 );
	gfx.PutPixel( 30 + x,135 + y,208,34,34 );
	gfx.PutPixel( 31 + x,135 + y,208,34,34 );
	gfx.PutPixel( 32 + x,135 + y,208,34,34 );
	gfx.PutPixel( 33 + x,135 + y,208,34,34 );
	gfx.PutPixel( 34 + x,135 + y,208,34,34 );
	gfx.PutPixel( 35 + x,135 + y,208,34,34 );
	gfx.PutPixel( 36 + x,135 + y,208,34,34 );
	gfx.PutPixel( 37 + x,135 + y,208,34,34 );
	gfx.PutPixel( 38 + x,135 + y,208,34,34 );
	gfx.PutPixel( 39 + x,135 + y,208,34,34 );
	gfx.PutPixel( 40 + x,135 + y,208,34,34 );
	gfx.PutPixel( 41 + x,135 + y,208,34,34 );
	gfx.PutPixel( 42 + x,135 + y,208,34,34 );
	gfx.PutPixel( 43 + x,135 + y,208,34,34 );
	gfx.PutPixel( 44 + x,135 + y,208,34,34 );
	gfx.PutPixel( 45 + x,135 + y,208,34,34 );
	gfx.PutPixel( 46 + x,135 + y,208,34,34 );
	gfx.PutPixel( 47 + x,135 + y,208,34,34 );
	gfx.PutPixel( 48 + x,135 + y,208,34,34 );
	gfx.PutPixel( 49 + x,135 + y,208,34,34 );
	gfx.PutPixel( 50 + x,135 + y,208,34,34 );
	gfx.PutPixel( 51 + x,135 + y,208,34,34 );
	gfx.PutPixel( 52 + x,135 + y,208,34,34 );
	gfx.PutPixel( 53 + x,135 + y,208,34,34 );
	gfx.PutPixel( 54 + x,135 + y,208,34,34 );
	gfx.PutPixel( 55 + x,135 + y,208,34,34 );
	gfx.PutPixel( 56 + x,135 + y,208,34,34 );
	gfx.PutPixel( 57 + x,135 + y,208,34,34 );
	gfx.PutPixel( 58 + x,135 + y,208,34,34 );
	gfx.PutPixel( 59 + x,135 + y,208,34,34 );
	gfx.PutPixel( 60 + x,135 + y,208,34,34 );
	gfx.PutPixel( 61 + x,135 + y,208,34,34 );
	gfx.PutPixel( 62 + x,135 + y,208,34,34 );
	gfx.PutPixel( 63 + x,135 + y,208,34,34 );
	gfx.PutPixel( 64 + x,135 + y,208,34,34 );
	gfx.PutPixel( 65 + x,135 + y,208,34,34 );
	gfx.PutPixel( 66 + x,135 + y,208,34,34 );
	gfx.PutPixel( 67 + x,135 + y,208,34,34 );
	gfx.PutPixel( 68 + x,135 + y,208,34,34 );
	gfx.PutPixel( 69 + x,135 + y,208,34,34 );
	gfx.PutPixel( 70 + x,135 + y,208,34,34 );
	gfx.PutPixel( 71 + x,135 + y,208,34,34 );
	gfx.PutPixel( 72 + x,135 + y,208,34,34 );
	gfx.PutPixel( 73 + x,135 + y,208,34,34 );
	gfx.PutPixel( 74 + x,135 + y,208,34,34 );
	gfx.PutPixel( 75 + x,135 + y,208,34,34 );
	gfx.PutPixel( 76 + x,135 + y,208,34,34 );
	gfx.PutPixel( 77 + x,135 + y,208,34,34 );
	gfx.PutPixel( 78 + x,135 + y,208,34,34 );
	gfx.PutPixel( 79 + x,135 + y,208,34,34 );
	gfx.PutPixel( 80 + x,135 + y,208,34,34 );
	gfx.PutPixel( 81 + x,135 + y,208,34,34 );
	gfx.PutPixel( 82 + x,135 + y,208,34,34 );
	gfx.PutPixel( 83 + x,135 + y,208,34,34 );
	gfx.PutPixel( 84 + x,135 + y,208,34,34 );
	gfx.PutPixel( 85 + x,135 + y,208,34,34 );
	gfx.PutPixel( 86 + x,135 + y,208,34,34 );
	gfx.PutPixel( 87 + x,135 + y,208,34,34 );
	gfx.PutPixel( 88 + x,135 + y,208,34,34 );
	gfx.PutPixel( 89 + x,135 + y,208,34,34 );
	gfx.PutPixel( 90 + x,135 + y,208,34,34 );
	gfx.PutPixel( 91 + x,135 + y,208,34,34 );
	gfx.PutPixel( 92 + x,135 + y,208,34,34 );
	gfx.PutPixel( 93 + x,135 + y,208,34,34 );
	gfx.PutPixel( 94 + x,135 + y,208,34,34 );
	gfx.PutPixel( 95 + x,135 + y,208,34,34 );
	gfx.PutPixel( 96 + x,135 + y,208,34,34 );
	gfx.PutPixel( 97 + x,135 + y,208,34,34 );
	gfx.PutPixel( 98 + x,135 + y,208,34,34 );
	gfx.PutPixel( 99 + x,135 + y,208,34,34 );
	gfx.PutPixel( 100 + x,135 + y,208,34,34 );
	gfx.PutPixel( 101 + x,135 + y,208,34,34 );
	gfx.PutPixel( 102 + x,135 + y,208,34,34 );
	gfx.PutPixel( 103 + x,135 + y,208,34,34 );
	gfx.PutPixel( 104 + x,135 + y,208,34,34 );
	gfx.PutPixel( 105 + x,135 + y,208,34,34 );
	gfx.PutPixel( 106 + x,135 + y,208,34,34 );
	gfx.PutPixel( 107 + x,135 + y,208,34,34 );
	gfx.PutPixel( 108 + x,135 + y,208,34,34 );
	gfx.PutPixel( 109 + x,135 + y,208,34,34 );
	gfx.PutPixel( 110 + x,135 + y,208,34,34 );
	gfx.PutPixel( 111 + x,135 + y,208,34,34 );
	gfx.PutPixel( 112 + x,135 + y,208,34,34 );
	gfx.PutPixel( 113 + x,135 + y,208,34,34 );
	gfx.PutPixel( 114 + x,135 + y,208,34,34 );
	gfx.PutPixel( 115 + x,135 + y,208,34,34 );
	gfx.PutPixel( 116 + x,135 + y,208,34,34 );
	gfx.PutPixel( 117 + x,135 + y,208,34,34 );
	gfx.PutPixel( 118 + x,135 + y,208,34,34 );
	gfx.PutPixel( 119 + x,135 + y,208,34,34 );
	gfx.PutPixel( 120 + x,135 + y,208,34,34 );
	gfx.PutPixel( 121 + x,135 + y,208,34,34 );
	gfx.PutPixel( 122 + x,135 + y,208,34,34 );
	gfx.PutPixel( 123 + x,135 + y,208,34,34 );
	gfx.PutPixel( 124 + x,135 + y,208,34,34 );
	gfx.PutPixel( 125 + x,135 + y,208,34,34 );
	gfx.PutPixel( 126 + x,135 + y,208,34,34 );
	gfx.PutPixel( 127 + x,135 + y,208,34,34 );
	gfx.PutPixel( 128 + x,135 + y,208,34,34 );
	gfx.PutPixel( 129 + x,135 + y,208,34,34 );
	gfx.PutPixel( 130 + x,135 + y,208,34,34 );
	gfx.PutPixel( 131 + x,135 + y,208,34,34 );
	gfx.PutPixel( 132 + x,135 + y,208,34,34 );
	gfx.PutPixel( 133 + x,135 + y,208,34,34 );
	gfx.PutPixel( 134 + x,135 + y,208,34,34 );
	gfx.PutPixel( 135 + x,135 + y,208,34,34 );
	gfx.PutPixel( 136 + x,135 + y,208,34,34 );
	gfx.PutPixel( 137 + x,135 + y,208,34,34 );
	gfx.PutPixel( 138 + x,135 + y,208,34,34 );
	gfx.PutPixel( 139 + x,135 + y,208,34,34 );
	gfx.PutPixel( 140 + x,135 + y,208,34,34 );
	gfx.PutPixel( 141 + x,135 + y,208,34,34 );
	gfx.PutPixel( 142 + x,135 + y,208,34,34 );
	gfx.PutPixel( 143 + x,135 + y,208,34,34 );
	gfx.PutPixel( 144 + x,135 + y,208,34,34 );
	gfx.PutPixel( 145 + x,135 + y,208,34,34 );
	gfx.PutPixel( 146 + x,135 + y,208,34,34 );
	gfx.PutPixel( 147 + x,135 + y,208,34,34 );
	gfx.PutPixel( 148 + x,135 + y,208,34,34 );
	gfx.PutPixel( 149 + x,135 + y,208,34,34 );
	gfx.PutPixel( 0 + x,136 + y,208,34,34 );
	gfx.PutPixel( 1 + x,136 + y,208,34,34 );
	gfx.PutPixel( 2 + x,136 + y,208,34,34 );
	gfx.PutPixel( 3 + x,136 + y,208,34,34 );
	gfx.PutPixel( 4 + x,136 + y,208,34,34 );
	gfx.PutPixel( 5 + x,136 + y,208,34,34 );
	gfx.PutPixel( 6 + x,136 + y,208,34,34 );
	gfx.PutPixel( 7 + x,136 + y,208,34,34 );
	gfx.PutPixel( 8 + x,136 + y,208,34,34 );
	gfx.PutPixel( 9 + x,136 + y,208,34,34 );
	gfx.PutPixel( 10 + x,136 + y,208,34,34 );
	gfx.PutPixel( 11 + x,136 + y,208,34,34 );
	gfx.PutPixel( 12 + x,136 + y,208,34,34 );
	gfx.PutPixel( 13 + x,136 + y,208,34,34 );
	gfx.PutPixel( 14 + x,136 + y,208,34,34 );
	gfx.PutPixel( 15 + x,136 + y,208,34,34 );
	gfx.PutPixel( 16 + x,136 + y,208,34,34 );
	gfx.PutPixel( 17 + x,136 + y,208,34,34 );
	gfx.PutPixel( 18 + x,136 + y,208,34,34 );
	gfx.PutPixel( 19 + x,136 + y,208,34,34 );
	gfx.PutPixel( 20 + x,136 + y,208,34,34 );
	gfx.PutPixel( 21 + x,136 + y,208,34,34 );
	gfx.PutPixel( 22 + x,136 + y,208,34,34 );
	gfx.PutPixel( 23 + x,136 + y,208,34,34 );
	gfx.PutPixel( 24 + x,136 + y,208,34,34 );
	gfx.PutPixel( 25 + x,136 + y,208,34,34 );
	gfx.PutPixel( 26 + x,136 + y,208,34,34 );
	gfx.PutPixel( 27 + x,136 + y,208,34,34 );
	gfx.PutPixel( 28 + x,136 + y,208,34,34 );
	gfx.PutPixel( 29 + x,136 + y,208,34,34 );
	gfx.PutPixel( 30 + x,136 + y,208,34,34 );
	gfx.PutPixel( 31 + x,136 + y,208,34,34 );
	gfx.PutPixel( 32 + x,136 + y,208,34,34 );
	gfx.PutPixel( 33 + x,136 + y,208,34,34 );
	gfx.PutPixel( 34 + x,136 + y,208,34,34 );
	gfx.PutPixel( 35 + x,136 + y,208,34,34 );
	gfx.PutPixel( 36 + x,136 + y,208,34,34 );
	gfx.PutPixel( 37 + x,136 + y,208,34,34 );
	gfx.PutPixel( 38 + x,136 + y,208,34,34 );
	gfx.PutPixel( 39 + x,136 + y,208,34,34 );
	gfx.PutPixel( 40 + x,136 + y,208,34,34 );
	gfx.PutPixel( 41 + x,136 + y,208,34,34 );
	gfx.PutPixel( 42 + x,136 + y,208,34,34 );
	gfx.PutPixel( 43 + x,136 + y,208,34,34 );
	gfx.PutPixel( 44 + x,136 + y,208,34,34 );
	gfx.PutPixel( 45 + x,136 + y,208,34,34 );
	gfx.PutPixel( 46 + x,136 + y,208,34,34 );
	gfx.PutPixel( 47 + x,136 + y,208,34,34 );
	gfx.PutPixel( 48 + x,136 + y,208,34,34 );
	gfx.PutPixel( 49 + x,136 + y,208,34,34 );
	gfx.PutPixel( 50 + x,136 + y,208,34,34 );
	gfx.PutPixel( 51 + x,136 + y,208,34,34 );
	gfx.PutPixel( 52 + x,136 + y,208,34,34 );
	gfx.PutPixel( 53 + x,136 + y,208,34,34 );
	gfx.PutPixel( 54 + x,136 + y,208,34,34 );
	gfx.PutPixel( 55 + x,136 + y,208,34,34 );
	gfx.PutPixel( 56 + x,136 + y,208,34,34 );
	gfx.PutPixel( 57 + x,136 + y,208,34,34 );
	gfx.PutPixel( 58 + x,136 + y,208,34,34 );
	gfx.PutPixel( 59 + x,136 + y,208,34,34 );
	gfx.PutPixel( 60 + x,136 + y,208,34,34 );
	gfx.PutPixel( 61 + x,136 + y,208,34,34 );
	gfx.PutPixel( 62 + x,136 + y,208,34,34 );
	gfx.PutPixel( 63 + x,136 + y,208,34,34 );
	gfx.PutPixel( 64 + x,136 + y,208,34,34 );
	gfx.PutPixel( 65 + x,136 + y,208,34,34 );
	gfx.PutPixel( 66 + x,136 + y,208,34,34 );
	gfx.PutPixel( 67 + x,136 + y,208,34,34 );
	gfx.PutPixel( 68 + x,136 + y,208,34,34 );
	gfx.PutPixel( 69 + x,136 + y,208,34,34 );
	gfx.PutPixel( 70 + x,136 + y,208,34,34 );
	gfx.PutPixel( 71 + x,136 + y,208,34,34 );
	gfx.PutPixel( 72 + x,136 + y,208,34,34 );
	gfx.PutPixel( 73 + x,136 + y,208,34,34 );
	gfx.PutPixel( 74 + x,136 + y,208,34,34 );
	gfx.PutPixel( 75 + x,136 + y,208,34,34 );
	gfx.PutPixel( 76 + x,136 + y,208,34,34 );
	gfx.PutPixel( 77 + x,136 + y,208,34,34 );
	gfx.PutPixel( 78 + x,136 + y,208,34,34 );
	gfx.PutPixel( 79 + x,136 + y,208,34,34 );
	gfx.PutPixel( 80 + x,136 + y,208,34,34 );
	gfx.PutPixel( 81 + x,136 + y,208,34,34 );
	gfx.PutPixel( 82 + x,136 + y,208,34,34 );
	gfx.PutPixel( 83 + x,136 + y,208,34,34 );
	gfx.PutPixel( 84 + x,136 + y,208,34,34 );
	gfx.PutPixel( 85 + x,136 + y,208,34,34 );
	gfx.PutPixel( 86 + x,136 + y,208,34,34 );
	gfx.PutPixel( 87 + x,136 + y,208,34,34 );
	gfx.PutPixel( 88 + x,136 + y,208,34,34 );
	gfx.PutPixel( 89 + x,136 + y,208,34,34 );
	gfx.PutPixel( 90 + x,136 + y,208,34,34 );
	gfx.PutPixel( 91 + x,136 + y,208,34,34 );
	gfx.PutPixel( 92 + x,136 + y,208,34,34 );
	gfx.PutPixel( 93 + x,136 + y,208,34,34 );
	gfx.PutPixel( 94 + x,136 + y,208,34,34 );
	gfx.PutPixel( 95 + x,136 + y,208,34,34 );
	gfx.PutPixel( 96 + x,136 + y,208,34,34 );
	gfx.PutPixel( 97 + x,136 + y,208,34,34 );
	gfx.PutPixel( 98 + x,136 + y,208,34,34 );
	gfx.PutPixel( 99 + x,136 + y,208,34,34 );
	gfx.PutPixel( 100 + x,136 + y,208,34,34 );
	gfx.PutPixel( 101 + x,136 + y,208,34,34 );
	gfx.PutPixel( 102 + x,136 + y,208,34,34 );
	gfx.PutPixel( 103 + x,136 + y,208,34,34 );
	gfx.PutPixel( 104 + x,136 + y,208,34,34 );
	gfx.PutPixel( 105 + x,136 + y,208,34,34 );
	gfx.PutPixel( 106 + x,136 + y,208,34,34 );
	gfx.PutPixel( 107 + x,136 + y,208,34,34 );
	gfx.PutPixel( 108 + x,136 + y,208,34,34 );
	gfx.PutPixel( 109 + x,136 + y,208,34,34 );
	gfx.PutPixel( 110 + x,136 + y,208,34,34 );
	gfx.PutPixel( 111 + x,136 + y,208,34,34 );
	gfx.PutPixel( 112 + x,136 + y,208,34,34 );
	gfx.PutPixel( 113 + x,136 + y,208,34,34 );
	gfx.PutPixel( 114 + x,136 + y,208,34,34 );
	gfx.PutPixel( 115 + x,136 + y,208,34,34 );
	gfx.PutPixel( 116 + x,136 + y,208,34,34 );
	gfx.PutPixel( 117 + x,136 + y,208,34,34 );
	gfx.PutPixel( 118 + x,136 + y,208,34,34 );
	gfx.PutPixel( 119 + x,136 + y,208,34,34 );
	gfx.PutPixel( 120 + x,136 + y,208,34,34 );
	gfx.PutPixel( 121 + x,136 + y,208,34,34 );
	gfx.PutPixel( 122 + x,136 + y,208,34,34 );
	gfx.PutPixel( 123 + x,136 + y,208,34,34 );
	gfx.PutPixel( 124 + x,136 + y,208,34,34 );
	gfx.PutPixel( 125 + x,136 + y,208,34,34 );
	gfx.PutPixel( 126 + x,136 + y,208,34,34 );
	gfx.PutPixel( 127 + x,136 + y,208,34,34 );
	gfx.PutPixel( 128 + x,136 + y,208,34,34 );
	gfx.PutPixel( 129 + x,136 + y,208,34,34 );
	gfx.PutPixel( 130 + x,136 + y,208,34,34 );
	gfx.PutPixel( 131 + x,136 + y,208,34,34 );
	gfx.PutPixel( 132 + x,136 + y,208,34,34 );
	gfx.PutPixel( 133 + x,136 + y,208,34,34 );
	gfx.PutPixel( 134 + x,136 + y,208,34,34 );
	gfx.PutPixel( 135 + x,136 + y,208,34,34 );
	gfx.PutPixel( 136 + x,136 + y,208,34,34 );
	gfx.PutPixel( 137 + x,136 + y,208,34,34 );
	gfx.PutPixel( 138 + x,136 + y,208,34,34 );
	gfx.PutPixel( 139 + x,136 + y,208,34,34 );
	gfx.PutPixel( 140 + x,136 + y,208,34,34 );
	gfx.PutPixel( 141 + x,136 + y,208,34,34 );
	gfx.PutPixel( 142 + x,136 + y,208,34,34 );
	gfx.PutPixel( 143 + x,136 + y,208,34,34 );
	gfx.PutPixel( 144 + x,136 + y,208,34,34 );
	gfx.PutPixel( 145 + x,136 + y,208,34,34 );
	gfx.PutPixel( 146 + x,136 + y,208,34,34 );
	gfx.PutPixel( 147 + x,136 + y,208,34,34 );
	gfx.PutPixel( 148 + x,136 + y,208,34,34 );
	gfx.PutPixel( 149 + x,136 + y,208,34,34 );
	gfx.PutPixel( 0 + x,137 + y,208,34,34 );
	gfx.PutPixel( 1 + x,137 + y,208,34,34 );
	gfx.PutPixel( 2 + x,137 + y,208,34,34 );
	gfx.PutPixel( 3 + x,137 + y,208,34,34 );
	gfx.PutPixel( 4 + x,137 + y,208,34,34 );
	gfx.PutPixel( 5 + x,137 + y,208,34,34 );
	gfx.PutPixel( 6 + x,137 + y,208,34,34 );
	gfx.PutPixel( 7 + x,137 + y,208,34,34 );
	gfx.PutPixel( 8 + x,137 + y,208,34,34 );
	gfx.PutPixel( 9 + x,137 + y,208,34,34 );
	gfx.PutPixel( 10 + x,137 + y,208,34,34 );
	gfx.PutPixel( 11 + x,137 + y,208,34,34 );
	gfx.PutPixel( 12 + x,137 + y,208,34,34 );
	gfx.PutPixel( 13 + x,137 + y,208,34,34 );
	gfx.PutPixel( 14 + x,137 + y,208,34,34 );
	gfx.PutPixel( 15 + x,137 + y,208,34,34 );
	gfx.PutPixel( 16 + x,137 + y,208,34,34 );
	gfx.PutPixel( 17 + x,137 + y,208,34,34 );
	gfx.PutPixel( 18 + x,137 + y,208,34,34 );
	gfx.PutPixel( 19 + x,137 + y,208,34,34 );
	gfx.PutPixel( 20 + x,137 + y,208,34,34 );
	gfx.PutPixel( 21 + x,137 + y,208,34,34 );
	gfx.PutPixel( 22 + x,137 + y,208,34,34 );
	gfx.PutPixel( 23 + x,137 + y,208,34,34 );
	gfx.PutPixel( 24 + x,137 + y,208,34,34 );
	gfx.PutPixel( 25 + x,137 + y,208,34,34 );
	gfx.PutPixel( 26 + x,137 + y,208,34,34 );
	gfx.PutPixel( 27 + x,137 + y,208,34,34 );
	gfx.PutPixel( 28 + x,137 + y,208,34,34 );
	gfx.PutPixel( 29 + x,137 + y,208,34,34 );
	gfx.PutPixel( 30 + x,137 + y,208,34,34 );
	gfx.PutPixel( 31 + x,137 + y,208,34,34 );
	gfx.PutPixel( 32 + x,137 + y,208,34,34 );
	gfx.PutPixel( 33 + x,137 + y,208,34,34 );
	gfx.PutPixel( 34 + x,137 + y,208,34,34 );
	gfx.PutPixel( 35 + x,137 + y,208,34,34 );
	gfx.PutPixel( 36 + x,137 + y,208,34,34 );
	gfx.PutPixel( 37 + x,137 + y,208,34,34 );
	gfx.PutPixel( 38 + x,137 + y,208,34,34 );
	gfx.PutPixel( 39 + x,137 + y,208,34,34 );
	gfx.PutPixel( 40 + x,137 + y,208,34,34 );
	gfx.PutPixel( 41 + x,137 + y,208,34,34 );
	gfx.PutPixel( 42 + x,137 + y,208,34,34 );
	gfx.PutPixel( 43 + x,137 + y,208,34,34 );
	gfx.PutPixel( 44 + x,137 + y,208,34,34 );
	gfx.PutPixel( 45 + x,137 + y,208,34,34 );
	gfx.PutPixel( 46 + x,137 + y,208,34,34 );
	gfx.PutPixel( 47 + x,137 + y,208,34,34 );
	gfx.PutPixel( 48 + x,137 + y,208,34,34 );
	gfx.PutPixel( 49 + x,137 + y,208,34,34 );
	gfx.PutPixel( 50 + x,137 + y,208,34,34 );
	gfx.PutPixel( 51 + x,137 + y,208,34,34 );
	gfx.PutPixel( 52 + x,137 + y,208,34,34 );
	gfx.PutPixel( 53 + x,137 + y,208,34,34 );
	gfx.PutPixel( 54 + x,137 + y,208,34,34 );
	gfx.PutPixel( 55 + x,137 + y,208,34,34 );
	gfx.PutPixel( 56 + x,137 + y,208,34,34 );
	gfx.PutPixel( 57 + x,137 + y,208,34,34 );
	gfx.PutPixel( 58 + x,137 + y,208,34,34 );
	gfx.PutPixel( 59 + x,137 + y,208,34,34 );
	gfx.PutPixel( 60 + x,137 + y,208,34,34 );
	gfx.PutPixel( 61 + x,137 + y,208,34,34 );
	gfx.PutPixel( 62 + x,137 + y,208,34,34 );
	gfx.PutPixel( 63 + x,137 + y,208,34,34 );
	gfx.PutPixel( 64 + x,137 + y,208,34,34 );
	gfx.PutPixel( 65 + x,137 + y,208,34,34 );
	gfx.PutPixel( 66 + x,137 + y,208,34,34 );
	gfx.PutPixel( 67 + x,137 + y,208,34,34 );
	gfx.PutPixel( 68 + x,137 + y,208,34,34 );
	gfx.PutPixel( 69 + x,137 + y,208,34,34 );
	gfx.PutPixel( 70 + x,137 + y,208,34,34 );
	gfx.PutPixel( 71 + x,137 + y,208,34,34 );
	gfx.PutPixel( 72 + x,137 + y,208,34,34 );
	gfx.PutPixel( 73 + x,137 + y,208,34,34 );
	gfx.PutPixel( 74 + x,137 + y,208,34,34 );
	gfx.PutPixel( 75 + x,137 + y,208,34,34 );
	gfx.PutPixel( 76 + x,137 + y,208,34,34 );
	gfx.PutPixel( 77 + x,137 + y,208,34,34 );
	gfx.PutPixel( 78 + x,137 + y,208,34,34 );
	gfx.PutPixel( 79 + x,137 + y,208,34,34 );
	gfx.PutPixel( 80 + x,137 + y,208,34,34 );
	gfx.PutPixel( 81 + x,137 + y,208,34,34 );
	gfx.PutPixel( 82 + x,137 + y,208,34,34 );
	gfx.PutPixel( 83 + x,137 + y,208,34,34 );
	gfx.PutPixel( 84 + x,137 + y,208,34,34 );
	gfx.PutPixel( 85 + x,137 + y,208,34,34 );
	gfx.PutPixel( 86 + x,137 + y,208,34,34 );
	gfx.PutPixel( 87 + x,137 + y,208,34,34 );
	gfx.PutPixel( 88 + x,137 + y,208,34,34 );
	gfx.PutPixel( 89 + x,137 + y,208,34,34 );
	gfx.PutPixel( 90 + x,137 + y,208,34,34 );
	gfx.PutPixel( 91 + x,137 + y,208,34,34 );
	gfx.PutPixel( 92 + x,137 + y,208,34,34 );
	gfx.PutPixel( 93 + x,137 + y,208,34,34 );
	gfx.PutPixel( 94 + x,137 + y,208,34,34 );
	gfx.PutPixel( 95 + x,137 + y,208,34,34 );
	gfx.PutPixel( 96 + x,137 + y,208,34,34 );
	gfx.PutPixel( 97 + x,137 + y,208,34,34 );
	gfx.PutPixel( 98 + x,137 + y,208,34,34 );
	gfx.PutPixel( 99 + x,137 + y,208,34,34 );
	gfx.PutPixel( 100 + x,137 + y,208,34,34 );
	gfx.PutPixel( 101 + x,137 + y,208,34,34 );
	gfx.PutPixel( 102 + x,137 + y,208,34,34 );
	gfx.PutPixel( 103 + x,137 + y,208,34,34 );
	gfx.PutPixel( 104 + x,137 + y,208,34,34 );
	gfx.PutPixel( 105 + x,137 + y,208,34,34 );
	gfx.PutPixel( 106 + x,137 + y,208,34,34 );
	gfx.PutPixel( 107 + x,137 + y,208,34,34 );
	gfx.PutPixel( 108 + x,137 + y,208,34,34 );
	gfx.PutPixel( 109 + x,137 + y,208,34,34 );
	gfx.PutPixel( 110 + x,137 + y,208,34,34 );
	gfx.PutPixel( 111 + x,137 + y,208,34,34 );
	gfx.PutPixel( 112 + x,137 + y,208,34,34 );
	gfx.PutPixel( 113 + x,137 + y,208,34,34 );
	gfx.PutPixel( 114 + x,137 + y,208,34,34 );
	gfx.PutPixel( 115 + x,137 + y,208,34,34 );
	gfx.PutPixel( 116 + x,137 + y,208,34,34 );
	gfx.PutPixel( 117 + x,137 + y,208,34,34 );
	gfx.PutPixel( 118 + x,137 + y,208,34,34 );
	gfx.PutPixel( 119 + x,137 + y,208,34,34 );
	gfx.PutPixel( 120 + x,137 + y,208,34,34 );
	gfx.PutPixel( 121 + x,137 + y,208,34,34 );
	gfx.PutPixel( 122 + x,137 + y,208,34,34 );
	gfx.PutPixel( 123 + x,137 + y,208,34,34 );
	gfx.PutPixel( 124 + x,137 + y,208,34,34 );
	gfx.PutPixel( 125 + x,137 + y,208,34,34 );
	gfx.PutPixel( 126 + x,137 + y,208,34,34 );
	gfx.PutPixel( 127 + x,137 + y,208,34,34 );
	gfx.PutPixel( 128 + x,137 + y,208,34,34 );
	gfx.PutPixel( 129 + x,137 + y,208,34,34 );
	gfx.PutPixel( 130 + x,137 + y,208,34,34 );
	gfx.PutPixel( 131 + x,137 + y,208,34,34 );
	gfx.PutPixel( 132 + x,137 + y,208,34,34 );
	gfx.PutPixel( 133 + x,137 + y,208,34,34 );
	gfx.PutPixel( 134 + x,137 + y,208,34,34 );
	gfx.PutPixel( 135 + x,137 + y,208,34,34 );
	gfx.PutPixel( 136 + x,137 + y,208,34,34 );
	gfx.PutPixel( 137 + x,137 + y,208,34,34 );
	gfx.PutPixel( 138 + x,137 + y,208,34,34 );
	gfx.PutPixel( 139 + x,137 + y,208,34,34 );
	gfx.PutPixel( 140 + x,137 + y,208,34,34 );
	gfx.PutPixel( 141 + x,137 + y,208,34,34 );
	gfx.PutPixel( 142 + x,137 + y,208,34,34 );
	gfx.PutPixel( 143 + x,137 + y,208,34,34 );
	gfx.PutPixel( 144 + x,137 + y,208,34,34 );
	gfx.PutPixel( 145 + x,137 + y,208,34,34 );
	gfx.PutPixel( 146 + x,137 + y,208,34,34 );
	gfx.PutPixel( 147 + x,137 + y,208,34,34 );
	gfx.PutPixel( 148 + x,137 + y,208,34,34 );
	gfx.PutPixel( 149 + x,137 + y,208,34,34 );
	gfx.PutPixel( 0 + x,138 + y,208,34,34 );
	gfx.PutPixel( 1 + x,138 + y,208,34,34 );
	gfx.PutPixel( 2 + x,138 + y,208,34,34 );
	gfx.PutPixel( 3 + x,138 + y,208,34,34 );
	gfx.PutPixel( 4 + x,138 + y,208,34,34 );
	gfx.PutPixel( 5 + x,138 + y,208,34,34 );
	gfx.PutPixel( 6 + x,138 + y,208,34,34 );
	gfx.PutPixel( 7 + x,138 + y,208,34,34 );
	gfx.PutPixel( 8 + x,138 + y,208,34,34 );
	gfx.PutPixel( 9 + x,138 + y,208,34,34 );
	gfx.PutPixel( 10 + x,138 + y,208,34,34 );
	gfx.PutPixel( 11 + x,138 + y,208,34,34 );
	gfx.PutPixel( 12 + x,138 + y,208,34,34 );
	gfx.PutPixel( 13 + x,138 + y,208,34,34 );
	gfx.PutPixel( 14 + x,138 + y,208,34,34 );
	gfx.PutPixel( 15 + x,138 + y,208,34,34 );
	gfx.PutPixel( 16 + x,138 + y,208,34,34 );
	gfx.PutPixel( 17 + x,138 + y,208,34,34 );
	gfx.PutPixel( 18 + x,138 + y,208,31,31 );
	gfx.PutPixel( 19 + x,138 + y,208,30,30 );
	gfx.PutPixel( 20 + x,138 + y,208,30,30 );
	gfx.PutPixel( 21 + x,138 + y,208,30,30 );
	gfx.PutPixel( 22 + x,138 + y,208,30,30 );
	gfx.PutPixel( 23 + x,138 + y,208,30,30 );
	gfx.PutPixel( 24 + x,138 + y,208,31,31 );
	gfx.PutPixel( 25 + x,138 + y,208,31,31 );
	gfx.PutPixel( 26 + x,138 + y,208,33,33 );
	gfx.PutPixel( 27 + x,138 + y,208,34,34 );
	gfx.PutPixel( 28 + x,138 + y,208,34,34 );
	gfx.PutPixel( 29 + x,138 + y,208,34,34 );
	gfx.PutPixel( 30 + x,138 + y,208,34,34 );
	gfx.PutPixel( 31 + x,138 + y,208,34,34 );
	gfx.PutPixel( 32 + x,138 + y,208,34,34 );
	gfx.PutPixel( 33 + x,138 + y,208,34,34 );
	gfx.PutPixel( 34 + x,138 + y,208,34,34 );
	gfx.PutPixel( 35 + x,138 + y,208,34,34 );
	gfx.PutPixel( 36 + x,138 + y,208,34,34 );
	gfx.PutPixel( 37 + x,138 + y,208,33,33 );
	gfx.PutPixel( 38 + x,138 + y,208,29,29 );
	gfx.PutPixel( 39 + x,138 + y,207,24,24 );
	gfx.PutPixel( 40 + x,138 + y,207,23,23 );
	gfx.PutPixel( 41 + x,138 + y,207,22,22 );
	gfx.PutPixel( 42 + x,138 + y,207,23,23 );
	gfx.PutPixel( 43 + x,138 + y,207,24,24 );
	gfx.PutPixel( 44 + x,138 + y,208,29,29 );
	gfx.PutPixel( 45 + x,138 + y,208,33,33 );
	gfx.PutPixel( 46 + x,138 + y,208,34,34 );
	gfx.PutPixel( 47 + x,138 + y,208,34,34 );
	gfx.PutPixel( 48 + x,138 + y,208,34,34 );
	gfx.PutPixel( 49 + x,138 + y,208,34,34 );
	gfx.PutPixel( 50 + x,138 + y,208,34,34 );
	gfx.PutPixel( 51 + x,138 + y,208,34,34 );
	gfx.PutPixel( 52 + x,138 + y,208,34,34 );
	gfx.PutPixel( 53 + x,138 + y,208,34,34 );
	gfx.PutPixel( 54 + x,138 + y,208,34,34 );
	gfx.PutPixel( 55 + x,138 + y,208,34,34 );
	gfx.PutPixel( 56 + x,138 + y,208,34,34 );
	gfx.PutPixel( 57 + x,138 + y,208,33,33 );
	gfx.PutPixel( 58 + x,138 + y,208,29,29 );
	gfx.PutPixel( 59 + x,138 + y,207,24,24 );
	gfx.PutPixel( 60 + x,138 + y,207,23,23 );
	gfx.PutPixel( 61 + x,138 + y,207,22,22 );
	gfx.PutPixel( 62 + x,138 + y,207,23,23 );
	gfx.PutPixel( 63 + x,138 + y,207,24,24 );
	gfx.PutPixel( 64 + x,138 + y,208,29,29 );
	gfx.PutPixel( 65 + x,138 + y,208,33,33 );
	gfx.PutPixel( 66 + x,138 + y,208,34,34 );
	gfx.PutPixel( 67 + x,138 + y,208,34,34 );
	gfx.PutPixel( 68 + x,138 + y,208,34,34 );
	gfx.PutPixel( 69 + x,138 + y,208,34,34 );
	gfx.PutPixel( 70 + x,138 + y,208,34,34 );
	gfx.PutPixel( 71 + x,138 + y,208,34,34 );
	gfx.PutPixel( 72 + x,138 + y,208,34,34 );
	gfx.PutPixel( 73 + x,138 + y,208,34,34 );
	gfx.PutPixel( 74 + x,138 + y,208,34,34 );
	gfx.PutPixel( 75 + x,138 + y,208,34,34 );
	gfx.PutPixel( 76 + x,138 + y,208,34,34 );
	gfx.PutPixel( 77 + x,138 + y,208,34,34 );
	gfx.PutPixel( 78 + x,138 + y,208,34,34 );
	gfx.PutPixel( 79 + x,138 + y,208,34,34 );
	gfx.PutPixel( 80 + x,138 + y,208,31,31 );
	gfx.PutPixel( 81 + x,138 + y,208,30,30 );
	gfx.PutPixel( 82 + x,138 + y,208,30,30 );
	gfx.PutPixel( 83 + x,138 + y,208,30,30 );
	gfx.PutPixel( 84 + x,138 + y,208,30,30 );
	gfx.PutPixel( 85 + x,138 + y,208,30,30 );
	gfx.PutPixel( 86 + x,138 + y,208,31,31 );
	gfx.PutPixel( 87 + x,138 + y,208,31,31 );
	gfx.PutPixel( 88 + x,138 + y,208,33,33 );
	gfx.PutPixel( 89 + x,138 + y,208,34,34 );
	gfx.PutPixel( 90 + x,138 + y,208,34,34 );
	gfx.PutPixel( 91 + x,138 + y,208,34,34 );
	gfx.PutPixel( 92 + x,138 + y,208,34,34 );
	gfx.PutPixel( 93 + x,138 + y,208,34,34 );
	gfx.PutPixel( 94 + x,138 + y,208,34,34 );
	gfx.PutPixel( 95 + x,138 + y,208,34,34 );
	gfx.PutPixel( 96 + x,138 + y,208,34,34 );
	gfx.PutPixel( 97 + x,138 + y,208,34,34 );
	gfx.PutPixel( 98 + x,138 + y,208,34,34 );
	gfx.PutPixel( 99 + x,138 + y,208,33,33 );
	gfx.PutPixel( 100 + x,138 + y,208,29,29 );
	gfx.PutPixel( 101 + x,138 + y,207,24,24 );
	gfx.PutPixel( 102 + x,138 + y,207,23,23 );
	gfx.PutPixel( 103 + x,138 + y,207,22,22 );
	gfx.PutPixel( 104 + x,138 + y,207,23,23 );
	gfx.PutPixel( 105 + x,138 + y,207,24,24 );
	gfx.PutPixel( 106 + x,138 + y,208,29,29 );
	gfx.PutPixel( 107 + x,138 + y,208,33,33 );
	gfx.PutPixel( 108 + x,138 + y,208,34,34 );
	gfx.PutPixel( 109 + x,138 + y,208,34,34 );
	gfx.PutPixel( 110 + x,138 + y,208,34,34 );
	gfx.PutPixel( 111 + x,138 + y,208,34,34 );
	gfx.PutPixel( 112 + x,138 +